(ns
 com.palletops.awaze.cloudformation
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudformation :as cloudformation]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudformation
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.cloudformation.AmazonCloudFormationClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Parameter}
parameter
  [m4875]
  (clojure.core/let
   [bean4874
    (new com.amazonaws.services.cloudformation.model.Parameter)]
   (clojure.core/let
    [v4876
     (:parameter-key m4875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4876 :com.palletops.awaze.client-builder/undef)
     (. bean4874 setParameterKey (clojure.core/str v4876))))
   (clojure.core/let
    [v4876
     (:parameter-value
      m4875
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4876 :com.palletops.awaze.client-builder/undef)
     (. bean4874 setParameterValue (clojure.core/str v4876))))
   (clojure.core/let
    [v4876
     (:use-previous-value
      m4875
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4876 :com.palletops.awaze.client-builder/undef)
     (. bean4874 setUsePreviousValue (clojure.core/boolean v4876))))
   bean4874))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Tag}
tag
  [m4878]
  (clojure.core/let
   [bean4877 (new com.amazonaws.services.cloudformation.model.Tag)]
   (clojure.core/let
    [v4879 (:value m4878 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4879 :com.palletops.awaze.client-builder/undef)
     (. bean4877 setValue (clojure.core/str v4879))))
   (clojure.core/let
    [v4879 (:key m4878 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4879 :com.palletops.awaze.client-builder/undef)
     (. bean4877 setKey (clojure.core/str v4879))))
   bean4877))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ResourceSignalStatus}
resource-signal-status
  [m4881]
  (.
   com.amazonaws.services.cloudformation.model.ResourceSignalStatus
   fromValue
   (clojure.core/name m4881)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ContinueUpdateRollbackRequest}
continue-update-rollback-request
  [m4884]
  (clojure.core/let
   [bean4883
    (new
     com.amazonaws.services.cloudformation.model.ContinueUpdateRollbackRequest)]
   (clojure.core/let
    [v4885
     (:stack-name m4884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4885 :com.palletops.awaze.client-builder/undef)
     (. bean4883 setStackName (clojure.core/str v4885))))
   bean4883))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest}
describe-change-set-request
  [m4887]
  (clojure.core/let
   [bean4886
    (new
     com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest)]
   (clojure.core/let
    [v4888
     (:next-token m4887 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4888 :com.palletops.awaze.client-builder/undef)
     (. bean4886 setNextToken (clojure.core/str v4888))))
   (clojure.core/let
    [v4888
     (:stack-name m4887 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4888 :com.palletops.awaze.client-builder/undef)
     (. bean4886 setStackName (clojure.core/str v4888))))
   (clojure.core/let
    [v4888
     (:change-set-name
      m4887
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4888 :com.palletops.awaze.client-builder/undef)
     (. bean4886 setChangeSetName (clojure.core/str v4888))))
   bean4886))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.SetStackPolicyRequest}
set-stack-policy-request
  [m4890]
  (clojure.core/let
   [bean4889
    (new
     com.amazonaws.services.cloudformation.model.SetStackPolicyRequest)]
   (clojure.core/let
    [v4891
     (:stack-name m4890 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4891 :com.palletops.awaze.client-builder/undef)
     (. bean4889 setStackName (clojure.core/str v4891))))
   (clojure.core/let
    [v4891
     (:stack-policy-body
      m4890
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4891 :com.palletops.awaze.client-builder/undef)
     (. bean4889 setStackPolicyBody (clojure.core/str v4891))))
   (clojure.core/let
    [v4891
     (:stack-policy-url
      m4890
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4891 :com.palletops.awaze.client-builder/undef)
     (. bean4889 setStackPolicyURL (clojure.core/str v4891))))
   bean4889))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStacksRequest}
describe-stacks-request
  [m4893]
  (clojure.core/let
   [bean4892
    (new
     com.amazonaws.services.cloudformation.model.DescribeStacksRequest)]
   (clojure.core/let
    [v4894
     (:next-token m4893 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4894 :com.palletops.awaze.client-builder/undef)
     (. bean4892 setNextToken (clojure.core/str v4894))))
   (clojure.core/let
    [v4894
     (:stack-name m4893 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4894 :com.palletops.awaze.client-builder/undef)
     (. bean4892 setStackName (clojure.core/str v4894))))
   bean4892))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.UpdateStackRequest}
update-stack-request
  [m4896]
  (clojure.core/let
   [bean4895
    (new
     com.amazonaws.services.cloudformation.model.UpdateStackRequest)]
   (clojure.core/let
    [v4897
     (:use-previous-template
      m4896
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (. bean4895 setUsePreviousTemplate (clojure.core/boolean v4897))))
   (clojure.core/let
    [v4897
     (:stack-name m4896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (. bean4895 setStackName (clojure.core/str v4897))))
   (clojure.core/let
    [v4897
     (:notification-arns
      m4896
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (.
      bean4895
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4955] (clojure.core/str arg4955))
 v4897))))
   (clojure.core/let
    [v4897
     (:parameters m4896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (.
      bean4895
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4956] (cloudformation/parameter arg4956))
 v4897))))
   (clojure.core/let
    [v4897
     (:stack-policy-during-update-body
      m4896
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (.
      bean4895
      setStackPolicyDuringUpdateBody
      (clojure.core/str v4897))))
   (clojure.core/let
    [v4897
     (:template-url m4896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (. bean4895 setTemplateURL (clojure.core/str v4897))))
   (clojure.core/let
    [v4897
     (:stack-policy-url
      m4896
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (. bean4895 setStackPolicyURL (clojure.core/str v4897))))
   (clojure.core/let
    [v4897
     (:stack-policy-body
      m4896
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (. bean4895 setStackPolicyBody (clojure.core/str v4897))))
   (clojure.core/let
    [v4897 (:tags m4896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (.
      bean4895
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4957] (cloudformation/tag arg4957))
 v4897))))
   (clojure.core/let
    [v4897
     (:stack-policy-during-update-url
      m4896
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (.
      bean4895
      setStackPolicyDuringUpdateURL
      (clojure.core/str v4897))))
   (clojure.core/let
    [v4897
     (:template-body m4896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (. bean4895 setTemplateBody (clojure.core/str v4897))))
   (clojure.core/let
    [v4897
     (:resource-types m4896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (.
      bean4895
      setResourceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4958] (clojure.core/str arg4958))
 v4897))))
   (clojure.core/let
    [v4897
     (:capabilities m4896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (.
      bean4895
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4959] (clojure.core/str arg4959))
 v4897))))
   bean4895))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest}
estimate-template-cost-request
  [m4899]
  (clojure.core/let
   [bean4898
    (new
     com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest)]
   (clojure.core/let
    [v4900
     (:parameters m4899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4900 :com.palletops.awaze.client-builder/undef)
     (.
      bean4898
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4960] (cloudformation/parameter arg4960))
 v4900))))
   (clojure.core/let
    [v4900
     (:template-body m4899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4900 :com.palletops.awaze.client-builder/undef)
     (. bean4898 setTemplateBody (clojure.core/str v4900))))
   (clojure.core/let
    [v4900
     (:template-url m4899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4900 :com.palletops.awaze.client-builder/undef)
     (. bean4898 setTemplateURL (clojure.core/str v4900))))
   bean4898))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStacksRequest}
list-stacks-request
  [m4902]
  (clojure.core/let
   [bean4901
    (new
     com.amazonaws.services.cloudformation.model.ListStacksRequest)]
   (clojure.core/let
    [v4903
     (:next-token m4902 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4903 :com.palletops.awaze.client-builder/undef)
     (. bean4901 setNextToken (clojure.core/str v4903))))
   (clojure.core/let
    [v4903
     (:stack-status-filters
      m4902
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4903 :com.palletops.awaze.client-builder/undef)
     (.
      bean4901
      setStackStatusFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4961] (clojure.core/str arg4961))
 v4903))))
   bean4901))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest}
describe-stack-events-request
  [m4905]
  (clojure.core/let
   [bean4904
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest)]
   (clojure.core/let
    [v4906
     (:next-token m4905 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4906 :com.palletops.awaze.client-builder/undef)
     (. bean4904 setNextToken (clojure.core/str v4906))))
   (clojure.core/let
    [v4906
     (:stack-name m4905 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4906 :com.palletops.awaze.client-builder/undef)
     (. bean4904 setStackName (clojure.core/str v4906))))
   bean4904))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DeleteStackRequest}
delete-stack-request
  [m4908]
  (clojure.core/let
   [bean4907
    (new
     com.amazonaws.services.cloudformation.model.DeleteStackRequest)]
   (clojure.core/let
    [v4909
     (:stack-name m4908 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4909 :com.palletops.awaze.client-builder/undef)
     (. bean4907 setStackName (clojure.core/str v4909))))
   (clojure.core/let
    [v4909
     (:retain-resources
      m4908
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4909 :com.palletops.awaze.client-builder/undef)
     (.
      bean4907
      setRetainResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4962] (clojure.core/str arg4962))
 v4909))))
   bean4907))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ValidateTemplateRequest}
validate-template-request
  [m4911]
  (clojure.core/let
   [bean4910
    (new
     com.amazonaws.services.cloudformation.model.ValidateTemplateRequest)]
   (clojure.core/let
    [v4912
     (:template-body m4911 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4912 :com.palletops.awaze.client-builder/undef)
     (. bean4910 setTemplateBody (clojure.core/str v4912))))
   (clojure.core/let
    [v4912
     (:template-url m4911 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4912 :com.palletops.awaze.client-builder/undef)
     (. bean4910 setTemplateURL (clojure.core/str v4912))))
   bean4910))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest}
describe-stack-resources-request
  [m4914]
  (clojure.core/let
   [bean4913
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest)]
   (clojure.core/let
    [v4915
     (:stack-name m4914 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4915 :com.palletops.awaze.client-builder/undef)
     (. bean4913 setStackName (clojure.core/str v4915))))
   (clojure.core/let
    [v4915
     (:physical-resource-id
      m4914
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4915 :com.palletops.awaze.client-builder/undef)
     (. bean4913 setPhysicalResourceId (clojure.core/str v4915))))
   (clojure.core/let
    [v4915
     (:logical-resource-id
      m4914
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4915 :com.palletops.awaze.client-builder/undef)
     (. bean4913 setLogicalResourceId (clojure.core/str v4915))))
   bean4913))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeAccountLimitsRequest}
describe-account-limits-request
  [m4917]
  (clojure.core/let
   [bean4916
    (new
     com.amazonaws.services.cloudformation.model.DescribeAccountLimitsRequest)]
   (clojure.core/let
    [v4918
     (:next-token m4917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4918 :com.palletops.awaze.client-builder/undef)
     (. bean4916 setNextToken (clojure.core/str v4918))))
   bean4916))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.SignalResourceRequest}
signal-resource-request
  [m4920]
  (clojure.core/let
   [bean4919
    (new
     com.amazonaws.services.cloudformation.model.SignalResourceRequest)]
   (clojure.core/let
    [v4921 (:status m4920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4921 :com.palletops.awaze.client-builder/undef)
     (.
      bean4919
      setStatus
      (cloudformation/resource-signal-status v4921))))
   (clojure.core/let
    [v4921
     (:stack-name m4920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4921 :com.palletops.awaze.client-builder/undef)
     (. bean4919 setStackName (clojure.core/str v4921))))
   (clojure.core/let
    [v4921
     (:logical-resource-id
      m4920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4921 :com.palletops.awaze.client-builder/undef)
     (. bean4919 setLogicalResourceId (clojure.core/str v4921))))
   (clojure.core/let
    [v4921
     (:unique-id m4920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4921 :com.palletops.awaze.client-builder/undef)
     (. bean4919 setUniqueId (clojure.core/str v4921))))
   bean4919))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetTemplateRequest}
get-template-request
  [m4923]
  (clojure.core/let
   [bean4922
    (new
     com.amazonaws.services.cloudformation.model.GetTemplateRequest)]
   (clojure.core/let
    [v4924
     (:stack-name m4923 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4924 :com.palletops.awaze.client-builder/undef)
     (. bean4922 setStackName (clojure.core/str v4924))))
   bean4922))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetStackPolicyRequest}
get-stack-policy-request
  [m4926]
  (clojure.core/let
   [bean4925
    (new
     com.amazonaws.services.cloudformation.model.GetStackPolicyRequest)]
   (clojure.core/let
    [v4927
     (:stack-name m4926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4927 :com.palletops.awaze.client-builder/undef)
     (. bean4925 setStackName (clojure.core/str v4927))))
   bean4925))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CreateStackRequest}
create-stack-request
  [m4929]
  (clojure.core/let
   [bean4928
    (new
     com.amazonaws.services.cloudformation.model.CreateStackRequest)]
   (clojure.core/let
    [v4930
     (:stack-name m4929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (. bean4928 setStackName (clojure.core/str v4930))))
   (clojure.core/let
    [v4930
     (:notification-arns
      m4929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (.
      bean4928
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4987] (clojure.core/str arg4987))
 v4930))))
   (clojure.core/let
    [v4930
     (:parameters m4929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (.
      bean4928
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4988] (cloudformation/parameter arg4988))
 v4930))))
   (clojure.core/let
    [v4930
     (:timeout-in-minutes
      m4929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (. bean4928 setTimeoutInMinutes (clojure.core/int v4930))))
   (clojure.core/let
    [v4930
     (:disable-rollback
      m4929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (. bean4928 setDisableRollback (clojure.core/boolean v4930))))
   (clojure.core/let
    [v4930
     (:template-url m4929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (. bean4928 setTemplateURL (clojure.core/str v4930))))
   (clojure.core/let
    [v4930
     (:stack-policy-url
      m4929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (. bean4928 setStackPolicyURL (clojure.core/str v4930))))
   (clojure.core/let
    [v4930
     (:stack-policy-body
      m4929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (. bean4928 setStackPolicyBody (clojure.core/str v4930))))
   (clojure.core/let
    [v4930 (:tags m4929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (.
      bean4928
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4989] (cloudformation/tag arg4989))
 v4930))))
   (clojure.core/let
    [v4930
     (:template-body m4929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (. bean4928 setTemplateBody (clojure.core/str v4930))))
   (clojure.core/let
    [v4930
     (:resource-types m4929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (.
      bean4928
      setResourceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4990] (clojure.core/str arg4990))
 v4930))))
   (clojure.core/let
    [v4930
     (:capabilities m4929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (.
      bean4928
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4991] (clojure.core/str arg4991))
 v4930))))
   (clojure.core/let
    [v4930
     (:on-failure m4929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (. bean4928 setOnFailure (clojure.core/str v4930))))
   bean4928))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStackResourcesRequest}
list-stack-resources-request
  [m4932]
  (clojure.core/let
   [bean4931
    (new
     com.amazonaws.services.cloudformation.model.ListStackResourcesRequest)]
   (clojure.core/let
    [v4933
     (:next-token m4932 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4933 :com.palletops.awaze.client-builder/undef)
     (. bean4931 setNextToken (clojure.core/str v4933))))
   (clojure.core/let
    [v4933
     (:stack-name m4932 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4933 :com.palletops.awaze.client-builder/undef)
     (. bean4931 setStackName (clojure.core/str v4933))))
   bean4931))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest}
describe-stack-resource-request
  [m4935]
  (clojure.core/let
   [bean4934
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest)]
   (clojure.core/let
    [v4936
     (:stack-name m4935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4936 :com.palletops.awaze.client-builder/undef)
     (. bean4934 setStackName (clojure.core/str v4936))))
   (clojure.core/let
    [v4936
     (:logical-resource-id
      m4935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4936 :com.palletops.awaze.client-builder/undef)
     (. bean4934 setLogicalResourceId (clojure.core/str v4936))))
   bean4934))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListChangeSetsRequest}
list-change-sets-request
  [m4938]
  (clojure.core/let
   [bean4937
    (new
     com.amazonaws.services.cloudformation.model.ListChangeSetsRequest)]
   (clojure.core/let
    [v4939
     (:next-token m4938 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4939 :com.palletops.awaze.client-builder/undef)
     (. bean4937 setNextToken (clojure.core/str v4939))))
   (clojure.core/let
    [v4939
     (:stack-name m4938 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4939 :com.palletops.awaze.client-builder/undef)
     (. bean4937 setStackName (clojure.core/str v4939))))
   bean4937))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest}
cancel-update-stack-request
  [m4941]
  (clojure.core/let
   [bean4940
    (new
     com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest)]
   (clojure.core/let
    [v4942
     (:stack-name m4941 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4942 :com.palletops.awaze.client-builder/undef)
     (. bean4940 setStackName (clojure.core/str v4942))))
   bean4940))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CreateChangeSetRequest}
create-change-set-request
  [m4944]
  (clojure.core/let
   [bean4943
    (new
     com.amazonaws.services.cloudformation.model.CreateChangeSetRequest)]
   (clojure.core/let
    [v4945
     (:description m4944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4945 :com.palletops.awaze.client-builder/undef)
     (. bean4943 setDescription (clojure.core/str v4945))))
   (clojure.core/let
    [v4945
     (:use-previous-template
      m4944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4945 :com.palletops.awaze.client-builder/undef)
     (. bean4943 setUsePreviousTemplate (clojure.core/boolean v4945))))
   (clojure.core/let
    [v4945
     (:stack-name m4944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4945 :com.palletops.awaze.client-builder/undef)
     (. bean4943 setStackName (clojure.core/str v4945))))
   (clojure.core/let
    [v4945
     (:notification-arns
      m4944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4945 :com.palletops.awaze.client-builder/undef)
     (.
      bean4943
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4992] (clojure.core/str arg4992))
 v4945))))
   (clojure.core/let
    [v4945
     (:parameters m4944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4945 :com.palletops.awaze.client-builder/undef)
     (.
      bean4943
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4993] (cloudformation/parameter arg4993))
 v4945))))
   (clojure.core/let
    [v4945
     (:client-token m4944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4945 :com.palletops.awaze.client-builder/undef)
     (. bean4943 setClientToken (clojure.core/str v4945))))
   (clojure.core/let
    [v4945
     (:template-url m4944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4945 :com.palletops.awaze.client-builder/undef)
     (. bean4943 setTemplateURL (clojure.core/str v4945))))
   (clojure.core/let
    [v4945 (:tags m4944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4945 :com.palletops.awaze.client-builder/undef)
     (.
      bean4943
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4994] (cloudformation/tag arg4994))
 v4945))))
   (clojure.core/let
    [v4945
     (:change-set-name
      m4944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4945 :com.palletops.awaze.client-builder/undef)
     (. bean4943 setChangeSetName (clojure.core/str v4945))))
   (clojure.core/let
    [v4945
     (:template-body m4944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4945 :com.palletops.awaze.client-builder/undef)
     (. bean4943 setTemplateBody (clojure.core/str v4945))))
   (clojure.core/let
    [v4945
     (:resource-types m4944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4945 :com.palletops.awaze.client-builder/undef)
     (.
      bean4943
      setResourceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4995] (clojure.core/str arg4995))
 v4945))))
   (clojure.core/let
    [v4945
     (:capabilities m4944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4945 :com.palletops.awaze.client-builder/undef)
     (.
      bean4943
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4996] (clojure.core/str arg4996))
 v4945))))
   bean4943))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ExecuteChangeSetRequest}
execute-change-set-request
  [m4947]
  (clojure.core/let
   [bean4946
    (new
     com.amazonaws.services.cloudformation.model.ExecuteChangeSetRequest)]
   (clojure.core/let
    [v4948
     (:stack-name m4947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4948 :com.palletops.awaze.client-builder/undef)
     (. bean4946 setStackName (clojure.core/str v4948))))
   (clojure.core/let
    [v4948
     (:change-set-name
      m4947
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4948 :com.palletops.awaze.client-builder/undef)
     (. bean4946 setChangeSetName (clojure.core/str v4948))))
   bean4946))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DeleteChangeSetRequest}
delete-change-set-request
  [m4950]
  (clojure.core/let
   [bean4949
    (new
     com.amazonaws.services.cloudformation.model.DeleteChangeSetRequest)]
   (clojure.core/let
    [v4951
     (:stack-name m4950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (. bean4949 setStackName (clojure.core/str v4951))))
   (clojure.core/let
    [v4951
     (:change-set-name
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (. bean4949 setChangeSetName (clojure.core/str v4951))))
   bean4949))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetTemplateSummaryRequest}
get-template-summary-request
  [m4953]
  (clojure.core/let
   [bean4952
    (new
     com.amazonaws.services.cloudformation.model.GetTemplateSummaryRequest)]
   (clojure.core/let
    [v4954
     (:stack-name m4953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4954 :com.palletops.awaze.client-builder/undef)
     (. bean4952 setStackName (clojure.core/str v4954))))
   (clojure.core/let
    [v4954
     (:template-body m4953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4954 :com.palletops.awaze.client-builder/undef)
     (. bean4952 setTemplateBody (clojure.core/str v4954))))
   (clojure.core/let
    [v4954
     (:template-url m4953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4954 :com.palletops.awaze.client-builder/undef)
     (. bean4952 setTemplateURL (clojure.core/str v4954))))
   bean4952))
 (clojure.core/defmulti
  cloudformation
  (clojure.core/fn
   cloudformation
   [m__1816__auto__]
   (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   cloudformation
   :continue-update-rollback
   [m4963]
   (clojure.core/let
    [credentials4964 (:credentials m4963) args4965 (:args m4963)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client4966
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials4964)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client4966
       continueUpdateRollback
       (cloudformation/continue-update-rollback-request
        (clojure.core/nth args4965 0)))))))
  (clojure.core/defn
   continue-update-rollback-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for continueUpdateRollback"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :continue-update-rollback,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   continue-update-rollback
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call continueUpdateRollback"}
   [credentials4968 & args4969]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client4970
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials4968)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client4970
      continueUpdateRollback
      (cloudformation/continue-update-rollback-request
       (clojure.core/nth args4969 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-change-set
   [m4971]
   (clojure.core/let
    [credentials4972 (:credentials m4971) args4973 (:args m4971)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client4974
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials4972)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client4974
       describeChangeSet
       (cloudformation/describe-change-set-request
        (clojure.core/nth args4973 0)))))))
  (clojure.core/defn
   describe-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeChangeSet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-change-set,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-change-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeChangeSet"}
   [credentials4976 & args4977]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client4978
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials4976)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client4978
      describeChangeSet
      (cloudformation/describe-change-set-request
       (clojure.core/nth args4977 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :set-stack-policy
   [m4979]
   (clojure.core/let
    [credentials4980 (:credentials m4979) args4981 (:args m4979)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client4982
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials4980)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client4982
       setStackPolicy
       (cloudformation/set-stack-policy-request
        (clojure.core/nth args4981 0)))))))
  (clojure.core/defn
   set-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         stack-policy-url]}]]),
    :doc "Generate map for setStackPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-stack-policy,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   set-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         stack-policy-url]}]]),
    :doc "Call setStackPolicy"}
   [credentials4984 & args4985]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client4986
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials4984)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client4986
      setStackPolicy
      (cloudformation/set-stack-policy-request
       (clojure.core/nth args4985 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stacks
   [m4997]
   (clojure.core/let
    [credentials4998 (:credentials m4997) args4999 (:args m4997)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5000
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials4998)]
     (clojure.core/case
      (clojure.core/count args4999)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5000
        describeStacks
        (cloudformation/describe-stacks-request
         (clojure.core/nth args4999 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5000
        describeStacks))))))
  (clojure.core/defn
   describe-stacks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeStacks, describeStacks"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-stacks,
     :credentials credentials__1784__auto__,
     :client :cloudformation})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-stacks,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stacks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeStacks, describeStacks"}
   [credentials5002 & args5003]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5004
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5002)]
    (clojure.core/case
     (clojure.core/count args5003)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5004
       describeStacks
       (cloudformation/describe-stacks-request
        (clojure.core/nth args5003 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5004
       describeStacks))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :update-stack
   [m5005]
   (clojure.core/let
    [credentials5006 (:credentials m5005) args5007 (:args m5005)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5008
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5006)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5008
       updateStack
       (cloudformation/update-stack-request
        (clojure.core/nth args5007 0)))))))
  (clojure.core/defn
   update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         stack-policy-during-update-body
                         clone-root
                         stack-policy-url
                         stack-policy-during-update-url]}]]),
    :doc "Generate map for updateStack"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-stack,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   update-stack
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         stack-policy-during-update-body
                         clone-root
                         stack-policy-url
                         stack-policy-during-update-url]}]]),
    :doc "Call updateStack"}
   [credentials5010 & args5011]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5012
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5010)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5012
      updateStack
      (cloudformation/update-stack-request
       (clojure.core/nth args5011 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :estimate-template-cost
   [m5013]
   (clojure.core/let
    [credentials5014 (:credentials m5013) args5015 (:args m5013)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5016
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5014)]
     (clojure.core/case
      (clojure.core/count args5015)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5016
        estimateTemplateCost))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5016
        estimateTemplateCost
        (cloudformation/estimate-template-cost-request
         (clojure.core/nth args5015 0))))))))
  (clojure.core/defn
   estimate-template-cost-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root]}]]),
    :doc "Generate map for estimateTemplateCost, estimateTemplateCost"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :estimate-template-cost,
     :credentials credentials__1784__auto__,
     :client :cloudformation})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :estimate-template-cost,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   estimate-template-cost
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root]}]]),
    :doc "Call estimateTemplateCost, estimateTemplateCost"}
   [credentials5018 & args5019]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5020
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5018)]
    (clojure.core/case
     (clojure.core/count args5019)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5020
       estimateTemplateCost))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5020
       estimateTemplateCost
       (cloudformation/estimate-template-cost-request
        (clojure.core/nth args5019 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stacks
   [m5021]
   (clojure.core/let
    [credentials5022 (:credentials m5021) args5023 (:args m5021)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5024
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5022)]
     (clojure.core/case
      (clojure.core/count args5023)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5024
        listStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5024
        listStacks
        (cloudformation/list-stacks-request
         (clojure.core/nth args5023 0))))))))
  (clojure.core/defn
   list-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         stack-status-filters
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listStacks, listStacks"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :list-stacks,
     :credentials credentials__1784__auto__,
     :client :cloudformation})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-stacks,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   list-stacks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         stack-status-filters
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listStacks, listStacks"}
   [credentials5026 & args5027]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5028
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5026)]
    (clojure.core/case
     (clojure.core/count args5027)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5028
       listStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5028
       listStacks
       (cloudformation/list-stacks-request
        (clojure.core/nth args5027 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-events
   [m5029]
   (clojure.core/let
    [credentials5030 (:credentials m5029) args5031 (:args m5029)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5032
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5030)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5032
       describeStackEvents
       (cloudformation/describe-stack-events-request
        (clojure.core/nth args5031 0)))))))
  (clojure.core/defn
   describe-stack-events-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeStackEvents"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-stack-events,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stack-events
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeStackEvents"}
   [credentials5034 & args5035]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5036
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5034)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5036
      describeStackEvents
      (cloudformation/describe-stack-events-request
       (clojure.core/nth args5035 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :delete-stack
   [m5037]
   (clojure.core/let
    [credentials5038 (:credentials m5037) args5039 (:args m5037)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5040
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5038)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5040
       deleteStack
       (cloudformation/delete-stack-request
        (clojure.core/nth args5039 0)))))))
  (clojure.core/defn
   delete-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         retain-resources
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteStack"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-stack,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   delete-stack
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         retain-resources
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteStack"}
   [credentials5042 & args5043]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5044
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5042)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5044
      deleteStack
      (cloudformation/delete-stack-request
       (clojure.core/nth args5043 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :validate-template
   [m5045]
   (clojure.core/let
    [credentials5046 (:credentials m5045) args5047 (:args m5045)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5048
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5046)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5048
       validateTemplate
       (cloudformation/validate-template-request
        (clojure.core/nth args5047 0)))))))
  (clojure.core/defn
   validate-template-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]]),
    :doc "Generate map for validateTemplate"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :validate-template,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   validate-template
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]]),
    :doc "Call validateTemplate"}
   [credentials5050 & args5051]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5052
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5050)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5052
      validateTemplate
      (cloudformation/validate-template-request
       (clojure.core/nth args5051 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resources
   [m5053]
   (clojure.core/let
    [credentials5054 (:credentials m5053) args5055 (:args m5053)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5056
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5054)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5056
       describeStackResources
       (cloudformation/describe-stack-resources-request
        (clojure.core/nth args5055 0)))))))
  (clojure.core/defn
   describe-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         physical-resource-id
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStackResources"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-stack-resources,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         physical-resource-id
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStackResources"}
   [credentials5058 & args5059]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5060
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5058)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5060
      describeStackResources
      (cloudformation/describe-stack-resources-request
       (clojure.core/nth args5059 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-account-limits
   [m5061]
   (clojure.core/let
    [credentials5062 (:credentials m5061) args5063 (:args m5061)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5064
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5062)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5064
       describeAccountLimits
       (cloudformation/describe-account-limits-request
        (clojure.core/nth args5063 0)))))))
  (clojure.core/defn
   describe-account-limits-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeAccountLimits"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-account-limits,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-account-limits
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeAccountLimits"}
   [credentials5066 & args5067]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5068
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5066)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5068
      describeAccountLimits
      (cloudformation/describe-account-limits-request
       (clojure.core/nth args5067 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :signal-resource
   [m5069]
   (clojure.core/let
    [credentials5070 (:credentials m5069) args5071 (:args m5069)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5072
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5070)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5072
       signalResource
       (cloudformation/signal-resource-request
        (clojure.core/nth args5071 0)))))))
  (clojure.core/defn
   signal-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         unique-id
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for signalResource"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :signal-resource,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   signal-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         unique-id
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Call signalResource"}
   [credentials5074 & args5075]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5076
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5074)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5076
      signalResource
      (cloudformation/signal-resource-request
       (clojure.core/nth args5075 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-template
   [m5077]
   (clojure.core/let
    [credentials5078 (:credentials m5077) args5079 (:args m5077)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5080
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5078)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5080
       getTemplate
       (cloudformation/get-template-request
        (clojure.core/nth args5079 0)))))))
  (clojure.core/defn
   get-template-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTemplate"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-template,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   get-template
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTemplate"}
   [credentials5082 & args5083]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5084
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5082)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5084
      getTemplate
      (cloudformation/get-template-request
       (clojure.core/nth args5083 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-stack-policy
   [m5085]
   (clojure.core/let
    [credentials5086 (:credentials m5085) args5087 (:args m5085)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5088
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5086)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5088
       getStackPolicy
       (cloudformation/get-stack-policy-request
        (clojure.core/nth args5087 0)))))))
  (clojure.core/defn
   get-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getStackPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-stack-policy,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   get-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getStackPolicy"}
   [credentials5090 & args5091]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5092
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5090)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5092
      getStackPolicy
      (cloudformation/get-stack-policy-request
       (clojure.core/nth args5091 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :create-stack
   [m5093]
   (clojure.core/let
    [credentials5094 (:credentials m5093) args5095 (:args m5093)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5096
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5094)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5096
       createStack
       (cloudformation/create-stack-request
        (clojure.core/nth args5095 0)))))))
  (clojure.core/defn
   create-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         tags
                         disable-rollback
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         timeout-in-minutes
                         read-limit
                         on-failure
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root
                         stack-policy-url]}]]),
    :doc "Generate map for createStack"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-stack,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   create-stack
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         tags
                         disable-rollback
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         timeout-in-minutes
                         read-limit
                         on-failure
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root
                         stack-policy-url]}]]),
    :doc "Call createStack"}
   [credentials5098 & args5099]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5100
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5098)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5100
      createStack
      (cloudformation/create-stack-request
       (clojure.core/nth args5099 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stack-resources
   [m5101]
   (clojure.core/let
    [credentials5102 (:credentials m5101) args5103 (:args m5101)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5104
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5102)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5104
       listStackResources
       (cloudformation/list-stack-resources-request
        (clojure.core/nth args5103 0)))))))
  (clojure.core/defn
   list-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listStackResources"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-stack-resources,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   list-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listStackResources"}
   [credentials5106 & args5107]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5108
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5106)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5108
      listStackResources
      (cloudformation/list-stack-resources-request
       (clojure.core/nth args5107 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resource
   [m5109]
   (clojure.core/let
    [credentials5110 (:credentials m5109) args5111 (:args m5109)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5112
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5110)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5112
       describeStackResource
       (cloudformation/describe-stack-resource-request
        (clojure.core/nth args5111 0)))))))
  (clojure.core/defn
   describe-stack-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStackResource"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-stack-resource,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stack-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStackResource"}
   [credentials5114 & args5115]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5116
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5114)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5116
      describeStackResource
      (cloudformation/describe-stack-resource-request
       (clojure.core/nth args5115 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-change-sets
   [m5117]
   (clojure.core/let
    [credentials5118 (:credentials m5117) args5119 (:args m5117)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5120
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5118)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5120
       listChangeSets
       (cloudformation/list-change-sets-request
        (clojure.core/nth args5119 0)))))))
  (clojure.core/defn
   list-change-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listChangeSets"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :list-change-sets,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   list-change-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listChangeSets"}
   [credentials5122 & args5123]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5124
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5122)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5124
      listChangeSets
      (cloudformation/list-change-sets-request
       (clojure.core/nth args5123 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :cancel-update-stack
   [m5125]
   (clojure.core/let
    [credentials5126 (:credentials m5125) args5127 (:args m5125)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5128
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5126)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5128
       cancelUpdateStack
       (cloudformation/cancel-update-stack-request
        (clojure.core/nth args5127 0)))))))
  (clojure.core/defn
   cancel-update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelUpdateStack"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :cancel-update-stack,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   cancel-update-stack
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelUpdateStack"}
   [credentials5130 & args5131]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5132
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5130)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5132
      cancelUpdateStack
      (cloudformation/cancel-update-stack-request
       (clojure.core/nth args5131 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :create-change-set
   [m5133]
   (clojure.core/let
    [credentials5134 (:credentials m5133) args5135 (:args m5133)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5136
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5134)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5136
       createChangeSet
       (cloudformation/create-change-set-request
        (clojure.core/nth args5135 0)))))))
  (clojure.core/defn
   create-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         resource-types
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         template-url
                         client-token
                         parameters
                         clone-root]}]]),
    :doc "Generate map for createChangeSet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-change-set,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   create-change-set
   {:arglists (quote
               [[credentials
                 {:keys [description
                         capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         resource-types
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         template-url
                         client-token
                         parameters
                         clone-root]}]]),
    :doc "Call createChangeSet"}
   [credentials5138 & args5139]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5140
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5138)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5140
      createChangeSet
      (cloudformation/create-change-set-request
       (clojure.core/nth args5139 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :execute-change-set
   [m5141]
   (clojure.core/let
    [credentials5142 (:credentials m5141) args5143 (:args m5141)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5144
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5142)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5144
       executeChangeSet
       (cloudformation/execute-change-set-request
        (clojure.core/nth args5143 0)))))))
  (clojure.core/defn
   execute-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for executeChangeSet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :execute-change-set,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   execute-change-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call executeChangeSet"}
   [credentials5146 & args5147]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5148
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5146)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5148
      executeChangeSet
      (cloudformation/execute-change-set-request
       (clojure.core/nth args5147 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :delete-change-set
   [m5149]
   (clojure.core/let
    [credentials5150 (:credentials m5149) args5151 (:args m5149)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5152
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5150)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5152
       deleteChangeSet
       (cloudformation/delete-change-set-request
        (clojure.core/nth args5151 0)))))))
  (clojure.core/defn
   delete-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteChangeSet"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-change-set,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   delete-change-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteChangeSet"}
   [credentials5154 & args5155]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5156
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5154)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5156
      deleteChangeSet
      (cloudformation/delete-change-set-request
       (clojure.core/nth args5155 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-template-summary
   [m5157]
   (clojure.core/let
    [credentials5158 (:credentials m5157) args5159 (:args m5157)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5160
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5158)]
     (clojure.core/case
      (clojure.core/count args5159)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5160
        getTemplateSummary))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5160
        getTemplateSummary
        (cloudformation/get-template-summary-request
         (clojure.core/nth args5159 0))))))))
  (clojure.core/defn
   get-template-summary-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]]),
    :doc "Generate map for getTemplateSummary, getTemplateSummary"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :get-template-summary,
     :credentials credentials__1784__auto__,
     :client :cloudformation})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :get-template-summary,
     :credentials credentials__1784__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   get-template-summary
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]]),
    :doc "Call getTemplateSummary, getTemplateSummary"}
   [credentials5162 & args5163]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5164
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5162)]
    (clojure.core/case
     (clojure.core/count args5163)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5164
       getTemplateSummary))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5164
       getTemplateSummary
       (cloudformation/get-template-summary-request
        (clojure.core/nth args5163 0)))))))))
