(ns
 com.palletops.awaze.beans.identitymanagement
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.beans.identitymanagement
   :as
   identitymanagement]))


(do
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ContextKeyTypeEnum}
context-key-type-enum
  [m14713]
  (.
   com.amazonaws.services.identitymanagement.model.ContextKeyTypeEnum
   fromValue
   (clojure.core/name m14713)))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.StatusType}
status-type
  [m14716]
  (.
   com.amazonaws.services.identitymanagement.model.StatusType
   fromValue
   (clojure.core/name m14716)))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ContextEntry}
context-entry
  [m14719]
  (clojure.core/let
   [bean14718
    (new com.amazonaws.services.identitymanagement.model.ContextEntry)]
   (clojure.core/let
    [v14720
     (:context-key-name
      m14719
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14720 :com.palletops.awaze.client-builder/undef)
     (. bean14718 setContextKeyName (clojure.core/str v14720))))
   (clojure.core/let
    [v14720
     (:context-key-values
      m14719
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14720 :com.palletops.awaze.client-builder/undef)
     (.
      bean14718
      setContextKeyValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg15066] (clojure.core/str arg15066))
 v14720))))
   (clojure.core/let
    [v14720
     (:context-key-type
      m14719
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14720 :com.palletops.awaze.client-builder/undef)
     (.
      bean14718
      setContextKeyType
      (identitymanagement/context-key-type-enum v14720))))
   bean14718))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.EntityType}
entity-type
  [m14722]
  (.
   com.amazonaws.services.identitymanagement.model.EntityType
   fromValue
   (clojure.core/name m14722)))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.PolicyScopeType}
policy-scope-type
  [m14725]
  (.
   com.amazonaws.services.identitymanagement.model.PolicyScopeType
   fromValue
   (clojure.core/name m14725)))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListGroupsForUserRequest}
list-groups-for-user-request
  [m14728]
  (clojure.core/let
   [bean14727
    (new
     com.amazonaws.services.identitymanagement.model.ListGroupsForUserRequest)]
   (clojure.core/let
    [v14729
     (:max-items m14728 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14729 :com.palletops.awaze.client-builder/undef)
     (. bean14727 setMaxItems (clojure.core/int v14729))))
   (clojure.core/let
    [v14729
     (:marker m14728 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14729 :com.palletops.awaze.client-builder/undef)
     (. bean14727 setMarker (clojure.core/str v14729))))
   (clojure.core/let
    [v14729
     (:user-name m14728 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14729 :com.palletops.awaze.client-builder/undef)
     (. bean14727 setUserName (clojure.core/str v14729))))
   bean14727))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateUserRequest}
create-user-request
  [m14731]
  (clojure.core/let
   [bean14730
    (new
     com.amazonaws.services.identitymanagement.model.CreateUserRequest)]
   (clojure.core/let
    [v14732 (:path m14731 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14732 :com.palletops.awaze.client-builder/undef)
     (. bean14730 setPath (clojure.core/str v14732))))
   (clojure.core/let
    [v14732
     (:user-name m14731 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14732 :com.palletops.awaze.client-builder/undef)
     (. bean14730 setUserName (clojure.core/str v14732))))
   bean14730))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetCredentialReportRequest}
get-credential-report-request
  [m14734]
  (clojure.core/let
   [bean14733
    (new
     com.amazonaws.services.identitymanagement.model.GetCredentialReportRequest)]
   bean14733))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetOpenIDConnectProviderRequest}
get-open-idconnect-provider-request
  [m14737]
  (clojure.core/let
   [bean14736
    (new
     com.amazonaws.services.identitymanagement.model.GetOpenIDConnectProviderRequest)]
   (clojure.core/let
    [v14738
     (:open-idconnect-provider-arn
      m14737
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14738 :com.palletops.awaze.client-builder/undef)
     (.
      bean14736
      setOpenIDConnectProviderArn
      (clojure.core/str v14738))))
   bean14736))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteSigningCertificateRequest}
delete-signing-certificate-request
  [m14740]
  (clojure.core/let
   [bean14739
    (new
     com.amazonaws.services.identitymanagement.model.DeleteSigningCertificateRequest)]
   (clojure.core/let
    [v14741
     (:certificate-id
      m14740
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14741 :com.palletops.awaze.client-builder/undef)
     (. bean14739 setCertificateId (clojure.core/str v14741))))
   (clojure.core/let
    [v14741
     (:user-name m14740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14741 :com.palletops.awaze.client-builder/undef)
     (. bean14739 setUserName (clojure.core/str v14741))))
   bean14739))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ChangePasswordRequest}
change-password-request
  [m14743]
  (clojure.core/let
   [bean14742
    (new
     com.amazonaws.services.identitymanagement.model.ChangePasswordRequest)]
   (clojure.core/let
    [v14744
     (:old-password m14743 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14744 :com.palletops.awaze.client-builder/undef)
     (. bean14742 setOldPassword (clojure.core/str v14744))))
   (clojure.core/let
    [v14744
     (:new-password m14743 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14744 :com.palletops.awaze.client-builder/undef)
     (. bean14742 setNewPassword (clojure.core/str v14744))))
   bean14742))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleRequest}
list-instance-profiles-for-role-request
  [m14746]
  (clojure.core/let
   [bean14745
    (new
     com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleRequest)]
   (clojure.core/let
    [v14747
     (:max-items m14746 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14747 :com.palletops.awaze.client-builder/undef)
     (. bean14745 setMaxItems (clojure.core/int v14747))))
   (clojure.core/let
    [v14747
     (:role-name m14746 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14747 :com.palletops.awaze.client-builder/undef)
     (. bean14745 setRoleName (clojure.core/str v14747))))
   (clojure.core/let
    [v14747
     (:marker m14746 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14747 :com.palletops.awaze.client-builder/undef)
     (. bean14745 setMarker (clojure.core/str v14747))))
   bean14745))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListInstanceProfilesRequest}
list-instance-profiles-request
  [m14749]
  (clojure.core/let
   [bean14748
    (new
     com.amazonaws.services.identitymanagement.model.ListInstanceProfilesRequest)]
   (clojure.core/let
    [v14750
     (:max-items m14749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14750 :com.palletops.awaze.client-builder/undef)
     (. bean14748 setMaxItems (clojure.core/int v14750))))
   (clojure.core/let
    [v14750
     (:marker m14749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14750 :com.palletops.awaze.client-builder/undef)
     (. bean14748 setMarker (clojure.core/str v14750))))
   (clojure.core/let
    [v14750
     (:path-prefix m14749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14750 :com.palletops.awaze.client-builder/undef)
     (. bean14748 setPathPrefix (clojure.core/str v14750))))
   bean14748))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.SetDefaultPolicyVersionRequest}
set-default-policy-version-request
  [m14752]
  (clojure.core/let
   [bean14751
    (new
     com.amazonaws.services.identitymanagement.model.SetDefaultPolicyVersionRequest)]
   (clojure.core/let
    [v14753
     (:version-id m14752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14753 :com.palletops.awaze.client-builder/undef)
     (. bean14751 setVersionId (clojure.core/str v14753))))
   (clojure.core/let
    [v14753
     (:policy-arn m14752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14753 :com.palletops.awaze.client-builder/undef)
     (. bean14751 setPolicyArn (clojure.core/str v14753))))
   bean14751))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest}
delete-user-policy-request
  [m14755]
  (clojure.core/let
   [bean14754
    (new
     com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest)]
   (clojure.core/let
    [v14756
     (:policy-name m14755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14756 :com.palletops.awaze.client-builder/undef)
     (. bean14754 setPolicyName (clojure.core/str v14756))))
   (clojure.core/let
    [v14756
     (:user-name m14755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14756 :com.palletops.awaze.client-builder/undef)
     (. bean14754 setUserName (clojure.core/str v14756))))
   bean14754))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetAccessKeyLastUsedRequest}
get-access-key-last-used-request
  [m14758]
  (clojure.core/let
   [bean14757
    (new
     com.amazonaws.services.identitymanagement.model.GetAccessKeyLastUsedRequest)]
   (clojure.core/let
    [v14759
     (:access-key-id m14758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14759 :com.palletops.awaze.client-builder/undef)
     (. bean14757 setAccessKeyId (clojure.core/str v14759))))
   bean14757))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.AttachGroupPolicyRequest}
attach-group-policy-request
  [m14761]
  (clojure.core/let
   [bean14760
    (new
     com.amazonaws.services.identitymanagement.model.AttachGroupPolicyRequest)]
   (clojure.core/let
    [v14762
     (:group-name m14761 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14762 :com.palletops.awaze.client-builder/undef)
     (. bean14760 setGroupName (clojure.core/str v14762))))
   (clojure.core/let
    [v14762
     (:policy-arn m14761 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14762 :com.palletops.awaze.client-builder/undef)
     (. bean14760 setPolicyArn (clojure.core/str v14762))))
   bean14760))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetUserRequest}
get-user-request
  [m14764]
  (clojure.core/let
   [bean14763
    (new
     com.amazonaws.services.identitymanagement.model.GetUserRequest)]
   (clojure.core/let
    [v14765
     (:user-name m14764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14765 :com.palletops.awaze.client-builder/undef)
     (. bean14763 setUserName (clojure.core/str v14765))))
   bean14763))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GenerateCredentialReportRequest}
generate-credential-report-request
  [m14767]
  (clojure.core/let
   [bean14766
    (new
     com.amazonaws.services.identitymanagement.model.GenerateCredentialReportRequest)]
   bean14766))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetSSHPublicKeyRequest}
get-sshpublic-key-request
  [m14770]
  (clojure.core/let
   [bean14769
    (new
     com.amazonaws.services.identitymanagement.model.GetSSHPublicKeyRequest)]
   (clojure.core/let
    [v14771
     (:encoding m14770 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14771 :com.palletops.awaze.client-builder/undef)
     (. bean14769 setEncoding (clojure.core/str v14771))))
   (clojure.core/let
    [v14771
     (:sshpublic-key-id
      m14770
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14771 :com.palletops.awaze.client-builder/undef)
     (. bean14769 setSSHPublicKeyId (clojure.core/str v14771))))
   (clojure.core/let
    [v14771
     (:user-name m14770 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14771 :com.palletops.awaze.client-builder/undef)
     (. bean14769 setUserName (clojure.core/str v14771))))
   bean14769))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateAccountAliasRequest}
create-account-alias-request
  [m14773]
  (clojure.core/let
   [bean14772
    (new
     com.amazonaws.services.identitymanagement.model.CreateAccountAliasRequest)]
   (clojure.core/let
    [v14774
     (:account-alias m14773 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14774 :com.palletops.awaze.client-builder/undef)
     (. bean14772 setAccountAlias (clojure.core/str v14774))))
   bean14772))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetSAMLProviderRequest}
get-samlprovider-request
  [m14776]
  (clojure.core/let
   [bean14775
    (new
     com.amazonaws.services.identitymanagement.model.GetSAMLProviderRequest)]
   (clojure.core/let
    [v14777
     (:samlprovider-arn
      m14776
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14777 :com.palletops.awaze.client-builder/undef)
     (. bean14775 setSAMLProviderArn (clojure.core/str v14777))))
   bean14775))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetPolicyVersionRequest}
get-policy-version-request
  [m14779]
  (clojure.core/let
   [bean14778
    (new
     com.amazonaws.services.identitymanagement.model.GetPolicyVersionRequest)]
   (clojure.core/let
    [v14780
     (:version-id m14779 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14780 :com.palletops.awaze.client-builder/undef)
     (. bean14778 setVersionId (clojure.core/str v14780))))
   (clojure.core/let
    [v14780
     (:policy-arn m14779 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14780 :com.palletops.awaze.client-builder/undef)
     (. bean14778 setPolicyArn (clojure.core/str v14780))))
   bean14778))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListMFADevicesRequest}
list-mfadevices-request
  [m14782]
  (clojure.core/let
   [bean14781
    (new
     com.amazonaws.services.identitymanagement.model.ListMFADevicesRequest)]
   (clojure.core/let
    [v14783
     (:max-items m14782 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14783 :com.palletops.awaze.client-builder/undef)
     (. bean14781 setMaxItems (clojure.core/int v14783))))
   (clojure.core/let
    [v14783
     (:marker m14782 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14783 :com.palletops.awaze.client-builder/undef)
     (. bean14781 setMarker (clojure.core/str v14783))))
   (clojure.core/let
    [v14783
     (:user-name m14782 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14783 :com.palletops.awaze.client-builder/undef)
     (. bean14781 setUserName (clojure.core/str v14783))))
   bean14781))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListServerCertificatesRequest}
list-server-certificates-request
  [m14785]
  (clojure.core/let
   [bean14784
    (new
     com.amazonaws.services.identitymanagement.model.ListServerCertificatesRequest)]
   (clojure.core/let
    [v14786
     (:max-items m14785 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14786 :com.palletops.awaze.client-builder/undef)
     (. bean14784 setMaxItems (clojure.core/int v14786))))
   (clojure.core/let
    [v14786
     (:marker m14785 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14786 :com.palletops.awaze.client-builder/undef)
     (. bean14784 setMarker (clojure.core/str v14786))))
   (clojure.core/let
    [v14786
     (:path-prefix m14785 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14786 :com.palletops.awaze.client-builder/undef)
     (. bean14784 setPathPrefix (clojure.core/str v14786))))
   bean14784))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.PutGroupPolicyRequest}
put-group-policy-request
  [m14788]
  (clojure.core/let
   [bean14787
    (new
     com.amazonaws.services.identitymanagement.model.PutGroupPolicyRequest)]
   (clojure.core/let
    [v14789
     (:group-name m14788 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14789 :com.palletops.awaze.client-builder/undef)
     (. bean14787 setGroupName (clojure.core/str v14789))))
   (clojure.core/let
    [v14789
     (:policy-document
      m14788
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14789 :com.palletops.awaze.client-builder/undef)
     (. bean14787 setPolicyDocument (clojure.core/str v14789))))
   (clojure.core/let
    [v14789
     (:policy-name m14788 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14789 :com.palletops.awaze.client-builder/undef)
     (. bean14787 setPolicyName (clojure.core/str v14789))))
   bean14787))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetAccountAuthorizationDetailsRequest}
get-account-authorization-details-request
  [m14791]
  (clojure.core/let
   [bean14790
    (new
     com.amazonaws.services.identitymanagement.model.GetAccountAuthorizationDetailsRequest)]
   (clojure.core/let
    [v14792
     (:max-items m14791 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14792 :com.palletops.awaze.client-builder/undef)
     (. bean14790 setMaxItems (clojure.core/int v14792))))
   (clojure.core/let
    [v14792
     (:filter m14791 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14792 :com.palletops.awaze.client-builder/undef)
     (.
      bean14790
      setFilter
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg15067] (clojure.core/str arg15067))
 v14792))))
   (clojure.core/let
    [v14792
     (:marker m14791 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14792 :com.palletops.awaze.client-builder/undef)
     (. bean14790 setMarker (clojure.core/str v14792))))
   bean14790))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteGroupPolicyRequest}
delete-group-policy-request
  [m14794]
  (clojure.core/let
   [bean14793
    (new
     com.amazonaws.services.identitymanagement.model.DeleteGroupPolicyRequest)]
   (clojure.core/let
    [v14795
     (:group-name m14794 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14795 :com.palletops.awaze.client-builder/undef)
     (. bean14793 setGroupName (clojure.core/str v14795))))
   (clojure.core/let
    [v14795
     (:policy-name m14794 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14795 :com.palletops.awaze.client-builder/undef)
     (. bean14793 setPolicyName (clojure.core/str v14795))))
   bean14793))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListOpenIDConnectProvidersRequest}
list-open-idconnect-providers-request
  [m14797]
  (clojure.core/let
   [bean14796
    (new
     com.amazonaws.services.identitymanagement.model.ListOpenIDConnectProvidersRequest)]
   bean14796))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListRolePoliciesRequest}
list-role-policies-request
  [m14800]
  (clojure.core/let
   [bean14799
    (new
     com.amazonaws.services.identitymanagement.model.ListRolePoliciesRequest)]
   (clojure.core/let
    [v14801
     (:max-items m14800 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14801 :com.palletops.awaze.client-builder/undef)
     (. bean14799 setMaxItems (clojure.core/int v14801))))
   (clojure.core/let
    [v14801
     (:role-name m14800 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14801 :com.palletops.awaze.client-builder/undef)
     (. bean14799 setRoleName (clojure.core/str v14801))))
   (clojure.core/let
    [v14801
     (:marker m14800 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14801 :com.palletops.awaze.client-builder/undef)
     (. bean14799 setMarker (clojure.core/str v14801))))
   bean14799))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateAccountPasswordPolicyRequest}
update-account-password-policy-request
  [m14803]
  (clojure.core/let
   [bean14802
    (new
     com.amazonaws.services.identitymanagement.model.UpdateAccountPasswordPolicyRequest)]
   (clojure.core/let
    [v14804
     (:require-uppercase-characters
      m14803
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14804 :com.palletops.awaze.client-builder/undef)
     (.
      bean14802
      setRequireUppercaseCharacters
      (clojure.core/boolean v14804))))
   (clojure.core/let
    [v14804
     (:hard-expiry m14803 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14804 :com.palletops.awaze.client-builder/undef)
     (. bean14802 setHardExpiry (clojure.core/boolean v14804))))
   (clojure.core/let
    [v14804
     (:require-symbols
      m14803
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14804 :com.palletops.awaze.client-builder/undef)
     (. bean14802 setRequireSymbols (clojure.core/boolean v14804))))
   (clojure.core/let
    [v14804
     (:require-numbers
      m14803
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14804 :com.palletops.awaze.client-builder/undef)
     (. bean14802 setRequireNumbers (clojure.core/boolean v14804))))
   (clojure.core/let
    [v14804
     (:minimum-password-length
      m14803
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14804 :com.palletops.awaze.client-builder/undef)
     (. bean14802 setMinimumPasswordLength (clojure.core/int v14804))))
   (clojure.core/let
    [v14804
     (:allow-users-to-change-password
      m14803
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14804 :com.palletops.awaze.client-builder/undef)
     (.
      bean14802
      setAllowUsersToChangePassword
      (clojure.core/boolean v14804))))
   (clojure.core/let
    [v14804
     (:max-password-age
      m14803
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14804 :com.palletops.awaze.client-builder/undef)
     (. bean14802 setMaxPasswordAge (clojure.core/int v14804))))
   (clojure.core/let
    [v14804
     (:require-lowercase-characters
      m14803
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14804 :com.palletops.awaze.client-builder/undef)
     (.
      bean14802
      setRequireLowercaseCharacters
      (clojure.core/boolean v14804))))
   (clojure.core/let
    [v14804
     (:password-reuse-prevention
      m14803
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14804 :com.palletops.awaze.client-builder/undef)
     (.
      bean14802
      setPasswordReusePrevention
      (clojure.core/int v14804))))
   bean14802))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest}
put-user-policy-request
  [m14806]
  (clojure.core/let
   [bean14805
    (new
     com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest)]
   (clojure.core/let
    [v14807
     (:policy-document
      m14806
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14807 :com.palletops.awaze.client-builder/undef)
     (. bean14805 setPolicyDocument (clojure.core/str v14807))))
   (clojure.core/let
    [v14807
     (:policy-name m14806 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14807 :com.palletops.awaze.client-builder/undef)
     (. bean14805 setPolicyName (clojure.core/str v14807))))
   (clojure.core/let
    [v14807
     (:user-name m14806 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14807 :com.palletops.awaze.client-builder/undef)
     (. bean14805 setUserName (clojure.core/str v14807))))
   bean14805))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateAssumeRolePolicyRequest}
update-assume-role-policy-request
  [m14809]
  (clojure.core/let
   [bean14808
    (new
     com.amazonaws.services.identitymanagement.model.UpdateAssumeRolePolicyRequest)]
   (clojure.core/let
    [v14810
     (:policy-document
      m14809
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14810 :com.palletops.awaze.client-builder/undef)
     (. bean14808 setPolicyDocument (clojure.core/str v14810))))
   (clojure.core/let
    [v14810
     (:role-name m14809 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14810 :com.palletops.awaze.client-builder/undef)
     (. bean14808 setRoleName (clojure.core/str v14810))))
   bean14808))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetPolicyRequest}
get-policy-request
  [m14812]
  (clojure.core/let
   [bean14811
    (new
     com.amazonaws.services.identitymanagement.model.GetPolicyRequest)]
   (clojure.core/let
    [v14813
     (:policy-arn m14812 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14813 :com.palletops.awaze.client-builder/undef)
     (. bean14811 setPolicyArn (clojure.core/str v14813))))
   bean14811))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateUserRequest}
update-user-request
  [m14815]
  (clojure.core/let
   [bean14814
    (new
     com.amazonaws.services.identitymanagement.model.UpdateUserRequest)]
   (clojure.core/let
    [v14816
     (:new-user-name m14815 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14816 :com.palletops.awaze.client-builder/undef)
     (. bean14814 setNewUserName (clojure.core/str v14816))))
   (clojure.core/let
    [v14816
     (:new-path m14815 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14816 :com.palletops.awaze.client-builder/undef)
     (. bean14814 setNewPath (clojure.core/str v14816))))
   (clojure.core/let
    [v14816
     (:user-name m14815 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14816 :com.palletops.awaze.client-builder/undef)
     (. bean14814 setUserName (clojure.core/str v14816))))
   bean14814))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetRolePolicyRequest}
get-role-policy-request
  [m14818]
  (clojure.core/let
   [bean14817
    (new
     com.amazonaws.services.identitymanagement.model.GetRolePolicyRequest)]
   (clojure.core/let
    [v14819
     (:role-name m14818 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14819 :com.palletops.awaze.client-builder/undef)
     (. bean14817 setRoleName (clojure.core/str v14819))))
   (clojure.core/let
    [v14819
     (:policy-name m14818 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14819 :com.palletops.awaze.client-builder/undef)
     (. bean14817 setPolicyName (clojure.core/str v14819))))
   bean14817))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteGroupRequest}
delete-group-request
  [m14821]
  (clojure.core/let
   [bean14820
    (new
     com.amazonaws.services.identitymanagement.model.DeleteGroupRequest)]
   (clojure.core/let
    [v14822
     (:group-name m14821 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14822 :com.palletops.awaze.client-builder/undef)
     (. bean14820 setGroupName (clojure.core/str v14822))))
   bean14820))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetLoginProfileRequest}
get-login-profile-request
  [m14824]
  (clojure.core/let
   [bean14823
    (new
     com.amazonaws.services.identitymanagement.model.GetLoginProfileRequest)]
   (clojure.core/let
    [v14825
     (:user-name m14824 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14825 :com.palletops.awaze.client-builder/undef)
     (. bean14823 setUserName (clojure.core/str v14825))))
   bean14823))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListSAMLProvidersRequest}
list-samlproviders-request
  [m14827]
  (clojure.core/let
   [bean14826
    (new
     com.amazonaws.services.identitymanagement.model.ListSAMLProvidersRequest)]
   bean14826))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateRoleRequest}
create-role-request
  [m14830]
  (clojure.core/let
   [bean14829
    (new
     com.amazonaws.services.identitymanagement.model.CreateRoleRequest)]
   (clojure.core/let
    [v14831
     (:role-name m14830 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14831 :com.palletops.awaze.client-builder/undef)
     (. bean14829 setRoleName (clojure.core/str v14831))))
   (clojure.core/let
    [v14831
     (:assume-role-policy-document
      m14830
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14831 :com.palletops.awaze.client-builder/undef)
     (.
      bean14829
      setAssumeRolePolicyDocument
      (clojure.core/str v14831))))
   (clojure.core/let
    [v14831 (:path m14830 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14831 :com.palletops.awaze.client-builder/undef)
     (. bean14829 setPath (clojure.core/str v14831))))
   bean14829))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListAttachedGroupPoliciesRequest}
list-attached-group-policies-request
  [m14833]
  (clojure.core/let
   [bean14832
    (new
     com.amazonaws.services.identitymanagement.model.ListAttachedGroupPoliciesRequest)]
   (clojure.core/let
    [v14834
     (:max-items m14833 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14834 :com.palletops.awaze.client-builder/undef)
     (. bean14832 setMaxItems (clojure.core/int v14834))))
   (clojure.core/let
    [v14834
     (:group-name m14833 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14834 :com.palletops.awaze.client-builder/undef)
     (. bean14832 setGroupName (clojure.core/str v14834))))
   (clojure.core/let
    [v14834
     (:marker m14833 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14834 :com.palletops.awaze.client-builder/undef)
     (. bean14832 setMarker (clojure.core/str v14834))))
   (clojure.core/let
    [v14834
     (:path-prefix m14833 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14834 :com.palletops.awaze.client-builder/undef)
     (. bean14832 setPathPrefix (clojure.core/str v14834))))
   bean14832))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest}
delete-access-key-request
  [m14836]
  (clojure.core/let
   [bean14835
    (new
     com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest)]
   (clojure.core/let
    [v14837
     (:access-key-id m14836 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14837 :com.palletops.awaze.client-builder/undef)
     (. bean14835 setAccessKeyId (clojure.core/str v14837))))
   (clojure.core/let
    [v14837
     (:user-name m14836 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14837 :com.palletops.awaze.client-builder/undef)
     (. bean14835 setUserName (clojure.core/str v14837))))
   bean14835))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetGroupRequest}
get-group-request
  [m14839]
  (clojure.core/let
   [bean14838
    (new
     com.amazonaws.services.identitymanagement.model.GetGroupRequest)]
   (clojure.core/let
    [v14840
     (:max-items m14839 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14840 :com.palletops.awaze.client-builder/undef)
     (. bean14838 setMaxItems (clojure.core/int v14840))))
   (clojure.core/let
    [v14840
     (:group-name m14839 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14840 :com.palletops.awaze.client-builder/undef)
     (. bean14838 setGroupName (clojure.core/str v14840))))
   (clojure.core/let
    [v14840
     (:marker m14839 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14840 :com.palletops.awaze.client-builder/undef)
     (. bean14838 setMarker (clojure.core/str v14840))))
   bean14838))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteAccountPasswordPolicyRequest}
delete-account-password-policy-request
  [m14842]
  (clojure.core/let
   [bean14841
    (new
     com.amazonaws.services.identitymanagement.model.DeleteAccountPasswordPolicyRequest)]
   bean14841))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetAccountSummaryRequest}
get-account-summary-request
  [m14845]
  (clojure.core/let
   [bean14844
    (new
     com.amazonaws.services.identitymanagement.model.GetAccountSummaryRequest)]
   bean14844))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeletePolicyRequest}
delete-policy-request
  [m14848]
  (clojure.core/let
   [bean14847
    (new
     com.amazonaws.services.identitymanagement.model.DeletePolicyRequest)]
   (clojure.core/let
    [v14849
     (:policy-arn m14848 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14849 :com.palletops.awaze.client-builder/undef)
     (. bean14847 setPolicyArn (clojure.core/str v14849))))
   bean14847))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateGroupRequest}
create-group-request
  [m14851]
  (clojure.core/let
   [bean14850
    (new
     com.amazonaws.services.identitymanagement.model.CreateGroupRequest)]
   (clojure.core/let
    [v14852
     (:group-name m14851 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14852 :com.palletops.awaze.client-builder/undef)
     (. bean14850 setGroupName (clojure.core/str v14852))))
   (clojure.core/let
    [v14852 (:path m14851 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14852 :com.palletops.awaze.client-builder/undef)
     (. bean14850 setPath (clojure.core/str v14852))))
   bean14850))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetRoleRequest}
get-role-request
  [m14854]
  (clojure.core/let
   [bean14853
    (new
     com.amazonaws.services.identitymanagement.model.GetRoleRequest)]
   (clojure.core/let
    [v14855
     (:role-name m14854 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14855 :com.palletops.awaze.client-builder/undef)
     (. bean14853 setRoleName (clojure.core/str v14855))))
   bean14853))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListPolicyVersionsRequest}
list-policy-versions-request
  [m14857]
  (clojure.core/let
   [bean14856
    (new
     com.amazonaws.services.identitymanagement.model.ListPolicyVersionsRequest)]
   (clojure.core/let
    [v14858
     (:max-items m14857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14858 :com.palletops.awaze.client-builder/undef)
     (. bean14856 setMaxItems (clojure.core/int v14858))))
   (clojure.core/let
    [v14858
     (:marker m14857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14858 :com.palletops.awaze.client-builder/undef)
     (. bean14856 setMarker (clojure.core/str v14858))))
   (clojure.core/let
    [v14858
     (:policy-arn m14857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14858 :com.palletops.awaze.client-builder/undef)
     (. bean14856 setPolicyArn (clojure.core/str v14858))))
   bean14856))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListGroupPoliciesRequest}
list-group-policies-request
  [m14860]
  (clojure.core/let
   [bean14859
    (new
     com.amazonaws.services.identitymanagement.model.ListGroupPoliciesRequest)]
   (clojure.core/let
    [v14861
     (:max-items m14860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14861 :com.palletops.awaze.client-builder/undef)
     (. bean14859 setMaxItems (clojure.core/int v14861))))
   (clojure.core/let
    [v14861
     (:group-name m14860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14861 :com.palletops.awaze.client-builder/undef)
     (. bean14859 setGroupName (clojure.core/str v14861))))
   (clojure.core/let
    [v14861
     (:marker m14860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14861 :com.palletops.awaze.client-builder/undef)
     (. bean14859 setMarker (clojure.core/str v14861))))
   bean14859))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteSAMLProviderRequest}
delete-samlprovider-request
  [m14863]
  (clojure.core/let
   [bean14862
    (new
     com.amazonaws.services.identitymanagement.model.DeleteSAMLProviderRequest)]
   (clojure.core/let
    [v14864
     (:samlprovider-arn
      m14863
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14864 :com.palletops.awaze.client-builder/undef)
     (. bean14862 setSAMLProviderArn (clojure.core/str v14864))))
   bean14862))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DetachRolePolicyRequest}
detach-role-policy-request
  [m14866]
  (clojure.core/let
   [bean14865
    (new
     com.amazonaws.services.identitymanagement.model.DetachRolePolicyRequest)]
   (clojure.core/let
    [v14867
     (:role-name m14866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14867 :com.palletops.awaze.client-builder/undef)
     (. bean14865 setRoleName (clojure.core/str v14867))))
   (clojure.core/let
    [v14867
     (:policy-arn m14866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14867 :com.palletops.awaze.client-builder/undef)
     (. bean14865 setPolicyArn (clojure.core/str v14867))))
   bean14865))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateLoginProfileRequest}
update-login-profile-request
  [m14869]
  (clojure.core/let
   [bean14868
    (new
     com.amazonaws.services.identitymanagement.model.UpdateLoginProfileRequest)]
   (clojure.core/let
    [v14870
     (:password m14869 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14870 :com.palletops.awaze.client-builder/undef)
     (. bean14868 setPassword (clojure.core/str v14870))))
   (clojure.core/let
    [v14870
     (:user-name m14869 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14870 :com.palletops.awaze.client-builder/undef)
     (. bean14868 setUserName (clojure.core/str v14870))))
   (clojure.core/let
    [v14870
     (:password-reset-required
      m14869
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14870 :com.palletops.awaze.client-builder/undef)
     (.
      bean14868
      setPasswordResetRequired
      (clojure.core/boolean v14870))))
   bean14868))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateOpenIDConnectProviderThumbprintRequest}
update-open-idconnect-provider-thumbprint-request
  [m14872]
  (clojure.core/let
   [bean14871
    (new
     com.amazonaws.services.identitymanagement.model.UpdateOpenIDConnectProviderThumbprintRequest)]
   (clojure.core/let
    [v14873
     (:open-idconnect-provider-arn
      m14872
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14873 :com.palletops.awaze.client-builder/undef)
     (.
      bean14871
      setOpenIDConnectProviderArn
      (clojure.core/str v14873))))
   (clojure.core/let
    [v14873
     (:thumbprint-list
      m14872
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14873 :com.palletops.awaze.client-builder/undef)
     (.
      bean14871
      setThumbprintList
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg15068] (clojure.core/str arg15068))
 v14873))))
   bean14871))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateSSHPublicKeyRequest}
update-sshpublic-key-request
  [m14875]
  (clojure.core/let
   [bean14874
    (new
     com.amazonaws.services.identitymanagement.model.UpdateSSHPublicKeyRequest)]
   (clojure.core/let
    [v14876
     (:status m14875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14876 :com.palletops.awaze.client-builder/undef)
     (. bean14874 setStatus (identitymanagement/status-type v14876))))
   (clojure.core/let
    [v14876
     (:sshpublic-key-id
      m14875
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14876 :com.palletops.awaze.client-builder/undef)
     (. bean14874 setSSHPublicKeyId (clojure.core/str v14876))))
   (clojure.core/let
    [v14876
     (:user-name m14875 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14876 :com.palletops.awaze.client-builder/undef)
     (. bean14874 setUserName (clojure.core/str v14876))))
   bean14874))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteServerCertificateRequest}
delete-server-certificate-request
  [m14878]
  (clojure.core/let
   [bean14877
    (new
     com.amazonaws.services.identitymanagement.model.DeleteServerCertificateRequest)]
   (clojure.core/let
    [v14879
     (:server-certificate-name
      m14878
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14879 :com.palletops.awaze.client-builder/undef)
     (. bean14877 setServerCertificateName (clojure.core/str v14879))))
   bean14877))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListVirtualMFADevicesRequest}
list-virtual-mfadevices-request
  [m14881]
  (clojure.core/let
   [bean14880
    (new
     com.amazonaws.services.identitymanagement.model.ListVirtualMFADevicesRequest)]
   (clojure.core/let
    [v14882
     (:max-items m14881 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14882 :com.palletops.awaze.client-builder/undef)
     (. bean14880 setMaxItems (clojure.core/int v14882))))
   (clojure.core/let
    [v14882
     (:marker m14881 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14882 :com.palletops.awaze.client-builder/undef)
     (. bean14880 setMarker (clojure.core/str v14882))))
   (clojure.core/let
    [v14882
     (:assignment-status
      m14881
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14882 :com.palletops.awaze.client-builder/undef)
     (. bean14880 setAssignmentStatus (clojure.core/str v14882))))
   bean14880))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetServerCertificateRequest}
get-server-certificate-request
  [m14884]
  (clojure.core/let
   [bean14883
    (new
     com.amazonaws.services.identitymanagement.model.GetServerCertificateRequest)]
   (clojure.core/let
    [v14885
     (:server-certificate-name
      m14884
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14885 :com.palletops.awaze.client-builder/undef)
     (. bean14883 setServerCertificateName (clojure.core/str v14885))))
   bean14883))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteRolePolicyRequest}
delete-role-policy-request
  [m14887]
  (clojure.core/let
   [bean14886
    (new
     com.amazonaws.services.identitymanagement.model.DeleteRolePolicyRequest)]
   (clojure.core/let
    [v14888
     (:role-name m14887 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14888 :com.palletops.awaze.client-builder/undef)
     (. bean14886 setRoleName (clojure.core/str v14888))))
   (clojure.core/let
    [v14888
     (:policy-name m14887 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14888 :com.palletops.awaze.client-builder/undef)
     (. bean14886 setPolicyName (clojure.core/str v14888))))
   bean14886))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileRequest}
delete-instance-profile-request
  [m14890]
  (clojure.core/let
   [bean14889
    (new
     com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileRequest)]
   (clojure.core/let
    [v14891
     (:instance-profile-name
      m14890
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14891 :com.palletops.awaze.client-builder/undef)
     (. bean14889 setInstanceProfileName (clojure.core/str v14891))))
   bean14889))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListAccountAliasesRequest}
list-account-aliases-request
  [m14893]
  (clojure.core/let
   [bean14892
    (new
     com.amazonaws.services.identitymanagement.model.ListAccountAliasesRequest)]
   (clojure.core/let
    [v14894
     (:max-items m14893 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14894 :com.palletops.awaze.client-builder/undef)
     (. bean14892 setMaxItems (clojure.core/int v14894))))
   (clojure.core/let
    [v14894
     (:marker m14893 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14894 :com.palletops.awaze.client-builder/undef)
     (. bean14892 setMarker (clojure.core/str v14894))))
   bean14892))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.AddUserToGroupRequest}
add-user-to-group-request
  [m14896]
  (clojure.core/let
   [bean14895
    (new
     com.amazonaws.services.identitymanagement.model.AddUserToGroupRequest)]
   (clojure.core/let
    [v14897
     (:group-name m14896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14897 :com.palletops.awaze.client-builder/undef)
     (. bean14895 setGroupName (clojure.core/str v14897))))
   (clojure.core/let
    [v14897
     (:user-name m14896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14897 :com.palletops.awaze.client-builder/undef)
     (. bean14895 setUserName (clojure.core/str v14897))))
   bean14895))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteOpenIDConnectProviderRequest}
delete-open-idconnect-provider-request
  [m14899]
  (clojure.core/let
   [bean14898
    (new
     com.amazonaws.services.identitymanagement.model.DeleteOpenIDConnectProviderRequest)]
   (clojure.core/let
    [v14900
     (:open-idconnect-provider-arn
      m14899
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14900 :com.palletops.awaze.client-builder/undef)
     (.
      bean14898
      setOpenIDConnectProviderArn
      (clojure.core/str v14900))))
   bean14898))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListUsersRequest}
list-users-request
  [m14902]
  (clojure.core/let
   [bean14901
    (new
     com.amazonaws.services.identitymanagement.model.ListUsersRequest)]
   (clojure.core/let
    [v14903
     (:max-items m14902 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14903 :com.palletops.awaze.client-builder/undef)
     (. bean14901 setMaxItems (clojure.core/int v14903))))
   (clojure.core/let
    [v14903
     (:marker m14902 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14903 :com.palletops.awaze.client-builder/undef)
     (. bean14901 setMarker (clojure.core/str v14903))))
   (clojure.core/let
    [v14903
     (:path-prefix m14902 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14903 :com.palletops.awaze.client-builder/undef)
     (. bean14901 setPathPrefix (clojure.core/str v14903))))
   bean14901))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest}
create-instance-profile-request
  [m14905]
  (clojure.core/let
   [bean14904
    (new
     com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest)]
   (clojure.core/let
    [v14906 (:path m14905 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14906 :com.palletops.awaze.client-builder/undef)
     (. bean14904 setPath (clojure.core/str v14906))))
   (clojure.core/let
    [v14906
     (:instance-profile-name
      m14905
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14906 :com.palletops.awaze.client-builder/undef)
     (. bean14904 setInstanceProfileName (clojure.core/str v14906))))
   bean14904))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetUserPolicyRequest}
get-user-policy-request
  [m14908]
  (clojure.core/let
   [bean14907
    (new
     com.amazonaws.services.identitymanagement.model.GetUserPolicyRequest)]
   (clojure.core/let
    [v14909
     (:policy-name m14908 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14909 :com.palletops.awaze.client-builder/undef)
     (. bean14907 setPolicyName (clojure.core/str v14909))))
   (clojure.core/let
    [v14909
     (:user-name m14908 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14909 :com.palletops.awaze.client-builder/undef)
     (. bean14907 setUserName (clojure.core/str v14909))))
   bean14907))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteLoginProfileRequest}
delete-login-profile-request
  [m14911]
  (clojure.core/let
   [bean14910
    (new
     com.amazonaws.services.identitymanagement.model.DeleteLoginProfileRequest)]
   (clojure.core/let
    [v14912
     (:user-name m14911 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14912 :com.palletops.awaze.client-builder/undef)
     (. bean14910 setUserName (clojure.core/str v14912))))
   bean14910))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.AttachUserPolicyRequest}
attach-user-policy-request
  [m14914]
  (clojure.core/let
   [bean14913
    (new
     com.amazonaws.services.identitymanagement.model.AttachUserPolicyRequest)]
   (clojure.core/let
    [v14915
     (:user-name m14914 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14915 :com.palletops.awaze.client-builder/undef)
     (. bean14913 setUserName (clojure.core/str v14915))))
   (clojure.core/let
    [v14915
     (:policy-arn m14914 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14915 :com.palletops.awaze.client-builder/undef)
     (. bean14913 setPolicyArn (clojure.core/str v14915))))
   bean14913))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.PutRolePolicyRequest}
put-role-policy-request
  [m14917]
  (clojure.core/let
   [bean14916
    (new
     com.amazonaws.services.identitymanagement.model.PutRolePolicyRequest)]
   (clojure.core/let
    [v14918
     (:policy-document
      m14917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14918 :com.palletops.awaze.client-builder/undef)
     (. bean14916 setPolicyDocument (clojure.core/str v14918))))
   (clojure.core/let
    [v14918
     (:role-name m14917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14918 :com.palletops.awaze.client-builder/undef)
     (. bean14916 setRoleName (clojure.core/str v14918))))
   (clojure.core/let
    [v14918
     (:policy-name m14917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14918 :com.palletops.awaze.client-builder/undef)
     (. bean14916 setPolicyName (clojure.core/str v14918))))
   bean14916))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest}
list-access-keys-request
  [m14920]
  (clojure.core/let
   [bean14919
    (new
     com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest)]
   (clojure.core/let
    [v14921
     (:max-items m14920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14921 :com.palletops.awaze.client-builder/undef)
     (. bean14919 setMaxItems (clojure.core/int v14921))))
   (clojure.core/let
    [v14921
     (:marker m14920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14921 :com.palletops.awaze.client-builder/undef)
     (. bean14919 setMarker (clojure.core/str v14921))))
   (clojure.core/let
    [v14921
     (:user-name m14920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14921 :com.palletops.awaze.client-builder/undef)
     (. bean14919 setUserName (clojure.core/str v14921))))
   bean14919))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListSigningCertificatesRequest}
list-signing-certificates-request
  [m14923]
  (clojure.core/let
   [bean14922
    (new
     com.amazonaws.services.identitymanagement.model.ListSigningCertificatesRequest)]
   (clojure.core/let
    [v14924
     (:max-items m14923 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14924 :com.palletops.awaze.client-builder/undef)
     (. bean14922 setMaxItems (clojure.core/int v14924))))
   (clojure.core/let
    [v14924
     (:marker m14923 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14924 :com.palletops.awaze.client-builder/undef)
     (. bean14922 setMarker (clojure.core/str v14924))))
   (clojure.core/let
    [v14924
     (:user-name m14923 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14924 :com.palletops.awaze.client-builder/undef)
     (. bean14922 setUserName (clojure.core/str v14924))))
   bean14922))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DetachGroupPolicyRequest}
detach-group-policy-request
  [m14926]
  (clojure.core/let
   [bean14925
    (new
     com.amazonaws.services.identitymanagement.model.DetachGroupPolicyRequest)]
   (clojure.core/let
    [v14927
     (:group-name m14926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14927 :com.palletops.awaze.client-builder/undef)
     (. bean14925 setGroupName (clojure.core/str v14927))))
   (clojure.core/let
    [v14927
     (:policy-arn m14926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14927 :com.palletops.awaze.client-builder/undef)
     (. bean14925 setPolicyArn (clojure.core/str v14927))))
   bean14925))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateAccessKeyRequest}
update-access-key-request
  [m14929]
  (clojure.core/let
   [bean14928
    (new
     com.amazonaws.services.identitymanagement.model.UpdateAccessKeyRequest)]
   (clojure.core/let
    [v14930
     (:status m14929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14930 :com.palletops.awaze.client-builder/undef)
     (. bean14928 setStatus (identitymanagement/status-type v14930))))
   (clojure.core/let
    [v14930
     (:access-key-id m14929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14930 :com.palletops.awaze.client-builder/undef)
     (. bean14928 setAccessKeyId (clojure.core/str v14930))))
   (clojure.core/let
    [v14930
     (:user-name m14929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14930 :com.palletops.awaze.client-builder/undef)
     (. bean14928 setUserName (clojure.core/str v14930))))
   bean14928))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UploadSSHPublicKeyRequest}
upload-sshpublic-key-request
  [m14932]
  (clojure.core/let
   [bean14931
    (new
     com.amazonaws.services.identitymanagement.model.UploadSSHPublicKeyRequest)]
   (clojure.core/let
    [v14933
     (:sshpublic-key-body
      m14932
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14933 :com.palletops.awaze.client-builder/undef)
     (. bean14931 setSSHPublicKeyBody (clojure.core/str v14933))))
   (clojure.core/let
    [v14933
     (:user-name m14932 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14933 :com.palletops.awaze.client-builder/undef)
     (. bean14931 setUserName (clojure.core/str v14933))))
   bean14931))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UploadServerCertificateRequest}
upload-server-certificate-request
  [m14935]
  (clojure.core/let
   [bean14934
    (new
     com.amazonaws.services.identitymanagement.model.UploadServerCertificateRequest)]
   (clojure.core/let
    [v14936
     (:certificate-body
      m14935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14936 :com.palletops.awaze.client-builder/undef)
     (. bean14934 setCertificateBody (clojure.core/str v14936))))
   (clojure.core/let
    [v14936
     (:certificate-chain
      m14935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14936 :com.palletops.awaze.client-builder/undef)
     (. bean14934 setCertificateChain (clojure.core/str v14936))))
   (clojure.core/let
    [v14936
     (:private-key m14935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14936 :com.palletops.awaze.client-builder/undef)
     (. bean14934 setPrivateKey (clojure.core/str v14936))))
   (clojure.core/let
    [v14936 (:path m14935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14936 :com.palletops.awaze.client-builder/undef)
     (. bean14934 setPath (clojure.core/str v14936))))
   (clojure.core/let
    [v14936
     (:server-certificate-name
      m14935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14936 :com.palletops.awaze.client-builder/undef)
     (. bean14934 setServerCertificateName (clojure.core/str v14936))))
   bean14934))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetAccountPasswordPolicyRequest}
get-account-password-policy-request
  [m14938]
  (clojure.core/let
   [bean14937
    (new
     com.amazonaws.services.identitymanagement.model.GetAccountPasswordPolicyRequest)]
   bean14937))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteRoleRequest}
delete-role-request
  [m14941]
  (clojure.core/let
   [bean14940
    (new
     com.amazonaws.services.identitymanagement.model.DeleteRoleRequest)]
   (clojure.core/let
    [v14942
     (:role-name m14941 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14942 :com.palletops.awaze.client-builder/undef)
     (. bean14940 setRoleName (clojure.core/str v14942))))
   bean14940))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.RemoveClientIDFromOpenIDConnectProviderRequest}
remove-client-idfrom-open-idconnect-provider-request
  [m14944]
  (clojure.core/let
   [bean14943
    (new
     com.amazonaws.services.identitymanagement.model.RemoveClientIDFromOpenIDConnectProviderRequest)]
   (clojure.core/let
    [v14945
     (:client-id m14944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14945 :com.palletops.awaze.client-builder/undef)
     (. bean14943 setClientID (clojure.core/str v14945))))
   (clojure.core/let
    [v14945
     (:open-idconnect-provider-arn
      m14944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14945 :com.palletops.awaze.client-builder/undef)
     (.
      bean14943
      setOpenIDConnectProviderArn
      (clojure.core/str v14945))))
   bean14943))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupRequest}
remove-user-from-group-request
  [m14947]
  (clojure.core/let
   [bean14946
    (new
     com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupRequest)]
   (clojure.core/let
    [v14948
     (:group-name m14947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14948 :com.palletops.awaze.client-builder/undef)
     (. bean14946 setGroupName (clojure.core/str v14948))))
   (clojure.core/let
    [v14948
     (:user-name m14947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14948 :com.palletops.awaze.client-builder/undef)
     (. bean14946 setUserName (clojure.core/str v14948))))
   bean14946))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListRolesRequest}
list-roles-request
  [m14950]
  (clojure.core/let
   [bean14949
    (new
     com.amazonaws.services.identitymanagement.model.ListRolesRequest)]
   (clojure.core/let
    [v14951
     (:max-items m14950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14951 :com.palletops.awaze.client-builder/undef)
     (. bean14949 setMaxItems (clojure.core/int v14951))))
   (clojure.core/let
    [v14951
     (:marker m14950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14951 :com.palletops.awaze.client-builder/undef)
     (. bean14949 setMarker (clojure.core/str v14951))))
   (clojure.core/let
    [v14951
     (:path-prefix m14950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14951 :com.palletops.awaze.client-builder/undef)
     (. bean14949 setPathPrefix (clojure.core/str v14951))))
   bean14949))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListAttachedRolePoliciesRequest}
list-attached-role-policies-request
  [m14953]
  (clojure.core/let
   [bean14952
    (new
     com.amazonaws.services.identitymanagement.model.ListAttachedRolePoliciesRequest)]
   (clojure.core/let
    [v14954
     (:max-items m14953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14954 :com.palletops.awaze.client-builder/undef)
     (. bean14952 setMaxItems (clojure.core/int v14954))))
   (clojure.core/let
    [v14954
     (:role-name m14953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14954 :com.palletops.awaze.client-builder/undef)
     (. bean14952 setRoleName (clojure.core/str v14954))))
   (clojure.core/let
    [v14954
     (:marker m14953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14954 :com.palletops.awaze.client-builder/undef)
     (. bean14952 setMarker (clojure.core/str v14954))))
   (clojure.core/let
    [v14954
     (:path-prefix m14953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14954 :com.palletops.awaze.client-builder/undef)
     (. bean14952 setPathPrefix (clojure.core/str v14954))))
   bean14952))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest}
remove-role-from-instance-profile-request
  [m14956]
  (clojure.core/let
   [bean14955
    (new
     com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest)]
   (clojure.core/let
    [v14957
     (:role-name m14956 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14957 :com.palletops.awaze.client-builder/undef)
     (. bean14955 setRoleName (clojure.core/str v14957))))
   (clojure.core/let
    [v14957
     (:instance-profile-name
      m14956
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14957 :com.palletops.awaze.client-builder/undef)
     (. bean14955 setInstanceProfileName (clojure.core/str v14957))))
   bean14955))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreatePolicyRequest}
create-policy-request
  [m14959]
  (clojure.core/let
   [bean14958
    (new
     com.amazonaws.services.identitymanagement.model.CreatePolicyRequest)]
   (clojure.core/let
    [v14960
     (:description m14959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14960 :com.palletops.awaze.client-builder/undef)
     (. bean14958 setDescription (clojure.core/str v14960))))
   (clojure.core/let
    [v14960
     (:policy-document
      m14959
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14960 :com.palletops.awaze.client-builder/undef)
     (. bean14958 setPolicyDocument (clojure.core/str v14960))))
   (clojure.core/let
    [v14960
     (:policy-name m14959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14960 :com.palletops.awaze.client-builder/undef)
     (. bean14958 setPolicyName (clojure.core/str v14960))))
   (clojure.core/let
    [v14960 (:path m14959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14960 :com.palletops.awaze.client-builder/undef)
     (. bean14958 setPath (clojure.core/str v14960))))
   bean14958))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.AddClientIDToOpenIDConnectProviderRequest}
add-client-idto-open-idconnect-provider-request
  [m14962]
  (clojure.core/let
   [bean14961
    (new
     com.amazonaws.services.identitymanagement.model.AddClientIDToOpenIDConnectProviderRequest)]
   (clojure.core/let
    [v14963
     (:client-id m14962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14963 :com.palletops.awaze.client-builder/undef)
     (. bean14961 setClientID (clojure.core/str v14963))))
   (clojure.core/let
    [v14963
     (:open-idconnect-provider-arn
      m14962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14963 :com.palletops.awaze.client-builder/undef)
     (.
      bean14961
      setOpenIDConnectProviderArn
      (clojure.core/str v14963))))
   bean14961))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceRequest}
create-virtual-mfadevice-request
  [m14965]
  (clojure.core/let
   [bean14964
    (new
     com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceRequest)]
   (clojure.core/let
    [v14966 (:path m14965 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14966 :com.palletops.awaze.client-builder/undef)
     (. bean14964 setPath (clojure.core/str v14966))))
   (clojure.core/let
    [v14966
     (:virtual-mfadevice-name
      m14965
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14966 :com.palletops.awaze.client-builder/undef)
     (. bean14964 setVirtualMFADeviceName (clojure.core/str v14966))))
   bean14964))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteAccountAliasRequest}
delete-account-alias-request
  [m14968]
  (clojure.core/let
   [bean14967
    (new
     com.amazonaws.services.identitymanagement.model.DeleteAccountAliasRequest)]
   (clojure.core/let
    [v14969
     (:account-alias m14968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14969 :com.palletops.awaze.client-builder/undef)
     (. bean14967 setAccountAlias (clojure.core/str v14969))))
   bean14967))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UploadSigningCertificateRequest}
upload-signing-certificate-request
  [m14971]
  (clojure.core/let
   [bean14970
    (new
     com.amazonaws.services.identitymanagement.model.UploadSigningCertificateRequest)]
   (clojure.core/let
    [v14972
     (:certificate-body
      m14971
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14972 :com.palletops.awaze.client-builder/undef)
     (. bean14970 setCertificateBody (clojure.core/str v14972))))
   (clojure.core/let
    [v14972
     (:user-name m14971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14972 :com.palletops.awaze.client-builder/undef)
     (. bean14970 setUserName (clojure.core/str v14972))))
   bean14970))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeactivateMFADeviceRequest}
deactivate-mfadevice-request
  [m14974]
  (clojure.core/let
   [bean14973
    (new
     com.amazonaws.services.identitymanagement.model.DeactivateMFADeviceRequest)]
   (clojure.core/let
    [v14975
     (:serial-number m14974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14975 :com.palletops.awaze.client-builder/undef)
     (. bean14973 setSerialNumber (clojure.core/str v14975))))
   (clojure.core/let
    [v14975
     (:user-name m14974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14975 :com.palletops.awaze.client-builder/undef)
     (. bean14973 setUserName (clojure.core/str v14975))))
   bean14973))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ResyncMFADeviceRequest}
resync-mfadevice-request
  [m14977]
  (clojure.core/let
   [bean14976
    (new
     com.amazonaws.services.identitymanagement.model.ResyncMFADeviceRequest)]
   (clojure.core/let
    [v14978
     (:authentication-code1
      m14977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14978 :com.palletops.awaze.client-builder/undef)
     (. bean14976 setAuthenticationCode1 (clojure.core/str v14978))))
   (clojure.core/let
    [v14978
     (:authentication-code2
      m14977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14978 :com.palletops.awaze.client-builder/undef)
     (. bean14976 setAuthenticationCode2 (clojure.core/str v14978))))
   (clojure.core/let
    [v14978
     (:serial-number m14977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14978 :com.palletops.awaze.client-builder/undef)
     (. bean14976 setSerialNumber (clojure.core/str v14978))))
   (clojure.core/let
    [v14978
     (:user-name m14977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14978 :com.palletops.awaze.client-builder/undef)
     (. bean14976 setUserName (clojure.core/str v14978))))
   bean14976))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListSSHPublicKeysRequest}
list-sshpublic-keys-request
  [m14980]
  (clojure.core/let
   [bean14979
    (new
     com.amazonaws.services.identitymanagement.model.ListSSHPublicKeysRequest)]
   (clojure.core/let
    [v14981
     (:max-items m14980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14981 :com.palletops.awaze.client-builder/undef)
     (. bean14979 setMaxItems (clojure.core/int v14981))))
   (clojure.core/let
    [v14981
     (:marker m14980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14981 :com.palletops.awaze.client-builder/undef)
     (. bean14979 setMarker (clojure.core/str v14981))))
   (clojure.core/let
    [v14981
     (:user-name m14980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14981 :com.palletops.awaze.client-builder/undef)
     (. bean14979 setUserName (clojure.core/str v14981))))
   bean14979))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest}
add-role-to-instance-profile-request
  [m14983]
  (clojure.core/let
   [bean14982
    (new
     com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest)]
   (clojure.core/let
    [v14984
     (:role-name m14983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14984 :com.palletops.awaze.client-builder/undef)
     (. bean14982 setRoleName (clojure.core/str v14984))))
   (clojure.core/let
    [v14984
     (:instance-profile-name
      m14983
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14984 :com.palletops.awaze.client-builder/undef)
     (. bean14982 setInstanceProfileName (clojure.core/str v14984))))
   bean14982))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.EnableMFADeviceRequest}
enable-mfadevice-request
  [m14986]
  (clojure.core/let
   [bean14985
    (new
     com.amazonaws.services.identitymanagement.model.EnableMFADeviceRequest)]
   (clojure.core/let
    [v14987
     (:authentication-code1
      m14986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14987 :com.palletops.awaze.client-builder/undef)
     (. bean14985 setAuthenticationCode1 (clojure.core/str v14987))))
   (clojure.core/let
    [v14987
     (:authentication-code2
      m14986
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14987 :com.palletops.awaze.client-builder/undef)
     (. bean14985 setAuthenticationCode2 (clojure.core/str v14987))))
   (clojure.core/let
    [v14987
     (:serial-number m14986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14987 :com.palletops.awaze.client-builder/undef)
     (. bean14985 setSerialNumber (clojure.core/str v14987))))
   (clojure.core/let
    [v14987
     (:user-name m14986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14987 :com.palletops.awaze.client-builder/undef)
     (. bean14985 setUserName (clojure.core/str v14987))))
   bean14985))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListGroupsRequest}
list-groups-request
  [m14989]
  (clojure.core/let
   [bean14988
    (new
     com.amazonaws.services.identitymanagement.model.ListGroupsRequest)]
   (clojure.core/let
    [v14990
     (:max-items m14989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14990 :com.palletops.awaze.client-builder/undef)
     (. bean14988 setMaxItems (clojure.core/int v14990))))
   (clojure.core/let
    [v14990
     (:marker m14989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14990 :com.palletops.awaze.client-builder/undef)
     (. bean14988 setMarker (clojure.core/str v14990))))
   (clojure.core/let
    [v14990
     (:path-prefix m14989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14990 :com.palletops.awaze.client-builder/undef)
     (. bean14988 setPathPrefix (clojure.core/str v14990))))
   bean14988))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeletePolicyVersionRequest}
delete-policy-version-request
  [m14992]
  (clojure.core/let
   [bean14991
    (new
     com.amazonaws.services.identitymanagement.model.DeletePolicyVersionRequest)]
   (clojure.core/let
    [v14993
     (:version-id m14992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14993 :com.palletops.awaze.client-builder/undef)
     (. bean14991 setVersionId (clojure.core/str v14993))))
   (clojure.core/let
    [v14993
     (:policy-arn m14992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14993 :com.palletops.awaze.client-builder/undef)
     (. bean14991 setPolicyArn (clojure.core/str v14993))))
   bean14991))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest}
create-access-key-request
  [m14995]
  (clojure.core/let
   [bean14994
    (new
     com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest)]
   (clojure.core/let
    [v14996
     (:user-name m14995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14996 :com.palletops.awaze.client-builder/undef)
     (. bean14994 setUserName (clojure.core/str v14996))))
   bean14994))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteVirtualMFADeviceRequest}
delete-virtual-mfadevice-request
  [m14998]
  (clojure.core/let
   [bean14997
    (new
     com.amazonaws.services.identitymanagement.model.DeleteVirtualMFADeviceRequest)]
   (clojure.core/let
    [v14999
     (:serial-number m14998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14999 :com.palletops.awaze.client-builder/undef)
     (. bean14997 setSerialNumber (clojure.core/str v14999))))
   bean14997))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest}
get-instance-profile-request
  [m15001]
  (clojure.core/let
   [bean15000
    (new
     com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest)]
   (clojure.core/let
    [v15002
     (:instance-profile-name
      m15001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15002 :com.palletops.awaze.client-builder/undef)
     (. bean15000 setInstanceProfileName (clojure.core/str v15002))))
   bean15000))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateSAMLProviderRequest}
create-samlprovider-request
  [m15004]
  (clojure.core/let
   [bean15003
    (new
     com.amazonaws.services.identitymanagement.model.CreateSAMLProviderRequest)]
   (clojure.core/let
    [v15005 (:name m15004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15005 :com.palletops.awaze.client-builder/undef)
     (. bean15003 setName (clojure.core/str v15005))))
   (clojure.core/let
    [v15005
     (:samlmetadata-document
      m15004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15005 :com.palletops.awaze.client-builder/undef)
     (. bean15003 setSAMLMetadataDocument (clojure.core/str v15005))))
   bean15003))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateSAMLProviderRequest}
update-samlprovider-request
  [m15007]
  (clojure.core/let
   [bean15006
    (new
     com.amazonaws.services.identitymanagement.model.UpdateSAMLProviderRequest)]
   (clojure.core/let
    [v15008
     (:samlprovider-arn
      m15007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15008 :com.palletops.awaze.client-builder/undef)
     (. bean15006 setSAMLProviderArn (clojure.core/str v15008))))
   (clojure.core/let
    [v15008
     (:samlmetadata-document
      m15007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15008 :com.palletops.awaze.client-builder/undef)
     (. bean15006 setSAMLMetadataDocument (clojure.core/str v15008))))
   bean15006))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteSSHPublicKeyRequest}
delete-sshpublic-key-request
  [m15010]
  (clojure.core/let
   [bean15009
    (new
     com.amazonaws.services.identitymanagement.model.DeleteSSHPublicKeyRequest)]
   (clojure.core/let
    [v15011
     (:sshpublic-key-id
      m15010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15011 :com.palletops.awaze.client-builder/undef)
     (. bean15009 setSSHPublicKeyId (clojure.core/str v15011))))
   (clojure.core/let
    [v15011
     (:user-name m15010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15011 :com.palletops.awaze.client-builder/undef)
     (. bean15009 setUserName (clojure.core/str v15011))))
   bean15009))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.SimulateCustomPolicyRequest}
simulate-custom-policy-request
  [m15013]
  (clojure.core/let
   [bean15012
    (new
     com.amazonaws.services.identitymanagement.model.SimulateCustomPolicyRequest)]
   (clojure.core/let
    [v15014
     (:action-names m15013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15014 :com.palletops.awaze.client-builder/undef)
     (.
      bean15012
      setActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg15069] (clojure.core/str arg15069))
 v15014))))
   (clojure.core/let
    [v15014
     (:caller-arn m15013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15014 :com.palletops.awaze.client-builder/undef)
     (. bean15012 setCallerArn (clojure.core/str v15014))))
   (clojure.core/let
    [v15014
     (:marker m15013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15014 :com.palletops.awaze.client-builder/undef)
     (. bean15012 setMarker (clojure.core/str v15014))))
   (clojure.core/let
    [v15014
     (:resource-arns m15013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15014 :com.palletops.awaze.client-builder/undef)
     (.
      bean15012
      setResourceArns
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg15070] (clojure.core/str arg15070))
 v15014))))
   (clojure.core/let
    [v15014
     (:resource-owner
      m15013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15014 :com.palletops.awaze.client-builder/undef)
     (. bean15012 setResourceOwner (clojure.core/str v15014))))
   (clojure.core/let
    [v15014
     (:resource-handling-option
      m15013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15014 :com.palletops.awaze.client-builder/undef)
     (. bean15012 setResourceHandlingOption (clojure.core/str v15014))))
   (clojure.core/let
    [v15014
     (:resource-policy
      m15013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15014 :com.palletops.awaze.client-builder/undef)
     (. bean15012 setResourcePolicy (clojure.core/str v15014))))
   (clojure.core/let
    [v15014
     (:max-items m15013 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15014 :com.palletops.awaze.client-builder/undef)
     (. bean15012 setMaxItems (clojure.core/int v15014))))
   (clojure.core/let
    [v15014
     (:context-entries
      m15013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15014 :com.palletops.awaze.client-builder/undef)
     (.
      bean15012
      setContextEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg15071]
  (identitymanagement/context-entry arg15071))
 v15014))))
   (clojure.core/let
    [v15014
     (:policy-input-list
      m15013
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15014 :com.palletops.awaze.client-builder/undef)
     (.
      bean15012
      setPolicyInputList
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg15072] (clojure.core/str arg15072))
 v15014))))
   bean15012))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetContextKeysForCustomPolicyRequest}
get-context-keys-for-custom-policy-request
  [m15016]
  (clojure.core/let
   [bean15015
    (new
     com.amazonaws.services.identitymanagement.model.GetContextKeysForCustomPolicyRequest)]
   (clojure.core/let
    [v15017
     (:policy-input-list
      m15016
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15017 :com.palletops.awaze.client-builder/undef)
     (.
      bean15015
      setPolicyInputList
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg15073] (clojure.core/str arg15073))
 v15017))))
   bean15015))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest}
list-user-policies-request
  [m15019]
  (clojure.core/let
   [bean15018
    (new
     com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest)]
   (clojure.core/let
    [v15020
     (:max-items m15019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15020 :com.palletops.awaze.client-builder/undef)
     (. bean15018 setMaxItems (clojure.core/int v15020))))
   (clojure.core/let
    [v15020
     (:marker m15019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15020 :com.palletops.awaze.client-builder/undef)
     (. bean15018 setMarker (clojure.core/str v15020))))
   (clojure.core/let
    [v15020
     (:user-name m15019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15020 :com.palletops.awaze.client-builder/undef)
     (. bean15018 setUserName (clojure.core/str v15020))))
   bean15018))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateGroupRequest}
update-group-request
  [m15022]
  (clojure.core/let
   [bean15021
    (new
     com.amazonaws.services.identitymanagement.model.UpdateGroupRequest)]
   (clojure.core/let
    [v15023
     (:new-path m15022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15023 :com.palletops.awaze.client-builder/undef)
     (. bean15021 setNewPath (clojure.core/str v15023))))
   (clojure.core/let
    [v15023
     (:new-group-name
      m15022
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15023 :com.palletops.awaze.client-builder/undef)
     (. bean15021 setNewGroupName (clojure.core/str v15023))))
   (clojure.core/let
    [v15023
     (:group-name m15022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15023 :com.palletops.awaze.client-builder/undef)
     (. bean15021 setGroupName (clojure.core/str v15023))))
   bean15021))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListEntitiesForPolicyRequest}
list-entities-for-policy-request
  [m15025]
  (clojure.core/let
   [bean15024
    (new
     com.amazonaws.services.identitymanagement.model.ListEntitiesForPolicyRequest)]
   (clojure.core/let
    [v15026
     (:max-items m15025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15026 :com.palletops.awaze.client-builder/undef)
     (. bean15024 setMaxItems (clojure.core/int v15026))))
   (clojure.core/let
    [v15026
     (:marker m15025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15026 :com.palletops.awaze.client-builder/undef)
     (. bean15024 setMarker (clojure.core/str v15026))))
   (clojure.core/let
    [v15026
     (:entity-filter m15025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15026 :com.palletops.awaze.client-builder/undef)
     (.
      bean15024
      setEntityFilter
      (identitymanagement/entity-type v15026))))
   (clojure.core/let
    [v15026
     (:path-prefix m15025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15026 :com.palletops.awaze.client-builder/undef)
     (. bean15024 setPathPrefix (clojure.core/str v15026))))
   (clojure.core/let
    [v15026
     (:policy-arn m15025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15026 :com.palletops.awaze.client-builder/undef)
     (. bean15024 setPolicyArn (clojure.core/str v15026))))
   bean15024))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListPoliciesRequest}
list-policies-request
  [m15028]
  (clojure.core/let
   [bean15027
    (new
     com.amazonaws.services.identitymanagement.model.ListPoliciesRequest)]
   (clojure.core/let
    [v15029 (:scope m15028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15029 :com.palletops.awaze.client-builder/undef)
     (.
      bean15027
      setScope
      (identitymanagement/policy-scope-type v15029))))
   (clojure.core/let
    [v15029
     (:max-items m15028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15029 :com.palletops.awaze.client-builder/undef)
     (. bean15027 setMaxItems (clojure.core/int v15029))))
   (clojure.core/let
    [v15029
     (:marker m15028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15029 :com.palletops.awaze.client-builder/undef)
     (. bean15027 setMarker (clojure.core/str v15029))))
   (clojure.core/let
    [v15029
     (:path-prefix m15028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15029 :com.palletops.awaze.client-builder/undef)
     (. bean15027 setPathPrefix (clojure.core/str v15029))))
   (clojure.core/let
    [v15029
     (:only-attached m15028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15029 :com.palletops.awaze.client-builder/undef)
     (. bean15027 setOnlyAttached (clojure.core/boolean v15029))))
   bean15027))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteUserRequest}
delete-user-request
  [m15031]
  (clojure.core/let
   [bean15030
    (new
     com.amazonaws.services.identitymanagement.model.DeleteUserRequest)]
   (clojure.core/let
    [v15032
     (:user-name m15031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15032 :com.palletops.awaze.client-builder/undef)
     (. bean15030 setUserName (clojure.core/str v15032))))
   bean15030))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateSigningCertificateRequest}
update-signing-certificate-request
  [m15034]
  (clojure.core/let
   [bean15033
    (new
     com.amazonaws.services.identitymanagement.model.UpdateSigningCertificateRequest)]
   (clojure.core/let
    [v15035
     (:status m15034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15035 :com.palletops.awaze.client-builder/undef)
     (. bean15033 setStatus (clojure.core/str v15035))))
   (clojure.core/let
    [v15035
     (:certificate-id
      m15034
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15035 :com.palletops.awaze.client-builder/undef)
     (. bean15033 setCertificateId (clojure.core/str v15035))))
   (clojure.core/let
    [v15035
     (:user-name m15034 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15035 :com.palletops.awaze.client-builder/undef)
     (. bean15033 setUserName (clojure.core/str v15035))))
   bean15033))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetContextKeysForPrincipalPolicyRequest}
get-context-keys-for-principal-policy-request
  [m15037]
  (clojure.core/let
   [bean15036
    (new
     com.amazonaws.services.identitymanagement.model.GetContextKeysForPrincipalPolicyRequest)]
   (clojure.core/let
    [v15038
     (:policy-input-list
      m15037
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15038 :com.palletops.awaze.client-builder/undef)
     (.
      bean15036
      setPolicyInputList
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg15074] (clojure.core/str arg15074))
 v15038))))
   (clojure.core/let
    [v15038
     (:policy-source-arn
      m15037
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15038 :com.palletops.awaze.client-builder/undef)
     (. bean15036 setPolicySourceArn (clojure.core/str v15038))))
   bean15036))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateServerCertificateRequest}
update-server-certificate-request
  [m15040]
  (clojure.core/let
   [bean15039
    (new
     com.amazonaws.services.identitymanagement.model.UpdateServerCertificateRequest)]
   (clojure.core/let
    [v15041
     (:new-path m15040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15041 :com.palletops.awaze.client-builder/undef)
     (. bean15039 setNewPath (clojure.core/str v15041))))
   (clojure.core/let
    [v15041
     (:new-server-certificate-name
      m15040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15041 :com.palletops.awaze.client-builder/undef)
     (.
      bean15039
      setNewServerCertificateName
      (clojure.core/str v15041))))
   (clojure.core/let
    [v15041
     (:server-certificate-name
      m15040
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15041 :com.palletops.awaze.client-builder/undef)
     (. bean15039 setServerCertificateName (clojure.core/str v15041))))
   bean15039))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListAttachedUserPoliciesRequest}
list-attached-user-policies-request
  [m15043]
  (clojure.core/let
   [bean15042
    (new
     com.amazonaws.services.identitymanagement.model.ListAttachedUserPoliciesRequest)]
   (clojure.core/let
    [v15044
     (:max-items m15043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15044 :com.palletops.awaze.client-builder/undef)
     (. bean15042 setMaxItems (clojure.core/int v15044))))
   (clojure.core/let
    [v15044
     (:marker m15043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15044 :com.palletops.awaze.client-builder/undef)
     (. bean15042 setMarker (clojure.core/str v15044))))
   (clojure.core/let
    [v15044
     (:path-prefix m15043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15044 :com.palletops.awaze.client-builder/undef)
     (. bean15042 setPathPrefix (clojure.core/str v15044))))
   (clojure.core/let
    [v15044
     (:user-name m15043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15044 :com.palletops.awaze.client-builder/undef)
     (. bean15042 setUserName (clojure.core/str v15044))))
   bean15042))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreatePolicyVersionRequest}
create-policy-version-request
  [m15046]
  (clojure.core/let
   [bean15045
    (new
     com.amazonaws.services.identitymanagement.model.CreatePolicyVersionRequest)]
   (clojure.core/let
    [v15047
     (:policy-document
      m15046
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15047 :com.palletops.awaze.client-builder/undef)
     (. bean15045 setPolicyDocument (clojure.core/str v15047))))
   (clojure.core/let
    [v15047
     (:policy-arn m15046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15047 :com.palletops.awaze.client-builder/undef)
     (. bean15045 setPolicyArn (clojure.core/str v15047))))
   (clojure.core/let
    [v15047
     (:set-as-default
      m15046
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15047 :com.palletops.awaze.client-builder/undef)
     (. bean15045 setSetAsDefault (clojure.core/boolean v15047))))
   bean15045))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateLoginProfileRequest}
create-login-profile-request
  [m15049]
  (clojure.core/let
   [bean15048
    (new
     com.amazonaws.services.identitymanagement.model.CreateLoginProfileRequest)]
   (clojure.core/let
    [v15050
     (:password m15049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15050 :com.palletops.awaze.client-builder/undef)
     (. bean15048 setPassword (clojure.core/str v15050))))
   (clojure.core/let
    [v15050
     (:user-name m15049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15050 :com.palletops.awaze.client-builder/undef)
     (. bean15048 setUserName (clojure.core/str v15050))))
   (clojure.core/let
    [v15050
     (:password-reset-required
      m15049
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15050 :com.palletops.awaze.client-builder/undef)
     (.
      bean15048
      setPasswordResetRequired
      (clojure.core/boolean v15050))))
   bean15048))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.SimulatePrincipalPolicyRequest}
simulate-principal-policy-request
  [m15052]
  (clojure.core/let
   [bean15051
    (new
     com.amazonaws.services.identitymanagement.model.SimulatePrincipalPolicyRequest)]
   (clojure.core/let
    [v15053
     (:action-names m15052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15053 :com.palletops.awaze.client-builder/undef)
     (.
      bean15051
      setActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg15075] (clojure.core/str arg15075))
 v15053))))
   (clojure.core/let
    [v15053
     (:caller-arn m15052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15053 :com.palletops.awaze.client-builder/undef)
     (. bean15051 setCallerArn (clojure.core/str v15053))))
   (clojure.core/let
    [v15053
     (:marker m15052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15053 :com.palletops.awaze.client-builder/undef)
     (. bean15051 setMarker (clojure.core/str v15053))))
   (clojure.core/let
    [v15053
     (:resource-arns m15052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15053 :com.palletops.awaze.client-builder/undef)
     (.
      bean15051
      setResourceArns
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg15076] (clojure.core/str arg15076))
 v15053))))
   (clojure.core/let
    [v15053
     (:resource-owner
      m15052
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15053 :com.palletops.awaze.client-builder/undef)
     (. bean15051 setResourceOwner (clojure.core/str v15053))))
   (clojure.core/let
    [v15053
     (:policy-source-arn
      m15052
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15053 :com.palletops.awaze.client-builder/undef)
     (. bean15051 setPolicySourceArn (clojure.core/str v15053))))
   (clojure.core/let
    [v15053
     (:resource-handling-option
      m15052
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15053 :com.palletops.awaze.client-builder/undef)
     (. bean15051 setResourceHandlingOption (clojure.core/str v15053))))
   (clojure.core/let
    [v15053
     (:resource-policy
      m15052
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15053 :com.palletops.awaze.client-builder/undef)
     (. bean15051 setResourcePolicy (clojure.core/str v15053))))
   (clojure.core/let
    [v15053
     (:max-items m15052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15053 :com.palletops.awaze.client-builder/undef)
     (. bean15051 setMaxItems (clojure.core/int v15053))))
   (clojure.core/let
    [v15053
     (:context-entries
      m15052
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15053 :com.palletops.awaze.client-builder/undef)
     (.
      bean15051
      setContextEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg15077]
  (identitymanagement/context-entry arg15077))
 v15053))))
   (clojure.core/let
    [v15053
     (:policy-input-list
      m15052
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15053 :com.palletops.awaze.client-builder/undef)
     (.
      bean15051
      setPolicyInputList
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg15078] (clojure.core/str arg15078))
 v15053))))
   bean15051))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateOpenIDConnectProviderRequest}
create-open-idconnect-provider-request
  [m15055]
  (clojure.core/let
   [bean15054
    (new
     com.amazonaws.services.identitymanagement.model.CreateOpenIDConnectProviderRequest)]
   (clojure.core/let
    [v15056 (:url m15055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15056 :com.palletops.awaze.client-builder/undef)
     (. bean15054 setUrl (clojure.core/str v15056))))
   (clojure.core/let
    [v15056
     (:client-idlist m15055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15056 :com.palletops.awaze.client-builder/undef)
     (.
      bean15054
      setClientIDList
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg15079] (clojure.core/str arg15079))
 v15056))))
   (clojure.core/let
    [v15056
     (:thumbprint-list
      m15055
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15056 :com.palletops.awaze.client-builder/undef)
     (.
      bean15054
      setThumbprintList
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg15080] (clojure.core/str arg15080))
 v15056))))
   bean15054))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.AttachRolePolicyRequest}
attach-role-policy-request
  [m15058]
  (clojure.core/let
   [bean15057
    (new
     com.amazonaws.services.identitymanagement.model.AttachRolePolicyRequest)]
   (clojure.core/let
    [v15059
     (:role-name m15058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15059 :com.palletops.awaze.client-builder/undef)
     (. bean15057 setRoleName (clojure.core/str v15059))))
   (clojure.core/let
    [v15059
     (:policy-arn m15058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15059 :com.palletops.awaze.client-builder/undef)
     (. bean15057 setPolicyArn (clojure.core/str v15059))))
   bean15057))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetGroupPolicyRequest}
get-group-policy-request
  [m15061]
  (clojure.core/let
   [bean15060
    (new
     com.amazonaws.services.identitymanagement.model.GetGroupPolicyRequest)]
   (clojure.core/let
    [v15062
     (:group-name m15061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15062 :com.palletops.awaze.client-builder/undef)
     (. bean15060 setGroupName (clojure.core/str v15062))))
   (clojure.core/let
    [v15062
     (:policy-name m15061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15062 :com.palletops.awaze.client-builder/undef)
     (. bean15060 setPolicyName (clojure.core/str v15062))))
   bean15060))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DetachUserPolicyRequest}
detach-user-policy-request
  [m15064]
  (clojure.core/let
   [bean15063
    (new
     com.amazonaws.services.identitymanagement.model.DetachUserPolicyRequest)]
   (clojure.core/let
    [v15065
     (:user-name m15064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15065 :com.palletops.awaze.client-builder/undef)
     (. bean15063 setUserName (clojure.core/str v15065))))
   (clojure.core/let
    [v15065
     (:policy-arn m15064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v15065 :com.palletops.awaze.client-builder/undef)
     (. bean15063 setPolicyArn (clojure.core/str v15065))))
   bean15063)))
