(ns
 com.palletops.awaze.autoscaling
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.autoscaling :as autoscaling]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :autoscaling
  [___1733__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1734__auto__]
  (new
   com.amazonaws.services.autoscaling.AmazonAutoScalingClient
   credentials__1734__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Ebs}
ebs
  [m6363]
  (clojure.core/let
   [bean6362 (new com.amazonaws.services.autoscaling.model.Ebs)]
   (clojure.core/let
    [v6364
     (:encrypted m6363 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6364 :com.palletops.awaze.client-builder/undef)
     (. bean6362 setEncrypted (clojure.core/boolean v6364))))
   (clojure.core/let
    [v6364
     (:snapshot-id m6363 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6364 :com.palletops.awaze.client-builder/undef)
     (. bean6362 setSnapshotId (clojure.core/str v6364))))
   (clojure.core/let
    [v6364
     (:volume-type m6363 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6364 :com.palletops.awaze.client-builder/undef)
     (. bean6362 setVolumeType (clojure.core/str v6364))))
   (clojure.core/let
    [v6364 (:iops m6363 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6364 :com.palletops.awaze.client-builder/undef)
     (. bean6362 setIops (clojure.core/int v6364))))
   (clojure.core/let
    [v6364
     (:delete-on-termination
      m6363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6364 :com.palletops.awaze.client-builder/undef)
     (. bean6362 setDeleteOnTermination (clojure.core/boolean v6364))))
   (clojure.core/let
    [v6364
     (:volume-size m6363 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6364 :com.palletops.awaze.client-builder/undef)
     (. bean6362 setVolumeSize (clojure.core/int v6364))))
   bean6362))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Tag}
tag
  [m6366]
  (clojure.core/let
   [bean6365 (new com.amazonaws.services.autoscaling.model.Tag)]
   (clojure.core/let
    [v6367 (:value m6366 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6367 :com.palletops.awaze.client-builder/undef)
     (. bean6365 setValue (clojure.core/str v6367))))
   (clojure.core/let
    [v6367
     (:resource-type m6366 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6367 :com.palletops.awaze.client-builder/undef)
     (. bean6365 setResourceType (clojure.core/str v6367))))
   (clojure.core/let
    [v6367 (:key m6366 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6367 :com.palletops.awaze.client-builder/undef)
     (. bean6365 setKey (clojure.core/str v6367))))
   (clojure.core/let
    [v6367
     (:resource-id m6366 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6367 :com.palletops.awaze.client-builder/undef)
     (. bean6365 setResourceId (clojure.core/str v6367))))
   (clojure.core/let
    [v6367
     (:propagate-at-launch
      m6366
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6367 :com.palletops.awaze.client-builder/undef)
     (. bean6365 setPropagateAtLaunch (clojure.core/boolean v6367))))
   bean6365))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.StepAdjustment}
step-adjustment
  [m6369]
  (clojure.core/let
   [bean6368
    (new com.amazonaws.services.autoscaling.model.StepAdjustment)]
   (clojure.core/let
    [v6370
     (:scaling-adjustment
      m6369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6370 :com.palletops.awaze.client-builder/undef)
     (. bean6368 setScalingAdjustment (clojure.core/int v6370))))
   (clojure.core/let
    [v6370
     (:metric-interval-lower-bound
      m6369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6370 :com.palletops.awaze.client-builder/undef)
     (.
      bean6368
      setMetricIntervalLowerBound
      (clojure.core/double v6370))))
   (clojure.core/let
    [v6370
     (:metric-interval-upper-bound
      m6369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6370 :com.palletops.awaze.client-builder/undef)
     (.
      bean6368
      setMetricIntervalUpperBound
      (clojure.core/double v6370))))
   bean6368))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Filter}
filter
  [m6372]
  (clojure.core/let
   [bean6371 (new com.amazonaws.services.autoscaling.model.Filter)]
   (clojure.core/let
    [v6373 (:name m6372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6373 :com.palletops.awaze.client-builder/undef)
     (. bean6371 setName (clojure.core/str v6373))))
   (clojure.core/let
    [v6373 (:values m6372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6373 :com.palletops.awaze.client-builder/undef)
     (.
      bean6371
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6527] (clojure.core/str arg6527))
 v6373))))
   bean6371))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.InstanceMonitoring}
instance-monitoring
  [m6375]
  (clojure.core/let
   [bean6374
    (new com.amazonaws.services.autoscaling.model.InstanceMonitoring)]
   (clojure.core/let
    [v6376 (:enabled m6375 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6376 :com.palletops.awaze.client-builder/undef)
     (. bean6374 setEnabled (clojure.core/boolean v6376))))
   bean6374))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.BlockDeviceMapping}
block-device-mapping
  [m6378]
  (clojure.core/let
   [bean6377
    (new com.amazonaws.services.autoscaling.model.BlockDeviceMapping)]
   (clojure.core/let
    [v6379
     (:device-name m6378 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6379 :com.palletops.awaze.client-builder/undef)
     (. bean6377 setDeviceName (clojure.core/str v6379))))
   (clojure.core/let
    [v6379 (:ebs m6378 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6379 :com.palletops.awaze.client-builder/undef)
     (. bean6377 setEbs (autoscaling/ebs v6379))))
   (clojure.core/let
    [v6379
     (:virtual-name m6378 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6379 :com.palletops.awaze.client-builder/undef)
     (. bean6377 setVirtualName (clojure.core/str v6379))))
   (clojure.core/let
    [v6379
     (:no-device m6378 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6379 :com.palletops.awaze.client-builder/undef)
     (. bean6377 setNoDevice (clojure.core/boolean v6379))))
   bean6377))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest}
update-auto-scaling-group-request
  [m6381]
  (clojure.core/let
   [bean6380
    (new
     com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest)]
   (clojure.core/let
    [v6382
     (:health-check-type
      m6381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setHealthCheckType (clojure.core/str v6382))))
   (clojure.core/let
    [v6382
     (:new-instances-protected-from-scale-in
      m6381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (.
      bean6380
      setNewInstancesProtectedFromScaleIn
      (clojure.core/boolean v6382))))
   (clojure.core/let
    [v6382
     (:availability-zones
      m6381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (.
      bean6380
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6528] (clojure.core/str arg6528))
 v6382))))
   (clojure.core/let
    [v6382
     (:desired-capacity
      m6381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setDesiredCapacity (clojure.core/int v6382))))
   (clojure.core/let
    [v6382
     (:placement-group
      m6381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setPlacementGroup (clojure.core/str v6382))))
   (clojure.core/let
    [v6382
     (:min-size m6381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setMinSize (clojure.core/int v6382))))
   (clojure.core/let
    [v6382
     (:launch-configuration-name
      m6381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setLaunchConfigurationName (clojure.core/str v6382))))
   (clojure.core/let
    [v6382
     (:health-check-grace-period
      m6381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setHealthCheckGracePeriod (clojure.core/int v6382))))
   (clojure.core/let
    [v6382
     (:termination-policies
      m6381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (.
      bean6380
      setTerminationPolicies
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6529] (clojure.core/str arg6529))
 v6382))))
   (clojure.core/let
    [v6382
     (:auto-scaling-group-name
      m6381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setAutoScalingGroupName (clojure.core/str v6382))))
   (clojure.core/let
    [v6382
     (:max-size m6381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setMaxSize (clojure.core/int v6382))))
   (clojure.core/let
    [v6382
     (:vpczone-identifier
      m6381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setVPCZoneIdentifier (clojure.core/str v6382))))
   (clojure.core/let
    [v6382
     (:default-cooldown
      m6381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setDefaultCooldown (clojure.core/int v6382))))
   bean6380))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.AttachLoadBalancersRequest}
attach-load-balancers-request
  [m6384]
  (clojure.core/let
   [bean6383
    (new
     com.amazonaws.services.autoscaling.model.AttachLoadBalancersRequest)]
   (clojure.core/let
    [v6385
     (:load-balancer-names
      m6384
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6385 :com.palletops.awaze.client-builder/undef)
     (.
      bean6383
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6530] (clojure.core/str arg6530))
 v6385))))
   (clojure.core/let
    [v6385
     (:auto-scaling-group-name
      m6384
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6385 :com.palletops.awaze.client-builder/undef)
     (. bean6383 setAutoScalingGroupName (clojure.core/str v6385))))
   bean6383))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest}
create-or-update-tags-request
  [m6387]
  (clojure.core/let
   [bean6386
    (new
     com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest)]
   (clojure.core/let
    [v6388 (:tags m6387 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6388 :com.palletops.awaze.client-builder/undef)
     (.
      bean6386
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6531] (autoscaling/tag arg6531))
 v6388))))
   bean6386))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ResumeProcessesRequest}
resume-processes-request
  [m6390]
  (clojure.core/let
   [bean6389
    (new
     com.amazonaws.services.autoscaling.model.ResumeProcessesRequest)]
   (clojure.core/let
    [v6391
     (:auto-scaling-group-name
      m6390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6391 :com.palletops.awaze.client-builder/undef)
     (. bean6389 setAutoScalingGroupName (clojure.core/str v6391))))
   (clojure.core/let
    [v6391
     (:scaling-processes
      m6390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6391 :com.palletops.awaze.client-builder/undef)
     (.
      bean6389
      setScalingProcesses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6532] (clojure.core/str arg6532))
 v6391))))
   bean6389))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest}
terminate-instance-in-auto-scaling-group-request
  [m6393]
  (clojure.core/let
   [bean6392
    (new
     com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest)]
   (clojure.core/let
    [v6394
     (:instance-id m6393 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6394 :com.palletops.awaze.client-builder/undef)
     (. bean6392 setInstanceId (clojure.core/str v6394))))
   (clojure.core/let
    [v6394
     (:should-decrement-desired-capacity
      m6393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6394 :com.palletops.awaze.client-builder/undef)
     (.
      bean6392
      setShouldDecrementDesiredCapacity
      (clojure.core/boolean v6394))))
   bean6392))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest}
delete-auto-scaling-group-request
  [m6396]
  (clojure.core/let
   [bean6395
    (new
     com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest)]
   (clojure.core/let
    [v6397
     (:auto-scaling-group-name
      m6396
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6397 :com.palletops.awaze.client-builder/undef)
     (. bean6395 setAutoScalingGroupName (clojure.core/str v6397))))
   (clojure.core/let
    [v6397
     (:force-delete m6396 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6397 :com.palletops.awaze.client-builder/undef)
     (. bean6395 setForceDelete (clojure.core/boolean v6397))))
   bean6395))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLoadBalancersRequest}
describe-load-balancers-request
  [m6399]
  (clojure.core/let
   [bean6398
    (new
     com.amazonaws.services.autoscaling.model.DescribeLoadBalancersRequest)]
   (clojure.core/let
    [v6400
     (:next-token m6399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6400 :com.palletops.awaze.client-builder/undef)
     (. bean6398 setNextToken (clojure.core/str v6400))))
   (clojure.core/let
    [v6400
     (:max-records m6399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6400 :com.palletops.awaze.client-builder/undef)
     (. bean6398 setMaxRecords (clojure.core/int v6400))))
   (clojure.core/let
    [v6400
     (:auto-scaling-group-name
      m6399
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6400 :com.palletops.awaze.client-builder/undef)
     (. bean6398 setAutoScalingGroupName (clojure.core/str v6400))))
   bean6398))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest}
disable-metrics-collection-request
  [m6402]
  (clojure.core/let
   [bean6401
    (new
     com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest)]
   (clojure.core/let
    [v6403
     (:auto-scaling-group-name
      m6402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6403 :com.palletops.awaze.client-builder/undef)
     (. bean6401 setAutoScalingGroupName (clojure.core/str v6403))))
   (clojure.core/let
    [v6403 (:metrics m6402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6403 :com.palletops.awaze.client-builder/undef)
     (.
      bean6401
      setMetrics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6533] (clojure.core/str arg6533))
 v6403))))
   bean6401))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest}
describe-scheduled-actions-request
  [m6405]
  (clojure.core/let
   [bean6404
    (new
     com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest)]
   (clojure.core/let
    [v6406
     (:next-token m6405 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6406 :com.palletops.awaze.client-builder/undef)
     (. bean6404 setNextToken (clojure.core/str v6406))))
   (clojure.core/let
    [v6406
     (:start-time m6405 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6406 :com.palletops.awaze.client-builder/undef)
     (.
      bean6404
      setStartTime
      (com.palletops.awaze.common/to-date v6406))))
   (clojure.core/let
    [v6406
     (:end-time m6405 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6406 :com.palletops.awaze.client-builder/undef)
     (.
      bean6404
      setEndTime
      (com.palletops.awaze.common/to-date v6406))))
   (clojure.core/let
    [v6406
     (:max-records m6405 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6406 :com.palletops.awaze.client-builder/undef)
     (. bean6404 setMaxRecords (clojure.core/int v6406))))
   (clojure.core/let
    [v6406
     (:auto-scaling-group-name
      m6405
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6406 :com.palletops.awaze.client-builder/undef)
     (. bean6404 setAutoScalingGroupName (clojure.core/str v6406))))
   (clojure.core/let
    [v6406
     (:scheduled-action-names
      m6405
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6406 :com.palletops.awaze.client-builder/undef)
     (.
      bean6404
      setScheduledActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6534] (clojure.core/str arg6534))
 v6406))))
   bean6404))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest}
delete-notification-configuration-request
  [m6408]
  (clojure.core/let
   [bean6407
    (new
     com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest)]
   (clojure.core/let
    [v6409
     (:auto-scaling-group-name
      m6408
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6409 :com.palletops.awaze.client-builder/undef)
     (. bean6407 setAutoScalingGroupName (clojure.core/str v6409))))
   (clojure.core/let
    [v6409
     (:topic-arn m6408 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6409 :com.palletops.awaze.client-builder/undef)
     (. bean6407 setTopicARN (clojure.core/str v6409))))
   bean6407))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest}
put-scaling-policy-request
  [m6411]
  (clojure.core/let
   [bean6410
    (new
     com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest)]
   (clojure.core/let
    [v6412
     (:policy-type m6411 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6412 :com.palletops.awaze.client-builder/undef)
     (. bean6410 setPolicyType (clojure.core/str v6412))))
   (clojure.core/let
    [v6412
     (:policy-name m6411 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6412 :com.palletops.awaze.client-builder/undef)
     (. bean6410 setPolicyName (clojure.core/str v6412))))
   (clojure.core/let
    [v6412
     (:adjustment-type
      m6411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6412 :com.palletops.awaze.client-builder/undef)
     (. bean6410 setAdjustmentType (clojure.core/str v6412))))
   (clojure.core/let
    [v6412
     (:step-adjustments
      m6411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6412 :com.palletops.awaze.client-builder/undef)
     (.
      bean6410
      setStepAdjustments
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6535] (autoscaling/step-adjustment arg6535))
 v6412))))
   (clojure.core/let
    [v6412
     (:min-adjustment-magnitude
      m6411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6412 :com.palletops.awaze.client-builder/undef)
     (. bean6410 setMinAdjustmentMagnitude (clojure.core/int v6412))))
   (clojure.core/let
    [v6412
     (:scaling-adjustment
      m6411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6412 :com.palletops.awaze.client-builder/undef)
     (. bean6410 setScalingAdjustment (clojure.core/int v6412))))
   (clojure.core/let
    [v6412
     (:auto-scaling-group-name
      m6411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6412 :com.palletops.awaze.client-builder/undef)
     (. bean6410 setAutoScalingGroupName (clojure.core/str v6412))))
   (clojure.core/let
    [v6412
     (:cooldown m6411 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6412 :com.palletops.awaze.client-builder/undef)
     (. bean6410 setCooldown (clojure.core/int v6412))))
   (clojure.core/let
    [v6412
     (:metric-aggregation-type
      m6411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6412 :com.palletops.awaze.client-builder/undef)
     (. bean6410 setMetricAggregationType (clojure.core/str v6412))))
   (clojure.core/let
    [v6412
     (:estimated-instance-warmup
      m6411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6412 :com.palletops.awaze.client-builder/undef)
     (. bean6410 setEstimatedInstanceWarmup (clojure.core/int v6412))))
   (clojure.core/let
    [v6412
     (:min-adjustment-step
      m6411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6412 :com.palletops.awaze.client-builder/undef)
     (. bean6410 setMinAdjustmentStep (clojure.core/int v6412))))
   bean6410))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest}
describe-scaling-activities-request
  [m6414]
  (clojure.core/let
   [bean6413
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest)]
   (clojure.core/let
    [v6415
     (:next-token m6414 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6415 :com.palletops.awaze.client-builder/undef)
     (. bean6413 setNextToken (clojure.core/str v6415))))
   (clojure.core/let
    [v6415
     (:max-records m6414 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6415 :com.palletops.awaze.client-builder/undef)
     (. bean6413 setMaxRecords (clojure.core/int v6415))))
   (clojure.core/let
    [v6415
     (:auto-scaling-group-name
      m6414
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6415 :com.palletops.awaze.client-builder/undef)
     (. bean6413 setAutoScalingGroupName (clojure.core/str v6415))))
   (clojure.core/let
    [v6415
     (:activity-ids m6414 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6415 :com.palletops.awaze.client-builder/undef)
     (.
      bean6413
      setActivityIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6536] (clojure.core/str arg6536))
 v6415))))
   bean6413))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksRequest}
describe-lifecycle-hooks-request
  [m6417]
  (clojure.core/let
   [bean6416
    (new
     com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksRequest)]
   (clojure.core/let
    [v6418
     (:auto-scaling-group-name
      m6417
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6418 :com.palletops.awaze.client-builder/undef)
     (. bean6416 setAutoScalingGroupName (clojure.core/str v6418))))
   (clojure.core/let
    [v6418
     (:lifecycle-hook-names
      m6417
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6418 :com.palletops.awaze.client-builder/undef)
     (.
      bean6416
      setLifecycleHookNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6537] (clojure.core/str arg6537))
 v6418))))
   bean6416))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest}
delete-launch-configuration-request
  [m6420]
  (clojure.core/let
   [bean6419
    (new
     com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest)]
   (clojure.core/let
    [v6421
     (:launch-configuration-name
      m6420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6421 :com.palletops.awaze.client-builder/undef)
     (. bean6419 setLaunchConfigurationName (clojure.core/str v6421))))
   bean6419))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeletePolicyRequest}
delete-policy-request
  [m6423]
  (clojure.core/let
   [bean6422
    (new com.amazonaws.services.autoscaling.model.DeletePolicyRequest)]
   (clojure.core/let
    [v6424
     (:policy-name m6423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6424 :com.palletops.awaze.client-builder/undef)
     (. bean6422 setPolicyName (clojure.core/str v6424))))
   (clojure.core/let
    [v6424
     (:auto-scaling-group-name
      m6423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6424 :com.palletops.awaze.client-builder/undef)
     (. bean6422 setAutoScalingGroupName (clojure.core/str v6424))))
   bean6422))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest}
create-auto-scaling-group-request
  [m6426]
  (clojure.core/let
   [bean6425
    (new
     com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest)]
   (clojure.core/let
    [v6427
     (:health-check-type
      m6426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (. bean6425 setHealthCheckType (clojure.core/str v6427))))
   (clojure.core/let
    [v6427
     (:new-instances-protected-from-scale-in
      m6426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (.
      bean6425
      setNewInstancesProtectedFromScaleIn
      (clojure.core/boolean v6427))))
   (clojure.core/let
    [v6427
     (:availability-zones
      m6426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (.
      bean6425
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6538] (clojure.core/str arg6538))
 v6427))))
   (clojure.core/let
    [v6427
     (:desired-capacity
      m6426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (. bean6425 setDesiredCapacity (clojure.core/int v6427))))
   (clojure.core/let
    [v6427
     (:instance-id m6426 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (. bean6425 setInstanceId (clojure.core/str v6427))))
   (clojure.core/let
    [v6427
     (:placement-group
      m6426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (. bean6425 setPlacementGroup (clojure.core/str v6427))))
   (clojure.core/let
    [v6427
     (:min-size m6426 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (. bean6425 setMinSize (clojure.core/int v6427))))
   (clojure.core/let
    [v6427 (:tags m6426 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (.
      bean6425
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6539] (autoscaling/tag arg6539))
 v6427))))
   (clojure.core/let
    [v6427
     (:load-balancer-names
      m6426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (.
      bean6425
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6540] (clojure.core/str arg6540))
 v6427))))
   (clojure.core/let
    [v6427
     (:launch-configuration-name
      m6426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (. bean6425 setLaunchConfigurationName (clojure.core/str v6427))))
   (clojure.core/let
    [v6427
     (:health-check-grace-period
      m6426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (. bean6425 setHealthCheckGracePeriod (clojure.core/int v6427))))
   (clojure.core/let
    [v6427
     (:termination-policies
      m6426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (.
      bean6425
      setTerminationPolicies
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6541] (clojure.core/str arg6541))
 v6427))))
   (clojure.core/let
    [v6427
     (:auto-scaling-group-name
      m6426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (. bean6425 setAutoScalingGroupName (clojure.core/str v6427))))
   (clojure.core/let
    [v6427
     (:max-size m6426 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (. bean6425 setMaxSize (clojure.core/int v6427))))
   (clojure.core/let
    [v6427
     (:vpczone-identifier
      m6426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (. bean6425 setVPCZoneIdentifier (clojure.core/str v6427))))
   (clojure.core/let
    [v6427
     (:default-cooldown
      m6426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6427 :com.palletops.awaze.client-builder/undef)
     (. bean6425 setDefaultCooldown (clojure.core/int v6427))))
   bean6425))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest}
describe-scaling-process-types-request
  [m6429]
  (clojure.core/let
   [bean6428
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest)]
   bean6428))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest}
describe-account-limits-request
  [m6432]
  (clojure.core/let
   [bean6431
    (new
     com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest)]
   bean6431))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest}
delete-scheduled-action-request
  [m6435]
  (clojure.core/let
   [bean6434
    (new
     com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest)]
   (clojure.core/let
    [v6436
     (:auto-scaling-group-name
      m6435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6436 :com.palletops.awaze.client-builder/undef)
     (. bean6434 setAutoScalingGroupName (clojure.core/str v6436))))
   (clojure.core/let
    [v6436
     (:scheduled-action-name
      m6435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6436 :com.palletops.awaze.client-builder/undef)
     (. bean6434 setScheduledActionName (clojure.core/str v6436))))
   bean6434))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest}
describe-notification-configurations-request
  [m6438]
  (clojure.core/let
   [bean6437
    (new
     com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest)]
   (clojure.core/let
    [v6439
     (:next-token m6438 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6439 :com.palletops.awaze.client-builder/undef)
     (. bean6437 setNextToken (clojure.core/str v6439))))
   (clojure.core/let
    [v6439
     (:max-records m6438 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6439 :com.palletops.awaze.client-builder/undef)
     (. bean6437 setMaxRecords (clojure.core/int v6439))))
   (clojure.core/let
    [v6439
     (:auto-scaling-group-names
      m6438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6439 :com.palletops.awaze.client-builder/undef)
     (.
      bean6437
      setAutoScalingGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6542] (clojure.core/str arg6542))
 v6439))))
   bean6437))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest}
describe-adjustment-types-request
  [m6441]
  (clojure.core/let
   [bean6440
    (new
     com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest)]
   bean6440))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest}
describe-auto-scaling-instances-request
  [m6444]
  (clojure.core/let
   [bean6443
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest)]
   (clojure.core/let
    [v6445
     (:instance-ids m6444 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6445 :com.palletops.awaze.client-builder/undef)
     (.
      bean6443
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6543] (clojure.core/str arg6543))
 v6445))))
   (clojure.core/let
    [v6445
     (:next-token m6444 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6445 :com.palletops.awaze.client-builder/undef)
     (. bean6443 setNextToken (clojure.core/str v6445))))
   (clojure.core/let
    [v6445
     (:max-records m6444 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6445 :com.palletops.awaze.client-builder/undef)
     (. bean6443 setMaxRecords (clojure.core/int v6445))))
   bean6443))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest}
describe-termination-policy-types-request
  [m6447]
  (clojure.core/let
   [bean6446
    (new
     com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest)]
   bean6446))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.AttachInstancesRequest}
attach-instances-request
  [m6450]
  (clojure.core/let
   [bean6449
    (new
     com.amazonaws.services.autoscaling.model.AttachInstancesRequest)]
   (clojure.core/let
    [v6451
     (:instance-ids m6450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6451 :com.palletops.awaze.client-builder/undef)
     (.
      bean6449
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6544] (clojure.core/str arg6544))
 v6451))))
   (clojure.core/let
    [v6451
     (:auto-scaling-group-name
      m6450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6451 :com.palletops.awaze.client-builder/undef)
     (. bean6449 setAutoScalingGroupName (clojure.core/str v6451))))
   bean6449))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeTagsRequest}
describe-tags-request
  [m6453]
  (clojure.core/let
   [bean6452
    (new com.amazonaws.services.autoscaling.model.DescribeTagsRequest)]
   (clojure.core/let
    [v6454 (:filters m6453 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6454 :com.palletops.awaze.client-builder/undef)
     (.
      bean6452
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6545] (autoscaling/filter arg6545))
 v6454))))
   (clojure.core/let
    [v6454
     (:next-token m6453 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6454 :com.palletops.awaze.client-builder/undef)
     (. bean6452 setNextToken (clojure.core/str v6454))))
   (clojure.core/let
    [v6454
     (:max-records m6453 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6454 :com.palletops.awaze.client-builder/undef)
     (. bean6452 setMaxRecords (clojure.core/int v6454))))
   bean6452))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteTagsRequest}
delete-tags-request
  [m6456]
  (clojure.core/let
   [bean6455
    (new com.amazonaws.services.autoscaling.model.DeleteTagsRequest)]
   (clojure.core/let
    [v6457 (:tags m6456 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6457 :com.palletops.awaze.client-builder/undef)
     (.
      bean6455
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6546] (autoscaling/tag arg6546))
 v6457))))
   bean6455))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest}
put-notification-configuration-request
  [m6459]
  (clojure.core/let
   [bean6458
    (new
     com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest)]
   (clojure.core/let
    [v6460
     (:auto-scaling-group-name
      m6459
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6460 :com.palletops.awaze.client-builder/undef)
     (. bean6458 setAutoScalingGroupName (clojure.core/str v6460))))
   (clojure.core/let
    [v6460
     (:topic-arn m6459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6460 :com.palletops.awaze.client-builder/undef)
     (. bean6458 setTopicARN (clojure.core/str v6460))))
   (clojure.core/let
    [v6460
     (:notification-types
      m6459
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6460 :com.palletops.awaze.client-builder/undef)
     (.
      bean6458
      setNotificationTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6547] (clojure.core/str arg6547))
 v6460))))
   bean6458))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DetachLoadBalancersRequest}
detach-load-balancers-request
  [m6462]
  (clojure.core/let
   [bean6461
    (new
     com.amazonaws.services.autoscaling.model.DetachLoadBalancersRequest)]
   (clojure.core/let
    [v6463
     (:load-balancer-names
      m6462
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6463 :com.palletops.awaze.client-builder/undef)
     (.
      bean6461
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6548] (clojure.core/str arg6548))
 v6463))))
   (clojure.core/let
    [v6463
     (:auto-scaling-group-name
      m6462
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6463 :com.palletops.awaze.client-builder/undef)
     (. bean6461 setAutoScalingGroupName (clojure.core/str v6463))))
   bean6461))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest}
describe-auto-scaling-notification-types-request
  [m6465]
  (clojure.core/let
   [bean6464
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest)]
   bean6464))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetInstanceProtectionRequest}
set-instance-protection-request
  [m6468]
  (clojure.core/let
   [bean6467
    (new
     com.amazonaws.services.autoscaling.model.SetInstanceProtectionRequest)]
   (clojure.core/let
    [v6469
     (:instance-ids m6468 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6469 :com.palletops.awaze.client-builder/undef)
     (.
      bean6467
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6549] (clojure.core/str arg6549))
 v6469))))
   (clojure.core/let
    [v6469
     (:auto-scaling-group-name
      m6468
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6469 :com.palletops.awaze.client-builder/undef)
     (. bean6467 setAutoScalingGroupName (clojure.core/str v6469))))
   (clojure.core/let
    [v6469
     (:protected-from-scale-in
      m6468
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6469 :com.palletops.awaze.client-builder/undef)
     (. bean6467 setProtectedFromScaleIn (clojure.core/boolean v6469))))
   bean6467))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CompleteLifecycleActionRequest}
complete-lifecycle-action-request
  [m6471]
  (clojure.core/let
   [bean6470
    (new
     com.amazonaws.services.autoscaling.model.CompleteLifecycleActionRequest)]
   (clojure.core/let
    [v6472
     (:instance-id m6471 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6472 :com.palletops.awaze.client-builder/undef)
     (. bean6470 setInstanceId (clojure.core/str v6472))))
   (clojure.core/let
    [v6472
     (:auto-scaling-group-name
      m6471
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6472 :com.palletops.awaze.client-builder/undef)
     (. bean6470 setAutoScalingGroupName (clojure.core/str v6472))))
   (clojure.core/let
    [v6472
     (:lifecycle-hook-name
      m6471
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6472 :com.palletops.awaze.client-builder/undef)
     (. bean6470 setLifecycleHookName (clojure.core/str v6472))))
   (clojure.core/let
    [v6472
     (:lifecycle-action-token
      m6471
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6472 :com.palletops.awaze.client-builder/undef)
     (. bean6470 setLifecycleActionToken (clojure.core/str v6472))))
   (clojure.core/let
    [v6472
     (:lifecycle-action-result
      m6471
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6472 :com.palletops.awaze.client-builder/undef)
     (. bean6470 setLifecycleActionResult (clojure.core/str v6472))))
   bean6470))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SuspendProcessesRequest}
suspend-processes-request
  [m6474]
  (clojure.core/let
   [bean6473
    (new
     com.amazonaws.services.autoscaling.model.SuspendProcessesRequest)]
   (clojure.core/let
    [v6475
     (:auto-scaling-group-name
      m6474
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6475 :com.palletops.awaze.client-builder/undef)
     (. bean6473 setAutoScalingGroupName (clojure.core/str v6475))))
   (clojure.core/let
    [v6475
     (:scaling-processes
      m6474
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6475 :com.palletops.awaze.client-builder/undef)
     (.
      bean6473
      setScalingProcesses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6550] (clojure.core/str arg6550))
 v6475))))
   bean6473))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest}
describe-auto-scaling-groups-request
  [m6477]
  (clojure.core/let
   [bean6476
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest)]
   (clojure.core/let
    [v6478
     (:next-token m6477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6478 :com.palletops.awaze.client-builder/undef)
     (. bean6476 setNextToken (clojure.core/str v6478))))
   (clojure.core/let
    [v6478
     (:max-records m6477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6478 :com.palletops.awaze.client-builder/undef)
     (. bean6476 setMaxRecords (clojure.core/int v6478))))
   (clojure.core/let
    [v6478
     (:auto-scaling-group-names
      m6477
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6478 :com.palletops.awaze.client-builder/undef)
     (.
      bean6476
      setAutoScalingGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6551] (clojure.core/str arg6551))
 v6478))))
   bean6476))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutLifecycleHookRequest}
put-lifecycle-hook-request
  [m6480]
  (clojure.core/let
   [bean6479
    (new
     com.amazonaws.services.autoscaling.model.PutLifecycleHookRequest)]
   (clojure.core/let
    [v6481
     (:auto-scaling-group-name
      m6480
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6481 :com.palletops.awaze.client-builder/undef)
     (. bean6479 setAutoScalingGroupName (clojure.core/str v6481))))
   (clojure.core/let
    [v6481
     (:lifecycle-hook-name
      m6480
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6481 :com.palletops.awaze.client-builder/undef)
     (. bean6479 setLifecycleHookName (clojure.core/str v6481))))
   (clojure.core/let
    [v6481
     (:lifecycle-transition
      m6480
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6481 :com.palletops.awaze.client-builder/undef)
     (. bean6479 setLifecycleTransition (clojure.core/str v6481))))
   (clojure.core/let
    [v6481
     (:role-arn m6480 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6481 :com.palletops.awaze.client-builder/undef)
     (. bean6479 setRoleARN (clojure.core/str v6481))))
   (clojure.core/let
    [v6481
     (:notification-target-arn
      m6480
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6481 :com.palletops.awaze.client-builder/undef)
     (. bean6479 setNotificationTargetARN (clojure.core/str v6481))))
   (clojure.core/let
    [v6481
     (:notification-metadata
      m6480
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6481 :com.palletops.awaze.client-builder/undef)
     (. bean6479 setNotificationMetadata (clojure.core/str v6481))))
   (clojure.core/let
    [v6481
     (:heartbeat-timeout
      m6480
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6481 :com.palletops.awaze.client-builder/undef)
     (. bean6479 setHeartbeatTimeout (clojure.core/int v6481))))
   (clojure.core/let
    [v6481
     (:default-result m6480 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6481 :com.palletops.awaze.client-builder/undef)
     (. bean6479 setDefaultResult (clojure.core/str v6481))))
   bean6479))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ExecutePolicyRequest}
execute-policy-request
  [m6483]
  (clojure.core/let
   [bean6482
    (new
     com.amazonaws.services.autoscaling.model.ExecutePolicyRequest)]
   (clojure.core/let
    [v6484
     (:policy-name m6483 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6484 :com.palletops.awaze.client-builder/undef)
     (. bean6482 setPolicyName (clojure.core/str v6484))))
   (clojure.core/let
    [v6484
     (:auto-scaling-group-name
      m6483
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6484 :com.palletops.awaze.client-builder/undef)
     (. bean6482 setAutoScalingGroupName (clojure.core/str v6484))))
   (clojure.core/let
    [v6484
     (:honor-cooldown m6483 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6484 :com.palletops.awaze.client-builder/undef)
     (. bean6482 setHonorCooldown (clojure.core/boolean v6484))))
   (clojure.core/let
    [v6484
     (:metric-value m6483 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6484 :com.palletops.awaze.client-builder/undef)
     (. bean6482 setMetricValue (clojure.core/double v6484))))
   (clojure.core/let
    [v6484
     (:breach-threshold
      m6483
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6484 :com.palletops.awaze.client-builder/undef)
     (. bean6482 setBreachThreshold (clojure.core/double v6484))))
   bean6482))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest}
record-lifecycle-action-heartbeat-request
  [m6486]
  (clojure.core/let
   [bean6485
    (new
     com.amazonaws.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest)]
   (clojure.core/let
    [v6487
     (:instance-id m6486 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6487 :com.palletops.awaze.client-builder/undef)
     (. bean6485 setInstanceId (clojure.core/str v6487))))
   (clojure.core/let
    [v6487
     (:auto-scaling-group-name
      m6486
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6487 :com.palletops.awaze.client-builder/undef)
     (. bean6485 setAutoScalingGroupName (clojure.core/str v6487))))
   (clojure.core/let
    [v6487
     (:lifecycle-hook-name
      m6486
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6487 :com.palletops.awaze.client-builder/undef)
     (. bean6485 setLifecycleHookName (clojure.core/str v6487))))
   (clojure.core/let
    [v6487
     (:lifecycle-action-token
      m6486
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6487 :com.palletops.awaze.client-builder/undef)
     (. bean6485 setLifecycleActionToken (clojure.core/str v6487))))
   bean6485))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ExitStandbyRequest}
exit-standby-request
  [m6489]
  (clojure.core/let
   [bean6488
    (new com.amazonaws.services.autoscaling.model.ExitStandbyRequest)]
   (clojure.core/let
    [v6490
     (:instance-ids m6489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6490 :com.palletops.awaze.client-builder/undef)
     (.
      bean6488
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6552] (clojure.core/str arg6552))
 v6490))))
   (clojure.core/let
    [v6490
     (:auto-scaling-group-name
      m6489
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6490 :com.palletops.awaze.client-builder/undef)
     (. bean6488 setAutoScalingGroupName (clojure.core/str v6490))))
   bean6488))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DetachInstancesRequest}
detach-instances-request
  [m6492]
  (clojure.core/let
   [bean6491
    (new
     com.amazonaws.services.autoscaling.model.DetachInstancesRequest)]
   (clojure.core/let
    [v6493
     (:instance-ids m6492 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6493 :com.palletops.awaze.client-builder/undef)
     (.
      bean6491
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6553] (clojure.core/str arg6553))
 v6493))))
   (clojure.core/let
    [v6493
     (:auto-scaling-group-name
      m6492
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6493 :com.palletops.awaze.client-builder/undef)
     (. bean6491 setAutoScalingGroupName (clojure.core/str v6493))))
   (clojure.core/let
    [v6493
     (:should-decrement-desired-capacity
      m6492
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6493 :com.palletops.awaze.client-builder/undef)
     (.
      bean6491
      setShouldDecrementDesiredCapacity
      (clojure.core/boolean v6493))))
   bean6491))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest}
set-desired-capacity-request
  [m6495]
  (clojure.core/let
   [bean6494
    (new
     com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest)]
   (clojure.core/let
    [v6496
     (:desired-capacity
      m6495
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6496 :com.palletops.awaze.client-builder/undef)
     (. bean6494 setDesiredCapacity (clojure.core/int v6496))))
   (clojure.core/let
    [v6496
     (:auto-scaling-group-name
      m6495
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6496 :com.palletops.awaze.client-builder/undef)
     (. bean6494 setAutoScalingGroupName (clojure.core/str v6496))))
   (clojure.core/let
    [v6496
     (:honor-cooldown m6495 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6496 :com.palletops.awaze.client-builder/undef)
     (. bean6494 setHonorCooldown (clojure.core/boolean v6496))))
   bean6494))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest}
set-instance-health-request
  [m6498]
  (clojure.core/let
   [bean6497
    (new
     com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest)]
   (clojure.core/let
    [v6499
     (:instance-id m6498 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6499 :com.palletops.awaze.client-builder/undef)
     (. bean6497 setInstanceId (clojure.core/str v6499))))
   (clojure.core/let
    [v6499
     (:health-status m6498 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6499 :com.palletops.awaze.client-builder/undef)
     (. bean6497 setHealthStatus (clojure.core/str v6499))))
   (clojure.core/let
    [v6499
     (:should-respect-grace-period
      m6498
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6499 :com.palletops.awaze.client-builder/undef)
     (.
      bean6497
      setShouldRespectGracePeriod
      (clojure.core/boolean v6499))))
   bean6497))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribePoliciesRequest}
describe-policies-request
  [m6501]
  (clojure.core/let
   [bean6500
    (new
     com.amazonaws.services.autoscaling.model.DescribePoliciesRequest)]
   (clojure.core/let
    [v6502
     (:next-token m6501 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6502 :com.palletops.awaze.client-builder/undef)
     (. bean6500 setNextToken (clojure.core/str v6502))))
   (clojure.core/let
    [v6502
     (:policy-names m6501 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6502 :com.palletops.awaze.client-builder/undef)
     (.
      bean6500
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6610] (clojure.core/str arg6610))
 v6502))))
   (clojure.core/let
    [v6502
     (:max-records m6501 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6502 :com.palletops.awaze.client-builder/undef)
     (. bean6500 setMaxRecords (clojure.core/int v6502))))
   (clojure.core/let
    [v6502
     (:auto-scaling-group-name
      m6501
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6502 :com.palletops.awaze.client-builder/undef)
     (. bean6500 setAutoScalingGroupName (clojure.core/str v6502))))
   (clojure.core/let
    [v6502
     (:policy-types m6501 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6502 :com.palletops.awaze.client-builder/undef)
     (.
      bean6500
      setPolicyTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6611] (clojure.core/str arg6611))
 v6502))))
   bean6500))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest}
put-scheduled-update-group-action-request
  [m6504]
  (clojure.core/let
   [bean6503
    (new
     com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest)]
   (clojure.core/let
    [v6505 (:time m6504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6505 :com.palletops.awaze.client-builder/undef)
     (. bean6503 setTime (com.palletops.awaze.common/to-date v6505))))
   (clojure.core/let
    [v6505
     (:desired-capacity
      m6504
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6505 :com.palletops.awaze.client-builder/undef)
     (. bean6503 setDesiredCapacity (clojure.core/int v6505))))
   (clojure.core/let
    [v6505
     (:scheduled-action-name
      m6504
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6505 :com.palletops.awaze.client-builder/undef)
     (. bean6503 setScheduledActionName (clojure.core/str v6505))))
   (clojure.core/let
    [v6505
     (:start-time m6504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6505 :com.palletops.awaze.client-builder/undef)
     (.
      bean6503
      setStartTime
      (com.palletops.awaze.common/to-date v6505))))
   (clojure.core/let
    [v6505
     (:recurrence m6504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6505 :com.palletops.awaze.client-builder/undef)
     (. bean6503 setRecurrence (clojure.core/str v6505))))
   (clojure.core/let
    [v6505
     (:min-size m6504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6505 :com.palletops.awaze.client-builder/undef)
     (. bean6503 setMinSize (clojure.core/int v6505))))
   (clojure.core/let
    [v6505
     (:end-time m6504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6505 :com.palletops.awaze.client-builder/undef)
     (.
      bean6503
      setEndTime
      (com.palletops.awaze.common/to-date v6505))))
   (clojure.core/let
    [v6505
     (:auto-scaling-group-name
      m6504
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6505 :com.palletops.awaze.client-builder/undef)
     (. bean6503 setAutoScalingGroupName (clojure.core/str v6505))))
   (clojure.core/let
    [v6505
     (:max-size m6504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6505 :com.palletops.awaze.client-builder/undef)
     (. bean6503 setMaxSize (clojure.core/int v6505))))
   bean6503))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.EnterStandbyRequest}
enter-standby-request
  [m6507]
  (clojure.core/let
   [bean6506
    (new com.amazonaws.services.autoscaling.model.EnterStandbyRequest)]
   (clojure.core/let
    [v6508
     (:instance-ids m6507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6508 :com.palletops.awaze.client-builder/undef)
     (.
      bean6506
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6612] (clojure.core/str arg6612))
 v6508))))
   (clojure.core/let
    [v6508
     (:auto-scaling-group-name
      m6507
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6508 :com.palletops.awaze.client-builder/undef)
     (. bean6506 setAutoScalingGroupName (clojure.core/str v6508))))
   (clojure.core/let
    [v6508
     (:should-decrement-desired-capacity
      m6507
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6508 :com.palletops.awaze.client-builder/undef)
     (.
      bean6506
      setShouldDecrementDesiredCapacity
      (clojure.core/boolean v6508))))
   bean6506))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest}
enable-metrics-collection-request
  [m6510]
  (clojure.core/let
   [bean6509
    (new
     com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest)]
   (clojure.core/let
    [v6511
     (:auto-scaling-group-name
      m6510
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6511 :com.palletops.awaze.client-builder/undef)
     (. bean6509 setAutoScalingGroupName (clojure.core/str v6511))))
   (clojure.core/let
    [v6511 (:metrics m6510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6511 :com.palletops.awaze.client-builder/undef)
     (.
      bean6509
      setMetrics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6613] (clojure.core/str arg6613))
 v6511))))
   (clojure.core/let
    [v6511
     (:granularity m6510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6511 :com.palletops.awaze.client-builder/undef)
     (. bean6509 setGranularity (clojure.core/str v6511))))
   bean6509))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest}
describe-metric-collection-types-request
  [m6513]
  (clojure.core/let
   [bean6512
    (new
     com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest)]
   bean6512))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest}
create-launch-configuration-request
  [m6516]
  (clojure.core/let
   [bean6515
    (new
     com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest)]
   (clojure.core/let
    [v6517
     (:instance-monitoring
      m6516
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (.
      bean6515
      setInstanceMonitoring
      (autoscaling/instance-monitoring v6517))))
   (clojure.core/let
    [v6517
     (:spot-price m6516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (. bean6515 setSpotPrice (clojure.core/str v6517))))
   (clojure.core/let
    [v6517
     (:iam-instance-profile
      m6516
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (. bean6515 setIamInstanceProfile (clojure.core/str v6517))))
   (clojure.core/let
    [v6517
     (:classic-link-vpcid
      m6516
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (. bean6515 setClassicLinkVPCId (clojure.core/str v6517))))
   (clojure.core/let
    [v6517
     (:instance-type m6516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (. bean6515 setInstanceType (clojure.core/str v6517))))
   (clojure.core/let
    [v6517
     (:ebs-optimized m6516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (. bean6515 setEbsOptimized (clojure.core/boolean v6517))))
   (clojure.core/let
    [v6517
     (:ramdisk-id m6516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (. bean6515 setRamdiskId (clojure.core/str v6517))))
   (clojure.core/let
    [v6517
     (:instance-id m6516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (. bean6515 setInstanceId (clojure.core/str v6517))))
   (clojure.core/let
    [v6517
     (:image-id m6516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (. bean6515 setImageId (clojure.core/str v6517))))
   (clojure.core/let
    [v6517
     (:launch-configuration-name
      m6516
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (. bean6515 setLaunchConfigurationName (clojure.core/str v6517))))
   (clojure.core/let
    [v6517
     (:key-name m6516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (. bean6515 setKeyName (clojure.core/str v6517))))
   (clojure.core/let
    [v6517
     (:classic-link-vpcsecurity-groups
      m6516
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (.
      bean6515
      setClassicLinkVPCSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6614] (clojure.core/str arg6614))
 v6517))))
   (clojure.core/let
    [v6517
     (:placement-tenancy
      m6516
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (. bean6515 setPlacementTenancy (clojure.core/str v6517))))
   (clojure.core/let
    [v6517
     (:kernel-id m6516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (. bean6515 setKernelId (clojure.core/str v6517))))
   (clojure.core/let
    [v6517
     (:associate-public-ip-address
      m6516
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (.
      bean6515
      setAssociatePublicIpAddress
      (clojure.core/boolean v6517))))
   (clojure.core/let
    [v6517
     (:security-groups
      m6516
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (.
      bean6515
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6615] (clojure.core/str arg6615))
 v6517))))
   (clojure.core/let
    [v6517
     (:block-device-mappings
      m6516
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (.
      bean6515
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6616]
  (autoscaling/block-device-mapping arg6616))
 v6517))))
   (clojure.core/let
    [v6517
     (:user-data m6516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (. bean6515 setUserData (clojure.core/str v6517))))
   bean6515))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteLifecycleHookRequest}
delete-lifecycle-hook-request
  [m6519]
  (clojure.core/let
   [bean6518
    (new
     com.amazonaws.services.autoscaling.model.DeleteLifecycleHookRequest)]
   (clojure.core/let
    [v6520
     (:auto-scaling-group-name
      m6519
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6520 :com.palletops.awaze.client-builder/undef)
     (. bean6518 setAutoScalingGroupName (clojure.core/str v6520))))
   (clojure.core/let
    [v6520
     (:lifecycle-hook-name
      m6519
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6520 :com.palletops.awaze.client-builder/undef)
     (. bean6518 setLifecycleHookName (clojure.core/str v6520))))
   bean6518))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest}
describe-launch-configurations-request
  [m6522]
  (clojure.core/let
   [bean6521
    (new
     com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest)]
   (clojure.core/let
    [v6523
     (:next-token m6522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6523 :com.palletops.awaze.client-builder/undef)
     (. bean6521 setNextToken (clojure.core/str v6523))))
   (clojure.core/let
    [v6523
     (:max-records m6522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6523 :com.palletops.awaze.client-builder/undef)
     (. bean6521 setMaxRecords (clojure.core/int v6523))))
   (clojure.core/let
    [v6523
     (:launch-configuration-names
      m6522
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6523 :com.palletops.awaze.client-builder/undef)
     (.
      bean6521
      setLaunchConfigurationNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6617] (clojure.core/str arg6617))
 v6523))))
   bean6521))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLifecycleHookTypesRequest}
describe-lifecycle-hook-types-request
  [m6525]
  (clojure.core/let
   [bean6524
    (new
     com.amazonaws.services.autoscaling.model.DescribeLifecycleHookTypesRequest)]
   bean6524))
 (clojure.core/defmulti
  autoscaling
  (clojure.core/fn
   autoscaling
   [m__1816__auto__]
   (:fn m__1816__auto__)))
 (do
  (clojure.core/defmethod
   autoscaling
   :update-auto-scaling-group
   [m6554]
   (clojure.core/let
    [credentials6555 (:credentials m6554) args6556 (:args m6554)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6557
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6555)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6557
       updateAutoScalingGroup
       (autoscaling/update-auto-scaling-group-request
        (clojure.core/nth args6556 0)))))))
  (clojure.core/defn
   update-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Generate map for updateAutoScalingGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :update-auto-scaling-group,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   update-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Call updateAutoScalingGroup"}
   [credentials6559 & args6560]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6561
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6559)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6561
      updateAutoScalingGroup
      (autoscaling/update-auto-scaling-group-request
       (clojure.core/nth args6560 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :attach-load-balancers
   [m6562]
   (clojure.core/let
    [credentials6563 (:credentials m6562) args6564 (:args m6562)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6565
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6563)]
     (clojure.core/case
      (clojure.core/count args6564)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6565
        attachLoadBalancers
        (autoscaling/attach-load-balancers-request
         (clojure.core/nth args6564 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6565
        attachLoadBalancers))))))
  (clojure.core/defn
   attach-load-balancers-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Generate map for attachLoadBalancers, attachLoadBalancers"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :attach-load-balancers,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :attach-load-balancers,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   attach-load-balancers
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Call attachLoadBalancers, attachLoadBalancers"}
   [credentials6567 & args6568]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6569
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6567)]
    (clojure.core/case
     (clojure.core/count args6568)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6569
       attachLoadBalancers
       (autoscaling/attach-load-balancers-request
        (clojure.core/nth args6568 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6569
       attachLoadBalancers))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-or-update-tags
   [m6570]
   (clojure.core/let
    [credentials6571 (:credentials m6570) args6572 (:args m6570)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6573
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6571)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6573
       createOrUpdateTags
       (autoscaling/create-or-update-tags-request
        (clojure.core/nth args6572 0)))))))
  (clojure.core/defn
   create-or-update-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createOrUpdateTags"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-or-update-tags,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   create-or-update-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createOrUpdateTags"}
   [credentials6575 & args6576]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6577
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6575)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6577
      createOrUpdateTags
      (autoscaling/create-or-update-tags-request
       (clojure.core/nth args6576 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :resume-processes
   [m6578]
   (clojure.core/let
    [credentials6579 (:credentials m6578) args6580 (:args m6578)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6581
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6579)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6581
       resumeProcesses
       (autoscaling/resume-processes-request
        (clojure.core/nth args6580 0)))))))
  (clojure.core/defn
   resume-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for resumeProcesses"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :resume-processes,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   resume-processes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call resumeProcesses"}
   [credentials6583 & args6584]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6585
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6583)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6585
      resumeProcesses
      (autoscaling/resume-processes-request
       (clojure.core/nth args6584 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :terminate-instance-in-auto-scaling-group
   [m6586]
   (clojure.core/let
    [credentials6587 (:credentials m6586) args6588 (:args m6586)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6589
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6587)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6589
       terminateInstanceInAutoScalingGroup
       (autoscaling/terminate-instance-in-auto-scaling-group-request
        (clojure.core/nth args6588 0)))))))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         should-decrement-desired-capacity
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for terminateInstanceInAutoScalingGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :terminate-instance-in-auto-scaling-group,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         should-decrement-desired-capacity
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call terminateInstanceInAutoScalingGroup"}
   [credentials6591 & args6592]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6593
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6591)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6593
      terminateInstanceInAutoScalingGroup
      (autoscaling/terminate-instance-in-auto-scaling-group-request
       (clojure.core/nth args6592 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-auto-scaling-group
   [m6594]
   (clojure.core/let
    [credentials6595 (:credentials m6594) args6596 (:args m6594)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6597
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6595)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6597
       deleteAutoScalingGroup
       (autoscaling/delete-auto-scaling-group-request
        (clojure.core/nth args6596 0)))))))
  (clojure.core/defn
   delete-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         force-delete
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteAutoScalingGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-auto-scaling-group,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         force-delete
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteAutoScalingGroup"}
   [credentials6599 & args6600]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6601
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6599)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6601
      deleteAutoScalingGroup
      (autoscaling/delete-auto-scaling-group-request
       (clojure.core/nth args6600 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-load-balancers
   [m6602]
   (clojure.core/let
    [credentials6603 (:credentials m6602) args6604 (:args m6602)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6605
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6603)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6605
       describeLoadBalancers
       (autoscaling/describe-load-balancers-request
        (clojure.core/nth args6604 0)))))))
  (clojure.core/defn
   describe-load-balancers-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Generate map for describeLoadBalancers"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-load-balancers,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-load-balancers
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Call describeLoadBalancers"}
   [credentials6607 & args6608]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6609
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6607)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6609
      describeLoadBalancers
      (autoscaling/describe-load-balancers-request
       (clojure.core/nth args6608 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :disable-metrics-collection
   [m6618]
   (clojure.core/let
    [credentials6619 (:credentials m6618) args6620 (:args m6618)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6621
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6619)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6621
       disableMetricsCollection
       (autoscaling/disable-metrics-collection-request
        (clojure.core/nth args6620 0)))))))
  (clojure.core/defn
   disable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Generate map for disableMetricsCollection"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :disable-metrics-collection,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   disable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Call disableMetricsCollection"}
   [credentials6623 & args6624]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6625
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6623)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6625
      disableMetricsCollection
      (autoscaling/disable-metrics-collection-request
       (clojure.core/nth args6624 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scheduled-actions
   [m6626]
   (clojure.core/let
    [credentials6627 (:credentials m6626) args6628 (:args m6626)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6629
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6627)]
     (clojure.core/case
      (clojure.core/count args6628)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6629
        describeScheduledActions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6629
        describeScheduledActions
        (autoscaling/describe-scheduled-actions-request
         (clojure.core/nth args6628 0))))))))
  (clojure.core/defn
   describe-scheduled-actions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scheduled-action-names
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Generate map for describeScheduledActions, describeScheduledActions"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-scheduled-actions,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-scheduled-actions,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-scheduled-actions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scheduled-action-names
                         start-time
                         custom-query-parameters
                         end-time
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]]),
    :doc "Call describeScheduledActions, describeScheduledActions"}
   [credentials6631 & args6632]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6633
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6631)]
    (clojure.core/case
     (clojure.core/count args6632)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6633
       describeScheduledActions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6633
       describeScheduledActions
       (autoscaling/describe-scheduled-actions-request
        (clojure.core/nth args6632 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-notification-configuration
   [m6634]
   (clojure.core/let
    [credentials6635 (:credentials m6634) args6636 (:args m6634)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6637
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6635)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6637
       deleteNotificationConfiguration
       (autoscaling/delete-notification-configuration-request
        (clojure.core/nth args6636 0)))))))
  (clojure.core/defn
   delete-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteNotificationConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-notification-configuration,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteNotificationConfiguration"}
   [credentials6639 & args6640]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6641
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6639)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6641
      deleteNotificationConfiguration
      (autoscaling/delete-notification-configuration-request
       (clojure.core/nth args6640 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scaling-policy
   [m6642]
   (clojure.core/let
    [credentials6643 (:credentials m6642) args6644 (:args m6642)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6645
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6643)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6645
       putScalingPolicy
       (autoscaling/put-scaling-policy-request
        (clojure.core/nth args6644 0)))))))
  (clojure.core/defn
   put-scaling-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [estimated-instance-warmup
                         adjustment-type
                         custom-request-headers
                         sdk-client-execution-timeout
                         metric-aggregation-type
                         sdk-request-timeout
                         scaling-adjustment
                         min-adjustment-magnitude
                         custom-query-parameters
                         cooldown
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-type
                         clone-source
                         step-adjustments
                         clone-root
                         min-adjustment-step
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putScalingPolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :put-scaling-policy,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-scaling-policy
   {:arglists (quote
               [[credentials
                 {:keys [estimated-instance-warmup
                         adjustment-type
                         custom-request-headers
                         sdk-client-execution-timeout
                         metric-aggregation-type
                         sdk-request-timeout
                         scaling-adjustment
                         min-adjustment-magnitude
                         custom-query-parameters
                         cooldown
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-type
                         clone-source
                         step-adjustments
                         clone-root
                         min-adjustment-step
                         auto-scaling-group-name]}]]),
    :doc "Call putScalingPolicy"}
   [credentials6647 & args6648]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6649
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6647)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6649
      putScalingPolicy
      (autoscaling/put-scaling-policy-request
       (clojure.core/nth args6648 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-activities
   [m6650]
   (clojure.core/let
    [credentials6651 (:credentials m6650) args6652 (:args m6650)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6653
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6651)]
     (clojure.core/case
      (clojure.core/count args6652)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6653
        describeScalingActivities
        (autoscaling/describe-scaling-activities-request
         (clojure.core/nth args6652 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6653
        describeScalingActivities))))))
  (clojure.core/defn
   describe-scaling-activities-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         activity-ids
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeScalingActivities, describeScalingActivities"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-scaling-activities,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-scaling-activities,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-scaling-activities
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         activity-ids
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]
                [credentials]]),
    :doc "Call describeScalingActivities, describeScalingActivities"}
   [credentials6655 & args6656]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6657
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6655)]
    (clojure.core/case
     (clojure.core/count args6656)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6657
       describeScalingActivities
       (autoscaling/describe-scaling-activities-request
        (clojure.core/nth args6656 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6657
       describeScalingActivities))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-lifecycle-hooks
   [m6658]
   (clojure.core/let
    [credentials6659 (:credentials m6658) args6660 (:args m6658)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6661
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6659)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6661
       describeLifecycleHooks
       (autoscaling/describe-lifecycle-hooks-request
        (clojure.core/nth args6660 0)))))))
  (clojure.core/defn
   describe-lifecycle-hooks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-hook-names
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for describeLifecycleHooks"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-lifecycle-hooks,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-lifecycle-hooks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-hook-names
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call describeLifecycleHooks"}
   [credentials6663 & args6664]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6665
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6663)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6665
      describeLifecycleHooks
      (autoscaling/describe-lifecycle-hooks-request
       (clojure.core/nth args6664 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-launch-configuration
   [m6666]
   (clojure.core/let
    [credentials6667 (:credentials m6666) args6668 (:args m6666)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6669
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6667)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6669
       deleteLaunchConfiguration
       (autoscaling/delete-launch-configuration-request
        (clojure.core/nth args6668 0)))))))
  (clojure.core/defn
   delete-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLaunchConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-launch-configuration,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLaunchConfiguration"}
   [credentials6671 & args6672]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6673
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6671)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6673
      deleteLaunchConfiguration
      (autoscaling/delete-launch-configuration-request
       (clojure.core/nth args6672 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-policy
   [m6674]
   (clojure.core/let
    [credentials6675 (:credentials m6674) args6676 (:args m6674)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6677
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6675)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6677
       deletePolicy
       (autoscaling/delete-policy-request
        (clojure.core/nth args6676 0)))))))
  (clojure.core/defn
   delete-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deletePolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-policy,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deletePolicy"}
   [credentials6679 & args6680]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6681
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6679)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6681
      deletePolicy
      (autoscaling/delete-policy-request
       (clojure.core/nth args6680 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-auto-scaling-group
   [m6682]
   (clojure.core/let
    [credentials6683 (:credentials m6682) args6684 (:args m6682)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6685
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6683)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6685
       createAutoScalingGroup
       (autoscaling/create-auto-scaling-group-request
        (clojure.core/nth args6684 0)))))))
  (clojure.core/defn
   create-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         instance-id
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Generate map for createAutoScalingGroup"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-auto-scaling-group,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   create-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         health-check-type
                         default-cooldown
                         sdk-request-timeout
                         availability-zones
                         launch-configuration-name
                         health-check-grace-period
                         custom-query-parameters
                         max-size
                         desired-capacity
                         instance-id
                         placement-group
                         min-size
                         read-limit
                         vpczone-identifier
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         termination-policies
                         clone-root
                         new-instances-protected-from-scale-in
                         auto-scaling-group-name]}]]),
    :doc "Call createAutoScalingGroup"}
   [credentials6687 & args6688]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6689
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6687)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6689
      createAutoScalingGroup
      (autoscaling/create-auto-scaling-group-request
       (clojure.core/nth args6688 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-process-types
   [m6690]
   (clojure.core/let
    [credentials6691 (:credentials m6690) args6692 (:args m6690)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6693
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6691)]
     (clojure.core/case
      (clojure.core/count args6692)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6693
        describeScalingProcessTypes
        (autoscaling/describe-scaling-process-types-request
         (clojure.core/nth args6692 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6693
        describeScalingProcessTypes))))))
  (clojure.core/defn
   describe-scaling-process-types-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeScalingProcessTypes, describeScalingProcessTypes"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-scaling-process-types,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-scaling-process-types,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-scaling-process-types
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeScalingProcessTypes, describeScalingProcessTypes"}
   [credentials6695 & args6696]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6697
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6695)]
    (clojure.core/case
     (clojure.core/count args6696)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6697
       describeScalingProcessTypes
       (autoscaling/describe-scaling-process-types-request
        (clojure.core/nth args6696 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6697
       describeScalingProcessTypes))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-account-limits
   [m6698]
   (clojure.core/let
    [credentials6699 (:credentials m6698) args6700 (:args m6698)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6701
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6699)]
     (clojure.core/case
      (clojure.core/count args6700)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6701
        describeAccountLimits
        (autoscaling/describe-account-limits-request
         (clojure.core/nth args6700 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6701
        describeAccountLimits))))))
  (clojure.core/defn
   describe-account-limits-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeAccountLimits, describeAccountLimits"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-account-limits,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-account-limits,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-account-limits
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeAccountLimits, describeAccountLimits"}
   [credentials6703 & args6704]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6705
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6703)]
    (clojure.core/case
     (clojure.core/count args6704)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6705
       describeAccountLimits
       (autoscaling/describe-account-limits-request
        (clojure.core/nth args6704 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6705
       describeAccountLimits))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-scheduled-action
   [m6706]
   (clojure.core/let
    [credentials6707 (:credentials m6706) args6708 (:args m6706)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6709
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6707)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6709
       deleteScheduledAction
       (autoscaling/delete-scheduled-action-request
        (clojure.core/nth args6708 0)))))))
  (clojure.core/defn
   delete-scheduled-action-map
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteScheduledAction"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-scheduled-action,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-scheduled-action
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteScheduledAction"}
   [credentials6711 & args6712]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6713
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6711)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6713
      deleteScheduledAction
      (autoscaling/delete-scheduled-action-request
       (clojure.core/nth args6712 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-notification-configurations
   [m6714]
   (clojure.core/let
    [credentials6715 (:credentials m6714) args6716 (:args m6714)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6717
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6715)]
     (clojure.core/case
      (clojure.core/count args6716)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6717
        describeNotificationConfigurations
        (autoscaling/describe-notification-configurations-request
         (clojure.core/nth args6716 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6717
        describeNotificationConfigurations))))))
  (clojure.core/defn
   describe-notification-configurations-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeNotificationConfigurations, describeNotificationConfigurations"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-notification-configurations,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-notification-configurations,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-notification-configurations
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeNotificationConfigurations, describeNotificationConfigurations"}
   [credentials6719 & args6720]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6721
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6719)]
    (clojure.core/case
     (clojure.core/count args6720)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6721
       describeNotificationConfigurations
       (autoscaling/describe-notification-configurations-request
        (clojure.core/nth args6720 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6721
       describeNotificationConfigurations))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-adjustment-types
   [m6722]
   (clojure.core/let
    [credentials6723 (:credentials m6722) args6724 (:args m6722)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6725
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6723)]
     (clojure.core/case
      (clojure.core/count args6724)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6725
        describeAdjustmentTypes
        (autoscaling/describe-adjustment-types-request
         (clojure.core/nth args6724 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6725
        describeAdjustmentTypes))))))
  (clojure.core/defn
   describe-adjustment-types-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeAdjustmentTypes, describeAdjustmentTypes"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-adjustment-types,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-adjustment-types,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-adjustment-types
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeAdjustmentTypes, describeAdjustmentTypes"}
   [credentials6727 & args6728]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6729
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6727)]
    (clojure.core/case
     (clojure.core/count args6728)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6729
       describeAdjustmentTypes
       (autoscaling/describe-adjustment-types-request
        (clojure.core/nth args6728 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6729
       describeAdjustmentTypes))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-instances
   [m6730]
   (clojure.core/let
    [credentials6731 (:credentials m6730) args6732 (:args m6730)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6733
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6731)]
     (clojure.core/case
      (clojure.core/count args6732)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6733
        describeAutoScalingInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6733
        describeAutoScalingInstances
        (autoscaling/describe-auto-scaling-instances-request
         (clojure.core/nth args6732 0))))))))
  (clojure.core/defn
   describe-auto-scaling-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeAutoScalingInstances, describeAutoScalingInstances"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-auto-scaling-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeAutoScalingInstances, describeAutoScalingInstances"}
   [credentials6735 & args6736]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6737
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6735)]
    (clojure.core/case
     (clojure.core/count args6736)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6737
       describeAutoScalingInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6737
       describeAutoScalingInstances
       (autoscaling/describe-auto-scaling-instances-request
        (clojure.core/nth args6736 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-termination-policy-types
   [m6738]
   (clojure.core/let
    [credentials6739 (:credentials m6738) args6740 (:args m6738)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6741
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6739)]
     (clojure.core/case
      (clojure.core/count args6740)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6741
        describeTerminationPolicyTypes
        (autoscaling/describe-termination-policy-types-request
         (clojure.core/nth args6740 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6741
        describeTerminationPolicyTypes))))))
  (clojure.core/defn
   describe-termination-policy-types-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-termination-policy-types,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-termination-policy-types,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-termination-policy-types
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   [credentials6743 & args6744]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6745
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6743)]
    (clojure.core/case
     (clojure.core/count args6744)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6745
       describeTerminationPolicyTypes
       (autoscaling/describe-termination-policy-types-request
        (clojure.core/nth args6744 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6745
       describeTerminationPolicyTypes))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :attach-instances
   [m6746]
   (clojure.core/let
    [credentials6747 (:credentials m6746) args6748 (:args m6746)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6749
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6747)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6749
       attachInstances
       (autoscaling/attach-instances-request
        (clojure.core/nth args6748 0)))))))
  (clojure.core/defn
   attach-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for attachInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :attach-instances,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   attach-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call attachInstances"}
   [credentials6751 & args6752]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6753
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6751)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6753
      attachInstances
      (autoscaling/attach-instances-request
       (clojure.core/nth args6752 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-tags
   [m6754]
   (clojure.core/let
    [credentials6755 (:credentials m6754) args6756 (:args m6754)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6757
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6755)]
     (clojure.core/case
      (clojure.core/count args6756)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6757
        describeTags))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6757
        describeTags
        (autoscaling/describe-tags-request
         (clojure.core/nth args6756 0))))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-tags,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeTags, describeTags"}
   [credentials6759 & args6760]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6761
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6759)]
    (clojure.core/case
     (clojure.core/count args6760)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6761
       describeTags))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6761
       describeTags
       (autoscaling/describe-tags-request
        (clojure.core/nth args6760 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-tags
   [m6762]
   (clojure.core/let
    [credentials6763 (:credentials m6762) args6764 (:args m6762)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6765
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6763)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6765
       deleteTags
       (autoscaling/delete-tags-request (clojure.core/nth args6764 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-tags,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTags"}
   [credentials6767 & args6768]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6769
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6767)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6769
      deleteTags
      (autoscaling/delete-tags-request (clojure.core/nth args6768 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-notification-configuration
   [m6770]
   (clojure.core/let
    [credentials6771 (:credentials m6770) args6772 (:args m6770)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6773
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6771)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6773
       putNotificationConfiguration
       (autoscaling/put-notification-configuration-request
        (clojure.core/nth args6772 0)))))))
  (clojure.core/defn
   put-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         notification-types
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putNotificationConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :put-notification-configuration,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         notification-types
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call putNotificationConfiguration"}
   [credentials6775 & args6776]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6777
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6775)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6777
      putNotificationConfiguration
      (autoscaling/put-notification-configuration-request
       (clojure.core/nth args6776 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :detach-load-balancers
   [m6778]
   (clojure.core/let
    [credentials6779 (:credentials m6778) args6780 (:args m6778)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6781
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6779)]
     (clojure.core/case
      (clojure.core/count args6780)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6781
        detachLoadBalancers))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6781
        detachLoadBalancers
        (autoscaling/detach-load-balancers-request
         (clojure.core/nth args6780 0))))))))
  (clojure.core/defn
   detach-load-balancers-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for detachLoadBalancers, detachLoadBalancers"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :detach-load-balancers,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :detach-load-balancers,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   detach-load-balancers
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call detachLoadBalancers, detachLoadBalancers"}
   [credentials6783 & args6784]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6785
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6783)]
    (clojure.core/case
     (clojure.core/count args6784)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6785
       detachLoadBalancers))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6785
       detachLoadBalancers
       (autoscaling/detach-load-balancers-request
        (clojure.core/nth args6784 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-notification-types
   [m6786]
   (clojure.core/let
    [credentials6787 (:credentials m6786) args6788 (:args m6786)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6789
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6787)]
     (clojure.core/case
      (clojure.core/count args6788)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6789
        describeAutoScalingNotificationTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6789
        describeAutoScalingNotificationTypes
        (autoscaling/describe-auto-scaling-notification-types-request
         (clojure.core/nth args6788 0))))))))
  (clojure.core/defn
   describe-auto-scaling-notification-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-auto-scaling-notification-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   [credentials6791 & args6792]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6793
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6791)]
    (clojure.core/case
     (clojure.core/count args6792)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6793
       describeAutoScalingNotificationTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6793
       describeAutoScalingNotificationTypes
       (autoscaling/describe-auto-scaling-notification-types-request
        (clojure.core/nth args6792 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-instance-protection
   [m6794]
   (clojure.core/let
    [credentials6795 (:credentials m6794) args6796 (:args m6794)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6797
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6795)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6797
       setInstanceProtection
       (autoscaling/set-instance-protection-request
        (clojure.core/nth args6796 0)))))))
  (clojure.core/defn
   set-instance-protection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         protected-from-scale-in
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for setInstanceProtection"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-instance-protection,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   set-instance-protection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         protected-from-scale-in
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call setInstanceProtection"}
   [credentials6799 & args6800]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6801
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6799)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6801
      setInstanceProtection
      (autoscaling/set-instance-protection-request
       (clojure.core/nth args6800 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :complete-lifecycle-action
   [m6802]
   (clojure.core/let
    [credentials6803 (:credentials m6802) args6804 (:args m6802)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6805
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6803)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6805
       completeLifecycleAction
       (autoscaling/complete-lifecycle-action-request
        (clojure.core/nth args6804 0)))))))
  (clojure.core/defn
   complete-lifecycle-action-map
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         lifecycle-action-result
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for completeLifecycleAction"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :complete-lifecycle-action,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   complete-lifecycle-action
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         lifecycle-action-result
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call completeLifecycleAction"}
   [credentials6807 & args6808]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6809
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6807)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6809
      completeLifecycleAction
      (autoscaling/complete-lifecycle-action-request
       (clojure.core/nth args6808 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :suspend-processes
   [m6810]
   (clojure.core/let
    [credentials6811 (:credentials m6810) args6812 (:args m6810)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6813
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6811)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6813
       suspendProcesses
       (autoscaling/suspend-processes-request
        (clojure.core/nth args6812 0)))))))
  (clojure.core/defn
   suspend-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for suspendProcesses"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :suspend-processes,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   suspend-processes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         scaling-processes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call suspendProcesses"}
   [credentials6815 & args6816]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6817
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6815)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6817
      suspendProcesses
      (autoscaling/suspend-processes-request
       (clojure.core/nth args6816 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-groups
   [m6818]
   (clojure.core/let
    [credentials6819 (:credentials m6818) args6820 (:args m6818)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6821
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6819)]
     (clojure.core/case
      (clojure.core/count args6820)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6821
        describeAutoScalingGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6821
        describeAutoScalingGroups
        (autoscaling/describe-auto-scaling-groups-request
         (clojure.core/nth args6820 0))))))))
  (clojure.core/defn
   describe-auto-scaling-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeAutoScalingGroups, describeAutoScalingGroups"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-auto-scaling-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         auto-scaling-group-names
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeAutoScalingGroups, describeAutoScalingGroups"}
   [credentials6823 & args6824]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6825
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6823)]
    (clojure.core/case
     (clojure.core/count args6824)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6825
       describeAutoScalingGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6825
       describeAutoScalingGroups
       (autoscaling/describe-auto-scaling-groups-request
        (clojure.core/nth args6824 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-lifecycle-hook
   [m6826]
   (clojure.core/let
    [credentials6827 (:credentials m6826) args6828 (:args m6826)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6829
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6827)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6829
       putLifecycleHook
       (autoscaling/put-lifecycle-hook-request
        (clojure.core/nth args6828 0)))))))
  (clojure.core/defn
   put-lifecycle-hook-map
   {:arglists (quote
               [[credentials
                 {:keys [notification-metadata
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-target-arn
                         sdk-request-timeout
                         custom-query-parameters
                         heartbeat-timeout
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-transition
                         clone-root
                         auto-scaling-group-name
                         default-result]}]]),
    :doc "Generate map for putLifecycleHook"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :put-lifecycle-hook,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-lifecycle-hook
   {:arglists (quote
               [[credentials
                 {:keys [notification-metadata
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-target-arn
                         sdk-request-timeout
                         custom-query-parameters
                         heartbeat-timeout
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         lifecycle-transition
                         clone-root
                         auto-scaling-group-name
                         default-result]}]]),
    :doc "Call putLifecycleHook"}
   [credentials6831 & args6832]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6833
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6831)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6833
      putLifecycleHook
      (autoscaling/put-lifecycle-hook-request
       (clojure.core/nth args6832 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :execute-policy
   [m6834]
   (clojure.core/let
    [credentials6835 (:credentials m6834) args6836 (:args m6834)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6837
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6835)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6837
       executePolicy
       (autoscaling/execute-policy-request
        (clojure.core/nth args6836 0)))))))
  (clojure.core/defn
   execute-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         breach-threshold
                         metric-value
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for executePolicy"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :execute-policy,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   execute-policy
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         breach-threshold
                         metric-value
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call executePolicy"}
   [credentials6839 & args6840]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6841
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6839)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6841
      executePolicy
      (autoscaling/execute-policy-request
       (clojure.core/nth args6840 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :record-lifecycle-action-heartbeat
   [m6842]
   (clojure.core/let
    [credentials6843 (:credentials m6842) args6844 (:args m6842)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6845
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6843)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6845
       recordLifecycleActionHeartbeat
       (autoscaling/record-lifecycle-action-heartbeat-request
        (clojure.core/nth args6844 0)))))))
  (clojure.core/defn
   record-lifecycle-action-heartbeat-map
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for recordLifecycleActionHeartbeat"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :record-lifecycle-action-heartbeat,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   record-lifecycle-action-heartbeat
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-action-token
                         lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call recordLifecycleActionHeartbeat"}
   [credentials6847 & args6848]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6849
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6847)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6849
      recordLifecycleActionHeartbeat
      (autoscaling/record-lifecycle-action-heartbeat-request
       (clojure.core/nth args6848 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :exit-standby
   [m6850]
   (clojure.core/let
    [credentials6851 (:credentials m6850) args6852 (:args m6850)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6853
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6851)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6853
       exitStandby
       (autoscaling/exit-standby-request
        (clojure.core/nth args6852 0)))))))
  (clojure.core/defn
   exit-standby-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for exitStandby"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :exit-standby,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   exit-standby
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call exitStandby"}
   [credentials6855 & args6856]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6857
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6855)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6857
      exitStandby
      (autoscaling/exit-standby-request (clojure.core/nth args6856 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :detach-instances
   [m6858]
   (clojure.core/let
    [credentials6859 (:credentials m6858) args6860 (:args m6858)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6861
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6859)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6861
       detachInstances
       (autoscaling/detach-instances-request
        (clojure.core/nth args6860 0)))))))
  (clojure.core/defn
   detach-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for detachInstances"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :detach-instances,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   detach-instances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call detachInstances"}
   [credentials6863 & args6864]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6865
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6863)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6865
      detachInstances
      (autoscaling/detach-instances-request
       (clojure.core/nth args6864 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-desired-capacity
   [m6866]
   (clojure.core/let
    [credentials6867 (:credentials m6866) args6868 (:args m6866)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6869
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6867)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6869
       setDesiredCapacity
       (autoscaling/set-desired-capacity-request
        (clojure.core/nth args6868 0)))))))
  (clojure.core/defn
   set-desired-capacity-map
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         desired-capacity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for setDesiredCapacity"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-desired-capacity,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   set-desired-capacity
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         desired-capacity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call setDesiredCapacity"}
   [credentials6871 & args6872]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6873
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6871)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6873
      setDesiredCapacity
      (autoscaling/set-desired-capacity-request
       (clojure.core/nth args6872 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-instance-health
   [m6874]
   (clojure.core/let
    [credentials6875 (:credentials m6874) args6876 (:args m6874)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6877
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6875)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6877
       setInstanceHealth
       (autoscaling/set-instance-health-request
        (clojure.core/nth args6876 0)))))))
  (clojure.core/defn
   set-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [health-status
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         should-respect-grace-period]}]]),
    :doc "Generate map for setInstanceHealth"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :set-instance-health,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   set-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [health-status
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         instance-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         should-respect-grace-period]}]]),
    :doc "Call setInstanceHealth"}
   [credentials6879 & args6880]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6881
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6879)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6881
      setInstanceHealth
      (autoscaling/set-instance-health-request
       (clojure.core/nth args6880 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-policies
   [m6882]
   (clojure.core/let
    [credentials6883 (:credentials m6882) args6884 (:args m6882)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6885
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6883)]
     (clojure.core/case
      (clojure.core/count args6884)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6885
        describePolicies
        (autoscaling/describe-policies-request
         (clojure.core/nth args6884 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6885
        describePolicies))))))
  (clojure.core/defn
   describe-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         policy-types
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describePolicies, describePolicies"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-policies,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-policies,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-policies
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         policy-types
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         auto-scaling-group-name
                         next-token]}]
                [credentials]]),
    :doc "Call describePolicies, describePolicies"}
   [credentials6887 & args6888]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6889
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6887)]
    (clojure.core/case
     (clojure.core/count args6888)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6889
       describePolicies
       (autoscaling/describe-policies-request
        (clojure.core/nth args6888 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6889
       describePolicies))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scheduled-update-group-action
   [m6890]
   (clojure.core/let
    [credentials6891 (:credentials m6890) args6892 (:args m6890)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6893
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6891)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6893
       putScheduledUpdateGroupAction
       (autoscaling/put-scheduled-update-group-action-request
        (clojure.core/nth args6892 0)))))))
  (clojure.core/defn
   put-scheduled-update-group-action-map
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         time
                         start-time
                         custom-query-parameters
                         end-time
                         max-size
                         desired-capacity
                         min-size
                         read-limit
                         general-progress-listener
                         recurrence
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putScheduledUpdateGroupAction"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :put-scheduled-update-group-action,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   put-scheduled-update-group-action
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         time
                         start-time
                         custom-query-parameters
                         end-time
                         max-size
                         desired-capacity
                         min-size
                         read-limit
                         general-progress-listener
                         recurrence
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call putScheduledUpdateGroupAction"}
   [credentials6895 & args6896]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6897
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6895)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6897
      putScheduledUpdateGroupAction
      (autoscaling/put-scheduled-update-group-action-request
       (clojure.core/nth args6896 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :enter-standby
   [m6898]
   (clojure.core/let
    [credentials6899 (:credentials m6898) args6900 (:args m6898)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6901
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6899)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6901
       enterStandby
       (autoscaling/enter-standby-request
        (clojure.core/nth args6900 0)))))))
  (clojure.core/defn
   enter-standby-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for enterStandby"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :enter-standby,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   enter-standby
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         should-decrement-desired-capacity
                         instance-ids
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call enterStandby"}
   [credentials6903 & args6904]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6905
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6903)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6905
      enterStandby
      (autoscaling/enter-standby-request
       (clojure.core/nth args6904 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :enable-metrics-collection
   [m6906]
   (clojure.core/let
    [credentials6907 (:credentials m6906) args6908 (:args m6906)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6909
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6907)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6909
       enableMetricsCollection
       (autoscaling/enable-metrics-collection-request
        (clojure.core/nth args6908 0)))))))
  (clojure.core/defn
   enable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         granularity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Generate map for enableMetricsCollection"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :enable-metrics-collection,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   enable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         granularity
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Call enableMetricsCollection"}
   [credentials6911 & args6912]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6913
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6911)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6913
      enableMetricsCollection
      (autoscaling/enable-metrics-collection-request
       (clojure.core/nth args6912 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-metric-collection-types
   [m6914]
   (clojure.core/let
    [credentials6915 (:credentials m6914) args6916 (:args m6914)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6917
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6915)]
     (clojure.core/case
      (clojure.core/count args6916)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6917
        describeMetricCollectionTypes
        (autoscaling/describe-metric-collection-types-request
         (clojure.core/nth args6916 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6917
        describeMetricCollectionTypes))))))
  (clojure.core/defn
   describe-metric-collection-types-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeMetricCollectionTypes, describeMetricCollectionTypes"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-metric-collection-types,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-metric-collection-types,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-metric-collection-types
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeMetricCollectionTypes, describeMetricCollectionTypes"}
   [credentials6919 & args6920]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6921
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6919)]
    (clojure.core/case
     (clojure.core/count args6920)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6921
       describeMetricCollectionTypes
       (autoscaling/describe-metric-collection-types-request
        (clojure.core/nth args6920 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6921
       describeMetricCollectionTypes))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-launch-configuration
   [m6922]
   (clojure.core/let
    [credentials6923 (:credentials m6922) args6924 (:args m6922)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6925
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6923)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6925
       createLaunchConfiguration
       (autoscaling/create-launch-configuration-request
        (clojure.core/nth args6924 0)))))))
  (clojure.core/defn
   create-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         security-groups
                         sdk-request-timeout
                         placement-tenancy
                         launch-configuration-name
                         instance-type
                         image-id
                         spot-price
                         instance-monitoring
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         iam-instance-profile
                         read-limit
                         classic-link-vpcsecurity-groups
                         kernel-id
                         general-progress-listener
                         associate-public-ip-address
                         classic-link-vpcid
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Generate map for createLaunchConfiguration"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :create-launch-configuration,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   create-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [ramdisk-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         key-name
                         security-groups
                         sdk-request-timeout
                         placement-tenancy
                         launch-configuration-name
                         instance-type
                         image-id
                         spot-price
                         instance-monitoring
                         custom-query-parameters
                         ebs-optimized
                         instance-id
                         user-data
                         iam-instance-profile
                         read-limit
                         classic-link-vpcsecurity-groups
                         kernel-id
                         general-progress-listener
                         associate-public-ip-address
                         classic-link-vpcid
                         clone-source
                         block-device-mappings
                         clone-root]}]]),
    :doc "Call createLaunchConfiguration"}
   [credentials6927 & args6928]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6929
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6927)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6929
      createLaunchConfiguration
      (autoscaling/create-launch-configuration-request
       (clojure.core/nth args6928 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-lifecycle-hook
   [m6930]
   (clojure.core/let
    [credentials6931 (:credentials m6930) args6932 (:args m6930)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6933
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6931)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6933
       deleteLifecycleHook
       (autoscaling/delete-lifecycle-hook-request
        (clojure.core/nth args6932 0)))))))
  (clojure.core/defn
   delete-lifecycle-hook-map
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteLifecycleHook"}
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :delete-lifecycle-hook,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   delete-lifecycle-hook
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-hook-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-scaling-group-name]}]]),
    :doc "Call deleteLifecycleHook"}
   [credentials6935 & args6936]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6937
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6935)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6937
      deleteLifecycleHook
      (autoscaling/delete-lifecycle-hook-request
       (clojure.core/nth args6936 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-launch-configurations
   [m6938]
   (clojure.core/let
    [credentials6939 (:credentials m6938) args6940 (:args m6938)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6941
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6939)]
     (clojure.core/case
      (clojure.core/count args6940)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6941
        describeLaunchConfigurations
        (autoscaling/describe-launch-configurations-request
         (clojure.core/nth args6940 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6941
        describeLaunchConfigurations))))))
  (clojure.core/defn
   describe-launch-configurations-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeLaunchConfigurations, describeLaunchConfigurations"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-launch-configurations,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-launch-configurations,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-launch-configurations
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         launch-configuration-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeLaunchConfigurations, describeLaunchConfigurations"}
   [credentials6943 & args6944]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6945
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6943)]
    (clojure.core/case
     (clojure.core/count args6944)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6945
       describeLaunchConfigurations
       (autoscaling/describe-launch-configurations-request
        (clojure.core/nth args6944 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6945
       describeLaunchConfigurations))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-lifecycle-hook-types
   [m6946]
   (clojure.core/let
    [credentials6947 (:credentials m6946) args6948 (:args m6946)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client6949
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials6947)]
     (clojure.core/case
      (clojure.core/count args6948)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6949
        describeLifecycleHookTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6949
        describeLifecycleHookTypes
        (autoscaling/describe-lifecycle-hook-types-request
         (clojure.core/nth args6948 0))))))))
  (clojure.core/defn
   describe-lifecycle-hook-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLifecycleHookTypes, describeLifecycleHookTypes"}
   ([credentials__1784__auto__]
    {:args [],
     :fn :describe-lifecycle-hook-types,
     :credentials credentials__1784__auto__,
     :client :autoscaling})
   ([credentials__1784__auto__ a]
    {:args [a],
     :fn :describe-lifecycle-hook-types,
     :credentials credentials__1784__auto__,
     :client :autoscaling}))
  (clojure.core/defn
   describe-lifecycle-hook-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLifecycleHookTypes, describeLifecycleHookTypes"}
   [credentials6951 & args6952]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client6953
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials6951)]
    (clojure.core/case
     (clojure.core/count args6952)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6953
       describeLifecycleHookTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client6953
       describeLifecycleHookTypes
       (autoscaling/describe-lifecycle-hook-types-request
        (clojure.core/nth args6952 0)))))))))
