(ns
 com.palletops.awaze.sts
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sts :as sts]
  [com.palletops.awaze.beans.securitytoken :as securitytoken]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sts
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__1601__auto__))
 (clojure.core/defmulti
  sts
  (clojure.core/fn sts [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   sts
   :assume-role
   [m4778]
   (clojure.core/let
    [credentials4779 (:credentials m4778) args4780 (:args m4778)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4781
      (com.palletops.awaze.common/aws-client :sts credentials4779)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4781
       assumeRole
       (securitytoken/assume-role-request
        (clojure.core/nth args4780 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists (quote
               [[credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds
                         external-id
                         role-session-name
                         policy
                         role-arn]}]]),
    :doc "Generate map for assumeRole"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sts,
     :fn :assume-role,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   assume-role
   {:arglists (quote
               [[credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds
                         external-id
                         role-session-name
                         policy
                         role-arn]}]]),
    :doc "Call assumeRole"}
   [credentials4783 & args4784]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4785
     (com.palletops.awaze.common/aws-client :sts credentials4783)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4785
      assumeRole
      (securitytoken/assume-role-request
       (clojure.core/nth args4784 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-federation-token
   [m4786]
   (clojure.core/let
    [credentials4787 (:credentials m4786) args4788 (:args m4786)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4789
      (com.palletops.awaze.common/aws-client :sts credentials4787)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4789
       getFederationToken
       (securitytoken/get-federation-token-request
        (clojure.core/nth args4788 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists (quote
               [[credentials
                 {:keys [policy
                         name
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Generate map for getFederationToken"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sts,
     :fn :get-federation-token,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-federation-token
   {:arglists (quote
               [[credentials
                 {:keys [policy
                         name
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Call getFederationToken"}
   [credentials4791 & args4792]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4793
     (com.palletops.awaze.common/aws-client :sts credentials4791)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4793
      getFederationToken
      (securitytoken/get-federation-token-request
       (clojure.core/nth args4792 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :assume-role-with-web-identity
   [m4794]
   (clojure.core/let
    [credentials4795 (:credentials m4794) args4796 (:args m4794)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4797
      (com.palletops.awaze.common/aws-client :sts credentials4795)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4797
       assumeRoleWithWebIdentity
       (securitytoken/assume-role-with-web-identity-request
        (clojure.core/nth args4796 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [web-identity-token
                         general-progress-listener
                         duration-seconds
                         role-session-name
                         policy
                         role-arn
                         provider-id]}]]),
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sts,
     :fn :assume-role-with-web-identity,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists (quote
               [[credentials
                 {:keys [web-identity-token
                         general-progress-listener
                         duration-seconds
                         role-session-name
                         policy
                         role-arn
                         provider-id]}]]),
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials4799 & args4800]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4801
     (com.palletops.awaze.common/aws-client :sts credentials4799)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4801
      assumeRoleWithWebIdentity
      (securitytoken/assume-role-with-web-identity-request
       (clojure.core/nth args4800 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-session-token
   [m4802]
   (clojure.core/let
    [credentials4803 (:credentials m4802) args4804 (:args m4802)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4805
      (com.palletops.awaze.common/aws-client :sts credentials4803)]
     (clojure.core/case
      (clojure.core/count args4804)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4805
        getSessionToken))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4805
        getSessionToken
        (securitytoken/get-session-token-request
         (clojure.core/nth args4804 0))))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__1651__auto__]
    {:args [],
     :client :sts,
     :fn :get-session-token,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sts,
     :fn :get-session-token,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-session-token
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Call getSessionToken, getSessionToken"}
   [credentials4807 & args4808]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4809
     (com.palletops.awaze.common/aws-client :sts credentials4807)]
    (clojure.core/case
     (clojure.core/count args4808)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4809
       getSessionToken))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4809
       getSessionToken
       (securitytoken/get-session-token-request
        (clojure.core/nth args4808 0))))))))
 (do
  (clojure.core/defmethod
   sts
   :decode-authorization-message
   [m4810]
   (clojure.core/let
    [credentials4811 (:credentials m4810) args4812 (:args m4810)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4813
      (com.palletops.awaze.common/aws-client :sts credentials4811)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4813
       decodeAuthorizationMessage
       (securitytoken/decode-authorization-message-request
        (clojure.core/nth args4812 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener encoded-message]}]]),
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sts,
     :fn :decode-authorization-message,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener encoded-message]}]]),
    :doc "Call decodeAuthorizationMessage"}
   [credentials4815 & args4816]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4817
     (com.palletops.awaze.common/aws-client :sts credentials4815)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4817
      decodeAuthorizationMessage
      (securitytoken/decode-authorization-message-request
       (clojure.core/nth args4816 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :assume-role-with-saml
   [m4818]
   (clojure.core/let
    [credentials4819 (:credentials m4818) args4820 (:args m4818)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4821
      (com.palletops.awaze.common/aws-client :sts credentials4819)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4821
       assumeRoleWithSAML
       (securitytoken/assume-role-with-samlrequest
        (clojure.core/nth args4820 0)))))))
  (clojure.core/defn
   assume-role-with-saml-map
   {:arglists (quote
               [[credentials
                 {:keys [principal-arn
                         duration-seconds
                         role-arn
                         policy
                         general-progress-listener
                         samlassertion]}]]),
    :doc "Generate map for assumeRoleWithSAML"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sts,
     :fn :assume-role-with-saml,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   assume-role-with-saml
   {:arglists (quote
               [[credentials
                 {:keys [principal-arn
                         duration-seconds
                         role-arn
                         policy
                         general-progress-listener
                         samlassertion]}]]),
    :doc "Call assumeRoleWithSAML"}
   [credentials4823 & args4824]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4825
     (com.palletops.awaze.common/aws-client :sts credentials4823)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4825
      assumeRoleWithSAML
      (securitytoken/assume-role-with-samlrequest
       (clojure.core/nth args4824 0))))))))
