(ns
 com.palletops.awaze.sqs
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sqs :as sqs]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sqs
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.sqs.AmazonSQSClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.MessageAttributeValue}
message-attribute-value
  [m8515]
  (clojure.core/let
   [bean8514
    (new com.amazonaws.services.sqs.model.MessageAttributeValue)]
   (clojure.core/let
    [v8516
     (:data-type m8515 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8516 :com.palletops.awaze.client-builder/undef)
     (. bean8514 setDataType (clojure.core/str v8516))))
   (clojure.core/let
    [v8516
     (:string-value m8515 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8516 :com.palletops.awaze.client-builder/undef)
     (. bean8514 setStringValue (clojure.core/str v8516))))
   (clojure.core/let
    [v8516
     (:binary-value m8515 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8516 :com.palletops.awaze.client-builder/undef)
     (. bean8514 setBinaryValue (clojure.core/identity v8516))))
   (clojure.core/let
    [v8516
     (:string-list-values
      m8515
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8516 :com.palletops.awaze.client-builder/undef)
     (.
      bean8514
      setStringListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8574] (clojure.core/str arg8574))
 v8516))))
   (clojure.core/let
    [v8516
     (:binary-list-values
      m8515
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8516 :com.palletops.awaze.client-builder/undef)
     (.
      bean8514
      setBinaryListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8575] (clojure.core/identity arg8575))
 v8516))))
   bean8514))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry}
change-message-visibility-batch-request-entry
  [m8518]
  (clojure.core/let
   [bean8517
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry)]
   (clojure.core/let
    [v8519 (:id m8518 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8519 :com.palletops.awaze.client-builder/undef)
     (. bean8517 setId (clojure.core/str v8519))))
   (clojure.core/let
    [v8519
     (:receipt-handle m8518 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8519 :com.palletops.awaze.client-builder/undef)
     (. bean8517 setReceiptHandle (clojure.core/str v8519))))
   (clojure.core/let
    [v8519
     (:visibility-timeout
      m8518
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8519 :com.palletops.awaze.client-builder/undef)
     (. bean8517 setVisibilityTimeout (clojure.core/int v8519))))
   bean8517))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry}
send-message-batch-request-entry
  [m8521]
  (clojure.core/let
   [bean8520
    (new
     com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry)]
   (clojure.core/let
    [v8522 (:id m8521 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8522 :com.palletops.awaze.client-builder/undef)
     (. bean8520 setId (clojure.core/str v8522))))
   (clojure.core/let
    [v8522
     (:message-attributes
      m8521
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8522 :com.palletops.awaze.client-builder/undef)
     (.
      bean8520
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8576] (clojure.core/str arg8576))
  (clojure.core/keys v8522))
 (clojure.core/map
  (clojure.core/fn [arg8576] (sqs/message-attribute-value arg8576))
  (clojure.core/vals v8522))))))
   (clojure.core/let
    [v8522
     (:message-body m8521 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8522 :com.palletops.awaze.client-builder/undef)
     (. bean8520 setMessageBody (clojure.core/str v8522))))
   (clojure.core/let
    [v8522
     (:delay-seconds m8521 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8522 :com.palletops.awaze.client-builder/undef)
     (. bean8520 setDelaySeconds (clojure.core/int v8522))))
   bean8520))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry}
delete-message-batch-request-entry
  [m8524]
  (clojure.core/let
   [bean8523
    (new
     com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry)]
   (clojure.core/let
    [v8525 (:id m8524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8525 :com.palletops.awaze.client-builder/undef)
     (. bean8523 setId (clojure.core/str v8525))))
   (clojure.core/let
    [v8525
     (:receipt-handle m8524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8525 :com.palletops.awaze.client-builder/undef)
     (. bean8523 setReceiptHandle (clojure.core/str v8525))))
   bean8523))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueAttributesRequest}
get-queue-attributes-request
  [m8527]
  (clojure.core/let
   [bean8526
    (new com.amazonaws.services.sqs.model.GetQueueAttributesRequest)]
   (clojure.core/let
    [v8528
     (:attribute-names
      m8527
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8528 :com.palletops.awaze.client-builder/undef)
     (.
      bean8526
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8577] (clojure.core/str arg8577))
 v8528))))
   (clojure.core/let
    [v8528
     (:queue-url m8527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8528 :com.palletops.awaze.client-builder/undef)
     (. bean8526 setQueueUrl (clojure.core/str v8528))))
   bean8526))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest}
change-message-visibility-batch-request
  [m8530]
  (clojure.core/let
   [bean8529
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest)]
   (clojure.core/let
    [v8531
     (:queue-url m8530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8531 :com.palletops.awaze.client-builder/undef)
     (. bean8529 setQueueUrl (clojure.core/str v8531))))
   (clojure.core/let
    [v8531 (:entries m8530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8531 :com.palletops.awaze.client-builder/undef)
     (.
      bean8529
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8578]
  (sqs/change-message-visibility-batch-request-entry arg8578))
 v8531))))
   bean8529))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageRequest}
send-message-request
  [m8533]
  (clojure.core/let
   [bean8532
    (new com.amazonaws.services.sqs.model.SendMessageRequest)]
   (clojure.core/let
    [v8534
     (:message-attributes
      m8533
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8534 :com.palletops.awaze.client-builder/undef)
     (.
      bean8532
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8579] (clojure.core/str arg8579))
  (clojure.core/keys v8534))
 (clojure.core/map
  (clojure.core/fn [arg8579] (sqs/message-attribute-value arg8579))
  (clojure.core/vals v8534))))))
   (clojure.core/let
    [v8534
     (:queue-url m8533 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8534 :com.palletops.awaze.client-builder/undef)
     (. bean8532 setQueueUrl (clojure.core/str v8534))))
   (clojure.core/let
    [v8534
     (:message-body m8533 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8534 :com.palletops.awaze.client-builder/undef)
     (. bean8532 setMessageBody (clojure.core/str v8534))))
   (clojure.core/let
    [v8534
     (:delay-seconds m8533 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8534 :com.palletops.awaze.client-builder/undef)
     (. bean8532 setDelaySeconds (clojure.core/int v8534))))
   bean8532))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
list-queues-request
  [m8536]
  (clojure.core/let
   [bean8535 (new com.amazonaws.services.sqs.model.ListQueuesRequest)]
   (clojure.core/let
    [v8537
     (:queue-name-prefix
      m8536
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8537 :com.palletops.awaze.client-builder/undef)
     (. bean8535 setQueueNamePrefix (clojure.core/str v8537))))
   bean8535))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.AddPermissionRequest}
add-permission-request
  [m8539]
  (clojure.core/let
   [bean8538
    (new com.amazonaws.services.sqs.model.AddPermissionRequest)]
   (clojure.core/let
    [v8540 (:label m8539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8540 :com.palletops.awaze.client-builder/undef)
     (. bean8538 setLabel (clojure.core/str v8540))))
   (clojure.core/let
    [v8540
     (:awsaccount-ids m8539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8540 :com.palletops.awaze.client-builder/undef)
     (.
      bean8538
      setAWSAccountIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8580] (clojure.core/str arg8580))
 v8540))))
   (clojure.core/let
    [v8540
     (:queue-url m8539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8540 :com.palletops.awaze.client-builder/undef)
     (. bean8538 setQueueUrl (clojure.core/str v8540))))
   (clojure.core/let
    [v8540 (:actions m8539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8540 :com.palletops.awaze.client-builder/undef)
     (.
      bean8538
      setActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8581] (clojure.core/str arg8581))
 v8540))))
   bean8538))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest}
list-dead-letter-source-queues-request
  [m8542]
  (clojure.core/let
   [bean8541
    (new
     com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest)]
   (clojure.core/let
    [v8543
     (:queue-url m8542 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8543 :com.palletops.awaze.client-builder/undef)
     (. bean8541 setQueueUrl (clojure.core/str v8543))))
   bean8541))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageRequest}
delete-message-request
  [m8545]
  (clojure.core/let
   [bean8544
    (new com.amazonaws.services.sqs.model.DeleteMessageRequest)]
   (clojure.core/let
    [v8546
     (:queue-url m8545 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8546 :com.palletops.awaze.client-builder/undef)
     (. bean8544 setQueueUrl (clojure.core/str v8546))))
   (clojure.core/let
    [v8546
     (:receipt-handle m8545 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8546 :com.palletops.awaze.client-builder/undef)
     (. bean8544 setReceiptHandle (clojure.core/str v8546))))
   bean8544))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
create-queue-request
  [m8548]
  (clojure.core/let
   [bean8547
    (new com.amazonaws.services.sqs.model.CreateQueueRequest)]
   (clojure.core/let
    [v8549
     (:queue-name m8548 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8549 :com.palletops.awaze.client-builder/undef)
     (. bean8547 setQueueName (clojure.core/str v8549))))
   (clojure.core/let
    [v8549
     (:attributes m8548 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8549 :com.palletops.awaze.client-builder/undef)
     (.
      bean8547
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8582] (clojure.core/str arg8582))
  (clojure.core/keys v8549))
 (clojure.core/map
  (clojure.core/fn [arg8582] (clojure.core/str arg8582))
  (clojure.core/vals v8549))))))
   bean8547))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest}
change-message-visibility-request
  [m8551]
  (clojure.core/let
   [bean8550
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest)]
   (clojure.core/let
    [v8552
     (:queue-url m8551 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8552 :com.palletops.awaze.client-builder/undef)
     (. bean8550 setQueueUrl (clojure.core/str v8552))))
   (clojure.core/let
    [v8552
     (:receipt-handle m8551 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8552 :com.palletops.awaze.client-builder/undef)
     (. bean8550 setReceiptHandle (clojure.core/str v8552))))
   (clojure.core/let
    [v8552
     (:visibility-timeout
      m8551
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8552 :com.palletops.awaze.client-builder/undef)
     (. bean8550 setVisibilityTimeout (clojure.core/int v8552))))
   bean8550))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequest}
send-message-batch-request
  [m8554]
  (clojure.core/let
   [bean8553
    (new com.amazonaws.services.sqs.model.SendMessageBatchRequest)]
   (clojure.core/let
    [v8555
     (:queue-url m8554 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8555 :com.palletops.awaze.client-builder/undef)
     (. bean8553 setQueueUrl (clojure.core/str v8555))))
   (clojure.core/let
    [v8555 (:entries m8554 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8555 :com.palletops.awaze.client-builder/undef)
     (.
      bean8553
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8583]
  (sqs/send-message-batch-request-entry arg8583))
 v8555))))
   bean8553))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
delete-queue-request
  [m8557]
  (clojure.core/let
   [bean8556
    (new com.amazonaws.services.sqs.model.DeleteQueueRequest)]
   (clojure.core/let
    [v8558
     (:queue-url m8557 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8558 :com.palletops.awaze.client-builder/undef)
     (. bean8556 setQueueUrl (clojure.core/str v8558))))
   bean8556))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
receive-message-request
  [m8560]
  (clojure.core/let
   [bean8559
    (new com.amazonaws.services.sqs.model.ReceiveMessageRequest)]
   (clojure.core/let
    [v8561
     (:attribute-names
      m8560
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8561 :com.palletops.awaze.client-builder/undef)
     (.
      bean8559
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8584] (clojure.core/str arg8584))
 v8561))))
   (clojure.core/let
    [v8561
     (:queue-url m8560 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8561 :com.palletops.awaze.client-builder/undef)
     (. bean8559 setQueueUrl (clojure.core/str v8561))))
   (clojure.core/let
    [v8561
     (:visibility-timeout
      m8560
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8561 :com.palletops.awaze.client-builder/undef)
     (. bean8559 setVisibilityTimeout (clojure.core/int v8561))))
   (clojure.core/let
    [v8561
     (:message-attribute-names
      m8560
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8561 :com.palletops.awaze.client-builder/undef)
     (.
      bean8559
      setMessageAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8585] (clojure.core/str arg8585))
 v8561))))
   (clojure.core/let
    [v8561
     (:max-number-of-messages
      m8560
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8561 :com.palletops.awaze.client-builder/undef)
     (. bean8559 setMaxNumberOfMessages (clojure.core/int v8561))))
   (clojure.core/let
    [v8561
     (:wait-time-seconds
      m8560
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8561 :com.palletops.awaze.client-builder/undef)
     (. bean8559 setWaitTimeSeconds (clojure.core/int v8561))))
   bean8559))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SetQueueAttributesRequest}
set-queue-attributes-request
  [m8563]
  (clojure.core/let
   [bean8562
    (new com.amazonaws.services.sqs.model.SetQueueAttributesRequest)]
   (clojure.core/let
    [v8564
     (:queue-url m8563 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8564 :com.palletops.awaze.client-builder/undef)
     (. bean8562 setQueueUrl (clojure.core/str v8564))))
   (clojure.core/let
    [v8564
     (:attributes m8563 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8564 :com.palletops.awaze.client-builder/undef)
     (.
      bean8562
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8586] (clojure.core/str arg8586))
  (clojure.core/keys v8564))
 (clojure.core/map
  (clojure.core/fn [arg8586] (clojure.core/str arg8586))
  (clojure.core/vals v8564))))))
   bean8562))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.RemovePermissionRequest}
remove-permission-request
  [m8566]
  (clojure.core/let
   [bean8565
    (new com.amazonaws.services.sqs.model.RemovePermissionRequest)]
   (clojure.core/let
    [v8567 (:label m8566 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8567 :com.palletops.awaze.client-builder/undef)
     (. bean8565 setLabel (clojure.core/str v8567))))
   (clojure.core/let
    [v8567
     (:queue-url m8566 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8567 :com.palletops.awaze.client-builder/undef)
     (. bean8565 setQueueUrl (clojure.core/str v8567))))
   bean8565))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequest}
delete-message-batch-request
  [m8569]
  (clojure.core/let
   [bean8568
    (new com.amazonaws.services.sqs.model.DeleteMessageBatchRequest)]
   (clojure.core/let
    [v8570
     (:queue-url m8569 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8570 :com.palletops.awaze.client-builder/undef)
     (. bean8568 setQueueUrl (clojure.core/str v8570))))
   (clojure.core/let
    [v8570 (:entries m8569 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8570 :com.palletops.awaze.client-builder/undef)
     (.
      bean8568
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8587]
  (sqs/delete-message-batch-request-entry arg8587))
 v8570))))
   bean8568))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
get-queue-url-request
  [m8572]
  (clojure.core/let
   [bean8571
    (new com.amazonaws.services.sqs.model.GetQueueUrlRequest)]
   (clojure.core/let
    [v8573
     (:queue-name m8572 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8573 :com.palletops.awaze.client-builder/undef)
     (. bean8571 setQueueName (clojure.core/str v8573))))
   (clojure.core/let
    [v8573
     (:queue-owner-awsaccount-id
      m8572
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8573 :com.palletops.awaze.client-builder/undef)
     (. bean8571 setQueueOwnerAWSAccountId (clojure.core/str v8573))))
   bean8571))
 (clojure.core/defmulti
  sqs
  (clojure.core/fn sqs [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-attributes
   [m8588]
   (clojure.core/let
    [credentials8589 (:credentials m8588) args8590 (:args m8588)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8591
      (com.palletops.awaze.common/aws-client :sqs credentials8589)]
     (clojure.core/case
      (clojure.core/count args8590)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8591
        getQueueAttributes
        (sqs/get-queue-attributes-request
         (clojure.core/nth args8590 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8591
        getQueueAttributes
        (clojure.core/str (clojure.core/nth args8590 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8604] (clojure.core/str arg8604))
 (clojure.core/nth args8590 1))))))))
  (clojure.core/defn
   get-queue-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url
                         general-progress-listener
                         attribute-names]}]
                [credentials string-0 list-1]]),
    :doc "Generate map for getQueueAttributes, getQueueAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :get-queue-attributes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :get-queue-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-queue-attributes
   {:arglists (quote
               [[credentials
                 {:keys [queue-url
                         general-progress-listener
                         attribute-names]}]
                [credentials string-0 list-1]]),
    :doc "Call getQueueAttributes, getQueueAttributes"}
   [credentials8593 & args8594]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8595
     (com.palletops.awaze.common/aws-client :sqs credentials8593)]
    (clojure.core/case
     (clojure.core/count args8594)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8595
       getQueueAttributes
       (sqs/get-queue-attributes-request
        (clojure.core/nth args8594 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8595
       getQueueAttributes
       (clojure.core/str (clojure.core/nth args8594 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8605] (clojure.core/str arg8605))
 (clojure.core/nth args8594 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility-batch
   [m8596]
   (clojure.core/let
    [credentials8597 (:credentials m8596) args8598 (:args m8596)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8599
      (com.palletops.awaze.common/aws-client :sqs credentials8597)]
     (clojure.core/case
      (clojure.core/count args8598)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8599
        changeMessageVisibilityBatch
        (clojure.core/str (clojure.core/nth args8598 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8614]
  (sqs/change-message-visibility-batch-request-entry arg8614))
 (clojure.core/nth args8598 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8599
        changeMessageVisibilityBatch
        (sqs/change-message-visibility-batch-request
         (clojure.core/nth args8598 0))))))))
  (clojure.core/defn
   change-message-visibility-batch-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [queue-url general-progress-listener entries]}]]),
    :doc "Generate map for changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :change-message-visibility-batch,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :change-message-visibility-batch,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   change-message-visibility-batch
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [queue-url general-progress-listener entries]}]]),
    :doc "Call changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   [credentials8601 & args8602]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8603
     (com.palletops.awaze.common/aws-client :sqs credentials8601)]
    (clojure.core/case
     (clojure.core/count args8602)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8603
       changeMessageVisibilityBatch
       (clojure.core/str (clojure.core/nth args8602 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8615]
  (sqs/change-message-visibility-batch-request-entry arg8615))
 (clojure.core/nth args8602 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8603
       changeMessageVisibilityBatch
       (sqs/change-message-visibility-batch-request
        (clojure.core/nth args8602 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message
   [m8606]
   (clojure.core/let
    [credentials8607 (:credentials m8606) args8608 (:args m8606)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8609
      (com.palletops.awaze.common/aws-client :sqs credentials8607)]
     (clojure.core/case
      (clojure.core/count args8608)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8609
        sendMessage
        (sqs/send-message-request (clojure.core/nth args8608 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8609
        sendMessage
        (clojure.core/str (clojure.core/nth args8608 0))
        (clojure.core/str (clojure.core/nth args8608 1))))))))
  (clojure.core/defn
   send-message-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url
                         message-body
                         message-attributes
                         general-progress-listener
                         delay-seconds]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for sendMessage, sendMessage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :send-message,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :send-message,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   send-message
   {:arglists (quote
               [[credentials
                 {:keys [queue-url
                         message-body
                         message-attributes
                         general-progress-listener
                         delay-seconds]}]
                [credentials string-0 string-1]]),
    :doc "Call sendMessage, sendMessage"}
   [credentials8611 & args8612]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8613
     (com.palletops.awaze.common/aws-client :sqs credentials8611)]
    (clojure.core/case
     (clojure.core/count args8612)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8613
       sendMessage
       (sqs/send-message-request (clojure.core/nth args8612 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8613
       sendMessage
       (clojure.core/str (clojure.core/nth args8612 0))
       (clojure.core/str (clojure.core/nth args8612 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-queues
   [m8616]
   (clojure.core/let
    [credentials8617 (:credentials m8616) args8618 (:args m8616)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8619
      (com.palletops.awaze.common/aws-client :sqs credentials8617)]
     (clojure.core/case
      (clojure.core/count args8618)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.ListQueuesRequest
           (clojure.core/nth args8618 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8619
           listQueues
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8618 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8619
               listQueues
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listQueues")
                {:args args8618}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8619
        listQueues))))))
  (clojure.core/defn
   list-queues-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-name-prefix general-progress-listener]}]
                [credentials string-0]
                [credentials]]),
    :doc "Generate map for listQueues, listQueues, listQueues"}
   ([credentials__1651__auto__]
    {:args [],
     :client :sqs,
     :fn :list-queues,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :list-queues,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-queues
   {:arglists (quote
               [[credentials
                 {:keys [queue-name-prefix general-progress-listener]}]
                [credentials string-0]
                [credentials]]),
    :doc "Call listQueues, listQueues, listQueues"}
   [credentials8621 & args8622]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8623
     (com.palletops.awaze.common/aws-client :sqs credentials8621)]
    (clojure.core/case
     (clojure.core/count args8622)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.ListQueuesRequest
          (clojure.core/nth args8622 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8623
          listQueues
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8622 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8623
              listQueues
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listQueues")
               {:args args8622}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8623
       listQueues))))))
 (do
  (clojure.core/defmethod
   sqs
   :add-permission
   [m8624]
   (clojure.core/let
    [credentials8625 (:credentials m8624) args8626 (:args m8624)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8627
      (com.palletops.awaze.common/aws-client :sqs credentials8625)]
     (clojure.core/case
      (clojure.core/count args8626)
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8627
        addPermission
        (clojure.core/str (clojure.core/nth args8626 0))
        (clojure.core/str (clojure.core/nth args8626 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8640] (clojure.core/str arg8640))
 (clojure.core/nth args8626 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8641] (clojure.core/str arg8641))
 (clojure.core/nth args8626 3))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8627
        addPermission
        (sqs/add-permission-request (clojure.core/nth args8626 0))))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials string-0 string-1 list-2 list-3]
                [credentials
                 {:keys [queue-url
                         label
                         general-progress-listener
                         actions
                         awsaccount-ids]}]]),
    :doc "Generate map for addPermission, addPermission"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :add-permission,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c d]
    {:args [a b c d],
     :client :sqs,
     :fn :add-permission,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials string-0 string-1 list-2 list-3]
                [credentials
                 {:keys [queue-url
                         label
                         general-progress-listener
                         actions
                         awsaccount-ids]}]]),
    :doc "Call addPermission, addPermission"}
   [credentials8629 & args8630]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8631
     (com.palletops.awaze.common/aws-client :sqs credentials8629)]
    (clojure.core/case
     (clojure.core/count args8630)
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8631
       addPermission
       (clojure.core/str (clojure.core/nth args8630 0))
       (clojure.core/str (clojure.core/nth args8630 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8642] (clojure.core/str arg8642))
 (clojure.core/nth args8630 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8643] (clojure.core/str arg8643))
 (clojure.core/nth args8630 3))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8631
       addPermission
       (sqs/add-permission-request (clojure.core/nth args8630 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-dead-letter-source-queues
   [m8632]
   (clojure.core/let
    [credentials8633 (:credentials m8632) args8634 (:args m8632)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8635
      (com.palletops.awaze.common/aws-client :sqs credentials8633)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8635
       listDeadLetterSourceQueues
       (sqs/list-dead-letter-source-queues-request
        (clojure.core/nth args8634 0)))))))
  (clojure.core/defn
   list-dead-letter-source-queues-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener]}]]),
    :doc "Generate map for listDeadLetterSourceQueues"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :list-dead-letter-source-queues,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-dead-letter-source-queues
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener]}]]),
    :doc "Call listDeadLetterSourceQueues"}
   [credentials8637 & args8638]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8639
     (com.palletops.awaze.common/aws-client :sqs credentials8637)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8639
      listDeadLetterSourceQueues
      (sqs/list-dead-letter-source-queues-request
       (clojure.core/nth args8638 0)))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message
   [m8644]
   (clojure.core/let
    [credentials8645 (:credentials m8644) args8646 (:args m8644)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8647
      (com.palletops.awaze.common/aws-client :sqs credentials8645)]
     (clojure.core/case
      (clojure.core/count args8646)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8647
        deleteMessage
        (clojure.core/str (clojure.core/nth args8646 0))
        (clojure.core/str (clojure.core/nth args8646 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8647
        deleteMessage
        (sqs/delete-message-request (clojure.core/nth args8646 0))))))))
  (clojure.core/defn
   delete-message-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [receipt-handle
                         queue-url
                         general-progress-listener]}]]),
    :doc "Generate map for deleteMessage, deleteMessage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :delete-message,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :delete-message,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-message
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [receipt-handle
                         queue-url
                         general-progress-listener]}]]),
    :doc "Call deleteMessage, deleteMessage"}
   [credentials8649 & args8650]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8651
     (com.palletops.awaze.common/aws-client :sqs credentials8649)]
    (clojure.core/case
     (clojure.core/count args8650)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8651
       deleteMessage
       (clojure.core/str (clojure.core/nth args8650 0))
       (clojure.core/str (clojure.core/nth args8650 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8651
       deleteMessage
       (sqs/delete-message-request (clojure.core/nth args8650 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :create-queue
   [m8652]
   (clojure.core/let
    [credentials8653 (:credentials m8652) args8654 (:args m8652)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8655
      (com.palletops.awaze.common/aws-client :sqs credentials8653)]
     (clojure.core/case
      (clojure.core/count args8654)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.CreateQueueRequest
           (clojure.core/nth args8654 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8655
           createQueue
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8654 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8655
               createQueue
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createQueue")
                {:args args8654}))))))))))))))
  (clojure.core/defn
   create-queue-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-name
                         general-progress-listener
                         attributes]}]
                [credentials string-0]]),
    :doc "Generate map for createQueue, createQueue"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :create-queue,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-queue
   {:arglists (quote
               [[credentials
                 {:keys [queue-name
                         general-progress-listener
                         attributes]}]
                [credentials string-0]]),
    :doc "Call createQueue, createQueue"}
   [credentials8657 & args8658]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8659
     (com.palletops.awaze.common/aws-client :sqs credentials8657)]
    (clojure.core/case
     (clojure.core/count args8658)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.CreateQueueRequest
          (clojure.core/nth args8658 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8659
          createQueue
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8658 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8659
              createQueue
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createQueue")
               {:args args8658}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility
   [m8660]
   (clojure.core/let
    [credentials8661 (:credentials m8660) args8662 (:args m8660)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8663
      (com.palletops.awaze.common/aws-client :sqs credentials8661)]
     (clojure.core/case
      (clojure.core/count args8662)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8663
        changeMessageVisibility
        (sqs/change-message-visibility-request
         (clojure.core/nth args8662 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8663
        changeMessageVisibility
        (clojure.core/str (clojure.core/nth args8662 0))
        (clojure.core/str (clojure.core/nth args8662 1))
        (clojure.core/int (clojure.core/nth args8662 2))))))))
  (clojure.core/defn
   change-message-visibility-map
   {:arglists (quote
               [[credentials
                 {:keys [visibility-timeout
                         receipt-handle
                         queue-url
                         general-progress-listener]}]
                [credentials string-0 string-1 integer-2]]),
    :doc "Generate map for changeMessageVisibility, changeMessageVisibility"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :change-message-visibility,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :sqs,
     :fn :change-message-visibility,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   change-message-visibility
   {:arglists (quote
               [[credentials
                 {:keys [visibility-timeout
                         receipt-handle
                         queue-url
                         general-progress-listener]}]
                [credentials string-0 string-1 integer-2]]),
    :doc "Call changeMessageVisibility, changeMessageVisibility"}
   [credentials8665 & args8666]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8667
     (com.palletops.awaze.common/aws-client :sqs credentials8665)]
    (clojure.core/case
     (clojure.core/count args8666)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8667
       changeMessageVisibility
       (sqs/change-message-visibility-request
        (clojure.core/nth args8666 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8667
       changeMessageVisibility
       (clojure.core/str (clojure.core/nth args8666 0))
       (clojure.core/str (clojure.core/nth args8666 1))
       (clojure.core/int (clojure.core/nth args8666 2))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message-batch
   [m8668]
   (clojure.core/let
    [credentials8669 (:credentials m8668) args8670 (:args m8668)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8671
      (com.palletops.awaze.common/aws-client :sqs credentials8669)]
     (clojure.core/case
      (clojure.core/count args8670)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8671
        sendMessageBatch
        (sqs/send-message-batch-request (clojure.core/nth args8670 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8671
        sendMessageBatch
        (clojure.core/str (clojure.core/nth args8670 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8684]
  (sqs/send-message-batch-request-entry arg8684))
 (clojure.core/nth args8670 1))))))))
  (clojure.core/defn
   send-message-batch-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener entries]}]
                [credentials string-0 list-1]]),
    :doc "Generate map for sendMessageBatch, sendMessageBatch"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :send-message-batch,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :send-message-batch,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   send-message-batch
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener entries]}]
                [credentials string-0 list-1]]),
    :doc "Call sendMessageBatch, sendMessageBatch"}
   [credentials8673 & args8674]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8675
     (com.palletops.awaze.common/aws-client :sqs credentials8673)]
    (clojure.core/case
     (clojure.core/count args8674)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8675
       sendMessageBatch
       (sqs/send-message-batch-request (clojure.core/nth args8674 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8675
       sendMessageBatch
       (clojure.core/str (clojure.core/nth args8674 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8685]
  (sqs/send-message-batch-request-entry arg8685))
 (clojure.core/nth args8674 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-queue
   [m8676]
   (clojure.core/let
    [credentials8677 (:credentials m8676) args8678 (:args m8676)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8679
      (com.palletops.awaze.common/aws-client :sqs credentials8677)]
     (clojure.core/case
      (clojure.core/count args8678)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8678 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8679
           deleteQueue
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.DeleteQueueRequest
               (clojure.core/nth args8678 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8679
               deleteQueue
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteQueue")
                {:args args8678}))))))))))))))
  (clojure.core/defn
   delete-queue-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [queue-url general-progress-listener]}]]),
    :doc "Generate map for deleteQueue, deleteQueue"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :delete-queue,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-queue
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [queue-url general-progress-listener]}]]),
    :doc "Call deleteQueue, deleteQueue"}
   [credentials8681 & args8682]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8683
     (com.palletops.awaze.common/aws-client :sqs credentials8681)]
    (clojure.core/case
     (clojure.core/count args8682)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8682 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8683
          deleteQueue
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.DeleteQueueRequest
              (clojure.core/nth args8682 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8683
              deleteQueue
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteQueue")
               {:args args8682}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :receive-message
   [m8686]
   (clojure.core/let
    [credentials8687 (:credentials m8686) args8688 (:args m8686)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8689
      (com.palletops.awaze.common/aws-client :sqs credentials8687)]
     (clojure.core/case
      (clojure.core/count args8688)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8688 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8689
           receiveMessage
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.ReceiveMessageRequest
               (clojure.core/nth args8688 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8689
               receiveMessage
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "receiveMessage")
                {:args args8688}))))))))))))))
  (clojure.core/defn
   receive-message-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener
                         message-attribute-names
                         queue-url
                         wait-time-seconds
                         attribute-names
                         max-number-of-messages
                         visibility-timeout]}]]),
    :doc "Generate map for receiveMessage, receiveMessage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :receive-message,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   receive-message
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener
                         message-attribute-names
                         queue-url
                         wait-time-seconds
                         attribute-names
                         max-number-of-messages
                         visibility-timeout]}]]),
    :doc "Call receiveMessage, receiveMessage"}
   [credentials8691 & args8692]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8693
     (com.palletops.awaze.common/aws-client :sqs credentials8691)]
    (clojure.core/case
     (clojure.core/count args8692)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8692 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8693
          receiveMessage
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.ReceiveMessageRequest
              (clojure.core/nth args8692 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8693
              receiveMessage
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "receiveMessage")
               {:args args8692}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :set-queue-attributes
   [m8694]
   (clojure.core/let
    [credentials8695 (:credentials m8694) args8696 (:args m8694)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8697
      (com.palletops.awaze.common/aws-client :sqs credentials8695)]
     (clojure.core/case
      (clojure.core/count args8696)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8697
        setQueueAttributes
        (sqs/set-queue-attributes-request
         (clojure.core/nth args8696 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8697
        setQueueAttributes
        (clojure.core/str (clojure.core/nth args8696 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8710] (clojure.core/str arg8710))
  (clojure.core/keys (clojure.core/nth args8696 1)))
 (clojure.core/map
  (clojure.core/fn [arg8710] (clojure.core/str arg8710))
  (clojure.core/vals (clojure.core/nth args8696 1))))))))))
  (clojure.core/defn
   set-queue-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url
                         general-progress-listener
                         attributes]}]
                [credentials string-0 map-1]]),
    :doc "Generate map for setQueueAttributes, setQueueAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :set-queue-attributes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :set-queue-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-queue-attributes
   {:arglists (quote
               [[credentials
                 {:keys [queue-url
                         general-progress-listener
                         attributes]}]
                [credentials string-0 map-1]]),
    :doc "Call setQueueAttributes, setQueueAttributes"}
   [credentials8699 & args8700]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8701
     (com.palletops.awaze.common/aws-client :sqs credentials8699)]
    (clojure.core/case
     (clojure.core/count args8700)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8701
       setQueueAttributes
       (sqs/set-queue-attributes-request
        (clojure.core/nth args8700 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8701
       setQueueAttributes
       (clojure.core/str (clojure.core/nth args8700 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8711] (clojure.core/str arg8711))
  (clojure.core/keys (clojure.core/nth args8700 1)))
 (clojure.core/map
  (clojure.core/fn [arg8711] (clojure.core/str arg8711))
  (clojure.core/vals (clojure.core/nth args8700 1))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :remove-permission
   [m8702]
   (clojure.core/let
    [credentials8703 (:credentials m8702) args8704 (:args m8702)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8705
      (com.palletops.awaze.common/aws-client :sqs credentials8703)]
     (clojure.core/case
      (clojure.core/count args8704)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8705
        removePermission
        (sqs/remove-permission-request (clojure.core/nth args8704 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8705
        removePermission
        (clojure.core/str (clojure.core/nth args8704 0))
        (clojure.core/str (clojure.core/nth args8704 1))))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url label general-progress-listener]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for removePermission, removePermission"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :remove-permission,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :remove-permission,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials
                 {:keys [queue-url label general-progress-listener]}]
                [credentials string-0 string-1]]),
    :doc "Call removePermission, removePermission"}
   [credentials8707 & args8708]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8709
     (com.palletops.awaze.common/aws-client :sqs credentials8707)]
    (clojure.core/case
     (clojure.core/count args8708)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8709
       removePermission
       (sqs/remove-permission-request (clojure.core/nth args8708 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8709
       removePermission
       (clojure.core/str (clojure.core/nth args8708 0))
       (clojure.core/str (clojure.core/nth args8708 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message-batch
   [m8712]
   (clojure.core/let
    [credentials8713 (:credentials m8712) args8714 (:args m8712)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8715
      (com.palletops.awaze.common/aws-client :sqs credentials8713)]
     (clojure.core/case
      (clojure.core/count args8714)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8715
        deleteMessageBatch
        (clojure.core/str (clojure.core/nth args8714 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8728]
  (sqs/delete-message-batch-request-entry arg8728))
 (clojure.core/nth args8714 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8715
        deleteMessageBatch
        (sqs/delete-message-batch-request
         (clojure.core/nth args8714 0))))))))
  (clojure.core/defn
   delete-message-batch-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [queue-url general-progress-listener entries]}]]),
    :doc "Generate map for deleteMessageBatch, deleteMessageBatch"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :delete-message-batch,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :delete-message-batch,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-message-batch
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [queue-url general-progress-listener entries]}]]),
    :doc "Call deleteMessageBatch, deleteMessageBatch"}
   [credentials8717 & args8718]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8719
     (com.palletops.awaze.common/aws-client :sqs credentials8717)]
    (clojure.core/case
     (clojure.core/count args8718)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8719
       deleteMessageBatch
       (clojure.core/str (clojure.core/nth args8718 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8729]
  (sqs/delete-message-batch-request-entry arg8729))
 (clojure.core/nth args8718 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8719
       deleteMessageBatch
       (sqs/delete-message-batch-request
        (clojure.core/nth args8718 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-url
   [m8720]
   (clojure.core/let
    [credentials8721 (:credentials m8720) args8722 (:args m8720)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8723
      (com.palletops.awaze.common/aws-client :sqs credentials8721)]
     (clojure.core/case
      (clojure.core/count args8722)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.GetQueueUrlRequest
           (clojure.core/nth args8722 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8723
           getQueueUrl
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8722 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8723
               getQueueUrl
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getQueueUrl")
                {:args args8722}))))))))))))))
  (clojure.core/defn
   get-queue-url-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-owner-awsaccount-id
                         queue-name
                         general-progress-listener]}]
                [credentials string-0]]),
    :doc "Generate map for getQueueUrl, getQueueUrl"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :get-queue-url,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-queue-url
   {:arglists (quote
               [[credentials
                 {:keys [queue-owner-awsaccount-id
                         queue-name
                         general-progress-listener]}]
                [credentials string-0]]),
    :doc "Call getQueueUrl, getQueueUrl"}
   [credentials8725 & args8726]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8727
     (com.palletops.awaze.common/aws-client :sqs credentials8725)]
    (clojure.core/case
     (clojure.core/count args8726)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.GetQueueUrlRequest
          (clojure.core/nth args8726 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8727
          getQueueUrl
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8726 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8727
              getQueueUrl
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getQueueUrl")
               {:args args8726})))))))))))))))
