(ns
 com.palletops.awaze.securitytoken
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.securitytoken :as securitytoken]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :securitytoken
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleRequest}
assume-role-request
  [m9704]
  (clojure.core/let
   [bean9703
    (new com.amazonaws.services.securitytoken.model.AssumeRoleRequest)]
   (clojure.core/let
    [v9705 (:policy m9704 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9705 :com.palletops.awaze.client-builder/undef)
     (. bean9703 setPolicy (clojure.core/str v9705))))
   (clojure.core/let
    [v9705
     (:role-arn m9704 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9705 :com.palletops.awaze.client-builder/undef)
     (. bean9703 setRoleArn (clojure.core/str v9705))))
   (clojure.core/let
    [v9705
     (:duration-seconds
      m9704
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9705 :com.palletops.awaze.client-builder/undef)
     (. bean9703 setDurationSeconds (clojure.core/int v9705))))
   (clojure.core/let
    [v9705
     (:serial-number m9704 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9705 :com.palletops.awaze.client-builder/undef)
     (. bean9703 setSerialNumber (clojure.core/str v9705))))
   (clojure.core/let
    [v9705
     (:token-code m9704 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9705 :com.palletops.awaze.client-builder/undef)
     (. bean9703 setTokenCode (clojure.core/str v9705))))
   (clojure.core/let
    [v9705
     (:role-session-name
      m9704
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9705 :com.palletops.awaze.client-builder/undef)
     (. bean9703 setRoleSessionName (clojure.core/str v9705))))
   (clojure.core/let
    [v9705
     (:external-id m9704 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9705 :com.palletops.awaze.client-builder/undef)
     (. bean9703 setExternalId (clojure.core/str v9705))))
   bean9703))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.GetFederationTokenRequest}
get-federation-token-request
  [m9707]
  (clojure.core/let
   [bean9706
    (new
     com.amazonaws.services.securitytoken.model.GetFederationTokenRequest)]
   (clojure.core/let
    [v9708 (:name m9707 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9708 :com.palletops.awaze.client-builder/undef)
     (. bean9706 setName (clojure.core/str v9708))))
   (clojure.core/let
    [v9708 (:policy m9707 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9708 :com.palletops.awaze.client-builder/undef)
     (. bean9706 setPolicy (clojure.core/str v9708))))
   (clojure.core/let
    [v9708
     (:duration-seconds
      m9707
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9708 :com.palletops.awaze.client-builder/undef)
     (. bean9706 setDurationSeconds (clojure.core/int v9708))))
   bean9706))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest}
assume-role-with-web-identity-request
  [m9710]
  (clojure.core/let
   [bean9709
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest)]
   (clojure.core/let
    [v9711 (:policy m9710 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9711 :com.palletops.awaze.client-builder/undef)
     (. bean9709 setPolicy (clojure.core/str v9711))))
   (clojure.core/let
    [v9711
     (:role-arn m9710 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9711 :com.palletops.awaze.client-builder/undef)
     (. bean9709 setRoleArn (clojure.core/str v9711))))
   (clojure.core/let
    [v9711
     (:duration-seconds
      m9710
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9711 :com.palletops.awaze.client-builder/undef)
     (. bean9709 setDurationSeconds (clojure.core/int v9711))))
   (clojure.core/let
    [v9711
     (:role-session-name
      m9710
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9711 :com.palletops.awaze.client-builder/undef)
     (. bean9709 setRoleSessionName (clojure.core/str v9711))))
   (clojure.core/let
    [v9711
     (:web-identity-token
      m9710
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9711 :com.palletops.awaze.client-builder/undef)
     (. bean9709 setWebIdentityToken (clojure.core/str v9711))))
   (clojure.core/let
    [v9711
     (:provider-id m9710 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9711 :com.palletops.awaze.client-builder/undef)
     (. bean9709 setProviderId (clojure.core/str v9711))))
   bean9709))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.GetSessionTokenRequest}
get-session-token-request
  [m9713]
  (clojure.core/let
   [bean9712
    (new
     com.amazonaws.services.securitytoken.model.GetSessionTokenRequest)]
   (clojure.core/let
    [v9714
     (:duration-seconds
      m9713
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9714 :com.palletops.awaze.client-builder/undef)
     (. bean9712 setDurationSeconds (clojure.core/int v9714))))
   (clojure.core/let
    [v9714
     (:serial-number m9713 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9714 :com.palletops.awaze.client-builder/undef)
     (. bean9712 setSerialNumber (clojure.core/str v9714))))
   (clojure.core/let
    [v9714
     (:token-code m9713 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9714 :com.palletops.awaze.client-builder/undef)
     (. bean9712 setTokenCode (clojure.core/str v9714))))
   bean9712))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest}
decode-authorization-message-request
  [m9716]
  (clojure.core/let
   [bean9715
    (new
     com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest)]
   (clojure.core/let
    [v9717
     (:encoded-message
      m9716
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9717 :com.palletops.awaze.client-builder/undef)
     (. bean9715 setEncodedMessage (clojure.core/str v9717))))
   bean9715))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest}
assume-role-with-samlrequest
  [m9719]
  (clojure.core/let
   [bean9718
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest)]
   (clojure.core/let
    [v9720 (:policy m9719 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9720 :com.palletops.awaze.client-builder/undef)
     (. bean9718 setPolicy (clojure.core/str v9720))))
   (clojure.core/let
    [v9720
     (:role-arn m9719 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9720 :com.palletops.awaze.client-builder/undef)
     (. bean9718 setRoleArn (clojure.core/str v9720))))
   (clojure.core/let
    [v9720
     (:principal-arn m9719 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9720 :com.palletops.awaze.client-builder/undef)
     (. bean9718 setPrincipalArn (clojure.core/str v9720))))
   (clojure.core/let
    [v9720
     (:samlassertion m9719 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9720 :com.palletops.awaze.client-builder/undef)
     (. bean9718 setSAMLAssertion (clojure.core/str v9720))))
   (clojure.core/let
    [v9720
     (:duration-seconds
      m9719
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9720 :com.palletops.awaze.client-builder/undef)
     (. bean9718 setDurationSeconds (clojure.core/int v9720))))
   bean9718))
 (clojure.core/defmulti
  securitytoken
  (clojure.core/fn
   securitytoken
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role
   [m9721]
   (clojure.core/let
    [credentials9722 (:credentials m9721) args9723 (:args m9721)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client9724
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials9722)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9724
       assumeRole
       (securitytoken/assume-role-request
        (clojure.core/nth args9723 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists (quote
               [[credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds
                         external-id
                         role-session-name
                         policy
                         role-arn]}]]),
    :doc "Generate map for assumeRole"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :assume-role,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   assume-role
   {:arglists (quote
               [[credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds
                         external-id
                         role-session-name
                         policy
                         role-arn]}]]),
    :doc "Call assumeRole"}
   [credentials9726 & args9727]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client9728
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials9726)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9728
      assumeRole
      (securitytoken/assume-role-request
       (clojure.core/nth args9727 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-federation-token
   [m9729]
   (clojure.core/let
    [credentials9730 (:credentials m9729) args9731 (:args m9729)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client9732
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials9730)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9732
       getFederationToken
       (securitytoken/get-federation-token-request
        (clojure.core/nth args9731 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists (quote
               [[credentials
                 {:keys [policy
                         name
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Generate map for getFederationToken"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :get-federation-token,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-federation-token
   {:arglists (quote
               [[credentials
                 {:keys [policy
                         name
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Call getFederationToken"}
   [credentials9734 & args9735]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client9736
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials9734)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9736
      getFederationToken
      (securitytoken/get-federation-token-request
       (clojure.core/nth args9735 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-web-identity
   [m9737]
   (clojure.core/let
    [credentials9738 (:credentials m9737) args9739 (:args m9737)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client9740
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials9738)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9740
       assumeRoleWithWebIdentity
       (securitytoken/assume-role-with-web-identity-request
        (clojure.core/nth args9739 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [web-identity-token
                         general-progress-listener
                         duration-seconds
                         role-session-name
                         policy
                         role-arn
                         provider-id]}]]),
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :assume-role-with-web-identity,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists (quote
               [[credentials
                 {:keys [web-identity-token
                         general-progress-listener
                         duration-seconds
                         role-session-name
                         policy
                         role-arn
                         provider-id]}]]),
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials9742 & args9743]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client9744
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials9742)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9744
      assumeRoleWithWebIdentity
      (securitytoken/assume-role-with-web-identity-request
       (clojure.core/nth args9743 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-session-token
   [m9745]
   (clojure.core/let
    [credentials9746 (:credentials m9745) args9747 (:args m9745)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client9748
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials9746)]
     (clojure.core/case
      (clojure.core/count args9747)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9748
        getSessionToken))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9748
        getSessionToken
        (securitytoken/get-session-token-request
         (clojure.core/nth args9747 0))))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__1651__auto__]
    {:args [],
     :client :securitytoken,
     :fn :get-session-token,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :get-session-token,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-session-token
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Call getSessionToken, getSessionToken"}
   [credentials9750 & args9751]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client9752
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials9750)]
    (clojure.core/case
     (clojure.core/count args9751)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9752
       getSessionToken))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9752
       getSessionToken
       (securitytoken/get-session-token-request
        (clojure.core/nth args9751 0))))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :decode-authorization-message
   [m9753]
   (clojure.core/let
    [credentials9754 (:credentials m9753) args9755 (:args m9753)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client9756
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials9754)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9756
       decodeAuthorizationMessage
       (securitytoken/decode-authorization-message-request
        (clojure.core/nth args9755 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener encoded-message]}]]),
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :decode-authorization-message,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener encoded-message]}]]),
    :doc "Call decodeAuthorizationMessage"}
   [credentials9758 & args9759]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client9760
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials9758)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9760
      decodeAuthorizationMessage
      (securitytoken/decode-authorization-message-request
       (clojure.core/nth args9759 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-saml
   [m9761]
   (clojure.core/let
    [credentials9762 (:credentials m9761) args9763 (:args m9761)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client9764
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials9762)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9764
       assumeRoleWithSAML
       (securitytoken/assume-role-with-samlrequest
        (clojure.core/nth args9763 0)))))))
  (clojure.core/defn
   assume-role-with-saml-map
   {:arglists (quote
               [[credentials
                 {:keys [principal-arn
                         duration-seconds
                         role-arn
                         policy
                         general-progress-listener
                         samlassertion]}]]),
    :doc "Generate map for assumeRoleWithSAML"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :assume-role-with-saml,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   assume-role-with-saml
   {:arglists (quote
               [[credentials
                 {:keys [principal-arn
                         duration-seconds
                         role-arn
                         policy
                         general-progress-listener
                         samlassertion]}]]),
    :doc "Call assumeRoleWithSAML"}
   [credentials9766 & args9767]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client9768
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials9766)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client9768
      assumeRoleWithSAML
      (securitytoken/assume-role-with-samlrequest
       (clojure.core/nth args9767 0))))))))
