(ns
 com.palletops.awaze.s3
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.s3 :as s3]
  [com.palletops.awaze.beans.root :as root]
  [com.palletops.awaze.beans.metrics :as metrics]
  [com.palletops.awaze.beans.regions :as regions]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :s3
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.s3.AmazonS3Client
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.StorageClass}
storage-class
  [m9972]
  (.
   com.amazonaws.services.s3.model.StorageClass
   fromValue
   (clojure.core/name m9972)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RoutingRuleCondition}
routing-rule-condition
  [m9975]
  (clojure.core/let
   [bean9974
    (new com.amazonaws.services.s3.model.RoutingRuleCondition)]
   (clojure.core/let
    [v9976
     (:key-prefix-equals
      m9975
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9976 :com.palletops.awaze.client-builder/undef)
     (. bean9974 setKeyPrefixEquals (clojure.core/str v9976))))
   (clojure.core/let
    [v9976
     (:http-error-code-returned-equals
      m9975
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9976 :com.palletops.awaze.client-builder/undef)
     (.
      bean9974
      setHttpErrorCodeReturnedEquals
      (clojure.core/str v9976))))
   bean9974))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RedirectRule}
redirect-rule
  [m9978]
  (clojure.core/let
   [bean9977 (new com.amazonaws.services.s3.model.RedirectRule)]
   (clojure.core/let
    [v9979
     (:protocol m9978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9979 :com.palletops.awaze.client-builder/undef)
     (. bean9977 setProtocol (clojure.core/str v9979))))
   (clojure.core/let
    [v9979
     (:host-name m9978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9979 :com.palletops.awaze.client-builder/undef)
     (. bean9977 setHostName (clojure.core/str v9979))))
   (clojure.core/let
    [v9979
     (:replace-key-prefix-with
      m9978
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9979 :com.palletops.awaze.client-builder/undef)
     (. bean9977 setReplaceKeyPrefixWith (clojure.core/str v9979))))
   (clojure.core/let
    [v9979
     (:replace-key-with
      m9978
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9979 :com.palletops.awaze.client-builder/undef)
     (. bean9977 setReplaceKeyWith (clojure.core/str v9979))))
   (clojure.core/let
    [v9979
     (:http-redirect-code
      m9978
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9979 :com.palletops.awaze.client-builder/undef)
     (. bean9977 setHttpRedirectCode (clojure.core/str v9979))))
   bean9977))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CORSRule$AllowedMethods}
corsrule-allowed-methods
  [m9981]
  (.
   com.amazonaws.services.s3.model.CORSRule$AllowedMethods
   fromValue
   (clojure.core/name m9981)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition}
bucket-lifecycle-configuration-transition
  [m9984]
  (clojure.core/let
   [bean9983
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition)]
   (clojure.core/let
    [v9985 (:days m9984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9985 :com.palletops.awaze.client-builder/undef)
     (. bean9983 setDays (clojure.core/int v9985))))
   (clojure.core/let
    [v9985
     (:storage-class m9984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9985 :com.palletops.awaze.client-builder/undef)
     (. bean9983 setStorageClass (s3/storage-class v9985))))
   (clojure.core/let
    [v9985 (:date m9984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9985 :com.palletops.awaze.client-builder/undef)
     (. bean9983 setDate (com.palletops.awaze.common/to-date v9985))))
   bean9983))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$NoncurrentVersionTransition}
bucket-lifecycle-configuration-noncurrent-version-transition
  [m9987]
  (clojure.core/let
   [bean9986
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$NoncurrentVersionTransition)]
   (clojure.core/let
    [v9988 (:days m9987 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9988 :com.palletops.awaze.client-builder/undef)
     (. bean9986 setDays (clojure.core/int v9988))))
   (clojure.core/let
    [v9988
     (:storage-class m9987 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9988 :com.palletops.awaze.client-builder/undef)
     (. bean9986 setStorageClass (s3/storage-class v9988))))
   bean9986))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration}
bucket-notification-configuration-topic-configuration
  [m9990]
  (clojure.core/let
   [arg9992
    nil
    arg9993
    nil
    bean9989
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration
     arg9992
     arg9993)]
   bean9989))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RoutingRule}
routing-rule
  [m9995]
  (clojure.core/let
   [bean9994 (new com.amazonaws.services.s3.model.RoutingRule)]
   (clojure.core/let
    [v9996
     (:condition m9995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9996 :com.palletops.awaze.client-builder/undef)
     (. bean9994 setCondition (s3/routing-rule-condition v9996))))
   (clojure.core/let
    [v9996
     (:redirect m9995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9996 :com.palletops.awaze.client-builder/undef)
     (. bean9994 setRedirect (s3/redirect-rule v9996))))
   bean9994))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.Owner}
owner
  [m9998]
  (clojure.core/let
   [bean9997 (new com.amazonaws.services.s3.model.Owner)]
   (clojure.core/let
    [v9999 (:id m9998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9999 :com.palletops.awaze.client-builder/undef)
     (. bean9997 setId (clojure.core/str v9999))))
   (clojure.core/let
    [v9999
     (:display-name m9998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9999 :com.palletops.awaze.client-builder/undef)
     (. bean9997 setDisplayName (clojure.core/str v9999))))
   bean9997))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CORSRule}
corsrule
  [m10001]
  (clojure.core/let
   [bean10000 (new com.amazonaws.services.s3.model.CORSRule)]
   (clojure.core/let
    [v10002 (:id m10001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10002 :com.palletops.awaze.client-builder/undef)
     (. bean10000 setId (clojure.core/str v10002))))
   (clojure.core/let
    [v10002
     (:allowed-methods
      m10001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10002 :com.palletops.awaze.client-builder/undef)
     (.
      bean10000
      setAllowedMethods
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10258] (s3/corsrule-allowed-methods arg10258))
 v10002))))
   (clojure.core/let
    [v10002
     (:allowed-origins
      m10001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10002 :com.palletops.awaze.client-builder/undef)
     (.
      bean10000
      setAllowedOrigins
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10259] (clojure.core/str arg10259))
 v10002))))
   (clojure.core/let
    [v10002
     (:max-age-seconds
      m10001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10002 :com.palletops.awaze.client-builder/undef)
     (. bean10000 setMaxAgeSeconds (clojure.core/int v10002))))
   (clojure.core/let
    [v10002
     (:exposed-headers
      m10001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10002 :com.palletops.awaze.client-builder/undef)
     (.
      bean10000
      setExposedHeaders
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10260] (clojure.core/str arg10260))
 v10002))))
   (clojure.core/let
    [v10002
     (:allowed-headers
      m10001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10002 :com.palletops.awaze.client-builder/undef)
     (.
      bean10000
      setAllowedHeaders
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10261] (clojure.core/str arg10261))
 v10002))))
   bean10000))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.TagSet}
tag-set
  [m10004]
  (clojure.core/let
   [bean10003 (new com.amazonaws.services.s3.model.TagSet)]
   bean10003))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule}
bucket-lifecycle-configuration-rule
  [m10007]
  (clojure.core/let
   [bean10006
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule)]
   (clojure.core/let
    [v10008 (:id m10007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10008 :com.palletops.awaze.client-builder/undef)
     (. bean10006 setId (clojure.core/str v10008))))
   (clojure.core/let
    [v10008
     (:noncurrent-version-expiration-in-days
      m10007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10008 :com.palletops.awaze.client-builder/undef)
     (.
      bean10006
      setNoncurrentVersionExpirationInDays
      (clojure.core/int v10008))))
   (clojure.core/let
    [v10008
     (:expiration-date
      m10007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10008 :com.palletops.awaze.client-builder/undef)
     (.
      bean10006
      setExpirationDate
      (com.palletops.awaze.common/to-date v10008))))
   (clojure.core/let
    [v10008
     (:transition m10007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10008 :com.palletops.awaze.client-builder/undef)
     (.
      bean10006
      setTransition
      (s3/bucket-lifecycle-configuration-transition v10008))))
   (clojure.core/let
    [v10008
     (:noncurrent-version-transition
      m10007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10008 :com.palletops.awaze.client-builder/undef)
     (.
      bean10006
      setNoncurrentVersionTransition
      (s3/bucket-lifecycle-configuration-noncurrent-version-transition
       v10008))))
   (clojure.core/let
    [v10008
     (:prefix m10007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10008 :com.palletops.awaze.client-builder/undef)
     (. bean10006 setPrefix (clojure.core/str v10008))))
   (clojure.core/let
    [v10008
     (:status m10007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10008 :com.palletops.awaze.client-builder/undef)
     (. bean10006 setStatus (clojure.core/str v10008))))
   (clojure.core/let
    [v10008
     (:expiration-in-days
      m10007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10008 :com.palletops.awaze.client-builder/undef)
     (. bean10006 setExpirationInDays (clojure.core/int v10008))))
   bean10006))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.MultiFactorAuthentication}
multi-factor-authentication
  [m10010]
  (clojure.core/let
   [arg10012
    nil
    arg10013
    nil
    bean10009
    (new
     com.amazonaws.services.s3.model.MultiFactorAuthentication
     arg10012
     arg10013)]
   (clojure.core/let
    [v10011 (:token m10010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10011 :com.palletops.awaze.client-builder/undef)
     (. bean10009 setToken (clojure.core/str v10011))))
   (clojure.core/let
    [v10011
     (:device-serial-number
      m10010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10011 :com.palletops.awaze.client-builder/undef)
     (. bean10009 setDeviceSerialNumber (clojure.core/str v10011))))
   bean10009))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion}
delete-objects-request-key-version
  [m10015]
  (clojure.core/let
   [arg10017
    nil
    bean10014
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion
     arg10017)]
   bean10014))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
bucket-notification-configuration
  [m10019]
  (clojure.core/let
   [bean10018
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration)]
   (clojure.core/let
    [v10020
     (:topic-configurations
      m10019
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10020 :com.palletops.awaze.client-builder/undef)
     (.
      bean10018
      setTopicConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10262]
  (s3/bucket-notification-configuration-topic-configuration arg10262))
 v10020))))
   bean10018))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ProgressListener}
progress-listener
  [m10022]
  (throw
   (clojure.core/ex-info
    "Trying to construct an interface"
    {:type "com.amazonaws.services.s3.model.ProgressListener",
     :value m10022})))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ResponseHeaderOverrides}
response-header-overrides
  [m10025]
  (clojure.core/let
   [bean10024
    (new com.amazonaws.services.s3.model.ResponseHeaderOverrides)]
   (clojure.core/let
    [v10026
     (:content-encoding
      m10025
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10026 :com.palletops.awaze.client-builder/undef)
     (. bean10024 setContentEncoding (clojure.core/str v10026))))
   (clojure.core/let
    [v10026
     (:cache-control m10025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10026 :com.palletops.awaze.client-builder/undef)
     (. bean10024 setCacheControl (clojure.core/str v10026))))
   (clojure.core/let
    [v10026
     (:content-disposition
      m10025
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10026 :com.palletops.awaze.client-builder/undef)
     (. bean10024 setContentDisposition (clojure.core/str v10026))))
   (clojure.core/let
    [v10026
     (:content-language
      m10025
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10026 :com.palletops.awaze.client-builder/undef)
     (. bean10024 setContentLanguage (clojure.core/str v10026))))
   (clojure.core/let
    [v10026
     (:expires m10025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10026 :com.palletops.awaze.client-builder/undef)
     (. bean10024 setExpires (clojure.core/str v10026))))
   (clojure.core/let
    [v10026
     (:content-type m10025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10026 :com.palletops.awaze.client-builder/undef)
     (. bean10024 setContentType (clojure.core/str v10026))))
   bean10024))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSECustomerKey}
ssecustomer-key
  [m10028]
  (clojure.core/let
   [^{:tag javax.crypto.SecretKey}
    arg10030
    nil
    bean10027
    (new
     com.amazonaws.services.s3.model.SSECustomerKey
^{:tag javax.crypto.SecretKey}
arg10030)]
   (clojure.core/let
    [v10029
     (:algorithm m10028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10029 :com.palletops.awaze.client-builder/undef)
     (. bean10027 setAlgorithm (clojure.core/str v10029))))
   (clojure.core/let
    [v10029 (:md5 m10028 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10029 :com.palletops.awaze.client-builder/undef)
     (. bean10027 setMd5 (clojure.core/str v10029))))
   bean10027))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketWebsiteConfiguration}
bucket-website-configuration
  [m10032]
  (clojure.core/let
   [bean10031
    (new com.amazonaws.services.s3.model.BucketWebsiteConfiguration)]
   (clojure.core/let
    [v10033
     (:index-document-suffix
      m10032
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10033 :com.palletops.awaze.client-builder/undef)
     (. bean10031 setIndexDocumentSuffix (clojure.core/str v10033))))
   (clojure.core/let
    [v10033
     (:error-document
      m10032
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10033 :com.palletops.awaze.client-builder/undef)
     (. bean10031 setErrorDocument (clojure.core/str v10033))))
   (clojure.core/let
    [v10033
     (:redirect-all-requests-to
      m10032
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10033 :com.palletops.awaze.client-builder/undef)
     (. bean10031 setRedirectAllRequestsTo (s3/redirect-rule v10033))))
   (clojure.core/let
    [v10033
     (:routing-rules m10032 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10033 :com.palletops.awaze.client-builder/undef)
     (.
      bean10031
      setRoutingRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10263] (s3/routing-rule arg10263))
 v10033))))
   bean10031))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ObjectMetadata}
object-metadata
  [m10035]
  (clojure.core/let
   [bean10034 (new com.amazonaws.services.s3.model.ObjectMetadata)]
   (clojure.core/let
    [v10036
     (:ssecustomer-key-md5
      m10035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (. bean10034 setSSECustomerKeyMd5 (clojure.core/str v10036))))
   (clojure.core/let
    [v10036
     (:content-disposition
      m10035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (. bean10034 setContentDisposition (clojure.core/str v10036))))
   (clojure.core/let
    [v10036
     (:last-modified m10035 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (.
      bean10034
      setLastModified
      (com.palletops.awaze.common/to-date v10036))))
   (clojure.core/let
    [v10036
     (:content-md5 m10035 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (. bean10034 setContentMD5 (clojure.core/str v10036))))
   (clojure.core/let
    [v10036
     (:restore-expiration-time
      m10035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (.
      bean10034
      setRestoreExpirationTime
      (com.palletops.awaze.common/to-date v10036))))
   (clojure.core/let
    [v10036
     (:content-encoding
      m10035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (. bean10034 setContentEncoding (clojure.core/str v10036))))
   (clojure.core/let
    [v10036
     (:ssealgorithm m10035 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (. bean10034 setSSEAlgorithm (clojure.core/str v10036))))
   (clojure.core/let
    [v10036
     (:ssecustomer-algorithm
      m10035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (. bean10034 setSSECustomerAlgorithm (clojure.core/str v10036))))
   (clojure.core/let
    [v10036
     (:content-type m10035 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (. bean10034 setContentType (clojure.core/str v10036))))
   (clojure.core/let
    [v10036
     (:expiration-time-rule-id
      m10035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (. bean10034 setExpirationTimeRuleId (clojure.core/str v10036))))
   (clojure.core/let
    [v10036
     (:ongoing-restore
      m10035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (. bean10034 setOngoingRestore (clojure.core/boolean v10036))))
   (clojure.core/let
    [v10036
     (:http-expires-date
      m10035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (.
      bean10034
      setHttpExpiresDate
      (com.palletops.awaze.common/to-date v10036))))
   (clojure.core/let
    [v10036
     (:user-metadata m10035 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (.
      bean10034
      setUserMetadata
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg10264] (clojure.core/str arg10264))
  (clojure.core/keys v10036))
 (clojure.core/map
  (clojure.core/fn [arg10264] (clojure.core/str arg10264))
  (clojure.core/vals v10036))))))
   (clojure.core/let
    [v10036
     (:cache-control m10035 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (. bean10034 setCacheControl (clojure.core/str v10036))))
   (clojure.core/let
    [v10036
     (:content-length
      m10035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (. bean10034 setContentLength (clojure.core/long v10036))))
   (clojure.core/let
    [v10036
     (:expiration-time
      m10035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (.
      bean10034
      setExpirationTime
      (com.palletops.awaze.common/to-date v10036))))
   (clojure.core/let
    [v10036
     (:server-side-encryption
      m10035
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10036 :com.palletops.awaze.client-builder/undef)
     (. bean10034 setServerSideEncryption (clojure.core/str v10036))))
   bean10034))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AccessControlList}
access-control-list
  [m10038]
  (clojure.core/let
   [bean10037 (new com.amazonaws.services.s3.model.AccessControlList)]
   (clojure.core/let
    [v10039 (:owner m10038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10039 :com.palletops.awaze.client-builder/undef)
     (. bean10037 setOwner (s3/owner v10039))))
   bean10037))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
canned-access-control-list
  [m10041]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.CannedAccessControlList
   (clojure.core/name m10041)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketCrossOriginConfiguration}
bucket-cross-origin-configuration
  [m10044]
  (clojure.core/let
   [bean10043
    (new
     com.amazonaws.services.s3.model.BucketCrossOriginConfiguration)]
   (clojure.core/let
    [v10045 (:rules m10044 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10045 :com.palletops.awaze.client-builder/undef)
     (.
      bean10043
      setRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10265] (s3/corsrule arg10265))
 v10045))))
   bean10043))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketTaggingConfiguration}
bucket-tagging-configuration
  [m10047]
  (clojure.core/let
   [bean10046
    (new com.amazonaws.services.s3.model.BucketTaggingConfiguration)]
   (clojure.core/let
    [v10048
     (:tag-sets m10047 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10048 :com.palletops.awaze.client-builder/undef)
     (.
      bean10046
      setTagSets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10266] (s3/tag-set arg10266))
 v10048))))
   bean10046))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketVersioningConfiguration}
bucket-versioning-configuration
  [m10050]
  (clojure.core/let
   [bean10049
    (new
     com.amazonaws.services.s3.model.BucketVersioningConfiguration)]
   (clojure.core/let
    [v10051
     (:status m10050 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10051 :com.palletops.awaze.client-builder/undef)
     (. bean10049 setStatus (clojure.core/str v10051))))
   (clojure.core/let
    [v10051
     (:mfa-delete-enabled
      m10050
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10051 :com.palletops.awaze.client-builder/undef)
     (. bean10049 setMfaDeleteEnabled (clojure.core/boolean v10051))))
   bean10049))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.PartETag}
part-etag
  [m10053]
  (clojure.core/let
   [arg10055
    0
    arg10056
    nil
    bean10052
    (new com.amazonaws.services.s3.model.PartETag arg10055 arg10056)]
   (clojure.core/let
    [v10054 (:etag m10053 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10054 :com.palletops.awaze.client-builder/undef)
     (. bean10052 setETag (clojure.core/str v10054))))
   (clojure.core/let
    [v10054
     (:part-number m10053 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10054 :com.palletops.awaze.client-builder/undef)
     (. bean10052 setPartNumber (clojure.core/int v10054))))
   bean10052))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration}
bucket-lifecycle-configuration
  [m10058]
  (clojure.core/let
   [bean10057
    (new com.amazonaws.services.s3.model.BucketLifecycleConfiguration)]
   (clojure.core/let
    [v10059 (:rules m10058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10059 :com.palletops.awaze.client-builder/undef)
     (.
      bean10057
      setRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg10267]
  (s3/bucket-lifecycle-configuration-rule arg10267))
 v10059))))
   bean10057))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLoggingConfiguration}
bucket-logging-configuration
  [m10061]
  (clojure.core/let
   [bean10060
    (new com.amazonaws.services.s3.model.BucketLoggingConfiguration)]
   (clojure.core/let
    [v10062
     (:destination-bucket-name
      m10061
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10062 :com.palletops.awaze.client-builder/undef)
     (. bean10060 setDestinationBucketName (clojure.core/str v10062))))
   (clojure.core/let
    [v10062
     (:log-file-prefix
      m10061
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10062 :com.palletops.awaze.client-builder/undef)
     (. bean10060 setLogFilePrefix (clojure.core/str v10062))))
   bean10060))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.S3VersionSummary}
s3version-summary
  [m10064]
  (clojure.core/let
   [bean10063 (new com.amazonaws.services.s3.model.S3VersionSummary)]
   (clojure.core/let
    [v10065
     (:last-modified m10064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10065 :com.palletops.awaze.client-builder/undef)
     (.
      bean10063
      setLastModified
      (com.palletops.awaze.common/to-date v10065))))
   (clojure.core/let
    [v10065 (:size m10064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10065 :com.palletops.awaze.client-builder/undef)
     (. bean10063 setSize (clojure.core/long v10065))))
   (clojure.core/let
    [v10065
     (:is-delete-marker
      m10064
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10065 :com.palletops.awaze.client-builder/undef)
     (. bean10063 setIsDeleteMarker (clojure.core/boolean v10065))))
   (clojure.core/let
    [v10065
     (:version-id m10064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10065 :com.palletops.awaze.client-builder/undef)
     (. bean10063 setVersionId (clojure.core/str v10065))))
   (clojure.core/let
    [v10065 (:owner m10064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10065 :com.palletops.awaze.client-builder/undef)
     (. bean10063 setOwner (s3/owner v10065))))
   (clojure.core/let
    [v10065
     (:is-latest m10064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10065 :com.palletops.awaze.client-builder/undef)
     (. bean10063 setIsLatest (clojure.core/boolean v10065))))
   (clojure.core/let
    [v10065 (:etag m10064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10065 :com.palletops.awaze.client-builder/undef)
     (. bean10063 setETag (clojure.core/str v10065))))
   (clojure.core/let
    [v10065
     (:bucket-name m10064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10065 :com.palletops.awaze.client-builder/undef)
     (. bean10063 setBucketName (clojure.core/str v10065))))
   (clojure.core/let
    [v10065 (:key m10064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10065 :com.palletops.awaze.client-builder/undef)
     (. bean10063 setKey (clojure.core/str v10065))))
   (clojure.core/let
    [v10065
     (:storage-class m10064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10065 :com.palletops.awaze.client-builder/undef)
     (. bean10063 setStorageClass (clojure.core/str v10065))))
   bean10063))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectsRequest}
delete-objects-request
  [m10067]
  (clojure.core/let
   [arg10069
    nil
    bean10066
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest
     arg10069)]
   (clojure.core/let
    [v10068 (:quiet m10067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10068 :com.palletops.awaze.client-builder/undef)
     (. bean10066 setQuiet (clojure.core/boolean v10068))))
   (clojure.core/let
    [v10068 (:mfa m10067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10068 :com.palletops.awaze.client-builder/undef)
     (. bean10066 setMfa (s3/multi-factor-authentication v10068))))
   (clojure.core/let
    [v10068 (:keys m10067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10068 :com.palletops.awaze.client-builder/undef)
     (.
      bean10066
      setKeys
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg10268]
  (s3/delete-objects-request-key-version arg10268))
 v10068))))
   (clojure.core/let
    [v10068
     (:bucket-name m10067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10068 :com.palletops.awaze.client-builder/undef)
     (. bean10066 setBucketName (clojure.core/str v10068))))
   bean10066))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketAclRequest}
set-bucket-acl-request
  [m10071]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg10073
    nil
^{:tag com.amazonaws.services.s3.model.AccessControlList}
arg10074
    (access-control-list {})
    bean10070
    (new
     com.amazonaws.services.s3.model.SetBucketAclRequest
^{:tag java.lang.String}
arg10073
^{:tag com.amazonaws.services.s3.model.AccessControlList}
arg10074)]
   bean10070))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
get-bucket-location-request
  [m10076]
  (clojure.core/let
   [arg10078
    nil
    bean10075
    (new
     com.amazonaws.services.s3.model.GetBucketLocationRequest
     arg10078)]
   (clojure.core/let
    [v10077
     (:bucket-name m10076 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10077 :com.palletops.awaze.client-builder/undef)
     (. bean10075 setBucketName (clojure.core/str v10077))))
   bean10075))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest}
set-bucket-notification-configuration-request
  [m10080]
  (clojure.core/let
   [^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
    arg10082
    (bucket-notification-configuration {})
^{:tag java.lang.String}
arg10083
    nil
    bean10079
    (new
     com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
arg10082
^{:tag java.lang.String}
arg10083)]
   (clojure.core/let
    [v10081
     (:bucket m10080 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10081 :com.palletops.awaze.client-builder/undef)
     (. bean10079 setBucket (clojure.core/str v10081))))
   (clojure.core/let
    [v10081
     (:bucket-notification-configuration
      m10080
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10081 :com.palletops.awaze.client-builder/undef)
     (.
      bean10079
      setBucketNotificationConfiguration
      (s3/bucket-notification-configuration v10081))))
   (clojure.core/let
    [v10081
     (:notification-configuration
      m10080
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10081 :com.palletops.awaze.client-builder/undef)
     (.
      bean10079
      setNotificationConfiguration
      (s3/bucket-notification-configuration v10081))))
   (clojure.core/let
    [v10081
     (:bucket-name m10080 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10081 :com.palletops.awaze.client-builder/undef)
     (. bean10079 setBucketName (clojure.core/str v10081))))
   bean10079))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
get-object-request
  [m10085]
  (clojure.core/let
   [arg10087
    nil
    arg10088
    nil
    bean10084
    (new
     com.amazonaws.services.s3.model.GetObjectRequest
     arg10087
     arg10088)]
   (clojure.core/let
    [v10086
     (:matching-etag-constraints
      m10085
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10086 :com.palletops.awaze.client-builder/undef)
     (.
      bean10084
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10269] (clojure.core/str arg10269))
 v10086))))
   (clojure.core/let
    [v10086
     (:progress-listener
      m10085
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10086 :com.palletops.awaze.client-builder/undef)
     (. bean10084 setProgressListener (s3/progress-listener v10086))))
   (clojure.core/let
    [v10086
     (:response-headers
      m10085
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10086 :com.palletops.awaze.client-builder/undef)
     (.
      bean10084
      setResponseHeaders
      (s3/response-header-overrides v10086))))
   (clojure.core/let
    [v10086
     (:requester-pays
      m10085
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10086 :com.palletops.awaze.client-builder/undef)
     (. bean10084 setRequesterPays (clojure.core/boolean v10086))))
   (clojure.core/let
    [v10086
     (:modified-since-constraint
      m10085
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10086 :com.palletops.awaze.client-builder/undef)
     (.
      bean10084
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v10086))))
   (clojure.core/let
    [v10086
     (:version-id m10085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10086 :com.palletops.awaze.client-builder/undef)
     (. bean10084 setVersionId (clojure.core/str v10086))))
   (clojure.core/let
    [v10086
     (:unmodified-since-constraint
      m10085
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10086 :com.palletops.awaze.client-builder/undef)
     (.
      bean10084
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v10086))))
   (clojure.core/let
    [v10086
     (:bucket-name m10085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10086 :com.palletops.awaze.client-builder/undef)
     (. bean10084 setBucketName (clojure.core/str v10086))))
   (clojure.core/let
    [v10086
     (:nonmatching-etag-constraints
      m10085
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10086 :com.palletops.awaze.client-builder/undef)
     (.
      bean10084
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10270] (clojure.core/str arg10270))
 v10086))))
   (clojure.core/let
    [v10086 (:key m10085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10086 :com.palletops.awaze.client-builder/undef)
     (. bean10084 setKey (clojure.core/str v10086))))
   (clojure.core/let
    [v10086
     (:ssecustomer-key
      m10085
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10086 :com.palletops.awaze.client-builder/undef)
     (. bean10084 setSSECustomerKey (s3/ssecustomer-key v10086))))
   bean10084))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest}
set-bucket-website-configuration-request
  [m10090]
  (clojure.core/let
   [arg10092
    nil
    arg10093
    nil
    bean10089
    (new
     com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest
     arg10092
     arg10093)]
   (clojure.core/let
    [v10091
     (:configuration m10090 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10091 :com.palletops.awaze.client-builder/undef)
     (.
      bean10089
      setConfiguration
      (s3/bucket-website-configuration v10091))))
   (clojure.core/let
    [v10091
     (:bucket-name m10090 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10091 :com.palletops.awaze.client-builder/undef)
     (. bean10089 setBucketName (clojure.core/str v10091))))
   bean10089))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CopyObjectRequest}
copy-object-request
  [m10095]
  (clojure.core/let
   [arg10097
    nil
    arg10098
    nil
    arg10099
    nil
    arg10100
    nil
    bean10094
    (new
     com.amazonaws.services.s3.model.CopyObjectRequest
     arg10097
     arg10098
     arg10099
     arg10100)]
   (clojure.core/let
    [v10096
     (:destination-bucket-name
      m10095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (. bean10094 setDestinationBucketName (clojure.core/str v10096))))
   (clojure.core/let
    [v10096
     (:matching-etag-constraints
      m10095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (.
      bean10094
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10271] (clojure.core/str arg10271))
 v10096))))
   (clojure.core/let
    [v10096
     (:source-key m10095 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (. bean10094 setSourceKey (clojure.core/str v10096))))
   (clojure.core/let
    [v10096
     (:destination-ssecustomer-key
      m10095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (.
      bean10094
      setDestinationSSECustomerKey
      (s3/ssecustomer-key v10096))))
   (clojure.core/let
    [v10096
     (:new-object-metadata
      m10095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (. bean10094 setNewObjectMetadata (s3/object-metadata v10096))))
   (clojure.core/let
    [v10096
     (:modified-since-constraint
      m10095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (.
      bean10094
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v10096))))
   (clojure.core/let
    [v10096
     (:source-bucket-name
      m10095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (. bean10094 setSourceBucketName (clojure.core/str v10096))))
   (clojure.core/let
    [v10096
     (:redirect-location
      m10095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (. bean10094 setRedirectLocation (clojure.core/str v10096))))
   (clojure.core/let
    [v10096
     (:destination-key
      m10095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (. bean10094 setDestinationKey (clojure.core/str v10096))))
   (clojure.core/let
    [v10096
     (:unmodified-since-constraint
      m10095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (.
      bean10094
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v10096))))
   (clojure.core/let
    [v10096
     (:access-control-list
      m10095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (.
      bean10094
      setAccessControlList
      (s3/access-control-list v10096))))
   (clojure.core/let
    [v10096
     (:source-version-id
      m10095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (. bean10094 setSourceVersionId (clojure.core/str v10096))))
   (clojure.core/let
    [v10096
     (:canned-access-control-list
      m10095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (.
      bean10094
      setCannedAccessControlList
      (s3/canned-access-control-list v10096))))
   (clojure.core/let
    [v10096
     (:nonmatching-etag-constraints
      m10095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (.
      bean10094
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10272] (clojure.core/str arg10272))
 v10096))))
   (clojure.core/let
    [v10096
     (:source-ssecustomer-key
      m10095
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (. bean10094 setSourceSSECustomerKey (s3/ssecustomer-key v10096))))
   (clojure.core/let
    [v10096
     (:storage-class m10095 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10096 :com.palletops.awaze.client-builder/undef)
     (. bean10094 setStorageClass (clojure.core/str v10096))))
   bean10094))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest}
set-bucket-cross-origin-configuration-request
  [m10102]
  (clojure.core/let
   [arg10104
    nil
    arg10105
    nil
    bean10101
    (new
     com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest
     arg10104
     arg10105)]
   (clojure.core/let
    [v10103
     (:cross-origin-configuration
      m10102
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10103 :com.palletops.awaze.client-builder/undef)
     (.
      bean10101
      setCrossOriginConfiguration
      (s3/bucket-cross-origin-configuration v10103))))
   (clojure.core/let
    [v10103
     (:bucket-name m10102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10103 :com.palletops.awaze.client-builder/undef)
     (. bean10101 setBucketName (clojure.core/str v10103))))
   bean10101))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest}
set-bucket-tagging-configuration-request
  [m10107]
  (clojure.core/let
   [arg10109
    nil
    arg10110
    nil
    bean10106
    (new
     com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest
     arg10109
     arg10110)]
   (clojure.core/let
    [v10108
     (:tagging-configuration
      m10107
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10108 :com.palletops.awaze.client-builder/undef)
     (.
      bean10106
      setTaggingConfiguration
      (s3/bucket-tagging-configuration v10108))))
   (clojure.core/let
    [v10108
     (:bucket-name m10107 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10108 :com.palletops.awaze.client-builder/undef)
     (. bean10106 setBucketName (clojure.core/str v10108))))
   bean10106))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.S3ClientOptions}
s3client-options
  [m10112]
  (clojure.core/let
   [bean10111 (new com.amazonaws.services.s3.S3ClientOptions)]
   (clojure.core/let
    [v10113
     (:path-style-access
      m10112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10113 :com.palletops.awaze.client-builder/undef)
     (. bean10111 setPathStyleAccess (clojure.core/boolean v10113))))
   bean10111))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RestoreObjectRequest}
restore-object-request
  [m10115]
  (clojure.core/let
   [arg10117
    nil
    arg10118
    nil
    bean10114
    (new
     com.amazonaws.services.s3.model.RestoreObjectRequest
     arg10117
     arg10118)]
   (clojure.core/let
    [v10116 (:key m10115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10116 :com.palletops.awaze.client-builder/undef)
     (. bean10114 setKey (clojure.core/str v10116))))
   (clojure.core/let
    [v10116
     (:version-id m10115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10116 :com.palletops.awaze.client-builder/undef)
     (. bean10114 setVersionId (clojure.core/str v10116))))
   (clojure.core/let
    [v10116
     (:expiration-in-days
      m10115
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10116 :com.palletops.awaze.client-builder/undef)
     (. bean10114 setExpirationInDays (clojure.core/int v10116))))
   (clojure.core/let
    [v10116
     (:bucket-name m10115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10116 :com.palletops.awaze.client-builder/undef)
     (. bean10114 setBucketName (clojure.core/str v10116))))
   bean10114))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteVersionRequest}
delete-version-request
  [m10120]
  (clojure.core/let
   [arg10122
    nil
    arg10123
    nil
    arg10124
    nil
    bean10119
    (new
     com.amazonaws.services.s3.model.DeleteVersionRequest
     arg10122
     arg10123
     arg10124)]
   (clojure.core/let
    [v10121 (:key m10120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10121 :com.palletops.awaze.client-builder/undef)
     (. bean10119 setKey (clojure.core/str v10121))))
   (clojure.core/let
    [v10121
     (:version-id m10120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10121 :com.palletops.awaze.client-builder/undef)
     (. bean10119 setVersionId (clojure.core/str v10121))))
   (clojure.core/let
    [v10121 (:mfa m10120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10121 :com.palletops.awaze.client-builder/undef)
     (. bean10119 setMfa (s3/multi-factor-authentication v10121))))
   (clojure.core/let
    [v10121
     (:bucket-name m10120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10121 :com.palletops.awaze.client-builder/undef)
     (. bean10119 setBucketName (clojure.core/str v10121))))
   bean10119))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest}
set-bucket-versioning-configuration-request
  [m10126]
  (clojure.core/let
   [arg10128
    nil
    arg10129
    nil
    bean10125
    (new
     com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest
     arg10128
     arg10129)]
   (clojure.core/let
    [v10127 (:mfa m10126 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10127 :com.palletops.awaze.client-builder/undef)
     (. bean10125 setMfa (s3/multi-factor-authentication v10127))))
   (clojure.core/let
    [v10127
     (:versioning-configuration
      m10126
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10127 :com.palletops.awaze.client-builder/undef)
     (.
      bean10125
      setVersioningConfiguration
      (s3/bucket-versioning-configuration v10127))))
   (clojure.core/let
    [v10127
     (:bucket-name m10126 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10127 :com.palletops.awaze.client-builder/undef)
     (. bean10125 setBucketName (clojure.core/str v10127))))
   bean10125))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
create-bucket-request
  [m10131]
  (clojure.core/let
   [arg10133
    nil
    bean10130
    (new com.amazonaws.services.s3.model.CreateBucketRequest arg10133)]
   (clojure.core/let
    [v10132
     (:region m10131 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10132 :com.palletops.awaze.client-builder/undef)
     (. bean10130 setRegion (clojure.core/str v10132))))
   (clojure.core/let
    [v10132
     (:canned-acl m10131 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10132 :com.palletops.awaze.client-builder/undef)
     (. bean10130 setCannedAcl (s3/canned-access-control-list v10132))))
   (clojure.core/let
    [v10132
     (:access-control-list
      m10131
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10132 :com.palletops.awaze.client-builder/undef)
     (.
      bean10130
      setAccessControlList
      (s3/access-control-list v10132))))
   (clojure.core/let
    [v10132
     (:bucket-name m10131 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10132 :com.palletops.awaze.client-builder/undef)
     (. bean10130 setBucketName (clojure.core/str v10132))))
   bean10130))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.Region}
region
  [m10135]
  (.
   com.amazonaws.services.s3.model.Region
   fromValue
   (clojure.core/name m10135)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ObjectListing}
object-listing
  [m10138]
  (clojure.core/let
   [bean10137 (new com.amazonaws.services.s3.model.ObjectListing)]
   (clojure.core/let
    [v10139
     (:delimiter m10138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10139 :com.palletops.awaze.client-builder/undef)
     (. bean10137 setDelimiter (clojure.core/str v10139))))
   (clojure.core/let
    [v10139
     (:common-prefixes
      m10138
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10139 :com.palletops.awaze.client-builder/undef)
     (.
      bean10137
      setCommonPrefixes
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10273] (clojure.core/str arg10273))
 v10139))))
   (clojure.core/let
    [v10139
     (:encoding-type m10138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10139 :com.palletops.awaze.client-builder/undef)
     (. bean10137 setEncodingType (clojure.core/str v10139))))
   (clojure.core/let
    [v10139
     (:next-marker m10138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10139 :com.palletops.awaze.client-builder/undef)
     (. bean10137 setNextMarker (clojure.core/str v10139))))
   (clojure.core/let
    [v10139
     (:prefix m10138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10139 :com.palletops.awaze.client-builder/undef)
     (. bean10137 setPrefix (clojure.core/str v10139))))
   (clojure.core/let
    [v10139
     (:max-keys m10138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10139 :com.palletops.awaze.client-builder/undef)
     (. bean10137 setMaxKeys (clojure.core/int v10139))))
   (clojure.core/let
    [v10139
     (:bucket-name m10138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10139 :com.palletops.awaze.client-builder/undef)
     (. bean10137 setBucketName (clojure.core/str v10139))))
   (clojure.core/let
    [v10139
     (:truncated m10138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10139 :com.palletops.awaze.client-builder/undef)
     (. bean10137 setTruncated (clojure.core/boolean v10139))))
   (clojure.core/let
    [v10139
     (:marker m10138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10139 :com.palletops.awaze.client-builder/undef)
     (. bean10137 setMarker (clojure.core/str v10139))))
   bean10137))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.PutObjectRequest}
put-object-request
  [m10141]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg10143
    nil
^{:tag java.lang.String}
arg10144
    nil
^{:tag java.lang.String}
arg10145
    nil
    bean10140
    (new
     com.amazonaws.services.s3.model.PutObjectRequest
^{:tag java.lang.String}
arg10143
^{:tag java.lang.String}
arg10144
^{:tag java.lang.String}
arg10145)]
   (clojure.core/let
    [v10142
     (:progress-listener
      m10141
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10142 :com.palletops.awaze.client-builder/undef)
     (. bean10140 setProgressListener (s3/progress-listener v10142))))
   (clojure.core/let
    [v10142
     (:input-stream m10141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10142 :com.palletops.awaze.client-builder/undef)
     (.
      bean10140
      setInputStream
      (clojure.java.io/input-stream v10142))))
   (clojure.core/let
    [v10142
     (:canned-acl m10141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10142 :com.palletops.awaze.client-builder/undef)
     (. bean10140 setCannedAcl (s3/canned-access-control-list v10142))))
   (clojure.core/let
    [v10142
     (:metadata m10141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10142 :com.palletops.awaze.client-builder/undef)
     (. bean10140 setMetadata (s3/object-metadata v10142))))
   (clojure.core/let
    [v10142
     (:redirect-location
      m10141
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10142 :com.palletops.awaze.client-builder/undef)
     (. bean10140 setRedirectLocation (clojure.core/str v10142))))
   (clojure.core/let
    [v10142
     (:access-control-list
      m10141
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10142 :com.palletops.awaze.client-builder/undef)
     (.
      bean10140
      setAccessControlList
      (s3/access-control-list v10142))))
   (clojure.core/let
    [v10142
     (:bucket-name m10141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10142 :com.palletops.awaze.client-builder/undef)
     (. bean10140 setBucketName (clojure.core/str v10142))))
   (clojure.core/let
    [v10142 (:key m10141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10142 :com.palletops.awaze.client-builder/undef)
     (. bean10140 setKey (clojure.core/str v10142))))
   (clojure.core/let
    [v10142 (:file m10141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10142 :com.palletops.awaze.client-builder/undef)
     (. bean10140 setFile (clojure.java.io/file v10142))))
   (clojure.core/let
    [v10142
     (:ssecustomer-key
      m10141
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10142 :com.palletops.awaze.client-builder/undef)
     (. bean10140 setSSECustomerKey (s3/ssecustomer-key v10142))))
   (clojure.core/let
    [v10142
     (:storage-class m10141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10142 :com.palletops.awaze.client-builder/undef)
     (. bean10140 setStorageClass (clojure.core/str v10142))))
   bean10140))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
get-bucket-policy-request
  [m10147]
  (clojure.core/let
   [arg10149
    nil
    bean10146
    (new
     com.amazonaws.services.s3.model.GetBucketPolicyRequest
     arg10149)]
   (clojure.core/let
    [v10148
     (:bucket-name m10147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10148 :com.palletops.awaze.client-builder/undef)
     (. bean10146 setBucketName (clojure.core/str v10148))))
   bean10146))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
list-objects-request
  [m10151]
  (clojure.core/let
   [bean10150
    (new com.amazonaws.services.s3.model.ListObjectsRequest)]
   (clojure.core/let
    [v10152
     (:prefix m10151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10152 :com.palletops.awaze.client-builder/undef)
     (. bean10150 setPrefix (clojure.core/str v10152))))
   (clojure.core/let
    [v10152
     (:marker m10151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10152 :com.palletops.awaze.client-builder/undef)
     (. bean10150 setMarker (clojure.core/str v10152))))
   (clojure.core/let
    [v10152
     (:delimiter m10151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10152 :com.palletops.awaze.client-builder/undef)
     (. bean10150 setDelimiter (clojure.core/str v10152))))
   (clojure.core/let
    [v10152
     (:max-keys m10151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10152 :com.palletops.awaze.client-builder/undef)
     (. bean10150 setMaxKeys (clojure.core/int v10152))))
   (clojure.core/let
    [v10152
     (:encoding-type m10151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10152 :com.palletops.awaze.client-builder/undef)
     (. bean10150 setEncodingType (clojure.core/str v10152))))
   (clojure.core/let
    [v10152
     (:bucket-name m10151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10152 :com.palletops.awaze.client-builder/undef)
     (. bean10150 setBucketName (clojure.core/str v10152))))
   bean10150))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AbortMultipartUploadRequest}
abort-multipart-upload-request
  [m10154]
  (clojure.core/let
   [arg10156
    nil
    arg10157
    nil
    arg10158
    nil
    bean10153
    (new
     com.amazonaws.services.s3.model.AbortMultipartUploadRequest
     arg10156
     arg10157
     arg10158)]
   (clojure.core/let
    [v10155 (:key m10154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10155 :com.palletops.awaze.client-builder/undef)
     (. bean10153 setKey (clojure.core/str v10155))))
   (clojure.core/let
    [v10155
     (:upload-id m10154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10155 :com.palletops.awaze.client-builder/undef)
     (. bean10153 setUploadId (clojure.core/str v10155))))
   (clojure.core/let
    [v10155
     (:bucket-name m10154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10155 :com.palletops.awaze.client-builder/undef)
     (. bean10153 setBucketName (clojure.core/str v10155))))
   bean10153))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.UploadPartRequest}
upload-part-request
  [m10160]
  (clojure.core/let
   [bean10159 (new com.amazonaws.services.s3.model.UploadPartRequest)]
   (clojure.core/let
    [v10161
     (:md5digest m10160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10161 :com.palletops.awaze.client-builder/undef)
     (. bean10159 setMd5Digest (clojure.core/str v10161))))
   (clojure.core/let
    [v10161
     (:progress-listener
      m10160
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10161 :com.palletops.awaze.client-builder/undef)
     (. bean10159 setProgressListener (s3/progress-listener v10161))))
   (clojure.core/let
    [v10161
     (:input-stream m10160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10161 :com.palletops.awaze.client-builder/undef)
     (.
      bean10159
      setInputStream
      (clojure.java.io/input-stream v10161))))
   (clojure.core/let
    [v10161
     (:last-part m10160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10161 :com.palletops.awaze.client-builder/undef)
     (. bean10159 setLastPart (clojure.core/boolean v10161))))
   (clojure.core/let
    [v10161
     (:file-offset m10160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10161 :com.palletops.awaze.client-builder/undef)
     (. bean10159 setFileOffset (clojure.core/long v10161))))
   (clojure.core/let
    [v10161
     (:part-size m10160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10161 :com.palletops.awaze.client-builder/undef)
     (. bean10159 setPartSize (clojure.core/long v10161))))
   (clojure.core/let
    [v10161
     (:bucket-name m10160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10161 :com.palletops.awaze.client-builder/undef)
     (. bean10159 setBucketName (clojure.core/str v10161))))
   (clojure.core/let
    [v10161 (:key m10160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10161 :com.palletops.awaze.client-builder/undef)
     (. bean10159 setKey (clojure.core/str v10161))))
   (clojure.core/let
    [v10161 (:file m10160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10161 :com.palletops.awaze.client-builder/undef)
     (. bean10159 setFile (clojure.java.io/file v10161))))
   (clojure.core/let
    [v10161
     (:upload-id m10160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10161 :com.palletops.awaze.client-builder/undef)
     (. bean10159 setUploadId (clojure.core/str v10161))))
   (clojure.core/let
    [v10161
     (:part-number m10160 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10161 :com.palletops.awaze.client-builder/undef)
     (. bean10159 setPartNumber (clojure.core/int v10161))))
   (clojure.core/let
    [v10161
     (:ssecustomer-key
      m10160
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10161 :com.palletops.awaze.client-builder/undef)
     (. bean10159 setSSECustomerKey (s3/ssecustomer-key v10161))))
   bean10159))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CompleteMultipartUploadRequest}
complete-multipart-upload-request
  [m10163]
  (clojure.core/let
   [arg10165
    nil
    arg10166
    nil
    arg10167
    nil
    arg10168
    nil
    bean10162
    (new
     com.amazonaws.services.s3.model.CompleteMultipartUploadRequest
     arg10165
     arg10166
     arg10167
     arg10168)]
   (clojure.core/let
    [v10164 (:key m10163 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10164 :com.palletops.awaze.client-builder/undef)
     (. bean10162 setKey (clojure.core/str v10164))))
   (clojure.core/let
    [v10164
     (:upload-id m10163 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10164 :com.palletops.awaze.client-builder/undef)
     (. bean10162 setUploadId (clojure.core/str v10164))))
   (clojure.core/let
    [v10164
     (:part-etags m10163 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10164 :com.palletops.awaze.client-builder/undef)
     (.
      bean10162
      setPartETags
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10274] (s3/part-etag arg10274))
 v10164))))
   (clojure.core/let
    [v10164
     (:bucket-name m10163 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10164 :com.palletops.awaze.client-builder/undef)
     (. bean10162 setBucketName (clojure.core/str v10164))))
   bean10162))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListVersionsRequest}
list-versions-request
  [m10170]
  (clojure.core/let
   [bean10169
    (new com.amazonaws.services.s3.model.ListVersionsRequest)]
   (clojure.core/let
    [v10171
     (:prefix m10170 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10171 :com.palletops.awaze.client-builder/undef)
     (. bean10169 setPrefix (clojure.core/str v10171))))
   (clojure.core/let
    [v10171
     (:delimiter m10170 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10171 :com.palletops.awaze.client-builder/undef)
     (. bean10169 setDelimiter (clojure.core/str v10171))))
   (clojure.core/let
    [v10171
     (:key-marker m10170 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10171 :com.palletops.awaze.client-builder/undef)
     (. bean10169 setKeyMarker (clojure.core/str v10171))))
   (clojure.core/let
    [v10171
     (:version-id-marker
      m10170
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10171 :com.palletops.awaze.client-builder/undef)
     (. bean10169 setVersionIdMarker (clojure.core/str v10171))))
   (clojure.core/let
    [v10171
     (:encoding-type m10170 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10171 :com.palletops.awaze.client-builder/undef)
     (. bean10169 setEncodingType (clojure.core/str v10171))))
   (clojure.core/let
    [v10171
     (:bucket-name m10170 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10171 :com.palletops.awaze.client-builder/undef)
     (. bean10169 setBucketName (clojure.core/str v10171))))
   (clojure.core/let
    [v10171
     (:max-results m10170 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10171 :com.palletops.awaze.client-builder/undef)
     (. bean10169 setMaxResults (clojure.core/int v10171))))
   bean10169))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
delete-bucket-website-configuration-request
  [m10173]
  (clojure.core/let
   [arg10175
    nil
    bean10172
    (new
     com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
     arg10175)]
   bean10172))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListMultipartUploadsRequest}
list-multipart-uploads-request
  [m10177]
  (clojure.core/let
   [arg10179
    nil
    bean10176
    (new
     com.amazonaws.services.s3.model.ListMultipartUploadsRequest
     arg10179)]
   (clojure.core/let
    [v10178
     (:prefix m10177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10178 :com.palletops.awaze.client-builder/undef)
     (. bean10176 setPrefix (clojure.core/str v10178))))
   (clojure.core/let
    [v10178
     (:upload-id-marker
      m10177
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10178 :com.palletops.awaze.client-builder/undef)
     (. bean10176 setUploadIdMarker (clojure.core/str v10178))))
   (clojure.core/let
    [v10178
     (:delimiter m10177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10178 :com.palletops.awaze.client-builder/undef)
     (. bean10176 setDelimiter (clojure.core/str v10178))))
   (clojure.core/let
    [v10178
     (:key-marker m10177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10178 :com.palletops.awaze.client-builder/undef)
     (. bean10176 setKeyMarker (clojure.core/str v10178))))
   (clojure.core/let
    [v10178
     (:encoding-type m10177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10178 :com.palletops.awaze.client-builder/undef)
     (. bean10176 setEncodingType (clojure.core/str v10178))))
   (clojure.core/let
    [v10178
     (:max-uploads m10177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10178 :com.palletops.awaze.client-builder/undef)
     (. bean10176 setMaxUploads (clojure.core/int v10178))))
   (clojure.core/let
    [v10178
     (:bucket-name m10177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10178 :com.palletops.awaze.client-builder/undef)
     (. bean10176 setBucketName (clojure.core/str v10178))))
   bean10176))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest}
set-bucket-lifecycle-configuration-request
  [m10181]
  (clojure.core/let
   [arg10183
    nil
    arg10184
    nil
    bean10180
    (new
     com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest
     arg10183
     arg10184)]
   (clojure.core/let
    [v10182
     (:lifecycle-configuration
      m10181
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10182 :com.palletops.awaze.client-builder/undef)
     (.
      bean10180
      setLifecycleConfiguration
      (s3/bucket-lifecycle-configuration v10182))))
   (clojure.core/let
    [v10182
     (:bucket-name m10181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10182 :com.palletops.awaze.client-builder/undef)
     (. bean10180 setBucketName (clojure.core/str v10182))))
   bean10180))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectMetadataRequest}
get-object-metadata-request
  [m10186]
  (clojure.core/let
   [arg10188
    nil
    arg10189
    nil
    bean10185
    (new
     com.amazonaws.services.s3.model.GetObjectMetadataRequest
     arg10188
     arg10189)]
   (clojure.core/let
    [v10187 (:key m10186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10187 :com.palletops.awaze.client-builder/undef)
     (. bean10185 setKey (clojure.core/str v10187))))
   (clojure.core/let
    [v10187
     (:version-id m10186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10187 :com.palletops.awaze.client-builder/undef)
     (. bean10185 setVersionId (clojure.core/str v10187))))
   (clojure.core/let
    [v10187
     (:ssecustomer-key
      m10186
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10187 :com.palletops.awaze.client-builder/undef)
     (. bean10185 setSSECustomerKey (s3/ssecustomer-key v10187))))
   (clojure.core/let
    [v10187
     (:bucket-name m10186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10187 :com.palletops.awaze.client-builder/undef)
     (. bean10185 setBucketName (clojure.core/str v10187))))
   bean10185))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
delete-bucket-cross-origin-configuration-request
  [m10191]
  (clojure.core/let
   [arg10193
    nil
    bean10190
    (new
     com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
     arg10193)]
   bean10190))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
delete-bucket-tagging-configuration-request
  [m10195]
  (clojure.core/let
   [arg10197
    nil
    bean10194
    (new
     com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
     arg10197)]
   bean10194))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
delete-bucket-policy-request
  [m10199]
  (clojure.core/let
   [arg10201
    nil
    bean10198
    (new
     com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
     arg10201)]
   (clojure.core/let
    [v10200
     (:bucket-name m10199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10200 :com.palletops.awaze.client-builder/undef)
     (. bean10198 setBucketName (clojure.core/str v10200))))
   bean10198))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
get-bucket-website-configuration-request
  [m10203]
  (clojure.core/let
   [arg10205
    nil
    bean10202
    (new
     com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
     arg10205)]
   (clojure.core/let
    [v10204
     (:bucket-name m10203 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10204 :com.palletops.awaze.client-builder/undef)
     (. bean10202 setBucketName (clojure.core/str v10204))))
   bean10202))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
delete-bucket-lifecycle-configuration-request
  [m10207]
  (clojure.core/let
   [arg10209
    nil
    bean10206
    (new
     com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
     arg10209)]
   bean10206))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
delete-bucket-request
  [m10211]
  (clojure.core/let
   [arg10213
    nil
    bean10210
    (new com.amazonaws.services.s3.model.DeleteBucketRequest arg10213)]
   (clojure.core/let
    [v10212
     (:bucket-name m10211 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10212 :com.palletops.awaze.client-builder/undef)
     (. bean10210 setBucketName (clojure.core/str v10212))))
   bean10210))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectRequest}
delete-object-request
  [m10215]
  (clojure.core/let
   [arg10217
    nil
    arg10218
    nil
    bean10214
    (new
     com.amazonaws.services.s3.model.DeleteObjectRequest
     arg10217
     arg10218)]
   (clojure.core/let
    [v10216 (:key m10215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10216 :com.palletops.awaze.client-builder/undef)
     (. bean10214 setKey (clojure.core/str v10216))))
   (clojure.core/let
    [v10216
     (:bucket-name m10215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10216 :com.palletops.awaze.client-builder/undef)
     (. bean10214 setBucketName (clojure.core/str v10216))))
   bean10214))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CopyPartRequest}
copy-part-request
  [m10220]
  (clojure.core/let
   [bean10219 (new com.amazonaws.services.s3.model.CopyPartRequest)]
   (clojure.core/let
    [v10221
     (:last-byte m10220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10221 :com.palletops.awaze.client-builder/undef)
     (. bean10219 setLastByte (clojure.core/long v10221))))
   (clojure.core/let
    [v10221
     (:destination-bucket-name
      m10220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10221 :com.palletops.awaze.client-builder/undef)
     (. bean10219 setDestinationBucketName (clojure.core/str v10221))))
   (clojure.core/let
    [v10221
     (:matching-etag-constraints
      m10220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10221 :com.palletops.awaze.client-builder/undef)
     (.
      bean10219
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10275] (clojure.core/str arg10275))
 v10221))))
   (clojure.core/let
    [v10221
     (:source-key m10220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10221 :com.palletops.awaze.client-builder/undef)
     (. bean10219 setSourceKey (clojure.core/str v10221))))
   (clojure.core/let
    [v10221
     (:destination-ssecustomer-key
      m10220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10221 :com.palletops.awaze.client-builder/undef)
     (.
      bean10219
      setDestinationSSECustomerKey
      (s3/ssecustomer-key v10221))))
   (clojure.core/let
    [v10221
     (:modified-since-constraint
      m10220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10221 :com.palletops.awaze.client-builder/undef)
     (.
      bean10219
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v10221))))
   (clojure.core/let
    [v10221
     (:source-bucket-name
      m10220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10221 :com.palletops.awaze.client-builder/undef)
     (. bean10219 setSourceBucketName (clojure.core/str v10221))))
   (clojure.core/let
    [v10221
     (:destination-key
      m10220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10221 :com.palletops.awaze.client-builder/undef)
     (. bean10219 setDestinationKey (clojure.core/str v10221))))
   (clojure.core/let
    [v10221
     (:unmodified-since-constraint
      m10220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10221 :com.palletops.awaze.client-builder/undef)
     (.
      bean10219
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v10221))))
   (clojure.core/let
    [v10221
     (:source-version-id
      m10220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10221 :com.palletops.awaze.client-builder/undef)
     (. bean10219 setSourceVersionId (clojure.core/str v10221))))
   (clojure.core/let
    [v10221
     (:first-byte m10220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10221 :com.palletops.awaze.client-builder/undef)
     (. bean10219 setFirstByte (clojure.core/long v10221))))
   (clojure.core/let
    [v10221
     (:nonmatching-etag-constraints
      m10220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10221 :com.palletops.awaze.client-builder/undef)
     (.
      bean10219
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10276] (clojure.core/str arg10276))
 v10221))))
   (clojure.core/let
    [v10221
     (:source-ssecustomer-key
      m10220
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10221 :com.palletops.awaze.client-builder/undef)
     (. bean10219 setSourceSSECustomerKey (s3/ssecustomer-key v10221))))
   (clojure.core/let
    [v10221
     (:upload-id m10220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10221 :com.palletops.awaze.client-builder/undef)
     (. bean10219 setUploadId (clojure.core/str v10221))))
   (clojure.core/let
    [v10221
     (:part-number m10220 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10221 :com.palletops.awaze.client-builder/undef)
     (. bean10219 setPartNumber (clojure.core/int v10221))))
   bean10219))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.InitiateMultipartUploadRequest}
initiate-multipart-upload-request
  [m10223]
  (clojure.core/let
   [arg10225
    nil
    arg10226
    nil
    bean10222
    (new
     com.amazonaws.services.s3.model.InitiateMultipartUploadRequest
     arg10225
     arg10226)]
   (clojure.core/let
    [v10224 (:key m10223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10224 :com.palletops.awaze.client-builder/undef)
     (. bean10222 setKey (clojure.core/str v10224))))
   (clojure.core/let
    [v10224
     (:ssecustomer-key
      m10223
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10224 :com.palletops.awaze.client-builder/undef)
     (. bean10222 setSSECustomerKey (s3/ssecustomer-key v10224))))
   (clojure.core/let
    [v10224
     (:storage-class m10223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10224 :com.palletops.awaze.client-builder/undef)
     (. bean10222 setStorageClass (s3/storage-class v10224))))
   (clojure.core/let
    [v10224
     (:access-control-list
      m10223
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10224 :com.palletops.awaze.client-builder/undef)
     (.
      bean10222
      setAccessControlList
      (s3/access-control-list v10224))))
   (clojure.core/let
    [v10224
     (:redirect-location
      m10223
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10224 :com.palletops.awaze.client-builder/undef)
     (. bean10222 setRedirectLocation (clojure.core/str v10224))))
   (clojure.core/let
    [v10224
     (:object-metadata
      m10223
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10224 :com.palletops.awaze.client-builder/undef)
     (. bean10222 setObjectMetadata (s3/object-metadata v10224))))
   (clojure.core/let
    [v10224
     (:canned-acl m10223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10224 :com.palletops.awaze.client-builder/undef)
     (. bean10222 setCannedACL (s3/canned-access-control-list v10224))))
   (clojure.core/let
    [v10224
     (:bucket-name m10223 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10224 :com.palletops.awaze.client-builder/undef)
     (. bean10222 setBucketName (clojure.core/str v10224))))
   bean10222))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketPolicyRequest}
set-bucket-policy-request
  [m10228]
  (clojure.core/let
   [arg10230
    nil
    arg10231
    nil
    bean10227
    (new
     com.amazonaws.services.s3.model.SetBucketPolicyRequest
     arg10230
     arg10231)]
   (clojure.core/let
    [v10229
     (:policy-text m10228 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10229 :com.palletops.awaze.client-builder/undef)
     (. bean10227 setPolicyText (clojure.core/str v10229))))
   (clojure.core/let
    [v10229
     (:bucket-name m10228 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10229 :com.palletops.awaze.client-builder/undef)
     (. bean10227 setBucketName (clojure.core/str v10229))))
   bean10227))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GeneratePresignedUrlRequest}
generate-presigned-url-request
  [m10233]
  (clojure.core/let
   [arg10235
    nil
    arg10236
    nil
    bean10232
    (new
     com.amazonaws.services.s3.model.GeneratePresignedUrlRequest
     arg10235
     arg10236)]
   (clojure.core/let
    [v10234 (:key m10233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10234 :com.palletops.awaze.client-builder/undef)
     (. bean10232 setKey (clojure.core/str v10234))))
   (clojure.core/let
    [v10234
     (:content-md5 m10233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10234 :com.palletops.awaze.client-builder/undef)
     (. bean10232 setContentMd5 (clojure.core/str v10234))))
   (clojure.core/let
    [v10234
     (:expiration m10233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10234 :com.palletops.awaze.client-builder/undef)
     (.
      bean10232
      setExpiration
      (com.palletops.awaze.common/to-date v10234))))
   (clojure.core/let
    [v10234
     (:response-headers
      m10233
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10234 :com.palletops.awaze.client-builder/undef)
     (.
      bean10232
      setResponseHeaders
      (s3/response-header-overrides v10234))))
   (clojure.core/let
    [v10234
     (:ssecustomer-key
      m10233
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10234 :com.palletops.awaze.client-builder/undef)
     (. bean10232 setSSECustomerKey (s3/ssecustomer-key v10234))))
   (clojure.core/let
    [v10234
     (:content-type m10233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10234 :com.palletops.awaze.client-builder/undef)
     (. bean10232 setContentType (clojure.core/str v10234))))
   (clojure.core/let
    [v10234
     (:bucket-name m10233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10234 :com.palletops.awaze.client-builder/undef)
     (. bean10232 setBucketName (clojure.core/str v10234))))
   (clojure.core/let
    [v10234
     (:method m10233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10234 :com.palletops.awaze.client-builder/undef)
     (. bean10232 setMethod (root/http-method v10234))))
   bean10232))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListPartsRequest}
list-parts-request
  [m10238]
  (clojure.core/let
   [arg10240
    nil
    arg10241
    nil
    arg10242
    nil
    bean10237
    (new
     com.amazonaws.services.s3.model.ListPartsRequest
     arg10240
     arg10241
     arg10242)]
   (clojure.core/let
    [v10239 (:key m10238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10239 :com.palletops.awaze.client-builder/undef)
     (. bean10237 setKey (clojure.core/str v10239))))
   (clojure.core/let
    [v10239
     (:upload-id m10238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10239 :com.palletops.awaze.client-builder/undef)
     (. bean10237 setUploadId (clojure.core/str v10239))))
   (clojure.core/let
    [v10239
     (:encoding-type m10238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10239 :com.palletops.awaze.client-builder/undef)
     (. bean10237 setEncodingType (clojure.core/str v10239))))
   (clojure.core/let
    [v10239
     (:max-parts m10238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10239 :com.palletops.awaze.client-builder/undef)
     (. bean10237 setMaxParts (clojure.core/int v10239))))
   (clojure.core/let
    [v10239
     (:part-number-marker
      m10238
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10239 :com.palletops.awaze.client-builder/undef)
     (. bean10237 setPartNumberMarker (clojure.core/int v10239))))
   (clojure.core/let
    [v10239
     (:bucket-name m10238 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10239 :com.palletops.awaze.client-builder/undef)
     (. bean10237 setBucketName (clojure.core/str v10239))))
   bean10237))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListBucketsRequest}
list-buckets-request
  [m10244]
  (clojure.core/let
   [bean10243
    (new com.amazonaws.services.s3.model.ListBucketsRequest)]
   bean10243))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest}
set-bucket-logging-configuration-request
  [m10247]
  (clojure.core/let
   [arg10249
    nil
    arg10250
    nil
    bean10246
    (new
     com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest
     arg10249
     arg10250)]
   (clojure.core/let
    [v10248
     (:logging-configuration
      m10247
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10248 :com.palletops.awaze.client-builder/undef)
     (.
      bean10246
      setLoggingConfiguration
      (s3/bucket-logging-configuration v10248))))
   (clojure.core/let
    [v10248
     (:bucket-name m10247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10248 :com.palletops.awaze.client-builder/undef)
     (. bean10246 setBucketName (clojure.core/str v10248))))
   bean10246))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
get-bucket-acl-request
  [m10252]
  (clojure.core/let
   [arg10254
    nil
    bean10251
    (new com.amazonaws.services.s3.model.GetBucketAclRequest arg10254)]
   bean10251))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.VersionListing}
version-listing
  [m10256]
  (clojure.core/let
   [bean10255 (new com.amazonaws.services.s3.model.VersionListing)]
   (clojure.core/let
    [v10257
     (:next-key-marker
      m10256
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10257 :com.palletops.awaze.client-builder/undef)
     (. bean10255 setNextKeyMarker (clojure.core/str v10257))))
   (clojure.core/let
    [v10257
     (:delimiter m10256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10257 :com.palletops.awaze.client-builder/undef)
     (. bean10255 setDelimiter (clojure.core/str v10257))))
   (clojure.core/let
    [v10257
     (:version-id-marker
      m10256
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10257 :com.palletops.awaze.client-builder/undef)
     (. bean10255 setVersionIdMarker (clojure.core/str v10257))))
   (clojure.core/let
    [v10257
     (:common-prefixes
      m10256
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10257 :com.palletops.awaze.client-builder/undef)
     (.
      bean10255
      setCommonPrefixes
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10277] (clojure.core/str arg10277))
 v10257))))
   (clojure.core/let
    [v10257
     (:version-summaries
      m10256
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10257 :com.palletops.awaze.client-builder/undef)
     (.
      bean10255
      setVersionSummaries
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10278] (s3/s3version-summary arg10278))
 v10257))))
   (clojure.core/let
    [v10257
     (:encoding-type m10256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10257 :com.palletops.awaze.client-builder/undef)
     (. bean10255 setEncodingType (clojure.core/str v10257))))
   (clojure.core/let
    [v10257
     (:prefix m10256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10257 :com.palletops.awaze.client-builder/undef)
     (. bean10255 setPrefix (clojure.core/str v10257))))
   (clojure.core/let
    [v10257
     (:max-keys m10256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10257 :com.palletops.awaze.client-builder/undef)
     (. bean10255 setMaxKeys (clojure.core/int v10257))))
   (clojure.core/let
    [v10257
     (:key-marker m10256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10257 :com.palletops.awaze.client-builder/undef)
     (. bean10255 setKeyMarker (clojure.core/str v10257))))
   (clojure.core/let
    [v10257
     (:bucket-name m10256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10257 :com.palletops.awaze.client-builder/undef)
     (. bean10255 setBucketName (clojure.core/str v10257))))
   (clojure.core/let
    [v10257
     (:next-version-id-marker
      m10256
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10257 :com.palletops.awaze.client-builder/undef)
     (. bean10255 setNextVersionIdMarker (clojure.core/str v10257))))
   (clojure.core/let
    [v10257
     (:truncated m10256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10257 :com.palletops.awaze.client-builder/undef)
     (. bean10255 setTruncated (clojure.core/boolean v10257))))
   bean10255))
 (clojure.core/defmulti
  s3
  (clojure.core/fn s3 [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-versioning-configuration
   [m10279]
   (clojure.core/let
    [credentials10280 (:credentials m10279) args10281 (:args m10279)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10282
      (com.palletops.awaze.common/aws-client :s3 credentials10280)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10282
       getBucketVersioningConfiguration
       (clojure.core/str (clojure.core/nth args10281 0)))))))
  (clojure.core/defn
   get-bucket-versioning-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketVersioningConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-versioning-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-bucket-versioning-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketVersioningConfiguration"}
   [credentials10284 & args10285]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10286
     (com.palletops.awaze.common/aws-client :s3 credentials10284)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10286
      getBucketVersioningConfiguration
      (clojure.core/str (clojure.core/nth args10285 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-objects
   [m10287]
   (clojure.core/let
    [credentials10288 (:credentials m10287) args10289 (:args m10287)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10290
      (com.palletops.awaze.common/aws-client :s3 credentials10288)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10290
       deleteObjects
       (s3/delete-objects-request (clojure.core/nth args10289 0)))))))
  (clojure.core/defn
   delete-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [quiet
                         mfa
                         keys
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Generate map for deleteObjects"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-objects,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-objects
   {:arglists (quote
               [[credentials
                 {:keys [quiet
                         mfa
                         keys
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Call deleteObjects"}
   [credentials10293 & args10294]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10296
     (com.palletops.awaze.common/aws-client :s3 credentials10293)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10296
      deleteObjects
      (s3/delete-objects-request (clojure.core/nth args10294 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-acl
   [m10297]
   (clojure.core/let
    [credentials10298 (:credentials m10297) args10299 (:args m10297)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10300
      (com.palletops.awaze.common/aws-client :s3 credentials10298)]
     (clojure.core/case
      (clojure.core/count args10299)
      2
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10299 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args10299 1))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10300
           setBucketAcl
           a
           b)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10299 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args10299 1))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10300
               setBucketAcl
               a
               b)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args10299}))))))))))
      3
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10299 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args10299 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.metrics.RequestMetricCollector
           (clojure.core/nth args10299 2))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10300
           setBucketAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10299 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args10299 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.metrics.RequestMetricCollector
               (clojure.core/nth args10299 2))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10300
               setBucketAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args10299}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10300
        setBucketAcl
        (s3/set-bucket-acl-request (clojure.core/nth args10299 0))))))))
  (clojure.core/defn
   set-bucket-acl-map
   {:arglists (quote
               [[credentials string-0 canned-access-control-list-1]
                [credentials string-0 {:keys [owner grants]}]
                [credentials
                 string-0
                 {:keys [owner grants]}
                 request-metric-collector-2]
                [credentials
                 {:keys [general-progress-listener
                         canned-acl
                         bucket-name
                         acl]}]
                [credentials
                 string-0
                 canned-access-control-list-1
                 request-metric-collector-2]]),
    :doc "Generate map for setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-acl,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-acl,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :set-bucket-acl,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-bucket-acl
   {:arglists (quote
               [[credentials string-0 canned-access-control-list-1]
                [credentials string-0 {:keys [owner grants]}]
                [credentials
                 string-0
                 {:keys [owner grants]}
                 request-metric-collector-2]
                [credentials
                 {:keys [general-progress-listener
                         canned-acl
                         bucket-name
                         acl]}]
                [credentials
                 string-0
                 canned-access-control-list-1
                 request-metric-collector-2]]),
    :doc "Call setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl"}
   [credentials10304 & args10305]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10308
     (com.palletops.awaze.common/aws-client :s3 credentials10304)]
    (clojure.core/case
     (clojure.core/count args10305)
     2
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10305 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args10305 1))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10308
          setBucketAcl
          a
          b)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10305 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args10305 1))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10308
              setBucketAcl
              a
              b)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args10305}))))))))))
     3
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10305 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args10305 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.metrics.RequestMetricCollector
          (clojure.core/nth args10305 2))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10308
          setBucketAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10305 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args10305 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.metrics.RequestMetricCollector
              (clojure.core/nth args10305 2))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10308
              setBucketAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args10305}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10308
       setBucketAcl
       (s3/set-bucket-acl-request (clojure.core/nth args10305 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-location
   [m10309]
   (clojure.core/let
    [credentials10310 (:credentials m10309) args10311 (:args m10309)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10312
      (com.palletops.awaze.common/aws-client :s3 credentials10310)]
     (clojure.core/case
      (clojure.core/count args10311)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10311 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10312
           getBucketLocation
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketLocationRequest
               (clojure.core/nth args10311 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10312
               getBucketLocation
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLocation")
                {:args args10311}))))))))))))))
  (clojure.core/defn
   get-bucket-location-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener bucket-name]}]]),
    :doc "Generate map for getBucketLocation, getBucketLocation"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-location,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-bucket-location
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener bucket-name]}]]),
    :doc "Call getBucketLocation, getBucketLocation"}
   [credentials10315 & args10316]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10318
     (com.palletops.awaze.common/aws-client :s3 credentials10315)]
    (clojure.core/case
     (clojure.core/count args10316)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10316 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10318
          getBucketLocation
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketLocationRequest
              (clojure.core/nth args10316 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10318
              getBucketLocation
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLocation")
               {:args args10316}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-notification-configuration
   [m10319]
   (clojure.core/let
    [credentials10320 (:credentials m10319) args10321 (:args m10319)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10322
      (com.palletops.awaze.common/aws-client :s3 credentials10320)]
     (clojure.core/case
      (clojure.core/count args10321)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10322
        setBucketNotificationConfiguration
        (clojure.core/str (clojure.core/nth args10321 0))
        (s3/bucket-notification-configuration
         (clojure.core/nth args10321 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10322
        setBucketNotificationConfiguration
        (s3/set-bucket-notification-configuration-request
         (clojure.core/nth args10321 0))))))))
  (clojure.core/defn
   set-bucket-notification-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys [topic-configurations]}]
                [credentials
                 {:keys [notification-configuration
                         general-progress-listener
                         bucket-notification-configuration
                         bucket-name
                         bucket]}]]),
    :doc "Generate map for setBucketNotificationConfiguration, setBucketNotificationConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-notification-configuration,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-notification-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-bucket-notification-configuration
   {:arglists (quote
               [[credentials string-0 {:keys [topic-configurations]}]
                [credentials
                 {:keys [notification-configuration
                         general-progress-listener
                         bucket-notification-configuration
                         bucket-name
                         bucket]}]]),
    :doc "Call setBucketNotificationConfiguration, setBucketNotificationConfiguration"}
   [credentials10326 & args10327]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10330
     (com.palletops.awaze.common/aws-client :s3 credentials10326)]
    (clojure.core/case
     (clojure.core/count args10327)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10330
       setBucketNotificationConfiguration
       (clojure.core/str (clojure.core/nth args10327 0))
       (s3/bucket-notification-configuration
        (clojure.core/nth args10327 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10330
       setBucketNotificationConfiguration
       (s3/set-bucket-notification-configuration-request
        (clojure.core/nth args10327 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object
   [m10331]
   (clojure.core/let
    [credentials10332 (:credentials m10331) args10333 (:args m10331)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10334
      (com.palletops.awaze.common/aws-client :s3 credentials10332)]
     (clojure.core/case
      (clojure.core/count args10333)
      2
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetObjectRequest
           (clojure.core/nth args10333 0))
^{:tag java.io.File}
b
          (com.palletops.awaze.common/coerce-value-form
           java.io.File
           (clojure.core/nth args10333 1))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10334
           getObject
           a
           b)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10333 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10333 1))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10334
               getObject
               a
               b)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getObject")
                {:args args10333}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10334
        getObject
        (s3/get-object-request (clojure.core/nth args10333 0))))))))
  (clojure.core/defn
   get-object-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         response-headers
                         key
                         bucket-name
                         unmodified-since-constraint
                         version-id
                         range
                         modified-since-constraint
                         progress-listener
                         nonmatching-etag-constraints
                         matching-etag-constraints
                         ssecustomer-key
                         requester-pays]}
                 file-1]
                [credentials
                 {:keys [general-progress-listener
                         response-headers
                         key
                         bucket-name
                         unmodified-since-constraint
                         version-id
                         range
                         modified-since-constraint
                         progress-listener
                         nonmatching-etag-constraints
                         matching-etag-constraints
                         ssecustomer-key
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for getObject, getObject, getObject"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-object,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-object,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-object
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         response-headers
                         key
                         bucket-name
                         unmodified-since-constraint
                         version-id
                         range
                         modified-since-constraint
                         progress-listener
                         nonmatching-etag-constraints
                         matching-etag-constraints
                         ssecustomer-key
                         requester-pays]}
                 file-1]
                [credentials
                 {:keys [general-progress-listener
                         response-headers
                         key
                         bucket-name
                         unmodified-since-constraint
                         version-id
                         range
                         modified-since-constraint
                         progress-listener
                         nonmatching-etag-constraints
                         matching-etag-constraints
                         ssecustomer-key
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Call getObject, getObject, getObject"}
   [credentials10340 & args10341]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10346
     (com.palletops.awaze.common/aws-client :s3 credentials10340)]
    (clojure.core/case
     (clojure.core/count args10341)
     2
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetObjectRequest
          (clojure.core/nth args10341 0))
^{:tag java.io.File}
b
         (com.palletops.awaze.common/coerce-value-form
          java.io.File
          (clojure.core/nth args10341 1))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10346
          getObject
          a
          b)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10341 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10341 1))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10346
              getObject
              a
              b)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getObject")
               {:args args10341}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10346
       getObject
       (s3/get-object-request (clojure.core/nth args10341 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-website-configuration
   [m10347]
   (clojure.core/let
    [credentials10348 (:credentials m10347) args10349 (:args m10347)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10350
      (com.palletops.awaze.common/aws-client :s3 credentials10348)]
     (clojure.core/case
      (clojure.core/count args10349)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10350
        setBucketWebsiteConfiguration
        (clojure.core/str (clojure.core/nth args10349 0))
        (s3/bucket-website-configuration
         (clojure.core/nth args10349 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10350
        setBucketWebsiteConfiguration
        (s3/set-bucket-website-configuration-request
         (clojure.core/nth args10349 0))))))))
  (clojure.core/defn
   set-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 string-0
                 {:keys [routing-rules
                         redirect-all-requests-to
                         index-document-suffix
                         error-document]}]
                [credentials
                 {:keys [general-progress-listener
                         configuration
                         bucket-name]}]]),
    :doc "Generate map for setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-website-configuration,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-website-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 string-0
                 {:keys [routing-rules
                         redirect-all-requests-to
                         index-document-suffix
                         error-document]}]
                [credentials
                 {:keys [general-progress-listener
                         configuration
                         bucket-name]}]]),
    :doc "Call setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   [credentials10354 & args10355]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10358
     (com.palletops.awaze.common/aws-client :s3 credentials10354)]
    (clojure.core/case
     (clojure.core/count args10355)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10358
       setBucketWebsiteConfiguration
       (clojure.core/str (clojure.core/nth args10355 0))
       (s3/bucket-website-configuration
        (clojure.core/nth args10355 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10358
       setBucketWebsiteConfiguration
       (s3/set-bucket-website-configuration-request
        (clojure.core/nth args10355 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :copy-object
   [m10359]
   (clojure.core/let
    [credentials10360 (:credentials m10359) args10361 (:args m10359)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10362
      (com.palletops.awaze.common/aws-client :s3 credentials10360)]
     (clojure.core/case
      (clojure.core/count args10361)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10362
        copyObject
        (s3/copy-object-request (clojure.core/nth args10361 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10362
        copyObject
        (clojure.core/str (clojure.core/nth args10361 0))
        (clojure.core/str (clojure.core/nth args10361 1))
        (clojure.core/str (clojure.core/nth args10361 2))
        (clojure.core/str (clojure.core/nth args10361 3))))))))
  (clojure.core/defn
   copy-object-map
   {:arglists (quote
               [[credentials
                 {:keys [source-key
                         source-ssecustomer-key
                         general-progress-listener
                         source-bucket-name
                         canned-access-control-list
                         destination-ssecustomer-key
                         unmodified-since-constraint
                         access-control-list
                         modified-since-constraint
                         redirect-location
                         new-object-metadata
                         nonmatching-etag-constraints
                         destination-key
                         matching-etag-constraints
                         destination-bucket-name
                         source-version-id
                         storage-class]}]
                [credentials string-0 string-1 string-2 string-3]]),
    :doc "Generate map for copyObject, copyObject"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :copy-object,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :copy-object,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   copy-object
   {:arglists (quote
               [[credentials
                 {:keys [source-key
                         source-ssecustomer-key
                         general-progress-listener
                         source-bucket-name
                         canned-access-control-list
                         destination-ssecustomer-key
                         unmodified-since-constraint
                         access-control-list
                         modified-since-constraint
                         redirect-location
                         new-object-metadata
                         nonmatching-etag-constraints
                         destination-key
                         matching-etag-constraints
                         destination-bucket-name
                         source-version-id
                         storage-class]}]
                [credentials string-0 string-1 string-2 string-3]]),
    :doc "Call copyObject, copyObject"}
   [credentials10368 & args10369]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10374
     (com.palletops.awaze.common/aws-client :s3 credentials10368)]
    (clojure.core/case
     (clojure.core/count args10369)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10374
       copyObject
       (s3/copy-object-request (clojure.core/nth args10369 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10374
       copyObject
       (clojure.core/str (clojure.core/nth args10369 0))
       (clojure.core/str (clojure.core/nth args10369 1))
       (clojure.core/str (clojure.core/nth args10369 2))
       (clojure.core/str (clojure.core/nth args10369 3))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-cross-origin-configuration
   [m10375]
   (clojure.core/let
    [credentials10376 (:credentials m10375) args10377 (:args m10375)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10378
      (com.palletops.awaze.common/aws-client :s3 credentials10376)]
     (clojure.core/case
      (clojure.core/count args10377)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10378
        setBucketCrossOriginConfiguration
        (clojure.core/str (clojure.core/nth args10377 0))
        (s3/bucket-cross-origin-configuration
         (clojure.core/nth args10377 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10378
        setBucketCrossOriginConfiguration
        (s3/set-bucket-cross-origin-configuration-request
         (clojure.core/nth args10377 0))))))))
  (clojure.core/defn
   set-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys [rules]}]
                [credentials
                 {:keys [general-progress-listener
                         cross-origin-configuration
                         bucket-name]}]]),
    :doc "Generate map for setBucketCrossOriginConfiguration, setBucketCrossOriginConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials string-0 {:keys [rules]}]
                [credentials
                 {:keys [general-progress-listener
                         cross-origin-configuration
                         bucket-name]}]]),
    :doc "Call setBucketCrossOriginConfiguration, setBucketCrossOriginConfiguration"}
   [credentials10382 & args10383]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10386
     (com.palletops.awaze.common/aws-client :s3 credentials10382)]
    (clojure.core/case
     (clojure.core/count args10383)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10386
       setBucketCrossOriginConfiguration
       (clojure.core/str (clojure.core/nth args10383 0))
       (s3/bucket-cross-origin-configuration
        (clojure.core/nth args10383 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10386
       setBucketCrossOriginConfiguration
       (s3/set-bucket-cross-origin-configuration-request
        (clojure.core/nth args10383 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :does-bucket-exist
   [m10387]
   (clojure.core/let
    [credentials10388 (:credentials m10387) args10389 (:args m10387)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10390
      (com.palletops.awaze.common/aws-client :s3 credentials10388)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10390
       doesBucketExist
       (clojure.core/str (clojure.core/nth args10389 0)))))))
  (clojure.core/defn
   does-bucket-exist-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for doesBucketExist"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :does-bucket-exist,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   does-bucket-exist
   {:arglists (quote [[credentials string-0]]),
    :doc "Call doesBucketExist"}
   [credentials10392 & args10393]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10394
     (com.palletops.awaze.common/aws-client :s3 credentials10392)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10394
      doesBucketExist
      (clojure.core/str (clojure.core/nth args10393 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :change-object-storage-class
   [m10395]
   (clojure.core/let
    [credentials10396 (:credentials m10395) args10397 (:args m10395)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10398
      (com.palletops.awaze.common/aws-client :s3 credentials10396)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10398
       changeObjectStorageClass
       (clojure.core/str (clojure.core/nth args10397 0))
       (clojure.core/str (clojure.core/nth args10397 1))
       (s3/storage-class (clojure.core/nth args10397 2)))))))
  (clojure.core/defn
   change-object-storage-class-map
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Generate map for changeObjectStorageClass"}
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :change-object-storage-class,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   change-object-storage-class
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Call changeObjectStorageClass"}
   [credentials10400 & args10401]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10402
     (com.palletops.awaze.common/aws-client :s3 credentials10400)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10402
      changeObjectStorageClass
      (clojure.core/str (clojure.core/nth args10401 0))
      (clojure.core/str (clojure.core/nth args10401 1))
      (s3/storage-class (clojure.core/nth args10401 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-tagging-configuration
   [m10403]
   (clojure.core/let
    [credentials10404 (:credentials m10403) args10405 (:args m10403)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10406
      (com.palletops.awaze.common/aws-client :s3 credentials10404)]
     (clojure.core/case
      (clojure.core/count args10405)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10406
        setBucketTaggingConfiguration
        (s3/set-bucket-tagging-configuration-request
         (clojure.core/nth args10405 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10406
        setBucketTaggingConfiguration
        (clojure.core/str (clojure.core/nth args10405 0))
        (s3/bucket-tagging-configuration
         (clojure.core/nth args10405 1))))))))
  (clojure.core/defn
   set-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [tagging-configuration
                         general-progress-listener
                         bucket-name]}]
                [credentials string-0 {:keys []}]]),
    :doc "Generate map for setBucketTaggingConfiguration, setBucketTaggingConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-bucket-tagging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [tagging-configuration
                         general-progress-listener
                         bucket-name]}]
                [credentials string-0 {:keys []}]]),
    :doc "Call setBucketTaggingConfiguration, setBucketTaggingConfiguration"}
   [credentials10410 & args10411]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10414
     (com.palletops.awaze.common/aws-client :s3 credentials10410)]
    (clojure.core/case
     (clojure.core/count args10411)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10414
       setBucketTaggingConfiguration
       (s3/set-bucket-tagging-configuration-request
        (clojure.core/nth args10411 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10414
       setBucketTaggingConfiguration
       (clojure.core/str (clojure.core/nth args10411 0))
       (s3/bucket-tagging-configuration
        (clojure.core/nth args10411 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-s3client-options
   [m10415]
   (clojure.core/let
    [credentials10416 (:credentials m10415) args10417 (:args m10415)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10418
      (com.palletops.awaze.common/aws-client :s3 credentials10416)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10418
       setS3ClientOptions
       (s3/s3client-options (clojure.core/nth args10417 0)))))))
  (clojure.core/defn
   set-s3client-options-map
   {:arglists (quote [[credentials {:keys [path-style-access]}]]),
    :doc "Generate map for setS3ClientOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-s3client-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-s3client-options
   {:arglists (quote [[credentials {:keys [path-style-access]}]]),
    :doc "Call setS3ClientOptions"}
   [credentials10420 & args10421]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10422
     (com.palletops.awaze.common/aws-client :s3 credentials10420)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10422
      setS3ClientOptions
      (s3/s3client-options (clojure.core/nth args10421 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-lifecycle-configuration
   [m10423]
   (clojure.core/let
    [credentials10424 (:credentials m10423) args10425 (:args m10423)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10426
      (com.palletops.awaze.common/aws-client :s3 credentials10424)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10426
       getBucketLifecycleConfiguration
       (clojure.core/str (clojure.core/nth args10425 0)))))))
  (clojure.core/defn
   get-bucket-lifecycle-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketLifecycleConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-lifecycle-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-bucket-lifecycle-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketLifecycleConfiguration"}
   [credentials10428 & args10429]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10430
     (com.palletops.awaze.common/aws-client :s3 credentials10428)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10430
      getBucketLifecycleConfiguration
      (clojure.core/str (clojure.core/nth args10429 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-resource-url
   [m10431]
   (clojure.core/let
    [credentials10432 (:credentials m10431) args10433 (:args m10431)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10434
      (com.palletops.awaze.common/aws-client :s3 credentials10432)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10434
       getResourceUrl
       (clojure.core/str (clojure.core/nth args10433 0))
       (clojure.core/str (clojure.core/nth args10433 1)))))))
  (clojure.core/defn
   get-resource-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getResourceUrl"}
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-resource-url,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-resource-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getResourceUrl"}
   [credentials10436 & args10437]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10438
     (com.palletops.awaze.common/aws-client :s3 credentials10436)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10438
      getResourceUrl
      (clojure.core/str (clojure.core/nth args10437 0))
      (clojure.core/str (clojure.core/nth args10437 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-acl
   [m10439]
   (clojure.core/let
    [credentials10440 (:credentials m10439) args10441 (:args m10439)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10442
      (com.palletops.awaze.common/aws-client :s3 credentials10440)]
     (clojure.core/case
      (clojure.core/count args10441)
      4
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10441 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10441 1))
^{:tag java.lang.String}
c
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10441 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args10441 3))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10442
           setObjectAcl
           a
           b
           c
           d)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10441 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10441 1))
^{:tag java.lang.String}
c
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10441 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args10441 3))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10442
               setObjectAcl
               a
               b
               c
               d)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args10441}))))))))))
      3
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10441 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10441 1))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
c
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args10441 2))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10442
           setObjectAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10441 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10441 1))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
c
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args10441 2))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10442
               setObjectAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args10441}))))))))))
      5
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10441 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10441 1))
^{:tag java.lang.String}
c
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10441 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args10441 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.metrics.RequestMetricCollector
           (clojure.core/nth args10441 4))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10442
           setObjectAcl
           a
           b
           c
           d
           e)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10441 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10441 1))
^{:tag java.lang.String}
c
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10441 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args10441 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.metrics.RequestMetricCollector
               (clojure.core/nth args10441 4))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10442
               setObjectAcl
               a
               b
               c
               d
               e)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args10441}))))))))))))))
  (clojure.core/defn
   set-object-acl-map
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 string-2
                 {:keys [owner grants]}]
                [credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials string-0 string-1 {:keys [owner grants]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [owner grants]}
                 request-metric-collector-4]]),
    :doc "Generate map for setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :set-object-acl,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :set-object-acl,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c d e]
    {:args [a b c d e],
     :client :s3,
     :fn :set-object-acl,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-object-acl
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 string-2
                 {:keys [owner grants]}]
                [credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials string-0 string-1 {:keys [owner grants]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [owner grants]}
                 request-metric-collector-4]]),
    :doc "Call setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   [credentials10444 & args10445]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10446
     (com.palletops.awaze.common/aws-client :s3 credentials10444)]
    (clojure.core/case
     (clojure.core/count args10445)
     4
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10445 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10445 1))
^{:tag java.lang.String}
c
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10445 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args10445 3))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10446
          setObjectAcl
          a
          b
          c
          d)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10445 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10445 1))
^{:tag java.lang.String}
c
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10445 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args10445 3))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10446
              setObjectAcl
              a
              b
              c
              d)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args10445}))))))))))
     3
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10445 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10445 1))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
c
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args10445 2))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10446
          setObjectAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10445 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10445 1))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
c
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args10445 2))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10446
              setObjectAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args10445}))))))))))
     5
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10445 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10445 1))
^{:tag java.lang.String}
c
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10445 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args10445 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.metrics.RequestMetricCollector
          (clojure.core/nth args10445 4))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10446
          setObjectAcl
          a
          b
          c
          d
          e)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10445 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10445 1))
^{:tag java.lang.String}
c
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10445 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args10445 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.metrics.RequestMetricCollector
              (clojure.core/nth args10445 4))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10446
              setObjectAcl
              a
              b
              c
              d
              e)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args10445}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :restore-object
   [m10447]
   (clojure.core/let
    [credentials10448 (:credentials m10447) args10449 (:args m10447)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10450
      (com.palletops.awaze.common/aws-client :s3 credentials10448)]
     (clojure.core/case
      (clojure.core/count args10449)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10450
        restoreObject
        (s3/restore-object-request (clojure.core/nth args10449 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10450
        restoreObject
        (clojure.core/str (clojure.core/nth args10449 0))
        (clojure.core/str (clojure.core/nth args10449 1))
        (clojure.core/int (clojure.core/nth args10449 2))))))))
  (clojure.core/defn
   restore-object-map
   {:arglists (quote
               [[credentials
                 {:keys [version-id
                         key
                         general-progress-listener
                         expiration-in-days
                         bucket-name]}]
                [credentials string-0 string-1 int-2]]),
    :doc "Generate map for restoreObject, restoreObject"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :restore-object,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :restore-object,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   restore-object
   {:arglists (quote
               [[credentials
                 {:keys [version-id
                         key
                         general-progress-listener
                         expiration-in-days
                         bucket-name]}]
                [credentials string-0 string-1 int-2]]),
    :doc "Call restoreObject, restoreObject"}
   [credentials10454 & args10455]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10458
     (com.palletops.awaze.common/aws-client :s3 credentials10454)]
    (clojure.core/case
     (clojure.core/count args10455)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10458
       restoreObject
       (s3/restore-object-request (clojure.core/nth args10455 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10458
       restoreObject
       (clojure.core/str (clojure.core/nth args10455 0))
       (clojure.core/str (clojure.core/nth args10455 1))
       (clojure.core/int (clojure.core/nth args10455 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-url
   [m10459]
   (clojure.core/let
    [credentials10460 (:credentials m10459) args10461 (:args m10459)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10462
      (com.palletops.awaze.common/aws-client :s3 credentials10460)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10462
       getUrl
       (clojure.core/str (clojure.core/nth args10461 0))
       (clojure.core/str (clojure.core/nth args10461 1)))))))
  (clojure.core/defn
   get-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getUrl"}
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-url,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getUrl"}
   [credentials10464 & args10465]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10466
     (com.palletops.awaze.common/aws-client :s3 credentials10464)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10466
      getUrl
      (clojure.core/str (clojure.core/nth args10465 0))
      (clojure.core/str (clojure.core/nth args10465 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-version
   [m10467]
   (clojure.core/let
    [credentials10468 (:credentials m10467) args10469 (:args m10467)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10470
      (com.palletops.awaze.common/aws-client :s3 credentials10468)]
     (clojure.core/case
      (clojure.core/count args10469)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10470
        deleteVersion
        (s3/delete-version-request (clojure.core/nth args10469 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10470
        deleteVersion
        (clojure.core/str (clojure.core/nth args10469 0))
        (clojure.core/str (clojure.core/nth args10469 1))
        (clojure.core/str (clojure.core/nth args10469 2))))))))
  (clojure.core/defn
   delete-version-map
   {:arglists (quote
               [[credentials
                 {:keys [version-id
                         mfa
                         key
                         general-progress-listener
                         bucket-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for deleteVersion, deleteVersion"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-version,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :delete-version,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-version
   {:arglists (quote
               [[credentials
                 {:keys [version-id
                         mfa
                         key
                         general-progress-listener
                         bucket-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call deleteVersion, deleteVersion"}
   [credentials10475 & args10476]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10480
     (com.palletops.awaze.common/aws-client :s3 credentials10475)]
    (clojure.core/case
     (clojure.core/count args10476)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10480
       deleteVersion
       (s3/delete-version-request (clojure.core/nth args10476 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10480
       deleteVersion
       (clojure.core/str (clojure.core/nth args10476 0))
       (clojure.core/str (clojure.core/nth args10476 1))
       (clojure.core/str (clojure.core/nth args10476 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-versioning-configuration
   [m10481]
   (clojure.core/let
    [credentials10482 (:credentials m10481) args10483 (:args m10481)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10484
      (com.palletops.awaze.common/aws-client :s3 credentials10482)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10484
       setBucketVersioningConfiguration
       (s3/set-bucket-versioning-configuration-request
        (clojure.core/nth args10483 0)))))))
  (clojure.core/defn
   set-bucket-versioning-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [versioning-configuration
                         mfa
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Generate map for setBucketVersioningConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-versioning-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-bucket-versioning-configuration
   {:arglists (quote
               [[credentials
                 {:keys [versioning-configuration
                         mfa
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Call setBucketVersioningConfiguration"}
   [credentials10488 & args10489]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10492
     (com.palletops.awaze.common/aws-client :s3 credentials10488)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10492
      setBucketVersioningConfiguration
      (s3/set-bucket-versioning-configuration-request
       (clojure.core/nth args10489 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-cross-origin-configuration
   [m10493]
   (clojure.core/let
    [credentials10494 (:credentials m10493) args10495 (:args m10493)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10496
      (com.palletops.awaze.common/aws-client :s3 credentials10494)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10496
       getBucketCrossOriginConfiguration
       (clojure.core/str (clojure.core/nth args10495 0)))))))
  (clojure.core/defn
   get-bucket-cross-origin-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketCrossOriginConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-cross-origin-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-bucket-cross-origin-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketCrossOriginConfiguration"}
   [credentials10498 & args10499]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10500
     (com.palletops.awaze.common/aws-client :s3 credentials10498)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10500
      getBucketCrossOriginConfiguration
      (clojure.core/str (clojure.core/nth args10499 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :create-bucket
   [m10501]
   (clojure.core/let
    [credentials10502 (:credentials m10501) args10503 (:args m10501)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10504
      (com.palletops.awaze.common/aws-client :s3 credentials10502)]
     (clojure.core/case
      (clojure.core/count args10503)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CreateBucketRequest
           (clojure.core/nth args10503 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10504
           createBucket
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10503 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10504
               createBucket
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args10503}))))))))))
      2
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10503 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10503 1))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10504
           createBucket
           a
           b)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10503 0))
^{:tag com.amazonaws.services.s3.model.Region}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.Region
               (clojure.core/nth args10503 1))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10504
               createBucket
               a
               b)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args10503}))))))))))))))
  (clojure.core/defn
   create-bucket-map
   {:arglists (quote
               [[credentials
                 {:keys [region
                         general-progress-listener
                         canned-acl
                         bucket-name
                         access-control-list]}]
                [credentials string-0]
                [credentials string-0 string-1]
                [credentials string-0 region-1]]),
    :doc "Generate map for createBucket, createBucket, createBucket, createBucket"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :create-bucket,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :create-bucket,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-bucket
   {:arglists (quote
               [[credentials
                 {:keys [region
                         general-progress-listener
                         canned-acl
                         bucket-name
                         access-control-list]}]
                [credentials string-0]
                [credentials string-0 string-1]
                [credentials string-0 region-1]]),
    :doc "Call createBucket, createBucket, createBucket, createBucket"}
   [credentials10507 & args10508]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10510
     (com.palletops.awaze.common/aws-client :s3 credentials10507)]
    (clojure.core/case
     (clojure.core/count args10508)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CreateBucketRequest
          (clojure.core/nth args10508 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10510
          createBucket
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10508 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10510
              createBucket
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args10508}))))))))))
     2
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10508 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10508 1))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10510
          createBucket
          a
          b)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10508 0))
^{:tag com.amazonaws.services.s3.model.Region}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.Region
              (clojure.core/nth args10508 1))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10510
              createBucket
              a
              b)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args10508}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-objects
   [m10511]
   (clojure.core/let
    [credentials10512 (:credentials m10511) args10513 (:args m10511)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10514
      (com.palletops.awaze.common/aws-client :s3 credentials10512)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10514
       listNextBatchOfObjects
       (s3/object-listing (clojure.core/nth args10513 0)))))))
  (clojure.core/defn
   list-next-batch-of-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [prefix
                         object-summaries
                         bucket-name
                         common-prefixes
                         max-keys
                         truncated
                         next-marker
                         delimiter
                         marker
                         encoding-type]}]]),
    :doc "Generate map for listNextBatchOfObjects"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-next-batch-of-objects,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-next-batch-of-objects
   {:arglists (quote
               [[credentials
                 {:keys [prefix
                         object-summaries
                         bucket-name
                         common-prefixes
                         max-keys
                         truncated
                         next-marker
                         delimiter
                         marker
                         encoding-type]}]]),
    :doc "Call listNextBatchOfObjects"}
   [credentials10516 & args10517]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10518
     (com.palletops.awaze.common/aws-client :s3 credentials10516)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10518
      listNextBatchOfObjects
      (s3/object-listing (clojure.core/nth args10517 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :put-object
   [m10519]
   (clojure.core/let
    [credentials10520 (:credentials m10519) args10521 (:args m10519)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10522
      (com.palletops.awaze.common/aws-client :s3 credentials10520)]
     (clojure.core/case
      (clojure.core/count args10521)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10522
        putObject
        (clojure.core/str (clojure.core/nth args10521 0))
        (clojure.core/str (clojure.core/nth args10521 1))
        (clojure.java.io/file (clojure.core/nth args10521 2))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10522
        putObject
        (clojure.core/str (clojure.core/nth args10521 0))
        (clojure.core/str (clojure.core/nth args10521 1))
        (clojure.java.io/input-stream (clojure.core/nth args10521 2))
        (s3/object-metadata (clojure.core/nth args10521 3))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10522
        putObject
        (s3/put-object-request (clojure.core/nth args10521 0))))))))
  (clojure.core/defn
   put-object-map
   {:arglists (quote
               [[credentials string-0 string-1 file-2]
                [credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [expiration-time
                         content-md5
                         server-side-encryption
                         etag
                         cache-control
                         ssealgorithm
                         raw-metadata
                         content-disposition
                         content-type
                         ongoing-restore
                         version-id
                         restore-expiration-time
                         expiration-time-rule-id
                         content-length
                         instance-length
                         ssecustomer-algorithm
                         http-expires-date
                         last-modified
                         ssecustomer-key-md5
                         user-metadata
                         content-encoding]}]
                [credentials
                 {:keys [metadata
                         general-progress-listener
                         canned-acl
                         key
                         bucket-name
                         input-stream
                         access-control-list
                         progress-listener
                         redirect-location
                         ssecustomer-key
                         storage-class
                         file]}]]),
    :doc "Generate map for putObject, putObject, putObject"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :put-object,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :put-object,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :put-object,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-object
   {:arglists (quote
               [[credentials string-0 string-1 file-2]
                [credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [expiration-time
                         content-md5
                         server-side-encryption
                         etag
                         cache-control
                         ssealgorithm
                         raw-metadata
                         content-disposition
                         content-type
                         ongoing-restore
                         version-id
                         restore-expiration-time
                         expiration-time-rule-id
                         content-length
                         instance-length
                         ssecustomer-algorithm
                         http-expires-date
                         last-modified
                         ssecustomer-key-md5
                         user-metadata
                         content-encoding]}]
                [credentials
                 {:keys [metadata
                         general-progress-listener
                         canned-acl
                         key
                         bucket-name
                         input-stream
                         access-control-list
                         progress-listener
                         redirect-location
                         ssecustomer-key
                         storage-class
                         file]}]]),
    :doc "Call putObject, putObject, putObject"}
   [credentials10527 & args10528]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10532
     (com.palletops.awaze.common/aws-client :s3 credentials10527)]
    (clojure.core/case
     (clojure.core/count args10528)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10532
       putObject
       (clojure.core/str (clojure.core/nth args10528 0))
       (clojure.core/str (clojure.core/nth args10528 1))
       (clojure.java.io/file (clojure.core/nth args10528 2))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10532
       putObject
       (clojure.core/str (clojure.core/nth args10528 0))
       (clojure.core/str (clojure.core/nth args10528 1))
       (clojure.java.io/input-stream (clojure.core/nth args10528 2))
       (s3/object-metadata (clojure.core/nth args10528 3))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10532
       putObject
       (s3/put-object-request (clojure.core/nth args10528 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-policy
   [m10533]
   (clojure.core/let
    [credentials10534 (:credentials m10533) args10535 (:args m10533)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10536
      (com.palletops.awaze.common/aws-client :s3 credentials10534)]
     (clojure.core/case
      (clojure.core/count args10535)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketPolicyRequest
           (clojure.core/nth args10535 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10536
           getBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10535 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10536
               getBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketPolicy")
                {:args args10535}))))))))))))))
  (clojure.core/defn
   get-bucket-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketPolicy, getBucketPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-bucket-policy
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Call getBucketPolicy, getBucketPolicy"}
   [credentials10539 & args10540]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10542
     (com.palletops.awaze.common/aws-client :s3 credentials10539)]
    (clojure.core/case
     (clojure.core/count args10540)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketPolicyRequest
          (clojure.core/nth args10540 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10542
          getBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10540 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10542
              getBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketPolicy")
               {:args args10540}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-objects
   [m10543]
   (clojure.core/let
    [credentials10544 (:credentials m10543) args10545 (:args m10543)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10546
      (com.palletops.awaze.common/aws-client :s3 credentials10544)]
     (clojure.core/case
      (clojure.core/count args10545)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10545 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10546
           listObjects
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.ListObjectsRequest
               (clojure.core/nth args10545 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10546
               listObjects
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listObjects")
                {:args args10545}))))))))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10546
        listObjects
        (clojure.core/str (clojure.core/nth args10545 0))
        (clojure.core/str (clojure.core/nth args10545 1))))))))
  (clojure.core/defn
   list-objects-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener
                         prefix
                         bucket-name
                         max-keys
                         delimiter
                         marker
                         encoding-type]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for listObjects, listObjects, listObjects"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-objects,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :list-objects,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-objects
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener
                         prefix
                         bucket-name
                         max-keys
                         delimiter
                         marker
                         encoding-type]}]
                [credentials string-0 string-1]]),
    :doc "Call listObjects, listObjects, listObjects"}
   [credentials10548 & args10549]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10550
     (com.palletops.awaze.common/aws-client :s3 credentials10548)]
    (clojure.core/case
     (clojure.core/count args10549)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10549 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10550
          listObjects
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.ListObjectsRequest
              (clojure.core/nth args10549 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10550
              listObjects
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listObjects")
               {:args args10549}))))))))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10550
       listObjects
       (clojure.core/str (clojure.core/nth args10549 0))
       (clojure.core/str (clojure.core/nth args10549 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-region
   [m10551]
   (clojure.core/let
    [credentials10552 (:credentials m10551) args10553 (:args m10551)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10554
      (com.palletops.awaze.common/aws-client :s3 credentials10552)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10554
       setRegion
       (regions/region (clojure.core/nth args10553 0)))))))
  (clojure.core/defn
   set-region-map
   {:arglists (quote [[credentials region-0]]),
    :doc "Generate map for setRegion"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-region,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-region
   {:arglists (quote [[credentials region-0]]), :doc "Call setRegion"}
   [credentials10556 & args10557]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10558
     (com.palletops.awaze.common/aws-client :s3 credentials10556)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10558
      setRegion
      (regions/region (clojure.core/nth args10557 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :abort-multipart-upload
   [m10559]
   (clojure.core/let
    [credentials10560 (:credentials m10559) args10561 (:args m10559)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10562
      (com.palletops.awaze.common/aws-client :s3 credentials10560)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10562
       abortMultipartUpload
       (s3/abort-multipart-upload-request
        (clojure.core/nth args10561 0)))))))
  (clojure.core/defn
   abort-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         key
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Generate map for abortMultipartUpload"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :abort-multipart-upload,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   abort-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         key
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Call abortMultipartUpload"}
   [credentials10567 & args10568]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10572
     (com.palletops.awaze.common/aws-client :s3 credentials10567)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10572
      abortMultipartUpload
      (s3/abort-multipart-upload-request
       (clojure.core/nth args10568 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :upload-part
   [m10573]
   (clojure.core/let
    [credentials10574 (:credentials m10573) args10575 (:args m10573)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10576
      (com.palletops.awaze.common/aws-client :s3 credentials10574)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10576
       uploadPart
       (s3/upload-part-request (clojure.core/nth args10575 0)))))))
  (clojure.core/defn
   upload-part-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         md5digest
                         key
                         bucket-name
                         part-number
                         input-stream
                         upload-id
                         progress-listener
                         file-offset
                         last-part
                         ssecustomer-key
                         file
                         part-size]}]]),
    :doc "Generate map for uploadPart"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :upload-part,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   upload-part
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         md5digest
                         key
                         bucket-name
                         part-number
                         input-stream
                         upload-id
                         progress-listener
                         file-offset
                         last-part
                         ssecustomer-key
                         file
                         part-size]}]]),
    :doc "Call uploadPart"}
   [credentials10578 & args10579]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10580
     (com.palletops.awaze.common/aws-client :s3 credentials10578)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10580
      uploadPart
      (s3/upload-part-request (clojure.core/nth args10579 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :disable-requester-pays
   [m10581]
   (clojure.core/let
    [credentials10582 (:credentials m10581) args10583 (:args m10581)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10584
      (com.palletops.awaze.common/aws-client :s3 credentials10582)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10584
       disableRequesterPays
       (clojure.core/str (clojure.core/nth args10583 0)))))))
  (clojure.core/defn
   disable-requester-pays-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for disableRequesterPays"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :disable-requester-pays,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disable-requester-pays
   {:arglists (quote [[credentials string-0]]),
    :doc "Call disableRequesterPays"}
   [credentials10586 & args10587]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10588
     (com.palletops.awaze.common/aws-client :s3 credentials10586)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10588
      disableRequesterPays
      (clojure.core/str (clojure.core/nth args10587 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :complete-multipart-upload
   [m10589]
   (clojure.core/let
    [credentials10590 (:credentials m10589) args10591 (:args m10589)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10592
      (com.palletops.awaze.common/aws-client :s3 credentials10590)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10592
       completeMultipartUpload
       (s3/complete-multipart-upload-request
        (clojure.core/nth args10591 0)))))))
  (clojure.core/defn
   complete-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         part-etags
                         key
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Generate map for completeMultipartUpload"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :complete-multipart-upload,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   complete-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         part-etags
                         key
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Call completeMultipartUpload"}
   [credentials10598 & args10599]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10604
     (com.palletops.awaze.common/aws-client :s3 credentials10598)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10604
      completeMultipartUpload
      (s3/complete-multipart-upload-request
       (clojure.core/nth args10599 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :list-versions
   [m10605]
   (clojure.core/let
    [credentials10606 (:credentials m10605) args10607 (:args m10605)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10608
      (com.palletops.awaze.common/aws-client :s3 credentials10606)]
     (clojure.core/case
      (clojure.core/count args10607)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10608
        listVersions
        (s3/list-versions-request (clojure.core/nth args10607 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10608
        listVersions
        (clojure.core/str (clojure.core/nth args10607 0))
        (clojure.core/str (clojure.core/nth args10607 1))))
      6
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10608
        listVersions
        (clojure.core/str (clojure.core/nth args10607 0))
        (clojure.core/str (clojure.core/nth args10607 1))
        (clojure.core/str (clojure.core/nth args10607 2))
        (clojure.core/str (clojure.core/nth args10607 3))
        (clojure.core/str (clojure.core/nth args10607 4))
        (clojure.core/int (clojure.core/nth args10607 5))))))))
  (clojure.core/defn
   list-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         prefix
                         max-results
                         bucket-name
                         key-marker
                         delimiter
                         version-id-marker
                         encoding-type]}]
                [credentials string-0 string-1]
                [credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]]),
    :doc "Generate map for listVersions, listVersions, listVersions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-versions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :list-versions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c d e f]
    {:args [a b c d e f],
     :client :s3,
     :fn :list-versions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-versions
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         prefix
                         max-results
                         bucket-name
                         key-marker
                         delimiter
                         version-id-marker
                         encoding-type]}]
                [credentials string-0 string-1]
                [credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]]),
    :doc "Call listVersions, listVersions, listVersions"}
   [credentials10610 & args10611]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10612
     (com.palletops.awaze.common/aws-client :s3 credentials10610)]
    (clojure.core/case
     (clojure.core/count args10611)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10612
       listVersions
       (s3/list-versions-request (clojure.core/nth args10611 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10612
       listVersions
       (clojure.core/str (clojure.core/nth args10611 0))
       (clojure.core/str (clojure.core/nth args10611 1))))
     6
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10612
       listVersions
       (clojure.core/str (clojure.core/nth args10611 0))
       (clojure.core/str (clojure.core/nth args10611 1))
       (clojure.core/str (clojure.core/nth args10611 2))
       (clojure.core/str (clojure.core/nth args10611 3))
       (clojure.core/str (clojure.core/nth args10611 4))
       (clojure.core/int (clojure.core/nth args10611 5))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-redirect-location
   [m10613]
   (clojure.core/let
    [credentials10614 (:credentials m10613) args10615 (:args m10613)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10616
      (com.palletops.awaze.common/aws-client :s3 credentials10614)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10616
       setObjectRedirectLocation
       (clojure.core/str (clojure.core/nth args10615 0))
       (clojure.core/str (clojure.core/nth args10615 1))
       (clojure.core/str (clojure.core/nth args10615 2)))))))
  (clojure.core/defn
   set-object-redirect-location-map
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Generate map for setObjectRedirectLocation"}
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :set-object-redirect-location,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-object-redirect-location
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Call setObjectRedirectLocation"}
   [credentials10618 & args10619]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10620
     (com.palletops.awaze.common/aws-client :s3 credentials10618)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10620
      setObjectRedirectLocation
      (clojure.core/str (clojure.core/nth args10619 0))
      (clojure.core/str (clojure.core/nth args10619 1))
      (clojure.core/str (clojure.core/nth args10619 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-website-configuration
   [m10621]
   (clojure.core/let
    [credentials10622 (:credentials m10621) args10623 (:args m10621)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10624
      (com.palletops.awaze.common/aws-client :s3 credentials10622)]
     (clojure.core/case
      (clojure.core/count args10623)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10623 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10624
           deleteBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
               (clojure.core/nth args10623 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10624
               deleteBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketWebsiteConfiguration")
                {:args args10623}))))))))))))))
  (clojure.core/defn
   delete-bucket-website-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener bucket-name bucket]}]]),
    :doc "Generate map for deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-website-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-bucket-website-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener bucket-name bucket]}]]),
    :doc "Call deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   [credentials10627 & args10628]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10630
     (com.palletops.awaze.common/aws-client :s3 credentials10627)]
    (clojure.core/case
     (clojure.core/count args10628)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10628 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10630
          deleteBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
              (clojure.core/nth args10628 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10630
              deleteBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketWebsiteConfiguration")
               {:args args10628}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-multipart-uploads
   [m10631]
   (clojure.core/let
    [credentials10632 (:credentials m10631) args10633 (:args m10631)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10634
      (com.palletops.awaze.common/aws-client :s3 credentials10632)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10634
       listMultipartUploads
       (s3/list-multipart-uploads-request
        (clojure.core/nth args10633 0)))))))
  (clojure.core/defn
   list-multipart-uploads-map
   {:arglists (quote
               [[credentials
                 {:keys [max-uploads
                         general-progress-listener
                         prefix
                         upload-id-marker
                         bucket-name
                         key-marker
                         delimiter
                         encoding-type]}]]),
    :doc "Generate map for listMultipartUploads"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-multipart-uploads,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-multipart-uploads
   {:arglists (quote
               [[credentials
                 {:keys [max-uploads
                         general-progress-listener
                         prefix
                         upload-id-marker
                         bucket-name
                         key-marker
                         delimiter
                         encoding-type]}]]),
    :doc "Call listMultipartUploads"}
   [credentials10637 & args10638]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10640
     (com.palletops.awaze.common/aws-client :s3 credentials10637)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10640
      listMultipartUploads
      (s3/list-multipart-uploads-request
       (clojure.core/nth args10638 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-lifecycle-configuration
   [m10641]
   (clojure.core/let
    [credentials10642 (:credentials m10641) args10643 (:args m10641)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10644
      (com.palletops.awaze.common/aws-client :s3 credentials10642)]
     (clojure.core/case
      (clojure.core/count args10643)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10644
        setBucketLifecycleConfiguration
        (s3/set-bucket-lifecycle-configuration-request
         (clojure.core/nth args10643 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10644
        setBucketLifecycleConfiguration
        (clojure.core/str (clojure.core/nth args10643 0))
        (s3/bucket-lifecycle-configuration
         (clojure.core/nth args10643 1))))))))
  (clojure.core/defn
   set-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-configuration
                         general-progress-listener
                         bucket-name]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Generate map for setBucketLifecycleConfiguration, setBucketLifecycleConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-configuration
                         general-progress-listener
                         bucket-name]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Call setBucketLifecycleConfiguration, setBucketLifecycleConfiguration"}
   [credentials10648 & args10649]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10652
     (com.palletops.awaze.common/aws-client :s3 credentials10648)]
    (clojure.core/case
     (clojure.core/count args10649)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10652
       setBucketLifecycleConfiguration
       (s3/set-bucket-lifecycle-configuration-request
        (clojure.core/nth args10649 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10652
       setBucketLifecycleConfiguration
       (clojure.core/str (clojure.core/nth args10649 0))
       (s3/bucket-lifecycle-configuration
        (clojure.core/nth args10649 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :enable-requester-pays
   [m10653]
   (clojure.core/let
    [credentials10654 (:credentials m10653) args10655 (:args m10653)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10656
      (com.palletops.awaze.common/aws-client :s3 credentials10654)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10656
       enableRequesterPays
       (clojure.core/str (clojure.core/nth args10655 0)))))))
  (clojure.core/defn
   enable-requester-pays-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for enableRequesterPays"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :enable-requester-pays,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-requester-pays
   {:arglists (quote [[credentials string-0]]),
    :doc "Call enableRequesterPays"}
   [credentials10658 & args10659]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10660
     (com.palletops.awaze.common/aws-client :s3 credentials10658)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10660
      enableRequesterPays
      (clojure.core/str (clojure.core/nth args10659 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-metadata
   [m10661]
   (clojure.core/let
    [credentials10662 (:credentials m10661) args10663 (:args m10661)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10664
      (com.palletops.awaze.common/aws-client :s3 credentials10662)]
     (clojure.core/case
      (clojure.core/count args10663)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10664
        getObjectMetadata
        (clojure.core/str (clojure.core/nth args10663 0))
        (clojure.core/str (clojure.core/nth args10663 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10664
        getObjectMetadata
        (s3/get-object-metadata-request
         (clojure.core/nth args10663 0))))))))
  (clojure.core/defn
   get-object-metadata-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [version-id
                         key
                         general-progress-listener
                         bucket-name
                         ssecustomer-key]}]]),
    :doc "Generate map for getObjectMetadata, getObjectMetadata"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-object-metadata,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-object-metadata,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-object-metadata
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [version-id
                         key
                         general-progress-listener
                         bucket-name
                         ssecustomer-key]}]]),
    :doc "Call getObjectMetadata, getObjectMetadata"}
   [credentials10668 & args10669]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10672
     (com.palletops.awaze.common/aws-client :s3 credentials10668)]
    (clojure.core/case
     (clojure.core/count args10669)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10672
       getObjectMetadata
       (clojure.core/str (clojure.core/nth args10669 0))
       (clojure.core/str (clojure.core/nth args10669 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10672
       getObjectMetadata
       (s3/get-object-metadata-request (clojure.core/nth args10669 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-cross-origin-configuration
   [m10673]
   (clojure.core/let
    [credentials10674 (:credentials m10673) args10675 (:args m10673)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10676
      (com.palletops.awaze.common/aws-client :s3 credentials10674)]
     (clojure.core/case
      (clojure.core/count args10675)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
           (clojure.core/nth args10675 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10676
           deleteBucketCrossOriginConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10675 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10676
               deleteBucketCrossOriginConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketCrossOriginConfiguration")
                {:args args10675}))))))))))))))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketCrossOriginConfiguration, deleteBucketCrossOriginConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-cross-origin-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketCrossOriginConfiguration, deleteBucketCrossOriginConfiguration"}
   [credentials10679 & args10680]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10682
     (com.palletops.awaze.common/aws-client :s3 credentials10679)]
    (clojure.core/case
     (clojure.core/count args10680)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
          (clojure.core/nth args10680 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10682
          deleteBucketCrossOriginConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10680 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10682
              deleteBucketCrossOriginConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketCrossOriginConfiguration")
               {:args args10680}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-tagging-configuration
   [m10683]
   (clojure.core/let
    [credentials10684 (:credentials m10683) args10685 (:args m10683)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10686
      (com.palletops.awaze.common/aws-client :s3 credentials10684)]
     (clojure.core/case
      (clojure.core/count args10685)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
           (clojure.core/nth args10685 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10686
           deleteBucketTaggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10685 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10686
               deleteBucketTaggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketTaggingConfiguration")
                {:args args10685}))))))))))))))
  (clojure.core/defn
   delete-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketTaggingConfiguration, deleteBucketTaggingConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-tagging-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-bucket-tagging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketTaggingConfiguration, deleteBucketTaggingConfiguration"}
   [credentials10689 & args10690]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10692
     (com.palletops.awaze.common/aws-client :s3 credentials10689)]
    (clojure.core/case
     (clojure.core/count args10690)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
          (clojure.core/nth args10690 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10692
          deleteBucketTaggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10690 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10692
              deleteBucketTaggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketTaggingConfiguration")
               {:args args10690}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-acl
   [m10693]
   (clojure.core/let
    [credentials10694 (:credentials m10693) args10695 (:args m10693)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10696
      (com.palletops.awaze.common/aws-client :s3 credentials10694)]
     (clojure.core/case
      (clojure.core/count args10695)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10696
        getObjectAcl
        (clojure.core/str (clojure.core/nth args10695 0))
        (clojure.core/str (clojure.core/nth args10695 1))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10696
        getObjectAcl
        (clojure.core/str (clojure.core/nth args10695 0))
        (clojure.core/str (clojure.core/nth args10695 1))
        (clojure.core/str (clojure.core/nth args10695 2))))))))
  (clojure.core/defn
   get-object-acl-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for getObjectAcl, getObjectAcl"}
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-object-acl,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :get-object-acl,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-object-acl
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials string-0 string-1 string-2]]),
    :doc "Call getObjectAcl, getObjectAcl"}
   [credentials10698 & args10699]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10700
     (com.palletops.awaze.common/aws-client :s3 credentials10698)]
    (clojure.core/case
     (clojure.core/count args10699)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10700
       getObjectAcl
       (clojure.core/str (clojure.core/nth args10699 0))
       (clojure.core/str (clojure.core/nth args10699 1))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10700
       getObjectAcl
       (clojure.core/str (clojure.core/nth args10699 0))
       (clojure.core/str (clojure.core/nth args10699 1))
       (clojure.core/str (clojure.core/nth args10699 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-policy
   [m10701]
   (clojure.core/let
    [credentials10702 (:credentials m10701) args10703 (:args m10701)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10704
      (com.palletops.awaze.common/aws-client :s3 credentials10702)]
     (clojure.core/case
      (clojure.core/count args10703)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
           (clojure.core/nth args10703 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10704
           deleteBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10703 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10704
               deleteBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketPolicy")
                {:args args10703}))))))))))))))
  (clojure.core/defn
   delete-bucket-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketPolicy, deleteBucketPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-bucket-policy
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Call deleteBucketPolicy, deleteBucketPolicy"}
   [credentials10707 & args10708]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10710
     (com.palletops.awaze.common/aws-client :s3 credentials10707)]
    (clojure.core/case
     (clojure.core/count args10708)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
          (clojure.core/nth args10708 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10710
          deleteBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10708 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10710
              deleteBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketPolicy")
               {:args args10708}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-tagging-configuration
   [m10711]
   (clojure.core/let
    [credentials10712 (:credentials m10711) args10713 (:args m10711)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10714
      (com.palletops.awaze.common/aws-client :s3 credentials10712)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10714
       getBucketTaggingConfiguration
       (clojure.core/str (clojure.core/nth args10713 0)))))))
  (clojure.core/defn
   get-bucket-tagging-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketTaggingConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-tagging-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-bucket-tagging-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketTaggingConfiguration"}
   [credentials10716 & args10717]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10718
     (com.palletops.awaze.common/aws-client :s3 credentials10716)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10718
      getBucketTaggingConfiguration
      (clojure.core/str (clojure.core/nth args10717 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-website-configuration
   [m10719]
   (clojure.core/let
    [credentials10720 (:credentials m10719) args10721 (:args m10719)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10722
      (com.palletops.awaze.common/aws-client :s3 credentials10720)]
     (clojure.core/case
      (clojure.core/count args10721)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
           (clojure.core/nth args10721 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10722
           getBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10721 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10722
               getBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketWebsiteConfiguration")
                {:args args10721}))))))))))))))
  (clojure.core/defn
   get-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-website-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Call getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   [credentials10725 & args10726]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10728
     (com.palletops.awaze.common/aws-client :s3 credentials10725)]
    (clojure.core/case
     (clojure.core/count args10726)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
          (clojure.core/nth args10726 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10728
          getBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10726 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10728
              getBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketWebsiteConfiguration")
               {:args args10726}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-lifecycle-configuration
   [m10729]
   (clojure.core/let
    [credentials10730 (:credentials m10729) args10731 (:args m10729)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10732
      (com.palletops.awaze.common/aws-client :s3 credentials10730)]
     (clojure.core/case
      (clojure.core/count args10731)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
           (clojure.core/nth args10731 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10732
           deleteBucketLifecycleConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10731 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10732
               deleteBucketLifecycleConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketLifecycleConfiguration")
                {:args args10731}))))))))))))))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketLifecycleConfiguration, deleteBucketLifecycleConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-lifecycle-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketLifecycleConfiguration, deleteBucketLifecycleConfiguration"}
   [credentials10735 & args10736]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10738
     (com.palletops.awaze.common/aws-client :s3 credentials10735)]
    (clojure.core/case
     (clojure.core/count args10736)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
          (clojure.core/nth args10736 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10738
          deleteBucketLifecycleConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10736 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10738
              deleteBucketLifecycleConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketLifecycleConfiguration")
               {:args args10736}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket
   [m10739]
   (clojure.core/let
    [credentials10740 (:credentials m10739) args10741 (:args m10739)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10742
      (com.palletops.awaze.common/aws-client :s3 credentials10740)]
     (clojure.core/case
      (clojure.core/count args10741)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketRequest
           (clojure.core/nth args10741 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10742
           deleteBucket
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10741 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10742
               deleteBucket
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucket")
                {:args args10741}))))))))))))))
  (clojure.core/defn
   delete-bucket-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucket, deleteBucket"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-bucket
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Call deleteBucket, deleteBucket"}
   [credentials10745 & args10746]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10748
     (com.palletops.awaze.common/aws-client :s3 credentials10745)]
    (clojure.core/case
     (clojure.core/count args10746)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketRequest
          (clojure.core/nth args10746 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10748
          deleteBucket
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10746 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10748
              deleteBucket
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucket")
               {:args args10746}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-object
   [m10749]
   (clojure.core/let
    [credentials10750 (:credentials m10749) args10751 (:args m10749)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10752
      (com.palletops.awaze.common/aws-client :s3 credentials10750)]
     (clojure.core/case
      (clojure.core/count args10751)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10752
        deleteObject
        (clojure.core/str (clojure.core/nth args10751 0))
        (clojure.core/str (clojure.core/nth args10751 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10752
        deleteObject
        (s3/delete-object-request (clojure.core/nth args10751 0))))))))
  (clojure.core/defn
   delete-object-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [key general-progress-listener bucket-name]}]]),
    :doc "Generate map for deleteObject, deleteObject"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-object,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :delete-object,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-object
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [key general-progress-listener bucket-name]}]]),
    :doc "Call deleteObject, deleteObject"}
   [credentials10756 & args10757]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10760
     (com.palletops.awaze.common/aws-client :s3 credentials10756)]
    (clojure.core/case
     (clojure.core/count args10757)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10760
       deleteObject
       (clojure.core/str (clojure.core/nth args10757 0))
       (clojure.core/str (clojure.core/nth args10757 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10760
       deleteObject
       (s3/delete-object-request (clojure.core/nth args10757 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-region
   [m10761]
   (clojure.core/let
    [credentials10762 (:credentials m10761) args10763 (:args m10761)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10764
      (com.palletops.awaze.common/aws-client :s3 credentials10762)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10764
       getRegion)))))
  (clojure.core/defn
   get-region-map
   {:arglists (quote [[credentials]]),
    :doc "Generate map for getRegion"}
   ([credentials__1651__auto__]
    {:args [],
     :client :s3,
     :fn :get-region,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-region
   {:arglists (quote [[credentials]]), :doc "Call getRegion"}
   [credentials10766 & args10767]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10768
     (com.palletops.awaze.common/aws-client :s3 credentials10766)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10768
      getRegion)))))
 (do
  (clojure.core/defmethod
   s3
   :copy-part
   [m10769]
   (clojure.core/let
    [credentials10770 (:credentials m10769) args10771 (:args m10769)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10772
      (com.palletops.awaze.common/aws-client :s3 credentials10770)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10772
       copyPart
       (s3/copy-part-request (clojure.core/nth args10771 0)))))))
  (clojure.core/defn
   copy-part-map
   {:arglists (quote
               [[credentials
                 {:keys [source-key
                         source-ssecustomer-key
                         general-progress-listener
                         source-bucket-name
                         last-byte
                         destination-ssecustomer-key
                         part-number
                         unmodified-since-constraint
                         upload-id
                         modified-since-constraint
                         first-byte
                         nonmatching-etag-constraints
                         destination-key
                         matching-etag-constraints
                         destination-bucket-name
                         source-version-id]}]]),
    :doc "Generate map for copyPart"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :copy-part,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   copy-part
   {:arglists (quote
               [[credentials
                 {:keys [source-key
                         source-ssecustomer-key
                         general-progress-listener
                         source-bucket-name
                         last-byte
                         destination-ssecustomer-key
                         part-number
                         unmodified-since-constraint
                         upload-id
                         modified-since-constraint
                         first-byte
                         nonmatching-etag-constraints
                         destination-key
                         matching-etag-constraints
                         destination-bucket-name
                         source-version-id]}]]),
    :doc "Call copyPart"}
   [credentials10774 & args10775]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10776
     (com.palletops.awaze.common/aws-client :s3 credentials10774)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10776
      copyPart
      (s3/copy-part-request (clojure.core/nth args10775 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :initiate-multipart-upload
   [m10777]
   (clojure.core/let
    [credentials10778 (:credentials m10777) args10779 (:args m10777)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10780
      (com.palletops.awaze.common/aws-client :s3 credentials10778)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10780
       initiateMultipartUpload
       (s3/initiate-multipart-upload-request
        (clojure.core/nth args10779 0)))))))
  (clojure.core/defn
   initiate-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         canned-acl
                         key
                         bucket-name
                         access-control-list
                         redirect-location
                         ssecustomer-key
                         storage-class
                         object-metadata]}]]),
    :doc "Generate map for initiateMultipartUpload"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :initiate-multipart-upload,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   initiate-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         canned-acl
                         key
                         bucket-name
                         access-control-list
                         redirect-location
                         ssecustomer-key
                         storage-class
                         object-metadata]}]]),
    :doc "Call initiateMultipartUpload"}
   [credentials10784 & args10785]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10788
     (com.palletops.awaze.common/aws-client :s3 credentials10784)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10788
      initiateMultipartUpload
      (s3/initiate-multipart-upload-request
       (clojure.core/nth args10785 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-policy
   [m10789]
   (clojure.core/let
    [credentials10790 (:credentials m10789) args10791 (:args m10789)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10792
      (com.palletops.awaze.common/aws-client :s3 credentials10790)]
     (clojure.core/case
      (clojure.core/count args10791)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10792
        setBucketPolicy
        (s3/set-bucket-policy-request (clojure.core/nth args10791 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10792
        setBucketPolicy
        (clojure.core/str (clojure.core/nth args10791 0))
        (clojure.core/str (clojure.core/nth args10791 1))))))))
  (clojure.core/defn
   set-bucket-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-text
                         general-progress-listener
                         bucket-name]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for setBucketPolicy, setBucketPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-policy,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-bucket-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-text
                         general-progress-listener
                         bucket-name]}]
                [credentials string-0 string-1]]),
    :doc "Call setBucketPolicy, setBucketPolicy"}
   [credentials10796 & args10797]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10800
     (com.palletops.awaze.common/aws-client :s3 credentials10796)]
    (clojure.core/case
     (clojure.core/count args10797)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10800
       setBucketPolicy
       (s3/set-bucket-policy-request (clojure.core/nth args10797 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10800
       setBucketPolicy
       (clojure.core/str (clojure.core/nth args10797 0))
       (clojure.core/str (clojure.core/nth args10797 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-notification-configuration
   [m10801]
   (clojure.core/let
    [credentials10802 (:credentials m10801) args10803 (:args m10801)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10804
      (com.palletops.awaze.common/aws-client :s3 credentials10802)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10804
       getBucketNotificationConfiguration
       (clojure.core/str (clojure.core/nth args10803 0)))))))
  (clojure.core/defn
   get-bucket-notification-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketNotificationConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-notification-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-bucket-notification-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketNotificationConfiguration"}
   [credentials10806 & args10807]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10808
     (com.palletops.awaze.common/aws-client :s3 credentials10806)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10808
      getBucketNotificationConfiguration
      (clojure.core/str (clojure.core/nth args10807 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :generate-presigned-url
   [m10809]
   (clojure.core/let
    [credentials10810 (:credentials m10809) args10811 (:args m10809)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10812
      (com.palletops.awaze.common/aws-client :s3 credentials10810)]
     (clojure.core/case
      (clojure.core/count args10811)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10812
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args10811 0))
        (clojure.core/str (clojure.core/nth args10811 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args10811 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10812
        generatePresignedUrl
        (s3/generate-presigned-url-request
         (clojure.core/nth args10811 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10812
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args10811 0))
        (clojure.core/str (clojure.core/nth args10811 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args10811 2))
        (root/http-method (clojure.core/nth args10811 3))))))))
  (clojure.core/defn
   generate-presigned-url-map
   {:arglists (quote
               [[credentials string-0 string-1 date-2]
                [credentials
                 {:keys [content-md5
                         expiration
                         general-progress-listener
                         response-headers
                         key
                         method
                         bucket-name
                         content-type
                         request-parameters
                         ssecustomer-key]}]
                [credentials string-0 string-1 date-2 http-method-3]]),
    :doc "Generate map for generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :generate-presigned-url,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :generate-presigned-url,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :generate-presigned-url,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   generate-presigned-url
   {:arglists (quote
               [[credentials string-0 string-1 date-2]
                [credentials
                 {:keys [content-md5
                         expiration
                         general-progress-listener
                         response-headers
                         key
                         method
                         bucket-name
                         content-type
                         request-parameters
                         ssecustomer-key]}]
                [credentials string-0 string-1 date-2 http-method-3]]),
    :doc "Call generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   [credentials10816 & args10817]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10820
     (com.palletops.awaze.common/aws-client :s3 credentials10816)]
    (clojure.core/case
     (clojure.core/count args10817)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10820
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args10817 0))
       (clojure.core/str (clojure.core/nth args10817 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args10817 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10820
       generatePresignedUrl
       (s3/generate-presigned-url-request
        (clojure.core/nth args10817 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10820
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args10817 0))
       (clojure.core/str (clojure.core/nth args10817 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args10817 2))
       (root/http-method (clojure.core/nth args10817 3))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-parts
   [m10821]
   (clojure.core/let
    [credentials10822 (:credentials m10821) args10823 (:args m10821)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10824
      (com.palletops.awaze.common/aws-client :s3 credentials10822)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10824
       listParts
       (s3/list-parts-request (clojure.core/nth args10823 0)))))))
  (clojure.core/defn
   list-parts-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         key
                         max-parts
                         bucket-name
                         upload-id
                         part-number-marker
                         encoding-type]}]]),
    :doc "Generate map for listParts"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-parts,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-parts
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         key
                         max-parts
                         bucket-name
                         upload-id
                         part-number-marker
                         encoding-type]}]]),
    :doc "Call listParts"}
   [credentials10829 & args10830]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10834
     (com.palletops.awaze.common/aws-client :s3 credentials10829)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10834
      listParts
      (s3/list-parts-request (clojure.core/nth args10830 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-s3account-owner
   [m10835]
   (clojure.core/let
    [credentials10836 (:credentials m10835) args10837 (:args m10835)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10838
      (com.palletops.awaze.common/aws-client :s3 credentials10836)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10838
       getS3AccountOwner)))))
  (clojure.core/defn
   get-s3account-owner-map
   {:arglists (quote [[credentials]]),
    :doc "Generate map for getS3AccountOwner"}
   ([credentials__1651__auto__]
    {:args [],
     :client :s3,
     :fn :get-s3account-owner,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-s3account-owner
   {:arglists (quote [[credentials]]), :doc "Call getS3AccountOwner"}
   [credentials10840 & args10841]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10842
     (com.palletops.awaze.common/aws-client :s3 credentials10840)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10842
      getS3AccountOwner)))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-logging-configuration
   [m10843]
   (clojure.core/let
    [credentials10844 (:credentials m10843) args10845 (:args m10843)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10846
      (com.palletops.awaze.common/aws-client :s3 credentials10844)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10846
       getBucketLoggingConfiguration
       (clojure.core/str (clojure.core/nth args10845 0)))))))
  (clojure.core/defn
   get-bucket-logging-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketLoggingConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-logging-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-bucket-logging-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketLoggingConfiguration"}
   [credentials10848 & args10849]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10850
     (com.palletops.awaze.common/aws-client :s3 credentials10848)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10850
      getBucketLoggingConfiguration
      (clojure.core/str (clojure.core/nth args10849 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :list-buckets
   [m10851]
   (clojure.core/let
    [credentials10852 (:credentials m10851) args10853 (:args m10851)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10854
      (com.palletops.awaze.common/aws-client :s3 credentials10852)]
     (clojure.core/case
      (clojure.core/count args10853)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10854
        listBuckets
        (s3/list-buckets-request (clojure.core/nth args10853 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10854
        listBuckets))))))
  (clojure.core/defn
   list-buckets-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listBuckets, listBuckets"}
   ([credentials__1651__auto__]
    {:args [],
     :client :s3,
     :fn :list-buckets,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-buckets,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-buckets
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call listBuckets, listBuckets"}
   [credentials10856 & args10857]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10858
     (com.palletops.awaze.common/aws-client :s3 credentials10856)]
    (clojure.core/case
     (clojure.core/count args10857)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10858
       listBuckets
       (s3/list-buckets-request (clojure.core/nth args10857 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10858
       listBuckets))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-logging-configuration
   [m10859]
   (clojure.core/let
    [credentials10860 (:credentials m10859) args10861 (:args m10859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10862
      (com.palletops.awaze.common/aws-client :s3 credentials10860)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10862
       setBucketLoggingConfiguration
       (s3/set-bucket-logging-configuration-request
        (clojure.core/nth args10861 0)))))))
  (clojure.core/defn
   set-bucket-logging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [logging-configuration
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Generate map for setBucketLoggingConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-logging-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-bucket-logging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [logging-configuration
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Call setBucketLoggingConfiguration"}
   [credentials10866 & args10867]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10870
     (com.palletops.awaze.common/aws-client :s3 credentials10866)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10870
      setBucketLoggingConfiguration
      (s3/set-bucket-logging-configuration-request
       (clojure.core/nth args10867 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-acl
   [m10871]
   (clojure.core/let
    [credentials10872 (:credentials m10871) args10873 (:args m10871)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10874
      (com.palletops.awaze.common/aws-client :s3 credentials10872)]
     (clojure.core/case
      (clojure.core/count args10873)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketAclRequest
           (clojure.core/nth args10873 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10874
           getBucketAcl
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10873 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10874
               getBucketAcl
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketAcl")
                {:args args10873}))))))))))))))
  (clojure.core/defn
   get-bucket-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketAcl, getBucketAcl"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-acl,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-bucket-acl
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Call getBucketAcl, getBucketAcl"}
   [credentials10877 & args10878]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10880
     (com.palletops.awaze.common/aws-client :s3 credentials10877)]
    (clojure.core/case
     (clojure.core/count args10878)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketAclRequest
          (clojure.core/nth args10878 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10880
          getBucketAcl
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10878 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10880
              getBucketAcl
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketAcl")
               {:args args10878}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-versions
   [m10881]
   (clojure.core/let
    [credentials10882 (:credentials m10881) args10883 (:args m10881)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10884
      (com.palletops.awaze.common/aws-client :s3 credentials10882)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10884
       listNextBatchOfVersions
       (s3/version-listing (clojure.core/nth args10883 0)))))))
  (clojure.core/defn
   list-next-batch-of-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [prefix
                         bucket-name
                         common-prefixes
                         version-summaries
                         max-keys
                         truncated
                         key-marker
                         next-key-marker
                         delimiter
                         next-version-id-marker
                         version-id-marker
                         encoding-type]}]]),
    :doc "Generate map for listNextBatchOfVersions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-next-batch-of-versions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-next-batch-of-versions
   {:arglists (quote
               [[credentials
                 {:keys [prefix
                         bucket-name
                         common-prefixes
                         version-summaries
                         max-keys
                         truncated
                         key-marker
                         next-key-marker
                         delimiter
                         next-version-id-marker
                         version-id-marker
                         encoding-type]}]]),
    :doc "Call listNextBatchOfVersions"}
   [credentials10886 & args10887]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10888
     (com.palletops.awaze.common/aws-client :s3 credentials10886)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10888
      listNextBatchOfVersions
      (s3/version-listing (clojure.core/nth args10887 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :is-requester-pays-enabled
   [m10889]
   (clojure.core/let
    [credentials10890 (:credentials m10889) args10891 (:args m10889)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10892
      (com.palletops.awaze.common/aws-client :s3 credentials10890)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10892
       isRequesterPaysEnabled
       (clojure.core/str (clojure.core/nth args10891 0)))))))
  (clojure.core/defn
   is-requester-pays-enabled-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for isRequesterPaysEnabled"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :s3,
     :fn :is-requester-pays-enabled,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   is-requester-pays-enabled
   {:arglists (quote [[credentials string-0]]),
    :doc "Call isRequesterPaysEnabled"}
   [credentials10894 & args10895]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10896
     (com.palletops.awaze.common/aws-client :s3 credentials10894)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10896
      isRequesterPaysEnabled
      (clojure.core/str (clojure.core/nth args10895 0))))))))
