(ns
 com.palletops.awaze.redshift
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.redshift :as redshift]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :redshift
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.redshift.AmazonRedshiftClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.Parameter}
parameter
  [m2527]
  (clojure.core/let
   [bean2526 (new com.amazonaws.services.redshift.model.Parameter)]
   (clojure.core/let
    [v2528
     (:parameter-name m2527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2528 :com.palletops.awaze.client-builder/undef)
     (. bean2526 setParameterName (clojure.core/str v2528))))
   (clojure.core/let
    [v2528
     (:parameter-value
      m2527
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2528 :com.palletops.awaze.client-builder/undef)
     (. bean2526 setParameterValue (clojure.core/str v2528))))
   (clojure.core/let
    [v2528
     (:data-type m2527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2528 :com.palletops.awaze.client-builder/undef)
     (. bean2526 setDataType (clojure.core/str v2528))))
   (clojure.core/let
    [v2528
     (:allowed-values m2527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2528 :com.palletops.awaze.client-builder/undef)
     (. bean2526 setAllowedValues (clojure.core/str v2528))))
   (clojure.core/let
    [v2528
     (:is-modifiable m2527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2528 :com.palletops.awaze.client-builder/undef)
     (. bean2526 setIsModifiable (clojure.core/boolean v2528))))
   (clojure.core/let
    [v2528
     (:minimum-engine-version
      m2527
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2528 :com.palletops.awaze.client-builder/undef)
     (. bean2526 setMinimumEngineVersion (clojure.core/str v2528))))
   (clojure.core/let
    [v2528 (:source m2527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2528 :com.palletops.awaze.client-builder/undef)
     (. bean2526 setSource (clojure.core/str v2528))))
   (clojure.core/let
    [v2528
     (:description m2527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2528 :com.palletops.awaze.client-builder/undef)
     (. bean2526 setDescription (clojure.core/str v2528))))
   bean2526))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest}
describe-cluster-security-groups-request
  [m2530]
  (clojure.core/let
   [bean2529
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest)]
   (clojure.core/let
    [v2531 (:marker m2530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2531 :com.palletops.awaze.client-builder/undef)
     (. bean2529 setMarker (clojure.core/str v2531))))
   (clojure.core/let
    [v2531
     (:max-records m2530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2531 :com.palletops.awaze.client-builder/undef)
     (. bean2529 setMaxRecords (clojure.core/int v2531))))
   (clojure.core/let
    [v2531
     (:cluster-security-group-name
      m2530
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2531 :com.palletops.awaze.client-builder/undef)
     (. bean2529 setClusterSecurityGroupName (clojure.core/str v2531))))
   bean2529))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest}
describe-cluster-parameter-groups-request
  [m2533]
  (clojure.core/let
   [bean2532
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest)]
   (clojure.core/let
    [v2534 (:marker m2533 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2534 :com.palletops.awaze.client-builder/undef)
     (. bean2532 setMarker (clojure.core/str v2534))))
   (clojure.core/let
    [v2534
     (:max-records m2533 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2534 :com.palletops.awaze.client-builder/undef)
     (. bean2532 setMaxRecords (clojure.core/int v2534))))
   (clojure.core/let
    [v2534
     (:parameter-group-name
      m2533
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2534 :com.palletops.awaze.client-builder/undef)
     (. bean2532 setParameterGroupName (clojure.core/str v2534))))
   bean2532))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest}
enable-snapshot-copy-request
  [m2536]
  (clojure.core/let
   [bean2535
    (new
     com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest)]
   (clojure.core/let
    [v2537
     (:cluster-identifier
      m2536
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2537 :com.palletops.awaze.client-builder/undef)
     (. bean2535 setClusterIdentifier (clojure.core/str v2537))))
   (clojure.core/let
    [v2537
     (:retention-period
      m2536
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2537 :com.palletops.awaze.client-builder/undef)
     (. bean2535 setRetentionPeriod (clojure.core/int v2537))))
   (clojure.core/let
    [v2537
     (:destination-region
      m2536
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2537 :com.palletops.awaze.client-builder/undef)
     (. bean2535 setDestinationRegion (clojure.core/str v2537))))
   bean2535))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterRequest}
create-cluster-request
  [m2539]
  (clojure.core/let
   [bean2538
    (new com.amazonaws.services.redshift.model.CreateClusterRequest)]
   (clojure.core/let
    [v2540
     (:vpc-security-group-ids
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (.
      bean2538
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2688] (clojure.core/str arg2688))
 v2540))))
   (clojure.core/let
    [v2540
     (:cluster-version
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (. bean2538 setClusterVersion (clojure.core/str v2540))))
   (clojure.core/let
    [v2540
     (:cluster-identifier
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (. bean2538 setClusterIdentifier (clojure.core/str v2540))))
   (clojure.core/let
    [v2540
     (:encrypted m2539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (. bean2538 setEncrypted (clojure.core/boolean v2540))))
   (clojure.core/let
    [v2540 (:port m2539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (. bean2538 setPort (clojure.core/int v2540))))
   (clojure.core/let
    [v2540
     (:preferred-maintenance-window
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (.
      bean2538
      setPreferredMaintenanceWindow
      (clojure.core/str v2540))))
   (clojure.core/let
    [v2540
     (:availability-zone
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (. bean2538 setAvailabilityZone (clojure.core/str v2540))))
   (clojure.core/let
    [v2540
     (:master-user-password
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (. bean2538 setMasterUserPassword (clojure.core/str v2540))))
   (clojure.core/let
    [v2540
     (:allow-version-upgrade
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (. bean2538 setAllowVersionUpgrade (clojure.core/boolean v2540))))
   (clojure.core/let
    [v2540 (:dbname m2539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (. bean2538 setDBName (clojure.core/str v2540))))
   (clojure.core/let
    [v2540
     (:cluster-security-groups
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (.
      bean2538
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2689] (clojure.core/str arg2689))
 v2540))))
   (clojure.core/let
    [v2540
     (:automated-snapshot-retention-period
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (.
      bean2538
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v2540))))
   (clojure.core/let
    [v2540
     (:publicly-accessible
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (. bean2538 setPubliclyAccessible (clojure.core/boolean v2540))))
   (clojure.core/let
    [v2540
     (:number-of-nodes
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (. bean2538 setNumberOfNodes (clojure.core/int v2540))))
   (clojure.core/let
    [v2540
     (:cluster-type m2539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (. bean2538 setClusterType (clojure.core/str v2540))))
   (clojure.core/let
    [v2540
     (:cluster-subnet-group-name
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (. bean2538 setClusterSubnetGroupName (clojure.core/str v2540))))
   (clojure.core/let
    [v2540
     (:hsm-client-certificate-identifier
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (.
      bean2538
      setHsmClientCertificateIdentifier
      (clojure.core/str v2540))))
   (clojure.core/let
    [v2540
     (:cluster-parameter-group-name
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (.
      bean2538
      setClusterParameterGroupName
      (clojure.core/str v2540))))
   (clojure.core/let
    [v2540
     (:elastic-ip m2539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (. bean2538 setElasticIp (clojure.core/str v2540))))
   (clojure.core/let
    [v2540
     (:master-username
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (. bean2538 setMasterUsername (clojure.core/str v2540))))
   (clojure.core/let
    [v2540
     (:node-type m2539 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (. bean2538 setNodeType (clojure.core/str v2540))))
   (clojure.core/let
    [v2540
     (:hsm-configuration-identifier
      m2539
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2540 :com.palletops.awaze.client-builder/undef)
     (.
      bean2538
      setHsmConfigurationIdentifier
      (clojure.core/str v2540))))
   bean2538))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest}
authorize-snapshot-access-request
  [m2542]
  (clojure.core/let
   [bean2541
    (new
     com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest)]
   (clojure.core/let
    [v2543
     (:snapshot-identifier
      m2542
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2543 :com.palletops.awaze.client-builder/undef)
     (. bean2541 setSnapshotIdentifier (clojure.core/str v2543))))
   (clojure.core/let
    [v2543
     (:snapshot-cluster-identifier
      m2542
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2543 :com.palletops.awaze.client-builder/undef)
     (.
      bean2541
      setSnapshotClusterIdentifier
      (clojure.core/str v2543))))
   (clojure.core/let
    [v2543
     (:account-with-restore-access
      m2542
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2543 :com.palletops.awaze.client-builder/undef)
     (. bean2541 setAccountWithRestoreAccess (clojure.core/str v2543))))
   bean2541))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest}
describe-cluster-subnet-groups-request
  [m2545]
  (clojure.core/let
   [bean2544
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest)]
   (clojure.core/let
    [v2546 (:marker m2545 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2546 :com.palletops.awaze.client-builder/undef)
     (. bean2544 setMarker (clojure.core/str v2546))))
   (clojure.core/let
    [v2546
     (:cluster-subnet-group-name
      m2545
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2546 :com.palletops.awaze.client-builder/undef)
     (. bean2544 setClusterSubnetGroupName (clojure.core/str v2546))))
   (clojure.core/let
    [v2546
     (:max-records m2545 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2546 :com.palletops.awaze.client-builder/undef)
     (. bean2544 setMaxRecords (clojure.core/int v2546))))
   bean2544))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableLoggingRequest}
enable-logging-request
  [m2548]
  (clojure.core/let
   [bean2547
    (new com.amazonaws.services.redshift.model.EnableLoggingRequest)]
   (clojure.core/let
    [v2549
     (:cluster-identifier
      m2548
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2549 :com.palletops.awaze.client-builder/undef)
     (. bean2547 setClusterIdentifier (clojure.core/str v2549))))
   (clojure.core/let
    [v2549
     (:bucket-name m2548 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2549 :com.palletops.awaze.client-builder/undef)
     (. bean2547 setBucketName (clojure.core/str v2549))))
   (clojure.core/let
    [v2549
     (:s3key-prefix m2548 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2549 :com.palletops.awaze.client-builder/undef)
     (. bean2547 setS3KeyPrefix (clojure.core/str v2549))))
   bean2547))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClustersRequest}
describe-clusters-request
  [m2551]
  (clojure.core/let
   [bean2550
    (new
     com.amazonaws.services.redshift.model.DescribeClustersRequest)]
   (clojure.core/let
    [v2552 (:marker m2551 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2552 :com.palletops.awaze.client-builder/undef)
     (. bean2550 setMarker (clojure.core/str v2552))))
   (clojure.core/let
    [v2552
     (:cluster-identifier
      m2551
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2552 :com.palletops.awaze.client-builder/undef)
     (. bean2550 setClusterIdentifier (clojure.core/str v2552))))
   (clojure.core/let
    [v2552
     (:max-records m2551 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2552 :com.palletops.awaze.client-builder/undef)
     (. bean2550 setMaxRecords (clojure.core/int v2552))))
   bean2550))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest}
restore-from-cluster-snapshot-request
  [m2554]
  (clojure.core/let
   [bean2553
    (new
     com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest)]
   (clojure.core/let
    [v2555
     (:vpc-security-group-ids
      m2554
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (.
      bean2553
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2690] (clojure.core/str arg2690))
 v2555))))
   (clojure.core/let
    [v2555
     (:cluster-identifier
      m2554
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (. bean2553 setClusterIdentifier (clojure.core/str v2555))))
   (clojure.core/let
    [v2555 (:port m2554 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (. bean2553 setPort (clojure.core/int v2555))))
   (clojure.core/let
    [v2555
     (:preferred-maintenance-window
      m2554
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (.
      bean2553
      setPreferredMaintenanceWindow
      (clojure.core/str v2555))))
   (clojure.core/let
    [v2555
     (:availability-zone
      m2554
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (. bean2553 setAvailabilityZone (clojure.core/str v2555))))
   (clojure.core/let
    [v2555
     (:allow-version-upgrade
      m2554
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (. bean2553 setAllowVersionUpgrade (clojure.core/boolean v2555))))
   (clojure.core/let
    [v2555
     (:cluster-security-groups
      m2554
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (.
      bean2553
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2691] (clojure.core/str arg2691))
 v2555))))
   (clojure.core/let
    [v2555
     (:automated-snapshot-retention-period
      m2554
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (.
      bean2553
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v2555))))
   (clojure.core/let
    [v2555
     (:publicly-accessible
      m2554
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (. bean2553 setPubliclyAccessible (clojure.core/boolean v2555))))
   (clojure.core/let
    [v2555
     (:snapshot-identifier
      m2554
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (. bean2553 setSnapshotIdentifier (clojure.core/str v2555))))
   (clojure.core/let
    [v2555
     (:cluster-subnet-group-name
      m2554
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (. bean2553 setClusterSubnetGroupName (clojure.core/str v2555))))
   (clojure.core/let
    [v2555
     (:hsm-client-certificate-identifier
      m2554
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (.
      bean2553
      setHsmClientCertificateIdentifier
      (clojure.core/str v2555))))
   (clojure.core/let
    [v2555
     (:cluster-parameter-group-name
      m2554
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (.
      bean2553
      setClusterParameterGroupName
      (clojure.core/str v2555))))
   (clojure.core/let
    [v2555
     (:elastic-ip m2554 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (. bean2553 setElasticIp (clojure.core/str v2555))))
   (clojure.core/let
    [v2555
     (:owner-account m2554 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (. bean2553 setOwnerAccount (clojure.core/str v2555))))
   (clojure.core/let
    [v2555
     (:snapshot-cluster-identifier
      m2554
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (.
      bean2553
      setSnapshotClusterIdentifier
      (clojure.core/str v2555))))
   (clojure.core/let
    [v2555
     (:hsm-configuration-identifier
      m2554
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2555 :com.palletops.awaze.client-builder/undef)
     (.
      bean2553
      setHsmConfigurationIdentifier
      (clojure.core/str v2555))))
   bean2553))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest}
revoke-snapshot-access-request
  [m2557]
  (clojure.core/let
   [bean2556
    (new
     com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest)]
   (clojure.core/let
    [v2558
     (:snapshot-identifier
      m2557
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2558 :com.palletops.awaze.client-builder/undef)
     (. bean2556 setSnapshotIdentifier (clojure.core/str v2558))))
   (clojure.core/let
    [v2558
     (:snapshot-cluster-identifier
      m2557
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2558 :com.palletops.awaze.client-builder/undef)
     (.
      bean2556
      setSnapshotClusterIdentifier
      (clojure.core/str v2558))))
   (clojure.core/let
    [v2558
     (:account-with-restore-access
      m2557
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2558 :com.palletops.awaze.client-builder/undef)
     (. bean2556 setAccountWithRestoreAccess (clojure.core/str v2558))))
   bean2556))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest}
rotate-encryption-key-request
  [m2560]
  (clojure.core/let
   [bean2559
    (new
     com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest)]
   (clojure.core/let
    [v2561
     (:cluster-identifier
      m2560
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2561 :com.palletops.awaze.client-builder/undef)
     (. bean2559 setClusterIdentifier (clojure.core/str v2561))))
   bean2559))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableLoggingRequest}
disable-logging-request
  [m2563]
  (clojure.core/let
   [bean2562
    (new com.amazonaws.services.redshift.model.DisableLoggingRequest)]
   (clojure.core/let
    [v2564
     (:cluster-identifier
      m2563
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2564 :com.palletops.awaze.client-builder/undef)
     (. bean2562 setClusterIdentifier (clojure.core/str v2564))))
   bean2562))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest}
delete-cluster-security-group-request
  [m2566]
  (clojure.core/let
   [bean2565
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest)]
   (clojure.core/let
    [v2567
     (:cluster-security-group-name
      m2566
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2567 :com.palletops.awaze.client-builder/undef)
     (. bean2565 setClusterSecurityGroupName (clojure.core/str v2567))))
   bean2565))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParametersRequest}
describe-cluster-parameters-request
  [m2569]
  (clojure.core/let
   [bean2568
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParametersRequest)]
   (clojure.core/let
    [v2570 (:source m2569 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2570 :com.palletops.awaze.client-builder/undef)
     (. bean2568 setSource (clojure.core/str v2570))))
   (clojure.core/let
    [v2570 (:marker m2569 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2570 :com.palletops.awaze.client-builder/undef)
     (. bean2568 setMarker (clojure.core/str v2570))))
   (clojure.core/let
    [v2570
     (:max-records m2569 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2570 :com.palletops.awaze.client-builder/undef)
     (. bean2568 setMaxRecords (clojure.core/int v2570))))
   (clojure.core/let
    [v2570
     (:parameter-group-name
      m2569
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2570 :com.palletops.awaze.client-builder/undef)
     (. bean2568 setParameterGroupName (clojure.core/str v2570))))
   bean2568))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest}
create-event-subscription-request
  [m2572]
  (clojure.core/let
   [bean2571
    (new
     com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest)]
   (clojure.core/let
    [v2573 (:enabled m2572 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2573 :com.palletops.awaze.client-builder/undef)
     (. bean2571 setEnabled (clojure.core/boolean v2573))))
   (clojure.core/let
    [v2573
     (:source-type m2572 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2573 :com.palletops.awaze.client-builder/undef)
     (. bean2571 setSourceType (clojure.core/str v2573))))
   (clojure.core/let
    [v2573
     (:subscription-name
      m2572
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2573 :com.palletops.awaze.client-builder/undef)
     (. bean2571 setSubscriptionName (clojure.core/str v2573))))
   (clojure.core/let
    [v2573
     (:sns-topic-arn m2572 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2573 :com.palletops.awaze.client-builder/undef)
     (. bean2571 setSnsTopicArn (clojure.core/str v2573))))
   (clojure.core/let
    [v2573
     (:source-ids m2572 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2573 :com.palletops.awaze.client-builder/undef)
     (.
      bean2571
      setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2692] (clojure.core/str arg2692))
 v2573))))
   (clojure.core/let
    [v2573
     (:event-categories
      m2572
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2573 :com.palletops.awaze.client-builder/undef)
     (.
      bean2571
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2693] (clojure.core/str arg2693))
 v2573))))
   (clojure.core/let
    [v2573
     (:severity m2572 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2573 :com.palletops.awaze.client-builder/undef)
     (. bean2571 setSeverity (clojure.core/str v2573))))
   bean2571))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest}
reset-cluster-parameter-group-request
  [m2575]
  (clojure.core/let
   [bean2574
    (new
     com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest)]
   (clojure.core/let
    [v2576
     (:parameters m2575 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2576 :com.palletops.awaze.client-builder/undef)
     (.
      bean2574
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2694] (redshift/parameter arg2694))
 v2576))))
   (clojure.core/let
    [v2576
     (:parameter-group-name
      m2575
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2576 :com.palletops.awaze.client-builder/undef)
     (. bean2574 setParameterGroupName (clojure.core/str v2576))))
   (clojure.core/let
    [v2576
     (:reset-all-parameters
      m2575
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2576 :com.palletops.awaze.client-builder/undef)
     (. bean2574 setResetAllParameters (clojure.core/boolean v2576))))
   bean2574))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest}
create-cluster-parameter-group-request
  [m2578]
  (clojure.core/let
   [bean2577
    (new
     com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest)]
   (clojure.core/let
    [v2579
     (:description m2578 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2579 :com.palletops.awaze.client-builder/undef)
     (. bean2577 setDescription (clojure.core/str v2579))))
   (clojure.core/let
    [v2579
     (:parameter-group-family
      m2578
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2579 :com.palletops.awaze.client-builder/undef)
     (. bean2577 setParameterGroupFamily (clojure.core/str v2579))))
   (clojure.core/let
    [v2579
     (:parameter-group-name
      m2578
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2579 :com.palletops.awaze.client-builder/undef)
     (. bean2577 setParameterGroupName (clojure.core/str v2579))))
   bean2577))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest}
delete-hsm-configuration-request
  [m2581]
  (clojure.core/let
   [bean2580
    (new
     com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest)]
   (clojure.core/let
    [v2582
     (:hsm-configuration-identifier
      m2581
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2582 :com.palletops.awaze.client-builder/undef)
     (.
      bean2580
      setHsmConfigurationIdentifier
      (clojure.core/str v2582))))
   bean2580))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest}
modify-event-subscription-request
  [m2584]
  (clojure.core/let
   [bean2583
    (new
     com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest)]
   (clojure.core/let
    [v2585 (:enabled m2584 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2585 :com.palletops.awaze.client-builder/undef)
     (. bean2583 setEnabled (clojure.core/boolean v2585))))
   (clojure.core/let
    [v2585
     (:source-type m2584 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2585 :com.palletops.awaze.client-builder/undef)
     (. bean2583 setSourceType (clojure.core/str v2585))))
   (clojure.core/let
    [v2585
     (:subscription-name
      m2584
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2585 :com.palletops.awaze.client-builder/undef)
     (. bean2583 setSubscriptionName (clojure.core/str v2585))))
   (clojure.core/let
    [v2585
     (:sns-topic-arn m2584 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2585 :com.palletops.awaze.client-builder/undef)
     (. bean2583 setSnsTopicArn (clojure.core/str v2585))))
   (clojure.core/let
    [v2585
     (:source-ids m2584 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2585 :com.palletops.awaze.client-builder/undef)
     (.
      bean2583
      setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2695] (clojure.core/str arg2695))
 v2585))))
   (clojure.core/let
    [v2585
     (:event-categories
      m2584
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2585 :com.palletops.awaze.client-builder/undef)
     (.
      bean2583
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2696] (clojure.core/str arg2696))
 v2585))))
   (clojure.core/let
    [v2585
     (:severity m2584 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2585 :com.palletops.awaze.client-builder/undef)
     (. bean2583 setSeverity (clojure.core/str v2585))))
   bean2583))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodesRequest}
describe-reserved-nodes-request
  [m2587]
  (clojure.core/let
   [bean2586
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodesRequest)]
   (clojure.core/let
    [v2588 (:marker m2587 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2588 :com.palletops.awaze.client-builder/undef)
     (. bean2586 setMarker (clojure.core/str v2588))))
   (clojure.core/let
    [v2588
     (:max-records m2587 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2588 :com.palletops.awaze.client-builder/undef)
     (. bean2586 setMaxRecords (clojure.core/int v2588))))
   (clojure.core/let
    [v2588
     (:reserved-node-id
      m2587
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2588 :com.palletops.awaze.client-builder/undef)
     (. bean2586 setReservedNodeId (clojure.core/str v2588))))
   bean2586))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest}
copy-cluster-snapshot-request
  [m2590]
  (clojure.core/let
   [bean2589
    (new
     com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest)]
   (clojure.core/let
    [v2591
     (:source-snapshot-identifier
      m2590
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2591 :com.palletops.awaze.client-builder/undef)
     (. bean2589 setSourceSnapshotIdentifier (clojure.core/str v2591))))
   (clojure.core/let
    [v2591
     (:source-snapshot-cluster-identifier
      m2590
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2591 :com.palletops.awaze.client-builder/undef)
     (.
      bean2589
      setSourceSnapshotClusterIdentifier
      (clojure.core/str v2591))))
   (clojure.core/let
    [v2591
     (:target-snapshot-identifier
      m2590
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2591 :com.palletops.awaze.client-builder/undef)
     (. bean2589 setTargetSnapshotIdentifier (clojure.core/str v2591))))
   bean2589))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest}
delete-hsm-client-certificate-request
  [m2593]
  (clojure.core/let
   [bean2592
    (new
     com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest)]
   (clojure.core/let
    [v2594
     (:hsm-client-certificate-identifier
      m2593
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2594 :com.palletops.awaze.client-builder/undef)
     (.
      bean2592
      setHsmClientCertificateIdentifier
      (clojure.core/str v2594))))
   bean2592))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest}
modify-cluster-subnet-group-request
  [m2596]
  (clojure.core/let
   [bean2595
    (new
     com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest)]
   (clojure.core/let
    [v2597
     (:description m2596 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2597 :com.palletops.awaze.client-builder/undef)
     (. bean2595 setDescription (clojure.core/str v2597))))
   (clojure.core/let
    [v2597
     (:cluster-subnet-group-name
      m2596
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2597 :com.palletops.awaze.client-builder/undef)
     (. bean2595 setClusterSubnetGroupName (clojure.core/str v2597))))
   (clojure.core/let
    [v2597
     (:subnet-ids m2596 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2597 :com.palletops.awaze.client-builder/undef)
     (.
      bean2595
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2697] (clojure.core/str arg2697))
 v2597))))
   bean2595))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest}
describe-logging-status-request
  [m2599]
  (clojure.core/let
   [bean2598
    (new
     com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest)]
   (clojure.core/let
    [v2600
     (:cluster-identifier
      m2599
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2600 :com.palletops.awaze.client-builder/undef)
     (. bean2598 setClusterIdentifier (clojure.core/str v2600))))
   bean2598))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventsRequest}
describe-events-request
  [m2602]
  (clojure.core/let
   [bean2601
    (new com.amazonaws.services.redshift.model.DescribeEventsRequest)]
   (clojure.core/let
    [v2603 (:marker m2602 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2603 :com.palletops.awaze.client-builder/undef)
     (. bean2601 setMarker (clojure.core/str v2603))))
   (clojure.core/let
    [v2603
     (:max-records m2602 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2603 :com.palletops.awaze.client-builder/undef)
     (. bean2601 setMaxRecords (clojure.core/int v2603))))
   (clojure.core/let
    [v2603
     (:source-identifier
      m2602
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2603 :com.palletops.awaze.client-builder/undef)
     (. bean2601 setSourceIdentifier (clojure.core/str v2603))))
   (clojure.core/let
    [v2603
     (:source-type m2602 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2603 :com.palletops.awaze.client-builder/undef)
     (. bean2601 setSourceType (clojure.core/str v2603))))
   (clojure.core/let
    [v2603
     (:start-time m2602 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2603 :com.palletops.awaze.client-builder/undef)
     (.
      bean2601
      setStartTime
      (com.palletops.awaze.common/to-date v2603))))
   (clojure.core/let
    [v2603
     (:end-time m2602 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2603 :com.palletops.awaze.client-builder/undef)
     (.
      bean2601
      setEndTime
      (com.palletops.awaze.common/to-date v2603))))
   (clojure.core/let
    [v2603
     (:duration m2602 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2603 :com.palletops.awaze.client-builder/undef)
     (. bean2601 setDuration (clojure.core/int v2603))))
   bean2601))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest}
delete-cluster-parameter-group-request
  [m2605]
  (clojure.core/let
   [bean2604
    (new
     com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest)]
   (clojure.core/let
    [v2606
     (:parameter-group-name
      m2605
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2606 :com.palletops.awaze.client-builder/undef)
     (. bean2604 setParameterGroupName (clojure.core/str v2606))))
   bean2604))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest}
authorize-cluster-security-group-ingress-request
  [m2608]
  (clojure.core/let
   [bean2607
    (new
     com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest)]
   (clojure.core/let
    [v2609
     (:cluster-security-group-name
      m2608
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2609 :com.palletops.awaze.client-builder/undef)
     (. bean2607 setClusterSecurityGroupName (clojure.core/str v2609))))
   (clojure.core/let
    [v2609 (:cidrip m2608 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2609 :com.palletops.awaze.client-builder/undef)
     (. bean2607 setCIDRIP (clojure.core/str v2609))))
   (clojure.core/let
    [v2609
     (:ec2security-group-name
      m2608
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2609 :com.palletops.awaze.client-builder/undef)
     (. bean2607 setEC2SecurityGroupName (clojure.core/str v2609))))
   (clojure.core/let
    [v2609
     (:ec2security-group-owner-id
      m2608
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2609 :com.palletops.awaze.client-builder/undef)
     (. bean2607 setEC2SecurityGroupOwnerId (clojure.core/str v2609))))
   bean2607))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterRequest}
modify-cluster-request
  [m2611]
  (clojure.core/let
   [bean2610
    (new com.amazonaws.services.redshift.model.ModifyClusterRequest)]
   (clojure.core/let
    [v2612
     (:vpc-security-group-ids
      m2611
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2612 :com.palletops.awaze.client-builder/undef)
     (.
      bean2610
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2698] (clojure.core/str arg2698))
 v2612))))
   (clojure.core/let
    [v2612
     (:cluster-version
      m2611
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2612 :com.palletops.awaze.client-builder/undef)
     (. bean2610 setClusterVersion (clojure.core/str v2612))))
   (clojure.core/let
    [v2612
     (:cluster-identifier
      m2611
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2612 :com.palletops.awaze.client-builder/undef)
     (. bean2610 setClusterIdentifier (clojure.core/str v2612))))
   (clojure.core/let
    [v2612
     (:preferred-maintenance-window
      m2611
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2612 :com.palletops.awaze.client-builder/undef)
     (.
      bean2610
      setPreferredMaintenanceWindow
      (clojure.core/str v2612))))
   (clojure.core/let
    [v2612
     (:new-cluster-identifier
      m2611
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2612 :com.palletops.awaze.client-builder/undef)
     (. bean2610 setNewClusterIdentifier (clojure.core/str v2612))))
   (clojure.core/let
    [v2612
     (:master-user-password
      m2611
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2612 :com.palletops.awaze.client-builder/undef)
     (. bean2610 setMasterUserPassword (clojure.core/str v2612))))
   (clojure.core/let
    [v2612
     (:allow-version-upgrade
      m2611
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2612 :com.palletops.awaze.client-builder/undef)
     (. bean2610 setAllowVersionUpgrade (clojure.core/boolean v2612))))
   (clojure.core/let
    [v2612
     (:cluster-security-groups
      m2611
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2612 :com.palletops.awaze.client-builder/undef)
     (.
      bean2610
      setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2699] (clojure.core/str arg2699))
 v2612))))
   (clojure.core/let
    [v2612
     (:automated-snapshot-retention-period
      m2611
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2612 :com.palletops.awaze.client-builder/undef)
     (.
      bean2610
      setAutomatedSnapshotRetentionPeriod
      (clojure.core/int v2612))))
   (clojure.core/let
    [v2612
     (:number-of-nodes
      m2611
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2612 :com.palletops.awaze.client-builder/undef)
     (. bean2610 setNumberOfNodes (clojure.core/int v2612))))
   (clojure.core/let
    [v2612
     (:cluster-type m2611 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2612 :com.palletops.awaze.client-builder/undef)
     (. bean2610 setClusterType (clojure.core/str v2612))))
   (clojure.core/let
    [v2612
     (:hsm-client-certificate-identifier
      m2611
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2612 :com.palletops.awaze.client-builder/undef)
     (.
      bean2610
      setHsmClientCertificateIdentifier
      (clojure.core/str v2612))))
   (clojure.core/let
    [v2612
     (:cluster-parameter-group-name
      m2611
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2612 :com.palletops.awaze.client-builder/undef)
     (.
      bean2610
      setClusterParameterGroupName
      (clojure.core/str v2612))))
   (clojure.core/let
    [v2612
     (:node-type m2611 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2612 :com.palletops.awaze.client-builder/undef)
     (. bean2610 setNodeType (clojure.core/str v2612))))
   (clojure.core/let
    [v2612
     (:hsm-configuration-identifier
      m2611
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2612 :com.palletops.awaze.client-builder/undef)
     (.
      bean2610
      setHsmConfigurationIdentifier
      (clojure.core/str v2612))))
   bean2610))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest}
delete-cluster-subnet-group-request
  [m2614]
  (clojure.core/let
   [bean2613
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest)]
   (clojure.core/let
    [v2615
     (:cluster-subnet-group-name
      m2614
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2615 :com.palletops.awaze.client-builder/undef)
     (. bean2613 setClusterSubnetGroupName (clojure.core/str v2615))))
   bean2613))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest}
create-cluster-subnet-group-request
  [m2617]
  (clojure.core/let
   [bean2616
    (new
     com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest)]
   (clojure.core/let
    [v2618
     (:description m2617 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2618 :com.palletops.awaze.client-builder/undef)
     (. bean2616 setDescription (clojure.core/str v2618))))
   (clojure.core/let
    [v2618
     (:cluster-subnet-group-name
      m2617
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2618 :com.palletops.awaze.client-builder/undef)
     (. bean2616 setClusterSubnetGroupName (clojure.core/str v2618))))
   (clojure.core/let
    [v2618
     (:subnet-ids m2617 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2618 :com.palletops.awaze.client-builder/undef)
     (.
      bean2616
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2700] (clojure.core/str arg2700))
 v2618))))
   bean2616))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest}
purchase-reserved-node-offering-request
  [m2620]
  (clojure.core/let
   [bean2619
    (new
     com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest)]
   (clojure.core/let
    [v2621
     (:reserved-node-offering-id
      m2620
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2621 :com.palletops.awaze.client-builder/undef)
     (. bean2619 setReservedNodeOfferingId (clojure.core/str v2621))))
   (clojure.core/let
    [v2621
     (:node-count m2620 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2621 :com.palletops.awaze.client-builder/undef)
     (. bean2619 setNodeCount (clojure.core/int v2621))))
   bean2619))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest}
describe-reserved-node-offerings-request
  [m2623]
  (clojure.core/let
   [bean2622
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest)]
   (clojure.core/let
    [v2624 (:marker m2623 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2624 :com.palletops.awaze.client-builder/undef)
     (. bean2622 setMarker (clojure.core/str v2624))))
   (clojure.core/let
    [v2624
     (:reserved-node-offering-id
      m2623
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2624 :com.palletops.awaze.client-builder/undef)
     (. bean2622 setReservedNodeOfferingId (clojure.core/str v2624))))
   (clojure.core/let
    [v2624
     (:max-records m2623 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2624 :com.palletops.awaze.client-builder/undef)
     (. bean2622 setMaxRecords (clojure.core/int v2624))))
   bean2622))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterRequest}
delete-cluster-request
  [m2626]
  (clojure.core/let
   [bean2625
    (new com.amazonaws.services.redshift.model.DeleteClusterRequest)]
   (clojure.core/let
    [v2627
     (:cluster-identifier
      m2626
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2627 :com.palletops.awaze.client-builder/undef)
     (. bean2625 setClusterIdentifier (clojure.core/str v2627))))
   (clojure.core/let
    [v2627
     (:skip-final-cluster-snapshot
      m2626
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2627 :com.palletops.awaze.client-builder/undef)
     (.
      bean2625
      setSkipFinalClusterSnapshot
      (clojure.core/boolean v2627))))
   (clojure.core/let
    [v2627
     (:final-cluster-snapshot-identifier
      m2626
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2627 :com.palletops.awaze.client-builder/undef)
     (.
      bean2625
      setFinalClusterSnapshotIdentifier
      (clojure.core/str v2627))))
   bean2625))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest}
create-cluster-security-group-request
  [m2629]
  (clojure.core/let
   [bean2628
    (new
     com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest)]
   (clojure.core/let
    [v2630
     (:description m2629 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2630 :com.palletops.awaze.client-builder/undef)
     (. bean2628 setDescription (clojure.core/str v2630))))
   (clojure.core/let
    [v2630
     (:cluster-security-group-name
      m2629
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2630 :com.palletops.awaze.client-builder/undef)
     (. bean2628 setClusterSecurityGroupName (clojure.core/str v2630))))
   bean2628))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest}
describe-event-subscriptions-request
  [m2632]
  (clojure.core/let
   [bean2631
    (new
     com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest)]
   (clojure.core/let
    [v2633 (:marker m2632 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2633 :com.palletops.awaze.client-builder/undef)
     (. bean2631 setMarker (clojure.core/str v2633))))
   (clojure.core/let
    [v2633
     (:max-records m2632 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2633 :com.palletops.awaze.client-builder/undef)
     (. bean2631 setMaxRecords (clojure.core/int v2633))))
   (clojure.core/let
    [v2633
     (:subscription-name
      m2632
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2633 :com.palletops.awaze.client-builder/undef)
     (. bean2631 setSubscriptionName (clojure.core/str v2633))))
   bean2631))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest}
describe-default-cluster-parameters-request
  [m2635]
  (clojure.core/let
   [bean2634
    (new
     com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest)]
   (clojure.core/let
    [v2636 (:marker m2635 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2636 :com.palletops.awaze.client-builder/undef)
     (. bean2634 setMarker (clojure.core/str v2636))))
   (clojure.core/let
    [v2636
     (:max-records m2635 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2636 :com.palletops.awaze.client-builder/undef)
     (. bean2634 setMaxRecords (clojure.core/int v2636))))
   (clojure.core/let
    [v2636
     (:parameter-group-family
      m2635
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2636 :com.palletops.awaze.client-builder/undef)
     (. bean2634 setParameterGroupFamily (clojure.core/str v2636))))
   bean2634))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest}
describe-hsm-configurations-request
  [m2638]
  (clojure.core/let
   [bean2637
    (new
     com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest)]
   (clojure.core/let
    [v2639 (:marker m2638 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2639 :com.palletops.awaze.client-builder/undef)
     (. bean2637 setMarker (clojure.core/str v2639))))
   (clojure.core/let
    [v2639
     (:hsm-configuration-identifier
      m2638
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2639 :com.palletops.awaze.client-builder/undef)
     (.
      bean2637
      setHsmConfigurationIdentifier
      (clojure.core/str v2639))))
   (clojure.core/let
    [v2639
     (:max-records m2638 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2639 :com.palletops.awaze.client-builder/undef)
     (. bean2637 setMaxRecords (clojure.core/int v2639))))
   bean2637))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest}
create-cluster-snapshot-request
  [m2641]
  (clojure.core/let
   [bean2640
    (new
     com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest)]
   (clojure.core/let
    [v2642
     (:snapshot-identifier
      m2641
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2642 :com.palletops.awaze.client-builder/undef)
     (. bean2640 setSnapshotIdentifier (clojure.core/str v2642))))
   (clojure.core/let
    [v2642
     (:cluster-identifier
      m2641
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2642 :com.palletops.awaze.client-builder/undef)
     (. bean2640 setClusterIdentifier (clojure.core/str v2642))))
   bean2640))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest}
describe-cluster-versions-request
  [m2644]
  (clojure.core/let
   [bean2643
    (new
     com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest)]
   (clojure.core/let
    [v2645 (:marker m2644 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2645 :com.palletops.awaze.client-builder/undef)
     (. bean2643 setMarker (clojure.core/str v2645))))
   (clojure.core/let
    [v2645
     (:cluster-version
      m2644
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2645 :com.palletops.awaze.client-builder/undef)
     (. bean2643 setClusterVersion (clojure.core/str v2645))))
   (clojure.core/let
    [v2645
     (:max-records m2644 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2645 :com.palletops.awaze.client-builder/undef)
     (. bean2643 setMaxRecords (clojure.core/int v2645))))
   (clojure.core/let
    [v2645
     (:cluster-parameter-group-family
      m2644
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2645 :com.palletops.awaze.client-builder/undef)
     (.
      bean2643
      setClusterParameterGroupFamily
      (clojure.core/str v2645))))
   bean2643))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest}
disable-snapshot-copy-request
  [m2647]
  (clojure.core/let
   [bean2646
    (new
     com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest)]
   (clojure.core/let
    [v2648
     (:cluster-identifier
      m2647
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2648 :com.palletops.awaze.client-builder/undef)
     (. bean2646 setClusterIdentifier (clojure.core/str v2648))))
   bean2646))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest}
delete-event-subscription-request
  [m2650]
  (clojure.core/let
   [bean2649
    (new
     com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest)]
   (clojure.core/let
    [v2651
     (:subscription-name
      m2650
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2651 :com.palletops.awaze.client-builder/undef)
     (. bean2649 setSubscriptionName (clojure.core/str v2651))))
   bean2649))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest}
modify-snapshot-copy-retention-period-request
  [m2653]
  (clojure.core/let
   [bean2652
    (new
     com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest)]
   (clojure.core/let
    [v2654
     (:cluster-identifier
      m2653
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2654 :com.palletops.awaze.client-builder/undef)
     (. bean2652 setClusterIdentifier (clojure.core/str v2654))))
   (clojure.core/let
    [v2654
     (:retention-period
      m2653
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2654 :com.palletops.awaze.client-builder/undef)
     (. bean2652 setRetentionPeriod (clojure.core/int v2654))))
   bean2652))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RebootClusterRequest}
reboot-cluster-request
  [m2656]
  (clojure.core/let
   [bean2655
    (new com.amazonaws.services.redshift.model.RebootClusterRequest)]
   (clojure.core/let
    [v2657
     (:cluster-identifier
      m2656
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2657 :com.palletops.awaze.client-builder/undef)
     (. bean2655 setClusterIdentifier (clojure.core/str v2657))))
   bean2655))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeResizeRequest}
describe-resize-request
  [m2659]
  (clojure.core/let
   [bean2658
    (new com.amazonaws.services.redshift.model.DescribeResizeRequest)]
   (clojure.core/let
    [v2660
     (:cluster-identifier
      m2659
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2660 :com.palletops.awaze.client-builder/undef)
     (. bean2658 setClusterIdentifier (clojure.core/str v2660))))
   bean2658))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest}
revoke-cluster-security-group-ingress-request
  [m2662]
  (clojure.core/let
   [bean2661
    (new
     com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest)]
   (clojure.core/let
    [v2663
     (:cluster-security-group-name
      m2662
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2663 :com.palletops.awaze.client-builder/undef)
     (. bean2661 setClusterSecurityGroupName (clojure.core/str v2663))))
   (clojure.core/let
    [v2663 (:cidrip m2662 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2663 :com.palletops.awaze.client-builder/undef)
     (. bean2661 setCIDRIP (clojure.core/str v2663))))
   (clojure.core/let
    [v2663
     (:ec2security-group-name
      m2662
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2663 :com.palletops.awaze.client-builder/undef)
     (. bean2661 setEC2SecurityGroupName (clojure.core/str v2663))))
   (clojure.core/let
    [v2663
     (:ec2security-group-owner-id
      m2662
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2663 :com.palletops.awaze.client-builder/undef)
     (. bean2661 setEC2SecurityGroupOwnerId (clojure.core/str v2663))))
   bean2661))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest}
modify-cluster-parameter-group-request
  [m2665]
  (clojure.core/let
   [bean2664
    (new
     com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest)]
   (clojure.core/let
    [v2666
     (:parameters m2665 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2666 :com.palletops.awaze.client-builder/undef)
     (.
      bean2664
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2701] (redshift/parameter arg2701))
 v2666))))
   (clojure.core/let
    [v2666
     (:parameter-group-name
      m2665
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2666 :com.palletops.awaze.client-builder/undef)
     (. bean2664 setParameterGroupName (clojure.core/str v2666))))
   bean2664))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest}
describe-hsm-client-certificates-request
  [m2668]
  (clojure.core/let
   [bean2667
    (new
     com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest)]
   (clojure.core/let
    [v2669 (:marker m2668 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2669 :com.palletops.awaze.client-builder/undef)
     (. bean2667 setMarker (clojure.core/str v2669))))
   (clojure.core/let
    [v2669
     (:hsm-client-certificate-identifier
      m2668
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2669 :com.palletops.awaze.client-builder/undef)
     (.
      bean2667
      setHsmClientCertificateIdentifier
      (clojure.core/str v2669))))
   (clojure.core/let
    [v2669
     (:max-records m2668 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2669 :com.palletops.awaze.client-builder/undef)
     (. bean2667 setMaxRecords (clojure.core/int v2669))))
   bean2667))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest}
create-hsm-client-certificate-request
  [m2671]
  (clojure.core/let
   [bean2670
    (new
     com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest)]
   (clojure.core/let
    [v2672
     (:hsm-client-certificate-identifier
      m2671
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2672 :com.palletops.awaze.client-builder/undef)
     (.
      bean2670
      setHsmClientCertificateIdentifier
      (clojure.core/str v2672))))
   bean2670))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest}
describe-event-categories-request
  [m2674]
  (clojure.core/let
   [bean2673
    (new
     com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest)]
   (clojure.core/let
    [v2675
     (:source-type m2674 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2675 :com.palletops.awaze.client-builder/undef)
     (. bean2673 setSourceType (clojure.core/str v2675))))
   bean2673))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest}
create-hsm-configuration-request
  [m2677]
  (clojure.core/let
   [bean2676
    (new
     com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest)]
   (clojure.core/let
    [v2678
     (:description m2677 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2678 :com.palletops.awaze.client-builder/undef)
     (. bean2676 setDescription (clojure.core/str v2678))))
   (clojure.core/let
    [v2678
     (:hsm-configuration-identifier
      m2677
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2678 :com.palletops.awaze.client-builder/undef)
     (.
      bean2676
      setHsmConfigurationIdentifier
      (clojure.core/str v2678))))
   (clojure.core/let
    [v2678
     (:hsm-ip-address m2677 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2678 :com.palletops.awaze.client-builder/undef)
     (. bean2676 setHsmIpAddress (clojure.core/str v2678))))
   (clojure.core/let
    [v2678
     (:hsm-partition-name
      m2677
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2678 :com.palletops.awaze.client-builder/undef)
     (. bean2676 setHsmPartitionName (clojure.core/str v2678))))
   (clojure.core/let
    [v2678
     (:hsm-partition-password
      m2677
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2678 :com.palletops.awaze.client-builder/undef)
     (. bean2676 setHsmPartitionPassword (clojure.core/str v2678))))
   (clojure.core/let
    [v2678
     (:hsm-server-public-certificate
      m2677
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2678 :com.palletops.awaze.client-builder/undef)
     (.
      bean2676
      setHsmServerPublicCertificate
      (clojure.core/str v2678))))
   bean2676))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest}
describe-cluster-snapshots-request
  [m2680]
  (clojure.core/let
   [bean2679
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest)]
   (clojure.core/let
    [v2681 (:marker m2680 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2681 :com.palletops.awaze.client-builder/undef)
     (. bean2679 setMarker (clojure.core/str v2681))))
   (clojure.core/let
    [v2681
     (:snapshot-identifier
      m2680
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2681 :com.palletops.awaze.client-builder/undef)
     (. bean2679 setSnapshotIdentifier (clojure.core/str v2681))))
   (clojure.core/let
    [v2681
     (:cluster-identifier
      m2680
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2681 :com.palletops.awaze.client-builder/undef)
     (. bean2679 setClusterIdentifier (clojure.core/str v2681))))
   (clojure.core/let
    [v2681
     (:max-records m2680 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2681 :com.palletops.awaze.client-builder/undef)
     (. bean2679 setMaxRecords (clojure.core/int v2681))))
   (clojure.core/let
    [v2681
     (:start-time m2680 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2681 :com.palletops.awaze.client-builder/undef)
     (.
      bean2679
      setStartTime
      (com.palletops.awaze.common/to-date v2681))))
   (clojure.core/let
    [v2681
     (:end-time m2680 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2681 :com.palletops.awaze.client-builder/undef)
     (.
      bean2679
      setEndTime
      (com.palletops.awaze.common/to-date v2681))))
   (clojure.core/let
    [v2681
     (:owner-account m2680 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2681 :com.palletops.awaze.client-builder/undef)
     (. bean2679 setOwnerAccount (clojure.core/str v2681))))
   (clojure.core/let
    [v2681
     (:snapshot-type m2680 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2681 :com.palletops.awaze.client-builder/undef)
     (. bean2679 setSnapshotType (clojure.core/str v2681))))
   bean2679))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest}
delete-cluster-snapshot-request
  [m2683]
  (clojure.core/let
   [bean2682
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest)]
   (clojure.core/let
    [v2684
     (:snapshot-identifier
      m2683
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2684 :com.palletops.awaze.client-builder/undef)
     (. bean2682 setSnapshotIdentifier (clojure.core/str v2684))))
   (clojure.core/let
    [v2684
     (:snapshot-cluster-identifier
      m2683
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2684 :com.palletops.awaze.client-builder/undef)
     (.
      bean2682
      setSnapshotClusterIdentifier
      (clojure.core/str v2684))))
   bean2682))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest}
describe-orderable-cluster-options-request
  [m2686]
  (clojure.core/let
   [bean2685
    (new
     com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest)]
   (clojure.core/let
    [v2687 (:marker m2686 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2687 :com.palletops.awaze.client-builder/undef)
     (. bean2685 setMarker (clojure.core/str v2687))))
   (clojure.core/let
    [v2687
     (:node-type m2686 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2687 :com.palletops.awaze.client-builder/undef)
     (. bean2685 setNodeType (clojure.core/str v2687))))
   (clojure.core/let
    [v2687
     (:cluster-version
      m2686
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2687 :com.palletops.awaze.client-builder/undef)
     (. bean2685 setClusterVersion (clojure.core/str v2687))))
   (clojure.core/let
    [v2687
     (:max-records m2686 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2687 :com.palletops.awaze.client-builder/undef)
     (. bean2685 setMaxRecords (clojure.core/int v2687))))
   bean2685))
 (clojure.core/defmulti
  redshift
  (clojure.core/fn redshift [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-security-groups
   [m2702]
   (clojure.core/let
    [credentials2703 (:credentials m2702) args2704 (:args m2702)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2705
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2703)]
     (clojure.core/case
      (clojure.core/count args2704)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2705
        describeClusterSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2705
        describeClusterSecurityGroups
        (redshift/describe-cluster-security-groups-request
         (clojure.core/nth args2704 0))))))))
  (clojure.core/defn
   describe-cluster-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-security-group-name]}]]),
    :doc "Generate map for describeClusterSecurityGroups, describeClusterSecurityGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-security-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-security-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cluster-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-security-group-name]}]]),
    :doc "Call describeClusterSecurityGroups, describeClusterSecurityGroups"}
   [credentials2707 & args2708]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2709
     (com.palletops.awaze.common/aws-client :redshift credentials2707)]
    (clojure.core/case
     (clojure.core/count args2708)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2709
       describeClusterSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2709
       describeClusterSecurityGroups
       (redshift/describe-cluster-security-groups-request
        (clojure.core/nth args2708 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameter-groups
   [m2710]
   (clojure.core/let
    [credentials2711 (:credentials m2710) args2712 (:args m2710)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2713
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2711)]
     (clojure.core/case
      (clojure.core/count args2712)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2713
        describeClusterParameterGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2713
        describeClusterParameterGroups
        (redshift/describe-cluster-parameter-groups-request
         (clojure.core/nth args2712 0))))))))
  (clojure.core/defn
   describe-cluster-parameter-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [parameter-group-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeClusterParameterGroups, describeClusterParameterGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cluster-parameter-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [parameter-group-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeClusterParameterGroups, describeClusterParameterGroups"}
   [credentials2715 & args2716]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2717
     (com.palletops.awaze.common/aws-client :redshift credentials2715)]
    (clojure.core/case
     (clojure.core/count args2716)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2717
       describeClusterParameterGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2717
       describeClusterParameterGroups
       (redshift/describe-cluster-parameter-groups-request
        (clojure.core/nth args2716 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-snapshot-copy
   [m2718]
   (clojure.core/let
    [credentials2719 (:credentials m2718) args2720 (:args m2718)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2721
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2719)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2721
       enableSnapshotCopy
       (redshift/enable-snapshot-copy-request
        (clojure.core/nth args2720 0)))))))
  (clojure.core/defn
   enable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [retention-period
                         general-progress-listener
                         destination-region
                         cluster-identifier]}]]),
    :doc "Generate map for enableSnapshotCopy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :enable-snapshot-copy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [retention-period
                         general-progress-listener
                         destination-region
                         cluster-identifier]}]]),
    :doc "Call enableSnapshotCopy"}
   [credentials2723 & args2724]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2725
     (com.palletops.awaze.common/aws-client :redshift credentials2723)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2725
      enableSnapshotCopy
      (redshift/enable-snapshot-copy-request
       (clojure.core/nth args2724 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster
   [m2726]
   (clojure.core/let
    [credentials2727 (:credentials m2726) args2728 (:args m2726)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2729
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2727)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2729
       createCluster
       (redshift/create-cluster-request (clojure.core/nth args2728 0)))))))
  (clojure.core/defn
   create-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         hsm-client-certificate-identifier
                         cluster-type
                         publicly-accessible
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         encrypted
                         availability-zone
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         master-username
                         dbname
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         port
                         elastic-ip
                         cluster-version
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Generate map for createCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cluster
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         hsm-client-certificate-identifier
                         cluster-type
                         publicly-accessible
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         encrypted
                         availability-zone
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         master-username
                         dbname
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         port
                         elastic-ip
                         cluster-version
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Call createCluster"}
   [credentials2731 & args2732]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2733
     (com.palletops.awaze.common/aws-client :redshift credentials2731)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2733
      createCluster
      (redshift/create-cluster-request (clojure.core/nth args2732 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-snapshot-access
   [m2734]
   (clojure.core/let
    [credentials2735 (:credentials m2734) args2736 (:args m2734)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2737
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2735)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2737
       authorizeSnapshotAccess
       (redshift/authorize-snapshot-access-request
        (clojure.core/nth args2736 0)))))))
  (clojure.core/defn
   authorize-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener
                         account-with-restore-access]}]]),
    :doc "Generate map for authorizeSnapshotAccess"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :authorize-snapshot-access,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   authorize-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener
                         account-with-restore-access]}]]),
    :doc "Call authorizeSnapshotAccess"}
   [credentials2739 & args2740]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2741
     (com.palletops.awaze.common/aws-client :redshift credentials2739)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2741
      authorizeSnapshotAccess
      (redshift/authorize-snapshot-access-request
       (clojure.core/nth args2740 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-subnet-groups
   [m2742]
   (clojure.core/let
    [credentials2743 (:credentials m2742) args2744 (:args m2742)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2745
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2743)]
     (clojure.core/case
      (clojure.core/count args2744)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2745
        describeClusterSubnetGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2745
        describeClusterSubnetGroups
        (redshift/describe-cluster-subnet-groups-request
         (clojure.core/nth args2744 0))))))))
  (clojure.core/defn
   describe-cluster-subnet-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-subnet-group-name]}]]),
    :doc "Generate map for describeClusterSubnetGroups, describeClusterSubnetGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cluster-subnet-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-subnet-group-name]}]]),
    :doc "Call describeClusterSubnetGroups, describeClusterSubnetGroups"}
   [credentials2747 & args2748]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2749
     (com.palletops.awaze.common/aws-client :redshift credentials2747)]
    (clojure.core/case
     (clojure.core/count args2748)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2749
       describeClusterSubnetGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2749
       describeClusterSubnetGroups
       (redshift/describe-cluster-subnet-groups-request
        (clojure.core/nth args2748 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-logging
   [m2750]
   (clojure.core/let
    [credentials2751 (:credentials m2750) args2752 (:args m2750)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2753
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2751)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2753
       enableLogging
       (redshift/enable-logging-request (clojure.core/nth args2752 0)))))))
  (clojure.core/defn
   enable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         general-progress-listener
                         cluster-identifier
                         bucket-name]}]]),
    :doc "Generate map for enableLogging"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :enable-logging,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-logging
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         general-progress-listener
                         cluster-identifier
                         bucket-name]}]]),
    :doc "Call enableLogging"}
   [credentials2755 & args2756]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2757
     (com.palletops.awaze.common/aws-client :redshift credentials2755)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2757
      enableLogging
      (redshift/enable-logging-request (clojure.core/nth args2756 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-clusters
   [m2758]
   (clojure.core/let
    [credentials2759 (:credentials m2758) args2760 (:args m2758)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2761
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2759)]
     (clojure.core/case
      (clojure.core/count args2760)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2761
        describeClusters
        (redshift/describe-clusters-request
         (clojure.core/nth args2760 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2761
        describeClusters))))))
  (clojure.core/defn
   describe-clusters-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-identifier]}]
                [credentials]]),
    :doc "Generate map for describeClusters, describeClusters"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-clusters,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-clusters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-clusters
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-identifier]}]
                [credentials]]),
    :doc "Call describeClusters, describeClusters"}
   [credentials2763 & args2764]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2765
     (com.palletops.awaze.common/aws-client :redshift credentials2763)]
    (clojure.core/case
     (clojure.core/count args2764)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2765
       describeClusters
       (redshift/describe-clusters-request
        (clojure.core/nth args2764 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2765
       describeClusters))))))
 (do
  (clojure.core/defmethod
   redshift
   :restore-from-cluster-snapshot
   [m2766]
   (clojure.core/let
    [credentials2767 (:credentials m2766) args2768 (:args m2766)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2769
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2767)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2769
       restoreFromClusterSnapshot
       (redshift/restore-from-cluster-snapshot-request
        (clojure.core/nth args2768 0)))))))
  (clojure.core/defn
   restore-from-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         publicly-accessible
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         owner-account
                         availability-zone
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         cluster-parameter-group-name
                         vpc-security-group-ids
                         port
                         elastic-ip
                         snapshot-identifier
                         snapshot-cluster-identifier
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Generate map for restoreFromClusterSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :restore-from-cluster-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   restore-from-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         publicly-accessible
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         owner-account
                         availability-zone
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         cluster-parameter-group-name
                         vpc-security-group-ids
                         port
                         elastic-ip
                         snapshot-identifier
                         snapshot-cluster-identifier
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Call restoreFromClusterSnapshot"}
   [credentials2771 & args2772]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2773
     (com.palletops.awaze.common/aws-client :redshift credentials2771)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2773
      restoreFromClusterSnapshot
      (redshift/restore-from-cluster-snapshot-request
       (clojure.core/nth args2772 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-snapshot-access
   [m2774]
   (clojure.core/let
    [credentials2775 (:credentials m2774) args2776 (:args m2774)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2777
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2775)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2777
       revokeSnapshotAccess
       (redshift/revoke-snapshot-access-request
        (clojure.core/nth args2776 0)))))))
  (clojure.core/defn
   revoke-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener
                         account-with-restore-access]}]]),
    :doc "Generate map for revokeSnapshotAccess"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :revoke-snapshot-access,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   revoke-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener
                         account-with-restore-access]}]]),
    :doc "Call revokeSnapshotAccess"}
   [credentials2779 & args2780]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2781
     (com.palletops.awaze.common/aws-client :redshift credentials2779)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2781
      revokeSnapshotAccess
      (redshift/revoke-snapshot-access-request
       (clojure.core/nth args2780 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :rotate-encryption-key
   [m2782]
   (clojure.core/let
    [credentials2783 (:credentials m2782) args2784 (:args m2782)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2785
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2783)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2785
       rotateEncryptionKey
       (redshift/rotate-encryption-key-request
        (clojure.core/nth args2784 0)))))))
  (clojure.core/defn
   rotate-encryption-key-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for rotateEncryptionKey"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :rotate-encryption-key,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   rotate-encryption-key
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call rotateEncryptionKey"}
   [credentials2787 & args2788]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2789
     (com.palletops.awaze.common/aws-client :redshift credentials2787)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2789
      rotateEncryptionKey
      (redshift/rotate-encryption-key-request
       (clojure.core/nth args2788 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-logging
   [m2790]
   (clojure.core/let
    [credentials2791 (:credentials m2790) args2792 (:args m2790)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2793
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2791)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2793
       disableLogging
       (redshift/disable-logging-request
        (clojure.core/nth args2792 0)))))))
  (clojure.core/defn
   disable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for disableLogging"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :disable-logging,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disable-logging
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call disableLogging"}
   [credentials2795 & args2796]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2797
     (com.palletops.awaze.common/aws-client :redshift credentials2795)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2797
      disableLogging
      (redshift/disable-logging-request (clojure.core/nth args2796 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-security-group
   [m2798]
   (clojure.core/let
    [credentials2799 (:credentials m2798) args2800 (:args m2798)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2801
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2799)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2801
       deleteClusterSecurityGroup
       (redshift/delete-cluster-security-group-request
        (clojure.core/nth args2800 0)))))))
  (clojure.core/defn
   delete-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name]}]]),
    :doc "Generate map for deleteClusterSecurityGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-security-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name]}]]),
    :doc "Call deleteClusterSecurityGroup"}
   [credentials2803 & args2804]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2805
     (com.palletops.awaze.common/aws-client :redshift credentials2803)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2805
      deleteClusterSecurityGroup
      (redshift/delete-cluster-security-group-request
       (clojure.core/nth args2804 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameters
   [m2806]
   (clojure.core/let
    [credentials2807 (:credentials m2806) args2808 (:args m2806)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2809
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2807)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2809
       describeClusterParameters
       (redshift/describe-cluster-parameters-request
        (clojure.core/nth args2808 0)))))))
  (clojure.core/defn
   describe-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         parameter-group-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeClusterParameters"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-parameters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [source
                         parameter-group-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeClusterParameters"}
   [credentials2811 & args2812]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2813
     (com.palletops.awaze.common/aws-client :redshift credentials2811)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2813
      describeClusterParameters
      (redshift/describe-cluster-parameters-request
       (clojure.core/nth args2812 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-event-subscription
   [m2814]
   (clojure.core/let
    [credentials2815 (:credentials m2814) args2816 (:args m2814)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2817
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2815)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2817
       createEventSubscription
       (redshift/create-event-subscription-request
        (clojure.core/nth args2816 0)))))))
  (clojure.core/defn
   create-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         severity]}]]),
    :doc "Generate map for createEventSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-event-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         severity]}]]),
    :doc "Call createEventSubscription"}
   [credentials2819 & args2820]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2821
     (com.palletops.awaze.common/aws-client :redshift credentials2819)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2821
      createEventSubscription
      (redshift/create-event-subscription-request
       (clojure.core/nth args2820 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :reset-cluster-parameter-group
   [m2822]
   (clojure.core/let
    [credentials2823 (:credentials m2822) args2824 (:args m2822)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2825
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2823)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2825
       resetClusterParameterGroup
       (redshift/reset-cluster-parameter-group-request
        (clojure.core/nth args2824 0)))))))
  (clojure.core/defn
   reset-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameters
                         parameter-group-name
                         general-progress-listener]}]]),
    :doc "Generate map for resetClusterParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :reset-cluster-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reset-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameters
                         parameter-group-name
                         general-progress-listener]}]]),
    :doc "Call resetClusterParameterGroup"}
   [credentials2827 & args2828]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2829
     (com.palletops.awaze.common/aws-client :redshift credentials2827)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2829
      resetClusterParameterGroup
      (redshift/reset-cluster-parameter-group-request
       (clojure.core/nth args2828 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-parameter-group
   [m2830]
   (clojure.core/let
    [credentials2831 (:credentials m2830) args2832 (:args m2830)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2833
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2831)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2833
       createClusterParameterGroup
       (redshift/create-cluster-parameter-group-request
        (clojure.core/nth args2832 0)))))))
  (clojure.core/defn
   create-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-name
                         parameter-group-family
                         general-progress-listener
                         description]}]]),
    :doc "Generate map for createClusterParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-name
                         parameter-group-family
                         general-progress-listener
                         description]}]]),
    :doc "Call createClusterParameterGroup"}
   [credentials2835 & args2836]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2837
     (com.palletops.awaze.common/aws-client :redshift credentials2835)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2837
      createClusterParameterGroup
      (redshift/create-cluster-parameter-group-request
       (clojure.core/nth args2836 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-configuration
   [m2838]
   (clojure.core/let
    [credentials2839 (:credentials m2838) args2840 (:args m2838)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2841
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2839)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2841
       deleteHsmConfiguration
       (redshift/delete-hsm-configuration-request
        (clojure.core/nth args2840 0)))))))
  (clojure.core/defn
   delete-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for deleteHsmConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-hsm-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         general-progress-listener]}]]),
    :doc "Call deleteHsmConfiguration"}
   [credentials2843 & args2844]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2845
     (com.palletops.awaze.common/aws-client :redshift credentials2843)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2845
      deleteHsmConfiguration
      (redshift/delete-hsm-configuration-request
       (clojure.core/nth args2844 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-event-subscription
   [m2846]
   (clojure.core/let
    [credentials2847 (:credentials m2846) args2848 (:args m2846)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2849
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2847)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2849
       modifyEventSubscription
       (redshift/modify-event-subscription-request
        (clojure.core/nth args2848 0)))))))
  (clojure.core/defn
   modify-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         severity]}]]),
    :doc "Generate map for modifyEventSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-event-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         severity]}]]),
    :doc "Call modifyEventSubscription"}
   [credentials2851 & args2852]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2853
     (com.palletops.awaze.common/aws-client :redshift credentials2851)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2853
      modifyEventSubscription
      (redshift/modify-event-subscription-request
       (clojure.core/nth args2852 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-nodes
   [m2854]
   (clojure.core/let
    [credentials2855 (:credentials m2854) args2856 (:args m2854)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2857
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2855)]
     (clojure.core/case
      (clojure.core/count args2856)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2857
        describeReservedNodes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2857
        describeReservedNodes
        (redshift/describe-reserved-nodes-request
         (clojure.core/nth args2856 0))))))))
  (clojure.core/defn
   describe-reserved-nodes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-node-id
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeReservedNodes, describeReservedNodes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-reserved-nodes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-reserved-nodes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-nodes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-node-id
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeReservedNodes, describeReservedNodes"}
   [credentials2859 & args2860]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2861
     (com.palletops.awaze.common/aws-client :redshift credentials2859)]
    (clojure.core/case
     (clojure.core/count args2860)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2861
       describeReservedNodes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2861
       describeReservedNodes
       (redshift/describe-reserved-nodes-request
        (clojure.core/nth args2860 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :copy-cluster-snapshot
   [m2862]
   (clojure.core/let
    [credentials2863 (:credentials m2862) args2864 (:args m2862)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2865
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2863)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2865
       copyClusterSnapshot
       (redshift/copy-cluster-snapshot-request
        (clojure.core/nth args2864 0)))))))
  (clojure.core/defn
   copy-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [target-snapshot-identifier
                         source-snapshot-identifier
                         source-snapshot-cluster-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for copyClusterSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :copy-cluster-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   copy-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [target-snapshot-identifier
                         source-snapshot-identifier
                         source-snapshot-cluster-identifier
                         general-progress-listener]}]]),
    :doc "Call copyClusterSnapshot"}
   [credentials2867 & args2868]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2869
     (com.palletops.awaze.common/aws-client :redshift credentials2867)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2869
      copyClusterSnapshot
      (redshift/copy-cluster-snapshot-request
       (clojure.core/nth args2868 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-client-certificate
   [m2870]
   (clojure.core/let
    [credentials2871 (:credentials m2870) args2872 (:args m2870)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2873
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2871)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2873
       deleteHsmClientCertificate
       (redshift/delete-hsm-client-certificate-request
        (clojure.core/nth args2872 0)))))))
  (clojure.core/defn
   delete-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for deleteHsmClientCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-hsm-client-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Call deleteHsmClientCertificate"}
   [credentials2875 & args2876]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2877
     (com.palletops.awaze.common/aws-client :redshift credentials2875)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2877
      deleteHsmClientCertificate
      (redshift/delete-hsm-client-certificate-request
       (clojure.core/nth args2876 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-subnet-group
   [m2878]
   (clojure.core/let
    [credentials2879 (:credentials m2878) args2880 (:args m2878)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2881
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2879)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2881
       modifyClusterSubnetGroup
       (redshift/modify-cluster-subnet-group-request
        (clojure.core/nth args2880 0)))))))
  (clojure.core/defn
   modify-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Generate map for modifyClusterSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-cluster-subnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Call modifyClusterSubnetGroup"}
   [credentials2883 & args2884]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2885
     (com.palletops.awaze.common/aws-client :redshift credentials2883)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2885
      modifyClusterSubnetGroup
      (redshift/modify-cluster-subnet-group-request
       (clojure.core/nth args2884 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-logging-status
   [m2886]
   (clojure.core/let
    [credentials2887 (:credentials m2886) args2888 (:args m2886)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2889
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2887)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2889
       describeLoggingStatus
       (redshift/describe-logging-status-request
        (clojure.core/nth args2888 0)))))))
  (clojure.core/defn
   describe-logging-status-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for describeLoggingStatus"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-logging-status,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-logging-status
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call describeLoggingStatus"}
   [credentials2891 & args2892]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2893
     (com.palletops.awaze.common/aws-client :redshift credentials2891)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2893
      describeLoggingStatus
      (redshift/describe-logging-status-request
       (clojure.core/nth args2892 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-events
   [m2894]
   (clojure.core/let
    [credentials2895 (:credentials m2894) args2896 (:args m2894)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2897
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2895)]
     (clojure.core/case
      (clojure.core/count args2896)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2897
        describeEvents))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2897
        describeEvents
        (redshift/describe-events-request
         (clojure.core/nth args2896 0))))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         source-type
                         duration
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-events,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-events,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         source-type
                         duration
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials2899 & args2900]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2901
     (com.palletops.awaze.common/aws-client :redshift credentials2899)]
    (clojure.core/case
     (clojure.core/count args2900)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2901
       describeEvents))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2901
       describeEvents
       (redshift/describe-events-request
        (clojure.core/nth args2900 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-parameter-group
   [m2902]
   (clojure.core/let
    [credentials2903 (:credentials m2902) args2904 (:args m2902)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2905
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2903)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2905
       deleteClusterParameterGroup
       (redshift/delete-cluster-parameter-group-request
        (clojure.core/nth args2904 0)))))))
  (clojure.core/defn
   delete-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteClusterParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-name
                         general-progress-listener]}]]),
    :doc "Call deleteClusterParameterGroup"}
   [credentials2907 & args2908]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2909
     (com.palletops.awaze.common/aws-client :redshift credentials2907)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2909
      deleteClusterParameterGroup
      (redshift/delete-cluster-parameter-group-request
       (clojure.core/nth args2908 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-cluster-security-group-ingress
   [m2910]
   (clojure.core/let
    [credentials2911 (:credentials m2910) args2912 (:args m2910)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2913
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2911)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2913
       authorizeClusterSecurityGroupIngress
       (redshift/authorize-cluster-security-group-ingress-request
        (clojure.core/nth args2912 0)))))))
  (clojure.core/defn
   authorize-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Generate map for authorizeClusterSecurityGroupIngress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :authorize-cluster-security-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   authorize-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Call authorizeClusterSecurityGroupIngress"}
   [credentials2915 & args2916]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2917
     (com.palletops.awaze.common/aws-client :redshift credentials2915)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2917
      authorizeClusterSecurityGroupIngress
      (redshift/authorize-cluster-security-group-ingress-request
       (clojure.core/nth args2916 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster
   [m2918]
   (clojure.core/let
    [credentials2919 (:credentials m2918) args2920 (:args m2918)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2921
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2919)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2921
       modifyCluster
       (redshift/modify-cluster-request (clojure.core/nth args2920 0)))))))
  (clojure.core/defn
   modify-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         hsm-client-certificate-identifier
                         cluster-type
                         new-cluster-identifier
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         cluster-version
                         allow-version-upgrade]}]]),
    :doc "Generate map for modifyCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-cluster
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         hsm-client-certificate-identifier
                         cluster-type
                         new-cluster-identifier
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         cluster-version
                         allow-version-upgrade]}]]),
    :doc "Call modifyCluster"}
   [credentials2923 & args2924]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2925
     (com.palletops.awaze.common/aws-client :redshift credentials2923)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2925
      modifyCluster
      (redshift/modify-cluster-request (clojure.core/nth args2924 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-subnet-group
   [m2926]
   (clojure.core/let
    [credentials2927 (:credentials m2926) args2928 (:args m2926)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2929
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2927)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2929
       deleteClusterSubnetGroup
       (redshift/delete-cluster-subnet-group-request
        (clojure.core/nth args2928 0)))))))
  (clojure.core/defn
   delete-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-subnet-group-name]}]]),
    :doc "Generate map for deleteClusterSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-subnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-subnet-group-name]}]]),
    :doc "Call deleteClusterSubnetGroup"}
   [credentials2931 & args2932]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2933
     (com.palletops.awaze.common/aws-client :redshift credentials2931)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2933
      deleteClusterSubnetGroup
      (redshift/delete-cluster-subnet-group-request
       (clojure.core/nth args2932 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-subnet-group
   [m2934]
   (clojure.core/let
    [credentials2935 (:credentials m2934) args2936 (:args m2934)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2937
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2935)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2937
       createClusterSubnetGroup
       (redshift/create-cluster-subnet-group-request
        (clojure.core/nth args2936 0)))))))
  (clojure.core/defn
   create-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Generate map for createClusterSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-subnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Call createClusterSubnetGroup"}
   [credentials2939 & args2940]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2941
     (com.palletops.awaze.common/aws-client :redshift credentials2939)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2941
      createClusterSubnetGroup
      (redshift/create-cluster-subnet-group-request
       (clojure.core/nth args2940 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :purchase-reserved-node-offering
   [m2942]
   (clojure.core/let
    [credentials2943 (:credentials m2942) args2944 (:args m2942)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2945
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2943)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2945
       purchaseReservedNodeOffering
       (redshift/purchase-reserved-node-offering-request
        (clojure.core/nth args2944 0)))))))
  (clojure.core/defn
   purchase-reserved-node-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-node-offering-id
                         node-count
                         general-progress-listener]}]]),
    :doc "Generate map for purchaseReservedNodeOffering"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :purchase-reserved-node-offering,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   purchase-reserved-node-offering
   {:arglists (quote
               [[credentials
                 {:keys [reserved-node-offering-id
                         node-count
                         general-progress-listener]}]]),
    :doc "Call purchaseReservedNodeOffering"}
   [credentials2947 & args2948]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2949
     (com.palletops.awaze.common/aws-client :redshift credentials2947)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2949
      purchaseReservedNodeOffering
      (redshift/purchase-reserved-node-offering-request
       (clojure.core/nth args2948 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-node-offerings
   [m2950]
   (clojure.core/let
    [credentials2951 (:credentials m2950) args2952 (:args m2950)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2953
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2951)]
     (clojure.core/case
      (clojure.core/count args2952)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2953
        describeReservedNodeOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2953
        describeReservedNodeOfferings
        (redshift/describe-reserved-node-offerings-request
         (clojure.core/nth args2952 0))))))))
  (clojure.core/defn
   describe-reserved-node-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-node-offering-id
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeReservedNodeOfferings, describeReservedNodeOfferings"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-node-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-node-offering-id
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeReservedNodeOfferings, describeReservedNodeOfferings"}
   [credentials2955 & args2956]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2957
     (com.palletops.awaze.common/aws-client :redshift credentials2955)]
    (clojure.core/case
     (clojure.core/count args2956)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2957
       describeReservedNodeOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2957
       describeReservedNodeOfferings
       (redshift/describe-reserved-node-offerings-request
        (clojure.core/nth args2956 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster
   [m2958]
   (clojure.core/let
    [credentials2959 (:credentials m2958) args2960 (:args m2958)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2961
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2959)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2961
       deleteCluster
       (redshift/delete-cluster-request (clojure.core/nth args2960 0)))))))
  (clojure.core/defn
   delete-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [skip-final-cluster-snapshot
                         general-progress-listener
                         final-cluster-snapshot-identifier
                         cluster-identifier]}]]),
    :doc "Generate map for deleteCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cluster
   {:arglists (quote
               [[credentials
                 {:keys [skip-final-cluster-snapshot
                         general-progress-listener
                         final-cluster-snapshot-identifier
                         cluster-identifier]}]]),
    :doc "Call deleteCluster"}
   [credentials2963 & args2964]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2965
     (com.palletops.awaze.common/aws-client :redshift credentials2963)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2965
      deleteCluster
      (redshift/delete-cluster-request (clojure.core/nth args2964 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-security-group
   [m2966]
   (clojure.core/let
    [credentials2967 (:credentials m2966) args2968 (:args m2966)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2969
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2967)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2969
       createClusterSecurityGroup
       (redshift/create-cluster-security-group-request
        (clojure.core/nth args2968 0)))))))
  (clojure.core/defn
   create-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cluster-security-group-name]}]]),
    :doc "Generate map for createClusterSecurityGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-security-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cluster-security-group-name]}]]),
    :doc "Call createClusterSecurityGroup"}
   [credentials2971 & args2972]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2973
     (com.palletops.awaze.common/aws-client :redshift credentials2971)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2973
      createClusterSecurityGroup
      (redshift/create-cluster-security-group-request
       (clojure.core/nth args2972 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-subscriptions
   [m2974]
   (clojure.core/let
    [credentials2975 (:credentials m2974) args2976 (:args m2974)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2977
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2975)]
     (clojure.core/case
      (clojure.core/count args2976)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2977
        describeEventSubscriptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2977
        describeEventSubscriptions
        (redshift/describe-event-subscriptions-request
         (clojure.core/nth args2976 0))))))))
  (clojure.core/defn
   describe-event-subscriptions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [subscription-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeEventSubscriptions, describeEventSubscriptions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-event-subscriptions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-event-subscriptions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-event-subscriptions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [subscription-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeEventSubscriptions, describeEventSubscriptions"}
   [credentials2979 & args2980]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2981
     (com.palletops.awaze.common/aws-client :redshift credentials2979)]
    (clojure.core/case
     (clojure.core/count args2980)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2981
       describeEventSubscriptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2981
       describeEventSubscriptions
       (redshift/describe-event-subscriptions-request
        (clojure.core/nth args2980 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-default-cluster-parameters
   [m2982]
   (clojure.core/let
    [credentials2983 (:credentials m2982) args2984 (:args m2982)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2985
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2983)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2985
       describeDefaultClusterParameters
       (redshift/describe-default-cluster-parameters-request
        (clojure.core/nth args2984 0)))))))
  (clojure.core/defn
   describe-default-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-family
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeDefaultClusterParameters"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-default-cluster-parameters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-default-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-family
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeDefaultClusterParameters"}
   [credentials2987 & args2988]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2989
     (com.palletops.awaze.common/aws-client :redshift credentials2987)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2989
      describeDefaultClusterParameters
      (redshift/describe-default-cluster-parameters-request
       (clojure.core/nth args2988 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-configurations
   [m2990]
   (clojure.core/let
    [credentials2991 (:credentials m2990) args2992 (:args m2990)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2993
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2991)]
     (clojure.core/case
      (clojure.core/count args2992)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2993
        describeHsmConfigurations
        (redshift/describe-hsm-configurations-request
         (clojure.core/nth args2992 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2993
        describeHsmConfigurations))))))
  (clojure.core/defn
   describe-hsm-configurations-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         hsm-configuration-identifier
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeHsmConfigurations, describeHsmConfigurations"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-hsm-configurations,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-hsm-configurations,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-hsm-configurations
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         hsm-configuration-identifier
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call describeHsmConfigurations, describeHsmConfigurations"}
   [credentials2995 & args2996]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2997
     (com.palletops.awaze.common/aws-client :redshift credentials2995)]
    (clojure.core/case
     (clojure.core/count args2996)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2997
       describeHsmConfigurations
       (redshift/describe-hsm-configurations-request
        (clojure.core/nth args2996 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2997
       describeHsmConfigurations))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-snapshot
   [m2998]
   (clojure.core/let
    [credentials2999 (:credentials m2998) args3000 (:args m2998)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3001
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2999)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3001
       createClusterSnapshot
       (redshift/create-cluster-snapshot-request
        (clojure.core/nth args3000 0)))))))
  (clojure.core/defn
   create-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Generate map for createClusterSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Call createClusterSnapshot"}
   [credentials3003 & args3004]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3005
     (com.palletops.awaze.common/aws-client :redshift credentials3003)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3005
      createClusterSnapshot
      (redshift/create-cluster-snapshot-request
       (clojure.core/nth args3004 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-versions
   [m3006]
   (clojure.core/let
    [credentials3007 (:credentials m3006) args3008 (:args m3006)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3009
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3007)]
     (clojure.core/case
      (clojure.core/count args3008)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3009
        describeClusterVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3009
        describeClusterVersions
        (redshift/describe-cluster-versions-request
         (clojure.core/nth args3008 0))))))))
  (clojure.core/defn
   describe-cluster-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-version
                         cluster-parameter-group-family]}]]),
    :doc "Generate map for describeClusterVersions, describeClusterVersions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-versions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-versions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cluster-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-version
                         cluster-parameter-group-family]}]]),
    :doc "Call describeClusterVersions, describeClusterVersions"}
   [credentials3011 & args3012]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3013
     (com.palletops.awaze.common/aws-client :redshift credentials3011)]
    (clojure.core/case
     (clojure.core/count args3012)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3013
       describeClusterVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3013
       describeClusterVersions
       (redshift/describe-cluster-versions-request
        (clojure.core/nth args3012 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-snapshot-copy
   [m3014]
   (clojure.core/let
    [credentials3015 (:credentials m3014) args3016 (:args m3014)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3017
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3015)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3017
       disableSnapshotCopy
       (redshift/disable-snapshot-copy-request
        (clojure.core/nth args3016 0)))))))
  (clojure.core/defn
   disable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for disableSnapshotCopy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :disable-snapshot-copy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call disableSnapshotCopy"}
   [credentials3019 & args3020]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3021
     (com.palletops.awaze.common/aws-client :redshift credentials3019)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3021
      disableSnapshotCopy
      (redshift/disable-snapshot-copy-request
       (clojure.core/nth args3020 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-event-subscription
   [m3022]
   (clojure.core/let
    [credentials3023 (:credentials m3022) args3024 (:args m3022)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3025
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3023)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3025
       deleteEventSubscription
       (redshift/delete-event-subscription-request
        (clojure.core/nth args3024 0)))))))
  (clojure.core/defn
   delete-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name general-progress-listener]}]]),
    :doc "Generate map for deleteEventSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-event-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name general-progress-listener]}]]),
    :doc "Call deleteEventSubscription"}
   [credentials3027 & args3028]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3029
     (com.palletops.awaze.common/aws-client :redshift credentials3027)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3029
      deleteEventSubscription
      (redshift/delete-event-subscription-request
       (clojure.core/nth args3028 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-snapshot-copy-retention-period
   [m3030]
   (clojure.core/let
    [credentials3031 (:credentials m3030) args3032 (:args m3030)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3033
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3031)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3033
       modifySnapshotCopyRetentionPeriod
       (redshift/modify-snapshot-copy-retention-period-request
        (clojure.core/nth args3032 0)))))))
  (clojure.core/defn
   modify-snapshot-copy-retention-period-map
   {:arglists (quote
               [[credentials
                 {:keys [retention-period
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Generate map for modifySnapshotCopyRetentionPeriod"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-snapshot-copy-retention-period,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-snapshot-copy-retention-period
   {:arglists (quote
               [[credentials
                 {:keys [retention-period
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Call modifySnapshotCopyRetentionPeriod"}
   [credentials3035 & args3036]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3037
     (com.palletops.awaze.common/aws-client :redshift credentials3035)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3037
      modifySnapshotCopyRetentionPeriod
      (redshift/modify-snapshot-copy-retention-period-request
       (clojure.core/nth args3036 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :reboot-cluster
   [m3038]
   (clojure.core/let
    [credentials3039 (:credentials m3038) args3040 (:args m3038)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3041
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3039)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3041
       rebootCluster
       (redshift/reboot-cluster-request (clojure.core/nth args3040 0)))))))
  (clojure.core/defn
   reboot-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for rebootCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :reboot-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reboot-cluster
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call rebootCluster"}
   [credentials3043 & args3044]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3045
     (com.palletops.awaze.common/aws-client :redshift credentials3043)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3045
      rebootCluster
      (redshift/reboot-cluster-request (clojure.core/nth args3044 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-resize
   [m3046]
   (clojure.core/let
    [credentials3047 (:credentials m3046) args3048 (:args m3046)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3049
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3047)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3049
       describeResize
       (redshift/describe-resize-request
        (clojure.core/nth args3048 0)))))))
  (clojure.core/defn
   describe-resize-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for describeResize"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-resize,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-resize
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call describeResize"}
   [credentials3051 & args3052]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3053
     (com.palletops.awaze.common/aws-client :redshift credentials3051)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3053
      describeResize
      (redshift/describe-resize-request (clojure.core/nth args3052 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-cluster-security-group-ingress
   [m3054]
   (clojure.core/let
    [credentials3055 (:credentials m3054) args3056 (:args m3054)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3057
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3055)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3057
       revokeClusterSecurityGroupIngress
       (redshift/revoke-cluster-security-group-ingress-request
        (clojure.core/nth args3056 0)))))))
  (clojure.core/defn
   revoke-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Generate map for revokeClusterSecurityGroupIngress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :revoke-cluster-security-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   revoke-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Call revokeClusterSecurityGroupIngress"}
   [credentials3059 & args3060]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3061
     (com.palletops.awaze.common/aws-client :redshift credentials3059)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3061
      revokeClusterSecurityGroupIngress
      (redshift/revoke-cluster-security-group-ingress-request
       (clojure.core/nth args3060 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-parameter-group
   [m3062]
   (clojure.core/let
    [credentials3063 (:credentials m3062) args3064 (:args m3062)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3065
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3063)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3065
       modifyClusterParameterGroup
       (redshift/modify-cluster-parameter-group-request
        (clojure.core/nth args3064 0)))))))
  (clojure.core/defn
   modify-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [parameters
                         parameter-group-name
                         general-progress-listener]}]]),
    :doc "Generate map for modifyClusterParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-cluster-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [parameters
                         parameter-group-name
                         general-progress-listener]}]]),
    :doc "Call modifyClusterParameterGroup"}
   [credentials3067 & args3068]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3069
     (com.palletops.awaze.common/aws-client :redshift credentials3067)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3069
      modifyClusterParameterGroup
      (redshift/modify-cluster-parameter-group-request
       (clojure.core/nth args3068 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-client-certificates
   [m3070]
   (clojure.core/let
    [credentials3071 (:credentials m3070) args3072 (:args m3070)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3073
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3071)]
     (clojure.core/case
      (clojure.core/count args3072)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3073
        describeHsmClientCertificates
        (redshift/describe-hsm-client-certificates-request
         (clojure.core/nth args3072 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3073
        describeHsmClientCertificates))))))
  (clojure.core/defn
   describe-hsm-client-certificates-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         hsm-client-certificate-identifier
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeHsmClientCertificates, describeHsmClientCertificates"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-hsm-client-certificates
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         hsm-client-certificate-identifier
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call describeHsmClientCertificates, describeHsmClientCertificates"}
   [credentials3075 & args3076]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3077
     (com.palletops.awaze.common/aws-client :redshift credentials3075)]
    (clojure.core/case
     (clojure.core/count args3076)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3077
       describeHsmClientCertificates
       (redshift/describe-hsm-client-certificates-request
        (clojure.core/nth args3076 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3077
       describeHsmClientCertificates))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-client-certificate
   [m3078]
   (clojure.core/let
    [credentials3079 (:credentials m3078) args3080 (:args m3078)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3081
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3079)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3081
       createHsmClientCertificate
       (redshift/create-hsm-client-certificate-request
        (clojure.core/nth args3080 0)))))))
  (clojure.core/defn
   create-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for createHsmClientCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-hsm-client-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Call createHsmClientCertificate"}
   [credentials3083 & args3084]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3085
     (com.palletops.awaze.common/aws-client :redshift credentials3083)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3085
      createHsmClientCertificate
      (redshift/create-hsm-client-certificate-request
       (clojure.core/nth args3084 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-categories
   [m3086]
   (clojure.core/let
    [credentials3087 (:credentials m3086) args3088 (:args m3086)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3089
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3087)]
     (clojure.core/case
      (clojure.core/count args3088)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3089
        describeEventCategories))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3089
        describeEventCategories
        (redshift/describe-event-categories-request
         (clojure.core/nth args3088 0))))))))
  (clojure.core/defn
   describe-event-categories-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-type general-progress-listener]}]]),
    :doc "Generate map for describeEventCategories, describeEventCategories"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-event-categories,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-event-categories,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-event-categories
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-type general-progress-listener]}]]),
    :doc "Call describeEventCategories, describeEventCategories"}
   [credentials3091 & args3092]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3093
     (com.palletops.awaze.common/aws-client :redshift credentials3091)]
    (clojure.core/case
     (clojure.core/count args3092)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3093
       describeEventCategories))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3093
       describeEventCategories
       (redshift/describe-event-categories-request
        (clojure.core/nth args3092 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-configuration
   [m3094]
   (clojure.core/let
    [credentials3095 (:credentials m3094) args3096 (:args m3094)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3097
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3095)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3097
       createHsmConfiguration
       (redshift/create-hsm-configuration-request
        (clojure.core/nth args3096 0)))))))
  (clojure.core/defn
   create-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         hsm-partition-name
                         hsm-configuration-identifier
                         hsm-partition-password
                         hsm-server-public-certificate
                         hsm-ip-address
                         description]}]]),
    :doc "Generate map for createHsmConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-hsm-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         hsm-partition-name
                         hsm-configuration-identifier
                         hsm-partition-password
                         hsm-server-public-certificate
                         hsm-ip-address
                         description]}]]),
    :doc "Call createHsmConfiguration"}
   [credentials3099 & args3100]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3101
     (com.palletops.awaze.common/aws-client :redshift credentials3099)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3101
      createHsmConfiguration
      (redshift/create-hsm-configuration-request
       (clojure.core/nth args3100 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-snapshots
   [m3102]
   (clojure.core/let
    [credentials3103 (:credentials m3102) args3104 (:args m3102)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3105
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3103)]
     (clojure.core/case
      (clojure.core/count args3104)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3105
        describeClusterSnapshots
        (redshift/describe-cluster-snapshots-request
         (clojure.core/nth args3104 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3105
        describeClusterSnapshots))))))
  (clojure.core/defn
   describe-cluster-snapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         cluster-identifier
                         owner-account
                         max-records
                         start-time
                         marker
                         snapshot-identifier
                         snapshot-type]}]
                [credentials]]),
    :doc "Generate map for describeClusterSnapshots, describeClusterSnapshots"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-snapshots,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-snapshots,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cluster-snapshots
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         cluster-identifier
                         owner-account
                         max-records
                         start-time
                         marker
                         snapshot-identifier
                         snapshot-type]}]
                [credentials]]),
    :doc "Call describeClusterSnapshots, describeClusterSnapshots"}
   [credentials3107 & args3108]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3109
     (com.palletops.awaze.common/aws-client :redshift credentials3107)]
    (clojure.core/case
     (clojure.core/count args3108)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3109
       describeClusterSnapshots
       (redshift/describe-cluster-snapshots-request
        (clojure.core/nth args3108 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3109
       describeClusterSnapshots))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-snapshot
   [m3110]
   (clojure.core/let
    [credentials3111 (:credentials m3110) args3112 (:args m3110)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3113
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3111)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3113
       deleteClusterSnapshot
       (redshift/delete-cluster-snapshot-request
        (clojure.core/nth args3112 0)))))))
  (clojure.core/defn
   delete-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for deleteClusterSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener]}]]),
    :doc "Call deleteClusterSnapshot"}
   [credentials3115 & args3116]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3117
     (com.palletops.awaze.common/aws-client :redshift credentials3115)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3117
      deleteClusterSnapshot
      (redshift/delete-cluster-snapshot-request
       (clojure.core/nth args3116 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-orderable-cluster-options
   [m3118]
   (clojure.core/let
    [credentials3119 (:credentials m3118) args3120 (:args m3118)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3121
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3119)]
     (clojure.core/case
      (clojure.core/count args3120)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3121
        describeOrderableClusterOptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3121
        describeOrderableClusterOptions
        (redshift/describe-orderable-cluster-options-request
         (clojure.core/nth args3120 0))))))))
  (clojure.core/defn
   describe-orderable-cluster-options-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [node-type
                         max-records
                         marker
                         general-progress-listener
                         cluster-version]}]]),
    :doc "Generate map for describeOrderableClusterOptions, describeOrderableClusterOptions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-orderable-cluster-options
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [node-type
                         max-records
                         marker
                         general-progress-listener
                         cluster-version]}]]),
    :doc "Call describeOrderableClusterOptions, describeOrderableClusterOptions"}
   [credentials3123 & args3124]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3125
     (com.palletops.awaze.common/aws-client :redshift credentials3123)]
    (clojure.core/case
     (clojure.core/count args3124)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3125
       describeOrderableClusterOptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3125
       describeOrderableClusterOptions
       (redshift/describe-orderable-cluster-options-request
        (clojure.core/nth args3124 0)))))))))
