(ns
 com.palletops.awaze.rds
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.rds :as rds]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :rds
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.rds.AmazonRDSClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.OptionSetting}
option-setting
  [m4827]
  (clojure.core/let
   [bean4826 (new com.amazonaws.services.rds.model.OptionSetting)]
   (clojure.core/let
    [v4828
     (:data-type m4827 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4828 :com.palletops.awaze.client-builder/undef)
     (. bean4826 setDataType (clojure.core/str v4828))))
   (clojure.core/let
    [v4828
     (:apply-type m4827 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4828 :com.palletops.awaze.client-builder/undef)
     (. bean4826 setApplyType (clojure.core/str v4828))))
   (clojure.core/let
    [v4828
     (:allowed-values m4827 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4828 :com.palletops.awaze.client-builder/undef)
     (. bean4826 setAllowedValues (clojure.core/str v4828))))
   (clojure.core/let
    [v4828
     (:is-collection m4827 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4828 :com.palletops.awaze.client-builder/undef)
     (. bean4826 setIsCollection (clojure.core/boolean v4828))))
   (clojure.core/let
    [v4828 (:name m4827 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4828 :com.palletops.awaze.client-builder/undef)
     (. bean4826 setName (clojure.core/str v4828))))
   (clojure.core/let
    [v4828 (:value m4827 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4828 :com.palletops.awaze.client-builder/undef)
     (. bean4826 setValue (clojure.core/str v4828))))
   (clojure.core/let
    [v4828
     (:is-modifiable m4827 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4828 :com.palletops.awaze.client-builder/undef)
     (. bean4826 setIsModifiable (clojure.core/boolean v4828))))
   (clojure.core/let
    [v4828
     (:default-value m4827 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4828 :com.palletops.awaze.client-builder/undef)
     (. bean4826 setDefaultValue (clojure.core/str v4828))))
   (clojure.core/let
    [v4828
     (:description m4827 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4828 :com.palletops.awaze.client-builder/undef)
     (. bean4826 setDescription (clojure.core/str v4828))))
   bean4826))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.Tag}
tag
  [m4830]
  (clojure.core/let
   [bean4829 (new com.amazonaws.services.rds.model.Tag)]
   (clojure.core/let
    [v4831 (:value m4830 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4831 :com.palletops.awaze.client-builder/undef)
     (. bean4829 setValue (clojure.core/str v4831))))
   (clojure.core/let
    [v4831 (:key m4830 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4831 :com.palletops.awaze.client-builder/undef)
     (. bean4829 setKey (clojure.core/str v4831))))
   bean4829))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.Filter}
filter
  [m4833]
  (clojure.core/let
   [bean4832 (new com.amazonaws.services.rds.model.Filter)]
   (clojure.core/let
    [v4834
     (:filter-name m4833 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4834 :com.palletops.awaze.client-builder/undef)
     (. bean4832 setFilterName (clojure.core/str v4834))))
   (clojure.core/let
    [v4834
     (:filter-value m4833 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4834 :com.palletops.awaze.client-builder/undef)
     (.
      bean4832
      setFilterValue
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5000] (clojure.core/str arg5000))
 v4834))))
   bean4832))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.SourceType}
source-type
  [m4836]
  (.
   com.amazonaws.services.rds.model.SourceType
   fromValue
   (clojure.core/name m4836)))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.OptionConfiguration}
option-configuration
  [m4839]
  (clojure.core/let
   [bean4838
    (new com.amazonaws.services.rds.model.OptionConfiguration)]
   (clojure.core/let
    [v4840
     (:option-name m4839 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4840 :com.palletops.awaze.client-builder/undef)
     (. bean4838 setOptionName (clojure.core/str v4840))))
   (clojure.core/let
    [v4840
     (:dbsecurity-group-memberships
      m4839
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4840 :com.palletops.awaze.client-builder/undef)
     (.
      bean4838
      setDBSecurityGroupMemberships
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5001] (clojure.core/str arg5001))
 v4840))))
   (clojure.core/let
    [v4840
     (:vpc-security-group-memberships
      m4839
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4840 :com.palletops.awaze.client-builder/undef)
     (.
      bean4838
      setVpcSecurityGroupMemberships
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5002] (clojure.core/str arg5002))
 v4840))))
   (clojure.core/let
    [v4840
     (:option-settings
      m4839
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4840 :com.palletops.awaze.client-builder/undef)
     (.
      bean4838
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5003] (rds/option-setting arg5003))
 v4840))))
   (clojure.core/let
    [v4840 (:port m4839 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4840 :com.palletops.awaze.client-builder/undef)
     (. bean4838 setPort (clojure.core/int v4840))))
   bean4838))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.Parameter}
parameter
  [m4842]
  (clojure.core/let
   [bean4841 (new com.amazonaws.services.rds.model.Parameter)]
   (clojure.core/let
    [v4843
     (:data-type m4842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4843 :com.palletops.awaze.client-builder/undef)
     (. bean4841 setDataType (clojure.core/str v4843))))
   (clojure.core/let
    [v4843
     (:apply-type m4842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4843 :com.palletops.awaze.client-builder/undef)
     (. bean4841 setApplyType (clojure.core/str v4843))))
   (clojure.core/let
    [v4843
     (:allowed-values m4842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4843 :com.palletops.awaze.client-builder/undef)
     (. bean4841 setAllowedValues (clojure.core/str v4843))))
   (clojure.core/let
    [v4843
     (:parameter-value
      m4842
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4843 :com.palletops.awaze.client-builder/undef)
     (. bean4841 setParameterValue (clojure.core/str v4843))))
   (clojure.core/let
    [v4843
     (:minimum-engine-version
      m4842
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4843 :com.palletops.awaze.client-builder/undef)
     (. bean4841 setMinimumEngineVersion (clojure.core/str v4843))))
   (clojure.core/let
    [v4843
     (:apply-method m4842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4843 :com.palletops.awaze.client-builder/undef)
     (. bean4841 setApplyMethod (clojure.core/str v4843))))
   (clojure.core/let
    [v4843
     (:is-modifiable m4842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4843 :com.palletops.awaze.client-builder/undef)
     (. bean4841 setIsModifiable (clojure.core/boolean v4843))))
   (clojure.core/let
    [v4843
     (:parameter-name m4842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4843 :com.palletops.awaze.client-builder/undef)
     (. bean4841 setParameterName (clojure.core/str v4843))))
   (clojure.core/let
    [v4843
     (:description m4842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4843 :com.palletops.awaze.client-builder/undef)
     (. bean4841 setDescription (clojure.core/str v4843))))
   (clojure.core/let
    [v4843 (:source m4842 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4843 :com.palletops.awaze.client-builder/undef)
     (. bean4841 setSource (clojure.core/str v4843))))
   bean4841))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest}
revoke-dbsecurity-group-ingress-request
  [m4845]
  (clojure.core/let
   [bean4844
    (new
     com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest)]
   (clojure.core/let
    [v4846
     (:dbsecurity-group-name
      m4845
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4846 :com.palletops.awaze.client-builder/undef)
     (. bean4844 setDBSecurityGroupName (clojure.core/str v4846))))
   (clojure.core/let
    [v4846
     (:ec2security-group-id
      m4845
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4846 :com.palletops.awaze.client-builder/undef)
     (. bean4844 setEC2SecurityGroupId (clojure.core/str v4846))))
   (clojure.core/let
    [v4846 (:cidrip m4845 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4846 :com.palletops.awaze.client-builder/undef)
     (. bean4844 setCIDRIP (clojure.core/str v4846))))
   (clojure.core/let
    [v4846
     (:ec2security-group-name
      m4845
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4846 :com.palletops.awaze.client-builder/undef)
     (. bean4844 setEC2SecurityGroupName (clojure.core/str v4846))))
   (clojure.core/let
    [v4846
     (:ec2security-group-owner-id
      m4845
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4846 :com.palletops.awaze.client-builder/undef)
     (. bean4844 setEC2SecurityGroupOwnerId (clojure.core/str v4846))))
   bean4844))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.AddTagsToResourceRequest}
add-tags-to-resource-request
  [m4848]
  (clojure.core/let
   [bean4847
    (new com.amazonaws.services.rds.model.AddTagsToResourceRequest)]
   (clojure.core/let
    [v4849 (:tags m4848 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4849 :com.palletops.awaze.client-builder/undef)
     (.
      bean4847
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5004] (rds/tag arg5004)) v4849))))
   (clojure.core/let
    [v4849
     (:resource-name m4848 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4849 :com.palletops.awaze.client-builder/undef)
     (. bean4847 setResourceName (clojure.core/str v4849))))
   bean4847))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest}
describe-dbsecurity-groups-request
  [m4851]
  (clojure.core/let
   [bean4850
    (new
     com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest)]
   (clojure.core/let
    [v4852 (:filters m4851 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4852 :com.palletops.awaze.client-builder/undef)
     (.
      bean4850
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5005] (rds/filter arg5005))
 v4852))))
   (clojure.core/let
    [v4852 (:marker m4851 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4852 :com.palletops.awaze.client-builder/undef)
     (. bean4850 setMarker (clojure.core/str v4852))))
   (clojure.core/let
    [v4852
     (:dbsecurity-group-name
      m4851
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4852 :com.palletops.awaze.client-builder/undef)
     (. bean4850 setDBSecurityGroupName (clojure.core/str v4852))))
   (clojure.core/let
    [v4852
     (:max-records m4851 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4852 :com.palletops.awaze.client-builder/undef)
     (. bean4850 setMaxRecords (clojure.core/int v4852))))
   bean4850))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest}
purchase-reserved-dbinstances-offering-request
  [m4854]
  (clojure.core/let
   [bean4853
    (new
     com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest)]
   (clojure.core/let
    [v4855 (:tags m4854 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4855 :com.palletops.awaze.client-builder/undef)
     (.
      bean4853
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5006] (rds/tag arg5006)) v4855))))
   (clojure.core/let
    [v4855
     (:reserved-dbinstances-offering-id
      m4854
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4855 :com.palletops.awaze.client-builder/undef)
     (.
      bean4853
      setReservedDBInstancesOfferingId
      (clojure.core/str v4855))))
   (clojure.core/let
    [v4855
     (:reserved-dbinstance-id
      m4854
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4855 :com.palletops.awaze.client-builder/undef)
     (. bean4853 setReservedDBInstanceId (clojure.core/str v4855))))
   (clojure.core/let
    [v4855
     (:dbinstance-count
      m4854
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4855 :com.palletops.awaze.client-builder/undef)
     (. bean4853 setDBInstanceCount (clojure.core/int v4855))))
   bean4853))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBParametersRequest}
describe-dbparameters-request
  [m4857]
  (clojure.core/let
   [bean4856
    (new com.amazonaws.services.rds.model.DescribeDBParametersRequest)]
   (clojure.core/let
    [v4858 (:source m4857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4858 :com.palletops.awaze.client-builder/undef)
     (. bean4856 setSource (clojure.core/str v4858))))
   (clojure.core/let
    [v4858 (:marker m4857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4858 :com.palletops.awaze.client-builder/undef)
     (. bean4856 setMarker (clojure.core/str v4858))))
   (clojure.core/let
    [v4858
     (:dbparameter-group-name
      m4857
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4858 :com.palletops.awaze.client-builder/undef)
     (. bean4856 setDBParameterGroupName (clojure.core/str v4858))))
   (clojure.core/let
    [v4858
     (:max-records m4857 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4858 :com.palletops.awaze.client-builder/undef)
     (. bean4856 setMaxRecords (clojure.core/int v4858))))
   bean4856))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeOptionGroupsRequest}
describe-option-groups-request
  [m4860]
  (clojure.core/let
   [bean4859
    (new com.amazonaws.services.rds.model.DescribeOptionGroupsRequest)]
   (clojure.core/let
    [v4861 (:filters m4860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4861 :com.palletops.awaze.client-builder/undef)
     (.
      bean4859
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5007] (rds/filter arg5007))
 v4861))))
   (clojure.core/let
    [v4861 (:marker m4860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4861 :com.palletops.awaze.client-builder/undef)
     (. bean4859 setMarker (clojure.core/str v4861))))
   (clojure.core/let
    [v4861
     (:option-group-name
      m4860
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4861 :com.palletops.awaze.client-builder/undef)
     (. bean4859 setOptionGroupName (clojure.core/str v4861))))
   (clojure.core/let
    [v4861
     (:engine-name m4860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4861 :com.palletops.awaze.client-builder/undef)
     (. bean4859 setEngineName (clojure.core/str v4861))))
   (clojure.core/let
    [v4861
     (:major-engine-version
      m4860
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4861 :com.palletops.awaze.client-builder/undef)
     (. bean4859 setMajorEngineVersion (clojure.core/str v4861))))
   (clojure.core/let
    [v4861
     (:max-records m4860 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4861 :com.palletops.awaze.client-builder/undef)
     (. bean4859 setMaxRecords (clojure.core/int v4861))))
   bean4859))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest}
create-dbinstance-read-replica-request
  [m4863]
  (clojure.core/let
   [bean4862
    (new
     com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest)]
   (clojure.core/let
    [v4864 (:port m4863 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4864 :com.palletops.awaze.client-builder/undef)
     (. bean4862 setPort (clojure.core/int v4864))))
   (clojure.core/let
    [v4864
     (:dbinstance-class
      m4863
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4864 :com.palletops.awaze.client-builder/undef)
     (. bean4862 setDBInstanceClass (clojure.core/str v4864))))
   (clojure.core/let
    [v4864
     (:auto-minor-version-upgrade
      m4863
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4864 :com.palletops.awaze.client-builder/undef)
     (.
      bean4862
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v4864))))
   (clojure.core/let
    [v4864
     (:availability-zone
      m4863
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4864 :com.palletops.awaze.client-builder/undef)
     (. bean4862 setAvailabilityZone (clojure.core/str v4864))))
   (clojure.core/let
    [v4864 (:iops m4863 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4864 :com.palletops.awaze.client-builder/undef)
     (. bean4862 setIops (clojure.core/int v4864))))
   (clojure.core/let
    [v4864
     (:dbsubnet-group-name
      m4863
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4864 :com.palletops.awaze.client-builder/undef)
     (. bean4862 setDBSubnetGroupName (clojure.core/str v4864))))
   (clojure.core/let
    [v4864
     (:publicly-accessible
      m4863
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4864 :com.palletops.awaze.client-builder/undef)
     (. bean4862 setPubliclyAccessible (clojure.core/boolean v4864))))
   (clojure.core/let
    [v4864
     (:option-group-name
      m4863
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4864 :com.palletops.awaze.client-builder/undef)
     (. bean4862 setOptionGroupName (clojure.core/str v4864))))
   (clojure.core/let
    [v4864
     (:source-dbinstance-identifier
      m4863
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4864 :com.palletops.awaze.client-builder/undef)
     (.
      bean4862
      setSourceDBInstanceIdentifier
      (clojure.core/str v4864))))
   (clojure.core/let
    [v4864 (:tags m4863 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4864 :com.palletops.awaze.client-builder/undef)
     (.
      bean4862
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5008] (rds/tag arg5008)) v4864))))
   (clojure.core/let
    [v4864
     (:dbinstance-identifier
      m4863
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4864 :com.palletops.awaze.client-builder/undef)
     (. bean4862 setDBInstanceIdentifier (clojure.core/str v4864))))
   bean4862))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest}
restore-dbinstance-from-dbsnapshot-request
  [m4866]
  (clojure.core/let
   [bean4865
    (new
     com.amazonaws.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest)]
   (clojure.core/let
    [v4867 (:port m4866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4867 :com.palletops.awaze.client-builder/undef)
     (. bean4865 setPort (clojure.core/int v4867))))
   (clojure.core/let
    [v4867
     (:dbinstance-class
      m4866
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4867 :com.palletops.awaze.client-builder/undef)
     (. bean4865 setDBInstanceClass (clojure.core/str v4867))))
   (clojure.core/let
    [v4867 (:engine m4866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4867 :com.palletops.awaze.client-builder/undef)
     (. bean4865 setEngine (clojure.core/str v4867))))
   (clojure.core/let
    [v4867
     (:auto-minor-version-upgrade
      m4866
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4867 :com.palletops.awaze.client-builder/undef)
     (.
      bean4865
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v4867))))
   (clojure.core/let
    [v4867
     (:availability-zone
      m4866
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4867 :com.palletops.awaze.client-builder/undef)
     (. bean4865 setAvailabilityZone (clojure.core/str v4867))))
   (clojure.core/let
    [v4867
     (:license-model m4866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4867 :com.palletops.awaze.client-builder/undef)
     (. bean4865 setLicenseModel (clojure.core/str v4867))))
   (clojure.core/let
    [v4867 (:iops m4866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4867 :com.palletops.awaze.client-builder/undef)
     (. bean4865 setIops (clojure.core/int v4867))))
   (clojure.core/let
    [v4867 (:dbname m4866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4867 :com.palletops.awaze.client-builder/undef)
     (. bean4865 setDBName (clojure.core/str v4867))))
   (clojure.core/let
    [v4867
     (:dbsnapshot-identifier
      m4866
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4867 :com.palletops.awaze.client-builder/undef)
     (. bean4865 setDBSnapshotIdentifier (clojure.core/str v4867))))
   (clojure.core/let
    [v4867
     (:dbsubnet-group-name
      m4866
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4867 :com.palletops.awaze.client-builder/undef)
     (. bean4865 setDBSubnetGroupName (clojure.core/str v4867))))
   (clojure.core/let
    [v4867
     (:publicly-accessible
      m4866
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4867 :com.palletops.awaze.client-builder/undef)
     (. bean4865 setPubliclyAccessible (clojure.core/boolean v4867))))
   (clojure.core/let
    [v4867
     (:multi-az m4866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4867 :com.palletops.awaze.client-builder/undef)
     (. bean4865 setMultiAZ (clojure.core/boolean v4867))))
   (clojure.core/let
    [v4867
     (:option-group-name
      m4866
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4867 :com.palletops.awaze.client-builder/undef)
     (. bean4865 setOptionGroupName (clojure.core/str v4867))))
   (clojure.core/let
    [v4867 (:tags m4866 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4867 :com.palletops.awaze.client-builder/undef)
     (.
      bean4865
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5009] (rds/tag arg5009)) v4867))))
   (clojure.core/let
    [v4867
     (:dbinstance-identifier
      m4866
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4867 :com.palletops.awaze.client-builder/undef)
     (. bean4865 setDBInstanceIdentifier (clojure.core/str v4867))))
   bean4865))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBParameterGroupRequest}
delete-dbparameter-group-request
  [m4869]
  (clojure.core/let
   [bean4868
    (new
     com.amazonaws.services.rds.model.DeleteDBParameterGroupRequest)]
   (clojure.core/let
    [v4870
     (:dbparameter-group-name
      m4869
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4870 :com.palletops.awaze.client-builder/undef)
     (. bean4868 setDBParameterGroupName (clojure.core/str v4870))))
   bean4868))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest}
describe-reserved-dbinstances-request
  [m4872]
  (clojure.core/let
   [bean4871
    (new
     com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest)]
   (clojure.core/let
    [v4873
     (:max-records m4872 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4873 :com.palletops.awaze.client-builder/undef)
     (. bean4871 setMaxRecords (clojure.core/int v4873))))
   (clojure.core/let
    [v4873
     (:offering-type m4872 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4873 :com.palletops.awaze.client-builder/undef)
     (. bean4871 setOfferingType (clojure.core/str v4873))))
   (clojure.core/let
    [v4873
     (:dbinstance-class
      m4872
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4873 :com.palletops.awaze.client-builder/undef)
     (. bean4871 setDBInstanceClass (clojure.core/str v4873))))
   (clojure.core/let
    [v4873
     (:product-description
      m4872
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4873 :com.palletops.awaze.client-builder/undef)
     (. bean4871 setProductDescription (clojure.core/str v4873))))
   (clojure.core/let
    [v4873
     (:multi-az m4872 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4873 :com.palletops.awaze.client-builder/undef)
     (. bean4871 setMultiAZ (clojure.core/boolean v4873))))
   (clojure.core/let
    [v4873
     (:duration m4872 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4873 :com.palletops.awaze.client-builder/undef)
     (. bean4871 setDuration (clojure.core/str v4873))))
   (clojure.core/let
    [v4873
     (:reserved-dbinstances-offering-id
      m4872
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4873 :com.palletops.awaze.client-builder/undef)
     (.
      bean4871
      setReservedDBInstancesOfferingId
      (clojure.core/str v4873))))
   (clojure.core/let
    [v4873
     (:reserved-dbinstance-id
      m4872
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4873 :com.palletops.awaze.client-builder/undef)
     (. bean4871 setReservedDBInstanceId (clojure.core/str v4873))))
   (clojure.core/let
    [v4873 (:filters m4872 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4873 :com.palletops.awaze.client-builder/undef)
     (.
      bean4871
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5010] (rds/filter arg5010))
 v4873))))
   (clojure.core/let
    [v4873 (:marker m4872 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4873 :com.palletops.awaze.client-builder/undef)
     (. bean4871 setMarker (clojure.core/str v4873))))
   bean4871))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBSecurityGroupRequest}
delete-dbsecurity-group-request
  [m4875]
  (clojure.core/let
   [bean4874
    (new
     com.amazonaws.services.rds.model.DeleteDBSecurityGroupRequest)]
   (clojure.core/let
    [v4876
     (:dbsecurity-group-name
      m4875
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4876 :com.palletops.awaze.client-builder/undef)
     (. bean4874 setDBSecurityGroupName (clojure.core/str v4876))))
   bean4874))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest}
describe-engine-default-parameters-request
  [m4878]
  (clojure.core/let
   [bean4877
    (new
     com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest)]
   (clojure.core/let
    [v4879 (:marker m4878 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4879 :com.palletops.awaze.client-builder/undef)
     (. bean4877 setMarker (clojure.core/str v4879))))
   (clojure.core/let
    [v4879
     (:dbparameter-group-family
      m4878
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4879 :com.palletops.awaze.client-builder/undef)
     (. bean4877 setDBParameterGroupFamily (clojure.core/str v4879))))
   (clojure.core/let
    [v4879
     (:max-records m4878 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4879 :com.palletops.awaze.client-builder/undef)
     (. bean4877 setMaxRecords (clojure.core/int v4879))))
   bean4877))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBParameterGroupRequest}
create-dbparameter-group-request
  [m4881]
  (clojure.core/let
   [bean4880
    (new
     com.amazonaws.services.rds.model.CreateDBParameterGroupRequest)]
   (clojure.core/let
    [v4882 (:tags m4881 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4882 :com.palletops.awaze.client-builder/undef)
     (.
      bean4880
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5011] (rds/tag arg5011)) v4882))))
   (clojure.core/let
    [v4882
     (:dbparameter-group-name
      m4881
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4882 :com.palletops.awaze.client-builder/undef)
     (. bean4880 setDBParameterGroupName (clojure.core/str v4882))))
   (clojure.core/let
    [v4882
     (:dbparameter-group-family
      m4881
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4882 :com.palletops.awaze.client-builder/undef)
     (. bean4880 setDBParameterGroupFamily (clojure.core/str v4882))))
   (clojure.core/let
    [v4882
     (:description m4881 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4882 :com.palletops.awaze.client-builder/undef)
     (. bean4880 setDescription (clojure.core/str v4882))))
   bean4880))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateEventSubscriptionRequest}
create-event-subscription-request
  [m4884]
  (clojure.core/let
   [bean4883
    (new
     com.amazonaws.services.rds.model.CreateEventSubscriptionRequest)]
   (clojure.core/let
    [v4885 (:tags m4884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4885 :com.palletops.awaze.client-builder/undef)
     (.
      bean4883
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5012] (rds/tag arg5012)) v4885))))
   (clojure.core/let
    [v4885 (:enabled m4884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4885 :com.palletops.awaze.client-builder/undef)
     (. bean4883 setEnabled (clojure.core/boolean v4885))))
   (clojure.core/let
    [v4885
     (:source-type m4884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4885 :com.palletops.awaze.client-builder/undef)
     (. bean4883 setSourceType (clojure.core/str v4885))))
   (clojure.core/let
    [v4885
     (:subscription-name
      m4884
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4885 :com.palletops.awaze.client-builder/undef)
     (. bean4883 setSubscriptionName (clojure.core/str v4885))))
   (clojure.core/let
    [v4885
     (:sns-topic-arn m4884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4885 :com.palletops.awaze.client-builder/undef)
     (. bean4883 setSnsTopicArn (clojure.core/str v4885))))
   (clojure.core/let
    [v4885
     (:source-ids m4884 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4885 :com.palletops.awaze.client-builder/undef)
     (.
      bean4883
      setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5013] (clojure.core/str arg5013))
 v4885))))
   (clojure.core/let
    [v4885
     (:event-categories
      m4884
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4885 :com.palletops.awaze.client-builder/undef)
     (.
      bean4883
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5014] (clojure.core/str arg5014))
 v4885))))
   bean4883))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest}
create-dbsecurity-group-request
  [m4887]
  (clojure.core/let
   [bean4886
    (new
     com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest)]
   (clojure.core/let
    [v4888 (:tags m4887 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4888 :com.palletops.awaze.client-builder/undef)
     (.
      bean4886
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5015] (rds/tag arg5015)) v4888))))
   (clojure.core/let
    [v4888
     (:dbsecurity-group-name
      m4887
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4888 :com.palletops.awaze.client-builder/undef)
     (. bean4886 setDBSecurityGroupName (clojure.core/str v4888))))
   (clojure.core/let
    [v4888
     (:dbsecurity-group-description
      m4887
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4888 :com.palletops.awaze.client-builder/undef)
     (.
      bean4886
      setDBSecurityGroupDescription
      (clojure.core/str v4888))))
   bean4886))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyEventSubscriptionRequest}
modify-event-subscription-request
  [m4890]
  (clojure.core/let
   [bean4889
    (new
     com.amazonaws.services.rds.model.ModifyEventSubscriptionRequest)]
   (clojure.core/let
    [v4891 (:enabled m4890 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4891 :com.palletops.awaze.client-builder/undef)
     (. bean4889 setEnabled (clojure.core/boolean v4891))))
   (clojure.core/let
    [v4891
     (:source-type m4890 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4891 :com.palletops.awaze.client-builder/undef)
     (. bean4889 setSourceType (clojure.core/str v4891))))
   (clojure.core/let
    [v4891
     (:subscription-name
      m4890
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4891 :com.palletops.awaze.client-builder/undef)
     (. bean4889 setSubscriptionName (clojure.core/str v4891))))
   (clojure.core/let
    [v4891
     (:sns-topic-arn m4890 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4891 :com.palletops.awaze.client-builder/undef)
     (. bean4889 setSnsTopicArn (clojure.core/str v4891))))
   (clojure.core/let
    [v4891
     (:event-categories
      m4890
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4891 :com.palletops.awaze.client-builder/undef)
     (.
      bean4889
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5016] (clojure.core/str arg5016))
 v4891))))
   bean4889))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteOptionGroupRequest}
delete-option-group-request
  [m4893]
  (clojure.core/let
   [bean4892
    (new com.amazonaws.services.rds.model.DeleteOptionGroupRequest)]
   (clojure.core/let
    [v4894
     (:option-group-name
      m4893
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4894 :com.palletops.awaze.client-builder/undef)
     (. bean4892 setOptionGroupName (clojure.core/str v4894))))
   bean4892))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DownloadDBLogFilePortionRequest}
download-dblog-file-portion-request
  [m4896]
  (clojure.core/let
   [bean4895
    (new
     com.amazonaws.services.rds.model.DownloadDBLogFilePortionRequest)]
   (clojure.core/let
    [v4897 (:marker m4896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (. bean4895 setMarker (clojure.core/str v4897))))
   (clojure.core/let
    [v4897
     (:dbinstance-identifier
      m4896
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (. bean4895 setDBInstanceIdentifier (clojure.core/str v4897))))
   (clojure.core/let
    [v4897
     (:log-file-name m4896 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (. bean4895 setLogFileName (clojure.core/str v4897))))
   (clojure.core/let
    [v4897
     (:number-of-lines
      m4896
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4897 :com.palletops.awaze.client-builder/undef)
     (. bean4895 setNumberOfLines (clojure.core/int v4897))))
   bean4895))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEventsRequest}
describe-events-request
  [m4899]
  (clojure.core/let
   [bean4898
    (new com.amazonaws.services.rds.model.DescribeEventsRequest)]
   (clojure.core/let
    [v4900 (:marker m4899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4900 :com.palletops.awaze.client-builder/undef)
     (. bean4898 setMarker (clojure.core/str v4900))))
   (clojure.core/let
    [v4900
     (:max-records m4899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4900 :com.palletops.awaze.client-builder/undef)
     (. bean4898 setMaxRecords (clojure.core/int v4900))))
   (clojure.core/let
    [v4900
     (:source-identifier
      m4899
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4900 :com.palletops.awaze.client-builder/undef)
     (. bean4898 setSourceIdentifier (clojure.core/str v4900))))
   (clojure.core/let
    [v4900
     (:source-type m4899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4900 :com.palletops.awaze.client-builder/undef)
     (. bean4898 setSourceType (rds/source-type v4900))))
   (clojure.core/let
    [v4900
     (:start-time m4899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4900 :com.palletops.awaze.client-builder/undef)
     (.
      bean4898
      setStartTime
      (com.palletops.awaze.common/to-date v4900))))
   (clojure.core/let
    [v4900
     (:end-time m4899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4900 :com.palletops.awaze.client-builder/undef)
     (.
      bean4898
      setEndTime
      (com.palletops.awaze.common/to-date v4900))))
   (clojure.core/let
    [v4900
     (:duration m4899 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4900 :com.palletops.awaze.client-builder/undef)
     (. bean4898 setDuration (clojure.core/int v4900))))
   (clojure.core/let
    [v4900
     (:event-categories
      m4899
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4900 :com.palletops.awaze.client-builder/undef)
     (.
      bean4898
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5017] (clojure.core/str arg5017))
 v4900))))
   bean4898))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest}
describe-reserved-dbinstances-offerings-request
  [m4902]
  (clojure.core/let
   [bean4901
    (new
     com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest)]
   (clojure.core/let
    [v4903 (:marker m4902 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4903 :com.palletops.awaze.client-builder/undef)
     (. bean4901 setMarker (clojure.core/str v4903))))
   (clojure.core/let
    [v4903
     (:dbinstance-class
      m4902
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4903 :com.palletops.awaze.client-builder/undef)
     (. bean4901 setDBInstanceClass (clojure.core/str v4903))))
   (clojure.core/let
    [v4903
     (:multi-az m4902 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4903 :com.palletops.awaze.client-builder/undef)
     (. bean4901 setMultiAZ (clojure.core/boolean v4903))))
   (clojure.core/let
    [v4903
     (:reserved-dbinstances-offering-id
      m4902
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4903 :com.palletops.awaze.client-builder/undef)
     (.
      bean4901
      setReservedDBInstancesOfferingId
      (clojure.core/str v4903))))
   (clojure.core/let
    [v4903
     (:product-description
      m4902
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4903 :com.palletops.awaze.client-builder/undef)
     (. bean4901 setProductDescription (clojure.core/str v4903))))
   (clojure.core/let
    [v4903
     (:max-records m4902 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4903 :com.palletops.awaze.client-builder/undef)
     (. bean4901 setMaxRecords (clojure.core/int v4903))))
   (clojure.core/let
    [v4903
     (:duration m4902 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4903 :com.palletops.awaze.client-builder/undef)
     (. bean4901 setDuration (clojure.core/str v4903))))
   (clojure.core/let
    [v4903
     (:offering-type m4902 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4903 :com.palletops.awaze.client-builder/undef)
     (. bean4901 setOfferingType (clojure.core/str v4903))))
   bean4901))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyOptionGroupRequest}
modify-option-group-request
  [m4905]
  (clojure.core/let
   [bean4904
    (new com.amazonaws.services.rds.model.ModifyOptionGroupRequest)]
   (clojure.core/let
    [v4906
     (:option-group-name
      m4905
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4906 :com.palletops.awaze.client-builder/undef)
     (. bean4904 setOptionGroupName (clojure.core/str v4906))))
   (clojure.core/let
    [v4906
     (:apply-immediately
      m4905
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4906 :com.palletops.awaze.client-builder/undef)
     (. bean4904 setApplyImmediately (clojure.core/boolean v4906))))
   (clojure.core/let
    [v4906
     (:options-to-include
      m4905
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4906 :com.palletops.awaze.client-builder/undef)
     (.
      bean4904
      setOptionsToInclude
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5018] (rds/option-configuration arg5018))
 v4906))))
   (clojure.core/let
    [v4906
     (:options-to-remove
      m4905
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4906 :com.palletops.awaze.client-builder/undef)
     (.
      bean4904
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5019] (clojure.core/str arg5019))
 v4906))))
   bean4904))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBInstancesRequest}
describe-dbinstances-request
  [m4908]
  (clojure.core/let
   [bean4907
    (new com.amazonaws.services.rds.model.DescribeDBInstancesRequest)]
   (clojure.core/let
    [v4909 (:filters m4908 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4909 :com.palletops.awaze.client-builder/undef)
     (.
      bean4907
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5020] (rds/filter arg5020))
 v4909))))
   (clojure.core/let
    [v4909 (:marker m4908 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4909 :com.palletops.awaze.client-builder/undef)
     (. bean4907 setMarker (clojure.core/str v4909))))
   (clojure.core/let
    [v4909
     (:dbinstance-identifier
      m4908
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4909 :com.palletops.awaze.client-builder/undef)
     (. bean4907 setDBInstanceIdentifier (clojure.core/str v4909))))
   (clojure.core/let
    [v4909
     (:max-records m4908 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4909 :com.palletops.awaze.client-builder/undef)
     (. bean4907 setMaxRecords (clojure.core/int v4909))))
   bean4907))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBSnapshotRequest}
create-dbsnapshot-request
  [m4911]
  (clojure.core/let
   [bean4910
    (new com.amazonaws.services.rds.model.CreateDBSnapshotRequest)]
   (clojure.core/let
    [v4912 (:tags m4911 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4912 :com.palletops.awaze.client-builder/undef)
     (.
      bean4910
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5021] (rds/tag arg5021)) v4912))))
   (clojure.core/let
    [v4912
     (:dbinstance-identifier
      m4911
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4912 :com.palletops.awaze.client-builder/undef)
     (. bean4910 setDBInstanceIdentifier (clojure.core/str v4912))))
   (clojure.core/let
    [v4912
     (:dbsnapshot-identifier
      m4911
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4912 :com.palletops.awaze.client-builder/undef)
     (. bean4910 setDBSnapshotIdentifier (clojure.core/str v4912))))
   bean4910))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest}
remove-source-identifier-from-subscription-request
  [m4914]
  (clojure.core/let
   [bean4913
    (new
     com.amazonaws.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest)]
   (clojure.core/let
    [v4915
     (:source-identifier
      m4914
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4915 :com.palletops.awaze.client-builder/undef)
     (. bean4913 setSourceIdentifier (clojure.core/str v4915))))
   (clojure.core/let
    [v4915
     (:subscription-name
      m4914
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4915 :com.palletops.awaze.client-builder/undef)
     (. bean4913 setSubscriptionName (clojure.core/str v4915))))
   bean4913))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateOptionGroupRequest}
create-option-group-request
  [m4917]
  (clojure.core/let
   [bean4916
    (new com.amazonaws.services.rds.model.CreateOptionGroupRequest)]
   (clojure.core/let
    [v4918 (:tags m4917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4918 :com.palletops.awaze.client-builder/undef)
     (.
      bean4916
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5022] (rds/tag arg5022)) v4918))))
   (clojure.core/let
    [v4918
     (:option-group-description
      m4917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4918 :com.palletops.awaze.client-builder/undef)
     (. bean4916 setOptionGroupDescription (clojure.core/str v4918))))
   (clojure.core/let
    [v4918
     (:option-group-name
      m4917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4918 :com.palletops.awaze.client-builder/undef)
     (. bean4916 setOptionGroupName (clojure.core/str v4918))))
   (clojure.core/let
    [v4918
     (:engine-name m4917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4918 :com.palletops.awaze.client-builder/undef)
     (. bean4916 setEngineName (clojure.core/str v4918))))
   (clojure.core/let
    [v4918
     (:major-engine-version
      m4917
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4918 :com.palletops.awaze.client-builder/undef)
     (. bean4916 setMajorEngineVersion (clojure.core/str v4918))))
   bean4916))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEventSubscriptionsRequest}
describe-event-subscriptions-request
  [m4920]
  (clojure.core/let
   [bean4919
    (new
     com.amazonaws.services.rds.model.DescribeEventSubscriptionsRequest)]
   (clojure.core/let
    [v4921 (:filters m4920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4921 :com.palletops.awaze.client-builder/undef)
     (.
      bean4919
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5023] (rds/filter arg5023))
 v4921))))
   (clojure.core/let
    [v4921 (:marker m4920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4921 :com.palletops.awaze.client-builder/undef)
     (. bean4919 setMarker (clojure.core/str v4921))))
   (clojure.core/let
    [v4921
     (:max-records m4920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4921 :com.palletops.awaze.client-builder/undef)
     (. bean4919 setMaxRecords (clojure.core/int v4921))))
   (clojure.core/let
    [v4921
     (:subscription-name
      m4920
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4921 :com.palletops.awaze.client-builder/undef)
     (. bean4919 setSubscriptionName (clojure.core/str v4921))))
   bean4919))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest}
describe-orderable-dbinstance-options-request
  [m4923]
  (clojure.core/let
   [bean4922
    (new
     com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest)]
   (clojure.core/let
    [v4924 (:marker m4923 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4924 :com.palletops.awaze.client-builder/undef)
     (. bean4922 setMarker (clojure.core/str v4924))))
   (clojure.core/let
    [v4924
     (:dbinstance-class
      m4923
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4924 :com.palletops.awaze.client-builder/undef)
     (. bean4922 setDBInstanceClass (clojure.core/str v4924))))
   (clojure.core/let
    [v4924 (:engine m4923 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4924 :com.palletops.awaze.client-builder/undef)
     (. bean4922 setEngine (clojure.core/str v4924))))
   (clojure.core/let
    [v4924
     (:engine-version m4923 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4924 :com.palletops.awaze.client-builder/undef)
     (. bean4922 setEngineVersion (clojure.core/str v4924))))
   (clojure.core/let
    [v4924
     (:license-model m4923 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4924 :com.palletops.awaze.client-builder/undef)
     (. bean4922 setLicenseModel (clojure.core/str v4924))))
   (clojure.core/let
    [v4924 (:vpc m4923 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4924 :com.palletops.awaze.client-builder/undef)
     (. bean4922 setVpc (clojure.core/boolean v4924))))
   (clojure.core/let
    [v4924
     (:max-records m4923 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4924 :com.palletops.awaze.client-builder/undef)
     (. bean4922 setMaxRecords (clojure.core/int v4924))))
   bean4922))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m4926]
  (clojure.core/let
   [bean4925
    (new com.amazonaws.services.rds.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v4927
     (:resource-name m4926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4927 :com.palletops.awaze.client-builder/undef)
     (. bean4925 setResourceName (clojure.core/str v4927))))
   bean4925))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyDBSubnetGroupRequest}
modify-dbsubnet-group-request
  [m4929]
  (clojure.core/let
   [bean4928
    (new com.amazonaws.services.rds.model.ModifyDBSubnetGroupRequest)]
   (clojure.core/let
    [v4930
     (:dbsubnet-group-name
      m4929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (. bean4928 setDBSubnetGroupName (clojure.core/str v4930))))
   (clojure.core/let
    [v4930
     (:dbsubnet-group-description
      m4929
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (. bean4928 setDBSubnetGroupDescription (clojure.core/str v4930))))
   (clojure.core/let
    [v4930
     (:subnet-ids m4929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4930 :com.palletops.awaze.client-builder/undef)
     (.
      bean4928
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5024] (clojure.core/str arg5024))
 v4930))))
   bean4928))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBLogFilesRequest}
describe-dblog-files-request
  [m4932]
  (clojure.core/let
   [bean4931
    (new com.amazonaws.services.rds.model.DescribeDBLogFilesRequest)]
   (clojure.core/let
    [v4933 (:marker m4932 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4933 :com.palletops.awaze.client-builder/undef)
     (. bean4931 setMarker (clojure.core/str v4933))))
   (clojure.core/let
    [v4933
     (:dbinstance-identifier
      m4932
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4933 :com.palletops.awaze.client-builder/undef)
     (. bean4931 setDBInstanceIdentifier (clojure.core/str v4933))))
   (clojure.core/let
    [v4933
     (:max-records m4932 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4933 :com.palletops.awaze.client-builder/undef)
     (. bean4931 setMaxRecords (clojure.core/int v4933))))
   (clojure.core/let
    [v4933
     (:filename-contains
      m4932
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4933 :com.palletops.awaze.client-builder/undef)
     (. bean4931 setFilenameContains (clojure.core/str v4933))))
   (clojure.core/let
    [v4933
     (:file-last-written
      m4932
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4933 :com.palletops.awaze.client-builder/undef)
     (. bean4931 setFileLastWritten (clojure.core/long v4933))))
   (clojure.core/let
    [v4933
     (:file-size m4932 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4933 :com.palletops.awaze.client-builder/undef)
     (. bean4931 setFileSize (clojure.core/long v4933))))
   bean4931))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.PromoteReadReplicaRequest}
promote-read-replica-request
  [m4935]
  (clojure.core/let
   [bean4934
    (new com.amazonaws.services.rds.model.PromoteReadReplicaRequest)]
   (clojure.core/let
    [v4936
     (:dbinstance-identifier
      m4935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4936 :com.palletops.awaze.client-builder/undef)
     (. bean4934 setDBInstanceIdentifier (clojure.core/str v4936))))
   (clojure.core/let
    [v4936
     (:backup-retention-period
      m4935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4936 :com.palletops.awaze.client-builder/undef)
     (. bean4934 setBackupRetentionPeriod (clojure.core/int v4936))))
   (clojure.core/let
    [v4936
     (:preferred-backup-window
      m4935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4936 :com.palletops.awaze.client-builder/undef)
     (. bean4934 setPreferredBackupWindow (clojure.core/str v4936))))
   bean4934))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBSubnetGroupRequest}
delete-dbsubnet-group-request
  [m4938]
  (clojure.core/let
   [bean4937
    (new com.amazonaws.services.rds.model.DeleteDBSubnetGroupRequest)]
   (clojure.core/let
    [v4939
     (:dbsubnet-group-name
      m4938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4939 :com.palletops.awaze.client-builder/undef)
     (. bean4937 setDBSubnetGroupName (clojure.core/str v4939))))
   bean4937))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest}
describe-dbsnapshots-request
  [m4941]
  (clojure.core/let
   [bean4940
    (new com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest)]
   (clojure.core/let
    [v4942 (:filters m4941 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4942 :com.palletops.awaze.client-builder/undef)
     (.
      bean4940
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5025] (rds/filter arg5025))
 v4942))))
   (clojure.core/let
    [v4942 (:marker m4941 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4942 :com.palletops.awaze.client-builder/undef)
     (. bean4940 setMarker (clojure.core/str v4942))))
   (clojure.core/let
    [v4942
     (:dbinstance-identifier
      m4941
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4942 :com.palletops.awaze.client-builder/undef)
     (. bean4940 setDBInstanceIdentifier (clojure.core/str v4942))))
   (clojure.core/let
    [v4942
     (:dbsnapshot-identifier
      m4941
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4942 :com.palletops.awaze.client-builder/undef)
     (. bean4940 setDBSnapshotIdentifier (clojure.core/str v4942))))
   (clojure.core/let
    [v4942
     (:max-records m4941 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4942 :com.palletops.awaze.client-builder/undef)
     (. bean4940 setMaxRecords (clojure.core/int v4942))))
   (clojure.core/let
    [v4942
     (:snapshot-type m4941 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4942 :com.palletops.awaze.client-builder/undef)
     (. bean4940 setSnapshotType (clojure.core/str v4942))))
   bean4940))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.AddSourceIdentifierToSubscriptionRequest}
add-source-identifier-to-subscription-request
  [m4944]
  (clojure.core/let
   [bean4943
    (new
     com.amazonaws.services.rds.model.AddSourceIdentifierToSubscriptionRequest)]
   (clojure.core/let
    [v4945
     (:source-identifier
      m4944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4945 :com.palletops.awaze.client-builder/undef)
     (. bean4943 setSourceIdentifier (clojure.core/str v4945))))
   (clojure.core/let
    [v4945
     (:subscription-name
      m4944
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4945 :com.palletops.awaze.client-builder/undef)
     (. bean4943 setSubscriptionName (clojure.core/str v4945))))
   bean4943))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RemoveTagsFromResourceRequest}
remove-tags-from-resource-request
  [m4947]
  (clojure.core/let
   [bean4946
    (new
     com.amazonaws.services.rds.model.RemoveTagsFromResourceRequest)]
   (clojure.core/let
    [v4948
     (:tag-keys m4947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4948 :com.palletops.awaze.client-builder/undef)
     (.
      bean4946
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5026] (clojure.core/str arg5026))
 v4948))))
   (clojure.core/let
    [v4948
     (:resource-name m4947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4948 :com.palletops.awaze.client-builder/undef)
     (. bean4946 setResourceName (clojure.core/str v4948))))
   bean4946))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyDBInstanceRequest}
modify-dbinstance-request
  [m4950]
  (clojure.core/let
   [bean4949
    (new com.amazonaws.services.rds.model.ModifyDBInstanceRequest)]
   (clojure.core/let
    [v4951
     (:vpc-security-group-ids
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (.
      bean4949
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5027] (clojure.core/str arg5027))
 v4951))))
   (clojure.core/let
    [v4951
     (:dbparameter-group-name
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (. bean4949 setDBParameterGroupName (clojure.core/str v4951))))
   (clojure.core/let
    [v4951
     (:dbinstance-class
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (. bean4949 setDBInstanceClass (clojure.core/str v4951))))
   (clojure.core/let
    [v4951
     (:preferred-maintenance-window
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (.
      bean4949
      setPreferredMaintenanceWindow
      (clojure.core/str v4951))))
   (clojure.core/let
    [v4951
     (:auto-minor-version-upgrade
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (.
      bean4949
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v4951))))
   (clojure.core/let
    [v4951
     (:master-user-password
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (. bean4949 setMasterUserPassword (clojure.core/str v4951))))
   (clojure.core/let
    [v4951 (:iops m4950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (. bean4949 setIops (clojure.core/int v4951))))
   (clojure.core/let
    [v4951
     (:multi-az m4950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (. bean4949 setMultiAZ (clojure.core/boolean v4951))))
   (clojure.core/let
    [v4951
     (:preferred-backup-window
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (. bean4949 setPreferredBackupWindow (clojure.core/str v4951))))
   (clojure.core/let
    [v4951
     (:apply-immediately
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (. bean4949 setApplyImmediately (clojure.core/boolean v4951))))
   (clojure.core/let
    [v4951
     (:option-group-name
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (. bean4949 setOptionGroupName (clojure.core/str v4951))))
   (clojure.core/let
    [v4951
     (:dbsecurity-groups
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (.
      bean4949
      setDBSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5028] (clojure.core/str arg5028))
 v4951))))
   (clojure.core/let
    [v4951
     (:engine-version m4950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (. bean4949 setEngineVersion (clojure.core/str v4951))))
   (clojure.core/let
    [v4951
     (:allocated-storage
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (. bean4949 setAllocatedStorage (clojure.core/int v4951))))
   (clojure.core/let
    [v4951
     (:allow-major-version-upgrade
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (.
      bean4949
      setAllowMajorVersionUpgrade
      (clojure.core/boolean v4951))))
   (clojure.core/let
    [v4951
     (:new-dbinstance-identifier
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (. bean4949 setNewDBInstanceIdentifier (clojure.core/str v4951))))
   (clojure.core/let
    [v4951
     (:backup-retention-period
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (. bean4949 setBackupRetentionPeriod (clojure.core/int v4951))))
   (clojure.core/let
    [v4951
     (:dbinstance-identifier
      m4950
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4951 :com.palletops.awaze.client-builder/undef)
     (. bean4949 setDBInstanceIdentifier (clojure.core/str v4951))))
   bean4949))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBEngineVersionsRequest}
describe-dbengine-versions-request
  [m4953]
  (clojure.core/let
   [bean4952
    (new
     com.amazonaws.services.rds.model.DescribeDBEngineVersionsRequest)]
   (clojure.core/let
    [v4954 (:marker m4953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4954 :com.palletops.awaze.client-builder/undef)
     (. bean4952 setMarker (clojure.core/str v4954))))
   (clojure.core/let
    [v4954 (:engine m4953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4954 :com.palletops.awaze.client-builder/undef)
     (. bean4952 setEngine (clojure.core/str v4954))))
   (clojure.core/let
    [v4954
     (:engine-version m4953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4954 :com.palletops.awaze.client-builder/undef)
     (. bean4952 setEngineVersion (clojure.core/str v4954))))
   (clojure.core/let
    [v4954
     (:dbparameter-group-family
      m4953
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4954 :com.palletops.awaze.client-builder/undef)
     (. bean4952 setDBParameterGroupFamily (clojure.core/str v4954))))
   (clojure.core/let
    [v4954
     (:default-only m4953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4954 :com.palletops.awaze.client-builder/undef)
     (. bean4952 setDefaultOnly (clojure.core/boolean v4954))))
   (clojure.core/let
    [v4954
     (:list-supported-character-sets
      m4953
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4954 :com.palletops.awaze.client-builder/undef)
     (.
      bean4952
      setListSupportedCharacterSets
      (clojure.core/boolean v4954))))
   (clojure.core/let
    [v4954
     (:max-records m4953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4954 :com.palletops.awaze.client-builder/undef)
     (. bean4952 setMaxRecords (clojure.core/int v4954))))
   bean4952))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RebootDBInstanceRequest}
reboot-dbinstance-request
  [m4956]
  (clojure.core/let
   [bean4955
    (new com.amazonaws.services.rds.model.RebootDBInstanceRequest)]
   (clojure.core/let
    [v4957
     (:dbinstance-identifier
      m4956
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4957 :com.palletops.awaze.client-builder/undef)
     (. bean4955 setDBInstanceIdentifier (clojure.core/str v4957))))
   (clojure.core/let
    [v4957
     (:force-failover m4956 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4957 :com.palletops.awaze.client-builder/undef)
     (. bean4955 setForceFailover (clojure.core/boolean v4957))))
   bean4955))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeOptionGroupOptionsRequest}
describe-option-group-options-request
  [m4959]
  (clojure.core/let
   [bean4958
    (new
     com.amazonaws.services.rds.model.DescribeOptionGroupOptionsRequest)]
   (clojure.core/let
    [v4960 (:marker m4959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4960 :com.palletops.awaze.client-builder/undef)
     (. bean4958 setMarker (clojure.core/str v4960))))
   (clojure.core/let
    [v4960
     (:engine-name m4959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4960 :com.palletops.awaze.client-builder/undef)
     (. bean4958 setEngineName (clojure.core/str v4960))))
   (clojure.core/let
    [v4960
     (:major-engine-version
      m4959
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4960 :com.palletops.awaze.client-builder/undef)
     (. bean4958 setMajorEngineVersion (clojure.core/str v4960))))
   (clojure.core/let
    [v4960
     (:max-records m4959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4960 :com.palletops.awaze.client-builder/undef)
     (. bean4958 setMaxRecords (clojure.core/int v4960))))
   bean4958))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBInstanceRequest}
create-dbinstance-request
  [m4962]
  (clojure.core/let
   [bean4961
    (new com.amazonaws.services.rds.model.CreateDBInstanceRequest)]
   (clojure.core/let
    [v4963
     (:vpc-security-group-ids
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (.
      bean4961
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5029] (clojure.core/str arg5029))
 v4963))))
   (clojure.core/let
    [v4963
     (:dbparameter-group-name
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setDBParameterGroupName (clojure.core/str v4963))))
   (clojure.core/let
    [v4963 (:port m4962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setPort (clojure.core/int v4963))))
   (clojure.core/let
    [v4963
     (:dbinstance-class
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setDBInstanceClass (clojure.core/str v4963))))
   (clojure.core/let
    [v4963
     (:preferred-maintenance-window
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (.
      bean4961
      setPreferredMaintenanceWindow
      (clojure.core/str v4963))))
   (clojure.core/let
    [v4963 (:engine m4962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setEngine (clojure.core/str v4963))))
   (clojure.core/let
    [v4963
     (:character-set-name
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setCharacterSetName (clojure.core/str v4963))))
   (clojure.core/let
    [v4963
     (:auto-minor-version-upgrade
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (.
      bean4961
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v4963))))
   (clojure.core/let
    [v4963
     (:availability-zone
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setAvailabilityZone (clojure.core/str v4963))))
   (clojure.core/let
    [v4963
     (:license-model m4962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setLicenseModel (clojure.core/str v4963))))
   (clojure.core/let
    [v4963
     (:master-user-password
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setMasterUserPassword (clojure.core/str v4963))))
   (clojure.core/let
    [v4963 (:iops m4962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setIops (clojure.core/int v4963))))
   (clojure.core/let
    [v4963 (:dbname m4962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setDBName (clojure.core/str v4963))))
   (clojure.core/let
    [v4963
     (:dbsubnet-group-name
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setDBSubnetGroupName (clojure.core/str v4963))))
   (clojure.core/let
    [v4963
     (:publicly-accessible
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setPubliclyAccessible (clojure.core/boolean v4963))))
   (clojure.core/let
    [v4963
     (:multi-az m4962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setMultiAZ (clojure.core/boolean v4963))))
   (clojure.core/let
    [v4963
     (:preferred-backup-window
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setPreferredBackupWindow (clojure.core/str v4963))))
   (clojure.core/let
    [v4963
     (:option-group-name
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setOptionGroupName (clojure.core/str v4963))))
   (clojure.core/let
    [v4963
     (:dbsecurity-groups
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (.
      bean4961
      setDBSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5030] (clojure.core/str arg5030))
 v4963))))
   (clojure.core/let
    [v4963
     (:engine-version m4962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setEngineVersion (clojure.core/str v4963))))
   (clojure.core/let
    [v4963
     (:allocated-storage
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setAllocatedStorage (clojure.core/int v4963))))
   (clojure.core/let
    [v4963
     (:master-username
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setMasterUsername (clojure.core/str v4963))))
   (clojure.core/let
    [v4963
     (:backup-retention-period
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setBackupRetentionPeriod (clojure.core/int v4963))))
   (clojure.core/let
    [v4963 (:tags m4962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (.
      bean4961
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5031] (rds/tag arg5031)) v4963))))
   (clojure.core/let
    [v4963
     (:dbinstance-identifier
      m4962
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4963 :com.palletops.awaze.client-builder/undef)
     (. bean4961 setDBInstanceIdentifier (clojure.core/str v4963))))
   bean4961))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBSubnetGroupsRequest}
describe-dbsubnet-groups-request
  [m4965]
  (clojure.core/let
   [bean4964
    (new
     com.amazonaws.services.rds.model.DescribeDBSubnetGroupsRequest)]
   (clojure.core/let
    [v4966 (:filters m4965 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4966 :com.palletops.awaze.client-builder/undef)
     (.
      bean4964
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5032] (rds/filter arg5032))
 v4966))))
   (clojure.core/let
    [v4966 (:marker m4965 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4966 :com.palletops.awaze.client-builder/undef)
     (. bean4964 setMarker (clojure.core/str v4966))))
   (clojure.core/let
    [v4966
     (:dbsubnet-group-name
      m4965
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4966 :com.palletops.awaze.client-builder/undef)
     (. bean4964 setDBSubnetGroupName (clojure.core/str v4966))))
   (clojure.core/let
    [v4966
     (:max-records m4965 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4966 :com.palletops.awaze.client-builder/undef)
     (. bean4964 setMaxRecords (clojure.core/int v4966))))
   bean4964))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteEventSubscriptionRequest}
delete-event-subscription-request
  [m4968]
  (clojure.core/let
   [bean4967
    (new
     com.amazonaws.services.rds.model.DeleteEventSubscriptionRequest)]
   (clojure.core/let
    [v4969
     (:subscription-name
      m4968
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4969 :com.palletops.awaze.client-builder/undef)
     (. bean4967 setSubscriptionName (clojure.core/str v4969))))
   bean4967))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBParameterGroupsRequest}
describe-dbparameter-groups-request
  [m4971]
  (clojure.core/let
   [bean4970
    (new
     com.amazonaws.services.rds.model.DescribeDBParameterGroupsRequest)]
   (clojure.core/let
    [v4972 (:filters m4971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4972 :com.palletops.awaze.client-builder/undef)
     (.
      bean4970
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5033] (rds/filter arg5033))
 v4972))))
   (clojure.core/let
    [v4972 (:marker m4971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4972 :com.palletops.awaze.client-builder/undef)
     (. bean4970 setMarker (clojure.core/str v4972))))
   (clojure.core/let
    [v4972
     (:dbparameter-group-name
      m4971
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4972 :com.palletops.awaze.client-builder/undef)
     (. bean4970 setDBParameterGroupName (clojure.core/str v4972))))
   (clojure.core/let
    [v4972
     (:max-records m4971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4972 :com.palletops.awaze.client-builder/undef)
     (. bean4970 setMaxRecords (clojure.core/int v4972))))
   bean4970))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ResetDBParameterGroupRequest}
reset-dbparameter-group-request
  [m4974]
  (clojure.core/let
   [bean4973
    (new
     com.amazonaws.services.rds.model.ResetDBParameterGroupRequest)]
   (clojure.core/let
    [v4975
     (:parameters m4974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4975 :com.palletops.awaze.client-builder/undef)
     (.
      bean4973
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5034] (rds/parameter arg5034))
 v4975))))
   (clojure.core/let
    [v4975
     (:dbparameter-group-name
      m4974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4975 :com.palletops.awaze.client-builder/undef)
     (. bean4973 setDBParameterGroupName (clojure.core/str v4975))))
   (clojure.core/let
    [v4975
     (:reset-all-parameters
      m4974
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4975 :com.palletops.awaze.client-builder/undef)
     (. bean4973 setResetAllParameters (clojure.core/boolean v4975))))
   bean4973))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest}
restore-dbinstance-to-point-in-time-request
  [m4977]
  (clojure.core/let
   [bean4976
    (new
     com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest)]
   (clojure.core/let
    [v4978 (:port m4977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (. bean4976 setPort (clojure.core/int v4978))))
   (clojure.core/let
    [v4978
     (:dbinstance-class
      m4977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (. bean4976 setDBInstanceClass (clojure.core/str v4978))))
   (clojure.core/let
    [v4978 (:engine m4977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (. bean4976 setEngine (clojure.core/str v4978))))
   (clojure.core/let
    [v4978
     (:auto-minor-version-upgrade
      m4977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (.
      bean4976
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v4978))))
   (clojure.core/let
    [v4978
     (:availability-zone
      m4977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (. bean4976 setAvailabilityZone (clojure.core/str v4978))))
   (clojure.core/let
    [v4978
     (:license-model m4977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (. bean4976 setLicenseModel (clojure.core/str v4978))))
   (clojure.core/let
    [v4978
     (:use-latest-restorable-time
      m4977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (.
      bean4976
      setUseLatestRestorableTime
      (clojure.core/boolean v4978))))
   (clojure.core/let
    [v4978 (:iops m4977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (. bean4976 setIops (clojure.core/int v4978))))
   (clojure.core/let
    [v4978 (:dbname m4977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (. bean4976 setDBName (clojure.core/str v4978))))
   (clojure.core/let
    [v4978
     (:dbsubnet-group-name
      m4977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (. bean4976 setDBSubnetGroupName (clojure.core/str v4978))))
   (clojure.core/let
    [v4978
     (:publicly-accessible
      m4977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (. bean4976 setPubliclyAccessible (clojure.core/boolean v4978))))
   (clojure.core/let
    [v4978
     (:target-dbinstance-identifier
      m4977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (.
      bean4976
      setTargetDBInstanceIdentifier
      (clojure.core/str v4978))))
   (clojure.core/let
    [v4978
     (:multi-az m4977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (. bean4976 setMultiAZ (clojure.core/boolean v4978))))
   (clojure.core/let
    [v4978
     (:option-group-name
      m4977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (. bean4976 setOptionGroupName (clojure.core/str v4978))))
   (clojure.core/let
    [v4978
     (:restore-time m4977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (.
      bean4976
      setRestoreTime
      (com.palletops.awaze.common/to-date v4978))))
   (clojure.core/let
    [v4978
     (:source-dbinstance-identifier
      m4977
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (.
      bean4976
      setSourceDBInstanceIdentifier
      (clojure.core/str v4978))))
   (clojure.core/let
    [v4978 (:tags m4977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4978 :com.palletops.awaze.client-builder/undef)
     (.
      bean4976
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5035] (rds/tag arg5035)) v4978))))
   bean4976))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest}
modify-dbparameter-group-request
  [m4980]
  (clojure.core/let
   [bean4979
    (new
     com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest)]
   (clojure.core/let
    [v4981
     (:parameters m4980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4981 :com.palletops.awaze.client-builder/undef)
     (.
      bean4979
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5036] (rds/parameter arg5036))
 v4981))))
   (clojure.core/let
    [v4981
     (:dbparameter-group-name
      m4980
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4981 :com.palletops.awaze.client-builder/undef)
     (. bean4979 setDBParameterGroupName (clojure.core/str v4981))))
   bean4979))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBInstanceRequest}
delete-dbinstance-request
  [m4983]
  (clojure.core/let
   [bean4982
    (new com.amazonaws.services.rds.model.DeleteDBInstanceRequest)]
   (clojure.core/let
    [v4984
     (:dbinstance-identifier
      m4983
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4984 :com.palletops.awaze.client-builder/undef)
     (. bean4982 setDBInstanceIdentifier (clojure.core/str v4984))))
   (clojure.core/let
    [v4984
     (:skip-final-snapshot
      m4983
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4984 :com.palletops.awaze.client-builder/undef)
     (. bean4982 setSkipFinalSnapshot (clojure.core/boolean v4984))))
   (clojure.core/let
    [v4984
     (:final-dbsnapshot-identifier
      m4983
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4984 :com.palletops.awaze.client-builder/undef)
     (.
      bean4982
      setFinalDBSnapshotIdentifier
      (clojure.core/str v4984))))
   bean4982))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEventCategoriesRequest}
describe-event-categories-request
  [m4986]
  (clojure.core/let
   [bean4985
    (new
     com.amazonaws.services.rds.model.DescribeEventCategoriesRequest)]
   (clojure.core/let
    [v4987
     (:source-type m4986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4987 :com.palletops.awaze.client-builder/undef)
     (. bean4985 setSourceType (clojure.core/str v4987))))
   bean4985))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest}
authorize-dbsecurity-group-ingress-request
  [m4989]
  (clojure.core/let
   [bean4988
    (new
     com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest)]
   (clojure.core/let
    [v4990
     (:dbsecurity-group-name
      m4989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4990 :com.palletops.awaze.client-builder/undef)
     (. bean4988 setDBSecurityGroupName (clojure.core/str v4990))))
   (clojure.core/let
    [v4990
     (:ec2security-group-id
      m4989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4990 :com.palletops.awaze.client-builder/undef)
     (. bean4988 setEC2SecurityGroupId (clojure.core/str v4990))))
   (clojure.core/let
    [v4990 (:cidrip m4989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4990 :com.palletops.awaze.client-builder/undef)
     (. bean4988 setCIDRIP (clojure.core/str v4990))))
   (clojure.core/let
    [v4990
     (:ec2security-group-name
      m4989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4990 :com.palletops.awaze.client-builder/undef)
     (. bean4988 setEC2SecurityGroupName (clojure.core/str v4990))))
   (clojure.core/let
    [v4990
     (:ec2security-group-owner-id
      m4989
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4990 :com.palletops.awaze.client-builder/undef)
     (. bean4988 setEC2SecurityGroupOwnerId (clojure.core/str v4990))))
   bean4988))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CopyDBSnapshotRequest}
copy-dbsnapshot-request
  [m4992]
  (clojure.core/let
   [bean4991
    (new com.amazonaws.services.rds.model.CopyDBSnapshotRequest)]
   (clojure.core/let
    [v4993 (:tags m4992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4993 :com.palletops.awaze.client-builder/undef)
     (.
      bean4991
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5037] (rds/tag arg5037)) v4993))))
   (clojure.core/let
    [v4993
     (:source-dbsnapshot-identifier
      m4992
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4993 :com.palletops.awaze.client-builder/undef)
     (.
      bean4991
      setSourceDBSnapshotIdentifier
      (clojure.core/str v4993))))
   (clojure.core/let
    [v4993
     (:target-dbsnapshot-identifier
      m4992
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4993 :com.palletops.awaze.client-builder/undef)
     (.
      bean4991
      setTargetDBSnapshotIdentifier
      (clojure.core/str v4993))))
   bean4991))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBSnapshotRequest}
delete-dbsnapshot-request
  [m4995]
  (clojure.core/let
   [bean4994
    (new com.amazonaws.services.rds.model.DeleteDBSnapshotRequest)]
   (clojure.core/let
    [v4996
     (:dbsnapshot-identifier
      m4995
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4996 :com.palletops.awaze.client-builder/undef)
     (. bean4994 setDBSnapshotIdentifier (clojure.core/str v4996))))
   bean4994))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest}
create-dbsubnet-group-request
  [m4998]
  (clojure.core/let
   [bean4997
    (new com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest)]
   (clojure.core/let
    [v4999 (:tags m4998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4999 :com.palletops.awaze.client-builder/undef)
     (.
      bean4997
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5038] (rds/tag arg5038)) v4999))))
   (clojure.core/let
    [v4999
     (:dbsubnet-group-name
      m4998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4999 :com.palletops.awaze.client-builder/undef)
     (. bean4997 setDBSubnetGroupName (clojure.core/str v4999))))
   (clojure.core/let
    [v4999
     (:dbsubnet-group-description
      m4998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4999 :com.palletops.awaze.client-builder/undef)
     (. bean4997 setDBSubnetGroupDescription (clojure.core/str v4999))))
   (clojure.core/let
    [v4999
     (:subnet-ids m4998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4999 :com.palletops.awaze.client-builder/undef)
     (.
      bean4997
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5039] (clojure.core/str arg5039))
 v4999))))
   bean4997))
 (clojure.core/defmulti
  rds
  (clojure.core/fn rds [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   rds
   :revoke-dbsecurity-group-ingress
   [m5040]
   (clojure.core/let
    [credentials5041 (:credentials m5040) args5042 (:args m5040)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5043
      (com.palletops.awaze.common/aws-client :rds credentials5041)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5043
       revokeDBSecurityGroupIngress
       (rds/revoke-dbsecurity-group-ingress-request
        (clojure.core/nth args5042 0)))))))
  (clojure.core/defn
   revoke-dbsecurity-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cidrip
                         ec2security-group-id
                         ec2security-group-owner-id
                         ec2security-group-name
                         dbsecurity-group-name
                         general-progress-listener]}]]),
    :doc "Generate map for revokeDBSecurityGroupIngress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :revoke-dbsecurity-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   revoke-dbsecurity-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cidrip
                         ec2security-group-id
                         ec2security-group-owner-id
                         ec2security-group-name
                         dbsecurity-group-name
                         general-progress-listener]}]]),
    :doc "Call revokeDBSecurityGroupIngress"}
   [credentials5045 & args5046]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5047
     (com.palletops.awaze.common/aws-client :rds credentials5045)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5047
      revokeDBSecurityGroupIngress
      (rds/revoke-dbsecurity-group-ingress-request
       (clojure.core/nth args5046 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :add-tags-to-resource
   [m5048]
   (clojure.core/let
    [credentials5049 (:credentials m5048) args5050 (:args m5048)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5051
      (com.palletops.awaze.common/aws-client :rds credentials5049)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5051
       addTagsToResource
       (rds/add-tags-to-resource-request
        (clojure.core/nth args5050 0)))))))
  (clojure.core/defn
   add-tags-to-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tags resource-name general-progress-listener]}]]),
    :doc "Generate map for addTagsToResource"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :add-tags-to-resource,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-tags-to-resource
   {:arglists (quote
               [[credentials
                 {:keys [tags resource-name general-progress-listener]}]]),
    :doc "Call addTagsToResource"}
   [credentials5053 & args5054]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5055
     (com.palletops.awaze.common/aws-client :rds credentials5053)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5055
      addTagsToResource
      (rds/add-tags-to-resource-request (clojure.core/nth args5054 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsecurity-groups
   [m5056]
   (clojure.core/let
    [credentials5057 (:credentials m5056) args5058 (:args m5056)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5059
      (com.palletops.awaze.common/aws-client :rds credentials5057)]
     (clojure.core/case
      (clojure.core/count args5058)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5059
        describeDBSecurityGroups
        (rds/describe-dbsecurity-groups-request
         (clojure.core/nth args5058 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5059
        describeDBSecurityGroups))))))
  (clojure.core/defn
   describe-dbsecurity-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbsecurity-group-name]}]
                [credentials]]),
    :doc "Generate map for describeDBSecurityGroups, describeDBSecurityGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbsecurity-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbsecurity-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dbsecurity-groups
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbsecurity-group-name]}]
                [credentials]]),
    :doc "Call describeDBSecurityGroups, describeDBSecurityGroups"}
   [credentials5061 & args5062]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5063
     (com.palletops.awaze.common/aws-client :rds credentials5061)]
    (clojure.core/case
     (clojure.core/count args5062)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5063
       describeDBSecurityGroups
       (rds/describe-dbsecurity-groups-request
        (clojure.core/nth args5062 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5063
       describeDBSecurityGroups))))))
 (do
  (clojure.core/defmethod
   rds
   :purchase-reserved-dbinstances-offering
   [m5064]
   (clojure.core/let
    [credentials5065 (:credentials m5064) args5066 (:args m5064)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5067
      (com.palletops.awaze.common/aws-client :rds credentials5065)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5067
       purchaseReservedDBInstancesOffering
       (rds/purchase-reserved-dbinstances-offering-request
        (clojure.core/nth args5066 0)))))))
  (clojure.core/defn
   purchase-reserved-dbinstances-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         reserved-dbinstances-offering-id
                         reserved-dbinstance-id
                         general-progress-listener
                         dbinstance-count]}]]),
    :doc "Generate map for purchaseReservedDBInstancesOffering"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :purchase-reserved-dbinstances-offering,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   purchase-reserved-dbinstances-offering
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         reserved-dbinstances-offering-id
                         reserved-dbinstance-id
                         general-progress-listener
                         dbinstance-count]}]]),
    :doc "Call purchaseReservedDBInstancesOffering"}
   [credentials5069 & args5070]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5071
     (com.palletops.awaze.common/aws-client :rds credentials5069)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5071
      purchaseReservedDBInstancesOffering
      (rds/purchase-reserved-dbinstances-offering-request
       (clojure.core/nth args5070 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbparameters
   [m5072]
   (clojure.core/let
    [credentials5073 (:credentials m5072) args5074 (:args m5072)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5075
      (com.palletops.awaze.common/aws-client :rds credentials5073)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5075
       describeDBParameters
       (rds/describe-dbparameters-request
        (clojure.core/nth args5074 0)))))))
  (clojure.core/defn
   describe-dbparameters-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         max-records
                         marker
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Generate map for describeDBParameters"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbparameters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dbparameters
   {:arglists (quote
               [[credentials
                 {:keys [source
                         max-records
                         marker
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Call describeDBParameters"}
   [credentials5077 & args5078]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5079
     (com.palletops.awaze.common/aws-client :rds credentials5077)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5079
      describeDBParameters
      (rds/describe-dbparameters-request
       (clojure.core/nth args5078 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-option-groups
   [m5080]
   (clojure.core/let
    [credentials5081 (:credentials m5080) args5082 (:args m5080)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5083
      (com.palletops.awaze.common/aws-client :rds credentials5081)]
     (clojure.core/case
      (clojure.core/count args5082)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5083
        describeOptionGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5083
        describeOptionGroups
        (rds/describe-option-groups-request
         (clojure.core/nth args5082 0))))))))
  (clojure.core/defn
   describe-option-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         engine-name
                         major-engine-version
                         max-records
                         marker
                         option-group-name]}]]),
    :doc "Generate map for describeOptionGroups, describeOptionGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-option-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-option-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-option-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         engine-name
                         major-engine-version
                         max-records
                         marker
                         option-group-name]}]]),
    :doc "Call describeOptionGroups, describeOptionGroups"}
   [credentials5085 & args5086]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5087
     (com.palletops.awaze.common/aws-client :rds credentials5085)]
    (clojure.core/case
     (clojure.core/count args5086)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5087
       describeOptionGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5087
       describeOptionGroups
       (rds/describe-option-groups-request
        (clojure.core/nth args5086 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbinstance-read-replica
   [m5088]
   (clojure.core/let
    [credentials5089 (:credentials m5088) args5090 (:args m5088)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5091
      (com.palletops.awaze.common/aws-client :rds credentials5089)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5091
       createDBInstanceReadReplica
       (rds/create-dbinstance-read-replica-request
        (clojure.core/nth args5090 0)))))))
  (clojure.core/defn
   create-dbinstance-read-replica-map
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         iops
                         general-progress-listener
                         availability-zone
                         dbinstance-class
                         port
                         dbsubnet-group-name
                         dbinstance-identifier
                         source-dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Generate map for createDBInstanceReadReplica"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbinstance-read-replica,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-dbinstance-read-replica
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         iops
                         general-progress-listener
                         availability-zone
                         dbinstance-class
                         port
                         dbsubnet-group-name
                         dbinstance-identifier
                         source-dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Call createDBInstanceReadReplica"}
   [credentials5093 & args5094]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5095
     (com.palletops.awaze.common/aws-client :rds credentials5093)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5095
      createDBInstanceReadReplica
      (rds/create-dbinstance-read-replica-request
       (clojure.core/nth args5094 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :restore-dbinstance-from-dbsnapshot
   [m5096]
   (clojure.core/let
    [credentials5097 (:credentials m5096) args5098 (:args m5096)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5099
      (com.palletops.awaze.common/aws-client :rds credentials5097)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5099
       restoreDBInstanceFromDBSnapshot
       (rds/restore-dbinstance-from-dbsnapshot-request
        (clojure.core/nth args5098 0)))))))
  (clojure.core/defn
   restore-dbinstance-from-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         dbsnapshot-identifier
                         iops
                         engine
                         general-progress-listener
                         availability-zone
                         dbname
                         dbinstance-class
                         port
                         license-model
                         dbsubnet-group-name
                         multi-az
                         dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Generate map for restoreDBInstanceFromDBSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :restore-dbinstance-from-dbsnapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   restore-dbinstance-from-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         dbsnapshot-identifier
                         iops
                         engine
                         general-progress-listener
                         availability-zone
                         dbname
                         dbinstance-class
                         port
                         license-model
                         dbsubnet-group-name
                         multi-az
                         dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Call restoreDBInstanceFromDBSnapshot"}
   [credentials5101 & args5102]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5103
     (com.palletops.awaze.common/aws-client :rds credentials5101)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5103
      restoreDBInstanceFromDBSnapshot
      (rds/restore-dbinstance-from-dbsnapshot-request
       (clojure.core/nth args5102 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbparameter-group
   [m5104]
   (clojure.core/let
    [credentials5105 (:credentials m5104) args5106 (:args m5104)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5107
      (com.palletops.awaze.common/aws-client :rds credentials5105)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5107
       deleteDBParameterGroup
       (rds/delete-dbparameter-group-request
        (clojure.core/nth args5106 0)))))))
  (clojure.core/defn
   delete-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Generate map for deleteDBParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbparameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Call deleteDBParameterGroup"}
   [credentials5109 & args5110]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5111
     (com.palletops.awaze.common/aws-client :rds credentials5109)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5111
      deleteDBParameterGroup
      (rds/delete-dbparameter-group-request
       (clojure.core/nth args5110 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-reserved-dbinstances
   [m5112]
   (clojure.core/let
    [credentials5113 (:credentials m5112) args5114 (:args m5112)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5115
      (com.palletops.awaze.common/aws-client :rds credentials5113)]
     (clojure.core/case
      (clojure.core/count args5114)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5115
        describeReservedDBInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5115
        describeReservedDBInstances
        (rds/describe-reserved-dbinstances-request
         (clojure.core/nth args5114 0))))))))
  (clojure.core/defn
   describe-reserved-dbinstances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration
                         general-progress-listener
                         filters
                         reserved-dbinstances-offering-id
                         reserved-dbinstance-id
                         max-records
                         dbinstance-class
                         marker
                         product-description
                         offering-type
                         multi-az]}]]),
    :doc "Generate map for describeReservedDBInstances, describeReservedDBInstances"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-reserved-dbinstances,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-reserved-dbinstances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-dbinstances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration
                         general-progress-listener
                         filters
                         reserved-dbinstances-offering-id
                         reserved-dbinstance-id
                         max-records
                         dbinstance-class
                         marker
                         product-description
                         offering-type
                         multi-az]}]]),
    :doc "Call describeReservedDBInstances, describeReservedDBInstances"}
   [credentials5117 & args5118]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5119
     (com.palletops.awaze.common/aws-client :rds credentials5117)]
    (clojure.core/case
     (clojure.core/count args5118)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5119
       describeReservedDBInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5119
       describeReservedDBInstances
       (rds/describe-reserved-dbinstances-request
        (clojure.core/nth args5118 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbsecurity-group
   [m5120]
   (clojure.core/let
    [credentials5121 (:credentials m5120) args5122 (:args m5120)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5123
      (com.palletops.awaze.common/aws-client :rds credentials5121)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5123
       deleteDBSecurityGroup
       (rds/delete-dbsecurity-group-request
        (clojure.core/nth args5122 0)))))))
  (clojure.core/defn
   delete-dbsecurity-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsecurity-group-name]}]]),
    :doc "Generate map for deleteDBSecurityGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbsecurity-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-dbsecurity-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsecurity-group-name]}]]),
    :doc "Call deleteDBSecurityGroup"}
   [credentials5125 & args5126]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5127
     (com.palletops.awaze.common/aws-client :rds credentials5125)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5127
      deleteDBSecurityGroup
      (rds/delete-dbsecurity-group-request
       (clojure.core/nth args5126 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-engine-default-parameters
   [m5128]
   (clojure.core/let
    [credentials5129 (:credentials m5128) args5130 (:args m5128)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5131
      (com.palletops.awaze.common/aws-client :rds credentials5129)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5131
       describeEngineDefaultParameters
       (rds/describe-engine-default-parameters-request
        (clojure.core/nth args5130 0)))))))
  (clojure.core/defn
   describe-engine-default-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         dbparameter-group-family]}]]),
    :doc "Generate map for describeEngineDefaultParameters"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-engine-default-parameters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-engine-default-parameters
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         dbparameter-group-family]}]]),
    :doc "Call describeEngineDefaultParameters"}
   [credentials5133 & args5134]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5135
     (com.palletops.awaze.common/aws-client :rds credentials5133)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5135
      describeEngineDefaultParameters
      (rds/describe-engine-default-parameters-request
       (clojure.core/nth args5134 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbparameter-group
   [m5136]
   (clojure.core/let
    [credentials5137 (:credentials m5136) args5138 (:args m5136)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5139
      (com.palletops.awaze.common/aws-client :rds credentials5137)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5139
       createDBParameterGroup
       (rds/create-dbparameter-group-request
        (clojure.core/nth args5138 0)))))))
  (clojure.core/defn
   create-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         description
                         dbparameter-group-name
                         dbparameter-group-family]}]]),
    :doc "Generate map for createDBParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbparameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         description
                         dbparameter-group-name
                         dbparameter-group-family]}]]),
    :doc "Call createDBParameterGroup"}
   [credentials5141 & args5142]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5143
     (com.palletops.awaze.common/aws-client :rds credentials5141)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5143
      createDBParameterGroup
      (rds/create-dbparameter-group-request
       (clojure.core/nth args5142 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-event-subscription
   [m5144]
   (clojure.core/let
    [credentials5145 (:credentials m5144) args5146 (:args m5144)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5147
      (com.palletops.awaze.common/aws-client :rds credentials5145)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5147
       createEventSubscription
       (rds/create-event-subscription-request
        (clojure.core/nth args5146 0)))))))
  (clojure.core/defn
   create-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         tags]}]]),
    :doc "Generate map for createEventSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-event-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         tags]}]]),
    :doc "Call createEventSubscription"}
   [credentials5149 & args5150]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5151
     (com.palletops.awaze.common/aws-client :rds credentials5149)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5151
      createEventSubscription
      (rds/create-event-subscription-request
       (clojure.core/nth args5150 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbsecurity-group
   [m5152]
   (clojure.core/let
    [credentials5153 (:credentials m5152) args5154 (:args m5152)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5155
      (com.palletops.awaze.common/aws-client :rds credentials5153)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5155
       createDBSecurityGroup
       (rds/create-dbsecurity-group-request
        (clojure.core/nth args5154 0)))))))
  (clojure.core/defn
   create-dbsecurity-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         dbsecurity-group-name
                         dbsecurity-group-description]}]]),
    :doc "Generate map for createDBSecurityGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbsecurity-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-dbsecurity-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         dbsecurity-group-name
                         dbsecurity-group-description]}]]),
    :doc "Call createDBSecurityGroup"}
   [credentials5157 & args5158]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5159
     (com.palletops.awaze.common/aws-client :rds credentials5157)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5159
      createDBSecurityGroup
      (rds/create-dbsecurity-group-request
       (clojure.core/nth args5158 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-event-subscription
   [m5160]
   (clojure.core/let
    [credentials5161 (:credentials m5160) args5162 (:args m5160)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5163
      (com.palletops.awaze.common/aws-client :rds credentials5161)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5163
       modifyEventSubscription
       (rds/modify-event-subscription-request
        (clojure.core/nth args5162 0)))))))
  (clojure.core/defn
   modify-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [source-type
                         subscription-name
                         event-categories
                         general-progress-listener
                         sns-topic-arn
                         enabled]}]]),
    :doc "Generate map for modifyEventSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-event-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [source-type
                         subscription-name
                         event-categories
                         general-progress-listener
                         sns-topic-arn
                         enabled]}]]),
    :doc "Call modifyEventSubscription"}
   [credentials5165 & args5166]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5167
     (com.palletops.awaze.common/aws-client :rds credentials5165)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5167
      modifyEventSubscription
      (rds/modify-event-subscription-request
       (clojure.core/nth args5166 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-option-group
   [m5168]
   (clojure.core/let
    [credentials5169 (:credentials m5168) args5170 (:args m5168)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5171
      (com.palletops.awaze.common/aws-client :rds credentials5169)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5171
       deleteOptionGroup
       (rds/delete-option-group-request (clojure.core/nth args5170 0)))))))
  (clojure.core/defn
   delete-option-group-map
   {:arglists (quote
               [[credentials
                 {:keys [option-group-name general-progress-listener]}]]),
    :doc "Generate map for deleteOptionGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-option-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-option-group
   {:arglists (quote
               [[credentials
                 {:keys [option-group-name general-progress-listener]}]]),
    :doc "Call deleteOptionGroup"}
   [credentials5173 & args5174]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5175
     (com.palletops.awaze.common/aws-client :rds credentials5173)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5175
      deleteOptionGroup
      (rds/delete-option-group-request (clojure.core/nth args5174 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :download-dblog-file-portion
   [m5176]
   (clojure.core/let
    [credentials5177 (:credentials m5176) args5178 (:args m5176)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5179
      (com.palletops.awaze.common/aws-client :rds credentials5177)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5179
       downloadDBLogFilePortion
       (rds/download-dblog-file-portion-request
        (clojure.core/nth args5178 0)))))))
  (clojure.core/defn
   download-dblog-file-portion-map
   {:arglists (quote
               [[credentials
                 {:keys [number-of-lines
                         marker
                         log-file-name
                         general-progress-listener
                         dbinstance-identifier]}]]),
    :doc "Generate map for downloadDBLogFilePortion"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :download-dblog-file-portion,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   download-dblog-file-portion
   {:arglists (quote
               [[credentials
                 {:keys [number-of-lines
                         marker
                         log-file-name
                         general-progress-listener
                         dbinstance-identifier]}]]),
    :doc "Call downloadDBLogFilePortion"}
   [credentials5181 & args5182]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5183
     (com.palletops.awaze.common/aws-client :rds credentials5181)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5183
      downloadDBLogFilePortion
      (rds/download-dblog-file-portion-request
       (clojure.core/nth args5182 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-events
   [m5184]
   (clojure.core/let
    [credentials5185 (:credentials m5184) args5186 (:args m5184)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5187
      (com.palletops.awaze.common/aws-client :rds credentials5185)]
     (clojure.core/case
      (clojure.core/count args5186)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5187
        describeEvents))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5187
        describeEvents
        (rds/describe-events-request (clojure.core/nth args5186 0))))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         source-type
                         duration
                         event-categories
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-events,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-events,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         source-type
                         duration
                         event-categories
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials5189 & args5190]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5191
     (com.palletops.awaze.common/aws-client :rds credentials5189)]
    (clojure.core/case
     (clojure.core/count args5190)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5191
       describeEvents))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5191
       describeEvents
       (rds/describe-events-request (clojure.core/nth args5190 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-reserved-dbinstances-offerings
   [m5192]
   (clojure.core/let
    [credentials5193 (:credentials m5192) args5194 (:args m5192)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5195
      (com.palletops.awaze.common/aws-client :rds credentials5193)]
     (clojure.core/case
      (clojure.core/count args5194)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5195
        describeReservedDBInstancesOfferings
        (rds/describe-reserved-dbinstances-offerings-request
         (clojure.core/nth args5194 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5195
        describeReservedDBInstancesOfferings))))))
  (clojure.core/defn
   describe-reserved-dbinstances-offerings-map
   {:arglists (quote
               [[credentials
                 {:keys [duration
                         general-progress-listener
                         reserved-dbinstances-offering-id
                         max-records
                         dbinstance-class
                         marker
                         product-description
                         offering-type
                         multi-az]}]
                [credentials]]),
    :doc "Generate map for describeReservedDBInstancesOfferings, describeReservedDBInstancesOfferings"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-reserved-dbinstances-offerings,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-reserved-dbinstances-offerings,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-dbinstances-offerings
   {:arglists (quote
               [[credentials
                 {:keys [duration
                         general-progress-listener
                         reserved-dbinstances-offering-id
                         max-records
                         dbinstance-class
                         marker
                         product-description
                         offering-type
                         multi-az]}]
                [credentials]]),
    :doc "Call describeReservedDBInstancesOfferings, describeReservedDBInstancesOfferings"}
   [credentials5197 & args5198]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5199
     (com.palletops.awaze.common/aws-client :rds credentials5197)]
    (clojure.core/case
     (clojure.core/count args5198)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5199
       describeReservedDBInstancesOfferings
       (rds/describe-reserved-dbinstances-offerings-request
        (clojure.core/nth args5198 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5199
       describeReservedDBInstancesOfferings))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-option-group
   [m5200]
   (clojure.core/let
    [credentials5201 (:credentials m5200) args5202 (:args m5200)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5203
      (com.palletops.awaze.common/aws-client :rds credentials5201)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5203
       modifyOptionGroup
       (rds/modify-option-group-request (clojure.core/nth args5202 0)))))))
  (clojure.core/defn
   modify-option-group-map
   {:arglists (quote
               [[credentials
                 {:keys [options-to-remove
                         options-to-include
                         option-group-name
                         general-progress-listener
                         apply-immediately]}]]),
    :doc "Generate map for modifyOptionGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-option-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-option-group
   {:arglists (quote
               [[credentials
                 {:keys [options-to-remove
                         options-to-include
                         option-group-name
                         general-progress-listener
                         apply-immediately]}]]),
    :doc "Call modifyOptionGroup"}
   [credentials5205 & args5206]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5207
     (com.palletops.awaze.common/aws-client :rds credentials5205)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5207
      modifyOptionGroup
      (rds/modify-option-group-request (clojure.core/nth args5206 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbinstances
   [m5208]
   (clojure.core/let
    [credentials5209 (:credentials m5208) args5210 (:args m5208)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5211
      (com.palletops.awaze.common/aws-client :rds credentials5209)]
     (clojure.core/case
      (clojure.core/count args5210)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5211
        describeDBInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5211
        describeDBInstances
        (rds/describe-dbinstances-request
         (clojure.core/nth args5210 0))))))))
  (clojure.core/defn
   describe-dbinstances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbinstance-identifier]}]]),
    :doc "Generate map for describeDBInstances, describeDBInstances"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbinstances,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbinstances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dbinstances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbinstance-identifier]}]]),
    :doc "Call describeDBInstances, describeDBInstances"}
   [credentials5213 & args5214]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5215
     (com.palletops.awaze.common/aws-client :rds credentials5213)]
    (clojure.core/case
     (clojure.core/count args5214)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5215
       describeDBInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5215
       describeDBInstances
       (rds/describe-dbinstances-request
        (clojure.core/nth args5214 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbsnapshot
   [m5216]
   (clojure.core/let
    [credentials5217 (:credentials m5216) args5218 (:args m5216)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5219
      (com.palletops.awaze.common/aws-client :rds credentials5217)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5219
       createDBSnapshot
       (rds/create-dbsnapshot-request (clojure.core/nth args5218 0)))))))
  (clojure.core/defn
   create-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         dbsnapshot-identifier
                         dbinstance-identifier]}]]),
    :doc "Generate map for createDBSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbsnapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         dbsnapshot-identifier
                         dbinstance-identifier]}]]),
    :doc "Call createDBSnapshot"}
   [credentials5221 & args5222]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5223
     (com.palletops.awaze.common/aws-client :rds credentials5221)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5223
      createDBSnapshot
      (rds/create-dbsnapshot-request (clojure.core/nth args5222 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :remove-source-identifier-from-subscription
   [m5224]
   (clojure.core/let
    [credentials5225 (:credentials m5224) args5226 (:args m5224)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5227
      (com.palletops.awaze.common/aws-client :rds credentials5225)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5227
       removeSourceIdentifierFromSubscription
       (rds/remove-source-identifier-from-subscription-request
        (clojure.core/nth args5226 0)))))))
  (clojure.core/defn
   remove-source-identifier-from-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         source-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for removeSourceIdentifierFromSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :remove-source-identifier-from-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   remove-source-identifier-from-subscription
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         source-identifier
                         general-progress-listener]}]]),
    :doc "Call removeSourceIdentifierFromSubscription"}
   [credentials5229 & args5230]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5231
     (com.palletops.awaze.common/aws-client :rds credentials5229)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5231
      removeSourceIdentifierFromSubscription
      (rds/remove-source-identifier-from-subscription-request
       (clojure.core/nth args5230 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-option-group
   [m5232]
   (clojure.core/let
    [credentials5233 (:credentials m5232) args5234 (:args m5232)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5235
      (com.palletops.awaze.common/aws-client :rds credentials5233)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5235
       createOptionGroup
       (rds/create-option-group-request (clojure.core/nth args5234 0)))))))
  (clojure.core/defn
   create-option-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         major-engine-version
                         engine-name
                         option-group-name
                         general-progress-listener
                         option-group-description]}]]),
    :doc "Generate map for createOptionGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-option-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-option-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         major-engine-version
                         engine-name
                         option-group-name
                         general-progress-listener
                         option-group-description]}]]),
    :doc "Call createOptionGroup"}
   [credentials5237 & args5238]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5239
     (com.palletops.awaze.common/aws-client :rds credentials5237)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5239
      createOptionGroup
      (rds/create-option-group-request (clojure.core/nth args5238 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-event-subscriptions
   [m5240]
   (clojure.core/let
    [credentials5241 (:credentials m5240) args5242 (:args m5240)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5243
      (com.palletops.awaze.common/aws-client :rds credentials5241)]
     (clojure.core/case
      (clojure.core/count args5242)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5243
        describeEventSubscriptions
        (rds/describe-event-subscriptions-request
         (clojure.core/nth args5242 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5243
        describeEventSubscriptions))))))
  (clojure.core/defn
   describe-event-subscriptions-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         max-records
                         marker
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeEventSubscriptions, describeEventSubscriptions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-event-subscriptions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-event-subscriptions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-event-subscriptions
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         max-records
                         marker
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeEventSubscriptions, describeEventSubscriptions"}
   [credentials5245 & args5246]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5247
     (com.palletops.awaze.common/aws-client :rds credentials5245)]
    (clojure.core/case
     (clojure.core/count args5246)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5247
       describeEventSubscriptions
       (rds/describe-event-subscriptions-request
        (clojure.core/nth args5246 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5247
       describeEventSubscriptions))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-orderable-dbinstance-options
   [m5248]
   (clojure.core/let
    [credentials5249 (:credentials m5248) args5250 (:args m5248)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5251
      (com.palletops.awaze.common/aws-client :rds credentials5249)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5251
       describeOrderableDBInstanceOptions
       (rds/describe-orderable-dbinstance-options-request
        (clojure.core/nth args5250 0)))))))
  (clojure.core/defn
   describe-orderable-dbinstance-options-map
   {:arglists (quote
               [[credentials
                 {:keys [engine
                         general-progress-listener
                         max-records
                         dbinstance-class
                         vpc
                         marker
                         license-model
                         engine-version]}]]),
    :doc "Generate map for describeOrderableDBInstanceOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-orderable-dbinstance-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-orderable-dbinstance-options
   {:arglists (quote
               [[credentials
                 {:keys [engine
                         general-progress-listener
                         max-records
                         dbinstance-class
                         vpc
                         marker
                         license-model
                         engine-version]}]]),
    :doc "Call describeOrderableDBInstanceOptions"}
   [credentials5253 & args5254]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5255
     (com.palletops.awaze.common/aws-client :rds credentials5253)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5255
      describeOrderableDBInstanceOptions
      (rds/describe-orderable-dbinstance-options-request
       (clojure.core/nth args5254 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :list-tags-for-resource
   [m5256]
   (clojure.core/let
    [credentials5257 (:credentials m5256) args5258 (:args m5256)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5259
      (com.palletops.awaze.common/aws-client :rds credentials5257)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5259
       listTagsForResource
       (rds/list-tags-for-resource-request
        (clojure.core/nth args5258 0)))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [resource-name general-progress-listener]}]]),
    :doc "Generate map for listTagsForResource"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :list-tags-for-resource,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [resource-name general-progress-listener]}]]),
    :doc "Call listTagsForResource"}
   [credentials5261 & args5262]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5263
     (com.palletops.awaze.common/aws-client :rds credentials5261)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5263
      listTagsForResource
      (rds/list-tags-for-resource-request
       (clojure.core/nth args5262 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbsubnet-group
   [m5264]
   (clojure.core/let
    [credentials5265 (:credentials m5264) args5266 (:args m5264)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5267
      (com.palletops.awaze.common/aws-client :rds credentials5265)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5267
       modifyDBSubnetGroup
       (rds/modify-dbsubnet-group-request
        (clojure.core/nth args5266 0)))))))
  (clojure.core/defn
   modify-dbsubnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         dbsubnet-group-name
                         dbsubnet-group-description]}]]),
    :doc "Generate map for modifyDBSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-dbsubnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-dbsubnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         dbsubnet-group-name
                         dbsubnet-group-description]}]]),
    :doc "Call modifyDBSubnetGroup"}
   [credentials5269 & args5270]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5271
     (com.palletops.awaze.common/aws-client :rds credentials5269)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5271
      modifyDBSubnetGroup
      (rds/modify-dbsubnet-group-request
       (clojure.core/nth args5270 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dblog-files
   [m5272]
   (clojure.core/let
    [credentials5273 (:credentials m5272) args5274 (:args m5272)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5275
      (com.palletops.awaze.common/aws-client :rds credentials5273)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5275
       describeDBLogFiles
       (rds/describe-dblog-files-request
        (clojure.core/nth args5274 0)))))))
  (clojure.core/defn
   describe-dblog-files-map
   {:arglists (quote
               [[credentials
                 {:keys [filename-contains
                         general-progress-listener
                         file-last-written
                         max-records
                         file-size
                         marker
                         dbinstance-identifier]}]]),
    :doc "Generate map for describeDBLogFiles"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dblog-files,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dblog-files
   {:arglists (quote
               [[credentials
                 {:keys [filename-contains
                         general-progress-listener
                         file-last-written
                         max-records
                         file-size
                         marker
                         dbinstance-identifier]}]]),
    :doc "Call describeDBLogFiles"}
   [credentials5277 & args5278]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5279
     (com.palletops.awaze.common/aws-client :rds credentials5277)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5279
      describeDBLogFiles
      (rds/describe-dblog-files-request (clojure.core/nth args5278 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :promote-read-replica
   [m5280]
   (clojure.core/let
    [credentials5281 (:credentials m5280) args5282 (:args m5280)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5283
      (com.palletops.awaze.common/aws-client :rds credentials5281)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5283
       promoteReadReplica
       (rds/promote-read-replica-request
        (clojure.core/nth args5282 0)))))))
  (clojure.core/defn
   promote-read-replica-map
   {:arglists (quote
               [[credentials
                 {:keys [preferred-backup-window
                         general-progress-listener
                         backup-retention-period
                         dbinstance-identifier]}]]),
    :doc "Generate map for promoteReadReplica"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :promote-read-replica,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   promote-read-replica
   {:arglists (quote
               [[credentials
                 {:keys [preferred-backup-window
                         general-progress-listener
                         backup-retention-period
                         dbinstance-identifier]}]]),
    :doc "Call promoteReadReplica"}
   [credentials5285 & args5286]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5287
     (com.palletops.awaze.common/aws-client :rds credentials5285)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5287
      promoteReadReplica
      (rds/promote-read-replica-request (clojure.core/nth args5286 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbsubnet-group
   [m5288]
   (clojure.core/let
    [credentials5289 (:credentials m5288) args5290 (:args m5288)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5291
      (com.palletops.awaze.common/aws-client :rds credentials5289)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5291
       deleteDBSubnetGroup
       (rds/delete-dbsubnet-group-request
        (clojure.core/nth args5290 0)))))))
  (clojure.core/defn
   delete-dbsubnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsubnet-group-name]}]]),
    :doc "Generate map for deleteDBSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbsubnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-dbsubnet-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsubnet-group-name]}]]),
    :doc "Call deleteDBSubnetGroup"}
   [credentials5293 & args5294]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5295
     (com.palletops.awaze.common/aws-client :rds credentials5293)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5295
      deleteDBSubnetGroup
      (rds/delete-dbsubnet-group-request
       (clojure.core/nth args5294 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsnapshots
   [m5296]
   (clojure.core/let
    [credentials5297 (:credentials m5296) args5298 (:args m5296)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5299
      (com.palletops.awaze.common/aws-client :rds credentials5297)]
     (clojure.core/case
      (clojure.core/count args5298)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5299
        describeDBSnapshots
        (rds/describe-dbsnapshots-request
         (clojure.core/nth args5298 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5299
        describeDBSnapshots))))))
  (clojure.core/defn
   describe-dbsnapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [dbsnapshot-identifier
                         general-progress-listener
                         filters
                         max-records
                         marker
                         dbinstance-identifier
                         snapshot-type]}]
                [credentials]]),
    :doc "Generate map for describeDBSnapshots, describeDBSnapshots"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbsnapshots,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbsnapshots,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dbsnapshots
   {:arglists (quote
               [[credentials
                 {:keys [dbsnapshot-identifier
                         general-progress-listener
                         filters
                         max-records
                         marker
                         dbinstance-identifier
                         snapshot-type]}]
                [credentials]]),
    :doc "Call describeDBSnapshots, describeDBSnapshots"}
   [credentials5301 & args5302]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5303
     (com.palletops.awaze.common/aws-client :rds credentials5301)]
    (clojure.core/case
     (clojure.core/count args5302)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5303
       describeDBSnapshots
       (rds/describe-dbsnapshots-request
        (clojure.core/nth args5302 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5303
       describeDBSnapshots))))))
 (do
  (clojure.core/defmethod
   rds
   :add-source-identifier-to-subscription
   [m5304]
   (clojure.core/let
    [credentials5305 (:credentials m5304) args5306 (:args m5304)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5307
      (com.palletops.awaze.common/aws-client :rds credentials5305)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5307
       addSourceIdentifierToSubscription
       (rds/add-source-identifier-to-subscription-request
        (clojure.core/nth args5306 0)))))))
  (clojure.core/defn
   add-source-identifier-to-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         source-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for addSourceIdentifierToSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :add-source-identifier-to-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-source-identifier-to-subscription
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         source-identifier
                         general-progress-listener]}]]),
    :doc "Call addSourceIdentifierToSubscription"}
   [credentials5309 & args5310]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5311
     (com.palletops.awaze.common/aws-client :rds credentials5309)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5311
      addSourceIdentifierToSubscription
      (rds/add-source-identifier-to-subscription-request
       (clojure.core/nth args5310 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :remove-tags-from-resource
   [m5312]
   (clojure.core/let
    [credentials5313 (:credentials m5312) args5314 (:args m5312)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5315
      (com.palletops.awaze.common/aws-client :rds credentials5313)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5315
       removeTagsFromResource
       (rds/remove-tags-from-resource-request
        (clojure.core/nth args5314 0)))))))
  (clojure.core/defn
   remove-tags-from-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tag-keys
                         resource-name
                         general-progress-listener]}]]),
    :doc "Generate map for removeTagsFromResource"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :remove-tags-from-resource,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   remove-tags-from-resource
   {:arglists (quote
               [[credentials
                 {:keys [tag-keys
                         resource-name
                         general-progress-listener]}]]),
    :doc "Call removeTagsFromResource"}
   [credentials5317 & args5318]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5319
     (com.palletops.awaze.common/aws-client :rds credentials5317)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5319
      removeTagsFromResource
      (rds/remove-tags-from-resource-request
       (clojure.core/nth args5318 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbinstance
   [m5320]
   (clojure.core/let
    [credentials5321 (:credentials m5320) args5322 (:args m5320)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5323
      (com.palletops.awaze.common/aws-client :rds credentials5321)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5323
       modifyDBInstance
       (rds/modify-dbinstance-request (clojure.core/nth args5322 0)))))))
  (clojure.core/defn
   modify-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [iops
                         dbsecurity-groups
                         general-progress-listener
                         backup-retention-period
                         preferred-maintenance-window
                         new-dbinstance-identifier
                         allow-major-version-upgrade
                         preferred-backup-window
                         dbinstance-class
                         master-user-password
                         vpc-security-group-ids
                         dbparameter-group-name
                         apply-immediately
                         engine-version
                         multi-az
                         dbinstance-identifier
                         allocated-storage
                         auto-minor-version-upgrade
                         option-group-name]}]]),
    :doc "Generate map for modifyDBInstance"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-dbinstance,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [iops
                         dbsecurity-groups
                         general-progress-listener
                         backup-retention-period
                         preferred-maintenance-window
                         new-dbinstance-identifier
                         allow-major-version-upgrade
                         preferred-backup-window
                         dbinstance-class
                         master-user-password
                         vpc-security-group-ids
                         dbparameter-group-name
                         apply-immediately
                         engine-version
                         multi-az
                         dbinstance-identifier
                         allocated-storage
                         auto-minor-version-upgrade
                         option-group-name]}]]),
    :doc "Call modifyDBInstance"}
   [credentials5325 & args5326]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5327
     (com.palletops.awaze.common/aws-client :rds credentials5325)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5327
      modifyDBInstance
      (rds/modify-dbinstance-request (clojure.core/nth args5326 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbengine-versions
   [m5328]
   (clojure.core/let
    [credentials5329 (:credentials m5328) args5330 (:args m5328)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5331
      (com.palletops.awaze.common/aws-client :rds credentials5329)]
     (clojure.core/case
      (clojure.core/count args5330)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5331
        describeDBEngineVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5331
        describeDBEngineVersions
        (rds/describe-dbengine-versions-request
         (clojure.core/nth args5330 0))))))))
  (clojure.core/defn
   describe-dbengine-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [dbparameter-group-family
                         list-supported-character-sets
                         engine
                         general-progress-listener
                         max-records
                         marker
                         default-only
                         engine-version]}]]),
    :doc "Generate map for describeDBEngineVersions, describeDBEngineVersions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbengine-versions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbengine-versions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dbengine-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [dbparameter-group-family
                         list-supported-character-sets
                         engine
                         general-progress-listener
                         max-records
                         marker
                         default-only
                         engine-version]}]]),
    :doc "Call describeDBEngineVersions, describeDBEngineVersions"}
   [credentials5333 & args5334]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5335
     (com.palletops.awaze.common/aws-client :rds credentials5333)]
    (clojure.core/case
     (clojure.core/count args5334)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5335
       describeDBEngineVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5335
       describeDBEngineVersions
       (rds/describe-dbengine-versions-request
        (clojure.core/nth args5334 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :reboot-dbinstance
   [m5336]
   (clojure.core/let
    [credentials5337 (:credentials m5336) args5338 (:args m5336)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5339
      (com.palletops.awaze.common/aws-client :rds credentials5337)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5339
       rebootDBInstance
       (rds/reboot-dbinstance-request (clojure.core/nth args5338 0)))))))
  (clojure.core/defn
   reboot-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force-failover
                         dbinstance-identifier]}]]),
    :doc "Generate map for rebootDBInstance"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :reboot-dbinstance,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reboot-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force-failover
                         dbinstance-identifier]}]]),
    :doc "Call rebootDBInstance"}
   [credentials5341 & args5342]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5343
     (com.palletops.awaze.common/aws-client :rds credentials5341)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5343
      rebootDBInstance
      (rds/reboot-dbinstance-request (clojure.core/nth args5342 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-option-group-options
   [m5344]
   (clojure.core/let
    [credentials5345 (:credentials m5344) args5346 (:args m5344)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5347
      (com.palletops.awaze.common/aws-client :rds credentials5345)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5347
       describeOptionGroupOptions
       (rds/describe-option-group-options-request
        (clojure.core/nth args5346 0)))))))
  (clojure.core/defn
   describe-option-group-options-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         major-engine-version
                         general-progress-listener
                         engine-name]}]]),
    :doc "Generate map for describeOptionGroupOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-option-group-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-option-group-options
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         major-engine-version
                         general-progress-listener
                         engine-name]}]]),
    :doc "Call describeOptionGroupOptions"}
   [credentials5349 & args5350]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5351
     (com.palletops.awaze.common/aws-client :rds credentials5349)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5351
      describeOptionGroupOptions
      (rds/describe-option-group-options-request
       (clojure.core/nth args5350 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbinstance
   [m5352]
   (clojure.core/let
    [credentials5353 (:credentials m5352) args5354 (:args m5352)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5355
      (com.palletops.awaze.common/aws-client :rds credentials5353)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5355
       createDBInstance
       (rds/create-dbinstance-request (clojure.core/nth args5354 0)))))))
  (clojure.core/defn
   create-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         iops
                         dbsecurity-groups
                         engine
                         general-progress-listener
                         backup-retention-period
                         availability-zone
                         preferred-maintenance-window
                         master-username
                         dbname
                         preferred-backup-window
                         dbinstance-class
                         master-user-password
                         vpc-security-group-ids
                         port
                         dbparameter-group-name
                         character-set-name
                         license-model
                         dbsubnet-group-name
                         engine-version
                         multi-az
                         dbinstance-identifier
                         allocated-storage
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Generate map for createDBInstance"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbinstance,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         iops
                         dbsecurity-groups
                         engine
                         general-progress-listener
                         backup-retention-period
                         availability-zone
                         preferred-maintenance-window
                         master-username
                         dbname
                         preferred-backup-window
                         dbinstance-class
                         master-user-password
                         vpc-security-group-ids
                         port
                         dbparameter-group-name
                         character-set-name
                         license-model
                         dbsubnet-group-name
                         engine-version
                         multi-az
                         dbinstance-identifier
                         allocated-storage
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Call createDBInstance"}
   [credentials5357 & args5358]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5359
     (com.palletops.awaze.common/aws-client :rds credentials5357)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5359
      createDBInstance
      (rds/create-dbinstance-request (clojure.core/nth args5358 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsubnet-groups
   [m5360]
   (clojure.core/let
    [credentials5361 (:credentials m5360) args5362 (:args m5360)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5363
      (com.palletops.awaze.common/aws-client :rds credentials5361)]
     (clojure.core/case
      (clojure.core/count args5362)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5363
        describeDBSubnetGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5363
        describeDBSubnetGroups
        (rds/describe-dbsubnet-groups-request
         (clojure.core/nth args5362 0))))))))
  (clojure.core/defn
   describe-dbsubnet-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbsubnet-group-name]}]]),
    :doc "Generate map for describeDBSubnetGroups, describeDBSubnetGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbsubnet-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbsubnet-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dbsubnet-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbsubnet-group-name]}]]),
    :doc "Call describeDBSubnetGroups, describeDBSubnetGroups"}
   [credentials5365 & args5366]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5367
     (com.palletops.awaze.common/aws-client :rds credentials5365)]
    (clojure.core/case
     (clojure.core/count args5366)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5367
       describeDBSubnetGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5367
       describeDBSubnetGroups
       (rds/describe-dbsubnet-groups-request
        (clojure.core/nth args5366 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-event-subscription
   [m5368]
   (clojure.core/let
    [credentials5369 (:credentials m5368) args5370 (:args m5368)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5371
      (com.palletops.awaze.common/aws-client :rds credentials5369)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5371
       deleteEventSubscription
       (rds/delete-event-subscription-request
        (clojure.core/nth args5370 0)))))))
  (clojure.core/defn
   delete-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name general-progress-listener]}]]),
    :doc "Generate map for deleteEventSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-event-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name general-progress-listener]}]]),
    :doc "Call deleteEventSubscription"}
   [credentials5373 & args5374]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5375
     (com.palletops.awaze.common/aws-client :rds credentials5373)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5375
      deleteEventSubscription
      (rds/delete-event-subscription-request
       (clojure.core/nth args5374 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbparameter-groups
   [m5376]
   (clojure.core/let
    [credentials5377 (:credentials m5376) args5378 (:args m5376)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5379
      (com.palletops.awaze.common/aws-client :rds credentials5377)]
     (clojure.core/case
      (clojure.core/count args5378)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5379
        describeDBParameterGroups
        (rds/describe-dbparameter-groups-request
         (clojure.core/nth args5378 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5379
        describeDBParameterGroups))))))
  (clojure.core/defn
   describe-dbparameter-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbparameter-group-name]}]
                [credentials]]),
    :doc "Generate map for describeDBParameterGroups, describeDBParameterGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbparameter-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbparameter-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dbparameter-groups
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbparameter-group-name]}]
                [credentials]]),
    :doc "Call describeDBParameterGroups, describeDBParameterGroups"}
   [credentials5381 & args5382]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5383
     (com.palletops.awaze.common/aws-client :rds credentials5381)]
    (clojure.core/case
     (clojure.core/count args5382)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5383
       describeDBParameterGroups
       (rds/describe-dbparameter-groups-request
        (clojure.core/nth args5382 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5383
       describeDBParameterGroups))))))
 (do
  (clojure.core/defmethod
   rds
   :reset-dbparameter-group
   [m5384]
   (clojure.core/let
    [credentials5385 (:credentials m5384) args5386 (:args m5384)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5387
      (com.palletops.awaze.common/aws-client :rds credentials5385)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5387
       resetDBParameterGroup
       (rds/reset-dbparameter-group-request
        (clojure.core/nth args5386 0)))))))
  (clojure.core/defn
   reset-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameters
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Generate map for resetDBParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :reset-dbparameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reset-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameters
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Call resetDBParameterGroup"}
   [credentials5389 & args5390]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5391
     (com.palletops.awaze.common/aws-client :rds credentials5389)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5391
      resetDBParameterGroup
      (rds/reset-dbparameter-group-request
       (clojure.core/nth args5390 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :restore-dbinstance-to-point-in-time
   [m5392]
   (clojure.core/let
    [credentials5393 (:credentials m5392) args5394 (:args m5392)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5395
      (com.palletops.awaze.common/aws-client :rds credentials5393)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5395
       restoreDBInstanceToPointInTime
       (rds/restore-dbinstance-to-point-in-time-request
        (clojure.core/nth args5394 0)))))))
  (clojure.core/defn
   restore-dbinstance-to-point-in-time-map
   {:arglists (quote
               [[credentials
                 {:keys [restore-time
                         publicly-accessible
                         iops
                         engine
                         general-progress-listener
                         availability-zone
                         dbname
                         target-dbinstance-identifier
                         dbinstance-class
                         port
                         license-model
                         dbsubnet-group-name
                         multi-az
                         use-latest-restorable-time
                         source-dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Generate map for restoreDBInstanceToPointInTime"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :restore-dbinstance-to-point-in-time,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   restore-dbinstance-to-point-in-time
   {:arglists (quote
               [[credentials
                 {:keys [restore-time
                         publicly-accessible
                         iops
                         engine
                         general-progress-listener
                         availability-zone
                         dbname
                         target-dbinstance-identifier
                         dbinstance-class
                         port
                         license-model
                         dbsubnet-group-name
                         multi-az
                         use-latest-restorable-time
                         source-dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Call restoreDBInstanceToPointInTime"}
   [credentials5397 & args5398]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5399
     (com.palletops.awaze.common/aws-client :rds credentials5397)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5399
      restoreDBInstanceToPointInTime
      (rds/restore-dbinstance-to-point-in-time-request
       (clojure.core/nth args5398 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbparameter-group
   [m5400]
   (clojure.core/let
    [credentials5401 (:credentials m5400) args5402 (:args m5400)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5403
      (com.palletops.awaze.common/aws-client :rds credentials5401)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5403
       modifyDBParameterGroup
       (rds/modify-dbparameter-group-request
        (clojure.core/nth args5402 0)))))))
  (clojure.core/defn
   modify-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [parameters
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Generate map for modifyDBParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-dbparameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [parameters
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Call modifyDBParameterGroup"}
   [credentials5405 & args5406]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5407
     (com.palletops.awaze.common/aws-client :rds credentials5405)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5407
      modifyDBParameterGroup
      (rds/modify-dbparameter-group-request
       (clojure.core/nth args5406 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbinstance
   [m5408]
   (clojure.core/let
    [credentials5409 (:credentials m5408) args5410 (:args m5408)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5411
      (com.palletops.awaze.common/aws-client :rds credentials5409)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5411
       deleteDBInstance
       (rds/delete-dbinstance-request (clojure.core/nth args5410 0)))))))
  (clojure.core/defn
   delete-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [skip-final-snapshot
                         general-progress-listener
                         final-dbsnapshot-identifier
                         dbinstance-identifier]}]]),
    :doc "Generate map for deleteDBInstance"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbinstance,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [skip-final-snapshot
                         general-progress-listener
                         final-dbsnapshot-identifier
                         dbinstance-identifier]}]]),
    :doc "Call deleteDBInstance"}
   [credentials5413 & args5414]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5415
     (com.palletops.awaze.common/aws-client :rds credentials5413)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5415
      deleteDBInstance
      (rds/delete-dbinstance-request (clojure.core/nth args5414 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-event-categories
   [m5416]
   (clojure.core/let
    [credentials5417 (:credentials m5416) args5418 (:args m5416)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5419
      (com.palletops.awaze.common/aws-client :rds credentials5417)]
     (clojure.core/case
      (clojure.core/count args5418)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5419
        describeEventCategories))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5419
        describeEventCategories
        (rds/describe-event-categories-request
         (clojure.core/nth args5418 0))))))))
  (clojure.core/defn
   describe-event-categories-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-type general-progress-listener]}]]),
    :doc "Generate map for describeEventCategories, describeEventCategories"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-event-categories,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-event-categories,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-event-categories
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-type general-progress-listener]}]]),
    :doc "Call describeEventCategories, describeEventCategories"}
   [credentials5421 & args5422]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5423
     (com.palletops.awaze.common/aws-client :rds credentials5421)]
    (clojure.core/case
     (clojure.core/count args5422)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5423
       describeEventCategories))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5423
       describeEventCategories
       (rds/describe-event-categories-request
        (clojure.core/nth args5422 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :authorize-dbsecurity-group-ingress
   [m5424]
   (clojure.core/let
    [credentials5425 (:credentials m5424) args5426 (:args m5424)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5427
      (com.palletops.awaze.common/aws-client :rds credentials5425)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5427
       authorizeDBSecurityGroupIngress
       (rds/authorize-dbsecurity-group-ingress-request
        (clojure.core/nth args5426 0)))))))
  (clojure.core/defn
   authorize-dbsecurity-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cidrip
                         ec2security-group-id
                         ec2security-group-owner-id
                         ec2security-group-name
                         dbsecurity-group-name
                         general-progress-listener]}]]),
    :doc "Generate map for authorizeDBSecurityGroupIngress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :authorize-dbsecurity-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   authorize-dbsecurity-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cidrip
                         ec2security-group-id
                         ec2security-group-owner-id
                         ec2security-group-name
                         dbsecurity-group-name
                         general-progress-listener]}]]),
    :doc "Call authorizeDBSecurityGroupIngress"}
   [credentials5429 & args5430]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5431
     (com.palletops.awaze.common/aws-client :rds credentials5429)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5431
      authorizeDBSecurityGroupIngress
      (rds/authorize-dbsecurity-group-ingress-request
       (clojure.core/nth args5430 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :copy-dbsnapshot
   [m5432]
   (clojure.core/let
    [credentials5433 (:credentials m5432) args5434 (:args m5432)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5435
      (com.palletops.awaze.common/aws-client :rds credentials5433)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5435
       copyDBSnapshot
       (rds/copy-dbsnapshot-request (clojure.core/nth args5434 0)))))))
  (clojure.core/defn
   copy-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [target-dbsnapshot-identifier
                         tags
                         source-dbsnapshot-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for copyDBSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :copy-dbsnapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   copy-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [target-dbsnapshot-identifier
                         tags
                         source-dbsnapshot-identifier
                         general-progress-listener]}]]),
    :doc "Call copyDBSnapshot"}
   [credentials5437 & args5438]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5439
     (com.palletops.awaze.common/aws-client :rds credentials5437)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5439
      copyDBSnapshot
      (rds/copy-dbsnapshot-request (clojure.core/nth args5438 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbsnapshot
   [m5440]
   (clojure.core/let
    [credentials5441 (:credentials m5440) args5442 (:args m5440)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5443
      (com.palletops.awaze.common/aws-client :rds credentials5441)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5443
       deleteDBSnapshot
       (rds/delete-dbsnapshot-request (clojure.core/nth args5442 0)))))))
  (clojure.core/defn
   delete-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsnapshot-identifier]}]]),
    :doc "Generate map for deleteDBSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbsnapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsnapshot-identifier]}]]),
    :doc "Call deleteDBSnapshot"}
   [credentials5445 & args5446]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5447
     (com.palletops.awaze.common/aws-client :rds credentials5445)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5447
      deleteDBSnapshot
      (rds/delete-dbsnapshot-request (clojure.core/nth args5446 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbsubnet-group
   [m5448]
   (clojure.core/let
    [credentials5449 (:credentials m5448) args5450 (:args m5448)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5451
      (com.palletops.awaze.common/aws-client :rds credentials5449)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5451
       createDBSubnetGroup
       (rds/create-dbsubnet-group-request
        (clojure.core/nth args5450 0)))))))
  (clojure.core/defn
   create-dbsubnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         subnet-ids
                         general-progress-listener
                         dbsubnet-group-name
                         dbsubnet-group-description]}]]),
    :doc "Generate map for createDBSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbsubnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-dbsubnet-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         subnet-ids
                         general-progress-listener
                         dbsubnet-group-name
                         dbsubnet-group-description]}]]),
    :doc "Call createDBSubnetGroup"}
   [credentials5453 & args5454]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5455
     (com.palletops.awaze.common/aws-client :rds credentials5453)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5455
      createDBSubnetGroup
      (rds/create-dbsubnet-group-request
       (clojure.core/nth args5454 0))))))))
