(ns
 com.palletops.awaze.iam
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.iam :as iam]
  [com.palletops.awaze.beans.identitymanagement
   :as
   identitymanagement]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :iam
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient
   credentials__1601__auto__))
 (clojure.core/defmulti
  iam
  (clojure.core/fn iam [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   iam
   :get-role-policy
   [m7922]
   (clojure.core/let
    [credentials7923 (:credentials m7922) args7924 (:args m7922)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7925
      (com.palletops.awaze.common/aws-client :iam credentials7923)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7925
       getRolePolicy
       (identitymanagement/get-role-policy-request
        (clojure.core/nth args7924 0)))))))
  (clojure.core/defn
   get-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Generate map for getRolePolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-role-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Call getRolePolicy"}
   [credentials7927 & args7928]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7929
     (com.palletops.awaze.common/aws-client :iam credentials7927)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7929
      getRolePolicy
      (identitymanagement/get-role-policy-request
       (clojure.core/nth args7928 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :change-password
   [m7930]
   (clojure.core/let
    [credentials7931 (:credentials m7930) args7932 (:args m7930)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7933
      (com.palletops.awaze.common/aws-client :iam credentials7931)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7933
       changePassword
       (identitymanagement/change-password-request
        (clojure.core/nth args7932 0)))))))
  (clojure.core/defn
   change-password-map
   {:arglists (quote
               [[credentials
                 {:keys [old-password
                         new-password
                         general-progress-listener]}]]),
    :doc "Generate map for changePassword"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :change-password,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   change-password
   {:arglists (quote
               [[credentials
                 {:keys [old-password
                         new-password
                         general-progress-listener]}]]),
    :doc "Call changePassword"}
   [credentials7935 & args7936]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7937
     (com.palletops.awaze.common/aws-client :iam credentials7935)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7937
      changePassword
      (identitymanagement/change-password-request
       (clojure.core/nth args7936 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :deactivate-mfadevice
   [m7938]
   (clojure.core/let
    [credentials7939 (:credentials m7938) args7940 (:args m7938)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7941
      (com.palletops.awaze.common/aws-client :iam credentials7939)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7941
       deactivateMFADevice
       (identitymanagement/deactivate-mfadevice-request
        (clojure.core/nth args7940 0)))))))
  (clojure.core/defn
   deactivate-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener]}]]),
    :doc "Generate map for deactivateMFADevice"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :deactivate-mfadevice,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   deactivate-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener]}]]),
    :doc "Call deactivateMFADevice"}
   [credentials7943 & args7944]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7945
     (com.palletops.awaze.common/aws-client :iam credentials7943)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7945
      deactivateMFADevice
      (identitymanagement/deactivate-mfadevice-request
       (clojure.core/nth args7944 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :resync-mfadevice
   [m7946]
   (clojure.core/let
    [credentials7947 (:credentials m7946) args7948 (:args m7946)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7949
      (com.palletops.awaze.common/aws-client :iam credentials7947)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7949
       resyncMFADevice
       (identitymanagement/resync-mfadevice-request
        (clojure.core/nth args7948 0)))))))
  (clojure.core/defn
   resync-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Generate map for resyncMFADevice"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :resync-mfadevice,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   resync-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Call resyncMFADevice"}
   [credentials7951 & args7952]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7953
     (com.palletops.awaze.common/aws-client :iam credentials7951)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7953
      resyncMFADevice
      (identitymanagement/resync-mfadevice-request
       (clojure.core/nth args7952 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-login-profile
   [m7954]
   (clojure.core/let
    [credentials7955 (:credentials m7954) args7956 (:args m7954)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7957
      (com.palletops.awaze.common/aws-client :iam credentials7955)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7957
       updateLoginProfile
       (identitymanagement/update-login-profile-request
        (clojure.core/nth args7956 0)))))))
  (clojure.core/defn
   update-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name password general-progress-listener]}]]),
    :doc "Generate map for updateLoginProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-login-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name password general-progress-listener]}]]),
    :doc "Call updateLoginProfile"}
   [credentials7959 & args7960]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7961
     (com.palletops.awaze.common/aws-client :iam credentials7959)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7961
      updateLoginProfile
      (identitymanagement/update-login-profile-request
       (clojure.core/nth args7960 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-role-policy
   [m7962]
   (clojure.core/let
    [credentials7963 (:credentials m7962) args7964 (:args m7962)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7965
      (com.palletops.awaze.common/aws-client :iam credentials7963)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7965
       putRolePolicy
       (identitymanagement/put-role-policy-request
        (clojure.core/nth args7964 0)))))))
  (clojure.core/defn
   put-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Generate map for putRolePolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :put-role-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Call putRolePolicy"}
   [credentials7967 & args7968]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7969
     (com.palletops.awaze.common/aws-client :iam credentials7967)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7969
      putRolePolicy
      (identitymanagement/put-role-policy-request
       (clojure.core/nth args7968 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-signing-certificate
   [m7970]
   (clojure.core/let
    [credentials7971 (:credentials m7970) args7972 (:args m7970)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7973
      (com.palletops.awaze.common/aws-client :iam credentials7971)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7973
       deleteSigningCertificate
       (identitymanagement/delete-signing-certificate-request
        (clojure.core/nth args7972 0)))))))
  (clojure.core/defn
   delete-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         certificate-id]}]]),
    :doc "Generate map for deleteSigningCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-signing-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         certificate-id]}]]),
    :doc "Call deleteSigningCertificate"}
   [credentials7975 & args7976]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7977
     (com.palletops.awaze.common/aws-client :iam credentials7975)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7977
      deleteSigningCertificate
      (identitymanagement/delete-signing-certificate-request
       (clojure.core/nth args7976 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-samlprovider
   [m7978]
   (clojure.core/let
    [credentials7979 (:credentials m7978) args7980 (:args m7978)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7981
      (com.palletops.awaze.common/aws-client :iam credentials7979)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7981
       deleteSAMLProvider
       (identitymanagement/delete-samlprovider-request
        (clojure.core/nth args7980 0)))))))
  (clojure.core/defn
   delete-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener samlprovider-arn]}]]),
    :doc "Generate map for deleteSAMLProvider"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-samlprovider,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener samlprovider-arn]}]]),
    :doc "Call deleteSAMLProvider"}
   [credentials7983 & args7984]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7985
     (com.palletops.awaze.common/aws-client :iam credentials7983)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7985
      deleteSAMLProvider
      (identitymanagement/delete-samlprovider-request
       (clojure.core/nth args7984 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user
   [m7986]
   (clojure.core/let
    [credentials7987 (:credentials m7986) args7988 (:args m7986)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7989
      (com.palletops.awaze.common/aws-client :iam credentials7987)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7989
       deleteUser
       (identitymanagement/delete-user-request
        (clojure.core/nth args7988 0)))))))
  (clojure.core/defn
   delete-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Generate map for deleteUser"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-user,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Call deleteUser"}
   [credentials7991 & args7992]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7993
     (com.palletops.awaze.common/aws-client :iam credentials7991)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7993
      deleteUser
      (identitymanagement/delete-user-request
       (clojure.core/nth args7992 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :add-user-to-group
   [m7994]
   (clojure.core/let
    [credentials7995 (:credentials m7994) args7996 (:args m7994)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7997
      (com.palletops.awaze.common/aws-client :iam credentials7995)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7997
       addUserToGroup
       (identitymanagement/add-user-to-group-request
        (clojure.core/nth args7996 0)))))))
  (clojure.core/defn
   add-user-to-group-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for addUserToGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :add-user-to-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-user-to-group
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Call addUserToGroup"}
   [credentials7999 & args8000]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8001
     (com.palletops.awaze.common/aws-client :iam credentials7999)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8001
      addUserToGroup
      (identitymanagement/add-user-to-group-request
       (clojure.core/nth args8000 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-account-aliases
   [m8002]
   (clojure.core/let
    [credentials8003 (:credentials m8002) args8004 (:args m8002)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8005
      (com.palletops.awaze.common/aws-client :iam credentials8003)]
     (clojure.core/case
      (clojure.core/count args8004)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8005
        listAccountAliases
        (identitymanagement/list-account-aliases-request
         (clojure.core/nth args8004 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8005
        listAccountAliases))))))
  (clojure.core/defn
   list-account-aliases-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listAccountAliases, listAccountAliases"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-account-aliases,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-account-aliases,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-account-aliases
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]
                [credentials]]),
    :doc "Call listAccountAliases, listAccountAliases"}
   [credentials8007 & args8008]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8009
     (com.palletops.awaze.common/aws-client :iam credentials8007)]
    (clojure.core/case
     (clojure.core/count args8008)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8009
       listAccountAliases
       (identitymanagement/list-account-aliases-request
        (clojure.core/nth args8008 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8009
       listAccountAliases))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-user-from-group
   [m8010]
   (clojure.core/let
    [credentials8011 (:credentials m8010) args8012 (:args m8010)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8013
      (com.palletops.awaze.common/aws-client :iam credentials8011)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8013
       removeUserFromGroup
       (identitymanagement/remove-user-from-group-request
        (clojure.core/nth args8012 0)))))))
  (clojure.core/defn
   remove-user-from-group-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for removeUserFromGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :remove-user-from-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   remove-user-from-group
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Call removeUserFromGroup"}
   [credentials8015 & args8016]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8017
     (com.palletops.awaze.common/aws-client :iam credentials8015)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8017
      removeUserFromGroup
      (identitymanagement/remove-user-from-group-request
       (clojure.core/nth args8016 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-group
   [m8018]
   (clojure.core/let
    [credentials8019 (:credentials m8018) args8020 (:args m8018)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8021
      (com.palletops.awaze.common/aws-client :iam credentials8019)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8021
       updateGroup
       (identitymanagement/update-group-request
        (clojure.core/nth args8020 0)))))))
  (clojure.core/defn
   update-group-map
   {:arglists (quote
               [[credentials
                 {:keys [new-path
                         new-group-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for updateGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-group
   {:arglists (quote
               [[credentials
                 {:keys [new-path
                         new-group-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Call updateGroup"}
   [credentials8023 & args8024]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8025
     (com.palletops.awaze.common/aws-client :iam credentials8023)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8025
      updateGroup
      (identitymanagement/update-group-request
       (clojure.core/nth args8024 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-server-certificate
   [m8026]
   (clojure.core/let
    [credentials8027 (:credentials m8026) args8028 (:args m8026)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8029
      (com.palletops.awaze.common/aws-client :iam credentials8027)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8029
       updateServerCertificate
       (identitymanagement/update-server-certificate-request
        (clojure.core/nth args8028 0)))))))
  (clojure.core/defn
   update-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         new-server-certificate-name
                         new-path
                         general-progress-listener]}]]),
    :doc "Generate map for updateServerCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-server-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         new-server-certificate-name
                         new-path
                         general-progress-listener]}]]),
    :doc "Call updateServerCertificate"}
   [credentials8031 & args8032]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8033
     (com.palletops.awaze.common/aws-client :iam credentials8031)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8033
      updateServerCertificate
      (identitymanagement/update-server-certificate-request
       (clojure.core/nth args8032 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role-policy
   [m8034]
   (clojure.core/let
    [credentials8035 (:credentials m8034) args8036 (:args m8034)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8037
      (com.palletops.awaze.common/aws-client :iam credentials8035)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8037
       deleteRolePolicy
       (identitymanagement/delete-role-policy-request
        (clojure.core/nth args8036 0)))))))
  (clojure.core/defn
   delete-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteRolePolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-role-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Call deleteRolePolicy"}
   [credentials8039 & args8040]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8041
     (com.palletops.awaze.common/aws-client :iam credentials8039)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8041
      deleteRolePolicy
      (identitymanagement/delete-role-policy-request
       (clojure.core/nth args8040 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-access-key
   [m8042]
   (clojure.core/let
    [credentials8043 (:credentials m8042) args8044 (:args m8042)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8045
      (com.palletops.awaze.common/aws-client :iam credentials8043)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8045
       updateAccessKey
       (identitymanagement/update-access-key-request
        (clojure.core/nth args8044 0)))))))
  (clojure.core/defn
   update-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         general-progress-listener
                         access-key-id]}]]),
    :doc "Generate map for updateAccessKey"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-access-key,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-access-key
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         general-progress-listener
                         access-key-id]}]]),
    :doc "Call updateAccessKey"}
   [credentials8047 & args8048]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8049
     (com.palletops.awaze.common/aws-client :iam credentials8047)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8049
      updateAccessKey
      (identitymanagement/update-access-key-request
       (clojure.core/nth args8048 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group
   [m8050]
   (clojure.core/let
    [credentials8051 (:credentials m8050) args8052 (:args m8050)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8053
      (com.palletops.awaze.common/aws-client :iam credentials8051)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8053
       deleteGroup
       (identitymanagement/delete-group-request
        (clojure.core/nth args8052 0)))))))
  (clojure.core/defn
   delete-group-map
   {:arglists (quote
               [[credentials
                 {:keys [group-name general-progress-listener]}]]),
    :doc "Generate map for deleteGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-group
   {:arglists (quote
               [[credentials
                 {:keys [group-name general-progress-listener]}]]),
    :doc "Call deleteGroup"}
   [credentials8055 & args8056]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8057
     (com.palletops.awaze.common/aws-client :iam credentials8055)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8057
      deleteGroup
      (identitymanagement/delete-group-request
       (clojure.core/nth args8056 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-groups-for-user
   [m8058]
   (clojure.core/let
    [credentials8059 (:credentials m8058) args8060 (:args m8058)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8061
      (com.palletops.awaze.common/aws-client :iam credentials8059)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8061
       listGroupsForUser
       (identitymanagement/list-groups-for-user-request
        (clojure.core/nth args8060 0)))))))
  (clojure.core/defn
   list-groups-for-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listGroupsForUser"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-groups-for-user,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-groups-for-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listGroupsForUser"}
   [credentials8063 & args8064]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8065
     (com.palletops.awaze.common/aws-client :iam credentials8063)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8065
      listGroupsForUser
      (identitymanagement/list-groups-for-user-request
       (clojure.core/nth args8064 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-user-policy
   [m8066]
   (clojure.core/let
    [credentials8067 (:credentials m8066) args8068 (:args m8066)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8069
      (com.palletops.awaze.common/aws-client :iam credentials8067)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8069
       putUserPolicy
       (identitymanagement/put-user-policy-request
        (clojure.core/nth args8068 0)))))))
  (clojure.core/defn
   put-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Generate map for putUserPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :put-user-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Call putUserPolicy"}
   [credentials8071 & args8072]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8073
     (com.palletops.awaze.common/aws-client :iam credentials8071)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8073
      putUserPolicy
      (identitymanagement/put-user-policy-request
       (clojure.core/nth args8072 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-role
   [m8074]
   (clojure.core/let
    [credentials8075 (:credentials m8074) args8076 (:args m8074)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8077
      (com.palletops.awaze.common/aws-client :iam credentials8075)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8077
       getRole
       (identitymanagement/get-role-request
        (clojure.core/nth args8076 0)))))))
  (clojure.core/defn
   get-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name general-progress-listener]}]]),
    :doc "Generate map for getRole"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-role,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name general-progress-listener]}]]),
    :doc "Call getRole"}
   [credentials8079 & args8080]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8081
     (com.palletops.awaze.common/aws-client :iam credentials8079)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8081
      getRole
      (identitymanagement/get-role-request
       (clojure.core/nth args8080 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-password-policy
   [m8082]
   (clojure.core/let
    [credentials8083 (:credentials m8082) args8084 (:args m8082)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8085
      (com.palletops.awaze.common/aws-client :iam credentials8083)]
     (clojure.core/case
      (clojure.core/count args8084)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8085
        getAccountPasswordPolicy
        (identitymanagement/get-account-password-policy-request
         (clojure.core/nth args8084 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8085
        getAccountPasswordPolicy))))))
  (clojure.core/defn
   get-account-password-policy-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for getAccountPasswordPolicy, getAccountPasswordPolicy"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :get-account-password-policy,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-account-password-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-account-password-policy
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call getAccountPasswordPolicy, getAccountPasswordPolicy"}
   [credentials8087 & args8088]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8089
     (com.palletops.awaze.common/aws-client :iam credentials8087)]
    (clojure.core/case
     (clojure.core/count args8088)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8089
       getAccountPasswordPolicy
       (identitymanagement/get-account-password-policy-request
        (clojure.core/nth args8088 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8089
       getAccountPasswordPolicy))))))
 (do
  (clojure.core/defmethod
   iam
   :list-access-keys
   [m8090]
   (clojure.core/let
    [credentials8091 (:credentials m8090) args8092 (:args m8090)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8093
      (com.palletops.awaze.common/aws-client :iam credentials8091)]
     (clojure.core/case
      (clojure.core/count args8092)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8093
        listAccessKeys))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8093
        listAccessKeys
        (identitymanagement/list-access-keys-request
         (clojure.core/nth args8092 0))))))))
  (clojure.core/defn
   list-access-keys-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listAccessKeys, listAccessKeys"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-access-keys,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-access-keys,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-access-keys
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listAccessKeys, listAccessKeys"}
   [credentials8095 & args8096]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8097
     (com.palletops.awaze.common/aws-client :iam credentials8095)]
    (clojure.core/case
     (clojure.core/count args8096)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8097
       listAccessKeys))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8097
       listAccessKeys
       (identitymanagement/list-access-keys-request
        (clojure.core/nth args8096 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-alias
   [m8098]
   (clojure.core/let
    [credentials8099 (:credentials m8098) args8100 (:args m8098)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8101
      (com.palletops.awaze.common/aws-client :iam credentials8099)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8101
       deleteAccountAlias
       (identitymanagement/delete-account-alias-request
        (clojure.core/nth args8100 0)))))))
  (clojure.core/defn
   delete-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener account-alias]}]]),
    :doc "Generate map for deleteAccountAlias"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-account-alias,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener account-alias]}]]),
    :doc "Call deleteAccountAlias"}
   [credentials8103 & args8104]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8105
     (com.palletops.awaze.common/aws-client :iam credentials8103)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8105
      deleteAccountAlias
      (identitymanagement/delete-account-alias-request
       (clojure.core/nth args8104 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-login-profile
   [m8106]
   (clojure.core/let
    [credentials8107 (:credentials m8106) args8108 (:args m8106)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8109
      (com.palletops.awaze.common/aws-client :iam credentials8107)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8109
       getLoginProfile
       (identitymanagement/get-login-profile-request
        (clojure.core/nth args8108 0)))))))
  (clojure.core/defn
   get-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Generate map for getLoginProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-login-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Call getLoginProfile"}
   [credentials8111 & args8112]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8113
     (com.palletops.awaze.common/aws-client :iam credentials8111)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8113
      getLoginProfile
      (identitymanagement/get-login-profile-request
       (clojure.core/nth args8112 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-login-profile
   [m8114]
   (clojure.core/let
    [credentials8115 (:credentials m8114) args8116 (:args m8114)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8117
      (com.palletops.awaze.common/aws-client :iam credentials8115)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8117
       createLoginProfile
       (identitymanagement/create-login-profile-request
        (clojure.core/nth args8116 0)))))))
  (clojure.core/defn
   create-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name password general-progress-listener]}]]),
    :doc "Generate map for createLoginProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-login-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name password general-progress-listener]}]]),
    :doc "Call createLoginProfile"}
   [credentials8119 & args8120]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8121
     (com.palletops.awaze.common/aws-client :iam credentials8119)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8121
      createLoginProfile
      (identitymanagement/create-login-profile-request
       (clojure.core/nth args8120 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-groups
   [m8122]
   (clojure.core/let
    [credentials8123 (:credentials m8122) args8124 (:args m8122)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8125
      (com.palletops.awaze.common/aws-client :iam credentials8123)]
     (clojure.core/case
      (clojure.core/count args8124)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8125
        listGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8125
        listGroups
        (identitymanagement/list-groups-request
         (clojure.core/nth args8124 0))))))))
  (clojure.core/defn
   list-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listGroups, listGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listGroups, listGroups"}
   [credentials8127 & args8128]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8129
     (com.palletops.awaze.common/aws-client :iam credentials8127)]
    (clojure.core/case
     (clojure.core/count args8128)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8129
       listGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8129
       listGroups
       (identitymanagement/list-groups-request
        (clojure.core/nth args8128 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-summary
   [m8130]
   (clojure.core/let
    [credentials8131 (:credentials m8130) args8132 (:args m8130)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8133
      (com.palletops.awaze.common/aws-client :iam credentials8131)]
     (clojure.core/case
      (clojure.core/count args8132)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8133
        getAccountSummary))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8133
        getAccountSummary
        (identitymanagement/get-account-summary-request
         (clojure.core/nth args8132 0))))))))
  (clojure.core/defn
   get-account-summary-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for getAccountSummary, getAccountSummary"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :get-account-summary,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-account-summary,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-account-summary
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call getAccountSummary, getAccountSummary"}
   [credentials8135 & args8136]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8137
     (com.palletops.awaze.common/aws-client :iam credentials8135)]
    (clojure.core/case
     (clojure.core/count args8136)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8137
       getAccountSummary))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8137
       getAccountSummary
       (identitymanagement/get-account-summary-request
        (clojure.core/nth args8136 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-password-policy
   [m8138]
   (clojure.core/let
    [credentials8139 (:credentials m8138) args8140 (:args m8138)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8141
      (com.palletops.awaze.common/aws-client :iam credentials8139)]
     (clojure.core/case
      (clojure.core/count args8140)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8141
        deleteAccountPasswordPolicy))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8141
        deleteAccountPasswordPolicy
        (identitymanagement/delete-account-password-policy-request
         (clojure.core/nth args8140 0))))))))
  (clojure.core/defn
   delete-account-password-policy-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :delete-account-password-policy,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-account-password-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-account-password-policy
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   [credentials8143 & args8144]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8145
     (com.palletops.awaze.common/aws-client :iam credentials8143)]
    (clojure.core/case
     (clojure.core/count args8144)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8145
       deleteAccountPasswordPolicy))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8145
       deleteAccountPasswordPolicy
       (identitymanagement/delete-account-password-policy-request
        (clojure.core/nth args8144 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-instance-profile
   [m8146]
   (clojure.core/let
    [credentials8147 (:credentials m8146) args8148 (:args m8146)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8149
      (com.palletops.awaze.common/aws-client :iam credentials8147)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8149
       getInstanceProfile
       (identitymanagement/get-instance-profile-request
        (clojure.core/nth args8148 0)))))))
  (clojure.core/defn
   get-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-profile-name
                         general-progress-listener]}]]),
    :doc "Generate map for getInstanceProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-instance-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [instance-profile-name
                         general-progress-listener]}]]),
    :doc "Call getInstanceProfile"}
   [credentials8151 & args8152]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8153
     (com.palletops.awaze.common/aws-client :iam credentials8151)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8153
      getInstanceProfile
      (identitymanagement/get-instance-profile-request
       (clojure.core/nth args8152 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user
   [m8154]
   (clojure.core/let
    [credentials8155 (:credentials m8154) args8156 (:args m8154)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8157
      (com.palletops.awaze.common/aws-client :iam credentials8155)]
     (clojure.core/case
      (clojure.core/count args8156)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8157
        getUser))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8157
        getUser
        (identitymanagement/get-user-request
         (clojure.core/nth args8156 0))))))))
  (clojure.core/defn
   get-user-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Generate map for getUser, getUser"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :get-user,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-user,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-user
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Call getUser, getUser"}
   [credentials8159 & args8160]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8161
     (com.palletops.awaze.common/aws-client :iam credentials8159)]
    (clojure.core/case
     (clojure.core/count args8160)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8161
       getUser))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8161
       getUser
       (identitymanagement/get-user-request
        (clojure.core/nth args8160 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :update-samlprovider
   [m8162]
   (clojure.core/let
    [credentials8163 (:credentials m8162) args8164 (:args m8162)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8165
      (com.palletops.awaze.common/aws-client :iam credentials8163)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8165
       updateSAMLProvider
       (identitymanagement/update-samlprovider-request
        (clojure.core/nth args8164 0)))))))
  (clojure.core/defn
   update-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         samlprovider-arn
                         samlmetadata-document]}]]),
    :doc "Generate map for updateSAMLProvider"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-samlprovider,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         samlprovider-arn
                         samlmetadata-document]}]]),
    :doc "Call updateSAMLProvider"}
   [credentials8167 & args8168]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8169
     (com.palletops.awaze.common/aws-client :iam credentials8167)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8169
      updateSAMLProvider
      (identitymanagement/update-samlprovider-request
       (clojure.core/nth args8168 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-samlprovider
   [m8170]
   (clojure.core/let
    [credentials8171 (:credentials m8170) args8172 (:args m8170)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8173
      (com.palletops.awaze.common/aws-client :iam credentials8171)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8173
       createSAMLProvider
       (identitymanagement/create-samlprovider-request
        (clojure.core/nth args8172 0)))))))
  (clojure.core/defn
   create-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [name
                         general-progress-listener
                         samlmetadata-document]}]]),
    :doc "Generate map for createSAMLProvider"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-samlprovider,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [name
                         general-progress-listener
                         samlmetadata-document]}]]),
    :doc "Call createSAMLProvider"}
   [credentials8175 & args8176]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8177
     (com.palletops.awaze.common/aws-client :iam credentials8175)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8177
      createSAMLProvider
      (identitymanagement/create-samlprovider-request
       (clojure.core/nth args8176 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-samlproviders
   [m8178]
   (clojure.core/let
    [credentials8179 (:credentials m8178) args8180 (:args m8178)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8181
      (com.palletops.awaze.common/aws-client :iam credentials8179)]
     (clojure.core/case
      (clojure.core/count args8180)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8181
        listSAMLProviders
        (identitymanagement/list-samlproviders-request
         (clojure.core/nth args8180 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8181
        listSAMLProviders))))))
  (clojure.core/defn
   list-samlproviders-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listSAMLProviders, listSAMLProviders"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-samlproviders,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-samlproviders,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-samlproviders
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call listSAMLProviders, listSAMLProviders"}
   [credentials8183 & args8184]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8185
     (com.palletops.awaze.common/aws-client :iam credentials8183)]
    (clojure.core/case
     (clojure.core/count args8184)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8185
       listSAMLProviders
       (identitymanagement/list-samlproviders-request
        (clojure.core/nth args8184 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8185
       listSAMLProviders))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-virtual-mfadevice
   [m8186]
   (clojure.core/let
    [credentials8187 (:credentials m8186) args8188 (:args m8186)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8189
      (com.palletops.awaze.common/aws-client :iam credentials8187)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8189
       deleteVirtualMFADevice
       (identitymanagement/delete-virtual-mfadevice-request
        (clojure.core/nth args8188 0)))))))
  (clojure.core/defn
   delete-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number general-progress-listener]}]]),
    :doc "Generate map for deleteVirtualMFADevice"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-virtual-mfadevice,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number general-progress-listener]}]]),
    :doc "Call deleteVirtualMFADevice"}
   [credentials8191 & args8192]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8193
     (com.palletops.awaze.common/aws-client :iam credentials8191)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8193
      deleteVirtualMFADevice
      (identitymanagement/delete-virtual-mfadevice-request
       (clojure.core/nth args8192 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-access-key
   [m8194]
   (clojure.core/let
    [credentials8195 (:credentials m8194) args8196 (:args m8194)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8197
      (com.palletops.awaze.common/aws-client :iam credentials8195)]
     (clojure.core/case
      (clojure.core/count args8196)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8197
        createAccessKey))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8197
        createAccessKey
        (identitymanagement/create-access-key-request
         (clojure.core/nth args8196 0))))))))
  (clojure.core/defn
   create-access-key-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Generate map for createAccessKey, createAccessKey"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :create-access-key,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-access-key,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-access-key
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Call createAccessKey, createAccessKey"}
   [credentials8199 & args8200]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8201
     (com.palletops.awaze.common/aws-client :iam credentials8199)]
    (clojure.core/case
     (clojure.core/count args8200)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8201
       createAccessKey))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8201
       createAccessKey
       (identitymanagement/create-access-key-request
        (clojure.core/nth args8200 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles
   [m8202]
   (clojure.core/let
    [credentials8203 (:credentials m8202) args8204 (:args m8202)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8205
      (com.palletops.awaze.common/aws-client :iam credentials8203)]
     (clojure.core/case
      (clojure.core/count args8204)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8205
        listInstanceProfiles
        (identitymanagement/list-instance-profiles-request
         (clojure.core/nth args8204 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8205
        listInstanceProfiles))))))
  (clojure.core/defn
   list-instance-profiles-map
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listInstanceProfiles, listInstanceProfiles"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-instance-profiles,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-instance-profiles,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-instance-profiles
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call listInstanceProfiles, listInstanceProfiles"}
   [credentials8207 & args8208]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8209
     (com.palletops.awaze.common/aws-client :iam credentials8207)]
    (clojure.core/case
     (clojure.core/count args8208)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8209
       listInstanceProfiles
       (identitymanagement/list-instance-profiles-request
        (clojure.core/nth args8208 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8209
       listInstanceProfiles))))))
 (do
  (clojure.core/defmethod
   iam
   :put-group-policy
   [m8210]
   (clojure.core/let
    [credentials8211 (:credentials m8210) args8212 (:args m8210)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8213
      (com.palletops.awaze.common/aws-client :iam credentials8211)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8213
       putGroupPolicy
       (identitymanagement/put-group-policy-request
        (clojure.core/nth args8212 0)))))))
  (clojure.core/defn
   put-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         policy-document
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for putGroupPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :put-group-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         policy-document
                         group-name
                         general-progress-listener]}]]),
    :doc "Call putGroupPolicy"}
   [credentials8215 & args8216]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8217
     (com.palletops.awaze.common/aws-client :iam credentials8215)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8217
      putGroupPolicy
      (identitymanagement/put-group-policy-request
       (clojure.core/nth args8216 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-server-certificate
   [m8218]
   (clojure.core/let
    [credentials8219 (:credentials m8218) args8220 (:args m8218)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8221
      (com.palletops.awaze.common/aws-client :iam credentials8219)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8221
       getServerCertificate
       (identitymanagement/get-server-certificate-request
        (clojure.core/nth args8220 0)))))))
  (clojure.core/defn
   get-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         general-progress-listener]}]]),
    :doc "Generate map for getServerCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-server-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         general-progress-listener]}]]),
    :doc "Call getServerCertificate"}
   [credentials8223 & args8224]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8225
     (com.palletops.awaze.common/aws-client :iam credentials8223)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8225
      getServerCertificate
      (identitymanagement/get-server-certificate-request
       (clojure.core/nth args8224 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-server-certificate
   [m8226]
   (clojure.core/let
    [credentials8227 (:credentials m8226) args8228 (:args m8226)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8229
      (com.palletops.awaze.common/aws-client :iam credentials8227)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8229
       uploadServerCertificate
       (identitymanagement/upload-server-certificate-request
        (clojure.core/nth args8228 0)))))))
  (clojure.core/defn
   upload-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [certificate-chain
                         certificate-body
                         general-progress-listener
                         private-key
                         server-certificate-name
                         path]}]]),
    :doc "Generate map for uploadServerCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :upload-server-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   upload-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [certificate-chain
                         certificate-body
                         general-progress-listener
                         private-key
                         server-certificate-name
                         path]}]]),
    :doc "Call uploadServerCertificate"}
   [credentials8231 & args8232]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8233
     (com.palletops.awaze.common/aws-client :iam credentials8231)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8233
      uploadServerCertificate
      (identitymanagement/upload-server-certificate-request
       (clojure.core/nth args8232 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-role-policies
   [m8234]
   (clojure.core/let
    [credentials8235 (:credentials m8234) args8236 (:args m8234)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8237
      (com.palletops.awaze.common/aws-client :iam credentials8235)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8237
       listRolePolicies
       (identitymanagement/list-role-policies-request
        (clojure.core/nth args8236 0)))))))
  (clojure.core/defn
   list-role-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listRolePolicies"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-role-policies,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-role-policies
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listRolePolicies"}
   [credentials8239 & args8240]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8241
     (com.palletops.awaze.common/aws-client :iam credentials8239)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8241
      listRolePolicies
      (identitymanagement/list-role-policies-request
       (clojure.core/nth args8240 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :add-role-to-instance-profile
   [m8242]
   (clojure.core/let
    [credentials8243 (:credentials m8242) args8244 (:args m8242)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8245
      (com.palletops.awaze.common/aws-client :iam credentials8243)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8245
       addRoleToInstanceProfile
       (identitymanagement/add-role-to-instance-profile-request
        (clojure.core/nth args8244 0)))))))
  (clojure.core/defn
   add-role-to-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Generate map for addRoleToInstanceProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :add-role-to-instance-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-role-to-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Call addRoleToInstanceProfile"}
   [credentials8247 & args8248]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8249
     (com.palletops.awaze.common/aws-client :iam credentials8247)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8249
      addRoleToInstanceProfile
      (identitymanagement/add-role-to-instance-profile-request
       (clojure.core/nth args8248 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-access-key
   [m8250]
   (clojure.core/let
    [credentials8251 (:credentials m8250) args8252 (:args m8250)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8253
      (com.palletops.awaze.common/aws-client :iam credentials8251)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8253
       deleteAccessKey
       (identitymanagement/delete-access-key-request
        (clojure.core/nth args8252 0)))))))
  (clojure.core/defn
   delete-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         access-key-id]}]]),
    :doc "Generate map for deleteAccessKey"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-access-key,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-access-key
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         access-key-id]}]]),
    :doc "Call deleteAccessKey"}
   [credentials8255 & args8256]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8257
     (com.palletops.awaze.common/aws-client :iam credentials8255)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8257
      deleteAccessKey
      (identitymanagement/delete-access-key-request
       (clojure.core/nth args8256 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role
   [m8258]
   (clojure.core/let
    [credentials8259 (:credentials m8258) args8260 (:args m8258)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8261
      (com.palletops.awaze.common/aws-client :iam credentials8259)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8261
       deleteRole
       (identitymanagement/delete-role-request
        (clojure.core/nth args8260 0)))))))
  (clojure.core/defn
   delete-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name general-progress-listener]}]]),
    :doc "Generate map for deleteRole"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-role,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name general-progress-listener]}]]),
    :doc "Call deleteRole"}
   [credentials8263 & args8264]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8265
     (com.palletops.awaze.common/aws-client :iam credentials8263)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8265
      deleteRole
      (identitymanagement/delete-role-request
       (clojure.core/nth args8264 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-virtual-mfadevice
   [m8266]
   (clojure.core/let
    [credentials8267 (:credentials m8266) args8268 (:args m8266)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8269
      (com.palletops.awaze.common/aws-client :iam credentials8267)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8269
       createVirtualMFADevice
       (identitymanagement/create-virtual-mfadevice-request
        (clojure.core/nth args8268 0)))))))
  (clojure.core/defn
   create-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-mfadevice-name
                         path
                         general-progress-listener]}]]),
    :doc "Generate map for createVirtualMFADevice"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-virtual-mfadevice,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [virtual-mfadevice-name
                         path
                         general-progress-listener]}]]),
    :doc "Call createVirtualMFADevice"}
   [credentials8271 & args8272]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8273
     (com.palletops.awaze.common/aws-client :iam credentials8271)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8273
      createVirtualMFADevice
      (identitymanagement/create-virtual-mfadevice-request
       (clojure.core/nth args8272 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-group-policies
   [m8274]
   (clojure.core/let
    [credentials8275 (:credentials m8274) args8276 (:args m8274)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8277
      (com.palletops.awaze.common/aws-client :iam credentials8275)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8277
       listGroupPolicies
       (identitymanagement/list-group-policies-request
        (clojure.core/nth args8276 0)))))))
  (clojure.core/defn
   list-group-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for listGroupPolicies"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-group-policies,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-group-policies
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         group-name
                         general-progress-listener]}]]),
    :doc "Call listGroupPolicies"}
   [credentials8279 & args8280]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8281
     (com.palletops.awaze.common/aws-client :iam credentials8279)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8281
      listGroupPolicies
      (identitymanagement/list-group-policies-request
       (clojure.core/nth args8280 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group-policy
   [m8282]
   (clojure.core/let
    [credentials8283 (:credentials m8282) args8284 (:args m8282)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8285
      (com.palletops.awaze.common/aws-client :iam credentials8283)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8285
       getGroupPolicy
       (identitymanagement/get-group-policy-request
        (clojure.core/nth args8284 0)))))))
  (clojure.core/defn
   get-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for getGroupPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-group-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Call getGroupPolicy"}
   [credentials8287 & args8288]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8289
     (com.palletops.awaze.common/aws-client :iam credentials8287)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8289
      getGroupPolicy
      (identitymanagement/get-group-policy-request
       (clojure.core/nth args8288 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-server-certificates
   [m8290]
   (clojure.core/let
    [credentials8291 (:credentials m8290) args8292 (:args m8290)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8293
      (com.palletops.awaze.common/aws-client :iam credentials8291)]
     (clojure.core/case
      (clojure.core/count args8292)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8293
        listServerCertificates
        (identitymanagement/list-server-certificates-request
         (clojure.core/nth args8292 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8293
        listServerCertificates))))))
  (clojure.core/defn
   list-server-certificates-map
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listServerCertificates, listServerCertificates"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-server-certificates,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-server-certificates,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-server-certificates
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call listServerCertificates, listServerCertificates"}
   [credentials8295 & args8296]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8297
     (com.palletops.awaze.common/aws-client :iam credentials8295)]
    (clojure.core/case
     (clojure.core/count args8296)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8297
       listServerCertificates
       (identitymanagement/list-server-certificates-request
        (clojure.core/nth args8296 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8297
       listServerCertificates))))))
 (do
  (clojure.core/defmethod
   iam
   :update-account-password-policy
   [m8298]
   (clojure.core/let
    [credentials8299 (:credentials m8298) args8300 (:args m8298)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8301
      (com.palletops.awaze.common/aws-client :iam credentials8299)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8301
       updateAccountPasswordPolicy
       (identitymanagement/update-account-password-policy-request
        (clojure.core/nth args8300 0)))))))
  (clojure.core/defn
   update-account-password-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [require-uppercase-characters
                         allow-users-to-change-password
                         general-progress-listener
                         require-numbers
                         require-lowercase-characters
                         minimum-password-length
                         require-symbols]}]]),
    :doc "Generate map for updateAccountPasswordPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-account-password-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-account-password-policy
   {:arglists (quote
               [[credentials
                 {:keys [require-uppercase-characters
                         allow-users-to-change-password
                         general-progress-listener
                         require-numbers
                         require-lowercase-characters
                         minimum-password-length
                         require-symbols]}]]),
    :doc "Call updateAccountPasswordPolicy"}
   [credentials8303 & args8304]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8305
     (com.palletops.awaze.common/aws-client :iam credentials8303)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8305
      updateAccountPasswordPolicy
      (identitymanagement/update-account-password-policy-request
       (clojure.core/nth args8304 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-group
   [m8306]
   (clojure.core/let
    [credentials8307 (:credentials m8306) args8308 (:args m8306)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8309
      (com.palletops.awaze.common/aws-client :iam credentials8307)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8309
       createGroup
       (identitymanagement/create-group-request
        (clojure.core/nth args8308 0)))))))
  (clojure.core/defn
   create-group-map
   {:arglists (quote
               [[credentials
                 {:keys [path group-name general-progress-listener]}]]),
    :doc "Generate map for createGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-group
   {:arglists (quote
               [[credentials
                 {:keys [path group-name general-progress-listener]}]]),
    :doc "Call createGroup"}
   [credentials8311 & args8312]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8313
     (com.palletops.awaze.common/aws-client :iam credentials8311)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8313
      createGroup
      (identitymanagement/create-group-request
       (clojure.core/nth args8312 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles-for-role
   [m8314]
   (clojure.core/let
    [credentials8315 (:credentials m8314) args8316 (:args m8314)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8317
      (com.palletops.awaze.common/aws-client :iam credentials8315)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8317
       listInstanceProfilesForRole
       (identitymanagement/list-instance-profiles-for-role-request
        (clojure.core/nth args8316 0)))))))
  (clojure.core/defn
   list-instance-profiles-for-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listInstanceProfilesForRole"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-instance-profiles-for-role,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-instance-profiles-for-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listInstanceProfilesForRole"}
   [credentials8319 & args8320]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8321
     (com.palletops.awaze.common/aws-client :iam credentials8319)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8321
      listInstanceProfilesForRole
      (identitymanagement/list-instance-profiles-for-role-request
       (clojure.core/nth args8320 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-signing-certificate
   [m8322]
   (clojure.core/let
    [credentials8323 (:credentials m8322) args8324 (:args m8322)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8325
      (com.palletops.awaze.common/aws-client :iam credentials8323)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8325
       uploadSigningCertificate
       (identitymanagement/upload-signing-certificate-request
        (clojure.core/nth args8324 0)))))))
  (clojure.core/defn
   upload-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         certificate-body]}]]),
    :doc "Generate map for uploadSigningCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :upload-signing-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   upload-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         certificate-body]}]]),
    :doc "Call uploadSigningCertificate"}
   [credentials8327 & args8328]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8329
     (com.palletops.awaze.common/aws-client :iam credentials8327)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8329
      uploadSigningCertificate
      (identitymanagement/upload-signing-certificate-request
       (clojure.core/nth args8328 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-server-certificate
   [m8330]
   (clojure.core/let
    [credentials8331 (:credentials m8330) args8332 (:args m8330)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8333
      (com.palletops.awaze.common/aws-client :iam credentials8331)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8333
       deleteServerCertificate
       (identitymanagement/delete-server-certificate-request
        (clojure.core/nth args8332 0)))))))
  (clojure.core/defn
   delete-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteServerCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-server-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         general-progress-listener]}]]),
    :doc "Call deleteServerCertificate"}
   [credentials8335 & args8336]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8337
     (com.palletops.awaze.common/aws-client :iam credentials8335)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8337
      deleteServerCertificate
      (identitymanagement/delete-server-certificate-request
       (clojure.core/nth args8336 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-virtual-mfadevices
   [m8338]
   (clojure.core/let
    [credentials8339 (:credentials m8338) args8340 (:args m8338)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8341
      (com.palletops.awaze.common/aws-client :iam credentials8339)]
     (clojure.core/case
      (clojure.core/count args8340)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8341
        listVirtualMFADevices))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8341
        listVirtualMFADevices
        (identitymanagement/list-virtual-mfadevices-request
         (clojure.core/nth args8340 0))))))))
  (clojure.core/defn
   list-virtual-mfadevices-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-items
                         marker
                         general-progress-listener
                         assignment-status]}]]),
    :doc "Generate map for listVirtualMFADevices, listVirtualMFADevices"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-virtual-mfadevices,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-virtual-mfadevices,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-virtual-mfadevices
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-items
                         marker
                         general-progress-listener
                         assignment-status]}]]),
    :doc "Call listVirtualMFADevices, listVirtualMFADevices"}
   [credentials8343 & args8344]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8345
     (com.palletops.awaze.common/aws-client :iam credentials8343)]
    (clojure.core/case
     (clojure.core/count args8344)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8345
       listVirtualMFADevices))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8345
       listVirtualMFADevices
       (identitymanagement/list-virtual-mfadevices-request
        (clojure.core/nth args8344 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-role-from-instance-profile
   [m8346]
   (clojure.core/let
    [credentials8347 (:credentials m8346) args8348 (:args m8346)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8349
      (com.palletops.awaze.common/aws-client :iam credentials8347)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8349
       removeRoleFromInstanceProfile
       (identitymanagement/remove-role-from-instance-profile-request
        (clojure.core/nth args8348 0)))))))
  (clojure.core/defn
   remove-role-from-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Generate map for removeRoleFromInstanceProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :remove-role-from-instance-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   remove-role-from-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Call removeRoleFromInstanceProfile"}
   [credentials8351 & args8352]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8353
     (com.palletops.awaze.common/aws-client :iam credentials8351)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8353
      removeRoleFromInstanceProfile
      (identitymanagement/remove-role-from-instance-profile-request
       (clojure.core/nth args8352 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-signing-certificates
   [m8354]
   (clojure.core/let
    [credentials8355 (:credentials m8354) args8356 (:args m8354)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8357
      (com.palletops.awaze.common/aws-client :iam credentials8355)]
     (clojure.core/case
      (clojure.core/count args8356)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8357
        listSigningCertificates
        (identitymanagement/list-signing-certificates-request
         (clojure.core/nth args8356 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8357
        listSigningCertificates))))))
  (clojure.core/defn
   list-signing-certificates-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listSigningCertificates, listSigningCertificates"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-signing-certificates,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-signing-certificates,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-signing-certificates
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call listSigningCertificates, listSigningCertificates"}
   [credentials8359 & args8360]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8361
     (com.palletops.awaze.common/aws-client :iam credentials8359)]
    (clojure.core/case
     (clojure.core/count args8360)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8361
       listSigningCertificates
       (identitymanagement/list-signing-certificates-request
        (clojure.core/nth args8360 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8361
       listSigningCertificates))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-instance-profile
   [m8362]
   (clojure.core/let
    [credentials8363 (:credentials m8362) args8364 (:args m8362)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8365
      (com.palletops.awaze.common/aws-client :iam credentials8363)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8365
       deleteInstanceProfile
       (identitymanagement/delete-instance-profile-request
        (clojure.core/nth args8364 0)))))))
  (clojure.core/defn
   delete-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-profile-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteInstanceProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-instance-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [instance-profile-name
                         general-progress-listener]}]]),
    :doc "Call deleteInstanceProfile"}
   [credentials8367 & args8368]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8369
     (com.palletops.awaze.common/aws-client :iam credentials8367)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8369
      deleteInstanceProfile
      (identitymanagement/delete-instance-profile-request
       (clojure.core/nth args8368 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-mfadevices
   [m8370]
   (clojure.core/let
    [credentials8371 (:credentials m8370) args8372 (:args m8370)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8373
      (com.palletops.awaze.common/aws-client :iam credentials8371)]
     (clojure.core/case
      (clojure.core/count args8372)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8373
        listMFADevices))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8373
        listMFADevices
        (identitymanagement/list-mfadevices-request
         (clojure.core/nth args8372 0))))))))
  (clojure.core/defn
   list-mfadevices-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listMFADevices, listMFADevices"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-mfadevices,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-mfadevices,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-mfadevices
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listMFADevices, listMFADevices"}
   [credentials8375 & args8376]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8377
     (com.palletops.awaze.common/aws-client :iam credentials8375)]
    (clojure.core/case
     (clojure.core/count args8376)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8377
       listMFADevices))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8377
       listMFADevices
       (identitymanagement/list-mfadevices-request
        (clojure.core/nth args8376 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user-policy
   [m8378]
   (clojure.core/let
    [credentials8379 (:credentials m8378) args8380 (:args m8378)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8381
      (com.palletops.awaze.common/aws-client :iam credentials8379)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8381
       deleteUserPolicy
       (identitymanagement/delete-user-policy-request
        (clojure.core/nth args8380 0)))))))
  (clojure.core/defn
   delete-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteUserPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-user-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Call deleteUserPolicy"}
   [credentials8383 & args8384]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8385
     (com.palletops.awaze.common/aws-client :iam credentials8383)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8385
      deleteUserPolicy
      (identitymanagement/delete-user-policy-request
       (clojure.core/nth args8384 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-account-alias
   [m8386]
   (clojure.core/let
    [credentials8387 (:credentials m8386) args8388 (:args m8386)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8389
      (com.palletops.awaze.common/aws-client :iam credentials8387)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8389
       createAccountAlias
       (identitymanagement/create-account-alias-request
        (clojure.core/nth args8388 0)))))))
  (clojure.core/defn
   create-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener account-alias]}]]),
    :doc "Generate map for createAccountAlias"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-account-alias,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener account-alias]}]]),
    :doc "Call createAccountAlias"}
   [credentials8391 & args8392]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8393
     (com.palletops.awaze.common/aws-client :iam credentials8391)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8393
      createAccountAlias
      (identitymanagement/create-account-alias-request
       (clojure.core/nth args8392 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-signing-certificate
   [m8394]
   (clojure.core/let
    [credentials8395 (:credentials m8394) args8396 (:args m8394)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8397
      (com.palletops.awaze.common/aws-client :iam credentials8395)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8397
       updateSigningCertificate
       (identitymanagement/update-signing-certificate-request
        (clojure.core/nth args8396 0)))))))
  (clojure.core/defn
   update-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         general-progress-listener
                         certificate-id]}]]),
    :doc "Generate map for updateSigningCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-signing-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         general-progress-listener
                         certificate-id]}]]),
    :doc "Call updateSigningCertificate"}
   [credentials8399 & args8400]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8401
     (com.palletops.awaze.common/aws-client :iam credentials8399)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8401
      updateSigningCertificate
      (identitymanagement/update-signing-certificate-request
       (clojure.core/nth args8400 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-assume-role-policy
   [m8402]
   (clojure.core/let
    [credentials8403 (:credentials m8402) args8404 (:args m8402)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8405
      (com.palletops.awaze.common/aws-client :iam credentials8403)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8405
       updateAssumeRolePolicy
       (identitymanagement/update-assume-role-policy-request
        (clojure.core/nth args8404 0)))))))
  (clojure.core/defn
   update-assume-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Generate map for updateAssumeRolePolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-assume-role-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-assume-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Call updateAssumeRolePolicy"}
   [credentials8407 & args8408]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8409
     (com.palletops.awaze.common/aws-client :iam credentials8407)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8409
      updateAssumeRolePolicy
      (identitymanagement/update-assume-role-policy-request
       (clojure.core/nth args8408 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-roles
   [m8410]
   (clojure.core/let
    [credentials8411 (:credentials m8410) args8412 (:args m8410)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8413
      (com.palletops.awaze.common/aws-client :iam credentials8411)]
     (clojure.core/case
      (clojure.core/count args8412)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8413
        listRoles))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8413
        listRoles
        (identitymanagement/list-roles-request
         (clojure.core/nth args8412 0))))))))
  (clojure.core/defn
   list-roles-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listRoles, listRoles"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-roles,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-roles,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-roles
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listRoles, listRoles"}
   [credentials8415 & args8416]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8417
     (com.palletops.awaze.common/aws-client :iam credentials8415)]
    (clojure.core/case
     (clojure.core/count args8416)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8417
       listRoles))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8417
       listRoles
       (identitymanagement/list-roles-request
        (clojure.core/nth args8416 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-user-policies
   [m8418]
   (clojure.core/let
    [credentials8419 (:credentials m8418) args8420 (:args m8418)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8421
      (com.palletops.awaze.common/aws-client :iam credentials8419)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8421
       listUserPolicies
       (identitymanagement/list-user-policies-request
        (clojure.core/nth args8420 0)))))))
  (clojure.core/defn
   list-user-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listUserPolicies"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-user-policies,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-user-policies
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listUserPolicies"}
   [credentials8423 & args8424]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8425
     (com.palletops.awaze.common/aws-client :iam credentials8423)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8425
      listUserPolicies
      (identitymanagement/list-user-policies-request
       (clojure.core/nth args8424 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-login-profile
   [m8426]
   (clojure.core/let
    [credentials8427 (:credentials m8426) args8428 (:args m8426)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8429
      (com.palletops.awaze.common/aws-client :iam credentials8427)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8429
       deleteLoginProfile
       (identitymanagement/delete-login-profile-request
        (clojure.core/nth args8428 0)))))))
  (clojure.core/defn
   delete-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Generate map for deleteLoginProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-login-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Call deleteLoginProfile"}
   [credentials8431 & args8432]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8433
     (com.palletops.awaze.common/aws-client :iam credentials8431)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8433
      deleteLoginProfile
      (identitymanagement/delete-login-profile-request
       (clojure.core/nth args8432 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :enable-mfadevice
   [m8434]
   (clojure.core/let
    [credentials8435 (:credentials m8434) args8436 (:args m8434)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8437
      (com.palletops.awaze.common/aws-client :iam credentials8435)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8437
       enableMFADevice
       (identitymanagement/enable-mfadevice-request
        (clojure.core/nth args8436 0)))))))
  (clojure.core/defn
   enable-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Generate map for enableMFADevice"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :enable-mfadevice,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Call enableMFADevice"}
   [credentials8439 & args8440]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8441
     (com.palletops.awaze.common/aws-client :iam credentials8439)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8441
      enableMFADevice
      (identitymanagement/enable-mfadevice-request
       (clojure.core/nth args8440 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-samlprovider
   [m8442]
   (clojure.core/let
    [credentials8443 (:credentials m8442) args8444 (:args m8442)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8445
      (com.palletops.awaze.common/aws-client :iam credentials8443)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8445
       getSAMLProvider
       (identitymanagement/get-samlprovider-request
        (clojure.core/nth args8444 0)))))))
  (clojure.core/defn
   get-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener samlprovider-arn]}]]),
    :doc "Generate map for getSAMLProvider"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-samlprovider,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener samlprovider-arn]}]]),
    :doc "Call getSAMLProvider"}
   [credentials8447 & args8448]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8449
     (com.palletops.awaze.common/aws-client :iam credentials8447)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8449
      getSAMLProvider
      (identitymanagement/get-samlprovider-request
       (clojure.core/nth args8448 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group
   [m8450]
   (clojure.core/let
    [credentials8451 (:credentials m8450) args8452 (:args m8450)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8453
      (com.palletops.awaze.common/aws-client :iam credentials8451)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8453
       getGroup
       (identitymanagement/get-group-request
        (clojure.core/nth args8452 0)))))))
  (clojure.core/defn
   get-group-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for getGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-group
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         group-name
                         general-progress-listener]}]]),
    :doc "Call getGroup"}
   [credentials8455 & args8456]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8457
     (com.palletops.awaze.common/aws-client :iam credentials8455)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8457
      getGroup
      (identitymanagement/get-group-request
       (clojure.core/nth args8456 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group-policy
   [m8458]
   (clojure.core/let
    [credentials8459 (:credentials m8458) args8460 (:args m8458)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8461
      (com.palletops.awaze.common/aws-client :iam credentials8459)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8461
       deleteGroupPolicy
       (identitymanagement/delete-group-policy-request
        (clojure.core/nth args8460 0)))))))
  (clojure.core/defn
   delete-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteGroupPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-group-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Call deleteGroupPolicy"}
   [credentials8463 & args8464]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8465
     (com.palletops.awaze.common/aws-client :iam credentials8463)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8465
      deleteGroupPolicy
      (identitymanagement/delete-group-policy-request
       (clojure.core/nth args8464 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-instance-profile
   [m8466]
   (clojure.core/let
    [credentials8467 (:credentials m8466) args8468 (:args m8466)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8469
      (com.palletops.awaze.common/aws-client :iam credentials8467)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8469
       createInstanceProfile
       (identitymanagement/create-instance-profile-request
        (clojure.core/nth args8468 0)))))))
  (clojure.core/defn
   create-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Generate map for createInstanceProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-instance-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [path
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Call createInstanceProfile"}
   [credentials8471 & args8472]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8473
     (com.palletops.awaze.common/aws-client :iam credentials8471)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8473
      createInstanceProfile
      (identitymanagement/create-instance-profile-request
       (clojure.core/nth args8472 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-user
   [m8474]
   (clojure.core/let
    [credentials8475 (:credentials m8474) args8476 (:args m8474)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8477
      (com.palletops.awaze.common/aws-client :iam credentials8475)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8477
       updateUser
       (identitymanagement/update-user-request
        (clojure.core/nth args8476 0)))))))
  (clojure.core/defn
   update-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         new-user-name
                         new-path
                         general-progress-listener]}]]),
    :doc "Generate map for updateUser"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-user,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         new-user-name
                         new-path
                         general-progress-listener]}]]),
    :doc "Call updateUser"}
   [credentials8479 & args8480]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8481
     (com.palletops.awaze.common/aws-client :iam credentials8479)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8481
      updateUser
      (identitymanagement/update-user-request
       (clojure.core/nth args8480 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-user
   [m8482]
   (clojure.core/let
    [credentials8483 (:credentials m8482) args8484 (:args m8482)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8485
      (com.palletops.awaze.common/aws-client :iam credentials8483)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8485
       createUser
       (identitymanagement/create-user-request
        (clojure.core/nth args8484 0)))))))
  (clojure.core/defn
   create-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name path general-progress-listener]}]]),
    :doc "Generate map for createUser"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-user,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name path general-progress-listener]}]]),
    :doc "Call createUser"}
   [credentials8487 & args8488]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8489
     (com.palletops.awaze.common/aws-client :iam credentials8487)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8489
      createUser
      (identitymanagement/create-user-request
       (clojure.core/nth args8488 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-role
   [m8490]
   (clojure.core/let
    [credentials8491 (:credentials m8490) args8492 (:args m8490)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8493
      (com.palletops.awaze.common/aws-client :iam credentials8491)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8493
       createRole
       (identitymanagement/create-role-request
        (clojure.core/nth args8492 0)))))))
  (clojure.core/defn
   create-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         path
                         general-progress-listener
                         assume-role-policy-document]}]]),
    :doc "Generate map for createRole"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-role,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         path
                         general-progress-listener
                         assume-role-policy-document]}]]),
    :doc "Call createRole"}
   [credentials8495 & args8496]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8497
     (com.palletops.awaze.common/aws-client :iam credentials8495)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8497
      createRole
      (identitymanagement/create-role-request
       (clojure.core/nth args8496 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user-policy
   [m8498]
   (clojure.core/let
    [credentials8499 (:credentials m8498) args8500 (:args m8498)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8501
      (com.palletops.awaze.common/aws-client :iam credentials8499)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8501
       getUserPolicy
       (identitymanagement/get-user-policy-request
        (clojure.core/nth args8500 0)))))))
  (clojure.core/defn
   get-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Generate map for getUserPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-user-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Call getUserPolicy"}
   [credentials8503 & args8504]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8505
     (com.palletops.awaze.common/aws-client :iam credentials8503)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8505
      getUserPolicy
      (identitymanagement/get-user-policy-request
       (clojure.core/nth args8504 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-users
   [m8506]
   (clojure.core/let
    [credentials8507 (:credentials m8506) args8508 (:args m8506)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8509
      (com.palletops.awaze.common/aws-client :iam credentials8507)]
     (clojure.core/case
      (clojure.core/count args8508)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8509
        listUsers
        (identitymanagement/list-users-request
         (clojure.core/nth args8508 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8509
        listUsers))))))
  (clojure.core/defn
   list-users-map
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listUsers, listUsers"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-users,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-users,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-users
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call listUsers, listUsers"}
   [credentials8511 & args8512]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8513
     (com.palletops.awaze.common/aws-client :iam credentials8511)]
    (clojure.core/case
     (clojure.core/count args8512)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8513
       listUsers
       (identitymanagement/list-users-request
        (clojure.core/nth args8512 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8513
       listUsers)))))))
