(ns
 com.palletops.awaze.elasticmapreduce
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticmapreduce :as elasticmapreduce]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticmapreduce
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.KeyValue}
key-value
  [m4078]
  (clojure.core/let
   [bean4077
    (new com.amazonaws.services.elasticmapreduce.model.KeyValue)]
   (clojure.core/let
    [v4079 (:value m4078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4079 :com.palletops.awaze.client-builder/undef)
     (. bean4077 setValue (clojure.core/str v4079))))
   (clojure.core/let
    [v4079 (:key m4078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4079 :com.palletops.awaze.client-builder/undef)
     (. bean4077 setKey (clojure.core/str v4079))))
   bean4077))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceRoleType}
instance-role-type
  [m4081]
  (.
   com.amazonaws.services.elasticmapreduce.model.InstanceRoleType
   fromValue
   (clojure.core/name m4081)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ActionOnFailure}
action-on-failure
  [m4084]
  (.
   com.amazonaws.services.elasticmapreduce.model.ActionOnFailure
   fromValue
   (clojure.core/name m4084)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig}
hadoop-jar-step-config
  [m4087]
  (clojure.core/let
   [bean4086
    (new
     com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig)]
   (clojure.core/let
    [v4088
     (:properties m4087 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4088 :com.palletops.awaze.client-builder/undef)
     (.
      bean4086
      setProperties
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4167] (elasticmapreduce/key-value arg4167))
 v4088))))
   (clojure.core/let
    [v4088 (:args m4087 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4088 :com.palletops.awaze.client-builder/undef)
     (.
      bean4086
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4168] (clojure.core/str arg4168))
 v4088))))
   (clojure.core/let
    [v4088 (:jar m4087 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4088 :com.palletops.awaze.client-builder/undef)
     (. bean4086 setJar (clojure.core/str v4088))))
   (clojure.core/let
    [v4088
     (:main-class m4087 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4088 :com.palletops.awaze.client-builder/undef)
     (. bean4086 setMainClass (clojure.core/str v4088))))
   bean4086))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig}
script-bootstrap-action-config
  [m4090]
  (clojure.core/let
   [bean4089
    (new
     com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig)]
   (clojure.core/let
    [v4091 (:args m4090 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4091 :com.palletops.awaze.client-builder/undef)
     (.
      bean4089
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4169] (clojure.core/str arg4169))
 v4091))))
   (clojure.core/let
    [v4091 (:path m4090 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4091 :com.palletops.awaze.client-builder/undef)
     (. bean4089 setPath (clojure.core/str v4091))))
   bean4089))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.PlacementType}
placement-type
  [m4093]
  (clojure.core/let
   [bean4092
    (new com.amazonaws.services.elasticmapreduce.model.PlacementType)]
   (clojure.core/let
    [v4094
     (:availability-zone
      m4093
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4094 :com.palletops.awaze.client-builder/undef)
     (. bean4092 setAvailabilityZone (clojure.core/str v4094))))
   bean4092))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig}
instance-group-config
  [m4096]
  (clojure.core/let
   [bean4095
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig)]
   (clojure.core/let
    [v4097 (:name m4096 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4097 :com.palletops.awaze.client-builder/undef)
     (. bean4095 setName (clojure.core/str v4097))))
   (clojure.core/let
    [v4097
     (:instance-count m4096 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4097 :com.palletops.awaze.client-builder/undef)
     (. bean4095 setInstanceCount (clojure.core/int v4097))))
   (clojure.core/let
    [v4097 (:market m4096 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4097 :com.palletops.awaze.client-builder/undef)
     (. bean4095 setMarket (clojure.core/str v4097))))
   (clojure.core/let
    [v4097
     (:instance-role m4096 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4097 :com.palletops.awaze.client-builder/undef)
     (.
      bean4095
      setInstanceRole
      (elasticmapreduce/instance-role-type v4097))))
   (clojure.core/let
    [v4097
     (:bid-price m4096 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4097 :com.palletops.awaze.client-builder/undef)
     (. bean4095 setBidPrice (clojure.core/str v4097))))
   (clojure.core/let
    [v4097
     (:instance-type m4096 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4097 :com.palletops.awaze.client-builder/undef)
     (. bean4095 setInstanceType (clojure.core/str v4097))))
   bean4095))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.StepConfig}
step-config
  [m4099]
  (clojure.core/let
   [bean4098
    (new com.amazonaws.services.elasticmapreduce.model.StepConfig)]
   (clojure.core/let
    [v4100 (:name m4099 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4100 :com.palletops.awaze.client-builder/undef)
     (. bean4098 setName (clojure.core/str v4100))))
   (clojure.core/let
    [v4100
     (:action-on-failure
      m4099
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4100 :com.palletops.awaze.client-builder/undef)
     (.
      bean4098
      setActionOnFailure
      (elasticmapreduce/action-on-failure v4100))))
   (clojure.core/let
    [v4100
     (:hadoop-jar-step
      m4099
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4100 :com.palletops.awaze.client-builder/undef)
     (.
      bean4098
      setHadoopJarStep
      (elasticmapreduce/hadoop-jar-step-config v4100))))
   bean4098))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig}
bootstrap-action-config
  [m4102]
  (clojure.core/let
   [bean4101
    (new
     com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig)]
   (clojure.core/let
    [v4103 (:name m4102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4103 :com.palletops.awaze.client-builder/undef)
     (. bean4101 setName (clojure.core/str v4103))))
   (clojure.core/let
    [v4103
     (:script-bootstrap-action
      m4102
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4103 :com.palletops.awaze.client-builder/undef)
     (.
      bean4101
      setScriptBootstrapAction
      (elasticmapreduce/script-bootstrap-action-config v4103))))
   bean4101))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig}
supported-product-config
  [m4105]
  (clojure.core/let
   [bean4104
    (new
     com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig)]
   (clojure.core/let
    [v4106 (:name m4105 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4106 :com.palletops.awaze.client-builder/undef)
     (. bean4104 setName (clojure.core/str v4106))))
   (clojure.core/let
    [v4106 (:args m4105 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4106 :com.palletops.awaze.client-builder/undef)
     (.
      bean4104
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4170] (clojure.core/str arg4170))
 v4106))))
   bean4104))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Tag}
tag
  [m4108]
  (clojure.core/let
   [bean4107 (new com.amazonaws.services.elasticmapreduce.model.Tag)]
   (clojure.core/let
    [v4109 (:value m4108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4109 :com.palletops.awaze.client-builder/undef)
     (. bean4107 setValue (clojure.core/str v4109))))
   (clojure.core/let
    [v4109 (:key m4108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4109 :com.palletops.awaze.client-builder/undef)
     (. bean4107 setKey (clojure.core/str v4109))))
   bean4107))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig}
job-flow-instances-config
  [m4111]
  (clojure.core/let
   [bean4110
    (new
     com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig)]
   (clojure.core/let
    [v4112
     (:placement m4111 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4112 :com.palletops.awaze.client-builder/undef)
     (. bean4110 setPlacement (elasticmapreduce/placement-type v4112))))
   (clojure.core/let
    [v4112
     (:keep-job-flow-alive-when-no-steps
      m4111
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4112 :com.palletops.awaze.client-builder/undef)
     (.
      bean4110
      setKeepJobFlowAliveWhenNoSteps
      (clojure.core/boolean v4112))))
   (clojure.core/let
    [v4112
     (:slave-instance-type
      m4111
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4112 :com.palletops.awaze.client-builder/undef)
     (. bean4110 setSlaveInstanceType (clojure.core/str v4112))))
   (clojure.core/let
    [v4112
     (:ec2subnet-id m4111 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4112 :com.palletops.awaze.client-builder/undef)
     (. bean4110 setEc2SubnetId (clojure.core/str v4112))))
   (clojure.core/let
    [v4112
     (:instance-groups
      m4111
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4112 :com.palletops.awaze.client-builder/undef)
     (.
      bean4110
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4171]
  (elasticmapreduce/instance-group-config arg4171))
 v4112))))
   (clojure.core/let
    [v4112
     (:termination-protected
      m4111
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4112 :com.palletops.awaze.client-builder/undef)
     (. bean4110 setTerminationProtected (clojure.core/boolean v4112))))
   (clojure.core/let
    [v4112
     (:hadoop-version m4111 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4112 :com.palletops.awaze.client-builder/undef)
     (. bean4110 setHadoopVersion (clojure.core/str v4112))))
   (clojure.core/let
    [v4112
     (:master-instance-type
      m4111
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4112 :com.palletops.awaze.client-builder/undef)
     (. bean4110 setMasterInstanceType (clojure.core/str v4112))))
   (clojure.core/let
    [v4112
     (:instance-count m4111 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4112 :com.palletops.awaze.client-builder/undef)
     (. bean4110 setInstanceCount (clojure.core/int v4112))))
   (clojure.core/let
    [v4112
     (:ec2key-name m4111 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4112 :com.palletops.awaze.client-builder/undef)
     (. bean4110 setEc2KeyName (clojure.core/str v4112))))
   bean4110))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig}
instance-group-modify-config
  [m4114]
  (clojure.core/let
   [bean4113
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig)]
   (clojure.core/let
    [v4115
     (:instance-group-id
      m4114
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4115 :com.palletops.awaze.client-builder/undef)
     (. bean4113 setInstanceGroupId (clojure.core/str v4115))))
   (clojure.core/let
    [v4115
     (:instance-count m4114 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4115 :com.palletops.awaze.client-builder/undef)
     (. bean4113 setInstanceCount (clojure.core/int v4115))))
   (clojure.core/let
    [v4115
     (:ec2instance-ids-to-terminate
      m4114
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4115 :com.palletops.awaze.client-builder/undef)
     (.
      bean4113
      setEC2InstanceIdsToTerminate
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4172] (clojure.core/str arg4172))
 v4115))))
   bean4113))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest}
run-job-flow-request
  [m4117]
  (clojure.core/let
   [bean4116
    (new
     com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest)]
   (clojure.core/let
    [v4118 (:steps m4117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4118 :com.palletops.awaze.client-builder/undef)
     (.
      bean4116
      setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4173] (elasticmapreduce/step-config arg4173))
 v4118))))
   (clojure.core/let
    [v4118
     (:service-role m4117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4118 :com.palletops.awaze.client-builder/undef)
     (. bean4116 setServiceRole (clojure.core/str v4118))))
   (clojure.core/let
    [v4118 (:log-uri m4117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4118 :com.palletops.awaze.client-builder/undef)
     (. bean4116 setLogUri (clojure.core/str v4118))))
   (clojure.core/let
    [v4118 (:name m4117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4118 :com.palletops.awaze.client-builder/undef)
     (. bean4116 setName (clojure.core/str v4118))))
   (clojure.core/let
    [v4118
     (:supported-products
      m4117
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4118 :com.palletops.awaze.client-builder/undef)
     (.
      bean4116
      setSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4174] (clojure.core/str arg4174))
 v4118))))
   (clojure.core/let
    [v4118
     (:bootstrap-actions
      m4117
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4118 :com.palletops.awaze.client-builder/undef)
     (.
      bean4116
      setBootstrapActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4175]
  (elasticmapreduce/bootstrap-action-config arg4175))
 v4118))))
   (clojure.core/let
    [v4118
     (:visible-to-all-users
      m4117
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4118 :com.palletops.awaze.client-builder/undef)
     (. bean4116 setVisibleToAllUsers (clojure.core/boolean v4118))))
   (clojure.core/let
    [v4118
     (:new-supported-products
      m4117
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4118 :com.palletops.awaze.client-builder/undef)
     (.
      bean4116
      setNewSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4176]
  (elasticmapreduce/supported-product-config arg4176))
 v4118))))
   (clojure.core/let
    [v4118
     (:additional-info
      m4117
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4118 :com.palletops.awaze.client-builder/undef)
     (. bean4116 setAdditionalInfo (clojure.core/str v4118))))
   (clojure.core/let
    [v4118 (:tags m4117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4118 :com.palletops.awaze.client-builder/undef)
     (.
      bean4116
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4177] (elasticmapreduce/tag arg4177))
 v4118))))
   (clojure.core/let
    [v4118
     (:instances m4117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4118 :com.palletops.awaze.client-builder/undef)
     (.
      bean4116
      setInstances
      (elasticmapreduce/job-flow-instances-config v4118))))
   (clojure.core/let
    [v4118
     (:ami-version m4117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4118 :com.palletops.awaze.client-builder/undef)
     (. bean4116 setAmiVersion (clojure.core/str v4118))))
   (clojure.core/let
    [v4118
     (:job-flow-role m4117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4118 :com.palletops.awaze.client-builder/undef)
     (. bean4116 setJobFlowRole (clojure.core/str v4118))))
   bean4116))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest}
list-bootstrap-actions-request
  [m4120]
  (clojure.core/let
   [bean4119
    (new
     com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest)]
   (clojure.core/let
    [v4121
     (:cluster-id m4120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4121 :com.palletops.awaze.client-builder/undef)
     (. bean4119 setClusterId (clojure.core/str v4121))))
   (clojure.core/let
    [v4121 (:marker m4120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4121 :com.palletops.awaze.client-builder/undef)
     (. bean4119 setMarker (clojure.core/str v4121))))
   bean4119))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest}
remove-tags-request
  [m4123]
  (clojure.core/let
   [bean4122
    (new
     com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest)]
   (clojure.core/let
    [v4124
     (:resource-id m4123 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4124 :com.palletops.awaze.client-builder/undef)
     (. bean4122 setResourceId (clojure.core/str v4124))))
   (clojure.core/let
    [v4124
     (:tag-keys m4123 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4124 :com.palletops.awaze.client-builder/undef)
     (.
      bean4122
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4178] (clojure.core/str arg4178))
 v4124))))
   bean4122))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest}
list-instance-groups-request
  [m4126]
  (clojure.core/let
   [bean4125
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest)]
   (clojure.core/let
    [v4127
     (:cluster-id m4126 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4127 :com.palletops.awaze.client-builder/undef)
     (. bean4125 setClusterId (clojure.core/str v4127))))
   (clojure.core/let
    [v4127 (:marker m4126 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4127 :com.palletops.awaze.client-builder/undef)
     (. bean4125 setMarker (clojure.core/str v4127))))
   bean4125))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest}
set-visible-to-all-users-request
  [m4129]
  (clojure.core/let
   [bean4128
    (new
     com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest)]
   (clojure.core/let
    [v4130
     (:job-flow-ids m4129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4130 :com.palletops.awaze.client-builder/undef)
     (.
      bean4128
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4179] (clojure.core/str arg4179))
 v4130))))
   (clojure.core/let
    [v4130
     (:visible-to-all-users
      m4129
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4130 :com.palletops.awaze.client-builder/undef)
     (. bean4128 setVisibleToAllUsers (clojure.core/boolean v4130))))
   bean4128))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest}
modify-instance-groups-request
  [m4132]
  (clojure.core/let
   [bean4131
    (new
     com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest)]
   (clojure.core/let
    [v4133
     (:instance-groups
      m4132
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4133 :com.palletops.awaze.client-builder/undef)
     (.
      bean4131
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4180]
  (elasticmapreduce/instance-group-modify-config arg4180))
 v4133))))
   bean4131))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest}
describe-cluster-request
  [m4135]
  (clojure.core/let
   [bean4134
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest)]
   (clojure.core/let
    [v4136
     (:cluster-id m4135 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4136 :com.palletops.awaze.client-builder/undef)
     (. bean4134 setClusterId (clojure.core/str v4136))))
   bean4134))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddTagsRequest}
add-tags-request
  [m4138]
  (clojure.core/let
   [bean4137
    (new com.amazonaws.services.elasticmapreduce.model.AddTagsRequest)]
   (clojure.core/let
    [v4139 (:tags m4138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4139 :com.palletops.awaze.client-builder/undef)
     (.
      bean4137
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4181] (elasticmapreduce/tag arg4181))
 v4139))))
   (clojure.core/let
    [v4139
     (:resource-id m4138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4139 :com.palletops.awaze.client-builder/undef)
     (. bean4137 setResourceId (clojure.core/str v4139))))
   bean4137))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest}
set-termination-protection-request
  [m4141]
  (clojure.core/let
   [bean4140
    (new
     com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest)]
   (clojure.core/let
    [v4142
     (:job-flow-ids m4141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4142 :com.palletops.awaze.client-builder/undef)
     (.
      bean4140
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4182] (clojure.core/str arg4182))
 v4142))))
   (clojure.core/let
    [v4142
     (:termination-protected
      m4141
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4142 :com.palletops.awaze.client-builder/undef)
     (. bean4140 setTerminationProtected (clojure.core/boolean v4142))))
   bean4140))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest}
add-instance-groups-request
  [m4144]
  (clojure.core/let
   [bean4143
    (new
     com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest)]
   (clojure.core/let
    [v4145
     (:job-flow-id m4144 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4145 :com.palletops.awaze.client-builder/undef)
     (. bean4143 setJobFlowId (clojure.core/str v4145))))
   (clojure.core/let
    [v4145
     (:instance-groups
      m4144
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4145 :com.palletops.awaze.client-builder/undef)
     (.
      bean4143
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4183]
  (elasticmapreduce/instance-group-config arg4183))
 v4145))))
   bean4143))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest}
describe-step-request
  [m4147]
  (clojure.core/let
   [bean4146
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest)]
   (clojure.core/let
    [v4148
     (:cluster-id m4147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4148 :com.palletops.awaze.client-builder/undef)
     (. bean4146 setClusterId (clojure.core/str v4148))))
   (clojure.core/let
    [v4148 (:step-id m4147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4148 :com.palletops.awaze.client-builder/undef)
     (. bean4146 setStepId (clojure.core/str v4148))))
   bean4146))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest}
terminate-job-flows-request
  [m4150]
  (clojure.core/let
   [bean4149
    (new
     com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest)]
   (clojure.core/let
    [v4151
     (:job-flow-ids m4150 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4151 :com.palletops.awaze.client-builder/undef)
     (.
      bean4149
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4184] (clojure.core/str arg4184))
 v4151))))
   bean4149))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest}
list-instances-request
  [m4153]
  (clojure.core/let
   [bean4152
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest)]
   (clojure.core/let
    [v4154
     (:cluster-id m4153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4154 :com.palletops.awaze.client-builder/undef)
     (. bean4152 setClusterId (clojure.core/str v4154))))
   (clojure.core/let
    [v4154
     (:instance-group-id
      m4153
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4154 :com.palletops.awaze.client-builder/undef)
     (. bean4152 setInstanceGroupId (clojure.core/str v4154))))
   (clojure.core/let
    [v4154
     (:instance-group-types
      m4153
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4154 :com.palletops.awaze.client-builder/undef)
     (.
      bean4152
      setInstanceGroupTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4185] (clojure.core/str arg4185))
 v4154))))
   (clojure.core/let
    [v4154 (:marker m4153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4154 :com.palletops.awaze.client-builder/undef)
     (. bean4152 setMarker (clojure.core/str v4154))))
   bean4152))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListClustersRequest}
list-clusters-request
  [m4156]
  (clojure.core/let
   [bean4155
    (new
     com.amazonaws.services.elasticmapreduce.model.ListClustersRequest)]
   (clojure.core/let
    [v4157
     (:created-after m4156 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4157 :com.palletops.awaze.client-builder/undef)
     (.
      bean4155
      setCreatedAfter
      (com.palletops.awaze.common/to-date v4157))))
   (clojure.core/let
    [v4157
     (:created-before m4156 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4157 :com.palletops.awaze.client-builder/undef)
     (.
      bean4155
      setCreatedBefore
      (com.palletops.awaze.common/to-date v4157))))
   (clojure.core/let
    [v4157
     (:cluster-states m4156 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4157 :com.palletops.awaze.client-builder/undef)
     (.
      bean4155
      setClusterStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4186] (clojure.core/str arg4186))
 v4157))))
   (clojure.core/let
    [v4157 (:marker m4156 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4157 :com.palletops.awaze.client-builder/undef)
     (. bean4155 setMarker (clojure.core/str v4157))))
   bean4155))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest}
add-job-flow-steps-request
  [m4159]
  (clojure.core/let
   [bean4158
    (new
     com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest)]
   (clojure.core/let
    [v4160 (:steps m4159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4160 :com.palletops.awaze.client-builder/undef)
     (.
      bean4158
      setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4187] (elasticmapreduce/step-config arg4187))
 v4160))))
   (clojure.core/let
    [v4160
     (:job-flow-id m4159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4160 :com.palletops.awaze.client-builder/undef)
     (. bean4158 setJobFlowId (clojure.core/str v4160))))
   bean4158))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListStepsRequest}
list-steps-request
  [m4162]
  (clojure.core/let
   [bean4161
    (new
     com.amazonaws.services.elasticmapreduce.model.ListStepsRequest)]
   (clojure.core/let
    [v4163
     (:cluster-id m4162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4163 :com.palletops.awaze.client-builder/undef)
     (. bean4161 setClusterId (clojure.core/str v4163))))
   (clojure.core/let
    [v4163
     (:step-states m4162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4163 :com.palletops.awaze.client-builder/undef)
     (.
      bean4161
      setStepStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4188] (clojure.core/str arg4188))
 v4163))))
   (clojure.core/let
    [v4163 (:marker m4162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4163 :com.palletops.awaze.client-builder/undef)
     (. bean4161 setMarker (clojure.core/str v4163))))
   bean4161))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest}
describe-job-flows-request
  [m4165]
  (clojure.core/let
   [bean4164
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest)]
   (clojure.core/let
    [v4166
     (:job-flow-ids m4165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4166 :com.palletops.awaze.client-builder/undef)
     (.
      bean4164
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4189] (clojure.core/str arg4189))
 v4166))))
   (clojure.core/let
    [v4166
     (:created-after m4165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4166 :com.palletops.awaze.client-builder/undef)
     (.
      bean4164
      setCreatedAfter
      (com.palletops.awaze.common/to-date v4166))))
   (clojure.core/let
    [v4166
     (:created-before m4165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4166 :com.palletops.awaze.client-builder/undef)
     (.
      bean4164
      setCreatedBefore
      (com.palletops.awaze.common/to-date v4166))))
   (clojure.core/let
    [v4166
     (:job-flow-states
      m4165
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4166 :com.palletops.awaze.client-builder/undef)
     (.
      bean4164
      setJobFlowStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4190] (clojure.core/str arg4190))
 v4166))))
   bean4164))
 (clojure.core/defmulti
  elasticmapreduce
  (clojure.core/fn
   elasticmapreduce
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :run-job-flow
   [m4191]
   (clojure.core/let
    [credentials4192 (:credentials m4191) args4193 (:args m4191)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4194
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4192)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4194
       runJobFlow
       (elasticmapreduce/run-job-flow-request
        (clojure.core/nth args4193 0)))))))
  (clojure.core/defn
   run-job-flow-map
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-role
                         additional-info
                         general-progress-listener
                         name
                         service-role
                         log-uri
                         bootstrap-actions
                         visible-to-all-users
                         supported-products
                         ami-version
                         steps
                         new-supported-products
                         instances
                         tags]}]]),
    :doc "Generate map for runJobFlow"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :run-job-flow,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   run-job-flow
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-role
                         additional-info
                         general-progress-listener
                         name
                         service-role
                         log-uri
                         bootstrap-actions
                         visible-to-all-users
                         supported-products
                         ami-version
                         steps
                         new-supported-products
                         instances
                         tags]}]]),
    :doc "Call runJobFlow"}
   [credentials4196 & args4197]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4198
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4196)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4198
      runJobFlow
      (elasticmapreduce/run-job-flow-request
       (clojure.core/nth args4197 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-bootstrap-actions
   [m4199]
   (clojure.core/let
    [credentials4200 (:credentials m4199) args4201 (:args m4199)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4202
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4200)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4202
       listBootstrapActions
       (elasticmapreduce/list-bootstrap-actions-request
        (clojure.core/nth args4201 0)))))))
  (clojure.core/defn
   list-bootstrap-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [marker general-progress-listener cluster-id]}]]),
    :doc "Generate map for listBootstrapActions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-bootstrap-actions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-bootstrap-actions
   {:arglists (quote
               [[credentials
                 {:keys [marker general-progress-listener cluster-id]}]]),
    :doc "Call listBootstrapActions"}
   [credentials4204 & args4205]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4206
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4204)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4206
      listBootstrapActions
      (elasticmapreduce/list-bootstrap-actions-request
       (clojure.core/nth args4205 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :remove-tags
   [m4207]
   (clojure.core/let
    [credentials4208 (:credentials m4207) args4209 (:args m4207)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4210
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4208)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4210
       removeTags
       (elasticmapreduce/remove-tags-request
        (clojure.core/nth args4209 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tag-keys
                         resource-id
                         general-progress-listener]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :remove-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [tag-keys
                         resource-id
                         general-progress-listener]}]]),
    :doc "Call removeTags"}
   [credentials4212 & args4213]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4214
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4212)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4214
      removeTags
      (elasticmapreduce/remove-tags-request
       (clojure.core/nth args4213 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instance-groups
   [m4215]
   (clojure.core/let
    [credentials4216 (:credentials m4215) args4217 (:args m4215)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4218
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4216)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4218
       listInstanceGroups
       (elasticmapreduce/list-instance-groups-request
        (clojure.core/nth args4217 0)))))))
  (clojure.core/defn
   list-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [marker general-progress-listener cluster-id]}]]),
    :doc "Generate map for listInstanceGroups"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-instance-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [marker general-progress-listener cluster-id]}]]),
    :doc "Call listInstanceGroups"}
   [credentials4220 & args4221]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4222
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4220)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4222
      listInstanceGroups
      (elasticmapreduce/list-instance-groups-request
       (clojure.core/nth args4221 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-visible-to-all-users
   [m4223]
   (clojure.core/let
    [credentials4224 (:credentials m4223) args4225 (:args m4223)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4226
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4224)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4226
       setVisibleToAllUsers
       (elasticmapreduce/set-visible-to-all-users-request
        (clojure.core/nth args4225 0)))))))
  (clojure.core/defn
   set-visible-to-all-users-map
   {:arglists (quote
               [[credentials
                 {:keys [visible-to-all-users
                         job-flow-ids
                         general-progress-listener]}]]),
    :doc "Generate map for setVisibleToAllUsers"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :set-visible-to-all-users,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-visible-to-all-users
   {:arglists (quote
               [[credentials
                 {:keys [visible-to-all-users
                         job-flow-ids
                         general-progress-listener]}]]),
    :doc "Call setVisibleToAllUsers"}
   [credentials4228 & args4229]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4230
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4228)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4230
      setVisibleToAllUsers
      (elasticmapreduce/set-visible-to-all-users-request
       (clojure.core/nth args4229 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :modify-instance-groups
   [m4231]
   (clojure.core/let
    [credentials4232 (:credentials m4231) args4233 (:args m4231)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4234
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4232)]
     (clojure.core/case
      (clojure.core/count args4233)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4234
        modifyInstanceGroups
        (elasticmapreduce/modify-instance-groups-request
         (clojure.core/nth args4233 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4234
        modifyInstanceGroups))))))
  (clojure.core/defn
   modify-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-groups general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for modifyInstanceGroups, modifyInstanceGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :modify-instance-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :modify-instance-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [instance-groups general-progress-listener]}]
                [credentials]]),
    :doc "Call modifyInstanceGroups, modifyInstanceGroups"}
   [credentials4236 & args4237]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4238
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4236)]
    (clojure.core/case
     (clojure.core/count args4237)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4238
       modifyInstanceGroups
       (elasticmapreduce/modify-instance-groups-request
        (clojure.core/nth args4237 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4238
       modifyInstanceGroups))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-cluster
   [m4239]
   (clojure.core/let
    [credentials4240 (:credentials m4239) args4241 (:args m4239)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4242
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4240)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4242
       describeCluster
       (elasticmapreduce/describe-cluster-request
        (clojure.core/nth args4241 0)))))))
  (clojure.core/defn
   describe-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-id]}]]),
    :doc "Generate map for describeCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :describe-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cluster
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-id]}]]),
    :doc "Call describeCluster"}
   [credentials4244 & args4245]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4246
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4244)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4246
      describeCluster
      (elasticmapreduce/describe-cluster-request
       (clojure.core/nth args4245 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-tags
   [m4247]
   (clojure.core/let
    [credentials4248 (:credentials m4247) args4249 (:args m4247)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4250
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4248)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4250
       addTags
       (elasticmapreduce/add-tags-request
        (clojure.core/nth args4249 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags resource-id general-progress-listener]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :add-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags resource-id general-progress-listener]}]]),
    :doc "Call addTags"}
   [credentials4252 & args4253]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4254
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4252)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4254
      addTags
      (elasticmapreduce/add-tags-request
       (clojure.core/nth args4253 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-termination-protection
   [m4255]
   (clojure.core/let
    [credentials4256 (:credentials m4255) args4257 (:args m4255)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4258
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4256)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4258
       setTerminationProtection
       (elasticmapreduce/set-termination-protection-request
        (clojure.core/nth args4257 0)))))))
  (clojure.core/defn
   set-termination-protection-map
   {:arglists (quote
               [[credentials
                 {:keys [termination-protected
                         job-flow-ids
                         general-progress-listener]}]]),
    :doc "Generate map for setTerminationProtection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :set-termination-protection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-termination-protection
   {:arglists (quote
               [[credentials
                 {:keys [termination-protected
                         job-flow-ids
                         general-progress-listener]}]]),
    :doc "Call setTerminationProtection"}
   [credentials4260 & args4261]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4262
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4260)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4262
      setTerminationProtection
      (elasticmapreduce/set-termination-protection-request
       (clojure.core/nth args4261 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-instance-groups
   [m4263]
   (clojure.core/let
    [credentials4264 (:credentials m4263) args4265 (:args m4263)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4266
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4264)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4266
       addInstanceGroups
       (elasticmapreduce/add-instance-groups-request
        (clojure.core/nth args4265 0)))))))
  (clojure.core/defn
   add-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-id
                         instance-groups
                         general-progress-listener]}]]),
    :doc "Generate map for addInstanceGroups"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :add-instance-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-id
                         instance-groups
                         general-progress-listener]}]]),
    :doc "Call addInstanceGroups"}
   [credentials4268 & args4269]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4270
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4268)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4270
      addInstanceGroups
      (elasticmapreduce/add-instance-groups-request
       (clojure.core/nth args4269 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-step
   [m4271]
   (clojure.core/let
    [credentials4272 (:credentials m4271) args4273 (:args m4271)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4274
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4272)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4274
       describeStep
       (elasticmapreduce/describe-step-request
        (clojure.core/nth args4273 0)))))))
  (clojure.core/defn
   describe-step-map
   {:arglists (quote
               [[credentials
                 {:keys [step-id general-progress-listener cluster-id]}]]),
    :doc "Generate map for describeStep"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :describe-step,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-step
   {:arglists (quote
               [[credentials
                 {:keys [step-id general-progress-listener cluster-id]}]]),
    :doc "Call describeStep"}
   [credentials4276 & args4277]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4278
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4276)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4278
      describeStep
      (elasticmapreduce/describe-step-request
       (clojure.core/nth args4277 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :terminate-job-flows
   [m4279]
   (clojure.core/let
    [credentials4280 (:credentials m4279) args4281 (:args m4279)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4282
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4280)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4282
       terminateJobFlows
       (elasticmapreduce/terminate-job-flows-request
        (clojure.core/nth args4281 0)))))))
  (clojure.core/defn
   terminate-job-flows-map
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-ids general-progress-listener]}]]),
    :doc "Generate map for terminateJobFlows"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :terminate-job-flows,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   terminate-job-flows
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-ids general-progress-listener]}]]),
    :doc "Call terminateJobFlows"}
   [credentials4284 & args4285]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4286
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4284)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4286
      terminateJobFlows
      (elasticmapreduce/terminate-job-flows-request
       (clojure.core/nth args4285 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instances
   [m4287]
   (clojure.core/let
    [credentials4288 (:credentials m4287) args4289 (:args m4287)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4290
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4288)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4290
       listInstances
       (elasticmapreduce/list-instances-request
        (clojure.core/nth args4289 0)))))))
  (clojure.core/defn
   list-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         instance-group-types
                         instance-group-id
                         general-progress-listener
                         cluster-id]}]]),
    :doc "Generate map for listInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-instances
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         instance-group-types
                         instance-group-id
                         general-progress-listener
                         cluster-id]}]]),
    :doc "Call listInstances"}
   [credentials4292 & args4293]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4294
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4292)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4294
      listInstances
      (elasticmapreduce/list-instances-request
       (clojure.core/nth args4293 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-clusters
   [m4295]
   (clojure.core/let
    [credentials4296 (:credentials m4295) args4297 (:args m4295)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4298
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4296)]
     (clojure.core/case
      (clojure.core/count args4297)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4298
        listClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4298
        listClusters
        (elasticmapreduce/list-clusters-request
         (clojure.core/nth args4297 0))))))))
  (clojure.core/defn
   list-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker
                         general-progress-listener
                         created-before
                         created-after
                         cluster-states]}]]),
    :doc "Generate map for listClusters, listClusters"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :list-clusters,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-clusters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker
                         general-progress-listener
                         created-before
                         created-after
                         cluster-states]}]]),
    :doc "Call listClusters, listClusters"}
   [credentials4300 & args4301]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4302
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4300)]
    (clojure.core/case
     (clojure.core/count args4301)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4302
       listClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4302
       listClusters
       (elasticmapreduce/list-clusters-request
        (clojure.core/nth args4301 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-job-flow-steps
   [m4303]
   (clojure.core/let
    [credentials4304 (:credentials m4303) args4305 (:args m4303)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4306
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4304)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4306
       addJobFlowSteps
       (elasticmapreduce/add-job-flow-steps-request
        (clojure.core/nth args4305 0)))))))
  (clojure.core/defn
   add-job-flow-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [steps job-flow-id general-progress-listener]}]]),
    :doc "Generate map for addJobFlowSteps"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :add-job-flow-steps,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-job-flow-steps
   {:arglists (quote
               [[credentials
                 {:keys [steps job-flow-id general-progress-listener]}]]),
    :doc "Call addJobFlowSteps"}
   [credentials4308 & args4309]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4310
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4308)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4310
      addJobFlowSteps
      (elasticmapreduce/add-job-flow-steps-request
       (clojure.core/nth args4309 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-steps
   [m4311]
   (clojure.core/let
    [credentials4312 (:credentials m4311) args4313 (:args m4311)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4314
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4312)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4314
       listSteps
       (elasticmapreduce/list-steps-request
        (clojure.core/nth args4313 0)))))))
  (clojure.core/defn
   list-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [step-states
                         marker
                         general-progress-listener
                         cluster-id]}]]),
    :doc "Generate map for listSteps"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-steps,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-steps
   {:arglists (quote
               [[credentials
                 {:keys [step-states
                         marker
                         general-progress-listener
                         cluster-id]}]]),
    :doc "Call listSteps"}
   [credentials4316 & args4317]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4318
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4316)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4318
      listSteps
      (elasticmapreduce/list-steps-request
       (clojure.core/nth args4317 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-job-flows
   [m4319]
   (clojure.core/let
    [credentials4320 (:credentials m4319) args4321 (:args m4319)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4322
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4320)]
     (clojure.core/case
      (clojure.core/count args4321)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4322
        describeJobFlows
        (elasticmapreduce/describe-job-flows-request
         (clojure.core/nth args4321 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4322
        describeJobFlows))))))
  (clojure.core/defn
   describe-job-flows-map
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-states
                         job-flow-ids
                         general-progress-listener
                         created-before
                         created-after]}]
                [credentials]]),
    :doc "Generate map for describeJobFlows, describeJobFlows"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :describe-job-flows,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :describe-job-flows,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-job-flows
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-states
                         job-flow-ids
                         general-progress-listener
                         created-before
                         created-after]}]
                [credentials]]),
    :doc "Call describeJobFlows, describeJobFlows"}
   [credentials4324 & args4325]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4326
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4324)]
    (clojure.core/case
     (clojure.core/count args4325)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4326
       describeJobFlows
       (elasticmapreduce/describe-job-flows-request
        (clojure.core/nth args4325 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4326
       describeJobFlows)))))))
