(ns
 com.palletops.awaze.elasticloadbalancing
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticloadbalancing :as elasticloadbalancing]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticloadbalancing
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing}
cross-zone-load-balancing
  [m4460]
  (clojure.core/let
   [bean4459
    (new
     com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing)]
   (clojure.core/let
    [v4461 (:enabled m4460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4461 :com.palletops.awaze.client-builder/undef)
     (. bean4459 setEnabled (clojure.core/boolean v4461))))
   bean4459))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AccessLog}
access-log
  [m4463]
  (clojure.core/let
   [bean4462
    (new com.amazonaws.services.elasticloadbalancing.model.AccessLog)]
   (clojure.core/let
    [v4464 (:enabled m4463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4464 :com.palletops.awaze.client-builder/undef)
     (. bean4462 setEnabled (clojure.core/boolean v4464))))
   (clojure.core/let
    [v4464
     (:s3bucket-name m4463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4464 :com.palletops.awaze.client-builder/undef)
     (. bean4462 setS3BucketName (clojure.core/str v4464))))
   (clojure.core/let
    [v4464
     (:emit-interval m4463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4464 :com.palletops.awaze.client-builder/undef)
     (. bean4462 setEmitInterval (clojure.core/int v4464))))
   (clojure.core/let
    [v4464
     (:s3bucket-prefix
      m4463
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4464 :com.palletops.awaze.client-builder/undef)
     (. bean4462 setS3BucketPrefix (clojure.core/str v4464))))
   bean4462))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining}
connection-draining
  [m4466]
  (clojure.core/let
   [bean4465
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining)]
   (clojure.core/let
    [v4467 (:enabled m4466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4467 :com.palletops.awaze.client-builder/undef)
     (. bean4465 setEnabled (clojure.core/boolean v4467))))
   (clojure.core/let
    [v4467 (:timeout m4466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4467 :com.palletops.awaze.client-builder/undef)
     (. bean4465 setTimeout (clojure.core/int v4467))))
   bean4465))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Instance}
instance
  [m4469]
  (clojure.core/let
   [bean4468
    (new com.amazonaws.services.elasticloadbalancing.model.Instance)]
   (clojure.core/let
    [v4470
     (:instance-id m4469 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4470 :com.palletops.awaze.client-builder/undef)
     (. bean4468 setInstanceId (clojure.core/str v4470))))
   bean4468))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute}
policy-attribute
  [m4472]
  (clojure.core/let
   [bean4471
    (new
     com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute)]
   (clojure.core/let
    [v4473
     (:attribute-name m4472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4473 :com.palletops.awaze.client-builder/undef)
     (. bean4471 setAttributeName (clojure.core/str v4473))))
   (clojure.core/let
    [v4473
     (:attribute-value
      m4472
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4473 :com.palletops.awaze.client-builder/undef)
     (. bean4471 setAttributeValue (clojure.core/str v4473))))
   bean4471))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.HealthCheck}
health-check
  [m4475]
  (clojure.core/let
   [bean4474
    (new
     com.amazonaws.services.elasticloadbalancing.model.HealthCheck)]
   (clojure.core/let
    [v4476 (:target m4475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4476 :com.palletops.awaze.client-builder/undef)
     (. bean4474 setTarget (clojure.core/str v4476))))
   (clojure.core/let
    [v4476
     (:interval m4475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4476 :com.palletops.awaze.client-builder/undef)
     (. bean4474 setInterval (clojure.core/int v4476))))
   (clojure.core/let
    [v4476 (:timeout m4475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4476 :com.palletops.awaze.client-builder/undef)
     (. bean4474 setTimeout (clojure.core/int v4476))))
   (clojure.core/let
    [v4476
     (:unhealthy-threshold
      m4475
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4476 :com.palletops.awaze.client-builder/undef)
     (. bean4474 setUnhealthyThreshold (clojure.core/int v4476))))
   (clojure.core/let
    [v4476
     (:healthy-threshold
      m4475
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4476 :com.palletops.awaze.client-builder/undef)
     (. bean4474 setHealthyThreshold (clojure.core/int v4476))))
   bean4474))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Listener}
listener
  [m4478]
  (clojure.core/let
   [bean4477
    (new com.amazonaws.services.elasticloadbalancing.model.Listener)]
   (clojure.core/let
    [v4479
     (:protocol m4478 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4479 :com.palletops.awaze.client-builder/undef)
     (. bean4477 setProtocol (clojure.core/str v4479))))
   (clojure.core/let
    [v4479
     (:load-balancer-port
      m4478
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4479 :com.palletops.awaze.client-builder/undef)
     (. bean4477 setLoadBalancerPort (clojure.core/int v4479))))
   (clojure.core/let
    [v4479
     (:instance-port m4478 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4479 :com.palletops.awaze.client-builder/undef)
     (. bean4477 setInstancePort (clojure.core/int v4479))))
   (clojure.core/let
    [v4479
     (:sslcertificate-id
      m4478
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4479 :com.palletops.awaze.client-builder/undef)
     (. bean4477 setSSLCertificateId (clojure.core/str v4479))))
   (clojure.core/let
    [v4479
     (:instance-protocol
      m4478
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4479 :com.palletops.awaze.client-builder/undef)
     (. bean4477 setInstanceProtocol (clojure.core/str v4479))))
   bean4477))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes}
load-balancer-attributes
  [m4481]
  (clojure.core/let
   [bean4480
    (new
     com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes)]
   (clojure.core/let
    [v4482
     (:cross-zone-load-balancing
      m4481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4482 :com.palletops.awaze.client-builder/undef)
     (.
      bean4480
      setCrossZoneLoadBalancing
      (elasticloadbalancing/cross-zone-load-balancing v4482))))
   (clojure.core/let
    [v4482
     (:access-log m4481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4482 :com.palletops.awaze.client-builder/undef)
     (. bean4480 setAccessLog (elasticloadbalancing/access-log v4482))))
   (clojure.core/let
    [v4482
     (:connection-draining
      m4481
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4482 :com.palletops.awaze.client-builder/undef)
     (.
      bean4480
      setConnectionDraining
      (elasticloadbalancing/connection-draining v4482))))
   bean4480))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest}
deregister-instances-from-load-balancer-request
  [m4484]
  (clojure.core/let
   [bean4483
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest)]
   (clojure.core/let
    [v4485
     (:instances m4484 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4485 :com.palletops.awaze.client-builder/undef)
     (.
      bean4483
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4558] (elasticloadbalancing/instance arg4558))
 v4485))))
   (clojure.core/let
    [v4485
     (:load-balancer-name
      m4484
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4485 :com.palletops.awaze.client-builder/undef)
     (. bean4483 setLoadBalancerName (clojure.core/str v4485))))
   bean4483))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest}
enable-availability-zones-for-load-balancer-request
  [m4487]
  (clojure.core/let
   [bean4486
    (new
     com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/let
    [v4488
     (:availability-zones
      m4487
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4488 :com.palletops.awaze.client-builder/undef)
     (.
      bean4486
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4559] (clojure.core/str arg4559))
 v4488))))
   (clojure.core/let
    [v4488
     (:load-balancer-name
      m4487
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4488 :com.palletops.awaze.client-builder/undef)
     (. bean4486 setLoadBalancerName (clojure.core/str v4488))))
   bean4486))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest}
apply-security-groups-to-load-balancer-request
  [m4490]
  (clojure.core/let
   [bean4489
    (new
     com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest)]
   (clojure.core/let
    [v4491
     (:security-groups
      m4490
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4491 :com.palletops.awaze.client-builder/undef)
     (.
      bean4489
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4560] (clojure.core/str arg4560))
 v4491))))
   (clojure.core/let
    [v4491
     (:load-balancer-name
      m4490
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4491 :com.palletops.awaze.client-builder/undef)
     (. bean4489 setLoadBalancerName (clojure.core/str v4491))))
   bean4489))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest}
create-lbcookie-stickiness-policy-request
  [m4493]
  (clojure.core/let
   [bean4492
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest)]
   (clojure.core/let
    [v4494
     (:policy-name m4493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4494 :com.palletops.awaze.client-builder/undef)
     (. bean4492 setPolicyName (clojure.core/str v4494))))
   (clojure.core/let
    [v4494
     (:load-balancer-name
      m4493
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4494 :com.palletops.awaze.client-builder/undef)
     (. bean4492 setLoadBalancerName (clojure.core/str v4494))))
   (clojure.core/let
    [v4494
     (:cookie-expiration-period
      m4493
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4494 :com.palletops.awaze.client-builder/undef)
     (. bean4492 setCookieExpirationPeriod (clojure.core/long v4494))))
   bean4492))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest}
describe-load-balancer-policies-request
  [m4496]
  (clojure.core/let
   [bean4495
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest)]
   (clojure.core/let
    [v4497
     (:policy-names m4496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4497 :com.palletops.awaze.client-builder/undef)
     (.
      bean4495
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4561] (clojure.core/str arg4561))
 v4497))))
   (clojure.core/let
    [v4497
     (:load-balancer-name
      m4496
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4497 :com.palletops.awaze.client-builder/undef)
     (. bean4495 setLoadBalancerName (clojure.core/str v4497))))
   bean4495))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest}
delete-load-balancer-request
  [m4499]
  (clojure.core/let
   [bean4498
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest)]
   (clojure.core/let
    [v4500
     (:load-balancer-name
      m4499
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4500 :com.palletops.awaze.client-builder/undef)
     (. bean4498 setLoadBalancerName (clojure.core/str v4500))))
   bean4498))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest}
describe-load-balancer-policy-types-request
  [m4502]
  (clojure.core/let
   [bean4501
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest)]
   (clojure.core/let
    [v4503
     (:policy-type-names
      m4502
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4503 :com.palletops.awaze.client-builder/undef)
     (.
      bean4501
      setPolicyTypeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4562] (clojure.core/str arg4562))
 v4503))))
   bean4501))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest}
delete-load-balancer-policy-request
  [m4505]
  (clojure.core/let
   [bean4504
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest)]
   (clojure.core/let
    [v4506
     (:policy-name m4505 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4506 :com.palletops.awaze.client-builder/undef)
     (. bean4504 setPolicyName (clojure.core/str v4506))))
   (clojure.core/let
    [v4506
     (:load-balancer-name
      m4505
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4506 :com.palletops.awaze.client-builder/undef)
     (. bean4504 setLoadBalancerName (clojure.core/str v4506))))
   bean4504))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest}
create-load-balancer-policy-request
  [m4508]
  (clojure.core/let
   [bean4507
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest)]
   (clojure.core/let
    [v4509
     (:policy-name m4508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4509 :com.palletops.awaze.client-builder/undef)
     (. bean4507 setPolicyName (clojure.core/str v4509))))
   (clojure.core/let
    [v4509
     (:load-balancer-name
      m4508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4509 :com.palletops.awaze.client-builder/undef)
     (. bean4507 setLoadBalancerName (clojure.core/str v4509))))
   (clojure.core/let
    [v4509
     (:policy-type-name
      m4508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4509 :com.palletops.awaze.client-builder/undef)
     (. bean4507 setPolicyTypeName (clojure.core/str v4509))))
   (clojure.core/let
    [v4509
     (:policy-attributes
      m4508
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4509 :com.palletops.awaze.client-builder/undef)
     (.
      bean4507
      setPolicyAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4563]
  (elasticloadbalancing/policy-attribute arg4563))
 v4509))))
   bean4507))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest}
configure-health-check-request
  [m4511]
  (clojure.core/let
   [bean4510
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest)]
   (clojure.core/let
    [v4512
     (:load-balancer-name
      m4511
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4512 :com.palletops.awaze.client-builder/undef)
     (. bean4510 setLoadBalancerName (clojure.core/str v4512))))
   (clojure.core/let
    [v4512
     (:health-check m4511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4512 :com.palletops.awaze.client-builder/undef)
     (.
      bean4510
      setHealthCheck
      (elasticloadbalancing/health-check v4512))))
   bean4510))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest}
describe-instance-health-request
  [m4514]
  (clojure.core/let
   [bean4513
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest)]
   (clojure.core/let
    [v4515
     (:instances m4514 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4515 :com.palletops.awaze.client-builder/undef)
     (.
      bean4513
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4564] (elasticloadbalancing/instance arg4564))
 v4515))))
   (clojure.core/let
    [v4515
     (:load-balancer-name
      m4514
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4515 :com.palletops.awaze.client-builder/undef)
     (. bean4513 setLoadBalancerName (clojure.core/str v4515))))
   bean4513))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest}
create-load-balancer-request
  [m4517]
  (clojure.core/let
   [bean4516
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest)]
   (clojure.core/let
    [v4518
     (:availability-zones
      m4517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4518 :com.palletops.awaze.client-builder/undef)
     (.
      bean4516
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4565] (clojure.core/str arg4565))
 v4518))))
   (clojure.core/let
    [v4518
     (:security-groups
      m4517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4518 :com.palletops.awaze.client-builder/undef)
     (.
      bean4516
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4566] (clojure.core/str arg4566))
 v4518))))
   (clojure.core/let
    [v4518 (:subnets m4517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4518 :com.palletops.awaze.client-builder/undef)
     (.
      bean4516
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4567] (clojure.core/str arg4567))
 v4518))))
   (clojure.core/let
    [v4518
     (:load-balancer-name
      m4517
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4518 :com.palletops.awaze.client-builder/undef)
     (. bean4516 setLoadBalancerName (clojure.core/str v4518))))
   (clojure.core/let
    [v4518
     (:listeners m4517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4518 :com.palletops.awaze.client-builder/undef)
     (.
      bean4516
      setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4568] (elasticloadbalancing/listener arg4568))
 v4518))))
   (clojure.core/let
    [v4518 (:scheme m4517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4518 :com.palletops.awaze.client-builder/undef)
     (. bean4516 setScheme (clojure.core/str v4518))))
   bean4516))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest}
set-load-balancer-policies-for-backend-server-request
  [m4520]
  (clojure.core/let
   [bean4519
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest)]
   (clojure.core/let
    [v4521
     (:policy-names m4520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4521 :com.palletops.awaze.client-builder/undef)
     (.
      bean4519
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4569] (clojure.core/str arg4569))
 v4521))))
   (clojure.core/let
    [v4521
     (:load-balancer-name
      m4520
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4521 :com.palletops.awaze.client-builder/undef)
     (. bean4519 setLoadBalancerName (clojure.core/str v4521))))
   (clojure.core/let
    [v4521
     (:instance-port m4520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4521 :com.palletops.awaze.client-builder/undef)
     (. bean4519 setInstancePort (clojure.core/int v4521))))
   bean4519))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest}
disable-availability-zones-for-load-balancer-request
  [m4523]
  (clojure.core/let
   [bean4522
    (new
     com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/let
    [v4524
     (:availability-zones
      m4523
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4524 :com.palletops.awaze.client-builder/undef)
     (.
      bean4522
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4570] (clojure.core/str arg4570))
 v4524))))
   (clojure.core/let
    [v4524
     (:load-balancer-name
      m4523
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4524 :com.palletops.awaze.client-builder/undef)
     (. bean4522 setLoadBalancerName (clojure.core/str v4524))))
   bean4522))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest}
detach-load-balancer-from-subnets-request
  [m4526]
  (clojure.core/let
   [bean4525
    (new
     com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest)]
   (clojure.core/let
    [v4527 (:subnets m4526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4527 :com.palletops.awaze.client-builder/undef)
     (.
      bean4525
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4571] (clojure.core/str arg4571))
 v4527))))
   (clojure.core/let
    [v4527
     (:load-balancer-name
      m4526
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4527 :com.palletops.awaze.client-builder/undef)
     (. bean4525 setLoadBalancerName (clojure.core/str v4527))))
   bean4525))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest}
create-load-balancer-listeners-request
  [m4529]
  (clojure.core/let
   [bean4528
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest)]
   (clojure.core/let
    [v4530
     (:load-balancer-name
      m4529
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4530 :com.palletops.awaze.client-builder/undef)
     (. bean4528 setLoadBalancerName (clojure.core/str v4530))))
   (clojure.core/let
    [v4530
     (:listeners m4529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4530 :com.palletops.awaze.client-builder/undef)
     (.
      bean4528
      setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4572] (elasticloadbalancing/listener arg4572))
 v4530))))
   bean4528))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest}
delete-load-balancer-listeners-request
  [m4532]
  (clojure.core/let
   [bean4531
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest)]
   (clojure.core/let
    [v4533
     (:load-balancer-name
      m4532
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4533 :com.palletops.awaze.client-builder/undef)
     (. bean4531 setLoadBalancerName (clojure.core/str v4533))))
   (clojure.core/let
    [v4533
     (:load-balancer-ports
      m4532
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4533 :com.palletops.awaze.client-builder/undef)
     (.
      bean4531
      setLoadBalancerPorts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4573] (clojure.core/int arg4573))
 v4533))))
   bean4531))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest}
set-load-balancer-listener-sslcertificate-request
  [m4535]
  (clojure.core/let
   [bean4534
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest)]
   (clojure.core/let
    [v4536
     (:load-balancer-name
      m4535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4536 :com.palletops.awaze.client-builder/undef)
     (. bean4534 setLoadBalancerName (clojure.core/str v4536))))
   (clojure.core/let
    [v4536
     (:load-balancer-port
      m4535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4536 :com.palletops.awaze.client-builder/undef)
     (. bean4534 setLoadBalancerPort (clojure.core/int v4536))))
   (clojure.core/let
    [v4536
     (:sslcertificate-id
      m4535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4536 :com.palletops.awaze.client-builder/undef)
     (. bean4534 setSSLCertificateId (clojure.core/str v4536))))
   bean4534))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest}
register-instances-with-load-balancer-request
  [m4538]
  (clojure.core/let
   [bean4537
    (new
     com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest)]
   (clojure.core/let
    [v4539
     (:instances m4538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4539 :com.palletops.awaze.client-builder/undef)
     (.
      bean4537
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4574] (elasticloadbalancing/instance arg4574))
 v4539))))
   (clojure.core/let
    [v4539
     (:load-balancer-name
      m4538
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4539 :com.palletops.awaze.client-builder/undef)
     (. bean4537 setLoadBalancerName (clojure.core/str v4539))))
   bean4537))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest}
set-load-balancer-policies-of-listener-request
  [m4541]
  (clojure.core/let
   [bean4540
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest)]
   (clojure.core/let
    [v4542
     (:policy-names m4541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4542 :com.palletops.awaze.client-builder/undef)
     (.
      bean4540
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4575] (clojure.core/str arg4575))
 v4542))))
   (clojure.core/let
    [v4542
     (:load-balancer-name
      m4541
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4542 :com.palletops.awaze.client-builder/undef)
     (. bean4540 setLoadBalancerName (clojure.core/str v4542))))
   (clojure.core/let
    [v4542
     (:load-balancer-port
      m4541
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4542 :com.palletops.awaze.client-builder/undef)
     (. bean4540 setLoadBalancerPort (clojure.core/int v4542))))
   bean4540))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest}
attach-load-balancer-to-subnets-request
  [m4544]
  (clojure.core/let
   [bean4543
    (new
     com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest)]
   (clojure.core/let
    [v4545 (:subnets m4544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4545 :com.palletops.awaze.client-builder/undef)
     (.
      bean4543
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4576] (clojure.core/str arg4576))
 v4545))))
   (clojure.core/let
    [v4545
     (:load-balancer-name
      m4544
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4545 :com.palletops.awaze.client-builder/undef)
     (. bean4543 setLoadBalancerName (clojure.core/str v4545))))
   bean4543))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest}
modify-load-balancer-attributes-request
  [m4547]
  (clojure.core/let
   [bean4546
    (new
     com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest)]
   (clojure.core/let
    [v4548
     (:load-balancer-name
      m4547
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4548 :com.palletops.awaze.client-builder/undef)
     (. bean4546 setLoadBalancerName (clojure.core/str v4548))))
   (clojure.core/let
    [v4548
     (:load-balancer-attributes
      m4547
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4548 :com.palletops.awaze.client-builder/undef)
     (.
      bean4546
      setLoadBalancerAttributes
      (elasticloadbalancing/load-balancer-attributes v4548))))
   bean4546))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest}
describe-load-balancers-request
  [m4550]
  (clojure.core/let
   [bean4549
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest)]
   (clojure.core/let
    [v4551
     (:load-balancer-names
      m4550
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4551 :com.palletops.awaze.client-builder/undef)
     (.
      bean4549
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4577] (clojure.core/str arg4577))
 v4551))))
   (clojure.core/let
    [v4551 (:marker m4550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4551 :com.palletops.awaze.client-builder/undef)
     (. bean4549 setMarker (clojure.core/str v4551))))
   bean4549))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest}
describe-load-balancer-attributes-request
  [m4553]
  (clojure.core/let
   [bean4552
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest)]
   (clojure.core/let
    [v4554
     (:load-balancer-name
      m4553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4554 :com.palletops.awaze.client-builder/undef)
     (. bean4552 setLoadBalancerName (clojure.core/str v4554))))
   bean4552))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest}
create-app-cookie-stickiness-policy-request
  [m4556]
  (clojure.core/let
   [bean4555
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest)]
   (clojure.core/let
    [v4557
     (:policy-name m4556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4557 :com.palletops.awaze.client-builder/undef)
     (. bean4555 setPolicyName (clojure.core/str v4557))))
   (clojure.core/let
    [v4557
     (:load-balancer-name
      m4556
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4557 :com.palletops.awaze.client-builder/undef)
     (. bean4555 setLoadBalancerName (clojure.core/str v4557))))
   (clojure.core/let
    [v4557
     (:cookie-name m4556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4557 :com.palletops.awaze.client-builder/undef)
     (. bean4555 setCookieName (clojure.core/str v4557))))
   bean4555))
 (clojure.core/defmulti
  elasticloadbalancing
  (clojure.core/fn
   elasticloadbalancing
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :deregister-instances-from-load-balancer
   [m4578]
   (clojure.core/let
    [credentials4579 (:credentials m4578) args4580 (:args m4578)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4581
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4579)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4581
       deregisterInstancesFromLoadBalancer
       (elasticloadbalancing/deregister-instances-from-load-balancer-request
        (clojure.core/nth args4580 0)))))))
  (clojure.core/defn
   deregister-instances-from-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Generate map for deregisterInstancesFromLoadBalancer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :deregister-instances-from-load-balancer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   deregister-instances-from-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Call deregisterInstancesFromLoadBalancer"}
   [credentials4583 & args4584]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4585
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4583)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4585
      deregisterInstancesFromLoadBalancer
      (elasticloadbalancing/deregister-instances-from-load-balancer-request
       (clojure.core/nth args4584 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :enable-availability-zones-for-load-balancer
   [m4586]
   (clojure.core/let
    [credentials4587 (:credentials m4586) args4588 (:args m4586)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4589
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4587)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4589
       enableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4588 0)))))))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         general-progress-listener
                         availability-zones]}]]),
    :doc "Generate map for enableAvailabilityZonesForLoadBalancer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :enable-availability-zones-for-load-balancer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         general-progress-listener
                         availability-zones]}]]),
    :doc "Call enableAvailabilityZonesForLoadBalancer"}
   [credentials4591 & args4592]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4593
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4591)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4593
      enableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4592 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :apply-security-groups-to-load-balancer
   [m4594]
   (clojure.core/let
    [credentials4595 (:credentials m4594) args4596 (:args m4594)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4597
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4595)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4597
       applySecurityGroupsToLoadBalancer
       (elasticloadbalancing/apply-security-groups-to-load-balancer-request
        (clojure.core/nth args4596 0)))))))
  (clojure.core/defn
   apply-security-groups-to-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [security-groups
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for applySecurityGroupsToLoadBalancer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :apply-security-groups-to-load-balancer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   apply-security-groups-to-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [security-groups
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call applySecurityGroupsToLoadBalancer"}
   [credentials4599 & args4600]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4601
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4599)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4601
      applySecurityGroupsToLoadBalancer
      (elasticloadbalancing/apply-security-groups-to-load-balancer-request
       (clojure.core/nth args4600 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-lbcookie-stickiness-policy
   [m4602]
   (clojure.core/let
    [credentials4603 (:credentials m4602) args4604 (:args m4602)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4605
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4603)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4605
       createLBCookieStickinessPolicy
       (elasticloadbalancing/create-lbcookie-stickiness-policy-request
        (clojure.core/nth args4604 0)))))))
  (clojure.core/defn
   create-lbcookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener
                         cookie-expiration-period]}]]),
    :doc "Generate map for createLBCookieStickinessPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-lbcookie-stickiness-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-lbcookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener
                         cookie-expiration-period]}]]),
    :doc "Call createLBCookieStickinessPolicy"}
   [credentials4607 & args4608]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4609
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4607)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4609
      createLBCookieStickinessPolicy
      (elasticloadbalancing/create-lbcookie-stickiness-policy-request
       (clojure.core/nth args4608 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policies
   [m4610]
   (clojure.core/let
    [credentials4611 (:credentials m4610) args4612 (:args m4610)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4613
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4611)]
     (clojure.core/case
      (clojure.core/count args4612)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4613
        describeLoadBalancerPolicies
        (elasticloadbalancing/describe-load-balancer-policies-request
         (clojure.core/nth args4612 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4613
        describeLoadBalancerPolicies))))))
  (clojure.core/defn
   describe-load-balancer-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-name
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policies,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policies,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-load-balancer-policies
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-name
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   [credentials4615 & args4616]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4617
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4615)]
    (clojure.core/case
     (clojure.core/count args4616)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4617
       describeLoadBalancerPolicies
       (elasticloadbalancing/describe-load-balancer-policies-request
        (clojure.core/nth args4616 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4617
       describeLoadBalancerPolicies))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer
   [m4618]
   (clojure.core/let
    [credentials4619 (:credentials m4618) args4620 (:args m4618)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4621
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4619)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4621
       deleteLoadBalancer
       (elasticloadbalancing/delete-load-balancer-request
        (clojure.core/nth args4620 0)))))))
  (clojure.core/defn
   delete-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name general-progress-listener]}]]),
    :doc "Generate map for deleteLoadBalancer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :delete-load-balancer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name general-progress-listener]}]]),
    :doc "Call deleteLoadBalancer"}
   [credentials4623 & args4624]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4625
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4623)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4625
      deleteLoadBalancer
      (elasticloadbalancing/delete-load-balancer-request
       (clojure.core/nth args4624 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policy-types
   [m4626]
   (clojure.core/let
    [credentials4627 (:credentials m4626) args4628 (:args m4626)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4629
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4627)]
     (clojure.core/case
      (clojure.core/count args4628)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4629
        describeLoadBalancerPolicyTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4629
        describeLoadBalancerPolicyTypes
        (elasticloadbalancing/describe-load-balancer-policy-types-request
         (clojure.core/nth args4628 0))))))))
  (clojure.core/defn
   describe-load-balancer-policy-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-type-names general-progress-listener]}]]),
    :doc "Generate map for describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-load-balancer-policy-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-type-names general-progress-listener]}]]),
    :doc "Call describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   [credentials4631 & args4632]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4633
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4631)]
    (clojure.core/case
     (clojure.core/count args4632)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4633
       describeLoadBalancerPolicyTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4633
       describeLoadBalancerPolicyTypes
       (elasticloadbalancing/describe-load-balancer-policy-types-request
        (clojure.core/nth args4632 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-policy
   [m4634]
   (clojure.core/let
    [credentials4635 (:credentials m4634) args4636 (:args m4634)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4637
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4635)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4637
       deleteLoadBalancerPolicy
       (elasticloadbalancing/delete-load-balancer-policy-request
        (clojure.core/nth args4636 0)))))))
  (clojure.core/defn
   delete-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteLoadBalancerPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :delete-load-balancer-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call deleteLoadBalancerPolicy"}
   [credentials4639 & args4640]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4641
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4639)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4641
      deleteLoadBalancerPolicy
      (elasticloadbalancing/delete-load-balancer-policy-request
       (clojure.core/nth args4640 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-policy
   [m4642]
   (clojure.core/let
    [credentials4643 (:credentials m4642) args4644 (:args m4642)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4645
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4643)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4645
       createLoadBalancerPolicy
       (elasticloadbalancing/create-load-balancer-policy-request
        (clojure.core/nth args4644 0)))))))
  (clojure.core/defn
   create-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-type-name
                         policy-name
                         policy-attributes
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for createLoadBalancerPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-load-balancer-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-type-name
                         policy-name
                         policy-attributes
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call createLoadBalancerPolicy"}
   [credentials4647 & args4648]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4649
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4647)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4649
      createLoadBalancerPolicy
      (elasticloadbalancing/create-load-balancer-policy-request
       (clojure.core/nth args4648 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :configure-health-check
   [m4650]
   (clojure.core/let
    [credentials4651 (:credentials m4650) args4652 (:args m4650)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4653
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4651)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4653
       configureHealthCheck
       (elasticloadbalancing/configure-health-check-request
        (clojure.core/nth args4652 0)))))))
  (clojure.core/defn
   configure-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         health-check
                         general-progress-listener]}]]),
    :doc "Generate map for configureHealthCheck"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :configure-health-check,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   configure-health-check
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         health-check
                         general-progress-listener]}]]),
    :doc "Call configureHealthCheck"}
   [credentials4655 & args4656]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4657
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4655)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4657
      configureHealthCheck
      (elasticloadbalancing/configure-health-check-request
       (clojure.core/nth args4656 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-instance-health
   [m4658]
   (clojure.core/let
    [credentials4659 (:credentials m4658) args4660 (:args m4658)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4661
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4659)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4661
       describeInstanceHealth
       (elasticloadbalancing/describe-instance-health-request
        (clojure.core/nth args4660 0)))))))
  (clojure.core/defn
   describe-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Generate map for describeInstanceHealth"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-instance-health,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Call describeInstanceHealth"}
   [credentials4663 & args4664]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4665
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4663)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4665
      describeInstanceHealth
      (elasticloadbalancing/describe-instance-health-request
       (clojure.core/nth args4664 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer
   [m4666]
   (clojure.core/let
    [credentials4667 (:credentials m4666) args4668 (:args m4666)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4669
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4667)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4669
       createLoadBalancer
       (elasticloadbalancing/create-load-balancer-request
        (clojure.core/nth args4668 0)))))))
  (clojure.core/defn
   create-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [scheme
                         general-progress-listener
                         subnets
                         listeners
                         security-groups
                         availability-zones
                         load-balancer-name]}]]),
    :doc "Generate map for createLoadBalancer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-load-balancer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [scheme
                         general-progress-listener
                         subnets
                         listeners
                         security-groups
                         availability-zones
                         load-balancer-name]}]]),
    :doc "Call createLoadBalancer"}
   [credentials4671 & args4672]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4673
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4671)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4673
      createLoadBalancer
      (elasticloadbalancing/create-load-balancer-request
       (clojure.core/nth args4672 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-for-backend-server
   [m4674]
   (clojure.core/let
    [credentials4675 (:credentials m4674) args4676 (:args m4674)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4677
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4675)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4677
       setLoadBalancerPoliciesForBackendServer
       (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
        (clojure.core/nth args4676 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-name
                         instance-port
                         general-progress-listener]}]]),
    :doc "Generate map for setLoadBalancerPoliciesForBackendServer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :set-load-balancer-policies-for-backend-server,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-name
                         instance-port
                         general-progress-listener]}]]),
    :doc "Call setLoadBalancerPoliciesForBackendServer"}
   [credentials4679 & args4680]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4681
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4679)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4681
      setLoadBalancerPoliciesForBackendServer
      (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
       (clojure.core/nth args4680 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :disable-availability-zones-for-load-balancer
   [m4682]
   (clojure.core/let
    [credentials4683 (:credentials m4682) args4684 (:args m4682)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4685
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4683)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4685
       disableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4684 0)))))))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         general-progress-listener
                         availability-zones]}]]),
    :doc "Generate map for disableAvailabilityZonesForLoadBalancer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :disable-availability-zones-for-load-balancer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         general-progress-listener
                         availability-zones]}]]),
    :doc "Call disableAvailabilityZonesForLoadBalancer"}
   [credentials4687 & args4688]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4689
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4687)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4689
      disableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4688 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :detach-load-balancer-from-subnets
   [m4690]
   (clojure.core/let
    [credentials4691 (:credentials m4690) args4692 (:args m4690)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4693
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4691)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4693
       detachLoadBalancerFromSubnets
       (elasticloadbalancing/detach-load-balancer-from-subnets-request
        (clojure.core/nth args4692 0)))))))
  (clojure.core/defn
   detach-load-balancer-from-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for detachLoadBalancerFromSubnets"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :detach-load-balancer-from-subnets,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   detach-load-balancer-from-subnets
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call detachLoadBalancerFromSubnets"}
   [credentials4695 & args4696]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4697
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4695)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4697
      detachLoadBalancerFromSubnets
      (elasticloadbalancing/detach-load-balancer-from-subnets-request
       (clojure.core/nth args4696 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-listeners
   [m4698]
   (clojure.core/let
    [credentials4699 (:credentials m4698) args4700 (:args m4698)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4701
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4699)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4701
       createLoadBalancerListeners
       (elasticloadbalancing/create-load-balancer-listeners-request
        (clojure.core/nth args4700 0)))))))
  (clojure.core/defn
   create-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         listeners
                         general-progress-listener]}]]),
    :doc "Generate map for createLoadBalancerListeners"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-load-balancer-listeners,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         listeners
                         general-progress-listener]}]]),
    :doc "Call createLoadBalancerListeners"}
   [credentials4703 & args4704]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4705
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4703)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4705
      createLoadBalancerListeners
      (elasticloadbalancing/create-load-balancer-listeners-request
       (clojure.core/nth args4704 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-listeners
   [m4706]
   (clojure.core/let
    [credentials4707 (:credentials m4706) args4708 (:args m4706)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4709
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4707)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4709
       deleteLoadBalancerListeners
       (elasticloadbalancing/delete-load-balancer-listeners-request
        (clojure.core/nth args4708 0)))))))
  (clojure.core/defn
   delete-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-ports
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteLoadBalancerListeners"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :delete-load-balancer-listeners,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-ports
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call deleteLoadBalancerListeners"}
   [credentials4711 & args4712]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4713
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4711)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4713
      deleteLoadBalancerListeners
      (elasticloadbalancing/delete-load-balancer-listeners-request
       (clojure.core/nth args4712 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-listener-sslcertificate
   [m4714]
   (clojure.core/let
    [credentials4715 (:credentials m4714) args4716 (:args m4714)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4717
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4715)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4717
       setLoadBalancerListenerSSLCertificate
       (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
        (clojure.core/nth args4716 0)))))))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-port
                         load-balancer-name
                         general-progress-listener
                         sslcertificate-id]}]]),
    :doc "Generate map for setLoadBalancerListenerSSLCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :set-load-balancer-listener-sslcertificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-port
                         load-balancer-name
                         general-progress-listener
                         sslcertificate-id]}]]),
    :doc "Call setLoadBalancerListenerSSLCertificate"}
   [credentials4719 & args4720]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4721
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4719)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4721
      setLoadBalancerListenerSSLCertificate
      (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
       (clojure.core/nth args4720 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :register-instances-with-load-balancer
   [m4722]
   (clojure.core/let
    [credentials4723 (:credentials m4722) args4724 (:args m4722)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4725
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4723)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4725
       registerInstancesWithLoadBalancer
       (elasticloadbalancing/register-instances-with-load-balancer-request
        (clojure.core/nth args4724 0)))))))
  (clojure.core/defn
   register-instances-with-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Generate map for registerInstancesWithLoadBalancer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :register-instances-with-load-balancer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   register-instances-with-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Call registerInstancesWithLoadBalancer"}
   [credentials4727 & args4728]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4729
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4727)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4729
      registerInstancesWithLoadBalancer
      (elasticloadbalancing/register-instances-with-load-balancer-request
       (clojure.core/nth args4728 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-of-listener
   [m4730]
   (clojure.core/let
    [credentials4731 (:credentials m4730) args4732 (:args m4730)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4733
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4731)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4733
       setLoadBalancerPoliciesOfListener
       (elasticloadbalancing/set-load-balancer-policies-of-listener-request
        (clojure.core/nth args4732 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-of-listener-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-port
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for setLoadBalancerPoliciesOfListener"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :set-load-balancer-policies-of-listener,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-load-balancer-policies-of-listener
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-port
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call setLoadBalancerPoliciesOfListener"}
   [credentials4735 & args4736]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4737
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4735)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4737
      setLoadBalancerPoliciesOfListener
      (elasticloadbalancing/set-load-balancer-policies-of-listener-request
       (clojure.core/nth args4736 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :attach-load-balancer-to-subnets
   [m4738]
   (clojure.core/let
    [credentials4739 (:credentials m4738) args4740 (:args m4738)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4741
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4739)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4741
       attachLoadBalancerToSubnets
       (elasticloadbalancing/attach-load-balancer-to-subnets-request
        (clojure.core/nth args4740 0)))))))
  (clojure.core/defn
   attach-load-balancer-to-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for attachLoadBalancerToSubnets"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :attach-load-balancer-to-subnets,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   attach-load-balancer-to-subnets
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call attachLoadBalancerToSubnets"}
   [credentials4743 & args4744]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4745
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4743)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4745
      attachLoadBalancerToSubnets
      (elasticloadbalancing/attach-load-balancer-to-subnets-request
       (clojure.core/nth args4744 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :modify-load-balancer-attributes
   [m4746]
   (clojure.core/let
    [credentials4747 (:credentials m4746) args4748 (:args m4746)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4749
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4747)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4749
       modifyLoadBalancerAttributes
       (elasticloadbalancing/modify-load-balancer-attributes-request
        (clojure.core/nth args4748 0)))))))
  (clojure.core/defn
   modify-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         load-balancer-attributes
                         general-progress-listener]}]]),
    :doc "Generate map for modifyLoadBalancerAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :modify-load-balancer-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         load-balancer-attributes
                         general-progress-listener]}]]),
    :doc "Call modifyLoadBalancerAttributes"}
   [credentials4751 & args4752]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4753
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4751)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4753
      modifyLoadBalancerAttributes
      (elasticloadbalancing/modify-load-balancer-attributes-request
       (clojure.core/nth args4752 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancers
   [m4754]
   (clojure.core/let
    [credentials4755 (:credentials m4754) args4756 (:args m4754)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4757
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4755)]
     (clojure.core/case
      (clojure.core/count args4756)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4757
        describeLoadBalancers
        (elasticloadbalancing/describe-load-balancers-request
         (clojure.core/nth args4756 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4757
        describeLoadBalancers))))))
  (clojure.core/defn
   describe-load-balancers-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         load-balancer-names
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeLoadBalancers, describeLoadBalancers"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticloadbalancing,
     :fn :describe-load-balancers,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancers,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-load-balancers
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         load-balancer-names
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call describeLoadBalancers, describeLoadBalancers"}
   [credentials4759 & args4760]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4761
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4759)]
    (clojure.core/case
     (clojure.core/count args4760)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4761
       describeLoadBalancers
       (elasticloadbalancing/describe-load-balancers-request
        (clojure.core/nth args4760 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4761
       describeLoadBalancers))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-attributes
   [m4762]
   (clojure.core/let
    [credentials4763 (:credentials m4762) args4764 (:args m4762)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4765
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4763)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4765
       describeLoadBalancerAttributes
       (elasticloadbalancing/describe-load-balancer-attributes-request
        (clojure.core/nth args4764 0)))))))
  (clojure.core/defn
   describe-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name general-progress-listener]}]]),
    :doc "Generate map for describeLoadBalancerAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name general-progress-listener]}]]),
    :doc "Call describeLoadBalancerAttributes"}
   [credentials4767 & args4768]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4769
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4767)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4769
      describeLoadBalancerAttributes
      (elasticloadbalancing/describe-load-balancer-attributes-request
       (clojure.core/nth args4768 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-app-cookie-stickiness-policy
   [m4770]
   (clojure.core/let
    [credentials4771 (:credentials m4770) args4772 (:args m4770)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4773
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4771)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4773
       createAppCookieStickinessPolicy
       (elasticloadbalancing/create-app-cookie-stickiness-policy-request
        (clojure.core/nth args4772 0)))))))
  (clojure.core/defn
   create-app-cookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener
                         cookie-name]}]]),
    :doc "Generate map for createAppCookieStickinessPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-app-cookie-stickiness-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-app-cookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener
                         cookie-name]}]]),
    :doc "Call createAppCookieStickinessPolicy"}
   [credentials4775 & args4776]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4777
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4775)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4777
      createAppCookieStickinessPolicy
      (elasticloadbalancing/create-app-cookie-stickiness-policy-request
       (clojure.core/nth args4776 0))))))))
