(ns
 com.palletops.awaze.elasticbeanstalk
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticbeanstalk :as elasticbeanstalk]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticbeanstalk
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier}
environment-tier
  [m9350]
  (clojure.core/let
   [bean9349
    (new
     com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier)]
   (clojure.core/let
    [v9351 (:name m9350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9351 :com.palletops.awaze.client-builder/undef)
     (. bean9349 setName (clojure.core/str v9351))))
   (clojure.core/let
    [v9351 (:version m9350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9351 :com.palletops.awaze.client-builder/undef)
     (. bean9349 setVersion (clojure.core/str v9351))))
   (clojure.core/let
    [v9351 (:type m9350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9351 :com.palletops.awaze.client-builder/undef)
     (. bean9349 setType (clojure.core/str v9351))))
   bean9349))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting}
configuration-option-setting
  [m9353]
  (clojure.core/let
   [bean9352
    (new
     com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting)]
   (clojure.core/let
    [v9354 (:value m9353 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9354 :com.palletops.awaze.client-builder/undef)
     (. bean9352 setValue (clojure.core/str v9354))))
   (clojure.core/let
    [v9354
     (:option-name m9353 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9354 :com.palletops.awaze.client-builder/undef)
     (. bean9352 setOptionName (clojure.core/str v9354))))
   (clojure.core/let
    [v9354
     (:namespace m9353 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9354 :com.palletops.awaze.client-builder/undef)
     (. bean9352 setNamespace (clojure.core/str v9354))))
   bean9352))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.OptionSpecification}
option-specification
  [m9356]
  (clojure.core/let
   [bean9355
    (new
     com.amazonaws.services.elasticbeanstalk.model.OptionSpecification)]
   (clojure.core/let
    [v9357
     (:option-name m9356 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9357 :com.palletops.awaze.client-builder/undef)
     (. bean9355 setOptionName (clojure.core/str v9357))))
   (clojure.core/let
    [v9357
     (:namespace m9356 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9357 :com.palletops.awaze.client-builder/undef)
     (. bean9355 setNamespace (clojure.core/str v9357))))
   bean9355))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.Tag}
tag
  [m9359]
  (clojure.core/let
   [bean9358 (new com.amazonaws.services.elasticbeanstalk.model.Tag)]
   (clojure.core/let
    [v9360 (:value m9359 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9360 :com.palletops.awaze.client-builder/undef)
     (. bean9358 setValue (clojure.core/str v9360))))
   (clojure.core/let
    [v9360 (:key m9359 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9360 :com.palletops.awaze.client-builder/undef)
     (. bean9358 setKey (clojure.core/str v9360))))
   bean9358))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.S3Location}
s3location
  [m9362]
  (clojure.core/let
   [bean9361
    (new com.amazonaws.services.elasticbeanstalk.model.S3Location)]
   (clojure.core/let
    [v9363 (:s3key m9362 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9363 :com.palletops.awaze.client-builder/undef)
     (. bean9361 setS3Key (clojure.core/str v9363))))
   (clojure.core/let
    [v9363
     (:s3bucket m9362 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9363 :com.palletops.awaze.client-builder/undef)
     (. bean9361 setS3Bucket (clojure.core/str v9363))))
   bean9361))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration}
source-configuration
  [m9365]
  (clojure.core/let
   [bean9364
    (new
     com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration)]
   (clojure.core/let
    [v9366
     (:application-name
      m9365
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9366 :com.palletops.awaze.client-builder/undef)
     (. bean9364 setApplicationName (clojure.core/str v9366))))
   (clojure.core/let
    [v9366
     (:template-name m9365 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9366 :com.palletops.awaze.client-builder/undef)
     (. bean9364 setTemplateName (clojure.core/str v9366))))
   bean9364))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.EnvironmentInfoType}
environment-info-type
  [m9368]
  (.
   com.amazonaws.services.elasticbeanstalk.model.EnvironmentInfoType
   fromValue
   (clojure.core/name m9368)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest}
create-application-request
  [m9371]
  (clojure.core/let
   [bean9370
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest)]
   (clojure.core/let
    [v9372
     (:description m9371 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9372 :com.palletops.awaze.client-builder/undef)
     (. bean9370 setDescription (clojure.core/str v9372))))
   (clojure.core/let
    [v9372
     (:application-name
      m9371
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9372 :com.palletops.awaze.client-builder/undef)
     (. bean9370 setApplicationName (clojure.core/str v9372))))
   bean9370))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest}
delete-application-request
  [m9374]
  (clojure.core/let
   [bean9373
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest)]
   (clojure.core/let
    [v9375
     (:terminate-env-by-force
      m9374
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9375 :com.palletops.awaze.client-builder/undef)
     (. bean9373 setTerminateEnvByForce (clojure.core/boolean v9375))))
   (clojure.core/let
    [v9375
     (:application-name
      m9374
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9375 :com.palletops.awaze.client-builder/undef)
     (. bean9373 setApplicationName (clojure.core/str v9375))))
   bean9373))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest}
create-environment-request
  [m9377]
  (clojure.core/let
   [bean9376
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest)]
   (clojure.core/let
    [v9378 (:tier m9377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9378 :com.palletops.awaze.client-builder/undef)
     (. bean9376 setTier (elasticbeanstalk/environment-tier v9378))))
   (clojure.core/let
    [v9378
     (:template-name m9377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9378 :com.palletops.awaze.client-builder/undef)
     (. bean9376 setTemplateName (clojure.core/str v9378))))
   (clojure.core/let
    [v9378
     (:solution-stack-name
      m9377
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9378 :com.palletops.awaze.client-builder/undef)
     (. bean9376 setSolutionStackName (clojure.core/str v9378))))
   (clojure.core/let
    [v9378
     (:application-name
      m9377
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9378 :com.palletops.awaze.client-builder/undef)
     (. bean9376 setApplicationName (clojure.core/str v9378))))
   (clojure.core/let
    [v9378
     (:option-settings
      m9377
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9378 :com.palletops.awaze.client-builder/undef)
     (.
      bean9376
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9457]
  (elasticbeanstalk/configuration-option-setting arg9457))
 v9378))))
   (clojure.core/let
    [v9378
     (:description m9377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9378 :com.palletops.awaze.client-builder/undef)
     (. bean9376 setDescription (clojure.core/str v9378))))
   (clojure.core/let
    [v9378
     (:options-to-remove
      m9377
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9378 :com.palletops.awaze.client-builder/undef)
     (.
      bean9376
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9458]
  (elasticbeanstalk/option-specification arg9458))
 v9378))))
   (clojure.core/let
    [v9378 (:tags m9377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9378 :com.palletops.awaze.client-builder/undef)
     (.
      bean9376
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9459] (elasticbeanstalk/tag arg9459))
 v9378))))
   (clojure.core/let
    [v9378
     (:environment-name
      m9377
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9378 :com.palletops.awaze.client-builder/undef)
     (. bean9376 setEnvironmentName (clojure.core/str v9378))))
   (clojure.core/let
    [v9378
     (:version-label m9377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9378 :com.palletops.awaze.client-builder/undef)
     (. bean9376 setVersionLabel (clojure.core/str v9378))))
   (clojure.core/let
    [v9378
     (:cnameprefix m9377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9378 :com.palletops.awaze.client-builder/undef)
     (. bean9376 setCNAMEPrefix (clojure.core/str v9378))))
   bean9376))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest}
describe-configuration-settings-request
  [m9380]
  (clojure.core/let
   [bean9379
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest)]
   (clojure.core/let
    [v9381
     (:application-name
      m9380
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9381 :com.palletops.awaze.client-builder/undef)
     (. bean9379 setApplicationName (clojure.core/str v9381))))
   (clojure.core/let
    [v9381
     (:environment-name
      m9380
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9381 :com.palletops.awaze.client-builder/undef)
     (. bean9379 setEnvironmentName (clojure.core/str v9381))))
   (clojure.core/let
    [v9381
     (:template-name m9380 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9381 :com.palletops.awaze.client-builder/undef)
     (. bean9379 setTemplateName (clojure.core/str v9381))))
   bean9379))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest}
create-storage-location-request
  [m9383]
  (clojure.core/let
   [bean9382
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest)]
   bean9382))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest}
describe-configuration-options-request
  [m9386]
  (clojure.core/let
   [bean9385
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest)]
   (clojure.core/let
    [v9387 (:options m9386 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9387 :com.palletops.awaze.client-builder/undef)
     (.
      bean9385
      setOptions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9460]
  (elasticbeanstalk/option-specification arg9460))
 v9387))))
   (clojure.core/let
    [v9387
     (:application-name
      m9386
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9387 :com.palletops.awaze.client-builder/undef)
     (. bean9385 setApplicationName (clojure.core/str v9387))))
   (clojure.core/let
    [v9387
     (:environment-name
      m9386
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9387 :com.palletops.awaze.client-builder/undef)
     (. bean9385 setEnvironmentName (clojure.core/str v9387))))
   (clojure.core/let
    [v9387
     (:template-name m9386 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9387 :com.palletops.awaze.client-builder/undef)
     (. bean9385 setTemplateName (clojure.core/str v9387))))
   (clojure.core/let
    [v9387
     (:solution-stack-name
      m9386
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9387 :com.palletops.awaze.client-builder/undef)
     (. bean9385 setSolutionStackName (clojure.core/str v9387))))
   bean9385))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest}
rebuild-environment-request
  [m9389]
  (clojure.core/let
   [bean9388
    (new
     com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest)]
   (clojure.core/let
    [v9390
     (:environment-id m9389 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9390 :com.palletops.awaze.client-builder/undef)
     (. bean9388 setEnvironmentId (clojure.core/str v9390))))
   (clojure.core/let
    [v9390
     (:environment-name
      m9389
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9390 :com.palletops.awaze.client-builder/undef)
     (. bean9388 setEnvironmentName (clojure.core/str v9390))))
   bean9388))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest}
create-application-version-request
  [m9392]
  (clojure.core/let
   [bean9391
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest)]
   (clojure.core/let
    [v9393
     (:source-bundle m9392 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9393 :com.palletops.awaze.client-builder/undef)
     (. bean9391 setSourceBundle (elasticbeanstalk/s3location v9393))))
   (clojure.core/let
    [v9393
     (:auto-create-application
      m9392
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9393 :com.palletops.awaze.client-builder/undef)
     (.
      bean9391
      setAutoCreateApplication
      (clojure.core/boolean v9393))))
   (clojure.core/let
    [v9393
     (:description m9392 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9393 :com.palletops.awaze.client-builder/undef)
     (. bean9391 setDescription (clojure.core/str v9393))))
   (clojure.core/let
    [v9393
     (:application-name
      m9392
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9393 :com.palletops.awaze.client-builder/undef)
     (. bean9391 setApplicationName (clojure.core/str v9393))))
   (clojure.core/let
    [v9393
     (:version-label m9392 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9393 :com.palletops.awaze.client-builder/undef)
     (. bean9391 setVersionLabel (clojure.core/str v9393))))
   bean9391))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest}
update-environment-request
  [m9395]
  (clojure.core/let
   [bean9394
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest)]
   (clojure.core/let
    [v9396
     (:option-settings
      m9395
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9396 :com.palletops.awaze.client-builder/undef)
     (.
      bean9394
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9461]
  (elasticbeanstalk/configuration-option-setting arg9461))
 v9396))))
   (clojure.core/let
    [v9396
     (:environment-id m9395 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9396 :com.palletops.awaze.client-builder/undef)
     (. bean9394 setEnvironmentId (clojure.core/str v9396))))
   (clojure.core/let
    [v9396
     (:options-to-remove
      m9395
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9396 :com.palletops.awaze.client-builder/undef)
     (.
      bean9394
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9462]
  (elasticbeanstalk/option-specification arg9462))
 v9396))))
   (clojure.core/let
    [v9396
     (:description m9395 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9396 :com.palletops.awaze.client-builder/undef)
     (. bean9394 setDescription (clojure.core/str v9396))))
   (clojure.core/let
    [v9396 (:tier m9395 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9396 :com.palletops.awaze.client-builder/undef)
     (. bean9394 setTier (elasticbeanstalk/environment-tier v9396))))
   (clojure.core/let
    [v9396
     (:environment-name
      m9395
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9396 :com.palletops.awaze.client-builder/undef)
     (. bean9394 setEnvironmentName (clojure.core/str v9396))))
   (clojure.core/let
    [v9396
     (:version-label m9395 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9396 :com.palletops.awaze.client-builder/undef)
     (. bean9394 setVersionLabel (clojure.core/str v9396))))
   (clojure.core/let
    [v9396
     (:template-name m9395 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9396 :com.palletops.awaze.client-builder/undef)
     (. bean9394 setTemplateName (clojure.core/str v9396))))
   bean9394))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest}
create-configuration-template-request
  [m9398]
  (clojure.core/let
   [bean9397
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest)]
   (clojure.core/let
    [v9399
     (:option-settings
      m9398
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9399 :com.palletops.awaze.client-builder/undef)
     (.
      bean9397
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9463]
  (elasticbeanstalk/configuration-option-setting arg9463))
 v9399))))
   (clojure.core/let
    [v9399
     (:environment-id m9398 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9399 :com.palletops.awaze.client-builder/undef)
     (. bean9397 setEnvironmentId (clojure.core/str v9399))))
   (clojure.core/let
    [v9399
     (:source-configuration
      m9398
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9399 :com.palletops.awaze.client-builder/undef)
     (.
      bean9397
      setSourceConfiguration
      (elasticbeanstalk/source-configuration v9399))))
   (clojure.core/let
    [v9399
     (:description m9398 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9399 :com.palletops.awaze.client-builder/undef)
     (. bean9397 setDescription (clojure.core/str v9399))))
   (clojure.core/let
    [v9399
     (:application-name
      m9398
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9399 :com.palletops.awaze.client-builder/undef)
     (. bean9397 setApplicationName (clojure.core/str v9399))))
   (clojure.core/let
    [v9399
     (:template-name m9398 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9399 :com.palletops.awaze.client-builder/undef)
     (. bean9397 setTemplateName (clojure.core/str v9399))))
   (clojure.core/let
    [v9399
     (:solution-stack-name
      m9398
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9399 :com.palletops.awaze.client-builder/undef)
     (. bean9397 setSolutionStackName (clojure.core/str v9399))))
   bean9397))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest}
validate-configuration-settings-request
  [m9401]
  (clojure.core/let
   [bean9400
    (new
     com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest)]
   (clojure.core/let
    [v9402
     (:option-settings
      m9401
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9402 :com.palletops.awaze.client-builder/undef)
     (.
      bean9400
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9464]
  (elasticbeanstalk/configuration-option-setting arg9464))
 v9402))))
   (clojure.core/let
    [v9402
     (:application-name
      m9401
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9402 :com.palletops.awaze.client-builder/undef)
     (. bean9400 setApplicationName (clojure.core/str v9402))))
   (clojure.core/let
    [v9402
     (:environment-name
      m9401
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9402 :com.palletops.awaze.client-builder/undef)
     (. bean9400 setEnvironmentName (clojure.core/str v9402))))
   (clojure.core/let
    [v9402
     (:template-name m9401 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9402 :com.palletops.awaze.client-builder/undef)
     (. bean9400 setTemplateName (clojure.core/str v9402))))
   bean9400))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest}
describe-events-request
  [m9404]
  (clojure.core/let
   [bean9403
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest)]
   (clojure.core/let
    [v9405
     (:max-records m9404 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9405 :com.palletops.awaze.client-builder/undef)
     (. bean9403 setMaxRecords (clojure.core/int v9405))))
   (clojure.core/let
    [v9405
     (:next-token m9404 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9405 :com.palletops.awaze.client-builder/undef)
     (. bean9403 setNextToken (clojure.core/str v9405))))
   (clojure.core/let
    [v9405
     (:end-time m9404 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9405 :com.palletops.awaze.client-builder/undef)
     (.
      bean9403
      setEndTime
      (com.palletops.awaze.common/to-date v9405))))
   (clojure.core/let
    [v9405
     (:template-name m9404 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9405 :com.palletops.awaze.client-builder/undef)
     (. bean9403 setTemplateName (clojure.core/str v9405))))
   (clojure.core/let
    [v9405
     (:request-id m9404 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9405 :com.palletops.awaze.client-builder/undef)
     (. bean9403 setRequestId (clojure.core/str v9405))))
   (clojure.core/let
    [v9405
     (:environment-id m9404 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9405 :com.palletops.awaze.client-builder/undef)
     (. bean9403 setEnvironmentId (clojure.core/str v9405))))
   (clojure.core/let
    [v9405
     (:start-time m9404 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9405 :com.palletops.awaze.client-builder/undef)
     (.
      bean9403
      setStartTime
      (com.palletops.awaze.common/to-date v9405))))
   (clojure.core/let
    [v9405
     (:application-name
      m9404
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9405 :com.palletops.awaze.client-builder/undef)
     (. bean9403 setApplicationName (clojure.core/str v9405))))
   (clojure.core/let
    [v9405
     (:environment-name
      m9404
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9405 :com.palletops.awaze.client-builder/undef)
     (. bean9403 setEnvironmentName (clojure.core/str v9405))))
   (clojure.core/let
    [v9405
     (:version-label m9404 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9405 :com.palletops.awaze.client-builder/undef)
     (. bean9403 setVersionLabel (clojure.core/str v9405))))
   (clojure.core/let
    [v9405
     (:severity m9404 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9405 :com.palletops.awaze.client-builder/undef)
     (. bean9403 setSeverity (clojure.core/str v9405))))
   bean9403))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest}
describe-applications-request
  [m9407]
  (clojure.core/let
   [bean9406
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest)]
   (clojure.core/let
    [v9408
     (:application-names
      m9407
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9408 :com.palletops.awaze.client-builder/undef)
     (.
      bean9406
      setApplicationNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9465] (clojure.core/str arg9465))
 v9408))))
   bean9406))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest}
check-dnsavailability-request
  [m9410]
  (clojure.core/let
   [bean9409
    (new
     com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest)]
   (clojure.core/let
    [v9411
     (:cnameprefix m9410 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9411 :com.palletops.awaze.client-builder/undef)
     (. bean9409 setCNAMEPrefix (clojure.core/str v9411))))
   bean9409))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest}
restart-app-server-request
  [m9413]
  (clojure.core/let
   [bean9412
    (new
     com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest)]
   (clojure.core/let
    [v9414
     (:environment-id m9413 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9414 :com.palletops.awaze.client-builder/undef)
     (. bean9412 setEnvironmentId (clojure.core/str v9414))))
   (clojure.core/let
    [v9414
     (:environment-name
      m9413
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9414 :com.palletops.awaze.client-builder/undef)
     (. bean9412 setEnvironmentName (clojure.core/str v9414))))
   bean9412))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest}
update-application-version-request
  [m9416]
  (clojure.core/let
   [bean9415
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest)]
   (clojure.core/let
    [v9417
     (:description m9416 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9417 :com.palletops.awaze.client-builder/undef)
     (. bean9415 setDescription (clojure.core/str v9417))))
   (clojure.core/let
    [v9417
     (:application-name
      m9416
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9417 :com.palletops.awaze.client-builder/undef)
     (. bean9415 setApplicationName (clojure.core/str v9417))))
   (clojure.core/let
    [v9417
     (:version-label m9416 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9417 :com.palletops.awaze.client-builder/undef)
     (. bean9415 setVersionLabel (clojure.core/str v9417))))
   bean9415))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest}
describe-environment-resources-request
  [m9419]
  (clojure.core/let
   [bean9418
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest)]
   (clojure.core/let
    [v9420
     (:environment-id m9419 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9420 :com.palletops.awaze.client-builder/undef)
     (. bean9418 setEnvironmentId (clojure.core/str v9420))))
   (clojure.core/let
    [v9420
     (:environment-name
      m9419
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9420 :com.palletops.awaze.client-builder/undef)
     (. bean9418 setEnvironmentName (clojure.core/str v9420))))
   bean9418))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest}
describe-environments-request
  [m9422]
  (clojure.core/let
   [bean9421
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest)]
   (clojure.core/let
    [v9423
     (:environment-ids
      m9422
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9423 :com.palletops.awaze.client-builder/undef)
     (.
      bean9421
      setEnvironmentIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9466] (clojure.core/str arg9466))
 v9423))))
   (clojure.core/let
    [v9423
     (:environment-names
      m9422
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9423 :com.palletops.awaze.client-builder/undef)
     (.
      bean9421
      setEnvironmentNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9467] (clojure.core/str arg9467))
 v9423))))
   (clojure.core/let
    [v9423
     (:include-deleted
      m9422
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9423 :com.palletops.awaze.client-builder/undef)
     (. bean9421 setIncludeDeleted (clojure.core/boolean v9423))))
   (clojure.core/let
    [v9423
     (:included-deleted-back-to
      m9422
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9423 :com.palletops.awaze.client-builder/undef)
     (.
      bean9421
      setIncludedDeletedBackTo
      (com.palletops.awaze.common/to-date v9423))))
   (clojure.core/let
    [v9423
     (:application-name
      m9422
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9423 :com.palletops.awaze.client-builder/undef)
     (. bean9421 setApplicationName (clojure.core/str v9423))))
   (clojure.core/let
    [v9423
     (:version-label m9422 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9423 :com.palletops.awaze.client-builder/undef)
     (. bean9421 setVersionLabel (clojure.core/str v9423))))
   bean9421))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest}
describe-application-versions-request
  [m9425]
  (clojure.core/let
   [bean9424
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest)]
   (clojure.core/let
    [v9426
     (:version-labels m9425 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9426 :com.palletops.awaze.client-builder/undef)
     (.
      bean9424
      setVersionLabels
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9468] (clojure.core/str arg9468))
 v9426))))
   (clojure.core/let
    [v9426
     (:application-name
      m9425
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9426 :com.palletops.awaze.client-builder/undef)
     (. bean9424 setApplicationName (clojure.core/str v9426))))
   bean9424))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest}
delete-application-version-request
  [m9428]
  (clojure.core/let
   [bean9427
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest)]
   (clojure.core/let
    [v9429
     (:delete-source-bundle
      m9428
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9429 :com.palletops.awaze.client-builder/undef)
     (. bean9427 setDeleteSourceBundle (clojure.core/boolean v9429))))
   (clojure.core/let
    [v9429
     (:application-name
      m9428
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9429 :com.palletops.awaze.client-builder/undef)
     (. bean9427 setApplicationName (clojure.core/str v9429))))
   (clojure.core/let
    [v9429
     (:version-label m9428 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9429 :com.palletops.awaze.client-builder/undef)
     (. bean9427 setVersionLabel (clojure.core/str v9429))))
   bean9427))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest}
swap-environment-cnames-request
  [m9431]
  (clojure.core/let
   [bean9430
    (new
     com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest)]
   (clojure.core/let
    [v9432
     (:source-environment-id
      m9431
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9432 :com.palletops.awaze.client-builder/undef)
     (. bean9430 setSourceEnvironmentId (clojure.core/str v9432))))
   (clojure.core/let
    [v9432
     (:source-environment-name
      m9431
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9432 :com.palletops.awaze.client-builder/undef)
     (. bean9430 setSourceEnvironmentName (clojure.core/str v9432))))
   (clojure.core/let
    [v9432
     (:destination-environment-id
      m9431
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9432 :com.palletops.awaze.client-builder/undef)
     (. bean9430 setDestinationEnvironmentId (clojure.core/str v9432))))
   (clojure.core/let
    [v9432
     (:destination-environment-name
      m9431
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9432 :com.palletops.awaze.client-builder/undef)
     (.
      bean9430
      setDestinationEnvironmentName
      (clojure.core/str v9432))))
   bean9430))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest}
delete-configuration-template-request
  [m9434]
  (clojure.core/let
   [bean9433
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest)]
   (clojure.core/let
    [v9435
     (:application-name
      m9434
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9435 :com.palletops.awaze.client-builder/undef)
     (. bean9433 setApplicationName (clojure.core/str v9435))))
   (clojure.core/let
    [v9435
     (:template-name m9434 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9435 :com.palletops.awaze.client-builder/undef)
     (. bean9433 setTemplateName (clojure.core/str v9435))))
   bean9433))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest}
update-application-request
  [m9437]
  (clojure.core/let
   [bean9436
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest)]
   (clojure.core/let
    [v9438
     (:description m9437 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9438 :com.palletops.awaze.client-builder/undef)
     (. bean9436 setDescription (clojure.core/str v9438))))
   (clojure.core/let
    [v9438
     (:application-name
      m9437
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9438 :com.palletops.awaze.client-builder/undef)
     (. bean9436 setApplicationName (clojure.core/str v9438))))
   bean9436))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest}
list-available-solution-stacks-request
  [m9440]
  (clojure.core/let
   [bean9439
    (new
     com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest)]
   bean9439))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest}
update-configuration-template-request
  [m9443]
  (clojure.core/let
   [bean9442
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest)]
   (clojure.core/let
    [v9444
     (:option-settings
      m9443
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9444 :com.palletops.awaze.client-builder/undef)
     (.
      bean9442
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9469]
  (elasticbeanstalk/configuration-option-setting arg9469))
 v9444))))
   (clojure.core/let
    [v9444
     (:options-to-remove
      m9443
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9444 :com.palletops.awaze.client-builder/undef)
     (.
      bean9442
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg9470]
  (elasticbeanstalk/option-specification arg9470))
 v9444))))
   (clojure.core/let
    [v9444
     (:description m9443 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9444 :com.palletops.awaze.client-builder/undef)
     (. bean9442 setDescription (clojure.core/str v9444))))
   (clojure.core/let
    [v9444
     (:application-name
      m9443
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9444 :com.palletops.awaze.client-builder/undef)
     (. bean9442 setApplicationName (clojure.core/str v9444))))
   (clojure.core/let
    [v9444
     (:template-name m9443 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9444 :com.palletops.awaze.client-builder/undef)
     (. bean9442 setTemplateName (clojure.core/str v9444))))
   bean9442))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest}
request-environment-info-request
  [m9446]
  (clojure.core/let
   [bean9445
    (new
     com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest)]
   (clojure.core/let
    [v9447
     (:environment-id m9446 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9447 :com.palletops.awaze.client-builder/undef)
     (. bean9445 setEnvironmentId (clojure.core/str v9447))))
   (clojure.core/let
    [v9447
     (:info-type m9446 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9447 :com.palletops.awaze.client-builder/undef)
     (.
      bean9445
      setInfoType
      (elasticbeanstalk/environment-info-type v9447))))
   (clojure.core/let
    [v9447
     (:environment-name
      m9446
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9447 :com.palletops.awaze.client-builder/undef)
     (. bean9445 setEnvironmentName (clojure.core/str v9447))))
   bean9445))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest}
delete-environment-configuration-request
  [m9449]
  (clojure.core/let
   [bean9448
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest)]
   (clojure.core/let
    [v9450
     (:application-name
      m9449
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9450 :com.palletops.awaze.client-builder/undef)
     (. bean9448 setApplicationName (clojure.core/str v9450))))
   (clojure.core/let
    [v9450
     (:environment-name
      m9449
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9450 :com.palletops.awaze.client-builder/undef)
     (. bean9448 setEnvironmentName (clojure.core/str v9450))))
   bean9448))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest}
terminate-environment-request
  [m9452]
  (clojure.core/let
   [bean9451
    (new
     com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest)]
   (clojure.core/let
    [v9453
     (:environment-id m9452 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9453 :com.palletops.awaze.client-builder/undef)
     (. bean9451 setEnvironmentId (clojure.core/str v9453))))
   (clojure.core/let
    [v9453
     (:terminate-resources
      m9452
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9453 :com.palletops.awaze.client-builder/undef)
     (. bean9451 setTerminateResources (clojure.core/boolean v9453))))
   (clojure.core/let
    [v9453
     (:environment-name
      m9452
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9453 :com.palletops.awaze.client-builder/undef)
     (. bean9451 setEnvironmentName (clojure.core/str v9453))))
   bean9451))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest}
retrieve-environment-info-request
  [m9455]
  (clojure.core/let
   [bean9454
    (new
     com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest)]
   (clojure.core/let
    [v9456
     (:environment-id m9455 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9456 :com.palletops.awaze.client-builder/undef)
     (. bean9454 setEnvironmentId (clojure.core/str v9456))))
   (clojure.core/let
    [v9456
     (:info-type m9455 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9456 :com.palletops.awaze.client-builder/undef)
     (.
      bean9454
      setInfoType
      (elasticbeanstalk/environment-info-type v9456))))
   (clojure.core/let
    [v9456
     (:environment-name
      m9455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9456 :com.palletops.awaze.client-builder/undef)
     (. bean9454 setEnvironmentName (clojure.core/str v9456))))
   bean9454))
 (clojure.core/defmulti
  elasticbeanstalk
  (clojure.core/fn
   elasticbeanstalk
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application
   [m9471]
   (clojure.core/let
    [credentials9472 (:credentials m9471) args9473 (:args m9471)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9474
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9472)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9474
       createApplication
       (elasticbeanstalk/create-application-request
        (clojure.core/nth args9473 0)))))))
  (clojure.core/defn
   create-application-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         application-name]}]]),
    :doc "Generate map for createApplication"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-application,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-application
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         application-name]}]]),
    :doc "Call createApplication"}
   [credentials9476 & args9477]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9478
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9476)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9478
      createApplication
      (elasticbeanstalk/create-application-request
       (clojure.core/nth args9477 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application
   [m9479]
   (clojure.core/let
    [credentials9480 (:credentials m9479) args9481 (:args m9479)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9482
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9480)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9482
       deleteApplication
       (elasticbeanstalk/delete-application-request
        (clojure.core/nth args9481 0)))))))
  (clojure.core/defn
   delete-application-map
   {:arglists (quote
               [[credentials
                 {:keys [terminate-env-by-force
                         general-progress-listener
                         application-name]}]]),
    :doc "Generate map for deleteApplication"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-application,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-application
   {:arglists (quote
               [[credentials
                 {:keys [terminate-env-by-force
                         general-progress-listener
                         application-name]}]]),
    :doc "Call deleteApplication"}
   [credentials9484 & args9485]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9486
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9484)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9486
      deleteApplication
      (elasticbeanstalk/delete-application-request
       (clojure.core/nth args9485 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-environment
   [m9487]
   (clojure.core/let
    [credentials9488 (:credentials m9487) args9489 (:args m9487)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9490
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9488)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9490
       createEnvironment
       (elasticbeanstalk/create-environment-request
        (clojure.core/nth args9489 0)))))))
  (clojure.core/defn
   create-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         option-settings
                         tier
                         version-label
                         cnameprefix
                         application-name
                         solution-stack-name
                         environment-name
                         description
                         options-to-remove
                         template-name
                         tags]}]]),
    :doc "Generate map for createEnvironment"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-environment,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-environment
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         option-settings
                         tier
                         version-label
                         cnameprefix
                         application-name
                         solution-stack-name
                         environment-name
                         description
                         options-to-remove
                         template-name
                         tags]}]]),
    :doc "Call createEnvironment"}
   [credentials9492 & args9493]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9494
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9492)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9494
      createEnvironment
      (elasticbeanstalk/create-environment-request
       (clojure.core/nth args9493 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-settings
   [m9495]
   (clojure.core/let
    [credentials9496 (:credentials m9495) args9497 (:args m9495)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9498
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9496)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9498
       describeConfigurationSettings
       (elasticbeanstalk/describe-configuration-settings-request
        (clojure.core/nth args9497 0)))))))
  (clojure.core/defn
   describe-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         general-progress-listener
                         environment-name
                         application-name]}]]),
    :doc "Generate map for describeConfigurationSettings"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-configuration-settings,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         general-progress-listener
                         environment-name
                         application-name]}]]),
    :doc "Call describeConfigurationSettings"}
   [credentials9500 & args9501]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9502
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9500)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9502
      describeConfigurationSettings
      (elasticbeanstalk/describe-configuration-settings-request
       (clojure.core/nth args9501 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-storage-location
   [m9503]
   (clojure.core/let
    [credentials9504 (:credentials m9503) args9505 (:args m9503)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9506
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9504)]
     (clojure.core/case
      (clojure.core/count args9505)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9506
        createStorageLocation))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9506
        createStorageLocation
        (elasticbeanstalk/create-storage-location-request
         (clojure.core/nth args9505 0))))))))
  (clojure.core/defn
   create-storage-location-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for createStorageLocation, createStorageLocation"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :create-storage-location,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-storage-location,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-storage-location
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call createStorageLocation, createStorageLocation"}
   [credentials9508 & args9509]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9510
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9508)]
    (clojure.core/case
     (clojure.core/count args9509)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9510
       createStorageLocation))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9510
       createStorageLocation
       (elasticbeanstalk/create-storage-location-request
        (clojure.core/nth args9509 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-options
   [m9511]
   (clojure.core/let
    [credentials9512 (:credentials m9511) args9513 (:args m9511)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9514
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9512)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9514
       describeConfigurationOptions
       (elasticbeanstalk/describe-configuration-options-request
        (clojure.core/nth args9513 0)))))))
  (clojure.core/defn
   describe-configuration-options-map
   {:arglists (quote
               [[credentials
                 {:keys [options
                         solution-stack-name
                         environment-name
                         general-progress-listener
                         application-name
                         template-name]}]]),
    :doc "Generate map for describeConfigurationOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-configuration-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-configuration-options
   {:arglists (quote
               [[credentials
                 {:keys [options
                         solution-stack-name
                         environment-name
                         general-progress-listener
                         application-name
                         template-name]}]]),
    :doc "Call describeConfigurationOptions"}
   [credentials9516 & args9517]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9518
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9516)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9518
      describeConfigurationOptions
      (elasticbeanstalk/describe-configuration-options-request
       (clojure.core/nth args9517 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :rebuild-environment
   [m9519]
   (clojure.core/let
    [credentials9520 (:credentials m9519) args9521 (:args m9519)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9522
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9520)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9522
       rebuildEnvironment
       (elasticbeanstalk/rebuild-environment-request
        (clojure.core/nth args9521 0)))))))
  (clojure.core/defn
   rebuild-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for rebuildEnvironment"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :rebuild-environment,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   rebuild-environment
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Call rebuildEnvironment"}
   [credentials9524 & args9525]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9526
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9524)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9526
      rebuildEnvironment
      (elasticbeanstalk/rebuild-environment-request
       (clojure.core/nth args9525 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application-version
   [m9527]
   (clojure.core/let
    [credentials9528 (:credentials m9527) args9529 (:args m9527)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9530
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9528)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9530
       createApplicationVersion
       (elasticbeanstalk/create-application-version-request
        (clojure.core/nth args9529 0)))))))
  (clojure.core/defn
   create-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [source-bundle
                         description
                         version-label
                         general-progress-listener
                         auto-create-application
                         application-name]}]]),
    :doc "Generate map for createApplicationVersion"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-application-version,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-application-version
   {:arglists (quote
               [[credentials
                 {:keys [source-bundle
                         description
                         version-label
                         general-progress-listener
                         auto-create-application
                         application-name]}]]),
    :doc "Call createApplicationVersion"}
   [credentials9532 & args9533]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9534
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9532)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9534
      createApplicationVersion
      (elasticbeanstalk/create-application-version-request
       (clojure.core/nth args9533 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-environment
   [m9535]
   (clojure.core/let
    [credentials9536 (:credentials m9535) args9537 (:args m9535)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9538
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9536)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9538
       updateEnvironment
       (elasticbeanstalk/update-environment-request
        (clojure.core/nth args9537 0)))))))
  (clojure.core/defn
   update-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         general-progress-listener
                         option-settings
                         tier
                         version-label
                         environment-name
                         description
                         options-to-remove
                         template-name]}]]),
    :doc "Generate map for updateEnvironment"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-environment,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-environment
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         general-progress-listener
                         option-settings
                         tier
                         version-label
                         environment-name
                         description
                         options-to-remove
                         template-name]}]]),
    :doc "Call updateEnvironment"}
   [credentials9540 & args9541]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9542
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9540)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9542
      updateEnvironment
      (elasticbeanstalk/update-environment-request
       (clojure.core/nth args9541 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-configuration-template
   [m9543]
   (clojure.core/let
    [credentials9544 (:credentials m9543) args9545 (:args m9543)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9546
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9544)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9546
       createConfigurationTemplate
       (elasticbeanstalk/create-configuration-template-request
        (clojure.core/nth args9545 0)))))))
  (clojure.core/defn
   create-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         general-progress-listener
                         option-settings
                         source-configuration
                         application-name
                         solution-stack-name
                         description
                         template-name]}]]),
    :doc "Generate map for createConfigurationTemplate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-configuration-template,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         general-progress-listener
                         option-settings
                         source-configuration
                         application-name
                         solution-stack-name
                         description
                         template-name]}]]),
    :doc "Call createConfigurationTemplate"}
   [credentials9548 & args9549]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9550
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9548)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9550
      createConfigurationTemplate
      (elasticbeanstalk/create-configuration-template-request
       (clojure.core/nth args9549 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :validate-configuration-settings
   [m9551]
   (clojure.core/let
    [credentials9552 (:credentials m9551) args9553 (:args m9551)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9554
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9552)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9554
       validateConfigurationSettings
       (elasticbeanstalk/validate-configuration-settings-request
        (clojure.core/nth args9553 0)))))))
  (clojure.core/defn
   validate-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         option-settings
                         general-progress-listener
                         environment-name
                         application-name]}]]),
    :doc "Generate map for validateConfigurationSettings"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :validate-configuration-settings,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   validate-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         option-settings
                         general-progress-listener
                         environment-name
                         application-name]}]]),
    :doc "Call validateConfigurationSettings"}
   [credentials9556 & args9557]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9558
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9556)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9558
      validateConfigurationSettings
      (elasticbeanstalk/validate-configuration-settings-request
       (clojure.core/nth args9557 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-events
   [m9559]
   (clojure.core/let
    [credentials9560 (:credentials m9559) args9561 (:args m9559)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9562
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9560)]
     (clojure.core/case
      (clojure.core/count args9561)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9562
        describeEvents))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9562
        describeEvents
        (elasticbeanstalk/describe-events-request
         (clojure.core/nth args9561 0))))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         environment-id
                         general-progress-listener
                         max-records
                         start-time
                         version-label
                         application-name
                         environment-name
                         next-token
                         severity
                         template-name
                         request-id]}]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-events,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-events,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         environment-id
                         general-progress-listener
                         max-records
                         start-time
                         version-label
                         application-name
                         environment-name
                         next-token
                         severity
                         template-name
                         request-id]}]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials9564 & args9565]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9566
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9564)]
    (clojure.core/case
     (clojure.core/count args9565)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9566
       describeEvents))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9566
       describeEvents
       (elasticbeanstalk/describe-events-request
        (clojure.core/nth args9565 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-applications
   [m9567]
   (clojure.core/let
    [credentials9568 (:credentials m9567) args9569 (:args m9567)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9570
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9568)]
     (clojure.core/case
      (clojure.core/count args9569)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9570
        describeApplications))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9570
        describeApplications
        (elasticbeanstalk/describe-applications-request
         (clojure.core/nth args9569 0))))))))
  (clojure.core/defn
   describe-applications-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener application-names]}]]),
    :doc "Generate map for describeApplications, describeApplications"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-applications,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-applications,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-applications
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener application-names]}]]),
    :doc "Call describeApplications, describeApplications"}
   [credentials9572 & args9573]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9574
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9572)]
    (clojure.core/case
     (clojure.core/count args9573)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9574
       describeApplications))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9574
       describeApplications
       (elasticbeanstalk/describe-applications-request
        (clojure.core/nth args9573 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :check-dnsavailability
   [m9575]
   (clojure.core/let
    [credentials9576 (:credentials m9575) args9577 (:args m9575)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9578
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9576)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9578
       checkDNSAvailability
       (elasticbeanstalk/check-dnsavailability-request
        (clojure.core/nth args9577 0)))))))
  (clojure.core/defn
   check-dnsavailability-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cnameprefix]}]]),
    :doc "Generate map for checkDNSAvailability"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :check-dnsavailability,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   check-dnsavailability
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cnameprefix]}]]),
    :doc "Call checkDNSAvailability"}
   [credentials9580 & args9581]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9582
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9580)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9582
      checkDNSAvailability
      (elasticbeanstalk/check-dnsavailability-request
       (clojure.core/nth args9581 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :restart-app-server
   [m9583]
   (clojure.core/let
    [credentials9584 (:credentials m9583) args9585 (:args m9583)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9586
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9584)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9586
       restartAppServer
       (elasticbeanstalk/restart-app-server-request
        (clojure.core/nth args9585 0)))))))
  (clojure.core/defn
   restart-app-server-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for restartAppServer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :restart-app-server,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   restart-app-server
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Call restartAppServer"}
   [credentials9588 & args9589]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9590
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9588)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9590
      restartAppServer
      (elasticbeanstalk/restart-app-server-request
       (clojure.core/nth args9589 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application-version
   [m9591]
   (clojure.core/let
    [credentials9592 (:credentials m9591) args9593 (:args m9591)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9594
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9592)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9594
       updateApplicationVersion
       (elasticbeanstalk/update-application-version-request
        (clojure.core/nth args9593 0)))))))
  (clojure.core/defn
   update-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [version-label
                         general-progress-listener
                         description
                         application-name]}]]),
    :doc "Generate map for updateApplicationVersion"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-application-version,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-application-version
   {:arglists (quote
               [[credentials
                 {:keys [version-label
                         general-progress-listener
                         description
                         application-name]}]]),
    :doc "Call updateApplicationVersion"}
   [credentials9596 & args9597]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9598
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9596)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9598
      updateApplicationVersion
      (elasticbeanstalk/update-application-version-request
       (clojure.core/nth args9597 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environment-resources
   [m9599]
   (clojure.core/let
    [credentials9600 (:credentials m9599) args9601 (:args m9599)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9602
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9600)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9602
       describeEnvironmentResources
       (elasticbeanstalk/describe-environment-resources-request
        (clojure.core/nth args9601 0)))))))
  (clojure.core/defn
   describe-environment-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for describeEnvironmentResources"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-environment-resources,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-environment-resources
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Call describeEnvironmentResources"}
   [credentials9604 & args9605]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9606
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9604)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9606
      describeEnvironmentResources
      (elasticbeanstalk/describe-environment-resources-request
       (clojure.core/nth args9605 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environments
   [m9607]
   (clojure.core/let
    [credentials9608 (:credentials m9607) args9609 (:args m9607)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9610
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9608)]
     (clojure.core/case
      (clojure.core/count args9609)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9610
        describeEnvironments
        (elasticbeanstalk/describe-environments-request
         (clojure.core/nth args9609 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9610
        describeEnvironments))))))
  (clojure.core/defn
   describe-environments-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         included-deleted-back-to
                         environment-names
                         version-label
                         application-name
                         include-deleted
                         environment-ids]}]
                [credentials]]),
    :doc "Generate map for describeEnvironments, describeEnvironments"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-environments,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-environments,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-environments
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         included-deleted-back-to
                         environment-names
                         version-label
                         application-name
                         include-deleted
                         environment-ids]}]
                [credentials]]),
    :doc "Call describeEnvironments, describeEnvironments"}
   [credentials9612 & args9613]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9614
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9612)]
    (clojure.core/case
     (clojure.core/count args9613)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9614
       describeEnvironments
       (elasticbeanstalk/describe-environments-request
        (clojure.core/nth args9613 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9614
       describeEnvironments))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-application-versions
   [m9615]
   (clojure.core/let
    [credentials9616 (:credentials m9615) args9617 (:args m9615)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9618
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9616)]
     (clojure.core/case
      (clojure.core/count args9617)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9618
        describeApplicationVersions
        (elasticbeanstalk/describe-application-versions-request
         (clojure.core/nth args9617 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9618
        describeApplicationVersions))))))
  (clojure.core/defn
   describe-application-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [version-labels
                         general-progress-listener
                         application-name]}]
                [credentials]]),
    :doc "Generate map for describeApplicationVersions, describeApplicationVersions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-application-versions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-application-versions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-application-versions
   {:arglists (quote
               [[credentials
                 {:keys [version-labels
                         general-progress-listener
                         application-name]}]
                [credentials]]),
    :doc "Call describeApplicationVersions, describeApplicationVersions"}
   [credentials9620 & args9621]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9622
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9620)]
    (clojure.core/case
     (clojure.core/count args9621)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9622
       describeApplicationVersions
       (elasticbeanstalk/describe-application-versions-request
        (clojure.core/nth args9621 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9622
       describeApplicationVersions))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application-version
   [m9623]
   (clojure.core/let
    [credentials9624 (:credentials m9623) args9625 (:args m9623)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9626
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9624)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9626
       deleteApplicationVersion
       (elasticbeanstalk/delete-application-version-request
        (clojure.core/nth args9625 0)))))))
  (clojure.core/defn
   delete-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [version-label
                         general-progress-listener
                         delete-source-bundle
                         application-name]}]]),
    :doc "Generate map for deleteApplicationVersion"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-application-version,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-application-version
   {:arglists (quote
               [[credentials
                 {:keys [version-label
                         general-progress-listener
                         delete-source-bundle
                         application-name]}]]),
    :doc "Call deleteApplicationVersion"}
   [credentials9628 & args9629]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9630
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9628)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9630
      deleteApplicationVersion
      (elasticbeanstalk/delete-application-version-request
       (clojure.core/nth args9629 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :swap-environment-cnames
   [m9631]
   (clojure.core/let
    [credentials9632 (:credentials m9631) args9633 (:args m9631)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9634
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9632)]
     (clojure.core/case
      (clojure.core/count args9633)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9634
        swapEnvironmentCNAMEs))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9634
        swapEnvironmentCNAMEs
        (elasticbeanstalk/swap-environment-cnames-request
         (clojure.core/nth args9633 0))))))))
  (clojure.core/defn
   swap-environment-cnames-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-environment-name
                         source-environment-id
                         general-progress-listener
                         destination-environment-name
                         destination-environment-id]}]]),
    :doc "Generate map for swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :swap-environment-cnames,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :swap-environment-cnames,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   swap-environment-cnames
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-environment-name
                         source-environment-id
                         general-progress-listener
                         destination-environment-name
                         destination-environment-id]}]]),
    :doc "Call swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   [credentials9636 & args9637]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9638
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9636)]
    (clojure.core/case
     (clojure.core/count args9637)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9638
       swapEnvironmentCNAMEs))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9638
       swapEnvironmentCNAMEs
       (elasticbeanstalk/swap-environment-cnames-request
        (clojure.core/nth args9637 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-configuration-template
   [m9639]
   (clojure.core/let
    [credentials9640 (:credentials m9639) args9641 (:args m9639)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9642
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9640)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9642
       deleteConfigurationTemplate
       (elasticbeanstalk/delete-configuration-template-request
        (clojure.core/nth args9641 0)))))))
  (clojure.core/defn
   delete-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         general-progress-listener
                         application-name]}]]),
    :doc "Generate map for deleteConfigurationTemplate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-configuration-template,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         general-progress-listener
                         application-name]}]]),
    :doc "Call deleteConfigurationTemplate"}
   [credentials9644 & args9645]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9646
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9644)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9646
      deleteConfigurationTemplate
      (elasticbeanstalk/delete-configuration-template-request
       (clojure.core/nth args9645 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application
   [m9647]
   (clojure.core/let
    [credentials9648 (:credentials m9647) args9649 (:args m9647)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9650
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9648)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9650
       updateApplication
       (elasticbeanstalk/update-application-request
        (clojure.core/nth args9649 0)))))))
  (clojure.core/defn
   update-application-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         application-name]}]]),
    :doc "Generate map for updateApplication"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-application,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-application
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         application-name]}]]),
    :doc "Call updateApplication"}
   [credentials9652 & args9653]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9654
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9652)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9654
      updateApplication
      (elasticbeanstalk/update-application-request
       (clojure.core/nth args9653 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :list-available-solution-stacks
   [m9655]
   (clojure.core/let
    [credentials9656 (:credentials m9655) args9657 (:args m9655)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9658
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9656)]
     (clojure.core/case
      (clojure.core/count args9657)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9658
        listAvailableSolutionStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9658
        listAvailableSolutionStacks
        (elasticbeanstalk/list-available-solution-stacks-request
         (clojure.core/nth args9657 0))))))))
  (clojure.core/defn
   list-available-solution-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for listAvailableSolutionStacks, listAvailableSolutionStacks"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :list-available-solution-stacks,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :list-available-solution-stacks,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-available-solution-stacks
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call listAvailableSolutionStacks, listAvailableSolutionStacks"}
   [credentials9660 & args9661]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9662
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9660)]
    (clojure.core/case
     (clojure.core/count args9661)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9662
       listAvailableSolutionStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9662
       listAvailableSolutionStacks
       (elasticbeanstalk/list-available-solution-stacks-request
        (clojure.core/nth args9661 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-configuration-template
   [m9663]
   (clojure.core/let
    [credentials9664 (:credentials m9663) args9665 (:args m9663)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9666
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9664)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9666
       updateConfigurationTemplate
       (elasticbeanstalk/update-configuration-template-request
        (clojure.core/nth args9665 0)))))))
  (clojure.core/defn
   update-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         option-settings
                         options-to-remove
                         general-progress-listener
                         application-name
                         template-name]}]]),
    :doc "Generate map for updateConfigurationTemplate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-configuration-template,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [description
                         option-settings
                         options-to-remove
                         general-progress-listener
                         application-name
                         template-name]}]]),
    :doc "Call updateConfigurationTemplate"}
   [credentials9668 & args9669]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9670
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9668)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9670
      updateConfigurationTemplate
      (elasticbeanstalk/update-configuration-template-request
       (clojure.core/nth args9669 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :request-environment-info
   [m9671]
   (clojure.core/let
    [credentials9672 (:credentials m9671) args9673 (:args m9671)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9674
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9672)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9674
       requestEnvironmentInfo
       (elasticbeanstalk/request-environment-info-request
        (clojure.core/nth args9673 0)))))))
  (clojure.core/defn
   request-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [info-type
                         general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for requestEnvironmentInfo"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :request-environment-info,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   request-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [info-type
                         general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Call requestEnvironmentInfo"}
   [credentials9676 & args9677]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9678
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9676)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9678
      requestEnvironmentInfo
      (elasticbeanstalk/request-environment-info-request
       (clojure.core/nth args9677 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-environment-configuration
   [m9679]
   (clojure.core/let
    [credentials9680 (:credentials m9679) args9681 (:args m9679)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9682
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9680)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9682
       deleteEnvironmentConfiguration
       (elasticbeanstalk/delete-environment-configuration-request
        (clojure.core/nth args9681 0)))))))
  (clojure.core/defn
   delete-environment-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         application-name]}]]),
    :doc "Generate map for deleteEnvironmentConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-environment-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-environment-configuration
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         environment-name
                         application-name]}]]),
    :doc "Call deleteEnvironmentConfiguration"}
   [credentials9684 & args9685]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9686
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9684)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9686
      deleteEnvironmentConfiguration
      (elasticbeanstalk/delete-environment-configuration-request
       (clojure.core/nth args9685 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :terminate-environment
   [m9687]
   (clojure.core/let
    [credentials9688 (:credentials m9687) args9689 (:args m9687)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9690
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9688)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9690
       terminateEnvironment
       (elasticbeanstalk/terminate-environment-request
        (clojure.core/nth args9689 0)))))))
  (clojure.core/defn
   terminate-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [terminate-resources
                         general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for terminateEnvironment"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :terminate-environment,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   terminate-environment
   {:arglists (quote
               [[credentials
                 {:keys [terminate-resources
                         general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Call terminateEnvironment"}
   [credentials9692 & args9693]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9694
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9692)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9694
      terminateEnvironment
      (elasticbeanstalk/terminate-environment-request
       (clojure.core/nth args9693 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :retrieve-environment-info
   [m9695]
   (clojure.core/let
    [credentials9696 (:credentials m9695) args9697 (:args m9695)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client9698
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials9696)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9698
       retrieveEnvironmentInfo
       (elasticbeanstalk/retrieve-environment-info-request
        (clojure.core/nth args9697 0)))))))
  (clojure.core/defn
   retrieve-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [info-type
                         general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for retrieveEnvironmentInfo"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :retrieve-environment-info,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   retrieve-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [info-type
                         general-progress-listener
                         environment-name
                         environment-id]}]]),
    :doc "Call retrieveEnvironmentInfo"}
   [credentials9700 & args9701]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client9702
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials9700)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client9702
      retrieveEnvironmentInfo
      (elasticbeanstalk/retrieve-environment-info-request
       (clojure.core/nth args9701 0))))))))
