(ns
 com.palletops.awaze.ec2
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.ec2 :as ec2]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :ec2
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.ec2.AmazonEC2Client
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeType}
volume-type
  [m5982]
  (.
   com.amazonaws.services.ec2.model.VolumeType
   fromValue
   (clojure.core/name m5982)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Tenancy}
tenancy
  [m5985]
  (.
   com.amazonaws.services.ec2.model.Tenancy
   fromValue
   (clojure.core/name m5985)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImageFormat}
disk-image-format
  [m5988]
  (.
   com.amazonaws.services.ec2.model.DiskImageFormat
   fromValue
   (clojure.core/name m5988)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsBlockDevice}
ebs-block-device
  [m5991]
  (clojure.core/let
   [bean5990 (new com.amazonaws.services.ec2.model.EbsBlockDevice)]
   (clojure.core/let
    [v5992
     (:snapshot-id m5991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5992 :com.palletops.awaze.client-builder/undef)
     (. bean5990 setSnapshotId (clojure.core/str v5992))))
   (clojure.core/let
    [v5992
     (:volume-size m5991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5992 :com.palletops.awaze.client-builder/undef)
     (. bean5990 setVolumeSize (clojure.core/int v5992))))
   (clojure.core/let
    [v5992
     (:volume-type m5991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5992 :com.palletops.awaze.client-builder/undef)
     (. bean5990 setVolumeType (ec2/volume-type v5992))))
   (clojure.core/let
    [v5992
     (:delete-on-termination
      m5991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5992 :com.palletops.awaze.client-builder/undef)
     (. bean5990 setDeleteOnTermination (clojure.core/boolean v5992))))
   (clojure.core/let
    [v5992 (:iops m5991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5992 :com.palletops.awaze.client-builder/undef)
     (. bean5990 setIops (clojure.core/int v5992))))
   (clojure.core/let
    [v5992
     (:encrypted m5991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5992 :com.palletops.awaze.client-builder/undef)
     (. bean5990 setEncrypted (clojure.core/boolean v5992))))
   bean5990))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PrivateIpAddressSpecification}
private-ip-address-specification
  [m5994]
  (clojure.core/let
   [bean5993
    (new
     com.amazonaws.services.ec2.model.PrivateIpAddressSpecification)]
   (clojure.core/let
    [v5995
     (:private-ip-address
      m5994
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5995 :com.palletops.awaze.client-builder/undef)
     (. bean5993 setPrivateIpAddress (clojure.core/str v5995))))
   (clojure.core/let
    [v5995 (:primary m5994 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5995 :com.palletops.awaze.client-builder/undef)
     (. bean5993 setPrimary (clojure.core/boolean v5995))))
   bean5993))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserIdGroupPair}
user-id-group-pair
  [m5997]
  (clojure.core/let
   [bean5996 (new com.amazonaws.services.ec2.model.UserIdGroupPair)]
   (clojure.core/let
    [v5998
     (:group-name m5997 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5998 :com.palletops.awaze.client-builder/undef)
     (. bean5996 setGroupName (clojure.core/str v5998))))
   (clojure.core/let
    [v5998
     (:group-id m5997 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5998 :com.palletops.awaze.client-builder/undef)
     (. bean5996 setGroupId (clojure.core/str v5998))))
   (clojure.core/let
    [v5998 (:user-id m5997 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5998 :com.palletops.awaze.client-builder/undef)
     (. bean5996 setUserId (clojure.core/str v5998))))
   bean5996))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CurrencyCodeValues}
currency-code-values
  [m6000]
  (.
   com.amazonaws.services.ec2.model.CurrencyCodeValues
   fromValue
   (clojure.core/name m6000)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermission}
launch-permission
  [m6003]
  (clojure.core/let
   [bean6002 (new com.amazonaws.services.ec2.model.LaunchPermission)]
   (clojure.core/let
    [v6004 (:group m6003 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6004 :com.palletops.awaze.client-builder/undef)
     (. bean6002 setGroup (clojure.core/str v6004))))
   (clojure.core/let
    [v6004 (:user-id m6003 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6004 :com.palletops.awaze.client-builder/undef)
     (. bean6002 setUserId (clojure.core/str v6004))))
   bean6002))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermission}
create-volume-permission
  [m6006]
  (clojure.core/let
   [bean6005
    (new com.amazonaws.services.ec2.model.CreateVolumePermission)]
   (clojure.core/let
    [v6007 (:group m6006 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6007 :com.palletops.awaze.client-builder/undef)
     (. bean6005 setGroup (clojure.core/str v6007))))
   (clojure.core/let
    [v6007 (:user-id m6006 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6007 :com.palletops.awaze.client-builder/undef)
     (. bean6005 setUserId (clojure.core/str v6007))))
   bean6005))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Placement}
placement
  [m6009]
  (clojure.core/let
   [bean6008 (new com.amazonaws.services.ec2.model.Placement)]
   (clojure.core/let
    [v6010 (:tenancy m6009 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6010 :com.palletops.awaze.client-builder/undef)
     (. bean6008 setTenancy (ec2/tenancy v6010))))
   (clojure.core/let
    [v6010
     (:availability-zone
      m6009
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6010 :com.palletops.awaze.client-builder/undef)
     (. bean6008 setAvailabilityZone (clojure.core/str v6010))))
   (clojure.core/let
    [v6010
     (:group-name m6009 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6010 :com.palletops.awaze.client-builder/undef)
     (. bean6008 setGroupName (clojure.core/str v6010))))
   bean6008))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ArchitectureValues}
architecture-values
  [m6012]
  (.
   com.amazonaws.services.ec2.model.ArchitectureValues
   fromValue
   (clojure.core/name m6012)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImageDetail}
disk-image-detail
  [m6015]
  (clojure.core/let
   [bean6014 (new com.amazonaws.services.ec2.model.DiskImageDetail)]
   (clojure.core/let
    [v6016 (:bytes m6015 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6016 :com.palletops.awaze.client-builder/undef)
     (. bean6014 setBytes (clojure.core/long v6016))))
   (clojure.core/let
    [v6016
     (:import-manifest-url
      m6015
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6016 :com.palletops.awaze.client-builder/undef)
     (. bean6014 setImportManifestUrl (clojure.core/str v6016))))
   (clojure.core/let
    [v6016 (:format m6015 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6016 :com.palletops.awaze.client-builder/undef)
     (. bean6014 setFormat (ec2/disk-image-format v6016))))
   bean6014))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeDetail}
volume-detail
  [m6018]
  (clojure.core/let
   [bean6017 (new com.amazonaws.services.ec2.model.VolumeDetail)]
   (clojure.core/let
    [v6019 (:size m6018 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6019 :com.palletops.awaze.client-builder/undef)
     (. bean6017 setSize (clojure.core/long v6019))))
   bean6017))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification}
ebs-instance-block-device-specification
  [m6021]
  (clojure.core/let
   [bean6020
    (new
     com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification)]
   (clojure.core/let
    [v6022
     (:delete-on-termination
      m6021
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6022 :com.palletops.awaze.client-builder/undef)
     (. bean6020 setDeleteOnTermination (clojure.core/boolean v6022))))
   (clojure.core/let
    [v6022
     (:volume-id m6021 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6022 :com.palletops.awaze.client-builder/undef)
     (. bean6020 setVolumeId (clojure.core/str v6022))))
   bean6020))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.S3Storage}
s3storage
  [m6024]
  (clojure.core/let
   [bean6023 (new com.amazonaws.services.ec2.model.S3Storage)]
   (clojure.core/let
    [v6025 (:bucket m6024 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6025 :com.palletops.awaze.client-builder/undef)
     (. bean6023 setBucket (clojure.core/str v6025))))
   (clojure.core/let
    [v6025 (:prefix m6024 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6025 :com.palletops.awaze.client-builder/undef)
     (. bean6023 setPrefix (clojure.core/str v6025))))
   (clojure.core/let
    [v6025
     (:awsaccess-key-id
      m6024
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6025 :com.palletops.awaze.client-builder/undef)
     (. bean6023 setAWSAccessKeyId (clojure.core/str v6025))))
   (clojure.core/let
    [v6025
     (:upload-policy m6024 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6025 :com.palletops.awaze.client-builder/undef)
     (. bean6023 setUploadPolicy (clojure.core/str v6025))))
   (clojure.core/let
    [v6025
     (:upload-policy-signature
      m6024
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6025 :com.palletops.awaze.client-builder/undef)
     (. bean6023 setUploadPolicySignature (clojure.core/str v6025))))
   bean6023))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IamInstanceProfileSpecification}
iam-instance-profile-specification
  [m6027]
  (clojure.core/let
   [bean6026
    (new
     com.amazonaws.services.ec2.model.IamInstanceProfileSpecification)]
   (clojure.core/let
    [v6028 (:name m6027 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6028 :com.palletops.awaze.client-builder/undef)
     (. bean6026 setName (clojure.core/str v6028))))
   (clojure.core/let
    [v6028 (:arn m6027 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6028 :com.palletops.awaze.client-builder/undef)
     (. bean6026 setArn (clojure.core/str v6028))))
   bean6026))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotPlacement}
spot-placement
  [m6030]
  (clojure.core/let
   [bean6029 (new com.amazonaws.services.ec2.model.SpotPlacement)]
   (clojure.core/let
    [v6031
     (:availability-zone
      m6030
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6031 :com.palletops.awaze.client-builder/undef)
     (. bean6029 setAvailabilityZone (clojure.core/str v6031))))
   (clojure.core/let
    [v6031
     (:group-name m6030 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6031 :com.palletops.awaze.client-builder/undef)
     (. bean6029 setGroupName (clojure.core/str v6031))))
   bean6029))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BlockDeviceMapping}
block-device-mapping
  [m6033]
  (clojure.core/let
   [bean6032
    (new com.amazonaws.services.ec2.model.BlockDeviceMapping)]
   (clojure.core/let
    [v6034 (:ebs m6033 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6034 :com.palletops.awaze.client-builder/undef)
     (. bean6032 setEbs (ec2/ebs-block-device v6034))))
   (clojure.core/let
    [v6034
     (:virtual-name m6033 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6034 :com.palletops.awaze.client-builder/undef)
     (. bean6032 setVirtualName (clojure.core/str v6034))))
   (clojure.core/let
    [v6034
     (:device-name m6033 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6034 :com.palletops.awaze.client-builder/undef)
     (. bean6032 setDeviceName (clojure.core/str v6034))))
   (clojure.core/let
    [v6034
     (:no-device m6033 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6034 :com.palletops.awaze.client-builder/undef)
     (. bean6032 setNoDevice (clojure.core/str v6034))))
   bean6032))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification}
instance-network-interface-specification
  [m6036]
  (clojure.core/let
   [bean6035
    (new
     com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification)]
   (clojure.core/let
    [v6037
     (:network-interface-id
      m6036
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6037 :com.palletops.awaze.client-builder/undef)
     (. bean6035 setNetworkInterfaceId (clojure.core/str v6037))))
   (clojure.core/let
    [v6037
     (:associate-public-ip-address
      m6036
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6037 :com.palletops.awaze.client-builder/undef)
     (.
      bean6035
      setAssociatePublicIpAddress
      (clojure.core/boolean v6037))))
   (clojure.core/let
    [v6037
     (:private-ip-address
      m6036
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6037 :com.palletops.awaze.client-builder/undef)
     (. bean6035 setPrivateIpAddress (clojure.core/str v6037))))
   (clojure.core/let
    [v6037
     (:secondary-private-ip-address-count
      m6036
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6037 :com.palletops.awaze.client-builder/undef)
     (.
      bean6035
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v6037))))
   (clojure.core/let
    [v6037 (:groups m6036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6037 :com.palletops.awaze.client-builder/undef)
     (.
      bean6035
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6572] (clojure.core/str arg6572))
 v6037))))
   (clojure.core/let
    [v6037
     (:delete-on-termination
      m6036
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6037 :com.palletops.awaze.client-builder/undef)
     (. bean6035 setDeleteOnTermination (clojure.core/boolean v6037))))
   (clojure.core/let
    [v6037
     (:private-ip-addresses
      m6036
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6037 :com.palletops.awaze.client-builder/undef)
     (.
      bean6035
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6573]
  (ec2/private-ip-address-specification arg6573))
 v6037))))
   (clojure.core/let
    [v6037
     (:description m6036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6037 :com.palletops.awaze.client-builder/undef)
     (. bean6035 setDescription (clojure.core/str v6037))))
   (clojure.core/let
    [v6037
     (:device-index m6036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6037 :com.palletops.awaze.client-builder/undef)
     (. bean6035 setDeviceIndex (clojure.core/int v6037))))
   (clojure.core/let
    [v6037
     (:subnet-id m6036 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6037 :com.palletops.awaze.client-builder/undef)
     (. bean6035 setSubnetId (clojure.core/str v6037))))
   bean6035))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GroupIdentifier}
group-identifier
  [m6039]
  (clojure.core/let
   [bean6038 (new com.amazonaws.services.ec2.model.GroupIdentifier)]
   (clojure.core/let
    [v6040
     (:group-name m6039 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6040 :com.palletops.awaze.client-builder/undef)
     (. bean6038 setGroupName (clojure.core/str v6040))))
   (clojure.core/let
    [v6040
     (:group-id m6039 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6040 :com.palletops.awaze.client-builder/undef)
     (. bean6038 setGroupId (clojure.core/str v6040))))
   bean6038))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Filter}
filter
  [m6042]
  (clojure.core/let
   [bean6041 (new com.amazonaws.services.ec2.model.Filter)]
   (clojure.core/let
    [v6043 (:name m6042 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6043 :com.palletops.awaze.client-builder/undef)
     (. bean6041 setName (clojure.core/str v6043))))
   (clojure.core/let
    [v6043 (:values m6042 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6043 :com.palletops.awaze.client-builder/undef)
     (.
      bean6041
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6574] (clojure.core/str arg6574))
 v6043))))
   bean6041))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IcmpTypeCode}
icmp-type-code
  [m6045]
  (clojure.core/let
   [bean6044 (new com.amazonaws.services.ec2.model.IcmpTypeCode)]
   (clojure.core/let
    [v6046 (:code m6045 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6046 :com.palletops.awaze.client-builder/undef)
     (. bean6044 setCode (clojure.core/int v6046))))
   (clojure.core/let
    [v6046 (:type m6045 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6046 :com.palletops.awaze.client-builder/undef)
     (. bean6044 setType (clojure.core/int v6046))))
   bean6044))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PortRange}
port-range
  [m6048]
  (clojure.core/let
   [bean6047 (new com.amazonaws.services.ec2.model.PortRange)]
   (clojure.core/let
    [v6049 (:to m6048 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6049 :com.palletops.awaze.client-builder/undef)
     (. bean6047 setTo (clojure.core/int v6049))))
   (clojure.core/let
    [v6049 (:from m6048 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6049 :com.palletops.awaze.client-builder/undef)
     (. bean6047 setFrom (clojure.core/int v6049))))
   bean6047))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IpPermission}
ip-permission
  [m6051]
  (clojure.core/let
   [bean6050 (new com.amazonaws.services.ec2.model.IpPermission)]
   (clojure.core/let
    [v6052
     (:user-id-group-pairs
      m6051
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6052 :com.palletops.awaze.client-builder/undef)
     (.
      bean6050
      setUserIdGroupPairs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6575] (ec2/user-id-group-pair arg6575))
 v6052))))
   (clojure.core/let
    [v6052
     (:ip-ranges m6051 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6052 :com.palletops.awaze.client-builder/undef)
     (.
      bean6050
      setIpRanges
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6576] (clojure.core/str arg6576))
 v6052))))
   (clojure.core/let
    [v6052
     (:ip-protocol m6051 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6052 :com.palletops.awaze.client-builder/undef)
     (. bean6050 setIpProtocol (clojure.core/str v6052))))
   (clojure.core/let
    [v6052
     (:from-port m6051 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6052 :com.palletops.awaze.client-builder/undef)
     (. bean6050 setFromPort (clojure.core/int v6052))))
   (clojure.core/let
    [v6052 (:to-port m6051 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6052 :com.palletops.awaze.client-builder/undef)
     (. bean6050 setToPort (clojure.core/int v6052))))
   bean6050))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PriceScheduleSpecification}
price-schedule-specification
  [m6054]
  (clojure.core/let
   [bean6053
    (new com.amazonaws.services.ec2.model.PriceScheduleSpecification)]
   (clojure.core/let
    [v6055 (:price m6054 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6055 :com.palletops.awaze.client-builder/undef)
     (. bean6053 setPrice (clojure.core/double v6055))))
   (clojure.core/let
    [v6055 (:term m6054 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6055 :com.palletops.awaze.client-builder/undef)
     (. bean6053 setTerm (clojure.core/long v6055))))
   (clojure.core/let
    [v6055
     (:currency-code m6054 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6055 :com.palletops.awaze.client-builder/undef)
     (. bean6053 setCurrencyCode (ec2/currency-code-values v6055))))
   bean6053))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermissionModifications}
launch-permission-modifications
  [m6057]
  (clojure.core/let
   [bean6056
    (new
     com.amazonaws.services.ec2.model.LaunchPermissionModifications)]
   (clojure.core/let
    [v6058 (:add m6057 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6058 :com.palletops.awaze.client-builder/undef)
     (.
      bean6056
      setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6577] (ec2/launch-permission arg6577))
 v6058))))
   (clojure.core/let
    [v6058 (:remove m6057 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6058 :com.palletops.awaze.client-builder/undef)
     (.
      bean6056
      setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6578] (ec2/launch-permission arg6578))
 v6058))))
   bean6056))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Tag}
tag
  [m6060]
  (clojure.core/let
   [bean6059 (new com.amazonaws.services.ec2.model.Tag)]
   (clojure.core/let
    [v6061 (:value m6060 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6061 :com.palletops.awaze.client-builder/undef)
     (. bean6059 setValue (clojure.core/str v6061))))
   (clojure.core/let
    [v6061 (:key m6060 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6061 :com.palletops.awaze.client-builder/undef)
     (. bean6059 setKey (clojure.core/str v6061))))
   bean6059))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermissionModifications}
create-volume-permission-modifications
  [m6063]
  (clojure.core/let
   [bean6062
    (new
     com.amazonaws.services.ec2.model.CreateVolumePermissionModifications)]
   (clojure.core/let
    [v6064 (:add m6063 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6064 :com.palletops.awaze.client-builder/undef)
     (.
      bean6062
      setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6579] (ec2/create-volume-permission arg6579))
 v6064))))
   (clojure.core/let
    [v6064 (:remove m6063 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6064 :com.palletops.awaze.client-builder/undef)
     (.
      bean6062
      setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6580] (ec2/create-volume-permission arg6580))
 v6064))))
   bean6062))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstancesConfiguration}
reserved-instances-configuration
  [m6066]
  (clojure.core/let
   [bean6065
    (new
     com.amazonaws.services.ec2.model.ReservedInstancesConfiguration)]
   (clojure.core/let
    [v6067
     (:platform m6066 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6067 :com.palletops.awaze.client-builder/undef)
     (. bean6065 setPlatform (clojure.core/str v6067))))
   (clojure.core/let
    [v6067
     (:instance-count m6066 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6067 :com.palletops.awaze.client-builder/undef)
     (. bean6065 setInstanceCount (clojure.core/int v6067))))
   (clojure.core/let
    [v6067
     (:instance-type m6066 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6067 :com.palletops.awaze.client-builder/undef)
     (. bean6065 setInstanceType (clojure.core/str v6067))))
   (clojure.core/let
    [v6067
     (:availability-zone
      m6066
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6067 :com.palletops.awaze.client-builder/undef)
     (. bean6065 setAvailabilityZone (clojure.core/str v6067))))
   bean6065))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VpcAttributeName}
vpc-attribute-name
  [m6069]
  (.
   com.amazonaws.services.ec2.model.VpcAttributeName
   fromValue
   (clojure.core/name m6069)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.OfferingTypeValues}
offering-type-values
  [m6072]
  (.
   com.amazonaws.services.ec2.model.OfferingTypeValues
   fromValue
   (clojure.core/name m6072)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PlatformValues}
platform-values
  [m6075]
  (.
   com.amazonaws.services.ec2.model.PlatformValues
   fromValue
   (clojure.core/name m6075)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification}
import-instance-launch-specification
  [m6078]
  (clojure.core/let
   [bean6077
    (new
     com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification)]
   (clojure.core/let
    [v6079
     (:placement m6078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6079 :com.palletops.awaze.client-builder/undef)
     (. bean6077 setPlacement (ec2/placement v6079))))
   (clojure.core/let
    [v6079
     (:monitoring m6078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6079 :com.palletops.awaze.client-builder/undef)
     (. bean6077 setMonitoring (clojure.core/boolean v6079))))
   (clojure.core/let
    [v6079
     (:group-names m6078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6079 :com.palletops.awaze.client-builder/undef)
     (.
      bean6077
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6581] (clojure.core/str arg6581))
 v6079))))
   (clojure.core/let
    [v6079
     (:private-ip-address
      m6078
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6079 :com.palletops.awaze.client-builder/undef)
     (. bean6077 setPrivateIpAddress (clojure.core/str v6079))))
   (clojure.core/let
    [v6079
     (:instance-type m6078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6079 :com.palletops.awaze.client-builder/undef)
     (. bean6077 setInstanceType (clojure.core/str v6079))))
   (clojure.core/let
    [v6079
     (:architecture m6078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6079 :com.palletops.awaze.client-builder/undef)
     (. bean6077 setArchitecture (ec2/architecture-values v6079))))
   (clojure.core/let
    [v6079
     (:user-data m6078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6079 :com.palletops.awaze.client-builder/undef)
     (. bean6077 setUserData (clojure.core/str v6079))))
   (clojure.core/let
    [v6079
     (:additional-info
      m6078
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6079 :com.palletops.awaze.client-builder/undef)
     (. bean6077 setAdditionalInfo (clojure.core/str v6079))))
   (clojure.core/let
    [v6079
     (:subnet-id m6078 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6079 :com.palletops.awaze.client-builder/undef)
     (. bean6077 setSubnetId (clojure.core/str v6079))))
   (clojure.core/let
    [v6079
     (:instance-initiated-shutdown-behavior
      m6078
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6079 :com.palletops.awaze.client-builder/undef)
     (.
      bean6077
      setInstanceInitiatedShutdownBehavior
      (clojure.core/str v6079))))
   bean6077))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImage}
disk-image
  [m6081]
  (clojure.core/let
   [bean6080 (new com.amazonaws.services.ec2.model.DiskImage)]
   (clojure.core/let
    [v6082 (:image m6081 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6082 :com.palletops.awaze.client-builder/undef)
     (. bean6080 setImage (ec2/disk-image-detail v6082))))
   (clojure.core/let
    [v6082 (:volume m6081 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6082 :com.palletops.awaze.client-builder/undef)
     (. bean6080 setVolume (ec2/volume-detail v6082))))
   (clojure.core/let
    [v6082
     (:description m6081 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6082 :com.palletops.awaze.client-builder/undef)
     (. bean6080 setDescription (clojure.core/str v6082))))
   bean6080))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges}
network-interface-attachment-changes
  [m6084]
  (clojure.core/let
   [bean6083
    (new
     com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges)]
   (clojure.core/let
    [v6085
     (:delete-on-termination
      m6084
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6085 :com.palletops.awaze.client-builder/undef)
     (. bean6083 setDeleteOnTermination (clojure.core/boolean v6085))))
   (clojure.core/let
    [v6085
     (:attachment-id m6084 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6085 :com.palletops.awaze.client-builder/undef)
     (. bean6083 setAttachmentId (clojure.core/str v6085))))
   bean6083))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeAttributeName}
volume-attribute-name
  [m6087]
  (.
   com.amazonaws.services.ec2.model.VolumeAttributeName
   fromValue
   (clojure.core/name m6087)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification}
instance-block-device-mapping-specification
  [m6090]
  (clojure.core/let
   [bean6089
    (new
     com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification)]
   (clojure.core/let
    [v6091 (:ebs m6090 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6091 :com.palletops.awaze.client-builder/undef)
     (.
      bean6089
      setEbs
      (ec2/ebs-instance-block-device-specification v6091))))
   (clojure.core/let
    [v6091
     (:virtual-name m6090 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6091 :com.palletops.awaze.client-builder/undef)
     (. bean6089 setVirtualName (clojure.core/str v6091))))
   (clojure.core/let
    [v6091
     (:device-name m6090 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6091 :com.palletops.awaze.client-builder/undef)
     (. bean6089 setDeviceName (clojure.core/str v6091))))
   (clojure.core/let
    [v6091
     (:no-device m6090 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6091 :com.palletops.awaze.client-builder/undef)
     (. bean6089 setNoDevice (clojure.core/str v6091))))
   bean6089))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Storage}
storage
  [m6093]
  (clojure.core/let
   [bean6092 (new com.amazonaws.services.ec2.model.Storage)]
   (clojure.core/let
    [v6094 (:s3 m6093 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6094 :com.palletops.awaze.client-builder/undef)
     (. bean6092 setS3 (ec2/s3storage v6094))))
   bean6092))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice}
reserved-instance-limit-price
  [m6096]
  (clojure.core/let
   [bean6095
    (new com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice)]
   (clojure.core/let
    [v6097
     (:currency-code m6096 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6097 :com.palletops.awaze.client-builder/undef)
     (. bean6095 setCurrencyCode (clojure.core/str v6097))))
   (clojure.core/let
    [v6097 (:amount m6096 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6097 :com.palletops.awaze.client-builder/undef)
     (. bean6095 setAmount (clojure.core/double v6097))))
   bean6095))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RIProductDescription}
riproduct-description
  [m6099]
  (.
   com.amazonaws.services.ec2.model.RIProductDescription
   fromValue
   (clojure.core/name m6099)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExportToS3TaskSpecification}
export-to-s3task-specification
  [m6102]
  (clojure.core/let
   [bean6101
    (new com.amazonaws.services.ec2.model.ExportToS3TaskSpecification)]
   (clojure.core/let
    [v6103
     (:disk-image-format
      m6102
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6103 :com.palletops.awaze.client-builder/undef)
     (. bean6101 setDiskImageFormat (clojure.core/str v6103))))
   (clojure.core/let
    [v6103
     (:container-format
      m6102
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6103 :com.palletops.awaze.client-builder/undef)
     (. bean6101 setContainerFormat (clojure.core/str v6103))))
   (clojure.core/let
    [v6103
     (:s3bucket m6102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6103 :com.palletops.awaze.client-builder/undef)
     (. bean6101 setS3Bucket (clojure.core/str v6103))))
   (clojure.core/let
    [v6103
     (:s3prefix m6102 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6103 :com.palletops.awaze.client-builder/undef)
     (. bean6101 setS3Prefix (clojure.core/str v6103))))
   bean6101))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification}
vpn-connection-options-specification
  [m6105]
  (clojure.core/let
   [bean6104
    (new
     com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification)]
   (clojure.core/let
    [v6106
     (:static-routes-only
      m6105
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6106 :com.palletops.awaze.client-builder/undef)
     (. bean6104 setStaticRoutesOnly (clojure.core/boolean v6106))))
   bean6104))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchSpecification}
launch-specification
  [m6108]
  (clojure.core/let
   [bean6107
    (new com.amazonaws.services.ec2.model.LaunchSpecification)]
   (clojure.core/let
    [v6109
     (:iam-instance-profile
      m6108
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (.
      bean6107
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v6109))))
   (clojure.core/let
    [v6109
     (:placement m6108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (. bean6107 setPlacement (ec2/spot-placement v6109))))
   (clojure.core/let
    [v6109
     (:block-device-mappings
      m6108
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (.
      bean6107
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6582] (ec2/block-device-mapping arg6582))
 v6109))))
   (clojure.core/let
    [v6109
     (:network-interfaces
      m6108
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (.
      bean6107
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6583]
  (ec2/instance-network-interface-specification arg6583))
 v6109))))
   (clojure.core/let
    [v6109
     (:key-name m6108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (. bean6107 setKeyName (clojure.core/str v6109))))
   (clojure.core/let
    [v6109
     (:addressing-type
      m6108
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (. bean6107 setAddressingType (clojure.core/str v6109))))
   (clojure.core/let
    [v6109
     (:instance-type m6108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (. bean6107 setInstanceType (clojure.core/str v6109))))
   (clojure.core/let
    [v6109
     (:all-security-groups
      m6108
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (.
      bean6107
      setAllSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6584] (ec2/group-identifier arg6584))
 v6109))))
   (clojure.core/let
    [v6109
     (:ebs-optimized m6108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (. bean6107 setEbsOptimized (clojure.core/boolean v6109))))
   (clojure.core/let
    [v6109
     (:image-id m6108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (. bean6107 setImageId (clojure.core/str v6109))))
   (clojure.core/let
    [v6109
     (:ramdisk-id m6108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (. bean6107 setRamdiskId (clojure.core/str v6109))))
   (clojure.core/let
    [v6109
     (:security-groups
      m6108
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (.
      bean6107
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6585] (clojure.core/str arg6585))
 v6109))))
   (clojure.core/let
    [v6109
     (:user-data m6108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (. bean6107 setUserData (clojure.core/str v6109))))
   (clojure.core/let
    [v6109
     (:monitoring-enabled
      m6108
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (. bean6107 setMonitoringEnabled (clojure.core/boolean v6109))))
   (clojure.core/let
    [v6109
     (:kernel-id m6108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (. bean6107 setKernelId (clojure.core/str v6109))))
   (clojure.core/let
    [v6109
     (:subnet-id m6108 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6109 :com.palletops.awaze.client-builder/undef)
     (. bean6107 setSubnetId (clojure.core/str v6109))))
   bean6107))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DhcpConfiguration}
dhcp-configuration
  [m6111]
  (clojure.core/let
   [bean6110 (new com.amazonaws.services.ec2.model.DhcpConfiguration)]
   (clojure.core/let
    [v6112 (:key m6111 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6112 :com.palletops.awaze.client-builder/undef)
     (. bean6110 setKey (clojure.core/str v6112))))
   (clojure.core/let
    [v6112 (:values m6111 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6112 :com.palletops.awaze.client-builder/undef)
     (.
      bean6110
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6586] (clojure.core/str arg6586))
 v6112))))
   bean6110))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest}
describe-security-groups-request
  [m6114]
  (clojure.core/let
   [bean6113
    (new
     com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest)]
   (clojure.core/let
    [v6115 (:filters m6114 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6115 :com.palletops.awaze.client-builder/undef)
     (.
      bean6113
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6587] (ec2/filter arg6587))
 v6115))))
   (clojure.core/let
    [v6115
     (:group-names m6114 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6115 :com.palletops.awaze.client-builder/undef)
     (.
      bean6113
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6588] (clojure.core/str arg6588))
 v6115))))
   (clojure.core/let
    [v6115
     (:group-ids m6114 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6115 :com.palletops.awaze.client-builder/undef)
     (.
      bean6113
      setGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6589] (clojure.core/str arg6589))
 v6115))))
   bean6113))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcRequest}
create-vpc-request
  [m6117]
  (clojure.core/let
   [bean6116 (new com.amazonaws.services.ec2.model.CreateVpcRequest)]
   (clojure.core/let
    [v6118
     (:cidr-block m6117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6118 :com.palletops.awaze.client-builder/undef)
     (. bean6116 setCidrBlock (clojure.core/str v6118))))
   (clojure.core/let
    [v6118
     (:instance-tenancy
      m6117
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6118 :com.palletops.awaze.client-builder/undef)
     (. bean6116 setInstanceTenancy (ec2/tenancy v6118))))
   bean6116))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeregisterImageRequest}
deregister-image-request
  [m6120]
  (clojure.core/let
   [bean6119
    (new com.amazonaws.services.ec2.model.DeregisterImageRequest)]
   (clojure.core/let
    [v6121
     (:image-id m6120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6121 :com.palletops.awaze.client-builder/undef)
     (. bean6119 setImageId (clojure.core/str v6121))))
   bean6119))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest}
create-network-acl-entry-request
  [m6123]
  (clojure.core/let
   [bean6122
    (new
     com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest)]
   (clojure.core/let
    [v6124
     (:protocol m6123 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6124 :com.palletops.awaze.client-builder/undef)
     (. bean6122 setProtocol (clojure.core/str v6124))))
   (clojure.core/let
    [v6124
     (:network-acl-id m6123 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6124 :com.palletops.awaze.client-builder/undef)
     (. bean6122 setNetworkAclId (clojure.core/str v6124))))
   (clojure.core/let
    [v6124
     (:rule-number m6123 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6124 :com.palletops.awaze.client-builder/undef)
     (. bean6122 setRuleNumber (clojure.core/int v6124))))
   (clojure.core/let
    [v6124
     (:rule-action m6123 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6124 :com.palletops.awaze.client-builder/undef)
     (. bean6122 setRuleAction (clojure.core/str v6124))))
   (clojure.core/let
    [v6124 (:egress m6123 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6124 :com.palletops.awaze.client-builder/undef)
     (. bean6122 setEgress (clojure.core/boolean v6124))))
   (clojure.core/let
    [v6124
     (:cidr-block m6123 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6124 :com.palletops.awaze.client-builder/undef)
     (. bean6122 setCidrBlock (clojure.core/str v6124))))
   (clojure.core/let
    [v6124
     (:icmp-type-code m6123 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6124 :com.palletops.awaze.client-builder/undef)
     (. bean6122 setIcmpTypeCode (ec2/icmp-type-code v6124))))
   (clojure.core/let
    [v6124
     (:port-range m6123 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6124 :com.palletops.awaze.client-builder/undef)
     (. bean6122 setPortRange (ec2/port-range v6124))))
   bean6122))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelExportTaskRequest}
cancel-export-task-request
  [m6126]
  (clojure.core/let
   [bean6125
    (new com.amazonaws.services.ec2.model.CancelExportTaskRequest)]
   (clojure.core/let
    [v6127
     (:export-task-id m6126 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6127 :com.palletops.awaze.client-builder/undef)
     (. bean6125 setExportTaskId (clojure.core/str v6127))))
   bean6125))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest}
revoke-security-group-ingress-request
  [m6129]
  (clojure.core/let
   [bean6128
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest)]
   (clojure.core/let
    [v6130
     (:ip-protocol m6129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6130 :com.palletops.awaze.client-builder/undef)
     (. bean6128 setIpProtocol (clojure.core/str v6130))))
   (clojure.core/let
    [v6130
     (:group-name m6129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6130 :com.palletops.awaze.client-builder/undef)
     (. bean6128 setGroupName (clojure.core/str v6130))))
   (clojure.core/let
    [v6130
     (:source-security-group-owner-id
      m6129
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6130 :com.palletops.awaze.client-builder/undef)
     (.
      bean6128
      setSourceSecurityGroupOwnerId
      (clojure.core/str v6130))))
   (clojure.core/let
    [v6130
     (:source-security-group-name
      m6129
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6130 :com.palletops.awaze.client-builder/undef)
     (. bean6128 setSourceSecurityGroupName (clojure.core/str v6130))))
   (clojure.core/let
    [v6130
     (:from-port m6129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6130 :com.palletops.awaze.client-builder/undef)
     (. bean6128 setFromPort (clojure.core/int v6130))))
   (clojure.core/let
    [v6130
     (:group-id m6129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6130 :com.palletops.awaze.client-builder/undef)
     (. bean6128 setGroupId (clojure.core/str v6130))))
   (clojure.core/let
    [v6130
     (:ip-permissions m6129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6130 :com.palletops.awaze.client-builder/undef)
     (.
      bean6128
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6590] (ec2/ip-permission arg6590))
 v6130))))
   (clojure.core/let
    [v6130 (:cidr-ip m6129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6130 :com.palletops.awaze.client-builder/undef)
     (. bean6128 setCidrIp (clojure.core/str v6130))))
   (clojure.core/let
    [v6130 (:to-port m6129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6130 :com.palletops.awaze.client-builder/undef)
     (. bean6128 setToPort (clojure.core/int v6130))))
   bean6128))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRouteTablesRequest}
describe-route-tables-request
  [m6132]
  (clojure.core/let
   [bean6131
    (new com.amazonaws.services.ec2.model.DescribeRouteTablesRequest)]
   (clojure.core/let
    [v6133 (:filters m6132 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6133 :com.palletops.awaze.client-builder/undef)
     (.
      bean6131
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6591] (ec2/filter arg6591))
 v6133))))
   (clojure.core/let
    [v6133
     (:route-table-ids
      m6132
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6133 :com.palletops.awaze.client-builder/undef)
     (.
      bean6131
      setRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6592] (clojure.core/str arg6592))
 v6133))))
   bean6131))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest}
create-reserved-instances-listing-request
  [m6135]
  (clojure.core/let
   [bean6134
    (new
     com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest)]
   (clojure.core/let
    [v6136
     (:instance-count m6135 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6136 :com.palletops.awaze.client-builder/undef)
     (. bean6134 setInstanceCount (clojure.core/int v6136))))
   (clojure.core/let
    [v6136
     (:reserved-instances-id
      m6135
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6136 :com.palletops.awaze.client-builder/undef)
     (. bean6134 setReservedInstancesId (clojure.core/str v6136))))
   (clojure.core/let
    [v6136
     (:price-schedules
      m6135
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6136 :com.palletops.awaze.client-builder/undef)
     (.
      bean6134
      setPriceSchedules
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6593]
  (ec2/price-schedule-specification arg6593))
 v6136))))
   (clojure.core/let
    [v6136
     (:client-token m6135 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6136 :com.palletops.awaze.client-builder/undef)
     (. bean6134 setClientToken (clojure.core/str v6136))))
   bean6134))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetImageAttributeRequest}
reset-image-attribute-request
  [m6138]
  (clojure.core/let
   [bean6137
    (new com.amazonaws.services.ec2.model.ResetImageAttributeRequest)]
   (clojure.core/let
    [v6139
     (:attribute m6138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6139 :com.palletops.awaze.client-builder/undef)
     (. bean6137 setAttribute (clojure.core/str v6139))))
   (clojure.core/let
    [v6139
     (:image-id m6138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6139 :com.palletops.awaze.client-builder/undef)
     (. bean6137 setImageId (clojure.core/str v6139))))
   bean6137))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest}
describe-availability-zones-request
  [m6141]
  (clojure.core/let
   [bean6140
    (new
     com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest)]
   (clojure.core/let
    [v6142 (:filters m6141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6142 :com.palletops.awaze.client-builder/undef)
     (.
      bean6140
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6594] (ec2/filter arg6594))
 v6142))))
   (clojure.core/let
    [v6142
     (:zone-names m6141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6142 :com.palletops.awaze.client-builder/undef)
     (.
      bean6140
      setZoneNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6595] (clojure.core/str arg6595))
 v6142))))
   bean6140))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest}
describe-network-acls-request
  [m6144]
  (clojure.core/let
   [bean6143
    (new com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest)]
   (clojure.core/let
    [v6145 (:filters m6144 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6145 :com.palletops.awaze.client-builder/undef)
     (.
      bean6143
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6596] (ec2/filter arg6596))
 v6145))))
   (clojure.core/let
    [v6145
     (:network-acl-ids
      m6144
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6145 :com.palletops.awaze.client-builder/undef)
     (.
      bean6143
      setNetworkAclIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6597] (clojure.core/str arg6597))
 v6145))))
   bean6143))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest}
describe-vpn-gateways-request
  [m6147]
  (clojure.core/let
   [bean6146
    (new com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest)]
   (clojure.core/let
    [v6148 (:filters m6147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6148 :com.palletops.awaze.client-builder/undef)
     (.
      bean6146
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6598] (ec2/filter arg6598))
 v6148))))
   (clojure.core/let
    [v6148
     (:vpn-gateway-ids
      m6147
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6148 :com.palletops.awaze.client-builder/undef)
     (.
      bean6146
      setVpnGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6599] (clojure.core/str arg6599))
 v6148))))
   bean6146))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m6150]
  (clojure.core/let
   [bean6149
    (new com.amazonaws.services.ec2.model.DescribeSnapshotsRequest)]
   (clojure.core/let
    [v6151 (:filters m6150 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6151 :com.palletops.awaze.client-builder/undef)
     (.
      bean6149
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6600] (ec2/filter arg6600))
 v6151))))
   (clojure.core/let
    [v6151
     (:snapshot-ids m6150 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6151 :com.palletops.awaze.client-builder/undef)
     (.
      bean6149
      setSnapshotIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6601] (clojure.core/str arg6601))
 v6151))))
   (clojure.core/let
    [v6151
     (:owner-ids m6150 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6151 :com.palletops.awaze.client-builder/undef)
     (.
      bean6149
      setOwnerIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6602] (clojure.core/str arg6602))
 v6151))))
   (clojure.core/let
    [v6151
     (:restorable-by-user-ids
      m6150
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6151 :com.palletops.awaze.client-builder/undef)
     (.
      bean6149
      setRestorableByUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6603] (clojure.core/str arg6603))
 v6151))))
   bean6149))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyImageAttributeRequest}
modify-image-attribute-request
  [m6153]
  (clojure.core/let
   [bean6152
    (new com.amazonaws.services.ec2.model.ModifyImageAttributeRequest)]
   (clojure.core/let
    [v6154
     (:user-groups m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (.
      bean6152
      setUserGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6604] (clojure.core/str arg6604))
 v6154))))
   (clojure.core/let
    [v6154
     (:launch-permission
      m6153
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (.
      bean6152
      setLaunchPermission
      (ec2/launch-permission-modifications v6154))))
   (clojure.core/let
    [v6154
     (:user-ids m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (.
      bean6152
      setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6605] (clojure.core/str arg6605))
 v6154))))
   (clojure.core/let
    [v6154 (:value m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (. bean6152 setValue (clojure.core/str v6154))))
   (clojure.core/let
    [v6154
     (:image-id m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (. bean6152 setImageId (clojure.core/str v6154))))
   (clojure.core/let
    [v6154
     (:product-codes m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (.
      bean6152
      setProductCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6606] (clojure.core/str arg6606))
 v6154))))
   (clojure.core/let
    [v6154
     (:attribute m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (. bean6152 setAttribute (clojure.core/str v6154))))
   (clojure.core/let
    [v6154
     (:description m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (. bean6152 setDescription (clojure.core/str v6154))))
   (clojure.core/let
    [v6154
     (:operation-type m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (. bean6152 setOperationType (clojure.core/str v6154))))
   bean6152))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumesRequest}
describe-volumes-request
  [m6156]
  (clojure.core/let
   [bean6155
    (new com.amazonaws.services.ec2.model.DescribeVolumesRequest)]
   (clojure.core/let
    [v6157 (:filters m6156 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6157 :com.palletops.awaze.client-builder/undef)
     (.
      bean6155
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6607] (ec2/filter arg6607))
 v6157))))
   (clojure.core/let
    [v6157
     (:volume-ids m6156 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6157 :com.palletops.awaze.client-builder/undef)
     (.
      bean6155
      setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6608] (clojure.core/str arg6608))
 v6157))))
   bean6155))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachInternetGatewayRequest}
attach-internet-gateway-request
  [m6159]
  (clojure.core/let
   [bean6158
    (new
     com.amazonaws.services.ec2.model.AttachInternetGatewayRequest)]
   (clojure.core/let
    [v6160
     (:internet-gateway-id
      m6159
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6160 :com.palletops.awaze.client-builder/undef)
     (. bean6158 setInternetGatewayId (clojure.core/str v6160))))
   (clojure.core/let
    [v6160 (:vpc-id m6159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6160 :com.palletops.awaze.client-builder/undef)
     (. bean6158 setVpcId (clojure.core/str v6160))))
   bean6158))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest}
delete-security-group-request
  [m6162]
  (clojure.core/let
   [bean6161
    (new com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest)]
   (clojure.core/let
    [v6163
     (:group-name m6162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6163 :com.palletops.awaze.client-builder/undef)
     (. bean6161 setGroupName (clojure.core/str v6163))))
   (clojure.core/let
    [v6163
     (:group-id m6162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6163 :com.palletops.awaze.client-builder/undef)
     (. bean6161 setGroupId (clojure.core/str v6163))))
   bean6161))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVolumeRequest}
detach-volume-request
  [m6165]
  (clojure.core/let
   [bean6164
    (new com.amazonaws.services.ec2.model.DetachVolumeRequest)]
   (clojure.core/let
    [v6166
     (:instance-id m6165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6166 :com.palletops.awaze.client-builder/undef)
     (. bean6164 setInstanceId (clojure.core/str v6166))))
   (clojure.core/let
    [v6166 (:force m6165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6166 :com.palletops.awaze.client-builder/undef)
     (. bean6164 setForce (clojure.core/boolean v6166))))
   (clojure.core/let
    [v6166
     (:volume-id m6165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6166 :com.palletops.awaze.client-builder/undef)
     (. bean6164 setVolumeId (clojure.core/str v6166))))
   (clojure.core/let
    [v6166 (:device m6165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6166 :com.palletops.awaze.client-builder/undef)
     (. bean6164 setDevice (clojure.core/str v6166))))
   bean6164))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReleaseAddressRequest}
release-address-request
  [m6168]
  (clojure.core/let
   [bean6167
    (new com.amazonaws.services.ec2.model.ReleaseAddressRequest)]
   (clojure.core/let
    [v6169
     (:public-ip m6168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6169 :com.palletops.awaze.client-builder/undef)
     (. bean6167 setPublicIp (clojure.core/str v6169))))
   (clojure.core/let
    [v6169
     (:allocation-id m6168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6169 :com.palletops.awaze.client-builder/undef)
     (. bean6167 setAllocationId (clojure.core/str v6169))))
   bean6167))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportVolumeRequest}
import-volume-request
  [m6171]
  (clojure.core/let
   [bean6170
    (new com.amazonaws.services.ec2.model.ImportVolumeRequest)]
   (clojure.core/let
    [v6172 (:image m6171 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6172 :com.palletops.awaze.client-builder/undef)
     (. bean6170 setImage (ec2/disk-image-detail v6172))))
   (clojure.core/let
    [v6172 (:volume m6171 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6172 :com.palletops.awaze.client-builder/undef)
     (. bean6170 setVolume (ec2/volume-detail v6172))))
   (clojure.core/let
    [v6172
     (:description m6171 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6172 :com.palletops.awaze.client-builder/undef)
     (. bean6170 setDescription (clojure.core/str v6172))))
   (clojure.core/let
    [v6172
     (:availability-zone
      m6171
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6172 :com.palletops.awaze.client-builder/undef)
     (. bean6170 setAvailabilityZone (clojure.core/str v6172))))
   bean6170))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteTableRequest}
delete-route-table-request
  [m6174]
  (clojure.core/let
   [bean6173
    (new com.amazonaws.services.ec2.model.DeleteRouteTableRequest)]
   (clojure.core/let
    [v6175
     (:route-table-id m6174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6175 :com.palletops.awaze.client-builder/undef)
     (. bean6173 setRouteTableId (clojure.core/str v6175))))
   bean6173))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest}
describe-snapshot-attribute-request
  [m6177]
  (clojure.core/let
   [bean6176
    (new
     com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest)]
   (clojure.core/let
    [v6178
     (:snapshot-id m6177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6178 :com.palletops.awaze.client-builder/undef)
     (. bean6176 setSnapshotId (clojure.core/str v6178))))
   (clojure.core/let
    [v6178
     (:attribute m6177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6178 :com.palletops.awaze.client-builder/undef)
     (. bean6176 setAttribute (clojure.core/str v6178))))
   bean6176))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest}
describe-instance-status-request
  [m6180]
  (clojure.core/let
   [bean6179
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest)]
   (clojure.core/let
    [v6181
     (:instance-ids m6180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6181 :com.palletops.awaze.client-builder/undef)
     (.
      bean6179
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6609] (clojure.core/str arg6609))
 v6181))))
   (clojure.core/let
    [v6181 (:filters m6180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6181 :com.palletops.awaze.client-builder/undef)
     (.
      bean6179
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6610] (ec2/filter arg6610))
 v6181))))
   (clojure.core/let
    [v6181
     (:next-token m6180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6181 :com.palletops.awaze.client-builder/undef)
     (. bean6179 setNextToken (clojure.core/str v6181))))
   (clojure.core/let
    [v6181
     (:include-all-instances
      m6180
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6181 :com.palletops.awaze.client-builder/undef)
     (. bean6179 setIncludeAllInstances (clojure.core/boolean v6181))))
   (clojure.core/let
    [v6181
     (:max-results m6180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6181 :com.palletops.awaze.client-builder/undef)
     (. bean6179 setMaxResults (clojure.core/int v6181))))
   bean6179))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImageAttributeRequest}
describe-image-attribute-request
  [m6183]
  (clojure.core/let
   [bean6182
    (new
     com.amazonaws.services.ec2.model.DescribeImageAttributeRequest)]
   (clojure.core/let
    [v6184
     (:attribute m6183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6184 :com.palletops.awaze.client-builder/undef)
     (. bean6182 setAttribute (clojure.core/str v6184))))
   (clojure.core/let
    [v6184
     (:image-id m6183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6184 :com.palletops.awaze.client-builder/undef)
     (. bean6182 setImageId (clojure.core/str v6184))))
   bean6182))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReportInstanceStatusRequest}
report-instance-status-request
  [m6186]
  (clojure.core/let
   [bean6185
    (new com.amazonaws.services.ec2.model.ReportInstanceStatusRequest)]
   (clojure.core/let
    [v6187 (:status m6186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6187 :com.palletops.awaze.client-builder/undef)
     (. bean6185 setStatus (clojure.core/str v6187))))
   (clojure.core/let
    [v6187
     (:instances m6186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6187 :com.palletops.awaze.client-builder/undef)
     (.
      bean6185
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6611] (clojure.core/str arg6611))
 v6187))))
   (clojure.core/let
    [v6187
     (:reason-codes m6186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6187 :com.palletops.awaze.client-builder/undef)
     (.
      bean6185
      setReasonCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6612] (clojure.core/str arg6612))
 v6187))))
   (clojure.core/let
    [v6187
     (:description m6186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6187 :com.palletops.awaze.client-builder/undef)
     (. bean6185 setDescription (clojure.core/str v6187))))
   (clojure.core/let
    [v6187
     (:start-time m6186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6187 :com.palletops.awaze.client-builder/undef)
     (.
      bean6185
      setStartTime
      (com.palletops.awaze.common/to-date v6187))))
   (clojure.core/let
    [v6187
     (:end-time m6186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6187 :com.palletops.awaze.client-builder/undef)
     (.
      bean6185
      setEndTime
      (com.palletops.awaze.common/to-date v6187))))
   bean6185))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteTagsRequest}
delete-tags-request
  [m6189]
  (clojure.core/let
   [bean6188 (new com.amazonaws.services.ec2.model.DeleteTagsRequest)]
   (clojure.core/let
    [v6190 (:tags m6189 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6190 :com.palletops.awaze.client-builder/undef)
     (.
      bean6188
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg6613] (ec2/tag arg6613)) v6190))))
   (clojure.core/let
    [v6190
     (:resources m6189 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6190 :com.palletops.awaze.client-builder/undef)
     (.
      bean6188
      setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6614] (clojure.core/str arg6614))
 v6190))))
   bean6188))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest}
reset-snapshot-attribute-request
  [m6192]
  (clojure.core/let
   [bean6191
    (new
     com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest)]
   (clojure.core/let
    [v6193
     (:snapshot-id m6192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6193 :com.palletops.awaze.client-builder/undef)
     (. bean6191 setSnapshotId (clojure.core/str v6193))))
   (clojure.core/let
    [v6193
     (:attribute m6192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6193 :com.palletops.awaze.client-builder/undef)
     (. bean6191 setAttribute (clojure.core/str v6193))))
   bean6191))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest}
associate-dhcp-options-request
  [m6195]
  (clojure.core/let
   [bean6194
    (new com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest)]
   (clojure.core/let
    [v6196 (:vpc-id m6195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6196 :com.palletops.awaze.client-builder/undef)
     (. bean6194 setVpcId (clojure.core/str v6196))))
   (clojure.core/let
    [v6196
     (:dhcp-options-id
      m6195
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6196 :com.palletops.awaze.client-builder/undef)
     (. bean6194 setDhcpOptionsId (clojure.core/str v6196))))
   bean6194))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest}
modify-snapshot-attribute-request
  [m6198]
  (clojure.core/let
   [bean6197
    (new
     com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest)]
   (clojure.core/let
    [v6199
     (:snapshot-id m6198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6199 :com.palletops.awaze.client-builder/undef)
     (. bean6197 setSnapshotId (clojure.core/str v6199))))
   (clojure.core/let
    [v6199
     (:group-names m6198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6199 :com.palletops.awaze.client-builder/undef)
     (.
      bean6197
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6615] (clojure.core/str arg6615))
 v6199))))
   (clojure.core/let
    [v6199
     (:operation-type m6198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6199 :com.palletops.awaze.client-builder/undef)
     (. bean6197 setOperationType (clojure.core/str v6199))))
   (clojure.core/let
    [v6199
     (:user-ids m6198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6199 :com.palletops.awaze.client-builder/undef)
     (.
      bean6197
      setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6616] (clojure.core/str arg6616))
 v6199))))
   (clojure.core/let
    [v6199
     (:create-volume-permission
      m6198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6199 :com.palletops.awaze.client-builder/undef)
     (.
      bean6197
      setCreateVolumePermission
      (ec2/create-volume-permission-modifications v6199))))
   (clojure.core/let
    [v6199
     (:attribute m6198 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6199 :com.palletops.awaze.client-builder/undef)
     (. bean6197 setAttribute (clojure.core/str v6199))))
   bean6197))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest}
modify-volume-attribute-request
  [m6201]
  (clojure.core/let
   [bean6200
    (new
     com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest)]
   (clojure.core/let
    [v6202
     (:auto-enable-io m6201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6202 :com.palletops.awaze.client-builder/undef)
     (. bean6200 setAutoEnableIO (clojure.core/boolean v6202))))
   (clojure.core/let
    [v6202
     (:volume-id m6201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6202 :com.palletops.awaze.client-builder/undef)
     (. bean6200 setVolumeId (clojure.core/str v6202))))
   bean6200))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreatePlacementGroupRequest}
create-placement-group-request
  [m6204]
  (clojure.core/let
   [bean6203
    (new com.amazonaws.services.ec2.model.CreatePlacementGroupRequest)]
   (clojure.core/let
    [v6205
     (:strategy m6204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6205 :com.palletops.awaze.client-builder/undef)
     (. bean6203 setStrategy (clojure.core/str v6205))))
   (clojure.core/let
    [v6205
     (:group-name m6204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6205 :com.palletops.awaze.client-builder/undef)
     (. bean6203 setGroupName (clojure.core/str v6205))))
   bean6203))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest}
describe-vpn-connections-request
  [m6207]
  (clojure.core/let
   [bean6206
    (new
     com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest)]
   (clojure.core/let
    [v6208 (:filters m6207 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6208 :com.palletops.awaze.client-builder/undef)
     (.
      bean6206
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6617] (ec2/filter arg6617))
 v6208))))
   (clojure.core/let
    [v6208
     (:vpn-connection-ids
      m6207
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6208 :com.palletops.awaze.client-builder/undef)
     (.
      bean6206
      setVpnConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6618] (clojure.core/str arg6618))
 v6208))))
   bean6206))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest}
describe-spot-price-history-request
  [m6210]
  (clojure.core/let
   [bean6209
    (new
     com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest)]
   (clojure.core/let
    [v6211 (:filters m6210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6211 :com.palletops.awaze.client-builder/undef)
     (.
      bean6209
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6619] (ec2/filter arg6619))
 v6211))))
   (clojure.core/let
    [v6211
     (:next-token m6210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6211 :com.palletops.awaze.client-builder/undef)
     (. bean6209 setNextToken (clojure.core/str v6211))))
   (clojure.core/let
    [v6211
     (:instance-types m6210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6211 :com.palletops.awaze.client-builder/undef)
     (.
      bean6209
      setInstanceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6620] (clojure.core/str arg6620))
 v6211))))
   (clojure.core/let
    [v6211
     (:product-descriptions
      m6210
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6211 :com.palletops.awaze.client-builder/undef)
     (.
      bean6209
      setProductDescriptions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6621] (clojure.core/str arg6621))
 v6211))))
   (clojure.core/let
    [v6211
     (:availability-zone
      m6210
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6211 :com.palletops.awaze.client-builder/undef)
     (. bean6209 setAvailabilityZone (clojure.core/str v6211))))
   (clojure.core/let
    [v6211
     (:start-time m6210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6211 :com.palletops.awaze.client-builder/undef)
     (.
      bean6209
      setStartTime
      (com.palletops.awaze.common/to-date v6211))))
   (clojure.core/let
    [v6211
     (:end-time m6210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6211 :com.palletops.awaze.client-builder/undef)
     (.
      bean6209
      setEndTime
      (com.palletops.awaze.common/to-date v6211))))
   (clojure.core/let
    [v6211
     (:max-results m6210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6211 :com.palletops.awaze.client-builder/undef)
     (. bean6209 setMaxResults (clojure.core/int v6211))))
   bean6209))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest}
reject-vpc-peering-connection-request
  [m6213]
  (clojure.core/let
   [bean6212
    (new
     com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v6214
     (:vpc-peering-connection-id
      m6213
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6214 :com.palletops.awaze.client-builder/undef)
     (. bean6212 setVpcPeeringConnectionId (clojure.core/str v6214))))
   bean6212))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcRequest}
delete-vpc-request
  [m6216]
  (clojure.core/let
   [bean6215 (new com.amazonaws.services.ec2.model.DeleteVpcRequest)]
   (clojure.core/let
    [v6217 (:vpc-id m6216 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6217 :com.palletops.awaze.client-builder/undef)
     (. bean6215 setVpcId (clojure.core/str v6217))))
   bean6215))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteTableRequest}
create-route-table-request
  [m6219]
  (clojure.core/let
   [bean6218
    (new com.amazonaws.services.ec2.model.CreateRouteTableRequest)]
   (clojure.core/let
    [v6220 (:vpc-id m6219 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6220 :com.palletops.awaze.client-builder/undef)
     (. bean6218 setVpcId (clojure.core/str v6220))))
   bean6218))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.TerminateInstancesRequest}
terminate-instances-request
  [m6222]
  (clojure.core/let
   [bean6221
    (new com.amazonaws.services.ec2.model.TerminateInstancesRequest)]
   (clojure.core/let
    [v6223
     (:instance-ids m6222 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6223 :com.palletops.awaze.client-builder/undef)
     (.
      bean6221
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6622] (clojure.core/str arg6622))
 v6223))))
   bean6221))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeBundleTasksRequest}
describe-bundle-tasks-request
  [m6225]
  (clojure.core/let
   [bean6224
    (new com.amazonaws.services.ec2.model.DescribeBundleTasksRequest)]
   (clojure.core/let
    [v6226 (:filters m6225 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6226 :com.palletops.awaze.client-builder/undef)
     (.
      bean6224
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6623] (ec2/filter arg6623))
 v6226))))
   (clojure.core/let
    [v6226
     (:bundle-ids m6225 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6226 :com.palletops.awaze.client-builder/undef)
     (.
      bean6224
      setBundleIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6624] (clojure.core/str arg6624))
 v6226))))
   bean6224))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateAddressRequest}
associate-address-request
  [m6228]
  (clojure.core/let
   [bean6227
    (new com.amazonaws.services.ec2.model.AssociateAddressRequest)]
   (clojure.core/let
    [v6229
     (:instance-id m6228 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6229 :com.palletops.awaze.client-builder/undef)
     (. bean6227 setInstanceId (clojure.core/str v6229))))
   (clojure.core/let
    [v6229
     (:private-ip-address
      m6228
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6229 :com.palletops.awaze.client-builder/undef)
     (. bean6227 setPrivateIpAddress (clojure.core/str v6229))))
   (clojure.core/let
    [v6229
     (:public-ip m6228 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6229 :com.palletops.awaze.client-builder/undef)
     (. bean6227 setPublicIp (clojure.core/str v6229))))
   (clojure.core/let
    [v6229
     (:allocation-id m6228 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6229 :com.palletops.awaze.client-builder/undef)
     (. bean6227 setAllocationId (clojure.core/str v6229))))
   (clojure.core/let
    [v6229
     (:allow-reassociation
      m6228
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6229 :com.palletops.awaze.client-builder/undef)
     (. bean6227 setAllowReassociation (clojure.core/boolean v6229))))
   (clojure.core/let
    [v6229
     (:network-interface-id
      m6228
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6229 :com.palletops.awaze.client-builder/undef)
     (. bean6227 setNetworkInterfaceId (clojure.core/str v6229))))
   bean6227))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumeRequest}
create-volume-request
  [m6231]
  (clojure.core/let
   [bean6230
    (new com.amazonaws.services.ec2.model.CreateVolumeRequest)]
   (clojure.core/let
    [v6232 (:size m6231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6232 :com.palletops.awaze.client-builder/undef)
     (. bean6230 setSize (clojure.core/int v6232))))
   (clojure.core/let
    [v6232
     (:snapshot-id m6231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6232 :com.palletops.awaze.client-builder/undef)
     (. bean6230 setSnapshotId (clojure.core/str v6232))))
   (clojure.core/let
    [v6232
     (:volume-type m6231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6232 :com.palletops.awaze.client-builder/undef)
     (. bean6230 setVolumeType (ec2/volume-type v6232))))
   (clojure.core/let
    [v6232 (:iops m6231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6232 :com.palletops.awaze.client-builder/undef)
     (. bean6230 setIops (clojure.core/int v6232))))
   (clojure.core/let
    [v6232
     (:availability-zone
      m6231
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6232 :com.palletops.awaze.client-builder/undef)
     (. bean6230 setAvailabilityZone (clojure.core/str v6232))))
   (clojure.core/let
    [v6232
     (:encrypted m6231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6232 :com.palletops.awaze.client-builder/undef)
     (. bean6230 setEncrypted (clojure.core/boolean v6232))))
   bean6230))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest}
modify-reserved-instances-request
  [m6234]
  (clojure.core/let
   [bean6233
    (new
     com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest)]
   (clojure.core/let
    [v6235
     (:target-configurations
      m6234
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6235 :com.palletops.awaze.client-builder/undef)
     (.
      bean6233
      setTargetConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6625]
  (ec2/reserved-instances-configuration arg6625))
 v6235))))
   (clojure.core/let
    [v6235
     (:client-token m6234 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6235 :com.palletops.awaze.client-builder/undef)
     (. bean6233 setClientToken (clojure.core/str v6235))))
   (clojure.core/let
    [v6235
     (:reserved-instances-ids
      m6234
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6235 :com.palletops.awaze.client-builder/undef)
     (.
      bean6233
      setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6626] (clojure.core/str arg6626))
 v6235))))
   bean6233))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest}
describe-vpc-attribute-request
  [m6237]
  (clojure.core/let
   [bean6236
    (new com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest)]
   (clojure.core/let
    [v6238
     (:attribute m6237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6238 :com.palletops.awaze.client-builder/undef)
     (. bean6236 setAttribute (ec2/vpc-attribute-name v6238))))
   (clojure.core/let
    [v6238 (:vpc-id m6237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6238 :com.palletops.awaze.client-builder/undef)
     (. bean6236 setVpcId (clojure.core/str v6238))))
   bean6236))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest}
authorize-security-group-egress-request
  [m6240]
  (clojure.core/let
   [bean6239
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest)]
   (clojure.core/let
    [v6241
     (:group-id m6240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6241 :com.palletops.awaze.client-builder/undef)
     (. bean6239 setGroupId (clojure.core/str v6241))))
   (clojure.core/let
    [v6241
     (:source-security-group-name
      m6240
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6241 :com.palletops.awaze.client-builder/undef)
     (. bean6239 setSourceSecurityGroupName (clojure.core/str v6241))))
   (clojure.core/let
    [v6241
     (:source-security-group-owner-id
      m6240
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6241 :com.palletops.awaze.client-builder/undef)
     (.
      bean6239
      setSourceSecurityGroupOwnerId
      (clojure.core/str v6241))))
   (clojure.core/let
    [v6241
     (:ip-protocol m6240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6241 :com.palletops.awaze.client-builder/undef)
     (. bean6239 setIpProtocol (clojure.core/str v6241))))
   (clojure.core/let
    [v6241
     (:from-port m6240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6241 :com.palletops.awaze.client-builder/undef)
     (. bean6239 setFromPort (clojure.core/int v6241))))
   (clojure.core/let
    [v6241 (:to-port m6240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6241 :com.palletops.awaze.client-builder/undef)
     (. bean6239 setToPort (clojure.core/int v6241))))
   (clojure.core/let
    [v6241 (:cidr-ip m6240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6241 :com.palletops.awaze.client-builder/undef)
     (. bean6239 setCidrIp (clojure.core/str v6241))))
   (clojure.core/let
    [v6241
     (:ip-permissions m6240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6241 :com.palletops.awaze.client-builder/undef)
     (.
      bean6239
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6627] (ec2/ip-permission arg6627))
 v6241))))
   bean6239))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest}
delete-customer-gateway-request
  [m6243]
  (clojure.core/let
   [bean6242
    (new
     com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest)]
   (clojure.core/let
    [v6244
     (:customer-gateway-id
      m6243
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6244 :com.palletops.awaze.client-builder/undef)
     (. bean6242 setCustomerGatewayId (clojure.core/str v6244))))
   bean6242))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest}
replace-network-acl-entry-request
  [m6246]
  (clojure.core/let
   [bean6245
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest)]
   (clojure.core/let
    [v6247
     (:protocol m6246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6247 :com.palletops.awaze.client-builder/undef)
     (. bean6245 setProtocol (clojure.core/str v6247))))
   (clojure.core/let
    [v6247
     (:network-acl-id m6246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6247 :com.palletops.awaze.client-builder/undef)
     (. bean6245 setNetworkAclId (clojure.core/str v6247))))
   (clojure.core/let
    [v6247
     (:rule-number m6246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6247 :com.palletops.awaze.client-builder/undef)
     (. bean6245 setRuleNumber (clojure.core/int v6247))))
   (clojure.core/let
    [v6247
     (:rule-action m6246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6247 :com.palletops.awaze.client-builder/undef)
     (. bean6245 setRuleAction (clojure.core/str v6247))))
   (clojure.core/let
    [v6247 (:egress m6246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6247 :com.palletops.awaze.client-builder/undef)
     (. bean6245 setEgress (clojure.core/boolean v6247))))
   (clojure.core/let
    [v6247
     (:cidr-block m6246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6247 :com.palletops.awaze.client-builder/undef)
     (. bean6245 setCidrBlock (clojure.core/str v6247))))
   (clojure.core/let
    [v6247
     (:icmp-type-code m6246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6247 :com.palletops.awaze.client-builder/undef)
     (. bean6245 setIcmpTypeCode (ec2/icmp-type-code v6247))))
   (clojure.core/let
    [v6247
     (:port-range m6246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6247 :com.palletops.awaze.client-builder/undef)
     (. bean6245 setPortRange (ec2/port-range v6247))))
   bean6245))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest}
create-vpc-peering-connection-request
  [m6249]
  (clojure.core/let
   [bean6248
    (new
     com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v6250
     (:peer-vpc-id m6249 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6250 :com.palletops.awaze.client-builder/undef)
     (. bean6248 setPeerVpcId (clojure.core/str v6250))))
   (clojure.core/let
    [v6250
     (:peer-owner-id m6249 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6250 :com.palletops.awaze.client-builder/undef)
     (. bean6248 setPeerOwnerId (clojure.core/str v6250))))
   (clojure.core/let
    [v6250 (:vpc-id m6249 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6250 :com.palletops.awaze.client-builder/undef)
     (. bean6248 setVpcId (clojure.core/str v6250))))
   bean6248))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSubnetsRequest}
describe-subnets-request
  [m6252]
  (clojure.core/let
   [bean6251
    (new com.amazonaws.services.ec2.model.DescribeSubnetsRequest)]
   (clojure.core/let
    [v6253 (:filters m6252 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6253 :com.palletops.awaze.client-builder/undef)
     (.
      bean6251
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6628] (ec2/filter arg6628))
 v6253))))
   (clojure.core/let
    [v6253
     (:subnet-ids m6252 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6253 :com.palletops.awaze.client-builder/undef)
     (.
      bean6251
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6629] (clojure.core/str arg6629))
 v6253))))
   bean6251))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetConsoleOutputRequest}
get-console-output-request
  [m6255]
  (clojure.core/let
   [bean6254
    (new com.amazonaws.services.ec2.model.GetConsoleOutputRequest)]
   (clojure.core/let
    [v6256
     (:instance-id m6255 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6256 :com.palletops.awaze.client-builder/undef)
     (. bean6254 setInstanceId (clojure.core/str v6256))))
   bean6254))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelConversionTaskRequest}
cancel-conversion-task-request
  [m6258]
  (clojure.core/let
   [bean6257
    (new com.amazonaws.services.ec2.model.CancelConversionTaskRequest)]
   (clojure.core/let
    [v6259
     (:conversion-task-id
      m6258
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6259 :com.palletops.awaze.client-builder/undef)
     (. bean6257 setConversionTaskId (clojure.core/str v6259))))
   (clojure.core/let
    [v6259
     (:reason-message m6258 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6259 :com.palletops.awaze.client-builder/undef)
     (. bean6257 setReasonMessage (clojure.core/str v6259))))
   bean6257))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVpnGatewayRequest}
attach-vpn-gateway-request
  [m6261]
  (clojure.core/let
   [bean6260
    (new com.amazonaws.services.ec2.model.AttachVpnGatewayRequest)]
   (clojure.core/let
    [v6262 (:vpc-id m6261 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6262 :com.palletops.awaze.client-builder/undef)
     (. bean6260 setVpcId (clojure.core/str v6262))))
   (clojure.core/let
    [v6262
     (:vpn-gateway-id m6261 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6262 :com.palletops.awaze.client-builder/undef)
     (. bean6260 setVpnGatewayId (clojure.core/str v6262))))
   bean6260))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest}
describe-vpc-peering-connections-request
  [m6264]
  (clojure.core/let
   [bean6263
    (new
     com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest)]
   (clojure.core/let
    [v6265 (:filters m6264 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6265 :com.palletops.awaze.client-builder/undef)
     (.
      bean6263
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6630] (ec2/filter arg6630))
 v6265))))
   (clojure.core/let
    [v6265
     (:vpc-peering-connection-ids
      m6264
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6265 :com.palletops.awaze.client-builder/undef)
     (.
      bean6263
      setVpcPeeringConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6631] (clojure.core/str arg6631))
 v6265))))
   bean6263))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest}
delete-vpn-connection-route-request
  [m6267]
  (clojure.core/let
   [bean6266
    (new
     com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest)]
   (clojure.core/let
    [v6268
     (:destination-cidr-block
      m6267
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6268 :com.palletops.awaze.client-builder/undef)
     (. bean6266 setDestinationCidrBlock (clojure.core/str v6268))))
   (clojure.core/let
    [v6268
     (:vpn-connection-id
      m6267
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6268 :com.palletops.awaze.client-builder/undef)
     (. bean6266 setVpnConnectionId (clojure.core/str v6268))))
   bean6266))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RunInstancesRequest}
run-instances-request
  [m6270]
  (clojure.core/let
   [bean6269
    (new com.amazonaws.services.ec2.model.RunInstancesRequest)]
   (clojure.core/let
    [v6271
     (:iam-instance-profile
      m6270
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (.
      bean6269
      setIamInstanceProfile
      (ec2/iam-instance-profile-specification v6271))))
   (clojure.core/let
    [v6271
     (:placement m6270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (. bean6269 setPlacement (ec2/placement v6271))))
   (clojure.core/let
    [v6271
     (:block-device-mappings
      m6270
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (.
      bean6269
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6632] (ec2/block-device-mapping arg6632))
 v6271))))
   (clojure.core/let
    [v6271
     (:network-interfaces
      m6270
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (.
      bean6269
      setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6633]
  (ec2/instance-network-interface-specification arg6633))
 v6271))))
   (clojure.core/let
    [v6271
     (:key-name m6270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (. bean6269 setKeyName (clojure.core/str v6271))))
   (clojure.core/let
    [v6271
     (:monitoring m6270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (. bean6269 setMonitoring (clojure.core/boolean v6271))))
   (clojure.core/let
    [v6271
     (:private-ip-address
      m6270
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (. bean6269 setPrivateIpAddress (clojure.core/str v6271))))
   (clojure.core/let
    [v6271
     (:client-token m6270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (. bean6269 setClientToken (clojure.core/str v6271))))
   (clojure.core/let
    [v6271
     (:max-count m6270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (. bean6269 setMaxCount (clojure.core/int v6271))))
   (clojure.core/let
    [v6271
     (:disable-api-termination
      m6270
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (.
      bean6269
      setDisableApiTermination
      (clojure.core/boolean v6271))))
   (clojure.core/let
    [v6271
     (:instance-type m6270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (. bean6269 setInstanceType (clojure.core/str v6271))))
   (clojure.core/let
    [v6271
     (:ebs-optimized m6270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (. bean6269 setEbsOptimized (clojure.core/boolean v6271))))
   (clojure.core/let
    [v6271
     (:image-id m6270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (. bean6269 setImageId (clojure.core/str v6271))))
   (clojure.core/let
    [v6271
     (:ramdisk-id m6270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (. bean6269 setRamdiskId (clojure.core/str v6271))))
   (clojure.core/let
    [v6271
     (:security-groups
      m6270
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (.
      bean6269
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6634] (clojure.core/str arg6634))
 v6271))))
   (clojure.core/let
    [v6271
     (:user-data m6270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (. bean6269 setUserData (clojure.core/str v6271))))
   (clojure.core/let
    [v6271
     (:additional-info
      m6270
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (. bean6269 setAdditionalInfo (clojure.core/str v6271))))
   (clojure.core/let
    [v6271
     (:kernel-id m6270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (. bean6269 setKernelId (clojure.core/str v6271))))
   (clojure.core/let
    [v6271
     (:subnet-id m6270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (. bean6269 setSubnetId (clojure.core/str v6271))))
   (clojure.core/let
    [v6271
     (:security-group-ids
      m6270
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (.
      bean6269
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6635] (clojure.core/str arg6635))
 v6271))))
   (clojure.core/let
    [v6271
     (:instance-initiated-shutdown-behavior
      m6270
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (.
      bean6269
      setInstanceInitiatedShutdownBehavior
      (clojure.core/str v6271))))
   (clojure.core/let
    [v6271
     (:min-count m6270 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6271 :com.palletops.awaze.client-builder/undef)
     (. bean6269 setMinCount (clojure.core/int v6271))))
   bean6269))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RegisterImageRequest}
register-image-request
  [m6273]
  (clojure.core/let
   [bean6272
    (new com.amazonaws.services.ec2.model.RegisterImageRequest)]
   (clojure.core/let
    [v6274
     (:sriov-net-support
      m6273
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6274 :com.palletops.awaze.client-builder/undef)
     (. bean6272 setSriovNetSupport (clojure.core/str v6274))))
   (clojure.core/let
    [v6274
     (:root-device-name
      m6273
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6274 :com.palletops.awaze.client-builder/undef)
     (. bean6272 setRootDeviceName (clojure.core/str v6274))))
   (clojure.core/let
    [v6274
     (:block-device-mappings
      m6273
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6274 :com.palletops.awaze.client-builder/undef)
     (.
      bean6272
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6636] (ec2/block-device-mapping arg6636))
 v6274))))
   (clojure.core/let
    [v6274 (:name m6273 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6274 :com.palletops.awaze.client-builder/undef)
     (. bean6272 setName (clojure.core/str v6274))))
   (clojure.core/let
    [v6274
     (:image-location m6273 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6274 :com.palletops.awaze.client-builder/undef)
     (. bean6272 setImageLocation (clojure.core/str v6274))))
   (clojure.core/let
    [v6274
     (:ramdisk-id m6273 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6274 :com.palletops.awaze.client-builder/undef)
     (. bean6272 setRamdiskId (clojure.core/str v6274))))
   (clojure.core/let
    [v6274
     (:virtualization-type
      m6273
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6274 :com.palletops.awaze.client-builder/undef)
     (. bean6272 setVirtualizationType (clojure.core/str v6274))))
   (clojure.core/let
    [v6274
     (:architecture m6273 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6274 :com.palletops.awaze.client-builder/undef)
     (. bean6272 setArchitecture (clojure.core/str v6274))))
   (clojure.core/let
    [v6274
     (:kernel-id m6273 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6274 :com.palletops.awaze.client-builder/undef)
     (. bean6272 setKernelId (clojure.core/str v6274))))
   (clojure.core/let
    [v6274
     (:description m6273 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6274 :com.palletops.awaze.client-builder/undef)
     (. bean6272 setDescription (clojure.core/str v6274))))
   bean6272))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeTagsRequest}
describe-tags-request
  [m6276]
  (clojure.core/let
   [bean6275
    (new com.amazonaws.services.ec2.model.DescribeTagsRequest)]
   (clojure.core/let
    [v6277 (:filters m6276 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6277 :com.palletops.awaze.client-builder/undef)
     (.
      bean6275
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6637] (ec2/filter arg6637))
 v6277))))
   (clojure.core/let
    [v6277
     (:next-token m6276 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6277 :com.palletops.awaze.client-builder/undef)
     (. bean6275 setNextToken (clojure.core/str v6277))))
   (clojure.core/let
    [v6277
     (:max-results m6276 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6277 :com.palletops.awaze.client-builder/undef)
     (. bean6275 setMaxResults (clojure.core/int v6277))))
   bean6275))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest}
describe-reserved-instances-request
  [m6279]
  (clojure.core/let
   [bean6278
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest)]
   (clojure.core/let
    [v6280 (:filters m6279 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6280 :com.palletops.awaze.client-builder/undef)
     (.
      bean6278
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6638] (ec2/filter arg6638))
 v6280))))
   (clojure.core/let
    [v6280
     (:offering-type m6279 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6280 :com.palletops.awaze.client-builder/undef)
     (. bean6278 setOfferingType (ec2/offering-type-values v6280))))
   (clojure.core/let
    [v6280
     (:reserved-instances-ids
      m6279
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6280 :com.palletops.awaze.client-builder/undef)
     (.
      bean6278
      setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6639] (clojure.core/str arg6639))
 v6280))))
   bean6278))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVpnGatewayRequest}
detach-vpn-gateway-request
  [m6282]
  (clojure.core/let
   [bean6281
    (new com.amazonaws.services.ec2.model.DetachVpnGatewayRequest)]
   (clojure.core/let
    [v6283 (:vpc-id m6282 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6283 :com.palletops.awaze.client-builder/undef)
     (. bean6281 setVpcId (clojure.core/str v6283))))
   (clojure.core/let
    [v6283
     (:vpn-gateway-id m6282 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6283 :com.palletops.awaze.client-builder/undef)
     (. bean6281 setVpnGatewayId (clojure.core/str v6283))))
   bean6281))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest}
describe-customer-gateways-request
  [m6285]
  (clojure.core/let
   [bean6284
    (new
     com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest)]
   (clojure.core/let
    [v6286 (:filters m6285 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6286 :com.palletops.awaze.client-builder/undef)
     (.
      bean6284
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6640] (ec2/filter arg6640))
 v6286))))
   (clojure.core/let
    [v6286
     (:customer-gateway-ids
      m6285
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6286 :com.palletops.awaze.client-builder/undef)
     (.
      bean6284
      setCustomerGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6641] (clojure.core/str arg6641))
 v6286))))
   bean6284))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest}
describe-network-interface-attribute-request
  [m6288]
  (clojure.core/let
   [bean6287
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v6289 (:groups m6288 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6289 :com.palletops.awaze.client-builder/undef)
     (. bean6287 setGroups (clojure.core/str v6289))))
   (clojure.core/let
    [v6289
     (:source-dest-check
      m6288
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6289 :com.palletops.awaze.client-builder/undef)
     (. bean6287 setSourceDestCheck (clojure.core/str v6289))))
   (clojure.core/let
    [v6289
     (:attachment m6288 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6289 :com.palletops.awaze.client-builder/undef)
     (. bean6287 setAttachment (clojure.core/str v6289))))
   (clojure.core/let
    [v6289
     (:description m6288 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6289 :com.palletops.awaze.client-builder/undef)
     (. bean6287 setDescription (clojure.core/str v6289))))
   (clojure.core/let
    [v6289
     (:network-interface-id
      m6288
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6289 :com.palletops.awaze.client-builder/undef)
     (. bean6287 setNetworkInterfaceId (clojure.core/str v6289))))
   bean6287))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportKeyPairRequest}
import-key-pair-request
  [m6291]
  (clojure.core/let
   [bean6290
    (new com.amazonaws.services.ec2.model.ImportKeyPairRequest)]
   (clojure.core/let
    [v6292
     (:key-name m6291 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6292 :com.palletops.awaze.client-builder/undef)
     (. bean6290 setKeyName (clojure.core/str v6292))))
   (clojure.core/let
    [v6292
     (:public-key-material
      m6291
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6292 :com.palletops.awaze.client-builder/undef)
     (. bean6290 setPublicKeyMaterial (clojure.core/str v6292))))
   bean6290))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceRequest}
import-instance-request
  [m6294]
  (clojure.core/let
   [bean6293
    (new com.amazonaws.services.ec2.model.ImportInstanceRequest)]
   (clojure.core/let
    [v6295
     (:platform m6294 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6295 :com.palletops.awaze.client-builder/undef)
     (. bean6293 setPlatform (ec2/platform-values v6295))))
   (clojure.core/let
    [v6295
     (:launch-specification
      m6294
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6295 :com.palletops.awaze.client-builder/undef)
     (.
      bean6293
      setLaunchSpecification
      (ec2/import-instance-launch-specification v6295))))
   (clojure.core/let
    [v6295
     (:disk-images m6294 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6295 :com.palletops.awaze.client-builder/undef)
     (.
      bean6293
      setDiskImages
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6642] (ec2/disk-image arg6642))
 v6295))))
   (clojure.core/let
    [v6295
     (:description m6294 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6295 :com.palletops.awaze.client-builder/undef)
     (. bean6293 setDescription (clojure.core/str v6295))))
   bean6293))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocateAddressRequest}
allocate-address-request
  [m6297]
  (clojure.core/let
   [bean6296
    (new com.amazonaws.services.ec2.model.AllocateAddressRequest)]
   (clojure.core/let
    [v6298 (:domain m6297 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6298 :com.palletops.awaze.client-builder/undef)
     (. bean6296 setDomain (clojure.core/str v6298))))
   bean6296))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest}
describe-spot-instance-requests-request
  [m6300]
  (clojure.core/let
   [bean6299
    (new
     com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest)]
   (clojure.core/let
    [v6301 (:filters m6300 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6301 :com.palletops.awaze.client-builder/undef)
     (.
      bean6299
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6643] (ec2/filter arg6643))
 v6301))))
   (clojure.core/let
    [v6301
     (:spot-instance-request-ids
      m6300
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6301 :com.palletops.awaze.client-builder/undef)
     (.
      bean6299
      setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6644] (clojure.core/str arg6644))
 v6301))))
   bean6299))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest}
delete-spot-datafeed-subscription-request
  [m6303]
  (clojure.core/let
   [bean6302
    (new
     com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest)]
   bean6302))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeConversionTasksRequest}
describe-conversion-tasks-request
  [m6306]
  (clojure.core/let
   [bean6305
    (new
     com.amazonaws.services.ec2.model.DescribeConversionTasksRequest)]
   (clojure.core/let
    [v6307 (:filters m6306 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6307 :com.palletops.awaze.client-builder/undef)
     (.
      bean6305
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6645] (ec2/filter arg6645))
 v6307))))
   (clojure.core/let
    [v6307
     (:conversion-task-ids
      m6306
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6307 :com.palletops.awaze.client-builder/undef)
     (.
      bean6305
      setConversionTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6646] (clojure.core/str arg6646))
 v6307))))
   bean6305))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest}
replace-route-table-association-request
  [m6309]
  (clojure.core/let
   [bean6308
    (new
     com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest)]
   (clojure.core/let
    [v6310
     (:route-table-id m6309 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6310 :com.palletops.awaze.client-builder/undef)
     (. bean6308 setRouteTableId (clojure.core/str v6310))))
   (clojure.core/let
    [v6310
     (:association-id m6309 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6310 :com.palletops.awaze.client-builder/undef)
     (. bean6308 setAssociationId (clojure.core/str v6310))))
   bean6308))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSubnetRequest}
delete-subnet-request
  [m6312]
  (clojure.core/let
   [bean6311
    (new com.amazonaws.services.ec2.model.DeleteSubnetRequest)]
   (clojure.core/let
    [v6313
     (:subnet-id m6312 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6313 :com.palletops.awaze.client-builder/undef)
     (. bean6311 setSubnetId (clojure.core/str v6313))))
   bean6311))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest}
modify-vpc-attribute-request
  [m6315]
  (clojure.core/let
   [bean6314
    (new com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest)]
   (clojure.core/let
    [v6316
     (:enable-dns-support
      m6315
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6316 :com.palletops.awaze.client-builder/undef)
     (. bean6314 setEnableDnsSupport (clojure.core/boolean v6316))))
   (clojure.core/let
    [v6316
     (:enable-dns-hostnames
      m6315
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6316 :com.palletops.awaze.client-builder/undef)
     (. bean6314 setEnableDnsHostnames (clojure.core/boolean v6316))))
   (clojure.core/let
    [v6316 (:vpc-id m6315 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6316 :com.palletops.awaze.client-builder/undef)
     (. bean6314 setVpcId (clojure.core/str v6316))))
   bean6314))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachInternetGatewayRequest}
detach-internet-gateway-request
  [m6318]
  (clojure.core/let
   [bean6317
    (new
     com.amazonaws.services.ec2.model.DetachInternetGatewayRequest)]
   (clojure.core/let
    [v6319
     (:internet-gateway-id
      m6318
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6319 :com.palletops.awaze.client-builder/undef)
     (. bean6317 setInternetGatewayId (clojure.core/str v6319))))
   (clojure.core/let
    [v6319 (:vpc-id m6318 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6319 :com.palletops.awaze.client-builder/undef)
     (. bean6317 setVpcId (clojure.core/str v6319))))
   bean6317))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest}
describe-reserved-instances-modifications-request
  [m6321]
  (clojure.core/let
   [bean6320
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest)]
   (clojure.core/let
    [v6322 (:filters m6321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6322 :com.palletops.awaze.client-builder/undef)
     (.
      bean6320
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6647] (ec2/filter arg6647))
 v6322))))
   (clojure.core/let
    [v6322
     (:next-token m6321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6322 :com.palletops.awaze.client-builder/undef)
     (. bean6320 setNextToken (clojure.core/str v6322))))
   (clojure.core/let
    [v6322
     (:reserved-instances-modification-ids
      m6321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6322 :com.palletops.awaze.client-builder/undef)
     (.
      bean6320
      setReservedInstancesModificationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6648] (clojure.core/str arg6648))
 v6322))))
   bean6320))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetPasswordDataRequest}
get-password-data-request
  [m6324]
  (clojure.core/let
   [bean6323
    (new com.amazonaws.services.ec2.model.GetPasswordDataRequest)]
   (clojure.core/let
    [v6325
     (:instance-id m6324 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6325 :com.palletops.awaze.client-builder/undef)
     (. bean6323 setInstanceId (clojure.core/str v6325))))
   bean6323))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest}
unassign-private-ip-addresses-request
  [m6327]
  (clojure.core/let
   [bean6326
    (new
     com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest)]
   (clojure.core/let
    [v6328
     (:private-ip-addresses
      m6327
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6328 :com.palletops.awaze.client-builder/undef)
     (.
      bean6326
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6649] (clojure.core/str arg6649))
 v6328))))
   (clojure.core/let
    [v6328
     (:network-interface-id
      m6327
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6328 :com.palletops.awaze.client-builder/undef)
     (. bean6326 setNetworkInterfaceId (clojure.core/str v6328))))
   bean6326))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest}
modify-network-interface-attribute-request
  [m6330]
  (clojure.core/let
   [bean6329
    (new
     com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v6331 (:groups m6330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6331 :com.palletops.awaze.client-builder/undef)
     (.
      bean6329
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6650] (clojure.core/str arg6650))
 v6331))))
   (clojure.core/let
    [v6331
     (:source-dest-check
      m6330
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6331 :com.palletops.awaze.client-builder/undef)
     (. bean6329 setSourceDestCheck (clojure.core/boolean v6331))))
   (clojure.core/let
    [v6331
     (:attachment m6330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6331 :com.palletops.awaze.client-builder/undef)
     (.
      bean6329
      setAttachment
      (ec2/network-interface-attachment-changes v6331))))
   (clojure.core/let
    [v6331
     (:description m6330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6331 :com.palletops.awaze.client-builder/undef)
     (. bean6329 setDescription (clojure.core/str v6331))))
   (clojure.core/let
    [v6331
     (:network-interface-id
      m6330
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6331 :com.palletops.awaze.client-builder/undef)
     (. bean6329 setNetworkInterfaceId (clojure.core/str v6331))))
   bean6329))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest}
reset-network-interface-attribute-request
  [m6333]
  (clojure.core/let
   [bean6332
    (new
     com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest)]
   (clojure.core/let
    [v6334
     (:source-dest-check
      m6333
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6334 :com.palletops.awaze.client-builder/undef)
     (. bean6332 setSourceDestCheck (clojure.core/str v6334))))
   (clojure.core/let
    [v6334
     (:network-interface-id
      m6333
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6334 :com.palletops.awaze.client-builder/undef)
     (. bean6332 setNetworkInterfaceId (clojure.core/str v6334))))
   bean6332))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcsRequest}
describe-vpcs-request
  [m6336]
  (clojure.core/let
   [bean6335
    (new com.amazonaws.services.ec2.model.DescribeVpcsRequest)]
   (clojure.core/let
    [v6337 (:filters m6336 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6337 :com.palletops.awaze.client-builder/undef)
     (.
      bean6335
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6651] (ec2/filter arg6651))
 v6337))))
   (clojure.core/let
    [v6337 (:vpc-ids m6336 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6337 :com.palletops.awaze.client-builder/undef)
     (.
      bean6335
      setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6652] (clojure.core/str arg6652))
 v6337))))
   bean6335))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RebootInstancesRequest}
reboot-instances-request
  [m6339]
  (clojure.core/let
   [bean6338
    (new com.amazonaws.services.ec2.model.RebootInstancesRequest)]
   (clojure.core/let
    [v6340
     (:instance-ids m6339 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6340 :com.palletops.awaze.client-builder/undef)
     (.
      bean6338
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6653] (clojure.core/str arg6653))
 v6340))))
   bean6338))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest}
describe-volume-attribute-request
  [m6342]
  (clojure.core/let
   [bean6341
    (new
     com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest)]
   (clojure.core/let
    [v6343
     (:attribute m6342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6343 :com.palletops.awaze.client-builder/undef)
     (. bean6341 setAttribute (ec2/volume-attribute-name v6343))))
   (clojure.core/let
    [v6343
     (:volume-id m6342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6343 :com.palletops.awaze.client-builder/undef)
     (. bean6341 setVolumeId (clojure.core/str v6343))))
   bean6341))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest}
modify-instance-attribute-request
  [m6345]
  (clojure.core/let
   [bean6344
    (new
     com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest)]
   (clojure.core/let
    [v6346
     (:sriov-net-support
      m6345
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6346 :com.palletops.awaze.client-builder/undef)
     (. bean6344 setSriovNetSupport (clojure.core/str v6346))))
   (clojure.core/let
    [v6346
     (:block-device-mappings
      m6345
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6346 :com.palletops.awaze.client-builder/undef)
     (.
      bean6344
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6654]
  (ec2/instance-block-device-mapping-specification arg6654))
 v6346))))
   (clojure.core/let
    [v6346
     (:source-dest-check
      m6345
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6346 :com.palletops.awaze.client-builder/undef)
     (. bean6344 setSourceDestCheck (clojure.core/boolean v6346))))
   (clojure.core/let
    [v6346 (:value m6345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6346 :com.palletops.awaze.client-builder/undef)
     (. bean6344 setValue (clojure.core/str v6346))))
   (clojure.core/let
    [v6346
     (:disable-api-termination
      m6345
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6346 :com.palletops.awaze.client-builder/undef)
     (.
      bean6344
      setDisableApiTermination
      (clojure.core/boolean v6346))))
   (clojure.core/let
    [v6346
     (:instance-type m6345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6346 :com.palletops.awaze.client-builder/undef)
     (. bean6344 setInstanceType (clojure.core/str v6346))))
   (clojure.core/let
    [v6346
     (:instance-id m6345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6346 :com.palletops.awaze.client-builder/undef)
     (. bean6344 setInstanceId (clojure.core/str v6346))))
   (clojure.core/let
    [v6346
     (:ebs-optimized m6345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6346 :com.palletops.awaze.client-builder/undef)
     (. bean6344 setEbsOptimized (clojure.core/boolean v6346))))
   (clojure.core/let
    [v6346 (:groups m6345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6346 :com.palletops.awaze.client-builder/undef)
     (.
      bean6344
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6655] (clojure.core/str arg6655))
 v6346))))
   (clojure.core/let
    [v6346
     (:user-data m6345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6346 :com.palletops.awaze.client-builder/undef)
     (. bean6344 setUserData (clojure.core/str v6346))))
   (clojure.core/let
    [v6346 (:ramdisk m6345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6346 :com.palletops.awaze.client-builder/undef)
     (. bean6344 setRamdisk (clojure.core/str v6346))))
   (clojure.core/let
    [v6346
     (:attribute m6345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6346 :com.palletops.awaze.client-builder/undef)
     (. bean6344 setAttribute (clojure.core/str v6346))))
   (clojure.core/let
    [v6346
     (:instance-initiated-shutdown-behavior
      m6345
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6346 :com.palletops.awaze.client-builder/undef)
     (.
      bean6344
      setInstanceInitiatedShutdownBehavior
      (clojure.core/str v6346))))
   (clojure.core/let
    [v6346 (:kernel m6345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6346 :com.palletops.awaze.client-builder/undef)
     (. bean6344 setKernel (clojure.core/str v6346))))
   bean6344))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteKeyPairRequest}
delete-key-pair-request
  [m6348]
  (clojure.core/let
   [bean6347
    (new com.amazonaws.services.ec2.model.DeleteKeyPairRequest)]
   (clojure.core/let
    [v6349
     (:key-name m6348 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6349 :com.palletops.awaze.client-builder/undef)
     (. bean6347 setKeyName (clojure.core/str v6349))))
   bean6347))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest}
enable-vgw-route-propagation-request
  [m6351]
  (clojure.core/let
   [bean6350
    (new
     com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest)]
   (clojure.core/let
    [v6352
     (:route-table-id m6351 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6352 :com.palletops.awaze.client-builder/undef)
     (. bean6350 setRouteTableId (clojure.core/str v6352))))
   (clojure.core/let
    [v6352
     (:gateway-id m6351 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6352 :com.palletops.awaze.client-builder/undef)
     (. bean6350 setGatewayId (clojure.core/str v6352))))
   bean6350))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BundleInstanceRequest}
bundle-instance-request
  [m6354]
  (clojure.core/let
   [bean6353
    (new com.amazonaws.services.ec2.model.BundleInstanceRequest)]
   (clojure.core/let
    [v6355
     (:instance-id m6354 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6355 :com.palletops.awaze.client-builder/undef)
     (. bean6353 setInstanceId (clojure.core/str v6355))))
   (clojure.core/let
    [v6355 (:storage m6354 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6355 :com.palletops.awaze.client-builder/undef)
     (. bean6353 setStorage (ec2/storage v6355))))
   bean6353))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInternetGatewayRequest}
create-internet-gateway-request
  [m6357]
  (clojure.core/let
   [bean6356
    (new
     com.amazonaws.services.ec2.model.CreateInternetGatewayRequest)]
   bean6356))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest}
describe-volume-status-request
  [m6360]
  (clojure.core/let
   [bean6359
    (new com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest)]
   (clojure.core/let
    [v6361 (:filters m6360 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6361 :com.palletops.awaze.client-builder/undef)
     (.
      bean6359
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6656] (ec2/filter arg6656))
 v6361))))
   (clojure.core/let
    [v6361
     (:next-token m6360 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6361 :com.palletops.awaze.client-builder/undef)
     (. bean6359 setNextToken (clojure.core/str v6361))))
   (clojure.core/let
    [v6361
     (:volume-ids m6360 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6361 :com.palletops.awaze.client-builder/undef)
     (.
      bean6359
      setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6657] (clojure.core/str arg6657))
 v6361))))
   (clojure.core/let
    [v6361
     (:max-results m6360 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6361 :com.palletops.awaze.client-builder/undef)
     (. bean6359 setMaxResults (clojure.core/int v6361))))
   bean6359))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopyImageRequest}
copy-image-request
  [m6363]
  (clojure.core/let
   [bean6362 (new com.amazonaws.services.ec2.model.CopyImageRequest)]
   (clojure.core/let
    [v6364 (:name m6363 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6364 :com.palletops.awaze.client-builder/undef)
     (. bean6362 setName (clojure.core/str v6364))))
   (clojure.core/let
    [v6364
     (:source-image-id
      m6363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6364 :com.palletops.awaze.client-builder/undef)
     (. bean6362 setSourceImageId (clojure.core/str v6364))))
   (clojure.core/let
    [v6364
     (:description m6363 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6364 :com.palletops.awaze.client-builder/undef)
     (. bean6362 setDescription (clojure.core/str v6364))))
   (clojure.core/let
    [v6364
     (:source-region m6363 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6364 :com.palletops.awaze.client-builder/undef)
     (. bean6362 setSourceRegion (clojure.core/str v6364))))
   (clojure.core/let
    [v6364
     (:client-token m6363 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6364 :com.palletops.awaze.client-builder/undef)
     (. bean6362 setClientToken (clojure.core/str v6364))))
   bean6362))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeKeyPairsRequest}
describe-key-pairs-request
  [m6366]
  (clojure.core/let
   [bean6365
    (new com.amazonaws.services.ec2.model.DescribeKeyPairsRequest)]
   (clojure.core/let
    [v6367 (:filters m6366 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6367 :com.palletops.awaze.client-builder/undef)
     (.
      bean6365
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6658] (ec2/filter arg6658))
 v6367))))
   (clojure.core/let
    [v6367
     (:key-names m6366 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6367 :com.palletops.awaze.client-builder/undef)
     (.
      bean6365
      setKeyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6659] (clojure.core/str arg6659))
 v6367))))
   bean6365))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest}
accept-vpc-peering-connection-request
  [m6369]
  (clojure.core/let
   [bean6368
    (new
     com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v6370
     (:vpc-peering-connection-id
      m6369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6370 :com.palletops.awaze.client-builder/undef)
     (. bean6368 setVpcPeeringConnectionId (clojure.core/str v6370))))
   bean6368))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest}
delete-network-acl-entry-request
  [m6372]
  (clojure.core/let
   [bean6371
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest)]
   (clojure.core/let
    [v6373
     (:network-acl-id m6372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6373 :com.palletops.awaze.client-builder/undef)
     (. bean6371 setNetworkAclId (clojure.core/str v6373))))
   (clojure.core/let
    [v6373
     (:rule-number m6372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6373 :com.palletops.awaze.client-builder/undef)
     (. bean6371 setRuleNumber (clojure.core/int v6373))))
   (clojure.core/let
    [v6373 (:egress m6372 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6373 :com.palletops.awaze.client-builder/undef)
     (. bean6371 setEgress (clojure.core/boolean v6373))))
   bean6371))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest}
purchase-reserved-instances-offering-request
  [m6375]
  (clojure.core/let
   [bean6374
    (new
     com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest)]
   (clojure.core/let
    [v6376
     (:instance-count m6375 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6376 :com.palletops.awaze.client-builder/undef)
     (. bean6374 setInstanceCount (clojure.core/int v6376))))
   (clojure.core/let
    [v6376
     (:reserved-instances-offering-id
      m6375
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6376 :com.palletops.awaze.client-builder/undef)
     (.
      bean6374
      setReservedInstancesOfferingId
      (clojure.core/str v6376))))
   (clojure.core/let
    [v6376
     (:limit-price m6375 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6376 :com.palletops.awaze.client-builder/undef)
     (.
      bean6374
      setLimitPrice
      (ec2/reserved-instance-limit-price v6376))))
   bean6374))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest}
cancel-reserved-instances-listing-request
  [m6378]
  (clojure.core/let
   [bean6377
    (new
     com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest)]
   (clojure.core/let
    [v6379
     (:reserved-instances-listing-id
      m6378
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6379 :com.palletops.awaze.client-builder/undef)
     (.
      bean6377
      setReservedInstancesListingId
      (clojure.core/str v6379))))
   bean6377))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest}
revoke-security-group-egress-request
  [m6381]
  (clojure.core/let
   [bean6380
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest)]
   (clojure.core/let
    [v6382
     (:group-id m6381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setGroupId (clojure.core/str v6382))))
   (clojure.core/let
    [v6382
     (:source-security-group-name
      m6381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setSourceSecurityGroupName (clojure.core/str v6382))))
   (clojure.core/let
    [v6382
     (:source-security-group-owner-id
      m6381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (.
      bean6380
      setSourceSecurityGroupOwnerId
      (clojure.core/str v6382))))
   (clojure.core/let
    [v6382
     (:ip-protocol m6381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setIpProtocol (clojure.core/str v6382))))
   (clojure.core/let
    [v6382
     (:from-port m6381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setFromPort (clojure.core/int v6382))))
   (clojure.core/let
    [v6382 (:to-port m6381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setToPort (clojure.core/int v6382))))
   (clojure.core/let
    [v6382 (:cidr-ip m6381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (. bean6380 setCidrIp (clojure.core/str v6382))))
   (clojure.core/let
    [v6382
     (:ip-permissions m6381 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6382 :com.palletops.awaze.client-builder/undef)
     (.
      bean6380
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6660] (ec2/ip-permission arg6660))
 v6382))))
   bean6380))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest}
create-spot-datafeed-subscription-request
  [m6384]
  (clojure.core/let
   [bean6383
    (new
     com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest)]
   (clojure.core/let
    [v6385 (:bucket m6384 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6385 :com.palletops.awaze.client-builder/undef)
     (. bean6383 setBucket (clojure.core/str v6385))))
   (clojure.core/let
    [v6385 (:prefix m6384 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6385 :com.palletops.awaze.client-builder/undef)
     (. bean6383 setPrefix (clojure.core/str v6385))))
   bean6383))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVolumeIORequest}
enable-volume-iorequest
  [m6387]
  (clojure.core/let
   [bean6386
    (new com.amazonaws.services.ec2.model.EnableVolumeIORequest)]
   (clojure.core/let
    [v6388
     (:volume-id m6387 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6388 :com.palletops.awaze.client-builder/undef)
     (. bean6386 setVolumeId (clojure.core/str v6388))))
   bean6386))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest}
replace-network-acl-association-request
  [m6390]
  (clojure.core/let
   [bean6389
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest)]
   (clojure.core/let
    [v6391
     (:network-acl-id m6390 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6391 :com.palletops.awaze.client-builder/undef)
     (. bean6389 setNetworkAclId (clojure.core/str v6391))))
   (clojure.core/let
    [v6391
     (:association-id m6390 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6391 :com.palletops.awaze.client-builder/undef)
     (. bean6389 setAssociationId (clojure.core/str v6391))))
   bean6389))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest}
delete-vpc-peering-connection-request
  [m6393]
  (clojure.core/let
   [bean6392
    (new
     com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest)]
   (clojure.core/let
    [v6394
     (:vpc-peering-connection-id
      m6393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6394 :com.palletops.awaze.client-builder/undef)
     (. bean6392 setVpcPeeringConnectionId (clojure.core/str v6394))))
   bean6392))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopySnapshotRequest}
copy-snapshot-request
  [m6396]
  (clojure.core/let
   [bean6395
    (new com.amazonaws.services.ec2.model.CopySnapshotRequest)]
   (clojure.core/let
    [v6397
     (:source-snapshot-id
      m6396
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6397 :com.palletops.awaze.client-builder/undef)
     (. bean6395 setSourceSnapshotId (clojure.core/str v6397))))
   (clojure.core/let
    [v6397
     (:presigned-url m6396 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6397 :com.palletops.awaze.client-builder/undef)
     (. bean6395 setPresignedUrl (clojure.core/str v6397))))
   (clojure.core/let
    [v6397
     (:description m6396 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6397 :com.palletops.awaze.client-builder/undef)
     (. bean6395 setDescription (clojure.core/str v6397))))
   (clojure.core/let
    [v6397
     (:destination-region
      m6396
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6397 :com.palletops.awaze.client-builder/undef)
     (. bean6395 setDestinationRegion (clojure.core/str v6397))))
   (clojure.core/let
    [v6397
     (:source-region m6396 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6397 :com.palletops.awaze.client-builder/undef)
     (. bean6395 setSourceRegion (clojure.core/str v6397))))
   bean6395))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest}
create-customer-gateway-request
  [m6399]
  (clojure.core/let
   [bean6398
    (new
     com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest)]
   (clojure.core/let
    [v6400
     (:public-ip m6399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6400 :com.palletops.awaze.client-builder/undef)
     (. bean6398 setPublicIp (clojure.core/str v6400))))
   (clojure.core/let
    [v6400 (:bgp-asn m6399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6400 :com.palletops.awaze.client-builder/undef)
     (. bean6398 setBgpAsn (clojure.core/int v6400))))
   (clojure.core/let
    [v6400 (:type m6399 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6400 :com.palletops.awaze.client-builder/undef)
     (. bean6398 setType (clojure.core/str v6400))))
   bean6398))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest}
describe-reserved-instances-offerings-request
  [m6402]
  (clojure.core/let
   [bean6401
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest)]
   (clojure.core/let
    [v6403
     (:offering-type m6402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6403 :com.palletops.awaze.client-builder/undef)
     (. bean6401 setOfferingType (clojure.core/str v6403))))
   (clojure.core/let
    [v6403
     (:min-duration m6402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6403 :com.palletops.awaze.client-builder/undef)
     (. bean6401 setMinDuration (clojure.core/long v6403))))
   (clojure.core/let
    [v6403
     (:next-token m6402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6403 :com.palletops.awaze.client-builder/undef)
     (. bean6401 setNextToken (clojure.core/str v6403))))
   (clojure.core/let
    [v6403
     (:include-marketplace
      m6402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6403 :com.palletops.awaze.client-builder/undef)
     (. bean6401 setIncludeMarketplace (clojure.core/boolean v6403))))
   (clojure.core/let
    [v6403
     (:availability-zone
      m6402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6403 :com.palletops.awaze.client-builder/undef)
     (. bean6401 setAvailabilityZone (clojure.core/str v6403))))
   (clojure.core/let
    [v6403
     (:instance-tenancy
      m6402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6403 :com.palletops.awaze.client-builder/undef)
     (. bean6401 setInstanceTenancy (clojure.core/str v6403))))
   (clojure.core/let
    [v6403
     (:product-description
      m6402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6403 :com.palletops.awaze.client-builder/undef)
     (.
      bean6401
      setProductDescription
      (ec2/riproduct-description v6403))))
   (clojure.core/let
    [v6403
     (:instance-type m6402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6403 :com.palletops.awaze.client-builder/undef)
     (. bean6401 setInstanceType (clojure.core/str v6403))))
   (clojure.core/let
    [v6403
     (:max-results m6402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6403 :com.palletops.awaze.client-builder/undef)
     (. bean6401 setMaxResults (clojure.core/int v6403))))
   (clojure.core/let
    [v6403
     (:max-duration m6402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6403 :com.palletops.awaze.client-builder/undef)
     (. bean6401 setMaxDuration (clojure.core/long v6403))))
   (clojure.core/let
    [v6403
     (:max-instance-count
      m6402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6403 :com.palletops.awaze.client-builder/undef)
     (. bean6401 setMaxInstanceCount (clojure.core/int v6403))))
   (clojure.core/let
    [v6403 (:filters m6402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6403 :com.palletops.awaze.client-builder/undef)
     (.
      bean6401
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6661] (ec2/filter arg6661))
 v6403))))
   (clojure.core/let
    [v6403
     (:reserved-instances-offering-ids
      m6402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6403 :com.palletops.awaze.client-builder/undef)
     (.
      bean6401
      setReservedInstancesOfferingIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6662] (clojure.core/str arg6662))
 v6403))))
   bean6401))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelBundleTaskRequest}
cancel-bundle-task-request
  [m6405]
  (clojure.core/let
   [bean6404
    (new com.amazonaws.services.ec2.model.CancelBundleTaskRequest)]
   (clojure.core/let
    [v6406
     (:bundle-id m6405 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6406 :com.palletops.awaze.client-builder/undef)
     (. bean6404 setBundleId (clojure.core/str v6406))))
   bean6404))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImagesRequest}
describe-images-request
  [m6408]
  (clojure.core/let
   [bean6407
    (new com.amazonaws.services.ec2.model.DescribeImagesRequest)]
   (clojure.core/let
    [v6409 (:filters m6408 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6409 :com.palletops.awaze.client-builder/undef)
     (.
      bean6407
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6663] (ec2/filter arg6663))
 v6409))))
   (clojure.core/let
    [v6409
     (:image-ids m6408 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6409 :com.palletops.awaze.client-builder/undef)
     (.
      bean6407
      setImageIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6664] (clojure.core/str arg6664))
 v6409))))
   (clojure.core/let
    [v6409 (:owners m6408 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6409 :com.palletops.awaze.client-builder/undef)
     (.
      bean6407
      setOwners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6665] (clojure.core/str arg6665))
 v6409))))
   (clojure.core/let
    [v6409
     (:executable-users
      m6408
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6409 :com.palletops.awaze.client-builder/undef)
     (.
      bean6407
      setExecutableUsers
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6666] (clojure.core/str arg6666))
 v6409))))
   bean6407))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest}
describe-dhcp-options-request
  [m6411]
  (clojure.core/let
   [bean6410
    (new com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest)]
   (clojure.core/let
    [v6412 (:filters m6411 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6412 :com.palletops.awaze.client-builder/undef)
     (.
      bean6410
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6667] (ec2/filter arg6667))
 v6412))))
   (clojure.core/let
    [v6412
     (:dhcp-options-ids
      m6411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6412 :com.palletops.awaze.client-builder/undef)
     (.
      bean6410
      setDhcpOptionsIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6668] (clojure.core/str arg6668))
 v6412))))
   bean6410))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest}
delete-vpn-connection-request
  [m6414]
  (clojure.core/let
   [bean6413
    (new com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest)]
   (clojure.core/let
    [v6415
     (:vpn-connection-id
      m6414
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6415 :com.palletops.awaze.client-builder/undef)
     (. bean6413 setVpnConnectionId (clojure.core/str v6415))))
   bean6413))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest}
create-vpn-connection-route-request
  [m6417]
  (clojure.core/let
   [bean6416
    (new
     com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest)]
   (clojure.core/let
    [v6418
     (:destination-cidr-block
      m6417
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6418 :com.palletops.awaze.client-builder/undef)
     (. bean6416 setDestinationCidrBlock (clojure.core/str v6418))))
   (clojure.core/let
    [v6418
     (:vpn-connection-id
      m6417
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6418 :com.palletops.awaze.client-builder/undef)
     (. bean6416 setVpnConnectionId (clojure.core/str v6418))))
   bean6416))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateKeyPairRequest}
create-key-pair-request
  [m6420]
  (clojure.core/let
   [bean6419
    (new com.amazonaws.services.ec2.model.CreateKeyPairRequest)]
   (clojure.core/let
    [v6421
     (:key-name m6420 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6421 :com.palletops.awaze.client-builder/undef)
     (. bean6419 setKeyName (clojure.core/str v6421))))
   bean6419))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest}
describe-account-attributes-request
  [m6423]
  (clojure.core/let
   [bean6422
    (new
     com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest)]
   (clojure.core/let
    [v6424
     (:attribute-names
      m6423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6424 :com.palletops.awaze.client-builder/undef)
     (.
      bean6422
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6669] (clojure.core/str arg6669))
 v6424))))
   bean6422))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest}
describe-spot-datafeed-subscription-request
  [m6426]
  (clojure.core/let
   [bean6425
    (new
     com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest)]
   bean6425))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest}
describe-internet-gateways-request
  [m6429]
  (clojure.core/let
   [bean6428
    (new
     com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest)]
   (clojure.core/let
    [v6430 (:filters m6429 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6430 :com.palletops.awaze.client-builder/undef)
     (.
      bean6428
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6670] (ec2/filter arg6670))
 v6430))))
   (clojure.core/let
    [v6430
     (:internet-gateway-ids
      m6429
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6430 :com.palletops.awaze.client-builder/undef)
     (.
      bean6428
      setInternetGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6671] (clojure.core/str arg6671))
 v6430))))
   bean6428))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StartInstancesRequest}
start-instances-request
  [m6432]
  (clojure.core/let
   [bean6431
    (new com.amazonaws.services.ec2.model.StartInstancesRequest)]
   (clojure.core/let
    [v6433
     (:instance-ids m6432 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6433 :com.palletops.awaze.client-builder/undef)
     (.
      bean6431
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6672] (clojure.core/str arg6672))
 v6433))))
   (clojure.core/let
    [v6433
     (:additional-info
      m6432
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6433 :com.palletops.awaze.client-builder/undef)
     (. bean6431 setAdditionalInfo (clojure.core/str v6433))))
   bean6431))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest}
attach-network-interface-request
  [m6435]
  (clojure.core/let
   [bean6434
    (new
     com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest)]
   (clojure.core/let
    [v6436
     (:instance-id m6435 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6436 :com.palletops.awaze.client-builder/undef)
     (. bean6434 setInstanceId (clojure.core/str v6436))))
   (clojure.core/let
    [v6436
     (:device-index m6435 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6436 :com.palletops.awaze.client-builder/undef)
     (. bean6434 setDeviceIndex (clojure.core/int v6436))))
   (clojure.core/let
    [v6436
     (:network-interface-id
      m6435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6436 :com.palletops.awaze.client-builder/undef)
     (. bean6434 setNetworkInterfaceId (clojure.core/str v6436))))
   bean6434))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteRequest}
create-route-request
  [m6438]
  (clojure.core/let
   [bean6437
    (new com.amazonaws.services.ec2.model.CreateRouteRequest)]
   (clojure.core/let
    [v6439
     (:instance-id m6438 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6439 :com.palletops.awaze.client-builder/undef)
     (. bean6437 setInstanceId (clojure.core/str v6439))))
   (clojure.core/let
    [v6439
     (:route-table-id m6438 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6439 :com.palletops.awaze.client-builder/undef)
     (. bean6437 setRouteTableId (clojure.core/str v6439))))
   (clojure.core/let
    [v6439
     (:destination-cidr-block
      m6438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6439 :com.palletops.awaze.client-builder/undef)
     (. bean6437 setDestinationCidrBlock (clojure.core/str v6439))))
   (clojure.core/let
    [v6439
     (:vpc-peering-connection-id
      m6438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6439 :com.palletops.awaze.client-builder/undef)
     (. bean6437 setVpcPeeringConnectionId (clojure.core/str v6439))))
   (clojure.core/let
    [v6439
     (:network-interface-id
      m6438
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6439 :com.palletops.awaze.client-builder/undef)
     (. bean6437 setNetworkInterfaceId (clojure.core/str v6439))))
   (clojure.core/let
    [v6439
     (:gateway-id m6438 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6439 :com.palletops.awaze.client-builder/undef)
     (. bean6437 setGatewayId (clojure.core/str v6439))))
   bean6437))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnmonitorInstancesRequest}
unmonitor-instances-request
  [m6441]
  (clojure.core/let
   [bean6440
    (new com.amazonaws.services.ec2.model.UnmonitorInstancesRequest)]
   (clojure.core/let
    [v6442
     (:instance-ids m6441 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6442 :com.palletops.awaze.client-builder/undef)
     (.
      bean6440
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6673] (clojure.core/str arg6673))
 v6442))))
   bean6440))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest}
delete-network-interface-request
  [m6444]
  (clojure.core/let
   [bean6443
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest)]
   (clojure.core/let
    [v6445
     (:network-interface-id
      m6444
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6445 :com.palletops.awaze.client-builder/undef)
     (. bean6443 setNetworkInterfaceId (clojure.core/str v6445))))
   bean6443))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.MonitorInstancesRequest}
monitor-instances-request
  [m6447]
  (clojure.core/let
   [bean6446
    (new com.amazonaws.services.ec2.model.MonitorInstancesRequest)]
   (clojure.core/let
    [v6448
     (:instance-ids m6447 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6448 :com.palletops.awaze.client-builder/undef)
     (.
      bean6446
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6674] (clojure.core/str arg6674))
 v6448))))
   bean6446))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest}
describe-reserved-instances-listings-request
  [m6450]
  (clojure.core/let
   [bean6449
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest)]
   (clojure.core/let
    [v6451 (:filters m6450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6451 :com.palletops.awaze.client-builder/undef)
     (.
      bean6449
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6675] (ec2/filter arg6675))
 v6451))))
   (clojure.core/let
    [v6451
     (:reserved-instances-id
      m6450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6451 :com.palletops.awaze.client-builder/undef)
     (. bean6449 setReservedInstancesId (clojure.core/str v6451))))
   (clojure.core/let
    [v6451
     (:reserved-instances-listing-id
      m6450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6451 :com.palletops.awaze.client-builder/undef)
     (.
      bean6449
      setReservedInstancesListingId
      (clojure.core/str v6451))))
   bean6449))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateTagsRequest}
create-tags-request
  [m6453]
  (clojure.core/let
   [bean6452 (new com.amazonaws.services.ec2.model.CreateTagsRequest)]
   (clojure.core/let
    [v6454 (:tags m6453 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6454 :com.palletops.awaze.client-builder/undef)
     (.
      bean6452
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg6676] (ec2/tag arg6676)) v6454))))
   (clojure.core/let
    [v6454
     (:resources m6453 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6454 :com.palletops.awaze.client-builder/undef)
     (.
      bean6452
      setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6677] (clojure.core/str arg6677))
 v6454))))
   bean6452))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest}
confirm-product-instance-request
  [m6456]
  (clojure.core/let
   [bean6455
    (new
     com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest)]
   (clojure.core/let
    [v6457
     (:instance-id m6456 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6457 :com.palletops.awaze.client-builder/undef)
     (. bean6455 setInstanceId (clojure.core/str v6457))))
   (clojure.core/let
    [v6457
     (:product-code m6456 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6457 :com.palletops.awaze.client-builder/undef)
     (. bean6455 setProductCode (clojure.core/str v6457))))
   bean6455))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateRouteTableRequest}
disassociate-route-table-request
  [m6459]
  (clojure.core/let
   [bean6458
    (new
     com.amazonaws.services.ec2.model.DisassociateRouteTableRequest)]
   (clojure.core/let
    [v6460
     (:association-id m6459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6460 :com.palletops.awaze.client-builder/undef)
     (. bean6458 setAssociationId (clojure.core/str v6460))))
   bean6458))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateAddressRequest}
disassociate-address-request
  [m6462]
  (clojure.core/let
   [bean6461
    (new com.amazonaws.services.ec2.model.DisassociateAddressRequest)]
   (clojure.core/let
    [v6463
     (:public-ip m6462 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6463 :com.palletops.awaze.client-builder/undef)
     (. bean6461 setPublicIp (clojure.core/str v6463))))
   (clojure.core/let
    [v6463
     (:association-id m6462 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6463 :com.palletops.awaze.client-builder/undef)
     (. bean6461 setAssociationId (clojure.core/str v6463))))
   bean6461))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest}
detach-network-interface-request
  [m6465]
  (clojure.core/let
   [bean6464
    (new
     com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest)]
   (clojure.core/let
    [v6466
     (:attachment-id m6465 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6466 :com.palletops.awaze.client-builder/undef)
     (. bean6464 setAttachmentId (clojure.core/str v6466))))
   (clojure.core/let
    [v6466 (:force m6465 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6466 :com.palletops.awaze.client-builder/undef)
     (. bean6464 setForce (clojure.core/boolean v6466))))
   bean6464))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeExportTasksRequest}
describe-export-tasks-request
  [m6468]
  (clojure.core/let
   [bean6467
    (new com.amazonaws.services.ec2.model.DescribeExportTasksRequest)]
   (clojure.core/let
    [v6469
     (:export-task-ids
      m6468
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6469 :com.palletops.awaze.client-builder/undef)
     (.
      bean6467
      setExportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6678] (clojure.core/str arg6678))
 v6469))))
   bean6467))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAddressesRequest}
describe-addresses-request
  [m6471]
  (clojure.core/let
   [bean6470
    (new com.amazonaws.services.ec2.model.DescribeAddressesRequest)]
   (clojure.core/let
    [v6472 (:filters m6471 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6472 :com.palletops.awaze.client-builder/undef)
     (.
      bean6470
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6679] (ec2/filter arg6679))
 v6472))))
   (clojure.core/let
    [v6472
     (:public-ips m6471 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6472 :com.palletops.awaze.client-builder/undef)
     (.
      bean6470
      setPublicIps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6680] (clojure.core/str arg6680))
 v6472))))
   (clojure.core/let
    [v6472
     (:allocation-ids m6471 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6472 :com.palletops.awaze.client-builder/undef)
     (.
      bean6470
      setAllocationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6681] (clojure.core/str arg6681))
 v6472))))
   bean6470))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest}
create-instance-export-task-request
  [m6474]
  (clojure.core/let
   [bean6473
    (new
     com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest)]
   (clojure.core/let
    [v6475
     (:instance-id m6474 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6475 :com.palletops.awaze.client-builder/undef)
     (. bean6473 setInstanceId (clojure.core/str v6475))))
   (clojure.core/let
    [v6475
     (:description m6474 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6475 :com.palletops.awaze.client-builder/undef)
     (. bean6473 setDescription (clojure.core/str v6475))))
   (clojure.core/let
    [v6475
     (:target-environment
      m6474
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6475 :com.palletops.awaze.client-builder/undef)
     (. bean6473 setTargetEnvironment (clojure.core/str v6475))))
   (clojure.core/let
    [v6475
     (:export-to-s3task
      m6474
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6475 :com.palletops.awaze.client-builder/undef)
     (.
      bean6473
      setExportToS3Task
      (ec2/export-to-s3task-specification v6475))))
   bean6473))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateImageRequest}
create-image-request
  [m6477]
  (clojure.core/let
   [bean6476
    (new com.amazonaws.services.ec2.model.CreateImageRequest)]
   (clojure.core/let
    [v6478 (:name m6477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6478 :com.palletops.awaze.client-builder/undef)
     (. bean6476 setName (clojure.core/str v6478))))
   (clojure.core/let
    [v6478
     (:instance-id m6477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6478 :com.palletops.awaze.client-builder/undef)
     (. bean6476 setInstanceId (clojure.core/str v6478))))
   (clojure.core/let
    [v6478
     (:no-reboot m6477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6478 :com.palletops.awaze.client-builder/undef)
     (. bean6476 setNoReboot (clojure.core/boolean v6478))))
   (clojure.core/let
    [v6478
     (:block-device-mappings
      m6477
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6478 :com.palletops.awaze.client-builder/undef)
     (.
      bean6476
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6682] (ec2/block-device-mapping arg6682))
 v6478))))
   (clojure.core/let
    [v6478
     (:description m6477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6478 :com.palletops.awaze.client-builder/undef)
     (. bean6476 setDescription (clojure.core/str v6478))))
   bean6476))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSecurityGroupRequest}
create-security-group-request
  [m6480]
  (clojure.core/let
   [bean6479
    (new com.amazonaws.services.ec2.model.CreateSecurityGroupRequest)]
   (clojure.core/let
    [v6481
     (:description m6480 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6481 :com.palletops.awaze.client-builder/undef)
     (. bean6479 setDescription (clojure.core/str v6481))))
   (clojure.core/let
    [v6481 (:vpc-id m6480 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6481 :com.palletops.awaze.client-builder/undef)
     (. bean6479 setVpcId (clojure.core/str v6481))))
   (clojure.core/let
    [v6481
     (:group-name m6480 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6481 :com.palletops.awaze.client-builder/undef)
     (. bean6479 setGroupName (clojure.core/str v6481))))
   bean6479))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSubnetRequest}
create-subnet-request
  [m6483]
  (clojure.core/let
   [bean6482
    (new com.amazonaws.services.ec2.model.CreateSubnetRequest)]
   (clojure.core/let
    [v6484
     (:cidr-block m6483 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6484 :com.palletops.awaze.client-builder/undef)
     (. bean6482 setCidrBlock (clojure.core/str v6484))))
   (clojure.core/let
    [v6484
     (:availability-zone
      m6483
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6484 :com.palletops.awaze.client-builder/undef)
     (. bean6482 setAvailabilityZone (clojure.core/str v6484))))
   (clojure.core/let
    [v6484 (:vpc-id m6483 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6484 :com.palletops.awaze.client-builder/undef)
     (. bean6482 setVpcId (clojure.core/str v6484))))
   bean6482))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclRequest}
delete-network-acl-request
  [m6486]
  (clojure.core/let
   [bean6485
    (new com.amazonaws.services.ec2.model.DeleteNetworkAclRequest)]
   (clojure.core/let
    [v6487
     (:network-acl-id m6486 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6487 :com.palletops.awaze.client-builder/undef)
     (. bean6485 setNetworkAclId (clojure.core/str v6487))))
   bean6485))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest}
create-network-interface-request
  [m6489]
  (clojure.core/let
   [bean6488
    (new
     com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest)]
   (clojure.core/let
    [v6490
     (:subnet-id m6489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6490 :com.palletops.awaze.client-builder/undef)
     (. bean6488 setSubnetId (clojure.core/str v6490))))
   (clojure.core/let
    [v6490
     (:private-ip-address
      m6489
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6490 :com.palletops.awaze.client-builder/undef)
     (. bean6488 setPrivateIpAddress (clojure.core/str v6490))))
   (clojure.core/let
    [v6490 (:groups m6489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6490 :com.palletops.awaze.client-builder/undef)
     (.
      bean6488
      setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6683] (clojure.core/str arg6683))
 v6490))))
   (clojure.core/let
    [v6490
     (:private-ip-addresses
      m6489
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6490 :com.palletops.awaze.client-builder/undef)
     (.
      bean6488
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6684]
  (ec2/private-ip-address-specification arg6684))
 v6490))))
   (clojure.core/let
    [v6490
     (:secondary-private-ip-address-count
      m6489
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6490 :com.palletops.awaze.client-builder/undef)
     (.
      bean6488
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v6490))))
   (clojure.core/let
    [v6490
     (:description m6489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6490 :com.palletops.awaze.client-builder/undef)
     (. bean6488 setDescription (clojure.core/str v6490))))
   bean6488))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest}
delete-vpn-gateway-request
  [m6492]
  (clojure.core/let
   [bean6491
    (new com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest)]
   (clojure.core/let
    [v6493
     (:vpn-gateway-id m6492 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6493 :com.palletops.awaze.client-builder/undef)
     (. bean6491 setVpnGatewayId (clojure.core/str v6493))))
   bean6491))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVolumeRequest}
attach-volume-request
  [m6495]
  (clojure.core/let
   [bean6494
    (new com.amazonaws.services.ec2.model.AttachVolumeRequest)]
   (clojure.core/let
    [v6496
     (:instance-id m6495 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6496 :com.palletops.awaze.client-builder/undef)
     (. bean6494 setInstanceId (clojure.core/str v6496))))
   (clojure.core/let
    [v6496
     (:volume-id m6495 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6496 :com.palletops.awaze.client-builder/undef)
     (. bean6494 setVolumeId (clojure.core/str v6496))))
   (clojure.core/let
    [v6496 (:device m6495 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6496 :com.palletops.awaze.client-builder/undef)
     (. bean6494 setDevice (clojure.core/str v6496))))
   bean6494))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRequest}
create-vpn-connection-request
  [m6498]
  (clojure.core/let
   [bean6497
    (new com.amazonaws.services.ec2.model.CreateVpnConnectionRequest)]
   (clojure.core/let
    [v6499 (:options m6498 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6499 :com.palletops.awaze.client-builder/undef)
     (.
      bean6497
      setOptions
      (ec2/vpn-connection-options-specification v6499))))
   (clojure.core/let
    [v6499
     (:customer-gateway-id
      m6498
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6499 :com.palletops.awaze.client-builder/undef)
     (. bean6497 setCustomerGatewayId (clojure.core/str v6499))))
   (clojure.core/let
    [v6499 (:type m6498 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6499 :com.palletops.awaze.client-builder/undef)
     (. bean6497 setType (clojure.core/str v6499))))
   (clojure.core/let
    [v6499
     (:vpn-gateway-id m6498 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6499 :com.palletops.awaze.client-builder/undef)
     (. bean6497 setVpnGatewayId (clojure.core/str v6499))))
   bean6497))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeletePlacementGroupRequest}
delete-placement-group-request
  [m6501]
  (clojure.core/let
   [bean6500
    (new com.amazonaws.services.ec2.model.DeletePlacementGroupRequest)]
   (clojure.core/let
    [v6502
     (:group-name m6501 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6502 :com.palletops.awaze.client-builder/undef)
     (. bean6500 setGroupName (clojure.core/str v6502))))
   bean6500))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest}
reset-instance-attribute-request
  [m6504]
  (clojure.core/let
   [bean6503
    (new
     com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest)]
   (clojure.core/let
    [v6505
     (:instance-id m6504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6505 :com.palletops.awaze.client-builder/undef)
     (. bean6503 setInstanceId (clojure.core/str v6505))))
   (clojure.core/let
    [v6505
     (:attribute m6504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6505 :com.palletops.awaze.client-builder/undef)
     (. bean6503 setAttribute (clojure.core/str v6505))))
   bean6503))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSnapshotRequest}
create-snapshot-request
  [m6507]
  (clojure.core/let
   [bean6506
    (new com.amazonaws.services.ec2.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v6508
     (:description m6507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6508 :com.palletops.awaze.client-builder/undef)
     (. bean6506 setDescription (clojure.core/str v6508))))
   (clojure.core/let
    [v6508
     (:volume-id m6507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6508 :com.palletops.awaze.client-builder/undef)
     (. bean6506 setVolumeId (clojure.core/str v6508))))
   bean6506))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RequestSpotInstancesRequest}
request-spot-instances-request
  [m6510]
  (clojure.core/let
   [bean6509
    (new com.amazonaws.services.ec2.model.RequestSpotInstancesRequest)]
   (clojure.core/let
    [v6511
     (:instance-count m6510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6511 :com.palletops.awaze.client-builder/undef)
     (. bean6509 setInstanceCount (clojure.core/int v6511))))
   (clojure.core/let
    [v6511
     (:launch-specification
      m6510
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6511 :com.palletops.awaze.client-builder/undef)
     (.
      bean6509
      setLaunchSpecification
      (ec2/launch-specification v6511))))
   (clojure.core/let
    [v6511
     (:valid-from m6510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6511 :com.palletops.awaze.client-builder/undef)
     (.
      bean6509
      setValidFrom
      (com.palletops.awaze.common/to-date v6511))))
   (clojure.core/let
    [v6511
     (:valid-until m6510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6511 :com.palletops.awaze.client-builder/undef)
     (.
      bean6509
      setValidUntil
      (com.palletops.awaze.common/to-date v6511))))
   (clojure.core/let
    [v6511
     (:launch-group m6510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6511 :com.palletops.awaze.client-builder/undef)
     (. bean6509 setLaunchGroup (clojure.core/str v6511))))
   (clojure.core/let
    [v6511
     (:availability-zone-group
      m6510
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6511 :com.palletops.awaze.client-builder/undef)
     (. bean6509 setAvailabilityZoneGroup (clojure.core/str v6511))))
   (clojure.core/let
    [v6511 (:type m6510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6511 :com.palletops.awaze.client-builder/undef)
     (. bean6509 setType (clojure.core/str v6511))))
   (clojure.core/let
    [v6511
     (:spot-price m6510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6511 :com.palletops.awaze.client-builder/undef)
     (. bean6509 setSpotPrice (clojure.core/str v6511))))
   bean6509))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest}
describe-network-interfaces-request
  [m6513]
  (clojure.core/let
   [bean6512
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest)]
   (clojure.core/let
    [v6514 (:filters m6513 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6514 :com.palletops.awaze.client-builder/undef)
     (.
      bean6512
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6685] (ec2/filter arg6685))
 v6514))))
   (clojure.core/let
    [v6514
     (:network-interface-ids
      m6513
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6514 :com.palletops.awaze.client-builder/undef)
     (.
      bean6512
      setNetworkInterfaceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6686] (clojure.core/str arg6686))
 v6514))))
   bean6512))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVolumeRequest}
delete-volume-request
  [m6516]
  (clojure.core/let
   [bean6515
    (new com.amazonaws.services.ec2.model.DeleteVolumeRequest)]
   (clojure.core/let
    [v6517
     (:volume-id m6516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6517 :com.palletops.awaze.client-builder/undef)
     (. bean6515 setVolumeId (clojure.core/str v6517))))
   bean6515))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m6519]
  (clojure.core/let
   [bean6518
    (new com.amazonaws.services.ec2.model.DeleteSnapshotRequest)]
   (clojure.core/let
    [v6520
     (:snapshot-id m6519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6520 :com.palletops.awaze.client-builder/undef)
     (. bean6518 setSnapshotId (clojure.core/str v6520))))
   bean6518))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstancesRequest}
describe-instances-request
  [m6522]
  (clojure.core/let
   [bean6521
    (new com.amazonaws.services.ec2.model.DescribeInstancesRequest)]
   (clojure.core/let
    [v6523
     (:instance-ids m6522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6523 :com.palletops.awaze.client-builder/undef)
     (.
      bean6521
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6687] (clojure.core/str arg6687))
 v6523))))
   (clojure.core/let
    [v6523 (:filters m6522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6523 :com.palletops.awaze.client-builder/undef)
     (.
      bean6521
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6688] (ec2/filter arg6688))
 v6523))))
   (clojure.core/let
    [v6523
     (:next-token m6522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6523 :com.palletops.awaze.client-builder/undef)
     (. bean6521 setNextToken (clojure.core/str v6523))))
   (clojure.core/let
    [v6523
     (:max-results m6522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6523 :com.palletops.awaze.client-builder/undef)
     (. bean6521 setMaxResults (clojure.core/int v6523))))
   bean6521))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateRouteTableRequest}
associate-route-table-request
  [m6525]
  (clojure.core/let
   [bean6524
    (new com.amazonaws.services.ec2.model.AssociateRouteTableRequest)]
   (clojure.core/let
    [v6526
     (:route-table-id m6525 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6526 :com.palletops.awaze.client-builder/undef)
     (. bean6524 setRouteTableId (clojure.core/str v6526))))
   (clojure.core/let
    [v6526
     (:subnet-id m6525 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6526 :com.palletops.awaze.client-builder/undef)
     (. bean6524 setSubnetId (clojure.core/str v6526))))
   bean6524))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest}
disable-vgw-route-propagation-request
  [m6528]
  (clojure.core/let
   [bean6527
    (new
     com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest)]
   (clojure.core/let
    [v6529
     (:route-table-id m6528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6529 :com.palletops.awaze.client-builder/undef)
     (. bean6527 setRouteTableId (clojure.core/str v6529))))
   (clojure.core/let
    [v6529
     (:gateway-id m6528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6529 :com.palletops.awaze.client-builder/undef)
     (. bean6527 setGatewayId (clojure.core/str v6529))))
   bean6527))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest}
describe-instance-attribute-request
  [m6531]
  (clojure.core/let
   [bean6530
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest)]
   (clojure.core/let
    [v6532
     (:instance-id m6531 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6532 :com.palletops.awaze.client-builder/undef)
     (. bean6530 setInstanceId (clojure.core/str v6532))))
   (clojure.core/let
    [v6532
     (:attribute m6531 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6532 :com.palletops.awaze.client-builder/undef)
     (. bean6530 setAttribute (clojure.core/str v6532))))
   bean6530))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnGatewayRequest}
create-vpn-gateway-request
  [m6534]
  (clojure.core/let
   [bean6533
    (new com.amazonaws.services.ec2.model.CreateVpnGatewayRequest)]
   (clojure.core/let
    [v6535 (:type m6534 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6535 :com.palletops.awaze.client-builder/undef)
     (. bean6533 setType (clojure.core/str v6535))))
   (clojure.core/let
    [v6535
     (:availability-zone
      m6534
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6535 :com.palletops.awaze.client-builder/undef)
     (. bean6533 setAvailabilityZone (clojure.core/str v6535))))
   bean6533))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclRequest}
create-network-acl-request
  [m6537]
  (clojure.core/let
   [bean6536
    (new com.amazonaws.services.ec2.model.CreateNetworkAclRequest)]
   (clojure.core/let
    [v6538 (:vpc-id m6537 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6538 :com.palletops.awaze.client-builder/undef)
     (. bean6536 setVpcId (clojure.core/str v6538))))
   bean6536))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteRequest}
replace-route-request
  [m6540]
  (clojure.core/let
   [bean6539
    (new com.amazonaws.services.ec2.model.ReplaceRouteRequest)]
   (clojure.core/let
    [v6541
     (:instance-id m6540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6541 :com.palletops.awaze.client-builder/undef)
     (. bean6539 setInstanceId (clojure.core/str v6541))))
   (clojure.core/let
    [v6541
     (:route-table-id m6540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6541 :com.palletops.awaze.client-builder/undef)
     (. bean6539 setRouteTableId (clojure.core/str v6541))))
   (clojure.core/let
    [v6541
     (:destination-cidr-block
      m6540
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6541 :com.palletops.awaze.client-builder/undef)
     (. bean6539 setDestinationCidrBlock (clojure.core/str v6541))))
   (clojure.core/let
    [v6541
     (:vpc-peering-connection-id
      m6540
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6541 :com.palletops.awaze.client-builder/undef)
     (. bean6539 setVpcPeeringConnectionId (clojure.core/str v6541))))
   (clojure.core/let
    [v6541
     (:network-interface-id
      m6540
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6541 :com.palletops.awaze.client-builder/undef)
     (. bean6539 setNetworkInterfaceId (clojure.core/str v6541))))
   (clojure.core/let
    [v6541
     (:gateway-id m6540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6541 :com.palletops.awaze.client-builder/undef)
     (. bean6539 setGatewayId (clojure.core/str v6541))))
   bean6539))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRegionsRequest}
describe-regions-request
  [m6543]
  (clojure.core/let
   [bean6542
    (new com.amazonaws.services.ec2.model.DescribeRegionsRequest)]
   (clojure.core/let
    [v6544 (:filters m6543 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6544 :com.palletops.awaze.client-builder/undef)
     (.
      bean6542
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6689] (ec2/filter arg6689))
 v6544))))
   (clojure.core/let
    [v6544
     (:region-names m6543 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6544 :com.palletops.awaze.client-builder/undef)
     (.
      bean6542
      setRegionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6690] (clojure.core/str arg6690))
 v6544))))
   bean6542))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest}
delete-internet-gateway-request
  [m6546]
  (clojure.core/let
   [bean6545
    (new
     com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest)]
   (clojure.core/let
    [v6547
     (:internet-gateway-id
      m6546
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6547 :com.palletops.awaze.client-builder/undef)
     (. bean6545 setInternetGatewayId (clojure.core/str v6547))))
   bean6545))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteRequest}
delete-route-request
  [m6549]
  (clojure.core/let
   [bean6548
    (new com.amazonaws.services.ec2.model.DeleteRouteRequest)]
   (clojure.core/let
    [v6550
     (:route-table-id m6549 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6550 :com.palletops.awaze.client-builder/undef)
     (. bean6548 setRouteTableId (clojure.core/str v6550))))
   (clojure.core/let
    [v6550
     (:destination-cidr-block
      m6549
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6550 :com.palletops.awaze.client-builder/undef)
     (. bean6548 setDestinationCidrBlock (clojure.core/str v6550))))
   bean6548))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest}
assign-private-ip-addresses-request
  [m6552]
  (clojure.core/let
   [bean6551
    (new
     com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest)]
   (clojure.core/let
    [v6553
     (:private-ip-addresses
      m6552
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6553 :com.palletops.awaze.client-builder/undef)
     (.
      bean6551
      setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6691] (clojure.core/str arg6691))
 v6553))))
   (clojure.core/let
    [v6553
     (:secondary-private-ip-address-count
      m6552
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6553 :com.palletops.awaze.client-builder/undef)
     (.
      bean6551
      setSecondaryPrivateIpAddressCount
      (clojure.core/int v6553))))
   (clojure.core/let
    [v6553
     (:allow-reassignment
      m6552
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6553 :com.palletops.awaze.client-builder/undef)
     (. bean6551 setAllowReassignment (clojure.core/boolean v6553))))
   (clojure.core/let
    [v6553
     (:network-interface-id
      m6552
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6553 :com.palletops.awaze.client-builder/undef)
     (. bean6551 setNetworkInterfaceId (clojure.core/str v6553))))
   bean6551))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest}
delete-dhcp-options-request
  [m6555]
  (clojure.core/let
   [bean6554
    (new com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest)]
   (clojure.core/let
    [v6556
     (:dhcp-options-id
      m6555
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6556 :com.palletops.awaze.client-builder/undef)
     (. bean6554 setDhcpOptionsId (clojure.core/str v6556))))
   bean6554))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest}
cancel-spot-instance-requests-request
  [m6558]
  (clojure.core/let
   [bean6557
    (new
     com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest)]
   (clojure.core/let
    [v6559
     (:spot-instance-request-ids
      m6558
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6559 :com.palletops.awaze.client-builder/undef)
     (.
      bean6557
      setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6692] (clojure.core/str arg6692))
 v6559))))
   bean6557))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest}
create-dhcp-options-request
  [m6561]
  (clojure.core/let
   [bean6560
    (new com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest)]
   (clojure.core/let
    [v6562
     (:dhcp-configurations
      m6561
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6562 :com.palletops.awaze.client-builder/undef)
     (.
      bean6560
      setDhcpConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6693] (ec2/dhcp-configuration arg6693))
 v6562))))
   bean6560))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StopInstancesRequest}
stop-instances-request
  [m6564]
  (clojure.core/let
   [bean6563
    (new com.amazonaws.services.ec2.model.StopInstancesRequest)]
   (clojure.core/let
    [v6565
     (:instance-ids m6564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6565 :com.palletops.awaze.client-builder/undef)
     (.
      bean6563
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6694] (clojure.core/str arg6694))
 v6565))))
   (clojure.core/let
    [v6565 (:force m6564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6565 :com.palletops.awaze.client-builder/undef)
     (. bean6563 setForce (clojure.core/boolean v6565))))
   bean6563))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest}
authorize-security-group-ingress-request
  [m6567]
  (clojure.core/let
   [bean6566
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest)]
   (clojure.core/let
    [v6568
     (:ip-protocol m6567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6568 :com.palletops.awaze.client-builder/undef)
     (. bean6566 setIpProtocol (clojure.core/str v6568))))
   (clojure.core/let
    [v6568
     (:group-name m6567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6568 :com.palletops.awaze.client-builder/undef)
     (. bean6566 setGroupName (clojure.core/str v6568))))
   (clojure.core/let
    [v6568
     (:source-security-group-owner-id
      m6567
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6568 :com.palletops.awaze.client-builder/undef)
     (.
      bean6566
      setSourceSecurityGroupOwnerId
      (clojure.core/str v6568))))
   (clojure.core/let
    [v6568
     (:source-security-group-name
      m6567
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6568 :com.palletops.awaze.client-builder/undef)
     (. bean6566 setSourceSecurityGroupName (clojure.core/str v6568))))
   (clojure.core/let
    [v6568
     (:from-port m6567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6568 :com.palletops.awaze.client-builder/undef)
     (. bean6566 setFromPort (clojure.core/int v6568))))
   (clojure.core/let
    [v6568
     (:group-id m6567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6568 :com.palletops.awaze.client-builder/undef)
     (. bean6566 setGroupId (clojure.core/str v6568))))
   (clojure.core/let
    [v6568
     (:ip-permissions m6567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6568 :com.palletops.awaze.client-builder/undef)
     (.
      bean6566
      setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6695] (ec2/ip-permission arg6695))
 v6568))))
   (clojure.core/let
    [v6568 (:cidr-ip m6567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6568 :com.palletops.awaze.client-builder/undef)
     (. bean6566 setCidrIp (clojure.core/str v6568))))
   (clojure.core/let
    [v6568 (:to-port m6567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6568 :com.palletops.awaze.client-builder/undef)
     (. bean6566 setToPort (clojure.core/int v6568))))
   bean6566))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest}
describe-placement-groups-request
  [m6570]
  (clojure.core/let
   [bean6569
    (new
     com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest)]
   (clojure.core/let
    [v6571 (:filters m6570 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6571 :com.palletops.awaze.client-builder/undef)
     (.
      bean6569
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6696] (ec2/filter arg6696))
 v6571))))
   (clojure.core/let
    [v6571
     (:group-names m6570 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6571 :com.palletops.awaze.client-builder/undef)
     (.
      bean6569
      setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6697] (clojure.core/str arg6697))
 v6571))))
   bean6569))
 (clojure.core/defmulti
  ec2
  (clojure.core/fn ec2 [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   ec2
   :describe-security-groups
   [m6698]
   (clojure.core/let
    [credentials6699 (:credentials m6698) args6700 (:args m6698)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6701
      (com.palletops.awaze.common/aws-client :ec2 credentials6699)]
     (clojure.core/case
      (clojure.core/count args6700)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6701
        describeSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6701
        describeSecurityGroups
        (ec2/describe-security-groups-request
         (clojure.core/nth args6700 0))))))))
  (clojure.core/defn
   describe-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-names
                         group-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeSecurityGroups, describeSecurityGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-security-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-security-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-names
                         group-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeSecurityGroups, describeSecurityGroups"}
   [credentials6703 & args6704]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6705
     (com.palletops.awaze.common/aws-client :ec2 credentials6703)]
    (clojure.core/case
     (clojure.core/count args6704)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6705
       describeSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6705
       describeSecurityGroups
       (ec2/describe-security-groups-request
        (clojure.core/nth args6704 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc
   [m6706]
   (clojure.core/let
    [credentials6707 (:credentials m6706) args6708 (:args m6706)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6709
      (com.palletops.awaze.common/aws-client :ec2 credentials6707)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6709
       createVpc
       (ec2/create-vpc-request (clojure.core/nth args6708 0)))))))
  (clojure.core/defn
   create-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-tenancy
                         general-progress-listener
                         cidr-block]}]]),
    :doc "Generate map for createVpc"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpc,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-vpc
   {:arglists (quote
               [[credentials
                 {:keys [instance-tenancy
                         general-progress-listener
                         cidr-block]}]]),
    :doc "Call createVpc"}
   [credentials6711 & args6712]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6713
     (com.palletops.awaze.common/aws-client :ec2 credentials6711)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6713
      createVpc
      (ec2/create-vpc-request (clojure.core/nth args6712 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :deregister-image
   [m6714]
   (clojure.core/let
    [credentials6715 (:credentials m6714) args6716 (:args m6714)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6717
      (com.palletops.awaze.common/aws-client :ec2 credentials6715)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6717
       deregisterImage
       (ec2/deregister-image-request (clojure.core/nth args6716 0)))))))
  (clojure.core/defn
   deregister-image-map
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener]}]]),
    :doc "Generate map for deregisterImage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :deregister-image,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   deregister-image
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener]}]]),
    :doc "Call deregisterImage"}
   [credentials6719 & args6720]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6721
     (com.palletops.awaze.common/aws-client :ec2 credentials6719)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6721
      deregisterImage
      (ec2/deregister-image-request (clojure.core/nth args6720 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl-entry
   [m6722]
   (clojure.core/let
    [credentials6723 (:credentials m6722) args6724 (:args m6722)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6725
      (com.palletops.awaze.common/aws-client :ec2 credentials6723)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6725
       createNetworkAclEntry
       (ec2/create-network-acl-entry-request
        (clojure.core/nth args6724 0)))))))
  (clojure.core/defn
   create-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         general-progress-listener
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Generate map for createNetworkAclEntry"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-network-acl-entry,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         general-progress-listener
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Call createNetworkAclEntry"}
   [credentials6727 & args6728]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6729
     (com.palletops.awaze.common/aws-client :ec2 credentials6727)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6729
      createNetworkAclEntry
      (ec2/create-network-acl-entry-request
       (clojure.core/nth args6728 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-export-task
   [m6730]
   (clojure.core/let
    [credentials6731 (:credentials m6730) args6732 (:args m6730)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6733
      (com.palletops.awaze.common/aws-client :ec2 credentials6731)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6733
       cancelExportTask
       (ec2/cancel-export-task-request (clojure.core/nth args6732 0)))))))
  (clojure.core/defn
   cancel-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener export-task-id]}]]),
    :doc "Generate map for cancelExportTask"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-export-task,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-export-task
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener export-task-id]}]]),
    :doc "Call cancelExportTask"}
   [credentials6735 & args6736]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6737
     (com.palletops.awaze.common/aws-client :ec2 credentials6735)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6737
      cancelExportTask
      (ec2/cancel-export-task-request (clojure.core/nth args6736 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-ingress
   [m6738]
   (clojure.core/let
    [credentials6739 (:credentials m6738) args6740 (:args m6738)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6741
      (com.palletops.awaze.common/aws-client :ec2 credentials6739)]
     (clojure.core/case
      (clojure.core/count args6740)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6741
        revokeSecurityGroupIngress
        (ec2/revoke-security-group-ingress-request
         (clojure.core/nth args6740 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6741
        revokeSecurityGroupIngress))))))
  (clojure.core/defn
   revoke-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]
                [credentials]]),
    :doc "Generate map for revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :revoke-security-group-ingress,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :revoke-security-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   revoke-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]
                [credentials]]),
    :doc "Call revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   [credentials6743 & args6744]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6745
     (com.palletops.awaze.common/aws-client :ec2 credentials6743)]
    (clojure.core/case
     (clojure.core/count args6744)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6745
       revokeSecurityGroupIngress
       (ec2/revoke-security-group-ingress-request
        (clojure.core/nth args6744 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6745
       revokeSecurityGroupIngress))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-route-tables
   [m6746]
   (clojure.core/let
    [credentials6747 (:credentials m6746) args6748 (:args m6746)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6749
      (com.palletops.awaze.common/aws-client :ec2 credentials6747)]
     (clojure.core/case
      (clojure.core/count args6748)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6749
        describeRouteTables
        (ec2/describe-route-tables-request
         (clojure.core/nth args6748 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6749
        describeRouteTables))))))
  (clojure.core/defn
   describe-route-tables-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeRouteTables, describeRouteTables"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-route-tables,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-route-tables,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-route-tables
   {:arglists (quote
               [[credentials
                 {:keys [route-table-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeRouteTables, describeRouteTables"}
   [credentials6751 & args6752]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6753
     (com.palletops.awaze.common/aws-client :ec2 credentials6751)]
    (clojure.core/case
     (clojure.core/count args6752)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6753
       describeRouteTables
       (ec2/describe-route-tables-request
        (clojure.core/nth args6752 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6753
       describeRouteTables))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-reserved-instances-listing
   [m6754]
   (clojure.core/let
    [credentials6755 (:credentials m6754) args6756 (:args m6754)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6757
      (com.palletops.awaze.common/aws-client :ec2 credentials6755)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6757
       createReservedInstancesListing
       (ec2/create-reserved-instances-listing-request
        (clojure.core/nth args6756 0)))))))
  (clojure.core/defn
   create-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-id
                         price-schedules
                         instance-count
                         general-progress-listener
                         client-token]}]]),
    :doc "Generate map for createReservedInstancesListing"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-reserved-instances-listing,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-id
                         price-schedules
                         instance-count
                         general-progress-listener
                         client-token]}]]),
    :doc "Call createReservedInstancesListing"}
   [credentials6759 & args6760]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6761
     (com.palletops.awaze.common/aws-client :ec2 credentials6759)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6761
      createReservedInstancesListing
      (ec2/create-reserved-instances-listing-request
       (clojure.core/nth args6760 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-image-attribute
   [m6762]
   (clojure.core/let
    [credentials6763 (:credentials m6762) args6764 (:args m6762)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6765
      (com.palletops.awaze.common/aws-client :ec2 credentials6763)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6765
       resetImageAttribute
       (ec2/reset-image-attribute-request
        (clojure.core/nth args6764 0)))))))
  (clojure.core/defn
   reset-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener attribute]}]]),
    :doc "Generate map for resetImageAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-image-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reset-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener attribute]}]]),
    :doc "Call resetImageAttribute"}
   [credentials6767 & args6768]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6769
     (com.palletops.awaze.common/aws-client :ec2 credentials6767)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6769
      resetImageAttribute
      (ec2/reset-image-attribute-request
       (clojure.core/nth args6768 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-availability-zones
   [m6770]
   (clojure.core/let
    [credentials6771 (:credentials m6770) args6772 (:args m6770)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6773
      (com.palletops.awaze.common/aws-client :ec2 credentials6771)]
     (clojure.core/case
      (clojure.core/count args6772)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6773
        describeAvailabilityZones
        (ec2/describe-availability-zones-request
         (clojure.core/nth args6772 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6773
        describeAvailabilityZones))))))
  (clojure.core/defn
   describe-availability-zones-map
   {:arglists (quote
               [[credentials
                 {:keys [zone-names general-progress-listener filters]}]
                [credentials]]),
    :doc "Generate map for describeAvailabilityZones, describeAvailabilityZones"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-availability-zones,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-availability-zones,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-availability-zones
   {:arglists (quote
               [[credentials
                 {:keys [zone-names general-progress-listener filters]}]
                [credentials]]),
    :doc "Call describeAvailabilityZones, describeAvailabilityZones"}
   [credentials6775 & args6776]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6777
     (com.palletops.awaze.common/aws-client :ec2 credentials6775)]
    (clojure.core/case
     (clojure.core/count args6776)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6777
       describeAvailabilityZones
       (ec2/describe-availability-zones-request
        (clojure.core/nth args6776 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6777
       describeAvailabilityZones))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-acls
   [m6778]
   (clojure.core/let
    [credentials6779 (:credentials m6778) args6780 (:args m6778)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6781
      (com.palletops.awaze.common/aws-client :ec2 credentials6779)]
     (clojure.core/case
      (clojure.core/count args6780)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6781
        describeNetworkAcls
        (ec2/describe-network-acls-request
         (clojure.core/nth args6780 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6781
        describeNetworkAcls))))))
  (clojure.core/defn
   describe-network-acls-map
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeNetworkAcls, describeNetworkAcls"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-network-acls,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-network-acls,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-network-acls
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeNetworkAcls, describeNetworkAcls"}
   [credentials6783 & args6784]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6785
     (com.palletops.awaze.common/aws-client :ec2 credentials6783)]
    (clojure.core/case
     (clojure.core/count args6784)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6785
       describeNetworkAcls
       (ec2/describe-network-acls-request
        (clojure.core/nth args6784 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6785
       describeNetworkAcls))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-gateways
   [m6786]
   (clojure.core/let
    [credentials6787 (:credentials m6786) args6788 (:args m6786)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6789
      (com.palletops.awaze.common/aws-client :ec2 credentials6787)]
     (clojure.core/case
      (clojure.core/count args6788)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6789
        describeVpnGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6789
        describeVpnGateways
        (ec2/describe-vpn-gateways-request
         (clojure.core/nth args6788 0))))))))
  (clojure.core/defn
   describe-vpn-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpn-gateway-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeVpnGateways, describeVpnGateways"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpn-gateways,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpn-gateways,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-vpn-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpn-gateway-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeVpnGateways, describeVpnGateways"}
   [credentials6791 & args6792]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6793
     (com.palletops.awaze.common/aws-client :ec2 credentials6791)]
    (clojure.core/case
     (clojure.core/count args6792)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6793
       describeVpnGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6793
       describeVpnGateways
       (ec2/describe-vpn-gateways-request
        (clojure.core/nth args6792 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshots
   [m6794]
   (clojure.core/let
    [credentials6795 (:credentials m6794) args6796 (:args m6794)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6797
      (com.palletops.awaze.common/aws-client :ec2 credentials6795)]
     (clojure.core/case
      (clojure.core/count args6796)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6797
        describeSnapshots
        (ec2/describe-snapshots-request (clojure.core/nth args6796 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6797
        describeSnapshots))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [restorable-by-user-ids
                         owner-ids
                         snapshot-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-snapshots,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-snapshots,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials
                 {:keys [restorable-by-user-ids
                         owner-ids
                         snapshot-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials6799 & args6800]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6801
     (com.palletops.awaze.common/aws-client :ec2 credentials6799)]
    (clojure.core/case
     (clojure.core/count args6800)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6801
       describeSnapshots
       (ec2/describe-snapshots-request (clojure.core/nth args6800 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6801
       describeSnapshots))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-image-attribute
   [m6802]
   (clojure.core/let
    [credentials6803 (:credentials m6802) args6804 (:args m6802)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6805
      (com.palletops.awaze.common/aws-client :ec2 credentials6803)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6805
       modifyImageAttribute
       (ec2/modify-image-attribute-request
        (clojure.core/nth args6804 0)))))))
  (clojure.core/defn
   modify-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [user-groups
                         launch-permission
                         general-progress-listener
                         user-ids
                         operation-type
                         attribute
                         image-id
                         product-codes
                         value
                         description]}]]),
    :doc "Generate map for modifyImageAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-image-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [user-groups
                         launch-permission
                         general-progress-listener
                         user-ids
                         operation-type
                         attribute
                         image-id
                         product-codes
                         value
                         description]}]]),
    :doc "Call modifyImageAttribute"}
   [credentials6807 & args6808]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6809
     (com.palletops.awaze.common/aws-client :ec2 credentials6807)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6809
      modifyImageAttribute
      (ec2/modify-image-attribute-request
       (clojure.core/nth args6808 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volumes
   [m6810]
   (clojure.core/let
    [credentials6811 (:credentials m6810) args6812 (:args m6810)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6813
      (com.palletops.awaze.common/aws-client :ec2 credentials6811)]
     (clojure.core/case
      (clojure.core/count args6812)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6813
        describeVolumes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6813
        describeVolumes
        (ec2/describe-volumes-request (clojure.core/nth args6812 0))))))))
  (clojure.core/defn
   describe-volumes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [volume-ids general-progress-listener filters]}]]),
    :doc "Generate map for describeVolumes, describeVolumes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-volumes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-volumes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-volumes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [volume-ids general-progress-listener filters]}]]),
    :doc "Call describeVolumes, describeVolumes"}
   [credentials6815 & args6816]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6817
     (com.palletops.awaze.common/aws-client :ec2 credentials6815)]
    (clojure.core/case
     (clojure.core/count args6816)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6817
       describeVolumes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6817
       describeVolumes
       (ec2/describe-volumes-request (clojure.core/nth args6816 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-internet-gateway
   [m6818]
   (clojure.core/let
    [credentials6819 (:credentials m6818) args6820 (:args m6818)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6821
      (com.palletops.awaze.common/aws-client :ec2 credentials6819)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6821
       attachInternetGateway
       (ec2/attach-internet-gateway-request
        (clojure.core/nth args6820 0)))))))
  (clojure.core/defn
   attach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Generate map for attachInternetGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-internet-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   attach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Call attachInternetGateway"}
   [credentials6823 & args6824]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6825
     (com.palletops.awaze.common/aws-client :ec2 credentials6823)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6825
      attachInternetGateway
      (ec2/attach-internet-gateway-request
       (clojure.core/nth args6824 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-security-group
   [m6826]
   (clojure.core/let
    [credentials6827 (:credentials m6826) args6828 (:args m6826)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6829
      (com.palletops.awaze.common/aws-client :ec2 credentials6827)]
     (clojure.core/case
      (clojure.core/count args6828)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6829
        deleteSecurityGroup))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6829
        deleteSecurityGroup
        (ec2/delete-security-group-request
         (clojure.core/nth args6828 0))))))))
  (clojure.core/defn
   delete-security-group-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-name
                         group-id
                         general-progress-listener]}]]),
    :doc "Generate map for deleteSecurityGroup, deleteSecurityGroup"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :delete-security-group,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-security-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-security-group
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-name
                         group-id
                         general-progress-listener]}]]),
    :doc "Call deleteSecurityGroup, deleteSecurityGroup"}
   [credentials6831 & args6832]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6833
     (com.palletops.awaze.common/aws-client :ec2 credentials6831)]
    (clojure.core/case
     (clojure.core/count args6832)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6833
       deleteSecurityGroup))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6833
       deleteSecurityGroup
       (ec2/delete-security-group-request
        (clojure.core/nth args6832 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-volume
   [m6834]
   (clojure.core/let
    [credentials6835 (:credentials m6834) args6836 (:args m6834)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6837
      (com.palletops.awaze.common/aws-client :ec2 credentials6835)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6837
       detachVolume
       (ec2/detach-volume-request (clojure.core/nth args6836 0)))))))
  (clojure.core/defn
   detach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         force
                         device
                         general-progress-listener
                         instance-id]}]]),
    :doc "Generate map for detachVolume"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-volume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   detach-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         force
                         device
                         general-progress-listener
                         instance-id]}]]),
    :doc "Call detachVolume"}
   [credentials6839 & args6840]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6841
     (com.palletops.awaze.common/aws-client :ec2 credentials6839)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6841
      detachVolume
      (ec2/detach-volume-request (clojure.core/nth args6840 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :release-address
   [m6842]
   (clojure.core/let
    [credentials6843 (:credentials m6842) args6844 (:args m6842)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6845
      (com.palletops.awaze.common/aws-client :ec2 credentials6843)]
     (clojure.core/case
      (clojure.core/count args6844)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6845
        releaseAddress))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6845
        releaseAddress
        (ec2/release-address-request (clojure.core/nth args6844 0))))))))
  (clojure.core/defn
   release-address-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [public-ip
                         general-progress-listener
                         allocation-id]}]]),
    :doc "Generate map for releaseAddress, releaseAddress"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :release-address,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :release-address,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   release-address
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [public-ip
                         general-progress-listener
                         allocation-id]}]]),
    :doc "Call releaseAddress, releaseAddress"}
   [credentials6847 & args6848]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6849
     (com.palletops.awaze.common/aws-client :ec2 credentials6847)]
    (clojure.core/case
     (clojure.core/count args6848)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6849
       releaseAddress))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6849
       releaseAddress
       (ec2/release-address-request (clojure.core/nth args6848 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-volume
   [m6850]
   (clojure.core/let
    [credentials6851 (:credentials m6850) args6852 (:args m6850)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6853
      (com.palletops.awaze.common/aws-client :ec2 credentials6851)]
     (clojure.core/case
      (clojure.core/count args6852)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6853
        importVolume
        (ec2/import-volume-request (clojure.core/nth args6852 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6853
        importVolume))))))
  (clojure.core/defn
   import-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume
                         availability-zone
                         description
                         image
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for importVolume, importVolume"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :import-volume,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :import-volume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   import-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume
                         availability-zone
                         description
                         image
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call importVolume, importVolume"}
   [credentials6855 & args6856]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6857
     (com.palletops.awaze.common/aws-client :ec2 credentials6855)]
    (clojure.core/case
     (clojure.core/count args6856)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6857
       importVolume
       (ec2/import-volume-request (clojure.core/nth args6856 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6857
       importVolume))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route-table
   [m6858]
   (clojure.core/let
    [credentials6859 (:credentials m6858) args6860 (:args m6858)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6861
      (com.palletops.awaze.common/aws-client :ec2 credentials6859)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6861
       deleteRouteTable
       (ec2/delete-route-table-request (clojure.core/nth args6860 0)))))))
  (clojure.core/defn
   delete-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id general-progress-listener]}]]),
    :doc "Generate map for deleteRouteTable"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-route-table,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-route-table
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id general-progress-listener]}]]),
    :doc "Call deleteRouteTable"}
   [credentials6863 & args6864]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6865
     (com.palletops.awaze.common/aws-client :ec2 credentials6863)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6865
      deleteRouteTable
      (ec2/delete-route-table-request (clojure.core/nth args6864 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshot-attribute
   [m6866]
   (clojure.core/let
    [credentials6867 (:credentials m6866) args6868 (:args m6866)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6869
      (com.palletops.awaze.common/aws-client :ec2 credentials6867)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6869
       describeSnapshotAttribute
       (ec2/describe-snapshot-attribute-request
        (clojure.core/nth args6868 0)))))))
  (clojure.core/defn
   describe-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Generate map for describeSnapshotAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-snapshot-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Call describeSnapshotAttribute"}
   [credentials6871 & args6872]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6873
     (com.palletops.awaze.common/aws-client :ec2 credentials6871)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6873
      describeSnapshotAttribute
      (ec2/describe-snapshot-attribute-request
       (clojure.core/nth args6872 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-status
   [m6874]
   (clojure.core/let
    [credentials6875 (:credentials m6874) args6876 (:args m6874)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6877
      (com.palletops.awaze.common/aws-client :ec2 credentials6875)]
     (clojure.core/case
      (clojure.core/count args6876)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6877
        describeInstanceStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6877
        describeInstanceStatus
        (ec2/describe-instance-status-request
         (clojure.core/nth args6876 0))))))))
  (clojure.core/defn
   describe-instance-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         max-results
                         include-all-instances
                         instance-ids
                         next-token]}]]),
    :doc "Generate map for describeInstanceStatus, describeInstanceStatus"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-instance-status,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-instance-status,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-instance-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         max-results
                         include-all-instances
                         instance-ids
                         next-token]}]]),
    :doc "Call describeInstanceStatus, describeInstanceStatus"}
   [credentials6879 & args6880]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6881
     (com.palletops.awaze.common/aws-client :ec2 credentials6879)]
    (clojure.core/case
     (clojure.core/count args6880)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6881
       describeInstanceStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6881
       describeInstanceStatus
       (ec2/describe-instance-status-request
        (clojure.core/nth args6880 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-image-attribute
   [m6882]
   (clojure.core/let
    [credentials6883 (:credentials m6882) args6884 (:args m6882)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6885
      (com.palletops.awaze.common/aws-client :ec2 credentials6883)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6885
       describeImageAttribute
       (ec2/describe-image-attribute-request
        (clojure.core/nth args6884 0)))))))
  (clojure.core/defn
   describe-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener attribute]}]]),
    :doc "Generate map for describeImageAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-image-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener attribute]}]]),
    :doc "Call describeImageAttribute"}
   [credentials6887 & args6888]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6889
     (com.palletops.awaze.common/aws-client :ec2 credentials6887)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6889
      describeImageAttribute
      (ec2/describe-image-attribute-request
       (clojure.core/nth args6888 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :report-instance-status
   [m6890]
   (clojure.core/let
    [credentials6891 (:credentials m6890) args6892 (:args m6890)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6893
      (com.palletops.awaze.common/aws-client :ec2 credentials6891)]
     (clojure.core/case
      (clojure.core/count args6892)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6893
        reportInstanceStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6893
        reportInstanceStatus
        (ec2/report-instance-status-request
         (clojure.core/nth args6892 0))))))))
  (clojure.core/defn
   report-instance-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         status
                         general-progress-listener
                         reason-codes
                         start-time
                         description
                         instances]}]]),
    :doc "Generate map for reportInstanceStatus, reportInstanceStatus"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :report-instance-status,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :report-instance-status,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   report-instance-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         status
                         general-progress-listener
                         reason-codes
                         start-time
                         description
                         instances]}]]),
    :doc "Call reportInstanceStatus, reportInstanceStatus"}
   [credentials6895 & args6896]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6897
     (com.palletops.awaze.common/aws-client :ec2 credentials6895)]
    (clojure.core/case
     (clojure.core/count args6896)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6897
       reportInstanceStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6897
       reportInstanceStatus
       (ec2/report-instance-status-request
        (clojure.core/nth args6896 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-tags
   [m6898]
   (clojure.core/let
    [credentials6899 (:credentials m6898) args6900 (:args m6898)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6901
      (com.palletops.awaze.common/aws-client :ec2 credentials6899)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6901
       deleteTags
       (ec2/delete-tags-request (clojure.core/nth args6900 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags resources general-progress-listener]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags resources general-progress-listener]}]]),
    :doc "Call deleteTags"}
   [credentials6903 & args6904]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6905
     (com.palletops.awaze.common/aws-client :ec2 credentials6903)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6905
      deleteTags
      (ec2/delete-tags-request (clojure.core/nth args6904 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-snapshot-attribute
   [m6906]
   (clojure.core/let
    [credentials6907 (:credentials m6906) args6908 (:args m6906)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6909
      (com.palletops.awaze.common/aws-client :ec2 credentials6907)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6909
       resetSnapshotAttribute
       (ec2/reset-snapshot-attribute-request
        (clojure.core/nth args6908 0)))))))
  (clojure.core/defn
   reset-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Generate map for resetSnapshotAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-snapshot-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reset-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Call resetSnapshotAttribute"}
   [credentials6911 & args6912]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6913
     (com.palletops.awaze.common/aws-client :ec2 credentials6911)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6913
      resetSnapshotAttribute
      (ec2/reset-snapshot-attribute-request
       (clojure.core/nth args6912 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-dhcp-options
   [m6914]
   (clojure.core/let
    [credentials6915 (:credentials m6914) args6916 (:args m6914)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6917
      (com.palletops.awaze.common/aws-client :ec2 credentials6915)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6917
       associateDhcpOptions
       (ec2/associate-dhcp-options-request
        (clojure.core/nth args6916 0)))))))
  (clojure.core/defn
   associate-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         dhcp-options-id]}]]),
    :doc "Generate map for associateDhcpOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :associate-dhcp-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   associate-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         dhcp-options-id]}]]),
    :doc "Call associateDhcpOptions"}
   [credentials6919 & args6920]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6921
     (com.palletops.awaze.common/aws-client :ec2 credentials6919)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6921
      associateDhcpOptions
      (ec2/associate-dhcp-options-request
       (clojure.core/nth args6920 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-snapshot-attribute
   [m6922]
   (clojure.core/let
    [credentials6923 (:credentials m6922) args6924 (:args m6922)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6925
      (com.palletops.awaze.common/aws-client :ec2 credentials6923)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6925
       modifySnapshotAttribute
       (ec2/modify-snapshot-attribute-request
        (clojure.core/nth args6924 0)))))))
  (clojure.core/defn
   modify-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         group-names
                         snapshot-id
                         user-ids
                         operation-type
                         attribute
                         create-volume-permission]}]]),
    :doc "Generate map for modifySnapshotAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-snapshot-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         group-names
                         snapshot-id
                         user-ids
                         operation-type
                         attribute
                         create-volume-permission]}]]),
    :doc "Call modifySnapshotAttribute"}
   [credentials6927 & args6928]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6929
     (com.palletops.awaze.common/aws-client :ec2 credentials6927)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6929
      modifySnapshotAttribute
      (ec2/modify-snapshot-attribute-request
       (clojure.core/nth args6928 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-volume-attribute
   [m6930]
   (clojure.core/let
    [credentials6931 (:credentials m6930) args6932 (:args m6930)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6933
      (com.palletops.awaze.common/aws-client :ec2 credentials6931)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6933
       modifyVolumeAttribute
       (ec2/modify-volume-attribute-request
        (clojure.core/nth args6932 0)))))))
  (clojure.core/defn
   modify-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         auto-enable-io]}]]),
    :doc "Generate map for modifyVolumeAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-volume-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         auto-enable-io]}]]),
    :doc "Call modifyVolumeAttribute"}
   [credentials6935 & args6936]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6937
     (com.palletops.awaze.common/aws-client :ec2 credentials6935)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6937
      modifyVolumeAttribute
      (ec2/modify-volume-attribute-request
       (clojure.core/nth args6936 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-placement-group
   [m6938]
   (clojure.core/let
    [credentials6939 (:credentials m6938) args6940 (:args m6938)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6941
      (com.palletops.awaze.common/aws-client :ec2 credentials6939)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6941
       createPlacementGroup
       (ec2/create-placement-group-request
        (clojure.core/nth args6940 0)))))))
  (clojure.core/defn
   create-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [strategy
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for createPlacementGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-placement-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [strategy
                         group-name
                         general-progress-listener]}]]),
    :doc "Call createPlacementGroup"}
   [credentials6943 & args6944]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6945
     (com.palletops.awaze.common/aws-client :ec2 credentials6943)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6945
      createPlacementGroup
      (ec2/create-placement-group-request
       (clojure.core/nth args6944 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-connections
   [m6946]
   (clojure.core/let
    [credentials6947 (:credentials m6946) args6948 (:args m6946)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6949
      (com.palletops.awaze.common/aws-client :ec2 credentials6947)]
     (clojure.core/case
      (clojure.core/count args6948)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6949
        describeVpnConnections))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6949
        describeVpnConnections
        (ec2/describe-vpn-connections-request
         (clojure.core/nth args6948 0))))))))
  (clojure.core/defn
   describe-vpn-connections-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpn-connection-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeVpnConnections, describeVpnConnections"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpn-connections,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpn-connections,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-vpn-connections
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpn-connection-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeVpnConnections, describeVpnConnections"}
   [credentials6951 & args6952]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6953
     (com.palletops.awaze.common/aws-client :ec2 credentials6951)]
    (clojure.core/case
     (clojure.core/count args6952)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6953
       describeVpnConnections))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6953
       describeVpnConnections
       (ec2/describe-vpn-connections-request
        (clojure.core/nth args6952 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-price-history
   [m6954]
   (clojure.core/let
    [credentials6955 (:credentials m6954) args6956 (:args m6954)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6957
      (com.palletops.awaze.common/aws-client :ec2 credentials6955)]
     (clojure.core/case
      (clojure.core/count args6956)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6957
        describeSpotPriceHistory
        (ec2/describe-spot-price-history-request
         (clojure.core/nth args6956 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6957
        describeSpotPriceHistory))))))
  (clojure.core/defn
   describe-spot-price-history-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         instance-types
                         product-descriptions
                         general-progress-listener
                         filters
                         availability-zone
                         max-results
                         start-time
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeSpotPriceHistory, describeSpotPriceHistory"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-spot-price-history,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-spot-price-history,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-spot-price-history
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         instance-types
                         product-descriptions
                         general-progress-listener
                         filters
                         availability-zone
                         max-results
                         start-time
                         next-token]}]
                [credentials]]),
    :doc "Call describeSpotPriceHistory, describeSpotPriceHistory"}
   [credentials6959 & args6960]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6961
     (com.palletops.awaze.common/aws-client :ec2 credentials6959)]
    (clojure.core/case
     (clojure.core/count args6960)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6961
       describeSpotPriceHistory
       (ec2/describe-spot-price-history-request
        (clojure.core/nth args6960 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6961
       describeSpotPriceHistory))))))
 (do
  (clojure.core/defmethod
   ec2
   :reject-vpc-peering-connection
   [m6962]
   (clojure.core/let
    [credentials6963 (:credentials m6962) args6964 (:args m6962)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6965
      (com.palletops.awaze.common/aws-client :ec2 credentials6963)]
     (clojure.core/case
      (clojure.core/count args6964)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6965
        rejectVpcPeeringConnection
        (ec2/reject-vpc-peering-connection-request
         (clojure.core/nth args6964 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6965
        rejectVpcPeeringConnection))))))
  (clojure.core/defn
   reject-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for rejectVpcPeeringConnection, rejectVpcPeeringConnection"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :reject-vpc-peering-connection,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reject-vpc-peering-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reject-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call rejectVpcPeeringConnection, rejectVpcPeeringConnection"}
   [credentials6967 & args6968]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6969
     (com.palletops.awaze.common/aws-client :ec2 credentials6967)]
    (clojure.core/case
     (clojure.core/count args6968)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6969
       rejectVpcPeeringConnection
       (ec2/reject-vpc-peering-connection-request
        (clojure.core/nth args6968 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6969
       rejectVpcPeeringConnection))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc
   [m6970]
   (clojure.core/let
    [credentials6971 (:credentials m6970) args6972 (:args m6970)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6973
      (com.palletops.awaze.common/aws-client :ec2 credentials6971)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6973
       deleteVpc
       (ec2/delete-vpc-request (clojure.core/nth args6972 0)))))))
  (clojure.core/defn
   delete-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Generate map for deleteVpc"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpc,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-vpc
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Call deleteVpc"}
   [credentials6975 & args6976]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6977
     (com.palletops.awaze.common/aws-client :ec2 credentials6975)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6977
      deleteVpc
      (ec2/delete-vpc-request (clojure.core/nth args6976 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route-table
   [m6978]
   (clojure.core/let
    [credentials6979 (:credentials m6978) args6980 (:args m6978)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6981
      (com.palletops.awaze.common/aws-client :ec2 credentials6979)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6981
       createRouteTable
       (ec2/create-route-table-request (clojure.core/nth args6980 0)))))))
  (clojure.core/defn
   create-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Generate map for createRouteTable"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-route-table,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-route-table
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Call createRouteTable"}
   [credentials6983 & args6984]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6985
     (com.palletops.awaze.common/aws-client :ec2 credentials6983)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6985
      createRouteTable
      (ec2/create-route-table-request (clojure.core/nth args6984 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :terminate-instances
   [m6986]
   (clojure.core/let
    [credentials6987 (:credentials m6986) args6988 (:args m6986)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6989
      (com.palletops.awaze.common/aws-client :ec2 credentials6987)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6989
       terminateInstances
       (ec2/terminate-instances-request (clojure.core/nth args6988 0)))))))
  (clojure.core/defn
   terminate-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Generate map for terminateInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :terminate-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   terminate-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Call terminateInstances"}
   [credentials6991 & args6992]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6993
     (com.palletops.awaze.common/aws-client :ec2 credentials6991)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6993
      terminateInstances
      (ec2/terminate-instances-request (clojure.core/nth args6992 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-bundle-tasks
   [m6994]
   (clojure.core/let
    [credentials6995 (:credentials m6994) args6996 (:args m6994)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6997
      (com.palletops.awaze.common/aws-client :ec2 credentials6995)]
     (clojure.core/case
      (clojure.core/count args6996)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6997
        describeBundleTasks
        (ec2/describe-bundle-tasks-request
         (clojure.core/nth args6996 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6997
        describeBundleTasks))))))
  (clojure.core/defn
   describe-bundle-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener filters bundle-ids]}]
                [credentials]]),
    :doc "Generate map for describeBundleTasks, describeBundleTasks"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-bundle-tasks,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-bundle-tasks,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-bundle-tasks
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener filters bundle-ids]}]
                [credentials]]),
    :doc "Call describeBundleTasks, describeBundleTasks"}
   [credentials6999 & args7000]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7001
     (com.palletops.awaze.common/aws-client :ec2 credentials6999)]
    (clojure.core/case
     (clojure.core/count args7000)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7001
       describeBundleTasks
       (ec2/describe-bundle-tasks-request
        (clojure.core/nth args7000 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7001
       describeBundleTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-address
   [m7002]
   (clojure.core/let
    [credentials7003 (:credentials m7002) args7004 (:args m7002)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7005
      (com.palletops.awaze.common/aws-client :ec2 credentials7003)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7005
       associateAddress
       (ec2/associate-address-request (clojure.core/nth args7004 0)))))))
  (clojure.core/defn
   associate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [allocation-id
                         general-progress-listener
                         public-ip
                         private-ip-address
                         allow-reassociation
                         network-interface-id
                         instance-id]}]]),
    :doc "Generate map for associateAddress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :associate-address,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   associate-address
   {:arglists (quote
               [[credentials
                 {:keys [allocation-id
                         general-progress-listener
                         public-ip
                         private-ip-address
                         allow-reassociation
                         network-interface-id
                         instance-id]}]]),
    :doc "Call associateAddress"}
   [credentials7007 & args7008]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7009
     (com.palletops.awaze.common/aws-client :ec2 credentials7007)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7009
      associateAddress
      (ec2/associate-address-request (clojure.core/nth args7008 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-volume
   [m7010]
   (clojure.core/let
    [credentials7011 (:credentials m7010) args7012 (:args m7010)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7013
      (com.palletops.awaze.common/aws-client :ec2 credentials7011)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7013
       createVolume
       (ec2/create-volume-request (clojure.core/nth args7012 0)))))))
  (clojure.core/defn
   create-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [iops
                         general-progress-listener
                         encrypted
                         snapshot-id
                         availability-zone
                         volume-type
                         size]}]]),
    :doc "Generate map for createVolume"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-volume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-volume
   {:arglists (quote
               [[credentials
                 {:keys [iops
                         general-progress-listener
                         encrypted
                         snapshot-id
                         availability-zone
                         volume-type
                         size]}]]),
    :doc "Call createVolume"}
   [credentials7015 & args7016]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7017
     (com.palletops.awaze.common/aws-client :ec2 credentials7015)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7017
      createVolume
      (ec2/create-volume-request (clojure.core/nth args7016 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-reserved-instances
   [m7018]
   (clojure.core/let
    [credentials7019 (:credentials m7018) args7020 (:args m7018)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7021
      (com.palletops.awaze.common/aws-client :ec2 credentials7019)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7021
       modifyReservedInstances
       (ec2/modify-reserved-instances-request
        (clojure.core/nth args7020 0)))))))
  (clojure.core/defn
   modify-reserved-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [target-configurations
                         reserved-instances-ids
                         general-progress-listener
                         client-token]}]]),
    :doc "Generate map for modifyReservedInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-reserved-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-reserved-instances
   {:arglists (quote
               [[credentials
                 {:keys [target-configurations
                         reserved-instances-ids
                         general-progress-listener
                         client-token]}]]),
    :doc "Call modifyReservedInstances"}
   [credentials7023 & args7024]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7025
     (com.palletops.awaze.common/aws-client :ec2 credentials7023)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7025
      modifyReservedInstances
      (ec2/modify-reserved-instances-request
       (clojure.core/nth args7024 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-attribute
   [m7026]
   (clojure.core/let
    [credentials7027 (:credentials m7026) args7028 (:args m7026)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7029
      (com.palletops.awaze.common/aws-client :ec2 credentials7027)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7029
       describeVpcAttribute
       (ec2/describe-vpc-attribute-request
        (clojure.core/nth args7028 0)))))))
  (clojure.core/defn
   describe-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener attribute]}]]),
    :doc "Generate map for describeVpcAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpc-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener attribute]}]]),
    :doc "Call describeVpcAttribute"}
   [credentials7031 & args7032]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7033
     (com.palletops.awaze.common/aws-client :ec2 credentials7031)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7033
      describeVpcAttribute
      (ec2/describe-vpc-attribute-request
       (clojure.core/nth args7032 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-egress
   [m7034]
   (clojure.core/let
    [credentials7035 (:credentials m7034) args7036 (:args m7034)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7037
      (com.palletops.awaze.common/aws-client :ec2 credentials7035)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7037
       authorizeSecurityGroupEgress
       (ec2/authorize-security-group-egress-request
        (clojure.core/nth args7036 0)))))))
  (clojure.core/defn
   authorize-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Generate map for authorizeSecurityGroupEgress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :authorize-security-group-egress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   authorize-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Call authorizeSecurityGroupEgress"}
   [credentials7039 & args7040]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7041
     (com.palletops.awaze.common/aws-client :ec2 credentials7039)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7041
      authorizeSecurityGroupEgress
      (ec2/authorize-security-group-egress-request
       (clojure.core/nth args7040 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-customer-gateway
   [m7042]
   (clojure.core/let
    [credentials7043 (:credentials m7042) args7044 (:args m7042)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7045
      (com.palletops.awaze.common/aws-client :ec2 credentials7043)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7045
       deleteCustomerGateway
       (ec2/delete-customer-gateway-request
        (clojure.core/nth args7044 0)))))))
  (clojure.core/defn
   delete-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         customer-gateway-id]}]]),
    :doc "Generate map for deleteCustomerGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-customer-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         customer-gateway-id]}]]),
    :doc "Call deleteCustomerGateway"}
   [credentials7047 & args7048]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7049
     (com.palletops.awaze.common/aws-client :ec2 credentials7047)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7049
      deleteCustomerGateway
      (ec2/delete-customer-gateway-request
       (clojure.core/nth args7048 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-entry
   [m7050]
   (clojure.core/let
    [credentials7051 (:credentials m7050) args7052 (:args m7050)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7053
      (com.palletops.awaze.common/aws-client :ec2 credentials7051)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7053
       replaceNetworkAclEntry
       (ec2/replace-network-acl-entry-request
        (clojure.core/nth args7052 0)))))))
  (clojure.core/defn
   replace-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         general-progress-listener
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Generate map for replaceNetworkAclEntry"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-network-acl-entry,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   replace-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         general-progress-listener
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Call replaceNetworkAclEntry"}
   [credentials7055 & args7056]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7057
     (com.palletops.awaze.common/aws-client :ec2 credentials7055)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7057
      replaceNetworkAclEntry
      (ec2/replace-network-acl-entry-request
       (clojure.core/nth args7056 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc-peering-connection
   [m7058]
   (clojure.core/let
    [credentials7059 (:credentials m7058) args7060 (:args m7058)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7061
      (com.palletops.awaze.common/aws-client :ec2 credentials7059)]
     (clojure.core/case
      (clojure.core/count args7060)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7061
        createVpcPeeringConnection))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7061
        createVpcPeeringConnection
        (ec2/create-vpc-peering-connection-request
         (clojure.core/nth args7060 0))))))))
  (clojure.core/defn
   create-vpc-peering-connection-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-id
                         peer-vpc-id
                         peer-owner-id
                         general-progress-listener]}]]),
    :doc "Generate map for createVpcPeeringConnection, createVpcPeeringConnection"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :create-vpc-peering-connection,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpc-peering-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-vpc-peering-connection
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-id
                         peer-vpc-id
                         peer-owner-id
                         general-progress-listener]}]]),
    :doc "Call createVpcPeeringConnection, createVpcPeeringConnection"}
   [credentials7063 & args7064]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7065
     (com.palletops.awaze.common/aws-client :ec2 credentials7063)]
    (clojure.core/case
     (clojure.core/count args7064)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7065
       createVpcPeeringConnection))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7065
       createVpcPeeringConnection
       (ec2/create-vpc-peering-connection-request
        (clojure.core/nth args7064 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-subnets
   [m7066]
   (clojure.core/let
    [credentials7067 (:credentials m7066) args7068 (:args m7066)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7069
      (com.palletops.awaze.common/aws-client :ec2 credentials7067)]
     (clojure.core/case
      (clojure.core/count args7068)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7069
        describeSubnets
        (ec2/describe-subnets-request (clojure.core/nth args7068 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7069
        describeSubnets))))))
  (clojure.core/defn
   describe-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids general-progress-listener filters]}]
                [credentials]]),
    :doc "Generate map for describeSubnets, describeSubnets"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-subnets,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-subnets,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-subnets
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids general-progress-listener filters]}]
                [credentials]]),
    :doc "Call describeSubnets, describeSubnets"}
   [credentials7071 & args7072]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7073
     (com.palletops.awaze.common/aws-client :ec2 credentials7071)]
    (clojure.core/case
     (clojure.core/count args7072)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7073
       describeSubnets
       (ec2/describe-subnets-request (clojure.core/nth args7072 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7073
       describeSubnets))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-console-output
   [m7074]
   (clojure.core/let
    [credentials7075 (:credentials m7074) args7076 (:args m7074)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7077
      (com.palletops.awaze.common/aws-client :ec2 credentials7075)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7077
       getConsoleOutput
       (ec2/get-console-output-request (clojure.core/nth args7076 0)))))))
  (clojure.core/defn
   get-console-output-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-id general-progress-listener]}]]),
    :doc "Generate map for getConsoleOutput"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :get-console-output,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-console-output
   {:arglists (quote
               [[credentials
                 {:keys [instance-id general-progress-listener]}]]),
    :doc "Call getConsoleOutput"}
   [credentials7079 & args7080]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7081
     (com.palletops.awaze.common/aws-client :ec2 credentials7079)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7081
      getConsoleOutput
      (ec2/get-console-output-request (clojure.core/nth args7080 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-conversion-task
   [m7082]
   (clojure.core/let
    [credentials7083 (:credentials m7082) args7084 (:args m7082)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7085
      (com.palletops.awaze.common/aws-client :ec2 credentials7083)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7085
       cancelConversionTask
       (ec2/cancel-conversion-task-request
        (clojure.core/nth args7084 0)))))))
  (clojure.core/defn
   cancel-conversion-task-map
   {:arglists (quote
               [[credentials
                 {:keys [reason-message
                         general-progress-listener
                         conversion-task-id]}]]),
    :doc "Generate map for cancelConversionTask"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-conversion-task,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-conversion-task
   {:arglists (quote
               [[credentials
                 {:keys [reason-message
                         general-progress-listener
                         conversion-task-id]}]]),
    :doc "Call cancelConversionTask"}
   [credentials7087 & args7088]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7089
     (com.palletops.awaze.common/aws-client :ec2 credentials7087)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7089
      cancelConversionTask
      (ec2/cancel-conversion-task-request
       (clojure.core/nth args7088 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-vpn-gateway
   [m7090]
   (clojure.core/let
    [credentials7091 (:credentials m7090) args7092 (:args m7090)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7093
      (com.palletops.awaze.common/aws-client :ec2 credentials7091)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7093
       attachVpnGateway
       (ec2/attach-vpn-gateway-request (clojure.core/nth args7092 0)))))))
  (clojure.core/defn
   attach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         general-progress-listener]}]]),
    :doc "Generate map for attachVpnGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-vpn-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   attach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         general-progress-listener]}]]),
    :doc "Call attachVpnGateway"}
   [credentials7095 & args7096]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7097
     (com.palletops.awaze.common/aws-client :ec2 credentials7095)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7097
      attachVpnGateway
      (ec2/attach-vpn-gateway-request (clojure.core/nth args7096 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-peering-connections
   [m7098]
   (clojure.core/let
    [credentials7099 (:credentials m7098) args7100 (:args m7098)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7101
      (com.palletops.awaze.common/aws-client :ec2 credentials7099)]
     (clojure.core/case
      (clojure.core/count args7100)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7101
        describeVpcPeeringConnections
        (ec2/describe-vpc-peering-connections-request
         (clojure.core/nth args7100 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7101
        describeVpcPeeringConnections))))))
  (clojure.core/defn
   describe-vpc-peering-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-peering-connection-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeVpcPeeringConnections, describeVpcPeeringConnections"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-vpc-peering-connections
   {:arglists (quote
               [[credentials
                 {:keys [vpc-peering-connection-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeVpcPeeringConnections, describeVpcPeeringConnections"}
   [credentials7103 & args7104]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7105
     (com.palletops.awaze.common/aws-client :ec2 credentials7103)]
    (clojure.core/case
     (clojure.core/count args7104)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7105
       describeVpcPeeringConnections
       (ec2/describe-vpc-peering-connections-request
        (clojure.core/nth args7104 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7105
       describeVpcPeeringConnections))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection-route
   [m7106]
   (clojure.core/let
    [credentials7107 (:credentials m7106) args7108 (:args m7106)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7109
      (com.palletops.awaze.common/aws-client :ec2 credentials7107)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7109
       deleteVpnConnectionRoute
       (ec2/delete-vpn-connection-route-request
        (clojure.core/nth args7108 0)))))))
  (clojure.core/defn
   delete-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Generate map for deleteVpnConnectionRoute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpn-connection-route,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Call deleteVpnConnectionRoute"}
   [credentials7111 & args7112]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7113
     (com.palletops.awaze.common/aws-client :ec2 credentials7111)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7113
      deleteVpnConnectionRoute
      (ec2/delete-vpn-connection-route-request
       (clojure.core/nth args7112 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :run-instances
   [m7114]
   (clojure.core/let
    [credentials7115 (:credentials m7114) args7116 (:args m7114)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7117
      (com.palletops.awaze.common/aws-client :ec2 credentials7115)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7117
       runInstances
       (ec2/run-instances-request (clojure.core/nth args7116 0)))))))
  (clojure.core/defn
   run-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         kernel-id
                         additional-info
                         general-progress-listener
                         ebs-optimized
                         subnet-id
                         max-count
                         block-device-mappings
                         network-interfaces
                         placement
                         private-ip-address
                         disable-api-termination
                         user-data
                         security-groups
                         ramdisk-id
                         iam-instance-profile
                         min-count
                         security-group-ids
                         key-name
                         client-token
                         image-id
                         monitoring
                         instance-initiated-shutdown-behavior]}]]),
    :doc "Generate map for runInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :run-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   run-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         kernel-id
                         additional-info
                         general-progress-listener
                         ebs-optimized
                         subnet-id
                         max-count
                         block-device-mappings
                         network-interfaces
                         placement
                         private-ip-address
                         disable-api-termination
                         user-data
                         security-groups
                         ramdisk-id
                         iam-instance-profile
                         min-count
                         security-group-ids
                         key-name
                         client-token
                         image-id
                         monitoring
                         instance-initiated-shutdown-behavior]}]]),
    :doc "Call runInstances"}
   [credentials7119 & args7120]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7121
     (com.palletops.awaze.common/aws-client :ec2 credentials7119)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7121
      runInstances
      (ec2/run-instances-request (clojure.core/nth args7120 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :register-image
   [m7122]
   (clojure.core/let
    [credentials7123 (:credentials m7122) args7124 (:args m7122)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7125
      (com.palletops.awaze.common/aws-client :ec2 credentials7123)]
     (clojure.core/case
      (clojure.core/count args7124)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7125
        registerImage))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7125
        registerImage
        (ec2/register-image-request (clojure.core/nth args7124 0))))))))
  (clojure.core/defn
   register-image-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [kernel-id
                         general-progress-listener
                         name
                         root-device-name
                         virtualization-type
                         block-device-mappings
                         image-location
                         ramdisk-id
                         architecture
                         sriov-net-support
                         description]}]]),
    :doc "Generate map for registerImage, registerImage"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :register-image,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :register-image,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   register-image
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [kernel-id
                         general-progress-listener
                         name
                         root-device-name
                         virtualization-type
                         block-device-mappings
                         image-location
                         ramdisk-id
                         architecture
                         sriov-net-support
                         description]}]]),
    :doc "Call registerImage, registerImage"}
   [credentials7127 & args7128]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7129
     (com.palletops.awaze.common/aws-client :ec2 credentials7127)]
    (clojure.core/case
     (clojure.core/count args7128)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7129
       registerImage))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7129
       registerImage
       (ec2/register-image-request (clojure.core/nth args7128 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-tags
   [m7130]
   (clojure.core/let
    [credentials7131 (:credentials m7130) args7132 (:args m7130)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7133
      (com.palletops.awaze.common/aws-client :ec2 credentials7131)]
     (clojure.core/case
      (clojure.core/count args7132)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7133
        describeTags))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7133
        describeTags
        (ec2/describe-tags-request (clojure.core/nth args7132 0))))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-results
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-tags,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-results
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeTags, describeTags"}
   [credentials7135 & args7136]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7137
     (com.palletops.awaze.common/aws-client :ec2 credentials7135)]
    (clojure.core/case
     (clojure.core/count args7136)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7137
       describeTags))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7137
       describeTags
       (ec2/describe-tags-request (clojure.core/nth args7136 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances
   [m7138]
   (clojure.core/let
    [credentials7139 (:credentials m7138) args7140 (:args m7138)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7141
      (com.palletops.awaze.common/aws-client :ec2 credentials7139)]
     (clojure.core/case
      (clojure.core/count args7140)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7141
        describeReservedInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7141
        describeReservedInstances
        (ec2/describe-reserved-instances-request
         (clojure.core/nth args7140 0))))))))
  (clojure.core/defn
   describe-reserved-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-ids
                         offering-type
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeReservedInstances, describeReservedInstances"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-ids
                         offering-type
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeReservedInstances, describeReservedInstances"}
   [credentials7143 & args7144]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7145
     (com.palletops.awaze.common/aws-client :ec2 credentials7143)]
    (clojure.core/case
     (clojure.core/count args7144)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7145
       describeReservedInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7145
       describeReservedInstances
       (ec2/describe-reserved-instances-request
        (clojure.core/nth args7144 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-vpn-gateway
   [m7146]
   (clojure.core/let
    [credentials7147 (:credentials m7146) args7148 (:args m7146)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7149
      (com.palletops.awaze.common/aws-client :ec2 credentials7147)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7149
       detachVpnGateway
       (ec2/detach-vpn-gateway-request (clojure.core/nth args7148 0)))))))
  (clojure.core/defn
   detach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         general-progress-listener]}]]),
    :doc "Generate map for detachVpnGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-vpn-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   detach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         general-progress-listener]}]]),
    :doc "Call detachVpnGateway"}
   [credentials7151 & args7152]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7153
     (com.palletops.awaze.common/aws-client :ec2 credentials7151)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7153
      detachVpnGateway
      (ec2/detach-vpn-gateway-request (clojure.core/nth args7152 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-customer-gateways
   [m7154]
   (clojure.core/let
    [credentials7155 (:credentials m7154) args7156 (:args m7154)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7157
      (com.palletops.awaze.common/aws-client :ec2 credentials7155)]
     (clojure.core/case
      (clojure.core/count args7156)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7157
        describeCustomerGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7157
        describeCustomerGateways
        (ec2/describe-customer-gateways-request
         (clojure.core/nth args7156 0))))))))
  (clojure.core/defn
   describe-customer-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         customer-gateway-ids]}]]),
    :doc "Generate map for describeCustomerGateways, describeCustomerGateways"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-customer-gateways,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-customer-gateways,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-customer-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         customer-gateway-ids]}]]),
    :doc "Call describeCustomerGateways, describeCustomerGateways"}
   [credentials7159 & args7160]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7161
     (com.palletops.awaze.common/aws-client :ec2 credentials7159)]
    (clojure.core/case
     (clojure.core/count args7160)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7161
       describeCustomerGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7161
       describeCustomerGateways
       (ec2/describe-customer-gateways-request
        (clojure.core/nth args7160 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interface-attribute
   [m7162]
   (clojure.core/let
    [credentials7163 (:credentials m7162) args7164 (:args m7162)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7165
      (com.palletops.awaze.common/aws-client :ec2 credentials7163)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7165
       describeNetworkInterfaceAttribute
       (ec2/describe-network-interface-attribute-request
        (clojure.core/nth args7164 0)))))))
  (clojure.core/defn
   describe-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         source-dest-check
                         network-interface-id
                         groups
                         attachment
                         description]}]]),
    :doc "Generate map for describeNetworkInterfaceAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-network-interface-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         source-dest-check
                         network-interface-id
                         groups
                         attachment
                         description]}]]),
    :doc "Call describeNetworkInterfaceAttribute"}
   [credentials7167 & args7168]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7169
     (com.palletops.awaze.common/aws-client :ec2 credentials7167)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7169
      describeNetworkInterfaceAttribute
      (ec2/describe-network-interface-attribute-request
       (clojure.core/nth args7168 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-key-pair
   [m7170]
   (clojure.core/let
    [credentials7171 (:credentials m7170) args7172 (:args m7170)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7173
      (com.palletops.awaze.common/aws-client :ec2 credentials7171)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7173
       importKeyPair
       (ec2/import-key-pair-request (clojure.core/nth args7172 0)))))))
  (clojure.core/defn
   import-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [public-key-material
                         key-name
                         general-progress-listener]}]]),
    :doc "Generate map for importKeyPair"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :import-key-pair,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   import-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [public-key-material
                         key-name
                         general-progress-listener]}]]),
    :doc "Call importKeyPair"}
   [credentials7175 & args7176]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7177
     (com.palletops.awaze.common/aws-client :ec2 credentials7175)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7177
      importKeyPair
      (ec2/import-key-pair-request (clojure.core/nth args7176 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-instance
   [m7178]
   (clojure.core/let
    [credentials7179 (:credentials m7178) args7180 (:args m7178)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7181
      (com.palletops.awaze.common/aws-client :ec2 credentials7179)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7181
       importInstance
       (ec2/import-instance-request (clojure.core/nth args7180 0)))))))
  (clojure.core/defn
   import-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [platform
                         description
                         disk-images
                         general-progress-listener
                         launch-specification]}]]),
    :doc "Generate map for importInstance"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :import-instance,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   import-instance
   {:arglists (quote
               [[credentials
                 {:keys [platform
                         description
                         disk-images
                         general-progress-listener
                         launch-specification]}]]),
    :doc "Call importInstance"}
   [credentials7183 & args7184]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7185
     (com.palletops.awaze.common/aws-client :ec2 credentials7183)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7185
      importInstance
      (ec2/import-instance-request (clojure.core/nth args7184 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :allocate-address
   [m7186]
   (clojure.core/let
    [credentials7187 (:credentials m7186) args7188 (:args m7186)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7189
      (com.palletops.awaze.common/aws-client :ec2 credentials7187)]
     (clojure.core/case
      (clojure.core/count args7188)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7189
        allocateAddress))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7189
        allocateAddress
        (ec2/allocate-address-request (clojure.core/nth args7188 0))))))))
  (clojure.core/defn
   allocate-address-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener domain]}]]),
    :doc "Generate map for allocateAddress, allocateAddress"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :allocate-address,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :allocate-address,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   allocate-address
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener domain]}]]),
    :doc "Call allocateAddress, allocateAddress"}
   [credentials7191 & args7192]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7193
     (com.palletops.awaze.common/aws-client :ec2 credentials7191)]
    (clojure.core/case
     (clojure.core/count args7192)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7193
       allocateAddress))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7193
       allocateAddress
       (ec2/allocate-address-request (clojure.core/nth args7192 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-instance-requests
   [m7194]
   (clojure.core/let
    [credentials7195 (:credentials m7194) args7196 (:args m7194)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7197
      (com.palletops.awaze.common/aws-client :ec2 credentials7195)]
     (clojure.core/case
      (clojure.core/count args7196)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7197
        describeSpotInstanceRequests))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7197
        describeSpotInstanceRequests
        (ec2/describe-spot-instance-requests-request
         (clojure.core/nth args7196 0))))))))
  (clojure.core/defn
   describe-spot-instance-requests-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [spot-instance-request-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeSpotInstanceRequests, describeSpotInstanceRequests"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-spot-instance-requests,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-spot-instance-requests,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-spot-instance-requests
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [spot-instance-request-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeSpotInstanceRequests, describeSpotInstanceRequests"}
   [credentials7199 & args7200]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7201
     (com.palletops.awaze.common/aws-client :ec2 credentials7199)]
    (clojure.core/case
     (clojure.core/count args7200)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7201
       describeSpotInstanceRequests))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7201
       describeSpotInstanceRequests
       (ec2/describe-spot-instance-requests-request
        (clojure.core/nth args7200 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-spot-datafeed-subscription
   [m7202]
   (clojure.core/let
    [credentials7203 (:credentials m7202) args7204 (:args m7202)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7205
      (com.palletops.awaze.common/aws-client :ec2 credentials7203)]
     (clojure.core/case
      (clojure.core/count args7204)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7205
        deleteSpotDatafeedSubscription
        (ec2/delete-spot-datafeed-subscription-request
         (clojure.core/nth args7204 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7205
        deleteSpotDatafeedSubscription))))))
  (clojure.core/defn
   delete-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-spot-datafeed-subscription
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   [credentials7207 & args7208]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7209
     (com.palletops.awaze.common/aws-client :ec2 credentials7207)]
    (clojure.core/case
     (clojure.core/count args7208)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7209
       deleteSpotDatafeedSubscription
       (ec2/delete-spot-datafeed-subscription-request
        (clojure.core/nth args7208 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7209
       deleteSpotDatafeedSubscription))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-conversion-tasks
   [m7210]
   (clojure.core/let
    [credentials7211 (:credentials m7210) args7212 (:args m7210)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7213
      (com.palletops.awaze.common/aws-client :ec2 credentials7211)]
     (clojure.core/case
      (clojure.core/count args7212)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7213
        describeConversionTasks
        (ec2/describe-conversion-tasks-request
         (clojure.core/nth args7212 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7213
        describeConversionTasks))))))
  (clojure.core/defn
   describe-conversion-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         filters
                         conversion-task-ids]}]
                [credentials]]),
    :doc "Generate map for describeConversionTasks, describeConversionTasks"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-conversion-tasks,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-conversion-tasks,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-conversion-tasks
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         filters
                         conversion-task-ids]}]
                [credentials]]),
    :doc "Call describeConversionTasks, describeConversionTasks"}
   [credentials7215 & args7216]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7217
     (com.palletops.awaze.common/aws-client :ec2 credentials7215)]
    (clojure.core/case
     (clojure.core/count args7216)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7217
       describeConversionTasks
       (ec2/describe-conversion-tasks-request
        (clojure.core/nth args7216 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7217
       describeConversionTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route-table-association
   [m7218]
   (clojure.core/let
    [credentials7219 (:credentials m7218) args7220 (:args m7218)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7221
      (com.palletops.awaze.common/aws-client :ec2 credentials7219)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7221
       replaceRouteTableAssociation
       (ec2/replace-route-table-association-request
        (clojure.core/nth args7220 0)))))))
  (clojure.core/defn
   replace-route-table-association-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         association-id]}]]),
    :doc "Generate map for replaceRouteTableAssociation"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-route-table-association,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   replace-route-table-association
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         association-id]}]]),
    :doc "Call replaceRouteTableAssociation"}
   [credentials7223 & args7224]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7225
     (com.palletops.awaze.common/aws-client :ec2 credentials7223)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7225
      replaceRouteTableAssociation
      (ec2/replace-route-table-association-request
       (clojure.core/nth args7224 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-subnet
   [m7226]
   (clojure.core/let
    [credentials7227 (:credentials m7226) args7228 (:args m7226)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7229
      (com.palletops.awaze.common/aws-client :ec2 credentials7227)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7229
       deleteSubnet
       (ec2/delete-subnet-request (clojure.core/nth args7228 0)))))))
  (clojure.core/defn
   delete-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id general-progress-listener]}]]),
    :doc "Generate map for deleteSubnet"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-subnet,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-subnet
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id general-progress-listener]}]]),
    :doc "Call deleteSubnet"}
   [credentials7231 & args7232]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7233
     (com.palletops.awaze.common/aws-client :ec2 credentials7231)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7233
      deleteSubnet
      (ec2/delete-subnet-request (clojure.core/nth args7232 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-vpc-attribute
   [m7234]
   (clojure.core/let
    [credentials7235 (:credentials m7234) args7236 (:args m7234)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7237
      (com.palletops.awaze.common/aws-client :ec2 credentials7235)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7237
       modifyVpcAttribute
       (ec2/modify-vpc-attribute-request
        (clojure.core/nth args7236 0)))))))
  (clojure.core/defn
   modify-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         enable-dns-support
                         enable-dns-hostnames]}]]),
    :doc "Generate map for modifyVpcAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-vpc-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         enable-dns-support
                         enable-dns-hostnames]}]]),
    :doc "Call modifyVpcAttribute"}
   [credentials7239 & args7240]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7241
     (com.palletops.awaze.common/aws-client :ec2 credentials7239)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7241
      modifyVpcAttribute
      (ec2/modify-vpc-attribute-request (clojure.core/nth args7240 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-internet-gateway
   [m7242]
   (clojure.core/let
    [credentials7243 (:credentials m7242) args7244 (:args m7242)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7245
      (com.palletops.awaze.common/aws-client :ec2 credentials7243)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7245
       detachInternetGateway
       (ec2/detach-internet-gateway-request
        (clojure.core/nth args7244 0)))))))
  (clojure.core/defn
   detach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Generate map for detachInternetGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-internet-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   detach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Call detachInternetGateway"}
   [credentials7247 & args7248]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7249
     (com.palletops.awaze.common/aws-client :ec2 credentials7247)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7249
      detachInternetGateway
      (ec2/detach-internet-gateway-request
       (clojure.core/nth args7248 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-modifications
   [m7250]
   (clojure.core/let
    [credentials7251 (:credentials m7250) args7252 (:args m7250)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7253
      (com.palletops.awaze.common/aws-client :ec2 credentials7251)]
     (clojure.core/case
      (clojure.core/count args7252)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7253
        describeReservedInstancesModifications
        (ec2/describe-reserved-instances-modifications-request
         (clojure.core/nth args7252 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7253
        describeReservedInstancesModifications))))))
  (clojure.core/defn
   describe-reserved-instances-modifications-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-modification-ids
                         next-token
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeReservedInstancesModifications, describeReservedInstancesModifications"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-instances-modifications
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-modification-ids
                         next-token
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeReservedInstancesModifications, describeReservedInstancesModifications"}
   [credentials7255 & args7256]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7257
     (com.palletops.awaze.common/aws-client :ec2 credentials7255)]
    (clojure.core/case
     (clojure.core/count args7256)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7257
       describeReservedInstancesModifications
       (ec2/describe-reserved-instances-modifications-request
        (clojure.core/nth args7256 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7257
       describeReservedInstancesModifications))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-password-data
   [m7258]
   (clojure.core/let
    [credentials7259 (:credentials m7258) args7260 (:args m7258)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7261
      (com.palletops.awaze.common/aws-client :ec2 credentials7259)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7261
       getPasswordData
       (ec2/get-password-data-request (clojure.core/nth args7260 0)))))))
  (clojure.core/defn
   get-password-data-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-id general-progress-listener]}]]),
    :doc "Generate map for getPasswordData"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :get-password-data,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-password-data
   {:arglists (quote
               [[credentials
                 {:keys [instance-id general-progress-listener]}]]),
    :doc "Call getPasswordData"}
   [credentials7263 & args7264]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7265
     (com.palletops.awaze.common/aws-client :ec2 credentials7263)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7265
      getPasswordData
      (ec2/get-password-data-request (clojure.core/nth args7264 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :unassign-private-ip-addresses
   [m7266]
   (clojure.core/let
    [credentials7267 (:credentials m7266) args7268 (:args m7266)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7269
      (com.palletops.awaze.common/aws-client :ec2 credentials7267)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7269
       unassignPrivateIpAddresses
       (ec2/unassign-private-ip-addresses-request
        (clojure.core/nth args7268 0)))))))
  (clojure.core/defn
   unassign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [private-ip-addresses
                         network-interface-id
                         general-progress-listener]}]]),
    :doc "Generate map for unassignPrivateIpAddresses"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :unassign-private-ip-addresses,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   unassign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [private-ip-addresses
                         network-interface-id
                         general-progress-listener]}]]),
    :doc "Call unassignPrivateIpAddresses"}
   [credentials7271 & args7272]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7273
     (com.palletops.awaze.common/aws-client :ec2 credentials7271)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7273
      unassignPrivateIpAddresses
      (ec2/unassign-private-ip-addresses-request
       (clojure.core/nth args7272 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-network-interface-attribute
   [m7274]
   (clojure.core/let
    [credentials7275 (:credentials m7274) args7276 (:args m7274)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7277
      (com.palletops.awaze.common/aws-client :ec2 credentials7275)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7277
       modifyNetworkInterfaceAttribute
       (ec2/modify-network-interface-attribute-request
        (clojure.core/nth args7276 0)))))))
  (clojure.core/defn
   modify-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         source-dest-check
                         network-interface-id
                         groups
                         attachment
                         description]}]]),
    :doc "Generate map for modifyNetworkInterfaceAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-network-interface-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         source-dest-check
                         network-interface-id
                         groups
                         attachment
                         description]}]]),
    :doc "Call modifyNetworkInterfaceAttribute"}
   [credentials7279 & args7280]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7281
     (com.palletops.awaze.common/aws-client :ec2 credentials7279)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7281
      modifyNetworkInterfaceAttribute
      (ec2/modify-network-interface-attribute-request
       (clojure.core/nth args7280 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-network-interface-attribute
   [m7282]
   (clojure.core/let
    [credentials7283 (:credentials m7282) args7284 (:args m7282)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7285
      (com.palletops.awaze.common/aws-client :ec2 credentials7283)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7285
       resetNetworkInterfaceAttribute
       (ec2/reset-network-interface-attribute-request
        (clojure.core/nth args7284 0)))))))
  (clojure.core/defn
   reset-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [source-dest-check
                         network-interface-id
                         general-progress-listener]}]]),
    :doc "Generate map for resetNetworkInterfaceAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-network-interface-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reset-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [source-dest-check
                         network-interface-id
                         general-progress-listener]}]]),
    :doc "Call resetNetworkInterfaceAttribute"}
   [credentials7287 & args7288]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7289
     (com.palletops.awaze.common/aws-client :ec2 credentials7287)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7289
      resetNetworkInterfaceAttribute
      (ec2/reset-network-interface-attribute-request
       (clojure.core/nth args7288 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpcs
   [m7290]
   (clojure.core/let
    [credentials7291 (:credentials m7290) args7292 (:args m7290)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7293
      (com.palletops.awaze.common/aws-client :ec2 credentials7291)]
     (clojure.core/case
      (clojure.core/count args7292)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7293
        describeVpcs
        (ec2/describe-vpcs-request (clojure.core/nth args7292 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7293
        describeVpcs))))))
  (clojure.core/defn
   describe-vpcs-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-ids general-progress-listener filters]}]
                [credentials]]),
    :doc "Generate map for describeVpcs, describeVpcs"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpcs,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpcs,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-vpcs
   {:arglists (quote
               [[credentials
                 {:keys [vpc-ids general-progress-listener filters]}]
                [credentials]]),
    :doc "Call describeVpcs, describeVpcs"}
   [credentials7295 & args7296]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7297
     (com.palletops.awaze.common/aws-client :ec2 credentials7295)]
    (clojure.core/case
     (clojure.core/count args7296)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7297
       describeVpcs
       (ec2/describe-vpcs-request (clojure.core/nth args7296 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7297
       describeVpcs))))))
 (do
  (clojure.core/defmethod
   ec2
   :reboot-instances
   [m7298]
   (clojure.core/let
    [credentials7299 (:credentials m7298) args7300 (:args m7298)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7301
      (com.palletops.awaze.common/aws-client :ec2 credentials7299)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7301
       rebootInstances
       (ec2/reboot-instances-request (clojure.core/nth args7300 0)))))))
  (clojure.core/defn
   reboot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Generate map for rebootInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reboot-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reboot-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Call rebootInstances"}
   [credentials7303 & args7304]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7305
     (com.palletops.awaze.common/aws-client :ec2 credentials7303)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7305
      rebootInstances
      (ec2/reboot-instances-request (clojure.core/nth args7304 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-attribute
   [m7306]
   (clojure.core/let
    [credentials7307 (:credentials m7306) args7308 (:args m7306)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7309
      (com.palletops.awaze.common/aws-client :ec2 credentials7307)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7309
       describeVolumeAttribute
       (ec2/describe-volume-attribute-request
        (clojure.core/nth args7308 0)))))))
  (clojure.core/defn
   describe-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Generate map for describeVolumeAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-volume-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Call describeVolumeAttribute"}
   [credentials7311 & args7312]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7313
     (com.palletops.awaze.common/aws-client :ec2 credentials7311)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7313
      describeVolumeAttribute
      (ec2/describe-volume-attribute-request
       (clojure.core/nth args7312 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-instance-attribute
   [m7314]
   (clojure.core/let
    [credentials7315 (:credentials m7314) args7316 (:args m7314)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7317
      (com.palletops.awaze.common/aws-client :ec2 credentials7315)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7317
       modifyInstanceAttribute
       (ec2/modify-instance-attribute-request
        (clojure.core/nth args7316 0)))))))
  (clojure.core/defn
   modify-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         general-progress-listener
                         ebs-optimized
                         source-dest-check
                         block-device-mappings
                         kernel
                         disable-api-termination
                         user-data
                         groups
                         ramdisk
                         attribute
                         instance-id
                         sriov-net-support
                         instance-initiated-shutdown-behavior
                         value]}]]),
    :doc "Generate map for modifyInstanceAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-instance-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         general-progress-listener
                         ebs-optimized
                         source-dest-check
                         block-device-mappings
                         kernel
                         disable-api-termination
                         user-data
                         groups
                         ramdisk
                         attribute
                         instance-id
                         sriov-net-support
                         instance-initiated-shutdown-behavior
                         value]}]]),
    :doc "Call modifyInstanceAttribute"}
   [credentials7319 & args7320]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7321
     (com.palletops.awaze.common/aws-client :ec2 credentials7319)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7321
      modifyInstanceAttribute
      (ec2/modify-instance-attribute-request
       (clojure.core/nth args7320 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-key-pair
   [m7322]
   (clojure.core/let
    [credentials7323 (:credentials m7322) args7324 (:args m7322)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7325
      (com.palletops.awaze.common/aws-client :ec2 credentials7323)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7325
       deleteKeyPair
       (ec2/delete-key-pair-request (clojure.core/nth args7324 0)))))))
  (clojure.core/defn
   delete-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [key-name general-progress-listener]}]]),
    :doc "Generate map for deleteKeyPair"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-key-pair,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [key-name general-progress-listener]}]]),
    :doc "Call deleteKeyPair"}
   [credentials7327 & args7328]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7329
     (com.palletops.awaze.common/aws-client :ec2 credentials7327)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7329
      deleteKeyPair
      (ec2/delete-key-pair-request (clojure.core/nth args7328 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vgw-route-propagation
   [m7330]
   (clojure.core/let
    [credentials7331 (:credentials m7330) args7332 (:args m7330)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7333
      (com.palletops.awaze.common/aws-client :ec2 credentials7331)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7333
       enableVgwRoutePropagation
       (ec2/enable-vgw-route-propagation-request
        (clojure.core/nth args7332 0)))))))
  (clojure.core/defn
   enable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         gateway-id]}]]),
    :doc "Generate map for enableVgwRoutePropagation"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :enable-vgw-route-propagation,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         gateway-id]}]]),
    :doc "Call enableVgwRoutePropagation"}
   [credentials7335 & args7336]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7337
     (com.palletops.awaze.common/aws-client :ec2 credentials7335)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7337
      enableVgwRoutePropagation
      (ec2/enable-vgw-route-propagation-request
       (clojure.core/nth args7336 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :bundle-instance
   [m7338]
   (clojure.core/let
    [credentials7339 (:credentials m7338) args7340 (:args m7338)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7341
      (com.palletops.awaze.common/aws-client :ec2 credentials7339)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7341
       bundleInstance
       (ec2/bundle-instance-request (clojure.core/nth args7340 0)))))))
  (clojure.core/defn
   bundle-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [storage
                         instance-id
                         general-progress-listener]}]]),
    :doc "Generate map for bundleInstance"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :bundle-instance,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   bundle-instance
   {:arglists (quote
               [[credentials
                 {:keys [storage
                         instance-id
                         general-progress-listener]}]]),
    :doc "Call bundleInstance"}
   [credentials7343 & args7344]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7345
     (com.palletops.awaze.common/aws-client :ec2 credentials7343)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7345
      bundleInstance
      (ec2/bundle-instance-request (clojure.core/nth args7344 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-internet-gateway
   [m7346]
   (clojure.core/let
    [credentials7347 (:credentials m7346) args7348 (:args m7346)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7349
      (com.palletops.awaze.common/aws-client :ec2 credentials7347)]
     (clojure.core/case
      (clojure.core/count args7348)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7349
        createInternetGateway))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7349
        createInternetGateway
        (ec2/create-internet-gateway-request
         (clojure.core/nth args7348 0))))))))
  (clojure.core/defn
   create-internet-gateway-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for createInternetGateway, createInternetGateway"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :create-internet-gateway,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-internet-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-internet-gateway
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call createInternetGateway, createInternetGateway"}
   [credentials7351 & args7352]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7353
     (com.palletops.awaze.common/aws-client :ec2 credentials7351)]
    (clojure.core/case
     (clojure.core/count args7352)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7353
       createInternetGateway))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7353
       createInternetGateway
       (ec2/create-internet-gateway-request
        (clojure.core/nth args7352 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-status
   [m7354]
   (clojure.core/let
    [credentials7355 (:credentials m7354) args7356 (:args m7354)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7357
      (com.palletops.awaze.common/aws-client :ec2 credentials7355)]
     (clojure.core/case
      (clojure.core/count args7356)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7357
        describeVolumeStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7357
        describeVolumeStatus
        (ec2/describe-volume-status-request
         (clojure.core/nth args7356 0))))))))
  (clojure.core/defn
   describe-volume-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [volume-ids
                         general-progress-listener
                         next-token
                         filters
                         max-results]}]]),
    :doc "Generate map for describeVolumeStatus, describeVolumeStatus"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-volume-status,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-volume-status,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-volume-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [volume-ids
                         general-progress-listener
                         next-token
                         filters
                         max-results]}]]),
    :doc "Call describeVolumeStatus, describeVolumeStatus"}
   [credentials7359 & args7360]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7361
     (com.palletops.awaze.common/aws-client :ec2 credentials7359)]
    (clojure.core/case
     (clojure.core/count args7360)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7361
       describeVolumeStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7361
       describeVolumeStatus
       (ec2/describe-volume-status-request
        (clojure.core/nth args7360 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-image
   [m7362]
   (clojure.core/let
    [credentials7363 (:credentials m7362) args7364 (:args m7362)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7365
      (com.palletops.awaze.common/aws-client :ec2 credentials7363)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7365
       copyImage
       (ec2/copy-image-request (clojure.core/nth args7364 0)))))))
  (clojure.core/defn
   copy-image-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         name
                         source-region
                         source-image-id
                         client-token
                         description]}]]),
    :doc "Generate map for copyImage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :copy-image,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   copy-image
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         name
                         source-region
                         source-image-id
                         client-token
                         description]}]]),
    :doc "Call copyImage"}
   [credentials7367 & args7368]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7369
     (com.palletops.awaze.common/aws-client :ec2 credentials7367)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7369
      copyImage
      (ec2/copy-image-request (clojure.core/nth args7368 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-key-pairs
   [m7370]
   (clojure.core/let
    [credentials7371 (:credentials m7370) args7372 (:args m7370)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7373
      (com.palletops.awaze.common/aws-client :ec2 credentials7371)]
     (clojure.core/case
      (clojure.core/count args7372)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7373
        describeKeyPairs
        (ec2/describe-key-pairs-request (clojure.core/nth args7372 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7373
        describeKeyPairs))))))
  (clojure.core/defn
   describe-key-pairs-map
   {:arglists (quote
               [[credentials
                 {:keys [key-names general-progress-listener filters]}]
                [credentials]]),
    :doc "Generate map for describeKeyPairs, describeKeyPairs"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-key-pairs,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-key-pairs,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-key-pairs
   {:arglists (quote
               [[credentials
                 {:keys [key-names general-progress-listener filters]}]
                [credentials]]),
    :doc "Call describeKeyPairs, describeKeyPairs"}
   [credentials7375 & args7376]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7377
     (com.palletops.awaze.common/aws-client :ec2 credentials7375)]
    (clojure.core/case
     (clojure.core/count args7376)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7377
       describeKeyPairs
       (ec2/describe-key-pairs-request (clojure.core/nth args7376 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7377
       describeKeyPairs))))))
 (do
  (clojure.core/defmethod
   ec2
   :accept-vpc-peering-connection
   [m7378]
   (clojure.core/let
    [credentials7379 (:credentials m7378) args7380 (:args m7378)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7381
      (com.palletops.awaze.common/aws-client :ec2 credentials7379)]
     (clojure.core/case
      (clojure.core/count args7380)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7381
        acceptVpcPeeringConnection))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7381
        acceptVpcPeeringConnection
        (ec2/accept-vpc-peering-connection-request
         (clojure.core/nth args7380 0))))))))
  (clojure.core/defn
   accept-vpc-peering-connection-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]]),
    :doc "Generate map for acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   accept-vpc-peering-connection
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]]),
    :doc "Call acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   [credentials7383 & args7384]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7385
     (com.palletops.awaze.common/aws-client :ec2 credentials7383)]
    (clojure.core/case
     (clojure.core/count args7384)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7385
       acceptVpcPeeringConnection))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7385
       acceptVpcPeeringConnection
       (ec2/accept-vpc-peering-connection-request
        (clojure.core/nth args7384 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl-entry
   [m7386]
   (clojure.core/let
    [credentials7387 (:credentials m7386) args7388 (:args m7386)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7389
      (com.palletops.awaze.common/aws-client :ec2 credentials7387)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7389
       deleteNetworkAclEntry
       (ec2/delete-network-acl-entry-request
        (clojure.core/nth args7388 0)))))))
  (clojure.core/defn
   delete-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-number
                         network-acl-id
                         general-progress-listener
                         egress]}]]),
    :doc "Generate map for deleteNetworkAclEntry"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-network-acl-entry,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [rule-number
                         network-acl-id
                         general-progress-listener
                         egress]}]]),
    :doc "Call deleteNetworkAclEntry"}
   [credentials7391 & args7392]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7393
     (com.palletops.awaze.common/aws-client :ec2 credentials7391)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7393
      deleteNetworkAclEntry
      (ec2/delete-network-acl-entry-request
       (clojure.core/nth args7392 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :purchase-reserved-instances-offering
   [m7394]
   (clojure.core/let
    [credentials7395 (:credentials m7394) args7396 (:args m7394)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7397
      (com.palletops.awaze.common/aws-client :ec2 credentials7395)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7397
       purchaseReservedInstancesOffering
       (ec2/purchase-reserved-instances-offering-request
        (clojure.core/nth args7396 0)))))))
  (clojure.core/defn
   purchase-reserved-instances-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-offering-id
                         limit-price
                         instance-count
                         general-progress-listener]}]]),
    :doc "Generate map for purchaseReservedInstancesOffering"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :purchase-reserved-instances-offering,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   purchase-reserved-instances-offering
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-offering-id
                         limit-price
                         instance-count
                         general-progress-listener]}]]),
    :doc "Call purchaseReservedInstancesOffering"}
   [credentials7399 & args7400]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7401
     (com.palletops.awaze.common/aws-client :ec2 credentials7399)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7401
      purchaseReservedInstancesOffering
      (ec2/purchase-reserved-instances-offering-request
       (clojure.core/nth args7400 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-reserved-instances-listing
   [m7402]
   (clojure.core/let
    [credentials7403 (:credentials m7402) args7404 (:args m7402)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7405
      (com.palletops.awaze.common/aws-client :ec2 credentials7403)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7405
       cancelReservedInstancesListing
       (ec2/cancel-reserved-instances-listing-request
        (clojure.core/nth args7404 0)))))))
  (clojure.core/defn
   cancel-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         general-progress-listener]}]]),
    :doc "Generate map for cancelReservedInstancesListing"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-reserved-instances-listing,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         general-progress-listener]}]]),
    :doc "Call cancelReservedInstancesListing"}
   [credentials7407 & args7408]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7409
     (com.palletops.awaze.common/aws-client :ec2 credentials7407)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7409
      cancelReservedInstancesListing
      (ec2/cancel-reserved-instances-listing-request
       (clojure.core/nth args7408 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-egress
   [m7410]
   (clojure.core/let
    [credentials7411 (:credentials m7410) args7412 (:args m7410)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7413
      (com.palletops.awaze.common/aws-client :ec2 credentials7411)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7413
       revokeSecurityGroupEgress
       (ec2/revoke-security-group-egress-request
        (clojure.core/nth args7412 0)))))))
  (clojure.core/defn
   revoke-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Generate map for revokeSecurityGroupEgress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :revoke-security-group-egress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   revoke-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Call revokeSecurityGroupEgress"}
   [credentials7415 & args7416]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7417
     (com.palletops.awaze.common/aws-client :ec2 credentials7415)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7417
      revokeSecurityGroupEgress
      (ec2/revoke-security-group-egress-request
       (clojure.core/nth args7416 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-spot-datafeed-subscription
   [m7418]
   (clojure.core/let
    [credentials7419 (:credentials m7418) args7420 (:args m7418)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7421
      (com.palletops.awaze.common/aws-client :ec2 credentials7419)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7421
       createSpotDatafeedSubscription
       (ec2/create-spot-datafeed-subscription-request
        (clojure.core/nth args7420 0)))))))
  (clojure.core/defn
   create-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [prefix general-progress-listener bucket]}]]),
    :doc "Generate map for createSpotDatafeedSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-spot-datafeed-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [prefix general-progress-listener bucket]}]]),
    :doc "Call createSpotDatafeedSubscription"}
   [credentials7423 & args7424]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7425
     (com.palletops.awaze.common/aws-client :ec2 credentials7423)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7425
      createSpotDatafeedSubscription
      (ec2/create-spot-datafeed-subscription-request
       (clojure.core/nth args7424 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-volume-io
   [m7426]
   (clojure.core/let
    [credentials7427 (:credentials m7426) args7428 (:args m7426)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7429
      (com.palletops.awaze.common/aws-client :ec2 credentials7427)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7429
       enableVolumeIO
       (ec2/enable-volume-iorequest (clojure.core/nth args7428 0)))))))
  (clojure.core/defn
   enable-volume-io-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id general-progress-listener]}]]),
    :doc "Generate map for enableVolumeIO"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :enable-volume-io,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-volume-io
   {:arglists (quote
               [[credentials
                 {:keys [volume-id general-progress-listener]}]]),
    :doc "Call enableVolumeIO"}
   [credentials7431 & args7432]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7433
     (com.palletops.awaze.common/aws-client :ec2 credentials7431)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7433
      enableVolumeIO
      (ec2/enable-volume-iorequest (clojure.core/nth args7432 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-association
   [m7434]
   (clojure.core/let
    [credentials7435 (:credentials m7434) args7436 (:args m7434)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7437
      (com.palletops.awaze.common/aws-client :ec2 credentials7435)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7437
       replaceNetworkAclAssociation
       (ec2/replace-network-acl-association-request
        (clojure.core/nth args7436 0)))))))
  (clojure.core/defn
   replace-network-acl-association-map
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-id
                         general-progress-listener
                         association-id]}]]),
    :doc "Generate map for replaceNetworkAclAssociation"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-network-acl-association,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   replace-network-acl-association
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-id
                         general-progress-listener
                         association-id]}]]),
    :doc "Call replaceNetworkAclAssociation"}
   [credentials7439 & args7440]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7441
     (com.palletops.awaze.common/aws-client :ec2 credentials7439)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7441
      replaceNetworkAclAssociation
      (ec2/replace-network-acl-association-request
       (clojure.core/nth args7440 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc-peering-connection
   [m7442]
   (clojure.core/let
    [credentials7443 (:credentials m7442) args7444 (:args m7442)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7445
      (com.palletops.awaze.common/aws-client :ec2 credentials7443)]
     (clojure.core/case
      (clojure.core/count args7444)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7445
        deleteVpcPeeringConnection))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7445
        deleteVpcPeeringConnection
        (ec2/delete-vpc-peering-connection-request
         (clojure.core/nth args7444 0))))))))
  (clojure.core/defn
   delete-vpc-peering-connection-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]]),
    :doc "Generate map for deleteVpcPeeringConnection, deleteVpcPeeringConnection"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :delete-vpc-peering-connection,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpc-peering-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-vpc-peering-connection
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]]),
    :doc "Call deleteVpcPeeringConnection, deleteVpcPeeringConnection"}
   [credentials7447 & args7448]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7449
     (com.palletops.awaze.common/aws-client :ec2 credentials7447)]
    (clojure.core/case
     (clojure.core/count args7448)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7449
       deleteVpcPeeringConnection))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7449
       deleteVpcPeeringConnection
       (ec2/delete-vpc-peering-connection-request
        (clojure.core/nth args7448 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-snapshot
   [m7450]
   (clojure.core/let
    [credentials7451 (:credentials m7450) args7452 (:args m7450)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7453
      (com.palletops.awaze.common/aws-client :ec2 credentials7451)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7453
       copySnapshot
       (ec2/copy-snapshot-request (clojure.core/nth args7452 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         destination-region
                         source-snapshot-id
                         source-region
                         presigned-url
                         description]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :copy-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         destination-region
                         source-snapshot-id
                         source-region
                         presigned-url
                         description]}]]),
    :doc "Call copySnapshot"}
   [credentials7455 & args7456]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7457
     (com.palletops.awaze.common/aws-client :ec2 credentials7455)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7457
      copySnapshot
      (ec2/copy-snapshot-request (clojure.core/nth args7456 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-customer-gateway
   [m7458]
   (clojure.core/let
    [credentials7459 (:credentials m7458) args7460 (:args m7458)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7461
      (com.palletops.awaze.common/aws-client :ec2 credentials7459)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7461
       createCustomerGateway
       (ec2/create-customer-gateway-request
        (clojure.core/nth args7460 0)))))))
  (clojure.core/defn
   create-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [type
                         public-ip
                         general-progress-listener
                         bgp-asn]}]]),
    :doc "Generate map for createCustomerGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-customer-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [type
                         public-ip
                         general-progress-listener
                         bgp-asn]}]]),
    :doc "Call createCustomerGateway"}
   [credentials7463 & args7464]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7465
     (com.palletops.awaze.common/aws-client :ec2 credentials7463)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7465
      createCustomerGateway
      (ec2/create-customer-gateway-request
       (clojure.core/nth args7464 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-offerings
   [m7466]
   (clojure.core/let
    [credentials7467 (:credentials m7466) args7468 (:args m7466)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7469
      (com.palletops.awaze.common/aws-client :ec2 credentials7467)]
     (clojure.core/case
      (clojure.core/count args7468)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7469
        describeReservedInstancesOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7469
        describeReservedInstancesOfferings
        (ec2/describe-reserved-instances-offerings-request
         (clojure.core/nth args7468 0))))))))
  (clojure.core/defn
   describe-reserved-instances-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [instance-type
                         reserved-instances-offering-ids
                         min-duration
                         general-progress-listener
                         filters
                         max-duration
                         availability-zone
                         max-instance-count
                         max-results
                         product-description
                         next-token
                         offering-type
                         instance-tenancy
                         include-marketplace]}]]),
    :doc "Generate map for describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-instances-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [instance-type
                         reserved-instances-offering-ids
                         min-duration
                         general-progress-listener
                         filters
                         max-duration
                         availability-zone
                         max-instance-count
                         max-results
                         product-description
                         next-token
                         offering-type
                         instance-tenancy
                         include-marketplace]}]]),
    :doc "Call describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   [credentials7471 & args7472]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7473
     (com.palletops.awaze.common/aws-client :ec2 credentials7471)]
    (clojure.core/case
     (clojure.core/count args7472)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7473
       describeReservedInstancesOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7473
       describeReservedInstancesOfferings
       (ec2/describe-reserved-instances-offerings-request
        (clojure.core/nth args7472 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-bundle-task
   [m7474]
   (clojure.core/let
    [credentials7475 (:credentials m7474) args7476 (:args m7474)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7477
      (com.palletops.awaze.common/aws-client :ec2 credentials7475)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7477
       cancelBundleTask
       (ec2/cancel-bundle-task-request (clojure.core/nth args7476 0)))))))
  (clojure.core/defn
   cancel-bundle-task-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bundle-id]}]]),
    :doc "Generate map for cancelBundleTask"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-bundle-task,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-bundle-task
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bundle-id]}]]),
    :doc "Call cancelBundleTask"}
   [credentials7479 & args7480]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7481
     (com.palletops.awaze.common/aws-client :ec2 credentials7479)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7481
      cancelBundleTask
      (ec2/cancel-bundle-task-request (clojure.core/nth args7480 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-images
   [m7482]
   (clojure.core/let
    [credentials7483 (:credentials m7482) args7484 (:args m7482)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7485
      (com.palletops.awaze.common/aws-client :ec2 credentials7483)]
     (clojure.core/case
      (clojure.core/count args7484)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7485
        describeImages))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7485
        describeImages
        (ec2/describe-images-request (clojure.core/nth args7484 0))))))))
  (clojure.core/defn
   describe-images-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [owners
                         general-progress-listener
                         executable-users
                         image-ids
                         filters]}]]),
    :doc "Generate map for describeImages, describeImages"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-images,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-images,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-images
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [owners
                         general-progress-listener
                         executable-users
                         image-ids
                         filters]}]]),
    :doc "Call describeImages, describeImages"}
   [credentials7487 & args7488]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7489
     (com.palletops.awaze.common/aws-client :ec2 credentials7487)]
    (clojure.core/case
     (clojure.core/count args7488)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7489
       describeImages))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7489
       describeImages
       (ec2/describe-images-request (clojure.core/nth args7488 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-dhcp-options
   [m7490]
   (clojure.core/let
    [credentials7491 (:credentials m7490) args7492 (:args m7490)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7493
      (com.palletops.awaze.common/aws-client :ec2 credentials7491)]
     (clojure.core/case
      (clojure.core/count args7492)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7493
        describeDhcpOptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7493
        describeDhcpOptions
        (ec2/describe-dhcp-options-request
         (clojure.core/nth args7492 0))))))))
  (clojure.core/defn
   describe-dhcp-options-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         dhcp-options-ids]}]]),
    :doc "Generate map for describeDhcpOptions, describeDhcpOptions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-dhcp-options,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-dhcp-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dhcp-options
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         dhcp-options-ids]}]]),
    :doc "Call describeDhcpOptions, describeDhcpOptions"}
   [credentials7495 & args7496]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7497
     (com.palletops.awaze.common/aws-client :ec2 credentials7495)]
    (clojure.core/case
     (clojure.core/count args7496)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7497
       describeDhcpOptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7497
       describeDhcpOptions
       (ec2/describe-dhcp-options-request
        (clojure.core/nth args7496 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection
   [m7498]
   (clojure.core/let
    [credentials7499 (:credentials m7498) args7500 (:args m7498)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7501
      (com.palletops.awaze.common/aws-client :ec2 credentials7499)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7501
       deleteVpnConnection
       (ec2/delete-vpn-connection-request
        (clojure.core/nth args7500 0)))))))
  (clojure.core/defn
   delete-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id general-progress-listener]}]]),
    :doc "Generate map for deleteVpnConnection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpn-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id general-progress-listener]}]]),
    :doc "Call deleteVpnConnection"}
   [credentials7503 & args7504]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7505
     (com.palletops.awaze.common/aws-client :ec2 credentials7503)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7505
      deleteVpnConnection
      (ec2/delete-vpn-connection-request
       (clojure.core/nth args7504 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection-route
   [m7506]
   (clojure.core/let
    [credentials7507 (:credentials m7506) args7508 (:args m7506)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7509
      (com.palletops.awaze.common/aws-client :ec2 credentials7507)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7509
       createVpnConnectionRoute
       (ec2/create-vpn-connection-route-request
        (clojure.core/nth args7508 0)))))))
  (clojure.core/defn
   create-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Generate map for createVpnConnectionRoute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpn-connection-route,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Call createVpnConnectionRoute"}
   [credentials7511 & args7512]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7513
     (com.palletops.awaze.common/aws-client :ec2 credentials7511)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7513
      createVpnConnectionRoute
      (ec2/create-vpn-connection-route-request
       (clojure.core/nth args7512 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-key-pair
   [m7514]
   (clojure.core/let
    [credentials7515 (:credentials m7514) args7516 (:args m7514)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7517
      (com.palletops.awaze.common/aws-client :ec2 credentials7515)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7517
       createKeyPair
       (ec2/create-key-pair-request (clojure.core/nth args7516 0)))))))
  (clojure.core/defn
   create-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [key-name general-progress-listener]}]]),
    :doc "Generate map for createKeyPair"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-key-pair,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [key-name general-progress-listener]}]]),
    :doc "Call createKeyPair"}
   [credentials7519 & args7520]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7521
     (com.palletops.awaze.common/aws-client :ec2 credentials7519)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7521
      createKeyPair
      (ec2/create-key-pair-request (clojure.core/nth args7520 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-account-attributes
   [m7522]
   (clojure.core/let
    [credentials7523 (:credentials m7522) args7524 (:args m7522)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7525
      (com.palletops.awaze.common/aws-client :ec2 credentials7523)]
     (clojure.core/case
      (clojure.core/count args7524)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7525
        describeAccountAttributes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7525
        describeAccountAttributes
        (ec2/describe-account-attributes-request
         (clojure.core/nth args7524 0))))))))
  (clojure.core/defn
   describe-account-attributes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener attribute-names]}]]),
    :doc "Generate map for describeAccountAttributes, describeAccountAttributes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-account-attributes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-account-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-account-attributes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener attribute-names]}]]),
    :doc "Call describeAccountAttributes, describeAccountAttributes"}
   [credentials7527 & args7528]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7529
     (com.palletops.awaze.common/aws-client :ec2 credentials7527)]
    (clojure.core/case
     (clojure.core/count args7528)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7529
       describeAccountAttributes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7529
       describeAccountAttributes
       (ec2/describe-account-attributes-request
        (clojure.core/nth args7528 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-datafeed-subscription
   [m7530]
   (clojure.core/let
    [credentials7531 (:credentials m7530) args7532 (:args m7530)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7533
      (com.palletops.awaze.common/aws-client :ec2 credentials7531)]
     (clojure.core/case
      (clojure.core/count args7532)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7533
        describeSpotDatafeedSubscription))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7533
        describeSpotDatafeedSubscription
        (ec2/describe-spot-datafeed-subscription-request
         (clojure.core/nth args7532 0))))))))
  (clojure.core/defn
   describe-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-spot-datafeed-subscription
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   [credentials7535 & args7536]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7537
     (com.palletops.awaze.common/aws-client :ec2 credentials7535)]
    (clojure.core/case
     (clojure.core/count args7536)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7537
       describeSpotDatafeedSubscription))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7537
       describeSpotDatafeedSubscription
       (ec2/describe-spot-datafeed-subscription-request
        (clojure.core/nth args7536 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-internet-gateways
   [m7538]
   (clojure.core/let
    [credentials7539 (:credentials m7538) args7540 (:args m7538)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7541
      (com.palletops.awaze.common/aws-client :ec2 credentials7539)]
     (clojure.core/case
      (clojure.core/count args7540)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7541
        describeInternetGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7541
        describeInternetGateways
        (ec2/describe-internet-gateways-request
         (clojure.core/nth args7540 0))))))))
  (clojure.core/defn
   describe-internet-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [internet-gateway-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeInternetGateways, describeInternetGateways"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-internet-gateways,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-internet-gateways,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-internet-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [internet-gateway-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeInternetGateways, describeInternetGateways"}
   [credentials7543 & args7544]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7545
     (com.palletops.awaze.common/aws-client :ec2 credentials7543)]
    (clojure.core/case
     (clojure.core/count args7544)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7545
       describeInternetGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7545
       describeInternetGateways
       (ec2/describe-internet-gateways-request
        (clojure.core/nth args7544 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :start-instances
   [m7546]
   (clojure.core/let
    [credentials7547 (:credentials m7546) args7548 (:args m7546)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7549
      (com.palletops.awaze.common/aws-client :ec2 credentials7547)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7549
       startInstances
       (ec2/start-instances-request (clojure.core/nth args7548 0)))))))
  (clojure.core/defn
   start-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids
                         general-progress-listener
                         additional-info]}]]),
    :doc "Generate map for startInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :start-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   start-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids
                         general-progress-listener
                         additional-info]}]]),
    :doc "Call startInstances"}
   [credentials7551 & args7552]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7553
     (com.palletops.awaze.common/aws-client :ec2 credentials7551)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7553
      startInstances
      (ec2/start-instances-request (clojure.core/nth args7552 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-network-interface
   [m7554]
   (clojure.core/let
    [credentials7555 (:credentials m7554) args7556 (:args m7554)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7557
      (com.palletops.awaze.common/aws-client :ec2 credentials7555)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7557
       attachNetworkInterface
       (ec2/attach-network-interface-request
        (clojure.core/nth args7556 0)))))))
  (clojure.core/defn
   attach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         instance-id
                         general-progress-listener
                         device-index]}]]),
    :doc "Generate map for attachNetworkInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-network-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   attach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         instance-id
                         general-progress-listener
                         device-index]}]]),
    :doc "Call attachNetworkInterface"}
   [credentials7559 & args7560]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7561
     (com.palletops.awaze.common/aws-client :ec2 credentials7559)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7561
      attachNetworkInterface
      (ec2/attach-network-interface-request
       (clojure.core/nth args7560 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route
   [m7562]
   (clojure.core/let
    [credentials7563 (:credentials m7562) args7564 (:args m7562)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7565
      (com.palletops.awaze.common/aws-client :ec2 credentials7563)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7565
       createRoute
       (ec2/create-route-request (clojure.core/nth args7564 0)))))))
  (clojure.core/defn
   create-route-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-id
                         destination-cidr-block
                         network-interface-id
                         vpc-peering-connection-id
                         instance-id
                         route-table-id]}]]),
    :doc "Generate map for createRoute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-route,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-route
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-id
                         destination-cidr-block
                         network-interface-id
                         vpc-peering-connection-id
                         instance-id
                         route-table-id]}]]),
    :doc "Call createRoute"}
   [credentials7567 & args7568]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7569
     (com.palletops.awaze.common/aws-client :ec2 credentials7567)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7569
      createRoute
      (ec2/create-route-request (clojure.core/nth args7568 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :unmonitor-instances
   [m7570]
   (clojure.core/let
    [credentials7571 (:credentials m7570) args7572 (:args m7570)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7573
      (com.palletops.awaze.common/aws-client :ec2 credentials7571)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7573
       unmonitorInstances
       (ec2/unmonitor-instances-request (clojure.core/nth args7572 0)))))))
  (clojure.core/defn
   unmonitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Generate map for unmonitorInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :unmonitor-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   unmonitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Call unmonitorInstances"}
   [credentials7575 & args7576]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7577
     (com.palletops.awaze.common/aws-client :ec2 credentials7575)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7577
      unmonitorInstances
      (ec2/unmonitor-instances-request (clojure.core/nth args7576 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-interface
   [m7578]
   (clojure.core/let
    [credentials7579 (:credentials m7578) args7580 (:args m7578)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7581
      (com.palletops.awaze.common/aws-client :ec2 credentials7579)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7581
       deleteNetworkInterface
       (ec2/delete-network-interface-request
        (clojure.core/nth args7580 0)))))))
  (clojure.core/defn
   delete-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         general-progress-listener]}]]),
    :doc "Generate map for deleteNetworkInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-network-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         general-progress-listener]}]]),
    :doc "Call deleteNetworkInterface"}
   [credentials7583 & args7584]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7585
     (com.palletops.awaze.common/aws-client :ec2 credentials7583)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7585
      deleteNetworkInterface
      (ec2/delete-network-interface-request
       (clojure.core/nth args7584 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :monitor-instances
   [m7586]
   (clojure.core/let
    [credentials7587 (:credentials m7586) args7588 (:args m7586)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7589
      (com.palletops.awaze.common/aws-client :ec2 credentials7587)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7589
       monitorInstances
       (ec2/monitor-instances-request (clojure.core/nth args7588 0)))))))
  (clojure.core/defn
   monitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Generate map for monitorInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :monitor-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   monitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Call monitorInstances"}
   [credentials7591 & args7592]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7593
     (com.palletops.awaze.common/aws-client :ec2 credentials7591)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7593
      monitorInstances
      (ec2/monitor-instances-request (clojure.core/nth args7592 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-listings
   [m7594]
   (clojure.core/let
    [credentials7595 (:credentials m7594) args7596 (:args m7594)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7597
      (com.palletops.awaze.common/aws-client :ec2 credentials7595)]
     (clojure.core/case
      (clojure.core/count args7596)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7597
        describeReservedInstancesListings
        (ec2/describe-reserved-instances-listings-request
         (clojure.core/nth args7596 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7597
        describeReservedInstancesListings))))))
  (clojure.core/defn
   describe-reserved-instances-listings-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         reserved-instances-id
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeReservedInstancesListings, describeReservedInstancesListings"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-instances-listings
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         reserved-instances-id
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeReservedInstancesListings, describeReservedInstancesListings"}
   [credentials7599 & args7600]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7601
     (com.palletops.awaze.common/aws-client :ec2 credentials7599)]
    (clojure.core/case
     (clojure.core/count args7600)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7601
       describeReservedInstancesListings
       (ec2/describe-reserved-instances-listings-request
        (clojure.core/nth args7600 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7601
       describeReservedInstancesListings))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-tags
   [m7602]
   (clojure.core/let
    [credentials7603 (:credentials m7602) args7604 (:args m7602)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7605
      (com.palletops.awaze.common/aws-client :ec2 credentials7603)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7605
       createTags
       (ec2/create-tags-request (clojure.core/nth args7604 0)))))))
  (clojure.core/defn
   create-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags resources general-progress-listener]}]]),
    :doc "Generate map for createTags"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags resources general-progress-listener]}]]),
    :doc "Call createTags"}
   [credentials7607 & args7608]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7609
     (com.palletops.awaze.common/aws-client :ec2 credentials7607)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7609
      createTags
      (ec2/create-tags-request (clojure.core/nth args7608 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :confirm-product-instance
   [m7610]
   (clojure.core/let
    [credentials7611 (:credentials m7610) args7612 (:args m7610)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7613
      (com.palletops.awaze.common/aws-client :ec2 credentials7611)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7613
       confirmProductInstance
       (ec2/confirm-product-instance-request
        (clojure.core/nth args7612 0)))))))
  (clojure.core/defn
   confirm-product-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [product-code
                         instance-id
                         general-progress-listener]}]]),
    :doc "Generate map for confirmProductInstance"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :confirm-product-instance,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   confirm-product-instance
   {:arglists (quote
               [[credentials
                 {:keys [product-code
                         instance-id
                         general-progress-listener]}]]),
    :doc "Call confirmProductInstance"}
   [credentials7615 & args7616]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7617
     (com.palletops.awaze.common/aws-client :ec2 credentials7615)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7617
      confirmProductInstance
      (ec2/confirm-product-instance-request
       (clojure.core/nth args7616 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-route-table
   [m7618]
   (clojure.core/let
    [credentials7619 (:credentials m7618) args7620 (:args m7618)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7621
      (com.palletops.awaze.common/aws-client :ec2 credentials7619)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7621
       disassociateRouteTable
       (ec2/disassociate-route-table-request
        (clojure.core/nth args7620 0)))))))
  (clojure.core/defn
   disassociate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener association-id]}]]),
    :doc "Generate map for disassociateRouteTable"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :disassociate-route-table,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disassociate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener association-id]}]]),
    :doc "Call disassociateRouteTable"}
   [credentials7623 & args7624]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7625
     (com.palletops.awaze.common/aws-client :ec2 credentials7623)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7625
      disassociateRouteTable
      (ec2/disassociate-route-table-request
       (clojure.core/nth args7624 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-address
   [m7626]
   (clojure.core/let
    [credentials7627 (:credentials m7626) args7628 (:args m7626)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7629
      (com.palletops.awaze.common/aws-client :ec2 credentials7627)]
     (clojure.core/case
      (clojure.core/count args7628)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7629
        disassociateAddress))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7629
        disassociateAddress
        (ec2/disassociate-address-request
         (clojure.core/nth args7628 0))))))))
  (clojure.core/defn
   disassociate-address-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [public-ip
                         general-progress-listener
                         association-id]}]]),
    :doc "Generate map for disassociateAddress, disassociateAddress"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :disassociate-address,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :disassociate-address,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disassociate-address
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [public-ip
                         general-progress-listener
                         association-id]}]]),
    :doc "Call disassociateAddress, disassociateAddress"}
   [credentials7631 & args7632]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7633
     (com.palletops.awaze.common/aws-client :ec2 credentials7631)]
    (clojure.core/case
     (clojure.core/count args7632)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7633
       disassociateAddress))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7633
       disassociateAddress
       (ec2/disassociate-address-request
        (clojure.core/nth args7632 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-network-interface
   [m7634]
   (clojure.core/let
    [credentials7635 (:credentials m7634) args7636 (:args m7634)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7637
      (com.palletops.awaze.common/aws-client :ec2 credentials7635)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7637
       detachNetworkInterface
       (ec2/detach-network-interface-request
        (clojure.core/nth args7636 0)))))))
  (clojure.core/defn
   detach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force
                         attachment-id]}]]),
    :doc "Generate map for detachNetworkInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-network-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   detach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force
                         attachment-id]}]]),
    :doc "Call detachNetworkInterface"}
   [credentials7639 & args7640]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7641
     (com.palletops.awaze.common/aws-client :ec2 credentials7639)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7641
      detachNetworkInterface
      (ec2/detach-network-interface-request
       (clojure.core/nth args7640 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-export-tasks
   [m7642]
   (clojure.core/let
    [credentials7643 (:credentials m7642) args7644 (:args m7642)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7645
      (com.palletops.awaze.common/aws-client :ec2 credentials7643)]
     (clojure.core/case
      (clojure.core/count args7644)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7645
        describeExportTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7645
        describeExportTasks
        (ec2/describe-export-tasks-request
         (clojure.core/nth args7644 0))))))))
  (clojure.core/defn
   describe-export-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener export-task-ids]}]]),
    :doc "Generate map for describeExportTasks, describeExportTasks"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-export-tasks,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-export-tasks,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-export-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener export-task-ids]}]]),
    :doc "Call describeExportTasks, describeExportTasks"}
   [credentials7647 & args7648]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7649
     (com.palletops.awaze.common/aws-client :ec2 credentials7647)]
    (clojure.core/case
     (clojure.core/count args7648)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7649
       describeExportTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7649
       describeExportTasks
       (ec2/describe-export-tasks-request
        (clojure.core/nth args7648 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-addresses
   [m7650]
   (clojure.core/let
    [credentials7651 (:credentials m7650) args7652 (:args m7650)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7653
      (com.palletops.awaze.common/aws-client :ec2 credentials7651)]
     (clojure.core/case
      (clojure.core/count args7652)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7653
        describeAddresses
        (ec2/describe-addresses-request (clojure.core/nth args7652 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7653
        describeAddresses))))))
  (clojure.core/defn
   describe-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [public-ips
                         general-progress-listener
                         filters
                         allocation-ids]}]
                [credentials]]),
    :doc "Generate map for describeAddresses, describeAddresses"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-addresses,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-addresses,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-addresses
   {:arglists (quote
               [[credentials
                 {:keys [public-ips
                         general-progress-listener
                         filters
                         allocation-ids]}]
                [credentials]]),
    :doc "Call describeAddresses, describeAddresses"}
   [credentials7655 & args7656]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7657
     (com.palletops.awaze.common/aws-client :ec2 credentials7655)]
    (clojure.core/case
     (clojure.core/count args7656)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7657
       describeAddresses
       (ec2/describe-addresses-request (clojure.core/nth args7656 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7657
       describeAddresses))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-instance-export-task
   [m7658]
   (clojure.core/let
    [credentials7659 (:credentials m7658) args7660 (:args m7658)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7661
      (com.palletops.awaze.common/aws-client :ec2 credentials7659)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7661
       createInstanceExportTask
       (ec2/create-instance-export-task-request
        (clojure.core/nth args7660 0)))))))
  (clojure.core/defn
   create-instance-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [target-environment
                         instance-id
                         general-progress-listener
                         export-to-s3task
                         description]}]]),
    :doc "Generate map for createInstanceExportTask"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-instance-export-task,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-instance-export-task
   {:arglists (quote
               [[credentials
                 {:keys [target-environment
                         instance-id
                         general-progress-listener
                         export-to-s3task
                         description]}]]),
    :doc "Call createInstanceExportTask"}
   [credentials7663 & args7664]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7665
     (com.palletops.awaze.common/aws-client :ec2 credentials7663)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7665
      createInstanceExportTask
      (ec2/create-instance-export-task-request
       (clojure.core/nth args7664 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-image
   [m7666]
   (clojure.core/let
    [credentials7667 (:credentials m7666) args7668 (:args m7666)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7669
      (com.palletops.awaze.common/aws-client :ec2 credentials7667)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7669
       createImage
       (ec2/create-image-request (clojure.core/nth args7668 0)))))))
  (clojure.core/defn
   create-image-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         name
                         block-device-mappings
                         no-reboot
                         instance-id
                         description]}]]),
    :doc "Generate map for createImage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-image,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-image
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         name
                         block-device-mappings
                         no-reboot
                         instance-id
                         description]}]]),
    :doc "Call createImage"}
   [credentials7671 & args7672]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7673
     (com.palletops.awaze.common/aws-client :ec2 credentials7671)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7673
      createImage
      (ec2/create-image-request (clojure.core/nth args7672 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-security-group
   [m7674]
   (clojure.core/let
    [credentials7675 (:credentials m7674) args7676 (:args m7674)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7677
      (com.palletops.awaze.common/aws-client :ec2 credentials7675)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7677
       createSecurityGroup
       (ec2/create-security-group-request
        (clojure.core/nth args7676 0)))))))
  (clojure.core/defn
   create-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         group-name
                         general-progress-listener
                         description]}]]),
    :doc "Generate map for createSecurityGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-security-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-security-group
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         group-name
                         general-progress-listener
                         description]}]]),
    :doc "Call createSecurityGroup"}
   [credentials7679 & args7680]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7681
     (com.palletops.awaze.common/aws-client :ec2 credentials7679)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7681
      createSecurityGroup
      (ec2/create-security-group-request
       (clojure.core/nth args7680 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-subnet
   [m7682]
   (clojure.core/let
    [credentials7683 (:credentials m7682) args7684 (:args m7682)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7685
      (com.palletops.awaze.common/aws-client :ec2 credentials7683)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7685
       createSubnet
       (ec2/create-subnet-request (clojure.core/nth args7684 0)))))))
  (clojure.core/defn
   create-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         cidr-block
                         availability-zone]}]]),
    :doc "Generate map for createSubnet"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-subnet,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-subnet
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         cidr-block
                         availability-zone]}]]),
    :doc "Call createSubnet"}
   [credentials7687 & args7688]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7689
     (com.palletops.awaze.common/aws-client :ec2 credentials7687)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7689
      createSubnet
      (ec2/create-subnet-request (clojure.core/nth args7688 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl
   [m7690]
   (clojure.core/let
    [credentials7691 (:credentials m7690) args7692 (:args m7690)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7693
      (com.palletops.awaze.common/aws-client :ec2 credentials7691)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7693
       deleteNetworkAcl
       (ec2/delete-network-acl-request (clojure.core/nth args7692 0)))))))
  (clojure.core/defn
   delete-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-id general-progress-listener]}]]),
    :doc "Generate map for deleteNetworkAcl"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-network-acl,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-id general-progress-listener]}]]),
    :doc "Call deleteNetworkAcl"}
   [credentials7695 & args7696]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7697
     (com.palletops.awaze.common/aws-client :ec2 credentials7695)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7697
      deleteNetworkAcl
      (ec2/delete-network-acl-request (clojure.core/nth args7696 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-interface
   [m7698]
   (clojure.core/let
    [credentials7699 (:credentials m7698) args7700 (:args m7698)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7701
      (com.palletops.awaze.common/aws-client :ec2 credentials7699)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7701
       createNetworkInterface
       (ec2/create-network-interface-request
        (clojure.core/nth args7700 0)))))))
  (clojure.core/defn
   create-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         secondary-private-ip-address-count
                         subnet-id
                         private-ip-address
                         groups
                         private-ip-addresses
                         description]}]]),
    :doc "Generate map for createNetworkInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-network-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         secondary-private-ip-address-count
                         subnet-id
                         private-ip-address
                         groups
                         private-ip-addresses
                         description]}]]),
    :doc "Call createNetworkInterface"}
   [credentials7703 & args7704]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7705
     (com.palletops.awaze.common/aws-client :ec2 credentials7703)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7705
      createNetworkInterface
      (ec2/create-network-interface-request
       (clojure.core/nth args7704 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-gateway
   [m7706]
   (clojure.core/let
    [credentials7707 (:credentials m7706) args7708 (:args m7706)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7709
      (com.palletops.awaze.common/aws-client :ec2 credentials7707)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7709
       deleteVpnGateway
       (ec2/delete-vpn-gateway-request (clojure.core/nth args7708 0)))))))
  (clojure.core/defn
   delete-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id general-progress-listener]}]]),
    :doc "Generate map for deleteVpnGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpn-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id general-progress-listener]}]]),
    :doc "Call deleteVpnGateway"}
   [credentials7711 & args7712]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7713
     (com.palletops.awaze.common/aws-client :ec2 credentials7711)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7713
      deleteVpnGateway
      (ec2/delete-vpn-gateway-request (clojure.core/nth args7712 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-volume
   [m7714]
   (clojure.core/let
    [credentials7715 (:credentials m7714) args7716 (:args m7714)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7717
      (com.palletops.awaze.common/aws-client :ec2 credentials7715)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7717
       attachVolume
       (ec2/attach-volume-request (clojure.core/nth args7716 0)))))))
  (clojure.core/defn
   attach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         instance-id
                         general-progress-listener
                         device]}]]),
    :doc "Generate map for attachVolume"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-volume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   attach-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         instance-id
                         general-progress-listener
                         device]}]]),
    :doc "Call attachVolume"}
   [credentials7719 & args7720]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7721
     (com.palletops.awaze.common/aws-client :ec2 credentials7719)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7721
      attachVolume
      (ec2/attach-volume-request (clojure.core/nth args7720 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection
   [m7722]
   (clojure.core/let
    [credentials7723 (:credentials m7722) args7724 (:args m7722)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7725
      (com.palletops.awaze.common/aws-client :ec2 credentials7723)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7725
       createVpnConnection
       (ec2/create-vpn-connection-request
        (clojure.core/nth args7724 0)))))))
  (clojure.core/defn
   create-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [options
                         type
                         vpn-gateway-id
                         general-progress-listener
                         customer-gateway-id]}]]),
    :doc "Generate map for createVpnConnection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpn-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [options
                         type
                         vpn-gateway-id
                         general-progress-listener
                         customer-gateway-id]}]]),
    :doc "Call createVpnConnection"}
   [credentials7727 & args7728]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7729
     (com.palletops.awaze.common/aws-client :ec2 credentials7727)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7729
      createVpnConnection
      (ec2/create-vpn-connection-request
       (clojure.core/nth args7728 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-placement-group
   [m7730]
   (clojure.core/let
    [credentials7731 (:credentials m7730) args7732 (:args m7730)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7733
      (com.palletops.awaze.common/aws-client :ec2 credentials7731)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7733
       deletePlacementGroup
       (ec2/delete-placement-group-request
        (clojure.core/nth args7732 0)))))))
  (clojure.core/defn
   delete-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [group-name general-progress-listener]}]]),
    :doc "Generate map for deletePlacementGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-placement-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [group-name general-progress-listener]}]]),
    :doc "Call deletePlacementGroup"}
   [credentials7735 & args7736]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7737
     (com.palletops.awaze.common/aws-client :ec2 credentials7735)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7737
      deletePlacementGroup
      (ec2/delete-placement-group-request
       (clojure.core/nth args7736 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-instance-attribute
   [m7738]
   (clojure.core/let
    [credentials7739 (:credentials m7738) args7740 (:args m7738)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7741
      (com.palletops.awaze.common/aws-client :ec2 credentials7739)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7741
       resetInstanceAttribute
       (ec2/reset-instance-attribute-request
        (clojure.core/nth args7740 0)))))))
  (clojure.core/defn
   reset-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Generate map for resetInstanceAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-instance-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reset-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [instance-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Call resetInstanceAttribute"}
   [credentials7743 & args7744]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7745
     (com.palletops.awaze.common/aws-client :ec2 credentials7743)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7745
      resetInstanceAttribute
      (ec2/reset-instance-attribute-request
       (clojure.core/nth args7744 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-snapshot
   [m7746]
   (clojure.core/let
    [credentials7747 (:credentials m7746) args7748 (:args m7746)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7749
      (com.palletops.awaze.common/aws-client :ec2 credentials7747)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7749
       createSnapshot
       (ec2/create-snapshot-request (clojure.core/nth args7748 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         description]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         description]}]]),
    :doc "Call createSnapshot"}
   [credentials7751 & args7752]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7753
     (com.palletops.awaze.common/aws-client :ec2 credentials7751)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7753
      createSnapshot
      (ec2/create-snapshot-request (clojure.core/nth args7752 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :request-spot-instances
   [m7754]
   (clojure.core/let
    [credentials7755 (:credentials m7754) args7756 (:args m7754)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7757
      (com.palletops.awaze.common/aws-client :ec2 credentials7755)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7757
       requestSpotInstances
       (ec2/request-spot-instances-request
        (clojure.core/nth args7756 0)))))))
  (clojure.core/defn
   request-spot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         valid-from
                         spot-price
                         launch-group
                         instance-count
                         launch-specification
                         type
                         availability-zone-group
                         valid-until]}]]),
    :doc "Generate map for requestSpotInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :request-spot-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   request-spot-instances
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         valid-from
                         spot-price
                         launch-group
                         instance-count
                         launch-specification
                         type
                         availability-zone-group
                         valid-until]}]]),
    :doc "Call requestSpotInstances"}
   [credentials7759 & args7760]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7761
     (com.palletops.awaze.common/aws-client :ec2 credentials7759)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7761
      requestSpotInstances
      (ec2/request-spot-instances-request
       (clojure.core/nth args7760 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interfaces
   [m7762]
   (clojure.core/let
    [credentials7763 (:credentials m7762) args7764 (:args m7762)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7765
      (com.palletops.awaze.common/aws-client :ec2 credentials7763)]
     (clojure.core/case
      (clojure.core/count args7764)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7765
        describeNetworkInterfaces
        (ec2/describe-network-interfaces-request
         (clojure.core/nth args7764 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7765
        describeNetworkInterfaces))))))
  (clojure.core/defn
   describe-network-interfaces-map
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeNetworkInterfaces, describeNetworkInterfaces"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-network-interfaces,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-network-interfaces,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-network-interfaces
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeNetworkInterfaces, describeNetworkInterfaces"}
   [credentials7767 & args7768]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7769
     (com.palletops.awaze.common/aws-client :ec2 credentials7767)]
    (clojure.core/case
     (clojure.core/count args7768)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7769
       describeNetworkInterfaces
       (ec2/describe-network-interfaces-request
        (clojure.core/nth args7768 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7769
       describeNetworkInterfaces))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-volume
   [m7770]
   (clojure.core/let
    [credentials7771 (:credentials m7770) args7772 (:args m7770)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7773
      (com.palletops.awaze.common/aws-client :ec2 credentials7771)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7773
       deleteVolume
       (ec2/delete-volume-request (clojure.core/nth args7772 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id general-progress-listener]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-volume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-id general-progress-listener]}]]),
    :doc "Call deleteVolume"}
   [credentials7775 & args7776]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7777
     (com.palletops.awaze.common/aws-client :ec2 credentials7775)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7777
      deleteVolume
      (ec2/delete-volume-request (clojure.core/nth args7776 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-snapshot
   [m7778]
   (clojure.core/let
    [credentials7779 (:credentials m7778) args7780 (:args m7778)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7781
      (com.palletops.awaze.common/aws-client :ec2 credentials7779)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7781
       deleteSnapshot
       (ec2/delete-snapshot-request (clojure.core/nth args7780 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id general-progress-listener]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id general-progress-listener]}]]),
    :doc "Call deleteSnapshot"}
   [credentials7783 & args7784]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7785
     (com.palletops.awaze.common/aws-client :ec2 credentials7783)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7785
      deleteSnapshot
      (ec2/delete-snapshot-request (clojure.core/nth args7784 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instances
   [m7786]
   (clojure.core/let
    [credentials7787 (:credentials m7786) args7788 (:args m7786)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7789
      (com.palletops.awaze.common/aws-client :ec2 credentials7787)]
     (clojure.core/case
      (clojure.core/count args7788)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7789
        describeInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7789
        describeInstances
        (ec2/describe-instances-request (clojure.core/nth args7788 0))))))))
  (clojure.core/defn
   describe-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [instance-ids
                         general-progress-listener
                         next-token
                         filters
                         max-results]}]]),
    :doc "Generate map for describeInstances, describeInstances"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-instances,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [instance-ids
                         general-progress-listener
                         next-token
                         filters
                         max-results]}]]),
    :doc "Call describeInstances, describeInstances"}
   [credentials7791 & args7792]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7793
     (com.palletops.awaze.common/aws-client :ec2 credentials7791)]
    (clojure.core/case
     (clojure.core/count args7792)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7793
       describeInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7793
       describeInstances
       (ec2/describe-instances-request (clojure.core/nth args7792 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-route-table
   [m7794]
   (clojure.core/let
    [credentials7795 (:credentials m7794) args7796 (:args m7794)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7797
      (com.palletops.awaze.common/aws-client :ec2 credentials7795)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7797
       associateRouteTable
       (ec2/associate-route-table-request
        (clojure.core/nth args7796 0)))))))
  (clojure.core/defn
   associate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id
                         route-table-id
                         general-progress-listener]}]]),
    :doc "Generate map for associateRouteTable"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :associate-route-table,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   associate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id
                         route-table-id
                         general-progress-listener]}]]),
    :doc "Call associateRouteTable"}
   [credentials7799 & args7800]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7801
     (com.palletops.awaze.common/aws-client :ec2 credentials7799)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7801
      associateRouteTable
      (ec2/associate-route-table-request
       (clojure.core/nth args7800 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vgw-route-propagation
   [m7802]
   (clojure.core/let
    [credentials7803 (:credentials m7802) args7804 (:args m7802)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7805
      (com.palletops.awaze.common/aws-client :ec2 credentials7803)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7805
       disableVgwRoutePropagation
       (ec2/disable-vgw-route-propagation-request
        (clojure.core/nth args7804 0)))))))
  (clojure.core/defn
   disable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         gateway-id]}]]),
    :doc "Generate map for disableVgwRoutePropagation"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :disable-vgw-route-propagation,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         gateway-id]}]]),
    :doc "Call disableVgwRoutePropagation"}
   [credentials7807 & args7808]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7809
     (com.palletops.awaze.common/aws-client :ec2 credentials7807)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7809
      disableVgwRoutePropagation
      (ec2/disable-vgw-route-propagation-request
       (clojure.core/nth args7808 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-attribute
   [m7810]
   (clojure.core/let
    [credentials7811 (:credentials m7810) args7812 (:args m7810)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7813
      (com.palletops.awaze.common/aws-client :ec2 credentials7811)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7813
       describeInstanceAttribute
       (ec2/describe-instance-attribute-request
        (clojure.core/nth args7812 0)))))))
  (clojure.core/defn
   describe-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Generate map for describeInstanceAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-instance-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [instance-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Call describeInstanceAttribute"}
   [credentials7815 & args7816]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7817
     (com.palletops.awaze.common/aws-client :ec2 credentials7815)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7817
      describeInstanceAttribute
      (ec2/describe-instance-attribute-request
       (clojure.core/nth args7816 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-gateway
   [m7818]
   (clojure.core/let
    [credentials7819 (:credentials m7818) args7820 (:args m7818)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7821
      (com.palletops.awaze.common/aws-client :ec2 credentials7819)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7821
       createVpnGateway
       (ec2/create-vpn-gateway-request (clojure.core/nth args7820 0)))))))
  (clojure.core/defn
   create-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [type
                         general-progress-listener
                         availability-zone]}]]),
    :doc "Generate map for createVpnGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpn-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [type
                         general-progress-listener
                         availability-zone]}]]),
    :doc "Call createVpnGateway"}
   [credentials7823 & args7824]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7825
     (com.palletops.awaze.common/aws-client :ec2 credentials7823)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7825
      createVpnGateway
      (ec2/create-vpn-gateway-request (clojure.core/nth args7824 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl
   [m7826]
   (clojure.core/let
    [credentials7827 (:credentials m7826) args7828 (:args m7826)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7829
      (com.palletops.awaze.common/aws-client :ec2 credentials7827)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7829
       createNetworkAcl
       (ec2/create-network-acl-request (clojure.core/nth args7828 0)))))))
  (clojure.core/defn
   create-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Generate map for createNetworkAcl"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-network-acl,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Call createNetworkAcl"}
   [credentials7831 & args7832]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7833
     (com.palletops.awaze.common/aws-client :ec2 credentials7831)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7833
      createNetworkAcl
      (ec2/create-network-acl-request (clojure.core/nth args7832 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route
   [m7834]
   (clojure.core/let
    [credentials7835 (:credentials m7834) args7836 (:args m7834)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7837
      (com.palletops.awaze.common/aws-client :ec2 credentials7835)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7837
       replaceRoute
       (ec2/replace-route-request (clojure.core/nth args7836 0)))))))
  (clojure.core/defn
   replace-route-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-id
                         destination-cidr-block
                         network-interface-id
                         vpc-peering-connection-id
                         instance-id
                         route-table-id]}]]),
    :doc "Generate map for replaceRoute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-route,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   replace-route
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-id
                         destination-cidr-block
                         network-interface-id
                         vpc-peering-connection-id
                         instance-id
                         route-table-id]}]]),
    :doc "Call replaceRoute"}
   [credentials7839 & args7840]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7841
     (com.palletops.awaze.common/aws-client :ec2 credentials7839)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7841
      replaceRoute
      (ec2/replace-route-request (clojure.core/nth args7840 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-regions
   [m7842]
   (clojure.core/let
    [credentials7843 (:credentials m7842) args7844 (:args m7842)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7845
      (com.palletops.awaze.common/aws-client :ec2 credentials7843)]
     (clojure.core/case
      (clojure.core/count args7844)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7845
        describeRegions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7845
        describeRegions
        (ec2/describe-regions-request (clojure.core/nth args7844 0))))))))
  (clojure.core/defn
   describe-regions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [region-names
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeRegions, describeRegions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-regions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-regions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-regions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [region-names
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeRegions, describeRegions"}
   [credentials7847 & args7848]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7849
     (com.palletops.awaze.common/aws-client :ec2 credentials7847)]
    (clojure.core/case
     (clojure.core/count args7848)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7849
       describeRegions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7849
       describeRegions
       (ec2/describe-regions-request (clojure.core/nth args7848 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-internet-gateway
   [m7850]
   (clojure.core/let
    [credentials7851 (:credentials m7850) args7852 (:args m7850)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7853
      (com.palletops.awaze.common/aws-client :ec2 credentials7851)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7853
       deleteInternetGateway
       (ec2/delete-internet-gateway-request
        (clojure.core/nth args7852 0)))))))
  (clojure.core/defn
   delete-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Generate map for deleteInternetGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-internet-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Call deleteInternetGateway"}
   [credentials7855 & args7856]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7857
     (com.palletops.awaze.common/aws-client :ec2 credentials7855)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7857
      deleteInternetGateway
      (ec2/delete-internet-gateway-request
       (clojure.core/nth args7856 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route
   [m7858]
   (clojure.core/let
    [credentials7859 (:credentials m7858) args7860 (:args m7858)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7861
      (com.palletops.awaze.common/aws-client :ec2 credentials7859)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7861
       deleteRoute
       (ec2/delete-route-request (clojure.core/nth args7860 0)))))))
  (clojure.core/defn
   delete-route-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Generate map for deleteRoute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-route,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-route
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Call deleteRoute"}
   [credentials7863 & args7864]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7865
     (com.palletops.awaze.common/aws-client :ec2 credentials7863)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7865
      deleteRoute
      (ec2/delete-route-request (clojure.core/nth args7864 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :assign-private-ip-addresses
   [m7866]
   (clojure.core/let
    [credentials7867 (:credentials m7866) args7868 (:args m7866)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7869
      (com.palletops.awaze.common/aws-client :ec2 credentials7867)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7869
       assignPrivateIpAddresses
       (ec2/assign-private-ip-addresses-request
        (clojure.core/nth args7868 0)))))))
  (clojure.core/defn
   assign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [secondary-private-ip-address-count
                         private-ip-addresses
                         network-interface-id
                         general-progress-listener
                         allow-reassignment]}]]),
    :doc "Generate map for assignPrivateIpAddresses"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :assign-private-ip-addresses,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   assign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [secondary-private-ip-address-count
                         private-ip-addresses
                         network-interface-id
                         general-progress-listener
                         allow-reassignment]}]]),
    :doc "Call assignPrivateIpAddresses"}
   [credentials7871 & args7872]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7873
     (com.palletops.awaze.common/aws-client :ec2 credentials7871)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7873
      assignPrivateIpAddresses
      (ec2/assign-private-ip-addresses-request
       (clojure.core/nth args7872 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-dhcp-options
   [m7874]
   (clojure.core/let
    [credentials7875 (:credentials m7874) args7876 (:args m7874)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7877
      (com.palletops.awaze.common/aws-client :ec2 credentials7875)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7877
       deleteDhcpOptions
       (ec2/delete-dhcp-options-request (clojure.core/nth args7876 0)))))))
  (clojure.core/defn
   delete-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener dhcp-options-id]}]]),
    :doc "Generate map for deleteDhcpOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-dhcp-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener dhcp-options-id]}]]),
    :doc "Call deleteDhcpOptions"}
   [credentials7879 & args7880]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7881
     (com.palletops.awaze.common/aws-client :ec2 credentials7879)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7881
      deleteDhcpOptions
      (ec2/delete-dhcp-options-request (clojure.core/nth args7880 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-spot-instance-requests
   [m7882]
   (clojure.core/let
    [credentials7883 (:credentials m7882) args7884 (:args m7882)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7885
      (com.palletops.awaze.common/aws-client :ec2 credentials7883)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7885
       cancelSpotInstanceRequests
       (ec2/cancel-spot-instance-requests-request
        (clojure.core/nth args7884 0)))))))
  (clojure.core/defn
   cancel-spot-instance-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [spot-instance-request-ids
                         general-progress-listener]}]]),
    :doc "Generate map for cancelSpotInstanceRequests"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-spot-instance-requests,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-spot-instance-requests
   {:arglists (quote
               [[credentials
                 {:keys [spot-instance-request-ids
                         general-progress-listener]}]]),
    :doc "Call cancelSpotInstanceRequests"}
   [credentials7887 & args7888]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7889
     (com.palletops.awaze.common/aws-client :ec2 credentials7887)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7889
      cancelSpotInstanceRequests
      (ec2/cancel-spot-instance-requests-request
       (clojure.core/nth args7888 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-dhcp-options
   [m7890]
   (clojure.core/let
    [credentials7891 (:credentials m7890) args7892 (:args m7890)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7893
      (com.palletops.awaze.common/aws-client :ec2 credentials7891)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7893
       createDhcpOptions
       (ec2/create-dhcp-options-request (clojure.core/nth args7892 0)))))))
  (clojure.core/defn
   create-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dhcp-configurations]}]]),
    :doc "Generate map for createDhcpOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-dhcp-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dhcp-configurations]}]]),
    :doc "Call createDhcpOptions"}
   [credentials7895 & args7896]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7897
     (com.palletops.awaze.common/aws-client :ec2 credentials7895)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7897
      createDhcpOptions
      (ec2/create-dhcp-options-request (clojure.core/nth args7896 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :stop-instances
   [m7898]
   (clojure.core/let
    [credentials7899 (:credentials m7898) args7900 (:args m7898)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7901
      (com.palletops.awaze.common/aws-client :ec2 credentials7899)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7901
       stopInstances
       (ec2/stop-instances-request (clojure.core/nth args7900 0)))))))
  (clojure.core/defn
   stop-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener force]}]]),
    :doc "Generate map for stopInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :stop-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   stop-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener force]}]]),
    :doc "Call stopInstances"}
   [credentials7903 & args7904]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7905
     (com.palletops.awaze.common/aws-client :ec2 credentials7903)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7905
      stopInstances
      (ec2/stop-instances-request (clojure.core/nth args7904 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-ingress
   [m7906]
   (clojure.core/let
    [credentials7907 (:credentials m7906) args7908 (:args m7906)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7909
      (com.palletops.awaze.common/aws-client :ec2 credentials7907)]
     (clojure.core/case
      (clojure.core/count args7908)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7909
        authorizeSecurityGroupIngress))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7909
        authorizeSecurityGroupIngress
        (ec2/authorize-security-group-ingress-request
         (clojure.core/nth args7908 0))))))))
  (clojure.core/defn
   authorize-security-group-ingress-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]]),
    :doc "Generate map for authorizeSecurityGroupIngress, authorizeSecurityGroupIngress"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :authorize-security-group-ingress,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :authorize-security-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   authorize-security-group-ingress
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]]),
    :doc "Call authorizeSecurityGroupIngress, authorizeSecurityGroupIngress"}
   [credentials7911 & args7912]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7913
     (com.palletops.awaze.common/aws-client :ec2 credentials7911)]
    (clojure.core/case
     (clojure.core/count args7912)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7913
       authorizeSecurityGroupIngress))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7913
       authorizeSecurityGroupIngress
       (ec2/authorize-security-group-ingress-request
        (clojure.core/nth args7912 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-placement-groups
   [m7914]
   (clojure.core/let
    [credentials7915 (:credentials m7914) args7916 (:args m7914)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7917
      (com.palletops.awaze.common/aws-client :ec2 credentials7915)]
     (clojure.core/case
      (clojure.core/count args7916)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7917
        describePlacementGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7917
        describePlacementGroups
        (ec2/describe-placement-groups-request
         (clojure.core/nth args7916 0))))))))
  (clojure.core/defn
   describe-placement-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-names
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describePlacementGroups, describePlacementGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-placement-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-placement-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-placement-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-names
                         general-progress-listener
                         filters]}]]),
    :doc "Call describePlacementGroups, describePlacementGroups"}
   [credentials7919 & args7920]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7921
     (com.palletops.awaze.common/aws-client :ec2 credentials7919)]
    (clojure.core/case
     (clojure.core/count args7920)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7921
       describePlacementGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7921
       describePlacementGroups
       (ec2/describe-placement-groups-request
        (clojure.core/nth args7920 0)))))))))
