(ns
 com.palletops.awaze.directconnect
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.directconnect :as directconnect]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :directconnect
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.directconnect.AmazonDirectConnectClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.RouteFilterPrefix}
route-filter-prefix
  [m3852]
  (clojure.core/let
   [bean3851
    (new com.amazonaws.services.directconnect.model.RouteFilterPrefix)]
   (clojure.core/let
    [v3853 (:cidr m3852 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3853 :com.palletops.awaze.client-builder/undef)
     (. bean3851 setCidr (clojure.core/str v3853))))
   bean3851))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterface}
new-public-virtual-interface
  [m3855]
  (clojure.core/let
   [bean3854
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterface)]
   (clojure.core/let
    [v3856 (:asn m3855 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3856 :com.palletops.awaze.client-builder/undef)
     (. bean3854 setAsn (clojure.core/int v3856))))
   (clojure.core/let
    [v3856 (:vlan m3855 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3856 :com.palletops.awaze.client-builder/undef)
     (. bean3854 setVlan (clojure.core/int v3856))))
   (clojure.core/let
    [v3856
     (:virtual-interface-name
      m3855
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3856 :com.palletops.awaze.client-builder/undef)
     (. bean3854 setVirtualInterfaceName (clojure.core/str v3856))))
   (clojure.core/let
    [v3856
     (:auth-key m3855 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3856 :com.palletops.awaze.client-builder/undef)
     (. bean3854 setAuthKey (clojure.core/str v3856))))
   (clojure.core/let
    [v3856
     (:amazon-address m3855 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3856 :com.palletops.awaze.client-builder/undef)
     (. bean3854 setAmazonAddress (clojure.core/str v3856))))
   (clojure.core/let
    [v3856
     (:customer-address
      m3855
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3856 :com.palletops.awaze.client-builder/undef)
     (. bean3854 setCustomerAddress (clojure.core/str v3856))))
   (clojure.core/let
    [v3856
     (:route-filter-prefixes
      m3855
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3856 :com.palletops.awaze.client-builder/undef)
     (.
      bean3854
      setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg3923]
  (directconnect/route-filter-prefix arg3923))
 v3856))))
   bean3854))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface}
new-private-virtual-interface
  [m3858]
  (clojure.core/let
   [bean3857
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface)]
   (clojure.core/let
    [v3859 (:asn m3858 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3859 :com.palletops.awaze.client-builder/undef)
     (. bean3857 setAsn (clojure.core/int v3859))))
   (clojure.core/let
    [v3859
     (:virtual-gateway-id
      m3858
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3859 :com.palletops.awaze.client-builder/undef)
     (. bean3857 setVirtualGatewayId (clojure.core/str v3859))))
   (clojure.core/let
    [v3859 (:vlan m3858 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3859 :com.palletops.awaze.client-builder/undef)
     (. bean3857 setVlan (clojure.core/int v3859))))
   (clojure.core/let
    [v3859
     (:virtual-interface-name
      m3858
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3859 :com.palletops.awaze.client-builder/undef)
     (. bean3857 setVirtualInterfaceName (clojure.core/str v3859))))
   (clojure.core/let
    [v3859
     (:auth-key m3858 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3859 :com.palletops.awaze.client-builder/undef)
     (. bean3857 setAuthKey (clojure.core/str v3859))))
   (clojure.core/let
    [v3859
     (:amazon-address m3858 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3859 :com.palletops.awaze.client-builder/undef)
     (. bean3857 setAmazonAddress (clojure.core/str v3859))))
   (clojure.core/let
    [v3859
     (:customer-address
      m3858
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3859 :com.palletops.awaze.client-builder/undef)
     (. bean3857 setCustomerAddress (clojure.core/str v3859))))
   bean3857))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation}
new-private-virtual-interface-allocation
  [m3861]
  (clojure.core/let
   [bean3860
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation)]
   (clojure.core/let
    [v3862 (:asn m3861 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3862 :com.palletops.awaze.client-builder/undef)
     (. bean3860 setAsn (clojure.core/int v3862))))
   (clojure.core/let
    [v3862 (:vlan m3861 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3862 :com.palletops.awaze.client-builder/undef)
     (. bean3860 setVlan (clojure.core/int v3862))))
   (clojure.core/let
    [v3862
     (:virtual-interface-name
      m3861
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3862 :com.palletops.awaze.client-builder/undef)
     (. bean3860 setVirtualInterfaceName (clojure.core/str v3862))))
   (clojure.core/let
    [v3862
     (:auth-key m3861 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3862 :com.palletops.awaze.client-builder/undef)
     (. bean3860 setAuthKey (clojure.core/str v3862))))
   (clojure.core/let
    [v3862
     (:amazon-address m3861 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3862 :com.palletops.awaze.client-builder/undef)
     (. bean3860 setAmazonAddress (clojure.core/str v3862))))
   (clojure.core/let
    [v3862
     (:customer-address
      m3861
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3862 :com.palletops.awaze.client-builder/undef)
     (. bean3860 setCustomerAddress (clojure.core/str v3862))))
   bean3860))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation}
new-public-virtual-interface-allocation
  [m3864]
  (clojure.core/let
   [bean3863
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation)]
   (clojure.core/let
    [v3865 (:asn m3864 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3865 :com.palletops.awaze.client-builder/undef)
     (. bean3863 setAsn (clojure.core/int v3865))))
   (clojure.core/let
    [v3865 (:vlan m3864 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3865 :com.palletops.awaze.client-builder/undef)
     (. bean3863 setVlan (clojure.core/int v3865))))
   (clojure.core/let
    [v3865
     (:virtual-interface-name
      m3864
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3865 :com.palletops.awaze.client-builder/undef)
     (. bean3863 setVirtualInterfaceName (clojure.core/str v3865))))
   (clojure.core/let
    [v3865
     (:auth-key m3864 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3865 :com.palletops.awaze.client-builder/undef)
     (. bean3863 setAuthKey (clojure.core/str v3865))))
   (clojure.core/let
    [v3865
     (:amazon-address m3864 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3865 :com.palletops.awaze.client-builder/undef)
     (. bean3863 setAmazonAddress (clojure.core/str v3865))))
   (clojure.core/let
    [v3865
     (:customer-address
      m3864
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3865 :com.palletops.awaze.client-builder/undef)
     (. bean3863 setCustomerAddress (clojure.core/str v3865))))
   (clojure.core/let
    [v3865
     (:route-filter-prefixes
      m3864
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3865 :com.palletops.awaze.client-builder/undef)
     (.
      bean3863
      setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg3924]
  (directconnect/route-filter-prefix arg3924))
 v3865))))
   bean3863))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteConnectionRequest}
delete-connection-request
  [m3867]
  (clojure.core/let
   [bean3866
    (new
     com.amazonaws.services.directconnect.model.DeleteConnectionRequest)]
   (clojure.core/let
    [v3868
     (:connection-id m3867 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3868 :com.palletops.awaze.client-builder/undef)
     (. bean3866 setConnectionId (clojure.core/str v3868))))
   bean3866))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest}
describe-connections-on-interconnect-request
  [m3870]
  (clojure.core/let
   [bean3869
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest)]
   (clojure.core/let
    [v3871
     (:interconnect-id
      m3870
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3871 :com.palletops.awaze.client-builder/undef)
     (. bean3869 setInterconnectId (clojure.core/str v3871))))
   bean3869))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeLocationsRequest}
describe-locations-request
  [m3873]
  (clojure.core/let
   [bean3872
    (new
     com.amazonaws.services.directconnect.model.DescribeLocationsRequest)]
   bean3872))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest}
allocate-connection-on-interconnect-request
  [m3876]
  (clojure.core/let
   [bean3875
    (new
     com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest)]
   (clojure.core/let
    [v3877
     (:bandwidth m3876 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3877 :com.palletops.awaze.client-builder/undef)
     (. bean3875 setBandwidth (clojure.core/str v3877))))
   (clojure.core/let
    [v3877
     (:interconnect-id
      m3876
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3877 :com.palletops.awaze.client-builder/undef)
     (. bean3875 setInterconnectId (clojure.core/str v3877))))
   (clojure.core/let
    [v3877 (:vlan m3876 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3877 :com.palletops.awaze.client-builder/undef)
     (. bean3875 setVlan (clojure.core/int v3877))))
   (clojure.core/let
    [v3877
     (:connection-name
      m3876
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3877 :com.palletops.awaze.client-builder/undef)
     (. bean3875 setConnectionName (clojure.core/str v3877))))
   (clojure.core/let
    [v3877
     (:owner-account m3876 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3877 :com.palletops.awaze.client-builder/undef)
     (. bean3875 setOwnerAccount (clojure.core/str v3877))))
   bean3875))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest}
create-public-virtual-interface-request
  [m3879]
  (clojure.core/let
   [bean3878
    (new
     com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v3880
     (:connection-id m3879 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3880 :com.palletops.awaze.client-builder/undef)
     (. bean3878 setConnectionId (clojure.core/str v3880))))
   (clojure.core/let
    [v3880
     (:new-public-virtual-interface
      m3879
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3880 :com.palletops.awaze.client-builder/undef)
     (.
      bean3878
      setNewPublicVirtualInterface
      (directconnect/new-public-virtual-interface v3880))))
   bean3878))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmConnectionRequest}
confirm-connection-request
  [m3882]
  (clojure.core/let
   [bean3881
    (new
     com.amazonaws.services.directconnect.model.ConfirmConnectionRequest)]
   (clojure.core/let
    [v3883
     (:connection-id m3882 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3883 :com.palletops.awaze.client-builder/undef)
     (. bean3881 setConnectionId (clojure.core/str v3883))))
   bean3881))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest}
confirm-private-virtual-interface-request
  [m3885]
  (clojure.core/let
   [bean3884
    (new
     com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v3886
     (:virtual-interface-id
      m3885
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3886 :com.palletops.awaze.client-builder/undef)
     (. bean3884 setVirtualInterfaceId (clojure.core/str v3886))))
   (clojure.core/let
    [v3886
     (:virtual-gateway-id
      m3885
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3886 :com.palletops.awaze.client-builder/undef)
     (. bean3884 setVirtualGatewayId (clojure.core/str v3886))))
   bean3884))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateInterconnectRequest}
create-interconnect-request
  [m3888]
  (clojure.core/let
   [bean3887
    (new
     com.amazonaws.services.directconnect.model.CreateInterconnectRequest)]
   (clojure.core/let
    [v3889
     (:location m3888 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3889 :com.palletops.awaze.client-builder/undef)
     (. bean3887 setLocation (clojure.core/str v3889))))
   (clojure.core/let
    [v3889
     (:interconnect-name
      m3888
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3889 :com.palletops.awaze.client-builder/undef)
     (. bean3887 setInterconnectName (clojure.core/str v3889))))
   (clojure.core/let
    [v3889
     (:bandwidth m3888 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3889 :com.palletops.awaze.client-builder/undef)
     (. bean3887 setBandwidth (clojure.core/str v3889))))
   bean3887))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest}
confirm-public-virtual-interface-request
  [m3891]
  (clojure.core/let
   [bean3890
    (new
     com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v3892
     (:virtual-interface-id
      m3891
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3892 :com.palletops.awaze.client-builder/undef)
     (. bean3890 setVirtualInterfaceId (clojure.core/str v3892))))
   bean3890))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest}
delete-virtual-interface-request
  [m3894]
  (clojure.core/let
   [bean3893
    (new
     com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest)]
   (clojure.core/let
    [v3895
     (:virtual-interface-id
      m3894
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3895 :com.palletops.awaze.client-builder/undef)
     (. bean3893 setVirtualInterfaceId (clojure.core/str v3895))))
   bean3893))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest}
create-private-virtual-interface-request
  [m3897]
  (clojure.core/let
   [bean3896
    (new
     com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v3898
     (:connection-id m3897 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3898 :com.palletops.awaze.client-builder/undef)
     (. bean3896 setConnectionId (clojure.core/str v3898))))
   (clojure.core/let
    [v3898
     (:new-private-virtual-interface
      m3897
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3898 :com.palletops.awaze.client-builder/undef)
     (.
      bean3896
      setNewPrivateVirtualInterface
      (directconnect/new-private-virtual-interface v3898))))
   bean3896))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest}
allocate-private-virtual-interface-request
  [m3900]
  (clojure.core/let
   [bean3899
    (new
     com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v3901
     (:connection-id m3900 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3901 :com.palletops.awaze.client-builder/undef)
     (. bean3899 setConnectionId (clojure.core/str v3901))))
   (clojure.core/let
    [v3901
     (:new-private-virtual-interface-allocation
      m3900
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3901 :com.palletops.awaze.client-builder/undef)
     (.
      bean3899
      setNewPrivateVirtualInterfaceAllocation
      (directconnect/new-private-virtual-interface-allocation v3901))))
   (clojure.core/let
    [v3901
     (:owner-account m3900 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3901 :com.palletops.awaze.client-builder/undef)
     (. bean3899 setOwnerAccount (clojure.core/str v3901))))
   bean3899))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest}
describe-virtual-interfaces-request
  [m3903]
  (clojure.core/let
   [bean3902
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest)]
   (clojure.core/let
    [v3904
     (:virtual-interface-id
      m3903
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3904 :com.palletops.awaze.client-builder/undef)
     (. bean3902 setVirtualInterfaceId (clojure.core/str v3904))))
   (clojure.core/let
    [v3904
     (:connection-id m3903 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3904 :com.palletops.awaze.client-builder/undef)
     (. bean3902 setConnectionId (clojure.core/str v3904))))
   bean3902))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsRequest}
describe-connections-request
  [m3906]
  (clojure.core/let
   [bean3905
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsRequest)]
   (clojure.core/let
    [v3907
     (:connection-id m3906 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3907 :com.palletops.awaze.client-builder/undef)
     (. bean3905 setConnectionId (clojure.core/str v3907))))
   bean3905))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest}
allocate-public-virtual-interface-request
  [m3909]
  (clojure.core/let
   [bean3908
    (new
     com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v3910
     (:connection-id m3909 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3910 :com.palletops.awaze.client-builder/undef)
     (. bean3908 setConnectionId (clojure.core/str v3910))))
   (clojure.core/let
    [v3910
     (:new-public-virtual-interface-allocation
      m3909
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3910 :com.palletops.awaze.client-builder/undef)
     (.
      bean3908
      setNewPublicVirtualInterfaceAllocation
      (directconnect/new-public-virtual-interface-allocation v3910))))
   (clojure.core/let
    [v3910
     (:owner-account m3909 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3910 :com.palletops.awaze.client-builder/undef)
     (. bean3908 setOwnerAccount (clojure.core/str v3910))))
   bean3908))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest}
describe-interconnects-request
  [m3912]
  (clojure.core/let
   [bean3911
    (new
     com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest)]
   (clojure.core/let
    [v3913
     (:interconnect-id
      m3912
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3913 :com.palletops.awaze.client-builder/undef)
     (. bean3911 setInterconnectId (clojure.core/str v3913))))
   bean3911))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateConnectionRequest}
create-connection-request
  [m3915]
  (clojure.core/let
   [bean3914
    (new
     com.amazonaws.services.directconnect.model.CreateConnectionRequest)]
   (clojure.core/let
    [v3916
     (:location m3915 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3916 :com.palletops.awaze.client-builder/undef)
     (. bean3914 setLocation (clojure.core/str v3916))))
   (clojure.core/let
    [v3916
     (:bandwidth m3915 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3916 :com.palletops.awaze.client-builder/undef)
     (. bean3914 setBandwidth (clojure.core/str v3916))))
   (clojure.core/let
    [v3916
     (:connection-name
      m3915
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3916 :com.palletops.awaze.client-builder/undef)
     (. bean3914 setConnectionName (clojure.core/str v3916))))
   bean3914))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteInterconnectRequest}
delete-interconnect-request
  [m3918]
  (clojure.core/let
   [bean3917
    (new
     com.amazonaws.services.directconnect.model.DeleteInterconnectRequest)]
   (clojure.core/let
    [v3919
     (:interconnect-id
      m3918
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3919 :com.palletops.awaze.client-builder/undef)
     (. bean3917 setInterconnectId (clojure.core/str v3919))))
   bean3917))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest}
describe-virtual-gateways-request
  [m3921]
  (clojure.core/let
   [bean3920
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest)]
   bean3920))
 (clojure.core/defmulti
  directconnect
  (clojure.core/fn
   directconnect
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-connection
   [m3925]
   (clojure.core/let
    [credentials3926 (:credentials m3925) args3927 (:args m3925)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3928
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3926)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3928
       deleteConnection
       (directconnect/delete-connection-request
        (clojure.core/nth args3927 0)))))))
  (clojure.core/defn
   delete-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Generate map for deleteConnection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :delete-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-connection
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Call deleteConnection"}
   [credentials3930 & args3931]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3932
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3930)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3932
      deleteConnection
      (directconnect/delete-connection-request
       (clojure.core/nth args3931 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections-on-interconnect
   [m3933]
   (clojure.core/let
    [credentials3934 (:credentials m3933) args3935 (:args m3933)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3936
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3934)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3936
       describeConnectionsOnInterconnect
       (directconnect/describe-connections-on-interconnect-request
        (clojure.core/nth args3935 0)))))))
  (clojure.core/defn
   describe-connections-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Generate map for describeConnectionsOnInterconnect"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-connections-on-interconnect,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-connections-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Call describeConnectionsOnInterconnect"}
   [credentials3938 & args3939]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3940
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3938)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3940
      describeConnectionsOnInterconnect
      (directconnect/describe-connections-on-interconnect-request
       (clojure.core/nth args3939 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-locations
   [m3941]
   (clojure.core/let
    [credentials3942 (:credentials m3941) args3943 (:args m3941)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3944
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3942)]
     (clojure.core/case
      (clojure.core/count args3943)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3944
        describeLocations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3944
        describeLocations
        (directconnect/describe-locations-request
         (clojure.core/nth args3943 0))))))))
  (clojure.core/defn
   describe-locations-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeLocations, describeLocations"}
   ([credentials__1651__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-locations,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-locations,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-locations
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeLocations, describeLocations"}
   [credentials3946 & args3947]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3948
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3946)]
    (clojure.core/case
     (clojure.core/count args3947)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3948
       describeLocations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3948
       describeLocations
       (directconnect/describe-locations-request
        (clojure.core/nth args3947 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-connection-on-interconnect
   [m3949]
   (clojure.core/let
    [credentials3950 (:credentials m3949) args3951 (:args m3949)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3952
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3950)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3952
       allocateConnectionOnInterconnect
       (directconnect/allocate-connection-on-interconnect-request
        (clojure.core/nth args3951 0)))))))
  (clojure.core/defn
   allocate-connection-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         bandwidth
                         general-progress-listener
                         connection-name
                         vlan
                         owner-account]}]]),
    :doc "Generate map for allocateConnectionOnInterconnect"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :allocate-connection-on-interconnect,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   allocate-connection-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         bandwidth
                         general-progress-listener
                         connection-name
                         vlan
                         owner-account]}]]),
    :doc "Call allocateConnectionOnInterconnect"}
   [credentials3954 & args3955]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3956
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3954)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3956
      allocateConnectionOnInterconnect
      (directconnect/allocate-connection-on-interconnect-request
       (clojure.core/nth args3955 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-public-virtual-interface
   [m3957]
   (clojure.core/let
    [credentials3958 (:credentials m3957) args3959 (:args m3957)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3960
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3958)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3960
       createPublicVirtualInterface
       (directconnect/create-public-virtual-interface-request
        (clojure.core/nth args3959 0)))))))
  (clojure.core/defn
   create-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [new-public-virtual-interface
                         general-progress-listener
                         connection-id]}]]),
    :doc "Generate map for createPublicVirtualInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-public-virtual-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [new-public-virtual-interface
                         general-progress-listener
                         connection-id]}]]),
    :doc "Call createPublicVirtualInterface"}
   [credentials3962 & args3963]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3964
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3962)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3964
      createPublicVirtualInterface
      (directconnect/create-public-virtual-interface-request
       (clojure.core/nth args3963 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-connection
   [m3965]
   (clojure.core/let
    [credentials3966 (:credentials m3965) args3967 (:args m3965)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3968
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3966)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3968
       confirmConnection
       (directconnect/confirm-connection-request
        (clojure.core/nth args3967 0)))))))
  (clojure.core/defn
   confirm-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Generate map for confirmConnection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :confirm-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   confirm-connection
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Call confirmConnection"}
   [credentials3970 & args3971]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3972
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3970)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3972
      confirmConnection
      (directconnect/confirm-connection-request
       (clojure.core/nth args3971 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-private-virtual-interface
   [m3973]
   (clojure.core/let
    [credentials3974 (:credentials m3973) args3975 (:args m3973)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3976
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3974)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3976
       confirmPrivateVirtualInterface
       (directconnect/confirm-private-virtual-interface-request
        (clojure.core/nth args3975 0)))))))
  (clojure.core/defn
   confirm-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         virtual-gateway-id
                         general-progress-listener]}]]),
    :doc "Generate map for confirmPrivateVirtualInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :confirm-private-virtual-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   confirm-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         virtual-gateway-id
                         general-progress-listener]}]]),
    :doc "Call confirmPrivateVirtualInterface"}
   [credentials3978 & args3979]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3980
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3978)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3980
      confirmPrivateVirtualInterface
      (directconnect/confirm-private-virtual-interface-request
       (clojure.core/nth args3979 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-interconnect
   [m3981]
   (clojure.core/let
    [credentials3982 (:credentials m3981) args3983 (:args m3981)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3984
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3982)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3984
       createInterconnect
       (directconnect/create-interconnect-request
        (clojure.core/nth args3983 0)))))))
  (clojure.core/defn
   create-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [location
                         interconnect-name
                         general-progress-listener
                         bandwidth]}]]),
    :doc "Generate map for createInterconnect"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-interconnect,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [location
                         interconnect-name
                         general-progress-listener
                         bandwidth]}]]),
    :doc "Call createInterconnect"}
   [credentials3986 & args3987]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3988
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3986)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3988
      createInterconnect
      (directconnect/create-interconnect-request
       (clojure.core/nth args3987 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-public-virtual-interface
   [m3989]
   (clojure.core/let
    [credentials3990 (:credentials m3989) args3991 (:args m3989)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3992
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3990)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3992
       confirmPublicVirtualInterface
       (directconnect/confirm-public-virtual-interface-request
        (clojure.core/nth args3991 0)))))))
  (clojure.core/defn
   confirm-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         general-progress-listener]}]]),
    :doc "Generate map for confirmPublicVirtualInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :confirm-public-virtual-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   confirm-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         general-progress-listener]}]]),
    :doc "Call confirmPublicVirtualInterface"}
   [credentials3994 & args3995]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3996
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3994)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3996
      confirmPublicVirtualInterface
      (directconnect/confirm-public-virtual-interface-request
       (clojure.core/nth args3995 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-virtual-interface
   [m3997]
   (clojure.core/let
    [credentials3998 (:credentials m3997) args3999 (:args m3997)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4000
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3998)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4000
       deleteVirtualInterface
       (directconnect/delete-virtual-interface-request
        (clojure.core/nth args3999 0)))))))
  (clojure.core/defn
   delete-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         general-progress-listener]}]]),
    :doc "Generate map for deleteVirtualInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :delete-virtual-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         general-progress-listener]}]]),
    :doc "Call deleteVirtualInterface"}
   [credentials4002 & args4003]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4004
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4002)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4004
      deleteVirtualInterface
      (directconnect/delete-virtual-interface-request
       (clojure.core/nth args4003 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-private-virtual-interface
   [m4005]
   (clojure.core/let
    [credentials4006 (:credentials m4005) args4007 (:args m4005)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4008
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4006)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4008
       createPrivateVirtualInterface
       (directconnect/create-private-virtual-interface-request
        (clojure.core/nth args4007 0)))))))
  (clojure.core/defn
   create-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [new-private-virtual-interface
                         general-progress-listener
                         connection-id]}]]),
    :doc "Generate map for createPrivateVirtualInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-private-virtual-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [new-private-virtual-interface
                         general-progress-listener
                         connection-id]}]]),
    :doc "Call createPrivateVirtualInterface"}
   [credentials4010 & args4011]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4012
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4010)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4012
      createPrivateVirtualInterface
      (directconnect/create-private-virtual-interface-request
       (clojure.core/nth args4011 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-private-virtual-interface
   [m4013]
   (clojure.core/let
    [credentials4014 (:credentials m4013) args4015 (:args m4013)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4016
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4014)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4016
       allocatePrivateVirtualInterface
       (directconnect/allocate-private-virtual-interface-request
        (clojure.core/nth args4015 0)))))))
  (clojure.core/defn
   allocate-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [owner-account
                         new-private-virtual-interface-allocation
                         general-progress-listener
                         connection-id]}]]),
    :doc "Generate map for allocatePrivateVirtualInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :allocate-private-virtual-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   allocate-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [owner-account
                         new-private-virtual-interface-allocation
                         general-progress-listener
                         connection-id]}]]),
    :doc "Call allocatePrivateVirtualInterface"}
   [credentials4018 & args4019]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4020
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4018)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4020
      allocatePrivateVirtualInterface
      (directconnect/allocate-private-virtual-interface-request
       (clojure.core/nth args4019 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-interfaces
   [m4021]
   (clojure.core/let
    [credentials4022 (:credentials m4021) args4023 (:args m4021)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4024
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4022)]
     (clojure.core/case
      (clojure.core/count args4023)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4024
        describeVirtualInterfaces
        (directconnect/describe-virtual-interfaces-request
         (clojure.core/nth args4023 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4024
        describeVirtualInterfaces))))))
  (clojure.core/defn
   describe-virtual-interfaces-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         general-progress-listener
                         connection-id]}]
                [credentials]]),
    :doc "Generate map for describeVirtualInterfaces, describeVirtualInterfaces"}
   ([credentials__1651__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-virtual-interfaces,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-virtual-interfaces,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-virtual-interfaces
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         general-progress-listener
                         connection-id]}]
                [credentials]]),
    :doc "Call describeVirtualInterfaces, describeVirtualInterfaces"}
   [credentials4026 & args4027]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4028
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4026)]
    (clojure.core/case
     (clojure.core/count args4027)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4028
       describeVirtualInterfaces
       (directconnect/describe-virtual-interfaces-request
        (clojure.core/nth args4027 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4028
       describeVirtualInterfaces))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections
   [m4029]
   (clojure.core/let
    [credentials4030 (:credentials m4029) args4031 (:args m4029)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4032
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4030)]
     (clojure.core/case
      (clojure.core/count args4031)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4032
        describeConnections))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4032
        describeConnections
        (directconnect/describe-connections-request
         (clojure.core/nth args4031 0))))))))
  (clojure.core/defn
   describe-connections-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Generate map for describeConnections, describeConnections"}
   ([credentials__1651__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-connections,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-connections,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-connections
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Call describeConnections, describeConnections"}
   [credentials4034 & args4035]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4036
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4034)]
    (clojure.core/case
     (clojure.core/count args4035)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4036
       describeConnections))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4036
       describeConnections
       (directconnect/describe-connections-request
        (clojure.core/nth args4035 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-public-virtual-interface
   [m4037]
   (clojure.core/let
    [credentials4038 (:credentials m4037) args4039 (:args m4037)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4040
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4038)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4040
       allocatePublicVirtualInterface
       (directconnect/allocate-public-virtual-interface-request
        (clojure.core/nth args4039 0)))))))
  (clojure.core/defn
   allocate-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [owner-account
                         new-public-virtual-interface-allocation
                         general-progress-listener
                         connection-id]}]]),
    :doc "Generate map for allocatePublicVirtualInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :allocate-public-virtual-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   allocate-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [owner-account
                         new-public-virtual-interface-allocation
                         general-progress-listener
                         connection-id]}]]),
    :doc "Call allocatePublicVirtualInterface"}
   [credentials4042 & args4043]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4044
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4042)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4044
      allocatePublicVirtualInterface
      (directconnect/allocate-public-virtual-interface-request
       (clojure.core/nth args4043 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-interconnects
   [m4045]
   (clojure.core/let
    [credentials4046 (:credentials m4045) args4047 (:args m4045)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4048
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4046)]
     (clojure.core/case
      (clojure.core/count args4047)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4048
        describeInterconnects))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4048
        describeInterconnects
        (directconnect/describe-interconnects-request
         (clojure.core/nth args4047 0))))))))
  (clojure.core/defn
   describe-interconnects-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Generate map for describeInterconnects, describeInterconnects"}
   ([credentials__1651__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-interconnects,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-interconnects,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-interconnects
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Call describeInterconnects, describeInterconnects"}
   [credentials4050 & args4051]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4052
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4050)]
    (clojure.core/case
     (clojure.core/count args4051)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4052
       describeInterconnects))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4052
       describeInterconnects
       (directconnect/describe-interconnects-request
        (clojure.core/nth args4051 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-connection
   [m4053]
   (clojure.core/let
    [credentials4054 (:credentials m4053) args4055 (:args m4053)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4056
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4054)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4056
       createConnection
       (directconnect/create-connection-request
        (clojure.core/nth args4055 0)))))))
  (clojure.core/defn
   create-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [location
                         general-progress-listener
                         connection-name
                         bandwidth]}]]),
    :doc "Generate map for createConnection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-connection
   {:arglists (quote
               [[credentials
                 {:keys [location
                         general-progress-listener
                         connection-name
                         bandwidth]}]]),
    :doc "Call createConnection"}
   [credentials4058 & args4059]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4060
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4058)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4060
      createConnection
      (directconnect/create-connection-request
       (clojure.core/nth args4059 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-interconnect
   [m4061]
   (clojure.core/let
    [credentials4062 (:credentials m4061) args4063 (:args m4061)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4064
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4062)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4064
       deleteInterconnect
       (directconnect/delete-interconnect-request
        (clojure.core/nth args4063 0)))))))
  (clojure.core/defn
   delete-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Generate map for deleteInterconnect"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :delete-interconnect,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Call deleteInterconnect"}
   [credentials4066 & args4067]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4068
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4066)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4068
      deleteInterconnect
      (directconnect/delete-interconnect-request
       (clojure.core/nth args4067 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-gateways
   [m4069]
   (clojure.core/let
    [credentials4070 (:credentials m4069) args4071 (:args m4069)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4072
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4070)]
     (clojure.core/case
      (clojure.core/count args4071)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4072
        describeVirtualGateways
        (directconnect/describe-virtual-gateways-request
         (clojure.core/nth args4071 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4072
        describeVirtualGateways))))))
  (clojure.core/defn
   describe-virtual-gateways-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeVirtualGateways, describeVirtualGateways"}
   ([credentials__1651__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-virtual-gateways,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-virtual-gateways,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-virtual-gateways
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call describeVirtualGateways, describeVirtualGateways"}
   [credentials4074 & args4075]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4076
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4074)]
    (clojure.core/case
     (clojure.core/count args4075)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4076
       describeVirtualGateways
       (directconnect/describe-virtual-gateways-request
        (clojure.core/nth args4075 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4076
       describeVirtualGateways)))))))
