(ns
 com.palletops.awaze.cloudwatch
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudwatch :as cloudwatch]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudwatch
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.cloudwatch.AmazonCloudWatchClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StatisticSet}
statistic-set
  [m9188]
  (clojure.core/let
   [bean9187
    (new com.amazonaws.services.cloudwatch.model.StatisticSet)]
   (clojure.core/let
    [v9189 (:sum m9188 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9189 :com.palletops.awaze.client-builder/undef)
     (. bean9187 setSum (clojure.core/double v9189))))
   (clojure.core/let
    [v9189
     (:sample-count m9188 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9189 :com.palletops.awaze.client-builder/undef)
     (. bean9187 setSampleCount (clojure.core/double v9189))))
   (clojure.core/let
    [v9189 (:minimum m9188 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9189 :com.palletops.awaze.client-builder/undef)
     (. bean9187 setMinimum (clojure.core/double v9189))))
   (clojure.core/let
    [v9189 (:maximum m9188 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9189 :com.palletops.awaze.client-builder/undef)
     (. bean9187 setMaximum (clojure.core/double v9189))))
   bean9187))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StandardUnit}
standard-unit
  [m9191]
  (.
   com.amazonaws.services.cloudwatch.model.StandardUnit
   fromValue
   (clojure.core/name m9191)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.Dimension}
dimension
  [m9194]
  (clojure.core/let
   [bean9193 (new com.amazonaws.services.cloudwatch.model.Dimension)]
   (clojure.core/let
    [v9195 (:name m9194 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9195 :com.palletops.awaze.client-builder/undef)
     (. bean9193 setName (clojure.core/str v9195))))
   (clojure.core/let
    [v9195 (:value m9194 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9195 :com.palletops.awaze.client-builder/undef)
     (. bean9193 setValue (clojure.core/str v9195))))
   bean9193))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.ComparisonOperator}
comparison-operator
  [m9197]
  (.
   com.amazonaws.services.cloudwatch.model.ComparisonOperator
   fromValue
   (clojure.core/name m9197)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.HistoryItemType}
history-item-type
  [m9200]
  (.
   com.amazonaws.services.cloudwatch.model.HistoryItemType
   fromValue
   (clojure.core/name m9200)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StateValue}
state-value
  [m9203]
  (.
   com.amazonaws.services.cloudwatch.model.StateValue
   fromValue
   (clojure.core/name m9203)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DimensionFilter}
dimension-filter
  [m9206]
  (clojure.core/let
   [bean9205
    (new com.amazonaws.services.cloudwatch.model.DimensionFilter)]
   (clojure.core/let
    [v9207 (:name m9206 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9207 :com.palletops.awaze.client-builder/undef)
     (. bean9205 setName (clojure.core/str v9207))))
   (clojure.core/let
    [v9207 (:value m9206 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9207 :com.palletops.awaze.client-builder/undef)
     (. bean9205 setValue (clojure.core/str v9207))))
   bean9205))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.MetricDatum}
metric-datum
  [m9209]
  (clojure.core/let
   [bean9208
    (new com.amazonaws.services.cloudwatch.model.MetricDatum)]
   (clojure.core/let
    [v9210 (:value m9209 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9210 :com.palletops.awaze.client-builder/undef)
     (. bean9208 setValue (clojure.core/double v9210))))
   (clojure.core/let
    [v9210
     (:timestamp m9209 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9210 :com.palletops.awaze.client-builder/undef)
     (.
      bean9208
      setTimestamp
      (com.palletops.awaze.common/to-date v9210))))
   (clojure.core/let
    [v9210
     (:statistic-values
      m9209
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9210 :com.palletops.awaze.client-builder/undef)
     (. bean9208 setStatisticValues (cloudwatch/statistic-set v9210))))
   (clojure.core/let
    [v9210 (:unit m9209 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9210 :com.palletops.awaze.client-builder/undef)
     (. bean9208 setUnit (cloudwatch/standard-unit v9210))))
   (clojure.core/let
    [v9210
     (:metric-name m9209 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9210 :com.palletops.awaze.client-builder/undef)
     (. bean9208 setMetricName (clojure.core/str v9210))))
   (clojure.core/let
    [v9210
     (:dimensions m9209 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9210 :com.palletops.awaze.client-builder/undef)
     (.
      bean9208
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9247] (cloudwatch/dimension arg9247))
 v9210))))
   bean9208))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.Statistic}
statistic
  [m9212]
  (.
   com.amazonaws.services.cloudwatch.model.Statistic
   fromValue
   (clojure.core/name m9212)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest}
put-metric-alarm-request
  [m9215]
  (clojure.core/let
   [bean9214
    (new
     com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest)]
   (clojure.core/let
    [v9216 (:period m9215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9216 :com.palletops.awaze.client-builder/undef)
     (. bean9214 setPeriod (clojure.core/int v9216))))
   (clojure.core/let
    [v9216
     (:actions-enabled
      m9215
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9216 :com.palletops.awaze.client-builder/undef)
     (. bean9214 setActionsEnabled (clojure.core/boolean v9216))))
   (clojure.core/let
    [v9216 (:unit m9215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9216 :com.palletops.awaze.client-builder/undef)
     (. bean9214 setUnit (clojure.core/str v9216))))
   (clojure.core/let
    [v9216
     (:threshold m9215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9216 :com.palletops.awaze.client-builder/undef)
     (. bean9214 setThreshold (clojure.core/double v9216))))
   (clojure.core/let
    [v9216
     (:alarm-description
      m9215
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9216 :com.palletops.awaze.client-builder/undef)
     (. bean9214 setAlarmDescription (clojure.core/str v9216))))
   (clojure.core/let
    [v9216
     (:alarm-actions m9215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9216 :com.palletops.awaze.client-builder/undef)
     (.
      bean9214
      setAlarmActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9248] (clojure.core/str arg9248))
 v9216))))
   (clojure.core/let
    [v9216
     (:statistic m9215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9216 :com.palletops.awaze.client-builder/undef)
     (. bean9214 setStatistic (clojure.core/str v9216))))
   (clojure.core/let
    [v9216
     (:insufficient-data-actions
      m9215
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9216 :com.palletops.awaze.client-builder/undef)
     (.
      bean9214
      setInsufficientDataActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9249] (clojure.core/str arg9249))
 v9216))))
   (clojure.core/let
    [v9216
     (:dimensions m9215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9216 :com.palletops.awaze.client-builder/undef)
     (.
      bean9214
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9250] (cloudwatch/dimension arg9250))
 v9216))))
   (clojure.core/let
    [v9216
     (:comparison-operator
      m9215
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9216 :com.palletops.awaze.client-builder/undef)
     (.
      bean9214
      setComparisonOperator
      (cloudwatch/comparison-operator v9216))))
   (clojure.core/let
    [v9216
     (:evaluation-periods
      m9215
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9216 :com.palletops.awaze.client-builder/undef)
     (. bean9214 setEvaluationPeriods (clojure.core/int v9216))))
   (clojure.core/let
    [v9216
     (:namespace m9215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9216 :com.palletops.awaze.client-builder/undef)
     (. bean9214 setNamespace (clojure.core/str v9216))))
   (clojure.core/let
    [v9216
     (:alarm-name m9215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9216 :com.palletops.awaze.client-builder/undef)
     (. bean9214 setAlarmName (clojure.core/str v9216))))
   (clojure.core/let
    [v9216
     (:metric-name m9215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9216 :com.palletops.awaze.client-builder/undef)
     (. bean9214 setMetricName (clojure.core/str v9216))))
   (clojure.core/let
    [v9216
     (:okactions m9215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9216 :com.palletops.awaze.client-builder/undef)
     (.
      bean9214
      setOKActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9251] (clojure.core/str arg9251))
 v9216))))
   bean9214))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest}
describe-alarm-history-request
  [m9218]
  (clojure.core/let
   [bean9217
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest)]
   (clojure.core/let
    [v9219
     (:next-token m9218 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9219 :com.palletops.awaze.client-builder/undef)
     (. bean9217 setNextToken (clojure.core/str v9219))))
   (clojure.core/let
    [v9219
     (:start-date m9218 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9219 :com.palletops.awaze.client-builder/undef)
     (.
      bean9217
      setStartDate
      (com.palletops.awaze.common/to-date v9219))))
   (clojure.core/let
    [v9219
     (:end-date m9218 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9219 :com.palletops.awaze.client-builder/undef)
     (.
      bean9217
      setEndDate
      (com.palletops.awaze.common/to-date v9219))))
   (clojure.core/let
    [v9219
     (:max-records m9218 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9219 :com.palletops.awaze.client-builder/undef)
     (. bean9217 setMaxRecords (clojure.core/int v9219))))
   (clojure.core/let
    [v9219
     (:alarm-name m9218 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9219 :com.palletops.awaze.client-builder/undef)
     (. bean9217 setAlarmName (clojure.core/str v9219))))
   (clojure.core/let
    [v9219
     (:history-item-type
      m9218
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9219 :com.palletops.awaze.client-builder/undef)
     (.
      bean9217
      setHistoryItemType
      (cloudwatch/history-item-type v9219))))
   bean9217))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest}
set-alarm-state-request
  [m9221]
  (clojure.core/let
   [bean9220
    (new com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest)]
   (clojure.core/let
    [v9222
     (:alarm-name m9221 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9222 :com.palletops.awaze.client-builder/undef)
     (. bean9220 setAlarmName (clojure.core/str v9222))))
   (clojure.core/let
    [v9222
     (:state-value m9221 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9222 :com.palletops.awaze.client-builder/undef)
     (. bean9220 setStateValue (cloudwatch/state-value v9222))))
   (clojure.core/let
    [v9222
     (:state-reason m9221 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9222 :com.palletops.awaze.client-builder/undef)
     (. bean9220 setStateReason (clojure.core/str v9222))))
   (clojure.core/let
    [v9222
     (:state-reason-data
      m9221
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9222 :com.palletops.awaze.client-builder/undef)
     (. bean9220 setStateReasonData (clojure.core/str v9222))))
   bean9220))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.ListMetricsRequest}
list-metrics-request
  [m9224]
  (clojure.core/let
   [bean9223
    (new com.amazonaws.services.cloudwatch.model.ListMetricsRequest)]
   (clojure.core/let
    [v9225
     (:next-token m9224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9225 :com.palletops.awaze.client-builder/undef)
     (. bean9223 setNextToken (clojure.core/str v9225))))
   (clojure.core/let
    [v9225
     (:namespace m9224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9225 :com.palletops.awaze.client-builder/undef)
     (. bean9223 setNamespace (clojure.core/str v9225))))
   (clojure.core/let
    [v9225
     (:metric-name m9224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9225 :com.palletops.awaze.client-builder/undef)
     (. bean9223 setMetricName (clojure.core/str v9225))))
   (clojure.core/let
    [v9225
     (:dimensions m9224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9225 :com.palletops.awaze.client-builder/undef)
     (.
      bean9223
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9252] (cloudwatch/dimension-filter arg9252))
 v9225))))
   bean9223))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest}
get-metric-statistics-request
  [m9227]
  (clojure.core/let
   [bean9226
    (new
     com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest)]
   (clojure.core/let
    [v9228
     (:namespace m9227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9228 :com.palletops.awaze.client-builder/undef)
     (. bean9226 setNamespace (clojure.core/str v9228))))
   (clojure.core/let
    [v9228
     (:start-time m9227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9228 :com.palletops.awaze.client-builder/undef)
     (.
      bean9226
      setStartTime
      (com.palletops.awaze.common/to-date v9228))))
   (clojure.core/let
    [v9228
     (:end-time m9227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9228 :com.palletops.awaze.client-builder/undef)
     (.
      bean9226
      setEndTime
      (com.palletops.awaze.common/to-date v9228))))
   (clojure.core/let
    [v9228 (:unit m9227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9228 :com.palletops.awaze.client-builder/undef)
     (. bean9226 setUnit (clojure.core/str v9228))))
   (clojure.core/let
    [v9228
     (:metric-name m9227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9228 :com.palletops.awaze.client-builder/undef)
     (. bean9226 setMetricName (clojure.core/str v9228))))
   (clojure.core/let
    [v9228
     (:dimensions m9227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9228 :com.palletops.awaze.client-builder/undef)
     (.
      bean9226
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9253] (cloudwatch/dimension arg9253))
 v9228))))
   (clojure.core/let
    [v9228 (:period m9227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9228 :com.palletops.awaze.client-builder/undef)
     (. bean9226 setPeriod (clojure.core/int v9228))))
   (clojure.core/let
    [v9228
     (:statistics m9227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9228 :com.palletops.awaze.client-builder/undef)
     (.
      bean9226
      setStatistics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9254] (clojure.core/str arg9254))
 v9228))))
   bean9226))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest}
disable-alarm-actions-request
  [m9230]
  (clojure.core/let
   [bean9229
    (new
     com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest)]
   (clojure.core/let
    [v9231
     (:alarm-names m9230 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9231 :com.palletops.awaze.client-builder/undef)
     (.
      bean9229
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9255] (clojure.core/str arg9255))
 v9231))))
   bean9229))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest}
enable-alarm-actions-request
  [m9233]
  (clojure.core/let
   [bean9232
    (new
     com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest)]
   (clojure.core/let
    [v9234
     (:alarm-names m9233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9234 :com.palletops.awaze.client-builder/undef)
     (.
      bean9232
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9256] (clojure.core/str arg9256))
 v9234))))
   bean9232))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.PutMetricDataRequest}
put-metric-data-request
  [m9236]
  (clojure.core/let
   [bean9235
    (new com.amazonaws.services.cloudwatch.model.PutMetricDataRequest)]
   (clojure.core/let
    [v9237
     (:namespace m9236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9237 :com.palletops.awaze.client-builder/undef)
     (. bean9235 setNamespace (clojure.core/str v9237))))
   (clojure.core/let
    [v9237
     (:metric-data m9236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9237 :com.palletops.awaze.client-builder/undef)
     (.
      bean9235
      setMetricData
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9257] (cloudwatch/metric-datum arg9257))
 v9237))))
   bean9235))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest}
describe-alarms-for-metric-request
  [m9239]
  (clojure.core/let
   [bean9238
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest)]
   (clojure.core/let
    [v9240
     (:namespace m9239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9240 :com.palletops.awaze.client-builder/undef)
     (. bean9238 setNamespace (clojure.core/str v9240))))
   (clojure.core/let
    [v9240 (:unit m9239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9240 :com.palletops.awaze.client-builder/undef)
     (. bean9238 setUnit (clojure.core/str v9240))))
   (clojure.core/let
    [v9240
     (:metric-name m9239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9240 :com.palletops.awaze.client-builder/undef)
     (. bean9238 setMetricName (clojure.core/str v9240))))
   (clojure.core/let
    [v9240
     (:statistic m9239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9240 :com.palletops.awaze.client-builder/undef)
     (. bean9238 setStatistic (cloudwatch/statistic v9240))))
   (clojure.core/let
    [v9240
     (:dimensions m9239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9240 :com.palletops.awaze.client-builder/undef)
     (.
      bean9238
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9258] (cloudwatch/dimension arg9258))
 v9240))))
   (clojure.core/let
    [v9240 (:period m9239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9240 :com.palletops.awaze.client-builder/undef)
     (. bean9238 setPeriod (clojure.core/int v9240))))
   bean9238))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest}
describe-alarms-request
  [m9242]
  (clojure.core/let
   [bean9241
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest)]
   (clojure.core/let
    [v9243
     (:next-token m9242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9243 :com.palletops.awaze.client-builder/undef)
     (. bean9241 setNextToken (clojure.core/str v9243))))
   (clojure.core/let
    [v9243
     (:max-records m9242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9243 :com.palletops.awaze.client-builder/undef)
     (. bean9241 setMaxRecords (clojure.core/int v9243))))
   (clojure.core/let
    [v9243
     (:alarm-names m9242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9243 :com.palletops.awaze.client-builder/undef)
     (.
      bean9241
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9259] (clojure.core/str arg9259))
 v9243))))
   (clojure.core/let
    [v9243
     (:alarm-name-prefix
      m9242
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9243 :com.palletops.awaze.client-builder/undef)
     (. bean9241 setAlarmNamePrefix (clojure.core/str v9243))))
   (clojure.core/let
    [v9243
     (:state-value m9242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9243 :com.palletops.awaze.client-builder/undef)
     (. bean9241 setStateValue (cloudwatch/state-value v9243))))
   (clojure.core/let
    [v9243
     (:action-prefix m9242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9243 :com.palletops.awaze.client-builder/undef)
     (. bean9241 setActionPrefix (clojure.core/str v9243))))
   bean9241))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest}
delete-alarms-request
  [m9245]
  (clojure.core/let
   [bean9244
    (new com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest)]
   (clojure.core/let
    [v9246
     (:alarm-names m9245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9246 :com.palletops.awaze.client-builder/undef)
     (.
      bean9244
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9260] (clojure.core/str arg9260))
 v9246))))
   bean9244))
 (clojure.core/defmulti
  cloudwatch
  (clojure.core/fn cloudwatch [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-alarm
   [m9261]
   (clojure.core/let
    [credentials9262 (:credentials m9261) args9263 (:args m9261)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9264
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9262)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9264
       putMetricAlarm
       (cloudwatch/put-metric-alarm-request
        (clojure.core/nth args9263 0)))))))
  (clojure.core/defn
   put-metric-alarm-map
   {:arglists (quote
               [[credentials
                 {:keys [period
                         evaluation-periods
                         general-progress-listener
                         metric-name
                         namespace
                         insufficient-data-actions
                         alarm-actions
                         threshold
                         alarm-description
                         comparison-operator
                         statistic
                         alarm-name
                         unit
                         okactions
                         dimensions
                         actions-enabled]}]]),
    :doc "Generate map for putMetricAlarm"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :put-metric-alarm,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-metric-alarm
   {:arglists (quote
               [[credentials
                 {:keys [period
                         evaluation-periods
                         general-progress-listener
                         metric-name
                         namespace
                         insufficient-data-actions
                         alarm-actions
                         threshold
                         alarm-description
                         comparison-operator
                         statistic
                         alarm-name
                         unit
                         okactions
                         dimensions
                         actions-enabled]}]]),
    :doc "Call putMetricAlarm"}
   [credentials9266 & args9267]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9268
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9266)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9268
      putMetricAlarm
      (cloudwatch/put-metric-alarm-request
       (clojure.core/nth args9267 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarm-history
   [m9269]
   (clojure.core/let
    [credentials9270 (:credentials m9269) args9271 (:args m9269)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9272
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9270)]
     (clojure.core/case
      (clojure.core/count args9271)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9272
        describeAlarmHistory
        (cloudwatch/describe-alarm-history-request
         (clojure.core/nth args9271 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9272
        describeAlarmHistory))))))
  (clojure.core/defn
   describe-alarm-history-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         end-date
                         max-records
                         history-item-type
                         alarm-name
                         start-date
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeAlarmHistory, describeAlarmHistory"}
   ([credentials__1651__auto__]
    {:args [],
     :client :cloudwatch,
     :fn :describe-alarm-history,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :describe-alarm-history,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-alarm-history
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         end-date
                         max-records
                         history-item-type
                         alarm-name
                         start-date
                         next-token]}]
                [credentials]]),
    :doc "Call describeAlarmHistory, describeAlarmHistory"}
   [credentials9274 & args9275]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9276
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9274)]
    (clojure.core/case
     (clojure.core/count args9275)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9276
       describeAlarmHistory
       (cloudwatch/describe-alarm-history-request
        (clojure.core/nth args9275 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9276
       describeAlarmHistory))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :set-alarm-state
   [m9277]
   (clojure.core/let
    [credentials9278 (:credentials m9277) args9279 (:args m9277)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9280
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9278)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9280
       setAlarmState
       (cloudwatch/set-alarm-state-request
        (clojure.core/nth args9279 0)))))))
  (clojure.core/defn
   set-alarm-state-map
   {:arglists (quote
               [[credentials
                 {:keys [state-value
                         state-reason-data
                         state-reason
                         general-progress-listener
                         alarm-name]}]]),
    :doc "Generate map for setAlarmState"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :set-alarm-state,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-alarm-state
   {:arglists (quote
               [[credentials
                 {:keys [state-value
                         state-reason-data
                         state-reason
                         general-progress-listener
                         alarm-name]}]]),
    :doc "Call setAlarmState"}
   [credentials9282 & args9283]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9284
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9282)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9284
      setAlarmState
      (cloudwatch/set-alarm-state-request
       (clojure.core/nth args9283 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :list-metrics
   [m9285]
   (clojure.core/let
    [credentials9286 (:credentials m9285) args9287 (:args m9285)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9288
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9286)]
     (clojure.core/case
      (clojure.core/count args9287)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9288
        listMetrics))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9288
        listMetrics
        (cloudwatch/list-metrics-request
         (clojure.core/nth args9287 0))))))))
  (clojure.core/defn
   list-metrics-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         namespace
                         metric-name
                         general-progress-listener
                         dimensions]}]]),
    :doc "Generate map for listMetrics, listMetrics"}
   ([credentials__1651__auto__]
    {:args [],
     :client :cloudwatch,
     :fn :list-metrics,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :list-metrics,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-metrics
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         namespace
                         metric-name
                         general-progress-listener
                         dimensions]}]]),
    :doc "Call listMetrics, listMetrics"}
   [credentials9290 & args9291]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9292
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9290)]
    (clojure.core/case
     (clojure.core/count args9291)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9292
       listMetrics))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9292
       listMetrics
       (cloudwatch/list-metrics-request (clojure.core/nth args9291 0))))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :get-metric-statistics
   [m9293]
   (clojure.core/let
    [credentials9294 (:credentials m9293) args9295 (:args m9293)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9296
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9294)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9296
       getMetricStatistics
       (cloudwatch/get-metric-statistics-request
        (clojure.core/nth args9295 0)))))))
  (clojure.core/defn
   get-metric-statistics-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         period
                         general-progress-listener
                         metric-name
                         namespace
                         start-time
                         unit
                         dimensions
                         statistics]}]]),
    :doc "Generate map for getMetricStatistics"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :get-metric-statistics,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-metric-statistics
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         period
                         general-progress-listener
                         metric-name
                         namespace
                         start-time
                         unit
                         dimensions
                         statistics]}]]),
    :doc "Call getMetricStatistics"}
   [credentials9298 & args9299]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9300
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9298)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9300
      getMetricStatistics
      (cloudwatch/get-metric-statistics-request
       (clojure.core/nth args9299 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :disable-alarm-actions
   [m9301]
   (clojure.core/let
    [credentials9302 (:credentials m9301) args9303 (:args m9301)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9304
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9302)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9304
       disableAlarmActions
       (cloudwatch/disable-alarm-actions-request
        (clojure.core/nth args9303 0)))))))
  (clojure.core/defn
   disable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener alarm-names]}]]),
    :doc "Generate map for disableAlarmActions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :disable-alarm-actions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener alarm-names]}]]),
    :doc "Call disableAlarmActions"}
   [credentials9306 & args9307]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9308
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9306)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9308
      disableAlarmActions
      (cloudwatch/disable-alarm-actions-request
       (clojure.core/nth args9307 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :enable-alarm-actions
   [m9309]
   (clojure.core/let
    [credentials9310 (:credentials m9309) args9311 (:args m9309)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9312
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9310)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9312
       enableAlarmActions
       (cloudwatch/enable-alarm-actions-request
        (clojure.core/nth args9311 0)))))))
  (clojure.core/defn
   enable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener alarm-names]}]]),
    :doc "Generate map for enableAlarmActions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :enable-alarm-actions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener alarm-names]}]]),
    :doc "Call enableAlarmActions"}
   [credentials9314 & args9315]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9316
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9314)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9316
      enableAlarmActions
      (cloudwatch/enable-alarm-actions-request
       (clojure.core/nth args9315 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-data
   [m9317]
   (clojure.core/let
    [credentials9318 (:credentials m9317) args9319 (:args m9317)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9320
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9318)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9320
       putMetricData
       (cloudwatch/put-metric-data-request
        (clojure.core/nth args9319 0)))))))
  (clojure.core/defn
   put-metric-data-map
   {:arglists (quote
               [[credentials
                 {:keys [namespace
                         metric-data
                         general-progress-listener]}]]),
    :doc "Generate map for putMetricData"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :put-metric-data,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-metric-data
   {:arglists (quote
               [[credentials
                 {:keys [namespace
                         metric-data
                         general-progress-listener]}]]),
    :doc "Call putMetricData"}
   [credentials9322 & args9323]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9324
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9322)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9324
      putMetricData
      (cloudwatch/put-metric-data-request
       (clojure.core/nth args9323 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms-for-metric
   [m9325]
   (clojure.core/let
    [credentials9326 (:credentials m9325) args9327 (:args m9325)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9328
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9326)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9328
       describeAlarmsForMetric
       (cloudwatch/describe-alarms-for-metric-request
        (clojure.core/nth args9327 0)))))))
  (clojure.core/defn
   describe-alarms-for-metric-map
   {:arglists (quote
               [[credentials
                 {:keys [period
                         general-progress-listener
                         metric-name
                         namespace
                         statistic
                         unit
                         dimensions]}]]),
    :doc "Generate map for describeAlarmsForMetric"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :describe-alarms-for-metric,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-alarms-for-metric
   {:arglists (quote
               [[credentials
                 {:keys [period
                         general-progress-listener
                         metric-name
                         namespace
                         statistic
                         unit
                         dimensions]}]]),
    :doc "Call describeAlarmsForMetric"}
   [credentials9330 & args9331]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9332
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9330)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9332
      describeAlarmsForMetric
      (cloudwatch/describe-alarms-for-metric-request
       (clojure.core/nth args9331 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms
   [m9333]
   (clojure.core/let
    [credentials9334 (:credentials m9333) args9335 (:args m9333)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9336
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9334)]
     (clojure.core/case
      (clojure.core/count args9335)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9336
        describeAlarms))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9336
        describeAlarms
        (cloudwatch/describe-alarms-request
         (clojure.core/nth args9335 0))))))))
  (clojure.core/defn
   describe-alarms-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [alarm-name-prefix
                         general-progress-listener
                         action-prefix
                         state-value
                         max-records
                         next-token
                         alarm-names]}]]),
    :doc "Generate map for describeAlarms, describeAlarms"}
   ([credentials__1651__auto__]
    {:args [],
     :client :cloudwatch,
     :fn :describe-alarms,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :describe-alarms,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-alarms
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [alarm-name-prefix
                         general-progress-listener
                         action-prefix
                         state-value
                         max-records
                         next-token
                         alarm-names]}]]),
    :doc "Call describeAlarms, describeAlarms"}
   [credentials9338 & args9339]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9340
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9338)]
    (clojure.core/case
     (clojure.core/count args9339)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9340
       describeAlarms))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9340
       describeAlarms
       (cloudwatch/describe-alarms-request
        (clojure.core/nth args9339 0))))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :delete-alarms
   [m9341]
   (clojure.core/let
    [credentials9342 (:credentials m9341) args9343 (:args m9341)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client9344
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials9342)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9344
       deleteAlarms
       (cloudwatch/delete-alarms-request
        (clojure.core/nth args9343 0)))))))
  (clojure.core/defn
   delete-alarms-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener alarm-names]}]]),
    :doc "Generate map for deleteAlarms"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :delete-alarms,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-alarms
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener alarm-names]}]]),
    :doc "Call deleteAlarms"}
   [credentials9346 & args9347]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client9348
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials9346)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client9348
      deleteAlarms
      (cloudwatch/delete-alarms-request (clojure.core/nth args9347 0))))))))
