(ns
 com.palletops.awaze.cloudsearch
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudsearch :as cloudsearch]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudsearch
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.cloudsearch.AmazonCloudSearchClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceData}
source-data
  [m8914]
  (clojure.core/let
   [bean8913
    (new com.amazonaws.services.cloudsearch.model.SourceData)]
   (clojure.core/let
    [v8915
     (:default-value m8914 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8915 :com.palletops.awaze.client-builder/undef)
     (. bean8913 setDefaultValue (clojure.core/str v8915))))
   (clojure.core/let
    [v8915
     (:source-name m8914 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8915 :com.palletops.awaze.client-builder/undef)
     (. bean8913 setSourceName (clojure.core/str v8915))))
   bean8913))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle}
source-data-trim-title
  [m8917]
  (clojure.core/let
   [bean8916
    (new com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle)]
   (clojure.core/let
    [v8918
     (:default-value m8917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setDefaultValue (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:language m8917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setLanguage (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:source-name m8917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setSourceName (clojure.core/str v8918))))
   (clojure.core/let
    [v8918
     (:separator m8917 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8918 :com.palletops.awaze.client-builder/undef)
     (. bean8916 setSeparator (clojure.core/str v8918))))
   bean8916))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataMap}
source-data-map
  [m8920]
  (clojure.core/let
   [bean8919
    (new com.amazonaws.services.cloudsearch.model.SourceDataMap)]
   (clojure.core/let
    [v8921
     (:default-value m8920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setDefaultValue (clojure.core/str v8921))))
   (clojure.core/let
    [v8921 (:cases m8920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (.
      bean8919
      setCases
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg9006] (clojure.core/str arg9006))
  (clojure.core/keys v8921))
 (clojure.core/map
  (clojure.core/fn [arg9006] (clojure.core/str arg9006))
  (clojure.core/vals v8921))))))
   (clojure.core/let
    [v8921
     (:source-name m8920 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8921 :com.palletops.awaze.client-builder/undef)
     (. bean8919 setSourceName (clojure.core/str v8921))))
   bean8919))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UIntOptions}
uint-options
  [m8923]
  (clojure.core/let
   [bean8922
    (new com.amazonaws.services.cloudsearch.model.UIntOptions)]
   (clojure.core/let
    [v8924
     (:default-value m8923 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8924 :com.palletops.awaze.client-builder/undef)
     (. bean8922 setDefaultValue (clojure.core/int v8924))))
   bean8922))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.LiteralOptions}
literal-options
  [m8926]
  (clojure.core/let
   [bean8925
    (new com.amazonaws.services.cloudsearch.model.LiteralOptions)]
   (clojure.core/let
    [v8927
     (:default-value m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setDefaultValue (clojure.core/str v8927))))
   (clojure.core/let
    [v8927
     (:search-enabled m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setSearchEnabled (clojure.core/boolean v8927))))
   (clojure.core/let
    [v8927
     (:facet-enabled m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setFacetEnabled (clojure.core/boolean v8927))))
   (clojure.core/let
    [v8927
     (:result-enabled m8926 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8927 :com.palletops.awaze.client-builder/undef)
     (. bean8925 setResultEnabled (clojure.core/boolean v8927))))
   bean8925))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.TextOptions}
text-options
  [m8929]
  (clojure.core/let
   [bean8928
    (new com.amazonaws.services.cloudsearch.model.TextOptions)]
   (clojure.core/let
    [v8930
     (:default-value m8929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setDefaultValue (clojure.core/str v8930))))
   (clojure.core/let
    [v8930
     (:facet-enabled m8929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setFacetEnabled (clojure.core/boolean v8930))))
   (clojure.core/let
    [v8930
     (:result-enabled m8929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setResultEnabled (clojure.core/boolean v8930))))
   (clojure.core/let
    [v8930
     (:text-processor m8929 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8930 :com.palletops.awaze.client-builder/undef)
     (. bean8928 setTextProcessor (clojure.core/str v8930))))
   bean8928))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceAttribute}
source-attribute
  [m8932]
  (clojure.core/let
   [bean8931
    (new com.amazonaws.services.cloudsearch.model.SourceAttribute)]
   (clojure.core/let
    [v8933
     (:source-data-function
      m8932
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8933 :com.palletops.awaze.client-builder/undef)
     (. bean8931 setSourceDataFunction (clojure.core/str v8933))))
   (clojure.core/let
    [v8933
     (:source-data-copy
      m8932
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8933 :com.palletops.awaze.client-builder/undef)
     (. bean8931 setSourceDataCopy (cloudsearch/source-data v8933))))
   (clojure.core/let
    [v8933
     (:source-data-trim-title
      m8932
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8933 :com.palletops.awaze.client-builder/undef)
     (.
      bean8931
      setSourceDataTrimTitle
      (cloudsearch/source-data-trim-title v8933))))
   (clojure.core/let
    [v8933
     (:source-data-map
      m8932
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8933 :com.palletops.awaze.client-builder/undef)
     (. bean8931 setSourceDataMap (cloudsearch/source-data-map v8933))))
   bean8931))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexField}
index-field
  [m8935]
  (clojure.core/let
   [bean8934
    (new com.amazonaws.services.cloudsearch.model.IndexField)]
   (clojure.core/let
    [v8936
     (:index-field-name
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setIndexFieldName (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:index-field-type
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setIndexFieldType (clojure.core/str v8936))))
   (clojure.core/let
    [v8936
     (:uint-options m8935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setUIntOptions (cloudsearch/uint-options v8936))))
   (clojure.core/let
    [v8936
     (:literal-options
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setLiteralOptions
      (cloudsearch/literal-options v8936))))
   (clojure.core/let
    [v8936
     (:text-options m8935 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (. bean8934 setTextOptions (cloudsearch/text-options v8936))))
   (clojure.core/let
    [v8936
     (:source-attributes
      m8935
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8936 :com.palletops.awaze.client-builder/undef)
     (.
      bean8934
      setSourceAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9007] (cloudsearch/source-attribute arg9007))
 v8936))))
   bean8934))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.NamedRankExpression}
named-rank-expression
  [m8938]
  (clojure.core/let
   [bean8937
    (new com.amazonaws.services.cloudsearch.model.NamedRankExpression)]
   (clojure.core/let
    [v8939
     (:rank-name m8938 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setRankName (clojure.core/str v8939))))
   (clojure.core/let
    [v8939
     (:rank-expression
      m8938
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8939 :com.palletops.awaze.client-builder/undef)
     (. bean8937 setRankExpression (clojure.core/str v8939))))
   bean8937))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest}
update-default-search-field-request
  [m8941]
  (clojure.core/let
   [bean8940
    (new
     com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest)]
   (clojure.core/let
    [v8942
     (:domain-name m8941 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8942 :com.palletops.awaze.client-builder/undef)
     (. bean8940 setDomainName (clojure.core/str v8942))))
   (clojure.core/let
    [v8942
     (:default-search-field
      m8941
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8942 :com.palletops.awaze.client-builder/undef)
     (. bean8940 setDefaultSearchField (clojure.core/str v8942))))
   bean8940))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest}
describe-service-access-policies-request
  [m8944]
  (clojure.core/let
   [bean8943
    (new
     com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest)]
   (clojure.core/let
    [v8945
     (:domain-name m8944 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8945 :com.palletops.awaze.client-builder/undef)
     (. bean8943 setDomainName (clojure.core/str v8945))))
   bean8943))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest}
describe-domains-request
  [m8947]
  (clojure.core/let
   [bean8946
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest)]
   (clojure.core/let
    [v8948
     (:domain-names m8947 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8948 :com.palletops.awaze.client-builder/undef)
     (.
      bean8946
      setDomainNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9008] (clojure.core/str arg9008))
 v8948))))
   bean8946))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest}
define-index-field-request
  [m8950]
  (clojure.core/let
   [bean8949
    (new
     com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest)]
   (clojure.core/let
    [v8951
     (:domain-name m8950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8951 :com.palletops.awaze.client-builder/undef)
     (. bean8949 setDomainName (clojure.core/str v8951))))
   (clojure.core/let
    [v8951
     (:index-field m8950 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8951 :com.palletops.awaze.client-builder/undef)
     (. bean8949 setIndexField (cloudsearch/index-field v8951))))
   bean8949))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest}
define-rank-expression-request
  [m8953]
  (clojure.core/let
   [bean8952
    (new
     com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest)]
   (clojure.core/let
    [v8954
     (:domain-name m8953 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8954 :com.palletops.awaze.client-builder/undef)
     (. bean8952 setDomainName (clojure.core/str v8954))))
   (clojure.core/let
    [v8954
     (:rank-expression
      m8953
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8954 :com.palletops.awaze.client-builder/undef)
     (.
      bean8952
      setRankExpression
      (cloudsearch/named-rank-expression v8954))))
   bean8952))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest}
update-stopword-options-request
  [m8956]
  (clojure.core/let
   [bean8955
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest)]
   (clojure.core/let
    [v8957
     (:domain-name m8956 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8957 :com.palletops.awaze.client-builder/undef)
     (. bean8955 setDomainName (clojure.core/str v8957))))
   (clojure.core/let
    [v8957
     (:stopwords m8956 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8957 :com.palletops.awaze.client-builder/undef)
     (. bean8955 setStopwords (clojure.core/str v8957))))
   bean8955))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest}
delete-rank-expression-request
  [m8959]
  (clojure.core/let
   [bean8958
    (new
     com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest)]
   (clojure.core/let
    [v8960
     (:domain-name m8959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8960 :com.palletops.awaze.client-builder/undef)
     (. bean8958 setDomainName (clojure.core/str v8960))))
   (clojure.core/let
    [v8960
     (:rank-name m8959 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8960 :com.palletops.awaze.client-builder/undef)
     (. bean8958 setRankName (clojure.core/str v8960))))
   bean8958))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest}
describe-default-search-field-request
  [m8962]
  (clojure.core/let
   [bean8961
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest)]
   (clojure.core/let
    [v8963
     (:domain-name m8962 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8963 :com.palletops.awaze.client-builder/undef)
     (. bean8961 setDomainName (clojure.core/str v8963))))
   bean8961))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.CreateDomainRequest}
create-domain-request
  [m8965]
  (clojure.core/let
   [bean8964
    (new com.amazonaws.services.cloudsearch.model.CreateDomainRequest)]
   (clojure.core/let
    [v8966
     (:domain-name m8965 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8966 :com.palletops.awaze.client-builder/undef)
     (. bean8964 setDomainName (clojure.core/str v8966))))
   bean8964))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest}
describe-stemming-options-request
  [m8968]
  (clojure.core/let
   [bean8967
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest)]
   (clojure.core/let
    [v8969
     (:domain-name m8968 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8969 :com.palletops.awaze.client-builder/undef)
     (. bean8967 setDomainName (clojure.core/str v8969))))
   bean8967))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateAvailabilityOptionsRequest}
update-availability-options-request
  [m8971]
  (clojure.core/let
   [bean8970
    (new
     com.amazonaws.services.cloudsearch.model.UpdateAvailabilityOptionsRequest)]
   (clojure.core/let
    [v8972
     (:domain-name m8971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8972 :com.palletops.awaze.client-builder/undef)
     (. bean8970 setDomainName (clojure.core/str v8972))))
   (clojure.core/let
    [v8972
     (:multi-az m8971 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8972 :com.palletops.awaze.client-builder/undef)
     (. bean8970 setMultiAZ (clojure.core/boolean v8972))))
   bean8970))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest}
describe-index-fields-request
  [m8974]
  (clojure.core/let
   [bean8973
    (new
     com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest)]
   (clojure.core/let
    [v8975
     (:domain-name m8974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8975 :com.palletops.awaze.client-builder/undef)
     (. bean8973 setDomainName (clojure.core/str v8975))))
   (clojure.core/let
    [v8975
     (:field-names m8974 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8975 :com.palletops.awaze.client-builder/undef)
     (.
      bean8973
      setFieldNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9009] (clojure.core/str arg9009))
 v8975))))
   bean8973))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeAvailabilityOptionsRequest}
describe-availability-options-request
  [m8977]
  (clojure.core/let
   [bean8976
    (new
     com.amazonaws.services.cloudsearch.model.DescribeAvailabilityOptionsRequest)]
   (clojure.core/let
    [v8978
     (:domain-name m8977 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8978 :com.palletops.awaze.client-builder/undef)
     (. bean8976 setDomainName (clojure.core/str v8978))))
   bean8976))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest}
delete-index-field-request
  [m8980]
  (clojure.core/let
   [bean8979
    (new
     com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest)]
   (clojure.core/let
    [v8981
     (:domain-name m8980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8981 :com.palletops.awaze.client-builder/undef)
     (. bean8979 setDomainName (clojure.core/str v8981))))
   (clojure.core/let
    [v8981
     (:index-field-name
      m8980
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8981 :com.palletops.awaze.client-builder/undef)
     (. bean8979 setIndexFieldName (clojure.core/str v8981))))
   bean8979))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest}
describe-stopword-options-request
  [m8983]
  (clojure.core/let
   [bean8982
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest)]
   (clojure.core/let
    [v8984
     (:domain-name m8983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8984 :com.palletops.awaze.client-builder/undef)
     (. bean8982 setDomainName (clojure.core/str v8984))))
   bean8982))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest}
describe-synonym-options-request
  [m8986]
  (clojure.core/let
   [bean8985
    (new
     com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest)]
   (clojure.core/let
    [v8987
     (:domain-name m8986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8987 :com.palletops.awaze.client-builder/undef)
     (. bean8985 setDomainName (clojure.core/str v8987))))
   bean8985))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest}
update-synonym-options-request
  [m8989]
  (clojure.core/let
   [bean8988
    (new
     com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest)]
   (clojure.core/let
    [v8990
     (:domain-name m8989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8990 :com.palletops.awaze.client-builder/undef)
     (. bean8988 setDomainName (clojure.core/str v8990))))
   (clojure.core/let
    [v8990
     (:synonyms m8989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8990 :com.palletops.awaze.client-builder/undef)
     (. bean8988 setSynonyms (clojure.core/str v8990))))
   bean8988))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteDomainRequest}
delete-domain-request
  [m8992]
  (clojure.core/let
   [bean8991
    (new com.amazonaws.services.cloudsearch.model.DeleteDomainRequest)]
   (clojure.core/let
    [v8993
     (:domain-name m8992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8993 :com.palletops.awaze.client-builder/undef)
     (. bean8991 setDomainName (clojure.core/str v8993))))
   bean8991))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest}
describe-rank-expressions-request
  [m8995]
  (clojure.core/let
   [bean8994
    (new
     com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest)]
   (clojure.core/let
    [v8996
     (:domain-name m8995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (. bean8994 setDomainName (clojure.core/str v8996))))
   (clojure.core/let
    [v8996
     (:rank-names m8995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8996 :com.palletops.awaze.client-builder/undef)
     (.
      bean8994
      setRankNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9010] (clojure.core/str arg9010))
 v8996))))
   bean8994))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest}
index-documents-request
  [m8998]
  (clojure.core/let
   [bean8997
    (new
     com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest)]
   (clojure.core/let
    [v8999
     (:domain-name m8998 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8999 :com.palletops.awaze.client-builder/undef)
     (. bean8997 setDomainName (clojure.core/str v8999))))
   bean8997))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest}
update-service-access-policies-request
  [m9001]
  (clojure.core/let
   [bean9000
    (new
     com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest)]
   (clojure.core/let
    [v9002
     (:domain-name m9001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9002 :com.palletops.awaze.client-builder/undef)
     (. bean9000 setDomainName (clojure.core/str v9002))))
   (clojure.core/let
    [v9002
     (:access-policies
      m9001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9002 :com.palletops.awaze.client-builder/undef)
     (. bean9000 setAccessPolicies (clojure.core/str v9002))))
   bean9000))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest}
update-stemming-options-request
  [m9004]
  (clojure.core/let
   [bean9003
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest)]
   (clojure.core/let
    [v9005
     (:domain-name m9004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9005 :com.palletops.awaze.client-builder/undef)
     (. bean9003 setDomainName (clojure.core/str v9005))))
   (clojure.core/let
    [v9005 (:stems m9004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9005 :com.palletops.awaze.client-builder/undef)
     (. bean9003 setStems (clojure.core/str v9005))))
   bean9003))
 (clojure.core/defmulti
  cloudsearch
  (clojure.core/fn
   cloudsearch
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-default-search-field
   [m9011]
   (clojure.core/let
    [credentials9012 (:credentials m9011) args9013 (:args m9011)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9014
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9012)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9014
       updateDefaultSearchField
       (cloudsearch/update-default-search-field-request
        (clojure.core/nth args9013 0)))))))
  (clojure.core/defn
   update-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         domain-name
                         default-search-field]}]]),
    :doc "Generate map for updateDefaultSearchField"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-default-search-field,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         domain-name
                         default-search-field]}]]),
    :doc "Call updateDefaultSearchField"}
   [credentials9016 & args9017]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9018
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9016)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9018
      updateDefaultSearchField
      (cloudsearch/update-default-search-field-request
       (clojure.core/nth args9017 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-service-access-policies
   [m9019]
   (clojure.core/let
    [credentials9020 (:credentials m9019) args9021 (:args m9019)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9022
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9020)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9022
       describeServiceAccessPolicies
       (cloudsearch/describe-service-access-policies-request
        (clojure.core/nth args9021 0)))))))
  (clojure.core/defn
   describe-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeServiceAccessPolicies"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-service-access-policies,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeServiceAccessPolicies"}
   [credentials9024 & args9025]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9026
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9024)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9026
      describeServiceAccessPolicies
      (cloudsearch/describe-service-access-policies-request
       (clojure.core/nth args9025 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-domains
   [m9027]
   (clojure.core/let
    [credentials9028 (:credentials m9027) args9029 (:args m9027)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9030
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9028)]
     (clojure.core/case
      (clojure.core/count args9029)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9030
        describeDomains
        (cloudsearch/describe-domains-request
         (clojure.core/nth args9029 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9030
        describeDomains))))))
  (clojure.core/defn
   describe-domains-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-names]}]
                [credentials]]),
    :doc "Generate map for describeDomains, describeDomains"}
   ([credentials__1651__auto__]
    {:args [],
     :client :cloudsearch,
     :fn :describe-domains,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-domains,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-domains
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-names]}]
                [credentials]]),
    :doc "Call describeDomains, describeDomains"}
   [credentials9032 & args9033]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9034
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9032)]
    (clojure.core/case
     (clojure.core/count args9033)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9034
       describeDomains
       (cloudsearch/describe-domains-request
        (clojure.core/nth args9033 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9034
       describeDomains))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-index-field
   [m9035]
   (clojure.core/let
    [credentials9036 (:credentials m9035) args9037 (:args m9035)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9038
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9036)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9038
       defineIndexField
       (cloudsearch/define-index-field-request
        (clojure.core/nth args9037 0)))))))
  (clojure.core/defn
   define-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [index-field
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for defineIndexField"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :define-index-field,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   define-index-field
   {:arglists (quote
               [[credentials
                 {:keys [index-field
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call defineIndexField"}
   [credentials9040 & args9041]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9042
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9040)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9042
      defineIndexField
      (cloudsearch/define-index-field-request
       (clojure.core/nth args9041 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-rank-expression
   [m9043]
   (clojure.core/let
    [credentials9044 (:credentials m9043) args9045 (:args m9043)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9046
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9044)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9046
       defineRankExpression
       (cloudsearch/define-rank-expression-request
        (clojure.core/nth args9045 0)))))))
  (clojure.core/defn
   define-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [rank-expression
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for defineRankExpression"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :define-rank-expression,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   define-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [rank-expression
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call defineRankExpression"}
   [credentials9048 & args9049]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9050
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9048)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9050
      defineRankExpression
      (cloudsearch/define-rank-expression-request
       (clojure.core/nth args9049 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stopword-options
   [m9051]
   (clojure.core/let
    [credentials9052 (:credentials m9051) args9053 (:args m9051)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9054
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9052)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9054
       updateStopwordOptions
       (cloudsearch/update-stopword-options-request
        (clojure.core/nth args9053 0)))))))
  (clojure.core/defn
   update-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [stopwords
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for updateStopwordOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-stopword-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [stopwords
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call updateStopwordOptions"}
   [credentials9056 & args9057]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9058
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9056)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9058
      updateStopwordOptions
      (cloudsearch/update-stopword-options-request
       (clojure.core/nth args9057 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-rank-expression
   [m9059]
   (clojure.core/let
    [credentials9060 (:credentials m9059) args9061 (:args m9059)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9062
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9060)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9062
       deleteRankExpression
       (cloudsearch/delete-rank-expression-request
        (clojure.core/nth args9061 0)))))))
  (clojure.core/defn
   delete-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [rank-name
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for deleteRankExpression"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :delete-rank-expression,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [rank-name
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call deleteRankExpression"}
   [credentials9064 & args9065]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9066
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9064)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9066
      deleteRankExpression
      (cloudsearch/delete-rank-expression-request
       (clojure.core/nth args9065 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-default-search-field
   [m9067]
   (clojure.core/let
    [credentials9068 (:credentials m9067) args9069 (:args m9067)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9070
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9068)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9070
       describeDefaultSearchField
       (cloudsearch/describe-default-search-field-request
        (clojure.core/nth args9069 0)))))))
  (clojure.core/defn
   describe-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeDefaultSearchField"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-default-search-field,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeDefaultSearchField"}
   [credentials9072 & args9073]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9074
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9072)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9074
      describeDefaultSearchField
      (cloudsearch/describe-default-search-field-request
       (clojure.core/nth args9073 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :create-domain
   [m9075]
   (clojure.core/let
    [credentials9076 (:credentials m9075) args9077 (:args m9075)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9078
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9076)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9078
       createDomain
       (cloudsearch/create-domain-request
        (clojure.core/nth args9077 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :create-domain,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call createDomain"}
   [credentials9080 & args9081]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9082
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9080)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9082
      createDomain
      (cloudsearch/create-domain-request
       (clojure.core/nth args9081 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stemming-options
   [m9083]
   (clojure.core/let
    [credentials9084 (:credentials m9083) args9085 (:args m9083)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9086
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9084)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9086
       describeStemmingOptions
       (cloudsearch/describe-stemming-options-request
        (clojure.core/nth args9085 0)))))))
  (clojure.core/defn
   describe-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeStemmingOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-stemming-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeStemmingOptions"}
   [credentials9088 & args9089]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9090
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9088)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9090
      describeStemmingOptions
      (cloudsearch/describe-stemming-options-request
       (clojure.core/nth args9089 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-availability-options
   [m9091]
   (clojure.core/let
    [credentials9092 (:credentials m9091) args9093 (:args m9091)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9094
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9092)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9094
       updateAvailabilityOptions
       (cloudsearch/update-availability-options-request
        (clojure.core/nth args9093 0)))))))
  (clojure.core/defn
   update-availability-options-map
   {:arglists (quote
               [[credentials
                 {:keys [multi-az
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for updateAvailabilityOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-availability-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-availability-options
   {:arglists (quote
               [[credentials
                 {:keys [multi-az
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call updateAvailabilityOptions"}
   [credentials9096 & args9097]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9098
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9096)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9098
      updateAvailabilityOptions
      (cloudsearch/update-availability-options-request
       (clojure.core/nth args9097 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-index-fields
   [m9099]
   (clojure.core/let
    [credentials9100 (:credentials m9099) args9101 (:args m9099)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9102
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9100)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9102
       describeIndexFields
       (cloudsearch/describe-index-fields-request
        (clojure.core/nth args9101 0)))))))
  (clojure.core/defn
   describe-index-fields-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         field-names
                         domain-name]}]]),
    :doc "Generate map for describeIndexFields"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-index-fields,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-index-fields
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         field-names
                         domain-name]}]]),
    :doc "Call describeIndexFields"}
   [credentials9104 & args9105]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9106
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9104)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9106
      describeIndexFields
      (cloudsearch/describe-index-fields-request
       (clojure.core/nth args9105 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-availability-options
   [m9107]
   (clojure.core/let
    [credentials9108 (:credentials m9107) args9109 (:args m9107)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9110
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9108)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9110
       describeAvailabilityOptions
       (cloudsearch/describe-availability-options-request
        (clojure.core/nth args9109 0)))))))
  (clojure.core/defn
   describe-availability-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeAvailabilityOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-availability-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-availability-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeAvailabilityOptions"}
   [credentials9112 & args9113]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9114
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9112)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9114
      describeAvailabilityOptions
      (cloudsearch/describe-availability-options-request
       (clojure.core/nth args9113 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-index-field
   [m9115]
   (clojure.core/let
    [credentials9116 (:credentials m9115) args9117 (:args m9115)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9118
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9116)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9118
       deleteIndexField
       (cloudsearch/delete-index-field-request
        (clojure.core/nth args9117 0)))))))
  (clojure.core/defn
   delete-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [index-field-name
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for deleteIndexField"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :delete-index-field,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-index-field
   {:arglists (quote
               [[credentials
                 {:keys [index-field-name
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call deleteIndexField"}
   [credentials9120 & args9121]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9122
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9120)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9122
      deleteIndexField
      (cloudsearch/delete-index-field-request
       (clojure.core/nth args9121 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stopword-options
   [m9123]
   (clojure.core/let
    [credentials9124 (:credentials m9123) args9125 (:args m9123)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9126
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9124)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9126
       describeStopwordOptions
       (cloudsearch/describe-stopword-options-request
        (clojure.core/nth args9125 0)))))))
  (clojure.core/defn
   describe-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeStopwordOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-stopword-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeStopwordOptions"}
   [credentials9128 & args9129]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9130
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9128)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9130
      describeStopwordOptions
      (cloudsearch/describe-stopword-options-request
       (clojure.core/nth args9129 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-synonym-options
   [m9131]
   (clojure.core/let
    [credentials9132 (:credentials m9131) args9133 (:args m9131)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9134
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9132)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9134
       describeSynonymOptions
       (cloudsearch/describe-synonym-options-request
        (clojure.core/nth args9133 0)))))))
  (clojure.core/defn
   describe-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeSynonymOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-synonym-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeSynonymOptions"}
   [credentials9136 & args9137]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9138
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9136)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9138
      describeSynonymOptions
      (cloudsearch/describe-synonym-options-request
       (clojure.core/nth args9137 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-synonym-options
   [m9139]
   (clojure.core/let
    [credentials9140 (:credentials m9139) args9141 (:args m9139)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9142
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9140)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9142
       updateSynonymOptions
       (cloudsearch/update-synonym-options-request
        (clojure.core/nth args9141 0)))))))
  (clojure.core/defn
   update-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [synonyms
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for updateSynonymOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-synonym-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [synonyms
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call updateSynonymOptions"}
   [credentials9144 & args9145]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9146
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9144)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9146
      updateSynonymOptions
      (cloudsearch/update-synonym-options-request
       (clojure.core/nth args9145 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-domain
   [m9147]
   (clojure.core/let
    [credentials9148 (:credentials m9147) args9149 (:args m9147)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9150
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9148)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9150
       deleteDomain
       (cloudsearch/delete-domain-request
        (clojure.core/nth args9149 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :delete-domain,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call deleteDomain"}
   [credentials9152 & args9153]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9154
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9152)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9154
      deleteDomain
      (cloudsearch/delete-domain-request
       (clojure.core/nth args9153 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-rank-expressions
   [m9155]
   (clojure.core/let
    [credentials9156 (:credentials m9155) args9157 (:args m9155)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9158
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9156)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9158
       describeRankExpressions
       (cloudsearch/describe-rank-expressions-request
        (clojure.core/nth args9157 0)))))))
  (clojure.core/defn
   describe-rank-expressions-map
   {:arglists (quote
               [[credentials
                 {:keys [rank-names
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for describeRankExpressions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-rank-expressions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-rank-expressions
   {:arglists (quote
               [[credentials
                 {:keys [rank-names
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call describeRankExpressions"}
   [credentials9160 & args9161]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9162
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9160)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9162
      describeRankExpressions
      (cloudsearch/describe-rank-expressions-request
       (clojure.core/nth args9161 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :index-documents
   [m9163]
   (clojure.core/let
    [credentials9164 (:credentials m9163) args9165 (:args m9163)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9166
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9164)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9166
       indexDocuments
       (cloudsearch/index-documents-request
        (clojure.core/nth args9165 0)))))))
  (clojure.core/defn
   index-documents-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for indexDocuments"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :index-documents,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   index-documents
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call indexDocuments"}
   [credentials9168 & args9169]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9170
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9168)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9170
      indexDocuments
      (cloudsearch/index-documents-request
       (clojure.core/nth args9169 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-service-access-policies
   [m9171]
   (clojure.core/let
    [credentials9172 (:credentials m9171) args9173 (:args m9171)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9174
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9172)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9174
       updateServiceAccessPolicies
       (cloudsearch/update-service-access-policies-request
        (clojure.core/nth args9173 0)))))))
  (clojure.core/defn
   update-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         domain-name
                         access-policies]}]]),
    :doc "Generate map for updateServiceAccessPolicies"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-service-access-policies,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         domain-name
                         access-policies]}]]),
    :doc "Call updateServiceAccessPolicies"}
   [credentials9176 & args9177]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9178
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9176)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9178
      updateServiceAccessPolicies
      (cloudsearch/update-service-access-policies-request
       (clojure.core/nth args9177 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stemming-options
   [m9179]
   (clojure.core/let
    [credentials9180 (:credentials m9179) args9181 (:args m9179)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9182
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9180)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9182
       updateStemmingOptions
       (cloudsearch/update-stemming-options-request
        (clojure.core/nth args9181 0)))))))
  (clojure.core/defn
   update-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [stems general-progress-listener domain-name]}]]),
    :doc "Generate map for updateStemmingOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-stemming-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [stems general-progress-listener domain-name]}]]),
    :doc "Call updateStemmingOptions"}
   [credentials9184 & args9185]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9186
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9184)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9186
      updateStemmingOptions
      (cloudsearch/update-stemming-options-request
       (clojure.core/nth args9185 0))))))))
