(ns
 com.palletops.awaze.beans.identitymanagement
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.beans.identitymanagement
   :as
   identitymanagement]))


(do
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.StatusType}
status-type
  [m11450]
  (.
   com.amazonaws.services.identitymanagement.model.StatusType
   fromValue
   (clojure.core/name m11450)))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetRolePolicyRequest}
get-role-policy-request
  [m11453]
  (clojure.core/let
   [bean11452
    (new
     com.amazonaws.services.identitymanagement.model.GetRolePolicyRequest)]
   (clojure.core/let
    [v11454
     (:policy-name m11453 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11454 :com.palletops.awaze.client-builder/undef)
     (. bean11452 setPolicyName (clojure.core/str v11454))))
   (clojure.core/let
    [v11454
     (:role-name m11453 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11454 :com.palletops.awaze.client-builder/undef)
     (. bean11452 setRoleName (clojure.core/str v11454))))
   bean11452))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ChangePasswordRequest}
change-password-request
  [m11456]
  (clojure.core/let
   [bean11455
    (new
     com.amazonaws.services.identitymanagement.model.ChangePasswordRequest)]
   (clojure.core/let
    [v11457
     (:old-password m11456 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11457 :com.palletops.awaze.client-builder/undef)
     (. bean11455 setOldPassword (clojure.core/str v11457))))
   (clojure.core/let
    [v11457
     (:new-password m11456 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11457 :com.palletops.awaze.client-builder/undef)
     (. bean11455 setNewPassword (clojure.core/str v11457))))
   bean11455))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeactivateMFADeviceRequest}
deactivate-mfadevice-request
  [m11459]
  (clojure.core/let
   [bean11458
    (new
     com.amazonaws.services.identitymanagement.model.DeactivateMFADeviceRequest)]
   (clojure.core/let
    [v11460
     (:serial-number m11459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11460 :com.palletops.awaze.client-builder/undef)
     (. bean11458 setSerialNumber (clojure.core/str v11460))))
   (clojure.core/let
    [v11460
     (:user-name m11459 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11460 :com.palletops.awaze.client-builder/undef)
     (. bean11458 setUserName (clojure.core/str v11460))))
   bean11458))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ResyncMFADeviceRequest}
resync-mfadevice-request
  [m11462]
  (clojure.core/let
   [bean11461
    (new
     com.amazonaws.services.identitymanagement.model.ResyncMFADeviceRequest)]
   (clojure.core/let
    [v11463
     (:serial-number m11462 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11463 :com.palletops.awaze.client-builder/undef)
     (. bean11461 setSerialNumber (clojure.core/str v11463))))
   (clojure.core/let
    [v11463
     (:user-name m11462 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11463 :com.palletops.awaze.client-builder/undef)
     (. bean11461 setUserName (clojure.core/str v11463))))
   (clojure.core/let
    [v11463
     (:authentication-code1
      m11462
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11463 :com.palletops.awaze.client-builder/undef)
     (. bean11461 setAuthenticationCode1 (clojure.core/str v11463))))
   (clojure.core/let
    [v11463
     (:authentication-code2
      m11462
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11463 :com.palletops.awaze.client-builder/undef)
     (. bean11461 setAuthenticationCode2 (clojure.core/str v11463))))
   bean11461))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateLoginProfileRequest}
update-login-profile-request
  [m11465]
  (clojure.core/let
   [bean11464
    (new
     com.amazonaws.services.identitymanagement.model.UpdateLoginProfileRequest)]
   (clojure.core/let
    [v11466
     (:password m11465 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11466 :com.palletops.awaze.client-builder/undef)
     (. bean11464 setPassword (clojure.core/str v11466))))
   (clojure.core/let
    [v11466
     (:user-name m11465 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11466 :com.palletops.awaze.client-builder/undef)
     (. bean11464 setUserName (clojure.core/str v11466))))
   bean11464))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.PutRolePolicyRequest}
put-role-policy-request
  [m11468]
  (clojure.core/let
   [bean11467
    (new
     com.amazonaws.services.identitymanagement.model.PutRolePolicyRequest)]
   (clojure.core/let
    [v11469
     (:policy-name m11468 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11469 :com.palletops.awaze.client-builder/undef)
     (. bean11467 setPolicyName (clojure.core/str v11469))))
   (clojure.core/let
    [v11469
     (:role-name m11468 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11469 :com.palletops.awaze.client-builder/undef)
     (. bean11467 setRoleName (clojure.core/str v11469))))
   (clojure.core/let
    [v11469
     (:policy-document
      m11468
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11469 :com.palletops.awaze.client-builder/undef)
     (. bean11467 setPolicyDocument (clojure.core/str v11469))))
   bean11467))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteSigningCertificateRequest}
delete-signing-certificate-request
  [m11471]
  (clojure.core/let
   [bean11470
    (new
     com.amazonaws.services.identitymanagement.model.DeleteSigningCertificateRequest)]
   (clojure.core/let
    [v11472
     (:user-name m11471 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11472 :com.palletops.awaze.client-builder/undef)
     (. bean11470 setUserName (clojure.core/str v11472))))
   (clojure.core/let
    [v11472
     (:certificate-id
      m11471
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11472 :com.palletops.awaze.client-builder/undef)
     (. bean11470 setCertificateId (clojure.core/str v11472))))
   bean11470))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteSAMLProviderRequest}
delete-samlprovider-request
  [m11474]
  (clojure.core/let
   [bean11473
    (new
     com.amazonaws.services.identitymanagement.model.DeleteSAMLProviderRequest)]
   (clojure.core/let
    [v11475
     (:samlprovider-arn
      m11474
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11475 :com.palletops.awaze.client-builder/undef)
     (. bean11473 setSAMLProviderArn (clojure.core/str v11475))))
   bean11473))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteUserRequest}
delete-user-request
  [m11477]
  (clojure.core/let
   [bean11476
    (new
     com.amazonaws.services.identitymanagement.model.DeleteUserRequest)]
   (clojure.core/let
    [v11478
     (:user-name m11477 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11478 :com.palletops.awaze.client-builder/undef)
     (. bean11476 setUserName (clojure.core/str v11478))))
   bean11476))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.AddUserToGroupRequest}
add-user-to-group-request
  [m11480]
  (clojure.core/let
   [bean11479
    (new
     com.amazonaws.services.identitymanagement.model.AddUserToGroupRequest)]
   (clojure.core/let
    [v11481
     (:group-name m11480 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11481 :com.palletops.awaze.client-builder/undef)
     (. bean11479 setGroupName (clojure.core/str v11481))))
   (clojure.core/let
    [v11481
     (:user-name m11480 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11481 :com.palletops.awaze.client-builder/undef)
     (. bean11479 setUserName (clojure.core/str v11481))))
   bean11479))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListAccountAliasesRequest}
list-account-aliases-request
  [m11483]
  (clojure.core/let
   [bean11482
    (new
     com.amazonaws.services.identitymanagement.model.ListAccountAliasesRequest)]
   (clojure.core/let
    [v11484
     (:max-items m11483 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11484 :com.palletops.awaze.client-builder/undef)
     (. bean11482 setMaxItems (clojure.core/int v11484))))
   (clojure.core/let
    [v11484
     (:marker m11483 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11484 :com.palletops.awaze.client-builder/undef)
     (. bean11482 setMarker (clojure.core/str v11484))))
   bean11482))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupRequest}
remove-user-from-group-request
  [m11486]
  (clojure.core/let
   [bean11485
    (new
     com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupRequest)]
   (clojure.core/let
    [v11487
     (:group-name m11486 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11487 :com.palletops.awaze.client-builder/undef)
     (. bean11485 setGroupName (clojure.core/str v11487))))
   (clojure.core/let
    [v11487
     (:user-name m11486 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11487 :com.palletops.awaze.client-builder/undef)
     (. bean11485 setUserName (clojure.core/str v11487))))
   bean11485))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateGroupRequest}
update-group-request
  [m11489]
  (clojure.core/let
   [bean11488
    (new
     com.amazonaws.services.identitymanagement.model.UpdateGroupRequest)]
   (clojure.core/let
    [v11490
     (:group-name m11489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11490 :com.palletops.awaze.client-builder/undef)
     (. bean11488 setGroupName (clojure.core/str v11490))))
   (clojure.core/let
    [v11490
     (:new-path m11489 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11490 :com.palletops.awaze.client-builder/undef)
     (. bean11488 setNewPath (clojure.core/str v11490))))
   (clojure.core/let
    [v11490
     (:new-group-name
      m11489
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11490 :com.palletops.awaze.client-builder/undef)
     (. bean11488 setNewGroupName (clojure.core/str v11490))))
   bean11488))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateServerCertificateRequest}
update-server-certificate-request
  [m11492]
  (clojure.core/let
   [bean11491
    (new
     com.amazonaws.services.identitymanagement.model.UpdateServerCertificateRequest)]
   (clojure.core/let
    [v11493
     (:new-path m11492 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11493 :com.palletops.awaze.client-builder/undef)
     (. bean11491 setNewPath (clojure.core/str v11493))))
   (clojure.core/let
    [v11493
     (:server-certificate-name
      m11492
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11493 :com.palletops.awaze.client-builder/undef)
     (. bean11491 setServerCertificateName (clojure.core/str v11493))))
   (clojure.core/let
    [v11493
     (:new-server-certificate-name
      m11492
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11493 :com.palletops.awaze.client-builder/undef)
     (.
      bean11491
      setNewServerCertificateName
      (clojure.core/str v11493))))
   bean11491))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteRolePolicyRequest}
delete-role-policy-request
  [m11495]
  (clojure.core/let
   [bean11494
    (new
     com.amazonaws.services.identitymanagement.model.DeleteRolePolicyRequest)]
   (clojure.core/let
    [v11496
     (:policy-name m11495 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11496 :com.palletops.awaze.client-builder/undef)
     (. bean11494 setPolicyName (clojure.core/str v11496))))
   (clojure.core/let
    [v11496
     (:role-name m11495 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11496 :com.palletops.awaze.client-builder/undef)
     (. bean11494 setRoleName (clojure.core/str v11496))))
   bean11494))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateAccessKeyRequest}
update-access-key-request
  [m11498]
  (clojure.core/let
   [bean11497
    (new
     com.amazonaws.services.identitymanagement.model.UpdateAccessKeyRequest)]
   (clojure.core/let
    [v11499
     (:status m11498 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11499 :com.palletops.awaze.client-builder/undef)
     (. bean11497 setStatus (identitymanagement/status-type v11499))))
   (clojure.core/let
    [v11499
     (:user-name m11498 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11499 :com.palletops.awaze.client-builder/undef)
     (. bean11497 setUserName (clojure.core/str v11499))))
   (clojure.core/let
    [v11499
     (:access-key-id m11498 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11499 :com.palletops.awaze.client-builder/undef)
     (. bean11497 setAccessKeyId (clojure.core/str v11499))))
   bean11497))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteGroupRequest}
delete-group-request
  [m11501]
  (clojure.core/let
   [bean11500
    (new
     com.amazonaws.services.identitymanagement.model.DeleteGroupRequest)]
   (clojure.core/let
    [v11502
     (:group-name m11501 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11502 :com.palletops.awaze.client-builder/undef)
     (. bean11500 setGroupName (clojure.core/str v11502))))
   bean11500))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListGroupsForUserRequest}
list-groups-for-user-request
  [m11504]
  (clojure.core/let
   [bean11503
    (new
     com.amazonaws.services.identitymanagement.model.ListGroupsForUserRequest)]
   (clojure.core/let
    [v11505
     (:max-items m11504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11505 :com.palletops.awaze.client-builder/undef)
     (. bean11503 setMaxItems (clojure.core/int v11505))))
   (clojure.core/let
    [v11505
     (:marker m11504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11505 :com.palletops.awaze.client-builder/undef)
     (. bean11503 setMarker (clojure.core/str v11505))))
   (clojure.core/let
    [v11505
     (:user-name m11504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11505 :com.palletops.awaze.client-builder/undef)
     (. bean11503 setUserName (clojure.core/str v11505))))
   bean11503))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest}
put-user-policy-request
  [m11507]
  (clojure.core/let
   [bean11506
    (new
     com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest)]
   (clojure.core/let
    [v11508
     (:policy-name m11507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11508 :com.palletops.awaze.client-builder/undef)
     (. bean11506 setPolicyName (clojure.core/str v11508))))
   (clojure.core/let
    [v11508
     (:user-name m11507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11508 :com.palletops.awaze.client-builder/undef)
     (. bean11506 setUserName (clojure.core/str v11508))))
   (clojure.core/let
    [v11508
     (:policy-document
      m11507
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11508 :com.palletops.awaze.client-builder/undef)
     (. bean11506 setPolicyDocument (clojure.core/str v11508))))
   bean11506))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetRoleRequest}
get-role-request
  [m11510]
  (clojure.core/let
   [bean11509
    (new
     com.amazonaws.services.identitymanagement.model.GetRoleRequest)]
   (clojure.core/let
    [v11511
     (:role-name m11510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11511 :com.palletops.awaze.client-builder/undef)
     (. bean11509 setRoleName (clojure.core/str v11511))))
   bean11509))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetAccountPasswordPolicyRequest}
get-account-password-policy-request
  [m11513]
  (clojure.core/let
   [bean11512
    (new
     com.amazonaws.services.identitymanagement.model.GetAccountPasswordPolicyRequest)]
   bean11512))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest}
list-access-keys-request
  [m11516]
  (clojure.core/let
   [bean11515
    (new
     com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest)]
   (clojure.core/let
    [v11517
     (:max-items m11516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11517 :com.palletops.awaze.client-builder/undef)
     (. bean11515 setMaxItems (clojure.core/int v11517))))
   (clojure.core/let
    [v11517
     (:marker m11516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11517 :com.palletops.awaze.client-builder/undef)
     (. bean11515 setMarker (clojure.core/str v11517))))
   (clojure.core/let
    [v11517
     (:user-name m11516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11517 :com.palletops.awaze.client-builder/undef)
     (. bean11515 setUserName (clojure.core/str v11517))))
   bean11515))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteAccountAliasRequest}
delete-account-alias-request
  [m11519]
  (clojure.core/let
   [bean11518
    (new
     com.amazonaws.services.identitymanagement.model.DeleteAccountAliasRequest)]
   (clojure.core/let
    [v11520
     (:account-alias m11519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11520 :com.palletops.awaze.client-builder/undef)
     (. bean11518 setAccountAlias (clojure.core/str v11520))))
   bean11518))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetLoginProfileRequest}
get-login-profile-request
  [m11522]
  (clojure.core/let
   [bean11521
    (new
     com.amazonaws.services.identitymanagement.model.GetLoginProfileRequest)]
   (clojure.core/let
    [v11523
     (:user-name m11522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11523 :com.palletops.awaze.client-builder/undef)
     (. bean11521 setUserName (clojure.core/str v11523))))
   bean11521))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateLoginProfileRequest}
create-login-profile-request
  [m11525]
  (clojure.core/let
   [bean11524
    (new
     com.amazonaws.services.identitymanagement.model.CreateLoginProfileRequest)]
   (clojure.core/let
    [v11526
     (:password m11525 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11526 :com.palletops.awaze.client-builder/undef)
     (. bean11524 setPassword (clojure.core/str v11526))))
   (clojure.core/let
    [v11526
     (:user-name m11525 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11526 :com.palletops.awaze.client-builder/undef)
     (. bean11524 setUserName (clojure.core/str v11526))))
   bean11524))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListGroupsRequest}
list-groups-request
  [m11528]
  (clojure.core/let
   [bean11527
    (new
     com.amazonaws.services.identitymanagement.model.ListGroupsRequest)]
   (clojure.core/let
    [v11529
     (:max-items m11528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11529 :com.palletops.awaze.client-builder/undef)
     (. bean11527 setMaxItems (clojure.core/int v11529))))
   (clojure.core/let
    [v11529
     (:marker m11528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11529 :com.palletops.awaze.client-builder/undef)
     (. bean11527 setMarker (clojure.core/str v11529))))
   (clojure.core/let
    [v11529
     (:path-prefix m11528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11529 :com.palletops.awaze.client-builder/undef)
     (. bean11527 setPathPrefix (clojure.core/str v11529))))
   bean11527))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetAccountSummaryRequest}
get-account-summary-request
  [m11531]
  (clojure.core/let
   [bean11530
    (new
     com.amazonaws.services.identitymanagement.model.GetAccountSummaryRequest)]
   bean11530))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteAccountPasswordPolicyRequest}
delete-account-password-policy-request
  [m11534]
  (clojure.core/let
   [bean11533
    (new
     com.amazonaws.services.identitymanagement.model.DeleteAccountPasswordPolicyRequest)]
   bean11533))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest}
get-instance-profile-request
  [m11537]
  (clojure.core/let
   [bean11536
    (new
     com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest)]
   (clojure.core/let
    [v11538
     (:instance-profile-name
      m11537
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11538 :com.palletops.awaze.client-builder/undef)
     (. bean11536 setInstanceProfileName (clojure.core/str v11538))))
   bean11536))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetUserRequest}
get-user-request
  [m11540]
  (clojure.core/let
   [bean11539
    (new
     com.amazonaws.services.identitymanagement.model.GetUserRequest)]
   (clojure.core/let
    [v11541
     (:user-name m11540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11541 :com.palletops.awaze.client-builder/undef)
     (. bean11539 setUserName (clojure.core/str v11541))))
   bean11539))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateSAMLProviderRequest}
update-samlprovider-request
  [m11543]
  (clojure.core/let
   [bean11542
    (new
     com.amazonaws.services.identitymanagement.model.UpdateSAMLProviderRequest)]
   (clojure.core/let
    [v11544
     (:samlprovider-arn
      m11543
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11544 :com.palletops.awaze.client-builder/undef)
     (. bean11542 setSAMLProviderArn (clojure.core/str v11544))))
   (clojure.core/let
    [v11544
     (:samlmetadata-document
      m11543
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11544 :com.palletops.awaze.client-builder/undef)
     (. bean11542 setSAMLMetadataDocument (clojure.core/str v11544))))
   bean11542))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateSAMLProviderRequest}
create-samlprovider-request
  [m11546]
  (clojure.core/let
   [bean11545
    (new
     com.amazonaws.services.identitymanagement.model.CreateSAMLProviderRequest)]
   (clojure.core/let
    [v11547 (:name m11546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11547 :com.palletops.awaze.client-builder/undef)
     (. bean11545 setName (clojure.core/str v11547))))
   (clojure.core/let
    [v11547
     (:samlmetadata-document
      m11546
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11547 :com.palletops.awaze.client-builder/undef)
     (. bean11545 setSAMLMetadataDocument (clojure.core/str v11547))))
   bean11545))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListSAMLProvidersRequest}
list-samlproviders-request
  [m11549]
  (clojure.core/let
   [bean11548
    (new
     com.amazonaws.services.identitymanagement.model.ListSAMLProvidersRequest)]
   bean11548))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteVirtualMFADeviceRequest}
delete-virtual-mfadevice-request
  [m11552]
  (clojure.core/let
   [bean11551
    (new
     com.amazonaws.services.identitymanagement.model.DeleteVirtualMFADeviceRequest)]
   (clojure.core/let
    [v11553
     (:serial-number m11552 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11553 :com.palletops.awaze.client-builder/undef)
     (. bean11551 setSerialNumber (clojure.core/str v11553))))
   bean11551))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest}
create-access-key-request
  [m11555]
  (clojure.core/let
   [bean11554
    (new
     com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest)]
   (clojure.core/let
    [v11556
     (:user-name m11555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11556 :com.palletops.awaze.client-builder/undef)
     (. bean11554 setUserName (clojure.core/str v11556))))
   bean11554))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListInstanceProfilesRequest}
list-instance-profiles-request
  [m11558]
  (clojure.core/let
   [bean11557
    (new
     com.amazonaws.services.identitymanagement.model.ListInstanceProfilesRequest)]
   (clojure.core/let
    [v11559
     (:max-items m11558 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11559 :com.palletops.awaze.client-builder/undef)
     (. bean11557 setMaxItems (clojure.core/int v11559))))
   (clojure.core/let
    [v11559
     (:marker m11558 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11559 :com.palletops.awaze.client-builder/undef)
     (. bean11557 setMarker (clojure.core/str v11559))))
   (clojure.core/let
    [v11559
     (:path-prefix m11558 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11559 :com.palletops.awaze.client-builder/undef)
     (. bean11557 setPathPrefix (clojure.core/str v11559))))
   bean11557))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.PutGroupPolicyRequest}
put-group-policy-request
  [m11561]
  (clojure.core/let
   [bean11560
    (new
     com.amazonaws.services.identitymanagement.model.PutGroupPolicyRequest)]
   (clojure.core/let
    [v11562
     (:policy-name m11561 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11562 :com.palletops.awaze.client-builder/undef)
     (. bean11560 setPolicyName (clojure.core/str v11562))))
   (clojure.core/let
    [v11562
     (:group-name m11561 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11562 :com.palletops.awaze.client-builder/undef)
     (. bean11560 setGroupName (clojure.core/str v11562))))
   (clojure.core/let
    [v11562
     (:policy-document
      m11561
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11562 :com.palletops.awaze.client-builder/undef)
     (. bean11560 setPolicyDocument (clojure.core/str v11562))))
   bean11560))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetServerCertificateRequest}
get-server-certificate-request
  [m11564]
  (clojure.core/let
   [bean11563
    (new
     com.amazonaws.services.identitymanagement.model.GetServerCertificateRequest)]
   (clojure.core/let
    [v11565
     (:server-certificate-name
      m11564
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11565 :com.palletops.awaze.client-builder/undef)
     (. bean11563 setServerCertificateName (clojure.core/str v11565))))
   bean11563))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UploadServerCertificateRequest}
upload-server-certificate-request
  [m11567]
  (clojure.core/let
   [bean11566
    (new
     com.amazonaws.services.identitymanagement.model.UploadServerCertificateRequest)]
   (clojure.core/let
    [v11568 (:path m11567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11568 :com.palletops.awaze.client-builder/undef)
     (. bean11566 setPath (clojure.core/str v11568))))
   (clojure.core/let
    [v11568
     (:server-certificate-name
      m11567
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11568 :com.palletops.awaze.client-builder/undef)
     (. bean11566 setServerCertificateName (clojure.core/str v11568))))
   (clojure.core/let
    [v11568
     (:certificate-body
      m11567
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11568 :com.palletops.awaze.client-builder/undef)
     (. bean11566 setCertificateBody (clojure.core/str v11568))))
   (clojure.core/let
    [v11568
     (:private-key m11567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11568 :com.palletops.awaze.client-builder/undef)
     (. bean11566 setPrivateKey (clojure.core/str v11568))))
   (clojure.core/let
    [v11568
     (:certificate-chain
      m11567
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11568 :com.palletops.awaze.client-builder/undef)
     (. bean11566 setCertificateChain (clojure.core/str v11568))))
   bean11566))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListRolePoliciesRequest}
list-role-policies-request
  [m11570]
  (clojure.core/let
   [bean11569
    (new
     com.amazonaws.services.identitymanagement.model.ListRolePoliciesRequest)]
   (clojure.core/let
    [v11571
     (:max-items m11570 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11571 :com.palletops.awaze.client-builder/undef)
     (. bean11569 setMaxItems (clojure.core/int v11571))))
   (clojure.core/let
    [v11571
     (:marker m11570 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11571 :com.palletops.awaze.client-builder/undef)
     (. bean11569 setMarker (clojure.core/str v11571))))
   (clojure.core/let
    [v11571
     (:role-name m11570 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11571 :com.palletops.awaze.client-builder/undef)
     (. bean11569 setRoleName (clojure.core/str v11571))))
   bean11569))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest}
add-role-to-instance-profile-request
  [m11573]
  (clojure.core/let
   [bean11572
    (new
     com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest)]
   (clojure.core/let
    [v11574
     (:instance-profile-name
      m11573
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11574 :com.palletops.awaze.client-builder/undef)
     (. bean11572 setInstanceProfileName (clojure.core/str v11574))))
   (clojure.core/let
    [v11574
     (:role-name m11573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11574 :com.palletops.awaze.client-builder/undef)
     (. bean11572 setRoleName (clojure.core/str v11574))))
   bean11572))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest}
delete-access-key-request
  [m11576]
  (clojure.core/let
   [bean11575
    (new
     com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest)]
   (clojure.core/let
    [v11577
     (:user-name m11576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11577 :com.palletops.awaze.client-builder/undef)
     (. bean11575 setUserName (clojure.core/str v11577))))
   (clojure.core/let
    [v11577
     (:access-key-id m11576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11577 :com.palletops.awaze.client-builder/undef)
     (. bean11575 setAccessKeyId (clojure.core/str v11577))))
   bean11575))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteRoleRequest}
delete-role-request
  [m11579]
  (clojure.core/let
   [bean11578
    (new
     com.amazonaws.services.identitymanagement.model.DeleteRoleRequest)]
   (clojure.core/let
    [v11580
     (:role-name m11579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11580 :com.palletops.awaze.client-builder/undef)
     (. bean11578 setRoleName (clojure.core/str v11580))))
   bean11578))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceRequest}
create-virtual-mfadevice-request
  [m11582]
  (clojure.core/let
   [bean11581
    (new
     com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceRequest)]
   (clojure.core/let
    [v11583
     (:virtual-mfadevice-name
      m11582
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11583 :com.palletops.awaze.client-builder/undef)
     (. bean11581 setVirtualMFADeviceName (clojure.core/str v11583))))
   (clojure.core/let
    [v11583 (:path m11582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11583 :com.palletops.awaze.client-builder/undef)
     (. bean11581 setPath (clojure.core/str v11583))))
   bean11581))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListGroupPoliciesRequest}
list-group-policies-request
  [m11585]
  (clojure.core/let
   [bean11584
    (new
     com.amazonaws.services.identitymanagement.model.ListGroupPoliciesRequest)]
   (clojure.core/let
    [v11586
     (:max-items m11585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11586 :com.palletops.awaze.client-builder/undef)
     (. bean11584 setMaxItems (clojure.core/int v11586))))
   (clojure.core/let
    [v11586
     (:marker m11585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11586 :com.palletops.awaze.client-builder/undef)
     (. bean11584 setMarker (clojure.core/str v11586))))
   (clojure.core/let
    [v11586
     (:group-name m11585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11586 :com.palletops.awaze.client-builder/undef)
     (. bean11584 setGroupName (clojure.core/str v11586))))
   bean11584))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetGroupPolicyRequest}
get-group-policy-request
  [m11588]
  (clojure.core/let
   [bean11587
    (new
     com.amazonaws.services.identitymanagement.model.GetGroupPolicyRequest)]
   (clojure.core/let
    [v11589
     (:policy-name m11588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11589 :com.palletops.awaze.client-builder/undef)
     (. bean11587 setPolicyName (clojure.core/str v11589))))
   (clojure.core/let
    [v11589
     (:group-name m11588 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11589 :com.palletops.awaze.client-builder/undef)
     (. bean11587 setGroupName (clojure.core/str v11589))))
   bean11587))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListServerCertificatesRequest}
list-server-certificates-request
  [m11591]
  (clojure.core/let
   [bean11590
    (new
     com.amazonaws.services.identitymanagement.model.ListServerCertificatesRequest)]
   (clojure.core/let
    [v11592
     (:max-items m11591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11592 :com.palletops.awaze.client-builder/undef)
     (. bean11590 setMaxItems (clojure.core/int v11592))))
   (clojure.core/let
    [v11592
     (:marker m11591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11592 :com.palletops.awaze.client-builder/undef)
     (. bean11590 setMarker (clojure.core/str v11592))))
   (clojure.core/let
    [v11592
     (:path-prefix m11591 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11592 :com.palletops.awaze.client-builder/undef)
     (. bean11590 setPathPrefix (clojure.core/str v11592))))
   bean11590))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateAccountPasswordPolicyRequest}
update-account-password-policy-request
  [m11594]
  (clojure.core/let
   [bean11593
    (new
     com.amazonaws.services.identitymanagement.model.UpdateAccountPasswordPolicyRequest)]
   (clojure.core/let
    [v11595
     (:minimum-password-length
      m11594
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11595 :com.palletops.awaze.client-builder/undef)
     (. bean11593 setMinimumPasswordLength (clojure.core/int v11595))))
   (clojure.core/let
    [v11595
     (:require-symbols
      m11594
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11595 :com.palletops.awaze.client-builder/undef)
     (. bean11593 setRequireSymbols (clojure.core/boolean v11595))))
   (clojure.core/let
    [v11595
     (:require-numbers
      m11594
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11595 :com.palletops.awaze.client-builder/undef)
     (. bean11593 setRequireNumbers (clojure.core/boolean v11595))))
   (clojure.core/let
    [v11595
     (:require-uppercase-characters
      m11594
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11595 :com.palletops.awaze.client-builder/undef)
     (.
      bean11593
      setRequireUppercaseCharacters
      (clojure.core/boolean v11595))))
   (clojure.core/let
    [v11595
     (:require-lowercase-characters
      m11594
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11595 :com.palletops.awaze.client-builder/undef)
     (.
      bean11593
      setRequireLowercaseCharacters
      (clojure.core/boolean v11595))))
   (clojure.core/let
    [v11595
     (:allow-users-to-change-password
      m11594
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11595 :com.palletops.awaze.client-builder/undef)
     (.
      bean11593
      setAllowUsersToChangePassword
      (clojure.core/boolean v11595))))
   bean11593))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateGroupRequest}
create-group-request
  [m11597]
  (clojure.core/let
   [bean11596
    (new
     com.amazonaws.services.identitymanagement.model.CreateGroupRequest)]
   (clojure.core/let
    [v11598 (:path m11597 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11598 :com.palletops.awaze.client-builder/undef)
     (. bean11596 setPath (clojure.core/str v11598))))
   (clojure.core/let
    [v11598
     (:group-name m11597 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11598 :com.palletops.awaze.client-builder/undef)
     (. bean11596 setGroupName (clojure.core/str v11598))))
   bean11596))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleRequest}
list-instance-profiles-for-role-request
  [m11600]
  (clojure.core/let
   [bean11599
    (new
     com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleRequest)]
   (clojure.core/let
    [v11601
     (:max-items m11600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11601 :com.palletops.awaze.client-builder/undef)
     (. bean11599 setMaxItems (clojure.core/int v11601))))
   (clojure.core/let
    [v11601
     (:marker m11600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11601 :com.palletops.awaze.client-builder/undef)
     (. bean11599 setMarker (clojure.core/str v11601))))
   (clojure.core/let
    [v11601
     (:role-name m11600 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11601 :com.palletops.awaze.client-builder/undef)
     (. bean11599 setRoleName (clojure.core/str v11601))))
   bean11599))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UploadSigningCertificateRequest}
upload-signing-certificate-request
  [m11603]
  (clojure.core/let
   [bean11602
    (new
     com.amazonaws.services.identitymanagement.model.UploadSigningCertificateRequest)]
   (clojure.core/let
    [v11604
     (:user-name m11603 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11604 :com.palletops.awaze.client-builder/undef)
     (. bean11602 setUserName (clojure.core/str v11604))))
   (clojure.core/let
    [v11604
     (:certificate-body
      m11603
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11604 :com.palletops.awaze.client-builder/undef)
     (. bean11602 setCertificateBody (clojure.core/str v11604))))
   bean11602))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteServerCertificateRequest}
delete-server-certificate-request
  [m11606]
  (clojure.core/let
   [bean11605
    (new
     com.amazonaws.services.identitymanagement.model.DeleteServerCertificateRequest)]
   (clojure.core/let
    [v11607
     (:server-certificate-name
      m11606
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11607 :com.palletops.awaze.client-builder/undef)
     (. bean11605 setServerCertificateName (clojure.core/str v11607))))
   bean11605))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListVirtualMFADevicesRequest}
list-virtual-mfadevices-request
  [m11609]
  (clojure.core/let
   [bean11608
    (new
     com.amazonaws.services.identitymanagement.model.ListVirtualMFADevicesRequest)]
   (clojure.core/let
    [v11610
     (:assignment-status
      m11609
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11610 :com.palletops.awaze.client-builder/undef)
     (. bean11608 setAssignmentStatus (clojure.core/str v11610))))
   (clojure.core/let
    [v11610
     (:max-items m11609 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11610 :com.palletops.awaze.client-builder/undef)
     (. bean11608 setMaxItems (clojure.core/int v11610))))
   (clojure.core/let
    [v11610
     (:marker m11609 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11610 :com.palletops.awaze.client-builder/undef)
     (. bean11608 setMarker (clojure.core/str v11610))))
   bean11608))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest}
remove-role-from-instance-profile-request
  [m11612]
  (clojure.core/let
   [bean11611
    (new
     com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest)]
   (clojure.core/let
    [v11613
     (:instance-profile-name
      m11612
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11613 :com.palletops.awaze.client-builder/undef)
     (. bean11611 setInstanceProfileName (clojure.core/str v11613))))
   (clojure.core/let
    [v11613
     (:role-name m11612 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11613 :com.palletops.awaze.client-builder/undef)
     (. bean11611 setRoleName (clojure.core/str v11613))))
   bean11611))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListSigningCertificatesRequest}
list-signing-certificates-request
  [m11615]
  (clojure.core/let
   [bean11614
    (new
     com.amazonaws.services.identitymanagement.model.ListSigningCertificatesRequest)]
   (clojure.core/let
    [v11616
     (:max-items m11615 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11616 :com.palletops.awaze.client-builder/undef)
     (. bean11614 setMaxItems (clojure.core/int v11616))))
   (clojure.core/let
    [v11616
     (:marker m11615 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11616 :com.palletops.awaze.client-builder/undef)
     (. bean11614 setMarker (clojure.core/str v11616))))
   (clojure.core/let
    [v11616
     (:user-name m11615 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11616 :com.palletops.awaze.client-builder/undef)
     (. bean11614 setUserName (clojure.core/str v11616))))
   bean11614))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileRequest}
delete-instance-profile-request
  [m11618]
  (clojure.core/let
   [bean11617
    (new
     com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileRequest)]
   (clojure.core/let
    [v11619
     (:instance-profile-name
      m11618
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11619 :com.palletops.awaze.client-builder/undef)
     (. bean11617 setInstanceProfileName (clojure.core/str v11619))))
   bean11617))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListMFADevicesRequest}
list-mfadevices-request
  [m11621]
  (clojure.core/let
   [bean11620
    (new
     com.amazonaws.services.identitymanagement.model.ListMFADevicesRequest)]
   (clojure.core/let
    [v11622
     (:max-items m11621 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11622 :com.palletops.awaze.client-builder/undef)
     (. bean11620 setMaxItems (clojure.core/int v11622))))
   (clojure.core/let
    [v11622
     (:marker m11621 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11622 :com.palletops.awaze.client-builder/undef)
     (. bean11620 setMarker (clojure.core/str v11622))))
   (clojure.core/let
    [v11622
     (:user-name m11621 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11622 :com.palletops.awaze.client-builder/undef)
     (. bean11620 setUserName (clojure.core/str v11622))))
   bean11620))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest}
delete-user-policy-request
  [m11624]
  (clojure.core/let
   [bean11623
    (new
     com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest)]
   (clojure.core/let
    [v11625
     (:policy-name m11624 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11625 :com.palletops.awaze.client-builder/undef)
     (. bean11623 setPolicyName (clojure.core/str v11625))))
   (clojure.core/let
    [v11625
     (:user-name m11624 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11625 :com.palletops.awaze.client-builder/undef)
     (. bean11623 setUserName (clojure.core/str v11625))))
   bean11623))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateAccountAliasRequest}
create-account-alias-request
  [m11627]
  (clojure.core/let
   [bean11626
    (new
     com.amazonaws.services.identitymanagement.model.CreateAccountAliasRequest)]
   (clojure.core/let
    [v11628
     (:account-alias m11627 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11628 :com.palletops.awaze.client-builder/undef)
     (. bean11626 setAccountAlias (clojure.core/str v11628))))
   bean11626))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateSigningCertificateRequest}
update-signing-certificate-request
  [m11630]
  (clojure.core/let
   [bean11629
    (new
     com.amazonaws.services.identitymanagement.model.UpdateSigningCertificateRequest)]
   (clojure.core/let
    [v11631
     (:status m11630 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11631 :com.palletops.awaze.client-builder/undef)
     (. bean11629 setStatus (identitymanagement/status-type v11631))))
   (clojure.core/let
    [v11631
     (:user-name m11630 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11631 :com.palletops.awaze.client-builder/undef)
     (. bean11629 setUserName (clojure.core/str v11631))))
   (clojure.core/let
    [v11631
     (:certificate-id
      m11630
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11631 :com.palletops.awaze.client-builder/undef)
     (. bean11629 setCertificateId (clojure.core/str v11631))))
   bean11629))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateAssumeRolePolicyRequest}
update-assume-role-policy-request
  [m11633]
  (clojure.core/let
   [bean11632
    (new
     com.amazonaws.services.identitymanagement.model.UpdateAssumeRolePolicyRequest)]
   (clojure.core/let
    [v11634
     (:role-name m11633 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11634 :com.palletops.awaze.client-builder/undef)
     (. bean11632 setRoleName (clojure.core/str v11634))))
   (clojure.core/let
    [v11634
     (:policy-document
      m11633
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11634 :com.palletops.awaze.client-builder/undef)
     (. bean11632 setPolicyDocument (clojure.core/str v11634))))
   bean11632))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListRolesRequest}
list-roles-request
  [m11636]
  (clojure.core/let
   [bean11635
    (new
     com.amazonaws.services.identitymanagement.model.ListRolesRequest)]
   (clojure.core/let
    [v11637
     (:max-items m11636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11637 :com.palletops.awaze.client-builder/undef)
     (. bean11635 setMaxItems (clojure.core/int v11637))))
   (clojure.core/let
    [v11637
     (:marker m11636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11637 :com.palletops.awaze.client-builder/undef)
     (. bean11635 setMarker (clojure.core/str v11637))))
   (clojure.core/let
    [v11637
     (:path-prefix m11636 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11637 :com.palletops.awaze.client-builder/undef)
     (. bean11635 setPathPrefix (clojure.core/str v11637))))
   bean11635))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest}
list-user-policies-request
  [m11639]
  (clojure.core/let
   [bean11638
    (new
     com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest)]
   (clojure.core/let
    [v11640
     (:max-items m11639 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11640 :com.palletops.awaze.client-builder/undef)
     (. bean11638 setMaxItems (clojure.core/int v11640))))
   (clojure.core/let
    [v11640
     (:marker m11639 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11640 :com.palletops.awaze.client-builder/undef)
     (. bean11638 setMarker (clojure.core/str v11640))))
   (clojure.core/let
    [v11640
     (:user-name m11639 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11640 :com.palletops.awaze.client-builder/undef)
     (. bean11638 setUserName (clojure.core/str v11640))))
   bean11638))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteLoginProfileRequest}
delete-login-profile-request
  [m11642]
  (clojure.core/let
   [bean11641
    (new
     com.amazonaws.services.identitymanagement.model.DeleteLoginProfileRequest)]
   (clojure.core/let
    [v11643
     (:user-name m11642 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11643 :com.palletops.awaze.client-builder/undef)
     (. bean11641 setUserName (clojure.core/str v11643))))
   bean11641))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.EnableMFADeviceRequest}
enable-mfadevice-request
  [m11645]
  (clojure.core/let
   [bean11644
    (new
     com.amazonaws.services.identitymanagement.model.EnableMFADeviceRequest)]
   (clojure.core/let
    [v11646
     (:serial-number m11645 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11646 :com.palletops.awaze.client-builder/undef)
     (. bean11644 setSerialNumber (clojure.core/str v11646))))
   (clojure.core/let
    [v11646
     (:user-name m11645 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11646 :com.palletops.awaze.client-builder/undef)
     (. bean11644 setUserName (clojure.core/str v11646))))
   (clojure.core/let
    [v11646
     (:authentication-code1
      m11645
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11646 :com.palletops.awaze.client-builder/undef)
     (. bean11644 setAuthenticationCode1 (clojure.core/str v11646))))
   (clojure.core/let
    [v11646
     (:authentication-code2
      m11645
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11646 :com.palletops.awaze.client-builder/undef)
     (. bean11644 setAuthenticationCode2 (clojure.core/str v11646))))
   bean11644))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetSAMLProviderRequest}
get-samlprovider-request
  [m11648]
  (clojure.core/let
   [bean11647
    (new
     com.amazonaws.services.identitymanagement.model.GetSAMLProviderRequest)]
   (clojure.core/let
    [v11649
     (:samlprovider-arn
      m11648
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11649 :com.palletops.awaze.client-builder/undef)
     (. bean11647 setSAMLProviderArn (clojure.core/str v11649))))
   bean11647))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetGroupRequest}
get-group-request
  [m11651]
  (clojure.core/let
   [bean11650
    (new
     com.amazonaws.services.identitymanagement.model.GetGroupRequest)]
   (clojure.core/let
    [v11652
     (:max-items m11651 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11652 :com.palletops.awaze.client-builder/undef)
     (. bean11650 setMaxItems (clojure.core/int v11652))))
   (clojure.core/let
    [v11652
     (:marker m11651 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11652 :com.palletops.awaze.client-builder/undef)
     (. bean11650 setMarker (clojure.core/str v11652))))
   (clojure.core/let
    [v11652
     (:group-name m11651 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11652 :com.palletops.awaze.client-builder/undef)
     (. bean11650 setGroupName (clojure.core/str v11652))))
   bean11650))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteGroupPolicyRequest}
delete-group-policy-request
  [m11654]
  (clojure.core/let
   [bean11653
    (new
     com.amazonaws.services.identitymanagement.model.DeleteGroupPolicyRequest)]
   (clojure.core/let
    [v11655
     (:policy-name m11654 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11655 :com.palletops.awaze.client-builder/undef)
     (. bean11653 setPolicyName (clojure.core/str v11655))))
   (clojure.core/let
    [v11655
     (:group-name m11654 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11655 :com.palletops.awaze.client-builder/undef)
     (. bean11653 setGroupName (clojure.core/str v11655))))
   bean11653))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest}
create-instance-profile-request
  [m11657]
  (clojure.core/let
   [bean11656
    (new
     com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest)]
   (clojure.core/let
    [v11658
     (:instance-profile-name
      m11657
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11658 :com.palletops.awaze.client-builder/undef)
     (. bean11656 setInstanceProfileName (clojure.core/str v11658))))
   (clojure.core/let
    [v11658 (:path m11657 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11658 :com.palletops.awaze.client-builder/undef)
     (. bean11656 setPath (clojure.core/str v11658))))
   bean11656))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateUserRequest}
update-user-request
  [m11660]
  (clojure.core/let
   [bean11659
    (new
     com.amazonaws.services.identitymanagement.model.UpdateUserRequest)]
   (clojure.core/let
    [v11661
     (:user-name m11660 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11661 :com.palletops.awaze.client-builder/undef)
     (. bean11659 setUserName (clojure.core/str v11661))))
   (clojure.core/let
    [v11661
     (:new-path m11660 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11661 :com.palletops.awaze.client-builder/undef)
     (. bean11659 setNewPath (clojure.core/str v11661))))
   (clojure.core/let
    [v11661
     (:new-user-name m11660 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11661 :com.palletops.awaze.client-builder/undef)
     (. bean11659 setNewUserName (clojure.core/str v11661))))
   bean11659))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateUserRequest}
create-user-request
  [m11663]
  (clojure.core/let
   [bean11662
    (new
     com.amazonaws.services.identitymanagement.model.CreateUserRequest)]
   (clojure.core/let
    [v11664 (:path m11663 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11664 :com.palletops.awaze.client-builder/undef)
     (. bean11662 setPath (clojure.core/str v11664))))
   (clojure.core/let
    [v11664
     (:user-name m11663 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11664 :com.palletops.awaze.client-builder/undef)
     (. bean11662 setUserName (clojure.core/str v11664))))
   bean11662))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateRoleRequest}
create-role-request
  [m11666]
  (clojure.core/let
   [bean11665
    (new
     com.amazonaws.services.identitymanagement.model.CreateRoleRequest)]
   (clojure.core/let
    [v11667
     (:assume-role-policy-document
      m11666
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11667 :com.palletops.awaze.client-builder/undef)
     (.
      bean11665
      setAssumeRolePolicyDocument
      (clojure.core/str v11667))))
   (clojure.core/let
    [v11667 (:path m11666 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11667 :com.palletops.awaze.client-builder/undef)
     (. bean11665 setPath (clojure.core/str v11667))))
   (clojure.core/let
    [v11667
     (:role-name m11666 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11667 :com.palletops.awaze.client-builder/undef)
     (. bean11665 setRoleName (clojure.core/str v11667))))
   bean11665))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetUserPolicyRequest}
get-user-policy-request
  [m11669]
  (clojure.core/let
   [bean11668
    (new
     com.amazonaws.services.identitymanagement.model.GetUserPolicyRequest)]
   (clojure.core/let
    [v11670
     (:policy-name m11669 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11670 :com.palletops.awaze.client-builder/undef)
     (. bean11668 setPolicyName (clojure.core/str v11670))))
   (clojure.core/let
    [v11670
     (:user-name m11669 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11670 :com.palletops.awaze.client-builder/undef)
     (. bean11668 setUserName (clojure.core/str v11670))))
   bean11668))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListUsersRequest}
list-users-request
  [m11672]
  (clojure.core/let
   [bean11671
    (new
     com.amazonaws.services.identitymanagement.model.ListUsersRequest)]
   (clojure.core/let
    [v11673
     (:max-items m11672 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11673 :com.palletops.awaze.client-builder/undef)
     (. bean11671 setMaxItems (clojure.core/int v11673))))
   (clojure.core/let
    [v11673
     (:marker m11672 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11673 :com.palletops.awaze.client-builder/undef)
     (. bean11671 setMarker (clojure.core/str v11673))))
   (clojure.core/let
    [v11673
     (:path-prefix m11672 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11673 :com.palletops.awaze.client-builder/undef)
     (. bean11671 setPathPrefix (clojure.core/str v11673))))
   bean11671)))
