(ns
 com.palletops.awaze.storagegateway
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.storagegateway :as storagegateway]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :storagegateway
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.storagegateway.AWSStorageGatewayClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest}
describe-maintenance-start-time-request
  [m5460]
  (clojure.core/let
   [bean5459
    (new
     com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest)]
   (clojure.core/when-let
    [v5461 (:gateway-arn m5460)]
    (. bean5459 setGatewayARN (clojure.core/str v5461)))
   bean5459))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest}
update-bandwidth-rate-limit-request
  [m5463]
  (clojure.core/let
   [bean5462
    (new
     com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest)]
   (clojure.core/when-let
    [v5464 (:gateway-arn m5463)]
    (. bean5462 setGatewayARN (clojure.core/str v5464)))
   (clojure.core/when-let
    [v5464 (:average-upload-rate-limit-in-bits-per-sec m5463)]
    (.
     bean5462
     setAverageUploadRateLimitInBitsPerSec
     (clojure.core/long v5464)))
   (clojure.core/when-let
    [v5464 (:average-download-rate-limit-in-bits-per-sec m5463)]
    (.
     bean5462
     setAverageDownloadRateLimitInBitsPerSec
     (clojure.core/long v5464)))
   bean5462))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest}
describe-working-storage-request
  [m5466]
  (clojure.core/let
   [bean5465
    (new
     com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest)]
   (clojure.core/when-let
    [v5467 (:gateway-arn m5466)]
    (. bean5465 setGatewayARN (clojure.core/str v5467)))
   bean5465))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteTapeArchiveRequest}
delete-tape-archive-request
  [m5469]
  (clojure.core/let
   [bean5468
    (new
     com.amazonaws.services.storagegateway.model.DeleteTapeArchiveRequest)]
   (clojure.core/when-let
    [v5470 (:tape-arn m5469)]
    (. bean5468 setTapeARN (clojure.core/str v5470)))
   bean5468))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest}
delete-snapshot-schedule-request
  [m5472]
  (clojure.core/let
   [bean5471
    (new
     com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest)]
   (clojure.core/when-let
    [v5473 (:volume-arn m5472)]
    (. bean5471 setVolumeARN (clojure.core/str v5473)))
   bean5471))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DisableGatewayRequest}
disable-gateway-request
  [m5475]
  (clojure.core/let
   [bean5474
    (new
     com.amazonaws.services.storagegateway.model.DisableGatewayRequest)]
   (clojure.core/when-let
    [v5476 (:gateway-arn m5475)]
    (. bean5474 setGatewayARN (clojure.core/str v5476)))
   bean5474))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest}
describe-chap-credentials-request
  [m5478]
  (clojure.core/let
   [bean5477
    (new
     com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest)]
   (clojure.core/when-let
    [v5479 (:target-arn m5478)]
    (. bean5477 setTargetARN (clojure.core/str v5479)))
   bean5477))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest}
delete-bandwidth-rate-limit-request
  [m5481]
  (clojure.core/let
   [bean5480
    (new
     com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest)]
   (clojure.core/when-let
    [v5482 (:gateway-arn m5481)]
    (. bean5480 setGatewayARN (clojure.core/str v5482)))
   (clojure.core/when-let
    [v5482 (:bandwidth-type m5481)]
    (. bean5480 setBandwidthType (clojure.core/str v5482)))
   bean5480))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CancelArchivalRequest}
cancel-archival-request
  [m5484]
  (clojure.core/let
   [bean5483
    (new
     com.amazonaws.services.storagegateway.model.CancelArchivalRequest)]
   (clojure.core/when-let
    [v5485 (:gateway-arn m5484)]
    (. bean5483 setGatewayARN (clojure.core/str v5485)))
   (clojure.core/when-let
    [v5485 (:tape-arn m5484)]
    (. bean5483 setTapeARN (clojure.core/str v5485)))
   bean5483))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest}
create-cachedi-scsivolume-request
  [m5487]
  (clojure.core/let
   [bean5486
    (new
     com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest)]
   (clojure.core/when-let
    [v5488 (:snapshot-id m5487)]
    (. bean5486 setSnapshotId (clojure.core/str v5488)))
   (clojure.core/when-let
    [v5488 (:gateway-arn m5487)]
    (. bean5486 setGatewayARN (clojure.core/str v5488)))
   (clojure.core/when-let
    [v5488 (:target-name m5487)]
    (. bean5486 setTargetName (clojure.core/str v5488)))
   (clojure.core/when-let
    [v5488 (:network-interface-id m5487)]
    (. bean5486 setNetworkInterfaceId (clojure.core/str v5488)))
   (clojure.core/when-let
    [v5488 (:client-token m5487)]
    (. bean5486 setClientToken (clojure.core/str v5488)))
   (clojure.core/when-let
    [v5488 (:volume-size-in-bytes m5487)]
    (. bean5486 setVolumeSizeInBytes (clojure.core/long v5488)))
   bean5486))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest}
create-snapshot-from-volume-recovery-point-request
  [m5490]
  (clojure.core/let
   [bean5489
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest)]
   (clojure.core/when-let
    [v5491 (:volume-arn m5490)]
    (. bean5489 setVolumeARN (clojure.core/str v5491)))
   (clojure.core/when-let
    [v5491 (:snapshot-description m5490)]
    (. bean5489 setSnapshotDescription (clojure.core/str v5491)))
   bean5489))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest}
describe-storedi-scsivolumes-request
  [m5493]
  (clojure.core/let
   [bean5492
    (new
     com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest)]
   (clojure.core/when-let
    [v5494 (:volume-arns m5493)]
    (.
     bean5492
     setVolumeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5600] (clojure.core/str arg5600))
 v5494)))
   bean5492))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest}
describe-upload-buffer-request
  [m5496]
  (clojure.core/let
   [bean5495
    (new
     com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest)]
   (clojure.core/when-let
    [v5497 (:gateway-arn m5496)]
    (. bean5495 setGatewayARN (clojure.core/str v5497)))
   bean5495))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddUploadBufferRequest}
add-upload-buffer-request
  [m5499]
  (clojure.core/let
   [bean5498
    (new
     com.amazonaws.services.storagegateway.model.AddUploadBufferRequest)]
   (clojure.core/when-let
    [v5500 (:gateway-arn m5499)]
    (. bean5498 setGatewayARN (clojure.core/str v5500)))
   (clojure.core/when-let
    [v5500 (:disk-ids m5499)]
    (.
     bean5498
     setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5601] (clojure.core/str arg5601))
 v5500)))
   bean5498))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RetrieveTapeArchiveRequest}
retrieve-tape-archive-request
  [m5502]
  (clojure.core/let
   [bean5501
    (new
     com.amazonaws.services.storagegateway.model.RetrieveTapeArchiveRequest)]
   (clojure.core/when-let
    [v5503 (:gateway-arn m5502)]
    (. bean5501 setGatewayARN (clojure.core/str v5503)))
   (clojure.core/when-let
    [v5503 (:tape-arn m5502)]
    (. bean5501 setTapeARN (clojure.core/str v5503)))
   bean5501))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapesRequest}
describe-tapes-request
  [m5505]
  (clojure.core/let
   [bean5504
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapesRequest)]
   (clojure.core/when-let
    [v5506 (:marker m5505)]
    (. bean5504 setMarker (clojure.core/str v5506)))
   (clojure.core/when-let
    [v5506 (:gateway-arn m5505)]
    (. bean5504 setGatewayARN (clojure.core/str v5506)))
   (clojure.core/when-let
    [v5506 (:tape-arns m5505)]
    (.
     bean5504
     setTapeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5602] (clojure.core/str arg5602))
 v5506)))
   (clojure.core/when-let
    [v5506 (:limit m5505)]
    (. bean5504 setLimit (clojure.core/int v5506)))
   bean5504))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest}
add-working-storage-request
  [m5508]
  (clojure.core/let
   [bean5507
    (new
     com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest)]
   (clojure.core/when-let
    [v5509 (:gateway-arn m5508)]
    (. bean5507 setGatewayARN (clojure.core/str v5509)))
   (clojure.core/when-let
    [v5509 (:disk-ids m5508)]
    (.
     bean5507
     setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5603] (clojure.core/str arg5603))
 v5509)))
   bean5507))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.StartGatewayRequest}
start-gateway-request
  [m5511]
  (clojure.core/let
   [bean5510
    (new
     com.amazonaws.services.storagegateway.model.StartGatewayRequest)]
   (clojure.core/when-let
    [v5512 (:gateway-arn m5511)]
    (. bean5510 setGatewayARN (clojure.core/str v5512)))
   bean5510))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapeRecoveryPointsRequest}
describe-tape-recovery-points-request
  [m5514]
  (clojure.core/let
   [bean5513
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapeRecoveryPointsRequest)]
   (clojure.core/when-let
    [v5515 (:marker m5514)]
    (. bean5513 setMarker (clojure.core/str v5515)))
   (clojure.core/when-let
    [v5515 (:gateway-arn m5514)]
    (. bean5513 setGatewayARN (clojure.core/str v5515)))
   (clojure.core/when-let
    [v5515 (:limit m5514)]
    (. bean5513 setLimit (clojure.core/int v5515)))
   bean5513))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListLocalDisksRequest}
list-local-disks-request
  [m5517]
  (clojure.core/let
   [bean5516
    (new
     com.amazonaws.services.storagegateway.model.ListLocalDisksRequest)]
   (clojure.core/when-let
    [v5518 (:gateway-arn m5517)]
    (. bean5516 setGatewayARN (clojure.core/str v5518)))
   bean5516))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest}
delete-chap-credentials-request
  [m5520]
  (clojure.core/let
   [bean5519
    (new
     com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest)]
   (clojure.core/when-let
    [v5521 (:target-arn m5520)]
    (. bean5519 setTargetARN (clojure.core/str v5521)))
   (clojure.core/when-let
    [v5521 (:initiator-name m5520)]
    (. bean5519 setInitiatorName (clojure.core/str v5521)))
   bean5519))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest}
update-maintenance-start-time-request
  [m5523]
  (clojure.core/let
   [bean5522
    (new
     com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest)]
   (clojure.core/when-let
    [v5524 (:hour-of-day m5523)]
    (. bean5522 setHourOfDay (clojure.core/int v5524)))
   (clojure.core/when-let
    [v5524 (:minute-of-hour m5523)]
    (. bean5522 setMinuteOfHour (clojure.core/int v5524)))
   (clojure.core/when-let
    [v5524 (:gateway-arn m5523)]
    (. bean5522 setGatewayARN (clojure.core/str v5524)))
   (clojure.core/when-let
    [v5524 (:day-of-week m5523)]
    (. bean5522 setDayOfWeek (clojure.core/int v5524)))
   bean5522))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddCacheRequest}
add-cache-request
  [m5526]
  (clojure.core/let
   [bean5525
    (new com.amazonaws.services.storagegateway.model.AddCacheRequest)]
   (clojure.core/when-let
    [v5527 (:gateway-arn m5526)]
    (. bean5525 setGatewayARN (clojure.core/str v5527)))
   (clojure.core/when-let
    [v5527 (:disk-ids m5526)]
    (.
     bean5525
     setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5604] (clojure.core/str arg5604))
 v5527)))
   bean5525))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest}
describe-cachedi-scsivolumes-request
  [m5529]
  (clojure.core/let
   [bean5528
    (new
     com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest)]
   (clojure.core/when-let
    [v5530 (:volume-arns m5529)]
    (.
     bean5528
     setVolumeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5605] (clojure.core/str arg5605))
 v5530)))
   bean5528))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest}
describe-bandwidth-rate-limit-request
  [m5532]
  (clojure.core/let
   [bean5531
    (new
     com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest)]
   (clojure.core/when-let
    [v5533 (:gateway-arn m5532)]
    (. bean5531 setGatewayARN (clojure.core/str v5533)))
   bean5531))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumesRequest}
list-volumes-request
  [m5535]
  (clojure.core/let
   [bean5534
    (new
     com.amazonaws.services.storagegateway.model.ListVolumesRequest)]
   (clojure.core/when-let
    [v5536 (:marker m5535)]
    (. bean5534 setMarker (clojure.core/str v5536)))
   (clojure.core/when-let
    [v5536 (:gateway-arn m5535)]
    (. bean5534 setGatewayARN (clojure.core/str v5536)))
   (clojure.core/when-let
    [v5536 (:limit m5535)]
    (. bean5534 setLimit (clojure.core/int v5536)))
   bean5534))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateTapesRequest}
create-tapes-request
  [m5538]
  (clojure.core/let
   [bean5537
    (new
     com.amazonaws.services.storagegateway.model.CreateTapesRequest)]
   (clojure.core/when-let
    [v5539 (:gateway-arn m5538)]
    (. bean5537 setGatewayARN (clojure.core/str v5539)))
   (clojure.core/when-let
    [v5539 (:tape-size-in-bytes m5538)]
    (. bean5537 setTapeSizeInBytes (clojure.core/long v5539)))
   (clojure.core/when-let
    [v5539 (:client-token m5538)]
    (. bean5537 setClientToken (clojure.core/str v5539)))
   (clojure.core/when-let
    [v5539 (:num-tapes-to-create m5538)]
    (. bean5537 setNumTapesToCreate (clojure.core/int v5539)))
   (clojure.core/when-let
    [v5539 (:tape-barcode-prefix m5538)]
    (. bean5537 setTapeBarcodePrefix (clojure.core/str v5539)))
   bean5537))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ActivateGatewayRequest}
activate-gateway-request
  [m5541]
  (clojure.core/let
   [bean5540
    (new
     com.amazonaws.services.storagegateway.model.ActivateGatewayRequest)]
   (clojure.core/when-let
    [v5542 (:activation-key m5541)]
    (. bean5540 setActivationKey (clojure.core/str v5542)))
   (clojure.core/when-let
    [v5542 (:gateway-name m5541)]
    (. bean5540 setGatewayName (clojure.core/str v5542)))
   (clojure.core/when-let
    [v5542 (:gateway-timezone m5541)]
    (. bean5540 setGatewayTimezone (clojure.core/str v5542)))
   (clojure.core/when-let
    [v5542 (:gateway-region m5541)]
    (. bean5540 setGatewayRegion (clojure.core/str v5542)))
   (clojure.core/when-let
    [v5542 (:gateway-type m5541)]
    (. bean5540 setGatewayType (clojure.core/str v5542)))
   (clojure.core/when-let
    [v5542 (:tape-drive-type m5541)]
    (. bean5540 setTapeDriveType (clojure.core/str v5542)))
   (clojure.core/when-let
    [v5542 (:medium-changer-type m5541)]
    (. bean5540 setMediumChangerType (clojure.core/str v5542)))
   bean5540))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeCacheRequest}
describe-cache-request
  [m5544]
  (clojure.core/let
   [bean5543
    (new
     com.amazonaws.services.storagegateway.model.DescribeCacheRequest)]
   (clojure.core/when-let
    [v5545 (:gateway-arn m5544)]
    (. bean5543 setGatewayARN (clojure.core/str v5545)))
   bean5543))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest}
update-gateway-software-now-request
  [m5547]
  (clojure.core/let
   [bean5546
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest)]
   (clojure.core/when-let
    [v5548 (:gateway-arn m5547)]
    (. bean5546 setGatewayARN (clojure.core/str v5548)))
   bean5546))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest}
update-chap-credentials-request
  [m5550]
  (clojure.core/let
   [bean5549
    (new
     com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest)]
   (clojure.core/when-let
    [v5551 (:target-arn m5550)]
    (. bean5549 setTargetARN (clojure.core/str v5551)))
   (clojure.core/when-let
    [v5551 (:secret-to-authenticate-initiator m5550)]
    (.
     bean5549
     setSecretToAuthenticateInitiator
     (clojure.core/str v5551)))
   (clojure.core/when-let
    [v5551 (:initiator-name m5550)]
    (. bean5549 setInitiatorName (clojure.core/str v5551)))
   (clojure.core/when-let
    [v5551 (:secret-to-authenticate-target m5550)]
    (.
     bean5549
     setSecretToAuthenticateTarget
     (clojure.core/str v5551)))
   bean5549))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapeArchivesRequest}
describe-tape-archives-request
  [m5553]
  (clojure.core/let
   [bean5552
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapeArchivesRequest)]
   (clojure.core/when-let
    [v5554 (:marker m5553)]
    (. bean5552 setMarker (clojure.core/str v5554)))
   (clojure.core/when-let
    [v5554 (:tape-arns m5553)]
    (.
     bean5552
     setTapeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5606] (clojure.core/str arg5606))
 v5554)))
   (clojure.core/when-let
    [v5554 (:limit m5553)]
    (. bean5552 setLimit (clojure.core/int v5554)))
   bean5552))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteTapeRequest}
delete-tape-request
  [m5556]
  (clojure.core/let
   [bean5555
    (new
     com.amazonaws.services.storagegateway.model.DeleteTapeRequest)]
   (clojure.core/when-let
    [v5557 (:gateway-arn m5556)]
    (. bean5555 setGatewayARN (clojure.core/str v5557)))
   (clojure.core/when-let
    [v5557 (:tape-arn m5556)]
    (. bean5555 setTapeARN (clojure.core/str v5557)))
   bean5555))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RetrieveTapeRecoveryPointRequest}
retrieve-tape-recovery-point-request
  [m5559]
  (clojure.core/let
   [bean5558
    (new
     com.amazonaws.services.storagegateway.model.RetrieveTapeRecoveryPointRequest)]
   (clojure.core/when-let
    [v5560 (:gateway-arn m5559)]
    (. bean5558 setGatewayARN (clojure.core/str v5560)))
   (clojure.core/when-let
    [v5560 (:tape-arn m5559)]
    (. bean5558 setTapeARN (clojure.core/str v5560)))
   bean5558))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest}
create-storedi-scsivolume-request
  [m5562]
  (clojure.core/let
   [bean5561
    (new
     com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest)]
   (clojure.core/when-let
    [v5563 (:snapshot-id m5562)]
    (. bean5561 setSnapshotId (clojure.core/str v5563)))
   (clojure.core/when-let
    [v5563 (:gateway-arn m5562)]
    (. bean5561 setGatewayARN (clojure.core/str v5563)))
   (clojure.core/when-let
    [v5563 (:disk-id m5562)]
    (. bean5561 setDiskId (clojure.core/str v5563)))
   (clojure.core/when-let
    [v5563 (:preserve-existing-data m5562)]
    (. bean5561 setPreserveExistingData (clojure.core/boolean v5563)))
   (clojure.core/when-let
    [v5563 (:target-name m5562)]
    (. bean5561 setTargetName (clojure.core/str v5563)))
   (clojure.core/when-let
    [v5563 (:network-interface-id m5562)]
    (. bean5561 setNetworkInterfaceId (clojure.core/str v5563)))
   bean5561))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest}
update-gateway-information-request
  [m5565]
  (clojure.core/let
   [bean5564
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest)]
   (clojure.core/when-let
    [v5566 (:gateway-arn m5565)]
    (. bean5564 setGatewayARN (clojure.core/str v5566)))
   (clojure.core/when-let
    [v5566 (:gateway-name m5565)]
    (. bean5564 setGatewayName (clojure.core/str v5566)))
   (clojure.core/when-let
    [v5566 (:gateway-timezone m5565)]
    (. bean5564 setGatewayTimezone (clojure.core/str v5566)))
   bean5564))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CancelRetrievalRequest}
cancel-retrieval-request
  [m5568]
  (clojure.core/let
   [bean5567
    (new
     com.amazonaws.services.storagegateway.model.CancelRetrievalRequest)]
   (clojure.core/when-let
    [v5569 (:gateway-arn m5568)]
    (. bean5567 setGatewayARN (clojure.core/str v5569)))
   (clojure.core/when-let
    [v5569 (:tape-arn m5568)]
    (. bean5567 setTapeARN (clojure.core/str v5569)))
   bean5567))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest}
describe-gateway-information-request
  [m5571]
  (clojure.core/let
   [bean5570
    (new
     com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest)]
   (clojure.core/when-let
    [v5572 (:gateway-arn m5571)]
    (. bean5570 setGatewayARN (clojure.core/str v5572)))
   bean5570))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest}
shutdown-gateway-request
  [m5574]
  (clojure.core/let
   [bean5573
    (new
     com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest)]
   (clojure.core/when-let
    [v5575 (:gateway-arn m5574)]
    (. bean5573 setGatewayARN (clojure.core/str v5575)))
   bean5573))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest}
list-volume-recovery-points-request
  [m5577]
  (clojure.core/let
   [bean5576
    (new
     com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest)]
   (clojure.core/when-let
    [v5578 (:gateway-arn m5577)]
    (. bean5576 setGatewayARN (clojure.core/str v5578)))
   bean5576))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteGatewayRequest}
delete-gateway-request
  [m5580]
  (clojure.core/let
   [bean5579
    (new
     com.amazonaws.services.storagegateway.model.DeleteGatewayRequest)]
   (clojure.core/when-let
    [v5581 (:gateway-arn m5580)]
    (. bean5579 setGatewayARN (clojure.core/str v5581)))
   bean5579))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateSnapshotRequest}
create-snapshot-request
  [m5583]
  (clojure.core/let
   [bean5582
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotRequest)]
   (clojure.core/when-let
    [v5584 (:volume-arn m5583)]
    (. bean5582 setVolumeARN (clojure.core/str v5584)))
   (clojure.core/when-let
    [v5584 (:snapshot-description m5583)]
    (. bean5582 setSnapshotDescription (clojure.core/str v5584)))
   bean5582))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteVolumeRequest}
delete-volume-request
  [m5586]
  (clojure.core/let
   [bean5585
    (new
     com.amazonaws.services.storagegateway.model.DeleteVolumeRequest)]
   (clojure.core/when-let
    [v5587 (:volume-arn m5586)]
    (. bean5585 setVolumeARN (clojure.core/str v5587)))
   bean5585))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest}
describe-vtldevices-request
  [m5589]
  (clojure.core/let
   [bean5588
    (new
     com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest)]
   (clojure.core/when-let
    [v5590 (:marker m5589)]
    (. bean5588 setMarker (clojure.core/str v5590)))
   (clojure.core/when-let
    [v5590 (:gateway-arn m5589)]
    (. bean5588 setGatewayARN (clojure.core/str v5590)))
   (clojure.core/when-let
    [v5590 (:vtldevice-arns m5589)]
    (.
     bean5588
     setVTLDeviceARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5607] (clojure.core/str arg5607))
 v5590)))
   (clojure.core/when-let
    [v5590 (:limit m5589)]
    (. bean5588 setLimit (clojure.core/int v5590)))
   bean5588))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest}
update-snapshot-schedule-request
  [m5592]
  (clojure.core/let
   [bean5591
    (new
     com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest)]
   (clojure.core/when-let
    [v5593 (:description m5592)]
    (. bean5591 setDescription (clojure.core/str v5593)))
   (clojure.core/when-let
    [v5593 (:volume-arn m5592)]
    (. bean5591 setVolumeARN (clojure.core/str v5593)))
   (clojure.core/when-let
    [v5593 (:start-at m5592)]
    (. bean5591 setStartAt (clojure.core/int v5593)))
   (clojure.core/when-let
    [v5593 (:recurrence-in-hours m5592)]
    (. bean5591 setRecurrenceInHours (clojure.core/int v5593)))
   bean5591))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest}
describe-snapshot-schedule-request
  [m5595]
  (clojure.core/let
   [bean5594
    (new
     com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest)]
   (clojure.core/when-let
    [v5596 (:volume-arn m5595)]
    (. bean5594 setVolumeARN (clojure.core/str v5596)))
   bean5594))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListGatewaysRequest}
list-gateways-request
  [m5598]
  (clojure.core/let
   [bean5597
    (new
     com.amazonaws.services.storagegateway.model.ListGatewaysRequest)]
   (clojure.core/when-let
    [v5599 (:marker m5598)]
    (. bean5597 setMarker (clojure.core/str v5599)))
   (clojure.core/when-let
    [v5599 (:limit m5598)]
    (. bean5597 setLimit (clojure.core/int v5599)))
   bean5597))
 (clojure.core/defmulti
  storagegateway
  (clojure.core/fn
   storagegateway
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-maintenance-start-time
   [m5608]
   (clojure.core/let
    [credentials5609 (:credentials m5608) args5610 (:args m5608)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5611
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5609)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5611
       describeMaintenanceStartTime
       (storagegateway/describe-maintenance-start-time-request
        (clojure.core/nth args5610 0)))))))
  (clojure.core/defn
   describe-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeMaintenanceStartTime"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-maintenance-start-time,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeMaintenanceStartTime"}
   [credentials5613 & args5614]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5615
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5613)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5615
      describeMaintenanceStartTime
      (storagegateway/describe-maintenance-start-time-request
       (clojure.core/nth args5614 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-bandwidth-rate-limit
   [m5616]
   (clojure.core/let
    [credentials5617 (:credentials m5616) args5618 (:args m5616)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5619
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5617)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5619
       updateBandwidthRateLimit
       (storagegateway/update-bandwidth-rate-limit-request
        (clojure.core/nth args5618 0)))))))
  (clojure.core/defn
   update-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         average-upload-rate-limit-in-bits-per-sec
                         average-download-rate-limit-in-bits-per-sec]}]]),
    :doc "Generate map for updateBandwidthRateLimit"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-bandwidth-rate-limit,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         average-upload-rate-limit-in-bits-per-sec
                         average-download-rate-limit-in-bits-per-sec]}]]),
    :doc "Call updateBandwidthRateLimit"}
   [credentials5621 & args5622]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5623
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5621)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5623
      updateBandwidthRateLimit
      (storagegateway/update-bandwidth-rate-limit-request
       (clojure.core/nth args5622 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-working-storage
   [m5624]
   (clojure.core/let
    [credentials5625 (:credentials m5624) args5626 (:args m5624)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5627
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5625)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5627
       describeWorkingStorage
       (storagegateway/describe-working-storage-request
        (clojure.core/nth args5626 0)))))))
  (clojure.core/defn
   describe-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeWorkingStorage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-working-storage,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeWorkingStorage"}
   [credentials5629 & args5630]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5631
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5629)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5631
      describeWorkingStorage
      (storagegateway/describe-working-storage-request
       (clojure.core/nth args5630 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-tape-archive
   [m5632]
   (clojure.core/let
    [credentials5633 (:credentials m5632) args5634 (:args m5632)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5635
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5633)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5635
       deleteTapeArchive
       (storagegateway/delete-tape-archive-request
        (clojure.core/nth args5634 0)))))))
  (clojure.core/defn
   delete-tape-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn general-progress-listener]}]]),
    :doc "Generate map for deleteTapeArchive"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-tape-archive,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-tape-archive
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn general-progress-listener]}]]),
    :doc "Call deleteTapeArchive"}
   [credentials5637 & args5638]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5639
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5637)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5639
      deleteTapeArchive
      (storagegateway/delete-tape-archive-request
       (clojure.core/nth args5638 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-snapshot-schedule
   [m5640]
   (clojure.core/let
    [credentials5641 (:credentials m5640) args5642 (:args m5640)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5643
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5641)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5643
       deleteSnapshotSchedule
       (storagegateway/delete-snapshot-schedule-request
        (clojure.core/nth args5642 0)))))))
  (clojure.core/defn
   delete-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Generate map for deleteSnapshotSchedule"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-snapshot-schedule,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Call deleteSnapshotSchedule"}
   [credentials5645 & args5646]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5647
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5645)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5647
      deleteSnapshotSchedule
      (storagegateway/delete-snapshot-schedule-request
       (clojure.core/nth args5646 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :disable-gateway
   [m5648]
   (clojure.core/let
    [credentials5649 (:credentials m5648) args5650 (:args m5648)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5651
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5649)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5651
       disableGateway
       (storagegateway/disable-gateway-request
        (clojure.core/nth args5650 0)))))))
  (clojure.core/defn
   disable-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for disableGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :disable-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disable-gateway
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call disableGateway"}
   [credentials5653 & args5654]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5655
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5653)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5655
      disableGateway
      (storagegateway/disable-gateway-request
       (clojure.core/nth args5654 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-chap-credentials
   [m5656]
   (clojure.core/let
    [credentials5657 (:credentials m5656) args5658 (:args m5656)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5659
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5657)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5659
       describeChapCredentials
       (storagegateway/describe-chap-credentials-request
        (clojure.core/nth args5658 0)))))))
  (clojure.core/defn
   describe-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [target-arn general-progress-listener]}]]),
    :doc "Generate map for describeChapCredentials"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-chap-credentials,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [target-arn general-progress-listener]}]]),
    :doc "Call describeChapCredentials"}
   [credentials5661 & args5662]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5663
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5661)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5663
      describeChapCredentials
      (storagegateway/describe-chap-credentials-request
       (clojure.core/nth args5662 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-bandwidth-rate-limit
   [m5664]
   (clojure.core/let
    [credentials5665 (:credentials m5664) args5666 (:args m5664)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5667
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5665)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5667
       deleteBandwidthRateLimit
       (storagegateway/delete-bandwidth-rate-limit-request
        (clojure.core/nth args5666 0)))))))
  (clojure.core/defn
   delete-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         bandwidth-type]}]]),
    :doc "Generate map for deleteBandwidthRateLimit"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-bandwidth-rate-limit,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         bandwidth-type]}]]),
    :doc "Call deleteBandwidthRateLimit"}
   [credentials5669 & args5670]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5671
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5669)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5671
      deleteBandwidthRateLimit
      (storagegateway/delete-bandwidth-rate-limit-request
       (clojure.core/nth args5670 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :cancel-archival
   [m5672]
   (clojure.core/let
    [credentials5673 (:credentials m5672) args5674 (:args m5672)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5675
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5673)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5675
       cancelArchival
       (storagegateway/cancel-archival-request
        (clojure.core/nth args5674 0)))))))
  (clojure.core/defn
   cancel-archival-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for cancelArchival"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :cancel-archival,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-archival
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call cancelArchival"}
   [credentials5677 & args5678]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5679
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5677)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5679
      cancelArchival
      (storagegateway/cancel-archival-request
       (clojure.core/nth args5678 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-cachedi-scsivolume
   [m5680]
   (clojure.core/let
    [credentials5681 (:credentials m5680) args5682 (:args m5680)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5683
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5681)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5683
       createCachediSCSIVolume
       (storagegateway/create-cachedi-scsivolume-request
        (clojure.core/nth args5682 0)))))))
  (clojure.core/defn
   create-cachedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         target-name
                         snapshot-id
                         network-interface-id
                         gateway-arn
                         volume-size-in-bytes
                         client-token]}]]),
    :doc "Generate map for createCachediSCSIVolume"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-cachedi-scsivolume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cachedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         target-name
                         snapshot-id
                         network-interface-id
                         gateway-arn
                         volume-size-in-bytes
                         client-token]}]]),
    :doc "Call createCachediSCSIVolume"}
   [credentials5685 & args5686]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5687
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5685)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5687
      createCachediSCSIVolume
      (storagegateway/create-cachedi-scsivolume-request
       (clojure.core/nth args5686 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot-from-volume-recovery-point
   [m5688]
   (clojure.core/let
    [credentials5689 (:credentials m5688) args5690 (:args m5688)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5691
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5689)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5691
       createSnapshotFromVolumeRecoveryPoint
       (storagegateway/create-snapshot-from-volume-recovery-point-request
        (clojure.core/nth args5690 0)))))))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         general-progress-listener]}]]),
    :doc "Generate map for createSnapshotFromVolumeRecoveryPoint"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-snapshot-from-volume-recovery-point,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         general-progress-listener]}]]),
    :doc "Call createSnapshotFromVolumeRecoveryPoint"}
   [credentials5693 & args5694]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5695
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5693)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5695
      createSnapshotFromVolumeRecoveryPoint
      (storagegateway/create-snapshot-from-volume-recovery-point-request
       (clojure.core/nth args5694 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-storedi-scsivolumes
   [m5696]
   (clojure.core/let
    [credentials5697 (:credentials m5696) args5698 (:args m5696)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5699
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5697)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5699
       describeStorediSCSIVolumes
       (storagegateway/describe-storedi-scsivolumes-request
        (clojure.core/nth args5698 0)))))))
  (clojure.core/defn
   describe-storedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns general-progress-listener]}]]),
    :doc "Generate map for describeStorediSCSIVolumes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-storedi-scsivolumes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-storedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns general-progress-listener]}]]),
    :doc "Call describeStorediSCSIVolumes"}
   [credentials5701 & args5702]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5703
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5701)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5703
      describeStorediSCSIVolumes
      (storagegateway/describe-storedi-scsivolumes-request
       (clojure.core/nth args5702 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-upload-buffer
   [m5704]
   (clojure.core/let
    [credentials5705 (:credentials m5704) args5706 (:args m5704)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5707
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5705)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5707
       describeUploadBuffer
       (storagegateway/describe-upload-buffer-request
        (clojure.core/nth args5706 0)))))))
  (clojure.core/defn
   describe-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeUploadBuffer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-upload-buffer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeUploadBuffer"}
   [credentials5709 & args5710]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5711
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5709)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5711
      describeUploadBuffer
      (storagegateway/describe-upload-buffer-request
       (clojure.core/nth args5710 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-upload-buffer
   [m5712]
   (clojure.core/let
    [credentials5713 (:credentials m5712) args5714 (:args m5712)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5715
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5713)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5715
       addUploadBuffer
       (storagegateway/add-upload-buffer-request
        (clojure.core/nth args5714 0)))))))
  (clojure.core/defn
   add-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Generate map for addUploadBuffer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :add-upload-buffer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Call addUploadBuffer"}
   [credentials5717 & args5718]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5719
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5717)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5719
      addUploadBuffer
      (storagegateway/add-upload-buffer-request
       (clojure.core/nth args5718 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :retrieve-tape-archive
   [m5720]
   (clojure.core/let
    [credentials5721 (:credentials m5720) args5722 (:args m5720)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5723
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5721)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5723
       retrieveTapeArchive
       (storagegateway/retrieve-tape-archive-request
        (clojure.core/nth args5722 0)))))))
  (clojure.core/defn
   retrieve-tape-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for retrieveTapeArchive"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :retrieve-tape-archive,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   retrieve-tape-archive
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call retrieveTapeArchive"}
   [credentials5725 & args5726]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5727
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5725)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5727
      retrieveTapeArchive
      (storagegateway/retrieve-tape-archive-request
       (clojure.core/nth args5726 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tapes
   [m5728]
   (clojure.core/let
    [credentials5729 (:credentials m5728) args5730 (:args m5728)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5731
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5729)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5731
       describeTapes
       (storagegateway/describe-tapes-request
        (clojure.core/nth args5730 0)))))))
  (clojure.core/defn
   describe-tapes-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arns
                         marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for describeTapes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-tapes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-tapes
   {:arglists (quote
               [[credentials
                 {:keys [tape-arns
                         marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call describeTapes"}
   [credentials5733 & args5734]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5735
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5733)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5735
      describeTapes
      (storagegateway/describe-tapes-request
       (clojure.core/nth args5734 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-working-storage
   [m5736]
   (clojure.core/let
    [credentials5737 (:credentials m5736) args5738 (:args m5736)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5739
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5737)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5739
       addWorkingStorage
       (storagegateway/add-working-storage-request
        (clojure.core/nth args5738 0)))))))
  (clojure.core/defn
   add-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Generate map for addWorkingStorage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :add-working-storage,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Call addWorkingStorage"}
   [credentials5741 & args5742]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5743
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5741)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5743
      addWorkingStorage
      (storagegateway/add-working-storage-request
       (clojure.core/nth args5742 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :start-gateway
   [m5744]
   (clojure.core/let
    [credentials5745 (:credentials m5744) args5746 (:args m5744)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5747
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5745)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5747
       startGateway
       (storagegateway/start-gateway-request
        (clojure.core/nth args5746 0)))))))
  (clojure.core/defn
   start-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for startGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :start-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   start-gateway
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call startGateway"}
   [credentials5749 & args5750]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5751
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5749)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5751
      startGateway
      (storagegateway/start-gateway-request
       (clojure.core/nth args5750 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tape-recovery-points
   [m5752]
   (clojure.core/let
    [credentials5753 (:credentials m5752) args5754 (:args m5752)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5755
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5753)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5755
       describeTapeRecoveryPoints
       (storagegateway/describe-tape-recovery-points-request
        (clojure.core/nth args5754 0)))))))
  (clojure.core/defn
   describe-tape-recovery-points-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for describeTapeRecoveryPoints"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-tape-recovery-points,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-tape-recovery-points
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call describeTapeRecoveryPoints"}
   [credentials5757 & args5758]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5759
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5757)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5759
      describeTapeRecoveryPoints
      (storagegateway/describe-tape-recovery-points-request
       (clojure.core/nth args5758 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-local-disks
   [m5760]
   (clojure.core/let
    [credentials5761 (:credentials m5760) args5762 (:args m5760)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5763
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5761)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5763
       listLocalDisks
       (storagegateway/list-local-disks-request
        (clojure.core/nth args5762 0)))))))
  (clojure.core/defn
   list-local-disks-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for listLocalDisks"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-local-disks,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-local-disks
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call listLocalDisks"}
   [credentials5765 & args5766]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5767
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5765)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5767
      listLocalDisks
      (storagegateway/list-local-disks-request
       (clojure.core/nth args5766 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-chap-credentials
   [m5768]
   (clojure.core/let
    [credentials5769 (:credentials m5768) args5770 (:args m5768)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5771
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5769)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5771
       deleteChapCredentials
       (storagegateway/delete-chap-credentials-request
        (clojure.core/nth args5770 0)))))))
  (clojure.core/defn
   delete-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         initiator-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteChapCredentials"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-chap-credentials,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         initiator-name
                         general-progress-listener]}]]),
    :doc "Call deleteChapCredentials"}
   [credentials5773 & args5774]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5775
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5773)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5775
      deleteChapCredentials
      (storagegateway/delete-chap-credentials-request
       (clojure.core/nth args5774 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-maintenance-start-time
   [m5776]
   (clojure.core/let
    [credentials5777 (:credentials m5776) args5778 (:args m5776)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5779
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5777)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5779
       updateMaintenanceStartTime
       (storagegateway/update-maintenance-start-time-request
        (clojure.core/nth args5778 0)))))))
  (clojure.core/defn
   update-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [minute-of-hour
                         hour-of-day
                         general-progress-listener
                         gateway-arn
                         day-of-week]}]]),
    :doc "Generate map for updateMaintenanceStartTime"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-maintenance-start-time,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [minute-of-hour
                         hour-of-day
                         general-progress-listener
                         gateway-arn
                         day-of-week]}]]),
    :doc "Call updateMaintenanceStartTime"}
   [credentials5781 & args5782]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5783
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5781)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5783
      updateMaintenanceStartTime
      (storagegateway/update-maintenance-start-time-request
       (clojure.core/nth args5782 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-cache
   [m5784]
   (clojure.core/let
    [credentials5785 (:credentials m5784) args5786 (:args m5784)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5787
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5785)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5787
       addCache
       (storagegateway/add-cache-request
        (clojure.core/nth args5786 0)))))))
  (clojure.core/defn
   add-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Generate map for addCache"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :add-cache,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-cache
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Call addCache"}
   [credentials5789 & args5790]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5791
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5789)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5791
      addCache
      (storagegateway/add-cache-request (clojure.core/nth args5790 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cachedi-scsivolumes
   [m5792]
   (clojure.core/let
    [credentials5793 (:credentials m5792) args5794 (:args m5792)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5795
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5793)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5795
       describeCachediSCSIVolumes
       (storagegateway/describe-cachedi-scsivolumes-request
        (clojure.core/nth args5794 0)))))))
  (clojure.core/defn
   describe-cachedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns general-progress-listener]}]]),
    :doc "Generate map for describeCachediSCSIVolumes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-cachedi-scsivolumes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cachedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns general-progress-listener]}]]),
    :doc "Call describeCachediSCSIVolumes"}
   [credentials5797 & args5798]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5799
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5797)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5799
      describeCachediSCSIVolumes
      (storagegateway/describe-cachedi-scsivolumes-request
       (clojure.core/nth args5798 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-bandwidth-rate-limit
   [m5800]
   (clojure.core/let
    [credentials5801 (:credentials m5800) args5802 (:args m5800)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5803
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5801)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5803
       describeBandwidthRateLimit
       (storagegateway/describe-bandwidth-rate-limit-request
        (clojure.core/nth args5802 0)))))))
  (clojure.core/defn
   describe-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeBandwidthRateLimit"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-bandwidth-rate-limit,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeBandwidthRateLimit"}
   [credentials5805 & args5806]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5807
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5805)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5807
      describeBandwidthRateLimit
      (storagegateway/describe-bandwidth-rate-limit-request
       (clojure.core/nth args5806 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volumes
   [m5808]
   (clojure.core/let
    [credentials5809 (:credentials m5808) args5810 (:args m5808)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5811
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5809)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5811
       listVolumes
       (storagegateway/list-volumes-request
        (clojure.core/nth args5810 0)))))))
  (clojure.core/defn
   list-volumes-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for listVolumes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-volumes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-volumes
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call listVolumes"}
   [credentials5813 & args5814]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5815
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5813)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5815
      listVolumes
      (storagegateway/list-volumes-request
       (clojure.core/nth args5814 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-tapes
   [m5816]
   (clojure.core/let
    [credentials5817 (:credentials m5816) args5818 (:args m5816)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5819
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5817)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5819
       createTapes
       (storagegateway/create-tapes-request
        (clojure.core/nth args5818 0)))))))
  (clojure.core/defn
   create-tapes-map
   {:arglists (quote
               [[credentials
                 {:keys [num-tapes-to-create
                         tape-size-in-bytes
                         client-token
                         tape-barcode-prefix
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for createTapes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-tapes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-tapes
   {:arglists (quote
               [[credentials
                 {:keys [num-tapes-to-create
                         tape-size-in-bytes
                         client-token
                         tape-barcode-prefix
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call createTapes"}
   [credentials5821 & args5822]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5823
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5821)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5823
      createTapes
      (storagegateway/create-tapes-request
       (clojure.core/nth args5822 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :activate-gateway
   [m5824]
   (clojure.core/let
    [credentials5825 (:credentials m5824) args5826 (:args m5824)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5827
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5825)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5827
       activateGateway
       (storagegateway/activate-gateway-request
        (clojure.core/nth args5826 0)))))))
  (clojure.core/defn
   activate-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [activation-key
                         general-progress-listener
                         tape-drive-type
                         gateway-timezone
                         medium-changer-type
                         gateway-region
                         gateway-name
                         gateway-type]}]]),
    :doc "Generate map for activateGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :activate-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   activate-gateway
   {:arglists (quote
               [[credentials
                 {:keys [activation-key
                         general-progress-listener
                         tape-drive-type
                         gateway-timezone
                         medium-changer-type
                         gateway-region
                         gateway-name
                         gateway-type]}]]),
    :doc "Call activateGateway"}
   [credentials5829 & args5830]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5831
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5829)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5831
      activateGateway
      (storagegateway/activate-gateway-request
       (clojure.core/nth args5830 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cache
   [m5832]
   (clojure.core/let
    [credentials5833 (:credentials m5832) args5834 (:args m5832)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5835
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5833)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5835
       describeCache
       (storagegateway/describe-cache-request
        (clojure.core/nth args5834 0)))))))
  (clojure.core/defn
   describe-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeCache"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-cache,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cache
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeCache"}
   [credentials5837 & args5838]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5839
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5837)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5839
      describeCache
      (storagegateway/describe-cache-request
       (clojure.core/nth args5838 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-software-now
   [m5840]
   (clojure.core/let
    [credentials5841 (:credentials m5840) args5842 (:args m5840)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5843
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5841)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5843
       updateGatewaySoftwareNow
       (storagegateway/update-gateway-software-now-request
        (clojure.core/nth args5842 0)))))))
  (clojure.core/defn
   update-gateway-software-now-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for updateGatewaySoftwareNow"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-gateway-software-now,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-gateway-software-now
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call updateGatewaySoftwareNow"}
   [credentials5845 & args5846]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5847
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5845)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5847
      updateGatewaySoftwareNow
      (storagegateway/update-gateway-software-now-request
       (clojure.core/nth args5846 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-chap-credentials
   [m5848]
   (clojure.core/let
    [credentials5849 (:credentials m5848) args5850 (:args m5848)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5851
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5849)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5851
       updateChapCredentials
       (storagegateway/update-chap-credentials-request
        (clojure.core/nth args5850 0)))))))
  (clojure.core/defn
   update-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         secret-to-authenticate-target
                         secret-to-authenticate-initiator
                         initiator-name
                         general-progress-listener]}]]),
    :doc "Generate map for updateChapCredentials"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-chap-credentials,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         secret-to-authenticate-target
                         secret-to-authenticate-initiator
                         initiator-name
                         general-progress-listener]}]]),
    :doc "Call updateChapCredentials"}
   [credentials5853 & args5854]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5855
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5853)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5855
      updateChapCredentials
      (storagegateway/update-chap-credentials-request
       (clojure.core/nth args5854 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tape-archives
   [m5856]
   (clojure.core/let
    [credentials5857 (:credentials m5856) args5858 (:args m5856)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5859
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5857)]
     (clojure.core/case
      (clojure.core/count args5858)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5859
        describeTapeArchives))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5859
        describeTapeArchives
        (storagegateway/describe-tape-archives-request
         (clojure.core/nth args5858 0))))))))
  (clojure.core/defn
   describe-tape-archives-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [tape-arns
                         marker
                         limit
                         general-progress-listener]}]]),
    :doc "Generate map for describeTapeArchives, describeTapeArchives"}
   ([credentials__1651__auto__]
    {:args [],
     :client :storagegateway,
     :fn :describe-tape-archives,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-tape-archives,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-tape-archives
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [tape-arns
                         marker
                         limit
                         general-progress-listener]}]]),
    :doc "Call describeTapeArchives, describeTapeArchives"}
   [credentials5861 & args5862]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5863
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5861)]
    (clojure.core/case
     (clojure.core/count args5862)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5863
       describeTapeArchives))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5863
       describeTapeArchives
       (storagegateway/describe-tape-archives-request
        (clojure.core/nth args5862 0))))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-tape
   [m5864]
   (clojure.core/let
    [credentials5865 (:credentials m5864) args5866 (:args m5864)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5867
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5865)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5867
       deleteTape
       (storagegateway/delete-tape-request
        (clojure.core/nth args5866 0)))))))
  (clojure.core/defn
   delete-tape-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for deleteTape"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-tape,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-tape
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call deleteTape"}
   [credentials5869 & args5870]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5871
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5869)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5871
      deleteTape
      (storagegateway/delete-tape-request
       (clojure.core/nth args5870 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :retrieve-tape-recovery-point
   [m5872]
   (clojure.core/let
    [credentials5873 (:credentials m5872) args5874 (:args m5872)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5875
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5873)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5875
       retrieveTapeRecoveryPoint
       (storagegateway/retrieve-tape-recovery-point-request
        (clojure.core/nth args5874 0)))))))
  (clojure.core/defn
   retrieve-tape-recovery-point-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for retrieveTapeRecoveryPoint"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :retrieve-tape-recovery-point,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   retrieve-tape-recovery-point
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call retrieveTapeRecoveryPoint"}
   [credentials5877 & args5878]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5879
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5877)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5879
      retrieveTapeRecoveryPoint
      (storagegateway/retrieve-tape-recovery-point-request
       (clojure.core/nth args5878 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-storedi-scsivolume
   [m5880]
   (clojure.core/let
    [credentials5881 (:credentials m5880) args5882 (:args m5880)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5883
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5881)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5883
       createStorediSCSIVolume
       (storagegateway/create-storedi-scsivolume-request
        (clojure.core/nth args5882 0)))))))
  (clojure.core/defn
   create-storedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         target-name
                         snapshot-id
                         preserve-existing-data
                         network-interface-id
                         gateway-arn
                         disk-id]}]]),
    :doc "Generate map for createStorediSCSIVolume"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-storedi-scsivolume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-storedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         target-name
                         snapshot-id
                         preserve-existing-data
                         network-interface-id
                         gateway-arn
                         disk-id]}]]),
    :doc "Call createStorediSCSIVolume"}
   [credentials5885 & args5886]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5887
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5885)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5887
      createStorediSCSIVolume
      (storagegateway/create-storedi-scsivolume-request
       (clojure.core/nth args5886 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-information
   [m5888]
   (clojure.core/let
    [credentials5889 (:credentials m5888) args5890 (:args m5888)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5891
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5889)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5891
       updateGatewayInformation
       (storagegateway/update-gateway-information-request
        (clojure.core/nth args5890 0)))))))
  (clojure.core/defn
   update-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-timezone
                         gateway-name
                         gateway-arn]}]]),
    :doc "Generate map for updateGatewayInformation"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-gateway-information,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-timezone
                         gateway-name
                         gateway-arn]}]]),
    :doc "Call updateGatewayInformation"}
   [credentials5893 & args5894]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5895
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5893)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5895
      updateGatewayInformation
      (storagegateway/update-gateway-information-request
       (clojure.core/nth args5894 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :cancel-retrieval
   [m5896]
   (clojure.core/let
    [credentials5897 (:credentials m5896) args5898 (:args m5896)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5899
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5897)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5899
       cancelRetrieval
       (storagegateway/cancel-retrieval-request
        (clojure.core/nth args5898 0)))))))
  (clojure.core/defn
   cancel-retrieval-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for cancelRetrieval"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :cancel-retrieval,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-retrieval
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call cancelRetrieval"}
   [credentials5901 & args5902]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5903
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5901)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5903
      cancelRetrieval
      (storagegateway/cancel-retrieval-request
       (clojure.core/nth args5902 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-gateway-information
   [m5904]
   (clojure.core/let
    [credentials5905 (:credentials m5904) args5906 (:args m5904)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5907
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5905)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5907
       describeGatewayInformation
       (storagegateway/describe-gateway-information-request
        (clojure.core/nth args5906 0)))))))
  (clojure.core/defn
   describe-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeGatewayInformation"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-gateway-information,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeGatewayInformation"}
   [credentials5909 & args5910]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5911
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5909)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5911
      describeGatewayInformation
      (storagegateway/describe-gateway-information-request
       (clojure.core/nth args5910 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :shutdown-gateway
   [m5912]
   (clojure.core/let
    [credentials5913 (:credentials m5912) args5914 (:args m5912)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5915
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5913)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5915
       shutdownGateway
       (storagegateway/shutdown-gateway-request
        (clojure.core/nth args5914 0)))))))
  (clojure.core/defn
   shutdown-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for shutdownGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :shutdown-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   shutdown-gateway
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call shutdownGateway"}
   [credentials5917 & args5918]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5919
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5917)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5919
      shutdownGateway
      (storagegateway/shutdown-gateway-request
       (clojure.core/nth args5918 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volume-recovery-points
   [m5920]
   (clojure.core/let
    [credentials5921 (:credentials m5920) args5922 (:args m5920)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5923
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5921)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5923
       listVolumeRecoveryPoints
       (storagegateway/list-volume-recovery-points-request
        (clojure.core/nth args5922 0)))))))
  (clojure.core/defn
   list-volume-recovery-points-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for listVolumeRecoveryPoints"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-volume-recovery-points,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-volume-recovery-points
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call listVolumeRecoveryPoints"}
   [credentials5925 & args5926]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5927
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5925)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5927
      listVolumeRecoveryPoints
      (storagegateway/list-volume-recovery-points-request
       (clojure.core/nth args5926 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-gateway
   [m5928]
   (clojure.core/let
    [credentials5929 (:credentials m5928) args5930 (:args m5928)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5931
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5929)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5931
       deleteGateway
       (storagegateway/delete-gateway-request
        (clojure.core/nth args5930 0)))))))
  (clojure.core/defn
   delete-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for deleteGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-gateway
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call deleteGateway"}
   [credentials5933 & args5934]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5935
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5933)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5935
      deleteGateway
      (storagegateway/delete-gateway-request
       (clojure.core/nth args5934 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot
   [m5936]
   (clojure.core/let
    [credentials5937 (:credentials m5936) args5938 (:args m5936)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5939
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5937)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5939
       createSnapshot
       (storagegateway/create-snapshot-request
        (clojure.core/nth args5938 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         general-progress-listener]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         general-progress-listener]}]]),
    :doc "Call createSnapshot"}
   [credentials5941 & args5942]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5943
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5941)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5943
      createSnapshot
      (storagegateway/create-snapshot-request
       (clojure.core/nth args5942 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-volume
   [m5944]
   (clojure.core/let
    [credentials5945 (:credentials m5944) args5946 (:args m5944)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5947
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5945)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5947
       deleteVolume
       (storagegateway/delete-volume-request
        (clojure.core/nth args5946 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-volume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Call deleteVolume"}
   [credentials5949 & args5950]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5951
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5949)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5951
      deleteVolume
      (storagegateway/delete-volume-request
       (clojure.core/nth args5950 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-vtldevices
   [m5952]
   (clojure.core/let
    [credentials5953 (:credentials m5952) args5954 (:args m5952)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5955
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5953)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5955
       describeVTLDevices
       (storagegateway/describe-vtldevices-request
        (clojure.core/nth args5954 0)))))))
  (clojure.core/defn
   describe-vtldevices-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn
                         vtldevice-arns]}]]),
    :doc "Generate map for describeVTLDevices"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-vtldevices,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-vtldevices
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn
                         vtldevice-arns]}]]),
    :doc "Call describeVTLDevices"}
   [credentials5957 & args5958]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5959
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5957)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5959
      describeVTLDevices
      (storagegateway/describe-vtldevices-request
       (clojure.core/nth args5958 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-snapshot-schedule
   [m5960]
   (clojure.core/let
    [credentials5961 (:credentials m5960) args5962 (:args m5960)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5963
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5961)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5963
       updateSnapshotSchedule
       (storagegateway/update-snapshot-schedule-request
        (clojure.core/nth args5962 0)))))))
  (clojure.core/defn
   update-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         start-at
                         recurrence-in-hours
                         general-progress-listener
                         description]}]]),
    :doc "Generate map for updateSnapshotSchedule"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-snapshot-schedule,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         start-at
                         recurrence-in-hours
                         general-progress-listener
                         description]}]]),
    :doc "Call updateSnapshotSchedule"}
   [credentials5965 & args5966]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5967
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5965)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5967
      updateSnapshotSchedule
      (storagegateway/update-snapshot-schedule-request
       (clojure.core/nth args5966 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-snapshot-schedule
   [m5968]
   (clojure.core/let
    [credentials5969 (:credentials m5968) args5970 (:args m5968)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5971
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5969)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5971
       describeSnapshotSchedule
       (storagegateway/describe-snapshot-schedule-request
        (clojure.core/nth args5970 0)))))))
  (clojure.core/defn
   describe-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Generate map for describeSnapshotSchedule"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-snapshot-schedule,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Call describeSnapshotSchedule"}
   [credentials5973 & args5974]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5975
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5973)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5975
      describeSnapshotSchedule
      (storagegateway/describe-snapshot-schedule-request
       (clojure.core/nth args5974 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-gateways
   [m5976]
   (clojure.core/let
    [credentials5977 (:credentials m5976) args5978 (:args m5976)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5979
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5977)]
     (clojure.core/case
      (clojure.core/count args5978)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5979
        listGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5979
        listGateways
        (storagegateway/list-gateways-request
         (clojure.core/nth args5978 0))))))))
  (clojure.core/defn
   list-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker limit general-progress-listener]}]]),
    :doc "Generate map for listGateways, listGateways"}
   ([credentials__1651__auto__]
    {:args [],
     :client :storagegateway,
     :fn :list-gateways,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-gateways,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker limit general-progress-listener]}]]),
    :doc "Call listGateways, listGateways"}
   [credentials5981 & args5982]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5983
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5981)]
    (clojure.core/case
     (clojure.core/count args5982)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5983
       listGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5983
       listGateways
       (storagegateway/list-gateways-request
        (clojure.core/nth args5982 0)))))))))
