(ns
 com.palletops.awaze.sns
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sns :as sns]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sns
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.sns.AmazonSNSClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.MessageAttributeValue}
message-attribute-value
  [m3130]
  (clojure.core/let
   [bean3129
    (new com.amazonaws.services.sns.model.MessageAttributeValue)]
   (clojure.core/when-let
    [v3131 (:data-type m3130)]
    (. bean3129 setDataType (clojure.core/str v3131)))
   (clojure.core/when-let
    [v3131 (:binary-value m3130)]
    (. bean3129 setBinaryValue (clojure.core/identity v3131)))
   (clojure.core/when-let
    [v3131 (:string-value m3130)]
    (. bean3129 setStringValue (clojure.core/str v3131)))
   bean3129))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetEndpointAttributesRequest}
get-endpoint-attributes-request
  [m3133]
  (clojure.core/let
   [bean3132
    (new
     com.amazonaws.services.sns.model.GetEndpointAttributesRequest)]
   (clojure.core/when-let
    [v3134 (:endpoint-arn m3133)]
    (. bean3132 setEndpointArn (clojure.core/str v3134)))
   bean3132))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest}
get-platform-application-attributes-request
  [m3136]
  (clojure.core/let
   [bean3135
    (new
     com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest)]
   (clojure.core/when-let
    [v3137 (:platform-application-arn m3136)]
    (. bean3135 setPlatformApplicationArn (clojure.core/str v3137)))
   bean3135))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetTopicAttributesRequest}
set-topic-attributes-request
  [m3139]
  (clojure.core/let
   [bean3138
    (new com.amazonaws.services.sns.model.SetTopicAttributesRequest)]
   (clojure.core/when-let
    [v3140 (:topic-arn m3139)]
    (. bean3138 setTopicArn (clojure.core/str v3140)))
   (clojure.core/when-let
    [v3140 (:attribute-name m3139)]
    (. bean3138 setAttributeName (clojure.core/str v3140)))
   (clojure.core/when-let
    [v3140 (:attribute-value m3139)]
    (. bean3138 setAttributeValue (clojure.core/str v3140)))
   bean3138))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.AddPermissionRequest}
add-permission-request
  [m3142]
  (clojure.core/let
   [bean3141
    (new com.amazonaws.services.sns.model.AddPermissionRequest)]
   (clojure.core/when-let
    [v3143 (:topic-arn m3142)]
    (. bean3141 setTopicArn (clojure.core/str v3143)))
   (clojure.core/when-let
    [v3143 (:label m3142)]
    (. bean3141 setLabel (clojure.core/str v3143)))
   (clojure.core/when-let
    [v3143 (:awsaccount-ids m3142)]
    (.
     bean3141
     setAWSAccountIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3207] (clojure.core/str arg3207))
 v3143)))
   (clojure.core/when-let
    [v3143 (:action-names m3142)]
    (.
     bean3141
     setActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3208] (clojure.core/str arg3208))
 v3143)))
   bean3141))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
get-subscription-attributes-request
  [m3145]
  (clojure.core/let
   [bean3144
    (new
     com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest)]
   (clojure.core/when-let
    [v3146 (:subscription-arn m3145)]
    (. bean3144 setSubscriptionArn (clojure.core/str v3146)))
   bean3144))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ConfirmSubscriptionRequest}
confirm-subscription-request
  [m3148]
  (clojure.core/let
   [bean3147
    (new com.amazonaws.services.sns.model.ConfirmSubscriptionRequest)]
   (clojure.core/when-let
    [v3149 (:topic-arn m3148)]
    (. bean3147 setTopicArn (clojure.core/str v3149)))
   (clojure.core/when-let
    [v3149 (:token m3148)]
    (. bean3147 setToken (clojure.core/str v3149)))
   (clojure.core/when-let
    [v3149 (:authenticate-on-unsubscribe m3148)]
    (. bean3147 setAuthenticateOnUnsubscribe (clojure.core/str v3149)))
   bean3147))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
delete-topic-request
  [m3151]
  (clojure.core/let
   [bean3150
    (new com.amazonaws.services.sns.model.DeleteTopicRequest)]
   (clojure.core/when-let
    [v3152 (:topic-arn m3151)]
    (. bean3150 setTopicArn (clojure.core/str v3152)))
   bean3150))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.PublishRequest}
publish-request
  [m3154]
  (clojure.core/let
   [bean3153 (new com.amazonaws.services.sns.model.PublishRequest)]
   (clojure.core/when-let
    [v3155 (:message m3154)]
    (. bean3153 setMessage (clojure.core/str v3155)))
   (clojure.core/when-let
    [v3155 (:topic-arn m3154)]
    (. bean3153 setTopicArn (clojure.core/str v3155)))
   (clojure.core/when-let
    [v3155 (:target-arn m3154)]
    (. bean3153 setTargetArn (clojure.core/str v3155)))
   (clojure.core/when-let
    [v3155 (:message-structure m3154)]
    (. bean3153 setMessageStructure (clojure.core/str v3155)))
   (clojure.core/when-let
    [v3155 (:message-attributes m3154)]
    (.
     bean3153
     setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg3209] (clojure.core/str arg3209))
  (clojure.core/keys v3155))
 (clojure.core/map
  (clojure.core/fn [arg3209] (sns/message-attribute-value arg3209))
  (clojure.core/vals v3155)))))
   (clojure.core/when-let
    [v3155 (:subject m3154)]
    (. bean3153 setSubject (clojure.core/str v3155)))
   bean3153))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
list-topics-request
  [m3157]
  (clojure.core/let
   [bean3156 (new com.amazonaws.services.sns.model.ListTopicsRequest)]
   (clojure.core/when-let
    [v3158 (:next-token m3157)]
    (. bean3156 setNextToken (clojure.core/str v3158)))
   bean3156))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
list-subscriptions-by-topic-request
  [m3160]
  (clojure.core/let
   [bean3159
    (new
     com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest)]
   (clojure.core/when-let
    [v3161 (:next-token m3160)]
    (. bean3159 setNextToken (clojure.core/str v3161)))
   (clojure.core/when-let
    [v3161 (:topic-arn m3160)]
    (. bean3159 setTopicArn (clojure.core/str v3161)))
   bean3159))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeletePlatformApplicationRequest}
delete-platform-application-request
  [m3163]
  (clojure.core/let
   [bean3162
    (new
     com.amazonaws.services.sns.model.DeletePlatformApplicationRequest)]
   (clojure.core/when-let
    [v3164 (:platform-application-arn m3163)]
    (. bean3162 setPlatformApplicationArn (clojure.core/str v3164)))
   bean3162))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest}
list-endpoints-by-platform-application-request
  [m3166]
  (clojure.core/let
   [bean3165
    (new
     com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest)]
   (clojure.core/when-let
    [v3167 (:next-token m3166)]
    (. bean3165 setNextToken (clojure.core/str v3167)))
   (clojure.core/when-let
    [v3167 (:platform-application-arn m3166)]
    (. bean3165 setPlatformApplicationArn (clojure.core/str v3167)))
   bean3165))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
unsubscribe-request
  [m3169]
  (clojure.core/let
   [bean3168
    (new com.amazonaws.services.sns.model.UnsubscribeRequest)]
   (clojure.core/when-let
    [v3170 (:subscription-arn m3169)]
    (. bean3168 setSubscriptionArn (clojure.core/str v3170)))
   bean3168))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest}
set-subscription-attributes-request
  [m3172]
  (clojure.core/let
   [bean3171
    (new
     com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest)]
   (clojure.core/when-let
    [v3173 (:attribute-name m3172)]
    (. bean3171 setAttributeName (clojure.core/str v3173)))
   (clojure.core/when-let
    [v3173 (:attribute-value m3172)]
    (. bean3171 setAttributeValue (clojure.core/str v3173)))
   (clojure.core/when-let
    [v3173 (:subscription-arn m3172)]
    (. bean3171 setSubscriptionArn (clojure.core/str v3173)))
   bean3171))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
list-subscriptions-request
  [m3175]
  (clojure.core/let
   [bean3174
    (new com.amazonaws.services.sns.model.ListSubscriptionsRequest)]
   (clojure.core/when-let
    [v3176 (:next-token m3175)]
    (. bean3174 setNextToken (clojure.core/str v3176)))
   bean3174))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
create-topic-request
  [m3178]
  (clojure.core/let
   [bean3177
    (new com.amazonaws.services.sns.model.CreateTopicRequest)]
   (clojure.core/when-let
    [v3179 (:name m3178)]
    (. bean3177 setName (clojure.core/str v3179)))
   bean3177))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreatePlatformEndpointRequest}
create-platform-endpoint-request
  [m3181]
  (clojure.core/let
   [bean3180
    (new
     com.amazonaws.services.sns.model.CreatePlatformEndpointRequest)]
   (clojure.core/when-let
    [v3182 (:token m3181)]
    (. bean3180 setToken (clojure.core/str v3182)))
   (clojure.core/when-let
    [v3182 (:platform-application-arn m3181)]
    (. bean3180 setPlatformApplicationArn (clojure.core/str v3182)))
   (clojure.core/when-let
    [v3182 (:custom-user-data m3181)]
    (. bean3180 setCustomUserData (clojure.core/str v3182)))
   (clojure.core/when-let
    [v3182 (:attributes m3181)]
    (.
     bean3180
     setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg3210] (clojure.core/str arg3210))
  (clojure.core/keys v3182))
 (clojure.core/map
  (clojure.core/fn [arg3210] (clojure.core/str arg3210))
  (clojure.core/vals v3182)))))
   bean3180))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.RemovePermissionRequest}
remove-permission-request
  [m3184]
  (clojure.core/let
   [bean3183
    (new com.amazonaws.services.sns.model.RemovePermissionRequest)]
   (clojure.core/when-let
    [v3185 (:topic-arn m3184)]
    (. bean3183 setTopicArn (clojure.core/str v3185)))
   (clojure.core/when-let
    [v3185 (:label m3184)]
    (. bean3183 setLabel (clojure.core/str v3185)))
   bean3183))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
get-topic-attributes-request
  [m3187]
  (clojure.core/let
   [bean3186
    (new com.amazonaws.services.sns.model.GetTopicAttributesRequest)]
   (clojure.core/when-let
    [v3188 (:topic-arn m3187)]
    (. bean3186 setTopicArn (clojure.core/str v3188)))
   bean3186))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SubscribeRequest}
subscribe-request
  [m3190]
  (clojure.core/let
   [bean3189 (new com.amazonaws.services.sns.model.SubscribeRequest)]
   (clojure.core/when-let
    [v3191 (:endpoint m3190)]
    (. bean3189 setEndpoint (clojure.core/str v3191)))
   (clojure.core/when-let
    [v3191 (:protocol m3190)]
    (. bean3189 setProtocol (clojure.core/str v3191)))
   (clojure.core/when-let
    [v3191 (:topic-arn m3190)]
    (. bean3189 setTopicArn (clojure.core/str v3191)))
   bean3189))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeleteEndpointRequest}
delete-endpoint-request
  [m3193]
  (clojure.core/let
   [bean3192
    (new com.amazonaws.services.sns.model.DeleteEndpointRequest)]
   (clojure.core/when-let
    [v3194 (:endpoint-arn m3193)]
    (. bean3192 setEndpointArn (clojure.core/str v3194)))
   bean3192))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListPlatformApplicationsRequest}
list-platform-applications-request
  [m3196]
  (clojure.core/let
   [bean3195
    (new
     com.amazonaws.services.sns.model.ListPlatformApplicationsRequest)]
   (clojure.core/when-let
    [v3197 (:next-token m3196)]
    (. bean3195 setNextToken (clojure.core/str v3197)))
   bean3195))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest}
set-platform-application-attributes-request
  [m3199]
  (clojure.core/let
   [bean3198
    (new
     com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest)]
   (clojure.core/when-let
    [v3200 (:platform-application-arn m3199)]
    (. bean3198 setPlatformApplicationArn (clojure.core/str v3200)))
   (clojure.core/when-let
    [v3200 (:attributes m3199)]
    (.
     bean3198
     setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg3211] (clojure.core/str arg3211))
  (clojure.core/keys v3200))
 (clojure.core/map
  (clojure.core/fn [arg3211] (clojure.core/str arg3211))
  (clojure.core/vals v3200)))))
   bean3198))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreatePlatformApplicationRequest}
create-platform-application-request
  [m3202]
  (clojure.core/let
   [bean3201
    (new
     com.amazonaws.services.sns.model.CreatePlatformApplicationRequest)]
   (clojure.core/when-let
    [v3203 (:name m3202)]
    (. bean3201 setName (clojure.core/str v3203)))
   (clojure.core/when-let
    [v3203 (:platform m3202)]
    (. bean3201 setPlatform (clojure.core/str v3203)))
   (clojure.core/when-let
    [v3203 (:attributes m3202)]
    (.
     bean3201
     setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg3212] (clojure.core/str arg3212))
  (clojure.core/keys v3203))
 (clojure.core/map
  (clojure.core/fn [arg3212] (clojure.core/str arg3212))
  (clojure.core/vals v3203)))))
   bean3201))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetEndpointAttributesRequest}
set-endpoint-attributes-request
  [m3205]
  (clojure.core/let
   [bean3204
    (new
     com.amazonaws.services.sns.model.SetEndpointAttributesRequest)]
   (clojure.core/when-let
    [v3206 (:endpoint-arn m3205)]
    (. bean3204 setEndpointArn (clojure.core/str v3206)))
   (clojure.core/when-let
    [v3206 (:attributes m3205)]
    (.
     bean3204
     setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg3213] (clojure.core/str arg3213))
  (clojure.core/keys v3206))
 (clojure.core/map
  (clojure.core/fn [arg3213] (clojure.core/str arg3213))
  (clojure.core/vals v3206)))))
   bean3204))
 (clojure.core/defmulti
  sns
  (clojure.core/fn sns [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   sns
   :get-endpoint-attributes
   [m3214]
   (clojure.core/let
    [credentials3215 (:credentials m3214) args3216 (:args m3214)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3217
      (com.palletops.awaze.common/aws-client :sns credentials3215)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3217
       getEndpointAttributes
       (sns/get-endpoint-attributes-request
        (clojure.core/nth args3216 0)))))))
  (clojure.core/defn
   get-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener endpoint-arn]}]]),
    :doc "Generate map for getEndpointAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-endpoint-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener endpoint-arn]}]]),
    :doc "Call getEndpointAttributes"}
   [credentials3219 & args3220]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3221
     (com.palletops.awaze.common/aws-client :sns credentials3219)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3221
      getEndpointAttributes
      (sns/get-endpoint-attributes-request
       (clojure.core/nth args3220 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-platform-application-attributes
   [m3222]
   (clojure.core/let
    [credentials3223 (:credentials m3222) args3224 (:args m3222)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3225
      (com.palletops.awaze.common/aws-client :sns credentials3223)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3225
       getPlatformApplicationAttributes
       (sns/get-platform-application-attributes-request
        (clojure.core/nth args3224 0)))))))
  (clojure.core/defn
   get-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener]}]]),
    :doc "Generate map for getPlatformApplicationAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-platform-application-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener]}]]),
    :doc "Call getPlatformApplicationAttributes"}
   [credentials3227 & args3228]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3229
     (com.palletops.awaze.common/aws-client :sns credentials3227)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3229
      getPlatformApplicationAttributes
      (sns/get-platform-application-attributes-request
       (clojure.core/nth args3228 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-topic-attributes
   [m3230]
   (clojure.core/let
    [credentials3231 (:credentials m3230) args3232 (:args m3230)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3233
      (com.palletops.awaze.common/aws-client :sns credentials3231)]
     (clojure.core/case
      (clojure.core/count args3232)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3233
        setTopicAttributes
        (sns/set-topic-attributes-request
         (clojure.core/nth args3232 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3233
        setTopicAttributes
        (clojure.core/str (clojure.core/nth args3232 0))
        (clojure.core/str (clojure.core/nth args3232 1))
        (clojure.core/str (clojure.core/nth args3232 2))))))))
  (clojure.core/defn
   set-topic-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         general-progress-listener
                         attribute-value
                         attribute-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for setTopicAttributes, setTopicAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-topic-attributes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :sns,
     :fn :set-topic-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-topic-attributes
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         general-progress-listener
                         attribute-value
                         attribute-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call setTopicAttributes, setTopicAttributes"}
   [credentials3235 & args3236]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3237
     (com.palletops.awaze.common/aws-client :sns credentials3235)]
    (clojure.core/case
     (clojure.core/count args3236)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3237
       setTopicAttributes
       (sns/set-topic-attributes-request
        (clojure.core/nth args3236 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3237
       setTopicAttributes
       (clojure.core/str (clojure.core/nth args3236 0))
       (clojure.core/str (clojure.core/nth args3236 1))
       (clojure.core/str (clojure.core/nth args3236 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :add-permission
   [m3238]
   (clojure.core/let
    [credentials3239 (:credentials m3238) args3240 (:args m3238)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3241
      (com.palletops.awaze.common/aws-client :sns credentials3239)]
     (clojure.core/case
      (clojure.core/count args3240)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3241
        addPermission
        (sns/add-permission-request (clojure.core/nth args3240 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3241
        addPermission
        (clojure.core/str (clojure.core/nth args3240 0))
        (clojure.core/str (clojure.core/nth args3240 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg3254] (clojure.core/str arg3254))
 (clojure.core/nth args3240 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg3255] (clojure.core/str arg3255))
 (clojure.core/nth args3240 3))))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         label
                         general-progress-listener
                         action-names
                         awsaccount-ids]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Generate map for addPermission, addPermission"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :add-permission,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c d]
    {:args [a b c d],
     :client :sns,
     :fn :add-permission,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         label
                         general-progress-listener
                         action-names
                         awsaccount-ids]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Call addPermission, addPermission"}
   [credentials3243 & args3244]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3245
     (com.palletops.awaze.common/aws-client :sns credentials3243)]
    (clojure.core/case
     (clojure.core/count args3244)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3245
       addPermission
       (sns/add-permission-request (clojure.core/nth args3244 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3245
       addPermission
       (clojure.core/str (clojure.core/nth args3244 0))
       (clojure.core/str (clojure.core/nth args3244 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg3256] (clojure.core/str arg3256))
 (clojure.core/nth args3244 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg3257] (clojure.core/str arg3257))
 (clojure.core/nth args3244 3))))))))
 (do
  (clojure.core/defmethod
   sns
   :get-subscription-attributes
   [m3246]
   (clojure.core/let
    [credentials3247 (:credentials m3246) args3248 (:args m3246)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3249
      (com.palletops.awaze.common/aws-client :sns credentials3247)]
     (clojure.core/case
      (clojure.core/count args3248)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args3248 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3249
           getSubscriptionAttributes
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest
               (clojure.core/nth args3248 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3249
               getSubscriptionAttributes
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getSubscriptionAttributes")
                {:args args3248}))))))))))))))
  (clojure.core/defn
   get-subscription-attributes-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [subscription-arn general-progress-listener]}]]),
    :doc "Generate map for getSubscriptionAttributes, getSubscriptionAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-subscription-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-subscription-attributes
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [subscription-arn general-progress-listener]}]]),
    :doc "Call getSubscriptionAttributes, getSubscriptionAttributes"}
   [credentials3251 & args3252]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3253
     (com.palletops.awaze.common/aws-client :sns credentials3251)]
    (clojure.core/case
     (clojure.core/count args3252)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args3252 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3253
          getSubscriptionAttributes
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest
              (clojure.core/nth args3252 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3253
              getSubscriptionAttributes
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getSubscriptionAttributes")
               {:args args3252}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :confirm-subscription
   [m3258]
   (clojure.core/let
    [credentials3259 (:credentials m3258) args3260 (:args m3258)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3261
      (com.palletops.awaze.common/aws-client :sns credentials3259)]
     (clojure.core/case
      (clojure.core/count args3260)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3261
        confirmSubscription
        (clojure.core/str (clojure.core/nth args3260 0))
        (clojure.core/str (clojure.core/nth args3260 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3261
        confirmSubscription
        (sns/confirm-subscription-request
         (clojure.core/nth args3260 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3261
        confirmSubscription
        (clojure.core/str (clojure.core/nth args3260 0))
        (clojure.core/str (clojure.core/nth args3260 1))
        (clojure.core/str (clojure.core/nth args3260 2))))))))
  (clojure.core/defn
   confirm-subscription-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn
                         token
                         general-progress-listener
                         authenticate-on-unsubscribe]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for confirmSubscription, confirmSubscription, confirmSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :confirm-subscription,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sns,
     :fn :confirm-subscription,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :sns,
     :fn :confirm-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   confirm-subscription
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn
                         token
                         general-progress-listener
                         authenticate-on-unsubscribe]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call confirmSubscription, confirmSubscription, confirmSubscription"}
   [credentials3263 & args3264]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3265
     (com.palletops.awaze.common/aws-client :sns credentials3263)]
    (clojure.core/case
     (clojure.core/count args3264)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3265
       confirmSubscription
       (clojure.core/str (clojure.core/nth args3264 0))
       (clojure.core/str (clojure.core/nth args3264 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3265
       confirmSubscription
       (sns/confirm-subscription-request
        (clojure.core/nth args3264 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3265
       confirmSubscription
       (clojure.core/str (clojure.core/nth args3264 0))
       (clojure.core/str (clojure.core/nth args3264 1))
       (clojure.core/str (clojure.core/nth args3264 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-topic
   [m3266]
   (clojure.core/let
    [credentials3267 (:credentials m3266) args3268 (:args m3266)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3269
      (com.palletops.awaze.common/aws-client :sns credentials3267)]
     (clojure.core/case
      (clojure.core/count args3268)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args3268 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3269
           deleteTopic
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.DeleteTopicRequest
               (clojure.core/nth args3268 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3269
               deleteTopic
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteTopic")
                {:args args3268}))))))))))))))
  (clojure.core/defn
   delete-topic-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [topic-arn general-progress-listener]}]]),
    :doc "Generate map for deleteTopic, deleteTopic"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :delete-topic,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-topic
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [topic-arn general-progress-listener]}]]),
    :doc "Call deleteTopic, deleteTopic"}
   [credentials3271 & args3272]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3273
     (com.palletops.awaze.common/aws-client :sns credentials3271)]
    (clojure.core/case
     (clojure.core/count args3272)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args3272 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3273
          deleteTopic
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.DeleteTopicRequest
              (clojure.core/nth args3272 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3273
              deleteTopic
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteTopic")
               {:args args3272}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :publish
   [m3274]
   (clojure.core/let
    [credentials3275 (:credentials m3274) args3276 (:args m3274)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3277
      (com.palletops.awaze.common/aws-client :sns credentials3275)]
     (clojure.core/case
      (clojure.core/count args3276)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3277
        publish
        (sns/publish-request (clojure.core/nth args3276 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3277
        publish
        (clojure.core/str (clojure.core/nth args3276 0))
        (clojure.core/str (clojure.core/nth args3276 1))
        (clojure.core/str (clojure.core/nth args3276 2))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3277
        publish
        (clojure.core/str (clojure.core/nth args3276 0))
        (clojure.core/str (clojure.core/nth args3276 1))))))))
  (clojure.core/defn
   publish-map
   {:arglists (quote
               [[credentials
                 {:keys [subject
                         message-structure
                         general-progress-listener
                         message-attributes
                         topic-arn
                         message
                         target-arn]}]
                [credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Generate map for publish, publish, publish"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :publish,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sns,
     :fn :publish,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :sns,
     :fn :publish,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   publish
   {:arglists (quote
               [[credentials
                 {:keys [subject
                         message-structure
                         general-progress-listener
                         message-attributes
                         topic-arn
                         message
                         target-arn]}]
                [credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Call publish, publish, publish"}
   [credentials3279 & args3280]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3281
     (com.palletops.awaze.common/aws-client :sns credentials3279)]
    (clojure.core/case
     (clojure.core/count args3280)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3281
       publish
       (sns/publish-request (clojure.core/nth args3280 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3281
       publish
       (clojure.core/str (clojure.core/nth args3280 0))
       (clojure.core/str (clojure.core/nth args3280 1))
       (clojure.core/str (clojure.core/nth args3280 2))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3281
       publish
       (clojure.core/str (clojure.core/nth args3280 0))
       (clojure.core/str (clojure.core/nth args3280 1))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-topics
   [m3282]
   (clojure.core/let
    [credentials3283 (:credentials m3282) args3284 (:args m3282)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3285
      (com.palletops.awaze.common/aws-client :sns credentials3283)]
     (clojure.core/case
      (clojure.core/count args3284)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args3284 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3285
           listTopics
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.ListTopicsRequest
               (clojure.core/nth args3284 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3285
               listTopics
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listTopics")
                {:args args3284}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3285
        listTopics))))))
  (clojure.core/defn
   list-topics-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [next-token general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listTopics, listTopics, listTopics"}
   ([credentials__1651__auto__]
    {:args [],
     :client :sns,
     :fn :list-topics,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-topics,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-topics
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [next-token general-progress-listener]}]
                [credentials]]),
    :doc "Call listTopics, listTopics, listTopics"}
   [credentials3287 & args3288]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3289
     (com.palletops.awaze.common/aws-client :sns credentials3287)]
    (clojure.core/case
     (clojure.core/count args3288)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args3288 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3289
          listTopics
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.ListTopicsRequest
              (clojure.core/nth args3288 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3289
              listTopics
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listTopics")
               {:args args3288}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3289
       listTopics))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions-by-topic
   [m3290]
   (clojure.core/let
    [credentials3291 (:credentials m3290) args3292 (:args m3290)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3293
      (com.palletops.awaze.common/aws-client :sns credentials3291)]
     (clojure.core/case
      (clojure.core/count args3292)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args3292 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3293
           listSubscriptionsByTopic
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest
               (clojure.core/nth args3292 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3293
               listSubscriptionsByTopic
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listSubscriptionsByTopic")
                {:args args3292}))))))))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3293
        listSubscriptionsByTopic
        (clojure.core/str (clojure.core/nth args3292 0))
        (clojure.core/str (clojure.core/nth args3292 1))))))))
  (clojure.core/defn
   list-subscriptions-by-topic-map
   {:arglists (quote
               [[credentials string-0]
                [credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn
                         next-token
                         general-progress-listener]}]]),
    :doc "Generate map for listSubscriptionsByTopic, listSubscriptionsByTopic, listSubscriptionsByTopic"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-subscriptions-by-topic,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sns,
     :fn :list-subscriptions-by-topic,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-subscriptions-by-topic
   {:arglists (quote
               [[credentials string-0]
                [credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn
                         next-token
                         general-progress-listener]}]]),
    :doc "Call listSubscriptionsByTopic, listSubscriptionsByTopic, listSubscriptionsByTopic"}
   [credentials3295 & args3296]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3297
     (com.palletops.awaze.common/aws-client :sns credentials3295)]
    (clojure.core/case
     (clojure.core/count args3296)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args3296 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3297
          listSubscriptionsByTopic
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest
              (clojure.core/nth args3296 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3297
              listSubscriptionsByTopic
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listSubscriptionsByTopic")
               {:args args3296}))))))))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3297
       listSubscriptionsByTopic
       (clojure.core/str (clojure.core/nth args3296 0))
       (clojure.core/str (clojure.core/nth args3296 1))))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-platform-application
   [m3298]
   (clojure.core/let
    [credentials3299 (:credentials m3298) args3300 (:args m3298)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3301
      (com.palletops.awaze.common/aws-client :sns credentials3299)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3301
       deletePlatformApplication
       (sns/delete-platform-application-request
        (clojure.core/nth args3300 0)))))))
  (clojure.core/defn
   delete-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener]}]]),
    :doc "Generate map for deletePlatformApplication"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :delete-platform-application,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener]}]]),
    :doc "Call deletePlatformApplication"}
   [credentials3303 & args3304]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3305
     (com.palletops.awaze.common/aws-client :sns credentials3303)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3305
      deletePlatformApplication
      (sns/delete-platform-application-request
       (clojure.core/nth args3304 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-endpoints-by-platform-application
   [m3306]
   (clojure.core/let
    [credentials3307 (:credentials m3306) args3308 (:args m3306)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3309
      (com.palletops.awaze.common/aws-client :sns credentials3307)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3309
       listEndpointsByPlatformApplication
       (sns/list-endpoints-by-platform-application-request
        (clojure.core/nth args3308 0)))))))
  (clojure.core/defn
   list-endpoints-by-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         next-token
                         general-progress-listener]}]]),
    :doc "Generate map for listEndpointsByPlatformApplication"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-endpoints-by-platform-application,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-endpoints-by-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         next-token
                         general-progress-listener]}]]),
    :doc "Call listEndpointsByPlatformApplication"}
   [credentials3311 & args3312]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3313
     (com.palletops.awaze.common/aws-client :sns credentials3311)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3313
      listEndpointsByPlatformApplication
      (sns/list-endpoints-by-platform-application-request
       (clojure.core/nth args3312 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :unsubscribe
   [m3314]
   (clojure.core/let
    [credentials3315 (:credentials m3314) args3316 (:args m3314)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3317
      (com.palletops.awaze.common/aws-client :sns credentials3315)]
     (clojure.core/case
      (clojure.core/count args3316)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args3316 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3317
           unsubscribe
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.UnsubscribeRequest
               (clojure.core/nth args3316 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3317
               unsubscribe
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "unsubscribe")
                {:args args3316}))))))))))))))
  (clojure.core/defn
   unsubscribe-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [subscription-arn general-progress-listener]}]]),
    :doc "Generate map for unsubscribe, unsubscribe"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :unsubscribe,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   unsubscribe
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [subscription-arn general-progress-listener]}]]),
    :doc "Call unsubscribe, unsubscribe"}
   [credentials3319 & args3320]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3321
     (com.palletops.awaze.common/aws-client :sns credentials3319)]
    (clojure.core/case
     (clojure.core/count args3320)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args3320 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3321
          unsubscribe
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.UnsubscribeRequest
              (clojure.core/nth args3320 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3321
              unsubscribe
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "unsubscribe")
               {:args args3320}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :set-subscription-attributes
   [m3322]
   (clojure.core/let
    [credentials3323 (:credentials m3322) args3324 (:args m3322)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3325
      (com.palletops.awaze.common/aws-client :sns credentials3323)]
     (clojure.core/case
      (clojure.core/count args3324)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3325
        setSubscriptionAttributes
        (sns/set-subscription-attributes-request
         (clojure.core/nth args3324 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3325
        setSubscriptionAttributes
        (clojure.core/str (clojure.core/nth args3324 0))
        (clojure.core/str (clojure.core/nth args3324 1))
        (clojure.core/str (clojure.core/nth args3324 2))))))))
  (clojure.core/defn
   set-subscription-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-arn
                         general-progress-listener
                         attribute-value
                         attribute-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for setSubscriptionAttributes, setSubscriptionAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-subscription-attributes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :sns,
     :fn :set-subscription-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-subscription-attributes
   {:arglists (quote
               [[credentials
                 {:keys [subscription-arn
                         general-progress-listener
                         attribute-value
                         attribute-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call setSubscriptionAttributes, setSubscriptionAttributes"}
   [credentials3327 & args3328]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3329
     (com.palletops.awaze.common/aws-client :sns credentials3327)]
    (clojure.core/case
     (clojure.core/count args3328)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3329
       setSubscriptionAttributes
       (sns/set-subscription-attributes-request
        (clojure.core/nth args3328 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3329
       setSubscriptionAttributes
       (clojure.core/str (clojure.core/nth args3328 0))
       (clojure.core/str (clojure.core/nth args3328 1))
       (clojure.core/str (clojure.core/nth args3328 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions
   [m3330]
   (clojure.core/let
    [credentials3331 (:credentials m3330) args3332 (:args m3330)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3333
      (com.palletops.awaze.common/aws-client :sns credentials3331)]
     (clojure.core/case
      (clojure.core/count args3332)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.ListSubscriptionsRequest
           (clojure.core/nth args3332 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3333
           listSubscriptions
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args3332 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3333
               listSubscriptions
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listSubscriptions")
                {:args args3332}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3333
        listSubscriptions))))))
  (clojure.core/defn
   list-subscriptions-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token general-progress-listener]}]
                [credentials]
                [credentials string-0]]),
    :doc "Generate map for listSubscriptions, listSubscriptions, listSubscriptions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :sns,
     :fn :list-subscriptions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-subscriptions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-subscriptions
   {:arglists (quote
               [[credentials
                 {:keys [next-token general-progress-listener]}]
                [credentials]
                [credentials string-0]]),
    :doc "Call listSubscriptions, listSubscriptions, listSubscriptions"}
   [credentials3335 & args3336]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3337
     (com.palletops.awaze.common/aws-client :sns credentials3335)]
    (clojure.core/case
     (clojure.core/count args3336)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.ListSubscriptionsRequest
          (clojure.core/nth args3336 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3337
          listSubscriptions
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args3336 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3337
              listSubscriptions
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listSubscriptions")
               {:args args3336}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3337
       listSubscriptions))))))
 (do
  (clojure.core/defmethod
   sns
   :create-topic
   [m3338]
   (clojure.core/let
    [credentials3339 (:credentials m3338) args3340 (:args m3338)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3341
      (com.palletops.awaze.common/aws-client :sns credentials3339)]
     (clojure.core/case
      (clojure.core/count args3340)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.CreateTopicRequest
           (clojure.core/nth args3340 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3341
           createTopic
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args3340 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3341
               createTopic
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createTopic")
                {:args args3340}))))))))))))))
  (clojure.core/defn
   create-topic-map
   {:arglists (quote
               [[credentials {:keys [name general-progress-listener]}]
                [credentials string-0]]),
    :doc "Generate map for createTopic, createTopic"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :create-topic,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-topic
   {:arglists (quote
               [[credentials {:keys [name general-progress-listener]}]
                [credentials string-0]]),
    :doc "Call createTopic, createTopic"}
   [credentials3343 & args3344]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3345
     (com.palletops.awaze.common/aws-client :sns credentials3343)]
    (clojure.core/case
     (clojure.core/count args3344)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.CreateTopicRequest
          (clojure.core/nth args3344 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3345
          createTopic
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args3344 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3345
              createTopic
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createTopic")
               {:args args3344}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-endpoint
   [m3346]
   (clojure.core/let
    [credentials3347 (:credentials m3346) args3348 (:args m3346)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3349
      (com.palletops.awaze.common/aws-client :sns credentials3347)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3349
       createPlatformEndpoint
       (sns/create-platform-endpoint-request
        (clojure.core/nth args3348 0)))))))
  (clojure.core/defn
   create-platform-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [token
                         platform-application-arn
                         general-progress-listener
                         custom-user-data
                         attributes]}]]),
    :doc "Generate map for createPlatformEndpoint"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :create-platform-endpoint,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-platform-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [token
                         platform-application-arn
                         general-progress-listener
                         custom-user-data
                         attributes]}]]),
    :doc "Call createPlatformEndpoint"}
   [credentials3351 & args3352]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3353
     (com.palletops.awaze.common/aws-client :sns credentials3351)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3353
      createPlatformEndpoint
      (sns/create-platform-endpoint-request
       (clojure.core/nth args3352 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :remove-permission
   [m3354]
   (clojure.core/let
    [credentials3355 (:credentials m3354) args3356 (:args m3354)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3357
      (com.palletops.awaze.common/aws-client :sns credentials3355)]
     (clojure.core/case
      (clojure.core/count args3356)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3357
        removePermission
        (clojure.core/str (clojure.core/nth args3356 0))
        (clojure.core/str (clojure.core/nth args3356 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3357
        removePermission
        (sns/remove-permission-request (clojure.core/nth args3356 0))))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn label general-progress-listener]}]]),
    :doc "Generate map for removePermission, removePermission"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :remove-permission,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sns,
     :fn :remove-permission,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn label general-progress-listener]}]]),
    :doc "Call removePermission, removePermission"}
   [credentials3359 & args3360]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3361
     (com.palletops.awaze.common/aws-client :sns credentials3359)]
    (clojure.core/case
     (clojure.core/count args3360)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3361
       removePermission
       (clojure.core/str (clojure.core/nth args3360 0))
       (clojure.core/str (clojure.core/nth args3360 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3361
       removePermission
       (sns/remove-permission-request (clojure.core/nth args3360 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :get-topic-attributes
   [m3362]
   (clojure.core/let
    [credentials3363 (:credentials m3362) args3364 (:args m3362)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3365
      (com.palletops.awaze.common/aws-client :sns credentials3363)]
     (clojure.core/case
      (clojure.core/count args3364)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.GetTopicAttributesRequest
           (clojure.core/nth args3364 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3365
           getTopicAttributes
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args3364 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3365
               getTopicAttributes
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getTopicAttributes")
                {:args args3364}))))))))))))))
  (clojure.core/defn
   get-topic-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn general-progress-listener]}]
                [credentials string-0]]),
    :doc "Generate map for getTopicAttributes, getTopicAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-topic-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-topic-attributes
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn general-progress-listener]}]
                [credentials string-0]]),
    :doc "Call getTopicAttributes, getTopicAttributes"}
   [credentials3367 & args3368]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3369
     (com.palletops.awaze.common/aws-client :sns credentials3367)]
    (clojure.core/case
     (clojure.core/count args3368)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.GetTopicAttributesRequest
          (clojure.core/nth args3368 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3369
          getTopicAttributes
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args3368 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3369
              getTopicAttributes
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getTopicAttributes")
               {:args args3368}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :subscribe
   [m3370]
   (clojure.core/let
    [credentials3371 (:credentials m3370) args3372 (:args m3370)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3373
      (com.palletops.awaze.common/aws-client :sns credentials3371)]
     (clojure.core/case
      (clojure.core/count args3372)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3373
        subscribe
        (sns/subscribe-request (clojure.core/nth args3372 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3373
        subscribe
        (clojure.core/str (clojure.core/nth args3372 0))
        (clojure.core/str (clojure.core/nth args3372 1))
        (clojure.core/str (clojure.core/nth args3372 2))))))))
  (clojure.core/defn
   subscribe-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         protocol
                         general-progress-listener
                         endpoint]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for subscribe, subscribe"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :subscribe,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :sns,
     :fn :subscribe,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   subscribe
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         protocol
                         general-progress-listener
                         endpoint]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call subscribe, subscribe"}
   [credentials3375 & args3376]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3377
     (com.palletops.awaze.common/aws-client :sns credentials3375)]
    (clojure.core/case
     (clojure.core/count args3376)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3377
       subscribe
       (sns/subscribe-request (clojure.core/nth args3376 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3377
       subscribe
       (clojure.core/str (clojure.core/nth args3376 0))
       (clojure.core/str (clojure.core/nth args3376 1))
       (clojure.core/str (clojure.core/nth args3376 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-endpoint
   [m3378]
   (clojure.core/let
    [credentials3379 (:credentials m3378) args3380 (:args m3378)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3381
      (com.palletops.awaze.common/aws-client :sns credentials3379)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3381
       deleteEndpoint
       (sns/delete-endpoint-request (clojure.core/nth args3380 0)))))))
  (clojure.core/defn
   delete-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener endpoint-arn]}]]),
    :doc "Generate map for deleteEndpoint"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :delete-endpoint,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener endpoint-arn]}]]),
    :doc "Call deleteEndpoint"}
   [credentials3383 & args3384]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3385
     (com.palletops.awaze.common/aws-client :sns credentials3383)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3385
      deleteEndpoint
      (sns/delete-endpoint-request (clojure.core/nth args3384 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-platform-applications
   [m3386]
   (clojure.core/let
    [credentials3387 (:credentials m3386) args3388 (:args m3386)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3389
      (com.palletops.awaze.common/aws-client :sns credentials3387)]
     (clojure.core/case
      (clojure.core/count args3388)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3389
        listPlatformApplications
        (sns/list-platform-applications-request
         (clojure.core/nth args3388 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3389
        listPlatformApplications))))))
  (clojure.core/defn
   list-platform-applications-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listPlatformApplications, listPlatformApplications"}
   ([credentials__1651__auto__]
    {:args [],
     :client :sns,
     :fn :list-platform-applications,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-platform-applications,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-platform-applications
   {:arglists (quote
               [[credentials
                 {:keys [next-token general-progress-listener]}]
                [credentials]]),
    :doc "Call listPlatformApplications, listPlatformApplications"}
   [credentials3391 & args3392]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3393
     (com.palletops.awaze.common/aws-client :sns credentials3391)]
    (clojure.core/case
     (clojure.core/count args3392)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3393
       listPlatformApplications
       (sns/list-platform-applications-request
        (clojure.core/nth args3392 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3393
       listPlatformApplications))))))
 (do
  (clojure.core/defmethod
   sns
   :set-platform-application-attributes
   [m3394]
   (clojure.core/let
    [credentials3395 (:credentials m3394) args3396 (:args m3394)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3397
      (com.palletops.awaze.common/aws-client :sns credentials3395)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3397
       setPlatformApplicationAttributes
       (sns/set-platform-application-attributes-request
        (clojure.core/nth args3396 0)))))))
  (clojure.core/defn
   set-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener
                         attributes]}]]),
    :doc "Generate map for setPlatformApplicationAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-platform-application-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener
                         attributes]}]]),
    :doc "Call setPlatformApplicationAttributes"}
   [credentials3399 & args3400]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3401
     (com.palletops.awaze.common/aws-client :sns credentials3399)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3401
      setPlatformApplicationAttributes
      (sns/set-platform-application-attributes-request
       (clojure.core/nth args3400 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-application
   [m3402]
   (clojure.core/let
    [credentials3403 (:credentials m3402) args3404 (:args m3402)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3405
      (com.palletops.awaze.common/aws-client :sns credentials3403)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3405
       createPlatformApplication
       (sns/create-platform-application-request
        (clojure.core/nth args3404 0)))))))
  (clojure.core/defn
   create-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [platform
                         name
                         general-progress-listener
                         attributes]}]]),
    :doc "Generate map for createPlatformApplication"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :create-platform-application,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [platform
                         name
                         general-progress-listener
                         attributes]}]]),
    :doc "Call createPlatformApplication"}
   [credentials3407 & args3408]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3409
     (com.palletops.awaze.common/aws-client :sns credentials3407)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3409
      createPlatformApplication
      (sns/create-platform-application-request
       (clojure.core/nth args3408 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-endpoint-attributes
   [m3410]
   (clojure.core/let
    [credentials3411 (:credentials m3410) args3412 (:args m3410)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3413
      (com.palletops.awaze.common/aws-client :sns credentials3411)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3413
       setEndpointAttributes
       (sns/set-endpoint-attributes-request
        (clojure.core/nth args3412 0)))))))
  (clojure.core/defn
   set-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         endpoint-arn
                         attributes]}]]),
    :doc "Generate map for setEndpointAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-endpoint-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         endpoint-arn
                         attributes]}]]),
    :doc "Call setEndpointAttributes"}
   [credentials3415 & args3416]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3417
     (com.palletops.awaze.common/aws-client :sns credentials3415)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3417
      setEndpointAttributes
      (sns/set-endpoint-attributes-request
       (clojure.core/nth args3416 0))))))))
