(ns
 com.palletops.awaze.rds
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.rds :as rds]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :rds
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.rds.AmazonRDSClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.OptionSetting}
option-setting
  [m4830]
  (clojure.core/let
   [bean4829 (new com.amazonaws.services.rds.model.OptionSetting)]
   (clojure.core/when-let
    [v4831 (:data-type m4830)]
    (. bean4829 setDataType (clojure.core/str v4831)))
   (clojure.core/when-let
    [v4831 (:apply-type m4830)]
    (. bean4829 setApplyType (clojure.core/str v4831)))
   (clojure.core/when-let
    [v4831 (:allowed-values m4830)]
    (. bean4829 setAllowedValues (clojure.core/str v4831)))
   (clojure.core/when-let
    [v4831 (:is-collection m4830)]
    (. bean4829 setIsCollection (clojure.core/boolean v4831)))
   (clojure.core/when-let
    [v4831 (:name m4830)]
    (. bean4829 setName (clojure.core/str v4831)))
   (clojure.core/when-let
    [v4831 (:value m4830)]
    (. bean4829 setValue (clojure.core/str v4831)))
   (clojure.core/when-let
    [v4831 (:is-modifiable m4830)]
    (. bean4829 setIsModifiable (clojure.core/boolean v4831)))
   (clojure.core/when-let
    [v4831 (:default-value m4830)]
    (. bean4829 setDefaultValue (clojure.core/str v4831)))
   (clojure.core/when-let
    [v4831 (:description m4830)]
    (. bean4829 setDescription (clojure.core/str v4831)))
   bean4829))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.Tag}
tag
  [m4833]
  (clojure.core/let
   [bean4832 (new com.amazonaws.services.rds.model.Tag)]
   (clojure.core/when-let
    [v4834 (:value m4833)]
    (. bean4832 setValue (clojure.core/str v4834)))
   (clojure.core/when-let
    [v4834 (:key m4833)]
    (. bean4832 setKey (clojure.core/str v4834)))
   bean4832))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.Filter}
filter
  [m4836]
  (clojure.core/let
   [bean4835 (new com.amazonaws.services.rds.model.Filter)]
   (clojure.core/when-let
    [v4837 (:filter-name m4836)]
    (. bean4835 setFilterName (clojure.core/str v4837)))
   (clojure.core/when-let
    [v4837 (:filter-value m4836)]
    (.
     bean4835
     setFilterValue
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5003] (clojure.core/str arg5003))
 v4837)))
   bean4835))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.SourceType}
source-type
  [m4839]
  (.
   com.amazonaws.services.rds.model.SourceType
   fromValue
   (clojure.core/name m4839)))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.OptionConfiguration}
option-configuration
  [m4842]
  (clojure.core/let
   [bean4841
    (new com.amazonaws.services.rds.model.OptionConfiguration)]
   (clojure.core/when-let
    [v4843 (:port m4842)]
    (. bean4841 setPort (clojure.core/int v4843)))
   (clojure.core/when-let
    [v4843 (:option-name m4842)]
    (. bean4841 setOptionName (clojure.core/str v4843)))
   (clojure.core/when-let
    [v4843 (:dbsecurity-group-memberships m4842)]
    (.
     bean4841
     setDBSecurityGroupMemberships
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5004] (clojure.core/str arg5004))
 v4843)))
   (clojure.core/when-let
    [v4843 (:vpc-security-group-memberships m4842)]
    (.
     bean4841
     setVpcSecurityGroupMemberships
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5005] (clojure.core/str arg5005))
 v4843)))
   (clojure.core/when-let
    [v4843 (:option-settings m4842)]
    (.
     bean4841
     setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5006] (rds/option-setting arg5006))
 v4843)))
   bean4841))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.Parameter}
parameter
  [m4845]
  (clojure.core/let
   [bean4844 (new com.amazonaws.services.rds.model.Parameter)]
   (clojure.core/when-let
    [v4846 (:data-type m4845)]
    (. bean4844 setDataType (clojure.core/str v4846)))
   (clojure.core/when-let
    [v4846 (:apply-type m4845)]
    (. bean4844 setApplyType (clojure.core/str v4846)))
   (clojure.core/when-let
    [v4846 (:allowed-values m4845)]
    (. bean4844 setAllowedValues (clojure.core/str v4846)))
   (clojure.core/when-let
    [v4846 (:parameter-value m4845)]
    (. bean4844 setParameterValue (clojure.core/str v4846)))
   (clojure.core/when-let
    [v4846 (:minimum-engine-version m4845)]
    (. bean4844 setMinimumEngineVersion (clojure.core/str v4846)))
   (clojure.core/when-let
    [v4846 (:apply-method m4845)]
    (. bean4844 setApplyMethod (clojure.core/str v4846)))
   (clojure.core/when-let
    [v4846 (:is-modifiable m4845)]
    (. bean4844 setIsModifiable (clojure.core/boolean v4846)))
   (clojure.core/when-let
    [v4846 (:parameter-name m4845)]
    (. bean4844 setParameterName (clojure.core/str v4846)))
   (clojure.core/when-let
    [v4846 (:description m4845)]
    (. bean4844 setDescription (clojure.core/str v4846)))
   (clojure.core/when-let
    [v4846 (:source m4845)]
    (. bean4844 setSource (clojure.core/str v4846)))
   bean4844))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest}
revoke-dbsecurity-group-ingress-request
  [m4848]
  (clojure.core/let
   [bean4847
    (new
     com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v4849 (:cidrip m4848)]
    (. bean4847 setCIDRIP (clojure.core/str v4849)))
   (clojure.core/when-let
    [v4849 (:ec2security-group-name m4848)]
    (. bean4847 setEC2SecurityGroupName (clojure.core/str v4849)))
   (clojure.core/when-let
    [v4849 (:ec2security-group-owner-id m4848)]
    (. bean4847 setEC2SecurityGroupOwnerId (clojure.core/str v4849)))
   (clojure.core/when-let
    [v4849 (:dbsecurity-group-name m4848)]
    (. bean4847 setDBSecurityGroupName (clojure.core/str v4849)))
   (clojure.core/when-let
    [v4849 (:ec2security-group-id m4848)]
    (. bean4847 setEC2SecurityGroupId (clojure.core/str v4849)))
   bean4847))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.AddTagsToResourceRequest}
add-tags-to-resource-request
  [m4851]
  (clojure.core/let
   [bean4850
    (new com.amazonaws.services.rds.model.AddTagsToResourceRequest)]
   (clojure.core/when-let
    [v4852 (:tags m4851)]
    (.
     bean4850
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5007] (rds/tag arg5007)) v4852)))
   (clojure.core/when-let
    [v4852 (:resource-name m4851)]
    (. bean4850 setResourceName (clojure.core/str v4852)))
   bean4850))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest}
describe-dbsecurity-groups-request
  [m4854]
  (clojure.core/let
   [bean4853
    (new
     com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest)]
   (clojure.core/when-let
    [v4855 (:marker m4854)]
    (. bean4853 setMarker (clojure.core/str v4855)))
   (clojure.core/when-let
    [v4855 (:max-records m4854)]
    (. bean4853 setMaxRecords (clojure.core/int v4855)))
   (clojure.core/when-let
    [v4855 (:filters m4854)]
    (.
     bean4853
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5008] (rds/filter arg5008))
 v4855)))
   (clojure.core/when-let
    [v4855 (:dbsecurity-group-name m4854)]
    (. bean4853 setDBSecurityGroupName (clojure.core/str v4855)))
   bean4853))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest}
purchase-reserved-dbinstances-offering-request
  [m4857]
  (clojure.core/let
   [bean4856
    (new
     com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest)]
   (clojure.core/when-let
    [v4858 (:tags m4857)]
    (.
     bean4856
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5009] (rds/tag arg5009)) v4858)))
   (clojure.core/when-let
    [v4858 (:dbinstance-count m4857)]
    (. bean4856 setDBInstanceCount (clojure.core/int v4858)))
   (clojure.core/when-let
    [v4858 (:reserved-dbinstances-offering-id m4857)]
    (.
     bean4856
     setReservedDBInstancesOfferingId
     (clojure.core/str v4858)))
   (clojure.core/when-let
    [v4858 (:reserved-dbinstance-id m4857)]
    (. bean4856 setReservedDBInstanceId (clojure.core/str v4858)))
   bean4856))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBParametersRequest}
describe-dbparameters-request
  [m4860]
  (clojure.core/let
   [bean4859
    (new com.amazonaws.services.rds.model.DescribeDBParametersRequest)]
   (clojure.core/when-let
    [v4861 (:marker m4860)]
    (. bean4859 setMarker (clojure.core/str v4861)))
   (clojure.core/when-let
    [v4861 (:max-records m4860)]
    (. bean4859 setMaxRecords (clojure.core/int v4861)))
   (clojure.core/when-let
    [v4861 (:source m4860)]
    (. bean4859 setSource (clojure.core/str v4861)))
   (clojure.core/when-let
    [v4861 (:dbparameter-group-name m4860)]
    (. bean4859 setDBParameterGroupName (clojure.core/str v4861)))
   bean4859))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeOptionGroupsRequest}
describe-option-groups-request
  [m4863]
  (clojure.core/let
   [bean4862
    (new com.amazonaws.services.rds.model.DescribeOptionGroupsRequest)]
   (clojure.core/when-let
    [v4864 (:marker m4863)]
    (. bean4862 setMarker (clojure.core/str v4864)))
   (clojure.core/when-let
    [v4864 (:max-records m4863)]
    (. bean4862 setMaxRecords (clojure.core/int v4864)))
   (clojure.core/when-let
    [v4864 (:filters m4863)]
    (.
     bean4862
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5010] (rds/filter arg5010))
 v4864)))
   (clojure.core/when-let
    [v4864 (:option-group-name m4863)]
    (. bean4862 setOptionGroupName (clojure.core/str v4864)))
   (clojure.core/when-let
    [v4864 (:engine-name m4863)]
    (. bean4862 setEngineName (clojure.core/str v4864)))
   (clojure.core/when-let
    [v4864 (:major-engine-version m4863)]
    (. bean4862 setMajorEngineVersion (clojure.core/str v4864)))
   bean4862))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest}
create-dbinstance-read-replica-request
  [m4866]
  (clojure.core/let
   [bean4865
    (new
     com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest)]
   (clojure.core/when-let
    [v4867 (:port m4866)]
    (. bean4865 setPort (clojure.core/int v4867)))
   (clojure.core/when-let
    [v4867 (:dbinstance-class m4866)]
    (. bean4865 setDBInstanceClass (clojure.core/str v4867)))
   (clojure.core/when-let
    [v4867 (:auto-minor-version-upgrade m4866)]
    (.
     bean4865
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v4867)))
   (clojure.core/when-let
    [v4867 (:availability-zone m4866)]
    (. bean4865 setAvailabilityZone (clojure.core/str v4867)))
   (clojure.core/when-let
    [v4867 (:iops m4866)]
    (. bean4865 setIops (clojure.core/int v4867)))
   (clojure.core/when-let
    [v4867 (:dbsubnet-group-name m4866)]
    (. bean4865 setDBSubnetGroupName (clojure.core/str v4867)))
   (clojure.core/when-let
    [v4867 (:publicly-accessible m4866)]
    (. bean4865 setPubliclyAccessible (clojure.core/boolean v4867)))
   (clojure.core/when-let
    [v4867 (:option-group-name m4866)]
    (. bean4865 setOptionGroupName (clojure.core/str v4867)))
   (clojure.core/when-let
    [v4867 (:source-dbinstance-identifier m4866)]
    (.
     bean4865
     setSourceDBInstanceIdentifier
     (clojure.core/str v4867)))
   (clojure.core/when-let
    [v4867 (:tags m4866)]
    (.
     bean4865
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5011] (rds/tag arg5011)) v4867)))
   (clojure.core/when-let
    [v4867 (:dbinstance-identifier m4866)]
    (. bean4865 setDBInstanceIdentifier (clojure.core/str v4867)))
   bean4865))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest}
restore-dbinstance-from-dbsnapshot-request
  [m4869]
  (clojure.core/let
   [bean4868
    (new
     com.amazonaws.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest)]
   (clojure.core/when-let
    [v4870 (:port m4869)]
    (. bean4868 setPort (clojure.core/int v4870)))
   (clojure.core/when-let
    [v4870 (:dbinstance-class m4869)]
    (. bean4868 setDBInstanceClass (clojure.core/str v4870)))
   (clojure.core/when-let
    [v4870 (:engine m4869)]
    (. bean4868 setEngine (clojure.core/str v4870)))
   (clojure.core/when-let
    [v4870 (:auto-minor-version-upgrade m4869)]
    (.
     bean4868
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v4870)))
   (clojure.core/when-let
    [v4870 (:availability-zone m4869)]
    (. bean4868 setAvailabilityZone (clojure.core/str v4870)))
   (clojure.core/when-let
    [v4870 (:license-model m4869)]
    (. bean4868 setLicenseModel (clojure.core/str v4870)))
   (clojure.core/when-let
    [v4870 (:iops m4869)]
    (. bean4868 setIops (clojure.core/int v4870)))
   (clojure.core/when-let
    [v4870 (:dbname m4869)]
    (. bean4868 setDBName (clojure.core/str v4870)))
   (clojure.core/when-let
    [v4870 (:dbsnapshot-identifier m4869)]
    (. bean4868 setDBSnapshotIdentifier (clojure.core/str v4870)))
   (clojure.core/when-let
    [v4870 (:dbsubnet-group-name m4869)]
    (. bean4868 setDBSubnetGroupName (clojure.core/str v4870)))
   (clojure.core/when-let
    [v4870 (:publicly-accessible m4869)]
    (. bean4868 setPubliclyAccessible (clojure.core/boolean v4870)))
   (clojure.core/when-let
    [v4870 (:multi-az m4869)]
    (. bean4868 setMultiAZ (clojure.core/boolean v4870)))
   (clojure.core/when-let
    [v4870 (:option-group-name m4869)]
    (. bean4868 setOptionGroupName (clojure.core/str v4870)))
   (clojure.core/when-let
    [v4870 (:tags m4869)]
    (.
     bean4868
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5012] (rds/tag arg5012)) v4870)))
   (clojure.core/when-let
    [v4870 (:dbinstance-identifier m4869)]
    (. bean4868 setDBInstanceIdentifier (clojure.core/str v4870)))
   bean4868))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBParameterGroupRequest}
delete-dbparameter-group-request
  [m4872]
  (clojure.core/let
   [bean4871
    (new
     com.amazonaws.services.rds.model.DeleteDBParameterGroupRequest)]
   (clojure.core/when-let
    [v4873 (:dbparameter-group-name m4872)]
    (. bean4871 setDBParameterGroupName (clojure.core/str v4873)))
   bean4871))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest}
describe-reserved-dbinstances-request
  [m4875]
  (clojure.core/let
   [bean4874
    (new
     com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest)]
   (clojure.core/when-let
    [v4876 (:max-records m4875)]
    (. bean4874 setMaxRecords (clojure.core/int v4876)))
   (clojure.core/when-let
    [v4876 (:offering-type m4875)]
    (. bean4874 setOfferingType (clojure.core/str v4876)))
   (clojure.core/when-let
    [v4876 (:dbinstance-class m4875)]
    (. bean4874 setDBInstanceClass (clojure.core/str v4876)))
   (clojure.core/when-let
    [v4876 (:product-description m4875)]
    (. bean4874 setProductDescription (clojure.core/str v4876)))
   (clojure.core/when-let
    [v4876 (:multi-az m4875)]
    (. bean4874 setMultiAZ (clojure.core/boolean v4876)))
   (clojure.core/when-let
    [v4876 (:duration m4875)]
    (. bean4874 setDuration (clojure.core/str v4876)))
   (clojure.core/when-let
    [v4876 (:reserved-dbinstances-offering-id m4875)]
    (.
     bean4874
     setReservedDBInstancesOfferingId
     (clojure.core/str v4876)))
   (clojure.core/when-let
    [v4876 (:reserved-dbinstance-id m4875)]
    (. bean4874 setReservedDBInstanceId (clojure.core/str v4876)))
   (clojure.core/when-let
    [v4876 (:filters m4875)]
    (.
     bean4874
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5013] (rds/filter arg5013))
 v4876)))
   (clojure.core/when-let
    [v4876 (:marker m4875)]
    (. bean4874 setMarker (clojure.core/str v4876)))
   bean4874))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBSecurityGroupRequest}
delete-dbsecurity-group-request
  [m4878]
  (clojure.core/let
   [bean4877
    (new
     com.amazonaws.services.rds.model.DeleteDBSecurityGroupRequest)]
   (clojure.core/when-let
    [v4879 (:dbsecurity-group-name m4878)]
    (. bean4877 setDBSecurityGroupName (clojure.core/str v4879)))
   bean4877))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest}
describe-engine-default-parameters-request
  [m4881]
  (clojure.core/let
   [bean4880
    (new
     com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest)]
   (clojure.core/when-let
    [v4882 (:marker m4881)]
    (. bean4880 setMarker (clojure.core/str v4882)))
   (clojure.core/when-let
    [v4882 (:max-records m4881)]
    (. bean4880 setMaxRecords (clojure.core/int v4882)))
   (clojure.core/when-let
    [v4882 (:dbparameter-group-family m4881)]
    (. bean4880 setDBParameterGroupFamily (clojure.core/str v4882)))
   bean4880))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBParameterGroupRequest}
create-dbparameter-group-request
  [m4884]
  (clojure.core/let
   [bean4883
    (new
     com.amazonaws.services.rds.model.CreateDBParameterGroupRequest)]
   (clojure.core/when-let
    [v4885 (:tags m4884)]
    (.
     bean4883
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5014] (rds/tag arg5014)) v4885)))
   (clojure.core/when-let
    [v4885 (:description m4884)]
    (. bean4883 setDescription (clojure.core/str v4885)))
   (clojure.core/when-let
    [v4885 (:dbparameter-group-name m4884)]
    (. bean4883 setDBParameterGroupName (clojure.core/str v4885)))
   (clojure.core/when-let
    [v4885 (:dbparameter-group-family m4884)]
    (. bean4883 setDBParameterGroupFamily (clojure.core/str v4885)))
   bean4883))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateEventSubscriptionRequest}
create-event-subscription-request
  [m4887]
  (clojure.core/let
   [bean4886
    (new
     com.amazonaws.services.rds.model.CreateEventSubscriptionRequest)]
   (clojure.core/when-let
    [v4888 (:source-type m4887)]
    (. bean4886 setSourceType (clojure.core/str v4888)))
   (clojure.core/when-let
    [v4888 (:subscription-name m4887)]
    (. bean4886 setSubscriptionName (clojure.core/str v4888)))
   (clojure.core/when-let
    [v4888 (:sns-topic-arn m4887)]
    (. bean4886 setSnsTopicArn (clojure.core/str v4888)))
   (clojure.core/when-let
    [v4888 (:source-ids m4887)]
    (.
     bean4886
     setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5015] (clojure.core/str arg5015))
 v4888)))
   (clojure.core/when-let
    [v4888 (:event-categories m4887)]
    (.
     bean4886
     setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5016] (clojure.core/str arg5016))
 v4888)))
   (clojure.core/when-let
    [v4888 (:tags m4887)]
    (.
     bean4886
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5017] (rds/tag arg5017)) v4888)))
   (clojure.core/when-let
    [v4888 (:enabled m4887)]
    (. bean4886 setEnabled (clojure.core/boolean v4888)))
   bean4886))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest}
create-dbsecurity-group-request
  [m4890]
  (clojure.core/let
   [bean4889
    (new
     com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest)]
   (clojure.core/when-let
    [v4891 (:tags m4890)]
    (.
     bean4889
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5018] (rds/tag arg5018)) v4891)))
   (clojure.core/when-let
    [v4891 (:dbsecurity-group-name m4890)]
    (. bean4889 setDBSecurityGroupName (clojure.core/str v4891)))
   (clojure.core/when-let
    [v4891 (:dbsecurity-group-description m4890)]
    (.
     bean4889
     setDBSecurityGroupDescription
     (clojure.core/str v4891)))
   bean4889))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyEventSubscriptionRequest}
modify-event-subscription-request
  [m4893]
  (clojure.core/let
   [bean4892
    (new
     com.amazonaws.services.rds.model.ModifyEventSubscriptionRequest)]
   (clojure.core/when-let
    [v4894 (:source-type m4893)]
    (. bean4892 setSourceType (clojure.core/str v4894)))
   (clojure.core/when-let
    [v4894 (:subscription-name m4893)]
    (. bean4892 setSubscriptionName (clojure.core/str v4894)))
   (clojure.core/when-let
    [v4894 (:sns-topic-arn m4893)]
    (. bean4892 setSnsTopicArn (clojure.core/str v4894)))
   (clojure.core/when-let
    [v4894 (:event-categories m4893)]
    (.
     bean4892
     setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5019] (clojure.core/str arg5019))
 v4894)))
   (clojure.core/when-let
    [v4894 (:enabled m4893)]
    (. bean4892 setEnabled (clojure.core/boolean v4894)))
   bean4892))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteOptionGroupRequest}
delete-option-group-request
  [m4896]
  (clojure.core/let
   [bean4895
    (new com.amazonaws.services.rds.model.DeleteOptionGroupRequest)]
   (clojure.core/when-let
    [v4897 (:option-group-name m4896)]
    (. bean4895 setOptionGroupName (clojure.core/str v4897)))
   bean4895))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DownloadDBLogFilePortionRequest}
download-dblog-file-portion-request
  [m4899]
  (clojure.core/let
   [bean4898
    (new
     com.amazonaws.services.rds.model.DownloadDBLogFilePortionRequest)]
   (clojure.core/when-let
    [v4900 (:marker m4899)]
    (. bean4898 setMarker (clojure.core/str v4900)))
   (clojure.core/when-let
    [v4900 (:dbinstance-identifier m4899)]
    (. bean4898 setDBInstanceIdentifier (clojure.core/str v4900)))
   (clojure.core/when-let
    [v4900 (:log-file-name m4899)]
    (. bean4898 setLogFileName (clojure.core/str v4900)))
   (clojure.core/when-let
    [v4900 (:number-of-lines m4899)]
    (. bean4898 setNumberOfLines (clojure.core/int v4900)))
   bean4898))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEventsRequest}
describe-events-request
  [m4902]
  (clojure.core/let
   [bean4901
    (new com.amazonaws.services.rds.model.DescribeEventsRequest)]
   (clojure.core/when-let
    [v4903 (:marker m4902)]
    (. bean4901 setMarker (clojure.core/str v4903)))
   (clojure.core/when-let
    [v4903 (:max-records m4902)]
    (. bean4901 setMaxRecords (clojure.core/int v4903)))
   (clojure.core/when-let
    [v4903 (:source-identifier m4902)]
    (. bean4901 setSourceIdentifier (clojure.core/str v4903)))
   (clojure.core/when-let
    [v4903 (:source-type m4902)]
    (. bean4901 setSourceType (rds/source-type v4903)))
   (clojure.core/when-let
    [v4903 (:start-time m4902)]
    (.
     bean4901
     setStartTime
     (com.palletops.awaze.common/to-date v4903)))
   (clojure.core/when-let
    [v4903 (:end-time m4902)]
    (. bean4901 setEndTime (com.palletops.awaze.common/to-date v4903)))
   (clojure.core/when-let
    [v4903 (:duration m4902)]
    (. bean4901 setDuration (clojure.core/int v4903)))
   (clojure.core/when-let
    [v4903 (:event-categories m4902)]
    (.
     bean4901
     setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5020] (clojure.core/str arg5020))
 v4903)))
   bean4901))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest}
describe-reserved-dbinstances-offerings-request
  [m4905]
  (clojure.core/let
   [bean4904
    (new
     com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest)]
   (clojure.core/when-let
    [v4906 (:marker m4905)]
    (. bean4904 setMarker (clojure.core/str v4906)))
   (clojure.core/when-let
    [v4906 (:max-records m4905)]
    (. bean4904 setMaxRecords (clojure.core/int v4906)))
   (clojure.core/when-let
    [v4906 (:duration m4905)]
    (. bean4904 setDuration (clojure.core/str v4906)))
   (clojure.core/when-let
    [v4906 (:offering-type m4905)]
    (. bean4904 setOfferingType (clojure.core/str v4906)))
   (clojure.core/when-let
    [v4906 (:dbinstance-class m4905)]
    (. bean4904 setDBInstanceClass (clojure.core/str v4906)))
   (clojure.core/when-let
    [v4906 (:multi-az m4905)]
    (. bean4904 setMultiAZ (clojure.core/boolean v4906)))
   (clojure.core/when-let
    [v4906 (:reserved-dbinstances-offering-id m4905)]
    (.
     bean4904
     setReservedDBInstancesOfferingId
     (clojure.core/str v4906)))
   (clojure.core/when-let
    [v4906 (:product-description m4905)]
    (. bean4904 setProductDescription (clojure.core/str v4906)))
   bean4904))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyOptionGroupRequest}
modify-option-group-request
  [m4908]
  (clojure.core/let
   [bean4907
    (new com.amazonaws.services.rds.model.ModifyOptionGroupRequest)]
   (clojure.core/when-let
    [v4909 (:option-group-name m4908)]
    (. bean4907 setOptionGroupName (clojure.core/str v4909)))
   (clojure.core/when-let
    [v4909 (:apply-immediately m4908)]
    (. bean4907 setApplyImmediately (clojure.core/boolean v4909)))
   (clojure.core/when-let
    [v4909 (:options-to-include m4908)]
    (.
     bean4907
     setOptionsToInclude
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5021] (rds/option-configuration arg5021))
 v4909)))
   (clojure.core/when-let
    [v4909 (:options-to-remove m4908)]
    (.
     bean4907
     setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5022] (clojure.core/str arg5022))
 v4909)))
   bean4907))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBInstancesRequest}
describe-dbinstances-request
  [m4911]
  (clojure.core/let
   [bean4910
    (new com.amazonaws.services.rds.model.DescribeDBInstancesRequest)]
   (clojure.core/when-let
    [v4912 (:marker m4911)]
    (. bean4910 setMarker (clojure.core/str v4912)))
   (clojure.core/when-let
    [v4912 (:max-records m4911)]
    (. bean4910 setMaxRecords (clojure.core/int v4912)))
   (clojure.core/when-let
    [v4912 (:filters m4911)]
    (.
     bean4910
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5023] (rds/filter arg5023))
 v4912)))
   (clojure.core/when-let
    [v4912 (:dbinstance-identifier m4911)]
    (. bean4910 setDBInstanceIdentifier (clojure.core/str v4912)))
   bean4910))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBSnapshotRequest}
create-dbsnapshot-request
  [m4914]
  (clojure.core/let
   [bean4913
    (new com.amazonaws.services.rds.model.CreateDBSnapshotRequest)]
   (clojure.core/when-let
    [v4915 (:tags m4914)]
    (.
     bean4913
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5024] (rds/tag arg5024)) v4915)))
   (clojure.core/when-let
    [v4915 (:dbinstance-identifier m4914)]
    (. bean4913 setDBInstanceIdentifier (clojure.core/str v4915)))
   (clojure.core/when-let
    [v4915 (:dbsnapshot-identifier m4914)]
    (. bean4913 setDBSnapshotIdentifier (clojure.core/str v4915)))
   bean4913))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest}
remove-source-identifier-from-subscription-request
  [m4917]
  (clojure.core/let
   [bean4916
    (new
     com.amazonaws.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest)]
   (clojure.core/when-let
    [v4918 (:source-identifier m4917)]
    (. bean4916 setSourceIdentifier (clojure.core/str v4918)))
   (clojure.core/when-let
    [v4918 (:subscription-name m4917)]
    (. bean4916 setSubscriptionName (clojure.core/str v4918)))
   bean4916))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateOptionGroupRequest}
create-option-group-request
  [m4920]
  (clojure.core/let
   [bean4919
    (new com.amazonaws.services.rds.model.CreateOptionGroupRequest)]
   (clojure.core/when-let
    [v4921 (:tags m4920)]
    (.
     bean4919
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5025] (rds/tag arg5025)) v4921)))
   (clojure.core/when-let
    [v4921 (:option-group-name m4920)]
    (. bean4919 setOptionGroupName (clojure.core/str v4921)))
   (clojure.core/when-let
    [v4921 (:engine-name m4920)]
    (. bean4919 setEngineName (clojure.core/str v4921)))
   (clojure.core/when-let
    [v4921 (:major-engine-version m4920)]
    (. bean4919 setMajorEngineVersion (clojure.core/str v4921)))
   (clojure.core/when-let
    [v4921 (:option-group-description m4920)]
    (. bean4919 setOptionGroupDescription (clojure.core/str v4921)))
   bean4919))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEventSubscriptionsRequest}
describe-event-subscriptions-request
  [m4923]
  (clojure.core/let
   [bean4922
    (new
     com.amazonaws.services.rds.model.DescribeEventSubscriptionsRequest)]
   (clojure.core/when-let
    [v4924 (:marker m4923)]
    (. bean4922 setMarker (clojure.core/str v4924)))
   (clojure.core/when-let
    [v4924 (:max-records m4923)]
    (. bean4922 setMaxRecords (clojure.core/int v4924)))
   (clojure.core/when-let
    [v4924 (:subscription-name m4923)]
    (. bean4922 setSubscriptionName (clojure.core/str v4924)))
   (clojure.core/when-let
    [v4924 (:filters m4923)]
    (.
     bean4922
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5026] (rds/filter arg5026))
 v4924)))
   bean4922))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest}
describe-orderable-dbinstance-options-request
  [m4926]
  (clojure.core/let
   [bean4925
    (new
     com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest)]
   (clojure.core/when-let
    [v4927 (:marker m4926)]
    (. bean4925 setMarker (clojure.core/str v4927)))
   (clojure.core/when-let
    [v4927 (:max-records m4926)]
    (. bean4925 setMaxRecords (clojure.core/int v4927)))
   (clojure.core/when-let
    [v4927 (:dbinstance-class m4926)]
    (. bean4925 setDBInstanceClass (clojure.core/str v4927)))
   (clojure.core/when-let
    [v4927 (:engine m4926)]
    (. bean4925 setEngine (clojure.core/str v4927)))
   (clojure.core/when-let
    [v4927 (:engine-version m4926)]
    (. bean4925 setEngineVersion (clojure.core/str v4927)))
   (clojure.core/when-let
    [v4927 (:license-model m4926)]
    (. bean4925 setLicenseModel (clojure.core/str v4927)))
   (clojure.core/when-let
    [v4927 (:vpc m4926)]
    (. bean4925 setVpc (clojure.core/boolean v4927)))
   bean4925))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m4929]
  (clojure.core/let
   [bean4928
    (new com.amazonaws.services.rds.model.ListTagsForResourceRequest)]
   (clojure.core/when-let
    [v4930 (:resource-name m4929)]
    (. bean4928 setResourceName (clojure.core/str v4930)))
   bean4928))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyDBSubnetGroupRequest}
modify-dbsubnet-group-request
  [m4932]
  (clojure.core/let
   [bean4931
    (new com.amazonaws.services.rds.model.ModifyDBSubnetGroupRequest)]
   (clojure.core/when-let
    [v4933 (:subnet-ids m4932)]
    (.
     bean4931
     setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5027] (clojure.core/str arg5027))
 v4933)))
   (clojure.core/when-let
    [v4933 (:dbsubnet-group-name m4932)]
    (. bean4931 setDBSubnetGroupName (clojure.core/str v4933)))
   (clojure.core/when-let
    [v4933 (:dbsubnet-group-description m4932)]
    (. bean4931 setDBSubnetGroupDescription (clojure.core/str v4933)))
   bean4931))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBLogFilesRequest}
describe-dblog-files-request
  [m4935]
  (clojure.core/let
   [bean4934
    (new com.amazonaws.services.rds.model.DescribeDBLogFilesRequest)]
   (clojure.core/when-let
    [v4936 (:marker m4935)]
    (. bean4934 setMarker (clojure.core/str v4936)))
   (clojure.core/when-let
    [v4936 (:max-records m4935)]
    (. bean4934 setMaxRecords (clojure.core/int v4936)))
   (clojure.core/when-let
    [v4936 (:dbinstance-identifier m4935)]
    (. bean4934 setDBInstanceIdentifier (clojure.core/str v4936)))
   (clojure.core/when-let
    [v4936 (:filename-contains m4935)]
    (. bean4934 setFilenameContains (clojure.core/str v4936)))
   (clojure.core/when-let
    [v4936 (:file-last-written m4935)]
    (. bean4934 setFileLastWritten (clojure.core/long v4936)))
   (clojure.core/when-let
    [v4936 (:file-size m4935)]
    (. bean4934 setFileSize (clojure.core/long v4936)))
   bean4934))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.PromoteReadReplicaRequest}
promote-read-replica-request
  [m4938]
  (clojure.core/let
   [bean4937
    (new com.amazonaws.services.rds.model.PromoteReadReplicaRequest)]
   (clojure.core/when-let
    [v4939 (:dbinstance-identifier m4938)]
    (. bean4937 setDBInstanceIdentifier (clojure.core/str v4939)))
   (clojure.core/when-let
    [v4939 (:backup-retention-period m4938)]
    (. bean4937 setBackupRetentionPeriod (clojure.core/int v4939)))
   (clojure.core/when-let
    [v4939 (:preferred-backup-window m4938)]
    (. bean4937 setPreferredBackupWindow (clojure.core/str v4939)))
   bean4937))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBSubnetGroupRequest}
delete-dbsubnet-group-request
  [m4941]
  (clojure.core/let
   [bean4940
    (new com.amazonaws.services.rds.model.DeleteDBSubnetGroupRequest)]
   (clojure.core/when-let
    [v4942 (:dbsubnet-group-name m4941)]
    (. bean4940 setDBSubnetGroupName (clojure.core/str v4942)))
   bean4940))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest}
describe-dbsnapshots-request
  [m4944]
  (clojure.core/let
   [bean4943
    (new com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest)]
   (clojure.core/when-let
    [v4945 (:marker m4944)]
    (. bean4943 setMarker (clojure.core/str v4945)))
   (clojure.core/when-let
    [v4945 (:max-records m4944)]
    (. bean4943 setMaxRecords (clojure.core/int v4945)))
   (clojure.core/when-let
    [v4945 (:snapshot-type m4944)]
    (. bean4943 setSnapshotType (clojure.core/str v4945)))
   (clojure.core/when-let
    [v4945 (:filters m4944)]
    (.
     bean4943
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5028] (rds/filter arg5028))
 v4945)))
   (clojure.core/when-let
    [v4945 (:dbinstance-identifier m4944)]
    (. bean4943 setDBInstanceIdentifier (clojure.core/str v4945)))
   (clojure.core/when-let
    [v4945 (:dbsnapshot-identifier m4944)]
    (. bean4943 setDBSnapshotIdentifier (clojure.core/str v4945)))
   bean4943))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.AddSourceIdentifierToSubscriptionRequest}
add-source-identifier-to-subscription-request
  [m4947]
  (clojure.core/let
   [bean4946
    (new
     com.amazonaws.services.rds.model.AddSourceIdentifierToSubscriptionRequest)]
   (clojure.core/when-let
    [v4948 (:source-identifier m4947)]
    (. bean4946 setSourceIdentifier (clojure.core/str v4948)))
   (clojure.core/when-let
    [v4948 (:subscription-name m4947)]
    (. bean4946 setSubscriptionName (clojure.core/str v4948)))
   bean4946))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RemoveTagsFromResourceRequest}
remove-tags-from-resource-request
  [m4950]
  (clojure.core/let
   [bean4949
    (new
     com.amazonaws.services.rds.model.RemoveTagsFromResourceRequest)]
   (clojure.core/when-let
    [v4951 (:tag-keys m4950)]
    (.
     bean4949
     setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5029] (clojure.core/str arg5029))
 v4951)))
   (clojure.core/when-let
    [v4951 (:resource-name m4950)]
    (. bean4949 setResourceName (clojure.core/str v4951)))
   bean4949))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyDBInstanceRequest}
modify-dbinstance-request
  [m4953]
  (clojure.core/let
   [bean4952
    (new com.amazonaws.services.rds.model.ModifyDBInstanceRequest)]
   (clojure.core/when-let
    [v4954 (:vpc-security-group-ids m4953)]
    (.
     bean4952
     setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5030] (clojure.core/str arg5030))
 v4954)))
   (clojure.core/when-let
    [v4954 (:dbparameter-group-name m4953)]
    (. bean4952 setDBParameterGroupName (clojure.core/str v4954)))
   (clojure.core/when-let
    [v4954 (:dbinstance-class m4953)]
    (. bean4952 setDBInstanceClass (clojure.core/str v4954)))
   (clojure.core/when-let
    [v4954 (:preferred-maintenance-window m4953)]
    (.
     bean4952
     setPreferredMaintenanceWindow
     (clojure.core/str v4954)))
   (clojure.core/when-let
    [v4954 (:auto-minor-version-upgrade m4953)]
    (.
     bean4952
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v4954)))
   (clojure.core/when-let
    [v4954 (:master-user-password m4953)]
    (. bean4952 setMasterUserPassword (clojure.core/str v4954)))
   (clojure.core/when-let
    [v4954 (:iops m4953)]
    (. bean4952 setIops (clojure.core/int v4954)))
   (clojure.core/when-let
    [v4954 (:multi-az m4953)]
    (. bean4952 setMultiAZ (clojure.core/boolean v4954)))
   (clojure.core/when-let
    [v4954 (:preferred-backup-window m4953)]
    (. bean4952 setPreferredBackupWindow (clojure.core/str v4954)))
   (clojure.core/when-let
    [v4954 (:apply-immediately m4953)]
    (. bean4952 setApplyImmediately (clojure.core/boolean v4954)))
   (clojure.core/when-let
    [v4954 (:option-group-name m4953)]
    (. bean4952 setOptionGroupName (clojure.core/str v4954)))
   (clojure.core/when-let
    [v4954 (:dbsecurity-groups m4953)]
    (.
     bean4952
     setDBSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5031] (clojure.core/str arg5031))
 v4954)))
   (clojure.core/when-let
    [v4954 (:engine-version m4953)]
    (. bean4952 setEngineVersion (clojure.core/str v4954)))
   (clojure.core/when-let
    [v4954 (:allocated-storage m4953)]
    (. bean4952 setAllocatedStorage (clojure.core/int v4954)))
   (clojure.core/when-let
    [v4954 (:allow-major-version-upgrade m4953)]
    (.
     bean4952
     setAllowMajorVersionUpgrade
     (clojure.core/boolean v4954)))
   (clojure.core/when-let
    [v4954 (:new-dbinstance-identifier m4953)]
    (. bean4952 setNewDBInstanceIdentifier (clojure.core/str v4954)))
   (clojure.core/when-let
    [v4954 (:backup-retention-period m4953)]
    (. bean4952 setBackupRetentionPeriod (clojure.core/int v4954)))
   (clojure.core/when-let
    [v4954 (:dbinstance-identifier m4953)]
    (. bean4952 setDBInstanceIdentifier (clojure.core/str v4954)))
   bean4952))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBEngineVersionsRequest}
describe-dbengine-versions-request
  [m4956]
  (clojure.core/let
   [bean4955
    (new
     com.amazonaws.services.rds.model.DescribeDBEngineVersionsRequest)]
   (clojure.core/when-let
    [v4957 (:marker m4956)]
    (. bean4955 setMarker (clojure.core/str v4957)))
   (clojure.core/when-let
    [v4957 (:max-records m4956)]
    (. bean4955 setMaxRecords (clojure.core/int v4957)))
   (clojure.core/when-let
    [v4957 (:engine m4956)]
    (. bean4955 setEngine (clojure.core/str v4957)))
   (clojure.core/when-let
    [v4957 (:engine-version m4956)]
    (. bean4955 setEngineVersion (clojure.core/str v4957)))
   (clojure.core/when-let
    [v4957 (:dbparameter-group-family m4956)]
    (. bean4955 setDBParameterGroupFamily (clojure.core/str v4957)))
   (clojure.core/when-let
    [v4957 (:default-only m4956)]
    (. bean4955 setDefaultOnly (clojure.core/boolean v4957)))
   (clojure.core/when-let
    [v4957 (:list-supported-character-sets m4956)]
    (.
     bean4955
     setListSupportedCharacterSets
     (clojure.core/boolean v4957)))
   bean4955))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RebootDBInstanceRequest}
reboot-dbinstance-request
  [m4959]
  (clojure.core/let
   [bean4958
    (new com.amazonaws.services.rds.model.RebootDBInstanceRequest)]
   (clojure.core/when-let
    [v4960 (:dbinstance-identifier m4959)]
    (. bean4958 setDBInstanceIdentifier (clojure.core/str v4960)))
   (clojure.core/when-let
    [v4960 (:force-failover m4959)]
    (. bean4958 setForceFailover (clojure.core/boolean v4960)))
   bean4958))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeOptionGroupOptionsRequest}
describe-option-group-options-request
  [m4962]
  (clojure.core/let
   [bean4961
    (new
     com.amazonaws.services.rds.model.DescribeOptionGroupOptionsRequest)]
   (clojure.core/when-let
    [v4963 (:marker m4962)]
    (. bean4961 setMarker (clojure.core/str v4963)))
   (clojure.core/when-let
    [v4963 (:max-records m4962)]
    (. bean4961 setMaxRecords (clojure.core/int v4963)))
   (clojure.core/when-let
    [v4963 (:engine-name m4962)]
    (. bean4961 setEngineName (clojure.core/str v4963)))
   (clojure.core/when-let
    [v4963 (:major-engine-version m4962)]
    (. bean4961 setMajorEngineVersion (clojure.core/str v4963)))
   bean4961))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBInstanceRequest}
create-dbinstance-request
  [m4965]
  (clojure.core/let
   [bean4964
    (new com.amazonaws.services.rds.model.CreateDBInstanceRequest)]
   (clojure.core/when-let
    [v4966 (:vpc-security-group-ids m4965)]
    (.
     bean4964
     setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5032] (clojure.core/str arg5032))
 v4966)))
   (clojure.core/when-let
    [v4966 (:dbparameter-group-name m4965)]
    (. bean4964 setDBParameterGroupName (clojure.core/str v4966)))
   (clojure.core/when-let
    [v4966 (:port m4965)]
    (. bean4964 setPort (clojure.core/int v4966)))
   (clojure.core/when-let
    [v4966 (:dbinstance-class m4965)]
    (. bean4964 setDBInstanceClass (clojure.core/str v4966)))
   (clojure.core/when-let
    [v4966 (:preferred-maintenance-window m4965)]
    (.
     bean4964
     setPreferredMaintenanceWindow
     (clojure.core/str v4966)))
   (clojure.core/when-let
    [v4966 (:engine m4965)]
    (. bean4964 setEngine (clojure.core/str v4966)))
   (clojure.core/when-let
    [v4966 (:character-set-name m4965)]
    (. bean4964 setCharacterSetName (clojure.core/str v4966)))
   (clojure.core/when-let
    [v4966 (:auto-minor-version-upgrade m4965)]
    (.
     bean4964
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v4966)))
   (clojure.core/when-let
    [v4966 (:availability-zone m4965)]
    (. bean4964 setAvailabilityZone (clojure.core/str v4966)))
   (clojure.core/when-let
    [v4966 (:license-model m4965)]
    (. bean4964 setLicenseModel (clojure.core/str v4966)))
   (clojure.core/when-let
    [v4966 (:master-user-password m4965)]
    (. bean4964 setMasterUserPassword (clojure.core/str v4966)))
   (clojure.core/when-let
    [v4966 (:iops m4965)]
    (. bean4964 setIops (clojure.core/int v4966)))
   (clojure.core/when-let
    [v4966 (:dbname m4965)]
    (. bean4964 setDBName (clojure.core/str v4966)))
   (clojure.core/when-let
    [v4966 (:dbsubnet-group-name m4965)]
    (. bean4964 setDBSubnetGroupName (clojure.core/str v4966)))
   (clojure.core/when-let
    [v4966 (:publicly-accessible m4965)]
    (. bean4964 setPubliclyAccessible (clojure.core/boolean v4966)))
   (clojure.core/when-let
    [v4966 (:multi-az m4965)]
    (. bean4964 setMultiAZ (clojure.core/boolean v4966)))
   (clojure.core/when-let
    [v4966 (:preferred-backup-window m4965)]
    (. bean4964 setPreferredBackupWindow (clojure.core/str v4966)))
   (clojure.core/when-let
    [v4966 (:option-group-name m4965)]
    (. bean4964 setOptionGroupName (clojure.core/str v4966)))
   (clojure.core/when-let
    [v4966 (:dbsecurity-groups m4965)]
    (.
     bean4964
     setDBSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5033] (clojure.core/str arg5033))
 v4966)))
   (clojure.core/when-let
    [v4966 (:engine-version m4965)]
    (. bean4964 setEngineVersion (clojure.core/str v4966)))
   (clojure.core/when-let
    [v4966 (:allocated-storage m4965)]
    (. bean4964 setAllocatedStorage (clojure.core/int v4966)))
   (clojure.core/when-let
    [v4966 (:master-username m4965)]
    (. bean4964 setMasterUsername (clojure.core/str v4966)))
   (clojure.core/when-let
    [v4966 (:backup-retention-period m4965)]
    (. bean4964 setBackupRetentionPeriod (clojure.core/int v4966)))
   (clojure.core/when-let
    [v4966 (:tags m4965)]
    (.
     bean4964
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5034] (rds/tag arg5034)) v4966)))
   (clojure.core/when-let
    [v4966 (:dbinstance-identifier m4965)]
    (. bean4964 setDBInstanceIdentifier (clojure.core/str v4966)))
   bean4964))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBSubnetGroupsRequest}
describe-dbsubnet-groups-request
  [m4968]
  (clojure.core/let
   [bean4967
    (new
     com.amazonaws.services.rds.model.DescribeDBSubnetGroupsRequest)]
   (clojure.core/when-let
    [v4969 (:marker m4968)]
    (. bean4967 setMarker (clojure.core/str v4969)))
   (clojure.core/when-let
    [v4969 (:max-records m4968)]
    (. bean4967 setMaxRecords (clojure.core/int v4969)))
   (clojure.core/when-let
    [v4969 (:filters m4968)]
    (.
     bean4967
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5035] (rds/filter arg5035))
 v4969)))
   (clojure.core/when-let
    [v4969 (:dbsubnet-group-name m4968)]
    (. bean4967 setDBSubnetGroupName (clojure.core/str v4969)))
   bean4967))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteEventSubscriptionRequest}
delete-event-subscription-request
  [m4971]
  (clojure.core/let
   [bean4970
    (new
     com.amazonaws.services.rds.model.DeleteEventSubscriptionRequest)]
   (clojure.core/when-let
    [v4972 (:subscription-name m4971)]
    (. bean4970 setSubscriptionName (clojure.core/str v4972)))
   bean4970))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBParameterGroupsRequest}
describe-dbparameter-groups-request
  [m4974]
  (clojure.core/let
   [bean4973
    (new
     com.amazonaws.services.rds.model.DescribeDBParameterGroupsRequest)]
   (clojure.core/when-let
    [v4975 (:marker m4974)]
    (. bean4973 setMarker (clojure.core/str v4975)))
   (clojure.core/when-let
    [v4975 (:max-records m4974)]
    (. bean4973 setMaxRecords (clojure.core/int v4975)))
   (clojure.core/when-let
    [v4975 (:filters m4974)]
    (.
     bean4973
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5036] (rds/filter arg5036))
 v4975)))
   (clojure.core/when-let
    [v4975 (:dbparameter-group-name m4974)]
    (. bean4973 setDBParameterGroupName (clojure.core/str v4975)))
   bean4973))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ResetDBParameterGroupRequest}
reset-dbparameter-group-request
  [m4977]
  (clojure.core/let
   [bean4976
    (new
     com.amazonaws.services.rds.model.ResetDBParameterGroupRequest)]
   (clojure.core/when-let
    [v4978 (:reset-all-parameters m4977)]
    (. bean4976 setResetAllParameters (clojure.core/boolean v4978)))
   (clojure.core/when-let
    [v4978 (:parameters m4977)]
    (.
     bean4976
     setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5037] (rds/parameter arg5037))
 v4978)))
   (clojure.core/when-let
    [v4978 (:dbparameter-group-name m4977)]
    (. bean4976 setDBParameterGroupName (clojure.core/str v4978)))
   bean4976))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest}
restore-dbinstance-to-point-in-time-request
  [m4980]
  (clojure.core/let
   [bean4979
    (new
     com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest)]
   (clojure.core/when-let
    [v4981 (:port m4980)]
    (. bean4979 setPort (clojure.core/int v4981)))
   (clojure.core/when-let
    [v4981 (:dbinstance-class m4980)]
    (. bean4979 setDBInstanceClass (clojure.core/str v4981)))
   (clojure.core/when-let
    [v4981 (:engine m4980)]
    (. bean4979 setEngine (clojure.core/str v4981)))
   (clojure.core/when-let
    [v4981 (:auto-minor-version-upgrade m4980)]
    (.
     bean4979
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v4981)))
   (clojure.core/when-let
    [v4981 (:availability-zone m4980)]
    (. bean4979 setAvailabilityZone (clojure.core/str v4981)))
   (clojure.core/when-let
    [v4981 (:license-model m4980)]
    (. bean4979 setLicenseModel (clojure.core/str v4981)))
   (clojure.core/when-let
    [v4981 (:use-latest-restorable-time m4980)]
    (.
     bean4979
     setUseLatestRestorableTime
     (clojure.core/boolean v4981)))
   (clojure.core/when-let
    [v4981 (:iops m4980)]
    (. bean4979 setIops (clojure.core/int v4981)))
   (clojure.core/when-let
    [v4981 (:dbname m4980)]
    (. bean4979 setDBName (clojure.core/str v4981)))
   (clojure.core/when-let
    [v4981 (:dbsubnet-group-name m4980)]
    (. bean4979 setDBSubnetGroupName (clojure.core/str v4981)))
   (clojure.core/when-let
    [v4981 (:publicly-accessible m4980)]
    (. bean4979 setPubliclyAccessible (clojure.core/boolean v4981)))
   (clojure.core/when-let
    [v4981 (:target-dbinstance-identifier m4980)]
    (.
     bean4979
     setTargetDBInstanceIdentifier
     (clojure.core/str v4981)))
   (clojure.core/when-let
    [v4981 (:multi-az m4980)]
    (. bean4979 setMultiAZ (clojure.core/boolean v4981)))
   (clojure.core/when-let
    [v4981 (:option-group-name m4980)]
    (. bean4979 setOptionGroupName (clojure.core/str v4981)))
   (clojure.core/when-let
    [v4981 (:restore-time m4980)]
    (.
     bean4979
     setRestoreTime
     (com.palletops.awaze.common/to-date v4981)))
   (clojure.core/when-let
    [v4981 (:source-dbinstance-identifier m4980)]
    (.
     bean4979
     setSourceDBInstanceIdentifier
     (clojure.core/str v4981)))
   (clojure.core/when-let
    [v4981 (:tags m4980)]
    (.
     bean4979
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5038] (rds/tag arg5038)) v4981)))
   bean4979))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest}
modify-dbparameter-group-request
  [m4983]
  (clojure.core/let
   [bean4982
    (new
     com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest)]
   (clojure.core/when-let
    [v4984 (:parameters m4983)]
    (.
     bean4982
     setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5039] (rds/parameter arg5039))
 v4984)))
   (clojure.core/when-let
    [v4984 (:dbparameter-group-name m4983)]
    (. bean4982 setDBParameterGroupName (clojure.core/str v4984)))
   bean4982))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBInstanceRequest}
delete-dbinstance-request
  [m4986]
  (clojure.core/let
   [bean4985
    (new com.amazonaws.services.rds.model.DeleteDBInstanceRequest)]
   (clojure.core/when-let
    [v4987 (:dbinstance-identifier m4986)]
    (. bean4985 setDBInstanceIdentifier (clojure.core/str v4987)))
   (clojure.core/when-let
    [v4987 (:skip-final-snapshot m4986)]
    (. bean4985 setSkipFinalSnapshot (clojure.core/boolean v4987)))
   (clojure.core/when-let
    [v4987 (:final-dbsnapshot-identifier m4986)]
    (. bean4985 setFinalDBSnapshotIdentifier (clojure.core/str v4987)))
   bean4985))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEventCategoriesRequest}
describe-event-categories-request
  [m4989]
  (clojure.core/let
   [bean4988
    (new
     com.amazonaws.services.rds.model.DescribeEventCategoriesRequest)]
   (clojure.core/when-let
    [v4990 (:source-type m4989)]
    (. bean4988 setSourceType (clojure.core/str v4990)))
   bean4988))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest}
authorize-dbsecurity-group-ingress-request
  [m4992]
  (clojure.core/let
   [bean4991
    (new
     com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v4993 (:cidrip m4992)]
    (. bean4991 setCIDRIP (clojure.core/str v4993)))
   (clojure.core/when-let
    [v4993 (:ec2security-group-name m4992)]
    (. bean4991 setEC2SecurityGroupName (clojure.core/str v4993)))
   (clojure.core/when-let
    [v4993 (:ec2security-group-owner-id m4992)]
    (. bean4991 setEC2SecurityGroupOwnerId (clojure.core/str v4993)))
   (clojure.core/when-let
    [v4993 (:dbsecurity-group-name m4992)]
    (. bean4991 setDBSecurityGroupName (clojure.core/str v4993)))
   (clojure.core/when-let
    [v4993 (:ec2security-group-id m4992)]
    (. bean4991 setEC2SecurityGroupId (clojure.core/str v4993)))
   bean4991))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CopyDBSnapshotRequest}
copy-dbsnapshot-request
  [m4995]
  (clojure.core/let
   [bean4994
    (new com.amazonaws.services.rds.model.CopyDBSnapshotRequest)]
   (clojure.core/when-let
    [v4996 (:tags m4995)]
    (.
     bean4994
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5040] (rds/tag arg5040)) v4996)))
   (clojure.core/when-let
    [v4996 (:source-dbsnapshot-identifier m4995)]
    (.
     bean4994
     setSourceDBSnapshotIdentifier
     (clojure.core/str v4996)))
   (clojure.core/when-let
    [v4996 (:target-dbsnapshot-identifier m4995)]
    (.
     bean4994
     setTargetDBSnapshotIdentifier
     (clojure.core/str v4996)))
   bean4994))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBSnapshotRequest}
delete-dbsnapshot-request
  [m4998]
  (clojure.core/let
   [bean4997
    (new com.amazonaws.services.rds.model.DeleteDBSnapshotRequest)]
   (clojure.core/when-let
    [v4999 (:dbsnapshot-identifier m4998)]
    (. bean4997 setDBSnapshotIdentifier (clojure.core/str v4999)))
   bean4997))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest}
create-dbsubnet-group-request
  [m5001]
  (clojure.core/let
   [bean5000
    (new com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest)]
   (clojure.core/when-let
    [v5002 (:subnet-ids m5001)]
    (.
     bean5000
     setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5041] (clojure.core/str arg5041))
 v5002)))
   (clojure.core/when-let
    [v5002 (:tags m5001)]
    (.
     bean5000
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg5042] (rds/tag arg5042)) v5002)))
   (clojure.core/when-let
    [v5002 (:dbsubnet-group-name m5001)]
    (. bean5000 setDBSubnetGroupName (clojure.core/str v5002)))
   (clojure.core/when-let
    [v5002 (:dbsubnet-group-description m5001)]
    (. bean5000 setDBSubnetGroupDescription (clojure.core/str v5002)))
   bean5000))
 (clojure.core/defmulti
  rds
  (clojure.core/fn rds [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   rds
   :revoke-dbsecurity-group-ingress
   [m5043]
   (clojure.core/let
    [credentials5044 (:credentials m5043) args5045 (:args m5043)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5046
      (com.palletops.awaze.common/aws-client :rds credentials5044)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5046
       revokeDBSecurityGroupIngress
       (rds/revoke-dbsecurity-group-ingress-request
        (clojure.core/nth args5045 0)))))))
  (clojure.core/defn
   revoke-dbsecurity-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cidrip
                         ec2security-group-id
                         ec2security-group-owner-id
                         ec2security-group-name
                         dbsecurity-group-name
                         general-progress-listener]}]]),
    :doc "Generate map for revokeDBSecurityGroupIngress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :revoke-dbsecurity-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   revoke-dbsecurity-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cidrip
                         ec2security-group-id
                         ec2security-group-owner-id
                         ec2security-group-name
                         dbsecurity-group-name
                         general-progress-listener]}]]),
    :doc "Call revokeDBSecurityGroupIngress"}
   [credentials5048 & args5049]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5050
     (com.palletops.awaze.common/aws-client :rds credentials5048)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5050
      revokeDBSecurityGroupIngress
      (rds/revoke-dbsecurity-group-ingress-request
       (clojure.core/nth args5049 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :add-tags-to-resource
   [m5051]
   (clojure.core/let
    [credentials5052 (:credentials m5051) args5053 (:args m5051)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5054
      (com.palletops.awaze.common/aws-client :rds credentials5052)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5054
       addTagsToResource
       (rds/add-tags-to-resource-request
        (clojure.core/nth args5053 0)))))))
  (clojure.core/defn
   add-tags-to-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tags resource-name general-progress-listener]}]]),
    :doc "Generate map for addTagsToResource"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :add-tags-to-resource,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-tags-to-resource
   {:arglists (quote
               [[credentials
                 {:keys [tags resource-name general-progress-listener]}]]),
    :doc "Call addTagsToResource"}
   [credentials5056 & args5057]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5058
     (com.palletops.awaze.common/aws-client :rds credentials5056)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5058
      addTagsToResource
      (rds/add-tags-to-resource-request (clojure.core/nth args5057 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsecurity-groups
   [m5059]
   (clojure.core/let
    [credentials5060 (:credentials m5059) args5061 (:args m5059)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5062
      (com.palletops.awaze.common/aws-client :rds credentials5060)]
     (clojure.core/case
      (clojure.core/count args5061)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5062
        describeDBSecurityGroups
        (rds/describe-dbsecurity-groups-request
         (clojure.core/nth args5061 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5062
        describeDBSecurityGroups))))))
  (clojure.core/defn
   describe-dbsecurity-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbsecurity-group-name]}]
                [credentials]]),
    :doc "Generate map for describeDBSecurityGroups, describeDBSecurityGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbsecurity-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbsecurity-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dbsecurity-groups
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbsecurity-group-name]}]
                [credentials]]),
    :doc "Call describeDBSecurityGroups, describeDBSecurityGroups"}
   [credentials5064 & args5065]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5066
     (com.palletops.awaze.common/aws-client :rds credentials5064)]
    (clojure.core/case
     (clojure.core/count args5065)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5066
       describeDBSecurityGroups
       (rds/describe-dbsecurity-groups-request
        (clojure.core/nth args5065 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5066
       describeDBSecurityGroups))))))
 (do
  (clojure.core/defmethod
   rds
   :purchase-reserved-dbinstances-offering
   [m5067]
   (clojure.core/let
    [credentials5068 (:credentials m5067) args5069 (:args m5067)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5070
      (com.palletops.awaze.common/aws-client :rds credentials5068)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5070
       purchaseReservedDBInstancesOffering
       (rds/purchase-reserved-dbinstances-offering-request
        (clojure.core/nth args5069 0)))))))
  (clojure.core/defn
   purchase-reserved-dbinstances-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         reserved-dbinstances-offering-id
                         reserved-dbinstance-id
                         general-progress-listener
                         dbinstance-count]}]]),
    :doc "Generate map for purchaseReservedDBInstancesOffering"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :purchase-reserved-dbinstances-offering,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   purchase-reserved-dbinstances-offering
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         reserved-dbinstances-offering-id
                         reserved-dbinstance-id
                         general-progress-listener
                         dbinstance-count]}]]),
    :doc "Call purchaseReservedDBInstancesOffering"}
   [credentials5072 & args5073]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5074
     (com.palletops.awaze.common/aws-client :rds credentials5072)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5074
      purchaseReservedDBInstancesOffering
      (rds/purchase-reserved-dbinstances-offering-request
       (clojure.core/nth args5073 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbparameters
   [m5075]
   (clojure.core/let
    [credentials5076 (:credentials m5075) args5077 (:args m5075)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5078
      (com.palletops.awaze.common/aws-client :rds credentials5076)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5078
       describeDBParameters
       (rds/describe-dbparameters-request
        (clojure.core/nth args5077 0)))))))
  (clojure.core/defn
   describe-dbparameters-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         max-records
                         marker
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Generate map for describeDBParameters"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbparameters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dbparameters
   {:arglists (quote
               [[credentials
                 {:keys [source
                         max-records
                         marker
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Call describeDBParameters"}
   [credentials5080 & args5081]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5082
     (com.palletops.awaze.common/aws-client :rds credentials5080)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5082
      describeDBParameters
      (rds/describe-dbparameters-request
       (clojure.core/nth args5081 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-option-groups
   [m5083]
   (clojure.core/let
    [credentials5084 (:credentials m5083) args5085 (:args m5083)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5086
      (com.palletops.awaze.common/aws-client :rds credentials5084)]
     (clojure.core/case
      (clojure.core/count args5085)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5086
        describeOptionGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5086
        describeOptionGroups
        (rds/describe-option-groups-request
         (clojure.core/nth args5085 0))))))))
  (clojure.core/defn
   describe-option-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         engine-name
                         major-engine-version
                         max-records
                         marker
                         option-group-name]}]]),
    :doc "Generate map for describeOptionGroups, describeOptionGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-option-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-option-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-option-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         engine-name
                         major-engine-version
                         max-records
                         marker
                         option-group-name]}]]),
    :doc "Call describeOptionGroups, describeOptionGroups"}
   [credentials5088 & args5089]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5090
     (com.palletops.awaze.common/aws-client :rds credentials5088)]
    (clojure.core/case
     (clojure.core/count args5089)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5090
       describeOptionGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5090
       describeOptionGroups
       (rds/describe-option-groups-request
        (clojure.core/nth args5089 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbinstance-read-replica
   [m5091]
   (clojure.core/let
    [credentials5092 (:credentials m5091) args5093 (:args m5091)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5094
      (com.palletops.awaze.common/aws-client :rds credentials5092)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5094
       createDBInstanceReadReplica
       (rds/create-dbinstance-read-replica-request
        (clojure.core/nth args5093 0)))))))
  (clojure.core/defn
   create-dbinstance-read-replica-map
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         iops
                         general-progress-listener
                         availability-zone
                         dbinstance-class
                         port
                         dbsubnet-group-name
                         dbinstance-identifier
                         source-dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Generate map for createDBInstanceReadReplica"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbinstance-read-replica,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-dbinstance-read-replica
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         iops
                         general-progress-listener
                         availability-zone
                         dbinstance-class
                         port
                         dbsubnet-group-name
                         dbinstance-identifier
                         source-dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Call createDBInstanceReadReplica"}
   [credentials5096 & args5097]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5098
     (com.palletops.awaze.common/aws-client :rds credentials5096)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5098
      createDBInstanceReadReplica
      (rds/create-dbinstance-read-replica-request
       (clojure.core/nth args5097 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :restore-dbinstance-from-dbsnapshot
   [m5099]
   (clojure.core/let
    [credentials5100 (:credentials m5099) args5101 (:args m5099)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5102
      (com.palletops.awaze.common/aws-client :rds credentials5100)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5102
       restoreDBInstanceFromDBSnapshot
       (rds/restore-dbinstance-from-dbsnapshot-request
        (clojure.core/nth args5101 0)))))))
  (clojure.core/defn
   restore-dbinstance-from-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         dbsnapshot-identifier
                         iops
                         engine
                         general-progress-listener
                         availability-zone
                         dbname
                         dbinstance-class
                         port
                         license-model
                         dbsubnet-group-name
                         multi-az
                         dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Generate map for restoreDBInstanceFromDBSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :restore-dbinstance-from-dbsnapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   restore-dbinstance-from-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         dbsnapshot-identifier
                         iops
                         engine
                         general-progress-listener
                         availability-zone
                         dbname
                         dbinstance-class
                         port
                         license-model
                         dbsubnet-group-name
                         multi-az
                         dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Call restoreDBInstanceFromDBSnapshot"}
   [credentials5104 & args5105]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5106
     (com.palletops.awaze.common/aws-client :rds credentials5104)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5106
      restoreDBInstanceFromDBSnapshot
      (rds/restore-dbinstance-from-dbsnapshot-request
       (clojure.core/nth args5105 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbparameter-group
   [m5107]
   (clojure.core/let
    [credentials5108 (:credentials m5107) args5109 (:args m5107)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5110
      (com.palletops.awaze.common/aws-client :rds credentials5108)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5110
       deleteDBParameterGroup
       (rds/delete-dbparameter-group-request
        (clojure.core/nth args5109 0)))))))
  (clojure.core/defn
   delete-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Generate map for deleteDBParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbparameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Call deleteDBParameterGroup"}
   [credentials5112 & args5113]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5114
     (com.palletops.awaze.common/aws-client :rds credentials5112)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5114
      deleteDBParameterGroup
      (rds/delete-dbparameter-group-request
       (clojure.core/nth args5113 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-reserved-dbinstances
   [m5115]
   (clojure.core/let
    [credentials5116 (:credentials m5115) args5117 (:args m5115)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5118
      (com.palletops.awaze.common/aws-client :rds credentials5116)]
     (clojure.core/case
      (clojure.core/count args5117)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5118
        describeReservedDBInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5118
        describeReservedDBInstances
        (rds/describe-reserved-dbinstances-request
         (clojure.core/nth args5117 0))))))))
  (clojure.core/defn
   describe-reserved-dbinstances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration
                         general-progress-listener
                         filters
                         reserved-dbinstances-offering-id
                         reserved-dbinstance-id
                         max-records
                         dbinstance-class
                         marker
                         product-description
                         offering-type
                         multi-az]}]]),
    :doc "Generate map for describeReservedDBInstances, describeReservedDBInstances"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-reserved-dbinstances,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-reserved-dbinstances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-dbinstances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration
                         general-progress-listener
                         filters
                         reserved-dbinstances-offering-id
                         reserved-dbinstance-id
                         max-records
                         dbinstance-class
                         marker
                         product-description
                         offering-type
                         multi-az]}]]),
    :doc "Call describeReservedDBInstances, describeReservedDBInstances"}
   [credentials5120 & args5121]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5122
     (com.palletops.awaze.common/aws-client :rds credentials5120)]
    (clojure.core/case
     (clojure.core/count args5121)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5122
       describeReservedDBInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5122
       describeReservedDBInstances
       (rds/describe-reserved-dbinstances-request
        (clojure.core/nth args5121 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbsecurity-group
   [m5123]
   (clojure.core/let
    [credentials5124 (:credentials m5123) args5125 (:args m5123)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5126
      (com.palletops.awaze.common/aws-client :rds credentials5124)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5126
       deleteDBSecurityGroup
       (rds/delete-dbsecurity-group-request
        (clojure.core/nth args5125 0)))))))
  (clojure.core/defn
   delete-dbsecurity-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsecurity-group-name]}]]),
    :doc "Generate map for deleteDBSecurityGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbsecurity-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-dbsecurity-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsecurity-group-name]}]]),
    :doc "Call deleteDBSecurityGroup"}
   [credentials5128 & args5129]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5130
     (com.palletops.awaze.common/aws-client :rds credentials5128)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5130
      deleteDBSecurityGroup
      (rds/delete-dbsecurity-group-request
       (clojure.core/nth args5129 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-engine-default-parameters
   [m5131]
   (clojure.core/let
    [credentials5132 (:credentials m5131) args5133 (:args m5131)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5134
      (com.palletops.awaze.common/aws-client :rds credentials5132)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5134
       describeEngineDefaultParameters
       (rds/describe-engine-default-parameters-request
        (clojure.core/nth args5133 0)))))))
  (clojure.core/defn
   describe-engine-default-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         dbparameter-group-family]}]]),
    :doc "Generate map for describeEngineDefaultParameters"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-engine-default-parameters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-engine-default-parameters
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         dbparameter-group-family]}]]),
    :doc "Call describeEngineDefaultParameters"}
   [credentials5136 & args5137]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5138
     (com.palletops.awaze.common/aws-client :rds credentials5136)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5138
      describeEngineDefaultParameters
      (rds/describe-engine-default-parameters-request
       (clojure.core/nth args5137 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbparameter-group
   [m5139]
   (clojure.core/let
    [credentials5140 (:credentials m5139) args5141 (:args m5139)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5142
      (com.palletops.awaze.common/aws-client :rds credentials5140)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5142
       createDBParameterGroup
       (rds/create-dbparameter-group-request
        (clojure.core/nth args5141 0)))))))
  (clojure.core/defn
   create-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         description
                         dbparameter-group-name
                         dbparameter-group-family]}]]),
    :doc "Generate map for createDBParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbparameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         description
                         dbparameter-group-name
                         dbparameter-group-family]}]]),
    :doc "Call createDBParameterGroup"}
   [credentials5144 & args5145]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5146
     (com.palletops.awaze.common/aws-client :rds credentials5144)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5146
      createDBParameterGroup
      (rds/create-dbparameter-group-request
       (clojure.core/nth args5145 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-event-subscription
   [m5147]
   (clojure.core/let
    [credentials5148 (:credentials m5147) args5149 (:args m5147)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5150
      (com.palletops.awaze.common/aws-client :rds credentials5148)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5150
       createEventSubscription
       (rds/create-event-subscription-request
        (clojure.core/nth args5149 0)))))))
  (clojure.core/defn
   create-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         tags]}]]),
    :doc "Generate map for createEventSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-event-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         tags]}]]),
    :doc "Call createEventSubscription"}
   [credentials5152 & args5153]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5154
     (com.palletops.awaze.common/aws-client :rds credentials5152)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5154
      createEventSubscription
      (rds/create-event-subscription-request
       (clojure.core/nth args5153 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbsecurity-group
   [m5155]
   (clojure.core/let
    [credentials5156 (:credentials m5155) args5157 (:args m5155)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5158
      (com.palletops.awaze.common/aws-client :rds credentials5156)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5158
       createDBSecurityGroup
       (rds/create-dbsecurity-group-request
        (clojure.core/nth args5157 0)))))))
  (clojure.core/defn
   create-dbsecurity-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         dbsecurity-group-name
                         dbsecurity-group-description]}]]),
    :doc "Generate map for createDBSecurityGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbsecurity-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-dbsecurity-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         dbsecurity-group-name
                         dbsecurity-group-description]}]]),
    :doc "Call createDBSecurityGroup"}
   [credentials5160 & args5161]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5162
     (com.palletops.awaze.common/aws-client :rds credentials5160)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5162
      createDBSecurityGroup
      (rds/create-dbsecurity-group-request
       (clojure.core/nth args5161 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-event-subscription
   [m5163]
   (clojure.core/let
    [credentials5164 (:credentials m5163) args5165 (:args m5163)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5166
      (com.palletops.awaze.common/aws-client :rds credentials5164)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5166
       modifyEventSubscription
       (rds/modify-event-subscription-request
        (clojure.core/nth args5165 0)))))))
  (clojure.core/defn
   modify-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [source-type
                         subscription-name
                         event-categories
                         general-progress-listener
                         sns-topic-arn
                         enabled]}]]),
    :doc "Generate map for modifyEventSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-event-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [source-type
                         subscription-name
                         event-categories
                         general-progress-listener
                         sns-topic-arn
                         enabled]}]]),
    :doc "Call modifyEventSubscription"}
   [credentials5168 & args5169]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5170
     (com.palletops.awaze.common/aws-client :rds credentials5168)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5170
      modifyEventSubscription
      (rds/modify-event-subscription-request
       (clojure.core/nth args5169 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-option-group
   [m5171]
   (clojure.core/let
    [credentials5172 (:credentials m5171) args5173 (:args m5171)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5174
      (com.palletops.awaze.common/aws-client :rds credentials5172)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5174
       deleteOptionGroup
       (rds/delete-option-group-request (clojure.core/nth args5173 0)))))))
  (clojure.core/defn
   delete-option-group-map
   {:arglists (quote
               [[credentials
                 {:keys [option-group-name general-progress-listener]}]]),
    :doc "Generate map for deleteOptionGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-option-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-option-group
   {:arglists (quote
               [[credentials
                 {:keys [option-group-name general-progress-listener]}]]),
    :doc "Call deleteOptionGroup"}
   [credentials5176 & args5177]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5178
     (com.palletops.awaze.common/aws-client :rds credentials5176)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5178
      deleteOptionGroup
      (rds/delete-option-group-request (clojure.core/nth args5177 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :download-dblog-file-portion
   [m5179]
   (clojure.core/let
    [credentials5180 (:credentials m5179) args5181 (:args m5179)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5182
      (com.palletops.awaze.common/aws-client :rds credentials5180)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5182
       downloadDBLogFilePortion
       (rds/download-dblog-file-portion-request
        (clojure.core/nth args5181 0)))))))
  (clojure.core/defn
   download-dblog-file-portion-map
   {:arglists (quote
               [[credentials
                 {:keys [number-of-lines
                         marker
                         log-file-name
                         general-progress-listener
                         dbinstance-identifier]}]]),
    :doc "Generate map for downloadDBLogFilePortion"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :download-dblog-file-portion,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   download-dblog-file-portion
   {:arglists (quote
               [[credentials
                 {:keys [number-of-lines
                         marker
                         log-file-name
                         general-progress-listener
                         dbinstance-identifier]}]]),
    :doc "Call downloadDBLogFilePortion"}
   [credentials5184 & args5185]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5186
     (com.palletops.awaze.common/aws-client :rds credentials5184)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5186
      downloadDBLogFilePortion
      (rds/download-dblog-file-portion-request
       (clojure.core/nth args5185 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-events
   [m5187]
   (clojure.core/let
    [credentials5188 (:credentials m5187) args5189 (:args m5187)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5190
      (com.palletops.awaze.common/aws-client :rds credentials5188)]
     (clojure.core/case
      (clojure.core/count args5189)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5190
        describeEvents
        (rds/describe-events-request (clojure.core/nth args5189 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5190
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         source-type
                         duration
                         event-categories
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-events,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-events,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         source-type
                         duration
                         event-categories
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials5192 & args5193]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5194
     (com.palletops.awaze.common/aws-client :rds credentials5192)]
    (clojure.core/case
     (clojure.core/count args5193)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5194
       describeEvents
       (rds/describe-events-request (clojure.core/nth args5193 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5194
       describeEvents))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-reserved-dbinstances-offerings
   [m5195]
   (clojure.core/let
    [credentials5196 (:credentials m5195) args5197 (:args m5195)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5198
      (com.palletops.awaze.common/aws-client :rds credentials5196)]
     (clojure.core/case
      (clojure.core/count args5197)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5198
        describeReservedDBInstancesOfferings
        (rds/describe-reserved-dbinstances-offerings-request
         (clojure.core/nth args5197 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5198
        describeReservedDBInstancesOfferings))))))
  (clojure.core/defn
   describe-reserved-dbinstances-offerings-map
   {:arglists (quote
               [[credentials
                 {:keys [duration
                         general-progress-listener
                         reserved-dbinstances-offering-id
                         max-records
                         dbinstance-class
                         marker
                         product-description
                         offering-type
                         multi-az]}]
                [credentials]]),
    :doc "Generate map for describeReservedDBInstancesOfferings, describeReservedDBInstancesOfferings"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-reserved-dbinstances-offerings,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-reserved-dbinstances-offerings,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-dbinstances-offerings
   {:arglists (quote
               [[credentials
                 {:keys [duration
                         general-progress-listener
                         reserved-dbinstances-offering-id
                         max-records
                         dbinstance-class
                         marker
                         product-description
                         offering-type
                         multi-az]}]
                [credentials]]),
    :doc "Call describeReservedDBInstancesOfferings, describeReservedDBInstancesOfferings"}
   [credentials5200 & args5201]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5202
     (com.palletops.awaze.common/aws-client :rds credentials5200)]
    (clojure.core/case
     (clojure.core/count args5201)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5202
       describeReservedDBInstancesOfferings
       (rds/describe-reserved-dbinstances-offerings-request
        (clojure.core/nth args5201 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5202
       describeReservedDBInstancesOfferings))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-option-group
   [m5203]
   (clojure.core/let
    [credentials5204 (:credentials m5203) args5205 (:args m5203)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5206
      (com.palletops.awaze.common/aws-client :rds credentials5204)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5206
       modifyOptionGroup
       (rds/modify-option-group-request (clojure.core/nth args5205 0)))))))
  (clojure.core/defn
   modify-option-group-map
   {:arglists (quote
               [[credentials
                 {:keys [options-to-remove
                         options-to-include
                         option-group-name
                         general-progress-listener
                         apply-immediately]}]]),
    :doc "Generate map for modifyOptionGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-option-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-option-group
   {:arglists (quote
               [[credentials
                 {:keys [options-to-remove
                         options-to-include
                         option-group-name
                         general-progress-listener
                         apply-immediately]}]]),
    :doc "Call modifyOptionGroup"}
   [credentials5208 & args5209]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5210
     (com.palletops.awaze.common/aws-client :rds credentials5208)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5210
      modifyOptionGroup
      (rds/modify-option-group-request (clojure.core/nth args5209 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbinstances
   [m5211]
   (clojure.core/let
    [credentials5212 (:credentials m5211) args5213 (:args m5211)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5214
      (com.palletops.awaze.common/aws-client :rds credentials5212)]
     (clojure.core/case
      (clojure.core/count args5213)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5214
        describeDBInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5214
        describeDBInstances
        (rds/describe-dbinstances-request
         (clojure.core/nth args5213 0))))))))
  (clojure.core/defn
   describe-dbinstances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbinstance-identifier]}]]),
    :doc "Generate map for describeDBInstances, describeDBInstances"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbinstances,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbinstances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dbinstances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbinstance-identifier]}]]),
    :doc "Call describeDBInstances, describeDBInstances"}
   [credentials5216 & args5217]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5218
     (com.palletops.awaze.common/aws-client :rds credentials5216)]
    (clojure.core/case
     (clojure.core/count args5217)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5218
       describeDBInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5218
       describeDBInstances
       (rds/describe-dbinstances-request
        (clojure.core/nth args5217 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbsnapshot
   [m5219]
   (clojure.core/let
    [credentials5220 (:credentials m5219) args5221 (:args m5219)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5222
      (com.palletops.awaze.common/aws-client :rds credentials5220)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5222
       createDBSnapshot
       (rds/create-dbsnapshot-request (clojure.core/nth args5221 0)))))))
  (clojure.core/defn
   create-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         dbsnapshot-identifier
                         dbinstance-identifier]}]]),
    :doc "Generate map for createDBSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbsnapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         general-progress-listener
                         dbsnapshot-identifier
                         dbinstance-identifier]}]]),
    :doc "Call createDBSnapshot"}
   [credentials5224 & args5225]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5226
     (com.palletops.awaze.common/aws-client :rds credentials5224)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5226
      createDBSnapshot
      (rds/create-dbsnapshot-request (clojure.core/nth args5225 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :remove-source-identifier-from-subscription
   [m5227]
   (clojure.core/let
    [credentials5228 (:credentials m5227) args5229 (:args m5227)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5230
      (com.palletops.awaze.common/aws-client :rds credentials5228)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5230
       removeSourceIdentifierFromSubscription
       (rds/remove-source-identifier-from-subscription-request
        (clojure.core/nth args5229 0)))))))
  (clojure.core/defn
   remove-source-identifier-from-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         source-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for removeSourceIdentifierFromSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :remove-source-identifier-from-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   remove-source-identifier-from-subscription
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         source-identifier
                         general-progress-listener]}]]),
    :doc "Call removeSourceIdentifierFromSubscription"}
   [credentials5232 & args5233]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5234
     (com.palletops.awaze.common/aws-client :rds credentials5232)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5234
      removeSourceIdentifierFromSubscription
      (rds/remove-source-identifier-from-subscription-request
       (clojure.core/nth args5233 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-option-group
   [m5235]
   (clojure.core/let
    [credentials5236 (:credentials m5235) args5237 (:args m5235)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5238
      (com.palletops.awaze.common/aws-client :rds credentials5236)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5238
       createOptionGroup
       (rds/create-option-group-request (clojure.core/nth args5237 0)))))))
  (clojure.core/defn
   create-option-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         major-engine-version
                         engine-name
                         option-group-name
                         general-progress-listener
                         option-group-description]}]]),
    :doc "Generate map for createOptionGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-option-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-option-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         major-engine-version
                         engine-name
                         option-group-name
                         general-progress-listener
                         option-group-description]}]]),
    :doc "Call createOptionGroup"}
   [credentials5240 & args5241]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5242
     (com.palletops.awaze.common/aws-client :rds credentials5240)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5242
      createOptionGroup
      (rds/create-option-group-request (clojure.core/nth args5241 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-event-subscriptions
   [m5243]
   (clojure.core/let
    [credentials5244 (:credentials m5243) args5245 (:args m5243)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5246
      (com.palletops.awaze.common/aws-client :rds credentials5244)]
     (clojure.core/case
      (clojure.core/count args5245)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5246
        describeEventSubscriptions
        (rds/describe-event-subscriptions-request
         (clojure.core/nth args5245 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5246
        describeEventSubscriptions))))))
  (clojure.core/defn
   describe-event-subscriptions-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         max-records
                         marker
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeEventSubscriptions, describeEventSubscriptions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-event-subscriptions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-event-subscriptions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-event-subscriptions
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         max-records
                         marker
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeEventSubscriptions, describeEventSubscriptions"}
   [credentials5248 & args5249]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5250
     (com.palletops.awaze.common/aws-client :rds credentials5248)]
    (clojure.core/case
     (clojure.core/count args5249)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5250
       describeEventSubscriptions
       (rds/describe-event-subscriptions-request
        (clojure.core/nth args5249 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5250
       describeEventSubscriptions))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-orderable-dbinstance-options
   [m5251]
   (clojure.core/let
    [credentials5252 (:credentials m5251) args5253 (:args m5251)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5254
      (com.palletops.awaze.common/aws-client :rds credentials5252)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5254
       describeOrderableDBInstanceOptions
       (rds/describe-orderable-dbinstance-options-request
        (clojure.core/nth args5253 0)))))))
  (clojure.core/defn
   describe-orderable-dbinstance-options-map
   {:arglists (quote
               [[credentials
                 {:keys [engine
                         general-progress-listener
                         max-records
                         dbinstance-class
                         vpc
                         marker
                         license-model
                         engine-version]}]]),
    :doc "Generate map for describeOrderableDBInstanceOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-orderable-dbinstance-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-orderable-dbinstance-options
   {:arglists (quote
               [[credentials
                 {:keys [engine
                         general-progress-listener
                         max-records
                         dbinstance-class
                         vpc
                         marker
                         license-model
                         engine-version]}]]),
    :doc "Call describeOrderableDBInstanceOptions"}
   [credentials5256 & args5257]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5258
     (com.palletops.awaze.common/aws-client :rds credentials5256)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5258
      describeOrderableDBInstanceOptions
      (rds/describe-orderable-dbinstance-options-request
       (clojure.core/nth args5257 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :list-tags-for-resource
   [m5259]
   (clojure.core/let
    [credentials5260 (:credentials m5259) args5261 (:args m5259)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5262
      (com.palletops.awaze.common/aws-client :rds credentials5260)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5262
       listTagsForResource
       (rds/list-tags-for-resource-request
        (clojure.core/nth args5261 0)))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [resource-name general-progress-listener]}]]),
    :doc "Generate map for listTagsForResource"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :list-tags-for-resource,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [resource-name general-progress-listener]}]]),
    :doc "Call listTagsForResource"}
   [credentials5264 & args5265]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5266
     (com.palletops.awaze.common/aws-client :rds credentials5264)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5266
      listTagsForResource
      (rds/list-tags-for-resource-request
       (clojure.core/nth args5265 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbsubnet-group
   [m5267]
   (clojure.core/let
    [credentials5268 (:credentials m5267) args5269 (:args m5267)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5270
      (com.palletops.awaze.common/aws-client :rds credentials5268)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5270
       modifyDBSubnetGroup
       (rds/modify-dbsubnet-group-request
        (clojure.core/nth args5269 0)))))))
  (clojure.core/defn
   modify-dbsubnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         dbsubnet-group-name
                         dbsubnet-group-description]}]]),
    :doc "Generate map for modifyDBSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-dbsubnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-dbsubnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         dbsubnet-group-name
                         dbsubnet-group-description]}]]),
    :doc "Call modifyDBSubnetGroup"}
   [credentials5272 & args5273]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5274
     (com.palletops.awaze.common/aws-client :rds credentials5272)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5274
      modifyDBSubnetGroup
      (rds/modify-dbsubnet-group-request
       (clojure.core/nth args5273 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dblog-files
   [m5275]
   (clojure.core/let
    [credentials5276 (:credentials m5275) args5277 (:args m5275)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5278
      (com.palletops.awaze.common/aws-client :rds credentials5276)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5278
       describeDBLogFiles
       (rds/describe-dblog-files-request
        (clojure.core/nth args5277 0)))))))
  (clojure.core/defn
   describe-dblog-files-map
   {:arglists (quote
               [[credentials
                 {:keys [filename-contains
                         general-progress-listener
                         file-last-written
                         max-records
                         file-size
                         marker
                         dbinstance-identifier]}]]),
    :doc "Generate map for describeDBLogFiles"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dblog-files,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dblog-files
   {:arglists (quote
               [[credentials
                 {:keys [filename-contains
                         general-progress-listener
                         file-last-written
                         max-records
                         file-size
                         marker
                         dbinstance-identifier]}]]),
    :doc "Call describeDBLogFiles"}
   [credentials5280 & args5281]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5282
     (com.palletops.awaze.common/aws-client :rds credentials5280)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5282
      describeDBLogFiles
      (rds/describe-dblog-files-request (clojure.core/nth args5281 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :promote-read-replica
   [m5283]
   (clojure.core/let
    [credentials5284 (:credentials m5283) args5285 (:args m5283)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5286
      (com.palletops.awaze.common/aws-client :rds credentials5284)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5286
       promoteReadReplica
       (rds/promote-read-replica-request
        (clojure.core/nth args5285 0)))))))
  (clojure.core/defn
   promote-read-replica-map
   {:arglists (quote
               [[credentials
                 {:keys [preferred-backup-window
                         general-progress-listener
                         backup-retention-period
                         dbinstance-identifier]}]]),
    :doc "Generate map for promoteReadReplica"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :promote-read-replica,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   promote-read-replica
   {:arglists (quote
               [[credentials
                 {:keys [preferred-backup-window
                         general-progress-listener
                         backup-retention-period
                         dbinstance-identifier]}]]),
    :doc "Call promoteReadReplica"}
   [credentials5288 & args5289]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5290
     (com.palletops.awaze.common/aws-client :rds credentials5288)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5290
      promoteReadReplica
      (rds/promote-read-replica-request (clojure.core/nth args5289 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbsubnet-group
   [m5291]
   (clojure.core/let
    [credentials5292 (:credentials m5291) args5293 (:args m5291)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5294
      (com.palletops.awaze.common/aws-client :rds credentials5292)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5294
       deleteDBSubnetGroup
       (rds/delete-dbsubnet-group-request
        (clojure.core/nth args5293 0)))))))
  (clojure.core/defn
   delete-dbsubnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsubnet-group-name]}]]),
    :doc "Generate map for deleteDBSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbsubnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-dbsubnet-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsubnet-group-name]}]]),
    :doc "Call deleteDBSubnetGroup"}
   [credentials5296 & args5297]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5298
     (com.palletops.awaze.common/aws-client :rds credentials5296)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5298
      deleteDBSubnetGroup
      (rds/delete-dbsubnet-group-request
       (clojure.core/nth args5297 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsnapshots
   [m5299]
   (clojure.core/let
    [credentials5300 (:credentials m5299) args5301 (:args m5299)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5302
      (com.palletops.awaze.common/aws-client :rds credentials5300)]
     (clojure.core/case
      (clojure.core/count args5301)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5302
        describeDBSnapshots
        (rds/describe-dbsnapshots-request
         (clojure.core/nth args5301 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5302
        describeDBSnapshots))))))
  (clojure.core/defn
   describe-dbsnapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [dbsnapshot-identifier
                         general-progress-listener
                         filters
                         max-records
                         marker
                         dbinstance-identifier
                         snapshot-type]}]
                [credentials]]),
    :doc "Generate map for describeDBSnapshots, describeDBSnapshots"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbsnapshots,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbsnapshots,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dbsnapshots
   {:arglists (quote
               [[credentials
                 {:keys [dbsnapshot-identifier
                         general-progress-listener
                         filters
                         max-records
                         marker
                         dbinstance-identifier
                         snapshot-type]}]
                [credentials]]),
    :doc "Call describeDBSnapshots, describeDBSnapshots"}
   [credentials5304 & args5305]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5306
     (com.palletops.awaze.common/aws-client :rds credentials5304)]
    (clojure.core/case
     (clojure.core/count args5305)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5306
       describeDBSnapshots
       (rds/describe-dbsnapshots-request
        (clojure.core/nth args5305 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5306
       describeDBSnapshots))))))
 (do
  (clojure.core/defmethod
   rds
   :add-source-identifier-to-subscription
   [m5307]
   (clojure.core/let
    [credentials5308 (:credentials m5307) args5309 (:args m5307)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5310
      (com.palletops.awaze.common/aws-client :rds credentials5308)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5310
       addSourceIdentifierToSubscription
       (rds/add-source-identifier-to-subscription-request
        (clojure.core/nth args5309 0)))))))
  (clojure.core/defn
   add-source-identifier-to-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         source-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for addSourceIdentifierToSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :add-source-identifier-to-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-source-identifier-to-subscription
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         source-identifier
                         general-progress-listener]}]]),
    :doc "Call addSourceIdentifierToSubscription"}
   [credentials5312 & args5313]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5314
     (com.palletops.awaze.common/aws-client :rds credentials5312)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5314
      addSourceIdentifierToSubscription
      (rds/add-source-identifier-to-subscription-request
       (clojure.core/nth args5313 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :remove-tags-from-resource
   [m5315]
   (clojure.core/let
    [credentials5316 (:credentials m5315) args5317 (:args m5315)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5318
      (com.palletops.awaze.common/aws-client :rds credentials5316)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5318
       removeTagsFromResource
       (rds/remove-tags-from-resource-request
        (clojure.core/nth args5317 0)))))))
  (clojure.core/defn
   remove-tags-from-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tag-keys
                         resource-name
                         general-progress-listener]}]]),
    :doc "Generate map for removeTagsFromResource"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :remove-tags-from-resource,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   remove-tags-from-resource
   {:arglists (quote
               [[credentials
                 {:keys [tag-keys
                         resource-name
                         general-progress-listener]}]]),
    :doc "Call removeTagsFromResource"}
   [credentials5320 & args5321]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5322
     (com.palletops.awaze.common/aws-client :rds credentials5320)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5322
      removeTagsFromResource
      (rds/remove-tags-from-resource-request
       (clojure.core/nth args5321 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbinstance
   [m5323]
   (clojure.core/let
    [credentials5324 (:credentials m5323) args5325 (:args m5323)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5326
      (com.palletops.awaze.common/aws-client :rds credentials5324)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5326
       modifyDBInstance
       (rds/modify-dbinstance-request (clojure.core/nth args5325 0)))))))
  (clojure.core/defn
   modify-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [iops
                         dbsecurity-groups
                         general-progress-listener
                         backup-retention-period
                         preferred-maintenance-window
                         new-dbinstance-identifier
                         allow-major-version-upgrade
                         preferred-backup-window
                         dbinstance-class
                         master-user-password
                         vpc-security-group-ids
                         dbparameter-group-name
                         apply-immediately
                         engine-version
                         multi-az
                         dbinstance-identifier
                         allocated-storage
                         auto-minor-version-upgrade
                         option-group-name]}]]),
    :doc "Generate map for modifyDBInstance"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-dbinstance,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [iops
                         dbsecurity-groups
                         general-progress-listener
                         backup-retention-period
                         preferred-maintenance-window
                         new-dbinstance-identifier
                         allow-major-version-upgrade
                         preferred-backup-window
                         dbinstance-class
                         master-user-password
                         vpc-security-group-ids
                         dbparameter-group-name
                         apply-immediately
                         engine-version
                         multi-az
                         dbinstance-identifier
                         allocated-storage
                         auto-minor-version-upgrade
                         option-group-name]}]]),
    :doc "Call modifyDBInstance"}
   [credentials5328 & args5329]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5330
     (com.palletops.awaze.common/aws-client :rds credentials5328)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5330
      modifyDBInstance
      (rds/modify-dbinstance-request (clojure.core/nth args5329 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbengine-versions
   [m5331]
   (clojure.core/let
    [credentials5332 (:credentials m5331) args5333 (:args m5331)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5334
      (com.palletops.awaze.common/aws-client :rds credentials5332)]
     (clojure.core/case
      (clojure.core/count args5333)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5334
        describeDBEngineVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5334
        describeDBEngineVersions
        (rds/describe-dbengine-versions-request
         (clojure.core/nth args5333 0))))))))
  (clojure.core/defn
   describe-dbengine-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [dbparameter-group-family
                         list-supported-character-sets
                         engine
                         general-progress-listener
                         max-records
                         marker
                         default-only
                         engine-version]}]]),
    :doc "Generate map for describeDBEngineVersions, describeDBEngineVersions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbengine-versions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbengine-versions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dbengine-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [dbparameter-group-family
                         list-supported-character-sets
                         engine
                         general-progress-listener
                         max-records
                         marker
                         default-only
                         engine-version]}]]),
    :doc "Call describeDBEngineVersions, describeDBEngineVersions"}
   [credentials5336 & args5337]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5338
     (com.palletops.awaze.common/aws-client :rds credentials5336)]
    (clojure.core/case
     (clojure.core/count args5337)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5338
       describeDBEngineVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5338
       describeDBEngineVersions
       (rds/describe-dbengine-versions-request
        (clojure.core/nth args5337 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :reboot-dbinstance
   [m5339]
   (clojure.core/let
    [credentials5340 (:credentials m5339) args5341 (:args m5339)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5342
      (com.palletops.awaze.common/aws-client :rds credentials5340)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5342
       rebootDBInstance
       (rds/reboot-dbinstance-request (clojure.core/nth args5341 0)))))))
  (clojure.core/defn
   reboot-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force-failover
                         dbinstance-identifier]}]]),
    :doc "Generate map for rebootDBInstance"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :reboot-dbinstance,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reboot-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force-failover
                         dbinstance-identifier]}]]),
    :doc "Call rebootDBInstance"}
   [credentials5344 & args5345]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5346
     (com.palletops.awaze.common/aws-client :rds credentials5344)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5346
      rebootDBInstance
      (rds/reboot-dbinstance-request (clojure.core/nth args5345 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-option-group-options
   [m5347]
   (clojure.core/let
    [credentials5348 (:credentials m5347) args5349 (:args m5347)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5350
      (com.palletops.awaze.common/aws-client :rds credentials5348)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5350
       describeOptionGroupOptions
       (rds/describe-option-group-options-request
        (clojure.core/nth args5349 0)))))))
  (clojure.core/defn
   describe-option-group-options-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         major-engine-version
                         general-progress-listener
                         engine-name]}]]),
    :doc "Generate map for describeOptionGroupOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-option-group-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-option-group-options
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         major-engine-version
                         general-progress-listener
                         engine-name]}]]),
    :doc "Call describeOptionGroupOptions"}
   [credentials5352 & args5353]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5354
     (com.palletops.awaze.common/aws-client :rds credentials5352)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5354
      describeOptionGroupOptions
      (rds/describe-option-group-options-request
       (clojure.core/nth args5353 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbinstance
   [m5355]
   (clojure.core/let
    [credentials5356 (:credentials m5355) args5357 (:args m5355)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5358
      (com.palletops.awaze.common/aws-client :rds credentials5356)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5358
       createDBInstance
       (rds/create-dbinstance-request (clojure.core/nth args5357 0)))))))
  (clojure.core/defn
   create-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         iops
                         dbsecurity-groups
                         engine
                         general-progress-listener
                         backup-retention-period
                         availability-zone
                         preferred-maintenance-window
                         master-username
                         dbname
                         preferred-backup-window
                         dbinstance-class
                         master-user-password
                         vpc-security-group-ids
                         port
                         dbparameter-group-name
                         character-set-name
                         license-model
                         dbsubnet-group-name
                         engine-version
                         multi-az
                         dbinstance-identifier
                         allocated-storage
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Generate map for createDBInstance"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbinstance,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         iops
                         dbsecurity-groups
                         engine
                         general-progress-listener
                         backup-retention-period
                         availability-zone
                         preferred-maintenance-window
                         master-username
                         dbname
                         preferred-backup-window
                         dbinstance-class
                         master-user-password
                         vpc-security-group-ids
                         port
                         dbparameter-group-name
                         character-set-name
                         license-model
                         dbsubnet-group-name
                         engine-version
                         multi-az
                         dbinstance-identifier
                         allocated-storage
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Call createDBInstance"}
   [credentials5360 & args5361]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5362
     (com.palletops.awaze.common/aws-client :rds credentials5360)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5362
      createDBInstance
      (rds/create-dbinstance-request (clojure.core/nth args5361 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsubnet-groups
   [m5363]
   (clojure.core/let
    [credentials5364 (:credentials m5363) args5365 (:args m5363)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5366
      (com.palletops.awaze.common/aws-client :rds credentials5364)]
     (clojure.core/case
      (clojure.core/count args5365)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5366
        describeDBSubnetGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5366
        describeDBSubnetGroups
        (rds/describe-dbsubnet-groups-request
         (clojure.core/nth args5365 0))))))))
  (clojure.core/defn
   describe-dbsubnet-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbsubnet-group-name]}]]),
    :doc "Generate map for describeDBSubnetGroups, describeDBSubnetGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbsubnet-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbsubnet-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dbsubnet-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbsubnet-group-name]}]]),
    :doc "Call describeDBSubnetGroups, describeDBSubnetGroups"}
   [credentials5368 & args5369]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5370
     (com.palletops.awaze.common/aws-client :rds credentials5368)]
    (clojure.core/case
     (clojure.core/count args5369)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5370
       describeDBSubnetGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5370
       describeDBSubnetGroups
       (rds/describe-dbsubnet-groups-request
        (clojure.core/nth args5369 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-event-subscription
   [m5371]
   (clojure.core/let
    [credentials5372 (:credentials m5371) args5373 (:args m5371)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5374
      (com.palletops.awaze.common/aws-client :rds credentials5372)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5374
       deleteEventSubscription
       (rds/delete-event-subscription-request
        (clojure.core/nth args5373 0)))))))
  (clojure.core/defn
   delete-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name general-progress-listener]}]]),
    :doc "Generate map for deleteEventSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-event-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name general-progress-listener]}]]),
    :doc "Call deleteEventSubscription"}
   [credentials5376 & args5377]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5378
     (com.palletops.awaze.common/aws-client :rds credentials5376)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5378
      deleteEventSubscription
      (rds/delete-event-subscription-request
       (clojure.core/nth args5377 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbparameter-groups
   [m5379]
   (clojure.core/let
    [credentials5380 (:credentials m5379) args5381 (:args m5379)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5382
      (com.palletops.awaze.common/aws-client :rds credentials5380)]
     (clojure.core/case
      (clojure.core/count args5381)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5382
        describeDBParameterGroups
        (rds/describe-dbparameter-groups-request
         (clojure.core/nth args5381 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5382
        describeDBParameterGroups))))))
  (clojure.core/defn
   describe-dbparameter-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbparameter-group-name]}]
                [credentials]]),
    :doc "Generate map for describeDBParameterGroups, describeDBParameterGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbparameter-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbparameter-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dbparameter-groups
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         filters
                         dbparameter-group-name]}]
                [credentials]]),
    :doc "Call describeDBParameterGroups, describeDBParameterGroups"}
   [credentials5384 & args5385]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5386
     (com.palletops.awaze.common/aws-client :rds credentials5384)]
    (clojure.core/case
     (clojure.core/count args5385)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5386
       describeDBParameterGroups
       (rds/describe-dbparameter-groups-request
        (clojure.core/nth args5385 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5386
       describeDBParameterGroups))))))
 (do
  (clojure.core/defmethod
   rds
   :reset-dbparameter-group
   [m5387]
   (clojure.core/let
    [credentials5388 (:credentials m5387) args5389 (:args m5387)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5390
      (com.palletops.awaze.common/aws-client :rds credentials5388)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5390
       resetDBParameterGroup
       (rds/reset-dbparameter-group-request
        (clojure.core/nth args5389 0)))))))
  (clojure.core/defn
   reset-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameters
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Generate map for resetDBParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :reset-dbparameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reset-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameters
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Call resetDBParameterGroup"}
   [credentials5392 & args5393]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5394
     (com.palletops.awaze.common/aws-client :rds credentials5392)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5394
      resetDBParameterGroup
      (rds/reset-dbparameter-group-request
       (clojure.core/nth args5393 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :restore-dbinstance-to-point-in-time
   [m5395]
   (clojure.core/let
    [credentials5396 (:credentials m5395) args5397 (:args m5395)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5398
      (com.palletops.awaze.common/aws-client :rds credentials5396)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5398
       restoreDBInstanceToPointInTime
       (rds/restore-dbinstance-to-point-in-time-request
        (clojure.core/nth args5397 0)))))))
  (clojure.core/defn
   restore-dbinstance-to-point-in-time-map
   {:arglists (quote
               [[credentials
                 {:keys [restore-time
                         publicly-accessible
                         iops
                         engine
                         general-progress-listener
                         availability-zone
                         dbname
                         target-dbinstance-identifier
                         dbinstance-class
                         port
                         license-model
                         dbsubnet-group-name
                         multi-az
                         use-latest-restorable-time
                         source-dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Generate map for restoreDBInstanceToPointInTime"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :restore-dbinstance-to-point-in-time,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   restore-dbinstance-to-point-in-time
   {:arglists (quote
               [[credentials
                 {:keys [restore-time
                         publicly-accessible
                         iops
                         engine
                         general-progress-listener
                         availability-zone
                         dbname
                         target-dbinstance-identifier
                         dbinstance-class
                         port
                         license-model
                         dbsubnet-group-name
                         multi-az
                         use-latest-restorable-time
                         source-dbinstance-identifier
                         auto-minor-version-upgrade
                         option-group-name
                         tags]}]]),
    :doc "Call restoreDBInstanceToPointInTime"}
   [credentials5400 & args5401]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5402
     (com.palletops.awaze.common/aws-client :rds credentials5400)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5402
      restoreDBInstanceToPointInTime
      (rds/restore-dbinstance-to-point-in-time-request
       (clojure.core/nth args5401 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbparameter-group
   [m5403]
   (clojure.core/let
    [credentials5404 (:credentials m5403) args5405 (:args m5403)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5406
      (com.palletops.awaze.common/aws-client :rds credentials5404)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5406
       modifyDBParameterGroup
       (rds/modify-dbparameter-group-request
        (clojure.core/nth args5405 0)))))))
  (clojure.core/defn
   modify-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [parameters
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Generate map for modifyDBParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-dbparameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [parameters
                         general-progress-listener
                         dbparameter-group-name]}]]),
    :doc "Call modifyDBParameterGroup"}
   [credentials5408 & args5409]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5410
     (com.palletops.awaze.common/aws-client :rds credentials5408)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5410
      modifyDBParameterGroup
      (rds/modify-dbparameter-group-request
       (clojure.core/nth args5409 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbinstance
   [m5411]
   (clojure.core/let
    [credentials5412 (:credentials m5411) args5413 (:args m5411)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5414
      (com.palletops.awaze.common/aws-client :rds credentials5412)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5414
       deleteDBInstance
       (rds/delete-dbinstance-request (clojure.core/nth args5413 0)))))))
  (clojure.core/defn
   delete-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [skip-final-snapshot
                         general-progress-listener
                         final-dbsnapshot-identifier
                         dbinstance-identifier]}]]),
    :doc "Generate map for deleteDBInstance"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbinstance,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [skip-final-snapshot
                         general-progress-listener
                         final-dbsnapshot-identifier
                         dbinstance-identifier]}]]),
    :doc "Call deleteDBInstance"}
   [credentials5416 & args5417]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5418
     (com.palletops.awaze.common/aws-client :rds credentials5416)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5418
      deleteDBInstance
      (rds/delete-dbinstance-request (clojure.core/nth args5417 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-event-categories
   [m5419]
   (clojure.core/let
    [credentials5420 (:credentials m5419) args5421 (:args m5419)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5422
      (com.palletops.awaze.common/aws-client :rds credentials5420)]
     (clojure.core/case
      (clojure.core/count args5421)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5422
        describeEventCategories))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5422
        describeEventCategories
        (rds/describe-event-categories-request
         (clojure.core/nth args5421 0))))))))
  (clojure.core/defn
   describe-event-categories-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-type general-progress-listener]}]]),
    :doc "Generate map for describeEventCategories, describeEventCategories"}
   ([credentials__1651__auto__]
    {:args [],
     :client :rds,
     :fn :describe-event-categories,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-event-categories,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-event-categories
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-type general-progress-listener]}]]),
    :doc "Call describeEventCategories, describeEventCategories"}
   [credentials5424 & args5425]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5426
     (com.palletops.awaze.common/aws-client :rds credentials5424)]
    (clojure.core/case
     (clojure.core/count args5425)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5426
       describeEventCategories))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5426
       describeEventCategories
       (rds/describe-event-categories-request
        (clojure.core/nth args5425 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :authorize-dbsecurity-group-ingress
   [m5427]
   (clojure.core/let
    [credentials5428 (:credentials m5427) args5429 (:args m5427)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5430
      (com.palletops.awaze.common/aws-client :rds credentials5428)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5430
       authorizeDBSecurityGroupIngress
       (rds/authorize-dbsecurity-group-ingress-request
        (clojure.core/nth args5429 0)))))))
  (clojure.core/defn
   authorize-dbsecurity-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [cidrip
                         ec2security-group-id
                         ec2security-group-owner-id
                         ec2security-group-name
                         dbsecurity-group-name
                         general-progress-listener]}]]),
    :doc "Generate map for authorizeDBSecurityGroupIngress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :authorize-dbsecurity-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   authorize-dbsecurity-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [cidrip
                         ec2security-group-id
                         ec2security-group-owner-id
                         ec2security-group-name
                         dbsecurity-group-name
                         general-progress-listener]}]]),
    :doc "Call authorizeDBSecurityGroupIngress"}
   [credentials5432 & args5433]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5434
     (com.palletops.awaze.common/aws-client :rds credentials5432)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5434
      authorizeDBSecurityGroupIngress
      (rds/authorize-dbsecurity-group-ingress-request
       (clojure.core/nth args5433 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :copy-dbsnapshot
   [m5435]
   (clojure.core/let
    [credentials5436 (:credentials m5435) args5437 (:args m5435)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5438
      (com.palletops.awaze.common/aws-client :rds credentials5436)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5438
       copyDBSnapshot
       (rds/copy-dbsnapshot-request (clojure.core/nth args5437 0)))))))
  (clojure.core/defn
   copy-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [target-dbsnapshot-identifier
                         tags
                         source-dbsnapshot-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for copyDBSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :copy-dbsnapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   copy-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [target-dbsnapshot-identifier
                         tags
                         source-dbsnapshot-identifier
                         general-progress-listener]}]]),
    :doc "Call copyDBSnapshot"}
   [credentials5440 & args5441]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5442
     (com.palletops.awaze.common/aws-client :rds credentials5440)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5442
      copyDBSnapshot
      (rds/copy-dbsnapshot-request (clojure.core/nth args5441 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbsnapshot
   [m5443]
   (clojure.core/let
    [credentials5444 (:credentials m5443) args5445 (:args m5443)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5446
      (com.palletops.awaze.common/aws-client :rds credentials5444)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5446
       deleteDBSnapshot
       (rds/delete-dbsnapshot-request (clojure.core/nth args5445 0)))))))
  (clojure.core/defn
   delete-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsnapshot-identifier]}]]),
    :doc "Generate map for deleteDBSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbsnapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dbsnapshot-identifier]}]]),
    :doc "Call deleteDBSnapshot"}
   [credentials5448 & args5449]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5450
     (com.palletops.awaze.common/aws-client :rds credentials5448)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5450
      deleteDBSnapshot
      (rds/delete-dbsnapshot-request (clojure.core/nth args5449 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbsubnet-group
   [m5451]
   (clojure.core/let
    [credentials5452 (:credentials m5451) args5453 (:args m5451)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client5454
      (com.palletops.awaze.common/aws-client :rds credentials5452)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5454
       createDBSubnetGroup
       (rds/create-dbsubnet-group-request
        (clojure.core/nth args5453 0)))))))
  (clojure.core/defn
   create-dbsubnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         subnet-ids
                         general-progress-listener
                         dbsubnet-group-name
                         dbsubnet-group-description]}]]),
    :doc "Generate map for createDBSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbsubnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-dbsubnet-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         subnet-ids
                         general-progress-listener
                         dbsubnet-group-name
                         dbsubnet-group-description]}]]),
    :doc "Call createDBSubnetGroup"}
   [credentials5456 & args5457]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client5458
     (com.palletops.awaze.common/aws-client :rds credentials5456)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client5458
      createDBSubnetGroup
      (rds/create-dbsubnet-group-request
       (clojure.core/nth args5457 0))))))))
