(ns
 com.palletops.awaze.iam
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.iam :as iam]
  [com.palletops.awaze.beans.identitymanagement
   :as
   identitymanagement]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :iam
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient
   credentials__1601__auto__))
 (clojure.core/defmulti
  iam
  (clojure.core/fn iam [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   iam
   :get-role-policy
   [m7931]
   (clojure.core/let
    [credentials7932 (:credentials m7931) args7933 (:args m7931)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7934
      (com.palletops.awaze.common/aws-client :iam credentials7932)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7934
       getRolePolicy
       (identitymanagement/get-role-policy-request
        (clojure.core/nth args7933 0)))))))
  (clojure.core/defn
   get-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Generate map for getRolePolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-role-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Call getRolePolicy"}
   [credentials7936 & args7937]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7938
     (com.palletops.awaze.common/aws-client :iam credentials7936)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7938
      getRolePolicy
      (identitymanagement/get-role-policy-request
       (clojure.core/nth args7937 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :change-password
   [m7939]
   (clojure.core/let
    [credentials7940 (:credentials m7939) args7941 (:args m7939)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7942
      (com.palletops.awaze.common/aws-client :iam credentials7940)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7942
       changePassword
       (identitymanagement/change-password-request
        (clojure.core/nth args7941 0)))))))
  (clojure.core/defn
   change-password-map
   {:arglists (quote
               [[credentials
                 {:keys [old-password
                         new-password
                         general-progress-listener]}]]),
    :doc "Generate map for changePassword"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :change-password,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   change-password
   {:arglists (quote
               [[credentials
                 {:keys [old-password
                         new-password
                         general-progress-listener]}]]),
    :doc "Call changePassword"}
   [credentials7944 & args7945]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7946
     (com.palletops.awaze.common/aws-client :iam credentials7944)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7946
      changePassword
      (identitymanagement/change-password-request
       (clojure.core/nth args7945 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :deactivate-mfadevice
   [m7947]
   (clojure.core/let
    [credentials7948 (:credentials m7947) args7949 (:args m7947)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7950
      (com.palletops.awaze.common/aws-client :iam credentials7948)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7950
       deactivateMFADevice
       (identitymanagement/deactivate-mfadevice-request
        (clojure.core/nth args7949 0)))))))
  (clojure.core/defn
   deactivate-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener]}]]),
    :doc "Generate map for deactivateMFADevice"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :deactivate-mfadevice,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   deactivate-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener]}]]),
    :doc "Call deactivateMFADevice"}
   [credentials7952 & args7953]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7954
     (com.palletops.awaze.common/aws-client :iam credentials7952)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7954
      deactivateMFADevice
      (identitymanagement/deactivate-mfadevice-request
       (clojure.core/nth args7953 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :resync-mfadevice
   [m7955]
   (clojure.core/let
    [credentials7956 (:credentials m7955) args7957 (:args m7955)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7958
      (com.palletops.awaze.common/aws-client :iam credentials7956)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7958
       resyncMFADevice
       (identitymanagement/resync-mfadevice-request
        (clojure.core/nth args7957 0)))))))
  (clojure.core/defn
   resync-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Generate map for resyncMFADevice"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :resync-mfadevice,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   resync-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Call resyncMFADevice"}
   [credentials7960 & args7961]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7962
     (com.palletops.awaze.common/aws-client :iam credentials7960)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7962
      resyncMFADevice
      (identitymanagement/resync-mfadevice-request
       (clojure.core/nth args7961 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-login-profile
   [m7963]
   (clojure.core/let
    [credentials7964 (:credentials m7963) args7965 (:args m7963)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7966
      (com.palletops.awaze.common/aws-client :iam credentials7964)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7966
       updateLoginProfile
       (identitymanagement/update-login-profile-request
        (clojure.core/nth args7965 0)))))))
  (clojure.core/defn
   update-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name password general-progress-listener]}]]),
    :doc "Generate map for updateLoginProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-login-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name password general-progress-listener]}]]),
    :doc "Call updateLoginProfile"}
   [credentials7968 & args7969]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7970
     (com.palletops.awaze.common/aws-client :iam credentials7968)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7970
      updateLoginProfile
      (identitymanagement/update-login-profile-request
       (clojure.core/nth args7969 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-role-policy
   [m7971]
   (clojure.core/let
    [credentials7972 (:credentials m7971) args7973 (:args m7971)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7974
      (com.palletops.awaze.common/aws-client :iam credentials7972)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7974
       putRolePolicy
       (identitymanagement/put-role-policy-request
        (clojure.core/nth args7973 0)))))))
  (clojure.core/defn
   put-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Generate map for putRolePolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :put-role-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Call putRolePolicy"}
   [credentials7976 & args7977]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7978
     (com.palletops.awaze.common/aws-client :iam credentials7976)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7978
      putRolePolicy
      (identitymanagement/put-role-policy-request
       (clojure.core/nth args7977 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-signing-certificate
   [m7979]
   (clojure.core/let
    [credentials7980 (:credentials m7979) args7981 (:args m7979)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7982
      (com.palletops.awaze.common/aws-client :iam credentials7980)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7982
       deleteSigningCertificate
       (identitymanagement/delete-signing-certificate-request
        (clojure.core/nth args7981 0)))))))
  (clojure.core/defn
   delete-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         certificate-id]}]]),
    :doc "Generate map for deleteSigningCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-signing-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         certificate-id]}]]),
    :doc "Call deleteSigningCertificate"}
   [credentials7984 & args7985]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7986
     (com.palletops.awaze.common/aws-client :iam credentials7984)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7986
      deleteSigningCertificate
      (identitymanagement/delete-signing-certificate-request
       (clojure.core/nth args7985 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-samlprovider
   [m7987]
   (clojure.core/let
    [credentials7988 (:credentials m7987) args7989 (:args m7987)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7990
      (com.palletops.awaze.common/aws-client :iam credentials7988)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7990
       deleteSAMLProvider
       (identitymanagement/delete-samlprovider-request
        (clojure.core/nth args7989 0)))))))
  (clojure.core/defn
   delete-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener samlprovider-arn]}]]),
    :doc "Generate map for deleteSAMLProvider"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-samlprovider,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener samlprovider-arn]}]]),
    :doc "Call deleteSAMLProvider"}
   [credentials7992 & args7993]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7994
     (com.palletops.awaze.common/aws-client :iam credentials7992)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7994
      deleteSAMLProvider
      (identitymanagement/delete-samlprovider-request
       (clojure.core/nth args7993 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user
   [m7995]
   (clojure.core/let
    [credentials7996 (:credentials m7995) args7997 (:args m7995)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7998
      (com.palletops.awaze.common/aws-client :iam credentials7996)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7998
       deleteUser
       (identitymanagement/delete-user-request
        (clojure.core/nth args7997 0)))))))
  (clojure.core/defn
   delete-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Generate map for deleteUser"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-user,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Call deleteUser"}
   [credentials8000 & args8001]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8002
     (com.palletops.awaze.common/aws-client :iam credentials8000)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8002
      deleteUser
      (identitymanagement/delete-user-request
       (clojure.core/nth args8001 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :add-user-to-group
   [m8003]
   (clojure.core/let
    [credentials8004 (:credentials m8003) args8005 (:args m8003)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8006
      (com.palletops.awaze.common/aws-client :iam credentials8004)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8006
       addUserToGroup
       (identitymanagement/add-user-to-group-request
        (clojure.core/nth args8005 0)))))))
  (clojure.core/defn
   add-user-to-group-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for addUserToGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :add-user-to-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-user-to-group
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Call addUserToGroup"}
   [credentials8008 & args8009]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8010
     (com.palletops.awaze.common/aws-client :iam credentials8008)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8010
      addUserToGroup
      (identitymanagement/add-user-to-group-request
       (clojure.core/nth args8009 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-account-aliases
   [m8011]
   (clojure.core/let
    [credentials8012 (:credentials m8011) args8013 (:args m8011)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8014
      (com.palletops.awaze.common/aws-client :iam credentials8012)]
     (clojure.core/case
      (clojure.core/count args8013)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8014
        listAccountAliases
        (identitymanagement/list-account-aliases-request
         (clojure.core/nth args8013 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8014
        listAccountAliases))))))
  (clojure.core/defn
   list-account-aliases-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listAccountAliases, listAccountAliases"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-account-aliases,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-account-aliases,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-account-aliases
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]
                [credentials]]),
    :doc "Call listAccountAliases, listAccountAliases"}
   [credentials8016 & args8017]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8018
     (com.palletops.awaze.common/aws-client :iam credentials8016)]
    (clojure.core/case
     (clojure.core/count args8017)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8018
       listAccountAliases
       (identitymanagement/list-account-aliases-request
        (clojure.core/nth args8017 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8018
       listAccountAliases))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-user-from-group
   [m8019]
   (clojure.core/let
    [credentials8020 (:credentials m8019) args8021 (:args m8019)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8022
      (com.palletops.awaze.common/aws-client :iam credentials8020)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8022
       removeUserFromGroup
       (identitymanagement/remove-user-from-group-request
        (clojure.core/nth args8021 0)))))))
  (clojure.core/defn
   remove-user-from-group-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for removeUserFromGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :remove-user-from-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   remove-user-from-group
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Call removeUserFromGroup"}
   [credentials8024 & args8025]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8026
     (com.palletops.awaze.common/aws-client :iam credentials8024)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8026
      removeUserFromGroup
      (identitymanagement/remove-user-from-group-request
       (clojure.core/nth args8025 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-group
   [m8027]
   (clojure.core/let
    [credentials8028 (:credentials m8027) args8029 (:args m8027)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8030
      (com.palletops.awaze.common/aws-client :iam credentials8028)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8030
       updateGroup
       (identitymanagement/update-group-request
        (clojure.core/nth args8029 0)))))))
  (clojure.core/defn
   update-group-map
   {:arglists (quote
               [[credentials
                 {:keys [new-path
                         new-group-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for updateGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-group
   {:arglists (quote
               [[credentials
                 {:keys [new-path
                         new-group-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Call updateGroup"}
   [credentials8032 & args8033]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8034
     (com.palletops.awaze.common/aws-client :iam credentials8032)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8034
      updateGroup
      (identitymanagement/update-group-request
       (clojure.core/nth args8033 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-server-certificate
   [m8035]
   (clojure.core/let
    [credentials8036 (:credentials m8035) args8037 (:args m8035)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8038
      (com.palletops.awaze.common/aws-client :iam credentials8036)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8038
       updateServerCertificate
       (identitymanagement/update-server-certificate-request
        (clojure.core/nth args8037 0)))))))
  (clojure.core/defn
   update-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         new-server-certificate-name
                         new-path
                         general-progress-listener]}]]),
    :doc "Generate map for updateServerCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-server-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         new-server-certificate-name
                         new-path
                         general-progress-listener]}]]),
    :doc "Call updateServerCertificate"}
   [credentials8040 & args8041]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8042
     (com.palletops.awaze.common/aws-client :iam credentials8040)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8042
      updateServerCertificate
      (identitymanagement/update-server-certificate-request
       (clojure.core/nth args8041 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role-policy
   [m8043]
   (clojure.core/let
    [credentials8044 (:credentials m8043) args8045 (:args m8043)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8046
      (com.palletops.awaze.common/aws-client :iam credentials8044)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8046
       deleteRolePolicy
       (identitymanagement/delete-role-policy-request
        (clojure.core/nth args8045 0)))))))
  (clojure.core/defn
   delete-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteRolePolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-role-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Call deleteRolePolicy"}
   [credentials8048 & args8049]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8050
     (com.palletops.awaze.common/aws-client :iam credentials8048)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8050
      deleteRolePolicy
      (identitymanagement/delete-role-policy-request
       (clojure.core/nth args8049 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-access-key
   [m8051]
   (clojure.core/let
    [credentials8052 (:credentials m8051) args8053 (:args m8051)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8054
      (com.palletops.awaze.common/aws-client :iam credentials8052)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8054
       updateAccessKey
       (identitymanagement/update-access-key-request
        (clojure.core/nth args8053 0)))))))
  (clojure.core/defn
   update-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         general-progress-listener
                         access-key-id]}]]),
    :doc "Generate map for updateAccessKey"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-access-key,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-access-key
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         general-progress-listener
                         access-key-id]}]]),
    :doc "Call updateAccessKey"}
   [credentials8056 & args8057]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8058
     (com.palletops.awaze.common/aws-client :iam credentials8056)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8058
      updateAccessKey
      (identitymanagement/update-access-key-request
       (clojure.core/nth args8057 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group
   [m8059]
   (clojure.core/let
    [credentials8060 (:credentials m8059) args8061 (:args m8059)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8062
      (com.palletops.awaze.common/aws-client :iam credentials8060)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8062
       deleteGroup
       (identitymanagement/delete-group-request
        (clojure.core/nth args8061 0)))))))
  (clojure.core/defn
   delete-group-map
   {:arglists (quote
               [[credentials
                 {:keys [group-name general-progress-listener]}]]),
    :doc "Generate map for deleteGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-group
   {:arglists (quote
               [[credentials
                 {:keys [group-name general-progress-listener]}]]),
    :doc "Call deleteGroup"}
   [credentials8064 & args8065]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8066
     (com.palletops.awaze.common/aws-client :iam credentials8064)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8066
      deleteGroup
      (identitymanagement/delete-group-request
       (clojure.core/nth args8065 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-groups-for-user
   [m8067]
   (clojure.core/let
    [credentials8068 (:credentials m8067) args8069 (:args m8067)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8070
      (com.palletops.awaze.common/aws-client :iam credentials8068)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8070
       listGroupsForUser
       (identitymanagement/list-groups-for-user-request
        (clojure.core/nth args8069 0)))))))
  (clojure.core/defn
   list-groups-for-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listGroupsForUser"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-groups-for-user,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-groups-for-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listGroupsForUser"}
   [credentials8072 & args8073]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8074
     (com.palletops.awaze.common/aws-client :iam credentials8072)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8074
      listGroupsForUser
      (identitymanagement/list-groups-for-user-request
       (clojure.core/nth args8073 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-user-policy
   [m8075]
   (clojure.core/let
    [credentials8076 (:credentials m8075) args8077 (:args m8075)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8078
      (com.palletops.awaze.common/aws-client :iam credentials8076)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8078
       putUserPolicy
       (identitymanagement/put-user-policy-request
        (clojure.core/nth args8077 0)))))))
  (clojure.core/defn
   put-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Generate map for putUserPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :put-user-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Call putUserPolicy"}
   [credentials8080 & args8081]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8082
     (com.palletops.awaze.common/aws-client :iam credentials8080)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8082
      putUserPolicy
      (identitymanagement/put-user-policy-request
       (clojure.core/nth args8081 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-role
   [m8083]
   (clojure.core/let
    [credentials8084 (:credentials m8083) args8085 (:args m8083)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8086
      (com.palletops.awaze.common/aws-client :iam credentials8084)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8086
       getRole
       (identitymanagement/get-role-request
        (clojure.core/nth args8085 0)))))))
  (clojure.core/defn
   get-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name general-progress-listener]}]]),
    :doc "Generate map for getRole"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-role,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name general-progress-listener]}]]),
    :doc "Call getRole"}
   [credentials8088 & args8089]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8090
     (com.palletops.awaze.common/aws-client :iam credentials8088)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8090
      getRole
      (identitymanagement/get-role-request
       (clojure.core/nth args8089 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-password-policy
   [m8091]
   (clojure.core/let
    [credentials8092 (:credentials m8091) args8093 (:args m8091)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8094
      (com.palletops.awaze.common/aws-client :iam credentials8092)]
     (clojure.core/case
      (clojure.core/count args8093)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8094
        getAccountPasswordPolicy
        (identitymanagement/get-account-password-policy-request
         (clojure.core/nth args8093 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8094
        getAccountPasswordPolicy))))))
  (clojure.core/defn
   get-account-password-policy-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for getAccountPasswordPolicy, getAccountPasswordPolicy"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :get-account-password-policy,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-account-password-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-account-password-policy
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call getAccountPasswordPolicy, getAccountPasswordPolicy"}
   [credentials8096 & args8097]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8098
     (com.palletops.awaze.common/aws-client :iam credentials8096)]
    (clojure.core/case
     (clojure.core/count args8097)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8098
       getAccountPasswordPolicy
       (identitymanagement/get-account-password-policy-request
        (clojure.core/nth args8097 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8098
       getAccountPasswordPolicy))))))
 (do
  (clojure.core/defmethod
   iam
   :list-access-keys
   [m8099]
   (clojure.core/let
    [credentials8100 (:credentials m8099) args8101 (:args m8099)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8102
      (com.palletops.awaze.common/aws-client :iam credentials8100)]
     (clojure.core/case
      (clojure.core/count args8101)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8102
        listAccessKeys
        (identitymanagement/list-access-keys-request
         (clojure.core/nth args8101 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8102
        listAccessKeys))))))
  (clojure.core/defn
   list-access-keys-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listAccessKeys, listAccessKeys"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-access-keys,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-access-keys,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-access-keys
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call listAccessKeys, listAccessKeys"}
   [credentials8104 & args8105]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8106
     (com.palletops.awaze.common/aws-client :iam credentials8104)]
    (clojure.core/case
     (clojure.core/count args8105)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8106
       listAccessKeys
       (identitymanagement/list-access-keys-request
        (clojure.core/nth args8105 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8106
       listAccessKeys))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-alias
   [m8107]
   (clojure.core/let
    [credentials8108 (:credentials m8107) args8109 (:args m8107)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8110
      (com.palletops.awaze.common/aws-client :iam credentials8108)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8110
       deleteAccountAlias
       (identitymanagement/delete-account-alias-request
        (clojure.core/nth args8109 0)))))))
  (clojure.core/defn
   delete-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener account-alias]}]]),
    :doc "Generate map for deleteAccountAlias"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-account-alias,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener account-alias]}]]),
    :doc "Call deleteAccountAlias"}
   [credentials8112 & args8113]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8114
     (com.palletops.awaze.common/aws-client :iam credentials8112)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8114
      deleteAccountAlias
      (identitymanagement/delete-account-alias-request
       (clojure.core/nth args8113 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-login-profile
   [m8115]
   (clojure.core/let
    [credentials8116 (:credentials m8115) args8117 (:args m8115)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8118
      (com.palletops.awaze.common/aws-client :iam credentials8116)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8118
       getLoginProfile
       (identitymanagement/get-login-profile-request
        (clojure.core/nth args8117 0)))))))
  (clojure.core/defn
   get-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Generate map for getLoginProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-login-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Call getLoginProfile"}
   [credentials8120 & args8121]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8122
     (com.palletops.awaze.common/aws-client :iam credentials8120)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8122
      getLoginProfile
      (identitymanagement/get-login-profile-request
       (clojure.core/nth args8121 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-login-profile
   [m8123]
   (clojure.core/let
    [credentials8124 (:credentials m8123) args8125 (:args m8123)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8126
      (com.palletops.awaze.common/aws-client :iam credentials8124)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8126
       createLoginProfile
       (identitymanagement/create-login-profile-request
        (clojure.core/nth args8125 0)))))))
  (clojure.core/defn
   create-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name password general-progress-listener]}]]),
    :doc "Generate map for createLoginProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-login-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name password general-progress-listener]}]]),
    :doc "Call createLoginProfile"}
   [credentials8128 & args8129]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8130
     (com.palletops.awaze.common/aws-client :iam credentials8128)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8130
      createLoginProfile
      (identitymanagement/create-login-profile-request
       (clojure.core/nth args8129 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-groups
   [m8131]
   (clojure.core/let
    [credentials8132 (:credentials m8131) args8133 (:args m8131)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8134
      (com.palletops.awaze.common/aws-client :iam credentials8132)]
     (clojure.core/case
      (clojure.core/count args8133)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8134
        listGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8134
        listGroups
        (identitymanagement/list-groups-request
         (clojure.core/nth args8133 0))))))))
  (clojure.core/defn
   list-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listGroups, listGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listGroups, listGroups"}
   [credentials8136 & args8137]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8138
     (com.palletops.awaze.common/aws-client :iam credentials8136)]
    (clojure.core/case
     (clojure.core/count args8137)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8138
       listGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8138
       listGroups
       (identitymanagement/list-groups-request
        (clojure.core/nth args8137 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-summary
   [m8139]
   (clojure.core/let
    [credentials8140 (:credentials m8139) args8141 (:args m8139)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8142
      (com.palletops.awaze.common/aws-client :iam credentials8140)]
     (clojure.core/case
      (clojure.core/count args8141)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8142
        getAccountSummary
        (identitymanagement/get-account-summary-request
         (clojure.core/nth args8141 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8142
        getAccountSummary))))))
  (clojure.core/defn
   get-account-summary-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for getAccountSummary, getAccountSummary"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :get-account-summary,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-account-summary,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-account-summary
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call getAccountSummary, getAccountSummary"}
   [credentials8144 & args8145]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8146
     (com.palletops.awaze.common/aws-client :iam credentials8144)]
    (clojure.core/case
     (clojure.core/count args8145)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8146
       getAccountSummary
       (identitymanagement/get-account-summary-request
        (clojure.core/nth args8145 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8146
       getAccountSummary))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-password-policy
   [m8147]
   (clojure.core/let
    [credentials8148 (:credentials m8147) args8149 (:args m8147)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8150
      (com.palletops.awaze.common/aws-client :iam credentials8148)]
     (clojure.core/case
      (clojure.core/count args8149)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8150
        deleteAccountPasswordPolicy
        (identitymanagement/delete-account-password-policy-request
         (clojure.core/nth args8149 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8150
        deleteAccountPasswordPolicy))))))
  (clojure.core/defn
   delete-account-password-policy-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :delete-account-password-policy,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-account-password-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-account-password-policy
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   [credentials8152 & args8153]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8154
     (com.palletops.awaze.common/aws-client :iam credentials8152)]
    (clojure.core/case
     (clojure.core/count args8153)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8154
       deleteAccountPasswordPolicy
       (identitymanagement/delete-account-password-policy-request
        (clojure.core/nth args8153 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8154
       deleteAccountPasswordPolicy))))))
 (do
  (clojure.core/defmethod
   iam
   :get-instance-profile
   [m8155]
   (clojure.core/let
    [credentials8156 (:credentials m8155) args8157 (:args m8155)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8158
      (com.palletops.awaze.common/aws-client :iam credentials8156)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8158
       getInstanceProfile
       (identitymanagement/get-instance-profile-request
        (clojure.core/nth args8157 0)))))))
  (clojure.core/defn
   get-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-profile-name
                         general-progress-listener]}]]),
    :doc "Generate map for getInstanceProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-instance-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [instance-profile-name
                         general-progress-listener]}]]),
    :doc "Call getInstanceProfile"}
   [credentials8160 & args8161]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8162
     (com.palletops.awaze.common/aws-client :iam credentials8160)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8162
      getInstanceProfile
      (identitymanagement/get-instance-profile-request
       (clojure.core/nth args8161 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user
   [m8163]
   (clojure.core/let
    [credentials8164 (:credentials m8163) args8165 (:args m8163)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8166
      (com.palletops.awaze.common/aws-client :iam credentials8164)]
     (clojure.core/case
      (clojure.core/count args8165)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8166
        getUser))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8166
        getUser
        (identitymanagement/get-user-request
         (clojure.core/nth args8165 0))))))))
  (clojure.core/defn
   get-user-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Generate map for getUser, getUser"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :get-user,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-user,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-user
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Call getUser, getUser"}
   [credentials8168 & args8169]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8170
     (com.palletops.awaze.common/aws-client :iam credentials8168)]
    (clojure.core/case
     (clojure.core/count args8169)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8170
       getUser))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8170
       getUser
       (identitymanagement/get-user-request
        (clojure.core/nth args8169 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :update-samlprovider
   [m8171]
   (clojure.core/let
    [credentials8172 (:credentials m8171) args8173 (:args m8171)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8174
      (com.palletops.awaze.common/aws-client :iam credentials8172)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8174
       updateSAMLProvider
       (identitymanagement/update-samlprovider-request
        (clojure.core/nth args8173 0)))))))
  (clojure.core/defn
   update-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         samlprovider-arn
                         samlmetadata-document]}]]),
    :doc "Generate map for updateSAMLProvider"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-samlprovider,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         samlprovider-arn
                         samlmetadata-document]}]]),
    :doc "Call updateSAMLProvider"}
   [credentials8176 & args8177]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8178
     (com.palletops.awaze.common/aws-client :iam credentials8176)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8178
      updateSAMLProvider
      (identitymanagement/update-samlprovider-request
       (clojure.core/nth args8177 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-samlprovider
   [m8179]
   (clojure.core/let
    [credentials8180 (:credentials m8179) args8181 (:args m8179)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8182
      (com.palletops.awaze.common/aws-client :iam credentials8180)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8182
       createSAMLProvider
       (identitymanagement/create-samlprovider-request
        (clojure.core/nth args8181 0)))))))
  (clojure.core/defn
   create-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [name
                         general-progress-listener
                         samlmetadata-document]}]]),
    :doc "Generate map for createSAMLProvider"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-samlprovider,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [name
                         general-progress-listener
                         samlmetadata-document]}]]),
    :doc "Call createSAMLProvider"}
   [credentials8184 & args8185]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8186
     (com.palletops.awaze.common/aws-client :iam credentials8184)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8186
      createSAMLProvider
      (identitymanagement/create-samlprovider-request
       (clojure.core/nth args8185 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-samlproviders
   [m8187]
   (clojure.core/let
    [credentials8188 (:credentials m8187) args8189 (:args m8187)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8190
      (com.palletops.awaze.common/aws-client :iam credentials8188)]
     (clojure.core/case
      (clojure.core/count args8189)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8190
        listSAMLProviders
        (identitymanagement/list-samlproviders-request
         (clojure.core/nth args8189 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8190
        listSAMLProviders))))))
  (clojure.core/defn
   list-samlproviders-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listSAMLProviders, listSAMLProviders"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-samlproviders,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-samlproviders,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-samlproviders
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call listSAMLProviders, listSAMLProviders"}
   [credentials8192 & args8193]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8194
     (com.palletops.awaze.common/aws-client :iam credentials8192)]
    (clojure.core/case
     (clojure.core/count args8193)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8194
       listSAMLProviders
       (identitymanagement/list-samlproviders-request
        (clojure.core/nth args8193 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8194
       listSAMLProviders))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-virtual-mfadevice
   [m8195]
   (clojure.core/let
    [credentials8196 (:credentials m8195) args8197 (:args m8195)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8198
      (com.palletops.awaze.common/aws-client :iam credentials8196)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8198
       deleteVirtualMFADevice
       (identitymanagement/delete-virtual-mfadevice-request
        (clojure.core/nth args8197 0)))))))
  (clojure.core/defn
   delete-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number general-progress-listener]}]]),
    :doc "Generate map for deleteVirtualMFADevice"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-virtual-mfadevice,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number general-progress-listener]}]]),
    :doc "Call deleteVirtualMFADevice"}
   [credentials8200 & args8201]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8202
     (com.palletops.awaze.common/aws-client :iam credentials8200)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8202
      deleteVirtualMFADevice
      (identitymanagement/delete-virtual-mfadevice-request
       (clojure.core/nth args8201 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-access-key
   [m8203]
   (clojure.core/let
    [credentials8204 (:credentials m8203) args8205 (:args m8203)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8206
      (com.palletops.awaze.common/aws-client :iam credentials8204)]
     (clojure.core/case
      (clojure.core/count args8205)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8206
        createAccessKey))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8206
        createAccessKey
        (identitymanagement/create-access-key-request
         (clojure.core/nth args8205 0))))))))
  (clojure.core/defn
   create-access-key-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Generate map for createAccessKey, createAccessKey"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :create-access-key,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-access-key,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-access-key
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Call createAccessKey, createAccessKey"}
   [credentials8208 & args8209]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8210
     (com.palletops.awaze.common/aws-client :iam credentials8208)]
    (clojure.core/case
     (clojure.core/count args8209)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8210
       createAccessKey))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8210
       createAccessKey
       (identitymanagement/create-access-key-request
        (clojure.core/nth args8209 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles
   [m8211]
   (clojure.core/let
    [credentials8212 (:credentials m8211) args8213 (:args m8211)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8214
      (com.palletops.awaze.common/aws-client :iam credentials8212)]
     (clojure.core/case
      (clojure.core/count args8213)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8214
        listInstanceProfiles))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8214
        listInstanceProfiles
        (identitymanagement/list-instance-profiles-request
         (clojure.core/nth args8213 0))))))))
  (clojure.core/defn
   list-instance-profiles-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listInstanceProfiles, listInstanceProfiles"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-instance-profiles,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-instance-profiles,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-instance-profiles
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listInstanceProfiles, listInstanceProfiles"}
   [credentials8216 & args8217]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8218
     (com.palletops.awaze.common/aws-client :iam credentials8216)]
    (clojure.core/case
     (clojure.core/count args8217)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8218
       listInstanceProfiles))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8218
       listInstanceProfiles
       (identitymanagement/list-instance-profiles-request
        (clojure.core/nth args8217 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :put-group-policy
   [m8219]
   (clojure.core/let
    [credentials8220 (:credentials m8219) args8221 (:args m8219)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8222
      (com.palletops.awaze.common/aws-client :iam credentials8220)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8222
       putGroupPolicy
       (identitymanagement/put-group-policy-request
        (clojure.core/nth args8221 0)))))))
  (clojure.core/defn
   put-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         policy-document
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for putGroupPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :put-group-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         policy-document
                         group-name
                         general-progress-listener]}]]),
    :doc "Call putGroupPolicy"}
   [credentials8224 & args8225]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8226
     (com.palletops.awaze.common/aws-client :iam credentials8224)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8226
      putGroupPolicy
      (identitymanagement/put-group-policy-request
       (clojure.core/nth args8225 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-server-certificate
   [m8227]
   (clojure.core/let
    [credentials8228 (:credentials m8227) args8229 (:args m8227)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8230
      (com.palletops.awaze.common/aws-client :iam credentials8228)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8230
       getServerCertificate
       (identitymanagement/get-server-certificate-request
        (clojure.core/nth args8229 0)))))))
  (clojure.core/defn
   get-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         general-progress-listener]}]]),
    :doc "Generate map for getServerCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-server-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         general-progress-listener]}]]),
    :doc "Call getServerCertificate"}
   [credentials8232 & args8233]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8234
     (com.palletops.awaze.common/aws-client :iam credentials8232)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8234
      getServerCertificate
      (identitymanagement/get-server-certificate-request
       (clojure.core/nth args8233 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-server-certificate
   [m8235]
   (clojure.core/let
    [credentials8236 (:credentials m8235) args8237 (:args m8235)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8238
      (com.palletops.awaze.common/aws-client :iam credentials8236)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8238
       uploadServerCertificate
       (identitymanagement/upload-server-certificate-request
        (clojure.core/nth args8237 0)))))))
  (clojure.core/defn
   upload-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [certificate-chain
                         certificate-body
                         general-progress-listener
                         private-key
                         server-certificate-name
                         path]}]]),
    :doc "Generate map for uploadServerCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :upload-server-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   upload-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [certificate-chain
                         certificate-body
                         general-progress-listener
                         private-key
                         server-certificate-name
                         path]}]]),
    :doc "Call uploadServerCertificate"}
   [credentials8240 & args8241]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8242
     (com.palletops.awaze.common/aws-client :iam credentials8240)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8242
      uploadServerCertificate
      (identitymanagement/upload-server-certificate-request
       (clojure.core/nth args8241 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-role-policies
   [m8243]
   (clojure.core/let
    [credentials8244 (:credentials m8243) args8245 (:args m8243)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8246
      (com.palletops.awaze.common/aws-client :iam credentials8244)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8246
       listRolePolicies
       (identitymanagement/list-role-policies-request
        (clojure.core/nth args8245 0)))))))
  (clojure.core/defn
   list-role-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listRolePolicies"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-role-policies,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-role-policies
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listRolePolicies"}
   [credentials8248 & args8249]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8250
     (com.palletops.awaze.common/aws-client :iam credentials8248)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8250
      listRolePolicies
      (identitymanagement/list-role-policies-request
       (clojure.core/nth args8249 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :add-role-to-instance-profile
   [m8251]
   (clojure.core/let
    [credentials8252 (:credentials m8251) args8253 (:args m8251)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8254
      (com.palletops.awaze.common/aws-client :iam credentials8252)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8254
       addRoleToInstanceProfile
       (identitymanagement/add-role-to-instance-profile-request
        (clojure.core/nth args8253 0)))))))
  (clojure.core/defn
   add-role-to-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Generate map for addRoleToInstanceProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :add-role-to-instance-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-role-to-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Call addRoleToInstanceProfile"}
   [credentials8256 & args8257]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8258
     (com.palletops.awaze.common/aws-client :iam credentials8256)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8258
      addRoleToInstanceProfile
      (identitymanagement/add-role-to-instance-profile-request
       (clojure.core/nth args8257 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-access-key
   [m8259]
   (clojure.core/let
    [credentials8260 (:credentials m8259) args8261 (:args m8259)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8262
      (com.palletops.awaze.common/aws-client :iam credentials8260)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8262
       deleteAccessKey
       (identitymanagement/delete-access-key-request
        (clojure.core/nth args8261 0)))))))
  (clojure.core/defn
   delete-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         access-key-id]}]]),
    :doc "Generate map for deleteAccessKey"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-access-key,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-access-key
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         access-key-id]}]]),
    :doc "Call deleteAccessKey"}
   [credentials8264 & args8265]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8266
     (com.palletops.awaze.common/aws-client :iam credentials8264)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8266
      deleteAccessKey
      (identitymanagement/delete-access-key-request
       (clojure.core/nth args8265 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role
   [m8267]
   (clojure.core/let
    [credentials8268 (:credentials m8267) args8269 (:args m8267)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8270
      (com.palletops.awaze.common/aws-client :iam credentials8268)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8270
       deleteRole
       (identitymanagement/delete-role-request
        (clojure.core/nth args8269 0)))))))
  (clojure.core/defn
   delete-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name general-progress-listener]}]]),
    :doc "Generate map for deleteRole"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-role,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name general-progress-listener]}]]),
    :doc "Call deleteRole"}
   [credentials8272 & args8273]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8274
     (com.palletops.awaze.common/aws-client :iam credentials8272)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8274
      deleteRole
      (identitymanagement/delete-role-request
       (clojure.core/nth args8273 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-virtual-mfadevice
   [m8275]
   (clojure.core/let
    [credentials8276 (:credentials m8275) args8277 (:args m8275)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8278
      (com.palletops.awaze.common/aws-client :iam credentials8276)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8278
       createVirtualMFADevice
       (identitymanagement/create-virtual-mfadevice-request
        (clojure.core/nth args8277 0)))))))
  (clojure.core/defn
   create-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-mfadevice-name
                         path
                         general-progress-listener]}]]),
    :doc "Generate map for createVirtualMFADevice"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-virtual-mfadevice,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [virtual-mfadevice-name
                         path
                         general-progress-listener]}]]),
    :doc "Call createVirtualMFADevice"}
   [credentials8280 & args8281]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8282
     (com.palletops.awaze.common/aws-client :iam credentials8280)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8282
      createVirtualMFADevice
      (identitymanagement/create-virtual-mfadevice-request
       (clojure.core/nth args8281 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-group-policies
   [m8283]
   (clojure.core/let
    [credentials8284 (:credentials m8283) args8285 (:args m8283)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8286
      (com.palletops.awaze.common/aws-client :iam credentials8284)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8286
       listGroupPolicies
       (identitymanagement/list-group-policies-request
        (clojure.core/nth args8285 0)))))))
  (clojure.core/defn
   list-group-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for listGroupPolicies"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-group-policies,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-group-policies
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         group-name
                         general-progress-listener]}]]),
    :doc "Call listGroupPolicies"}
   [credentials8288 & args8289]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8290
     (com.palletops.awaze.common/aws-client :iam credentials8288)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8290
      listGroupPolicies
      (identitymanagement/list-group-policies-request
       (clojure.core/nth args8289 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group-policy
   [m8291]
   (clojure.core/let
    [credentials8292 (:credentials m8291) args8293 (:args m8291)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8294
      (com.palletops.awaze.common/aws-client :iam credentials8292)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8294
       getGroupPolicy
       (identitymanagement/get-group-policy-request
        (clojure.core/nth args8293 0)))))))
  (clojure.core/defn
   get-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for getGroupPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-group-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Call getGroupPolicy"}
   [credentials8296 & args8297]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8298
     (com.palletops.awaze.common/aws-client :iam credentials8296)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8298
      getGroupPolicy
      (identitymanagement/get-group-policy-request
       (clojure.core/nth args8297 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-server-certificates
   [m8299]
   (clojure.core/let
    [credentials8300 (:credentials m8299) args8301 (:args m8299)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8302
      (com.palletops.awaze.common/aws-client :iam credentials8300)]
     (clojure.core/case
      (clojure.core/count args8301)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8302
        listServerCertificates
        (identitymanagement/list-server-certificates-request
         (clojure.core/nth args8301 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8302
        listServerCertificates))))))
  (clojure.core/defn
   list-server-certificates-map
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listServerCertificates, listServerCertificates"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-server-certificates,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-server-certificates,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-server-certificates
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call listServerCertificates, listServerCertificates"}
   [credentials8304 & args8305]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8306
     (com.palletops.awaze.common/aws-client :iam credentials8304)]
    (clojure.core/case
     (clojure.core/count args8305)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8306
       listServerCertificates
       (identitymanagement/list-server-certificates-request
        (clojure.core/nth args8305 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8306
       listServerCertificates))))))
 (do
  (clojure.core/defmethod
   iam
   :update-account-password-policy
   [m8307]
   (clojure.core/let
    [credentials8308 (:credentials m8307) args8309 (:args m8307)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8310
      (com.palletops.awaze.common/aws-client :iam credentials8308)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8310
       updateAccountPasswordPolicy
       (identitymanagement/update-account-password-policy-request
        (clojure.core/nth args8309 0)))))))
  (clojure.core/defn
   update-account-password-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [require-uppercase-characters
                         allow-users-to-change-password
                         general-progress-listener
                         require-numbers
                         require-lowercase-characters
                         minimum-password-length
                         require-symbols]}]]),
    :doc "Generate map for updateAccountPasswordPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-account-password-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-account-password-policy
   {:arglists (quote
               [[credentials
                 {:keys [require-uppercase-characters
                         allow-users-to-change-password
                         general-progress-listener
                         require-numbers
                         require-lowercase-characters
                         minimum-password-length
                         require-symbols]}]]),
    :doc "Call updateAccountPasswordPolicy"}
   [credentials8312 & args8313]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8314
     (com.palletops.awaze.common/aws-client :iam credentials8312)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8314
      updateAccountPasswordPolicy
      (identitymanagement/update-account-password-policy-request
       (clojure.core/nth args8313 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-group
   [m8315]
   (clojure.core/let
    [credentials8316 (:credentials m8315) args8317 (:args m8315)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8318
      (com.palletops.awaze.common/aws-client :iam credentials8316)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8318
       createGroup
       (identitymanagement/create-group-request
        (clojure.core/nth args8317 0)))))))
  (clojure.core/defn
   create-group-map
   {:arglists (quote
               [[credentials
                 {:keys [path group-name general-progress-listener]}]]),
    :doc "Generate map for createGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-group
   {:arglists (quote
               [[credentials
                 {:keys [path group-name general-progress-listener]}]]),
    :doc "Call createGroup"}
   [credentials8320 & args8321]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8322
     (com.palletops.awaze.common/aws-client :iam credentials8320)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8322
      createGroup
      (identitymanagement/create-group-request
       (clojure.core/nth args8321 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles-for-role
   [m8323]
   (clojure.core/let
    [credentials8324 (:credentials m8323) args8325 (:args m8323)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8326
      (com.palletops.awaze.common/aws-client :iam credentials8324)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8326
       listInstanceProfilesForRole
       (identitymanagement/list-instance-profiles-for-role-request
        (clojure.core/nth args8325 0)))))))
  (clojure.core/defn
   list-instance-profiles-for-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listInstanceProfilesForRole"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-instance-profiles-for-role,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-instance-profiles-for-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listInstanceProfilesForRole"}
   [credentials8328 & args8329]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8330
     (com.palletops.awaze.common/aws-client :iam credentials8328)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8330
      listInstanceProfilesForRole
      (identitymanagement/list-instance-profiles-for-role-request
       (clojure.core/nth args8329 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-signing-certificate
   [m8331]
   (clojure.core/let
    [credentials8332 (:credentials m8331) args8333 (:args m8331)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8334
      (com.palletops.awaze.common/aws-client :iam credentials8332)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8334
       uploadSigningCertificate
       (identitymanagement/upload-signing-certificate-request
        (clojure.core/nth args8333 0)))))))
  (clojure.core/defn
   upload-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         certificate-body]}]]),
    :doc "Generate map for uploadSigningCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :upload-signing-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   upload-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         certificate-body]}]]),
    :doc "Call uploadSigningCertificate"}
   [credentials8336 & args8337]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8338
     (com.palletops.awaze.common/aws-client :iam credentials8336)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8338
      uploadSigningCertificate
      (identitymanagement/upload-signing-certificate-request
       (clojure.core/nth args8337 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-server-certificate
   [m8339]
   (clojure.core/let
    [credentials8340 (:credentials m8339) args8341 (:args m8339)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8342
      (com.palletops.awaze.common/aws-client :iam credentials8340)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8342
       deleteServerCertificate
       (identitymanagement/delete-server-certificate-request
        (clojure.core/nth args8341 0)))))))
  (clojure.core/defn
   delete-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteServerCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-server-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         general-progress-listener]}]]),
    :doc "Call deleteServerCertificate"}
   [credentials8344 & args8345]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8346
     (com.palletops.awaze.common/aws-client :iam credentials8344)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8346
      deleteServerCertificate
      (identitymanagement/delete-server-certificate-request
       (clojure.core/nth args8345 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-virtual-mfadevices
   [m8347]
   (clojure.core/let
    [credentials8348 (:credentials m8347) args8349 (:args m8347)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8350
      (com.palletops.awaze.common/aws-client :iam credentials8348)]
     (clojure.core/case
      (clojure.core/count args8349)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8350
        listVirtualMFADevices))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8350
        listVirtualMFADevices
        (identitymanagement/list-virtual-mfadevices-request
         (clojure.core/nth args8349 0))))))))
  (clojure.core/defn
   list-virtual-mfadevices-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-items
                         marker
                         general-progress-listener
                         assignment-status]}]]),
    :doc "Generate map for listVirtualMFADevices, listVirtualMFADevices"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-virtual-mfadevices,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-virtual-mfadevices,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-virtual-mfadevices
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-items
                         marker
                         general-progress-listener
                         assignment-status]}]]),
    :doc "Call listVirtualMFADevices, listVirtualMFADevices"}
   [credentials8352 & args8353]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8354
     (com.palletops.awaze.common/aws-client :iam credentials8352)]
    (clojure.core/case
     (clojure.core/count args8353)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8354
       listVirtualMFADevices))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8354
       listVirtualMFADevices
       (identitymanagement/list-virtual-mfadevices-request
        (clojure.core/nth args8353 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-role-from-instance-profile
   [m8355]
   (clojure.core/let
    [credentials8356 (:credentials m8355) args8357 (:args m8355)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8358
      (com.palletops.awaze.common/aws-client :iam credentials8356)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8358
       removeRoleFromInstanceProfile
       (identitymanagement/remove-role-from-instance-profile-request
        (clojure.core/nth args8357 0)))))))
  (clojure.core/defn
   remove-role-from-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Generate map for removeRoleFromInstanceProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :remove-role-from-instance-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   remove-role-from-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Call removeRoleFromInstanceProfile"}
   [credentials8360 & args8361]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8362
     (com.palletops.awaze.common/aws-client :iam credentials8360)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8362
      removeRoleFromInstanceProfile
      (identitymanagement/remove-role-from-instance-profile-request
       (clojure.core/nth args8361 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-signing-certificates
   [m8363]
   (clojure.core/let
    [credentials8364 (:credentials m8363) args8365 (:args m8363)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8366
      (com.palletops.awaze.common/aws-client :iam credentials8364)]
     (clojure.core/case
      (clojure.core/count args8365)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8366
        listSigningCertificates
        (identitymanagement/list-signing-certificates-request
         (clojure.core/nth args8365 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8366
        listSigningCertificates))))))
  (clojure.core/defn
   list-signing-certificates-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listSigningCertificates, listSigningCertificates"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-signing-certificates,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-signing-certificates,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-signing-certificates
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call listSigningCertificates, listSigningCertificates"}
   [credentials8368 & args8369]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8370
     (com.palletops.awaze.common/aws-client :iam credentials8368)]
    (clojure.core/case
     (clojure.core/count args8369)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8370
       listSigningCertificates
       (identitymanagement/list-signing-certificates-request
        (clojure.core/nth args8369 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8370
       listSigningCertificates))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-instance-profile
   [m8371]
   (clojure.core/let
    [credentials8372 (:credentials m8371) args8373 (:args m8371)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8374
      (com.palletops.awaze.common/aws-client :iam credentials8372)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8374
       deleteInstanceProfile
       (identitymanagement/delete-instance-profile-request
        (clojure.core/nth args8373 0)))))))
  (clojure.core/defn
   delete-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-profile-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteInstanceProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-instance-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [instance-profile-name
                         general-progress-listener]}]]),
    :doc "Call deleteInstanceProfile"}
   [credentials8376 & args8377]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8378
     (com.palletops.awaze.common/aws-client :iam credentials8376)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8378
      deleteInstanceProfile
      (identitymanagement/delete-instance-profile-request
       (clojure.core/nth args8377 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-mfadevices
   [m8379]
   (clojure.core/let
    [credentials8380 (:credentials m8379) args8381 (:args m8379)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8382
      (com.palletops.awaze.common/aws-client :iam credentials8380)]
     (clojure.core/case
      (clojure.core/count args8381)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8382
        listMFADevices))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8382
        listMFADevices
        (identitymanagement/list-mfadevices-request
         (clojure.core/nth args8381 0))))))))
  (clojure.core/defn
   list-mfadevices-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listMFADevices, listMFADevices"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-mfadevices,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-mfadevices,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-mfadevices
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listMFADevices, listMFADevices"}
   [credentials8384 & args8385]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8386
     (com.palletops.awaze.common/aws-client :iam credentials8384)]
    (clojure.core/case
     (clojure.core/count args8385)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8386
       listMFADevices))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8386
       listMFADevices
       (identitymanagement/list-mfadevices-request
        (clojure.core/nth args8385 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user-policy
   [m8387]
   (clojure.core/let
    [credentials8388 (:credentials m8387) args8389 (:args m8387)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8390
      (com.palletops.awaze.common/aws-client :iam credentials8388)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8390
       deleteUserPolicy
       (identitymanagement/delete-user-policy-request
        (clojure.core/nth args8389 0)))))))
  (clojure.core/defn
   delete-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteUserPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-user-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Call deleteUserPolicy"}
   [credentials8392 & args8393]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8394
     (com.palletops.awaze.common/aws-client :iam credentials8392)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8394
      deleteUserPolicy
      (identitymanagement/delete-user-policy-request
       (clojure.core/nth args8393 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-account-alias
   [m8395]
   (clojure.core/let
    [credentials8396 (:credentials m8395) args8397 (:args m8395)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8398
      (com.palletops.awaze.common/aws-client :iam credentials8396)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8398
       createAccountAlias
       (identitymanagement/create-account-alias-request
        (clojure.core/nth args8397 0)))))))
  (clojure.core/defn
   create-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener account-alias]}]]),
    :doc "Generate map for createAccountAlias"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-account-alias,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener account-alias]}]]),
    :doc "Call createAccountAlias"}
   [credentials8400 & args8401]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8402
     (com.palletops.awaze.common/aws-client :iam credentials8400)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8402
      createAccountAlias
      (identitymanagement/create-account-alias-request
       (clojure.core/nth args8401 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-signing-certificate
   [m8403]
   (clojure.core/let
    [credentials8404 (:credentials m8403) args8405 (:args m8403)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8406
      (com.palletops.awaze.common/aws-client :iam credentials8404)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8406
       updateSigningCertificate
       (identitymanagement/update-signing-certificate-request
        (clojure.core/nth args8405 0)))))))
  (clojure.core/defn
   update-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         general-progress-listener
                         certificate-id]}]]),
    :doc "Generate map for updateSigningCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-signing-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         general-progress-listener
                         certificate-id]}]]),
    :doc "Call updateSigningCertificate"}
   [credentials8408 & args8409]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8410
     (com.palletops.awaze.common/aws-client :iam credentials8408)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8410
      updateSigningCertificate
      (identitymanagement/update-signing-certificate-request
       (clojure.core/nth args8409 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-assume-role-policy
   [m8411]
   (clojure.core/let
    [credentials8412 (:credentials m8411) args8413 (:args m8411)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8414
      (com.palletops.awaze.common/aws-client :iam credentials8412)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8414
       updateAssumeRolePolicy
       (identitymanagement/update-assume-role-policy-request
        (clojure.core/nth args8413 0)))))))
  (clojure.core/defn
   update-assume-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Generate map for updateAssumeRolePolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-assume-role-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-assume-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Call updateAssumeRolePolicy"}
   [credentials8416 & args8417]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8418
     (com.palletops.awaze.common/aws-client :iam credentials8416)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8418
      updateAssumeRolePolicy
      (identitymanagement/update-assume-role-policy-request
       (clojure.core/nth args8417 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-roles
   [m8419]
   (clojure.core/let
    [credentials8420 (:credentials m8419) args8421 (:args m8419)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8422
      (com.palletops.awaze.common/aws-client :iam credentials8420)]
     (clojure.core/case
      (clojure.core/count args8421)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8422
        listRoles))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8422
        listRoles
        (identitymanagement/list-roles-request
         (clojure.core/nth args8421 0))))))))
  (clojure.core/defn
   list-roles-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listRoles, listRoles"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-roles,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-roles,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-roles
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listRoles, listRoles"}
   [credentials8424 & args8425]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8426
     (com.palletops.awaze.common/aws-client :iam credentials8424)]
    (clojure.core/case
     (clojure.core/count args8425)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8426
       listRoles))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8426
       listRoles
       (identitymanagement/list-roles-request
        (clojure.core/nth args8425 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-user-policies
   [m8427]
   (clojure.core/let
    [credentials8428 (:credentials m8427) args8429 (:args m8427)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8430
      (com.palletops.awaze.common/aws-client :iam credentials8428)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8430
       listUserPolicies
       (identitymanagement/list-user-policies-request
        (clojure.core/nth args8429 0)))))))
  (clojure.core/defn
   list-user-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listUserPolicies"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-user-policies,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-user-policies
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listUserPolicies"}
   [credentials8432 & args8433]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8434
     (com.palletops.awaze.common/aws-client :iam credentials8432)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8434
      listUserPolicies
      (identitymanagement/list-user-policies-request
       (clojure.core/nth args8433 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-login-profile
   [m8435]
   (clojure.core/let
    [credentials8436 (:credentials m8435) args8437 (:args m8435)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8438
      (com.palletops.awaze.common/aws-client :iam credentials8436)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8438
       deleteLoginProfile
       (identitymanagement/delete-login-profile-request
        (clojure.core/nth args8437 0)))))))
  (clojure.core/defn
   delete-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Generate map for deleteLoginProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-login-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Call deleteLoginProfile"}
   [credentials8440 & args8441]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8442
     (com.palletops.awaze.common/aws-client :iam credentials8440)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8442
      deleteLoginProfile
      (identitymanagement/delete-login-profile-request
       (clojure.core/nth args8441 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :enable-mfadevice
   [m8443]
   (clojure.core/let
    [credentials8444 (:credentials m8443) args8445 (:args m8443)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8446
      (com.palletops.awaze.common/aws-client :iam credentials8444)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8446
       enableMFADevice
       (identitymanagement/enable-mfadevice-request
        (clojure.core/nth args8445 0)))))))
  (clojure.core/defn
   enable-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Generate map for enableMFADevice"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :enable-mfadevice,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Call enableMFADevice"}
   [credentials8448 & args8449]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8450
     (com.palletops.awaze.common/aws-client :iam credentials8448)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8450
      enableMFADevice
      (identitymanagement/enable-mfadevice-request
       (clojure.core/nth args8449 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-samlprovider
   [m8451]
   (clojure.core/let
    [credentials8452 (:credentials m8451) args8453 (:args m8451)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8454
      (com.palletops.awaze.common/aws-client :iam credentials8452)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8454
       getSAMLProvider
       (identitymanagement/get-samlprovider-request
        (clojure.core/nth args8453 0)))))))
  (clojure.core/defn
   get-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener samlprovider-arn]}]]),
    :doc "Generate map for getSAMLProvider"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-samlprovider,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener samlprovider-arn]}]]),
    :doc "Call getSAMLProvider"}
   [credentials8456 & args8457]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8458
     (com.palletops.awaze.common/aws-client :iam credentials8456)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8458
      getSAMLProvider
      (identitymanagement/get-samlprovider-request
       (clojure.core/nth args8457 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group
   [m8459]
   (clojure.core/let
    [credentials8460 (:credentials m8459) args8461 (:args m8459)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8462
      (com.palletops.awaze.common/aws-client :iam credentials8460)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8462
       getGroup
       (identitymanagement/get-group-request
        (clojure.core/nth args8461 0)))))))
  (clojure.core/defn
   get-group-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for getGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-group
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         group-name
                         general-progress-listener]}]]),
    :doc "Call getGroup"}
   [credentials8464 & args8465]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8466
     (com.palletops.awaze.common/aws-client :iam credentials8464)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8466
      getGroup
      (identitymanagement/get-group-request
       (clojure.core/nth args8465 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group-policy
   [m8467]
   (clojure.core/let
    [credentials8468 (:credentials m8467) args8469 (:args m8467)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8470
      (com.palletops.awaze.common/aws-client :iam credentials8468)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8470
       deleteGroupPolicy
       (identitymanagement/delete-group-policy-request
        (clojure.core/nth args8469 0)))))))
  (clojure.core/defn
   delete-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteGroupPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-group-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Call deleteGroupPolicy"}
   [credentials8472 & args8473]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8474
     (com.palletops.awaze.common/aws-client :iam credentials8472)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8474
      deleteGroupPolicy
      (identitymanagement/delete-group-policy-request
       (clojure.core/nth args8473 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-instance-profile
   [m8475]
   (clojure.core/let
    [credentials8476 (:credentials m8475) args8477 (:args m8475)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8478
      (com.palletops.awaze.common/aws-client :iam credentials8476)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8478
       createInstanceProfile
       (identitymanagement/create-instance-profile-request
        (clojure.core/nth args8477 0)))))))
  (clojure.core/defn
   create-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Generate map for createInstanceProfile"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-instance-profile,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [path
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Call createInstanceProfile"}
   [credentials8480 & args8481]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8482
     (com.palletops.awaze.common/aws-client :iam credentials8480)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8482
      createInstanceProfile
      (identitymanagement/create-instance-profile-request
       (clojure.core/nth args8481 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-user
   [m8483]
   (clojure.core/let
    [credentials8484 (:credentials m8483) args8485 (:args m8483)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8486
      (com.palletops.awaze.common/aws-client :iam credentials8484)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8486
       updateUser
       (identitymanagement/update-user-request
        (clojure.core/nth args8485 0)))))))
  (clojure.core/defn
   update-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         new-user-name
                         new-path
                         general-progress-listener]}]]),
    :doc "Generate map for updateUser"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-user,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         new-user-name
                         new-path
                         general-progress-listener]}]]),
    :doc "Call updateUser"}
   [credentials8488 & args8489]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8490
     (com.palletops.awaze.common/aws-client :iam credentials8488)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8490
      updateUser
      (identitymanagement/update-user-request
       (clojure.core/nth args8489 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-user
   [m8491]
   (clojure.core/let
    [credentials8492 (:credentials m8491) args8493 (:args m8491)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8494
      (com.palletops.awaze.common/aws-client :iam credentials8492)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8494
       createUser
       (identitymanagement/create-user-request
        (clojure.core/nth args8493 0)))))))
  (clojure.core/defn
   create-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name path general-progress-listener]}]]),
    :doc "Generate map for createUser"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-user,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name path general-progress-listener]}]]),
    :doc "Call createUser"}
   [credentials8496 & args8497]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8498
     (com.palletops.awaze.common/aws-client :iam credentials8496)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8498
      createUser
      (identitymanagement/create-user-request
       (clojure.core/nth args8497 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-role
   [m8499]
   (clojure.core/let
    [credentials8500 (:credentials m8499) args8501 (:args m8499)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8502
      (com.palletops.awaze.common/aws-client :iam credentials8500)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8502
       createRole
       (identitymanagement/create-role-request
        (clojure.core/nth args8501 0)))))))
  (clojure.core/defn
   create-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         path
                         general-progress-listener
                         assume-role-policy-document]}]]),
    :doc "Generate map for createRole"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-role,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         path
                         general-progress-listener
                         assume-role-policy-document]}]]),
    :doc "Call createRole"}
   [credentials8504 & args8505]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8506
     (com.palletops.awaze.common/aws-client :iam credentials8504)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8506
      createRole
      (identitymanagement/create-role-request
       (clojure.core/nth args8505 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user-policy
   [m8507]
   (clojure.core/let
    [credentials8508 (:credentials m8507) args8509 (:args m8507)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8510
      (com.palletops.awaze.common/aws-client :iam credentials8508)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8510
       getUserPolicy
       (identitymanagement/get-user-policy-request
        (clojure.core/nth args8509 0)))))))
  (clojure.core/defn
   get-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Generate map for getUserPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-user-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Call getUserPolicy"}
   [credentials8512 & args8513]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8514
     (com.palletops.awaze.common/aws-client :iam credentials8512)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8514
      getUserPolicy
      (identitymanagement/get-user-policy-request
       (clojure.core/nth args8513 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-users
   [m8515]
   (clojure.core/let
    [credentials8516 (:credentials m8515) args8517 (:args m8515)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8518
      (com.palletops.awaze.common/aws-client :iam credentials8516)]
     (clojure.core/case
      (clojure.core/count args8517)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8518
        listUsers
        (identitymanagement/list-users-request
         (clojure.core/nth args8517 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8518
        listUsers))))))
  (clojure.core/defn
   list-users-map
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listUsers, listUsers"}
   ([credentials__1651__auto__]
    {:args [],
     :client :iam,
     :fn :list-users,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-users,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-users
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call listUsers, listUsers"}
   [credentials8520 & args8521]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8522
     (com.palletops.awaze.common/aws-client :iam credentials8520)]
    (clojure.core/case
     (clojure.core/count args8521)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8522
       listUsers
       (identitymanagement/list-users-request
        (clojure.core/nth args8521 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8522
       listUsers)))))))
