(ns
 com.palletops.awaze.elasticmapreduce
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticmapreduce :as elasticmapreduce]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticmapreduce
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.KeyValue}
key-value
  [m4081]
  (clojure.core/let
   [bean4080
    (new com.amazonaws.services.elasticmapreduce.model.KeyValue)]
   (clojure.core/when-let
    [v4082 (:value m4081)]
    (. bean4080 setValue (clojure.core/str v4082)))
   (clojure.core/when-let
    [v4082 (:key m4081)]
    (. bean4080 setKey (clojure.core/str v4082)))
   bean4080))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceRoleType}
instance-role-type
  [m4084]
  (.
   com.amazonaws.services.elasticmapreduce.model.InstanceRoleType
   fromValue
   (clojure.core/name m4084)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ActionOnFailure}
action-on-failure
  [m4087]
  (.
   com.amazonaws.services.elasticmapreduce.model.ActionOnFailure
   fromValue
   (clojure.core/name m4087)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig}
hadoop-jar-step-config
  [m4090]
  (clojure.core/let
   [bean4089
    (new
     com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig)]
   (clojure.core/when-let
    [v4091 (:properties m4090)]
    (.
     bean4089
     setProperties
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4170] (elasticmapreduce/key-value arg4170))
 v4091)))
   (clojure.core/when-let
    [v4091 (:args m4090)]
    (.
     bean4089
     setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4171] (clojure.core/str arg4171))
 v4091)))
   (clojure.core/when-let
    [v4091 (:jar m4090)]
    (. bean4089 setJar (clojure.core/str v4091)))
   (clojure.core/when-let
    [v4091 (:main-class m4090)]
    (. bean4089 setMainClass (clojure.core/str v4091)))
   bean4089))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig}
script-bootstrap-action-config
  [m4093]
  (clojure.core/let
   [bean4092
    (new
     com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig)]
   (clojure.core/when-let
    [v4094 (:args m4093)]
    (.
     bean4092
     setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4172] (clojure.core/str arg4172))
 v4094)))
   (clojure.core/when-let
    [v4094 (:path m4093)]
    (. bean4092 setPath (clojure.core/str v4094)))
   bean4092))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.PlacementType}
placement-type
  [m4096]
  (clojure.core/let
   [bean4095
    (new com.amazonaws.services.elasticmapreduce.model.PlacementType)]
   (clojure.core/when-let
    [v4097 (:availability-zone m4096)]
    (. bean4095 setAvailabilityZone (clojure.core/str v4097)))
   bean4095))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig}
instance-group-config
  [m4099]
  (clojure.core/let
   [bean4098
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig)]
   (clojure.core/when-let
    [v4100 (:name m4099)]
    (. bean4098 setName (clojure.core/str v4100)))
   (clojure.core/when-let
    [v4100 (:instance-type m4099)]
    (. bean4098 setInstanceType (clojure.core/str v4100)))
   (clojure.core/when-let
    [v4100 (:instance-count m4099)]
    (. bean4098 setInstanceCount (clojure.core/int v4100)))
   (clojure.core/when-let
    [v4100 (:market m4099)]
    (. bean4098 setMarket (clojure.core/str v4100)))
   (clojure.core/when-let
    [v4100 (:instance-role m4099)]
    (.
     bean4098
     setInstanceRole
     (elasticmapreduce/instance-role-type v4100)))
   (clojure.core/when-let
    [v4100 (:bid-price m4099)]
    (. bean4098 setBidPrice (clojure.core/str v4100)))
   bean4098))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.StepConfig}
step-config
  [m4102]
  (clojure.core/let
   [bean4101
    (new com.amazonaws.services.elasticmapreduce.model.StepConfig)]
   (clojure.core/when-let
    [v4103 (:name m4102)]
    (. bean4101 setName (clojure.core/str v4103)))
   (clojure.core/when-let
    [v4103 (:action-on-failure m4102)]
    (.
     bean4101
     setActionOnFailure
     (elasticmapreduce/action-on-failure v4103)))
   (clojure.core/when-let
    [v4103 (:hadoop-jar-step m4102)]
    (.
     bean4101
     setHadoopJarStep
     (elasticmapreduce/hadoop-jar-step-config v4103)))
   bean4101))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig}
bootstrap-action-config
  [m4105]
  (clojure.core/let
   [bean4104
    (new
     com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig)]
   (clojure.core/when-let
    [v4106 (:name m4105)]
    (. bean4104 setName (clojure.core/str v4106)))
   (clojure.core/when-let
    [v4106 (:script-bootstrap-action m4105)]
    (.
     bean4104
     setScriptBootstrapAction
     (elasticmapreduce/script-bootstrap-action-config v4106)))
   bean4104))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig}
supported-product-config
  [m4108]
  (clojure.core/let
   [bean4107
    (new
     com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig)]
   (clojure.core/when-let
    [v4109 (:name m4108)]
    (. bean4107 setName (clojure.core/str v4109)))
   (clojure.core/when-let
    [v4109 (:args m4108)]
    (.
     bean4107
     setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4173] (clojure.core/str arg4173))
 v4109)))
   bean4107))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Tag}
tag
  [m4111]
  (clojure.core/let
   [bean4110 (new com.amazonaws.services.elasticmapreduce.model.Tag)]
   (clojure.core/when-let
    [v4112 (:value m4111)]
    (. bean4110 setValue (clojure.core/str v4112)))
   (clojure.core/when-let
    [v4112 (:key m4111)]
    (. bean4110 setKey (clojure.core/str v4112)))
   bean4110))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig}
job-flow-instances-config
  [m4114]
  (clojure.core/let
   [bean4113
    (new
     com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig)]
   (clojure.core/when-let
    [v4115 (:placement m4114)]
    (. bean4113 setPlacement (elasticmapreduce/placement-type v4115)))
   (clojure.core/when-let
    [v4115 (:keep-job-flow-alive-when-no-steps m4114)]
    (.
     bean4113
     setKeepJobFlowAliveWhenNoSteps
     (clojure.core/boolean v4115)))
   (clojure.core/when-let
    [v4115 (:slave-instance-type m4114)]
    (. bean4113 setSlaveInstanceType (clojure.core/str v4115)))
   (clojure.core/when-let
    [v4115 (:ec2subnet-id m4114)]
    (. bean4113 setEc2SubnetId (clojure.core/str v4115)))
   (clojure.core/when-let
    [v4115 (:instance-groups m4114)]
    (.
     bean4113
     setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4174]
  (elasticmapreduce/instance-group-config arg4174))
 v4115)))
   (clojure.core/when-let
    [v4115 (:termination-protected m4114)]
    (. bean4113 setTerminationProtected (clojure.core/boolean v4115)))
   (clojure.core/when-let
    [v4115 (:hadoop-version m4114)]
    (. bean4113 setHadoopVersion (clojure.core/str v4115)))
   (clojure.core/when-let
    [v4115 (:master-instance-type m4114)]
    (. bean4113 setMasterInstanceType (clojure.core/str v4115)))
   (clojure.core/when-let
    [v4115 (:instance-count m4114)]
    (. bean4113 setInstanceCount (clojure.core/int v4115)))
   (clojure.core/when-let
    [v4115 (:ec2key-name m4114)]
    (. bean4113 setEc2KeyName (clojure.core/str v4115)))
   bean4113))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig}
instance-group-modify-config
  [m4117]
  (clojure.core/let
   [bean4116
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig)]
   (clojure.core/when-let
    [v4118 (:instance-group-id m4117)]
    (. bean4116 setInstanceGroupId (clojure.core/str v4118)))
   (clojure.core/when-let
    [v4118 (:instance-count m4117)]
    (. bean4116 setInstanceCount (clojure.core/int v4118)))
   (clojure.core/when-let
    [v4118 (:ec2instance-ids-to-terminate m4117)]
    (.
     bean4116
     setEC2InstanceIdsToTerminate
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4175] (clojure.core/str arg4175))
 v4118)))
   bean4116))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest}
run-job-flow-request
  [m4120]
  (clojure.core/let
   [bean4119
    (new
     com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest)]
   (clojure.core/when-let
    [v4121 (:steps m4120)]
    (.
     bean4119
     setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4176] (elasticmapreduce/step-config arg4176))
 v4121)))
   (clojure.core/when-let
    [v4121 (:service-role m4120)]
    (. bean4119 setServiceRole (clojure.core/str v4121)))
   (clojure.core/when-let
    [v4121 (:log-uri m4120)]
    (. bean4119 setLogUri (clojure.core/str v4121)))
   (clojure.core/when-let
    [v4121 (:name m4120)]
    (. bean4119 setName (clojure.core/str v4121)))
   (clojure.core/when-let
    [v4121 (:supported-products m4120)]
    (.
     bean4119
     setSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4177] (clojure.core/str arg4177))
 v4121)))
   (clojure.core/when-let
    [v4121 (:bootstrap-actions m4120)]
    (.
     bean4119
     setBootstrapActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4178]
  (elasticmapreduce/bootstrap-action-config arg4178))
 v4121)))
   (clojure.core/when-let
    [v4121 (:visible-to-all-users m4120)]
    (. bean4119 setVisibleToAllUsers (clojure.core/boolean v4121)))
   (clojure.core/when-let
    [v4121 (:new-supported-products m4120)]
    (.
     bean4119
     setNewSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4179]
  (elasticmapreduce/supported-product-config arg4179))
 v4121)))
   (clojure.core/when-let
    [v4121 (:additional-info m4120)]
    (. bean4119 setAdditionalInfo (clojure.core/str v4121)))
   (clojure.core/when-let
    [v4121 (:tags m4120)]
    (.
     bean4119
     setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4180] (elasticmapreduce/tag arg4180))
 v4121)))
   (clojure.core/when-let
    [v4121 (:instances m4120)]
    (.
     bean4119
     setInstances
     (elasticmapreduce/job-flow-instances-config v4121)))
   (clojure.core/when-let
    [v4121 (:ami-version m4120)]
    (. bean4119 setAmiVersion (clojure.core/str v4121)))
   (clojure.core/when-let
    [v4121 (:job-flow-role m4120)]
    (. bean4119 setJobFlowRole (clojure.core/str v4121)))
   bean4119))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest}
list-bootstrap-actions-request
  [m4123]
  (clojure.core/let
   [bean4122
    (new
     com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest)]
   (clojure.core/when-let
    [v4124 (:marker m4123)]
    (. bean4122 setMarker (clojure.core/str v4124)))
   (clojure.core/when-let
    [v4124 (:cluster-id m4123)]
    (. bean4122 setClusterId (clojure.core/str v4124)))
   bean4122))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest}
remove-tags-request
  [m4126]
  (clojure.core/let
   [bean4125
    (new
     com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest)]
   (clojure.core/when-let
    [v4127 (:resource-id m4126)]
    (. bean4125 setResourceId (clojure.core/str v4127)))
   (clojure.core/when-let
    [v4127 (:tag-keys m4126)]
    (.
     bean4125
     setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4181] (clojure.core/str arg4181))
 v4127)))
   bean4125))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest}
list-instance-groups-request
  [m4129]
  (clojure.core/let
   [bean4128
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest)]
   (clojure.core/when-let
    [v4130 (:marker m4129)]
    (. bean4128 setMarker (clojure.core/str v4130)))
   (clojure.core/when-let
    [v4130 (:cluster-id m4129)]
    (. bean4128 setClusterId (clojure.core/str v4130)))
   bean4128))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest}
set-visible-to-all-users-request
  [m4132]
  (clojure.core/let
   [bean4131
    (new
     com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest)]
   (clojure.core/when-let
    [v4133 (:visible-to-all-users m4132)]
    (. bean4131 setVisibleToAllUsers (clojure.core/boolean v4133)))
   (clojure.core/when-let
    [v4133 (:job-flow-ids m4132)]
    (.
     bean4131
     setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4182] (clojure.core/str arg4182))
 v4133)))
   bean4131))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest}
modify-instance-groups-request
  [m4135]
  (clojure.core/let
   [bean4134
    (new
     com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest)]
   (clojure.core/when-let
    [v4136 (:instance-groups m4135)]
    (.
     bean4134
     setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4183]
  (elasticmapreduce/instance-group-modify-config arg4183))
 v4136)))
   bean4134))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest}
describe-cluster-request
  [m4138]
  (clojure.core/let
   [bean4137
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest)]
   (clojure.core/when-let
    [v4139 (:cluster-id m4138)]
    (. bean4137 setClusterId (clojure.core/str v4139)))
   bean4137))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddTagsRequest}
add-tags-request
  [m4141]
  (clojure.core/let
   [bean4140
    (new com.amazonaws.services.elasticmapreduce.model.AddTagsRequest)]
   (clojure.core/when-let
    [v4142 (:tags m4141)]
    (.
     bean4140
     setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4184] (elasticmapreduce/tag arg4184))
 v4142)))
   (clojure.core/when-let
    [v4142 (:resource-id m4141)]
    (. bean4140 setResourceId (clojure.core/str v4142)))
   bean4140))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest}
set-termination-protection-request
  [m4144]
  (clojure.core/let
   [bean4143
    (new
     com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest)]
   (clojure.core/when-let
    [v4145 (:job-flow-ids m4144)]
    (.
     bean4143
     setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4185] (clojure.core/str arg4185))
 v4145)))
   (clojure.core/when-let
    [v4145 (:termination-protected m4144)]
    (. bean4143 setTerminationProtected (clojure.core/boolean v4145)))
   bean4143))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest}
add-instance-groups-request
  [m4147]
  (clojure.core/let
   [bean4146
    (new
     com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest)]
   (clojure.core/when-let
    [v4148 (:job-flow-id m4147)]
    (. bean4146 setJobFlowId (clojure.core/str v4148)))
   (clojure.core/when-let
    [v4148 (:instance-groups m4147)]
    (.
     bean4146
     setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4186]
  (elasticmapreduce/instance-group-config arg4186))
 v4148)))
   bean4146))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest}
describe-step-request
  [m4150]
  (clojure.core/let
   [bean4149
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest)]
   (clojure.core/when-let
    [v4151 (:cluster-id m4150)]
    (. bean4149 setClusterId (clojure.core/str v4151)))
   (clojure.core/when-let
    [v4151 (:step-id m4150)]
    (. bean4149 setStepId (clojure.core/str v4151)))
   bean4149))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest}
terminate-job-flows-request
  [m4153]
  (clojure.core/let
   [bean4152
    (new
     com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest)]
   (clojure.core/when-let
    [v4154 (:job-flow-ids m4153)]
    (.
     bean4152
     setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4187] (clojure.core/str arg4187))
 v4154)))
   bean4152))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest}
list-instances-request
  [m4156]
  (clojure.core/let
   [bean4155
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest)]
   (clojure.core/when-let
    [v4157 (:marker m4156)]
    (. bean4155 setMarker (clojure.core/str v4157)))
   (clojure.core/when-let
    [v4157 (:cluster-id m4156)]
    (. bean4155 setClusterId (clojure.core/str v4157)))
   (clojure.core/when-let
    [v4157 (:instance-group-id m4156)]
    (. bean4155 setInstanceGroupId (clojure.core/str v4157)))
   (clojure.core/when-let
    [v4157 (:instance-group-types m4156)]
    (.
     bean4155
     setInstanceGroupTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4188] (clojure.core/str arg4188))
 v4157)))
   bean4155))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListClustersRequest}
list-clusters-request
  [m4159]
  (clojure.core/let
   [bean4158
    (new
     com.amazonaws.services.elasticmapreduce.model.ListClustersRequest)]
   (clojure.core/when-let
    [v4160 (:marker m4159)]
    (. bean4158 setMarker (clojure.core/str v4160)))
   (clojure.core/when-let
    [v4160 (:created-after m4159)]
    (.
     bean4158
     setCreatedAfter
     (com.palletops.awaze.common/to-date v4160)))
   (clojure.core/when-let
    [v4160 (:created-before m4159)]
    (.
     bean4158
     setCreatedBefore
     (com.palletops.awaze.common/to-date v4160)))
   (clojure.core/when-let
    [v4160 (:cluster-states m4159)]
    (.
     bean4158
     setClusterStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4189] (clojure.core/str arg4189))
 v4160)))
   bean4158))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest}
add-job-flow-steps-request
  [m4162]
  (clojure.core/let
   [bean4161
    (new
     com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest)]
   (clojure.core/when-let
    [v4163 (:job-flow-id m4162)]
    (. bean4161 setJobFlowId (clojure.core/str v4163)))
   (clojure.core/when-let
    [v4163 (:steps m4162)]
    (.
     bean4161
     setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4190] (elasticmapreduce/step-config arg4190))
 v4163)))
   bean4161))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListStepsRequest}
list-steps-request
  [m4165]
  (clojure.core/let
   [bean4164
    (new
     com.amazonaws.services.elasticmapreduce.model.ListStepsRequest)]
   (clojure.core/when-let
    [v4166 (:marker m4165)]
    (. bean4164 setMarker (clojure.core/str v4166)))
   (clojure.core/when-let
    [v4166 (:cluster-id m4165)]
    (. bean4164 setClusterId (clojure.core/str v4166)))
   (clojure.core/when-let
    [v4166 (:step-states m4165)]
    (.
     bean4164
     setStepStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4191] (clojure.core/str arg4191))
 v4166)))
   bean4164))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest}
describe-job-flows-request
  [m4168]
  (clojure.core/let
   [bean4167
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest)]
   (clojure.core/when-let
    [v4169 (:job-flow-ids m4168)]
    (.
     bean4167
     setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4192] (clojure.core/str arg4192))
 v4169)))
   (clojure.core/when-let
    [v4169 (:created-after m4168)]
    (.
     bean4167
     setCreatedAfter
     (com.palletops.awaze.common/to-date v4169)))
   (clojure.core/when-let
    [v4169 (:created-before m4168)]
    (.
     bean4167
     setCreatedBefore
     (com.palletops.awaze.common/to-date v4169)))
   (clojure.core/when-let
    [v4169 (:job-flow-states m4168)]
    (.
     bean4167
     setJobFlowStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4193] (clojure.core/str arg4193))
 v4169)))
   bean4167))
 (clojure.core/defmulti
  elasticmapreduce
  (clojure.core/fn
   elasticmapreduce
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :run-job-flow
   [m4194]
   (clojure.core/let
    [credentials4195 (:credentials m4194) args4196 (:args m4194)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4197
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4195)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4197
       runJobFlow
       (elasticmapreduce/run-job-flow-request
        (clojure.core/nth args4196 0)))))))
  (clojure.core/defn
   run-job-flow-map
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-role
                         additional-info
                         general-progress-listener
                         name
                         service-role
                         log-uri
                         bootstrap-actions
                         visible-to-all-users
                         supported-products
                         ami-version
                         steps
                         new-supported-products
                         instances
                         tags]}]]),
    :doc "Generate map for runJobFlow"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :run-job-flow,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   run-job-flow
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-role
                         additional-info
                         general-progress-listener
                         name
                         service-role
                         log-uri
                         bootstrap-actions
                         visible-to-all-users
                         supported-products
                         ami-version
                         steps
                         new-supported-products
                         instances
                         tags]}]]),
    :doc "Call runJobFlow"}
   [credentials4199 & args4200]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4201
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4199)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4201
      runJobFlow
      (elasticmapreduce/run-job-flow-request
       (clojure.core/nth args4200 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-bootstrap-actions
   [m4202]
   (clojure.core/let
    [credentials4203 (:credentials m4202) args4204 (:args m4202)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4205
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4203)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4205
       listBootstrapActions
       (elasticmapreduce/list-bootstrap-actions-request
        (clojure.core/nth args4204 0)))))))
  (clojure.core/defn
   list-bootstrap-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [marker general-progress-listener cluster-id]}]]),
    :doc "Generate map for listBootstrapActions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-bootstrap-actions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-bootstrap-actions
   {:arglists (quote
               [[credentials
                 {:keys [marker general-progress-listener cluster-id]}]]),
    :doc "Call listBootstrapActions"}
   [credentials4207 & args4208]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4209
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4207)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4209
      listBootstrapActions
      (elasticmapreduce/list-bootstrap-actions-request
       (clojure.core/nth args4208 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :remove-tags
   [m4210]
   (clojure.core/let
    [credentials4211 (:credentials m4210) args4212 (:args m4210)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4213
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4211)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4213
       removeTags
       (elasticmapreduce/remove-tags-request
        (clojure.core/nth args4212 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tag-keys
                         resource-id
                         general-progress-listener]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :remove-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [tag-keys
                         resource-id
                         general-progress-listener]}]]),
    :doc "Call removeTags"}
   [credentials4215 & args4216]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4217
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4215)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4217
      removeTags
      (elasticmapreduce/remove-tags-request
       (clojure.core/nth args4216 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instance-groups
   [m4218]
   (clojure.core/let
    [credentials4219 (:credentials m4218) args4220 (:args m4218)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4221
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4219)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4221
       listInstanceGroups
       (elasticmapreduce/list-instance-groups-request
        (clojure.core/nth args4220 0)))))))
  (clojure.core/defn
   list-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [marker general-progress-listener cluster-id]}]]),
    :doc "Generate map for listInstanceGroups"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-instance-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [marker general-progress-listener cluster-id]}]]),
    :doc "Call listInstanceGroups"}
   [credentials4223 & args4224]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4225
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4223)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4225
      listInstanceGroups
      (elasticmapreduce/list-instance-groups-request
       (clojure.core/nth args4224 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-visible-to-all-users
   [m4226]
   (clojure.core/let
    [credentials4227 (:credentials m4226) args4228 (:args m4226)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4229
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4227)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4229
       setVisibleToAllUsers
       (elasticmapreduce/set-visible-to-all-users-request
        (clojure.core/nth args4228 0)))))))
  (clojure.core/defn
   set-visible-to-all-users-map
   {:arglists (quote
               [[credentials
                 {:keys [visible-to-all-users
                         job-flow-ids
                         general-progress-listener]}]]),
    :doc "Generate map for setVisibleToAllUsers"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :set-visible-to-all-users,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-visible-to-all-users
   {:arglists (quote
               [[credentials
                 {:keys [visible-to-all-users
                         job-flow-ids
                         general-progress-listener]}]]),
    :doc "Call setVisibleToAllUsers"}
   [credentials4231 & args4232]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4233
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4231)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4233
      setVisibleToAllUsers
      (elasticmapreduce/set-visible-to-all-users-request
       (clojure.core/nth args4232 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :modify-instance-groups
   [m4234]
   (clojure.core/let
    [credentials4235 (:credentials m4234) args4236 (:args m4234)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4237
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4235)]
     (clojure.core/case
      (clojure.core/count args4236)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4237
        modifyInstanceGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4237
        modifyInstanceGroups
        (elasticmapreduce/modify-instance-groups-request
         (clojure.core/nth args4236 0))))))))
  (clojure.core/defn
   modify-instance-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [instance-groups general-progress-listener]}]]),
    :doc "Generate map for modifyInstanceGroups, modifyInstanceGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :modify-instance-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :modify-instance-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-instance-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [instance-groups general-progress-listener]}]]),
    :doc "Call modifyInstanceGroups, modifyInstanceGroups"}
   [credentials4239 & args4240]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4241
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4239)]
    (clojure.core/case
     (clojure.core/count args4240)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4241
       modifyInstanceGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4241
       modifyInstanceGroups
       (elasticmapreduce/modify-instance-groups-request
        (clojure.core/nth args4240 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-cluster
   [m4242]
   (clojure.core/let
    [credentials4243 (:credentials m4242) args4244 (:args m4242)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4245
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4243)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4245
       describeCluster
       (elasticmapreduce/describe-cluster-request
        (clojure.core/nth args4244 0)))))))
  (clojure.core/defn
   describe-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-id]}]]),
    :doc "Generate map for describeCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :describe-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cluster
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-id]}]]),
    :doc "Call describeCluster"}
   [credentials4247 & args4248]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4249
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4247)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4249
      describeCluster
      (elasticmapreduce/describe-cluster-request
       (clojure.core/nth args4248 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-tags
   [m4250]
   (clojure.core/let
    [credentials4251 (:credentials m4250) args4252 (:args m4250)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4253
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4251)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4253
       addTags
       (elasticmapreduce/add-tags-request
        (clojure.core/nth args4252 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags resource-id general-progress-listener]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :add-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags resource-id general-progress-listener]}]]),
    :doc "Call addTags"}
   [credentials4255 & args4256]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4257
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4255)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4257
      addTags
      (elasticmapreduce/add-tags-request
       (clojure.core/nth args4256 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-termination-protection
   [m4258]
   (clojure.core/let
    [credentials4259 (:credentials m4258) args4260 (:args m4258)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4261
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4259)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4261
       setTerminationProtection
       (elasticmapreduce/set-termination-protection-request
        (clojure.core/nth args4260 0)))))))
  (clojure.core/defn
   set-termination-protection-map
   {:arglists (quote
               [[credentials
                 {:keys [termination-protected
                         job-flow-ids
                         general-progress-listener]}]]),
    :doc "Generate map for setTerminationProtection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :set-termination-protection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-termination-protection
   {:arglists (quote
               [[credentials
                 {:keys [termination-protected
                         job-flow-ids
                         general-progress-listener]}]]),
    :doc "Call setTerminationProtection"}
   [credentials4263 & args4264]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4265
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4263)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4265
      setTerminationProtection
      (elasticmapreduce/set-termination-protection-request
       (clojure.core/nth args4264 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-instance-groups
   [m4266]
   (clojure.core/let
    [credentials4267 (:credentials m4266) args4268 (:args m4266)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4269
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4267)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4269
       addInstanceGroups
       (elasticmapreduce/add-instance-groups-request
        (clojure.core/nth args4268 0)))))))
  (clojure.core/defn
   add-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-id
                         instance-groups
                         general-progress-listener]}]]),
    :doc "Generate map for addInstanceGroups"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :add-instance-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-id
                         instance-groups
                         general-progress-listener]}]]),
    :doc "Call addInstanceGroups"}
   [credentials4271 & args4272]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4273
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4271)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4273
      addInstanceGroups
      (elasticmapreduce/add-instance-groups-request
       (clojure.core/nth args4272 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-step
   [m4274]
   (clojure.core/let
    [credentials4275 (:credentials m4274) args4276 (:args m4274)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4277
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4275)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4277
       describeStep
       (elasticmapreduce/describe-step-request
        (clojure.core/nth args4276 0)))))))
  (clojure.core/defn
   describe-step-map
   {:arglists (quote
               [[credentials
                 {:keys [step-id general-progress-listener cluster-id]}]]),
    :doc "Generate map for describeStep"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :describe-step,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-step
   {:arglists (quote
               [[credentials
                 {:keys [step-id general-progress-listener cluster-id]}]]),
    :doc "Call describeStep"}
   [credentials4279 & args4280]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4281
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4279)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4281
      describeStep
      (elasticmapreduce/describe-step-request
       (clojure.core/nth args4280 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :terminate-job-flows
   [m4282]
   (clojure.core/let
    [credentials4283 (:credentials m4282) args4284 (:args m4282)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4285
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4283)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4285
       terminateJobFlows
       (elasticmapreduce/terminate-job-flows-request
        (clojure.core/nth args4284 0)))))))
  (clojure.core/defn
   terminate-job-flows-map
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-ids general-progress-listener]}]]),
    :doc "Generate map for terminateJobFlows"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :terminate-job-flows,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   terminate-job-flows
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-ids general-progress-listener]}]]),
    :doc "Call terminateJobFlows"}
   [credentials4287 & args4288]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4289
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4287)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4289
      terminateJobFlows
      (elasticmapreduce/terminate-job-flows-request
       (clojure.core/nth args4288 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instances
   [m4290]
   (clojure.core/let
    [credentials4291 (:credentials m4290) args4292 (:args m4290)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4293
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4291)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4293
       listInstances
       (elasticmapreduce/list-instances-request
        (clojure.core/nth args4292 0)))))))
  (clojure.core/defn
   list-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         instance-group-types
                         instance-group-id
                         general-progress-listener
                         cluster-id]}]]),
    :doc "Generate map for listInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-instances
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         instance-group-types
                         instance-group-id
                         general-progress-listener
                         cluster-id]}]]),
    :doc "Call listInstances"}
   [credentials4295 & args4296]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4297
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4295)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4297
      listInstances
      (elasticmapreduce/list-instances-request
       (clojure.core/nth args4296 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-clusters
   [m4298]
   (clojure.core/let
    [credentials4299 (:credentials m4298) args4300 (:args m4298)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4301
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4299)]
     (clojure.core/case
      (clojure.core/count args4300)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4301
        listClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4301
        listClusters
        (elasticmapreduce/list-clusters-request
         (clojure.core/nth args4300 0))))))))
  (clojure.core/defn
   list-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker
                         general-progress-listener
                         created-before
                         created-after
                         cluster-states]}]]),
    :doc "Generate map for listClusters, listClusters"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :list-clusters,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-clusters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker
                         general-progress-listener
                         created-before
                         created-after
                         cluster-states]}]]),
    :doc "Call listClusters, listClusters"}
   [credentials4303 & args4304]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4305
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4303)]
    (clojure.core/case
     (clojure.core/count args4304)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4305
       listClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4305
       listClusters
       (elasticmapreduce/list-clusters-request
        (clojure.core/nth args4304 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-job-flow-steps
   [m4306]
   (clojure.core/let
    [credentials4307 (:credentials m4306) args4308 (:args m4306)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4309
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4307)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4309
       addJobFlowSteps
       (elasticmapreduce/add-job-flow-steps-request
        (clojure.core/nth args4308 0)))))))
  (clojure.core/defn
   add-job-flow-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [steps job-flow-id general-progress-listener]}]]),
    :doc "Generate map for addJobFlowSteps"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :add-job-flow-steps,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-job-flow-steps
   {:arglists (quote
               [[credentials
                 {:keys [steps job-flow-id general-progress-listener]}]]),
    :doc "Call addJobFlowSteps"}
   [credentials4311 & args4312]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4313
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4311)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4313
      addJobFlowSteps
      (elasticmapreduce/add-job-flow-steps-request
       (clojure.core/nth args4312 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-steps
   [m4314]
   (clojure.core/let
    [credentials4315 (:credentials m4314) args4316 (:args m4314)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4317
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4315)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4317
       listSteps
       (elasticmapreduce/list-steps-request
        (clojure.core/nth args4316 0)))))))
  (clojure.core/defn
   list-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [step-states
                         marker
                         general-progress-listener
                         cluster-id]}]]),
    :doc "Generate map for listSteps"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-steps,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-steps
   {:arglists (quote
               [[credentials
                 {:keys [step-states
                         marker
                         general-progress-listener
                         cluster-id]}]]),
    :doc "Call listSteps"}
   [credentials4319 & args4320]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4321
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4319)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4321
      listSteps
      (elasticmapreduce/list-steps-request
       (clojure.core/nth args4320 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-job-flows
   [m4322]
   (clojure.core/let
    [credentials4323 (:credentials m4322) args4324 (:args m4322)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4325
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4323)]
     (clojure.core/case
      (clojure.core/count args4324)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4325
        describeJobFlows
        (elasticmapreduce/describe-job-flows-request
         (clojure.core/nth args4324 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4325
        describeJobFlows))))))
  (clojure.core/defn
   describe-job-flows-map
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-states
                         job-flow-ids
                         general-progress-listener
                         created-before
                         created-after]}]
                [credentials]]),
    :doc "Generate map for describeJobFlows, describeJobFlows"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :describe-job-flows,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :describe-job-flows,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-job-flows
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-states
                         job-flow-ids
                         general-progress-listener
                         created-before
                         created-after]}]
                [credentials]]),
    :doc "Call describeJobFlows, describeJobFlows"}
   [credentials4327 & args4328]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4329
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4327)]
    (clojure.core/case
     (clojure.core/count args4328)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4329
       describeJobFlows
       (elasticmapreduce/describe-job-flows-request
        (clojure.core/nth args4328 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4329
       describeJobFlows)))))))
