(ns
 com.palletops.awaze.elasticache
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticache :as elasticache]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticache
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.elasticache.AmazonElastiCacheClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ParameterNameValue}
parameter-name-value
  [m10898]
  (clojure.core/let
   [bean10897
    (new com.amazonaws.services.elasticache.model.ParameterNameValue)]
   (clojure.core/when-let
    [v10899 (:parameter-name m10898)]
    (. bean10897 setParameterName (clojure.core/str v10899)))
   (clojure.core/when-let
    [v10899 (:parameter-value m10898)]
    (. bean10897 setParameterValue (clojure.core/str v10899)))
   bean10897))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.SourceType}
source-type
  [m10901]
  (.
   com.amazonaws.services.elasticache.model.SourceType
   fromValue
   (clojure.core/name m10901)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest}
describe-cache-parameter-groups-request
  [m10904]
  (clojure.core/let
   [bean10903
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest)]
   (clojure.core/when-let
    [v10905 (:marker m10904)]
    (. bean10903 setMarker (clojure.core/str v10905)))
   (clojure.core/when-let
    [v10905 (:max-records m10904)]
    (. bean10903 setMaxRecords (clojure.core/int v10905)))
   (clojure.core/when-let
    [v10905 (:cache-parameter-group-name m10904)]
    (. bean10903 setCacheParameterGroupName (clojure.core/str v10905)))
   bean10903))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest}
create-cache-parameter-group-request
  [m10907]
  (clojure.core/let
   [bean10906
    (new
     com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v10908 (:description m10907)]
    (. bean10906 setDescription (clojure.core/str v10908)))
   (clojure.core/when-let
    [v10908 (:cache-parameter-group-family m10907)]
    (.
     bean10906
     setCacheParameterGroupFamily
     (clojure.core/str v10908)))
   (clojure.core/when-let
    [v10908 (:cache-parameter-group-name m10907)]
    (. bean10906 setCacheParameterGroupName (clojure.core/str v10908)))
   bean10906))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest}
revoke-cache-security-group-ingress-request
  [m10910]
  (clojure.core/let
   [bean10909
    (new
     com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v10911 (:ec2security-group-name m10910)]
    (. bean10909 setEC2SecurityGroupName (clojure.core/str v10911)))
   (clojure.core/when-let
    [v10911 (:ec2security-group-owner-id m10910)]
    (. bean10909 setEC2SecurityGroupOwnerId (clojure.core/str v10911)))
   (clojure.core/when-let
    [v10911 (:cache-security-group-name m10910)]
    (. bean10909 setCacheSecurityGroupName (clojure.core/str v10911)))
   bean10909))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest}
create-replication-group-request
  [m10913]
  (clojure.core/let
   [bean10912
    (new
     com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest)]
   (clojure.core/when-let
    [v10914 (:replication-group-id m10913)]
    (. bean10912 setReplicationGroupId (clojure.core/str v10914)))
   (clojure.core/when-let
    [v10914 (:replication-group-description m10913)]
    (.
     bean10912
     setReplicationGroupDescription
     (clojure.core/str v10914)))
   (clojure.core/when-let
    [v10914 (:primary-cluster-id m10913)]
    (. bean10912 setPrimaryClusterId (clojure.core/str v10914)))
   bean10912))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m10916]
  (clojure.core/let
   [bean10915
    (new
     com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest)]
   (clojure.core/when-let
    [v10917 (:marker m10916)]
    (. bean10915 setMarker (clojure.core/str v10917)))
   (clojure.core/when-let
    [v10917 (:max-records m10916)]
    (. bean10915 setMaxRecords (clojure.core/int v10917)))
   (clojure.core/when-let
    [v10917 (:snapshot-name m10916)]
    (. bean10915 setSnapshotName (clojure.core/str v10917)))
   (clojure.core/when-let
    [v10917 (:cache-cluster-id m10916)]
    (. bean10915 setCacheClusterId (clojure.core/str v10917)))
   (clojure.core/when-let
    [v10917 (:snapshot-source m10916)]
    (. bean10915 setSnapshotSource (clojure.core/str v10917)))
   bean10915))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest}
authorize-cache-security-group-ingress-request
  [m10919]
  (clojure.core/let
   [bean10918
    (new
     com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v10920 (:ec2security-group-name m10919)]
    (. bean10918 setEC2SecurityGroupName (clojure.core/str v10920)))
   (clojure.core/when-let
    [v10920 (:ec2security-group-owner-id m10919)]
    (. bean10918 setEC2SecurityGroupOwnerId (clojure.core/str v10920)))
   (clojure.core/when-let
    [v10920 (:cache-security-group-name m10919)]
    (. bean10918 setCacheSecurityGroupName (clojure.core/str v10920)))
   bean10918))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest}
describe-reserved-cache-nodes-request
  [m10922]
  (clojure.core/let
   [bean10921
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest)]
   (clojure.core/when-let
    [v10923 (:marker m10922)]
    (. bean10921 setMarker (clojure.core/str v10923)))
   (clojure.core/when-let
    [v10923 (:max-records m10922)]
    (. bean10921 setMaxRecords (clojure.core/int v10923)))
   (clojure.core/when-let
    [v10923 (:duration m10922)]
    (. bean10921 setDuration (clojure.core/str v10923)))
   (clojure.core/when-let
    [v10923 (:offering-type m10922)]
    (. bean10921 setOfferingType (clojure.core/str v10923)))
   (clojure.core/when-let
    [v10923 (:product-description m10922)]
    (. bean10921 setProductDescription (clojure.core/str v10923)))
   (clojure.core/when-let
    [v10923 (:cache-node-type m10922)]
    (. bean10921 setCacheNodeType (clojure.core/str v10923)))
   (clojure.core/when-let
    [v10923 (:reserved-cache-nodes-offering-id m10922)]
    (.
     bean10921
     setReservedCacheNodesOfferingId
     (clojure.core/str v10923)))
   (clojure.core/when-let
    [v10923 (:reserved-cache-node-id m10922)]
    (. bean10921 setReservedCacheNodeId (clojure.core/str v10923)))
   bean10921))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest}
modify-cache-cluster-request
  [m10925]
  (clojure.core/let
   [bean10924
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest)]
   (clojure.core/when-let
    [v10926 (:cache-parameter-group-name m10925)]
    (. bean10924 setCacheParameterGroupName (clojure.core/str v10926)))
   (clojure.core/when-let
    [v10926 (:snapshot-retention-limit m10925)]
    (. bean10924 setSnapshotRetentionLimit (clojure.core/int v10926)))
   (clojure.core/when-let
    [v10926 (:preferred-maintenance-window m10925)]
    (.
     bean10924
     setPreferredMaintenanceWindow
     (clojure.core/str v10926)))
   (clojure.core/when-let
    [v10926 (:auto-minor-version-upgrade m10925)]
    (.
     bean10924
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v10926)))
   (clojure.core/when-let
    [v10926 (:cache-security-group-names m10925)]
    (.
     bean10924
     setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11005] (clojure.core/str arg11005))
 v10926)))
   (clojure.core/when-let
    [v10926 (:apply-immediately m10925)]
    (. bean10924 setApplyImmediately (clojure.core/boolean v10926)))
   (clojure.core/when-let
    [v10926 (:num-cache-nodes m10925)]
    (. bean10924 setNumCacheNodes (clojure.core/int v10926)))
   (clojure.core/when-let
    [v10926 (:notification-topic-status m10925)]
    (. bean10924 setNotificationTopicStatus (clojure.core/str v10926)))
   (clojure.core/when-let
    [v10926 (:engine-version m10925)]
    (. bean10924 setEngineVersion (clojure.core/str v10926)))
   (clojure.core/when-let
    [v10926 (:cache-cluster-id m10925)]
    (. bean10924 setCacheClusterId (clojure.core/str v10926)))
   (clojure.core/when-let
    [v10926 (:cache-node-ids-to-remove m10925)]
    (.
     bean10924
     setCacheNodeIdsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11006] (clojure.core/str arg11006))
 v10926)))
   (clojure.core/when-let
    [v10926 (:snapshot-window m10925)]
    (. bean10924 setSnapshotWindow (clojure.core/str v10926)))
   (clojure.core/when-let
    [v10926 (:notification-topic-arn m10925)]
    (. bean10924 setNotificationTopicArn (clojure.core/str v10926)))
   (clojure.core/when-let
    [v10926 (:security-group-ids m10925)]
    (.
     bean10924
     setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11007] (clojure.core/str arg11007))
 v10926)))
   bean10924))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest}
delete-cache-subnet-group-request
  [m10928]
  (clojure.core/let
   [bean10927
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest)]
   (clojure.core/when-let
    [v10929 (:cache-subnet-group-name m10928)]
    (. bean10927 setCacheSubnetGroupName (clojure.core/str v10929)))
   bean10927))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest}
describe-cache-engine-versions-request
  [m10931]
  (clojure.core/let
   [bean10930
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest)]
   (clojure.core/when-let
    [v10932 (:marker m10931)]
    (. bean10930 setMarker (clojure.core/str v10932)))
   (clojure.core/when-let
    [v10932 (:max-records m10931)]
    (. bean10930 setMaxRecords (clojure.core/int v10932)))
   (clojure.core/when-let
    [v10932 (:engine m10931)]
    (. bean10930 setEngine (clojure.core/str v10932)))
   (clojure.core/when-let
    [v10932 (:engine-version m10931)]
    (. bean10930 setEngineVersion (clojure.core/str v10932)))
   (clojure.core/when-let
    [v10932 (:default-only m10931)]
    (. bean10930 setDefaultOnly (clojure.core/boolean v10932)))
   (clojure.core/when-let
    [v10932 (:cache-parameter-group-family m10931)]
    (.
     bean10930
     setCacheParameterGroupFamily
     (clojure.core/str v10932)))
   bean10930))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest}
reset-cache-parameter-group-request
  [m10934]
  (clojure.core/let
   [bean10933
    (new
     com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v10935 (:reset-all-parameters m10934)]
    (. bean10933 setResetAllParameters (clojure.core/boolean v10935)))
   (clojure.core/when-let
    [v10935 (:cache-parameter-group-name m10934)]
    (. bean10933 setCacheParameterGroupName (clojure.core/str v10935)))
   (clojure.core/when-let
    [v10935 (:parameter-name-values m10934)]
    (.
     bean10933
     setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11008]
  (elasticache/parameter-name-value arg11008))
 v10935)))
   bean10933))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest}
describe-engine-default-parameters-request
  [m10937]
  (clojure.core/let
   [bean10936
    (new
     com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest)]
   (clojure.core/when-let
    [v10938 (:marker m10937)]
    (. bean10936 setMarker (clojure.core/str v10938)))
   (clojure.core/when-let
    [v10938 (:max-records m10937)]
    (. bean10936 setMaxRecords (clojure.core/int v10938)))
   (clojure.core/when-let
    [v10938 (:cache-parameter-group-family m10937)]
    (.
     bean10936
     setCacheParameterGroupFamily
     (clojure.core/str v10938)))
   bean10936))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest}
delete-cache-cluster-request
  [m10940]
  (clojure.core/let
   [bean10939
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest)]
   (clojure.core/when-let
    [v10941 (:cache-cluster-id m10940)]
    (. bean10939 setCacheClusterId (clojure.core/str v10941)))
   (clojure.core/when-let
    [v10941 (:final-snapshot-identifier m10940)]
    (. bean10939 setFinalSnapshotIdentifier (clojure.core/str v10941)))
   bean10939))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest}
describe-cache-subnet-groups-request
  [m10943]
  (clojure.core/let
   [bean10942
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest)]
   (clojure.core/when-let
    [v10944 (:marker m10943)]
    (. bean10942 setMarker (clojure.core/str v10944)))
   (clojure.core/when-let
    [v10944 (:max-records m10943)]
    (. bean10942 setMaxRecords (clojure.core/int v10944)))
   (clojure.core/when-let
    [v10944 (:cache-subnet-group-name m10943)]
    (. bean10942 setCacheSubnetGroupName (clojure.core/str v10944)))
   bean10942))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest}
describe-replication-groups-request
  [m10946]
  (clojure.core/let
   [bean10945
    (new
     com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest)]
   (clojure.core/when-let
    [v10947 (:marker m10946)]
    (. bean10945 setMarker (clojure.core/str v10947)))
   (clojure.core/when-let
    [v10947 (:max-records m10946)]
    (. bean10945 setMaxRecords (clojure.core/int v10947)))
   (clojure.core/when-let
    [v10947 (:replication-group-id m10946)]
    (. bean10945 setReplicationGroupId (clojure.core/str v10947)))
   bean10945))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest}
describe-cache-security-groups-request
  [m10949]
  (clojure.core/let
   [bean10948
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest)]
   (clojure.core/when-let
    [v10950 (:marker m10949)]
    (. bean10948 setMarker (clojure.core/str v10950)))
   (clojure.core/when-let
    [v10950 (:max-records m10949)]
    (. bean10948 setMaxRecords (clojure.core/int v10950)))
   (clojure.core/when-let
    [v10950 (:cache-security-group-name m10949)]
    (. bean10948 setCacheSecurityGroupName (clojure.core/str v10950)))
   bean10948))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest}
create-cache-security-group-request
  [m10952]
  (clojure.core/let
   [bean10951
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest)]
   (clojure.core/when-let
    [v10953 (:description m10952)]
    (. bean10951 setDescription (clojure.core/str v10953)))
   (clojure.core/when-let
    [v10953 (:cache-security-group-name m10952)]
    (. bean10951 setCacheSecurityGroupName (clojure.core/str v10953)))
   bean10951))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest}
describe-cache-clusters-request
  [m10955]
  (clojure.core/let
   [bean10954
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest)]
   (clojure.core/when-let
    [v10956 (:marker m10955)]
    (. bean10954 setMarker (clojure.core/str v10956)))
   (clojure.core/when-let
    [v10956 (:max-records m10955)]
    (. bean10954 setMaxRecords (clojure.core/int v10956)))
   (clojure.core/when-let
    [v10956 (:show-cache-node-info m10955)]
    (. bean10954 setShowCacheNodeInfo (clojure.core/boolean v10956)))
   (clojure.core/when-let
    [v10956 (:cache-cluster-id m10955)]
    (. bean10954 setCacheClusterId (clojure.core/str v10956)))
   bean10954))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEventsRequest}
describe-events-request
  [m10958]
  (clojure.core/let
   [bean10957
    (new
     com.amazonaws.services.elasticache.model.DescribeEventsRequest)]
   (clojure.core/when-let
    [v10959 (:marker m10958)]
    (. bean10957 setMarker (clojure.core/str v10959)))
   (clojure.core/when-let
    [v10959 (:max-records m10958)]
    (. bean10957 setMaxRecords (clojure.core/int v10959)))
   (clojure.core/when-let
    [v10959 (:source-identifier m10958)]
    (. bean10957 setSourceIdentifier (clojure.core/str v10959)))
   (clojure.core/when-let
    [v10959 (:source-type m10958)]
    (. bean10957 setSourceType (elasticache/source-type v10959)))
   (clojure.core/when-let
    [v10959 (:start-time m10958)]
    (.
     bean10957
     setStartTime
     (com.palletops.awaze.common/to-date v10959)))
   (clojure.core/when-let
    [v10959 (:end-time m10958)]
    (.
     bean10957
     setEndTime
     (com.palletops.awaze.common/to-date v10959)))
   (clojure.core/when-let
    [v10959 (:duration m10958)]
    (. bean10957 setDuration (clojure.core/int v10959)))
   bean10957))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest}
modify-cache-parameter-group-request
  [m10961]
  (clojure.core/let
   [bean10960
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v10962 (:cache-parameter-group-name m10961)]
    (. bean10960 setCacheParameterGroupName (clojure.core/str v10962)))
   (clojure.core/when-let
    [v10962 (:parameter-name-values m10961)]
    (.
     bean10960
     setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11009]
  (elasticache/parameter-name-value arg11009))
 v10962)))
   bean10960))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest}
delete-cache-security-group-request
  [m10964]
  (clojure.core/let
   [bean10963
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest)]
   (clojure.core/when-let
    [v10965 (:cache-security-group-name m10964)]
    (. bean10963 setCacheSecurityGroupName (clojure.core/str v10965)))
   bean10963))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest}
create-cache-subnet-group-request
  [m10967]
  (clojure.core/let
   [bean10966
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest)]
   (clojure.core/when-let
    [v10968 (:subnet-ids m10967)]
    (.
     bean10966
     setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11010] (clojure.core/str arg11010))
 v10968)))
   (clojure.core/when-let
    [v10968 (:cache-subnet-group-name m10967)]
    (. bean10966 setCacheSubnetGroupName (clojure.core/str v10968)))
   (clojure.core/when-let
    [v10968 (:cache-subnet-group-description m10967)]
    (.
     bean10966
     setCacheSubnetGroupDescription
     (clojure.core/str v10968)))
   bean10966))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest}
modify-replication-group-request
  [m10970]
  (clojure.core/let
   [bean10969
    (new
     com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest)]
   (clojure.core/when-let
    [v10971 (:cache-parameter-group-name m10970)]
    (. bean10969 setCacheParameterGroupName (clojure.core/str v10971)))
   (clojure.core/when-let
    [v10971 (:snapshotting-cluster-id m10970)]
    (. bean10969 setSnapshottingClusterId (clojure.core/str v10971)))
   (clojure.core/when-let
    [v10971 (:snapshot-retention-limit m10970)]
    (. bean10969 setSnapshotRetentionLimit (clojure.core/int v10971)))
   (clojure.core/when-let
    [v10971 (:preferred-maintenance-window m10970)]
    (.
     bean10969
     setPreferredMaintenanceWindow
     (clojure.core/str v10971)))
   (clojure.core/when-let
    [v10971 (:replication-group-description m10970)]
    (.
     bean10969
     setReplicationGroupDescription
     (clojure.core/str v10971)))
   (clojure.core/when-let
    [v10971 (:auto-minor-version-upgrade m10970)]
    (.
     bean10969
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v10971)))
   (clojure.core/when-let
    [v10971 (:cache-security-group-names m10970)]
    (.
     bean10969
     setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11011] (clojure.core/str arg11011))
 v10971)))
   (clojure.core/when-let
    [v10971 (:replication-group-id m10970)]
    (. bean10969 setReplicationGroupId (clojure.core/str v10971)))
   (clojure.core/when-let
    [v10971 (:apply-immediately m10970)]
    (. bean10969 setApplyImmediately (clojure.core/boolean v10971)))
   (clojure.core/when-let
    [v10971 (:notification-topic-status m10970)]
    (. bean10969 setNotificationTopicStatus (clojure.core/str v10971)))
   (clojure.core/when-let
    [v10971 (:engine-version m10970)]
    (. bean10969 setEngineVersion (clojure.core/str v10971)))
   (clojure.core/when-let
    [v10971 (:primary-cluster-id m10970)]
    (. bean10969 setPrimaryClusterId (clojure.core/str v10971)))
   (clojure.core/when-let
    [v10971 (:snapshot-window m10970)]
    (. bean10969 setSnapshotWindow (clojure.core/str v10971)))
   (clojure.core/when-let
    [v10971 (:notification-topic-arn m10970)]
    (. bean10969 setNotificationTopicArn (clojure.core/str v10971)))
   (clojure.core/when-let
    [v10971 (:security-group-ids m10970)]
    (.
     bean10969
     setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11012] (clojure.core/str arg11012))
 v10971)))
   bean10969))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest}
modify-cache-subnet-group-request
  [m10973]
  (clojure.core/let
   [bean10972
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest)]
   (clojure.core/when-let
    [v10974 (:subnet-ids m10973)]
    (.
     bean10972
     setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11013] (clojure.core/str arg11013))
 v10974)))
   (clojure.core/when-let
    [v10974 (:cache-subnet-group-name m10973)]
    (. bean10972 setCacheSubnetGroupName (clojure.core/str v10974)))
   (clojure.core/when-let
    [v10974 (:cache-subnet-group-description m10973)]
    (.
     bean10972
     setCacheSubnetGroupDescription
     (clojure.core/str v10974)))
   bean10972))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest}
describe-cache-parameters-request
  [m10976]
  (clojure.core/let
   [bean10975
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest)]
   (clojure.core/when-let
    [v10977 (:marker m10976)]
    (. bean10975 setMarker (clojure.core/str v10977)))
   (clojure.core/when-let
    [v10977 (:max-records m10976)]
    (. bean10975 setMaxRecords (clojure.core/int v10977)))
   (clojure.core/when-let
    [v10977 (:source m10976)]
    (. bean10975 setSource (clojure.core/str v10977)))
   (clojure.core/when-let
    [v10977 (:cache-parameter-group-name m10976)]
    (. bean10975 setCacheParameterGroupName (clojure.core/str v10977)))
   bean10975))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest}
delete-cache-parameter-group-request
  [m10979]
  (clojure.core/let
   [bean10978
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v10980 (:cache-parameter-group-name m10979)]
    (. bean10978 setCacheParameterGroupName (clojure.core/str v10980)))
   bean10978))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest}
delete-replication-group-request
  [m10982]
  (clojure.core/let
   [bean10981
    (new
     com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest)]
   (clojure.core/when-let
    [v10983 (:final-snapshot-identifier m10982)]
    (. bean10981 setFinalSnapshotIdentifier (clojure.core/str v10983)))
   (clojure.core/when-let
    [v10983 (:replication-group-id m10982)]
    (. bean10981 setReplicationGroupId (clojure.core/str v10983)))
   (clojure.core/when-let
    [v10983 (:retain-primary-cluster m10982)]
    (.
     bean10981
     setRetainPrimaryCluster
     (clojure.core/boolean v10983)))
   bean10981))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CopySnapshotRequest}
copy-snapshot-request
  [m10985]
  (clojure.core/let
   [bean10984
    (new com.amazonaws.services.elasticache.model.CopySnapshotRequest)]
   (clojure.core/when-let
    [v10986 (:source-snapshot-name m10985)]
    (. bean10984 setSourceSnapshotName (clojure.core/str v10986)))
   (clojure.core/when-let
    [v10986 (:target-snapshot-name m10985)]
    (. bean10984 setTargetSnapshotName (clojure.core/str v10986)))
   bean10984))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest}
purchase-reserved-cache-nodes-offering-request
  [m10988]
  (clojure.core/let
   [bean10987
    (new
     com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest)]
   (clojure.core/when-let
    [v10989 (:cache-node-count m10988)]
    (. bean10987 setCacheNodeCount (clojure.core/int v10989)))
   (clojure.core/when-let
    [v10989 (:reserved-cache-nodes-offering-id m10988)]
    (.
     bean10987
     setReservedCacheNodesOfferingId
     (clojure.core/str v10989)))
   (clojure.core/when-let
    [v10989 (:reserved-cache-node-id m10988)]
    (. bean10987 setReservedCacheNodeId (clojure.core/str v10989)))
   bean10987))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RebootCacheClusterRequest}
reboot-cache-cluster-request
  [m10991]
  (clojure.core/let
   [bean10990
    (new
     com.amazonaws.services.elasticache.model.RebootCacheClusterRequest)]
   (clojure.core/when-let
    [v10992 (:cache-cluster-id m10991)]
    (. bean10990 setCacheClusterId (clojure.core/str v10992)))
   (clojure.core/when-let
    [v10992 (:cache-node-ids-to-reboot m10991)]
    (.
     bean10990
     setCacheNodeIdsToReboot
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11014] (clojure.core/str arg11014))
 v10992)))
   bean10990))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheClusterRequest}
create-cache-cluster-request
  [m10994]
  (clojure.core/let
   [bean10993
    (new
     com.amazonaws.services.elasticache.model.CreateCacheClusterRequest)]
   (clojure.core/when-let
    [v10995 (:cache-parameter-group-name m10994)]
    (. bean10993 setCacheParameterGroupName (clojure.core/str v10995)))
   (clojure.core/when-let
    [v10995 (:port m10994)]
    (. bean10993 setPort (clojure.core/int v10995)))
   (clojure.core/when-let
    [v10995 (:snapshot-retention-limit m10994)]
    (. bean10993 setSnapshotRetentionLimit (clojure.core/int v10995)))
   (clojure.core/when-let
    [v10995 (:preferred-maintenance-window m10994)]
    (.
     bean10993
     setPreferredMaintenanceWindow
     (clojure.core/str v10995)))
   (clojure.core/when-let
    [v10995 (:engine m10994)]
    (. bean10993 setEngine (clojure.core/str v10995)))
   (clojure.core/when-let
    [v10995 (:preferred-availability-zone m10994)]
    (.
     bean10993
     setPreferredAvailabilityZone
     (clojure.core/str v10995)))
   (clojure.core/when-let
    [v10995 (:auto-minor-version-upgrade m10994)]
    (.
     bean10993
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v10995)))
   (clojure.core/when-let
    [v10995 (:cache-security-group-names m10994)]
    (.
     bean10993
     setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11015] (clojure.core/str arg11015))
 v10995)))
   (clojure.core/when-let
    [v10995 (:cache-subnet-group-name m10994)]
    (. bean10993 setCacheSubnetGroupName (clojure.core/str v10995)))
   (clojure.core/when-let
    [v10995 (:replication-group-id m10994)]
    (. bean10993 setReplicationGroupId (clojure.core/str v10995)))
   (clojure.core/when-let
    [v10995 (:snapshot-name m10994)]
    (. bean10993 setSnapshotName (clojure.core/str v10995)))
   (clojure.core/when-let
    [v10995 (:num-cache-nodes m10994)]
    (. bean10993 setNumCacheNodes (clojure.core/int v10995)))
   (clojure.core/when-let
    [v10995 (:engine-version m10994)]
    (. bean10993 setEngineVersion (clojure.core/str v10995)))
   (clojure.core/when-let
    [v10995 (:cache-cluster-id m10994)]
    (. bean10993 setCacheClusterId (clojure.core/str v10995)))
   (clojure.core/when-let
    [v10995 (:snapshot-window m10994)]
    (. bean10993 setSnapshotWindow (clojure.core/str v10995)))
   (clojure.core/when-let
    [v10995 (:notification-topic-arn m10994)]
    (. bean10993 setNotificationTopicArn (clojure.core/str v10995)))
   (clojure.core/when-let
    [v10995 (:security-group-ids m10994)]
    (.
     bean10993
     setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11016] (clojure.core/str arg11016))
 v10995)))
   (clojure.core/when-let
    [v10995 (:cache-node-type m10994)]
    (. bean10993 setCacheNodeType (clojure.core/str v10995)))
   (clojure.core/when-let
    [v10995 (:snapshot-arns m10994)]
    (.
     bean10993
     setSnapshotArns
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11017] (clojure.core/str arg11017))
 v10995)))
   bean10993))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest}
describe-reserved-cache-nodes-offerings-request
  [m10997]
  (clojure.core/let
   [bean10996
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)]
   (clojure.core/when-let
    [v10998 (:marker m10997)]
    (. bean10996 setMarker (clojure.core/str v10998)))
   (clojure.core/when-let
    [v10998 (:max-records m10997)]
    (. bean10996 setMaxRecords (clojure.core/int v10998)))
   (clojure.core/when-let
    [v10998 (:duration m10997)]
    (. bean10996 setDuration (clojure.core/str v10998)))
   (clojure.core/when-let
    [v10998 (:offering-type m10997)]
    (. bean10996 setOfferingType (clojure.core/str v10998)))
   (clojure.core/when-let
    [v10998 (:product-description m10997)]
    (. bean10996 setProductDescription (clojure.core/str v10998)))
   (clojure.core/when-let
    [v10998 (:cache-node-type m10997)]
    (. bean10996 setCacheNodeType (clojure.core/str v10998)))
   (clojure.core/when-let
    [v10998 (:reserved-cache-nodes-offering-id m10997)]
    (.
     bean10996
     setReservedCacheNodesOfferingId
     (clojure.core/str v10998)))
   bean10996))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateSnapshotRequest}
create-snapshot-request
  [m11000]
  (clojure.core/let
   [bean10999
    (new
     com.amazonaws.services.elasticache.model.CreateSnapshotRequest)]
   (clojure.core/when-let
    [v11001 (:snapshot-name m11000)]
    (. bean10999 setSnapshotName (clojure.core/str v11001)))
   (clojure.core/when-let
    [v11001 (:cache-cluster-id m11000)]
    (. bean10999 setCacheClusterId (clojure.core/str v11001)))
   bean10999))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m11003]
  (clojure.core/let
   [bean11002
    (new
     com.amazonaws.services.elasticache.model.DeleteSnapshotRequest)]
   (clojure.core/when-let
    [v11004 (:snapshot-name m11003)]
    (. bean11002 setSnapshotName (clojure.core/str v11004)))
   bean11002))
 (clojure.core/defmulti
  elasticache
  (clojure.core/fn
   elasticache
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameter-groups
   [m11018]
   (clojure.core/let
    [credentials11019 (:credentials m11018) args11020 (:args m11018)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11021
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11019)]
     (clojure.core/case
      (clojure.core/count args11020)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11021
        describeCacheParameterGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11021
        describeCacheParameterGroups
        (elasticache/describe-cache-parameter-groups-request
         (clojure.core/nth args11020 0))))))))
  (clojure.core/defn
   describe-cache-parameter-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Generate map for describeCacheParameterGroups, describeCacheParameterGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cache-parameter-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Call describeCacheParameterGroups, describeCacheParameterGroups"}
   [credentials11023 & args11024]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11025
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11023)]
    (clojure.core/case
     (clojure.core/count args11024)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11025
       describeCacheParameterGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11025
       describeCacheParameterGroups
       (elasticache/describe-cache-parameter-groups-request
        (clojure.core/nth args11024 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-parameter-group
   [m11026]
   (clojure.core/let
    [credentials11027 (:credentials m11026) args11028 (:args m11026)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11029
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11027)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11029
       createCacheParameterGroup
       (elasticache/create-cache-parameter-group-request
        (clojure.core/nth args11028 0)))))))
  (clojure.core/defn
   create-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cache-parameter-group-name
                         cache-parameter-group-family]}]]),
    :doc "Generate map for createCacheParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cache-parameter-group-name
                         cache-parameter-group-family]}]]),
    :doc "Call createCacheParameterGroup"}
   [credentials11031 & args11032]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11033
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11031)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11033
      createCacheParameterGroup
      (elasticache/create-cache-parameter-group-request
       (clojure.core/nth args11032 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :revoke-cache-security-group-ingress
   [m11034]
   (clojure.core/let
    [credentials11035 (:credentials m11034) args11036 (:args m11034)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11037
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11035)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11037
       revokeCacheSecurityGroupIngress
       (elasticache/revoke-cache-security-group-ingress-request
        (clojure.core/nth args11036 0)))))))
  (clojure.core/defn
   revoke-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Generate map for revokeCacheSecurityGroupIngress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :revoke-cache-security-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   revoke-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Call revokeCacheSecurityGroupIngress"}
   [credentials11039 & args11040]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11041
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11039)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11041
      revokeCacheSecurityGroupIngress
      (elasticache/revoke-cache-security-group-ingress-request
       (clojure.core/nth args11040 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-replication-group
   [m11042]
   (clojure.core/let
    [credentials11043 (:credentials m11042) args11044 (:args m11042)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11045
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11043)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11045
       createReplicationGroup
       (elasticache/create-replication-group-request
        (clojure.core/nth args11044 0)))))))
  (clojure.core/defn
   create-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [replication-group-id
                         replication-group-description
                         primary-cluster-id
                         general-progress-listener]}]]),
    :doc "Generate map for createReplicationGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-replication-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [replication-group-id
                         replication-group-description
                         primary-cluster-id
                         general-progress-listener]}]]),
    :doc "Call createReplicationGroup"}
   [credentials11047 & args11048]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11049
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11047)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11049
      createReplicationGroup
      (elasticache/create-replication-group-request
       (clojure.core/nth args11048 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-snapshots
   [m11050]
   (clojure.core/let
    [credentials11051 (:credentials m11050) args11052 (:args m11050)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11053
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11051)]
     (clojure.core/case
      (clojure.core/count args11052)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11053
        describeSnapshots
        (elasticache/describe-snapshots-request
         (clojure.core/nth args11052 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11053
        describeSnapshots))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [cache-cluster-id
                         marker
                         snapshot-name
                         max-records
                         general-progress-listener
                         snapshot-source]}]
                [credentials]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-snapshots,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-snapshots,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials
                 {:keys [cache-cluster-id
                         marker
                         snapshot-name
                         max-records
                         general-progress-listener
                         snapshot-source]}]
                [credentials]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials11055 & args11056]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11057
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11055)]
    (clojure.core/case
     (clojure.core/count args11056)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11057
       describeSnapshots
       (elasticache/describe-snapshots-request
        (clojure.core/nth args11056 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11057
       describeSnapshots))))))
 (do
  (clojure.core/defmethod
   elasticache
   :authorize-cache-security-group-ingress
   [m11058]
   (clojure.core/let
    [credentials11059 (:credentials m11058) args11060 (:args m11058)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11061
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11059)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11061
       authorizeCacheSecurityGroupIngress
       (elasticache/authorize-cache-security-group-ingress-request
        (clojure.core/nth args11060 0)))))))
  (clojure.core/defn
   authorize-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Generate map for authorizeCacheSecurityGroupIngress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :authorize-cache-security-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   authorize-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Call authorizeCacheSecurityGroupIngress"}
   [credentials11063 & args11064]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11065
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11063)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11065
      authorizeCacheSecurityGroupIngress
      (elasticache/authorize-cache-security-group-ingress-request
       (clojure.core/nth args11064 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes
   [m11066]
   (clojure.core/let
    [credentials11067 (:credentials m11066) args11068 (:args m11066)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11069
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11067)]
     (clojure.core/case
      (clojure.core/count args11068)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11069
        describeReservedCacheNodes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11069
        describeReservedCacheNodes
        (elasticache/describe-reserved-cache-nodes-request
         (clojure.core/nth args11068 0))))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-cache-node-id
                         duration
                         general-progress-listener
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]]),
    :doc "Generate map for describeReservedCacheNodes, describeReservedCacheNodes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-cache-nodes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-cache-node-id
                         duration
                         general-progress-listener
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]]),
    :doc "Call describeReservedCacheNodes, describeReservedCacheNodes"}
   [credentials11071 & args11072]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11073
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11071)]
    (clojure.core/case
     (clojure.core/count args11072)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11073
       describeReservedCacheNodes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11073
       describeReservedCacheNodes
       (elasticache/describe-reserved-cache-nodes-request
        (clojure.core/nth args11072 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-cluster
   [m11074]
   (clojure.core/let
    [credentials11075 (:credentials m11074) args11076 (:args m11074)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11077
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11075)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11077
       modifyCacheCluster
       (elasticache/modify-cache-cluster-request
        (clojure.core/nth args11076 0)))))))
  (clojure.core/defn
   modify-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         snapshot-retention-limit
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         cache-cluster-id
                         num-cache-nodes
                         preferred-maintenance-window
                         cache-node-ids-to-remove
                         cache-security-group-names
                         security-group-ids
                         apply-immediately
                         engine-version
                         auto-minor-version-upgrade
                         snapshot-window]}]]),
    :doc "Generate map for modifyCacheCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-cache-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         snapshot-retention-limit
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         cache-cluster-id
                         num-cache-nodes
                         preferred-maintenance-window
                         cache-node-ids-to-remove
                         cache-security-group-names
                         security-group-ids
                         apply-immediately
                         engine-version
                         auto-minor-version-upgrade
                         snapshot-window]}]]),
    :doc "Call modifyCacheCluster"}
   [credentials11079 & args11080]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11081
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11079)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11081
      modifyCacheCluster
      (elasticache/modify-cache-cluster-request
       (clojure.core/nth args11080 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-subnet-group
   [m11082]
   (clojure.core/let
    [credentials11083 (:credentials m11082) args11084 (:args m11082)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11085
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11083)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11085
       deleteCacheSubnetGroup
       (elasticache/delete-cache-subnet-group-request
        (clojure.core/nth args11084 0)))))))
  (clojure.core/defn
   delete-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-subnet-group-name]}]]),
    :doc "Generate map for deleteCacheSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-subnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-subnet-group-name]}]]),
    :doc "Call deleteCacheSubnetGroup"}
   [credentials11087 & args11088]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11089
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11087)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11089
      deleteCacheSubnetGroup
      (elasticache/delete-cache-subnet-group-request
       (clojure.core/nth args11088 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-engine-versions
   [m11090]
   (clojure.core/let
    [credentials11091 (:credentials m11090) args11092 (:args m11090)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11093
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11091)]
     (clojure.core/case
      (clojure.core/count args11092)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11093
        describeCacheEngineVersions
        (elasticache/describe-cache-engine-versions-request
         (clojure.core/nth args11092 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11093
        describeCacheEngineVersions))))))
  (clojure.core/defn
   describe-cache-engine-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [cache-parameter-group-family
                         engine
                         general-progress-listener
                         max-records
                         marker
                         default-only
                         engine-version]}]
                [credentials]]),
    :doc "Generate map for describeCacheEngineVersions, describeCacheEngineVersions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-engine-versions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-engine-versions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cache-engine-versions
   {:arglists (quote
               [[credentials
                 {:keys [cache-parameter-group-family
                         engine
                         general-progress-listener
                         max-records
                         marker
                         default-only
                         engine-version]}]
                [credentials]]),
    :doc "Call describeCacheEngineVersions, describeCacheEngineVersions"}
   [credentials11095 & args11096]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11097
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11095)]
    (clojure.core/case
     (clojure.core/count args11096)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11097
       describeCacheEngineVersions
       (elasticache/describe-cache-engine-versions-request
        (clojure.core/nth args11096 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11097
       describeCacheEngineVersions))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reset-cache-parameter-group
   [m11098]
   (clojure.core/let
    [credentials11099 (:credentials m11098) args11100 (:args m11098)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11101
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11099)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11101
       resetCacheParameterGroup
       (elasticache/reset-cache-parameter-group-request
        (clojure.core/nth args11100 0)))))))
  (clojure.core/defn
   reset-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameter-name-values
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Generate map for resetCacheParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :reset-cache-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reset-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameter-name-values
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Call resetCacheParameterGroup"}
   [credentials11103 & args11104]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11105
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11103)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11105
      resetCacheParameterGroup
      (elasticache/reset-cache-parameter-group-request
       (clojure.core/nth args11104 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-engine-default-parameters
   [m11106]
   (clojure.core/let
    [credentials11107 (:credentials m11106) args11108 (:args m11106)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11109
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11107)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11109
       describeEngineDefaultParameters
       (elasticache/describe-engine-default-parameters-request
        (clojure.core/nth args11108 0)))))))
  (clojure.core/defn
   describe-engine-default-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-family]}]]),
    :doc "Generate map for describeEngineDefaultParameters"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-engine-default-parameters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-engine-default-parameters
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-family]}]]),
    :doc "Call describeEngineDefaultParameters"}
   [credentials11111 & args11112]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11113
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11111)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11113
      describeEngineDefaultParameters
      (elasticache/describe-engine-default-parameters-request
       (clojure.core/nth args11112 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-cluster
   [m11114]
   (clojure.core/let
    [credentials11115 (:credentials m11114) args11116 (:args m11114)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11117
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11115)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11117
       deleteCacheCluster
       (elasticache/delete-cache-cluster-request
        (clojure.core/nth args11116 0)))))))
  (clojure.core/defn
   delete-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         final-snapshot-identifier
                         cache-cluster-id]}]]),
    :doc "Generate map for deleteCacheCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         final-snapshot-identifier
                         cache-cluster-id]}]]),
    :doc "Call deleteCacheCluster"}
   [credentials11119 & args11120]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11121
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11119)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11121
      deleteCacheCluster
      (elasticache/delete-cache-cluster-request
       (clojure.core/nth args11120 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-subnet-groups
   [m11122]
   (clojure.core/let
    [credentials11123 (:credentials m11122) args11124 (:args m11122)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11125
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11123)]
     (clojure.core/case
      (clojure.core/count args11124)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11125
        describeCacheSubnetGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11125
        describeCacheSubnetGroups
        (elasticache/describe-cache-subnet-groups-request
         (clojure.core/nth args11124 0))))))))
  (clojure.core/defn
   describe-cache-subnet-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-subnet-group-name]}]]),
    :doc "Generate map for describeCacheSubnetGroups, describeCacheSubnetGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cache-subnet-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-subnet-group-name]}]]),
    :doc "Call describeCacheSubnetGroups, describeCacheSubnetGroups"}
   [credentials11127 & args11128]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11129
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11127)]
    (clojure.core/case
     (clojure.core/count args11128)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11129
       describeCacheSubnetGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11129
       describeCacheSubnetGroups
       (elasticache/describe-cache-subnet-groups-request
        (clojure.core/nth args11128 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-replication-groups
   [m11130]
   (clojure.core/let
    [credentials11131 (:credentials m11130) args11132 (:args m11130)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11133
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11131)]
     (clojure.core/case
      (clojure.core/count args11132)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11133
        describeReplicationGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11133
        describeReplicationGroups
        (elasticache/describe-replication-groups-request
         (clojure.core/nth args11132 0))))))))
  (clojure.core/defn
   describe-replication-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [replication-group-id
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeReplicationGroups, describeReplicationGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-replication-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-replication-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-replication-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [replication-group-id
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeReplicationGroups, describeReplicationGroups"}
   [credentials11135 & args11136]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11137
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11135)]
    (clojure.core/case
     (clojure.core/count args11136)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11137
       describeReplicationGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11137
       describeReplicationGroups
       (elasticache/describe-replication-groups-request
        (clojure.core/nth args11136 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-security-groups
   [m11138]
   (clojure.core/let
    [credentials11139 (:credentials m11138) args11140 (:args m11138)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11141
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11139)]
     (clojure.core/case
      (clojure.core/count args11140)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11141
        describeCacheSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11141
        describeCacheSecurityGroups
        (elasticache/describe-cache-security-groups-request
         (clojure.core/nth args11140 0))))))))
  (clojure.core/defn
   describe-cache-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-security-group-name]}]]),
    :doc "Generate map for describeCacheSecurityGroups, describeCacheSecurityGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-security-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-security-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cache-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-security-group-name]}]]),
    :doc "Call describeCacheSecurityGroups, describeCacheSecurityGroups"}
   [credentials11143 & args11144]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11145
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11143)]
    (clojure.core/case
     (clojure.core/count args11144)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11145
       describeCacheSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11145
       describeCacheSecurityGroups
       (elasticache/describe-cache-security-groups-request
        (clojure.core/nth args11144 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-security-group
   [m11146]
   (clojure.core/let
    [credentials11147 (:credentials m11146) args11148 (:args m11146)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11149
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11147)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11149
       createCacheSecurityGroup
       (elasticache/create-cache-security-group-request
        (clojure.core/nth args11148 0)))))))
  (clojure.core/defn
   create-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cache-security-group-name]}]]),
    :doc "Generate map for createCacheSecurityGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-security-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cache-security-group-name]}]]),
    :doc "Call createCacheSecurityGroup"}
   [credentials11151 & args11152]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11153
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11151)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11153
      createCacheSecurityGroup
      (elasticache/create-cache-security-group-request
       (clojure.core/nth args11152 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-clusters
   [m11154]
   (clojure.core/let
    [credentials11155 (:credentials m11154) args11156 (:args m11154)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11157
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11155)]
     (clojure.core/case
      (clojure.core/count args11156)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11157
        describeCacheClusters
        (elasticache/describe-cache-clusters-request
         (clojure.core/nth args11156 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11157
        describeCacheClusters))))))
  (clojure.core/defn
   describe-cache-clusters-map
   {:arglists (quote
               [[credentials
                 {:keys [show-cache-node-info
                         max-records
                         marker
                         general-progress-listener
                         cache-cluster-id]}]
                [credentials]]),
    :doc "Generate map for describeCacheClusters, describeCacheClusters"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-clusters,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-clusters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cache-clusters
   {:arglists (quote
               [[credentials
                 {:keys [show-cache-node-info
                         max-records
                         marker
                         general-progress-listener
                         cache-cluster-id]}]
                [credentials]]),
    :doc "Call describeCacheClusters, describeCacheClusters"}
   [credentials11159 & args11160]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11161
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11159)]
    (clojure.core/case
     (clojure.core/count args11160)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11161
       describeCacheClusters
       (elasticache/describe-cache-clusters-request
        (clojure.core/nth args11160 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11161
       describeCacheClusters))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-events
   [m11162]
   (clojure.core/let
    [credentials11163 (:credentials m11162) args11164 (:args m11162)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11165
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11163)]
     (clojure.core/case
      (clojure.core/count args11164)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11165
        describeEvents
        (elasticache/describe-events-request
         (clojure.core/nth args11164 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11165
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         source-type
                         duration
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-events,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-events,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         source-type
                         duration
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials11167 & args11168]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11169
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11167)]
    (clojure.core/case
     (clojure.core/count args11168)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11169
       describeEvents
       (elasticache/describe-events-request
        (clojure.core/nth args11168 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11169
       describeEvents))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-parameter-group
   [m11170]
   (clojure.core/let
    [credentials11171 (:credentials m11170) args11172 (:args m11170)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11173
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11171)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11173
       modifyCacheParameterGroup
       (elasticache/modify-cache-parameter-group-request
        (clojure.core/nth args11172 0)))))))
  (clojure.core/defn
   modify-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [parameter-name-values
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Generate map for modifyCacheParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-cache-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [parameter-name-values
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Call modifyCacheParameterGroup"}
   [credentials11175 & args11176]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11177
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11175)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11177
      modifyCacheParameterGroup
      (elasticache/modify-cache-parameter-group-request
       (clojure.core/nth args11176 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-security-group
   [m11178]
   (clojure.core/let
    [credentials11179 (:credentials m11178) args11180 (:args m11178)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11181
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11179)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11181
       deleteCacheSecurityGroup
       (elasticache/delete-cache-security-group-request
        (clojure.core/nth args11180 0)))))))
  (clojure.core/defn
   delete-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name]}]]),
    :doc "Generate map for deleteCacheSecurityGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-security-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name]}]]),
    :doc "Call deleteCacheSecurityGroup"}
   [credentials11183 & args11184]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11185
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11183)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11185
      deleteCacheSecurityGroup
      (elasticache/delete-cache-security-group-request
       (clojure.core/nth args11184 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-subnet-group
   [m11186]
   (clojure.core/let
    [credentials11187 (:credentials m11186) args11188 (:args m11186)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11189
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11187)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11189
       createCacheSubnetGroup
       (elasticache/create-cache-subnet-group-request
        (clojure.core/nth args11188 0)))))))
  (clojure.core/defn
   create-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Generate map for createCacheSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-subnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Call createCacheSubnetGroup"}
   [credentials11191 & args11192]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11193
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11191)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11193
      createCacheSubnetGroup
      (elasticache/create-cache-subnet-group-request
       (clojure.core/nth args11192 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-replication-group
   [m11194]
   (clojure.core/let
    [credentials11195 (:credentials m11194) args11196 (:args m11194)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11197
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11195)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11197
       modifyReplicationGroup
       (elasticache/modify-replication-group-request
        (clojure.core/nth args11196 0)))))))
  (clojure.core/defn
   modify-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         snapshot-retention-limit
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         primary-cluster-id
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         replication-group-description
                         security-group-ids
                         apply-immediately
                         engine-version
                         snapshotting-cluster-id
                         auto-minor-version-upgrade
                         snapshot-window]}]]),
    :doc "Generate map for modifyReplicationGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-replication-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         snapshot-retention-limit
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         primary-cluster-id
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         replication-group-description
                         security-group-ids
                         apply-immediately
                         engine-version
                         snapshotting-cluster-id
                         auto-minor-version-upgrade
                         snapshot-window]}]]),
    :doc "Call modifyReplicationGroup"}
   [credentials11199 & args11200]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11201
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11199)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11201
      modifyReplicationGroup
      (elasticache/modify-replication-group-request
       (clojure.core/nth args11200 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-subnet-group
   [m11202]
   (clojure.core/let
    [credentials11203 (:credentials m11202) args11204 (:args m11202)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11205
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11203)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11205
       modifyCacheSubnetGroup
       (elasticache/modify-cache-subnet-group-request
        (clojure.core/nth args11204 0)))))))
  (clojure.core/defn
   modify-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Generate map for modifyCacheSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-cache-subnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Call modifyCacheSubnetGroup"}
   [credentials11207 & args11208]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11209
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11207)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11209
      modifyCacheSubnetGroup
      (elasticache/modify-cache-subnet-group-request
       (clojure.core/nth args11208 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameters
   [m11210]
   (clojure.core/let
    [credentials11211 (:credentials m11210) args11212 (:args m11210)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11213
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11211)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11213
       describeCacheParameters
       (elasticache/describe-cache-parameters-request
        (clojure.core/nth args11212 0)))))))
  (clojure.core/defn
   describe-cache-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Generate map for describeCacheParameters"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-parameters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cache-parameters
   {:arglists (quote
               [[credentials
                 {:keys [source
                         max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Call describeCacheParameters"}
   [credentials11215 & args11216]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11217
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11215)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11217
      describeCacheParameters
      (elasticache/describe-cache-parameters-request
       (clojure.core/nth args11216 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-parameter-group
   [m11218]
   (clojure.core/let
    [credentials11219 (:credentials m11218) args11220 (:args m11218)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11221
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11219)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11221
       deleteCacheParameterGroup
       (elasticache/delete-cache-parameter-group-request
        (clojure.core/nth args11220 0)))))))
  (clojure.core/defn
   delete-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Generate map for deleteCacheParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Call deleteCacheParameterGroup"}
   [credentials11223 & args11224]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11225
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11223)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11225
      deleteCacheParameterGroup
      (elasticache/delete-cache-parameter-group-request
       (clojure.core/nth args11224 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-replication-group
   [m11226]
   (clojure.core/let
    [credentials11227 (:credentials m11226) args11228 (:args m11226)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11229
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11227)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11229
       deleteReplicationGroup
       (elasticache/delete-replication-group-request
        (clojure.core/nth args11228 0)))))))
  (clojure.core/defn
   delete-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         replication-group-id
                         general-progress-listener
                         final-snapshot-identifier]}]]),
    :doc "Generate map for deleteReplicationGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-replication-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         replication-group-id
                         general-progress-listener
                         final-snapshot-identifier]}]]),
    :doc "Call deleteReplicationGroup"}
   [credentials11231 & args11232]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11233
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11231)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11233
      deleteReplicationGroup
      (elasticache/delete-replication-group-request
       (clojure.core/nth args11232 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :copy-snapshot
   [m11234]
   (clojure.core/let
    [credentials11235 (:credentials m11234) args11236 (:args m11234)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11237
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11235)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11237
       copySnapshot
       (elasticache/copy-snapshot-request
        (clojure.core/nth args11236 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [target-snapshot-name
                         source-snapshot-name
                         general-progress-listener]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :copy-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [target-snapshot-name
                         source-snapshot-name
                         general-progress-listener]}]]),
    :doc "Call copySnapshot"}
   [credentials11239 & args11240]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11241
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11239)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11241
      copySnapshot
      (elasticache/copy-snapshot-request
       (clojure.core/nth args11240 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :purchase-reserved-cache-nodes-offering
   [m11242]
   (clojure.core/let
    [credentials11243 (:credentials m11242) args11244 (:args m11242)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11245
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11243)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11245
       purchaseReservedCacheNodesOffering
       (elasticache/purchase-reserved-cache-nodes-offering-request
        (clojure.core/nth args11244 0)))))))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-cache-nodes-offering-id
                         reserved-cache-node-id
                         general-progress-listener
                         cache-node-count]}]]),
    :doc "Generate map for purchaseReservedCacheNodesOffering"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :purchase-reserved-cache-nodes-offering,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering
   {:arglists (quote
               [[credentials
                 {:keys [reserved-cache-nodes-offering-id
                         reserved-cache-node-id
                         general-progress-listener
                         cache-node-count]}]]),
    :doc "Call purchaseReservedCacheNodesOffering"}
   [credentials11247 & args11248]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11249
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11247)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11249
      purchaseReservedCacheNodesOffering
      (elasticache/purchase-reserved-cache-nodes-offering-request
       (clojure.core/nth args11248 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reboot-cache-cluster
   [m11250]
   (clojure.core/let
    [credentials11251 (:credentials m11250) args11252 (:args m11250)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11253
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11251)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11253
       rebootCacheCluster
       (elasticache/reboot-cache-cluster-request
        (clojure.core/nth args11252 0)))))))
  (clojure.core/defn
   reboot-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-node-ids-to-reboot
                         cache-cluster-id]}]]),
    :doc "Generate map for rebootCacheCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :reboot-cache-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reboot-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-node-ids-to-reboot
                         cache-cluster-id]}]]),
    :doc "Call rebootCacheCluster"}
   [credentials11255 & args11256]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11257
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11255)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11257
      rebootCacheCluster
      (elasticache/reboot-cache-cluster-request
       (clojure.core/nth args11256 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-cluster
   [m11258]
   (clojure.core/let
    [credentials11259 (:credentials m11258) args11260 (:args m11258)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11261
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11259)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11261
       createCacheCluster
       (elasticache/create-cache-cluster-request
        (clojure.core/nth args11260 0)))))))
  (clojure.core/defn
   create-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-retention-limit
                         engine
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         cache-cluster-id
                         preferred-availability-zone
                         num-cache-nodes
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         port
                         security-group-ids
                         snapshot-arns
                         engine-version
                         snapshot-name
                         auto-minor-version-upgrade
                         cache-node-type
                         snapshot-window
                         cache-subnet-group-name]}]]),
    :doc "Generate map for createCacheCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-retention-limit
                         engine
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         cache-cluster-id
                         preferred-availability-zone
                         num-cache-nodes
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         port
                         security-group-ids
                         snapshot-arns
                         engine-version
                         snapshot-name
                         auto-minor-version-upgrade
                         cache-node-type
                         snapshot-window
                         cache-subnet-group-name]}]]),
    :doc "Call createCacheCluster"}
   [credentials11263 & args11264]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11265
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11263)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11265
      createCacheCluster
      (elasticache/create-cache-cluster-request
       (clojure.core/nth args11264 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes-offerings
   [m11266]
   (clojure.core/let
    [credentials11267 (:credentials m11266) args11268 (:args m11266)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11269
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11267)]
     (clojure.core/case
      (clojure.core/count args11268)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11269
        describeReservedCacheNodesOfferings
        (elasticache/describe-reserved-cache-nodes-offerings-request
         (clojure.core/nth args11268 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11269
        describeReservedCacheNodesOfferings))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings-map
   {:arglists (quote
               [[credentials
                 {:keys [duration
                         general-progress-listener
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]
                [credentials]]),
    :doc "Generate map for describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings
   {:arglists (quote
               [[credentials
                 {:keys [duration
                         general-progress-listener
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]
                [credentials]]),
    :doc "Call describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   [credentials11271 & args11272]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11273
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11271)]
    (clojure.core/case
     (clojure.core/count args11272)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11273
       describeReservedCacheNodesOfferings
       (elasticache/describe-reserved-cache-nodes-offerings-request
        (clojure.core/nth args11272 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11273
       describeReservedCacheNodesOfferings))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-snapshot
   [m11274]
   (clojure.core/let
    [credentials11275 (:credentials m11274) args11276 (:args m11274)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11277
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11275)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11277
       createSnapshot
       (elasticache/create-snapshot-request
        (clojure.core/nth args11276 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-name
                         general-progress-listener
                         cache-cluster-id]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-name
                         general-progress-listener
                         cache-cluster-id]}]]),
    :doc "Call createSnapshot"}
   [credentials11279 & args11280]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11281
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11279)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11281
      createSnapshot
      (elasticache/create-snapshot-request
       (clojure.core/nth args11280 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-snapshot
   [m11282]
   (clojure.core/let
    [credentials11283 (:credentials m11282) args11284 (:args m11282)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11285
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11283)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11285
       deleteSnapshot
       (elasticache/delete-snapshot-request
        (clojure.core/nth args11284 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-name general-progress-listener]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-name general-progress-listener]}]]),
    :doc "Call deleteSnapshot"}
   [credentials11287 & args11288]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11289
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11287)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11289
      deleteSnapshot
      (elasticache/delete-snapshot-request
       (clojure.core/nth args11288 0))))))))
