(ns
 com.palletops.awaze.directconnect
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.directconnect :as directconnect]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :directconnect
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.directconnect.AmazonDirectConnectClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.RouteFilterPrefix}
route-filter-prefix
  [m3855]
  (clojure.core/let
   [bean3854
    (new com.amazonaws.services.directconnect.model.RouteFilterPrefix)]
   (clojure.core/when-let
    [v3856 (:cidr m3855)]
    (. bean3854 setCidr (clojure.core/str v3856)))
   bean3854))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterface}
new-public-virtual-interface
  [m3858]
  (clojure.core/let
   [bean3857
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterface)]
   (clojure.core/when-let
    [v3859 (:vlan m3858)]
    (. bean3857 setVlan (clojure.core/int v3859)))
   (clojure.core/when-let
    [v3859 (:virtual-interface-name m3858)]
    (. bean3857 setVirtualInterfaceName (clojure.core/str v3859)))
   (clojure.core/when-let
    [v3859 (:asn m3858)]
    (. bean3857 setAsn (clojure.core/int v3859)))
   (clojure.core/when-let
    [v3859 (:auth-key m3858)]
    (. bean3857 setAuthKey (clojure.core/str v3859)))
   (clojure.core/when-let
    [v3859 (:amazon-address m3858)]
    (. bean3857 setAmazonAddress (clojure.core/str v3859)))
   (clojure.core/when-let
    [v3859 (:customer-address m3858)]
    (. bean3857 setCustomerAddress (clojure.core/str v3859)))
   (clojure.core/when-let
    [v3859 (:route-filter-prefixes m3858)]
    (.
     bean3857
     setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg3926]
  (directconnect/route-filter-prefix arg3926))
 v3859)))
   bean3857))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface}
new-private-virtual-interface
  [m3861]
  (clojure.core/let
   [bean3860
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface)]
   (clojure.core/when-let
    [v3862 (:virtual-gateway-id m3861)]
    (. bean3860 setVirtualGatewayId (clojure.core/str v3862)))
   (clojure.core/when-let
    [v3862 (:vlan m3861)]
    (. bean3860 setVlan (clojure.core/int v3862)))
   (clojure.core/when-let
    [v3862 (:virtual-interface-name m3861)]
    (. bean3860 setVirtualInterfaceName (clojure.core/str v3862)))
   (clojure.core/when-let
    [v3862 (:asn m3861)]
    (. bean3860 setAsn (clojure.core/int v3862)))
   (clojure.core/when-let
    [v3862 (:auth-key m3861)]
    (. bean3860 setAuthKey (clojure.core/str v3862)))
   (clojure.core/when-let
    [v3862 (:amazon-address m3861)]
    (. bean3860 setAmazonAddress (clojure.core/str v3862)))
   (clojure.core/when-let
    [v3862 (:customer-address m3861)]
    (. bean3860 setCustomerAddress (clojure.core/str v3862)))
   bean3860))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation}
new-private-virtual-interface-allocation
  [m3864]
  (clojure.core/let
   [bean3863
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation)]
   (clojure.core/when-let
    [v3865 (:vlan m3864)]
    (. bean3863 setVlan (clojure.core/int v3865)))
   (clojure.core/when-let
    [v3865 (:virtual-interface-name m3864)]
    (. bean3863 setVirtualInterfaceName (clojure.core/str v3865)))
   (clojure.core/when-let
    [v3865 (:asn m3864)]
    (. bean3863 setAsn (clojure.core/int v3865)))
   (clojure.core/when-let
    [v3865 (:auth-key m3864)]
    (. bean3863 setAuthKey (clojure.core/str v3865)))
   (clojure.core/when-let
    [v3865 (:amazon-address m3864)]
    (. bean3863 setAmazonAddress (clojure.core/str v3865)))
   (clojure.core/when-let
    [v3865 (:customer-address m3864)]
    (. bean3863 setCustomerAddress (clojure.core/str v3865)))
   bean3863))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation}
new-public-virtual-interface-allocation
  [m3867]
  (clojure.core/let
   [bean3866
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation)]
   (clojure.core/when-let
    [v3868 (:vlan m3867)]
    (. bean3866 setVlan (clojure.core/int v3868)))
   (clojure.core/when-let
    [v3868 (:virtual-interface-name m3867)]
    (. bean3866 setVirtualInterfaceName (clojure.core/str v3868)))
   (clojure.core/when-let
    [v3868 (:asn m3867)]
    (. bean3866 setAsn (clojure.core/int v3868)))
   (clojure.core/when-let
    [v3868 (:auth-key m3867)]
    (. bean3866 setAuthKey (clojure.core/str v3868)))
   (clojure.core/when-let
    [v3868 (:amazon-address m3867)]
    (. bean3866 setAmazonAddress (clojure.core/str v3868)))
   (clojure.core/when-let
    [v3868 (:customer-address m3867)]
    (. bean3866 setCustomerAddress (clojure.core/str v3868)))
   (clojure.core/when-let
    [v3868 (:route-filter-prefixes m3867)]
    (.
     bean3866
     setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg3927]
  (directconnect/route-filter-prefix arg3927))
 v3868)))
   bean3866))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteConnectionRequest}
delete-connection-request
  [m3870]
  (clojure.core/let
   [bean3869
    (new
     com.amazonaws.services.directconnect.model.DeleteConnectionRequest)]
   (clojure.core/when-let
    [v3871 (:connection-id m3870)]
    (. bean3869 setConnectionId (clojure.core/str v3871)))
   bean3869))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest}
describe-connections-on-interconnect-request
  [m3873]
  (clojure.core/let
   [bean3872
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest)]
   (clojure.core/when-let
    [v3874 (:interconnect-id m3873)]
    (. bean3872 setInterconnectId (clojure.core/str v3874)))
   bean3872))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeLocationsRequest}
describe-locations-request
  [m3876]
  (clojure.core/let
   [bean3875
    (new
     com.amazonaws.services.directconnect.model.DescribeLocationsRequest)]
   bean3875))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest}
allocate-connection-on-interconnect-request
  [m3879]
  (clojure.core/let
   [bean3878
    (new
     com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest)]
   (clojure.core/when-let
    [v3880 (:owner-account m3879)]
    (. bean3878 setOwnerAccount (clojure.core/str v3880)))
   (clojure.core/when-let
    [v3880 (:bandwidth m3879)]
    (. bean3878 setBandwidth (clojure.core/str v3880)))
   (clojure.core/when-let
    [v3880 (:interconnect-id m3879)]
    (. bean3878 setInterconnectId (clojure.core/str v3880)))
   (clojure.core/when-let
    [v3880 (:connection-name m3879)]
    (. bean3878 setConnectionName (clojure.core/str v3880)))
   (clojure.core/when-let
    [v3880 (:vlan m3879)]
    (. bean3878 setVlan (clojure.core/int v3880)))
   bean3878))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest}
create-public-virtual-interface-request
  [m3882]
  (clojure.core/let
   [bean3881
    (new
     com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3883 (:connection-id m3882)]
    (. bean3881 setConnectionId (clojure.core/str v3883)))
   (clojure.core/when-let
    [v3883 (:new-public-virtual-interface m3882)]
    (.
     bean3881
     setNewPublicVirtualInterface
     (directconnect/new-public-virtual-interface v3883)))
   bean3881))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmConnectionRequest}
confirm-connection-request
  [m3885]
  (clojure.core/let
   [bean3884
    (new
     com.amazonaws.services.directconnect.model.ConfirmConnectionRequest)]
   (clojure.core/when-let
    [v3886 (:connection-id m3885)]
    (. bean3884 setConnectionId (clojure.core/str v3886)))
   bean3884))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest}
confirm-private-virtual-interface-request
  [m3888]
  (clojure.core/let
   [bean3887
    (new
     com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3889 (:virtual-gateway-id m3888)]
    (. bean3887 setVirtualGatewayId (clojure.core/str v3889)))
   (clojure.core/when-let
    [v3889 (:virtual-interface-id m3888)]
    (. bean3887 setVirtualInterfaceId (clojure.core/str v3889)))
   bean3887))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateInterconnectRequest}
create-interconnect-request
  [m3891]
  (clojure.core/let
   [bean3890
    (new
     com.amazonaws.services.directconnect.model.CreateInterconnectRequest)]
   (clojure.core/when-let
    [v3892 (:location m3891)]
    (. bean3890 setLocation (clojure.core/str v3892)))
   (clojure.core/when-let
    [v3892 (:interconnect-name m3891)]
    (. bean3890 setInterconnectName (clojure.core/str v3892)))
   (clojure.core/when-let
    [v3892 (:bandwidth m3891)]
    (. bean3890 setBandwidth (clojure.core/str v3892)))
   bean3890))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest}
confirm-public-virtual-interface-request
  [m3894]
  (clojure.core/let
   [bean3893
    (new
     com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3895 (:virtual-interface-id m3894)]
    (. bean3893 setVirtualInterfaceId (clojure.core/str v3895)))
   bean3893))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest}
delete-virtual-interface-request
  [m3897]
  (clojure.core/let
   [bean3896
    (new
     com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3898 (:virtual-interface-id m3897)]
    (. bean3896 setVirtualInterfaceId (clojure.core/str v3898)))
   bean3896))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest}
create-private-virtual-interface-request
  [m3900]
  (clojure.core/let
   [bean3899
    (new
     com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3901 (:connection-id m3900)]
    (. bean3899 setConnectionId (clojure.core/str v3901)))
   (clojure.core/when-let
    [v3901 (:new-private-virtual-interface m3900)]
    (.
     bean3899
     setNewPrivateVirtualInterface
     (directconnect/new-private-virtual-interface v3901)))
   bean3899))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest}
allocate-private-virtual-interface-request
  [m3903]
  (clojure.core/let
   [bean3902
    (new
     com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3904 (:owner-account m3903)]
    (. bean3902 setOwnerAccount (clojure.core/str v3904)))
   (clojure.core/when-let
    [v3904 (:connection-id m3903)]
    (. bean3902 setConnectionId (clojure.core/str v3904)))
   (clojure.core/when-let
    [v3904 (:new-private-virtual-interface-allocation m3903)]
    (.
     bean3902
     setNewPrivateVirtualInterfaceAllocation
     (directconnect/new-private-virtual-interface-allocation v3904)))
   bean3902))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest}
describe-virtual-interfaces-request
  [m3906]
  (clojure.core/let
   [bean3905
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest)]
   (clojure.core/when-let
    [v3907 (:connection-id m3906)]
    (. bean3905 setConnectionId (clojure.core/str v3907)))
   (clojure.core/when-let
    [v3907 (:virtual-interface-id m3906)]
    (. bean3905 setVirtualInterfaceId (clojure.core/str v3907)))
   bean3905))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsRequest}
describe-connections-request
  [m3909]
  (clojure.core/let
   [bean3908
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsRequest)]
   (clojure.core/when-let
    [v3910 (:connection-id m3909)]
    (. bean3908 setConnectionId (clojure.core/str v3910)))
   bean3908))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest}
allocate-public-virtual-interface-request
  [m3912]
  (clojure.core/let
   [bean3911
    (new
     com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3913 (:owner-account m3912)]
    (. bean3911 setOwnerAccount (clojure.core/str v3913)))
   (clojure.core/when-let
    [v3913 (:connection-id m3912)]
    (. bean3911 setConnectionId (clojure.core/str v3913)))
   (clojure.core/when-let
    [v3913 (:new-public-virtual-interface-allocation m3912)]
    (.
     bean3911
     setNewPublicVirtualInterfaceAllocation
     (directconnect/new-public-virtual-interface-allocation v3913)))
   bean3911))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest}
describe-interconnects-request
  [m3915]
  (clojure.core/let
   [bean3914
    (new
     com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest)]
   (clojure.core/when-let
    [v3916 (:interconnect-id m3915)]
    (. bean3914 setInterconnectId (clojure.core/str v3916)))
   bean3914))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateConnectionRequest}
create-connection-request
  [m3918]
  (clojure.core/let
   [bean3917
    (new
     com.amazonaws.services.directconnect.model.CreateConnectionRequest)]
   (clojure.core/when-let
    [v3919 (:location m3918)]
    (. bean3917 setLocation (clojure.core/str v3919)))
   (clojure.core/when-let
    [v3919 (:bandwidth m3918)]
    (. bean3917 setBandwidth (clojure.core/str v3919)))
   (clojure.core/when-let
    [v3919 (:connection-name m3918)]
    (. bean3917 setConnectionName (clojure.core/str v3919)))
   bean3917))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteInterconnectRequest}
delete-interconnect-request
  [m3921]
  (clojure.core/let
   [bean3920
    (new
     com.amazonaws.services.directconnect.model.DeleteInterconnectRequest)]
   (clojure.core/when-let
    [v3922 (:interconnect-id m3921)]
    (. bean3920 setInterconnectId (clojure.core/str v3922)))
   bean3920))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest}
describe-virtual-gateways-request
  [m3924]
  (clojure.core/let
   [bean3923
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest)]
   bean3923))
 (clojure.core/defmulti
  directconnect
  (clojure.core/fn
   directconnect
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-connection
   [m3928]
   (clojure.core/let
    [credentials3929 (:credentials m3928) args3930 (:args m3928)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3931
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3929)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3931
       deleteConnection
       (directconnect/delete-connection-request
        (clojure.core/nth args3930 0)))))))
  (clojure.core/defn
   delete-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Generate map for deleteConnection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :delete-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-connection
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Call deleteConnection"}
   [credentials3933 & args3934]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3935
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3933)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3935
      deleteConnection
      (directconnect/delete-connection-request
       (clojure.core/nth args3934 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections-on-interconnect
   [m3936]
   (clojure.core/let
    [credentials3937 (:credentials m3936) args3938 (:args m3936)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3939
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3937)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3939
       describeConnectionsOnInterconnect
       (directconnect/describe-connections-on-interconnect-request
        (clojure.core/nth args3938 0)))))))
  (clojure.core/defn
   describe-connections-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Generate map for describeConnectionsOnInterconnect"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-connections-on-interconnect,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-connections-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Call describeConnectionsOnInterconnect"}
   [credentials3941 & args3942]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3943
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3941)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3943
      describeConnectionsOnInterconnect
      (directconnect/describe-connections-on-interconnect-request
       (clojure.core/nth args3942 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-locations
   [m3944]
   (clojure.core/let
    [credentials3945 (:credentials m3944) args3946 (:args m3944)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3947
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3945)]
     (clojure.core/case
      (clojure.core/count args3946)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3947
        describeLocations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3947
        describeLocations
        (directconnect/describe-locations-request
         (clojure.core/nth args3946 0))))))))
  (clojure.core/defn
   describe-locations-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeLocations, describeLocations"}
   ([credentials__1651__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-locations,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-locations,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-locations
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeLocations, describeLocations"}
   [credentials3949 & args3950]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3951
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3949)]
    (clojure.core/case
     (clojure.core/count args3950)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3951
       describeLocations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3951
       describeLocations
       (directconnect/describe-locations-request
        (clojure.core/nth args3950 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-connection-on-interconnect
   [m3952]
   (clojure.core/let
    [credentials3953 (:credentials m3952) args3954 (:args m3952)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3955
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3953)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3955
       allocateConnectionOnInterconnect
       (directconnect/allocate-connection-on-interconnect-request
        (clojure.core/nth args3954 0)))))))
  (clojure.core/defn
   allocate-connection-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         bandwidth
                         general-progress-listener
                         connection-name
                         vlan
                         owner-account]}]]),
    :doc "Generate map for allocateConnectionOnInterconnect"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :allocate-connection-on-interconnect,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   allocate-connection-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         bandwidth
                         general-progress-listener
                         connection-name
                         vlan
                         owner-account]}]]),
    :doc "Call allocateConnectionOnInterconnect"}
   [credentials3957 & args3958]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3959
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3957)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3959
      allocateConnectionOnInterconnect
      (directconnect/allocate-connection-on-interconnect-request
       (clojure.core/nth args3958 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-public-virtual-interface
   [m3960]
   (clojure.core/let
    [credentials3961 (:credentials m3960) args3962 (:args m3960)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3963
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3961)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3963
       createPublicVirtualInterface
       (directconnect/create-public-virtual-interface-request
        (clojure.core/nth args3962 0)))))))
  (clojure.core/defn
   create-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [new-public-virtual-interface
                         general-progress-listener
                         connection-id]}]]),
    :doc "Generate map for createPublicVirtualInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-public-virtual-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [new-public-virtual-interface
                         general-progress-listener
                         connection-id]}]]),
    :doc "Call createPublicVirtualInterface"}
   [credentials3965 & args3966]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3967
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3965)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3967
      createPublicVirtualInterface
      (directconnect/create-public-virtual-interface-request
       (clojure.core/nth args3966 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-connection
   [m3968]
   (clojure.core/let
    [credentials3969 (:credentials m3968) args3970 (:args m3968)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3971
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3969)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3971
       confirmConnection
       (directconnect/confirm-connection-request
        (clojure.core/nth args3970 0)))))))
  (clojure.core/defn
   confirm-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Generate map for confirmConnection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :confirm-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   confirm-connection
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Call confirmConnection"}
   [credentials3973 & args3974]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3975
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3973)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3975
      confirmConnection
      (directconnect/confirm-connection-request
       (clojure.core/nth args3974 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-private-virtual-interface
   [m3976]
   (clojure.core/let
    [credentials3977 (:credentials m3976) args3978 (:args m3976)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3979
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3977)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3979
       confirmPrivateVirtualInterface
       (directconnect/confirm-private-virtual-interface-request
        (clojure.core/nth args3978 0)))))))
  (clojure.core/defn
   confirm-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         virtual-gateway-id
                         general-progress-listener]}]]),
    :doc "Generate map for confirmPrivateVirtualInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :confirm-private-virtual-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   confirm-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         virtual-gateway-id
                         general-progress-listener]}]]),
    :doc "Call confirmPrivateVirtualInterface"}
   [credentials3981 & args3982]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3983
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3981)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3983
      confirmPrivateVirtualInterface
      (directconnect/confirm-private-virtual-interface-request
       (clojure.core/nth args3982 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-interconnect
   [m3984]
   (clojure.core/let
    [credentials3985 (:credentials m3984) args3986 (:args m3984)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3987
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3985)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3987
       createInterconnect
       (directconnect/create-interconnect-request
        (clojure.core/nth args3986 0)))))))
  (clojure.core/defn
   create-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [location
                         interconnect-name
                         general-progress-listener
                         bandwidth]}]]),
    :doc "Generate map for createInterconnect"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-interconnect,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [location
                         interconnect-name
                         general-progress-listener
                         bandwidth]}]]),
    :doc "Call createInterconnect"}
   [credentials3989 & args3990]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3991
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3989)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3991
      createInterconnect
      (directconnect/create-interconnect-request
       (clojure.core/nth args3990 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-public-virtual-interface
   [m3992]
   (clojure.core/let
    [credentials3993 (:credentials m3992) args3994 (:args m3992)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3995
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3993)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3995
       confirmPublicVirtualInterface
       (directconnect/confirm-public-virtual-interface-request
        (clojure.core/nth args3994 0)))))))
  (clojure.core/defn
   confirm-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         general-progress-listener]}]]),
    :doc "Generate map for confirmPublicVirtualInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :confirm-public-virtual-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   confirm-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         general-progress-listener]}]]),
    :doc "Call confirmPublicVirtualInterface"}
   [credentials3997 & args3998]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3999
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3997)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3999
      confirmPublicVirtualInterface
      (directconnect/confirm-public-virtual-interface-request
       (clojure.core/nth args3998 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-virtual-interface
   [m4000]
   (clojure.core/let
    [credentials4001 (:credentials m4000) args4002 (:args m4000)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4003
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4001)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4003
       deleteVirtualInterface
       (directconnect/delete-virtual-interface-request
        (clojure.core/nth args4002 0)))))))
  (clojure.core/defn
   delete-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         general-progress-listener]}]]),
    :doc "Generate map for deleteVirtualInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :delete-virtual-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         general-progress-listener]}]]),
    :doc "Call deleteVirtualInterface"}
   [credentials4005 & args4006]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4007
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4005)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4007
      deleteVirtualInterface
      (directconnect/delete-virtual-interface-request
       (clojure.core/nth args4006 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-private-virtual-interface
   [m4008]
   (clojure.core/let
    [credentials4009 (:credentials m4008) args4010 (:args m4008)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4011
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4009)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4011
       createPrivateVirtualInterface
       (directconnect/create-private-virtual-interface-request
        (clojure.core/nth args4010 0)))))))
  (clojure.core/defn
   create-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [new-private-virtual-interface
                         general-progress-listener
                         connection-id]}]]),
    :doc "Generate map for createPrivateVirtualInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-private-virtual-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [new-private-virtual-interface
                         general-progress-listener
                         connection-id]}]]),
    :doc "Call createPrivateVirtualInterface"}
   [credentials4013 & args4014]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4015
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4013)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4015
      createPrivateVirtualInterface
      (directconnect/create-private-virtual-interface-request
       (clojure.core/nth args4014 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-private-virtual-interface
   [m4016]
   (clojure.core/let
    [credentials4017 (:credentials m4016) args4018 (:args m4016)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4019
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4017)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4019
       allocatePrivateVirtualInterface
       (directconnect/allocate-private-virtual-interface-request
        (clojure.core/nth args4018 0)))))))
  (clojure.core/defn
   allocate-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [owner-account
                         new-private-virtual-interface-allocation
                         general-progress-listener
                         connection-id]}]]),
    :doc "Generate map for allocatePrivateVirtualInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :allocate-private-virtual-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   allocate-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [owner-account
                         new-private-virtual-interface-allocation
                         general-progress-listener
                         connection-id]}]]),
    :doc "Call allocatePrivateVirtualInterface"}
   [credentials4021 & args4022]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4023
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4021)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4023
      allocatePrivateVirtualInterface
      (directconnect/allocate-private-virtual-interface-request
       (clojure.core/nth args4022 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-interfaces
   [m4024]
   (clojure.core/let
    [credentials4025 (:credentials m4024) args4026 (:args m4024)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4027
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4025)]
     (clojure.core/case
      (clojure.core/count args4026)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4027
        describeVirtualInterfaces))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4027
        describeVirtualInterfaces
        (directconnect/describe-virtual-interfaces-request
         (clojure.core/nth args4026 0))))))))
  (clojure.core/defn
   describe-virtual-interfaces-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [virtual-interface-id
                         general-progress-listener
                         connection-id]}]]),
    :doc "Generate map for describeVirtualInterfaces, describeVirtualInterfaces"}
   ([credentials__1651__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-virtual-interfaces,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-virtual-interfaces,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-virtual-interfaces
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [virtual-interface-id
                         general-progress-listener
                         connection-id]}]]),
    :doc "Call describeVirtualInterfaces, describeVirtualInterfaces"}
   [credentials4029 & args4030]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4031
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4029)]
    (clojure.core/case
     (clojure.core/count args4030)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4031
       describeVirtualInterfaces))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4031
       describeVirtualInterfaces
       (directconnect/describe-virtual-interfaces-request
        (clojure.core/nth args4030 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections
   [m4032]
   (clojure.core/let
    [credentials4033 (:credentials m4032) args4034 (:args m4032)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4035
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4033)]
     (clojure.core/case
      (clojure.core/count args4034)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4035
        describeConnections))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4035
        describeConnections
        (directconnect/describe-connections-request
         (clojure.core/nth args4034 0))))))))
  (clojure.core/defn
   describe-connections-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Generate map for describeConnections, describeConnections"}
   ([credentials__1651__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-connections,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-connections,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-connections
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Call describeConnections, describeConnections"}
   [credentials4037 & args4038]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4039
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4037)]
    (clojure.core/case
     (clojure.core/count args4038)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4039
       describeConnections))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4039
       describeConnections
       (directconnect/describe-connections-request
        (clojure.core/nth args4038 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-public-virtual-interface
   [m4040]
   (clojure.core/let
    [credentials4041 (:credentials m4040) args4042 (:args m4040)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4043
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4041)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4043
       allocatePublicVirtualInterface
       (directconnect/allocate-public-virtual-interface-request
        (clojure.core/nth args4042 0)))))))
  (clojure.core/defn
   allocate-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [owner-account
                         new-public-virtual-interface-allocation
                         general-progress-listener
                         connection-id]}]]),
    :doc "Generate map for allocatePublicVirtualInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :allocate-public-virtual-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   allocate-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [owner-account
                         new-public-virtual-interface-allocation
                         general-progress-listener
                         connection-id]}]]),
    :doc "Call allocatePublicVirtualInterface"}
   [credentials4045 & args4046]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4047
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4045)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4047
      allocatePublicVirtualInterface
      (directconnect/allocate-public-virtual-interface-request
       (clojure.core/nth args4046 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-interconnects
   [m4048]
   (clojure.core/let
    [credentials4049 (:credentials m4048) args4050 (:args m4048)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4051
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4049)]
     (clojure.core/case
      (clojure.core/count args4050)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4051
        describeInterconnects))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4051
        describeInterconnects
        (directconnect/describe-interconnects-request
         (clojure.core/nth args4050 0))))))))
  (clojure.core/defn
   describe-interconnects-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Generate map for describeInterconnects, describeInterconnects"}
   ([credentials__1651__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-interconnects,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-interconnects,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-interconnects
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Call describeInterconnects, describeInterconnects"}
   [credentials4053 & args4054]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4055
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4053)]
    (clojure.core/case
     (clojure.core/count args4054)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4055
       describeInterconnects))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4055
       describeInterconnects
       (directconnect/describe-interconnects-request
        (clojure.core/nth args4054 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-connection
   [m4056]
   (clojure.core/let
    [credentials4057 (:credentials m4056) args4058 (:args m4056)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4059
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4057)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4059
       createConnection
       (directconnect/create-connection-request
        (clojure.core/nth args4058 0)))))))
  (clojure.core/defn
   create-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [location
                         general-progress-listener
                         connection-name
                         bandwidth]}]]),
    :doc "Generate map for createConnection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-connection
   {:arglists (quote
               [[credentials
                 {:keys [location
                         general-progress-listener
                         connection-name
                         bandwidth]}]]),
    :doc "Call createConnection"}
   [credentials4061 & args4062]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4063
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4061)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4063
      createConnection
      (directconnect/create-connection-request
       (clojure.core/nth args4062 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-interconnect
   [m4064]
   (clojure.core/let
    [credentials4065 (:credentials m4064) args4066 (:args m4064)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4067
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4065)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4067
       deleteInterconnect
       (directconnect/delete-interconnect-request
        (clojure.core/nth args4066 0)))))))
  (clojure.core/defn
   delete-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Generate map for deleteInterconnect"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :delete-interconnect,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Call deleteInterconnect"}
   [credentials4069 & args4070]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4071
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4069)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4071
      deleteInterconnect
      (directconnect/delete-interconnect-request
       (clojure.core/nth args4070 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-gateways
   [m4072]
   (clojure.core/let
    [credentials4073 (:credentials m4072) args4074 (:args m4072)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4075
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4073)]
     (clojure.core/case
      (clojure.core/count args4074)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4075
        describeVirtualGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4075
        describeVirtualGateways
        (directconnect/describe-virtual-gateways-request
         (clojure.core/nth args4074 0))))))))
  (clojure.core/defn
   describe-virtual-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeVirtualGateways, describeVirtualGateways"}
   ([credentials__1651__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-virtual-gateways,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-virtual-gateways,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-virtual-gateways
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeVirtualGateways, describeVirtualGateways"}
   [credentials4077 & args4078]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4079
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4077)]
    (clojure.core/case
     (clojure.core/count args4078)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4079
       describeVirtualGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4079
       describeVirtualGateways
       (directconnect/describe-virtual-gateways-request
        (clojure.core/nth args4078 0)))))))))
