(ns
 com.palletops.awaze.datapipeline
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.datapipeline :as datapipeline]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :datapipeline
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.datapipeline.DataPipelineClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Operator}
operator
  [m9770]
  (clojure.core/let
   [bean9769 (new com.amazonaws.services.datapipeline.model.Operator)]
   (clojure.core/when-let
    [v9771 (:values m9770)]
    (.
     bean9769
     setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9835] (clojure.core/str arg9835))
 v9771)))
   (clojure.core/when-let
    [v9771 (:type m9770)]
    (. bean9769 setType (clojure.core/str v9771)))
   bean9769))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Selector}
selector
  [m9773]
  (clojure.core/let
   [bean9772 (new com.amazonaws.services.datapipeline.model.Selector)]
   (clojure.core/when-let
    [v9774 (:field-name m9773)]
    (. bean9772 setFieldName (clojure.core/str v9774)))
   (clojure.core/when-let
    [v9774 (:operator m9773)]
    (. bean9772 setOperator (datapipeline/operator v9774)))
   bean9772))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Field}
field
  [m9776]
  (clojure.core/let
   [bean9775 (new com.amazonaws.services.datapipeline.model.Field)]
   (clojure.core/when-let
    [v9777 (:key m9776)]
    (. bean9775 setKey (clojure.core/str v9777)))
   (clojure.core/when-let
    [v9777 (:string-value m9776)]
    (. bean9775 setStringValue (clojure.core/str v9777)))
   (clojure.core/when-let
    [v9777 (:ref-value m9776)]
    (. bean9775 setRefValue (clojure.core/str v9777)))
   bean9775))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Query}
query
  [m9779]
  (clojure.core/let
   [bean9778 (new com.amazonaws.services.datapipeline.model.Query)]
   (clojure.core/when-let
    [v9780 (:selectors m9779)]
    (.
     bean9778
     setSelectors
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9836] (datapipeline/selector arg9836))
 v9780)))
   bean9778))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.InstanceIdentity}
instance-identity
  [m9782]
  (clojure.core/let
   [bean9781
    (new com.amazonaws.services.datapipeline.model.InstanceIdentity)]
   (clojure.core/when-let
    [v9783 (:document m9782)]
    (. bean9781 setDocument (clojure.core/str v9783)))
   (clojure.core/when-let
    [v9783 (:signature m9782)]
    (. bean9781 setSignature (clojure.core/str v9783)))
   bean9781))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PipelineObject}
pipeline-object
  [m9785]
  (clojure.core/let
   [bean9784
    (new com.amazonaws.services.datapipeline.model.PipelineObject)]
   (clojure.core/when-let
    [v9786 (:name m9785)]
    (. bean9784 setName (clojure.core/str v9786)))
   (clojure.core/when-let
    [v9786 (:fields m9785)]
    (.
     bean9784
     setFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9837] (datapipeline/field arg9837))
 v9786)))
   (clojure.core/when-let
    [v9786 (:id m9785)]
    (. bean9784 setId (clojure.core/str v9786)))
   bean9784))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DescribeObjectsRequest}
describe-objects-request
  [m9788]
  (clojure.core/let
   [bean9787
    (new
     com.amazonaws.services.datapipeline.model.DescribeObjectsRequest)]
   (clojure.core/when-let
    [v9789 (:marker m9788)]
    (. bean9787 setMarker (clojure.core/str v9789)))
   (clojure.core/when-let
    [v9789 (:pipeline-id m9788)]
    (. bean9787 setPipelineId (clojure.core/str v9789)))
   (clojure.core/when-let
    [v9789 (:object-ids m9788)]
    (.
     bean9787
     setObjectIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9838] (clojure.core/str arg9838))
 v9789)))
   (clojure.core/when-let
    [v9789 (:evaluate-expressions m9788)]
    (. bean9787 setEvaluateExpressions (clojure.core/boolean v9789)))
   bean9787))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest}
report-task-runner-heartbeat-request
  [m9791]
  (clojure.core/let
   [bean9790
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest)]
   (clojure.core/when-let
    [v9792 (:worker-group m9791)]
    (. bean9790 setWorkerGroup (clojure.core/str v9792)))
   (clojure.core/when-let
    [v9792 (:hostname m9791)]
    (. bean9790 setHostname (clojure.core/str v9792)))
   (clojure.core/when-let
    [v9792 (:taskrunner-id m9791)]
    (. bean9790 setTaskrunnerId (clojure.core/str v9792)))
   bean9790))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.QueryObjectsRequest}
query-objects-request
  [m9794]
  (clojure.core/let
   [bean9793
    (new
     com.amazonaws.services.datapipeline.model.QueryObjectsRequest)]
   (clojure.core/when-let
    [v9795 (:marker m9794)]
    (. bean9793 setMarker (clojure.core/str v9795)))
   (clojure.core/when-let
    [v9795 (:limit m9794)]
    (. bean9793 setLimit (clojure.core/int v9795)))
   (clojure.core/when-let
    [v9795 (:pipeline-id m9794)]
    (. bean9793 setPipelineId (clojure.core/str v9795)))
   (clojure.core/when-let
    [v9795 (:query m9794)]
    (. bean9793 setQuery (datapipeline/query v9795)))
   (clojure.core/when-let
    [v9795 (:sphere m9794)]
    (. bean9793 setSphere (clojure.core/str v9795)))
   bean9793))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DescribePipelinesRequest}
describe-pipelines-request
  [m9797]
  (clojure.core/let
   [bean9796
    (new
     com.amazonaws.services.datapipeline.model.DescribePipelinesRequest)]
   (clojure.core/when-let
    [v9798 (:pipeline-ids m9797)]
    (.
     bean9796
     setPipelineIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9839] (clojure.core/str arg9839))
 v9798)))
   bean9796))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ActivatePipelineRequest}
activate-pipeline-request
  [m9800]
  (clojure.core/let
   [bean9799
    (new
     com.amazonaws.services.datapipeline.model.ActivatePipelineRequest)]
   (clojure.core/when-let
    [v9801 (:pipeline-id m9800)]
    (. bean9799 setPipelineId (clojure.core/str v9801)))
   bean9799))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.SetStatusRequest}
set-status-request
  [m9803]
  (clojure.core/let
   [bean9802
    (new com.amazonaws.services.datapipeline.model.SetStatusRequest)]
   (clojure.core/when-let
    [v9804 (:status m9803)]
    (. bean9802 setStatus (clojure.core/str v9804)))
   (clojure.core/when-let
    [v9804 (:pipeline-id m9803)]
    (. bean9802 setPipelineId (clojure.core/str v9804)))
   (clojure.core/when-let
    [v9804 (:object-ids m9803)]
    (.
     bean9802
     setObjectIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9840] (clojure.core/str arg9840))
 v9804)))
   bean9802))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest}
get-pipeline-definition-request
  [m9806]
  (clojure.core/let
   [bean9805
    (new
     com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest)]
   (clojure.core/when-let
    [v9807 (:version m9806)]
    (. bean9805 setVersion (clojure.core/str v9807)))
   (clojure.core/when-let
    [v9807 (:pipeline-id m9806)]
    (. bean9805 setPipelineId (clojure.core/str v9807)))
   bean9805))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PollForTaskRequest}
poll-for-task-request
  [m9809]
  (clojure.core/let
   [bean9808
    (new com.amazonaws.services.datapipeline.model.PollForTaskRequest)]
   (clojure.core/when-let
    [v9810 (:worker-group m9809)]
    (. bean9808 setWorkerGroup (clojure.core/str v9810)))
   (clojure.core/when-let
    [v9810 (:hostname m9809)]
    (. bean9808 setHostname (clojure.core/str v9810)))
   (clojure.core/when-let
    [v9810 (:instance-identity m9809)]
    (.
     bean9808
     setInstanceIdentity
     (datapipeline/instance-identity v9810)))
   bean9808))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest}
report-task-progress-request
  [m9812]
  (clojure.core/let
   [bean9811
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest)]
   (clojure.core/when-let
    [v9813 (:task-id m9812)]
    (. bean9811 setTaskId (clojure.core/str v9813)))
   bean9811))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DeletePipelineRequest}
delete-pipeline-request
  [m9815]
  (clojure.core/let
   [bean9814
    (new
     com.amazonaws.services.datapipeline.model.DeletePipelineRequest)]
   (clojure.core/when-let
    [v9816 (:pipeline-id m9815)]
    (. bean9814 setPipelineId (clojure.core/str v9816)))
   bean9814))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.CreatePipelineRequest}
create-pipeline-request
  [m9818]
  (clojure.core/let
   [bean9817
    (new
     com.amazonaws.services.datapipeline.model.CreatePipelineRequest)]
   (clojure.core/when-let
    [v9819 (:name m9818)]
    (. bean9817 setName (clojure.core/str v9819)))
   (clojure.core/when-let
    [v9819 (:description m9818)]
    (. bean9817 setDescription (clojure.core/str v9819)))
   (clojure.core/when-let
    [v9819 (:unique-id m9818)]
    (. bean9817 setUniqueId (clojure.core/str v9819)))
   bean9817))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest}
evaluate-expression-request
  [m9821]
  (clojure.core/let
   [bean9820
    (new
     com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest)]
   (clojure.core/when-let
    [v9822 (:expression m9821)]
    (. bean9820 setExpression (clojure.core/str v9822)))
   (clojure.core/when-let
    [v9822 (:pipeline-id m9821)]
    (. bean9820 setPipelineId (clojure.core/str v9822)))
   (clojure.core/when-let
    [v9822 (:object-id m9821)]
    (. bean9820 setObjectId (clojure.core/str v9822)))
   bean9820))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest}
put-pipeline-definition-request
  [m9824]
  (clojure.core/let
   [bean9823
    (new
     com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest)]
   (clojure.core/when-let
    [v9825 (:pipeline-id m9824)]
    (. bean9823 setPipelineId (clojure.core/str v9825)))
   (clojure.core/when-let
    [v9825 (:pipeline-objects m9824)]
    (.
     bean9823
     setPipelineObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9841] (datapipeline/pipeline-object arg9841))
 v9825)))
   bean9823))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ListPipelinesRequest}
list-pipelines-request
  [m9827]
  (clojure.core/let
   [bean9826
    (new
     com.amazonaws.services.datapipeline.model.ListPipelinesRequest)]
   (clojure.core/when-let
    [v9828 (:marker m9827)]
    (. bean9826 setMarker (clojure.core/str v9828)))
   bean9826))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.SetTaskStatusRequest}
set-task-status-request
  [m9830]
  (clojure.core/let
   [bean9829
    (new
     com.amazonaws.services.datapipeline.model.SetTaskStatusRequest)]
   (clojure.core/when-let
    [v9831 (:task-id m9830)]
    (. bean9829 setTaskId (clojure.core/str v9831)))
   (clojure.core/when-let
    [v9831 (:task-status m9830)]
    (. bean9829 setTaskStatus (clojure.core/str v9831)))
   (clojure.core/when-let
    [v9831 (:error-id m9830)]
    (. bean9829 setErrorId (clojure.core/str v9831)))
   (clojure.core/when-let
    [v9831 (:error-message m9830)]
    (. bean9829 setErrorMessage (clojure.core/str v9831)))
   (clojure.core/when-let
    [v9831 (:error-stack-trace m9830)]
    (. bean9829 setErrorStackTrace (clojure.core/str v9831)))
   bean9829))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest}
validate-pipeline-definition-request
  [m9833]
  (clojure.core/let
   [bean9832
    (new
     com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest)]
   (clojure.core/when-let
    [v9834 (:pipeline-id m9833)]
    (. bean9832 setPipelineId (clojure.core/str v9834)))
   (clojure.core/when-let
    [v9834 (:pipeline-objects m9833)]
    (.
     bean9832
     setPipelineObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9842] (datapipeline/pipeline-object arg9842))
 v9834)))
   bean9832))
 (clojure.core/defmulti
  datapipeline
  (clojure.core/fn
   datapipeline
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-objects
   [m9843]
   (clojure.core/let
    [credentials9844 (:credentials m9843) args9845 (:args m9843)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9846
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9844)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9846
       describeObjects
       (datapipeline/describe-objects-request
        (clojure.core/nth args9845 0)))))))
  (clojure.core/defn
   describe-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id
                         object-ids
                         marker
                         general-progress-listener
                         evaluate-expressions]}]]),
    :doc "Generate map for describeObjects"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :describe-objects,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-objects
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id
                         object-ids
                         marker
                         general-progress-listener
                         evaluate-expressions]}]]),
    :doc "Call describeObjects"}
   [credentials9848 & args9849]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9850
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9848)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9850
      describeObjects
      (datapipeline/describe-objects-request
       (clojure.core/nth args9849 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-runner-heartbeat
   [m9851]
   (clojure.core/let
    [credentials9852 (:credentials m9851) args9853 (:args m9851)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9854
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9852)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9854
       reportTaskRunnerHeartbeat
       (datapipeline/report-task-runner-heartbeat-request
        (clojure.core/nth args9853 0)))))))
  (clojure.core/defn
   report-task-runner-heartbeat-map
   {:arglists (quote
               [[credentials
                 {:keys [worker-group
                         taskrunner-id
                         hostname
                         general-progress-listener]}]]),
    :doc "Generate map for reportTaskRunnerHeartbeat"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :report-task-runner-heartbeat,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   report-task-runner-heartbeat
   {:arglists (quote
               [[credentials
                 {:keys [worker-group
                         taskrunner-id
                         hostname
                         general-progress-listener]}]]),
    :doc "Call reportTaskRunnerHeartbeat"}
   [credentials9856 & args9857]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9858
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9856)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9858
      reportTaskRunnerHeartbeat
      (datapipeline/report-task-runner-heartbeat-request
       (clojure.core/nth args9857 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :query-objects
   [m9859]
   (clojure.core/let
    [credentials9860 (:credentials m9859) args9861 (:args m9859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9862
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9860)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9862
       queryObjects
       (datapipeline/query-objects-request
        (clojure.core/nth args9861 0)))))))
  (clojure.core/defn
   query-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [query
                         sphere
                         marker
                         limit
                         general-progress-listener
                         pipeline-id]}]]),
    :doc "Generate map for queryObjects"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :query-objects,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   query-objects
   {:arglists (quote
               [[credentials
                 {:keys [query
                         sphere
                         marker
                         limit
                         general-progress-listener
                         pipeline-id]}]]),
    :doc "Call queryObjects"}
   [credentials9864 & args9865]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9866
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9864)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9866
      queryObjects
      (datapipeline/query-objects-request
       (clojure.core/nth args9865 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-pipelines
   [m9867]
   (clojure.core/let
    [credentials9868 (:credentials m9867) args9869 (:args m9867)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9870
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9868)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9870
       describePipelines
       (datapipeline/describe-pipelines-request
        (clojure.core/nth args9869 0)))))))
  (clojure.core/defn
   describe-pipelines-map
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-ids general-progress-listener]}]]),
    :doc "Generate map for describePipelines"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :describe-pipelines,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-pipelines
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-ids general-progress-listener]}]]),
    :doc "Call describePipelines"}
   [credentials9872 & args9873]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9874
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9872)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9874
      describePipelines
      (datapipeline/describe-pipelines-request
       (clojure.core/nth args9873 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :activate-pipeline
   [m9875]
   (clojure.core/let
    [credentials9876 (:credentials m9875) args9877 (:args m9875)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9878
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9876)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9878
       activatePipeline
       (datapipeline/activate-pipeline-request
        (clojure.core/nth args9877 0)))))))
  (clojure.core/defn
   activate-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id general-progress-listener]}]]),
    :doc "Generate map for activatePipeline"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :activate-pipeline,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   activate-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id general-progress-listener]}]]),
    :doc "Call activatePipeline"}
   [credentials9880 & args9881]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9882
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9880)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9882
      activatePipeline
      (datapipeline/activate-pipeline-request
       (clojure.core/nth args9881 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-status
   [m9883]
   (clojure.core/let
    [credentials9884 (:credentials m9883) args9885 (:args m9883)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9886
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9884)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9886
       setStatus
       (datapipeline/set-status-request (clojure.core/nth args9885 0)))))))
  (clojure.core/defn
   set-status-map
   {:arglists (quote
               [[credentials
                 {:keys [status
                         pipeline-id
                         object-ids
                         general-progress-listener]}]]),
    :doc "Generate map for setStatus"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :set-status,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-status
   {:arglists (quote
               [[credentials
                 {:keys [status
                         pipeline-id
                         object-ids
                         general-progress-listener]}]]),
    :doc "Call setStatus"}
   [credentials9888 & args9889]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9890
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9888)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9890
      setStatus
      (datapipeline/set-status-request (clojure.core/nth args9889 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :get-pipeline-definition
   [m9891]
   (clojure.core/let
    [credentials9892 (:credentials m9891) args9893 (:args m9891)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9894
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9892)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9894
       getPipelineDefinition
       (datapipeline/get-pipeline-definition-request
        (clojure.core/nth args9893 0)))))))
  (clojure.core/defn
   get-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [version
                         pipeline-id
                         general-progress-listener]}]]),
    :doc "Generate map for getPipelineDefinition"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :get-pipeline-definition,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [version
                         pipeline-id
                         general-progress-listener]}]]),
    :doc "Call getPipelineDefinition"}
   [credentials9896 & args9897]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9898
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9896)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9898
      getPipelineDefinition
      (datapipeline/get-pipeline-definition-request
       (clojure.core/nth args9897 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :poll-for-task
   [m9899]
   (clojure.core/let
    [credentials9900 (:credentials m9899) args9901 (:args m9899)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9902
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9900)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9902
       pollForTask
       (datapipeline/poll-for-task-request
        (clojure.core/nth args9901 0)))))))
  (clojure.core/defn
   poll-for-task-map
   {:arglists (quote
               [[credentials
                 {:keys [worker-group
                         instance-identity
                         hostname
                         general-progress-listener]}]]),
    :doc "Generate map for pollForTask"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :poll-for-task,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   poll-for-task
   {:arglists (quote
               [[credentials
                 {:keys [worker-group
                         instance-identity
                         hostname
                         general-progress-listener]}]]),
    :doc "Call pollForTask"}
   [credentials9904 & args9905]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9906
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9904)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9906
      pollForTask
      (datapipeline/poll-for-task-request
       (clojure.core/nth args9905 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-progress
   [m9907]
   (clojure.core/let
    [credentials9908 (:credentials m9907) args9909 (:args m9907)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9910
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9908)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9910
       reportTaskProgress
       (datapipeline/report-task-progress-request
        (clojure.core/nth args9909 0)))))))
  (clojure.core/defn
   report-task-progress-map
   {:arglists (quote
               [[credentials
                 {:keys [task-id general-progress-listener]}]]),
    :doc "Generate map for reportTaskProgress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :report-task-progress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   report-task-progress
   {:arglists (quote
               [[credentials
                 {:keys [task-id general-progress-listener]}]]),
    :doc "Call reportTaskProgress"}
   [credentials9912 & args9913]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9914
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9912)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9914
      reportTaskProgress
      (datapipeline/report-task-progress-request
       (clojure.core/nth args9913 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :delete-pipeline
   [m9915]
   (clojure.core/let
    [credentials9916 (:credentials m9915) args9917 (:args m9915)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9918
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9916)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9918
       deletePipeline
       (datapipeline/delete-pipeline-request
        (clojure.core/nth args9917 0)))))))
  (clojure.core/defn
   delete-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id general-progress-listener]}]]),
    :doc "Generate map for deletePipeline"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :delete-pipeline,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id general-progress-listener]}]]),
    :doc "Call deletePipeline"}
   [credentials9920 & args9921]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9922
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9920)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9922
      deletePipeline
      (datapipeline/delete-pipeline-request
       (clojure.core/nth args9921 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :create-pipeline
   [m9923]
   (clojure.core/let
    [credentials9924 (:credentials m9923) args9925 (:args m9923)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9926
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9924)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9926
       createPipeline
       (datapipeline/create-pipeline-request
        (clojure.core/nth args9925 0)))))))
  (clojure.core/defn
   create-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [unique-id
                         name
                         general-progress-listener
                         description]}]]),
    :doc "Generate map for createPipeline"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :create-pipeline,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [unique-id
                         name
                         general-progress-listener
                         description]}]]),
    :doc "Call createPipeline"}
   [credentials9928 & args9929]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9930
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9928)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9930
      createPipeline
      (datapipeline/create-pipeline-request
       (clojure.core/nth args9929 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :evaluate-expression
   [m9931]
   (clojure.core/let
    [credentials9932 (:credentials m9931) args9933 (:args m9931)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9934
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9932)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9934
       evaluateExpression
       (datapipeline/evaluate-expression-request
        (clojure.core/nth args9933 0)))))))
  (clojure.core/defn
   evaluate-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id
                         object-id
                         general-progress-listener
                         expression]}]]),
    :doc "Generate map for evaluateExpression"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :evaluate-expression,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   evaluate-expression
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-id
                         object-id
                         general-progress-listener
                         expression]}]]),
    :doc "Call evaluateExpression"}
   [credentials9936 & args9937]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9938
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9936)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9938
      evaluateExpression
      (datapipeline/evaluate-expression-request
       (clojure.core/nth args9937 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :put-pipeline-definition
   [m9939]
   (clojure.core/let
    [credentials9940 (:credentials m9939) args9941 (:args m9939)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9942
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9940)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9942
       putPipelineDefinition
       (datapipeline/put-pipeline-definition-request
        (clojure.core/nth args9941 0)))))))
  (clojure.core/defn
   put-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-objects
                         pipeline-id
                         general-progress-listener]}]]),
    :doc "Generate map for putPipelineDefinition"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :put-pipeline-definition,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-objects
                         pipeline-id
                         general-progress-listener]}]]),
    :doc "Call putPipelineDefinition"}
   [credentials9944 & args9945]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9946
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9944)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9946
      putPipelineDefinition
      (datapipeline/put-pipeline-definition-request
       (clojure.core/nth args9945 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :list-pipelines
   [m9947]
   (clojure.core/let
    [credentials9948 (:credentials m9947) args9949 (:args m9947)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9950
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9948)]
     (clojure.core/case
      (clojure.core/count args9949)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9950
        listPipelines))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9950
        listPipelines
        (datapipeline/list-pipelines-request
         (clojure.core/nth args9949 0))))))))
  (clojure.core/defn
   list-pipelines-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker general-progress-listener]}]]),
    :doc "Generate map for listPipelines, listPipelines"}
   ([credentials__1651__auto__]
    {:args [],
     :client :datapipeline,
     :fn :list-pipelines,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :list-pipelines,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-pipelines
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker general-progress-listener]}]]),
    :doc "Call listPipelines, listPipelines"}
   [credentials9952 & args9953]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9954
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9952)]
    (clojure.core/case
     (clojure.core/count args9953)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9954
       listPipelines))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9954
       listPipelines
       (datapipeline/list-pipelines-request
        (clojure.core/nth args9953 0))))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-task-status
   [m9955]
   (clojure.core/let
    [credentials9956 (:credentials m9955) args9957 (:args m9955)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9958
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9956)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9958
       setTaskStatus
       (datapipeline/set-task-status-request
        (clojure.core/nth args9957 0)))))))
  (clojure.core/defn
   set-task-status-map
   {:arglists (quote
               [[credentials
                 {:keys [task-status
                         task-id
                         general-progress-listener
                         error-message
                         error-stack-trace
                         error-id]}]]),
    :doc "Generate map for setTaskStatus"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :set-task-status,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-task-status
   {:arglists (quote
               [[credentials
                 {:keys [task-status
                         task-id
                         general-progress-listener
                         error-message
                         error-stack-trace
                         error-id]}]]),
    :doc "Call setTaskStatus"}
   [credentials9960 & args9961]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9962
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9960)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9962
      setTaskStatus
      (datapipeline/set-task-status-request
       (clojure.core/nth args9961 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :validate-pipeline-definition
   [m9963]
   (clojure.core/let
    [credentials9964 (:credentials m9963) args9965 (:args m9963)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client9966
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9964)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9966
       validatePipelineDefinition
       (datapipeline/validate-pipeline-definition-request
        (clojure.core/nth args9965 0)))))))
  (clojure.core/defn
   validate-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-objects
                         pipeline-id
                         general-progress-listener]}]]),
    :doc "Generate map for validatePipelineDefinition"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :validate-pipeline-definition,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   validate-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [pipeline-objects
                         pipeline-id
                         general-progress-listener]}]]),
    :doc "Call validatePipelineDefinition"}
   [credentials9968 & args9969]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client9970
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9968)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client9970
      validatePipelineDefinition
      (datapipeline/validate-pipeline-definition-request
       (clojure.core/nth args9969 0))))))))
