(ns
 com.palletops.awaze.autoscaling
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.autoscaling :as autoscaling]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :autoscaling
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.autoscaling.AmazonAutoScalingClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Ebs}
ebs
  [m3419]
  (clojure.core/let
   [bean3418 (new com.amazonaws.services.autoscaling.model.Ebs)]
   (clojure.core/when-let
    [v3420 (:snapshot-id m3419)]
    (. bean3418 setSnapshotId (clojure.core/str v3420)))
   (clojure.core/when-let
    [v3420 (:volume-size m3419)]
    (. bean3418 setVolumeSize (clojure.core/int v3420)))
   (clojure.core/when-let
    [v3420 (:volume-type m3419)]
    (. bean3418 setVolumeType (clojure.core/str v3420)))
   (clojure.core/when-let
    [v3420 (:delete-on-termination m3419)]
    (. bean3418 setDeleteOnTermination (clojure.core/boolean v3420)))
   (clojure.core/when-let
    [v3420 (:iops m3419)]
    (. bean3418 setIops (clojure.core/int v3420)))
   bean3418))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Tag}
tag
  [m3422]
  (clojure.core/let
   [bean3421 (new com.amazonaws.services.autoscaling.model.Tag)]
   (clojure.core/when-let
    [v3423 (:value m3422)]
    (. bean3421 setValue (clojure.core/str v3423)))
   (clojure.core/when-let
    [v3423 (:resource-id m3422)]
    (. bean3421 setResourceId (clojure.core/str v3423)))
   (clojure.core/when-let
    [v3423 (:resource-type m3422)]
    (. bean3421 setResourceType (clojure.core/str v3423)))
   (clojure.core/when-let
    [v3423 (:key m3422)]
    (. bean3421 setKey (clojure.core/str v3423)))
   (clojure.core/when-let
    [v3423 (:propagate-at-launch m3422)]
    (. bean3421 setPropagateAtLaunch (clojure.core/boolean v3423)))
   bean3421))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.BlockDeviceMapping}
block-device-mapping
  [m3425]
  (clojure.core/let
   [bean3424
    (new com.amazonaws.services.autoscaling.model.BlockDeviceMapping)]
   (clojure.core/when-let
    [v3426 (:virtual-name m3425)]
    (. bean3424 setVirtualName (clojure.core/str v3426)))
   (clojure.core/when-let
    [v3426 (:device-name m3425)]
    (. bean3424 setDeviceName (clojure.core/str v3426)))
   (clojure.core/when-let
    [v3426 (:ebs m3425)]
    (. bean3424 setEbs (autoscaling/ebs v3426)))
   (clojure.core/when-let
    [v3426 (:no-device m3425)]
    (. bean3424 setNoDevice (clojure.core/boolean v3426)))
   bean3424))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.InstanceMonitoring}
instance-monitoring
  [m3428]
  (clojure.core/let
   [bean3427
    (new com.amazonaws.services.autoscaling.model.InstanceMonitoring)]
   (clojure.core/when-let
    [v3429 (:enabled m3428)]
    (. bean3427 setEnabled (clojure.core/boolean v3429)))
   bean3427))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Filter}
filter
  [m3431]
  (clojure.core/let
   [bean3430 (new com.amazonaws.services.autoscaling.model.Filter)]
   (clojure.core/when-let
    [v3432 (:name m3431)]
    (. bean3430 setName (clojure.core/str v3432)))
   (clojure.core/when-let
    [v3432 (:values m3431)]
    (.
     bean3430
     setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3541] (clojure.core/str arg3541))
 v3432)))
   bean3430))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest}
set-desired-capacity-request
  [m3434]
  (clojure.core/let
   [bean3433
    (new
     com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest)]
   (clojure.core/when-let
    [v3435 (:desired-capacity m3434)]
    (. bean3433 setDesiredCapacity (clojure.core/int v3435)))
   (clojure.core/when-let
    [v3435 (:auto-scaling-group-name m3434)]
    (. bean3433 setAutoScalingGroupName (clojure.core/str v3435)))
   (clojure.core/when-let
    [v3435 (:honor-cooldown m3434)]
    (. bean3433 setHonorCooldown (clojure.core/boolean v3435)))
   bean3433))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest}
enable-metrics-collection-request
  [m3437]
  (clojure.core/let
   [bean3436
    (new
     com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest)]
   (clojure.core/when-let
    [v3438 (:auto-scaling-group-name m3437)]
    (. bean3436 setAutoScalingGroupName (clojure.core/str v3438)))
   (clojure.core/when-let
    [v3438 (:metrics m3437)]
    (.
     bean3436
     setMetrics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3542] (clojure.core/str arg3542))
 v3438)))
   (clojure.core/when-let
    [v3438 (:granularity m3437)]
    (. bean3436 setGranularity (clojure.core/str v3438)))
   bean3436))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeletePolicyRequest}
delete-policy-request
  [m3440]
  (clojure.core/let
   [bean3439
    (new com.amazonaws.services.autoscaling.model.DeletePolicyRequest)]
   (clojure.core/when-let
    [v3441 (:auto-scaling-group-name m3440)]
    (. bean3439 setAutoScalingGroupName (clojure.core/str v3441)))
   (clojure.core/when-let
    [v3441 (:policy-name m3440)]
    (. bean3439 setPolicyName (clojure.core/str v3441)))
   bean3439))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest}
set-instance-health-request
  [m3443]
  (clojure.core/let
   [bean3442
    (new
     com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest)]
   (clojure.core/when-let
    [v3444 (:instance-id m3443)]
    (. bean3442 setInstanceId (clojure.core/str v3444)))
   (clojure.core/when-let
    [v3444 (:health-status m3443)]
    (. bean3442 setHealthStatus (clojure.core/str v3444)))
   (clojure.core/when-let
    [v3444 (:should-respect-grace-period m3443)]
    (.
     bean3442
     setShouldRespectGracePeriod
     (clojure.core/boolean v3444)))
   bean3442))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest}
describe-launch-configurations-request
  [m3446]
  (clojure.core/let
   [bean3445
    (new
     com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest)]
   (clojure.core/when-let
    [v3447 (:max-records m3446)]
    (. bean3445 setMaxRecords (clojure.core/int v3447)))
   (clojure.core/when-let
    [v3447 (:launch-configuration-names m3446)]
    (.
     bean3445
     setLaunchConfigurationNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3543] (clojure.core/str arg3543))
 v3447)))
   (clojure.core/when-let
    [v3447 (:next-token m3446)]
    (. bean3445 setNextToken (clojure.core/str v3447)))
   bean3445))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteTagsRequest}
delete-tags-request
  [m3449]
  (clojure.core/let
   [bean3448
    (new com.amazonaws.services.autoscaling.model.DeleteTagsRequest)]
   (clojure.core/when-let
    [v3450 (:tags m3449)]
    (.
     bean3448
     setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3544] (autoscaling/tag arg3544))
 v3450)))
   bean3448))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest}
describe-auto-scaling-instances-request
  [m3452]
  (clojure.core/let
   [bean3451
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest)]
   (clojure.core/when-let
    [v3453 (:max-records m3452)]
    (. bean3451 setMaxRecords (clojure.core/int v3453)))
   (clojure.core/when-let
    [v3453 (:instance-ids m3452)]
    (.
     bean3451
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3545] (clojure.core/str arg3545))
 v3453)))
   (clojure.core/when-let
    [v3453 (:next-token m3452)]
    (. bean3451 setNextToken (clojure.core/str v3453)))
   bean3451))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest}
describe-account-limits-request
  [m3455]
  (clojure.core/let
   [bean3454
    (new
     com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest)]
   bean3454))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest}
describe-notification-configurations-request
  [m3458]
  (clojure.core/let
   [bean3457
    (new
     com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest)]
   (clojure.core/when-let
    [v3459 (:max-records m3458)]
    (. bean3457 setMaxRecords (clojure.core/int v3459)))
   (clojure.core/when-let
    [v3459 (:auto-scaling-group-names m3458)]
    (.
     bean3457
     setAutoScalingGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3546] (clojure.core/str arg3546))
 v3459)))
   (clojure.core/when-let
    [v3459 (:next-token m3458)]
    (. bean3457 setNextToken (clojure.core/str v3459)))
   bean3457))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest}
describe-auto-scaling-notification-types-request
  [m3461]
  (clojure.core/let
   [bean3460
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest)]
   bean3460))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest}
put-notification-configuration-request
  [m3464]
  (clojure.core/let
   [bean3463
    (new
     com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest)]
   (clojure.core/when-let
    [v3465 (:auto-scaling-group-name m3464)]
    (. bean3463 setAutoScalingGroupName (clojure.core/str v3465)))
   (clojure.core/when-let
    [v3465 (:topic-arn m3464)]
    (. bean3463 setTopicARN (clojure.core/str v3465)))
   (clojure.core/when-let
    [v3465 (:notification-types m3464)]
    (.
     bean3463
     setNotificationTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3547] (clojure.core/str arg3547))
 v3465)))
   bean3463))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribePoliciesRequest}
describe-policies-request
  [m3467]
  (clojure.core/let
   [bean3466
    (new
     com.amazonaws.services.autoscaling.model.DescribePoliciesRequest)]
   (clojure.core/when-let
    [v3468 (:max-records m3467)]
    (. bean3466 setMaxRecords (clojure.core/int v3468)))
   (clojure.core/when-let
    [v3468 (:auto-scaling-group-name m3467)]
    (. bean3466 setAutoScalingGroupName (clojure.core/str v3468)))
   (clojure.core/when-let
    [v3468 (:policy-names m3467)]
    (.
     bean3466
     setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3548] (clojure.core/str arg3548))
 v3468)))
   (clojure.core/when-let
    [v3468 (:next-token m3467)]
    (. bean3466 setNextToken (clojure.core/str v3468)))
   bean3466))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SuspendProcessesRequest}
suspend-processes-request
  [m3470]
  (clojure.core/let
   [bean3469
    (new
     com.amazonaws.services.autoscaling.model.SuspendProcessesRequest)]
   (clojure.core/when-let
    [v3471 (:auto-scaling-group-name m3470)]
    (. bean3469 setAutoScalingGroupName (clojure.core/str v3471)))
   (clojure.core/when-let
    [v3471 (:scaling-processes m3470)]
    (.
     bean3469
     setScalingProcesses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3549] (clojure.core/str arg3549))
 v3471)))
   bean3469))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest}
create-auto-scaling-group-request
  [m3473]
  (clojure.core/let
   [bean3472
    (new
     com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v3474 (:max-size m3473)]
    (. bean3472 setMaxSize (clojure.core/int v3474)))
   (clojure.core/when-let
    [v3474 (:health-check-type m3473)]
    (. bean3472 setHealthCheckType (clojure.core/str v3474)))
   (clojure.core/when-let
    [v3474 (:default-cooldown m3473)]
    (. bean3472 setDefaultCooldown (clojure.core/int v3474)))
   (clojure.core/when-let
    [v3474 (:load-balancer-names m3473)]
    (.
     bean3472
     setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3550] (clojure.core/str arg3550))
 v3474)))
   (clojure.core/when-let
    [v3474 (:availability-zones m3473)]
    (.
     bean3472
     setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3551] (clojure.core/str arg3551))
 v3474)))
   (clojure.core/when-let
    [v3474 (:launch-configuration-name m3473)]
    (. bean3472 setLaunchConfigurationName (clojure.core/str v3474)))
   (clojure.core/when-let
    [v3474 (:health-check-grace-period m3473)]
    (. bean3472 setHealthCheckGracePeriod (clojure.core/int v3474)))
   (clojure.core/when-let
    [v3474 (:min-size m3473)]
    (. bean3472 setMinSize (clojure.core/int v3474)))
   (clojure.core/when-let
    [v3474 (:desired-capacity m3473)]
    (. bean3472 setDesiredCapacity (clojure.core/int v3474)))
   (clojure.core/when-let
    [v3474 (:termination-policies m3473)]
    (.
     bean3472
     setTerminationPolicies
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3552] (clojure.core/str arg3552))
 v3474)))
   (clojure.core/when-let
    [v3474 (:instance-id m3473)]
    (. bean3472 setInstanceId (clojure.core/str v3474)))
   (clojure.core/when-let
    [v3474 (:auto-scaling-group-name m3473)]
    (. bean3472 setAutoScalingGroupName (clojure.core/str v3474)))
   (clojure.core/when-let
    [v3474 (:tags m3473)]
    (.
     bean3472
     setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3553] (autoscaling/tag arg3553))
 v3474)))
   (clojure.core/when-let
    [v3474 (:vpczone-identifier m3473)]
    (. bean3472 setVPCZoneIdentifier (clojure.core/str v3474)))
   (clojure.core/when-let
    [v3474 (:placement-group m3473)]
    (. bean3472 setPlacementGroup (clojure.core/str v3474)))
   bean3472))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest}
describe-auto-scaling-groups-request
  [m3476]
  (clojure.core/let
   [bean3475
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest)]
   (clojure.core/when-let
    [v3477 (:max-records m3476)]
    (. bean3475 setMaxRecords (clojure.core/int v3477)))
   (clojure.core/when-let
    [v3477 (:auto-scaling-group-names m3476)]
    (.
     bean3475
     setAutoScalingGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3554] (clojure.core/str arg3554))
 v3477)))
   (clojure.core/when-let
    [v3477 (:next-token m3476)]
    (. bean3475 setNextToken (clojure.core/str v3477)))
   bean3475))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest}
put-scaling-policy-request
  [m3479]
  (clojure.core/let
   [bean3478
    (new
     com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest)]
   (clojure.core/when-let
    [v3480 (:auto-scaling-group-name m3479)]
    (. bean3478 setAutoScalingGroupName (clojure.core/str v3480)))
   (clojure.core/when-let
    [v3480 (:policy-name m3479)]
    (. bean3478 setPolicyName (clojure.core/str v3480)))
   (clojure.core/when-let
    [v3480 (:scaling-adjustment m3479)]
    (. bean3478 setScalingAdjustment (clojure.core/int v3480)))
   (clojure.core/when-let
    [v3480 (:adjustment-type m3479)]
    (. bean3478 setAdjustmentType (clojure.core/str v3480)))
   (clojure.core/when-let
    [v3480 (:cooldown m3479)]
    (. bean3478 setCooldown (clojure.core/int v3480)))
   (clojure.core/when-let
    [v3480 (:min-adjustment-step m3479)]
    (. bean3478 setMinAdjustmentStep (clojure.core/int v3480)))
   bean3478))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ExecutePolicyRequest}
execute-policy-request
  [m3482]
  (clojure.core/let
   [bean3481
    (new
     com.amazonaws.services.autoscaling.model.ExecutePolicyRequest)]
   (clojure.core/when-let
    [v3483 (:auto-scaling-group-name m3482)]
    (. bean3481 setAutoScalingGroupName (clojure.core/str v3483)))
   (clojure.core/when-let
    [v3483 (:policy-name m3482)]
    (. bean3481 setPolicyName (clojure.core/str v3483)))
   (clojure.core/when-let
    [v3483 (:honor-cooldown m3482)]
    (. bean3481 setHonorCooldown (clojure.core/boolean v3483)))
   bean3481))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest}
create-launch-configuration-request
  [m3485]
  (clojure.core/let
   [bean3484
    (new
     com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest)]
   (clojure.core/when-let
    [v3486 (:iam-instance-profile m3485)]
    (. bean3484 setIamInstanceProfile (clojure.core/str v3486)))
   (clojure.core/when-let
    [v3486 (:spot-price m3485)]
    (. bean3484 setSpotPrice (clojure.core/str v3486)))
   (clojure.core/when-let
    [v3486 (:block-device-mappings m3485)]
    (.
     bean3484
     setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg3555]
  (autoscaling/block-device-mapping arg3555))
 v3486)))
   (clojure.core/when-let
    [v3486 (:key-name m3485)]
    (. bean3484 setKeyName (clojure.core/str v3486)))
   (clojure.core/when-let
    [v3486 (:associate-public-ip-address m3485)]
    (.
     bean3484
     setAssociatePublicIpAddress
     (clojure.core/boolean v3486)))
   (clojure.core/when-let
    [v3486 (:launch-configuration-name m3485)]
    (. bean3484 setLaunchConfigurationName (clojure.core/str v3486)))
   (clojure.core/when-let
    [v3486 (:instance-type m3485)]
    (. bean3484 setInstanceType (clojure.core/str v3486)))
   (clojure.core/when-let
    [v3486 (:instance-id m3485)]
    (. bean3484 setInstanceId (clojure.core/str v3486)))
   (clojure.core/when-let
    [v3486 (:ebs-optimized m3485)]
    (. bean3484 setEbsOptimized (clojure.core/boolean v3486)))
   (clojure.core/when-let
    [v3486 (:image-id m3485)]
    (. bean3484 setImageId (clojure.core/str v3486)))
   (clojure.core/when-let
    [v3486 (:ramdisk-id m3485)]
    (. bean3484 setRamdiskId (clojure.core/str v3486)))
   (clojure.core/when-let
    [v3486 (:security-groups m3485)]
    (.
     bean3484
     setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3556] (clojure.core/str arg3556))
 v3486)))
   (clojure.core/when-let
    [v3486 (:user-data m3485)]
    (. bean3484 setUserData (clojure.core/str v3486)))
   (clojure.core/when-let
    [v3486 (:kernel-id m3485)]
    (. bean3484 setKernelId (clojure.core/str v3486)))
   (clojure.core/when-let
    [v3486 (:placement-tenancy m3485)]
    (. bean3484 setPlacementTenancy (clojure.core/str v3486)))
   (clojure.core/when-let
    [v3486 (:instance-monitoring m3485)]
    (.
     bean3484
     setInstanceMonitoring
     (autoscaling/instance-monitoring v3486)))
   bean3484))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest}
describe-termination-policy-types-request
  [m3488]
  (clojure.core/let
   [bean3487
    (new
     com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest)]
   bean3487))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest}
describe-scaling-activities-request
  [m3491]
  (clojure.core/let
   [bean3490
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest)]
   (clojure.core/when-let
    [v3492 (:max-records m3491)]
    (. bean3490 setMaxRecords (clojure.core/int v3492)))
   (clojure.core/when-let
    [v3492 (:auto-scaling-group-name m3491)]
    (. bean3490 setAutoScalingGroupName (clojure.core/str v3492)))
   (clojure.core/when-let
    [v3492 (:activity-ids m3491)]
    (.
     bean3490
     setActivityIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3557] (clojure.core/str arg3557))
 v3492)))
   (clojure.core/when-let
    [v3492 (:next-token m3491)]
    (. bean3490 setNextToken (clojure.core/str v3492)))
   bean3490))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest}
describe-scheduled-actions-request
  [m3494]
  (clojure.core/let
   [bean3493
    (new
     com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest)]
   (clojure.core/when-let
    [v3495 (:max-records m3494)]
    (. bean3493 setMaxRecords (clojure.core/int v3495)))
   (clojure.core/when-let
    [v3495 (:start-time m3494)]
    (.
     bean3493
     setStartTime
     (com.palletops.awaze.common/to-date v3495)))
   (clojure.core/when-let
    [v3495 (:end-time m3494)]
    (. bean3493 setEndTime (com.palletops.awaze.common/to-date v3495)))
   (clojure.core/when-let
    [v3495 (:auto-scaling-group-name m3494)]
    (. bean3493 setAutoScalingGroupName (clojure.core/str v3495)))
   (clojure.core/when-let
    [v3495 (:scheduled-action-names m3494)]
    (.
     bean3493
     setScheduledActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3558] (clojure.core/str arg3558))
 v3495)))
   (clojure.core/when-let
    [v3495 (:next-token m3494)]
    (. bean3493 setNextToken (clojure.core/str v3495)))
   bean3493))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest}
describe-adjustment-types-request
  [m3497]
  (clojure.core/let
   [bean3496
    (new
     com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest)]
   bean3496))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeTagsRequest}
describe-tags-request
  [m3500]
  (clojure.core/let
   [bean3499
    (new com.amazonaws.services.autoscaling.model.DescribeTagsRequest)]
   (clojure.core/when-let
    [v3501 (:max-records m3500)]
    (. bean3499 setMaxRecords (clojure.core/int v3501)))
   (clojure.core/when-let
    [v3501 (:filters m3500)]
    (.
     bean3499
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3559] (autoscaling/filter arg3559))
 v3501)))
   (clojure.core/when-let
    [v3501 (:next-token m3500)]
    (. bean3499 setNextToken (clojure.core/str v3501)))
   bean3499))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ResumeProcessesRequest}
resume-processes-request
  [m3503]
  (clojure.core/let
   [bean3502
    (new
     com.amazonaws.services.autoscaling.model.ResumeProcessesRequest)]
   (clojure.core/when-let
    [v3504 (:auto-scaling-group-name m3503)]
    (. bean3502 setAutoScalingGroupName (clojure.core/str v3504)))
   (clojure.core/when-let
    [v3504 (:scaling-processes m3503)]
    (.
     bean3502
     setScalingProcesses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3560] (clojure.core/str arg3560))
 v3504)))
   bean3502))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest}
delete-launch-configuration-request
  [m3506]
  (clojure.core/let
   [bean3505
    (new
     com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest)]
   (clojure.core/when-let
    [v3507 (:launch-configuration-name m3506)]
    (. bean3505 setLaunchConfigurationName (clojure.core/str v3507)))
   bean3505))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest}
disable-metrics-collection-request
  [m3509]
  (clojure.core/let
   [bean3508
    (new
     com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest)]
   (clojure.core/when-let
    [v3510 (:auto-scaling-group-name m3509)]
    (. bean3508 setAutoScalingGroupName (clojure.core/str v3510)))
   (clojure.core/when-let
    [v3510 (:metrics m3509)]
    (.
     bean3508
     setMetrics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3561] (clojure.core/str arg3561))
 v3510)))
   bean3508))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest}
put-scheduled-update-group-action-request
  [m3512]
  (clojure.core/let
   [bean3511
    (new
     com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest)]
   (clojure.core/when-let
    [v3513 (:max-size m3512)]
    (. bean3511 setMaxSize (clojure.core/int v3513)))
   (clojure.core/when-let
    [v3513 (:end-time m3512)]
    (. bean3511 setEndTime (com.palletops.awaze.common/to-date v3513)))
   (clojure.core/when-let
    [v3513 (:scheduled-action-name m3512)]
    (. bean3511 setScheduledActionName (clojure.core/str v3513)))
   (clojure.core/when-let
    [v3513 (:start-time m3512)]
    (.
     bean3511
     setStartTime
     (com.palletops.awaze.common/to-date v3513)))
   (clojure.core/when-let
    [v3513 (:time m3512)]
    (. bean3511 setTime (com.palletops.awaze.common/to-date v3513)))
   (clojure.core/when-let
    [v3513 (:min-size m3512)]
    (. bean3511 setMinSize (clojure.core/int v3513)))
   (clojure.core/when-let
    [v3513 (:desired-capacity m3512)]
    (. bean3511 setDesiredCapacity (clojure.core/int v3513)))
   (clojure.core/when-let
    [v3513 (:recurrence m3512)]
    (. bean3511 setRecurrence (clojure.core/str v3513)))
   (clojure.core/when-let
    [v3513 (:auto-scaling-group-name m3512)]
    (. bean3511 setAutoScalingGroupName (clojure.core/str v3513)))
   bean3511))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest}
describe-scaling-process-types-request
  [m3515]
  (clojure.core/let
   [bean3514
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest)]
   bean3514))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest}
describe-metric-collection-types-request
  [m3518]
  (clojure.core/let
   [bean3517
    (new
     com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest)]
   bean3517))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest}
delete-scheduled-action-request
  [m3521]
  (clojure.core/let
   [bean3520
    (new
     com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest)]
   (clojure.core/when-let
    [v3522 (:auto-scaling-group-name m3521)]
    (. bean3520 setAutoScalingGroupName (clojure.core/str v3522)))
   (clojure.core/when-let
    [v3522 (:scheduled-action-name m3521)]
    (. bean3520 setScheduledActionName (clojure.core/str v3522)))
   bean3520))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest}
update-auto-scaling-group-request
  [m3524]
  (clojure.core/let
   [bean3523
    (new
     com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v3525 (:max-size m3524)]
    (. bean3523 setMaxSize (clojure.core/int v3525)))
   (clojure.core/when-let
    [v3525 (:health-check-type m3524)]
    (. bean3523 setHealthCheckType (clojure.core/str v3525)))
   (clojure.core/when-let
    [v3525 (:default-cooldown m3524)]
    (. bean3523 setDefaultCooldown (clojure.core/int v3525)))
   (clojure.core/when-let
    [v3525 (:availability-zones m3524)]
    (.
     bean3523
     setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3562] (clojure.core/str arg3562))
 v3525)))
   (clojure.core/when-let
    [v3525 (:launch-configuration-name m3524)]
    (. bean3523 setLaunchConfigurationName (clojure.core/str v3525)))
   (clojure.core/when-let
    [v3525 (:health-check-grace-period m3524)]
    (. bean3523 setHealthCheckGracePeriod (clojure.core/int v3525)))
   (clojure.core/when-let
    [v3525 (:min-size m3524)]
    (. bean3523 setMinSize (clojure.core/int v3525)))
   (clojure.core/when-let
    [v3525 (:desired-capacity m3524)]
    (. bean3523 setDesiredCapacity (clojure.core/int v3525)))
   (clojure.core/when-let
    [v3525 (:termination-policies m3524)]
    (.
     bean3523
     setTerminationPolicies
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3563] (clojure.core/str arg3563))
 v3525)))
   (clojure.core/when-let
    [v3525 (:auto-scaling-group-name m3524)]
    (. bean3523 setAutoScalingGroupName (clojure.core/str v3525)))
   (clojure.core/when-let
    [v3525 (:vpczone-identifier m3524)]
    (. bean3523 setVPCZoneIdentifier (clojure.core/str v3525)))
   (clojure.core/when-let
    [v3525 (:placement-group m3524)]
    (. bean3523 setPlacementGroup (clojure.core/str v3525)))
   bean3523))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.AttachInstancesRequest}
attach-instances-request
  [m3527]
  (clojure.core/let
   [bean3526
    (new
     com.amazonaws.services.autoscaling.model.AttachInstancesRequest)]
   (clojure.core/when-let
    [v3528 (:auto-scaling-group-name m3527)]
    (. bean3526 setAutoScalingGroupName (clojure.core/str v3528)))
   (clojure.core/when-let
    [v3528 (:instance-ids m3527)]
    (.
     bean3526
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3564] (clojure.core/str arg3564))
 v3528)))
   bean3526))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest}
delete-notification-configuration-request
  [m3530]
  (clojure.core/let
   [bean3529
    (new
     com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest)]
   (clojure.core/when-let
    [v3531 (:auto-scaling-group-name m3530)]
    (. bean3529 setAutoScalingGroupName (clojure.core/str v3531)))
   (clojure.core/when-let
    [v3531 (:topic-arn m3530)]
    (. bean3529 setTopicARN (clojure.core/str v3531)))
   bean3529))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest}
terminate-instance-in-auto-scaling-group-request
  [m3533]
  (clojure.core/let
   [bean3532
    (new
     com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v3534 (:instance-id m3533)]
    (. bean3532 setInstanceId (clojure.core/str v3534)))
   (clojure.core/when-let
    [v3534 (:should-decrement-desired-capacity m3533)]
    (.
     bean3532
     setShouldDecrementDesiredCapacity
     (clojure.core/boolean v3534)))
   bean3532))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest}
delete-auto-scaling-group-request
  [m3536]
  (clojure.core/let
   [bean3535
    (new
     com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v3537 (:auto-scaling-group-name m3536)]
    (. bean3535 setAutoScalingGroupName (clojure.core/str v3537)))
   (clojure.core/when-let
    [v3537 (:force-delete m3536)]
    (. bean3535 setForceDelete (clojure.core/boolean v3537)))
   bean3535))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest}
create-or-update-tags-request
  [m3539]
  (clojure.core/let
   [bean3538
    (new
     com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest)]
   (clojure.core/when-let
    [v3540 (:tags m3539)]
    (.
     bean3538
     setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3565] (autoscaling/tag arg3565))
 v3540)))
   bean3538))
 (clojure.core/defmulti
  autoscaling
  (clojure.core/fn
   autoscaling
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-desired-capacity
   [m3566]
   (clojure.core/let
    [credentials3567 (:credentials m3566) args3568 (:args m3566)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3569
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3567)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3569
       setDesiredCapacity
       (autoscaling/set-desired-capacity-request
        (clojure.core/nth args3568 0)))))))
  (clojure.core/defn
   set-desired-capacity-map
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         general-progress-listener
                         desired-capacity
                         auto-scaling-group-name]}]]),
    :doc "Generate map for setDesiredCapacity"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :set-desired-capacity,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-desired-capacity
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         general-progress-listener
                         desired-capacity
                         auto-scaling-group-name]}]]),
    :doc "Call setDesiredCapacity"}
   [credentials3571 & args3572]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3573
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3571)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3573
      setDesiredCapacity
      (autoscaling/set-desired-capacity-request
       (clojure.core/nth args3572 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :enable-metrics-collection
   [m3574]
   (clojure.core/let
    [credentials3575 (:credentials m3574) args3576 (:args m3574)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3577
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3575)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3577
       enableMetricsCollection
       (autoscaling/enable-metrics-collection-request
        (clojure.core/nth args3576 0)))))))
  (clojure.core/defn
   enable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [metrics
                         granularity
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for enableMetricsCollection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :enable-metrics-collection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [metrics
                         granularity
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call enableMetricsCollection"}
   [credentials3579 & args3580]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3581
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3579)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3581
      enableMetricsCollection
      (autoscaling/enable-metrics-collection-request
       (clojure.core/nth args3580 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-policy
   [m3582]
   (clojure.core/let
    [credentials3583 (:credentials m3582) args3584 (:args m3582)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3585
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3583)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3585
       deletePolicy
       (autoscaling/delete-policy-request
        (clojure.core/nth args3584 0)))))))
  (clojure.core/defn
   delete-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deletePolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call deletePolicy"}
   [credentials3587 & args3588]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3589
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3587)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3589
      deletePolicy
      (autoscaling/delete-policy-request
       (clojure.core/nth args3588 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-instance-health
   [m3590]
   (clojure.core/let
    [credentials3591 (:credentials m3590) args3592 (:args m3590)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3593
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3591)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3593
       setInstanceHealth
       (autoscaling/set-instance-health-request
        (clojure.core/nth args3592 0)))))))
  (clojure.core/defn
   set-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [should-respect-grace-period
                         instance-id
                         health-status
                         general-progress-listener]}]]),
    :doc "Generate map for setInstanceHealth"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :set-instance-health,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [should-respect-grace-period
                         instance-id
                         health-status
                         general-progress-listener]}]]),
    :doc "Call setInstanceHealth"}
   [credentials3595 & args3596]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3597
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3595)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3597
      setInstanceHealth
      (autoscaling/set-instance-health-request
       (clojure.core/nth args3596 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-launch-configurations
   [m3598]
   (clojure.core/let
    [credentials3599 (:credentials m3598) args3600 (:args m3598)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3601
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3599)]
     (clojure.core/case
      (clojure.core/count args3600)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3601
        describeLaunchConfigurations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3601
        describeLaunchConfigurations
        (autoscaling/describe-launch-configurations-request
         (clojure.core/nth args3600 0))))))))
  (clojure.core/defn
   describe-launch-configurations-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         launch-configuration-names
                         general-progress-listener]}]]),
    :doc "Generate map for describeLaunchConfigurations, describeLaunchConfigurations"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-launch-configurations,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-launch-configurations,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-launch-configurations
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         launch-configuration-names
                         general-progress-listener]}]]),
    :doc "Call describeLaunchConfigurations, describeLaunchConfigurations"}
   [credentials3603 & args3604]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3605
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3603)]
    (clojure.core/case
     (clojure.core/count args3604)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3605
       describeLaunchConfigurations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3605
       describeLaunchConfigurations
       (autoscaling/describe-launch-configurations-request
        (clojure.core/nth args3604 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-tags
   [m3606]
   (clojure.core/let
    [credentials3607 (:credentials m3606) args3608 (:args m3606)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3609
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3607)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3609
       deleteTags
       (autoscaling/delete-tags-request (clojure.core/nth args3608 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials {:keys [tags general-progress-listener]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials {:keys [tags general-progress-listener]}]]),
    :doc "Call deleteTags"}
   [credentials3611 & args3612]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3613
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3611)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3613
      deleteTags
      (autoscaling/delete-tags-request (clojure.core/nth args3612 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-instances
   [m3614]
   (clojure.core/let
    [credentials3615 (:credentials m3614) args3616 (:args m3614)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3617
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3615)]
     (clojure.core/case
      (clojure.core/count args3616)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3617
        describeAutoScalingInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3617
        describeAutoScalingInstances
        (autoscaling/describe-auto-scaling-instances-request
         (clojure.core/nth args3616 0))))))))
  (clojure.core/defn
   describe-auto-scaling-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         instance-ids
                         general-progress-listener]}]]),
    :doc "Generate map for describeAutoScalingInstances, describeAutoScalingInstances"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-auto-scaling-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         instance-ids
                         general-progress-listener]}]]),
    :doc "Call describeAutoScalingInstances, describeAutoScalingInstances"}
   [credentials3619 & args3620]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3621
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3619)]
    (clojure.core/case
     (clojure.core/count args3620)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3621
       describeAutoScalingInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3621
       describeAutoScalingInstances
       (autoscaling/describe-auto-scaling-instances-request
        (clojure.core/nth args3620 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-account-limits
   [m3622]
   (clojure.core/let
    [credentials3623 (:credentials m3622) args3624 (:args m3622)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3625
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3623)]
     (clojure.core/case
      (clojure.core/count args3624)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3625
        describeAccountLimits))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3625
        describeAccountLimits
        (autoscaling/describe-account-limits-request
         (clojure.core/nth args3624 0))))))))
  (clojure.core/defn
   describe-account-limits-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeAccountLimits, describeAccountLimits"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-account-limits,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-account-limits,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-account-limits
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeAccountLimits, describeAccountLimits"}
   [credentials3627 & args3628]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3629
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3627)]
    (clojure.core/case
     (clojure.core/count args3628)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3629
       describeAccountLimits))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3629
       describeAccountLimits
       (autoscaling/describe-account-limits-request
        (clojure.core/nth args3628 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-notification-configurations
   [m3630]
   (clojure.core/let
    [credentials3631 (:credentials m3630) args3632 (:args m3630)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3633
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3631)]
     (clojure.core/case
      (clojure.core/count args3632)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3633
        describeNotificationConfigurations
        (autoscaling/describe-notification-configurations-request
         (clojure.core/nth args3632 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3633
        describeNotificationConfigurations))))))
  (clojure.core/defn
   describe-notification-configurations-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-names]}]
                [credentials]]),
    :doc "Generate map for describeNotificationConfigurations, describeNotificationConfigurations"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-notification-configurations,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-notification-configurations,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-notification-configurations
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-names]}]
                [credentials]]),
    :doc "Call describeNotificationConfigurations, describeNotificationConfigurations"}
   [credentials3635 & args3636]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3637
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3635)]
    (clojure.core/case
     (clojure.core/count args3636)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3637
       describeNotificationConfigurations
       (autoscaling/describe-notification-configurations-request
        (clojure.core/nth args3636 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3637
       describeNotificationConfigurations))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-notification-types
   [m3638]
   (clojure.core/let
    [credentials3639 (:credentials m3638) args3640 (:args m3638)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3641
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3639)]
     (clojure.core/case
      (clojure.core/count args3640)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3641
        describeAutoScalingNotificationTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3641
        describeAutoScalingNotificationTypes
        (autoscaling/describe-auto-scaling-notification-types-request
         (clojure.core/nth args3640 0))))))))
  (clojure.core/defn
   describe-auto-scaling-notification-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-auto-scaling-notification-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   [credentials3643 & args3644]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3645
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3643)]
    (clojure.core/case
     (clojure.core/count args3644)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3645
       describeAutoScalingNotificationTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3645
       describeAutoScalingNotificationTypes
       (autoscaling/describe-auto-scaling-notification-types-request
        (clojure.core/nth args3644 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-notification-configuration
   [m3646]
   (clojure.core/let
    [credentials3647 (:credentials m3646) args3648 (:args m3646)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3649
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3647)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3649
       putNotificationConfiguration
       (autoscaling/put-notification-configuration-request
        (clojure.core/nth args3648 0)))))))
  (clojure.core/defn
   put-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         notification-types
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putNotificationConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :put-notification-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         notification-types
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call putNotificationConfiguration"}
   [credentials3651 & args3652]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3653
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3651)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3653
      putNotificationConfiguration
      (autoscaling/put-notification-configuration-request
       (clojure.core/nth args3652 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-policies
   [m3654]
   (clojure.core/let
    [credentials3655 (:credentials m3654) args3656 (:args m3654)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3657
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3655)]
     (clojure.core/case
      (clojure.core/count args3656)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3657
        describePolicies
        (autoscaling/describe-policies-request
         (clojure.core/nth args3656 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3657
        describePolicies))))))
  (clojure.core/defn
   describe-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Generate map for describePolicies, describePolicies"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-policies,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-policies,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-policies
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Call describePolicies, describePolicies"}
   [credentials3659 & args3660]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3661
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3659)]
    (clojure.core/case
     (clojure.core/count args3660)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3661
       describePolicies
       (autoscaling/describe-policies-request
        (clojure.core/nth args3660 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3661
       describePolicies))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :suspend-processes
   [m3662]
   (clojure.core/let
    [credentials3663 (:credentials m3662) args3664 (:args m3662)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3665
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3663)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3665
       suspendProcesses
       (autoscaling/suspend-processes-request
        (clojure.core/nth args3664 0)))))))
  (clojure.core/defn
   suspend-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for suspendProcesses"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :suspend-processes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   suspend-processes
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call suspendProcesses"}
   [credentials3667 & args3668]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3669
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3667)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3669
      suspendProcesses
      (autoscaling/suspend-processes-request
       (clojure.core/nth args3668 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-auto-scaling-group
   [m3670]
   (clojure.core/let
    [credentials3671 (:credentials m3670) args3672 (:args m3670)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3673
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3671)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3673
       createAutoScalingGroup
       (autoscaling/create-auto-scaling-group-request
        (clojure.core/nth args3672 0)))))))
  (clojure.core/defn
   create-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-names
                         health-check-grace-period
                         placement-group
                         general-progress-listener
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         instance-id
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name
                         tags]}]]),
    :doc "Generate map for createAutoScalingGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :create-auto-scaling-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-names
                         health-check-grace-period
                         placement-group
                         general-progress-listener
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         instance-id
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name
                         tags]}]]),
    :doc "Call createAutoScalingGroup"}
   [credentials3675 & args3676]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3677
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3675)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3677
      createAutoScalingGroup
      (autoscaling/create-auto-scaling-group-request
       (clojure.core/nth args3676 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-groups
   [m3678]
   (clojure.core/let
    [credentials3679 (:credentials m3678) args3680 (:args m3678)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3681
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3679)]
     (clojure.core/case
      (clojure.core/count args3680)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3681
        describeAutoScalingGroups
        (autoscaling/describe-auto-scaling-groups-request
         (clojure.core/nth args3680 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3681
        describeAutoScalingGroups))))))
  (clojure.core/defn
   describe-auto-scaling-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-names]}]
                [credentials]]),
    :doc "Generate map for describeAutoScalingGroups, describeAutoScalingGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-auto-scaling-groups
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-names]}]
                [credentials]]),
    :doc "Call describeAutoScalingGroups, describeAutoScalingGroups"}
   [credentials3683 & args3684]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3685
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3683)]
    (clojure.core/case
     (clojure.core/count args3684)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3685
       describeAutoScalingGroups
       (autoscaling/describe-auto-scaling-groups-request
        (clojure.core/nth args3684 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3685
       describeAutoScalingGroups))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scaling-policy
   [m3686]
   (clojure.core/let
    [credentials3687 (:credentials m3686) args3688 (:args m3686)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3689
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3687)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3689
       putScalingPolicy
       (autoscaling/put-scaling-policy-request
        (clojure.core/nth args3688 0)))))))
  (clojure.core/defn
   put-scaling-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         policy-name
                         min-adjustment-step
                         cooldown
                         auto-scaling-group-name
                         adjustment-type
                         scaling-adjustment]}]]),
    :doc "Generate map for putScalingPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :put-scaling-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-scaling-policy
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         policy-name
                         min-adjustment-step
                         cooldown
                         auto-scaling-group-name
                         adjustment-type
                         scaling-adjustment]}]]),
    :doc "Call putScalingPolicy"}
   [credentials3691 & args3692]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3693
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3691)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3693
      putScalingPolicy
      (autoscaling/put-scaling-policy-request
       (clojure.core/nth args3692 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :execute-policy
   [m3694]
   (clojure.core/let
    [credentials3695 (:credentials m3694) args3696 (:args m3694)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3697
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3695)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3697
       executePolicy
       (autoscaling/execute-policy-request
        (clojure.core/nth args3696 0)))))))
  (clojure.core/defn
   execute-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         honor-cooldown
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for executePolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :execute-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   execute-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         honor-cooldown
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call executePolicy"}
   [credentials3699 & args3700]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3701
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3699)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3701
      executePolicy
      (autoscaling/execute-policy-request
       (clojure.core/nth args3700 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-launch-configuration
   [m3702]
   (clojure.core/let
    [credentials3703 (:credentials m3702) args3704 (:args m3702)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3705
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3703)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3705
       createLaunchConfiguration
       (autoscaling/create-launch-configuration-request
        (clojure.core/nth args3704 0)))))))
  (clojure.core/defn
   create-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [placement-tenancy
                         instance-type
                         kernel-id
                         associate-public-ip-address
                         general-progress-listener
                         launch-configuration-name
                         ebs-optimized
                         block-device-mappings
                         spot-price
                         user-data
                         security-groups
                         ramdisk-id
                         instance-monitoring
                         iam-instance-profile
                         instance-id
                         key-name
                         image-id]}]]),
    :doc "Generate map for createLaunchConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :create-launch-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [placement-tenancy
                         instance-type
                         kernel-id
                         associate-public-ip-address
                         general-progress-listener
                         launch-configuration-name
                         ebs-optimized
                         block-device-mappings
                         spot-price
                         user-data
                         security-groups
                         ramdisk-id
                         instance-monitoring
                         iam-instance-profile
                         instance-id
                         key-name
                         image-id]}]]),
    :doc "Call createLaunchConfiguration"}
   [credentials3707 & args3708]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3709
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3707)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3709
      createLaunchConfiguration
      (autoscaling/create-launch-configuration-request
       (clojure.core/nth args3708 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-termination-policy-types
   [m3710]
   (clojure.core/let
    [credentials3711 (:credentials m3710) args3712 (:args m3710)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3713
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3711)]
     (clojure.core/case
      (clojure.core/count args3712)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3713
        describeTerminationPolicyTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3713
        describeTerminationPolicyTypes
        (autoscaling/describe-termination-policy-types-request
         (clojure.core/nth args3712 0))))))))
  (clojure.core/defn
   describe-termination-policy-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-termination-policy-types,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-termination-policy-types,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-termination-policy-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   [credentials3715 & args3716]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3717
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3715)]
    (clojure.core/case
     (clojure.core/count args3716)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3717
       describeTerminationPolicyTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3717
       describeTerminationPolicyTypes
       (autoscaling/describe-termination-policy-types-request
        (clojure.core/nth args3716 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-activities
   [m3718]
   (clojure.core/let
    [credentials3719 (:credentials m3718) args3720 (:args m3718)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3721
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3719)]
     (clojure.core/case
      (clojure.core/count args3720)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3721
        describeScalingActivities))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3721
        describeScalingActivities
        (autoscaling/describe-scaling-activities-request
         (clojure.core/nth args3720 0))))))))
  (clojure.core/defn
   describe-scaling-activities-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-name
                         activity-ids]}]]),
    :doc "Generate map for describeScalingActivities, describeScalingActivities"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-scaling-activities,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-scaling-activities,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-scaling-activities
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-name
                         activity-ids]}]]),
    :doc "Call describeScalingActivities, describeScalingActivities"}
   [credentials3723 & args3724]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3725
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3723)]
    (clojure.core/case
     (clojure.core/count args3724)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3725
       describeScalingActivities))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3725
       describeScalingActivities
       (autoscaling/describe-scaling-activities-request
        (clojure.core/nth args3724 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scheduled-actions
   [m3726]
   (clojure.core/let
    [credentials3727 (:credentials m3726) args3728 (:args m3726)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3729
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3727)]
     (clojure.core/case
      (clojure.core/count args3728)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3729
        describeScheduledActions
        (autoscaling/describe-scheduled-actions-request
         (clojure.core/nth args3728 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3729
        describeScheduledActions))))))
  (clojure.core/defn
   describe-scheduled-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         scheduled-action-names
                         max-records
                         start-time
                         next-token
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Generate map for describeScheduledActions, describeScheduledActions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-scheduled-actions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-scheduled-actions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-scheduled-actions
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         scheduled-action-names
                         max-records
                         start-time
                         next-token
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Call describeScheduledActions, describeScheduledActions"}
   [credentials3731 & args3732]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3733
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3731)]
    (clojure.core/case
     (clojure.core/count args3732)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3733
       describeScheduledActions
       (autoscaling/describe-scheduled-actions-request
        (clojure.core/nth args3732 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3733
       describeScheduledActions))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-adjustment-types
   [m3734]
   (clojure.core/let
    [credentials3735 (:credentials m3734) args3736 (:args m3734)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3737
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3735)]
     (clojure.core/case
      (clojure.core/count args3736)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3737
        describeAdjustmentTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3737
        describeAdjustmentTypes
        (autoscaling/describe-adjustment-types-request
         (clojure.core/nth args3736 0))))))))
  (clojure.core/defn
   describe-adjustment-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeAdjustmentTypes, describeAdjustmentTypes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-adjustment-types,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-adjustment-types,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-adjustment-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeAdjustmentTypes, describeAdjustmentTypes"}
   [credentials3739 & args3740]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3741
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3739)]
    (clojure.core/case
     (clojure.core/count args3740)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3741
       describeAdjustmentTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3741
       describeAdjustmentTypes
       (autoscaling/describe-adjustment-types-request
        (clojure.core/nth args3740 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-tags
   [m3742]
   (clojure.core/let
    [credentials3743 (:credentials m3742) args3744 (:args m3742)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3745
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3743)]
     (clojure.core/case
      (clojure.core/count args3744)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3745
        describeTags
        (autoscaling/describe-tags-request
         (clojure.core/nth args3744 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3745
        describeTags))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-tags,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeTags, describeTags"}
   [credentials3747 & args3748]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3749
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3747)]
    (clojure.core/case
     (clojure.core/count args3748)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3749
       describeTags
       (autoscaling/describe-tags-request
        (clojure.core/nth args3748 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3749
       describeTags))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :resume-processes
   [m3750]
   (clojure.core/let
    [credentials3751 (:credentials m3750) args3752 (:args m3750)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3753
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3751)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3753
       resumeProcesses
       (autoscaling/resume-processes-request
        (clojure.core/nth args3752 0)))))))
  (clojure.core/defn
   resume-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for resumeProcesses"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :resume-processes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   resume-processes
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call resumeProcesses"}
   [credentials3755 & args3756]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3757
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3755)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3757
      resumeProcesses
      (autoscaling/resume-processes-request
       (clojure.core/nth args3756 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-launch-configuration
   [m3758]
   (clojure.core/let
    [credentials3759 (:credentials m3758) args3760 (:args m3758)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3761
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3759)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3761
       deleteLaunchConfiguration
       (autoscaling/delete-launch-configuration-request
        (clojure.core/nth args3760 0)))))))
  (clojure.core/defn
   delete-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [launch-configuration-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteLaunchConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-launch-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [launch-configuration-name
                         general-progress-listener]}]]),
    :doc "Call deleteLaunchConfiguration"}
   [credentials3763 & args3764]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3765
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3763)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3765
      deleteLaunchConfiguration
      (autoscaling/delete-launch-configuration-request
       (clojure.core/nth args3764 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :disable-metrics-collection
   [m3766]
   (clojure.core/let
    [credentials3767 (:credentials m3766) args3768 (:args m3766)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3769
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3767)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3769
       disableMetricsCollection
       (autoscaling/disable-metrics-collection-request
        (clojure.core/nth args3768 0)))))))
  (clojure.core/defn
   disable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [metrics
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for disableMetricsCollection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :disable-metrics-collection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [metrics
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call disableMetricsCollection"}
   [credentials3771 & args3772]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3773
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3771)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3773
      disableMetricsCollection
      (autoscaling/disable-metrics-collection-request
       (clojure.core/nth args3772 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scheduled-update-group-action
   [m3774]
   (clojure.core/let
    [credentials3775 (:credentials m3774) args3776 (:args m3774)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3777
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3775)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3777
       putScheduledUpdateGroupAction
       (autoscaling/put-scheduled-update-group-action-request
        (clojure.core/nth args3776 0)))))))
  (clojure.core/defn
   put-scheduled-update-group-action-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         desired-capacity
                         recurrence
                         start-time
                         min-size
                         time
                         max-size
                         scheduled-action-name
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putScheduledUpdateGroupAction"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :put-scheduled-update-group-action,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-scheduled-update-group-action
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         desired-capacity
                         recurrence
                         start-time
                         min-size
                         time
                         max-size
                         scheduled-action-name
                         auto-scaling-group-name]}]]),
    :doc "Call putScheduledUpdateGroupAction"}
   [credentials3779 & args3780]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3781
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3779)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3781
      putScheduledUpdateGroupAction
      (autoscaling/put-scheduled-update-group-action-request
       (clojure.core/nth args3780 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-process-types
   [m3782]
   (clojure.core/let
    [credentials3783 (:credentials m3782) args3784 (:args m3782)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3785
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3783)]
     (clojure.core/case
      (clojure.core/count args3784)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3785
        describeScalingProcessTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3785
        describeScalingProcessTypes
        (autoscaling/describe-scaling-process-types-request
         (clojure.core/nth args3784 0))))))))
  (clojure.core/defn
   describe-scaling-process-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeScalingProcessTypes, describeScalingProcessTypes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-scaling-process-types,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-scaling-process-types,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-scaling-process-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeScalingProcessTypes, describeScalingProcessTypes"}
   [credentials3787 & args3788]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3789
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3787)]
    (clojure.core/case
     (clojure.core/count args3788)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3789
       describeScalingProcessTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3789
       describeScalingProcessTypes
       (autoscaling/describe-scaling-process-types-request
        (clojure.core/nth args3788 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-metric-collection-types
   [m3790]
   (clojure.core/let
    [credentials3791 (:credentials m3790) args3792 (:args m3790)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3793
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3791)]
     (clojure.core/case
      (clojure.core/count args3792)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3793
        describeMetricCollectionTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3793
        describeMetricCollectionTypes
        (autoscaling/describe-metric-collection-types-request
         (clojure.core/nth args3792 0))))))))
  (clojure.core/defn
   describe-metric-collection-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeMetricCollectionTypes, describeMetricCollectionTypes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-metric-collection-types,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-metric-collection-types,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-metric-collection-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeMetricCollectionTypes, describeMetricCollectionTypes"}
   [credentials3795 & args3796]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3797
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3795)]
    (clojure.core/case
     (clojure.core/count args3796)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3797
       describeMetricCollectionTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3797
       describeMetricCollectionTypes
       (autoscaling/describe-metric-collection-types-request
        (clojure.core/nth args3796 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-scheduled-action
   [m3798]
   (clojure.core/let
    [credentials3799 (:credentials m3798) args3800 (:args m3798)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3801
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3799)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3801
       deleteScheduledAction
       (autoscaling/delete-scheduled-action-request
        (clojure.core/nth args3800 0)))))))
  (clojure.core/defn
   delete-scheduled-action-map
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteScheduledAction"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-scheduled-action,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-scheduled-action
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call deleteScheduledAction"}
   [credentials3803 & args3804]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3805
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3803)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3805
      deleteScheduledAction
      (autoscaling/delete-scheduled-action-request
       (clojure.core/nth args3804 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :update-auto-scaling-group
   [m3806]
   (clojure.core/let
    [credentials3807 (:credentials m3806) args3808 (:args m3806)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3809
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3807)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3809
       updateAutoScalingGroup
       (autoscaling/update-auto-scaling-group-request
        (clojure.core/nth args3808 0)))))))
  (clojure.core/defn
   update-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [health-check-grace-period
                         placement-group
                         general-progress-listener
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name]}]]),
    :doc "Generate map for updateAutoScalingGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :update-auto-scaling-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [health-check-grace-period
                         placement-group
                         general-progress-listener
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name]}]]),
    :doc "Call updateAutoScalingGroup"}
   [credentials3811 & args3812]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3813
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3811)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3813
      updateAutoScalingGroup
      (autoscaling/update-auto-scaling-group-request
       (clojure.core/nth args3812 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :attach-instances
   [m3814]
   (clojure.core/let
    [credentials3815 (:credentials m3814) args3816 (:args m3814)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3817
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3815)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3817
       attachInstances
       (autoscaling/attach-instances-request
        (clojure.core/nth args3816 0)))))))
  (clojure.core/defn
   attach-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for attachInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :attach-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   attach-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call attachInstances"}
   [credentials3819 & args3820]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3821
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3819)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3821
      attachInstances
      (autoscaling/attach-instances-request
       (clojure.core/nth args3820 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-notification-configuration
   [m3822]
   (clojure.core/let
    [credentials3823 (:credentials m3822) args3824 (:args m3822)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3825
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3823)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3825
       deleteNotificationConfiguration
       (autoscaling/delete-notification-configuration-request
        (clojure.core/nth args3824 0)))))))
  (clojure.core/defn
   delete-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteNotificationConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-notification-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call deleteNotificationConfiguration"}
   [credentials3827 & args3828]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3829
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3827)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3829
      deleteNotificationConfiguration
      (autoscaling/delete-notification-configuration-request
       (clojure.core/nth args3828 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :terminate-instance-in-auto-scaling-group
   [m3830]
   (clojure.core/let
    [credentials3831 (:credentials m3830) args3832 (:args m3830)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3833
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3831)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3833
       terminateInstanceInAutoScalingGroup
       (autoscaling/terminate-instance-in-auto-scaling-group-request
        (clojure.core/nth args3832 0)))))))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [should-decrement-desired-capacity
                         instance-id
                         general-progress-listener]}]]),
    :doc "Generate map for terminateInstanceInAutoScalingGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :terminate-instance-in-auto-scaling-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [should-decrement-desired-capacity
                         instance-id
                         general-progress-listener]}]]),
    :doc "Call terminateInstanceInAutoScalingGroup"}
   [credentials3835 & args3836]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3837
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3835)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3837
      terminateInstanceInAutoScalingGroup
      (autoscaling/terminate-instance-in-auto-scaling-group-request
       (clojure.core/nth args3836 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-auto-scaling-group
   [m3838]
   (clojure.core/let
    [credentials3839 (:credentials m3838) args3840 (:args m3838)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3841
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3839)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3841
       deleteAutoScalingGroup
       (autoscaling/delete-auto-scaling-group-request
        (clojure.core/nth args3840 0)))))))
  (clojure.core/defn
   delete-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force-delete
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteAutoScalingGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-auto-scaling-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force-delete
                         auto-scaling-group-name]}]]),
    :doc "Call deleteAutoScalingGroup"}
   [credentials3843 & args3844]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3845
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3843)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3845
      deleteAutoScalingGroup
      (autoscaling/delete-auto-scaling-group-request
       (clojure.core/nth args3844 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-or-update-tags
   [m3846]
   (clojure.core/let
    [credentials3847 (:credentials m3846) args3848 (:args m3846)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3849
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3847)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3849
       createOrUpdateTags
       (autoscaling/create-or-update-tags-request
        (clojure.core/nth args3848 0)))))))
  (clojure.core/defn
   create-or-update-tags-map
   {:arglists (quote
               [[credentials {:keys [tags general-progress-listener]}]]),
    :doc "Generate map for createOrUpdateTags"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :create-or-update-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-or-update-tags
   {:arglists (quote
               [[credentials {:keys [tags general-progress-listener]}]]),
    :doc "Call createOrUpdateTags"}
   [credentials3851 & args3852]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3853
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3851)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3853
      createOrUpdateTags
      (autoscaling/create-or-update-tags-request
       (clojure.core/nth args3852 0))))))))
