(ns com.palletops.awaze.sts (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sts
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.AssumeRoleRequest assume-role-request
  [m3161]
  (clojure.core/let
   [bean3160
    (new com.amazonaws.services.securitytoken.model.AssumeRoleRequest)]
   (clojure.core/when-let
    [v3162 (:duration-seconds m3161)]
    (. bean3160 setDurationSeconds (clojure.core/int v3162)))
   (clojure.core/when-let
    [v3162 (:role-arn m3161)]
    (. bean3160 setRoleArn (clojure.core/str v3162)))
   (clojure.core/when-let
    [v3162 (:role-session-name m3161)]
    (. bean3160 setRoleSessionName (clojure.core/str v3162)))
   (clojure.core/when-let
    [v3162 (:external-id m3161)]
    (. bean3160 setExternalId (clojure.core/str v3162)))
   (clojure.core/when-let
    [v3162 (:policy m3161)]
    (. bean3160 setPolicy (clojure.core/str v3162)))
   bean3160))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.GetFederationTokenRequest get-federation-token-request
  [m3164]
  (clojure.core/let
   [bean3163
    (new
     com.amazonaws.services.securitytoken.model.GetFederationTokenRequest)]
   (clojure.core/when-let
    [v3165 (:name m3164)]
    (. bean3163 setName (clojure.core/str v3165)))
   (clojure.core/when-let
    [v3165 (:duration-seconds m3164)]
    (. bean3163 setDurationSeconds (clojure.core/int v3165)))
   (clojure.core/when-let
    [v3165 (:policy m3164)]
    (. bean3163 setPolicy (clojure.core/str v3165)))
   bean3163))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest assume-role-with-web-identity-request
  [m3167]
  (clojure.core/let
   [bean3166
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest)]
   (clojure.core/when-let
    [v3168 (:duration-seconds m3167)]
    (. bean3166 setDurationSeconds (clojure.core/int v3168)))
   (clojure.core/when-let
    [v3168 (:role-arn m3167)]
    (. bean3166 setRoleArn (clojure.core/str v3168)))
   (clojure.core/when-let
    [v3168 (:role-session-name m3167)]
    (. bean3166 setRoleSessionName (clojure.core/str v3168)))
   (clojure.core/when-let
    [v3168 (:web-identity-token m3167)]
    (. bean3166 setWebIdentityToken (clojure.core/str v3168)))
   (clojure.core/when-let
    [v3168 (:provider-id m3167)]
    (. bean3166 setProviderId (clojure.core/str v3168)))
   (clojure.core/when-let
    [v3168 (:policy m3167)]
    (. bean3166 setPolicy (clojure.core/str v3168)))
   bean3166))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest decode-authorization-message-request
  [m3170]
  (clojure.core/let
   [bean3169
    (new
     com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest)]
   (clojure.core/when-let
    [v3171 (:encoded-message m3170)]
    (. bean3169 setEncodedMessage (clojure.core/str v3171)))
   bean3169))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.GetSessionTokenRequest get-session-token-request
  [m3173]
  (clojure.core/let
   [bean3172
    (new
     com.amazonaws.services.securitytoken.model.GetSessionTokenRequest)]
   (clojure.core/when-let
    [v3174 (:duration-seconds m3173)]
    (. bean3172 setDurationSeconds (clojure.core/int v3174)))
   (clojure.core/when-let
    [v3174 (:serial-number m3173)]
    (. bean3172 setSerialNumber (clojure.core/str v3174)))
   (clojure.core/when-let
    [v3174 (:token-code m3173)]
    (. bean3172 setTokenCode (clojure.core/str v3174)))
   bean3172))
 (clojure.core/defmulti
  sts
  (clojure.core/fn sts [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   sts
   :assume-role
   [m3175]
   (clojure.core/let
    [credentials3176 (:credentials m3175) args3177 (:args m3175)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3178
      (com.palletops.awaze.common/aws-client :sts credentials3176)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3178
       assumeRole
       (assume-role-request (clojure.core/nth args3177 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists
    '[[credentials
       {:keys
        [role-session-name
         role-arn
         request-metric-collector
         policy
         external-id
         duration-seconds]}]],
    :doc "Generate map for assumeRole"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sts,
     :fn :assume-role,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   assume-role
   {:arglists
    '[[credentials
       {:keys
        [role-session-name
         role-arn
         request-metric-collector
         policy
         external-id
         duration-seconds]}]],
    :doc "Call assumeRole"}
   [credentials3180 & args3181]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3182
     (com.palletops.awaze.common/aws-client :sts credentials3180)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3182
      assumeRole
      (assume-role-request (clojure.core/nth args3181 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-federation-token
   [m3183]
   (clojure.core/let
    [credentials3184 (:credentials m3183) args3185 (:args m3183)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3186
      (com.palletops.awaze.common/aws-client :sts credentials3184)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3186
       getFederationToken
       (get-federation-token-request
        (clojure.core/nth args3185 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector policy name duration-seconds]}]],
    :doc "Generate map for getFederationToken"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sts,
     :fn :get-federation-token,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-federation-token
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector policy name duration-seconds]}]],
    :doc "Call getFederationToken"}
   [credentials3188 & args3189]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3190
     (com.palletops.awaze.common/aws-client :sts credentials3188)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3190
      getFederationToken
      (get-federation-token-request (clojure.core/nth args3189 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :assume-role-with-web-identity
   [m3191]
   (clojure.core/let
    [credentials3192 (:credentials m3191) args3193 (:args m3191)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3194
      (com.palletops.awaze.common/aws-client :sts credentials3192)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3194
       assumeRoleWithWebIdentity
       (assume-role-with-web-identity-request
        (clojure.core/nth args3193 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists
    '[[credentials
       {:keys
        [duration-seconds
         role-arn
         role-session-name
         provider-id
         policy
         web-identity-token
         request-metric-collector]}]],
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sts,
     :fn :assume-role-with-web-identity,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists
    '[[credentials
       {:keys
        [duration-seconds
         role-arn
         role-session-name
         provider-id
         policy
         web-identity-token
         request-metric-collector]}]],
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials3196 & args3197]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3198
     (com.palletops.awaze.common/aws-client :sts credentials3196)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3198
      assumeRoleWithWebIdentity
      (assume-role-with-web-identity-request
       (clojure.core/nth args3197 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :decode-authorization-message
   [m3199]
   (clojure.core/let
    [credentials3200 (:credentials m3199) args3201 (:args m3199)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3202
      (com.palletops.awaze.common/aws-client :sts credentials3200)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3202
       decodeAuthorizationMessage
       (decode-authorization-message-request
        (clojure.core/nth args3201 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector encoded-message]}]],
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sts,
     :fn :decode-authorization-message,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists
    '[[credentials
       {:keys [request-metric-collector encoded-message]}]],
    :doc "Call decodeAuthorizationMessage"}
   [credentials3204 & args3205]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3206
     (com.palletops.awaze.common/aws-client :sts credentials3204)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3206
      decodeAuthorizationMessage
      (decode-authorization-message-request
       (clojure.core/nth args3205 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-session-token
   [m3207]
   (clojure.core/let
    [credentials3208 (:credentials m3207) args3209 (:args m3207)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3210
      (com.palletops.awaze.common/aws-client :sts credentials3208)]
     (clojure.core/case
      (clojure.core/count args3209)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3210
        getSessionToken))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3210
        getSessionToken
        (get-session-token-request (clojure.core/nth args3209 0))))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [token-code
         serial-number
         request-metric-collector
         duration-seconds]}]],
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__577__auto__]
    {:args [],
     :client :sts,
     :fn :get-session-token,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sts,
     :fn :get-session-token,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-session-token
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [token-code
         serial-number
         request-metric-collector
         duration-seconds]}]],
    :doc "Call getSessionToken, getSessionToken"}
   [credentials3212 & args3213]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3214
     (com.palletops.awaze.common/aws-client :sts credentials3212)]
    (clojure.core/case
     (clojure.core/count args3213)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3214
       getSessionToken))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client3214
       getSessionToken
       (get-session-token-request (clojure.core/nth args3213 0)))))))))
