(ns com.palletops.awaze.storagegateway (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :storagegateway
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.storagegateway.AWSStorageGatewayClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.BandwidthType bandwidth-type
  [m3825]
  (java.lang.Enum/valueOf
   com.amazonaws.services.storagegateway.model.BandwidthType
   (clojure.core/name m3825)))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.GatewayTimezone gateway-timezone
  [m3828]
  (java.lang.Enum/valueOf
   com.amazonaws.services.storagegateway.model.GatewayTimezone
   (clojure.core/name m3828)))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.GatewayType gateway-type
  [m3831]
  (java.lang.Enum/valueOf
   com.amazonaws.services.storagegateway.model.GatewayType
   (clojure.core/name m3831)))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest describe-maintenance-start-time-request
  [m3834]
  (clojure.core/let
   [bean3833
    (new
     com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest)]
   (clojure.core/when-let
    [v3835 (:gateway-arn m3834)]
    (. bean3833 setGatewayARN (clojure.core/str v3835)))
   bean3833))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest update-bandwidth-rate-limit-request
  [m3837]
  (clojure.core/let
   [bean3836
    (new
     com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest)]
   (clojure.core/when-let
    [v3838 (:gateway-arn m3837)]
    (. bean3836 setGatewayARN (clojure.core/str v3838)))
   (clojure.core/when-let
    [v3838 (:average-upload-rate-limit-in-bits-per-sec m3837)]
    (.
     bean3836
     setAverageUploadRateLimitInBitsPerSec
     (clojure.core/long v3838)))
   (clojure.core/when-let
    [v3838 (:average-download-rate-limit-in-bits-per-sec m3837)]
    (.
     bean3836
     setAverageDownloadRateLimitInBitsPerSec
     (clojure.core/long v3838)))
   bean3836))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest describe-working-storage-request
  [m3840]
  (clojure.core/let
   [bean3839
    (new
     com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest)]
   (clojure.core/when-let
    [v3841 (:gateway-arn m3840)]
    (. bean3839 setGatewayARN (clojure.core/str v3841)))
   bean3839))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest delete-snapshot-schedule-request
  [m3843]
  (clojure.core/let
   [bean3842
    (new
     com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest)]
   (clojure.core/when-let
    [v3844 (:volume-arn m3843)]
    (. bean3842 setVolumeARN (clojure.core/str v3844)))
   bean3842))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest describe-chap-credentials-request
  [m3846]
  (clojure.core/let
   [bean3845
    (new
     com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest)]
   (clojure.core/when-let
    [v3847 (:target-arn m3846)]
    (. bean3845 setTargetARN (clojure.core/str v3847)))
   bean3845))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest delete-bandwidth-rate-limit-request
  [m3849]
  (clojure.core/let
   [bean3848
    (new
     com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest)]
   (clojure.core/when-let
    [v3850 (:gateway-arn m3849)]
    (. bean3848 setGatewayARN (clojure.core/str v3850)))
   (clojure.core/when-let
    [v3850 (:bandwidth-type m3849)]
    (. bean3848 setBandwidthType (clojure.core/str v3850)))
   (clojure.core/when-let
    [v3850 (:bandwidth-type m3849)]
    (. bean3848 setBandwidthType (bandwidth-type v3850)))
   bean3848))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest create-cachedi-scsivolume-request
  [m3852]
  (clojure.core/let
   [bean3851
    (new
     com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest)]
   (clojure.core/when-let
    [v3853 (:snapshot-id m3852)]
    (. bean3851 setSnapshotId (clojure.core/str v3853)))
   (clojure.core/when-let
    [v3853 (:gateway-arn m3852)]
    (. bean3851 setGatewayARN (clojure.core/str v3853)))
   (clojure.core/when-let
    [v3853 (:volume-size-in-bytes m3852)]
    (. bean3851 setVolumeSizeInBytes (clojure.core/long v3853)))
   (clojure.core/when-let
    [v3853 (:target-name m3852)]
    (. bean3851 setTargetName (clojure.core/str v3853)))
   (clojure.core/when-let
    [v3853 (:network-interface-id m3852)]
    (. bean3851 setNetworkInterfaceId (clojure.core/str v3853)))
   (clojure.core/when-let
    [v3853 (:client-token m3852)]
    (. bean3851 setClientToken (clojure.core/str v3853)))
   bean3851))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest create-snapshot-from-volume-recovery-point-request
  [m3855]
  (clojure.core/let
   [bean3854
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest)]
   (clojure.core/when-let
    [v3856 (:volume-arn m3855)]
    (. bean3854 setVolumeARN (clojure.core/str v3856)))
   (clojure.core/when-let
    [v3856 (:snapshot-description m3855)]
    (. bean3854 setSnapshotDescription (clojure.core/str v3856)))
   bean3854))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest describe-storedi-scsivolumes-request
  [m3858]
  (clojure.core/let
   [bean3857
    (new
     com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest)]
   (clojure.core/when-let
    [v3859 (:volume-arns m3858)]
    (.
     bean3857
     setVolumeARNs
     (clojure.core/map
      (clojure.core/fn [arg3860] (clojure.core/str arg3860))
      v3859)))
   bean3857))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest describe-upload-buffer-request
  [m3862]
  (clojure.core/let
   [bean3861
    (new
     com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest)]
   (clojure.core/when-let
    [v3863 (:gateway-arn m3862)]
    (. bean3861 setGatewayARN (clojure.core/str v3863)))
   bean3861))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.AddUploadBufferRequest add-upload-buffer-request
  [m3865]
  (clojure.core/let
   [bean3864
    (new
     com.amazonaws.services.storagegateway.model.AddUploadBufferRequest)]
   (clojure.core/when-let
    [v3866 (:gateway-arn m3865)]
    (. bean3864 setGatewayARN (clojure.core/str v3866)))
   (clojure.core/when-let
    [v3866 (:disk-ids m3865)]
    (.
     bean3864
     setDiskIds
     (clojure.core/map
      (clojure.core/fn [arg3867] (clojure.core/str arg3867))
      v3866)))
   bean3864))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest add-working-storage-request
  [m3869]
  (clojure.core/let
   [bean3868
    (new
     com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest)]
   (clojure.core/when-let
    [v3870 (:gateway-arn m3869)]
    (. bean3868 setGatewayARN (clojure.core/str v3870)))
   (clojure.core/when-let
    [v3870 (:disk-ids m3869)]
    (.
     bean3868
     setDiskIds
     (clojure.core/map
      (clojure.core/fn [arg3871] (clojure.core/str arg3871))
      v3870)))
   bean3868))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.StartGatewayRequest start-gateway-request
  [m3873]
  (clojure.core/let
   [bean3872
    (new
     com.amazonaws.services.storagegateway.model.StartGatewayRequest)]
   (clojure.core/when-let
    [v3874 (:gateway-arn m3873)]
    (. bean3872 setGatewayARN (clojure.core/str v3874)))
   bean3872))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.ListLocalDisksRequest list-local-disks-request
  [m3876]
  (clojure.core/let
   [bean3875
    (new
     com.amazonaws.services.storagegateway.model.ListLocalDisksRequest)]
   (clojure.core/when-let
    [v3877 (:gateway-arn m3876)]
    (. bean3875 setGatewayARN (clojure.core/str v3877)))
   bean3875))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest delete-chap-credentials-request
  [m3879]
  (clojure.core/let
   [bean3878
    (new
     com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest)]
   (clojure.core/when-let
    [v3880 (:target-arn m3879)]
    (. bean3878 setTargetARN (clojure.core/str v3880)))
   (clojure.core/when-let
    [v3880 (:initiator-name m3879)]
    (. bean3878 setInitiatorName (clojure.core/str v3880)))
   bean3878))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest update-maintenance-start-time-request
  [m3882]
  (clojure.core/let
   [bean3881
    (new
     com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest)]
   (clojure.core/when-let
    [v3883 (:hour-of-day m3882)]
    (. bean3881 setHourOfDay (clojure.core/int v3883)))
   (clojure.core/when-let
    [v3883 (:minute-of-hour m3882)]
    (. bean3881 setMinuteOfHour (clojure.core/int v3883)))
   (clojure.core/when-let
    [v3883 (:gateway-arn m3882)]
    (. bean3881 setGatewayARN (clojure.core/str v3883)))
   (clojure.core/when-let
    [v3883 (:day-of-week m3882)]
    (. bean3881 setDayOfWeek (clojure.core/int v3883)))
   bean3881))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.AddCacheRequest add-cache-request
  [m3885]
  (clojure.core/let
   [bean3884
    (new com.amazonaws.services.storagegateway.model.AddCacheRequest)]
   (clojure.core/when-let
    [v3886 (:gateway-arn m3885)]
    (. bean3884 setGatewayARN (clojure.core/str v3886)))
   (clojure.core/when-let
    [v3886 (:disk-ids m3885)]
    (.
     bean3884
     setDiskIds
     (clojure.core/map
      (clojure.core/fn [arg3887] (clojure.core/str arg3887))
      v3886)))
   bean3884))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest describe-cachedi-scsivolumes-request
  [m3889]
  (clojure.core/let
   [bean3888
    (new
     com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest)]
   (clojure.core/when-let
    [v3890 (:volume-arns m3889)]
    (.
     bean3888
     setVolumeARNs
     (clojure.core/map
      (clojure.core/fn [arg3891] (clojure.core/str arg3891))
      v3890)))
   bean3888))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest describe-bandwidth-rate-limit-request
  [m3893]
  (clojure.core/let
   [bean3892
    (new
     com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest)]
   (clojure.core/when-let
    [v3894 (:gateway-arn m3893)]
    (. bean3892 setGatewayARN (clojure.core/str v3894)))
   bean3892))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.ListVolumesRequest list-volumes-request
  [m3896]
  (clojure.core/let
   [bean3895
    (new
     com.amazonaws.services.storagegateway.model.ListVolumesRequest)]
   (clojure.core/when-let
    [v3897 (:marker m3896)]
    (. bean3895 setMarker (clojure.core/str v3897)))
   (clojure.core/when-let
    [v3897 (:gateway-arn m3896)]
    (. bean3895 setGatewayARN (clojure.core/str v3897)))
   (clojure.core/when-let
    [v3897 (:limit m3896)]
    (. bean3895 setLimit (clojure.core/int v3897)))
   bean3895))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.ActivateGatewayRequest activate-gateway-request
  [m3899]
  (clojure.core/let
   [bean3898
    (new
     com.amazonaws.services.storagegateway.model.ActivateGatewayRequest)]
   (clojure.core/when-let
    [v3900 (:activation-key m3899)]
    (. bean3898 setActivationKey (clojure.core/str v3900)))
   (clojure.core/when-let
    [v3900 (:gateway-name m3899)]
    (. bean3898 setGatewayName (clojure.core/str v3900)))
   (clojure.core/when-let
    [v3900 (:gateway-timezone m3899)]
    (. bean3898 setGatewayTimezone (clojure.core/str v3900)))
   (clojure.core/when-let
    [v3900 (:gateway-timezone m3899)]
    (. bean3898 setGatewayTimezone (gateway-timezone v3900)))
   (clojure.core/when-let
    [v3900 (:gateway-region m3899)]
    (. bean3898 setGatewayRegion (clojure.core/str v3900)))
   (clojure.core/when-let
    [v3900 (:gateway-type m3899)]
    (. bean3898 setGatewayType (gateway-type v3900)))
   (clojure.core/when-let
    [v3900 (:gateway-type m3899)]
    (. bean3898 setGatewayType (clojure.core/str v3900)))
   bean3898))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeCacheRequest describe-cache-request
  [m3902]
  (clojure.core/let
   [bean3901
    (new
     com.amazonaws.services.storagegateway.model.DescribeCacheRequest)]
   (clojure.core/when-let
    [v3903 (:gateway-arn m3902)]
    (. bean3901 setGatewayARN (clojure.core/str v3903)))
   bean3901))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest update-gateway-software-now-request
  [m3905]
  (clojure.core/let
   [bean3904
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest)]
   (clojure.core/when-let
    [v3906 (:gateway-arn m3905)]
    (. bean3904 setGatewayARN (clojure.core/str v3906)))
   bean3904))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest update-chap-credentials-request
  [m3908]
  (clojure.core/let
   [bean3907
    (new
     com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest)]
   (clojure.core/when-let
    [v3909 (:target-arn m3908)]
    (. bean3907 setTargetARN (clojure.core/str v3909)))
   (clojure.core/when-let
    [v3909 (:secret-to-authenticate-initiator m3908)]
    (.
     bean3907
     setSecretToAuthenticateInitiator
     (clojure.core/str v3909)))
   (clojure.core/when-let
    [v3909 (:initiator-name m3908)]
    (. bean3907 setInitiatorName (clojure.core/str v3909)))
   (clojure.core/when-let
    [v3909 (:secret-to-authenticate-target m3908)]
    (.
     bean3907
     setSecretToAuthenticateTarget
     (clojure.core/str v3909)))
   bean3907))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest create-storedi-scsivolume-request
  [m3911]
  (clojure.core/let
   [bean3910
    (new
     com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest)]
   (clojure.core/when-let
    [v3912 (:snapshot-id m3911)]
    (. bean3910 setSnapshotId (clojure.core/str v3912)))
   (clojure.core/when-let
    [v3912 (:gateway-arn m3911)]
    (. bean3910 setGatewayARN (clojure.core/str v3912)))
   (clojure.core/when-let
    [v3912 (:target-name m3911)]
    (. bean3910 setTargetName (clojure.core/str v3912)))
   (clojure.core/when-let
    [v3912 (:network-interface-id m3911)]
    (. bean3910 setNetworkInterfaceId (clojure.core/str v3912)))
   (clojure.core/when-let
    [v3912 (:disk-id m3911)]
    (. bean3910 setDiskId (clojure.core/str v3912)))
   (clojure.core/when-let
    [v3912 (:preserve-existing-data m3911)]
    (. bean3910 setPreserveExistingData (clojure.core/boolean v3912)))
   bean3910))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest update-gateway-information-request
  [m3914]
  (clojure.core/let
   [bean3913
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest)]
   (clojure.core/when-let
    [v3915 (:gateway-arn m3914)]
    (. bean3913 setGatewayARN (clojure.core/str v3915)))
   (clojure.core/when-let
    [v3915 (:gateway-name m3914)]
    (. bean3913 setGatewayName (clojure.core/str v3915)))
   (clojure.core/when-let
    [v3915 (:gateway-timezone m3914)]
    (. bean3913 setGatewayTimezone (clojure.core/str v3915)))
   (clojure.core/when-let
    [v3915 (:gateway-timezone m3914)]
    (. bean3913 setGatewayTimezone (gateway-timezone v3915)))
   bean3913))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest describe-gateway-information-request
  [m3917]
  (clojure.core/let
   [bean3916
    (new
     com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest)]
   (clojure.core/when-let
    [v3918 (:gateway-arn m3917)]
    (. bean3916 setGatewayARN (clojure.core/str v3918)))
   bean3916))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest shutdown-gateway-request
  [m3920]
  (clojure.core/let
   [bean3919
    (new
     com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest)]
   (clojure.core/when-let
    [v3921 (:gateway-arn m3920)]
    (. bean3919 setGatewayARN (clojure.core/str v3921)))
   bean3919))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest list-volume-recovery-points-request
  [m3923]
  (clojure.core/let
   [bean3922
    (new
     com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest)]
   (clojure.core/when-let
    [v3924 (:gateway-arn m3923)]
    (. bean3922 setGatewayARN (clojure.core/str v3924)))
   bean3922))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DeleteGatewayRequest delete-gateway-request
  [m3926]
  (clojure.core/let
   [bean3925
    (new
     com.amazonaws.services.storagegateway.model.DeleteGatewayRequest)]
   (clojure.core/when-let
    [v3927 (:gateway-arn m3926)]
    (. bean3925 setGatewayARN (clojure.core/str v3927)))
   bean3925))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.CreateSnapshotRequest create-snapshot-request
  [m3929]
  (clojure.core/let
   [bean3928
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotRequest)]
   (clojure.core/when-let
    [v3930 (:volume-arn m3929)]
    (. bean3928 setVolumeARN (clojure.core/str v3930)))
   (clojure.core/when-let
    [v3930 (:snapshot-description m3929)]
    (. bean3928 setSnapshotDescription (clojure.core/str v3930)))
   bean3928))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DeleteVolumeRequest delete-volume-request
  [m3932]
  (clojure.core/let
   [bean3931
    (new
     com.amazonaws.services.storagegateway.model.DeleteVolumeRequest)]
   (clojure.core/when-let
    [v3933 (:volume-arn m3932)]
    (. bean3931 setVolumeARN (clojure.core/str v3933)))
   bean3931))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest update-snapshot-schedule-request
  [m3935]
  (clojure.core/let
   [bean3934
    (new
     com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest)]
   (clojure.core/when-let
    [v3936 (:volume-arn m3935)]
    (. bean3934 setVolumeARN (clojure.core/str v3936)))
   (clojure.core/when-let
    [v3936 (:start-at m3935)]
    (. bean3934 setStartAt (clojure.core/int v3936)))
   (clojure.core/when-let
    [v3936 (:recurrence-in-hours m3935)]
    (. bean3934 setRecurrenceInHours (clojure.core/int v3936)))
   (clojure.core/when-let
    [v3936 (:description m3935)]
    (. bean3934 setDescription (clojure.core/str v3936)))
   bean3934))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest describe-snapshot-schedule-request
  [m3938]
  (clojure.core/let
   [bean3937
    (new
     com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest)]
   (clojure.core/when-let
    [v3939 (:volume-arn m3938)]
    (. bean3937 setVolumeARN (clojure.core/str v3939)))
   bean3937))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.ListGatewaysRequest list-gateways-request
  [m3941]
  (clojure.core/let
   [bean3940
    (new
     com.amazonaws.services.storagegateway.model.ListGatewaysRequest)]
   (clojure.core/when-let
    [v3942 (:marker m3941)]
    (. bean3940 setMarker (clojure.core/str v3942)))
   (clojure.core/when-let
    [v3942 (:limit m3941)]
    (. bean3940 setLimit (clojure.core/int v3942)))
   bean3940))
 (clojure.core/defmulti
  storagegateway
  (clojure.core/fn
   storagegateway
   [m__609__auto__]
   (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-maintenance-start-time
   [m3943]
   (clojure.core/let
    [credentials3944 (:credentials m3943) args3945 (:args m3943)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3946
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials3944)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3946
       describeMaintenanceStartTime
       (describe-maintenance-start-time-request
        (clojure.core/nth args3945 0)))))))
  (clojure.core/defn
   describe-maintenance-start-time-map
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Generate map for describeMaintenanceStartTime"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-maintenance-start-time,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-maintenance-start-time
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Call describeMaintenanceStartTime"}
   [credentials3948 & args3949]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3950
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials3948)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3950
      describeMaintenanceStartTime
      (describe-maintenance-start-time-request
       (clojure.core/nth args3949 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-bandwidth-rate-limit
   [m3951]
   (clojure.core/let
    [credentials3952 (:credentials m3951) args3953 (:args m3951)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3954
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials3952)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3954
       updateBandwidthRateLimit
       (update-bandwidth-rate-limit-request
        (clojure.core/nth args3953 0)))))))
  (clojure.core/defn
   update-bandwidth-rate-limit-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         gateway-arn
         average-upload-rate-limit-in-bits-per-sec
         average-download-rate-limit-in-bits-per-sec]}]],
    :doc "Generate map for updateBandwidthRateLimit"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-bandwidth-rate-limit,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-bandwidth-rate-limit
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         gateway-arn
         average-upload-rate-limit-in-bits-per-sec
         average-download-rate-limit-in-bits-per-sec]}]],
    :doc "Call updateBandwidthRateLimit"}
   [credentials3956 & args3957]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3958
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials3956)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3958
      updateBandwidthRateLimit
      (update-bandwidth-rate-limit-request
       (clojure.core/nth args3957 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-working-storage
   [m3959]
   (clojure.core/let
    [credentials3960 (:credentials m3959) args3961 (:args m3959)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3962
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials3960)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3962
       describeWorkingStorage
       (describe-working-storage-request
        (clojure.core/nth args3961 0)))))))
  (clojure.core/defn
   describe-working-storage-map
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Generate map for describeWorkingStorage"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-working-storage,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-working-storage
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Call describeWorkingStorage"}
   [credentials3964 & args3965]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3966
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials3964)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3966
      describeWorkingStorage
      (describe-working-storage-request
       (clojure.core/nth args3965 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-snapshot-schedule
   [m3967]
   (clojure.core/let
    [credentials3968 (:credentials m3967) args3969 (:args m3967)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3970
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials3968)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3970
       deleteSnapshotSchedule
       (delete-snapshot-schedule-request
        (clojure.core/nth args3969 0)))))))
  (clojure.core/defn
   delete-snapshot-schedule-map
   {:arglists
    '[[credentials {:keys [volume-arn request-metric-collector]}]],
    :doc "Generate map for deleteSnapshotSchedule"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-snapshot-schedule,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-snapshot-schedule
   {:arglists
    '[[credentials {:keys [volume-arn request-metric-collector]}]],
    :doc "Call deleteSnapshotSchedule"}
   [credentials3972 & args3973]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3974
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials3972)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3974
      deleteSnapshotSchedule
      (delete-snapshot-schedule-request
       (clojure.core/nth args3973 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-chap-credentials
   [m3975]
   (clojure.core/let
    [credentials3976 (:credentials m3975) args3977 (:args m3975)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3978
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials3976)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3978
       describeChapCredentials
       (describe-chap-credentials-request
        (clojure.core/nth args3977 0)))))))
  (clojure.core/defn
   describe-chap-credentials-map
   {:arglists
    '[[credentials {:keys [target-arn request-metric-collector]}]],
    :doc "Generate map for describeChapCredentials"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-chap-credentials,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-chap-credentials
   {:arglists
    '[[credentials {:keys [target-arn request-metric-collector]}]],
    :doc "Call describeChapCredentials"}
   [credentials3980 & args3981]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3982
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials3980)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3982
      describeChapCredentials
      (describe-chap-credentials-request
       (clojure.core/nth args3981 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-bandwidth-rate-limit
   [m3983]
   (clojure.core/let
    [credentials3984 (:credentials m3983) args3985 (:args m3983)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3986
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials3984)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3986
       deleteBandwidthRateLimit
       (delete-bandwidth-rate-limit-request
        (clojure.core/nth args3985 0)))))))
  (clojure.core/defn
   delete-bandwidth-rate-limit-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector gateway-arn bandwidth-type]}]],
    :doc "Generate map for deleteBandwidthRateLimit"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-bandwidth-rate-limit,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-bandwidth-rate-limit
   {:arglists
    '[[credentials
       {:keys [request-metric-collector gateway-arn bandwidth-type]}]],
    :doc "Call deleteBandwidthRateLimit"}
   [credentials3988 & args3989]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3990
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials3988)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3990
      deleteBandwidthRateLimit
      (delete-bandwidth-rate-limit-request
       (clojure.core/nth args3989 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-cachedi-scsivolume
   [m3991]
   (clojure.core/let
    [credentials3992 (:credentials m3991) args3993 (:args m3991)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3994
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials3992)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3994
       createCachediSCSIVolume
       (create-cachedi-scsivolume-request
        (clojure.core/nth args3993 0)))))))
  (clojure.core/defn
   create-cachedi-scsivolume-map
   {:arglists
    '[[credentials
       {:keys
        [network-interface-id
         client-token
         target-name
         volume-size-in-bytes
         gateway-arn
         request-metric-collector
         snapshot-id]}]],
    :doc "Generate map for createCachediSCSIVolume"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-cachedi-scsivolume,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-cachedi-scsivolume
   {:arglists
    '[[credentials
       {:keys
        [network-interface-id
         client-token
         target-name
         volume-size-in-bytes
         gateway-arn
         request-metric-collector
         snapshot-id]}]],
    :doc "Call createCachediSCSIVolume"}
   [credentials3996 & args3997]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3998
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials3996)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client3998
      createCachediSCSIVolume
      (create-cachedi-scsivolume-request
       (clojure.core/nth args3997 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot-from-volume-recovery-point
   [m3999]
   (clojure.core/let
    [credentials4000 (:credentials m3999) args4001 (:args m3999)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4002
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4000)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4002
       createSnapshotFromVolumeRecoveryPoint
       (create-snapshot-from-volume-recovery-point-request
        (clojure.core/nth args4001 0)))))))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point-map
   {:arglists
    '[[credentials
       {:keys
        [volume-arn snapshot-description request-metric-collector]}]],
    :doc "Generate map for createSnapshotFromVolumeRecoveryPoint"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-snapshot-from-volume-recovery-point,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point
   {:arglists
    '[[credentials
       {:keys
        [volume-arn snapshot-description request-metric-collector]}]],
    :doc "Call createSnapshotFromVolumeRecoveryPoint"}
   [credentials4004 & args4005]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4006
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4004)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4006
      createSnapshotFromVolumeRecoveryPoint
      (create-snapshot-from-volume-recovery-point-request
       (clojure.core/nth args4005 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-storedi-scsivolumes
   [m4007]
   (clojure.core/let
    [credentials4008 (:credentials m4007) args4009 (:args m4007)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4010
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4008)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4010
       describeStorediSCSIVolumes
       (describe-storedi-scsivolumes-request
        (clojure.core/nth args4009 0)))))))
  (clojure.core/defn
   describe-storedi-scsivolumes-map
   {:arglists
    '[[credentials {:keys [volume-arns request-metric-collector]}]],
    :doc "Generate map for describeStorediSCSIVolumes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-storedi-scsivolumes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-storedi-scsivolumes
   {:arglists
    '[[credentials {:keys [volume-arns request-metric-collector]}]],
    :doc "Call describeStorediSCSIVolumes"}
   [credentials4012 & args4013]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4014
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4012)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4014
      describeStorediSCSIVolumes
      (describe-storedi-scsivolumes-request
       (clojure.core/nth args4013 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-upload-buffer
   [m4015]
   (clojure.core/let
    [credentials4016 (:credentials m4015) args4017 (:args m4015)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4018
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4016)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4018
       describeUploadBuffer
       (describe-upload-buffer-request
        (clojure.core/nth args4017 0)))))))
  (clojure.core/defn
   describe-upload-buffer-map
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Generate map for describeUploadBuffer"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-upload-buffer,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-upload-buffer
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Call describeUploadBuffer"}
   [credentials4020 & args4021]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4022
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4020)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4022
      describeUploadBuffer
      (describe-upload-buffer-request
       (clojure.core/nth args4021 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-upload-buffer
   [m4023]
   (clojure.core/let
    [credentials4024 (:credentials m4023) args4025 (:args m4023)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4026
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4024)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4026
       addUploadBuffer
       (add-upload-buffer-request (clojure.core/nth args4025 0)))))))
  (clojure.core/defn
   add-upload-buffer-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector gateway-arn disk-ids]}]],
    :doc "Generate map for addUploadBuffer"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :add-upload-buffer,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   add-upload-buffer
   {:arglists
    '[[credentials
       {:keys [request-metric-collector gateway-arn disk-ids]}]],
    :doc "Call addUploadBuffer"}
   [credentials4028 & args4029]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4030
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4028)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4030
      addUploadBuffer
      (add-upload-buffer-request (clojure.core/nth args4029 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-working-storage
   [m4031]
   (clojure.core/let
    [credentials4032 (:credentials m4031) args4033 (:args m4031)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4034
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4032)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4034
       addWorkingStorage
       (add-working-storage-request (clojure.core/nth args4033 0)))))))
  (clojure.core/defn
   add-working-storage-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector gateway-arn disk-ids]}]],
    :doc "Generate map for addWorkingStorage"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :add-working-storage,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   add-working-storage
   {:arglists
    '[[credentials
       {:keys [request-metric-collector gateway-arn disk-ids]}]],
    :doc "Call addWorkingStorage"}
   [credentials4036 & args4037]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4038
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4036)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4038
      addWorkingStorage
      (add-working-storage-request (clojure.core/nth args4037 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :start-gateway
   [m4039]
   (clojure.core/let
    [credentials4040 (:credentials m4039) args4041 (:args m4039)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4042
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4040)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4042
       startGateway
       (start-gateway-request (clojure.core/nth args4041 0)))))))
  (clojure.core/defn
   start-gateway-map
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Generate map for startGateway"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :start-gateway,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   start-gateway
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Call startGateway"}
   [credentials4044 & args4045]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4046
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4044)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4046
      startGateway
      (start-gateway-request (clojure.core/nth args4045 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-local-disks
   [m4047]
   (clojure.core/let
    [credentials4048 (:credentials m4047) args4049 (:args m4047)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4050
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4048)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4050
       listLocalDisks
       (list-local-disks-request (clojure.core/nth args4049 0)))))))
  (clojure.core/defn
   list-local-disks-map
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Generate map for listLocalDisks"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-local-disks,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-local-disks
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Call listLocalDisks"}
   [credentials4052 & args4053]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4054
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4052)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4054
      listLocalDisks
      (list-local-disks-request (clojure.core/nth args4053 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-chap-credentials
   [m4055]
   (clojure.core/let
    [credentials4056 (:credentials m4055) args4057 (:args m4055)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4058
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4056)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4058
       deleteChapCredentials
       (delete-chap-credentials-request
        (clojure.core/nth args4057 0)))))))
  (clojure.core/defn
   delete-chap-credentials-map
   {:arglists
    '[[credentials
       {:keys [target-arn request-metric-collector initiator-name]}]],
    :doc "Generate map for deleteChapCredentials"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-chap-credentials,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-chap-credentials
   {:arglists
    '[[credentials
       {:keys [target-arn request-metric-collector initiator-name]}]],
    :doc "Call deleteChapCredentials"}
   [credentials4060 & args4061]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4062
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4060)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4062
      deleteChapCredentials
      (delete-chap-credentials-request
       (clojure.core/nth args4061 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-maintenance-start-time
   [m4063]
   (clojure.core/let
    [credentials4064 (:credentials m4063) args4065 (:args m4063)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4066
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4064)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4066
       updateMaintenanceStartTime
       (update-maintenance-start-time-request
        (clojure.core/nth args4065 0)))))))
  (clojure.core/defn
   update-maintenance-start-time-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         minute-of-hour
         hour-of-day
         gateway-arn
         day-of-week]}]],
    :doc "Generate map for updateMaintenanceStartTime"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-maintenance-start-time,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-maintenance-start-time
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         minute-of-hour
         hour-of-day
         gateway-arn
         day-of-week]}]],
    :doc "Call updateMaintenanceStartTime"}
   [credentials4068 & args4069]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4070
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4068)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4070
      updateMaintenanceStartTime
      (update-maintenance-start-time-request
       (clojure.core/nth args4069 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-cache
   [m4071]
   (clojure.core/let
    [credentials4072 (:credentials m4071) args4073 (:args m4071)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4074
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4072)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4074
       addCache
       (add-cache-request (clojure.core/nth args4073 0)))))))
  (clojure.core/defn
   add-cache-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector gateway-arn disk-ids]}]],
    :doc "Generate map for addCache"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :add-cache,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   add-cache
   {:arglists
    '[[credentials
       {:keys [request-metric-collector gateway-arn disk-ids]}]],
    :doc "Call addCache"}
   [credentials4076 & args4077]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4078
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4076)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4078
      addCache
      (add-cache-request (clojure.core/nth args4077 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cachedi-scsivolumes
   [m4079]
   (clojure.core/let
    [credentials4080 (:credentials m4079) args4081 (:args m4079)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4082
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4080)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4082
       describeCachediSCSIVolumes
       (describe-cachedi-scsivolumes-request
        (clojure.core/nth args4081 0)))))))
  (clojure.core/defn
   describe-cachedi-scsivolumes-map
   {:arglists
    '[[credentials {:keys [volume-arns request-metric-collector]}]],
    :doc "Generate map for describeCachediSCSIVolumes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-cachedi-scsivolumes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-cachedi-scsivolumes
   {:arglists
    '[[credentials {:keys [volume-arns request-metric-collector]}]],
    :doc "Call describeCachediSCSIVolumes"}
   [credentials4084 & args4085]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4086
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4084)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4086
      describeCachediSCSIVolumes
      (describe-cachedi-scsivolumes-request
       (clojure.core/nth args4085 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-bandwidth-rate-limit
   [m4087]
   (clojure.core/let
    [credentials4088 (:credentials m4087) args4089 (:args m4087)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4090
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4088)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4090
       describeBandwidthRateLimit
       (describe-bandwidth-rate-limit-request
        (clojure.core/nth args4089 0)))))))
  (clojure.core/defn
   describe-bandwidth-rate-limit-map
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Generate map for describeBandwidthRateLimit"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-bandwidth-rate-limit,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-bandwidth-rate-limit
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Call describeBandwidthRateLimit"}
   [credentials4092 & args4093]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4094
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4092)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4094
      describeBandwidthRateLimit
      (describe-bandwidth-rate-limit-request
       (clojure.core/nth args4093 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volumes
   [m4095]
   (clojure.core/let
    [credentials4096 (:credentials m4095) args4097 (:args m4095)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4098
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4096)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4098
       listVolumes
       (list-volumes-request (clojure.core/nth args4097 0)))))))
  (clojure.core/defn
   list-volumes-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector marker limit gateway-arn]}]],
    :doc "Generate map for listVolumes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-volumes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-volumes
   {:arglists
    '[[credentials
       {:keys [request-metric-collector marker limit gateway-arn]}]],
    :doc "Call listVolumes"}
   [credentials4100 & args4101]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4102
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4100)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4102
      listVolumes
      (list-volumes-request (clojure.core/nth args4101 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :activate-gateway
   [m4103]
   (clojure.core/let
    [credentials4104 (:credentials m4103) args4105 (:args m4103)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4106
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4104)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4106
       activateGateway
       (activate-gateway-request (clojure.core/nth args4105 0)))))))
  (clojure.core/defn
   activate-gateway-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         gateway-type
         gateway-timezone
         gateway-region
         gateway-name
         activation-key]}]],
    :doc "Generate map for activateGateway"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :activate-gateway,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   activate-gateway
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         gateway-type
         gateway-timezone
         gateway-region
         gateway-name
         activation-key]}]],
    :doc "Call activateGateway"}
   [credentials4108 & args4109]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4110
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4108)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4110
      activateGateway
      (activate-gateway-request (clojure.core/nth args4109 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cache
   [m4111]
   (clojure.core/let
    [credentials4112 (:credentials m4111) args4113 (:args m4111)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4114
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4112)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4114
       describeCache
       (describe-cache-request (clojure.core/nth args4113 0)))))))
  (clojure.core/defn
   describe-cache-map
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Generate map for describeCache"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-cache,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-cache
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Call describeCache"}
   [credentials4116 & args4117]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4118
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4116)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4118
      describeCache
      (describe-cache-request (clojure.core/nth args4117 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-software-now
   [m4119]
   (clojure.core/let
    [credentials4120 (:credentials m4119) args4121 (:args m4119)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4122
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4120)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4122
       updateGatewaySoftwareNow
       (update-gateway-software-now-request
        (clojure.core/nth args4121 0)))))))
  (clojure.core/defn
   update-gateway-software-now-map
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Generate map for updateGatewaySoftwareNow"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-gateway-software-now,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-gateway-software-now
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Call updateGatewaySoftwareNow"}
   [credentials4124 & args4125]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4126
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4124)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4126
      updateGatewaySoftwareNow
      (update-gateway-software-now-request
       (clojure.core/nth args4125 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-chap-credentials
   [m4127]
   (clojure.core/let
    [credentials4128 (:credentials m4127) args4129 (:args m4127)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4130
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4128)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4130
       updateChapCredentials
       (update-chap-credentials-request
        (clojure.core/nth args4129 0)))))))
  (clojure.core/defn
   update-chap-credentials-map
   {:arglists
    '[[credentials
       {:keys
        [target-arn
         secret-to-authenticate-target
         secret-to-authenticate-initiator
         request-metric-collector
         initiator-name]}]],
    :doc "Generate map for updateChapCredentials"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-chap-credentials,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-chap-credentials
   {:arglists
    '[[credentials
       {:keys
        [target-arn
         secret-to-authenticate-target
         secret-to-authenticate-initiator
         request-metric-collector
         initiator-name]}]],
    :doc "Call updateChapCredentials"}
   [credentials4132 & args4133]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4134
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4132)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4134
      updateChapCredentials
      (update-chap-credentials-request
       (clojure.core/nth args4133 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-storedi-scsivolume
   [m4135]
   (clojure.core/let
    [credentials4136 (:credentials m4135) args4137 (:args m4135)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4138
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4136)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4138
       createStorediSCSIVolume
       (create-storedi-scsivolume-request
        (clojure.core/nth args4137 0)))))))
  (clojure.core/defn
   create-storedi-scsivolume-map
   {:arglists
    '[[credentials
       {:keys
        [network-interface-id
         target-name
         gateway-arn
         request-metric-collector
         preserve-existing-data
         snapshot-id
         disk-id]}]],
    :doc "Generate map for createStorediSCSIVolume"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-storedi-scsivolume,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-storedi-scsivolume
   {:arglists
    '[[credentials
       {:keys
        [network-interface-id
         target-name
         gateway-arn
         request-metric-collector
         preserve-existing-data
         snapshot-id
         disk-id]}]],
    :doc "Call createStorediSCSIVolume"}
   [credentials4140 & args4141]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4142
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4140)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4142
      createStorediSCSIVolume
      (create-storedi-scsivolume-request
       (clojure.core/nth args4141 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-information
   [m4143]
   (clojure.core/let
    [credentials4144 (:credentials m4143) args4145 (:args m4143)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4146
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4144)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4146
       updateGatewayInformation
       (update-gateway-information-request
        (clojure.core/nth args4145 0)))))))
  (clojure.core/defn
   update-gateway-information-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         gateway-timezone
         gateway-name
         gateway-arn]}]],
    :doc "Generate map for updateGatewayInformation"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-gateway-information,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-gateway-information
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         gateway-timezone
         gateway-name
         gateway-arn]}]],
    :doc "Call updateGatewayInformation"}
   [credentials4148 & args4149]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4150
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4148)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4150
      updateGatewayInformation
      (update-gateway-information-request
       (clojure.core/nth args4149 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-gateway-information
   [m4151]
   (clojure.core/let
    [credentials4152 (:credentials m4151) args4153 (:args m4151)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4154
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4152)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4154
       describeGatewayInformation
       (describe-gateway-information-request
        (clojure.core/nth args4153 0)))))))
  (clojure.core/defn
   describe-gateway-information-map
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Generate map for describeGatewayInformation"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-gateway-information,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-gateway-information
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Call describeGatewayInformation"}
   [credentials4156 & args4157]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4158
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4156)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4158
      describeGatewayInformation
      (describe-gateway-information-request
       (clojure.core/nth args4157 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :shutdown-gateway
   [m4159]
   (clojure.core/let
    [credentials4160 (:credentials m4159) args4161 (:args m4159)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4162
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4160)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4162
       shutdownGateway
       (shutdown-gateway-request (clojure.core/nth args4161 0)))))))
  (clojure.core/defn
   shutdown-gateway-map
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Generate map for shutdownGateway"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :shutdown-gateway,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   shutdown-gateway
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Call shutdownGateway"}
   [credentials4164 & args4165]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4166
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4164)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4166
      shutdownGateway
      (shutdown-gateway-request (clojure.core/nth args4165 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volume-recovery-points
   [m4167]
   (clojure.core/let
    [credentials4168 (:credentials m4167) args4169 (:args m4167)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4170
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4168)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4170
       listVolumeRecoveryPoints
       (list-volume-recovery-points-request
        (clojure.core/nth args4169 0)))))))
  (clojure.core/defn
   list-volume-recovery-points-map
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Generate map for listVolumeRecoveryPoints"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-volume-recovery-points,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-volume-recovery-points
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Call listVolumeRecoveryPoints"}
   [credentials4172 & args4173]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4174
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4172)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4174
      listVolumeRecoveryPoints
      (list-volume-recovery-points-request
       (clojure.core/nth args4173 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-gateway
   [m4175]
   (clojure.core/let
    [credentials4176 (:credentials m4175) args4177 (:args m4175)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4178
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4176)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4178
       deleteGateway
       (delete-gateway-request (clojure.core/nth args4177 0)))))))
  (clojure.core/defn
   delete-gateway-map
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Generate map for deleteGateway"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-gateway,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-gateway
   {:arglists
    '[[credentials {:keys [request-metric-collector gateway-arn]}]],
    :doc "Call deleteGateway"}
   [credentials4180 & args4181]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4182
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4180)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4182
      deleteGateway
      (delete-gateway-request (clojure.core/nth args4181 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot
   [m4183]
   (clojure.core/let
    [credentials4184 (:credentials m4183) args4185 (:args m4183)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4186
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4184)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4186
       createSnapshot
       (create-snapshot-request (clojure.core/nth args4185 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists
    '[[credentials
       {:keys
        [volume-arn snapshot-description request-metric-collector]}]],
    :doc "Generate map for createSnapshot"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-snapshot,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-snapshot
   {:arglists
    '[[credentials
       {:keys
        [volume-arn snapshot-description request-metric-collector]}]],
    :doc "Call createSnapshot"}
   [credentials4188 & args4189]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4190
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4188)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4190
      createSnapshot
      (create-snapshot-request (clojure.core/nth args4189 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-volume
   [m4191]
   (clojure.core/let
    [credentials4192 (:credentials m4191) args4193 (:args m4191)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4194
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4192)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4194
       deleteVolume
       (delete-volume-request (clojure.core/nth args4193 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists
    '[[credentials {:keys [volume-arn request-metric-collector]}]],
    :doc "Generate map for deleteVolume"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-volume,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-volume
   {:arglists
    '[[credentials {:keys [volume-arn request-metric-collector]}]],
    :doc "Call deleteVolume"}
   [credentials4196 & args4197]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4198
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4196)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4198
      deleteVolume
      (delete-volume-request (clojure.core/nth args4197 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-snapshot-schedule
   [m4199]
   (clojure.core/let
    [credentials4200 (:credentials m4199) args4201 (:args m4199)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4202
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4200)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4202
       updateSnapshotSchedule
       (update-snapshot-schedule-request
        (clojure.core/nth args4201 0)))))))
  (clojure.core/defn
   update-snapshot-schedule-map
   {:arglists
    '[[credentials
       {:keys
        [volume-arn
         start-at
         request-metric-collector
         recurrence-in-hours
         description]}]],
    :doc "Generate map for updateSnapshotSchedule"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-snapshot-schedule,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-snapshot-schedule
   {:arglists
    '[[credentials
       {:keys
        [volume-arn
         start-at
         request-metric-collector
         recurrence-in-hours
         description]}]],
    :doc "Call updateSnapshotSchedule"}
   [credentials4204 & args4205]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4206
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4204)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4206
      updateSnapshotSchedule
      (update-snapshot-schedule-request
       (clojure.core/nth args4205 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-snapshot-schedule
   [m4207]
   (clojure.core/let
    [credentials4208 (:credentials m4207) args4209 (:args m4207)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4210
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4208)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4210
       describeSnapshotSchedule
       (describe-snapshot-schedule-request
        (clojure.core/nth args4209 0)))))))
  (clojure.core/defn
   describe-snapshot-schedule-map
   {:arglists
    '[[credentials {:keys [volume-arn request-metric-collector]}]],
    :doc "Generate map for describeSnapshotSchedule"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-snapshot-schedule,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-snapshot-schedule
   {:arglists
    '[[credentials {:keys [volume-arn request-metric-collector]}]],
    :doc "Call describeSnapshotSchedule"}
   [credentials4212 & args4213]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4214
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4212)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4214
      describeSnapshotSchedule
      (describe-snapshot-schedule-request
       (clojure.core/nth args4213 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-gateways
   [m4215]
   (clojure.core/let
    [credentials4216 (:credentials m4215) args4217 (:args m4215)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4218
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4216)]
     (clojure.core/case
      (clojure.core/count args4217)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4218
        listGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4218
        listGateways
        (list-gateways-request (clojure.core/nth args4217 0))))))))
  (clojure.core/defn
   list-gateways-map
   {:arglists
    '[[credentials]
      [credentials {:keys [request-metric-collector marker limit]}]],
    :doc "Generate map for listGateways, listGateways"}
   ([credentials__577__auto__]
    {:args [],
     :client :storagegateway,
     :fn :list-gateways,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-gateways,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-gateways
   {:arglists
    '[[credentials]
      [credentials {:keys [request-metric-collector marker limit]}]],
    :doc "Call listGateways, listGateways"}
   [credentials4220 & args4221]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4222
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4220)]
    (clojure.core/case
     (clojure.core/count args4221)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4222
       listGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4222
       listGateways
       (list-gateways-request (clojure.core/nth args4221 0)))))))))
