(ns com.palletops.awaze.sns (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sns
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.sns.AmazonSNSClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.GetEndpointAttributesRequest get-endpoint-attributes-request
  [m1599]
  (clojure.core/let
   [bean1598
    (new
     com.amazonaws.services.sns.model.GetEndpointAttributesRequest)]
   (clojure.core/when-let
    [v1600 (:endpoint-arn m1599)]
    (. bean1598 setEndpointArn (clojure.core/str v1600)))
   bean1598))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest get-platform-application-attributes-request
  [m1602]
  (clojure.core/let
   [bean1601
    (new
     com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest)]
   (clojure.core/when-let
    [v1603 (:platform-application-arn m1602)]
    (. bean1601 setPlatformApplicationArn (clojure.core/str v1603)))
   bean1601))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.SetTopicAttributesRequest set-topic-attributes-request
  [m1605]
  (clojure.core/let
   [bean1604
    (new com.amazonaws.services.sns.model.SetTopicAttributesRequest)]
   (clojure.core/when-let
    [v1606 (:topic-arn m1605)]
    (. bean1604 setTopicArn (clojure.core/str v1606)))
   (clojure.core/when-let
    [v1606 (:attribute-name m1605)]
    (. bean1604 setAttributeName (clojure.core/str v1606)))
   (clojure.core/when-let
    [v1606 (:attribute-value m1605)]
    (. bean1604 setAttributeValue (clojure.core/str v1606)))
   bean1604))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.AddPermissionRequest add-permission-request
  [m1608]
  (clojure.core/let
   [bean1607
    (new com.amazonaws.services.sns.model.AddPermissionRequest)]
   (clojure.core/when-let
    [v1609 (:topic-arn m1608)]
    (. bean1607 setTopicArn (clojure.core/str v1609)))
   (clojure.core/when-let
    [v1609 (:label m1608)]
    (. bean1607 setLabel (clojure.core/str v1609)))
   (clojure.core/when-let
    [v1609 (:awsaccount-ids m1608)]
    (.
     bean1607
     setAWSAccountIds
     (clojure.core/map
      (clojure.core/fn [arg1610] (clojure.core/str arg1610))
      v1609)))
   (clojure.core/when-let
    [v1609 (:action-names m1608)]
    (.
     bean1607
     setActionNames
     (clojure.core/map
      (clojure.core/fn [arg1611] (clojure.core/str arg1611))
      v1609)))
   bean1607))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest get-subscription-attributes-request
  [m1613]
  (clojure.core/let
   [bean1612
    (new
     com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest)]
   (clojure.core/when-let
    [v1614 (:subscription-arn m1613)]
    (. bean1612 setSubscriptionArn (clojure.core/str v1614)))
   bean1612))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.ConfirmSubscriptionRequest confirm-subscription-request
  [m1616]
  (clojure.core/let
   [bean1615
    (new com.amazonaws.services.sns.model.ConfirmSubscriptionRequest)]
   (clojure.core/when-let
    [v1617 (:topic-arn m1616)]
    (. bean1615 setTopicArn (clojure.core/str v1617)))
   (clojure.core/when-let
    [v1617 (:token m1616)]
    (. bean1615 setToken (clojure.core/str v1617)))
   (clojure.core/when-let
    [v1617 (:authenticate-on-unsubscribe m1616)]
    (. bean1615 setAuthenticateOnUnsubscribe (clojure.core/str v1617)))
   bean1615))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.DeleteTopicRequest delete-topic-request
  [m1619]
  (clojure.core/let
   [bean1618 (new com.amazonaws.services.sns.model.DeleteTopicRequest)]
   (clojure.core/when-let
    [v1620 (:topic-arn m1619)]
    (. bean1618 setTopicArn (clojure.core/str v1620)))
   bean1618))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.PublishRequest publish-request
  [m1622]
  (clojure.core/let
   [bean1621 (new com.amazonaws.services.sns.model.PublishRequest)]
   (clojure.core/when-let
    [v1623 (:topic-arn m1622)]
    (. bean1621 setTopicArn (clojure.core/str v1623)))
   (clojure.core/when-let
    [v1623 (:target-arn m1622)]
    (. bean1621 setTargetArn (clojure.core/str v1623)))
   (clojure.core/when-let
    [v1623 (:message-structure m1622)]
    (. bean1621 setMessageStructure (clojure.core/str v1623)))
   (clojure.core/when-let
    [v1623 (:message m1622)]
    (. bean1621 setMessage (clojure.core/str v1623)))
   (clojure.core/when-let
    [v1623 (:subject m1622)]
    (. bean1621 setSubject (clojure.core/str v1623)))
   bean1621))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.ListTopicsRequest list-topics-request
  [m1625]
  (clojure.core/let
   [bean1624 (new com.amazonaws.services.sns.model.ListTopicsRequest)]
   (clojure.core/when-let
    [v1626 (:next-token m1625)]
    (. bean1624 setNextToken (clojure.core/str v1626)))
   bean1624))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest list-subscriptions-by-topic-request
  [m1628]
  (clojure.core/let
   [bean1627
    (new
     com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest)]
   (clojure.core/when-let
    [v1629 (:topic-arn m1628)]
    (. bean1627 setTopicArn (clojure.core/str v1629)))
   (clojure.core/when-let
    [v1629 (:next-token m1628)]
    (. bean1627 setNextToken (clojure.core/str v1629)))
   bean1627))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.DeletePlatformApplicationRequest delete-platform-application-request
  [m1631]
  (clojure.core/let
   [bean1630
    (new
     com.amazonaws.services.sns.model.DeletePlatformApplicationRequest)]
   (clojure.core/when-let
    [v1632 (:platform-application-arn m1631)]
    (. bean1630 setPlatformApplicationArn (clojure.core/str v1632)))
   bean1630))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest list-endpoints-by-platform-application-request
  [m1634]
  (clojure.core/let
   [bean1633
    (new
     com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest)]
   (clojure.core/when-let
    [v1635 (:platform-application-arn m1634)]
    (. bean1633 setPlatformApplicationArn (clojure.core/str v1635)))
   (clojure.core/when-let
    [v1635 (:next-token m1634)]
    (. bean1633 setNextToken (clojure.core/str v1635)))
   bean1633))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.UnsubscribeRequest unsubscribe-request
  [m1637]
  (clojure.core/let
   [bean1636 (new com.amazonaws.services.sns.model.UnsubscribeRequest)]
   (clojure.core/when-let
    [v1638 (:subscription-arn m1637)]
    (. bean1636 setSubscriptionArn (clojure.core/str v1638)))
   bean1636))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest set-subscription-attributes-request
  [m1640]
  (clojure.core/let
   [bean1639
    (new
     com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest)]
   (clojure.core/when-let
    [v1641 (:subscription-arn m1640)]
    (. bean1639 setSubscriptionArn (clojure.core/str v1641)))
   (clojure.core/when-let
    [v1641 (:attribute-name m1640)]
    (. bean1639 setAttributeName (clojure.core/str v1641)))
   (clojure.core/when-let
    [v1641 (:attribute-value m1640)]
    (. bean1639 setAttributeValue (clojure.core/str v1641)))
   bean1639))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.ListSubscriptionsRequest list-subscriptions-request
  [m1643]
  (clojure.core/let
   [bean1642
    (new com.amazonaws.services.sns.model.ListSubscriptionsRequest)]
   (clojure.core/when-let
    [v1644 (:next-token m1643)]
    (. bean1642 setNextToken (clojure.core/str v1644)))
   bean1642))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.CreateTopicRequest create-topic-request
  [m1646]
  (clojure.core/let
   [bean1645 (new com.amazonaws.services.sns.model.CreateTopicRequest)]
   (clojure.core/when-let
    [v1647 (:name m1646)]
    (. bean1645 setName (clojure.core/str v1647)))
   bean1645))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.CreatePlatformEndpointRequest create-platform-endpoint-request
  [m1649]
  (clojure.core/let
   [bean1648
    (new
     com.amazonaws.services.sns.model.CreatePlatformEndpointRequest)]
   (clojure.core/when-let
    [v1650 (:token m1649)]
    (. bean1648 setToken (clojure.core/str v1650)))
   (clojure.core/when-let
    [v1650 (:platform-application-arn m1649)]
    (. bean1648 setPlatformApplicationArn (clojure.core/str v1650)))
   (clojure.core/when-let
    [v1650 (:custom-user-data m1649)]
    (. bean1648 setCustomUserData (clojure.core/str v1650)))
   (clojure.core/when-let
    [v1650 (:attributes m1649)]
    (.
     bean1648
     setAttributes
     (clojure.core/zipmap
      (clojure.core/map
       (clojure.core/fn [arg1651] (clojure.core/str arg1651))
       (clojure.core/keys v1650))
      (clojure.core/map
       (clojure.core/fn [arg1651] (clojure.core/str arg1651))
       (clojure.core/vals v1650)))))
   bean1648))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.RemovePermissionRequest remove-permission-request
  [m1653]
  (clojure.core/let
   [bean1652
    (new com.amazonaws.services.sns.model.RemovePermissionRequest)]
   (clojure.core/when-let
    [v1654 (:topic-arn m1653)]
    (. bean1652 setTopicArn (clojure.core/str v1654)))
   (clojure.core/when-let
    [v1654 (:label m1653)]
    (. bean1652 setLabel (clojure.core/str v1654)))
   bean1652))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.GetTopicAttributesRequest get-topic-attributes-request
  [m1656]
  (clojure.core/let
   [bean1655
    (new com.amazonaws.services.sns.model.GetTopicAttributesRequest)]
   (clojure.core/when-let
    [v1657 (:topic-arn m1656)]
    (. bean1655 setTopicArn (clojure.core/str v1657)))
   bean1655))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.SubscribeRequest subscribe-request
  [m1659]
  (clojure.core/let
   [bean1658 (new com.amazonaws.services.sns.model.SubscribeRequest)]
   (clojure.core/when-let
    [v1660 (:topic-arn m1659)]
    (. bean1658 setTopicArn (clojure.core/str v1660)))
   (clojure.core/when-let
    [v1660 (:protocol m1659)]
    (. bean1658 setProtocol (clojure.core/str v1660)))
   (clojure.core/when-let
    [v1660 (:endpoint m1659)]
    (. bean1658 setEndpoint (clojure.core/str v1660)))
   bean1658))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.DeleteEndpointRequest delete-endpoint-request
  [m1662]
  (clojure.core/let
   [bean1661
    (new com.amazonaws.services.sns.model.DeleteEndpointRequest)]
   (clojure.core/when-let
    [v1663 (:endpoint-arn m1662)]
    (. bean1661 setEndpointArn (clojure.core/str v1663)))
   bean1661))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.ListPlatformApplicationsRequest list-platform-applications-request
  [m1665]
  (clojure.core/let
   [bean1664
    (new
     com.amazonaws.services.sns.model.ListPlatformApplicationsRequest)]
   (clojure.core/when-let
    [v1666 (:next-token m1665)]
    (. bean1664 setNextToken (clojure.core/str v1666)))
   bean1664))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest set-platform-application-attributes-request
  [m1668]
  (clojure.core/let
   [bean1667
    (new
     com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest)]
   (clojure.core/when-let
    [v1669 (:platform-application-arn m1668)]
    (. bean1667 setPlatformApplicationArn (clojure.core/str v1669)))
   (clojure.core/when-let
    [v1669 (:attributes m1668)]
    (.
     bean1667
     setAttributes
     (clojure.core/zipmap
      (clojure.core/map
       (clojure.core/fn [arg1670] (clojure.core/str arg1670))
       (clojure.core/keys v1669))
      (clojure.core/map
       (clojure.core/fn [arg1670] (clojure.core/str arg1670))
       (clojure.core/vals v1669)))))
   bean1667))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.CreatePlatformApplicationRequest create-platform-application-request
  [m1672]
  (clojure.core/let
   [bean1671
    (new
     com.amazonaws.services.sns.model.CreatePlatformApplicationRequest)]
   (clojure.core/when-let
    [v1673 (:name m1672)]
    (. bean1671 setName (clojure.core/str v1673)))
   (clojure.core/when-let
    [v1673 (:platform m1672)]
    (. bean1671 setPlatform (clojure.core/str v1673)))
   (clojure.core/when-let
    [v1673 (:attributes m1672)]
    (.
     bean1671
     setAttributes
     (clojure.core/zipmap
      (clojure.core/map
       (clojure.core/fn [arg1674] (clojure.core/str arg1674))
       (clojure.core/keys v1673))
      (clojure.core/map
       (clojure.core/fn [arg1674] (clojure.core/str arg1674))
       (clojure.core/vals v1673)))))
   bean1671))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.SetEndpointAttributesRequest set-endpoint-attributes-request
  [m1676]
  (clojure.core/let
   [bean1675
    (new
     com.amazonaws.services.sns.model.SetEndpointAttributesRequest)]
   (clojure.core/when-let
    [v1677 (:endpoint-arn m1676)]
    (. bean1675 setEndpointArn (clojure.core/str v1677)))
   (clojure.core/when-let
    [v1677 (:attributes m1676)]
    (.
     bean1675
     setAttributes
     (clojure.core/zipmap
      (clojure.core/map
       (clojure.core/fn [arg1678] (clojure.core/str arg1678))
       (clojure.core/keys v1677))
      (clojure.core/map
       (clojure.core/fn [arg1678] (clojure.core/str arg1678))
       (clojure.core/vals v1677)))))
   bean1675))
 (clojure.core/defmulti
  sns
  (clojure.core/fn sns [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   sns
   :get-endpoint-attributes
   [m1679]
   (clojure.core/let
    [credentials1680 (:credentials m1679) args1681 (:args m1679)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1682
      (com.palletops.awaze.common/aws-client :sns credentials1680)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1682
       getEndpointAttributes
       (get-endpoint-attributes-request
        (clojure.core/nth args1681 0)))))))
  (clojure.core/defn
   get-endpoint-attributes-map
   {:arglists
    '[[credentials {:keys [request-metric-collector endpoint-arn]}]],
    :doc "Generate map for getEndpointAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-endpoint-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-endpoint-attributes
   {:arglists
    '[[credentials {:keys [request-metric-collector endpoint-arn]}]],
    :doc "Call getEndpointAttributes"}
   [credentials1684 & args1685]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1686
     (com.palletops.awaze.common/aws-client :sns credentials1684)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1686
      getEndpointAttributes
      (get-endpoint-attributes-request
       (clojure.core/nth args1685 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-platform-application-attributes
   [m1687]
   (clojure.core/let
    [credentials1688 (:credentials m1687) args1689 (:args m1687)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1690
      (com.palletops.awaze.common/aws-client :sns credentials1688)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1690
       getPlatformApplicationAttributes
       (get-platform-application-attributes-request
        (clojure.core/nth args1689 0)))))))
  (clojure.core/defn
   get-platform-application-attributes-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector platform-application-arn]}]],
    :doc "Generate map for getPlatformApplicationAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-platform-application-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-platform-application-attributes
   {:arglists
    '[[credentials
       {:keys [request-metric-collector platform-application-arn]}]],
    :doc "Call getPlatformApplicationAttributes"}
   [credentials1692 & args1693]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1694
     (com.palletops.awaze.common/aws-client :sns credentials1692)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1694
      getPlatformApplicationAttributes
      (get-platform-application-attributes-request
       (clojure.core/nth args1693 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-topic-attributes
   [m1695]
   (clojure.core/let
    [credentials1696 (:credentials m1695) args1697 (:args m1695)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1698
      (com.palletops.awaze.common/aws-client :sns credentials1696)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1698
       setTopicAttributes
       (set-topic-attributes-request
        (clojure.core/nth args1697 0)))))))
  (clojure.core/defn
   set-topic-attributes-map
   {:arglists
    '[[credentials
       {:keys
        [topic-arn
         request-metric-collector
         attribute-value
         attribute-name]}]],
    :doc "Generate map for setTopicAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-topic-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-topic-attributes
   {:arglists
    '[[credentials
       {:keys
        [topic-arn
         request-metric-collector
         attribute-value
         attribute-name]}]],
    :doc "Call setTopicAttributes"}
   [credentials1700 & args1701]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1702
     (com.palletops.awaze.common/aws-client :sns credentials1700)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1702
      setTopicAttributes
      (set-topic-attributes-request (clojure.core/nth args1701 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :add-permission
   [m1703]
   (clojure.core/let
    [credentials1704 (:credentials m1703) args1705 (:args m1703)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1706
      (com.palletops.awaze.common/aws-client :sns credentials1704)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1706
       addPermission
       (add-permission-request (clojure.core/nth args1705 0)))))))
  (clojure.core/defn
   add-permission-map
   {:arglists
    '[[credentials
       {:keys
        [topic-arn
         request-metric-collector
         label
         action-names
         awsaccount-ids]}]],
    :doc "Generate map for addPermission"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :add-permission,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   add-permission
   {:arglists
    '[[credentials
       {:keys
        [topic-arn
         request-metric-collector
         label
         action-names
         awsaccount-ids]}]],
    :doc "Call addPermission"}
   [credentials1708 & args1709]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1710
     (com.palletops.awaze.common/aws-client :sns credentials1708)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1710
      addPermission
      (add-permission-request (clojure.core/nth args1709 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-subscription-attributes
   [m1711]
   (clojure.core/let
    [credentials1712 (:credentials m1711) args1713 (:args m1711)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1714
      (com.palletops.awaze.common/aws-client :sns credentials1712)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1714
       getSubscriptionAttributes
       (get-subscription-attributes-request
        (clojure.core/nth args1713 0)))))))
  (clojure.core/defn
   get-subscription-attributes-map
   {:arglists
    '[[credentials
       {:keys [subscription-arn request-metric-collector]}]],
    :doc "Generate map for getSubscriptionAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-subscription-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-subscription-attributes
   {:arglists
    '[[credentials
       {:keys [subscription-arn request-metric-collector]}]],
    :doc "Call getSubscriptionAttributes"}
   [credentials1716 & args1717]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1718
     (com.palletops.awaze.common/aws-client :sns credentials1716)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1718
      getSubscriptionAttributes
      (get-subscription-attributes-request
       (clojure.core/nth args1717 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :confirm-subscription
   [m1719]
   (clojure.core/let
    [credentials1720 (:credentials m1719) args1721 (:args m1719)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1722
      (com.palletops.awaze.common/aws-client :sns credentials1720)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1722
       confirmSubscription
       (confirm-subscription-request
        (clojure.core/nth args1721 0)))))))
  (clojure.core/defn
   confirm-subscription-map
   {:arglists
    '[[credentials
       {:keys
        [topic-arn
         token
         request-metric-collector
         authenticate-on-unsubscribe]}]],
    :doc "Generate map for confirmSubscription"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :confirm-subscription,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   confirm-subscription
   {:arglists
    '[[credentials
       {:keys
        [topic-arn
         token
         request-metric-collector
         authenticate-on-unsubscribe]}]],
    :doc "Call confirmSubscription"}
   [credentials1724 & args1725]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1726
     (com.palletops.awaze.common/aws-client :sns credentials1724)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1726
      confirmSubscription
      (confirm-subscription-request (clojure.core/nth args1725 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-topic
   [m1727]
   (clojure.core/let
    [credentials1728 (:credentials m1727) args1729 (:args m1727)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1730
      (com.palletops.awaze.common/aws-client :sns credentials1728)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1730
       deleteTopic
       (delete-topic-request (clojure.core/nth args1729 0)))))))
  (clojure.core/defn
   delete-topic-map
   {:arglists
    '[[credentials {:keys [topic-arn request-metric-collector]}]],
    :doc "Generate map for deleteTopic"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :delete-topic,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-topic
   {:arglists
    '[[credentials {:keys [topic-arn request-metric-collector]}]],
    :doc "Call deleteTopic"}
   [credentials1732 & args1733]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1734
     (com.palletops.awaze.common/aws-client :sns credentials1732)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1734
      deleteTopic
      (delete-topic-request (clojure.core/nth args1733 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :publish
   [m1735]
   (clojure.core/let
    [credentials1736 (:credentials m1735) args1737 (:args m1735)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1738
      (com.palletops.awaze.common/aws-client :sns credentials1736)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1738
       publish
       (publish-request (clojure.core/nth args1737 0)))))))
  (clojure.core/defn
   publish-map
   {:arglists
    '[[credentials
       {:keys
        [topic-arn
         target-arn
         subject
         request-metric-collector
         message-structure
         message]}]],
    :doc "Generate map for publish"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :publish,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   publish
   {:arglists
    '[[credentials
       {:keys
        [topic-arn
         target-arn
         subject
         request-metric-collector
         message-structure
         message]}]],
    :doc "Call publish"}
   [credentials1740 & args1741]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1742
     (com.palletops.awaze.common/aws-client :sns credentials1740)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1742
      publish
      (publish-request (clojure.core/nth args1741 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-topics
   [m1743]
   (clojure.core/let
    [credentials1744 (:credentials m1743) args1745 (:args m1743)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1746
      (com.palletops.awaze.common/aws-client :sns credentials1744)]
     (clojure.core/case
      (clojure.core/count args1745)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.sns.AmazonSNSClient client1746
        listTopics))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.sns.AmazonSNSClient client1746
        listTopics
        (list-topics-request (clojure.core/nth args1745 0))))))))
  (clojure.core/defn
   list-topics-map
   {:arglists
    '[[credentials]
      [credentials {:keys [request-metric-collector next-token]}]],
    :doc "Generate map for listTopics, listTopics"}
   ([credentials__577__auto__]
    {:args [],
     :client :sns,
     :fn :list-topics,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-topics,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-topics
   {:arglists
    '[[credentials]
      [credentials {:keys [request-metric-collector next-token]}]],
    :doc "Call listTopics, listTopics"}
   [credentials1748 & args1749]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1750
     (com.palletops.awaze.common/aws-client :sns credentials1748)]
    (clojure.core/case
     (clojure.core/count args1749)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1750
       listTopics))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1750
       listTopics
       (list-topics-request (clojure.core/nth args1749 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions-by-topic
   [m1751]
   (clojure.core/let
    [credentials1752 (:credentials m1751) args1753 (:args m1751)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1754
      (com.palletops.awaze.common/aws-client :sns credentials1752)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1754
       listSubscriptionsByTopic
       (list-subscriptions-by-topic-request
        (clojure.core/nth args1753 0)))))))
  (clojure.core/defn
   list-subscriptions-by-topic-map
   {:arglists
    '[[credentials
       {:keys [topic-arn request-metric-collector next-token]}]],
    :doc "Generate map for listSubscriptionsByTopic"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-subscriptions-by-topic,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-subscriptions-by-topic
   {:arglists
    '[[credentials
       {:keys [topic-arn request-metric-collector next-token]}]],
    :doc "Call listSubscriptionsByTopic"}
   [credentials1756 & args1757]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1758
     (com.palletops.awaze.common/aws-client :sns credentials1756)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1758
      listSubscriptionsByTopic
      (list-subscriptions-by-topic-request
       (clojure.core/nth args1757 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-platform-application
   [m1759]
   (clojure.core/let
    [credentials1760 (:credentials m1759) args1761 (:args m1759)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1762
      (com.palletops.awaze.common/aws-client :sns credentials1760)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1762
       deletePlatformApplication
       (delete-platform-application-request
        (clojure.core/nth args1761 0)))))))
  (clojure.core/defn
   delete-platform-application-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector platform-application-arn]}]],
    :doc "Generate map for deletePlatformApplication"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :delete-platform-application,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-platform-application
   {:arglists
    '[[credentials
       {:keys [request-metric-collector platform-application-arn]}]],
    :doc "Call deletePlatformApplication"}
   [credentials1764 & args1765]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1766
     (com.palletops.awaze.common/aws-client :sns credentials1764)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1766
      deletePlatformApplication
      (delete-platform-application-request
       (clojure.core/nth args1765 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-endpoints-by-platform-application
   [m1767]
   (clojure.core/let
    [credentials1768 (:credentials m1767) args1769 (:args m1767)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1770
      (com.palletops.awaze.common/aws-client :sns credentials1768)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1770
       listEndpointsByPlatformApplication
       (list-endpoints-by-platform-application-request
        (clojure.core/nth args1769 0)))))))
  (clojure.core/defn
   list-endpoints-by-platform-application-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         platform-application-arn
         next-token]}]],
    :doc "Generate map for listEndpointsByPlatformApplication"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-endpoints-by-platform-application,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-endpoints-by-platform-application
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         platform-application-arn
         next-token]}]],
    :doc "Call listEndpointsByPlatformApplication"}
   [credentials1772 & args1773]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1774
     (com.palletops.awaze.common/aws-client :sns credentials1772)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1774
      listEndpointsByPlatformApplication
      (list-endpoints-by-platform-application-request
       (clojure.core/nth args1773 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :unsubscribe
   [m1775]
   (clojure.core/let
    [credentials1776 (:credentials m1775) args1777 (:args m1775)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1778
      (com.palletops.awaze.common/aws-client :sns credentials1776)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1778
       unsubscribe
       (unsubscribe-request (clojure.core/nth args1777 0)))))))
  (clojure.core/defn
   unsubscribe-map
   {:arglists
    '[[credentials
       {:keys [subscription-arn request-metric-collector]}]],
    :doc "Generate map for unsubscribe"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :unsubscribe,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   unsubscribe
   {:arglists
    '[[credentials
       {:keys [subscription-arn request-metric-collector]}]],
    :doc "Call unsubscribe"}
   [credentials1780 & args1781]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1782
     (com.palletops.awaze.common/aws-client :sns credentials1780)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1782
      unsubscribe
      (unsubscribe-request (clojure.core/nth args1781 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-subscription-attributes
   [m1783]
   (clojure.core/let
    [credentials1784 (:credentials m1783) args1785 (:args m1783)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1786
      (com.palletops.awaze.common/aws-client :sns credentials1784)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1786
       setSubscriptionAttributes
       (set-subscription-attributes-request
        (clojure.core/nth args1785 0)))))))
  (clojure.core/defn
   set-subscription-attributes-map
   {:arglists
    '[[credentials
       {:keys
        [subscription-arn
         request-metric-collector
         attribute-value
         attribute-name]}]],
    :doc "Generate map for setSubscriptionAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-subscription-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-subscription-attributes
   {:arglists
    '[[credentials
       {:keys
        [subscription-arn
         request-metric-collector
         attribute-value
         attribute-name]}]],
    :doc "Call setSubscriptionAttributes"}
   [credentials1788 & args1789]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1790
     (com.palletops.awaze.common/aws-client :sns credentials1788)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1790
      setSubscriptionAttributes
      (set-subscription-attributes-request
       (clojure.core/nth args1789 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions
   [m1791]
   (clojure.core/let
    [credentials1792 (:credentials m1791) args1793 (:args m1791)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1794
      (com.palletops.awaze.common/aws-client :sns credentials1792)]
     (clojure.core/case
      (clojure.core/count args1793)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.sns.AmazonSNSClient client1794
        listSubscriptions))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.sns.AmazonSNSClient client1794
        listSubscriptions
        (list-subscriptions-request
         (clojure.core/nth args1793 0))))))))
  (clojure.core/defn
   list-subscriptions-map
   {:arglists
    '[[credentials]
      [credentials {:keys [request-metric-collector next-token]}]],
    :doc "Generate map for listSubscriptions, listSubscriptions"}
   ([credentials__577__auto__]
    {:args [],
     :client :sns,
     :fn :list-subscriptions,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-subscriptions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-subscriptions
   {:arglists
    '[[credentials]
      [credentials {:keys [request-metric-collector next-token]}]],
    :doc "Call listSubscriptions, listSubscriptions"}
   [credentials1796 & args1797]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1798
     (com.palletops.awaze.common/aws-client :sns credentials1796)]
    (clojure.core/case
     (clojure.core/count args1797)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1798
       listSubscriptions))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1798
       listSubscriptions
       (list-subscriptions-request (clojure.core/nth args1797 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-topic
   [m1799]
   (clojure.core/let
    [credentials1800 (:credentials m1799) args1801 (:args m1799)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1802
      (com.palletops.awaze.common/aws-client :sns credentials1800)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1802
       createTopic
       (create-topic-request (clojure.core/nth args1801 0)))))))
  (clojure.core/defn
   create-topic-map
   {:arglists '[[credentials {:keys [request-metric-collector name]}]],
    :doc "Generate map for createTopic"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :create-topic,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-topic
   {:arglists '[[credentials {:keys [request-metric-collector name]}]],
    :doc "Call createTopic"}
   [credentials1804 & args1805]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1806
     (com.palletops.awaze.common/aws-client :sns credentials1804)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1806
      createTopic
      (create-topic-request (clojure.core/nth args1805 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-endpoint
   [m1807]
   (clojure.core/let
    [credentials1808 (:credentials m1807) args1809 (:args m1807)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1810
      (com.palletops.awaze.common/aws-client :sns credentials1808)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1810
       createPlatformEndpoint
       (create-platform-endpoint-request
        (clojure.core/nth args1809 0)))))))
  (clojure.core/defn
   create-platform-endpoint-map
   {:arglists
    '[[credentials
       {:keys
        [token
         request-metric-collector
         platform-application-arn
         custom-user-data
         attributes]}]],
    :doc "Generate map for createPlatformEndpoint"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :create-platform-endpoint,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-platform-endpoint
   {:arglists
    '[[credentials
       {:keys
        [token
         request-metric-collector
         platform-application-arn
         custom-user-data
         attributes]}]],
    :doc "Call createPlatformEndpoint"}
   [credentials1812 & args1813]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1814
     (com.palletops.awaze.common/aws-client :sns credentials1812)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1814
      createPlatformEndpoint
      (create-platform-endpoint-request
       (clojure.core/nth args1813 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :remove-permission
   [m1815]
   (clojure.core/let
    [credentials1816 (:credentials m1815) args1817 (:args m1815)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1818
      (com.palletops.awaze.common/aws-client :sns credentials1816)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1818
       removePermission
       (remove-permission-request (clojure.core/nth args1817 0)))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists
    '[[credentials
       {:keys [topic-arn request-metric-collector label]}]],
    :doc "Generate map for removePermission"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :remove-permission,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   remove-permission
   {:arglists
    '[[credentials
       {:keys [topic-arn request-metric-collector label]}]],
    :doc "Call removePermission"}
   [credentials1820 & args1821]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1822
     (com.palletops.awaze.common/aws-client :sns credentials1820)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1822
      removePermission
      (remove-permission-request (clojure.core/nth args1821 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-topic-attributes
   [m1823]
   (clojure.core/let
    [credentials1824 (:credentials m1823) args1825 (:args m1823)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1826
      (com.palletops.awaze.common/aws-client :sns credentials1824)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1826
       getTopicAttributes
       (get-topic-attributes-request
        (clojure.core/nth args1825 0)))))))
  (clojure.core/defn
   get-topic-attributes-map
   {:arglists
    '[[credentials {:keys [topic-arn request-metric-collector]}]],
    :doc "Generate map for getTopicAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-topic-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-topic-attributes
   {:arglists
    '[[credentials {:keys [topic-arn request-metric-collector]}]],
    :doc "Call getTopicAttributes"}
   [credentials1828 & args1829]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1830
     (com.palletops.awaze.common/aws-client :sns credentials1828)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1830
      getTopicAttributes
      (get-topic-attributes-request (clojure.core/nth args1829 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :subscribe
   [m1831]
   (clojure.core/let
    [credentials1832 (:credentials m1831) args1833 (:args m1831)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1834
      (com.palletops.awaze.common/aws-client :sns credentials1832)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1834
       subscribe
       (subscribe-request (clojure.core/nth args1833 0)))))))
  (clojure.core/defn
   subscribe-map
   {:arglists
    '[[credentials
       {:keys
        [topic-arn request-metric-collector protocol endpoint]}]],
    :doc "Generate map for subscribe"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :subscribe,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   subscribe
   {:arglists
    '[[credentials
       {:keys
        [topic-arn request-metric-collector protocol endpoint]}]],
    :doc "Call subscribe"}
   [credentials1836 & args1837]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1838
     (com.palletops.awaze.common/aws-client :sns credentials1836)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1838
      subscribe
      (subscribe-request (clojure.core/nth args1837 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-endpoint
   [m1839]
   (clojure.core/let
    [credentials1840 (:credentials m1839) args1841 (:args m1839)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1842
      (com.palletops.awaze.common/aws-client :sns credentials1840)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1842
       deleteEndpoint
       (delete-endpoint-request (clojure.core/nth args1841 0)))))))
  (clojure.core/defn
   delete-endpoint-map
   {:arglists
    '[[credentials {:keys [request-metric-collector endpoint-arn]}]],
    :doc "Generate map for deleteEndpoint"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :delete-endpoint,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-endpoint
   {:arglists
    '[[credentials {:keys [request-metric-collector endpoint-arn]}]],
    :doc "Call deleteEndpoint"}
   [credentials1844 & args1845]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1846
     (com.palletops.awaze.common/aws-client :sns credentials1844)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1846
      deleteEndpoint
      (delete-endpoint-request (clojure.core/nth args1845 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-platform-applications
   [m1847]
   (clojure.core/let
    [credentials1848 (:credentials m1847) args1849 (:args m1847)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1850
      (com.palletops.awaze.common/aws-client :sns credentials1848)]
     (clojure.core/case
      (clojure.core/count args1849)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.sns.AmazonSNSClient client1850
        listPlatformApplications))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.sns.AmazonSNSClient client1850
        listPlatformApplications
        (list-platform-applications-request
         (clojure.core/nth args1849 0))))))))
  (clojure.core/defn
   list-platform-applications-map
   {:arglists
    '[[credentials]
      [credentials {:keys [request-metric-collector next-token]}]],
    :doc
    "Generate map for listPlatformApplications, listPlatformApplications"}
   ([credentials__577__auto__]
    {:args [],
     :client :sns,
     :fn :list-platform-applications,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-platform-applications,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-platform-applications
   {:arglists
    '[[credentials]
      [credentials {:keys [request-metric-collector next-token]}]],
    :doc "Call listPlatformApplications, listPlatformApplications"}
   [credentials1852 & args1853]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1854
     (com.palletops.awaze.common/aws-client :sns credentials1852)]
    (clojure.core/case
     (clojure.core/count args1853)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1854
       listPlatformApplications))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1854
       listPlatformApplications
       (list-platform-applications-request
        (clojure.core/nth args1853 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :set-platform-application-attributes
   [m1855]
   (clojure.core/let
    [credentials1856 (:credentials m1855) args1857 (:args m1855)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1858
      (com.palletops.awaze.common/aws-client :sns credentials1856)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1858
       setPlatformApplicationAttributes
       (set-platform-application-attributes-request
        (clojure.core/nth args1857 0)))))))
  (clojure.core/defn
   set-platform-application-attributes-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         platform-application-arn
         attributes]}]],
    :doc "Generate map for setPlatformApplicationAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-platform-application-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-platform-application-attributes
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         platform-application-arn
         attributes]}]],
    :doc "Call setPlatformApplicationAttributes"}
   [credentials1860 & args1861]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1862
     (com.palletops.awaze.common/aws-client :sns credentials1860)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1862
      setPlatformApplicationAttributes
      (set-platform-application-attributes-request
       (clojure.core/nth args1861 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-application
   [m1863]
   (clojure.core/let
    [credentials1864 (:credentials m1863) args1865 (:args m1863)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1866
      (com.palletops.awaze.common/aws-client :sns credentials1864)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1866
       createPlatformApplication
       (create-platform-application-request
        (clojure.core/nth args1865 0)))))))
  (clojure.core/defn
   create-platform-application-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector platform name attributes]}]],
    :doc "Generate map for createPlatformApplication"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :create-platform-application,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-platform-application
   {:arglists
    '[[credentials
       {:keys [request-metric-collector platform name attributes]}]],
    :doc "Call createPlatformApplication"}
   [credentials1868 & args1869]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1870
     (com.palletops.awaze.common/aws-client :sns credentials1868)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1870
      createPlatformApplication
      (create-platform-application-request
       (clojure.core/nth args1869 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-endpoint-attributes
   [m1871]
   (clojure.core/let
    [credentials1872 (:credentials m1871) args1873 (:args m1871)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client1874
      (com.palletops.awaze.common/aws-client :sns credentials1872)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client1874
       setEndpointAttributes
       (set-endpoint-attributes-request
        (clojure.core/nth args1873 0)))))))
  (clojure.core/defn
   set-endpoint-attributes-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector endpoint-arn attributes]}]],
    :doc "Generate map for setEndpointAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-endpoint-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-endpoint-attributes
   {:arglists
    '[[credentials
       {:keys [request-metric-collector endpoint-arn attributes]}]],
    :doc "Call setEndpointAttributes"}
   [credentials1876 & args1877]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client1878
     (com.palletops.awaze.common/aws-client :sns credentials1876)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client1878
      setEndpointAttributes
      (set-endpoint-attributes-request
       (clojure.core/nth args1877 0))))))))
