(ns com.palletops.awaze.simpleemail (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpleemail
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.Content content
  [m650]
  (clojure.core/let
   [bean649 (new com.amazonaws.services.simpleemail.model.Content)]
   (clojure.core/when-let
    [v651 (:charset m650)]
    (. bean649 setCharset (clojure.core/str v651)))
   (clojure.core/when-let
    [v651 (:data m650)]
    (. bean649 setData (clojure.core/str v651)))
   bean649))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.Body body
  [m653]
  (clojure.core/let
   [bean652 (new com.amazonaws.services.simpleemail.model.Body)]
   (clojure.core/when-let
    [v654 (:text m653)]
    (. bean652 setText (content v654)))
   (clojure.core/when-let
    [v654 (:html m653)]
    (. bean652 setHtml (content v654)))
   bean652))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.Destination destination
  [m656]
  (clojure.core/let
   [bean655 (new com.amazonaws.services.simpleemail.model.Destination)]
   (clojure.core/when-let
    [v657 (:to-addresses m656)]
    (.
     bean655
     setToAddresses
     (clojure.core/map
      (clojure.core/fn [arg658] (clojure.core/str arg658))
      v657)))
   (clojure.core/when-let
    [v657 (:cc-addresses m656)]
    (.
     bean655
     setCcAddresses
     (clojure.core/map
      (clojure.core/fn [arg659] (clojure.core/str arg659))
      v657)))
   (clojure.core/when-let
    [v657 (:bcc-addresses m656)]
    (.
     bean655
     setBccAddresses
     (clojure.core/map
      (clojure.core/fn [arg660] (clojure.core/str arg660))
      v657)))
   bean655))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.Message message
  [m662]
  (clojure.core/let
   [bean661 (new com.amazonaws.services.simpleemail.model.Message)]
   (clojure.core/when-let
    [v663 (:subject m662)]
    (. bean661 setSubject (content v663)))
   (clojure.core/when-let
    [v663 (:body m662)]
    (. bean661 setBody (body v663)))
   bean661))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.RawMessage raw-message
  [m665]
  (clojure.core/let
   [bean664
    (new
     com.amazonaws.services.simpleemail.model.RawMessage)]Couldn't find coercion function for java.nio.ByteBuffer of type java.lang.Class java.nio.ByteBuffer

   (clojure.core/when-let [v666 (:data m665)] (. bean664 setData v666))
   bean664))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.IdentityType identity-type
  [m668]
  (java.lang.Enum/valueOf
   com.amazonaws.services.simpleemail.model.IdentityType
   (clojure.core/name m668)))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.NotificationType notification-type
  [m671]
  (java.lang.Enum/valueOf
   com.amazonaws.services.simpleemail.model.NotificationType
   (clojure.core/name m671)))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.SendEmailRequest send-email-request
  [m674]
  (clojure.core/let
   [bean673
    (new com.amazonaws.services.simpleemail.model.SendEmailRequest)]
   (clojure.core/when-let
    [v675 (:source m674)]
    (. bean673 setSource (clojure.core/str v675)))
   (clojure.core/when-let
    [v675 (:destination m674)]
    (. bean673 setDestination (destination v675)))
   (clojure.core/when-let
    [v675 (:message m674)]
    (. bean673 setMessage (message v675)))
   (clojure.core/when-let
    [v675 (:reply-to-addresses m674)]
    (.
     bean673
     setReplyToAddresses
     (clojure.core/map
      (clojure.core/fn [arg676] (clojure.core/str arg676))
      v675)))
   (clojure.core/when-let
    [v675 (:return-path m674)]
    (. bean673 setReturnPath (clojure.core/str v675)))
   bean673))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest list-verified-email-addresses-request
  [m678]
  (clojure.core/let
   [bean677
    (new
     com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest)]
   bean677))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest get-send-statistics-request
  [m681]
  (clojure.core/let
   [bean680
    (new
     com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest)]
   bean680))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest delete-verified-email-address-request
  [m684]
  (clojure.core/let
   [bean683
    (new
     com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest)]
   (clojure.core/when-let
    [v685 (:email-address m684)]
    (. bean683 setEmailAddress (clojure.core/str v685)))
   bean683))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest set-identity-dkim-enabled-request
  [m687]
  (clojure.core/let
   [bean686
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest)]
   (clojure.core/when-let
    [v688 (:identity m687)]
    (. bean686 setIdentity (clojure.core/str v688)))
   (clojure.core/when-let
    [v688 (:dkim-enabled m687)]
    (. bean686 setDkimEnabled (clojure.core/boolean v688)))
   bean686))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest set-identity-feedback-forwarding-enabled-request
  [m690]
  (clojure.core/let
   [bean689
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest)]
   (clojure.core/when-let
    [v691 (:identity m690)]
    (. bean689 setIdentity (clojure.core/str v691)))
   (clojure.core/when-let
    [v691 (:forwarding-enabled m690)]
    (. bean689 setForwardingEnabled (clojure.core/boolean v691)))
   bean689))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.SendRawEmailRequest send-raw-email-request
  [m693]
  (clojure.core/let
   [bean692
    (new com.amazonaws.services.simpleemail.model.SendRawEmailRequest)]
   (clojure.core/when-let
    [v694 (:source m693)]
    (. bean692 setSource (clojure.core/str v694)))
   (clojure.core/when-let
    [v694 (:destinations m693)]
    (.
     bean692
     setDestinations
     (clojure.core/map
      (clojure.core/fn [arg695] (clojure.core/str arg695))
      v694)))
   (clojure.core/when-let
    [v694 (:raw-message m693)]
    (. bean692 setRawMessage (raw-message v694)))
   bean692))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest get-identity-notification-attributes-request
  [m697]
  (clojure.core/let
   [bean696
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest)]
   (clojure.core/when-let
    [v698 (:identities m697)]
    (.
     bean696
     setIdentities
     (clojure.core/map
      (clojure.core/fn [arg699] (clojure.core/str arg699))
      v698)))
   bean696))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.ListIdentitiesRequest list-identities-request
  [m701]
  (clojure.core/let
   [bean700
    (new
     com.amazonaws.services.simpleemail.model.ListIdentitiesRequest)]
   (clojure.core/when-let
    [v702 (:next-token m701)]
    (. bean700 setNextToken (clojure.core/str v702)))
   (clojure.core/when-let
    [v702 (:identity-type m701)]
    (. bean700 setIdentityType (identity-type v702)))
   (clojure.core/when-let
    [v702 (:identity-type m701)]
    (. bean700 setIdentityType (clojure.core/str v702)))
   (clojure.core/when-let
    [v702 (:max-items m701)]
    (. bean700 setMaxItems (clojure.core/int v702)))
   bean700))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest get-identity-dkim-attributes-request
  [m704]
  (clojure.core/let
   [bean703
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest)]
   (clojure.core/when-let
    [v705 (:identities m704)]
    (.
     bean703
     setIdentities
     (clojure.core/map
      (clojure.core/fn [arg706] (clojure.core/str arg706))
      v705)))
   bean703))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest verify-domain-dkim-request
  [m708]
  (clojure.core/let
   [bean707
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest)]
   (clojure.core/when-let
    [v709 (:domain m708)]
    (. bean707 setDomain (clojure.core/str v709)))
   bean707))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest verify-email-address-request
  [m711]
  (clojure.core/let
   [bean710
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest)]
   (clojure.core/when-let
    [v712 (:email-address m711)]
    (. bean710 setEmailAddress (clojure.core/str v712)))
   bean710))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest set-identity-notification-topic-request
  [m714]
  (clojure.core/let
   [bean713
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest)]
   (clojure.core/when-let
    [v715 (:identity m714)]
    (. bean713 setIdentity (clojure.core/str v715)))
   (clojure.core/when-let
    [v715 (:notification-type m714)]
    (. bean713 setNotificationType (notification-type v715)))
   (clojure.core/when-let
    [v715 (:notification-type m714)]
    (. bean713 setNotificationType (clojure.core/str v715)))
   (clojure.core/when-let
    [v715 (:sns-topic m714)]
    (. bean713 setSnsTopic (clojure.core/str v715)))
   bean713))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest get-identity-verification-attributes-request
  [m717]
  (clojure.core/let
   [bean716
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest)]
   (clojure.core/when-let
    [v718 (:identities m717)]
    (.
     bean716
     setIdentities
     (clojure.core/map
      (clojure.core/fn [arg719] (clojure.core/str arg719))
      v718)))
   bean716))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest verify-domain-identity-request
  [m721]
  (clojure.core/let
   [bean720
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest)]
   (clojure.core/when-let
    [v722 (:domain m721)]
    (. bean720 setDomain (clojure.core/str v722)))
   bean720))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.GetSendQuotaRequest get-send-quota-request
  [m724]
  (clojure.core/let
   [bean723
    (new com.amazonaws.services.simpleemail.model.GetSendQuotaRequest)]
   bean723))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.DeleteIdentityRequest delete-identity-request
  [m727]
  (clojure.core/let
   [bean726
    (new
     com.amazonaws.services.simpleemail.model.DeleteIdentityRequest)]
   (clojure.core/when-let
    [v728 (:identity m727)]
    (. bean726 setIdentity (clojure.core/str v728)))
   bean726))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest verify-email-identity-request
  [m730]
  (clojure.core/let
   [bean729
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest)]
   (clojure.core/when-let
    [v731 (:email-address m730)]
    (. bean729 setEmailAddress (clojure.core/str v731)))
   bean729))
 (clojure.core/defmulti
  simpleemail
  (clojure.core/fn simpleemail [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-email
   [m732]
   (clojure.core/let
    [credentials733 (:credentials m732) args734 (:args m732)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client735
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials733)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client735
       sendEmail
       (send-email-request (clojure.core/nth args734 0)))))))
  (clojure.core/defn
   send-email-map
   {:arglists
    '[[credentials
       {:keys
        [source
         return-path
         request-metric-collector
         reply-to-addresses
         message
         destination]}]],
    :doc "Generate map for sendEmail"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :send-email,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   send-email
   {:arglists
    '[[credentials
       {:keys
        [source
         return-path
         request-metric-collector
         reply-to-addresses
         message
         destination]}]],
    :doc "Call sendEmail"}
   [credentials737 & args738]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client739
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials737)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client739
      sendEmail
      (send-email-request (clojure.core/nth args738 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-verified-email-addresses
   [m740]
   (clojure.core/let
    [credentials741 (:credentials m740) args742 (:args m740)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client743
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials741)]
     (clojure.core/case
      (clojure.core/count args742)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client743
        listVerifiedEmailAddresses))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client743
        listVerifiedEmailAddresses
        (list-verified-email-addresses-request
         (clojure.core/nth args742 0))))))))
  (clojure.core/defn
   list-verified-email-addresses-map
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc
    "Generate map for listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   ([credentials__577__auto__]
    {:args [],
     :client :simpleemail,
     :fn :list-verified-email-addresses,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :list-verified-email-addresses,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-verified-email-addresses
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc "Call listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   [credentials745 & args746]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client747
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials745)]
    (clojure.core/case
     (clojure.core/count args746)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client747
       listVerifiedEmailAddresses))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client747
       listVerifiedEmailAddresses
       (list-verified-email-addresses-request
        (clojure.core/nth args746 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-statistics
   [m748]
   (clojure.core/let
    [credentials749 (:credentials m748) args750 (:args m748)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client751
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials749)]
     (clojure.core/case
      (clojure.core/count args750)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client751
        getSendStatistics
        (get-send-statistics-request (clojure.core/nth args750 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client751
        getSendStatistics))))))
  (clojure.core/defn
   get-send-statistics-map
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc "Generate map for getSendStatistics, getSendStatistics"}
   ([credentials__577__auto__]
    {:args [],
     :client :simpleemail,
     :fn :get-send-statistics,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-send-statistics,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-send-statistics
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc "Call getSendStatistics, getSendStatistics"}
   [credentials753 & args754]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client755
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials753)]
    (clojure.core/case
     (clojure.core/count args754)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client755
       getSendStatistics
       (get-send-statistics-request (clojure.core/nth args754 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client755
       getSendStatistics))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-verified-email-address
   [m756]
   (clojure.core/let
    [credentials757 (:credentials m756) args758 (:args m756)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client759
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials757)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client759
       deleteVerifiedEmailAddress
       (delete-verified-email-address-request
        (clojure.core/nth args758 0)))))))
  (clojure.core/defn
   delete-verified-email-address-map
   {:arglists
    '[[credentials {:keys [request-metric-collector email-address]}]],
    :doc "Generate map for deleteVerifiedEmailAddress"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :delete-verified-email-address,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-verified-email-address
   {:arglists
    '[[credentials {:keys [request-metric-collector email-address]}]],
    :doc "Call deleteVerifiedEmailAddress"}
   [credentials761 & args762]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client763
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials761)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client763
      deleteVerifiedEmailAddress
      (delete-verified-email-address-request
       (clojure.core/nth args762 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-dkim-enabled
   [m764]
   (clojure.core/let
    [credentials765 (:credentials m764) args766 (:args m764)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client767
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials765)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client767
       setIdentityDkimEnabled
       (set-identity-dkim-enabled-request
        (clojure.core/nth args766 0)))))))
  (clojure.core/defn
   set-identity-dkim-enabled-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector identity dkim-enabled]}]],
    :doc "Generate map for setIdentityDkimEnabled"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :set-identity-dkim-enabled,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-identity-dkim-enabled
   {:arglists
    '[[credentials
       {:keys [request-metric-collector identity dkim-enabled]}]],
    :doc "Call setIdentityDkimEnabled"}
   [credentials769 & args770]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client771
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials769)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client771
      setIdentityDkimEnabled
      (set-identity-dkim-enabled-request
       (clojure.core/nth args770 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-feedback-forwarding-enabled
   [m772]
   (clojure.core/let
    [credentials773 (:credentials m772) args774 (:args m772)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client775
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials773)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client775
       setIdentityFeedbackForwardingEnabled
       (set-identity-feedback-forwarding-enabled-request
        (clojure.core/nth args774 0)))))))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector identity forwarding-enabled]}]],
    :doc "Generate map for setIdentityFeedbackForwardingEnabled"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :set-identity-feedback-forwarding-enabled,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector identity forwarding-enabled]}]],
    :doc "Call setIdentityFeedbackForwardingEnabled"}
   [credentials777 & args778]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client779
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials777)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client779
      setIdentityFeedbackForwardingEnabled
      (set-identity-feedback-forwarding-enabled-request
       (clojure.core/nth args778 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-raw-email
   [m780]
   (clojure.core/let
    [credentials781 (:credentials m780) args782 (:args m780)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client783
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials781)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client783
       sendRawEmail
       (send-raw-email-request (clojure.core/nth args782 0)))))))
  (clojure.core/defn
   send-raw-email-map
   {:arglists
    '[[credentials
       {:keys
        [source request-metric-collector raw-message destinations]}]],
    :doc "Generate map for sendRawEmail"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :send-raw-email,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   send-raw-email
   {:arglists
    '[[credentials
       {:keys
        [source request-metric-collector raw-message destinations]}]],
    :doc "Call sendRawEmail"}
   [credentials785 & args786]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client787
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials785)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client787
      sendRawEmail
      (send-raw-email-request (clojure.core/nth args786 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-notification-attributes
   [m788]
   (clojure.core/let
    [credentials789 (:credentials m788) args790 (:args m788)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client791
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials789)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client791
       getIdentityNotificationAttributes
       (get-identity-notification-attributes-request
        (clojure.core/nth args790 0)))))))
  (clojure.core/defn
   get-identity-notification-attributes-map
   {:arglists
    '[[credentials {:keys [request-metric-collector identities]}]],
    :doc "Generate map for getIdentityNotificationAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-identity-notification-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-identity-notification-attributes
   {:arglists
    '[[credentials {:keys [request-metric-collector identities]}]],
    :doc "Call getIdentityNotificationAttributes"}
   [credentials793 & args794]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client795
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials793)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client795
      getIdentityNotificationAttributes
      (get-identity-notification-attributes-request
       (clojure.core/nth args794 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-identities
   [m796]
   (clojure.core/let
    [credentials797 (:credentials m796) args798 (:args m796)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client799
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials797)]
     (clojure.core/case
      (clojure.core/count args798)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client799
        listIdentities))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client799
        listIdentities
        (list-identities-request (clojure.core/nth args798 0))))))))
  (clojure.core/defn
   list-identities-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         next-token
         max-items
         identity-type]}]],
    :doc "Generate map for listIdentities, listIdentities"}
   ([credentials__577__auto__]
    {:args [],
     :client :simpleemail,
     :fn :list-identities,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :list-identities,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-identities
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         next-token
         max-items
         identity-type]}]],
    :doc "Call listIdentities, listIdentities"}
   [credentials801 & args802]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client803
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials801)]
    (clojure.core/case
     (clojure.core/count args802)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client803
       listIdentities))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client803
       listIdentities
       (list-identities-request (clojure.core/nth args802 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-dkim-attributes
   [m804]
   (clojure.core/let
    [credentials805 (:credentials m804) args806 (:args m804)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client807
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials805)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client807
       getIdentityDkimAttributes
       (get-identity-dkim-attributes-request
        (clojure.core/nth args806 0)))))))
  (clojure.core/defn
   get-identity-dkim-attributes-map
   {:arglists
    '[[credentials {:keys [request-metric-collector identities]}]],
    :doc "Generate map for getIdentityDkimAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-identity-dkim-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-identity-dkim-attributes
   {:arglists
    '[[credentials {:keys [request-metric-collector identities]}]],
    :doc "Call getIdentityDkimAttributes"}
   [credentials809 & args810]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client811
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials809)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client811
      getIdentityDkimAttributes
      (get-identity-dkim-attributes-request
       (clojure.core/nth args810 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-dkim
   [m812]
   (clojure.core/let
    [credentials813 (:credentials m812) args814 (:args m812)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client815
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials813)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client815
       verifyDomainDkim
       (verify-domain-dkim-request (clojure.core/nth args814 0)))))))
  (clojure.core/defn
   verify-domain-dkim-map
   {:arglists
    '[[credentials {:keys [request-metric-collector domain]}]],
    :doc "Generate map for verifyDomainDkim"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-domain-dkim,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   verify-domain-dkim
   {:arglists
    '[[credentials {:keys [request-metric-collector domain]}]],
    :doc "Call verifyDomainDkim"}
   [credentials817 & args818]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client819
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials817)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client819
      verifyDomainDkim
      (verify-domain-dkim-request (clojure.core/nth args818 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-address
   [m820]
   (clojure.core/let
    [credentials821 (:credentials m820) args822 (:args m820)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client823
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials821)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client823
       verifyEmailAddress
       (verify-email-address-request (clojure.core/nth args822 0)))))))
  (clojure.core/defn
   verify-email-address-map
   {:arglists
    '[[credentials {:keys [request-metric-collector email-address]}]],
    :doc "Generate map for verifyEmailAddress"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-email-address,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   verify-email-address
   {:arglists
    '[[credentials {:keys [request-metric-collector email-address]}]],
    :doc "Call verifyEmailAddress"}
   [credentials825 & args826]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client827
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials825)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client827
      verifyEmailAddress
      (verify-email-address-request (clojure.core/nth args826 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-notification-topic
   [m828]
   (clojure.core/let
    [credentials829 (:credentials m828) args830 (:args m828)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client831
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials829)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client831
       setIdentityNotificationTopic
       (set-identity-notification-topic-request
        (clojure.core/nth args830 0)))))))
  (clojure.core/defn
   set-identity-notification-topic-map
   {:arglists
    '[[credentials
       {:keys
        [sns-topic
         request-metric-collector
         notification-type
         identity]}]],
    :doc "Generate map for setIdentityNotificationTopic"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :set-identity-notification-topic,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-identity-notification-topic
   {:arglists
    '[[credentials
       {:keys
        [sns-topic
         request-metric-collector
         notification-type
         identity]}]],
    :doc "Call setIdentityNotificationTopic"}
   [credentials833 & args834]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client835
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials833)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client835
      setIdentityNotificationTopic
      (set-identity-notification-topic-request
       (clojure.core/nth args834 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-verification-attributes
   [m836]
   (clojure.core/let
    [credentials837 (:credentials m836) args838 (:args m836)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client839
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials837)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client839
       getIdentityVerificationAttributes
       (get-identity-verification-attributes-request
        (clojure.core/nth args838 0)))))))
  (clojure.core/defn
   get-identity-verification-attributes-map
   {:arglists
    '[[credentials {:keys [request-metric-collector identities]}]],
    :doc "Generate map for getIdentityVerificationAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-identity-verification-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-identity-verification-attributes
   {:arglists
    '[[credentials {:keys [request-metric-collector identities]}]],
    :doc "Call getIdentityVerificationAttributes"}
   [credentials841 & args842]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client843
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials841)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client843
      getIdentityVerificationAttributes
      (get-identity-verification-attributes-request
       (clojure.core/nth args842 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-identity
   [m844]
   (clojure.core/let
    [credentials845 (:credentials m844) args846 (:args m844)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client847
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials845)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client847
       verifyDomainIdentity
       (verify-domain-identity-request
        (clojure.core/nth args846 0)))))))
  (clojure.core/defn
   verify-domain-identity-map
   {:arglists
    '[[credentials {:keys [request-metric-collector domain]}]],
    :doc "Generate map for verifyDomainIdentity"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-domain-identity,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   verify-domain-identity
   {:arglists
    '[[credentials {:keys [request-metric-collector domain]}]],
    :doc "Call verifyDomainIdentity"}
   [credentials849 & args850]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client851
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials849)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client851
      verifyDomainIdentity
      (verify-domain-identity-request
       (clojure.core/nth args850 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-quota
   [m852]
   (clojure.core/let
    [credentials853 (:credentials m852) args854 (:args m852)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client855
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials853)]
     (clojure.core/case
      (clojure.core/count args854)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client855
        getSendQuota
        (get-send-quota-request (clojure.core/nth args854 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client855
        getSendQuota))))))
  (clojure.core/defn
   get-send-quota-map
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc "Generate map for getSendQuota, getSendQuota"}
   ([credentials__577__auto__]
    {:args [],
     :client :simpleemail,
     :fn :get-send-quota,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-send-quota,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-send-quota
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc "Call getSendQuota, getSendQuota"}
   [credentials857 & args858]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client859
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials857)]
    (clojure.core/case
     (clojure.core/count args858)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client859
       getSendQuota
       (get-send-quota-request (clojure.core/nth args858 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client859
       getSendQuota))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-identity
   [m860]
   (clojure.core/let
    [credentials861 (:credentials m860) args862 (:args m860)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client863
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials861)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client863
       deleteIdentity
       (delete-identity-request (clojure.core/nth args862 0)))))))
  (clojure.core/defn
   delete-identity-map
   {:arglists
    '[[credentials {:keys [request-metric-collector identity]}]],
    :doc "Generate map for deleteIdentity"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :delete-identity,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-identity
   {:arglists
    '[[credentials {:keys [request-metric-collector identity]}]],
    :doc "Call deleteIdentity"}
   [credentials865 & args866]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client867
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials865)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client867
      deleteIdentity
      (delete-identity-request (clojure.core/nth args866 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-identity
   [m868]
   (clojure.core/let
    [credentials869 (:credentials m868) args870 (:args m868)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client871
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials869)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client871
       verifyEmailIdentity
       (verify-email-identity-request
        (clojure.core/nth args870 0)))))))
  (clojure.core/defn
   verify-email-identity-map
   {:arglists
    '[[credentials {:keys [request-metric-collector email-address]}]],
    :doc "Generate map for verifyEmailIdentity"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-email-identity,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   verify-email-identity
   {:arglists
    '[[credentials {:keys [request-metric-collector email-address]}]],
    :doc "Call verifyEmailIdentity"}
   [credentials873 & args874]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client875
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials873)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client875
      verifyEmailIdentity
      (verify-email-identity-request (clojure.core/nth args874 0))))))))
