(ns com.palletops.awaze.simpledb (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpledb
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.simpledb.AmazonSimpleDBClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.Attribute attribute
  [m2744]
  (clojure.core/let
   [bean2743 (new com.amazonaws.services.simpledb.model.Attribute)]
   (clojure.core/when-let
    [v2745 (:name m2744)]
    (. bean2743 setName (clojure.core/str v2745)))
   (clojure.core/when-let
    [v2745 (:value m2744)]
    (. bean2743 setValue (clojure.core/str v2745)))
   (clojure.core/when-let
    [v2745 (:alternate-name-encoding m2744)]
    (. bean2743 setAlternateNameEncoding (clojure.core/str v2745)))
   (clojure.core/when-let
    [v2745 (:alternate-value-encoding m2744)]
    (. bean2743 setAlternateValueEncoding (clojure.core/str v2745)))
   bean2743))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.ReplaceableAttribute replaceable-attribute
  [m2747]
  (clojure.core/let
   [bean2746
    (new com.amazonaws.services.simpledb.model.ReplaceableAttribute)]
   (clojure.core/when-let
    [v2748 (:name m2747)]
    (. bean2746 setName (clojure.core/str v2748)))
   (clojure.core/when-let
    [v2748 (:value m2747)]
    (. bean2746 setValue (clojure.core/str v2748)))
   (clojure.core/when-let
    [v2748 (:replace m2747)]
    (. bean2746 setReplace (clojure.core/boolean v2748)))
   bean2746))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.DeletableItem deletable-item
  [m2750]
  (clojure.core/let
   [bean2749 (new com.amazonaws.services.simpledb.model.DeletableItem)]
   (clojure.core/when-let
    [v2751 (:name m2750)]
    (. bean2749 setName (clojure.core/str v2751)))
   (clojure.core/when-let
    [v2751 (:attributes m2750)]
    (.
     bean2749
     setAttributes
     (clojure.core/map
      (clojure.core/fn [arg2752] (attribute arg2752))
      v2751)))
   bean2749))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.UpdateCondition update-condition
  [m2754]
  (clojure.core/let
   [bean2753
    (new com.amazonaws.services.simpledb.model.UpdateCondition)]
   (clojure.core/when-let
    [v2755 (:name m2754)]
    (. bean2753 setName (clojure.core/str v2755)))
   (clojure.core/when-let
    [v2755 (:value m2754)]
    (. bean2753 setValue (clojure.core/str v2755)))
   (clojure.core/when-let
    [v2755 (:exists m2754)]
    (. bean2753 setExists (clojure.core/boolean v2755)))
   bean2753))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.ReplaceableItem replaceable-item
  [m2757]
  (clojure.core/let
   [bean2756
    (new com.amazonaws.services.simpledb.model.ReplaceableItem)]
   (clojure.core/when-let
    [v2758 (:name m2757)]
    (. bean2756 setName (clojure.core/str v2758)))
   (clojure.core/when-let
    [v2758 (:attributes m2757)]
    (.
     bean2756
     setAttributes
     (clojure.core/map
      (clojure.core/fn [arg2759] (replaceable-attribute arg2759))
      v2758)))
   bean2756))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.DomainMetadataRequest domain-metadata-request
  [m2761]
  (clojure.core/let
   [bean2760
    (new com.amazonaws.services.simpledb.model.DomainMetadataRequest)]
   (clojure.core/when-let
    [v2762 (:domain-name m2761)]
    (. bean2760 setDomainName (clojure.core/str v2762)))
   bean2760))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.GetAttributesRequest get-attributes-request
  [m2764]
  (clojure.core/let
   [bean2763
    (new com.amazonaws.services.simpledb.model.GetAttributesRequest)]
   (clojure.core/when-let
    [v2765 (:domain-name m2764)]
    (. bean2763 setDomainName (clojure.core/str v2765)))
   (clojure.core/when-let
    [v2765 (:item-name m2764)]
    (. bean2763 setItemName (clojure.core/str v2765)))
   (clojure.core/when-let
    [v2765 (:attribute-names m2764)]
    (.
     bean2763
     setAttributeNames
     (clojure.core/map
      (clojure.core/fn [arg2766] (clojure.core/str arg2766))
      v2765)))
   (clojure.core/when-let
    [v2765 (:consistent-read m2764)]
    (. bean2763 setConsistentRead (clojure.core/boolean v2765)))
   bean2763))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.CreateDomainRequest create-domain-request
  [m2768]
  (clojure.core/let
   [bean2767
    (new com.amazonaws.services.simpledb.model.CreateDomainRequest)]
   (clojure.core/when-let
    [v2769 (:domain-name m2768)]
    (. bean2767 setDomainName (clojure.core/str v2769)))
   bean2767))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest batch-delete-attributes-request
  [m2771]
  (clojure.core/let
   [bean2770
    (new
     com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest)]
   (clojure.core/when-let
    [v2772 (:items m2771)]
    (.
     bean2770
     setItems
     (clojure.core/map
      (clojure.core/fn [arg2773] (deletable-item arg2773))
      v2772)))
   (clojure.core/when-let
    [v2772 (:domain-name m2771)]
    (. bean2770 setDomainName (clojure.core/str v2772)))
   bean2770))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.ListDomainsRequest list-domains-request
  [m2775]
  (clojure.core/let
   [bean2774
    (new com.amazonaws.services.simpledb.model.ListDomainsRequest)]
   (clojure.core/when-let
    [v2776 (:next-token m2775)]
    (. bean2774 setNextToken (clojure.core/str v2776)))
   (clojure.core/when-let
    [v2776 (:max-number-of-domains m2775)]
    (. bean2774 setMaxNumberOfDomains (clojure.core/int v2776)))
   bean2774))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.PutAttributesRequest put-attributes-request
  [m2778]
  (clojure.core/let
   [bean2777
    (new com.amazonaws.services.simpledb.model.PutAttributesRequest)]
   (clojure.core/when-let
    [v2779 (:domain-name m2778)]
    (. bean2777 setDomainName (clojure.core/str v2779)))
   (clojure.core/when-let
    [v2779 (:item-name m2778)]
    (. bean2777 setItemName (clojure.core/str v2779)))
   (clojure.core/when-let
    [v2779 (:expected m2778)]
    (. bean2777 setExpected (update-condition v2779)))
   (clojure.core/when-let
    [v2779 (:attributes m2778)]
    (.
     bean2777
     setAttributes
     (clojure.core/map
      (clojure.core/fn [arg2780] (replaceable-attribute arg2780))
      v2779)))
   bean2777))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.DeleteAttributesRequest delete-attributes-request
  [m2782]
  (clojure.core/let
   [bean2781
    (new
     com.amazonaws.services.simpledb.model.DeleteAttributesRequest)]
   (clojure.core/when-let
    [v2783 (:domain-name m2782)]
    (. bean2781 setDomainName (clojure.core/str v2783)))
   (clojure.core/when-let
    [v2783 (:item-name m2782)]
    (. bean2781 setItemName (clojure.core/str v2783)))
   (clojure.core/when-let
    [v2783 (:expected m2782)]
    (. bean2781 setExpected (update-condition v2783)))
   (clojure.core/when-let
    [v2783 (:attributes m2782)]
    (.
     bean2781
     setAttributes
     (clojure.core/map
      (clojure.core/fn [arg2784] (attribute arg2784))
      v2783)))
   bean2781))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.BatchPutAttributesRequest batch-put-attributes-request
  [m2786]
  (clojure.core/let
   [bean2785
    (new
     com.amazonaws.services.simpledb.model.BatchPutAttributesRequest)]
   (clojure.core/when-let
    [v2787 (:items m2786)]
    (.
     bean2785
     setItems
     (clojure.core/map
      (clojure.core/fn [arg2788] (replaceable-item arg2788))
      v2787)))
   (clojure.core/when-let
    [v2787 (:domain-name m2786)]
    (. bean2785 setDomainName (clojure.core/str v2787)))
   bean2785))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.DeleteDomainRequest delete-domain-request
  [m2790]
  (clojure.core/let
   [bean2789
    (new com.amazonaws.services.simpledb.model.DeleteDomainRequest)]
   (clojure.core/when-let
    [v2791 (:domain-name m2790)]
    (. bean2789 setDomainName (clojure.core/str v2791)))
   bean2789))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.SelectRequest select-request
  [m2793]
  (clojure.core/let
   [bean2792 (new com.amazonaws.services.simpledb.model.SelectRequest)]
   (clojure.core/when-let
    [v2794 (:next-token m2793)]
    (. bean2792 setNextToken (clojure.core/str v2794)))
   (clojure.core/when-let
    [v2794 (:consistent-read m2793)]
    (. bean2792 setConsistentRead (clojure.core/boolean v2794)))
   (clojure.core/when-let
    [v2794 (:select-expression m2793)]
    (. bean2792 setSelectExpression (clojure.core/str v2794)))
   bean2792))
 (clojure.core/defmulti
  simpledb
  (clojure.core/fn simpledb [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   simpledb
   :domain-metadata
   [m2795]
   (clojure.core/let
    [credentials2796 (:credentials m2795) args2797 (:args m2795)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2798
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials2796)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2798
       domainMetadata
       (domain-metadata-request (clojure.core/nth args2797 0)))))))
  (clojure.core/defn
   domain-metadata-map
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Generate map for domainMetadata"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :domain-metadata,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   domain-metadata
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Call domainMetadata"}
   [credentials2800 & args2801]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2802
     (com.palletops.awaze.common/aws-client :simpledb credentials2800)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2802
      domainMetadata
      (domain-metadata-request (clojure.core/nth args2801 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :get-attributes
   [m2803]
   (clojure.core/let
    [credentials2804 (:credentials m2803) args2805 (:args m2803)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2806
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials2804)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2806
       getAttributes
       (get-attributes-request (clojure.core/nth args2805 0)))))))
  (clojure.core/defn
   get-attributes-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         item-name
         domain-name
         consistent-read
         attribute-names]}]],
    :doc "Generate map for getAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :get-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-attributes
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         item-name
         domain-name
         consistent-read
         attribute-names]}]],
    :doc "Call getAttributes"}
   [credentials2808 & args2809]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2810
     (com.palletops.awaze.common/aws-client :simpledb credentials2808)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2810
      getAttributes
      (get-attributes-request (clojure.core/nth args2809 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :create-domain
   [m2811]
   (clojure.core/let
    [credentials2812 (:credentials m2811) args2813 (:args m2811)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2814
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials2812)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2814
       createDomain
       (create-domain-request (clojure.core/nth args2813 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Generate map for createDomain"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :create-domain,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-domain
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Call createDomain"}
   [credentials2816 & args2817]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2818
     (com.palletops.awaze.common/aws-client :simpledb credentials2816)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2818
      createDomain
      (create-domain-request (clojure.core/nth args2817 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-delete-attributes
   [m2819]
   (clojure.core/let
    [credentials2820 (:credentials m2819) args2821 (:args m2819)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2822
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials2820)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2822
       batchDeleteAttributes
       (batch-delete-attributes-request
        (clojure.core/nth args2821 0)))))))
  (clojure.core/defn
   batch-delete-attributes-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector items domain-name]}]],
    :doc "Generate map for batchDeleteAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :batch-delete-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   batch-delete-attributes
   {:arglists
    '[[credentials
       {:keys [request-metric-collector items domain-name]}]],
    :doc "Call batchDeleteAttributes"}
   [credentials2824 & args2825]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2826
     (com.palletops.awaze.common/aws-client :simpledb credentials2824)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2826
      batchDeleteAttributes
      (batch-delete-attributes-request
       (clojure.core/nth args2825 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :list-domains
   [m2827]
   (clojure.core/let
    [credentials2828 (:credentials m2827) args2829 (:args m2827)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2830
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials2828)]
     (clojure.core/case
      (clojure.core/count args2829)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2830
        listDomains))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2830
        listDomains
        (list-domains-request (clojure.core/nth args2829 0))))))))
  (clojure.core/defn
   list-domains-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector next-token max-number-of-domains]}]],
    :doc "Generate map for listDomains, listDomains"}
   ([credentials__577__auto__]
    {:args [],
     :client :simpledb,
     :fn :list-domains,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :list-domains,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-domains
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector next-token max-number-of-domains]}]],
    :doc "Call listDomains, listDomains"}
   [credentials2832 & args2833]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2834
     (com.palletops.awaze.common/aws-client :simpledb credentials2832)]
    (clojure.core/case
     (clojure.core/count args2833)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2834
       listDomains))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2834
       listDomains
       (list-domains-request (clojure.core/nth args2833 0))))))))
 (do
  (clojure.core/defmethod
   simpledb
   :put-attributes
   [m2835]
   (clojure.core/let
    [credentials2836 (:credentials m2835) args2837 (:args m2835)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2838
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials2836)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2838
       putAttributes
       (put-attributes-request (clojure.core/nth args2837 0)))))))
  (clojure.core/defn
   put-attributes-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         item-name
         expected
         domain-name
         attributes]}]],
    :doc "Generate map for putAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :put-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   put-attributes
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         item-name
         expected
         domain-name
         attributes]}]],
    :doc "Call putAttributes"}
   [credentials2840 & args2841]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2842
     (com.palletops.awaze.common/aws-client :simpledb credentials2840)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2842
      putAttributes
      (put-attributes-request (clojure.core/nth args2841 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-attributes
   [m2843]
   (clojure.core/let
    [credentials2844 (:credentials m2843) args2845 (:args m2843)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2846
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials2844)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2846
       deleteAttributes
       (delete-attributes-request (clojure.core/nth args2845 0)))))))
  (clojure.core/defn
   delete-attributes-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         item-name
         expected
         domain-name
         attributes]}]],
    :doc "Generate map for deleteAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :delete-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-attributes
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         item-name
         expected
         domain-name
         attributes]}]],
    :doc "Call deleteAttributes"}
   [credentials2848 & args2849]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2850
     (com.palletops.awaze.common/aws-client :simpledb credentials2848)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2850
      deleteAttributes
      (delete-attributes-request (clojure.core/nth args2849 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-put-attributes
   [m2851]
   (clojure.core/let
    [credentials2852 (:credentials m2851) args2853 (:args m2851)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2854
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials2852)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2854
       batchPutAttributes
       (batch-put-attributes-request
        (clojure.core/nth args2853 0)))))))
  (clojure.core/defn
   batch-put-attributes-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector items domain-name]}]],
    :doc "Generate map for batchPutAttributes"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :batch-put-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   batch-put-attributes
   {:arglists
    '[[credentials
       {:keys [request-metric-collector items domain-name]}]],
    :doc "Call batchPutAttributes"}
   [credentials2856 & args2857]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2858
     (com.palletops.awaze.common/aws-client :simpledb credentials2856)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2858
      batchPutAttributes
      (batch-put-attributes-request (clojure.core/nth args2857 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-domain
   [m2859]
   (clojure.core/let
    [credentials2860 (:credentials m2859) args2861 (:args m2859)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2862
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials2860)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2862
       deleteDomain
       (delete-domain-request (clojure.core/nth args2861 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Generate map for deleteDomain"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :delete-domain,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-domain
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Call deleteDomain"}
   [credentials2864 & args2865]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2866
     (com.palletops.awaze.common/aws-client :simpledb credentials2864)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2866
      deleteDomain
      (delete-domain-request (clojure.core/nth args2865 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :select
   [m2867]
   (clojure.core/let
    [credentials2868 (:credentials m2867) args2869 (:args m2867)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2870
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials2868)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2870
       select
       (select-request (clojure.core/nth args2869 0)))))))
  (clojure.core/defn
   select-map
   {:arglists
    '[[credentials
       {:keys
        [select-expression
         request-metric-collector
         next-token
         consistent-read]}]],
    :doc "Generate map for select"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :select,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   select
   {:arglists
    '[[credentials
       {:keys
        [select-expression
         request-metric-collector
         next-token
         consistent-read]}]],
    :doc "Call select"}
   [credentials2872 & args2873]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2874
     (com.palletops.awaze.common/aws-client :simpledb credentials2872)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client2874
      select
      (select-request (clojure.core/nth args2873 0))))))))
