(ns com.palletops.awaze.securitytoken (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :securitytoken
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.AssumeRoleRequest assume-role-request
  [m7886]
  (clojure.core/let
   [bean7885
    (new com.amazonaws.services.securitytoken.model.AssumeRoleRequest)]
   (clojure.core/when-let
    [v7887 (:duration-seconds m7886)]
    (. bean7885 setDurationSeconds (clojure.core/int v7887)))
   (clojure.core/when-let
    [v7887 (:role-arn m7886)]
    (. bean7885 setRoleArn (clojure.core/str v7887)))
   (clojure.core/when-let
    [v7887 (:role-session-name m7886)]
    (. bean7885 setRoleSessionName (clojure.core/str v7887)))
   (clojure.core/when-let
    [v7887 (:external-id m7886)]
    (. bean7885 setExternalId (clojure.core/str v7887)))
   (clojure.core/when-let
    [v7887 (:policy m7886)]
    (. bean7885 setPolicy (clojure.core/str v7887)))
   bean7885))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.GetFederationTokenRequest get-federation-token-request
  [m7889]
  (clojure.core/let
   [bean7888
    (new
     com.amazonaws.services.securitytoken.model.GetFederationTokenRequest)]
   (clojure.core/when-let
    [v7890 (:name m7889)]
    (. bean7888 setName (clojure.core/str v7890)))
   (clojure.core/when-let
    [v7890 (:duration-seconds m7889)]
    (. bean7888 setDurationSeconds (clojure.core/int v7890)))
   (clojure.core/when-let
    [v7890 (:policy m7889)]
    (. bean7888 setPolicy (clojure.core/str v7890)))
   bean7888))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest assume-role-with-web-identity-request
  [m7892]
  (clojure.core/let
   [bean7891
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest)]
   (clojure.core/when-let
    [v7893 (:duration-seconds m7892)]
    (. bean7891 setDurationSeconds (clojure.core/int v7893)))
   (clojure.core/when-let
    [v7893 (:role-arn m7892)]
    (. bean7891 setRoleArn (clojure.core/str v7893)))
   (clojure.core/when-let
    [v7893 (:role-session-name m7892)]
    (. bean7891 setRoleSessionName (clojure.core/str v7893)))
   (clojure.core/when-let
    [v7893 (:web-identity-token m7892)]
    (. bean7891 setWebIdentityToken (clojure.core/str v7893)))
   (clojure.core/when-let
    [v7893 (:provider-id m7892)]
    (. bean7891 setProviderId (clojure.core/str v7893)))
   (clojure.core/when-let
    [v7893 (:policy m7892)]
    (. bean7891 setPolicy (clojure.core/str v7893)))
   bean7891))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest decode-authorization-message-request
  [m7895]
  (clojure.core/let
   [bean7894
    (new
     com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest)]
   (clojure.core/when-let
    [v7896 (:encoded-message m7895)]
    (. bean7894 setEncodedMessage (clojure.core/str v7896)))
   bean7894))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.GetSessionTokenRequest get-session-token-request
  [m7898]
  (clojure.core/let
   [bean7897
    (new
     com.amazonaws.services.securitytoken.model.GetSessionTokenRequest)]
   (clojure.core/when-let
    [v7899 (:duration-seconds m7898)]
    (. bean7897 setDurationSeconds (clojure.core/int v7899)))
   (clojure.core/when-let
    [v7899 (:serial-number m7898)]
    (. bean7897 setSerialNumber (clojure.core/str v7899)))
   (clojure.core/when-let
    [v7899 (:token-code m7898)]
    (. bean7897 setTokenCode (clojure.core/str v7899)))
   bean7897))
 (clojure.core/defmulti
  securitytoken
  (clojure.core/fn
   securitytoken
   [m__609__auto__]
   (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role
   [m7900]
   (clojure.core/let
    [credentials7901 (:credentials m7900) args7902 (:args m7900)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7903
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials7901)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7903
       assumeRole
       (assume-role-request (clojure.core/nth args7902 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists
    '[[credentials
       {:keys
        [role-session-name
         role-arn
         request-metric-collector
         policy
         external-id
         duration-seconds]}]],
    :doc "Generate map for assumeRole"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :assume-role,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   assume-role
   {:arglists
    '[[credentials
       {:keys
        [role-session-name
         role-arn
         request-metric-collector
         policy
         external-id
         duration-seconds]}]],
    :doc "Call assumeRole"}
   [credentials7905 & args7906]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7907
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials7905)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7907
      assumeRole
      (assume-role-request (clojure.core/nth args7906 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-federation-token
   [m7908]
   (clojure.core/let
    [credentials7909 (:credentials m7908) args7910 (:args m7908)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7911
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials7909)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7911
       getFederationToken
       (get-federation-token-request
        (clojure.core/nth args7910 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector policy name duration-seconds]}]],
    :doc "Generate map for getFederationToken"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :get-federation-token,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-federation-token
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector policy name duration-seconds]}]],
    :doc "Call getFederationToken"}
   [credentials7913 & args7914]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7915
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials7913)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7915
      getFederationToken
      (get-federation-token-request (clojure.core/nth args7914 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-web-identity
   [m7916]
   (clojure.core/let
    [credentials7917 (:credentials m7916) args7918 (:args m7916)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7919
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials7917)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7919
       assumeRoleWithWebIdentity
       (assume-role-with-web-identity-request
        (clojure.core/nth args7918 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists
    '[[credentials
       {:keys
        [duration-seconds
         role-arn
         role-session-name
         provider-id
         policy
         web-identity-token
         request-metric-collector]}]],
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :assume-role-with-web-identity,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists
    '[[credentials
       {:keys
        [duration-seconds
         role-arn
         role-session-name
         provider-id
         policy
         web-identity-token
         request-metric-collector]}]],
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials7921 & args7922]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7923
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials7921)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7923
      assumeRoleWithWebIdentity
      (assume-role-with-web-identity-request
       (clojure.core/nth args7922 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :decode-authorization-message
   [m7924]
   (clojure.core/let
    [credentials7925 (:credentials m7924) args7926 (:args m7924)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7927
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials7925)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7927
       decodeAuthorizationMessage
       (decode-authorization-message-request
        (clojure.core/nth args7926 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector encoded-message]}]],
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :decode-authorization-message,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists
    '[[credentials
       {:keys [request-metric-collector encoded-message]}]],
    :doc "Call decodeAuthorizationMessage"}
   [credentials7929 & args7930]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7931
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials7929)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7931
      decodeAuthorizationMessage
      (decode-authorization-message-request
       (clojure.core/nth args7930 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-session-token
   [m7932]
   (clojure.core/let
    [credentials7933 (:credentials m7932) args7934 (:args m7932)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7935
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials7933)]
     (clojure.core/case
      (clojure.core/count args7934)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7935
        getSessionToken))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7935
        getSessionToken
        (get-session-token-request (clojure.core/nth args7934 0))))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [token-code
         serial-number
         request-metric-collector
         duration-seconds]}]],
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__577__auto__]
    {:args [],
     :client :securitytoken,
     :fn :get-session-token,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :get-session-token,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-session-token
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [token-code
         serial-number
         request-metric-collector
         duration-seconds]}]],
    :doc "Call getSessionToken, getSessionToken"}
   [credentials7937 & args7938]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7939
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials7937)]
    (clojure.core/case
     (clojure.core/count args7938)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7939
       getSessionToken))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client7939
       getSessionToken
       (get-session-token-request (clojure.core/nth args7938 0)))))))))
