(ns com.palletops.awaze.s3 (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :s3
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.s3.AmazonS3Client
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.RedirectRule redirect-rule
  [m8149]
  (clojure.core/let
   [bean8148 (new com.amazonaws.services.s3.model.RedirectRule)]
   (clojure.core/when-let
    [v8150 (:protocol m8149)]
    (. bean8148 setProtocol (clojure.core/str v8150)))
   (clojure.core/when-let
    [v8150 (:host-name m8149)]
    (. bean8148 setHostName (clojure.core/str v8150)))
   (clojure.core/when-let
    [v8150 (:replace-key-prefix-with m8149)]
    (. bean8148 setReplaceKeyPrefixWith (clojure.core/str v8150)))
   (clojure.core/when-let
    [v8150 (:replace-key-with m8149)]
    (. bean8148 setReplaceKeyWith (clojure.core/str v8150)))
   (clojure.core/when-let
    [v8150 (:http-redirect-code m8149)]
    (. bean8148 setHttpRedirectCode (clojure.core/str v8150)))
   bean8148))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.RoutingRuleCondition routing-rule-condition
  [m8152]
  (clojure.core/let
   [bean8151
    (new com.amazonaws.services.s3.model.RoutingRuleCondition)]
   (clojure.core/when-let
    [v8153 (:http-error-code-returned-equals m8152)]
    (.
     bean8151
     setHttpErrorCodeReturnedEquals
     (clojure.core/str v8153)))
   (clojure.core/when-let
    [v8153 (:key-prefix-equals m8152)]
    (. bean8151 setKeyPrefixEquals (clojure.core/str v8153)))
   bean8151))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.StorageClass storage-class
  [m8155]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.StorageClass
   (clojure.core/name m8155)))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.RoutingRule routing-rule
  [m8158]
  (clojure.core/let
   [bean8157 (new com.amazonaws.services.s3.model.RoutingRule)]
   (clojure.core/when-let
    [v8159 (:redirect m8158)]
    (. bean8157 setRedirect (redirect-rule v8159)))
   (clojure.core/when-let
    [v8159 (:condition m8158)]
    (. bean8157 setCondition (routing-rule-condition v8159)))
   bean8157))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.Owner owner
  [m8161]
  (clojure.core/let
   [bean8160 (new com.amazonaws.services.s3.model.Owner)]
   (clojure.core/when-let
    [v8162 (:id m8161)]
    (. bean8160 setId (clojure.core/str v8162)))
   (clojure.core/when-let
    [v8162 (:display-name m8161)]
    (. bean8160 setDisplayName (clojure.core/str v8162)))
   bean8160))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.CORSRule$AllowedMethods corsrule-allowed-methods
  [m8164]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.CORSRule$AllowedMethods
   (clojure.core/name m8164)))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition bucket-lifecycle-configuration-transition
  [m8167]
  (clojure.core/let
   [bean8166
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition)]
   (clojure.core/when-let
    [v8168 (:date m8167)]
    (. bean8166 setDate (com.palletops.awaze.common/to-date v8168)))
   (clojure.core/when-let
    [v8168 (:storage-class m8167)]
    (. bean8166 setStorageClass (storage-class v8168)))
   (clojure.core/when-let
    [v8168 (:days m8167)]
    (. bean8166 setDays (clojure.core/int v8168)))
   bean8166))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.MultiFactorAuthentication multi-factor-authentication
  [m8170]
  (clojure.core/let
   [arg8172
    nil
    arg8173
    nil
    bean8169
    (new
     com.amazonaws.services.s3.model.MultiFactorAuthentication
     arg8172
     arg8173)]
   (clojure.core/when-let
    [v8171 (:token m8170)]
    (. bean8169 setToken (clojure.core/str v8171)))
   (clojure.core/when-let
    [v8171 (:device-serial-number m8170)]
    (. bean8169 setDeviceSerialNumber (clojure.core/str v8171)))
   bean8169))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion delete-objects-request-key-version
  [m8175]
  (clojure.core/let
   [arg8177
    nil
    bean8174
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion
     arg8177)]
   bean8174))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration bucket-notification-configuration-topic-configuration
  [m8179]
  (clojure.core/let
   [arg8181
    nil
    arg8182
    nil
    bean8178
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration
     arg8181
     arg8182)]
   bean8178))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ProgressListener progress-listener
  [m8184]
  (throw
   (clojure.core/ex-info
    "Trying to construct an interface"
    {:type "com.amazonaws.services.s3.model.ProgressListener",
     :value m8184})))
 (clojure.core/defn
  ^com.amazonaws.event.ProgressListener progress-listener
  [m8187]
  (throw
   (clojure.core/ex-info
    "Trying to construct an interface"
    {:type "com.amazonaws.event.ProgressListener", :value m8187})))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ResponseHeaderOverrides response-header-overrides
  [m8190]
  (clojure.core/let
   [bean8189
    (new com.amazonaws.services.s3.model.ResponseHeaderOverrides)]
   (clojure.core/when-let
    [v8191 (:content-type m8190)]
    (. bean8189 setContentType (clojure.core/str v8191)))
   (clojure.core/when-let
    [v8191 (:content-language m8190)]
    (. bean8189 setContentLanguage (clojure.core/str v8191)))
   (clojure.core/when-let
    [v8191 (:expires m8190)]
    (. bean8189 setExpires (clojure.core/str v8191)))
   (clojure.core/when-let
    [v8191 (:content-encoding m8190)]
    (. bean8189 setContentEncoding (clojure.core/str v8191)))
   (clojure.core/when-let
    [v8191 (:cache-control m8190)]
    (. bean8189 setCacheControl (clojure.core/str v8191)))
   (clojure.core/when-let
    [v8191 (:content-disposition m8190)]
    (. bean8189 setContentDisposition (clojure.core/str v8191)))
   bean8189))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketWebsiteConfiguration bucket-website-configuration
  [m8193]
  (clojure.core/let
   [bean8192
    (new com.amazonaws.services.s3.model.BucketWebsiteConfiguration)]
   (clojure.core/when-let
    [v8194 (:index-document-suffix m8193)]
    (. bean8192 setIndexDocumentSuffix (clojure.core/str v8194)))
   (clojure.core/when-let
    [v8194 (:error-document m8193)]
    (. bean8192 setErrorDocument (clojure.core/str v8194)))
   (clojure.core/when-let
    [v8194 (:redirect-all-requests-to m8193)]
    (. bean8192 setRedirectAllRequestsTo (redirect-rule v8194)))
   (clojure.core/when-let
    [v8194 (:routing-rules m8193)]
    (.
     bean8192
     setRoutingRules
     (clojure.core/map
      (clojure.core/fn [arg8195] (routing-rule arg8195))
      v8194)))
   bean8192))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.AccessControlList access-control-list
  [m8197]
  (clojure.core/let
   [bean8196 (new com.amazonaws.services.s3.model.AccessControlList)]
   (clojure.core/when-let
    [v8198 (:owner m8197)]
    (. bean8196 setOwner (owner v8198)))
   bean8196))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.CannedAccessControlList canned-access-control-list
  [m8200]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.CannedAccessControlList
   (clojure.core/name m8200)))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ObjectMetadata object-metadata
  [m8203]
  (clojure.core/let
   [bean8202 (new com.amazonaws.services.s3.model.ObjectMetadata)]
   (clojure.core/when-let
    [v8204 (:last-modified m8203)]
    (.
     bean8202
     setLastModified
     (com.palletops.awaze.common/to-date v8204)))
   (clojure.core/when-let
    [v8204 (:content-type m8203)]
    (. bean8202 setContentType (clojure.core/str v8204)))
   (clojure.core/when-let
    [v8204 (:content-length m8203)]
    (. bean8202 setContentLength (clojure.core/long v8204)))
   (clojure.core/when-let
    [v8204 (:content-md5 m8203)]
    (. bean8202 setContentMD5 (clojure.core/str v8204)))
   (clojure.core/when-let
    [v8204 (:server-side-encryption m8203)]
    (. bean8202 setServerSideEncryption (clojure.core/str v8204)))
   (clojure.core/when-let
    [v8204 (:expiration-time-rule-id m8203)]
    (. bean8202 setExpirationTimeRuleId (clojure.core/str v8204)))
   (clojure.core/when-let
    [v8204 (:content-encoding m8203)]
    (. bean8202 setContentEncoding (clojure.core/str v8204)))
   (clojure.core/when-let
    [v8204 (:cache-control m8203)]
    (. bean8202 setCacheControl (clojure.core/str v8204)))
   (clojure.core/when-let
    [v8204 (:content-disposition m8203)]
    (. bean8202 setContentDisposition (clojure.core/str v8204)))
   (clojure.core/when-let
    [v8204 (:restore-expiration-time m8203)]
    (.
     bean8202
     setRestoreExpirationTime
     (com.palletops.awaze.common/to-date v8204)))
   (clojure.core/when-let
    [v8204 (:ongoing-restore m8203)]
    (. bean8202 setOngoingRestore (clojure.core/boolean v8204)))
   (clojure.core/when-let
    [v8204 (:user-metadata m8203)]
    (.
     bean8202
     setUserMetadata
     (clojure.core/zipmap
      (clojure.core/map
       (clojure.core/fn [arg8205] (clojure.core/str arg8205))
       (clojure.core/keys v8204))
      (clojure.core/map
       (clojure.core/fn [arg8205] (clojure.core/str arg8205))
       (clojure.core/vals v8204)))))
   (clojure.core/when-let
    [v8204 (:http-expires-date m8203)]
    (.
     bean8202
     setHttpExpiresDate
     (com.palletops.awaze.common/to-date v8204)))
   (clojure.core/when-let
    [v8204 (:expiration-time m8203)]
    (.
     bean8202
     setExpirationTime
     (com.palletops.awaze.common/to-date v8204)))
   bean8202))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.CORSRule corsrule
  [m8207]
  (clojure.core/let
   [bean8206 (new com.amazonaws.services.s3.model.CORSRule)]
   (clojure.core/when-let
    [v8208 (:allowed-methods m8207)]
    (.
     bean8206
     setAllowedMethods
     (clojure.core/into-array
      com.amazonaws.services.s3.model.CORSRule$AllowedMethods
      (clojure.core/map
       (clojure.core/fn [arg8209] (corsrule-allowed-methods arg8209))
       v8208))))
   (clojure.core/when-let
    [v8208 (:allowed-methods m8207)]
    (.
     bean8206
     setAllowedMethods
     (clojure.core/map
      (clojure.core/fn [arg8210] (corsrule-allowed-methods arg8210))
      v8208)))
   (clojure.core/when-let
    [v8208 (:id m8207)]
    (. bean8206 setId (clojure.core/str v8208)))
   (clojure.core/when-let
    [v8208 (:allowed-origins m8207)]
    (.
     bean8206
     setAllowedOrigins
     (clojure.core/into-array
      java.lang.String
      (clojure.core/map
       (clojure.core/fn [arg8211] (clojure.core/str arg8211))
       v8208))))
   (clojure.core/when-let
    [v8208 (:allowed-origins m8207)]
    (.
     bean8206
     setAllowedOrigins
     (clojure.core/map
      (clojure.core/fn [arg8212] (clojure.core/str arg8212))
      v8208)))
   (clojure.core/when-let
    [v8208 (:max-age-seconds m8207)]
    (. bean8206 setMaxAgeSeconds (clojure.core/int v8208)))
   (clojure.core/when-let
    [v8208 (:exposed-headers m8207)]
    (.
     bean8206
     setExposedHeaders
     (clojure.core/into-array
      java.lang.String
      (clojure.core/map
       (clojure.core/fn [arg8213] (clojure.core/str arg8213))
       v8208))))
   (clojure.core/when-let
    [v8208 (:exposed-headers m8207)]
    (.
     bean8206
     setExposedHeaders
     (clojure.core/map
      (clojure.core/fn [arg8214] (clojure.core/str arg8214))
      v8208)))
   (clojure.core/when-let
    [v8208 (:allowed-headers m8207)]
    (.
     bean8206
     setAllowedHeaders
     (clojure.core/into-array
      java.lang.String
      (clojure.core/map
       (clojure.core/fn [arg8215] (clojure.core/str arg8215))
       v8208))))
   (clojure.core/when-let
    [v8208 (:allowed-headers m8207)]
    (.
     bean8206
     setAllowedHeaders
     (clojure.core/map
      (clojure.core/fn [arg8216] (clojure.core/str arg8216))
      v8208)))
   bean8206))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.TagSet tag-set
  [m8218]
  (clojure.core/let
   [bean8217 (new com.amazonaws.services.s3.model.TagSet)]
   bean8217))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketVersioningConfiguration bucket-versioning-configuration
  [m8221]
  (clojure.core/let
   [bean8220
    (new
     com.amazonaws.services.s3.model.BucketVersioningConfiguration)]
   (clojure.core/when-let
    [v8222 (:status m8221)]
    (. bean8220 setStatus (clojure.core/str v8222)))
   (clojure.core/when-let
    [v8222 (:mfa-delete-enabled m8221)]
    (. bean8220 setMfaDeleteEnabled (clojure.core/boolean v8222)))
   bean8220))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.PartETag part-etag
  [m8224]
  (clojure.core/let
   [arg8226
    0
    arg8227
    nil
    bean8223
    (new com.amazonaws.services.s3.model.PartETag arg8226 arg8227)]
   (clojure.core/when-let
    [v8225 (:etag m8224)]
    (. bean8223 setETag (clojure.core/str v8225)))
   (clojure.core/when-let
    [v8225 (:part-number m8224)]
    (. bean8223 setPartNumber (clojure.core/int v8225)))
   bean8223))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule bucket-lifecycle-configuration-rule
  [m8229]
  (clojure.core/let
   [bean8228
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule)]
   (clojure.core/when-let
    [v8230 (:prefix m8229)]
    (. bean8228 setPrefix (clojure.core/str v8230)))
   (clojure.core/when-let
    [v8230 (:id m8229)]
    (. bean8228 setId (clojure.core/str v8230)))
   (clojure.core/when-let
    [v8230 (:status m8229)]
    (. bean8228 setStatus (clojure.core/str v8230)))
   (clojure.core/when-let
    [v8230 (:transition m8229)]
    (.
     bean8228
     setTransition
     (bucket-lifecycle-configuration-transition v8230)))
   (clojure.core/when-let
    [v8230 (:expiration-in-days m8229)]
    (. bean8228 setExpirationInDays (clojure.core/int v8230)))
   (clojure.core/when-let
    [v8230 (:expiration-date m8229)]
    (.
     bean8228
     setExpirationDate
     (com.palletops.awaze.common/to-date v8230)))
   bean8228))
 (clojure.core/defn
  ^com.amazonaws.HttpMethod http-method
  [m8232]
  (java.lang.Enum/valueOf
   com.amazonaws.HttpMethod
   (clojure.core/name m8232)))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketLoggingConfiguration bucket-logging-configuration
  [m8235]
  (clojure.core/let
   [bean8234
    (new com.amazonaws.services.s3.model.BucketLoggingConfiguration)]
   (clojure.core/when-let
    [v8236 (:log-file-prefix m8235)]
    (. bean8234 setLogFilePrefix (clojure.core/str v8236)))
   (clojure.core/when-let
    [v8236 (:destination-bucket-name m8235)]
    (. bean8234 setDestinationBucketName (clojure.core/str v8236)))
   bean8234))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.S3VersionSummary s3version-summary
  [m8238]
  (clojure.core/let
   [bean8237 (new com.amazonaws.services.s3.model.S3VersionSummary)]
   (clojure.core/when-let
    [v8239 (:size m8238)]
    (. bean8237 setSize (clojure.core/long v8239)))
   (clojure.core/when-let
    [v8239 (:last-modified m8238)]
    (.
     bean8237
     setLastModified
     (com.palletops.awaze.common/to-date v8239)))
   (clojure.core/when-let
    [v8239 (:etag m8238)]
    (. bean8237 setETag (clojure.core/str v8239)))
   (clojure.core/when-let
    [v8239 (:key m8238)]
    (. bean8237 setKey (clojure.core/str v8239)))
   (clojure.core/when-let
    [v8239 (:owner m8238)]
    (. bean8237 setOwner (owner v8239)))
   (clojure.core/when-let
    [v8239 (:bucket-name m8238)]
    (. bean8237 setBucketName (clojure.core/str v8239)))
   (clojure.core/when-let
    [v8239 (:version-id m8238)]
    (. bean8237 setVersionId (clojure.core/str v8239)))
   (clojure.core/when-let
    [v8239 (:storage-class m8238)]
    (. bean8237 setStorageClass (clojure.core/str v8239)))
   (clojure.core/when-let
    [v8239 (:is-latest m8238)]
    (. bean8237 setIsLatest (clojure.core/boolean v8239)))
   (clojure.core/when-let
    [v8239 (:is-delete-marker m8238)]
    (. bean8237 setIsDeleteMarker (clojure.core/boolean v8239)))
   bean8237))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.DeleteObjectsRequest delete-objects-request
  [m8241]
  (clojure.core/let
   [arg8243
    nil
    bean8240
    (new com.amazonaws.services.s3.model.DeleteObjectsRequest arg8243)]
   (clojure.core/when-let
    [v8242 (:bucket-name m8241)]
    (. bean8240 setBucketName (clojure.core/str v8242)))
   (clojure.core/when-let
    [v8242 (:quiet m8241)]
    (. bean8240 setQuiet (clojure.core/boolean v8242)))
   (clojure.core/when-let
    [v8242 (:mfa m8241)]
    (. bean8240 setMfa (multi-factor-authentication v8242)))
   (clojure.core/when-let
    [v8242 (:keys m8241)]
    (.
     bean8240
     setKeys
     (clojure.core/map
      (clojure.core/fn
       [arg8244]
       (delete-objects-request-key-version arg8244))
      v8242)))
   bean8240))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.SetBucketAclRequest set-bucket-acl-request
  [m8246]
  (clojure.core/let
   [^java.lang.String arg8248
    nil
    ^com.amazonaws.services.s3.model.AccessControlList arg8249
    (access-control-list {})
    bean8245
    (new
     com.amazonaws.services.s3.model.SetBucketAclRequest
     ^java.lang.String arg8248
     ^com.amazonaws.services.s3.model.AccessControlList arg8249)]
   bean8245))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.GetBucketLocationRequest get-bucket-location-request
  [m8251]
  (clojure.core/let
   [arg8253
    nil
    bean8250
    (new
     com.amazonaws.services.s3.model.GetBucketLocationRequest
     arg8253)]
   (clojure.core/when-let
    [v8252 (:bucket-name m8251)]
    (. bean8250 setBucketName (clojure.core/str v8252)))
   bean8250))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketNotificationConfiguration bucket-notification-configuration
  [m8255]
  (clojure.core/let
   [bean8254
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration)]
   (clojure.core/when-let
    [v8256 (:topic-configurations m8255)]
    (.
     bean8254
     setTopicConfigurations
     (clojure.core/map
      (clojure.core/fn
       [arg8257]
       (bucket-notification-configuration-topic-configuration arg8257))
      v8256)))
   bean8254))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.GetObjectRequest get-object-request
  [m8259]
  (clojure.core/let
   [arg8261
    nil
    arg8262
    nil
    bean8258
    (new
     com.amazonaws.services.s3.model.GetObjectRequest
     arg8261
     arg8262)]
   (clojure.core/when-let
    [v8260 (:key m8259)]
    (. bean8258 setKey (clojure.core/str v8260)))
   (clojure.core/when-let
    [v8260 (:bucket-name m8259)]
    (. bean8258 setBucketName (clojure.core/str v8260)))
   (clojure.core/when-let
    [v8260 (:version-id m8259)]
    (. bean8258 setVersionId (clojure.core/str v8260)))
   (clojure.core/when-let
    [v8260 (:progress-listener m8259)]
    (. bean8258 setProgressListener (progress-listener v8260)))
   (clojure.core/when-let
    [v8260 (:general-progress-listener m8259)]
    (. bean8258 setGeneralProgressListener (progress-listener v8260)))
   (clojure.core/when-let
    [v8260 (:response-headers m8259)]
    (. bean8258 setResponseHeaders (response-header-overrides v8260)))
   (clojure.core/when-let
    [v8260 (:matching-etag-constraints m8259)]
    (.
     bean8258
     setMatchingETagConstraints
     (clojure.core/map
      (clojure.core/fn [arg8263] (clojure.core/str arg8263))
      v8260)))
   (clojure.core/when-let
    [v8260 (:nonmatching-etag-constraints m8259)]
    (.
     bean8258
     setNonmatchingETagConstraints
     (clojure.core/map
      (clojure.core/fn [arg8264] (clojure.core/str arg8264))
      v8260)))
   (clojure.core/when-let
    [v8260 (:unmodified-since-constraint m8259)]
    (.
     bean8258
     setUnmodifiedSinceConstraint
     (com.palletops.awaze.common/to-date v8260)))
   (clojure.core/when-let
    [v8260 (:modified-since-constraint m8259)]
    (.
     bean8258
     setModifiedSinceConstraint
     (com.palletops.awaze.common/to-date v8260)))
   bean8258))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest set-bucket-website-configuration-request
  [m8266]
  (clojure.core/let
   [arg8268
    nil
    arg8269
    nil
    bean8265
    (new
     com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest
     arg8268
     arg8269)]
   (clojure.core/when-let
    [v8267 (:configuration m8266)]
    (. bean8265 setConfiguration (bucket-website-configuration v8267)))
   (clojure.core/when-let
    [v8267 (:bucket-name m8266)]
    (. bean8265 setBucketName (clojure.core/str v8267)))
   bean8265))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.CopyObjectRequest copy-object-request
  [m8271]
  (clojure.core/let
   [arg8273
    nil
    arg8274
    nil
    arg8275
    nil
    arg8276
    nil
    bean8270
    (new
     com.amazonaws.services.s3.model.CopyObjectRequest
     arg8273
     arg8274
     arg8275
     arg8276)]
   (clojure.core/when-let
    [v8272 (:access-control-list m8271)]
    (. bean8270 setAccessControlList (access-control-list v8272)))
   (clojure.core/when-let
    [v8272 (:storage-class m8271)]
    (. bean8270 setStorageClass (storage-class v8272)))
   (clojure.core/when-let
    [v8272 (:storage-class m8271)]
    (. bean8270 setStorageClass (clojure.core/str v8272)))
   (clojure.core/when-let
    [v8272 (:redirect-location m8271)]
    (. bean8270 setRedirectLocation (clojure.core/str v8272)))
   (clojure.core/when-let
    [v8272 (:canned-access-control-list m8271)]
    (.
     bean8270
     setCannedAccessControlList
     (canned-access-control-list v8272)))
   (clojure.core/when-let
    [v8272 (:source-bucket-name m8271)]
    (. bean8270 setSourceBucketName (clojure.core/str v8272)))
   (clojure.core/when-let
    [v8272 (:source-key m8271)]
    (. bean8270 setSourceKey (clojure.core/str v8272)))
   (clojure.core/when-let
    [v8272 (:source-version-id m8271)]
    (. bean8270 setSourceVersionId (clojure.core/str v8272)))
   (clojure.core/when-let
    [v8272 (:destination-bucket-name m8271)]
    (. bean8270 setDestinationBucketName (clojure.core/str v8272)))
   (clojure.core/when-let
    [v8272 (:destination-key m8271)]
    (. bean8270 setDestinationKey (clojure.core/str v8272)))
   (clojure.core/when-let
    [v8272 (:matching-etag-constraints m8271)]
    (.
     bean8270
     setMatchingETagConstraints
     (clojure.core/map
      (clojure.core/fn [arg8277] (clojure.core/str arg8277))
      v8272)))
   (clojure.core/when-let
    [v8272 (:nonmatching-etag-constraints m8271)]
    (.
     bean8270
     setNonmatchingETagConstraints
     (clojure.core/map
      (clojure.core/fn [arg8278] (clojure.core/str arg8278))
      v8272)))
   (clojure.core/when-let
    [v8272 (:unmodified-since-constraint m8271)]
    (.
     bean8270
     setUnmodifiedSinceConstraint
     (com.palletops.awaze.common/to-date v8272)))
   (clojure.core/when-let
    [v8272 (:modified-since-constraint m8271)]
    (.
     bean8270
     setModifiedSinceConstraint
     (com.palletops.awaze.common/to-date v8272)))
   (clojure.core/when-let
    [v8272 (:new-object-metadata m8271)]
    (. bean8270 setNewObjectMetadata (object-metadata v8272)))
   bean8270))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketCrossOriginConfiguration bucket-cross-origin-configuration
  [m8280]
  (clojure.core/let
   [bean8279
    (new
     com.amazonaws.services.s3.model.BucketCrossOriginConfiguration)]
   (clojure.core/when-let
    [v8281 (:rules m8280)]
    (.
     bean8279
     setRules
     (clojure.core/map
      (clojure.core/fn [arg8282] (corsrule arg8282))
      v8281)))
   bean8279))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketTaggingConfiguration bucket-tagging-configuration
  [m8284]
  (clojure.core/let
   [bean8283
    (new com.amazonaws.services.s3.model.BucketTaggingConfiguration)]
   (clojure.core/when-let
    [v8285 (:tag-sets m8284)]
    (.
     bean8283
     setTagSets
     (clojure.core/map
      (clojure.core/fn [arg8286] (tag-set arg8286))
      v8285)))
   bean8283))
 (clojure.core/defn
  ^com.amazonaws.services.s3.S3ClientOptions s3client-options
  [m8288]
  (clojure.core/let
   [bean8287 (new com.amazonaws.services.s3.S3ClientOptions)]
   (clojure.core/when-let
    [v8289 (:path-style-access m8288)]
    (. bean8287 setPathStyleAccess (clojure.core/boolean v8289)))
   bean8287))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.RestoreObjectRequest restore-object-request
  [m8291]
  (clojure.core/let
   [arg8293
    nil
    arg8294
    nil
    bean8290
    (new
     com.amazonaws.services.s3.model.RestoreObjectRequest
     arg8293
     arg8294)]
   (clojure.core/when-let
    [v8292 (:key m8291)]
    (. bean8290 setKey (clojure.core/str v8292)))
   (clojure.core/when-let
    [v8292 (:bucket-name m8291)]
    (. bean8290 setBucketName (clojure.core/str v8292)))
   (clojure.core/when-let
    [v8292 (:expiration-in-days m8291)]
    (. bean8290 setExpirationInDays (clojure.core/int v8292)))
   bean8290))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.DeleteVersionRequest delete-version-request
  [m8296]
  (clojure.core/let
   [arg8298
    nil
    arg8299
    nil
    arg8300
    nil
    bean8295
    (new
     com.amazonaws.services.s3.model.DeleteVersionRequest
     arg8298
     arg8299
     arg8300)]
   (clojure.core/when-let
    [v8297 (:key m8296)]
    (. bean8295 setKey (clojure.core/str v8297)))
   (clojure.core/when-let
    [v8297 (:bucket-name m8296)]
    (. bean8295 setBucketName (clojure.core/str v8297)))
   (clojure.core/when-let
    [v8297 (:version-id m8296)]
    (. bean8295 setVersionId (clojure.core/str v8297)))
   (clojure.core/when-let
    [v8297 (:mfa m8296)]
    (. bean8295 setMfa (multi-factor-authentication v8297)))
   bean8295))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest set-bucket-versioning-configuration-request
  [m8302]
  (clojure.core/let
   [arg8304
    nil
    arg8305
    nil
    bean8301
    (new
     com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest
     arg8304
     arg8305)]
   (clojure.core/when-let
    [v8303 (:bucket-name m8302)]
    (. bean8301 setBucketName (clojure.core/str v8303)))
   (clojure.core/when-let
    [v8303 (:mfa m8302)]
    (. bean8301 setMfa (multi-factor-authentication v8303)))
   (clojure.core/when-let
    [v8303 (:versioning-configuration m8302)]
    (.
     bean8301
     setVersioningConfiguration
     (bucket-versioning-configuration v8303)))
   bean8301))
 (clojure.core/defn
  ^com.amazonaws.handlers.RequestHandler request-handler
  [m8307]
  (throw
   (clojure.core/ex-info
    "Trying to construct an interface"
    {:type "com.amazonaws.handlers.RequestHandler", :value m8307})))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.CreateBucketRequest create-bucket-request
  [m8310]
  (clojure.core/let
   [arg8312
    nil
    bean8309
    (new com.amazonaws.services.s3.model.CreateBucketRequest arg8312)]
   (clojure.core/when-let
    [v8311 (:region m8310)]
    (. bean8309 setRegion (clojure.core/str v8311)))
   (clojure.core/when-let
    [v8311 (:bucket-name m8310)]
    (. bean8309 setBucketName (clojure.core/str v8311)))
   (clojure.core/when-let
    [v8311 (:access-control-list m8310)]
    (. bean8309 setAccessControlList (access-control-list v8311)))
   (clojure.core/when-let
    [v8311 (:canned-acl m8310)]
    (. bean8309 setCannedAcl (canned-access-control-list v8311)))
   bean8309))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.Region region
  [m8314]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.Region
   (clojure.core/name m8314)))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ObjectListing object-listing
  [m8317]
  (clojure.core/let
   [bean8316 (new com.amazonaws.services.s3.model.ObjectListing)]
   (clojure.core/when-let
    [v8318 (:prefix m8317)]
    (. bean8316 setPrefix (clojure.core/str v8318)))
   (clojure.core/when-let
    [v8318 (:marker m8317)]
    (. bean8316 setMarker (clojure.core/str v8318)))
   (clojure.core/when-let
    [v8318 (:next-marker m8317)]
    (. bean8316 setNextMarker (clojure.core/str v8318)))
   (clojure.core/when-let
    [v8318 (:bucket-name m8317)]
    (. bean8316 setBucketName (clojure.core/str v8318)))
   (clojure.core/when-let
    [v8318 (:delimiter m8317)]
    (. bean8316 setDelimiter (clojure.core/str v8318)))
   (clojure.core/when-let
    [v8318 (:max-keys m8317)]
    (. bean8316 setMaxKeys (clojure.core/int v8318)))
   (clojure.core/when-let
    [v8318 (:truncated m8317)]
    (. bean8316 setTruncated (clojure.core/boolean v8318)))
   (clojure.core/when-let
    [v8318 (:common-prefixes m8317)]
    (.
     bean8316
     setCommonPrefixes
     (clojure.core/map
      (clojure.core/fn [arg8319] (clojure.core/str arg8319))
      v8318)))
   bean8316))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.PutObjectRequest put-object-request
  [m8321]
  (clojure.core/let
   [^java.lang.String arg8323
    nil
    ^java.lang.String arg8324
    nil
    ^java.lang.String arg8325
    nil
    bean8320
    (new
     com.amazonaws.services.s3.model.PutObjectRequest
     ^java.lang.String arg8323
     ^java.lang.String arg8324
     ^java.lang.String arg8325)]
   (clojure.core/when-let
    [v8322 (:file m8321)]
    (. bean8320 setFile (clojure.java.io/file v8322)))
   (clojure.core/when-let
    [v8322 (:key m8321)]
    (. bean8320 setKey (clojure.core/str v8322)))
   (clojure.core/when-let
    [v8322 (:bucket-name m8321)]
    (. bean8320 setBucketName (clojure.core/str v8322)))
   (clojure.core/when-let
    [v8322 (:input-stream m8321)]
    (. bean8320 setInputStream (clojure.java.io/input-stream v8322)))
   (clojure.core/when-let
    [v8322 (:progress-listener m8321)]
    (. bean8320 setProgressListener (progress-listener v8322)))
   (clojure.core/when-let
    [v8322 (:general-progress-listener m8321)]
    (. bean8320 setGeneralProgressListener (progress-listener v8322)))
   (clojure.core/when-let
    [v8322 (:access-control-list m8321)]
    (. bean8320 setAccessControlList (access-control-list v8322)))
   (clojure.core/when-let
    [v8322 (:storage-class m8321)]
    (. bean8320 setStorageClass (storage-class v8322)))
   (clojure.core/when-let
    [v8322 (:storage-class m8321)]
    (. bean8320 setStorageClass (clojure.core/str v8322)))
   (clojure.core/when-let
    [v8322 (:redirect-location m8321)]
    (. bean8320 setRedirectLocation (clojure.core/str v8322)))
   (clojure.core/when-let
    [v8322 (:canned-acl m8321)]
    (. bean8320 setCannedAcl (canned-access-control-list v8322)))
   (clojure.core/when-let
    [v8322 (:metadata m8321)]
    (. bean8320 setMetadata (object-metadata v8322)))
   bean8320))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.GetBucketPolicyRequest get-bucket-policy-request
  [m8327]
  (clojure.core/let
   [arg8329
    nil
    bean8326
    (new
     com.amazonaws.services.s3.model.GetBucketPolicyRequest
     arg8329)]
   (clojure.core/when-let
    [v8328 (:bucket-name m8327)]
    (. bean8326 setBucketName (clojure.core/str v8328)))
   bean8326))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ListObjectsRequest list-objects-request
  [m8331]
  (clojure.core/let
   [bean8330 (new com.amazonaws.services.s3.model.ListObjectsRequest)]
   (clojure.core/when-let
    [v8332 (:prefix m8331)]
    (. bean8330 setPrefix (clojure.core/str v8332)))
   (clojure.core/when-let
    [v8332 (:marker m8331)]
    (. bean8330 setMarker (clojure.core/str v8332)))
   (clojure.core/when-let
    [v8332 (:bucket-name m8331)]
    (. bean8330 setBucketName (clojure.core/str v8332)))
   (clojure.core/when-let
    [v8332 (:delimiter m8331)]
    (. bean8330 setDelimiter (clojure.core/str v8332)))
   (clojure.core/when-let
    [v8332 (:max-keys m8331)]
    (. bean8330 setMaxKeys (clojure.core/int v8332)))
   bean8330))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.AbortMultipartUploadRequest abort-multipart-upload-request
  [m8334]
  (clojure.core/let
   [arg8336
    nil
    arg8337
    nil
    arg8338
    nil
    bean8333
    (new
     com.amazonaws.services.s3.model.AbortMultipartUploadRequest
     arg8336
     arg8337
     arg8338)]
   (clojure.core/when-let
    [v8335 (:key m8334)]
    (. bean8333 setKey (clojure.core/str v8335)))
   (clojure.core/when-let
    [v8335 (:bucket-name m8334)]
    (. bean8333 setBucketName (clojure.core/str v8335)))
   (clojure.core/when-let
    [v8335 (:upload-id m8334)]
    (. bean8333 setUploadId (clojure.core/str v8335)))
   bean8333))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.UploadPartRequest upload-part-request
  [m8340]
  (clojure.core/let
   [bean8339 (new com.amazonaws.services.s3.model.UploadPartRequest)]
   (clojure.core/when-let
    [v8341 (:file m8340)]
    (. bean8339 setFile (clojure.java.io/file v8341)))
   (clojure.core/when-let
    [v8341 (:key m8340)]
    (. bean8339 setKey (clojure.core/str v8341)))
   (clojure.core/when-let
    [v8341 (:bucket-name m8340)]
    (. bean8339 setBucketName (clojure.core/str v8341)))
   (clojure.core/when-let
    [v8341 (:part-number m8340)]
    (. bean8339 setPartNumber (clojure.core/int v8341)))
   (clojure.core/when-let
    [v8341 (:input-stream m8340)]
    (. bean8339 setInputStream (clojure.java.io/input-stream v8341)))
   (clojure.core/when-let
    [v8341 (:upload-id m8340)]
    (. bean8339 setUploadId (clojure.core/str v8341)))
   (clojure.core/when-let
    [v8341 (:part-size m8340)]
    (. bean8339 setPartSize (clojure.core/long v8341)))
   (clojure.core/when-let
    [v8341 (:md5digest m8340)]
    (. bean8339 setMd5Digest (clojure.core/str v8341)))
   (clojure.core/when-let
    [v8341 (:file-offset m8340)]
    (. bean8339 setFileOffset (clojure.core/long v8341)))
   (clojure.core/when-let
    [v8341 (:progress-listener m8340)]
    (. bean8339 setProgressListener (progress-listener v8341)))
   (clojure.core/when-let
    [v8341 (:last-part m8340)]
    (. bean8339 setLastPart (clojure.core/boolean v8341)))
   (clojure.core/when-let
    [v8341 (:general-progress-listener m8340)]
    (. bean8339 setGeneralProgressListener (progress-listener v8341)))
   bean8339))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.CompleteMultipartUploadRequest complete-multipart-upload-request
  [m8343]
  (clojure.core/let
   [arg8345
    nil
    arg8346
    nil
    arg8347
    nil
    arg8348
    nil
    bean8342
    (new
     com.amazonaws.services.s3.model.CompleteMultipartUploadRequest
     arg8345
     arg8346
     arg8347
     arg8348)]
   (clojure.core/when-let
    [v8344 (:key m8343)]
    (. bean8342 setKey (clojure.core/str v8344)))
   (clojure.core/when-let
    [v8344 (:bucket-name m8343)]
    (. bean8342 setBucketName (clojure.core/str v8344)))
   (clojure.core/when-let
    [v8344 (:upload-id m8343)]
    (. bean8342 setUploadId (clojure.core/str v8344)))
   (clojure.core/when-let
    [v8344 (:part-etags m8343)]
    (.
     bean8342
     setPartETags
     (clojure.core/map
      (clojure.core/fn [arg8349] (part-etag arg8349))
      v8344)))
   bean8342))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ListVersionsRequest list-versions-request
  [m8351]
  (clojure.core/let
   [bean8350 (new com.amazonaws.services.s3.model.ListVersionsRequest)]
   (clojure.core/when-let
    [v8352 (:prefix m8351)]
    (. bean8350 setPrefix (clojure.core/str v8352)))
   (clojure.core/when-let
    [v8352 (:max-results m8351)]
    (. bean8350 setMaxResults (clojure.core/int v8352)))
   (clojure.core/when-let
    [v8352 (:bucket-name m8351)]
    (. bean8350 setBucketName (clojure.core/str v8352)))
   (clojure.core/when-let
    [v8352 (:delimiter m8351)]
    (. bean8350 setDelimiter (clojure.core/str v8352)))
   (clojure.core/when-let
    [v8352 (:key-marker m8351)]
    (. bean8350 setKeyMarker (clojure.core/str v8352)))
   (clojure.core/when-let
    [v8352 (:version-id-marker m8351)]
    (. bean8350 setVersionIdMarker (clojure.core/str v8352)))
   bean8350))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest delete-bucket-website-configuration-request
  [m8354]
  (clojure.core/let
   [arg8356
    nil
    bean8353
    (new
     com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
     arg8356)]
   (clojure.core/when-let
    [v8355 (:bucket-name m8354)]
    (. bean8353 setBucketName (clojure.core/str v8355)))
   bean8353))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ListMultipartUploadsRequest list-multipart-uploads-request
  [m8358]
  (clojure.core/let
   [arg8360
    nil
    bean8357
    (new
     com.amazonaws.services.s3.model.ListMultipartUploadsRequest
     arg8360)]
   (clojure.core/when-let
    [v8359 (:prefix m8358)]
    (. bean8357 setPrefix (clojure.core/str v8359)))
   (clojure.core/when-let
    [v8359 (:bucket-name m8358)]
    (. bean8357 setBucketName (clojure.core/str v8359)))
   (clojure.core/when-let
    [v8359 (:delimiter m8358)]
    (. bean8357 setDelimiter (clojure.core/str v8359)))
   (clojure.core/when-let
    [v8359 (:key-marker m8358)]
    (. bean8357 setKeyMarker (clojure.core/str v8359)))
   (clojure.core/when-let
    [v8359 (:max-uploads m8358)]
    (. bean8357 setMaxUploads (clojure.core/int v8359)))
   (clojure.core/when-let
    [v8359 (:upload-id-marker m8358)]
    (. bean8357 setUploadIdMarker (clojure.core/str v8359)))
   bean8357))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketLifecycleConfiguration bucket-lifecycle-configuration
  [m8362]
  (clojure.core/let
   [bean8361
    (new com.amazonaws.services.s3.model.BucketLifecycleConfiguration)]
   (clojure.core/when-let
    [v8363 (:rules m8362)]
    (.
     bean8361
     setRules
     (clojure.core/map
      (clojure.core/fn
       [arg8364]
       (bucket-lifecycle-configuration-rule arg8364))
      v8363)))
   bean8361))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.GetObjectMetadataRequest get-object-metadata-request
  [m8366]
  (clojure.core/let
   [arg8368
    nil
    arg8369
    nil
    bean8365
    (new
     com.amazonaws.services.s3.model.GetObjectMetadataRequest
     arg8368
     arg8369)]
   (clojure.core/when-let
    [v8367 (:key m8366)]
    (. bean8365 setKey (clojure.core/str v8367)))
   (clojure.core/when-let
    [v8367 (:bucket-name m8366)]
    (. bean8365 setBucketName (clojure.core/str v8367)))
   (clojure.core/when-let
    [v8367 (:version-id m8366)]
    (. bean8365 setVersionId (clojure.core/str v8367)))
   bean8365))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.DeleteBucketPolicyRequest delete-bucket-policy-request
  [m8371]
  (clojure.core/let
   [arg8373
    nil
    bean8370
    (new
     com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
     arg8373)]
   (clojure.core/when-let
    [v8372 (:bucket-name m8371)]
    (. bean8370 setBucketName (clojure.core/str v8372)))
   bean8370))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest get-bucket-website-configuration-request
  [m8375]
  (clojure.core/let
   [arg8377
    nil
    bean8374
    (new
     com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
     arg8377)]
   (clojure.core/when-let
    [v8376 (:bucket-name m8375)]
    (. bean8374 setBucketName (clojure.core/str v8376)))
   bean8374))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.DeleteBucketRequest delete-bucket-request
  [m8379]
  (clojure.core/let
   [arg8381
    nil
    bean8378
    (new com.amazonaws.services.s3.model.DeleteBucketRequest arg8381)]
   (clojure.core/when-let
    [v8380 (:bucket-name m8379)]
    (. bean8378 setBucketName (clojure.core/str v8380)))
   bean8378))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.DeleteObjectRequest delete-object-request
  [m8383]
  (clojure.core/let
   [arg8385
    nil
    arg8386
    nil
    bean8382
    (new
     com.amazonaws.services.s3.model.DeleteObjectRequest
     arg8385
     arg8386)]
   (clojure.core/when-let
    [v8384 (:key m8383)]
    (. bean8382 setKey (clojure.core/str v8384)))
   (clojure.core/when-let
    [v8384 (:bucket-name m8383)]
    (. bean8382 setBucketName (clojure.core/str v8384)))
   bean8382))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.CopyPartRequest copy-part-request
  [m8388]
  (clojure.core/let
   [bean8387 (new com.amazonaws.services.s3.model.CopyPartRequest)]
   (clojure.core/when-let
    [v8389 (:part-number m8388)]
    (. bean8387 setPartNumber (clojure.core/int v8389)))
   (clojure.core/when-let
    [v8389 (:upload-id m8388)]
    (. bean8387 setUploadId (clojure.core/str v8389)))
   (clojure.core/when-let
    [v8389 (:source-bucket-name m8388)]
    (. bean8387 setSourceBucketName (clojure.core/str v8389)))
   (clojure.core/when-let
    [v8389 (:source-key m8388)]
    (. bean8387 setSourceKey (clojure.core/str v8389)))
   (clojure.core/when-let
    [v8389 (:source-version-id m8388)]
    (. bean8387 setSourceVersionId (clojure.core/str v8389)))
   (clojure.core/when-let
    [v8389 (:destination-bucket-name m8388)]
    (. bean8387 setDestinationBucketName (clojure.core/str v8389)))
   (clojure.core/when-let
    [v8389 (:destination-key m8388)]
    (. bean8387 setDestinationKey (clojure.core/str v8389)))
   (clojure.core/when-let
    [v8389 (:first-byte m8388)]
    (. bean8387 setFirstByte (clojure.core/long v8389)))
   (clojure.core/when-let
    [v8389 (:last-byte m8388)]
    (. bean8387 setLastByte (clojure.core/long v8389)))
   (clojure.core/when-let
    [v8389 (:matching-etag-constraints m8388)]
    (.
     bean8387
     setMatchingETagConstraints
     (clojure.core/map
      (clojure.core/fn [arg8390] (clojure.core/str arg8390))
      v8389)))
   (clojure.core/when-let
    [v8389 (:nonmatching-etag-constraints m8388)]
    (.
     bean8387
     setNonmatchingETagConstraints
     (clojure.core/map
      (clojure.core/fn [arg8391] (clojure.core/str arg8391))
      v8389)))
   (clojure.core/when-let
    [v8389 (:unmodified-since-constraint m8388)]
    (.
     bean8387
     setUnmodifiedSinceConstraint
     (com.palletops.awaze.common/to-date v8389)))
   (clojure.core/when-let
    [v8389 (:modified-since-constraint m8388)]
    (.
     bean8387
     setModifiedSinceConstraint
     (com.palletops.awaze.common/to-date v8389)))
   bean8387))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.InitiateMultipartUploadRequest initiate-multipart-upload-request
  [m8393]
  (clojure.core/let
   [arg8395
    nil
    arg8396
    nil
    bean8392
    (new
     com.amazonaws.services.s3.model.InitiateMultipartUploadRequest
     arg8395
     arg8396)]
   (clojure.core/when-let
    [v8394 (:key m8393)]
    (. bean8392 setKey (clojure.core/str v8394)))
   (clojure.core/when-let
    [v8394 (:bucket-name m8393)]
    (. bean8392 setBucketName (clojure.core/str v8394)))
   (clojure.core/when-let
    [v8394 (:canned-acl m8393)]
    (. bean8392 setCannedACL (canned-access-control-list v8394)))
   (clojure.core/when-let
    [v8394 (:access-control-list m8393)]
    (. bean8392 setAccessControlList (access-control-list v8394)))
   (clojure.core/when-let
    [v8394 (:storage-class m8393)]
    (. bean8392 setStorageClass (storage-class v8394)))
   (clojure.core/when-let
    [v8394 (:object-metadata m8393)]
    (. bean8392 setObjectMetadata (object-metadata v8394)))
   (clojure.core/when-let
    [v8394 (:redirect-location m8393)]
    (. bean8392 setRedirectLocation (clojure.core/str v8394)))
   bean8392))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.SetBucketPolicyRequest set-bucket-policy-request
  [m8398]
  (clojure.core/let
   [arg8400
    nil
    arg8401
    nil
    bean8397
    (new
     com.amazonaws.services.s3.model.SetBucketPolicyRequest
     arg8400
     arg8401)]
   (clojure.core/when-let
    [v8399 (:bucket-name m8398)]
    (. bean8397 setBucketName (clojure.core/str v8399)))
   (clojure.core/when-let
    [v8399 (:policy-text m8398)]
    (. bean8397 setPolicyText (clojure.core/str v8399)))
   bean8397))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.GeneratePresignedUrlRequest generate-presigned-url-request
  [m8403]
  (clojure.core/let
   [arg8405
    nil
    arg8406
    nil
    bean8402
    (new
     com.amazonaws.services.s3.model.GeneratePresignedUrlRequest
     arg8405
     arg8406)]
   (clojure.core/when-let
    [v8404 (:method m8403)]
    (. bean8402 setMethod (http-method v8404)))
   (clojure.core/when-let
    [v8404 (:key m8403)]
    (. bean8402 setKey (clojure.core/str v8404)))
   (clojure.core/when-let
    [v8404 (:content-type m8403)]
    (. bean8402 setContentType (clojure.core/str v8404)))
   (clojure.core/when-let
    [v8404 (:bucket-name m8403)]
    (. bean8402 setBucketName (clojure.core/str v8404)))
   (clojure.core/when-let
    [v8404 (:expiration m8403)]
    (.
     bean8402
     setExpiration
     (com.palletops.awaze.common/to-date v8404)))
   (clojure.core/when-let
    [v8404 (:response-headers m8403)]
    (. bean8402 setResponseHeaders (response-header-overrides v8404)))
   bean8402))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ListPartsRequest list-parts-request
  [m8408]
  (clojure.core/let
   [arg8410
    nil
    arg8411
    nil
    arg8412
    nil
    bean8407
    (new
     com.amazonaws.services.s3.model.ListPartsRequest
     arg8410
     arg8411
     arg8412)]
   (clojure.core/when-let
    [v8409 (:key m8408)]
    (. bean8407 setKey (clojure.core/str v8409)))
   (clojure.core/when-let
    [v8409 (:bucket-name m8408)]
    (. bean8407 setBucketName (clojure.core/str v8409)))
   (clojure.core/when-let
    [v8409 (:upload-id m8408)]
    (. bean8407 setUploadId (clojure.core/str v8409)))
   (clojure.core/when-let
    [v8409 (:max-parts m8408)]
    (. bean8407 setMaxParts (clojure.core/int v8409)))
   (clojure.core/when-let
    [v8409 (:part-number-marker m8408)]
    (. bean8407 setPartNumberMarker (clojure.core/int v8409)))
   bean8407))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ListBucketsRequest list-buckets-request
  [m8414]
  (clojure.core/let
   [bean8413 (new com.amazonaws.services.s3.model.ListBucketsRequest)]
   bean8413))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest set-bucket-logging-configuration-request
  [m8417]
  (clojure.core/let
   [arg8419
    nil
    arg8420
    nil
    bean8416
    (new
     com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest
     arg8419
     arg8420)]
   (clojure.core/when-let
    [v8418 (:bucket-name m8417)]
    (. bean8416 setBucketName (clojure.core/str v8418)))
   (clojure.core/when-let
    [v8418 (:logging-configuration m8417)]
    (.
     bean8416
     setLoggingConfiguration
     (bucket-logging-configuration v8418)))
   bean8416))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.GetBucketAclRequest get-bucket-acl-request
  [m8422]
  (clojure.core/let
   [arg8424
    nil
    bean8421
    (new com.amazonaws.services.s3.model.GetBucketAclRequest arg8424)]
   bean8421))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.VersionListing version-listing
  [m8426]
  (clojure.core/let
   [bean8425 (new com.amazonaws.services.s3.model.VersionListing)]
   (clojure.core/when-let
    [v8427 (:prefix m8426)]
    (. bean8425 setPrefix (clojure.core/str v8427)))
   (clojure.core/when-let
    [v8427 (:bucket-name m8426)]
    (. bean8425 setBucketName (clojure.core/str v8427)))
   (clojure.core/when-let
    [v8427 (:delimiter m8426)]
    (. bean8425 setDelimiter (clojure.core/str v8427)))
   (clojure.core/when-let
    [v8427 (:key-marker m8426)]
    (. bean8425 setKeyMarker (clojure.core/str v8427)))
   (clojure.core/when-let
    [v8427 (:version-id-marker m8426)]
    (. bean8425 setVersionIdMarker (clojure.core/str v8427)))
   (clojure.core/when-let
    [v8427 (:max-keys m8426)]
    (. bean8425 setMaxKeys (clojure.core/int v8427)))
   (clojure.core/when-let
    [v8427 (:truncated m8426)]
    (. bean8425 setTruncated (clojure.core/boolean v8427)))
   (clojure.core/when-let
    [v8427 (:version-summaries m8426)]
    (.
     bean8425
     setVersionSummaries
     (clojure.core/map
      (clojure.core/fn [arg8428] (s3version-summary arg8428))
      v8427)))
   (clojure.core/when-let
    [v8427 (:common-prefixes m8426)]
    (.
     bean8425
     setCommonPrefixes
     (clojure.core/map
      (clojure.core/fn [arg8429] (clojure.core/str arg8429))
      v8427)))
   (clojure.core/when-let
    [v8427 (:next-key-marker m8426)]
    (. bean8425 setNextKeyMarker (clojure.core/str v8427)))
   (clojure.core/when-let
    [v8427 (:next-version-id-marker m8426)]
    (. bean8425 setNextVersionIdMarker (clojure.core/str v8427)))
   bean8425))
 (clojure.core/defmulti
  s3
  (clojure.core/fn s3 [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-versioning-configuration
   [m8430]
   (clojure.core/let
    [credentials8431 (:credentials m8430) args8432 (:args m8430)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8433
      (com.palletops.awaze.common/aws-client :s3 credentials8431)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8433
       getBucketVersioningConfiguration
       (clojure.core/str (clojure.core/nth args8432 0)))))))
  (clojure.core/defn
   get-bucket-versioning-configuration-map
   {:arglists '[[credentials string-0]],
    :doc "Generate map for getBucketVersioningConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-versioning-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-bucket-versioning-configuration
   {:arglists '[[credentials string-0]],
    :doc "Call getBucketVersioningConfiguration"}
   [credentials8435 & args8436]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8437
     (com.palletops.awaze.common/aws-client :s3 credentials8435)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8437
      getBucketVersioningConfiguration
      (clojure.core/str (clojure.core/nth args8436 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-objects
   [m8438]
   (clojure.core/let
    [credentials8439 (:credentials m8438) args8440 (:args m8438)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8441
      (com.palletops.awaze.common/aws-client :s3 credentials8439)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8441
       deleteObjects
       (delete-objects-request (clojure.core/nth args8440 0)))))))
  (clojure.core/defn
   delete-objects-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector quiet mfa keys bucket-name]}]],
    :doc "Generate map for deleteObjects"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-objects,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-objects
   {:arglists
    '[[credentials
       {:keys [request-metric-collector quiet mfa keys bucket-name]}]],
    :doc "Call deleteObjects"}
   [credentials8444 & args8445]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8447
     (com.palletops.awaze.common/aws-client :s3 credentials8444)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8447
      deleteObjects
      (delete-objects-request (clojure.core/nth args8445 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-acl
   [m8448]
   (clojure.core/let
    [credentials8449 (:credentials m8448) args8450 (:args m8448)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8451
      (com.palletops.awaze.common/aws-client :s3 credentials8449)]
     (clojure.core/case
      (clojure.core/count args8450)
      2
      (clojure.core/let
       [a__552__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8450 0))
          ^com.amazonaws.services.s3.model.CannedAccessControlList b
          (com.palletops.awaze.client-builder/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args8450 1))]
         (clojure.core/reset! a__552__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client8451
           setBucketAcl
           a
           b)))
        (catch
         java.lang.Exception
         e__553__auto__
         (if
          @a__552__auto__
          (throw e__553__auto__)
          (clojure.core/let
           [a__552__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.client-builder/coerce-value-form
               java.lang.String
               (clojure.core/nth args8450 0))
              ^com.amazonaws.services.s3.model.AccessControlList b
              (com.palletops.awaze.client-builder/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args8450 1))]
             (clojure.core/reset! a__552__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client8451
               setBucketAcl
               a
               b)))
            (catch
             java.lang.Exception
             e__553__auto__
             (if
              @a__552__auto__
              (throw e__553__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args8450}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8451
        setBucketAcl
        (set-bucket-acl-request (clojure.core/nth args8450 0))))))))
  (clojure.core/defn
   set-bucket-acl-map
   {:arglists
    '[[credentials string-0 canned-access-control-list-1]
      [credentials
       {:keys [request-metric-collector canned-acl bucket-name acl]}]
      [credentials string-0 {:keys [owner grants]}]],
    :doc "Generate map for setBucketAcl, setBucketAcl, setBucketAcl"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-acl,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-acl,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-bucket-acl
   {:arglists
    '[[credentials string-0 canned-access-control-list-1]
      [credentials
       {:keys [request-metric-collector canned-acl bucket-name acl]}]
      [credentials string-0 {:keys [owner grants]}]],
    :doc "Call setBucketAcl, setBucketAcl, setBucketAcl"}
   [credentials8455 & args8456]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8459
     (com.palletops.awaze.common/aws-client :s3 credentials8455)]
    (clojure.core/case
     (clojure.core/count args8456)
     2
     (clojure.core/let
      [a__552__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8456 0))
         ^com.amazonaws.services.s3.model.CannedAccessControlList b
         (com.palletops.awaze.client-builder/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args8456 1))]
        (clojure.core/reset! a__552__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client8459
          setBucketAcl
          a
          b)))
       (catch
        java.lang.Exception
        e__553__auto__
        (if
         @a__552__auto__
         (throw e__553__auto__)
         (clojure.core/let
          [a__552__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.client-builder/coerce-value-form
              java.lang.String
              (clojure.core/nth args8456 0))
             ^com.amazonaws.services.s3.model.AccessControlList b
             (com.palletops.awaze.client-builder/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args8456 1))]
            (clojure.core/reset! a__552__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client8459
              setBucketAcl
              a
              b)))
           (catch
            java.lang.Exception
            e__553__auto__
            (if
             @a__552__auto__
             (throw e__553__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args8456}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8459
       setBucketAcl
       (set-bucket-acl-request (clojure.core/nth args8456 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-location
   [m8460]
   (clojure.core/let
    [credentials8461 (:credentials m8460) args8462 (:args m8460)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8463
      (com.palletops.awaze.common/aws-client :s3 credentials8461)]
     (clojure.core/case
      (clojure.core/count args8462)
      1
      (clojure.core/let
       [a__552__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8462 0))]
         (clojure.core/reset! a__552__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client8463
           getBucketLocation
           a)))
        (catch
         java.lang.Exception
         e__553__auto__
         (if
          @a__552__auto__
          (throw e__553__auto__)
          (clojure.core/let
           [a__552__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^com.amazonaws.services.s3.model.GetBucketLocationRequest a
              (com.palletops.awaze.client-builder/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketLocationRequest
               (clojure.core/nth args8462 0))]
             (clojure.core/reset! a__552__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client8463
               getBucketLocation
               a)))
            (catch
             java.lang.Exception
             e__553__auto__
             (if
              @a__552__auto__
              (throw e__553__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLocation")
                {:args args8462}))))))))))))))
  (clojure.core/defn
   get-bucket-location-map
   {:arglists
    '[[credentials string-0]
      [credentials {:keys [request-metric-collector bucket-name]}]],
    :doc "Generate map for getBucketLocation, getBucketLocation"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-location,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-bucket-location
   {:arglists
    '[[credentials string-0]
      [credentials {:keys [request-metric-collector bucket-name]}]],
    :doc "Call getBucketLocation, getBucketLocation"}
   [credentials8466 & args8467]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8469
     (com.palletops.awaze.common/aws-client :s3 credentials8466)]
    (clojure.core/case
     (clojure.core/count args8467)
     1
     (clojure.core/let
      [a__552__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8467 0))]
        (clojure.core/reset! a__552__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client8469
          getBucketLocation
          a)))
       (catch
        java.lang.Exception
        e__553__auto__
        (if
         @a__552__auto__
         (throw e__553__auto__)
         (clojure.core/let
          [a__552__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^com.amazonaws.services.s3.model.GetBucketLocationRequest a
             (com.palletops.awaze.client-builder/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketLocationRequest
              (clojure.core/nth args8467 0))]
            (clojure.core/reset! a__552__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client8469
              getBucketLocation
              a)))
           (catch
            java.lang.Exception
            e__553__auto__
            (if
             @a__552__auto__
             (throw e__553__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLocation")
               {:args args8467}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-notification-configuration
   [m8470]
   (clojure.core/let
    [credentials8471 (:credentials m8470) args8472 (:args m8470)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8473
      (com.palletops.awaze.common/aws-client :s3 credentials8471)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8473
       setBucketNotificationConfiguration
       (clojure.core/str (clojure.core/nth args8472 0))
       (bucket-notification-configuration
        (clojure.core/nth args8472 1)))))))
  (clojure.core/defn
   set-bucket-notification-configuration-map
   {:arglists '[[credentials string-0 {:keys [topic-configurations]}]],
    :doc "Generate map for setBucketNotificationConfiguration"}
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-notification-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-bucket-notification-configuration
   {:arglists '[[credentials string-0 {:keys [topic-configurations]}]],
    :doc "Call setBucketNotificationConfiguration"}
   [credentials8475 & args8476]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8477
     (com.palletops.awaze.common/aws-client :s3 credentials8475)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8477
      setBucketNotificationConfiguration
      (clojure.core/str (clojure.core/nth args8476 0))
      (bucket-notification-configuration
       (clojure.core/nth args8476 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object
   [m8478]
   (clojure.core/let
    [credentials8479 (:credentials m8478) args8480 (:args m8478)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8481
      (com.palletops.awaze.common/aws-client :s3 credentials8479)]
     (clojure.core/case
      (clojure.core/count args8480)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8481
        getObject
        (get-object-request (clojure.core/nth args8480 0))))
      2
      (clojure.core/let
       [a__552__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8480 0))
          ^java.lang.String b
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8480 1))]
         (clojure.core/reset! a__552__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client8481
           getObject
           a
           b)))
        (catch
         java.lang.Exception
         e__553__auto__
         (if
          @a__552__auto__
          (throw e__553__auto__)
          (clojure.core/let
           [a__552__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^com.amazonaws.services.s3.model.GetObjectRequest a
              (com.palletops.awaze.client-builder/coerce-value-form
               com.amazonaws.services.s3.model.GetObjectRequest
               (clojure.core/nth args8480 0))
              ^java.io.File b
              (com.palletops.awaze.client-builder/coerce-value-form
               java.io.File
               (clojure.core/nth args8480 1))]
             (clojure.core/reset! a__552__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client8481
               getObject
               a
               b)))
            (catch
             java.lang.Exception
             e__553__auto__
             (if
              @a__552__auto__
              (throw e__553__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getObject")
                {:args args8480}))))))))))))))
  (clojure.core/defn
   get-object-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         general-progress-listener
         response-headers
         key
         bucket-name
         unmodified-since-constraint
         version-id
         range
         modified-since-constraint
         progress-listener
         nonmatching-etag-constraints
         matching-etag-constraints]}]
      [credentials string-0 string-1]
      [credentials
       {:keys
        [request-metric-collector
         general-progress-listener
         response-headers
         key
         bucket-name
         unmodified-since-constraint
         version-id
         range
         modified-since-constraint
         progress-listener
         nonmatching-etag-constraints
         matching-etag-constraints]}
       file-1]],
    :doc "Generate map for getObject, getObject, getObject"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-object,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-object,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-object
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         general-progress-listener
         response-headers
         key
         bucket-name
         unmodified-since-constraint
         version-id
         range
         modified-since-constraint
         progress-listener
         nonmatching-etag-constraints
         matching-etag-constraints]}]
      [credentials string-0 string-1]
      [credentials
       {:keys
        [request-metric-collector
         general-progress-listener
         response-headers
         key
         bucket-name
         unmodified-since-constraint
         version-id
         range
         modified-since-constraint
         progress-listener
         nonmatching-etag-constraints
         matching-etag-constraints]}
       file-1]],
    :doc "Call getObject, getObject, getObject"}
   [credentials8487 & args8488]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8493
     (com.palletops.awaze.common/aws-client :s3 credentials8487)]
    (clojure.core/case
     (clojure.core/count args8488)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8493
       getObject
       (get-object-request (clojure.core/nth args8488 0))))
     2
     (clojure.core/let
      [a__552__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8488 0))
         ^java.lang.String b
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8488 1))]
        (clojure.core/reset! a__552__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client8493
          getObject
          a
          b)))
       (catch
        java.lang.Exception
        e__553__auto__
        (if
         @a__552__auto__
         (throw e__553__auto__)
         (clojure.core/let
          [a__552__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^com.amazonaws.services.s3.model.GetObjectRequest a
             (com.palletops.awaze.client-builder/coerce-value-form
              com.amazonaws.services.s3.model.GetObjectRequest
              (clojure.core/nth args8488 0))
             ^java.io.File b
             (com.palletops.awaze.client-builder/coerce-value-form
              java.io.File
              (clojure.core/nth args8488 1))]
            (clojure.core/reset! a__552__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client8493
              getObject
              a
              b)))
           (catch
            java.lang.Exception
            e__553__auto__
            (if
             @a__552__auto__
             (throw e__553__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getObject")
               {:args args8488}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-website-configuration
   [m8494]
   (clojure.core/let
    [credentials8495 (:credentials m8494) args8496 (:args m8494)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8497
      (com.palletops.awaze.common/aws-client :s3 credentials8495)]
     (clojure.core/case
      (clojure.core/count args8496)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8497
        setBucketWebsiteConfiguration
        (set-bucket-website-configuration-request
         (clojure.core/nth args8496 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8497
        setBucketWebsiteConfiguration
        (clojure.core/str (clojure.core/nth args8496 0))
        (bucket-website-configuration
         (clojure.core/nth args8496 1))))))))
  (clojure.core/defn
   set-bucket-website-configuration-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector configuration bucket-name]}]
      [credentials
       string-0
       {:keys
        [routing-rules
         redirect-all-requests-to
         index-document-suffix
         error-document]}]],
    :doc
    "Generate map for setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-website-configuration,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-website-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-bucket-website-configuration
   {:arglists
    '[[credentials
       {:keys [request-metric-collector configuration bucket-name]}]
      [credentials
       string-0
       {:keys
        [routing-rules
         redirect-all-requests-to
         index-document-suffix
         error-document]}]],
    :doc
    "Call setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   [credentials8501 & args8502]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8505
     (com.palletops.awaze.common/aws-client :s3 credentials8501)]
    (clojure.core/case
     (clojure.core/count args8502)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8505
       setBucketWebsiteConfiguration
       (set-bucket-website-configuration-request
        (clojure.core/nth args8502 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8505
       setBucketWebsiteConfiguration
       (clojure.core/str (clojure.core/nth args8502 0))
       (bucket-website-configuration
        (clojure.core/nth args8502 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :copy-object
   [m8506]
   (clojure.core/let
    [credentials8507 (:credentials m8506) args8508 (:args m8506)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8509
      (com.palletops.awaze.common/aws-client :s3 credentials8507)]
     (clojure.core/case
      (clojure.core/count args8508)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8509
        copyObject
        (copy-object-request (clojure.core/nth args8508 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8509
        copyObject
        (clojure.core/str (clojure.core/nth args8508 0))
        (clojure.core/str (clojure.core/nth args8508 1))
        (clojure.core/str (clojure.core/nth args8508 2))
        (clojure.core/str (clojure.core/nth args8508 3))))))))
  (clojure.core/defn
   copy-object-map
   {:arglists
    '[[credentials
       {:keys
        [source-key
         request-metric-collector
         source-bucket-name
         canned-access-control-list
         unmodified-since-constraint
         access-control-list
         modified-since-constraint
         redirect-location
         new-object-metadata
         nonmatching-etag-constraints
         destination-key
         matching-etag-constraints
         destination-bucket-name
         source-version-id
         storage-class]}]
      [credentials string-0 string-1 string-2 string-3]],
    :doc "Generate map for copyObject, copyObject"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :copy-object,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :copy-object,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   copy-object
   {:arglists
    '[[credentials
       {:keys
        [source-key
         request-metric-collector
         source-bucket-name
         canned-access-control-list
         unmodified-since-constraint
         access-control-list
         modified-since-constraint
         redirect-location
         new-object-metadata
         nonmatching-etag-constraints
         destination-key
         matching-etag-constraints
         destination-bucket-name
         source-version-id
         storage-class]}]
      [credentials string-0 string-1 string-2 string-3]],
    :doc "Call copyObject, copyObject"}
   [credentials8515 & args8516]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8521
     (com.palletops.awaze.common/aws-client :s3 credentials8515)]
    (clojure.core/case
     (clojure.core/count args8516)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8521
       copyObject
       (copy-object-request (clojure.core/nth args8516 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8521
       copyObject
       (clojure.core/str (clojure.core/nth args8516 0))
       (clojure.core/str (clojure.core/nth args8516 1))
       (clojure.core/str (clojure.core/nth args8516 2))
       (clojure.core/str (clojure.core/nth args8516 3))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-cross-origin-configuration
   [m8522]
   (clojure.core/let
    [credentials8523 (:credentials m8522) args8524 (:args m8522)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8525
      (com.palletops.awaze.common/aws-client :s3 credentials8523)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8525
       setBucketCrossOriginConfiguration
       (clojure.core/str (clojure.core/nth args8524 0))
       (bucket-cross-origin-configuration
        (clojure.core/nth args8524 1)))))))
  (clojure.core/defn
   set-bucket-cross-origin-configuration-map
   {:arglists '[[credentials string-0 {:keys [rules]}]],
    :doc "Generate map for setBucketCrossOriginConfiguration"}
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-bucket-cross-origin-configuration
   {:arglists '[[credentials string-0 {:keys [rules]}]],
    :doc "Call setBucketCrossOriginConfiguration"}
   [credentials8527 & args8528]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8529
     (com.palletops.awaze.common/aws-client :s3 credentials8527)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8529
      setBucketCrossOriginConfiguration
      (clojure.core/str (clojure.core/nth args8528 0))
      (bucket-cross-origin-configuration
       (clojure.core/nth args8528 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :does-bucket-exist
   [m8530]
   (clojure.core/let
    [credentials8531 (:credentials m8530) args8532 (:args m8530)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8533
      (com.palletops.awaze.common/aws-client :s3 credentials8531)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8533
       doesBucketExist
       (clojure.core/str (clojure.core/nth args8532 0)))))))
  (clojure.core/defn
   does-bucket-exist-map
   {:arglists '[[credentials string-0]],
    :doc "Generate map for doesBucketExist"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :does-bucket-exist,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   does-bucket-exist
   {:arglists '[[credentials string-0]], :doc "Call doesBucketExist"}
   [credentials8535 & args8536]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8537
     (com.palletops.awaze.common/aws-client :s3 credentials8535)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8537
      doesBucketExist
      (clojure.core/str (clojure.core/nth args8536 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :change-object-storage-class
   [m8538]
   (clojure.core/let
    [credentials8539 (:credentials m8538) args8540 (:args m8538)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8541
      (com.palletops.awaze.common/aws-client :s3 credentials8539)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8541
       changeObjectStorageClass
       (clojure.core/str (clojure.core/nth args8540 0))
       (clojure.core/str (clojure.core/nth args8540 1))
       (storage-class (clojure.core/nth args8540 2)))))))
  (clojure.core/defn
   change-object-storage-class-map
   {:arglists '[[credentials string-0 string-1 storage-class-2]],
    :doc "Generate map for changeObjectStorageClass"}
   ([credentials__577__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :change-object-storage-class,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   change-object-storage-class
   {:arglists '[[credentials string-0 string-1 storage-class-2]],
    :doc "Call changeObjectStorageClass"}
   [credentials8543 & args8544]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8545
     (com.palletops.awaze.common/aws-client :s3 credentials8543)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8545
      changeObjectStorageClass
      (clojure.core/str (clojure.core/nth args8544 0))
      (clojure.core/str (clojure.core/nth args8544 1))
      (storage-class (clojure.core/nth args8544 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-tagging-configuration
   [m8546]
   (clojure.core/let
    [credentials8547 (:credentials m8546) args8548 (:args m8546)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8549
      (com.palletops.awaze.common/aws-client :s3 credentials8547)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8549
       setBucketTaggingConfiguration
       (clojure.core/str (clojure.core/nth args8548 0))
       (bucket-tagging-configuration
        (clojure.core/nth args8548 1)))))))
  (clojure.core/defn
   set-bucket-tagging-configuration-map
   {:arglists '[[credentials string-0 {:keys []}]],
    :doc "Generate map for setBucketTaggingConfiguration"}
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-bucket-tagging-configuration
   {:arglists '[[credentials string-0 {:keys []}]],
    :doc "Call setBucketTaggingConfiguration"}
   [credentials8551 & args8552]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8553
     (com.palletops.awaze.common/aws-client :s3 credentials8551)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8553
      setBucketTaggingConfiguration
      (clojure.core/str (clojure.core/nth args8552 0))
      (bucket-tagging-configuration (clojure.core/nth args8552 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-s3client-options
   [m8554]
   (clojure.core/let
    [credentials8555 (:credentials m8554) args8556 (:args m8554)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8557
      (com.palletops.awaze.common/aws-client :s3 credentials8555)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8557
       setS3ClientOptions
       (s3client-options (clojure.core/nth args8556 0)))))))
  (clojure.core/defn
   set-s3client-options-map
   {:arglists '[[credentials {:keys [path-style-access]}]],
    :doc "Generate map for setS3ClientOptions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-s3client-options,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-s3client-options
   {:arglists '[[credentials {:keys [path-style-access]}]],
    :doc "Call setS3ClientOptions"}
   [credentials8559 & args8560]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8561
     (com.palletops.awaze.common/aws-client :s3 credentials8559)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8561
      setS3ClientOptions
      (s3client-options (clojure.core/nth args8560 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-lifecycle-configuration
   [m8562]
   (clojure.core/let
    [credentials8563 (:credentials m8562) args8564 (:args m8562)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8565
      (com.palletops.awaze.common/aws-client :s3 credentials8563)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8565
       getBucketLifecycleConfiguration
       (clojure.core/str (clojure.core/nth args8564 0)))))))
  (clojure.core/defn
   get-bucket-lifecycle-configuration-map
   {:arglists '[[credentials string-0]],
    :doc "Generate map for getBucketLifecycleConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-lifecycle-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-bucket-lifecycle-configuration
   {:arglists '[[credentials string-0]],
    :doc "Call getBucketLifecycleConfiguration"}
   [credentials8567 & args8568]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8569
     (com.palletops.awaze.common/aws-client :s3 credentials8567)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8569
      getBucketLifecycleConfiguration
      (clojure.core/str (clojure.core/nth args8568 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-resource-url
   [m8570]
   (clojure.core/let
    [credentials8571 (:credentials m8570) args8572 (:args m8570)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8573
      (com.palletops.awaze.common/aws-client :s3 credentials8571)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8573
       getResourceUrl
       (clojure.core/str (clojure.core/nth args8572 0))
       (clojure.core/str (clojure.core/nth args8572 1)))))))
  (clojure.core/defn
   get-resource-url-map
   {:arglists '[[credentials string-0 string-1]],
    :doc "Generate map for getResourceUrl"}
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-resource-url,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-resource-url
   {:arglists '[[credentials string-0 string-1]],
    :doc "Call getResourceUrl"}
   [credentials8575 & args8576]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8577
     (com.palletops.awaze.common/aws-client :s3 credentials8575)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8577
      getResourceUrl
      (clojure.core/str (clojure.core/nth args8576 0))
      (clojure.core/str (clojure.core/nth args8576 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-acl
   [m8578]
   (clojure.core/let
    [credentials8579 (:credentials m8578) args8580 (:args m8578)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8581
      (com.palletops.awaze.common/aws-client :s3 credentials8579)]
     (clojure.core/case
      (clojure.core/count args8580)
      3
      (clojure.core/let
       [a__552__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8580 0))
          ^java.lang.String b
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8580 1))
          ^com.amazonaws.services.s3.model.AccessControlList c
          (com.palletops.awaze.client-builder/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args8580 2))]
         (clojure.core/reset! a__552__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client8581
           setObjectAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__553__auto__
         (if
          @a__552__auto__
          (throw e__553__auto__)
          (clojure.core/let
           [a__552__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.client-builder/coerce-value-form
               java.lang.String
               (clojure.core/nth args8580 0))
              ^java.lang.String b
              (com.palletops.awaze.client-builder/coerce-value-form
               java.lang.String
               (clojure.core/nth args8580 1))
              ^com.amazonaws.services.s3.model.CannedAccessControlList c
              (com.palletops.awaze.client-builder/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args8580 2))]
             (clojure.core/reset! a__552__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client8581
               setObjectAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__553__auto__
             (if
              @a__552__auto__
              (throw e__553__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args8580}))))))))))
      4
      (clojure.core/let
       [a__552__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8580 0))
          ^java.lang.String b
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8580 1))
          ^java.lang.String c
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8580 2))
          ^com.amazonaws.services.s3.model.CannedAccessControlList d
          (com.palletops.awaze.client-builder/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args8580 3))]
         (clojure.core/reset! a__552__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client8581
           setObjectAcl
           a
           b
           c
           d)))
        (catch
         java.lang.Exception
         e__553__auto__
         (if
          @a__552__auto__
          (throw e__553__auto__)
          (clojure.core/let
           [a__552__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.client-builder/coerce-value-form
               java.lang.String
               (clojure.core/nth args8580 0))
              ^java.lang.String b
              (com.palletops.awaze.client-builder/coerce-value-form
               java.lang.String
               (clojure.core/nth args8580 1))
              ^java.lang.String c
              (com.palletops.awaze.client-builder/coerce-value-form
               java.lang.String
               (clojure.core/nth args8580 2))
              ^com.amazonaws.services.s3.model.AccessControlList d
              (com.palletops.awaze.client-builder/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args8580 3))]
             (clojure.core/reset! a__552__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client8581
               setObjectAcl
               a
               b
               c
               d)))
            (catch
             java.lang.Exception
             e__553__auto__
             (if
              @a__552__auto__
              (throw e__553__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args8580}))))))))))))))
  (clojure.core/defn
   set-object-acl-map
   {:arglists
    '[[credentials string-0 string-1 {:keys [owner grants]}]
      [credentials
       string-0
       string-1
       string-2
       canned-access-control-list-3]
      [credentials string-0 string-1 string-2 {:keys [owner grants]}]
      [credentials string-0 string-1 canned-access-control-list-2]],
    :doc
    "Generate map for setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   ([credentials__577__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :set-object-acl,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :set-object-acl,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-object-acl
   {:arglists
    '[[credentials string-0 string-1 {:keys [owner grants]}]
      [credentials
       string-0
       string-1
       string-2
       canned-access-control-list-3]
      [credentials string-0 string-1 string-2 {:keys [owner grants]}]
      [credentials string-0 string-1 canned-access-control-list-2]],
    :doc "Call setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   [credentials8583 & args8584]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8585
     (com.palletops.awaze.common/aws-client :s3 credentials8583)]
    (clojure.core/case
     (clojure.core/count args8584)
     3
     (clojure.core/let
      [a__552__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8584 0))
         ^java.lang.String b
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8584 1))
         ^com.amazonaws.services.s3.model.AccessControlList c
         (com.palletops.awaze.client-builder/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args8584 2))]
        (clojure.core/reset! a__552__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client8585
          setObjectAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__553__auto__
        (if
         @a__552__auto__
         (throw e__553__auto__)
         (clojure.core/let
          [a__552__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.client-builder/coerce-value-form
              java.lang.String
              (clojure.core/nth args8584 0))
             ^java.lang.String b
             (com.palletops.awaze.client-builder/coerce-value-form
              java.lang.String
              (clojure.core/nth args8584 1))
             ^com.amazonaws.services.s3.model.CannedAccessControlList c
             (com.palletops.awaze.client-builder/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args8584 2))]
            (clojure.core/reset! a__552__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client8585
              setObjectAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__553__auto__
            (if
             @a__552__auto__
             (throw e__553__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args8584}))))))))))
     4
     (clojure.core/let
      [a__552__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8584 0))
         ^java.lang.String b
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8584 1))
         ^java.lang.String c
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8584 2))
         ^com.amazonaws.services.s3.model.CannedAccessControlList d
         (com.palletops.awaze.client-builder/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args8584 3))]
        (clojure.core/reset! a__552__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client8585
          setObjectAcl
          a
          b
          c
          d)))
       (catch
        java.lang.Exception
        e__553__auto__
        (if
         @a__552__auto__
         (throw e__553__auto__)
         (clojure.core/let
          [a__552__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.client-builder/coerce-value-form
              java.lang.String
              (clojure.core/nth args8584 0))
             ^java.lang.String b
             (com.palletops.awaze.client-builder/coerce-value-form
              java.lang.String
              (clojure.core/nth args8584 1))
             ^java.lang.String c
             (com.palletops.awaze.client-builder/coerce-value-form
              java.lang.String
              (clojure.core/nth args8584 2))
             ^com.amazonaws.services.s3.model.AccessControlList d
             (com.palletops.awaze.client-builder/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args8584 3))]
            (clojure.core/reset! a__552__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client8585
              setObjectAcl
              a
              b
              c
              d)))
           (catch
            java.lang.Exception
            e__553__auto__
            (if
             @a__552__auto__
             (throw e__553__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args8584}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :restore-object
   [m8586]
   (clojure.core/let
    [credentials8587 (:credentials m8586) args8588 (:args m8586)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8589
      (com.palletops.awaze.common/aws-client :s3 credentials8587)]
     (clojure.core/case
      (clojure.core/count args8588)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8589
        restoreObject
        (restore-object-request (clojure.core/nth args8588 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8589
        restoreObject
        (clojure.core/str (clojure.core/nth args8588 0))
        (clojure.core/str (clojure.core/nth args8588 1))
        (clojure.core/int (clojure.core/nth args8588 2))))))))
  (clojure.core/defn
   restore-object-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector key expiration-in-days bucket-name]}]
      [credentials string-0 string-1 int-2]],
    :doc "Generate map for restoreObject, restoreObject"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :restore-object,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :restore-object,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   restore-object
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector key expiration-in-days bucket-name]}]
      [credentials string-0 string-1 int-2]],
    :doc "Call restoreObject, restoreObject"}
   [credentials8593 & args8594]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8597
     (com.palletops.awaze.common/aws-client :s3 credentials8593)]
    (clojure.core/case
     (clojure.core/count args8594)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8597
       restoreObject
       (restore-object-request (clojure.core/nth args8594 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8597
       restoreObject
       (clojure.core/str (clojure.core/nth args8594 0))
       (clojure.core/str (clojure.core/nth args8594 1))
       (clojure.core/int (clojure.core/nth args8594 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-url
   [m8598]
   (clojure.core/let
    [credentials8599 (:credentials m8598) args8600 (:args m8598)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8601
      (com.palletops.awaze.common/aws-client :s3 credentials8599)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8601
       getUrl
       (clojure.core/str (clojure.core/nth args8600 0))
       (clojure.core/str (clojure.core/nth args8600 1)))))))
  (clojure.core/defn
   get-url-map
   {:arglists '[[credentials string-0 string-1]],
    :doc "Generate map for getUrl"}
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-url,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-url
   {:arglists '[[credentials string-0 string-1]], :doc "Call getUrl"}
   [credentials8603 & args8604]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8605
     (com.palletops.awaze.common/aws-client :s3 credentials8603)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8605
      getUrl
      (clojure.core/str (clojure.core/nth args8604 0))
      (clojure.core/str (clojure.core/nth args8604 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-version
   [m8606]
   (clojure.core/let
    [credentials8607 (:credentials m8606) args8608 (:args m8606)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8609
      (com.palletops.awaze.common/aws-client :s3 credentials8607)]
     (clojure.core/case
      (clojure.core/count args8608)
      3
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8609
        deleteVersion
        (clojure.core/str (clojure.core/nth args8608 0))
        (clojure.core/str (clojure.core/nth args8608 1))
        (clojure.core/str (clojure.core/nth args8608 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8609
        deleteVersion
        (delete-version-request (clojure.core/nth args8608 0))))))))
  (clojure.core/defn
   delete-version-map
   {:arglists
    '[[credentials string-0 string-1 string-2]
      [credentials
       {:keys
        [version-id request-metric-collector mfa key bucket-name]}]],
    :doc "Generate map for deleteVersion, deleteVersion"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-version,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :delete-version,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-version
   {:arglists
    '[[credentials string-0 string-1 string-2]
      [credentials
       {:keys
        [version-id request-metric-collector mfa key bucket-name]}]],
    :doc "Call deleteVersion, deleteVersion"}
   [credentials8614 & args8615]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8619
     (com.palletops.awaze.common/aws-client :s3 credentials8614)]
    (clojure.core/case
     (clojure.core/count args8615)
     3
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8619
       deleteVersion
       (clojure.core/str (clojure.core/nth args8615 0))
       (clojure.core/str (clojure.core/nth args8615 1))
       (clojure.core/str (clojure.core/nth args8615 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8619
       deleteVersion
       (delete-version-request (clojure.core/nth args8615 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-versioning-configuration
   [m8620]
   (clojure.core/let
    [credentials8621 (:credentials m8620) args8622 (:args m8620)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8623
      (com.palletops.awaze.common/aws-client :s3 credentials8621)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8623
       setBucketVersioningConfiguration
       (set-bucket-versioning-configuration-request
        (clojure.core/nth args8622 0)))))))
  (clojure.core/defn
   set-bucket-versioning-configuration-map
   {:arglists
    '[[credentials
       {:keys
        [versioning-configuration
         request-metric-collector
         mfa
         bucket-name]}]],
    :doc "Generate map for setBucketVersioningConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-versioning-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-bucket-versioning-configuration
   {:arglists
    '[[credentials
       {:keys
        [versioning-configuration
         request-metric-collector
         mfa
         bucket-name]}]],
    :doc "Call setBucketVersioningConfiguration"}
   [credentials8627 & args8628]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8631
     (com.palletops.awaze.common/aws-client :s3 credentials8627)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8631
      setBucketVersioningConfiguration
      (set-bucket-versioning-configuration-request
       (clojure.core/nth args8628 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :add-request-handler
   [m8632]
   (clojure.core/let
    [credentials8633 (:credentials m8632) args8634 (:args m8632)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8635
      (com.palletops.awaze.common/aws-client :s3 credentials8633)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8635
       addRequestHandler
       (request-handler (clojure.core/nth args8634 0)))))))
  (clojure.core/defn
   add-request-handler-map
   {:arglists '[[credentials request-handler-0]],
    :doc "Generate map for addRequestHandler"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :add-request-handler,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   add-request-handler
   {:arglists '[[credentials request-handler-0]],
    :doc "Call addRequestHandler"}
   [credentials8637 & args8638]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8639
     (com.palletops.awaze.common/aws-client :s3 credentials8637)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8639
      addRequestHandler
      (request-handler (clojure.core/nth args8638 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-cross-origin-configuration
   [m8640]
   (clojure.core/let
    [credentials8641 (:credentials m8640) args8642 (:args m8640)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8643
      (com.palletops.awaze.common/aws-client :s3 credentials8641)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8643
       getBucketCrossOriginConfiguration
       (clojure.core/str (clojure.core/nth args8642 0)))))))
  (clojure.core/defn
   get-bucket-cross-origin-configuration-map
   {:arglists '[[credentials string-0]],
    :doc "Generate map for getBucketCrossOriginConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-cross-origin-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-bucket-cross-origin-configuration
   {:arglists '[[credentials string-0]],
    :doc "Call getBucketCrossOriginConfiguration"}
   [credentials8645 & args8646]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8647
     (com.palletops.awaze.common/aws-client :s3 credentials8645)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8647
      getBucketCrossOriginConfiguration
      (clojure.core/str (clojure.core/nth args8646 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :create-bucket
   [m8648]
   (clojure.core/let
    [credentials8649 (:credentials m8648) args8650 (:args m8648)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8651
      (com.palletops.awaze.common/aws-client :s3 credentials8649)]
     (clojure.core/case
      (clojure.core/count args8650)
      1
      (clojure.core/let
       [a__552__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8650 0))]
         (clojure.core/reset! a__552__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client8651
           createBucket
           a)))
        (catch
         java.lang.Exception
         e__553__auto__
         (if
          @a__552__auto__
          (throw e__553__auto__)
          (clojure.core/let
           [a__552__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^com.amazonaws.services.s3.model.CreateBucketRequest a
              (com.palletops.awaze.client-builder/coerce-value-form
               com.amazonaws.services.s3.model.CreateBucketRequest
               (clojure.core/nth args8650 0))]
             (clojure.core/reset! a__552__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client8651
               createBucket
               a)))
            (catch
             java.lang.Exception
             e__553__auto__
             (if
              @a__552__auto__
              (throw e__553__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args8650}))))))))))
      2
      (clojure.core/let
       [a__552__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8650 0))
          ^java.lang.String b
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8650 1))]
         (clojure.core/reset! a__552__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client8651
           createBucket
           a
           b)))
        (catch
         java.lang.Exception
         e__553__auto__
         (if
          @a__552__auto__
          (throw e__553__auto__)
          (clojure.core/let
           [a__552__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.client-builder/coerce-value-form
               java.lang.String
               (clojure.core/nth args8650 0))
              ^com.amazonaws.services.s3.model.Region b
              (com.palletops.awaze.client-builder/coerce-value-form
               com.amazonaws.services.s3.model.Region
               (clojure.core/nth args8650 1))]
             (clojure.core/reset! a__552__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client8651
               createBucket
               a
               b)))
            (catch
             java.lang.Exception
             e__553__auto__
             (if
              @a__552__auto__
              (throw e__553__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args8650}))))))))))))))
  (clojure.core/defn
   create-bucket-map
   {:arglists
    '[[credentials string-0]
      [credentials
       {:keys
        [request-metric-collector
         region
         canned-acl
         bucket-name
         access-control-list]}]
      [credentials string-0 string-1]
      [credentials string-0 region-1]],
    :doc
    "Generate map for createBucket, createBucket, createBucket, createBucket"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :create-bucket,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :create-bucket,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-bucket
   {:arglists
    '[[credentials string-0]
      [credentials
       {:keys
        [request-metric-collector
         region
         canned-acl
         bucket-name
         access-control-list]}]
      [credentials string-0 string-1]
      [credentials string-0 region-1]],
    :doc "Call createBucket, createBucket, createBucket, createBucket"}
   [credentials8654 & args8655]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8657
     (com.palletops.awaze.common/aws-client :s3 credentials8654)]
    (clojure.core/case
     (clojure.core/count args8655)
     1
     (clojure.core/let
      [a__552__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8655 0))]
        (clojure.core/reset! a__552__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client8657
          createBucket
          a)))
       (catch
        java.lang.Exception
        e__553__auto__
        (if
         @a__552__auto__
         (throw e__553__auto__)
         (clojure.core/let
          [a__552__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^com.amazonaws.services.s3.model.CreateBucketRequest a
             (com.palletops.awaze.client-builder/coerce-value-form
              com.amazonaws.services.s3.model.CreateBucketRequest
              (clojure.core/nth args8655 0))]
            (clojure.core/reset! a__552__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client8657
              createBucket
              a)))
           (catch
            java.lang.Exception
            e__553__auto__
            (if
             @a__552__auto__
             (throw e__553__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args8655}))))))))))
     2
     (clojure.core/let
      [a__552__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8655 0))
         ^java.lang.String b
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8655 1))]
        (clojure.core/reset! a__552__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client8657
          createBucket
          a
          b)))
       (catch
        java.lang.Exception
        e__553__auto__
        (if
         @a__552__auto__
         (throw e__553__auto__)
         (clojure.core/let
          [a__552__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.client-builder/coerce-value-form
              java.lang.String
              (clojure.core/nth args8655 0))
             ^com.amazonaws.services.s3.model.Region b
             (com.palletops.awaze.client-builder/coerce-value-form
              com.amazonaws.services.s3.model.Region
              (clojure.core/nth args8655 1))]
            (clojure.core/reset! a__552__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client8657
              createBucket
              a
              b)))
           (catch
            java.lang.Exception
            e__553__auto__
            (if
             @a__552__auto__
             (throw e__553__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args8655}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-objects
   [m8658]
   (clojure.core/let
    [credentials8659 (:credentials m8658) args8660 (:args m8658)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8661
      (com.palletops.awaze.common/aws-client :s3 credentials8659)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8661
       listNextBatchOfObjects
       (object-listing (clojure.core/nth args8660 0)))))))
  (clojure.core/defn
   list-next-batch-of-objects-map
   {:arglists
    '[[credentials
       {:keys
        [common-prefixes
         marker
         delimiter
         truncated
         next-marker
         max-keys
         prefix
         object-summaries
         bucket-name]}]],
    :doc "Generate map for listNextBatchOfObjects"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-next-batch-of-objects,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-next-batch-of-objects
   {:arglists
    '[[credentials
       {:keys
        [common-prefixes
         marker
         delimiter
         truncated
         next-marker
         max-keys
         prefix
         object-summaries
         bucket-name]}]],
    :doc "Call listNextBatchOfObjects"}
   [credentials8663 & args8664]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8665
     (com.palletops.awaze.common/aws-client :s3 credentials8663)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8665
      listNextBatchOfObjects
      (object-listing (clojure.core/nth args8664 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :put-object
   [m8666]
   (clojure.core/let
    [credentials8667 (:credentials m8666) args8668 (:args m8666)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8669
      (com.palletops.awaze.common/aws-client :s3 credentials8667)]
     (clojure.core/case
      (clojure.core/count args8668)
      3
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8669
        putObject
        (clojure.core/str (clojure.core/nth args8668 0))
        (clojure.core/str (clojure.core/nth args8668 1))
        (clojure.java.io/file (clojure.core/nth args8668 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8669
        putObject
        (put-object-request (clojure.core/nth args8668 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8669
        putObject
        (clojure.core/str (clojure.core/nth args8668 0))
        (clojure.core/str (clojure.core/nth args8668 1))
        (clojure.java.io/input-stream (clojure.core/nth args8668 2))
        (object-metadata (clojure.core/nth args8668 3))))))))
  (clojure.core/defn
   put-object-map
   {:arglists
    '[[credentials string-0 string-1 file-2]
      [credentials
       {:keys
        [request-metric-collector
         metadata
         general-progress-listener
         canned-acl
         key
         bucket-name
         input-stream
         access-control-list
         progress-listener
         redirect-location
         storage-class
         file]}]
      [credentials
       string-0
       string-1
       input-stream-2
       {:keys
        [expiration-time
         content-md5
         server-side-encryption
         etag
         cache-control
         raw-metadata
         content-disposition
         content-type
         ongoing-restore
         version-id
         restore-expiration-time
         expiration-time-rule-id
         content-length
         http-expires-date
         last-modified
         user-metadata
         content-encoding]}]],
    :doc "Generate map for putObject, putObject, putObject"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :put-object,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :put-object,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :put-object,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   put-object
   {:arglists
    '[[credentials string-0 string-1 file-2]
      [credentials
       {:keys
        [request-metric-collector
         metadata
         general-progress-listener
         canned-acl
         key
         bucket-name
         input-stream
         access-control-list
         progress-listener
         redirect-location
         storage-class
         file]}]
      [credentials
       string-0
       string-1
       input-stream-2
       {:keys
        [expiration-time
         content-md5
         server-side-encryption
         etag
         cache-control
         raw-metadata
         content-disposition
         content-type
         ongoing-restore
         version-id
         restore-expiration-time
         expiration-time-rule-id
         content-length
         http-expires-date
         last-modified
         user-metadata
         content-encoding]}]],
    :doc "Call putObject, putObject, putObject"}
   [credentials8674 & args8675]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8679
     (com.palletops.awaze.common/aws-client :s3 credentials8674)]
    (clojure.core/case
     (clojure.core/count args8675)
     3
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8679
       putObject
       (clojure.core/str (clojure.core/nth args8675 0))
       (clojure.core/str (clojure.core/nth args8675 1))
       (clojure.java.io/file (clojure.core/nth args8675 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8679
       putObject
       (put-object-request (clojure.core/nth args8675 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8679
       putObject
       (clojure.core/str (clojure.core/nth args8675 0))
       (clojure.core/str (clojure.core/nth args8675 1))
       (clojure.java.io/input-stream (clojure.core/nth args8675 2))
       (object-metadata (clojure.core/nth args8675 3))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-policy
   [m8680]
   (clojure.core/let
    [credentials8681 (:credentials m8680) args8682 (:args m8680)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8683
      (com.palletops.awaze.common/aws-client :s3 credentials8681)]
     (clojure.core/case
      (clojure.core/count args8682)
      1
      (clojure.core/let
       [a__552__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8682 0))]
         (clojure.core/reset! a__552__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client8683
           getBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__553__auto__
         (if
          @a__552__auto__
          (throw e__553__auto__)
          (clojure.core/let
           [a__552__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^com.amazonaws.services.s3.model.GetBucketPolicyRequest a
              (com.palletops.awaze.client-builder/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketPolicyRequest
               (clojure.core/nth args8682 0))]
             (clojure.core/reset! a__552__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client8683
               getBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__553__auto__
             (if
              @a__552__auto__
              (throw e__553__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketPolicy")
                {:args args8682}))))))))))))))
  (clojure.core/defn
   get-bucket-policy-map
   {:arglists
    '[[credentials string-0]
      [credentials {:keys [request-metric-collector bucket-name]}]],
    :doc "Generate map for getBucketPolicy, getBucketPolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-bucket-policy
   {:arglists
    '[[credentials string-0]
      [credentials {:keys [request-metric-collector bucket-name]}]],
    :doc "Call getBucketPolicy, getBucketPolicy"}
   [credentials8686 & args8687]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8689
     (com.palletops.awaze.common/aws-client :s3 credentials8686)]
    (clojure.core/case
     (clojure.core/count args8687)
     1
     (clojure.core/let
      [a__552__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8687 0))]
        (clojure.core/reset! a__552__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client8689
          getBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__553__auto__
        (if
         @a__552__auto__
         (throw e__553__auto__)
         (clojure.core/let
          [a__552__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^com.amazonaws.services.s3.model.GetBucketPolicyRequest a
             (com.palletops.awaze.client-builder/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketPolicyRequest
              (clojure.core/nth args8687 0))]
            (clojure.core/reset! a__552__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client8689
              getBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__553__auto__
            (if
             @a__552__auto__
             (throw e__553__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketPolicy")
               {:args args8687}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-objects
   [m8690]
   (clojure.core/let
    [credentials8691 (:credentials m8690) args8692 (:args m8690)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8693
      (com.palletops.awaze.common/aws-client :s3 credentials8691)]
     (clojure.core/case
      (clojure.core/count args8692)
      1
      (clojure.core/let
       [a__552__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8692 0))]
         (clojure.core/reset! a__552__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client8693
           listObjects
           a)))
        (catch
         java.lang.Exception
         e__553__auto__
         (if
          @a__552__auto__
          (throw e__553__auto__)
          (clojure.core/let
           [a__552__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^com.amazonaws.services.s3.model.ListObjectsRequest a
              (com.palletops.awaze.client-builder/coerce-value-form
               com.amazonaws.services.s3.model.ListObjectsRequest
               (clojure.core/nth args8692 0))]
             (clojure.core/reset! a__552__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client8693
               listObjects
               a)))
            (catch
             java.lang.Exception
             e__553__auto__
             (if
              @a__552__auto__
              (throw e__553__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listObjects")
                {:args args8692}))))))))))
      2
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8693
        listObjects
        (clojure.core/str (clojure.core/nth args8692 0))
        (clojure.core/str (clojure.core/nth args8692 1))))))))
  (clojure.core/defn
   list-objects-map
   {:arglists
    '[[credentials string-0]
      [credentials string-0 string-1]
      [credentials
       {:keys
        [request-metric-collector
         prefix
         max-keys
         marker
         delimiter
         bucket-name]}]],
    :doc "Generate map for listObjects, listObjects, listObjects"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-objects,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :list-objects,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-objects
   {:arglists
    '[[credentials string-0]
      [credentials string-0 string-1]
      [credentials
       {:keys
        [request-metric-collector
         prefix
         max-keys
         marker
         delimiter
         bucket-name]}]],
    :doc "Call listObjects, listObjects, listObjects"}
   [credentials8695 & args8696]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8697
     (com.palletops.awaze.common/aws-client :s3 credentials8695)]
    (clojure.core/case
     (clojure.core/count args8696)
     1
     (clojure.core/let
      [a__552__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8696 0))]
        (clojure.core/reset! a__552__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client8697
          listObjects
          a)))
       (catch
        java.lang.Exception
        e__553__auto__
        (if
         @a__552__auto__
         (throw e__553__auto__)
         (clojure.core/let
          [a__552__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^com.amazonaws.services.s3.model.ListObjectsRequest a
             (com.palletops.awaze.client-builder/coerce-value-form
              com.amazonaws.services.s3.model.ListObjectsRequest
              (clojure.core/nth args8696 0))]
            (clojure.core/reset! a__552__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client8697
              listObjects
              a)))
           (catch
            java.lang.Exception
            e__553__auto__
            (if
             @a__552__auto__
             (throw e__553__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listObjects")
               {:args args8696}))))))))))
     2
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8697
       listObjects
       (clojure.core/str (clojure.core/nth args8696 0))
       (clojure.core/str (clojure.core/nth args8696 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :abort-multipart-upload
   [m8698]
   (clojure.core/let
    [credentials8699 (:credentials m8698) args8700 (:args m8698)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8701
      (com.palletops.awaze.common/aws-client :s3 credentials8699)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8701
       abortMultipartUpload
       (abort-multipart-upload-request
        (clojure.core/nth args8700 0)))))))
  (clojure.core/defn
   abort-multipart-upload-map
   {:arglists
    '[[credentials
       {:keys [upload-id request-metric-collector key bucket-name]}]],
    :doc "Generate map for abortMultipartUpload"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :abort-multipart-upload,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   abort-multipart-upload
   {:arglists
    '[[credentials
       {:keys [upload-id request-metric-collector key bucket-name]}]],
    :doc "Call abortMultipartUpload"}
   [credentials8706 & args8707]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8711
     (com.palletops.awaze.common/aws-client :s3 credentials8706)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8711
      abortMultipartUpload
      (abort-multipart-upload-request
       (clojure.core/nth args8707 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :upload-part
   [m8712]
   (clojure.core/let
    [credentials8713 (:credentials m8712) args8714 (:args m8712)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8715
      (com.palletops.awaze.common/aws-client :s3 credentials8713)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8715
       uploadPart
       (upload-part-request (clojure.core/nth args8714 0)))))))
  (clojure.core/defn
   upload-part-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         general-progress-listener
         md5digest
         key
         bucket-name
         part-number
         input-stream
         upload-id
         progress-listener
         file-offset
         last-part
         file
         part-size]}]],
    :doc "Generate map for uploadPart"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :upload-part,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   upload-part
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         general-progress-listener
         md5digest
         key
         bucket-name
         part-number
         input-stream
         upload-id
         progress-listener
         file-offset
         last-part
         file
         part-size]}]],
    :doc "Call uploadPart"}
   [credentials8717 & args8718]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8719
     (com.palletops.awaze.common/aws-client :s3 credentials8717)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8719
      uploadPart
      (upload-part-request (clojure.core/nth args8718 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :complete-multipart-upload
   [m8720]
   (clojure.core/let
    [credentials8721 (:credentials m8720) args8722 (:args m8720)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8723
      (com.palletops.awaze.common/aws-client :s3 credentials8721)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8723
       completeMultipartUpload
       (complete-multipart-upload-request
        (clojure.core/nth args8722 0)))))))
  (clojure.core/defn
   complete-multipart-upload-map
   {:arglists
    '[[credentials
       {:keys
        [upload-id
         request-metric-collector
         part-etags
         key
         bucket-name]}]],
    :doc "Generate map for completeMultipartUpload"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :complete-multipart-upload,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   complete-multipart-upload
   {:arglists
    '[[credentials
       {:keys
        [upload-id
         request-metric-collector
         part-etags
         key
         bucket-name]}]],
    :doc "Call completeMultipartUpload"}
   [credentials8729 & args8730]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8735
     (com.palletops.awaze.common/aws-client :s3 credentials8729)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8735
      completeMultipartUpload
      (complete-multipart-upload-request
       (clojure.core/nth args8730 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :list-versions
   [m8736]
   (clojure.core/let
    [credentials8737 (:credentials m8736) args8738 (:args m8736)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8739
      (com.palletops.awaze.common/aws-client :s3 credentials8737)]
     (clojure.core/case
      (clojure.core/count args8738)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8739
        listVersions
        (list-versions-request (clojure.core/nth args8738 0))))
      6
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8739
        listVersions
        (clojure.core/str (clojure.core/nth args8738 0))
        (clojure.core/str (clojure.core/nth args8738 1))
        (clojure.core/str (clojure.core/nth args8738 2))
        (clojure.core/str (clojure.core/nth args8738 3))
        (clojure.core/str (clojure.core/nth args8738 4))
        (clojure.core/int (clojure.core/nth args8738 5))))
      2
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8739
        listVersions
        (clojure.core/str (clojure.core/nth args8738 0))
        (clojure.core/str (clojure.core/nth args8738 1))))))))
  (clojure.core/defn
   list-versions-map
   {:arglists
    '[[credentials
       {:keys
        [delimiter
         prefix
         key-marker
         bucket-name
         request-metric-collector
         version-id-marker
         max-results]}]
      [credentials
       string-0
       string-1
       string-2
       string-3
       string-4
       integer-5]
      [credentials string-0 string-1]],
    :doc "Generate map for listVersions, listVersions, listVersions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-versions,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :list-versions,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b c d e f]
    {:args [a b c d e f],
     :client :s3,
     :fn :list-versions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-versions
   {:arglists
    '[[credentials
       {:keys
        [delimiter
         prefix
         key-marker
         bucket-name
         request-metric-collector
         version-id-marker
         max-results]}]
      [credentials
       string-0
       string-1
       string-2
       string-3
       string-4
       integer-5]
      [credentials string-0 string-1]],
    :doc "Call listVersions, listVersions, listVersions"}
   [credentials8741 & args8742]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8743
     (com.palletops.awaze.common/aws-client :s3 credentials8741)]
    (clojure.core/case
     (clojure.core/count args8742)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8743
       listVersions
       (list-versions-request (clojure.core/nth args8742 0))))
     6
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8743
       listVersions
       (clojure.core/str (clojure.core/nth args8742 0))
       (clojure.core/str (clojure.core/nth args8742 1))
       (clojure.core/str (clojure.core/nth args8742 2))
       (clojure.core/str (clojure.core/nth args8742 3))
       (clojure.core/str (clojure.core/nth args8742 4))
       (clojure.core/int (clojure.core/nth args8742 5))))
     2
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8743
       listVersions
       (clojure.core/str (clojure.core/nth args8742 0))
       (clojure.core/str (clojure.core/nth args8742 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-redirect-location
   [m8744]
   (clojure.core/let
    [credentials8745 (:credentials m8744) args8746 (:args m8744)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8747
      (com.palletops.awaze.common/aws-client :s3 credentials8745)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8747
       setObjectRedirectLocation
       (clojure.core/str (clojure.core/nth args8746 0))
       (clojure.core/str (clojure.core/nth args8746 1))
       (clojure.core/str (clojure.core/nth args8746 2)))))))
  (clojure.core/defn
   set-object-redirect-location-map
   {:arglists '[[credentials string-0 string-1 string-2]],
    :doc "Generate map for setObjectRedirectLocation"}
   ([credentials__577__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :set-object-redirect-location,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-object-redirect-location
   {:arglists '[[credentials string-0 string-1 string-2]],
    :doc "Call setObjectRedirectLocation"}
   [credentials8749 & args8750]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8751
     (com.palletops.awaze.common/aws-client :s3 credentials8749)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8751
      setObjectRedirectLocation
      (clojure.core/str (clojure.core/nth args8750 0))
      (clojure.core/str (clojure.core/nth args8750 1))
      (clojure.core/str (clojure.core/nth args8750 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-website-configuration
   [m8752]
   (clojure.core/let
    [credentials8753 (:credentials m8752) args8754 (:args m8752)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8755
      (com.palletops.awaze.common/aws-client :s3 credentials8753)]
     (clojure.core/case
      (clojure.core/count args8754)
      1
      (clojure.core/let
       [a__552__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest a
          (com.palletops.awaze.client-builder/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
           (clojure.core/nth args8754 0))]
         (clojure.core/reset! a__552__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client8755
           deleteBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__553__auto__
         (if
          @a__552__auto__
          (throw e__553__auto__)
          (clojure.core/let
           [a__552__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.client-builder/coerce-value-form
               java.lang.String
               (clojure.core/nth args8754 0))]
             (clojure.core/reset! a__552__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client8755
               deleteBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__553__auto__
             (if
              @a__552__auto__
              (throw e__553__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketWebsiteConfiguration")
                {:args args8754}))))))))))))))
  (clojure.core/defn
   delete-bucket-website-configuration-map
   {:arglists
    '[[credentials {:keys [request-metric-collector bucket-name]}]
      [credentials string-0]],
    :doc
    "Generate map for deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-website-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-bucket-website-configuration
   {:arglists
    '[[credentials {:keys [request-metric-collector bucket-name]}]
      [credentials string-0]],
    :doc
    "Call deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   [credentials8758 & args8759]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8761
     (com.palletops.awaze.common/aws-client :s3 credentials8758)]
    (clojure.core/case
     (clojure.core/count args8759)
     1
     (clojure.core/let
      [a__552__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest a
         (com.palletops.awaze.client-builder/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
          (clojure.core/nth args8759 0))]
        (clojure.core/reset! a__552__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client8761
          deleteBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__553__auto__
        (if
         @a__552__auto__
         (throw e__553__auto__)
         (clojure.core/let
          [a__552__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.client-builder/coerce-value-form
              java.lang.String
              (clojure.core/nth args8759 0))]
            (clojure.core/reset! a__552__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client8761
              deleteBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__553__auto__
            (if
             @a__552__auto__
             (throw e__553__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketWebsiteConfiguration")
               {:args args8759}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-multipart-uploads
   [m8762]
   (clojure.core/let
    [credentials8763 (:credentials m8762) args8764 (:args m8762)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8765
      (com.palletops.awaze.common/aws-client :s3 credentials8763)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8765
       listMultipartUploads
       (list-multipart-uploads-request
        (clojure.core/nth args8764 0)))))))
  (clojure.core/defn
   list-multipart-uploads-map
   {:arglists
    '[[credentials
       {:keys
        [delimiter
         upload-id-marker
         max-uploads
         prefix
         key-marker
         bucket-name
         request-metric-collector]}]],
    :doc "Generate map for listMultipartUploads"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-multipart-uploads,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-multipart-uploads
   {:arglists
    '[[credentials
       {:keys
        [delimiter
         upload-id-marker
         max-uploads
         prefix
         key-marker
         bucket-name
         request-metric-collector]}]],
    :doc "Call listMultipartUploads"}
   [credentials8768 & args8769]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8771
     (com.palletops.awaze.common/aws-client :s3 credentials8768)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8771
      listMultipartUploads
      (list-multipart-uploads-request
       (clojure.core/nth args8769 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-lifecycle-configuration
   [m8772]
   (clojure.core/let
    [credentials8773 (:credentials m8772) args8774 (:args m8772)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8775
      (com.palletops.awaze.common/aws-client :s3 credentials8773)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8775
       setBucketLifecycleConfiguration
       (clojure.core/str (clojure.core/nth args8774 0))
       (bucket-lifecycle-configuration
        (clojure.core/nth args8774 1)))))))
  (clojure.core/defn
   set-bucket-lifecycle-configuration-map
   {:arglists '[[credentials string-0 {:keys [rules]}]],
    :doc "Generate map for setBucketLifecycleConfiguration"}
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-bucket-lifecycle-configuration
   {:arglists '[[credentials string-0 {:keys [rules]}]],
    :doc "Call setBucketLifecycleConfiguration"}
   [credentials8777 & args8778]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8779
     (com.palletops.awaze.common/aws-client :s3 credentials8777)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8779
      setBucketLifecycleConfiguration
      (clojure.core/str (clojure.core/nth args8778 0))
      (bucket-lifecycle-configuration
       (clojure.core/nth args8778 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-metadata
   [m8780]
   (clojure.core/let
    [credentials8781 (:credentials m8780) args8782 (:args m8780)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8783
      (com.palletops.awaze.common/aws-client :s3 credentials8781)]
     (clojure.core/case
      (clojure.core/count args8782)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8783
        getObjectMetadata
        (get-object-metadata-request (clojure.core/nth args8782 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8783
        getObjectMetadata
        (clojure.core/str (clojure.core/nth args8782 0))
        (clojure.core/str (clojure.core/nth args8782 1))))))))
  (clojure.core/defn
   get-object-metadata-map
   {:arglists
    '[[credentials
       {:keys [version-id request-metric-collector key bucket-name]}]
      [credentials string-0 string-1]],
    :doc "Generate map for getObjectMetadata, getObjectMetadata"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-object-metadata,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-object-metadata,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-object-metadata
   {:arglists
    '[[credentials
       {:keys [version-id request-metric-collector key bucket-name]}]
      [credentials string-0 string-1]],
    :doc "Call getObjectMetadata, getObjectMetadata"}
   [credentials8787 & args8788]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8791
     (com.palletops.awaze.common/aws-client :s3 credentials8787)]
    (clojure.core/case
     (clojure.core/count args8788)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8791
       getObjectMetadata
       (get-object-metadata-request (clojure.core/nth args8788 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8791
       getObjectMetadata
       (clojure.core/str (clojure.core/nth args8788 0))
       (clojure.core/str (clojure.core/nth args8788 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-cross-origin-configuration
   [m8792]
   (clojure.core/let
    [credentials8793 (:credentials m8792) args8794 (:args m8792)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8795
      (com.palletops.awaze.common/aws-client :s3 credentials8793)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8795
       deleteBucketCrossOriginConfiguration
       (clojure.core/str (clojure.core/nth args8794 0)))))))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration-map
   {:arglists '[[credentials string-0]],
    :doc "Generate map for deleteBucketCrossOriginConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-cross-origin-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration
   {:arglists '[[credentials string-0]],
    :doc "Call deleteBucketCrossOriginConfiguration"}
   [credentials8797 & args8798]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8799
     (com.palletops.awaze.common/aws-client :s3 credentials8797)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8799
      deleteBucketCrossOriginConfiguration
      (clojure.core/str (clojure.core/nth args8798 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-tagging-configuration
   [m8800]
   (clojure.core/let
    [credentials8801 (:credentials m8800) args8802 (:args m8800)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8803
      (com.palletops.awaze.common/aws-client :s3 credentials8801)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8803
       deleteBucketTaggingConfiguration
       (clojure.core/str (clojure.core/nth args8802 0)))))))
  (clojure.core/defn
   delete-bucket-tagging-configuration-map
   {:arglists '[[credentials string-0]],
    :doc "Generate map for deleteBucketTaggingConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-tagging-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-bucket-tagging-configuration
   {:arglists '[[credentials string-0]],
    :doc "Call deleteBucketTaggingConfiguration"}
   [credentials8805 & args8806]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8807
     (com.palletops.awaze.common/aws-client :s3 credentials8805)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8807
      deleteBucketTaggingConfiguration
      (clojure.core/str (clojure.core/nth args8806 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-acl
   [m8808]
   (clojure.core/let
    [credentials8809 (:credentials m8808) args8810 (:args m8808)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8811
      (com.palletops.awaze.common/aws-client :s3 credentials8809)]
     (clojure.core/case
      (clojure.core/count args8810)
      2
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8811
        getObjectAcl
        (clojure.core/str (clojure.core/nth args8810 0))
        (clojure.core/str (clojure.core/nth args8810 1))))
      3
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8811
        getObjectAcl
        (clojure.core/str (clojure.core/nth args8810 0))
        (clojure.core/str (clojure.core/nth args8810 1))
        (clojure.core/str (clojure.core/nth args8810 2))))))))
  (clojure.core/defn
   get-object-acl-map
   {:arglists
    '[[credentials string-0 string-1]
      [credentials string-0 string-1 string-2]],
    :doc "Generate map for getObjectAcl, getObjectAcl"}
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-object-acl,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :get-object-acl,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-object-acl
   {:arglists
    '[[credentials string-0 string-1]
      [credentials string-0 string-1 string-2]],
    :doc "Call getObjectAcl, getObjectAcl"}
   [credentials8813 & args8814]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8815
     (com.palletops.awaze.common/aws-client :s3 credentials8813)]
    (clojure.core/case
     (clojure.core/count args8814)
     2
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8815
       getObjectAcl
       (clojure.core/str (clojure.core/nth args8814 0))
       (clojure.core/str (clojure.core/nth args8814 1))))
     3
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8815
       getObjectAcl
       (clojure.core/str (clojure.core/nth args8814 0))
       (clojure.core/str (clojure.core/nth args8814 1))
       (clojure.core/str (clojure.core/nth args8814 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-policy
   [m8816]
   (clojure.core/let
    [credentials8817 (:credentials m8816) args8818 (:args m8816)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8819
      (com.palletops.awaze.common/aws-client :s3 credentials8817)]
     (clojure.core/case
      (clojure.core/count args8818)
      1
      (clojure.core/let
       [a__552__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8818 0))]
         (clojure.core/reset! a__552__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client8819
           deleteBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__553__auto__
         (if
          @a__552__auto__
          (throw e__553__auto__)
          (clojure.core/let
           [a__552__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^com.amazonaws.services.s3.model.DeleteBucketPolicyRequest a
              (com.palletops.awaze.client-builder/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
               (clojure.core/nth args8818 0))]
             (clojure.core/reset! a__552__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client8819
               deleteBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__553__auto__
             (if
              @a__552__auto__
              (throw e__553__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketPolicy")
                {:args args8818}))))))))))))))
  (clojure.core/defn
   delete-bucket-policy-map
   {:arglists
    '[[credentials string-0]
      [credentials {:keys [request-metric-collector bucket-name]}]],
    :doc "Generate map for deleteBucketPolicy, deleteBucketPolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-bucket-policy
   {:arglists
    '[[credentials string-0]
      [credentials {:keys [request-metric-collector bucket-name]}]],
    :doc "Call deleteBucketPolicy, deleteBucketPolicy"}
   [credentials8822 & args8823]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8825
     (com.palletops.awaze.common/aws-client :s3 credentials8822)]
    (clojure.core/case
     (clojure.core/count args8823)
     1
     (clojure.core/let
      [a__552__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8823 0))]
        (clojure.core/reset! a__552__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client8825
          deleteBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__553__auto__
        (if
         @a__552__auto__
         (throw e__553__auto__)
         (clojure.core/let
          [a__552__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^com.amazonaws.services.s3.model.DeleteBucketPolicyRequest a
             (com.palletops.awaze.client-builder/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
              (clojure.core/nth args8823 0))]
            (clojure.core/reset! a__552__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client8825
              deleteBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__553__auto__
            (if
             @a__552__auto__
             (throw e__553__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketPolicy")
               {:args args8823}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-tagging-configuration
   [m8826]
   (clojure.core/let
    [credentials8827 (:credentials m8826) args8828 (:args m8826)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8829
      (com.palletops.awaze.common/aws-client :s3 credentials8827)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8829
       getBucketTaggingConfiguration
       (clojure.core/str (clojure.core/nth args8828 0)))))))
  (clojure.core/defn
   get-bucket-tagging-configuration-map
   {:arglists '[[credentials string-0]],
    :doc "Generate map for getBucketTaggingConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-tagging-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-bucket-tagging-configuration
   {:arglists '[[credentials string-0]],
    :doc "Call getBucketTaggingConfiguration"}
   [credentials8831 & args8832]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8833
     (com.palletops.awaze.common/aws-client :s3 credentials8831)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8833
      getBucketTaggingConfiguration
      (clojure.core/str (clojure.core/nth args8832 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-website-configuration
   [m8834]
   (clojure.core/let
    [credentials8835 (:credentials m8834) args8836 (:args m8834)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8837
      (com.palletops.awaze.common/aws-client :s3 credentials8835)]
     (clojure.core/case
      (clojure.core/count args8836)
      1
      (clojure.core/let
       [a__552__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.client-builder/coerce-value-form
           java.lang.String
           (clojure.core/nth args8836 0))]
         (clojure.core/reset! a__552__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client8837
           getBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__553__auto__
         (if
          @a__552__auto__
          (throw e__553__auto__)
          (clojure.core/let
           [a__552__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest a
              (com.palletops.awaze.client-builder/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
               (clojure.core/nth args8836 0))]
             (clojure.core/reset! a__552__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client8837
               getBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__553__auto__
             (if
              @a__552__auto__
              (throw e__553__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketWebsiteConfiguration")
                {:args args8836}))))))))))))))
  (clojure.core/defn
   get-bucket-website-configuration-map
   {:arglists
    '[[credentials string-0]
      [credentials {:keys [request-metric-collector bucket-name]}]],
    :doc
    "Generate map for getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-website-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-bucket-website-configuration
   {:arglists
    '[[credentials string-0]
      [credentials {:keys [request-metric-collector bucket-name]}]],
    :doc
    "Call getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   [credentials8840 & args8841]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8843
     (com.palletops.awaze.common/aws-client :s3 credentials8840)]
    (clojure.core/case
     (clojure.core/count args8841)
     1
     (clojure.core/let
      [a__552__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.client-builder/coerce-value-form
          java.lang.String
          (clojure.core/nth args8841 0))]
        (clojure.core/reset! a__552__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client8843
          getBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__553__auto__
        (if
         @a__552__auto__
         (throw e__553__auto__)
         (clojure.core/let
          [a__552__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest a
             (com.palletops.awaze.client-builder/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
              (clojure.core/nth args8841 0))]
            (clojure.core/reset! a__552__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client8843
              getBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__553__auto__
            (if
             @a__552__auto__
             (throw e__553__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketWebsiteConfiguration")
               {:args args8841}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-lifecycle-configuration
   [m8844]
   (clojure.core/let
    [credentials8845 (:credentials m8844) args8846 (:args m8844)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8847
      (com.palletops.awaze.common/aws-client :s3 credentials8845)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8847
       deleteBucketLifecycleConfiguration
       (clojure.core/str (clojure.core/nth args8846 0)))))))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration-map
   {:arglists '[[credentials string-0]],
    :doc "Generate map for deleteBucketLifecycleConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-lifecycle-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration
   {:arglists '[[credentials string-0]],
    :doc "Call deleteBucketLifecycleConfiguration"}
   [credentials8849 & args8850]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8851
     (com.palletops.awaze.common/aws-client :s3 credentials8849)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8851
      deleteBucketLifecycleConfiguration
      (clojure.core/str (clojure.core/nth args8850 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket
   [m8852]
   (clojure.core/let
    [credentials8853 (:credentials m8852) args8854 (:args m8852)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8855
      (com.palletops.awaze.common/aws-client :s3 credentials8853)]
     (clojure.core/case
      (clojure.core/count args8854)
      1
      (clojure.core/let
       [a__552__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^com.amazonaws.services.s3.model.DeleteBucketRequest a
          (com.palletops.awaze.client-builder/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketRequest
           (clojure.core/nth args8854 0))]
         (clojure.core/reset! a__552__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client8855
           deleteBucket
           a)))
        (catch
         java.lang.Exception
         e__553__auto__
         (if
          @a__552__auto__
          (throw e__553__auto__)
          (clojure.core/let
           [a__552__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.client-builder/coerce-value-form
               java.lang.String
               (clojure.core/nth args8854 0))]
             (clojure.core/reset! a__552__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client8855
               deleteBucket
               a)))
            (catch
             java.lang.Exception
             e__553__auto__
             (if
              @a__552__auto__
              (throw e__553__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucket")
                {:args args8854}))))))))))))))
  (clojure.core/defn
   delete-bucket-map
   {:arglists
    '[[credentials {:keys [request-metric-collector bucket-name]}]
      [credentials string-0]],
    :doc "Generate map for deleteBucket, deleteBucket"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-bucket
   {:arglists
    '[[credentials {:keys [request-metric-collector bucket-name]}]
      [credentials string-0]],
    :doc "Call deleteBucket, deleteBucket"}
   [credentials8858 & args8859]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8861
     (com.palletops.awaze.common/aws-client :s3 credentials8858)]
    (clojure.core/case
     (clojure.core/count args8859)
     1
     (clojure.core/let
      [a__552__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^com.amazonaws.services.s3.model.DeleteBucketRequest a
         (com.palletops.awaze.client-builder/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketRequest
          (clojure.core/nth args8859 0))]
        (clojure.core/reset! a__552__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client8861
          deleteBucket
          a)))
       (catch
        java.lang.Exception
        e__553__auto__
        (if
         @a__552__auto__
         (throw e__553__auto__)
         (clojure.core/let
          [a__552__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.client-builder/coerce-value-form
              java.lang.String
              (clojure.core/nth args8859 0))]
            (clojure.core/reset! a__552__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client8861
              deleteBucket
              a)))
           (catch
            java.lang.Exception
            e__553__auto__
            (if
             @a__552__auto__
             (throw e__553__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucket")
               {:args args8859}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-object
   [m8862]
   (clojure.core/let
    [credentials8863 (:credentials m8862) args8864 (:args m8862)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8865
      (com.palletops.awaze.common/aws-client :s3 credentials8863)]
     (clojure.core/case
      (clojure.core/count args8864)
      2
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8865
        deleteObject
        (clojure.core/str (clojure.core/nth args8864 0))
        (clojure.core/str (clojure.core/nth args8864 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8865
        deleteObject
        (delete-object-request (clojure.core/nth args8864 0))))))))
  (clojure.core/defn
   delete-object-map
   {:arglists
    '[[credentials string-0 string-1]
      [credentials
       {:keys [request-metric-collector key bucket-name]}]],
    :doc "Generate map for deleteObject, deleteObject"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-object,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :delete-object,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-object
   {:arglists
    '[[credentials string-0 string-1]
      [credentials
       {:keys [request-metric-collector key bucket-name]}]],
    :doc "Call deleteObject, deleteObject"}
   [credentials8869 & args8870]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8873
     (com.palletops.awaze.common/aws-client :s3 credentials8869)]
    (clojure.core/case
     (clojure.core/count args8870)
     2
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8873
       deleteObject
       (clojure.core/str (clojure.core/nth args8870 0))
       (clojure.core/str (clojure.core/nth args8870 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8873
       deleteObject
       (delete-object-request (clojure.core/nth args8870 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-region
   [m8874]
   (clojure.core/let
    [credentials8875 (:credentials m8874) args8876 (:args m8874)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8877
      (com.palletops.awaze.common/aws-client :s3 credentials8875)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8877
       getRegion)))))
  (clojure.core/defn
   get-region-map
   {:arglists '[[credentials]], :doc "Generate map for getRegion"}
   ([credentials__577__auto__]
    {:args [],
     :client :s3,
     :fn :get-region,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-region
   {:arglists '[[credentials]], :doc "Call getRegion"}
   [credentials8879 & args8880]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8881
     (com.palletops.awaze.common/aws-client :s3 credentials8879)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8881
      getRegion)))))
 (do
  (clojure.core/defmethod
   s3
   :copy-part
   [m8882]
   (clojure.core/let
    [credentials8883 (:credentials m8882) args8884 (:args m8882)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8885
      (com.palletops.awaze.common/aws-client :s3 credentials8883)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8885
       copyPart
       (copy-part-request (clojure.core/nth args8884 0)))))))
  (clojure.core/defn
   copy-part-map
   {:arglists
    '[[credentials
       {:keys
        [source-key
         request-metric-collector
         source-bucket-name
         last-byte
         part-number
         unmodified-since-constraint
         upload-id
         modified-since-constraint
         first-byte
         nonmatching-etag-constraints
         destination-key
         matching-etag-constraints
         destination-bucket-name
         source-version-id]}]],
    :doc "Generate map for copyPart"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :copy-part,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   copy-part
   {:arglists
    '[[credentials
       {:keys
        [source-key
         request-metric-collector
         source-bucket-name
         last-byte
         part-number
         unmodified-since-constraint
         upload-id
         modified-since-constraint
         first-byte
         nonmatching-etag-constraints
         destination-key
         matching-etag-constraints
         destination-bucket-name
         source-version-id]}]],
    :doc "Call copyPart"}
   [credentials8887 & args8888]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8889
     (com.palletops.awaze.common/aws-client :s3 credentials8887)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8889
      copyPart
      (copy-part-request (clojure.core/nth args8888 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :initiate-multipart-upload
   [m8890]
   (clojure.core/let
    [credentials8891 (:credentials m8890) args8892 (:args m8890)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8893
      (com.palletops.awaze.common/aws-client :s3 credentials8891)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8893
       initiateMultipartUpload
       (initiate-multipart-upload-request
        (clojure.core/nth args8892 0)))))))
  (clojure.core/defn
   initiate-multipart-upload-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         canned-acl
         key
         bucket-name
         access-control-list
         redirect-location
         storage-class
         object-metadata]}]],
    :doc "Generate map for initiateMultipartUpload"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :initiate-multipart-upload,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   initiate-multipart-upload
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         canned-acl
         key
         bucket-name
         access-control-list
         redirect-location
         storage-class
         object-metadata]}]],
    :doc "Call initiateMultipartUpload"}
   [credentials8897 & args8898]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8901
     (com.palletops.awaze.common/aws-client :s3 credentials8897)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8901
      initiateMultipartUpload
      (initiate-multipart-upload-request
       (clojure.core/nth args8898 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-policy
   [m8902]
   (clojure.core/let
    [credentials8903 (:credentials m8902) args8904 (:args m8902)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8905
      (com.palletops.awaze.common/aws-client :s3 credentials8903)]
     (clojure.core/case
      (clojure.core/count args8904)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8905
        setBucketPolicy
        (set-bucket-policy-request (clojure.core/nth args8904 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8905
        setBucketPolicy
        (clojure.core/str (clojure.core/nth args8904 0))
        (clojure.core/str (clojure.core/nth args8904 1))))))))
  (clojure.core/defn
   set-bucket-policy-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector policy-text bucket-name]}]
      [credentials string-0 string-1]],
    :doc "Generate map for setBucketPolicy, setBucketPolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-policy,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-bucket-policy
   {:arglists
    '[[credentials
       {:keys [request-metric-collector policy-text bucket-name]}]
      [credentials string-0 string-1]],
    :doc "Call setBucketPolicy, setBucketPolicy"}
   [credentials8909 & args8910]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8913
     (com.palletops.awaze.common/aws-client :s3 credentials8909)]
    (clojure.core/case
     (clojure.core/count args8910)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8913
       setBucketPolicy
       (set-bucket-policy-request (clojure.core/nth args8910 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8913
       setBucketPolicy
       (clojure.core/str (clojure.core/nth args8910 0))
       (clojure.core/str (clojure.core/nth args8910 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-notification-configuration
   [m8914]
   (clojure.core/let
    [credentials8915 (:credentials m8914) args8916 (:args m8914)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8917
      (com.palletops.awaze.common/aws-client :s3 credentials8915)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8917
       getBucketNotificationConfiguration
       (clojure.core/str (clojure.core/nth args8916 0)))))))
  (clojure.core/defn
   get-bucket-notification-configuration-map
   {:arglists '[[credentials string-0]],
    :doc "Generate map for getBucketNotificationConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-notification-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-bucket-notification-configuration
   {:arglists '[[credentials string-0]],
    :doc "Call getBucketNotificationConfiguration"}
   [credentials8919 & args8920]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8921
     (com.palletops.awaze.common/aws-client :s3 credentials8919)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8921
      getBucketNotificationConfiguration
      (clojure.core/str (clojure.core/nth args8920 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :generate-presigned-url
   [m8922]
   (clojure.core/let
    [credentials8923 (:credentials m8922) args8924 (:args m8922)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8925
      (com.palletops.awaze.common/aws-client :s3 credentials8923)]
     (clojure.core/case
      (clojure.core/count args8924)
      4
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8925
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args8924 0))
        (clojure.core/str (clojure.core/nth args8924 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args8924 2))
        (http-method (clojure.core/nth args8924 3))))
      3
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8925
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args8924 0))
        (clojure.core/str (clojure.core/nth args8924 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args8924 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8925
        generatePresignedUrl
        (generate-presigned-url-request
         (clojure.core/nth args8924 0))))))))
  (clojure.core/defn
   generate-presigned-url-map
   {:arglists
    '[[credentials string-0 string-1 date-2 http-method-3]
      [credentials string-0 string-1 date-2]
      [credentials
       {:keys
        [request-metric-collector
         expiration
         response-headers
         key
         method
         bucket-name
         content-type
         request-parameters]}]],
    :doc
    "Generate map for generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :generate-presigned-url,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :generate-presigned-url,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :generate-presigned-url,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   generate-presigned-url
   {:arglists
    '[[credentials string-0 string-1 date-2 http-method-3]
      [credentials string-0 string-1 date-2]
      [credentials
       {:keys
        [request-metric-collector
         expiration
         response-headers
         key
         method
         bucket-name
         content-type
         request-parameters]}]],
    :doc
    "Call generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   [credentials8929 & args8930]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8933
     (com.palletops.awaze.common/aws-client :s3 credentials8929)]
    (clojure.core/case
     (clojure.core/count args8930)
     4
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8933
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args8930 0))
       (clojure.core/str (clojure.core/nth args8930 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args8930 2))
       (http-method (clojure.core/nth args8930 3))))
     3
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8933
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args8930 0))
       (clojure.core/str (clojure.core/nth args8930 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args8930 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8933
       generatePresignedUrl
       (generate-presigned-url-request
        (clojure.core/nth args8930 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-parts
   [m8934]
   (clojure.core/let
    [credentials8935 (:credentials m8934) args8936 (:args m8934)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8937
      (com.palletops.awaze.common/aws-client :s3 credentials8935)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8937
       listParts
       (list-parts-request (clojure.core/nth args8936 0)))))))
  (clojure.core/defn
   list-parts-map
   {:arglists
    '[[credentials
       {:keys
        [upload-id
         request-metric-collector
         part-number-marker
         max-parts
         key
         bucket-name]}]],
    :doc "Generate map for listParts"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-parts,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-parts
   {:arglists
    '[[credentials
       {:keys
        [upload-id
         request-metric-collector
         part-number-marker
         max-parts
         key
         bucket-name]}]],
    :doc "Call listParts"}
   [credentials8942 & args8943]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8947
     (com.palletops.awaze.common/aws-client :s3 credentials8942)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8947
      listParts
      (list-parts-request (clojure.core/nth args8943 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-s3account-owner
   [m8948]
   (clojure.core/let
    [credentials8949 (:credentials m8948) args8950 (:args m8948)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8951
      (com.palletops.awaze.common/aws-client :s3 credentials8949)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8951
       getS3AccountOwner)))))
  (clojure.core/defn
   get-s3account-owner-map
   {:arglists '[[credentials]],
    :doc "Generate map for getS3AccountOwner"}
   ([credentials__577__auto__]
    {:args [],
     :client :s3,
     :fn :get-s3account-owner,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-s3account-owner
   {:arglists '[[credentials]], :doc "Call getS3AccountOwner"}
   [credentials8953 & args8954]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8955
     (com.palletops.awaze.common/aws-client :s3 credentials8953)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8955
      getS3AccountOwner)))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-logging-configuration
   [m8956]
   (clojure.core/let
    [credentials8957 (:credentials m8956) args8958 (:args m8956)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8959
      (com.palletops.awaze.common/aws-client :s3 credentials8957)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8959
       getBucketLoggingConfiguration
       (clojure.core/str (clojure.core/nth args8958 0)))))))
  (clojure.core/defn
   get-bucket-logging-configuration-map
   {:arglists '[[credentials string-0]],
    :doc "Generate map for getBucketLoggingConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-logging-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-bucket-logging-configuration
   {:arglists '[[credentials string-0]],
    :doc "Call getBucketLoggingConfiguration"}
   [credentials8961 & args8962]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8963
     (com.palletops.awaze.common/aws-client :s3 credentials8961)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8963
      getBucketLoggingConfiguration
      (clojure.core/str (clojure.core/nth args8962 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :list-buckets
   [m8964]
   (clojure.core/let
    [credentials8965 (:credentials m8964) args8966 (:args m8964)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8967
      (com.palletops.awaze.common/aws-client :s3 credentials8965)]
     (clojure.core/case
      (clojure.core/count args8966)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8967
        listBuckets
        (list-buckets-request (clojure.core/nth args8966 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client8967
        listBuckets))))))
  (clojure.core/defn
   list-buckets-map
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc "Generate map for listBuckets, listBuckets"}
   ([credentials__577__auto__]
    {:args [],
     :client :s3,
     :fn :list-buckets,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-buckets,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-buckets
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc "Call listBuckets, listBuckets"}
   [credentials8969 & args8970]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8971
     (com.palletops.awaze.common/aws-client :s3 credentials8969)]
    (clojure.core/case
     (clojure.core/count args8970)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8971
       listBuckets
       (list-buckets-request (clojure.core/nth args8970 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8971
       listBuckets))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-logging-configuration
   [m8972]
   (clojure.core/let
    [credentials8973 (:credentials m8972) args8974 (:args m8972)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8975
      (com.palletops.awaze.common/aws-client :s3 credentials8973)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8975
       setBucketLoggingConfiguration
       (set-bucket-logging-configuration-request
        (clojure.core/nth args8974 0)))))))
  (clojure.core/defn
   set-bucket-logging-configuration-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         logging-configuration
         bucket-name]}]],
    :doc "Generate map for setBucketLoggingConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-logging-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-bucket-logging-configuration
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         logging-configuration
         bucket-name]}]],
    :doc "Call setBucketLoggingConfiguration"}
   [credentials8979 & args8980]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8983
     (com.palletops.awaze.common/aws-client :s3 credentials8979)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client8983
      setBucketLoggingConfiguration
      (set-bucket-logging-configuration-request
       (clojure.core/nth args8980 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-acl
   [m8984]
   (clojure.core/let
    [credentials8985 (:credentials m8984) args8986 (:args m8984)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8987
      (com.palletops.awaze.common/aws-client :s3 credentials8985)]
     (clojure.core/case
      (clojure.core/count args8986)
      1
      (clojure.core/let
       [a__552__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^com.amazonaws.services.s3.model.GetBucketAclRequest a
          (com.palletops.awaze.client-builder/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketAclRequest
           (clojure.core/nth args8986 0))]
         (clojure.core/reset! a__552__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client8987
           getBucketAcl
           a)))
        (catch
         java.lang.Exception
         e__553__auto__
         (if
          @a__552__auto__
          (throw e__553__auto__)
          (clojure.core/let
           [a__552__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.client-builder/coerce-value-form
               java.lang.String
               (clojure.core/nth args8986 0))]
             (clojure.core/reset! a__552__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client8987
               getBucketAcl
               a)))
            (catch
             java.lang.Exception
             e__553__auto__
             (if
              @a__552__auto__
              (throw e__553__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketAcl")
                {:args args8986}))))))))))))))
  (clojure.core/defn
   get-bucket-acl-map
   {:arglists
    '[[credentials {:keys [request-metric-collector bucket-name]}]
      [credentials string-0]],
    :doc "Generate map for getBucketAcl, getBucketAcl"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-acl,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-bucket-acl
   {:arglists
    '[[credentials {:keys [request-metric-collector bucket-name]}]
      [credentials string-0]],
    :doc "Call getBucketAcl, getBucketAcl"}
   [credentials8990 & args8991]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client8993
     (com.palletops.awaze.common/aws-client :s3 credentials8990)]
    (clojure.core/case
     (clojure.core/count args8991)
     1
     (clojure.core/let
      [a__552__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^com.amazonaws.services.s3.model.GetBucketAclRequest a
         (com.palletops.awaze.client-builder/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketAclRequest
          (clojure.core/nth args8991 0))]
        (clojure.core/reset! a__552__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client8993
          getBucketAcl
          a)))
       (catch
        java.lang.Exception
        e__553__auto__
        (if
         @a__552__auto__
         (throw e__553__auto__)
         (clojure.core/let
          [a__552__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.client-builder/coerce-value-form
              java.lang.String
              (clojure.core/nth args8991 0))]
            (clojure.core/reset! a__552__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client8993
              getBucketAcl
              a)))
           (catch
            java.lang.Exception
            e__553__auto__
            (if
             @a__552__auto__
             (throw e__553__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketAcl")
               {:args args8991}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-versions
   [m8994]
   (clojure.core/let
    [credentials8995 (:credentials m8994) args8996 (:args m8994)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client8997
      (com.palletops.awaze.common/aws-client :s3 credentials8995)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client8997
       listNextBatchOfVersions
       (version-listing (clojure.core/nth args8996 0)))))))
  (clojure.core/defn
   list-next-batch-of-versions-map
   {:arglists
    '[[credentials
       {:keys
        [prefix
         bucket-name
         common-prefixes
         version-summaries
         max-keys
         truncated
         key-marker
         next-key-marker
         delimiter
         next-version-id-marker
         version-id-marker]}]],
    :doc "Generate map for listNextBatchOfVersions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-next-batch-of-versions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-next-batch-of-versions
   {:arglists
    '[[credentials
       {:keys
        [prefix
         bucket-name
         common-prefixes
         version-summaries
         max-keys
         truncated
         key-marker
         next-key-marker
         delimiter
         next-version-id-marker
         version-id-marker]}]],
    :doc "Call listNextBatchOfVersions"}
   [credentials8999 & args9000]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9001
     (com.palletops.awaze.common/aws-client :s3 credentials8999)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9001
      listNextBatchOfVersions
      (version-listing (clojure.core/nth args9000 0))))))))
