(ns com.palletops.awaze.route53 (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :route53
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.route53.AmazonRoute53Client
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ResourceRecordSetFailover resource-record-set-failover
  [m9352]
  (java.lang.Enum/valueOf
   com.amazonaws.services.route53.model.ResourceRecordSetFailover
   (clojure.core/name m9352)))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ResourceRecord resource-record
  [m9355]
  (clojure.core/let
   [bean9354 (new com.amazonaws.services.route53.model.ResourceRecord)]
   (clojure.core/when-let
    [v9356 (:value m9355)]
    (. bean9354 setValue (clojure.core/str v9356)))
   bean9354))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.AliasTarget alias-target
  [m9358]
  (clojure.core/let
   [bean9357 (new com.amazonaws.services.route53.model.AliasTarget)]
   (clojure.core/when-let
    [v9359 (:dnsname m9358)]
    (. bean9357 setDNSName (clojure.core/str v9359)))
   (clojure.core/when-let
    [v9359 (:hosted-zone-id m9358)]
    (. bean9357 setHostedZoneId (clojure.core/str v9359)))
   (clojure.core/when-let
    [v9359 (:evaluate-target-health m9358)]
    (. bean9357 setEvaluateTargetHealth (clojure.core/boolean v9359)))
   bean9357))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ResourceRecordSetRegion resource-record-set-region
  [m9361]
  (java.lang.Enum/valueOf
   com.amazonaws.services.route53.model.ResourceRecordSetRegion
   (clojure.core/name m9361)))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.RRType rrtype
  [m9364]
  (java.lang.Enum/valueOf
   com.amazonaws.services.route53.model.RRType
   (clojure.core/name m9364)))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ChangeAction change-action
  [m9367]
  (java.lang.Enum/valueOf
   com.amazonaws.services.route53.model.ChangeAction
   (clojure.core/name m9367)))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ResourceRecordSet resource-record-set
  [m9370]
  (clojure.core/let
   [bean9369
    (new com.amazonaws.services.route53.model.ResourceRecordSet)]
   (clojure.core/when-let
    [v9371 (:name m9370)]
    (. bean9369 setName (clojure.core/str v9371)))
   (clojure.core/when-let
    [v9371 (:health-check-id m9370)]
    (. bean9369 setHealthCheckId (clojure.core/str v9371)))
   (clojure.core/when-let
    [v9371 (:set-identifier m9370)]
    (. bean9369 setSetIdentifier (clojure.core/str v9371)))
   (clojure.core/when-let
    [v9371 (:weight m9370)]
    (. bean9369 setWeight (clojure.core/long v9371)))
   (clojure.core/when-let
    [v9371 (:failover m9370)]
    (. bean9369 setFailover (clojure.core/str v9371)))
   (clojure.core/when-let
    [v9371 (:failover m9370)]
    (. bean9369 setFailover (resource-record-set-failover v9371)))
   (clojure.core/when-let
    [v9371 (:ttl m9370)]
    (. bean9369 setTTL (clojure.core/long v9371)))
   (clojure.core/when-let
    [v9371 (:resource-records m9370)]
    (.
     bean9369
     setResourceRecords
     (clojure.core/map
      (clojure.core/fn [arg9372] (resource-record arg9372))
      v9371)))
   (clojure.core/when-let
    [v9371 (:alias-target m9370)]
    (. bean9369 setAliasTarget (alias-target v9371)))
   (clojure.core/when-let
    [v9371 (:region m9370)]
    (. bean9369 setRegion (clojure.core/str v9371)))
   (clojure.core/when-let
    [v9371 (:region m9370)]
    (. bean9369 setRegion (resource-record-set-region v9371)))
   (clojure.core/when-let
    [v9371 (:type m9370)]
    (. bean9369 setType (clojure.core/str v9371)))
   (clojure.core/when-let
    [v9371 (:type m9370)]
    (. bean9369 setType (rrtype v9371)))
   bean9369))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.Change change
  [m9374]
  (clojure.core/let
   [bean9373 (new com.amazonaws.services.route53.model.Change)]
   (clojure.core/when-let
    [v9375 (:action m9374)]
    (. bean9373 setAction (clojure.core/str v9375)))
   (clojure.core/when-let
    [v9375 (:action m9374)]
    (. bean9373 setAction (change-action v9375)))
   (clojure.core/when-let
    [v9375 (:resource-record-set m9374)]
    (. bean9373 setResourceRecordSet (resource-record-set v9375)))
   bean9373))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.HealthCheckType health-check-type
  [m9377]
  (java.lang.Enum/valueOf
   com.amazonaws.services.route53.model.HealthCheckType
   (clojure.core/name m9377)))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ChangeBatch change-batch
  [m9380]
  (clojure.core/let
   [bean9379 (new com.amazonaws.services.route53.model.ChangeBatch)]
   (clojure.core/when-let
    [v9381 (:comment m9380)]
    (. bean9379 setComment (clojure.core/str v9381)))
   (clojure.core/when-let
    [v9381 (:changes m9380)]
    (.
     bean9379
     setChanges
     (clojure.core/map
      (clojure.core/fn [arg9382] (change arg9382))
      v9381)))
   bean9379))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.HealthCheckConfig health-check-config
  [m9384]
  (clojure.core/let
   [bean9383
    (new com.amazonaws.services.route53.model.HealthCheckConfig)]
   (clojure.core/when-let
    [v9385 (:port m9384)]
    (. bean9383 setPort (clojure.core/int v9385)))
   (clojure.core/when-let
    [v9385 (:fully-qualified-domain-name m9384)]
    (. bean9383 setFullyQualifiedDomainName (clojure.core/str v9385)))
   (clojure.core/when-let
    [v9385 (:ipaddress m9384)]
    (. bean9383 setIPAddress (clojure.core/str v9385)))
   (clojure.core/when-let
    [v9385 (:resource-path m9384)]
    (. bean9383 setResourcePath (clojure.core/str v9385)))
   (clojure.core/when-let
    [v9385 (:type m9384)]
    (. bean9383 setType (health-check-type v9385)))
   (clojure.core/when-let
    [v9385 (:type m9384)]
    (. bean9383 setType (clojure.core/str v9385)))
   bean9383))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.HostedZoneConfig hosted-zone-config
  [m9387]
  (clojure.core/let
   [bean9386
    (new com.amazonaws.services.route53.model.HostedZoneConfig)]
   (clojure.core/when-let
    [v9388 (:comment m9387)]
    (. bean9386 setComment (clojure.core/str v9388)))
   bean9386))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.GetHostedZoneRequest get-hosted-zone-request
  [m9390]
  (clojure.core/let
   [bean9389
    (new com.amazonaws.services.route53.model.GetHostedZoneRequest)]
   (clojure.core/when-let
    [v9391 (:id m9390)]
    (. bean9389 setId (clojure.core/str v9391)))
   bean9389))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ListHostedZonesRequest list-hosted-zones-request
  [m9393]
  (clojure.core/let
   [bean9392
    (new com.amazonaws.services.route53.model.ListHostedZonesRequest)]
   (clojure.core/when-let
    [v9394 (:max-items m9393)]
    (. bean9392 setMaxItems (clojure.core/str v9394)))
   (clojure.core/when-let
    [v9394 (:marker m9393)]
    (. bean9392 setMarker (clojure.core/str v9394)))
   bean9392))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ListResourceRecordSetsRequest list-resource-record-sets-request
  [m9396]
  (clojure.core/let
   [bean9395
    (new
     com.amazonaws.services.route53.model.ListResourceRecordSetsRequest)]
   (clojure.core/when-let
    [v9397 (:max-items m9396)]
    (. bean9395 setMaxItems (clojure.core/str v9397)))
   (clojure.core/when-let
    [v9397 (:hosted-zone-id m9396)]
    (. bean9395 setHostedZoneId (clojure.core/str v9397)))
   (clojure.core/when-let
    [v9397 (:start-record-name m9396)]
    (. bean9395 setStartRecordName (clojure.core/str v9397)))
   (clojure.core/when-let
    [v9397 (:start-record-type m9396)]
    (. bean9395 setStartRecordType (rrtype v9397)))
   (clojure.core/when-let
    [v9397 (:start-record-type m9396)]
    (. bean9395 setStartRecordType (clojure.core/str v9397)))
   (clojure.core/when-let
    [v9397 (:start-record-identifier m9396)]
    (. bean9395 setStartRecordIdentifier (clojure.core/str v9397)))
   bean9395))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest change-resource-record-sets-request
  [m9399]
  (clojure.core/let
   [bean9398
    (new
     com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest)]
   (clojure.core/when-let
    [v9400 (:hosted-zone-id m9399)]
    (. bean9398 setHostedZoneId (clojure.core/str v9400)))
   (clojure.core/when-let
    [v9400 (:change-batch m9399)]
    (. bean9398 setChangeBatch (change-batch v9400)))
   bean9398))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ListHealthChecksRequest list-health-checks-request
  [m9402]
  (clojure.core/let
   [bean9401
    (new com.amazonaws.services.route53.model.ListHealthChecksRequest)]
   (clojure.core/when-let
    [v9403 (:max-items m9402)]
    (. bean9401 setMaxItems (clojure.core/str v9403)))
   (clojure.core/when-let
    [v9403 (:marker m9402)]
    (. bean9401 setMarker (clojure.core/str v9403)))
   bean9401))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.CreateHealthCheckRequest create-health-check-request
  [m9405]
  (clojure.core/let
   [bean9404
    (new
     com.amazonaws.services.route53.model.CreateHealthCheckRequest)]
   (clojure.core/when-let
    [v9406 (:caller-reference m9405)]
    (. bean9404 setCallerReference (clojure.core/str v9406)))
   (clojure.core/when-let
    [v9406 (:health-check-config m9405)]
    (. bean9404 setHealthCheckConfig (health-check-config v9406)))
   bean9404))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.GetHealthCheckRequest get-health-check-request
  [m9408]
  (clojure.core/let
   [bean9407
    (new com.amazonaws.services.route53.model.GetHealthCheckRequest)]
   (clojure.core/when-let
    [v9409 (:health-check-id m9408)]
    (. bean9407 setHealthCheckId (clojure.core/str v9409)))
   bean9407))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.DeleteHostedZoneRequest delete-hosted-zone-request
  [m9411]
  (clojure.core/let
   [bean9410
    (new com.amazonaws.services.route53.model.DeleteHostedZoneRequest)]
   (clojure.core/when-let
    [v9412 (:id m9411)]
    (. bean9410 setId (clojure.core/str v9412)))
   bean9410))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.GetChangeRequest get-change-request
  [m9414]
  (clojure.core/let
   [bean9413
    (new com.amazonaws.services.route53.model.GetChangeRequest)]
   (clojure.core/when-let
    [v9415 (:id m9414)]
    (. bean9413 setId (clojure.core/str v9415)))
   bean9413))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.DeleteHealthCheckRequest delete-health-check-request
  [m9417]
  (clojure.core/let
   [bean9416
    (new
     com.amazonaws.services.route53.model.DeleteHealthCheckRequest)]
   (clojure.core/when-let
    [v9418 (:health-check-id m9417)]
    (. bean9416 setHealthCheckId (clojure.core/str v9418)))
   bean9416))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.CreateHostedZoneRequest create-hosted-zone-request
  [m9420]
  (clojure.core/let
   [bean9419
    (new com.amazonaws.services.route53.model.CreateHostedZoneRequest)]
   (clojure.core/when-let
    [v9421 (:name m9420)]
    (. bean9419 setName (clojure.core/str v9421)))
   (clojure.core/when-let
    [v9421 (:caller-reference m9420)]
    (. bean9419 setCallerReference (clojure.core/str v9421)))
   (clojure.core/when-let
    [v9421 (:hosted-zone-config m9420)]
    (. bean9419 setHostedZoneConfig (hosted-zone-config v9421)))
   bean9419))
 (clojure.core/defmulti
  route53
  (clojure.core/fn route53 [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   route53
   :get-hosted-zone
   [m9422]
   (clojure.core/let
    [credentials9423 (:credentials m9422) args9424 (:args m9422)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client9425
      (com.palletops.awaze.common/aws-client :route53 credentials9423)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client9425
       getHostedZone
       (get-hosted-zone-request (clojure.core/nth args9424 0)))))))
  (clojure.core/defn
   get-hosted-zone-map
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Generate map for getHostedZone"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :route53,
     :fn :get-hosted-zone,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-hosted-zone
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Call getHostedZone"}
   [credentials9427 & args9428]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client9429
     (com.palletops.awaze.common/aws-client :route53 credentials9427)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client9429
      getHostedZone
      (get-hosted-zone-request (clojure.core/nth args9428 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-hosted-zones
   [m9430]
   (clojure.core/let
    [credentials9431 (:credentials m9430) args9432 (:args m9430)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client9433
      (com.palletops.awaze.common/aws-client :route53 credentials9431)]
     (clojure.core/case
      (clojure.core/count args9432)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.route53.AmazonRoute53Client client9433
        listHostedZones
        (list-hosted-zones-request (clojure.core/nth args9432 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.route53.AmazonRoute53Client client9433
        listHostedZones))))))
  (clojure.core/defn
   list-hosted-zones-map
   {:arglists
    '[[credentials {:keys [request-metric-collector max-items marker]}]
      [credentials]],
    :doc "Generate map for listHostedZones, listHostedZones"}
   ([credentials__577__auto__]
    {:args [],
     :client :route53,
     :fn :list-hosted-zones,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :route53,
     :fn :list-hosted-zones,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-hosted-zones
   {:arglists
    '[[credentials {:keys [request-metric-collector max-items marker]}]
      [credentials]],
    :doc "Call listHostedZones, listHostedZones"}
   [credentials9435 & args9436]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client9437
     (com.palletops.awaze.common/aws-client :route53 credentials9435)]
    (clojure.core/case
     (clojure.core/count args9436)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client9437
       listHostedZones
       (list-hosted-zones-request (clojure.core/nth args9436 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client9437
       listHostedZones))))))
 (do
  (clojure.core/defmethod
   route53
   :list-resource-record-sets
   [m9438]
   (clojure.core/let
    [credentials9439 (:credentials m9438) args9440 (:args m9438)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client9441
      (com.palletops.awaze.common/aws-client :route53 credentials9439)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client9441
       listResourceRecordSets
       (list-resource-record-sets-request
        (clojure.core/nth args9440 0)))))))
  (clojure.core/defn
   list-resource-record-sets-map
   {:arglists
    '[[credentials
       {:keys
        [start-record-type
         start-record-name
         start-record-identifier
         request-metric-collector
         max-items
         hosted-zone-id]}]],
    :doc "Generate map for listResourceRecordSets"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :route53,
     :fn :list-resource-record-sets,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-resource-record-sets
   {:arglists
    '[[credentials
       {:keys
        [start-record-type
         start-record-name
         start-record-identifier
         request-metric-collector
         max-items
         hosted-zone-id]}]],
    :doc "Call listResourceRecordSets"}
   [credentials9443 & args9444]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client9445
     (com.palletops.awaze.common/aws-client :route53 credentials9443)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client9445
      listResourceRecordSets
      (list-resource-record-sets-request
       (clojure.core/nth args9444 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :change-resource-record-sets
   [m9446]
   (clojure.core/let
    [credentials9447 (:credentials m9446) args9448 (:args m9446)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client9449
      (com.palletops.awaze.common/aws-client :route53 credentials9447)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client9449
       changeResourceRecordSets
       (change-resource-record-sets-request
        (clojure.core/nth args9448 0)))))))
  (clojure.core/defn
   change-resource-record-sets-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector hosted-zone-id change-batch]}]],
    :doc "Generate map for changeResourceRecordSets"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :route53,
     :fn :change-resource-record-sets,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   change-resource-record-sets
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector hosted-zone-id change-batch]}]],
    :doc "Call changeResourceRecordSets"}
   [credentials9451 & args9452]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client9453
     (com.palletops.awaze.common/aws-client :route53 credentials9451)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client9453
      changeResourceRecordSets
      (change-resource-record-sets-request
       (clojure.core/nth args9452 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-health-checks
   [m9454]
   (clojure.core/let
    [credentials9455 (:credentials m9454) args9456 (:args m9454)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client9457
      (com.palletops.awaze.common/aws-client :route53 credentials9455)]
     (clojure.core/case
      (clojure.core/count args9456)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.route53.AmazonRoute53Client client9457
        listHealthChecks
        (list-health-checks-request (clojure.core/nth args9456 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.route53.AmazonRoute53Client client9457
        listHealthChecks))))))
  (clojure.core/defn
   list-health-checks-map
   {:arglists
    '[[credentials {:keys [request-metric-collector max-items marker]}]
      [credentials]],
    :doc "Generate map for listHealthChecks, listHealthChecks"}
   ([credentials__577__auto__]
    {:args [],
     :client :route53,
     :fn :list-health-checks,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :route53,
     :fn :list-health-checks,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-health-checks
   {:arglists
    '[[credentials {:keys [request-metric-collector max-items marker]}]
      [credentials]],
    :doc "Call listHealthChecks, listHealthChecks"}
   [credentials9459 & args9460]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client9461
     (com.palletops.awaze.common/aws-client :route53 credentials9459)]
    (clojure.core/case
     (clojure.core/count args9460)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client9461
       listHealthChecks
       (list-health-checks-request (clojure.core/nth args9460 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client9461
       listHealthChecks))))))
 (do
  (clojure.core/defmethod
   route53
   :create-health-check
   [m9462]
   (clojure.core/let
    [credentials9463 (:credentials m9462) args9464 (:args m9462)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client9465
      (com.palletops.awaze.common/aws-client :route53 credentials9463)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client9465
       createHealthCheck
       (create-health-check-request (clojure.core/nth args9464 0)))))))
  (clojure.core/defn
   create-health-check-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         health-check-config
         caller-reference]}]],
    :doc "Generate map for createHealthCheck"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :route53,
     :fn :create-health-check,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-health-check
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         health-check-config
         caller-reference]}]],
    :doc "Call createHealthCheck"}
   [credentials9467 & args9468]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client9469
     (com.palletops.awaze.common/aws-client :route53 credentials9467)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client9469
      createHealthCheck
      (create-health-check-request (clojure.core/nth args9468 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check
   [m9470]
   (clojure.core/let
    [credentials9471 (:credentials m9470) args9472 (:args m9470)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client9473
      (com.palletops.awaze.common/aws-client :route53 credentials9471)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client9473
       getHealthCheck
       (get-health-check-request (clojure.core/nth args9472 0)))))))
  (clojure.core/defn
   get-health-check-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector health-check-id]}]],
    :doc "Generate map for getHealthCheck"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :route53,
     :fn :get-health-check,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-health-check
   {:arglists
    '[[credentials
       {:keys [request-metric-collector health-check-id]}]],
    :doc "Call getHealthCheck"}
   [credentials9475 & args9476]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client9477
     (com.palletops.awaze.common/aws-client :route53 credentials9475)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client9477
      getHealthCheck
      (get-health-check-request (clojure.core/nth args9476 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-hosted-zone
   [m9478]
   (clojure.core/let
    [credentials9479 (:credentials m9478) args9480 (:args m9478)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client9481
      (com.palletops.awaze.common/aws-client :route53 credentials9479)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client9481
       deleteHostedZone
       (delete-hosted-zone-request (clojure.core/nth args9480 0)))))))
  (clojure.core/defn
   delete-hosted-zone-map
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Generate map for deleteHostedZone"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :route53,
     :fn :delete-hosted-zone,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-hosted-zone
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Call deleteHostedZone"}
   [credentials9483 & args9484]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client9485
     (com.palletops.awaze.common/aws-client :route53 credentials9483)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client9485
      deleteHostedZone
      (delete-hosted-zone-request (clojure.core/nth args9484 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-change
   [m9486]
   (clojure.core/let
    [credentials9487 (:credentials m9486) args9488 (:args m9486)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client9489
      (com.palletops.awaze.common/aws-client :route53 credentials9487)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client9489
       getChange
       (get-change-request (clojure.core/nth args9488 0)))))))
  (clojure.core/defn
   get-change-map
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Generate map for getChange"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :route53,
     :fn :get-change,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-change
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Call getChange"}
   [credentials9491 & args9492]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client9493
     (com.palletops.awaze.common/aws-client :route53 credentials9491)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client9493
      getChange
      (get-change-request (clojure.core/nth args9492 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-health-check
   [m9494]
   (clojure.core/let
    [credentials9495 (:credentials m9494) args9496 (:args m9494)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client9497
      (com.palletops.awaze.common/aws-client :route53 credentials9495)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client9497
       deleteHealthCheck
       (delete-health-check-request (clojure.core/nth args9496 0)))))))
  (clojure.core/defn
   delete-health-check-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector health-check-id]}]],
    :doc "Generate map for deleteHealthCheck"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :route53,
     :fn :delete-health-check,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-health-check
   {:arglists
    '[[credentials
       {:keys [request-metric-collector health-check-id]}]],
    :doc "Call deleteHealthCheck"}
   [credentials9499 & args9500]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client9501
     (com.palletops.awaze.common/aws-client :route53 credentials9499)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client9501
      deleteHealthCheck
      (delete-health-check-request (clojure.core/nth args9500 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-hosted-zone
   [m9502]
   (clojure.core/let
    [credentials9503 (:credentials m9502) args9504 (:args m9502)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client9505
      (com.palletops.awaze.common/aws-client :route53 credentials9503)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client9505
       createHostedZone
       (create-hosted-zone-request (clojure.core/nth args9504 0)))))))
  (clojure.core/defn
   create-hosted-zone-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         name
         hosted-zone-config
         caller-reference]}]],
    :doc "Generate map for createHostedZone"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :route53,
     :fn :create-hosted-zone,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-hosted-zone
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         name
         hosted-zone-config
         caller-reference]}]],
    :doc "Call createHostedZone"}
   [credentials9507 & args9508]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client9509
     (com.palletops.awaze.common/aws-client :route53 credentials9507)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client9509
      createHostedZone
      (create-hosted-zone-request (clojure.core/nth args9508 0))))))))
