(ns com.palletops.awaze.redshift (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :redshift
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.redshift.AmazonRedshiftClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.Parameter parameter
  [m1200]
  (clojure.core/let
   [bean1199 (new com.amazonaws.services.redshift.model.Parameter)]
   (clojure.core/when-let
    [v1201 (:source m1200)]
    (. bean1199 setSource (clojure.core/str v1201)))
   (clojure.core/when-let
    [v1201 (:description m1200)]
    (. bean1199 setDescription (clojure.core/str v1201)))
   (clojure.core/when-let
    [v1201 (:parameter-name m1200)]
    (. bean1199 setParameterName (clojure.core/str v1201)))
   (clojure.core/when-let
    [v1201 (:parameter-value m1200)]
    (. bean1199 setParameterValue (clojure.core/str v1201)))
   (clojure.core/when-let
    [v1201 (:data-type m1200)]
    (. bean1199 setDataType (clojure.core/str v1201)))
   (clojure.core/when-let
    [v1201 (:allowed-values m1200)]
    (. bean1199 setAllowedValues (clojure.core/str v1201)))
   (clojure.core/when-let
    [v1201 (:is-modifiable m1200)]
    (. bean1199 setIsModifiable (clojure.core/boolean v1201)))
   (clojure.core/when-let
    [v1201 (:minimum-engine-version m1200)]
    (. bean1199 setMinimumEngineVersion (clojure.core/str v1201)))
   bean1199))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.SourceType source-type
  [m1203]
  (java.lang.Enum/valueOf
   com.amazonaws.services.redshift.model.SourceType
   (clojure.core/name m1203)))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest describe-cluster-security-groups-request
  [m1206]
  (clojure.core/let
   [bean1205
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest)]
   (clojure.core/when-let
    [v1207 (:marker m1206)]
    (. bean1205 setMarker (clojure.core/str v1207)))
   (clojure.core/when-let
    [v1207 (:cluster-security-group-name m1206)]
    (. bean1205 setClusterSecurityGroupName (clojure.core/str v1207)))
   (clojure.core/when-let
    [v1207 (:max-records m1206)]
    (. bean1205 setMaxRecords (clojure.core/int v1207)))
   bean1205))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest describe-cluster-parameter-groups-request
  [m1209]
  (clojure.core/let
   [bean1208
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest)]
   (clojure.core/when-let
    [v1210 (:marker m1209)]
    (. bean1208 setMarker (clojure.core/str v1210)))
   (clojure.core/when-let
    [v1210 (:parameter-group-name m1209)]
    (. bean1208 setParameterGroupName (clojure.core/str v1210)))
   (clojure.core/when-let
    [v1210 (:max-records m1209)]
    (. bean1208 setMaxRecords (clojure.core/int v1210)))
   bean1208))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.CreateClusterRequest create-cluster-request
  [m1212]
  (clojure.core/let
   [bean1211
    (new com.amazonaws.services.redshift.model.CreateClusterRequest)]
   (clojure.core/when-let
    [v1213 (:port m1212)]
    (. bean1211 setPort (clojure.core/int v1213)))
   (clojure.core/when-let
    [v1213 (:cluster-identifier m1212)]
    (. bean1211 setClusterIdentifier (clojure.core/str v1213)))
   (clojure.core/when-let
    [v1213 (:availability-zone m1212)]
    (. bean1211 setAvailabilityZone (clojure.core/str v1213)))
   (clojure.core/when-let
    [v1213 (:master-username m1212)]
    (. bean1211 setMasterUsername (clojure.core/str v1213)))
   (clojure.core/when-let
    [v1213 (:cluster-version m1212)]
    (. bean1211 setClusterVersion (clojure.core/str v1213)))
   (clojure.core/when-let
    [v1213 (:node-type m1212)]
    (. bean1211 setNodeType (clojure.core/str v1213)))
   (clojure.core/when-let
    [v1213 (:number-of-nodes m1212)]
    (. bean1211 setNumberOfNodes (clojure.core/int v1213)))
   (clojure.core/when-let
    [v1213 (:dbname m1212)]
    (. bean1211 setDBName (clojure.core/str v1213)))
   (clojure.core/when-let
    [v1213 (:encrypted m1212)]
    (. bean1211 setEncrypted (clojure.core/boolean v1213)))
   (clojure.core/when-let
    [v1213 (:cluster-security-groups m1212)]
    (.
     bean1211
     setClusterSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg1214] (clojure.core/str arg1214))
      v1213)))
   (clojure.core/when-let
    [v1213 (:automated-snapshot-retention-period m1212)]
    (.
     bean1211
     setAutomatedSnapshotRetentionPeriod
     (clojure.core/int v1213)))
   (clojure.core/when-let
    [v1213 (:cluster-subnet-group-name m1212)]
    (. bean1211 setClusterSubnetGroupName (clojure.core/str v1213)))
   (clojure.core/when-let
    [v1213 (:preferred-maintenance-window m1212)]
    (.
     bean1211
     setPreferredMaintenanceWindow
     (clojure.core/str v1213)))
   (clojure.core/when-let
    [v1213 (:allow-version-upgrade m1212)]
    (. bean1211 setAllowVersionUpgrade (clojure.core/boolean v1213)))
   (clojure.core/when-let
    [v1213 (:publicly-accessible m1212)]
    (. bean1211 setPubliclyAccessible (clojure.core/boolean v1213)))
   (clojure.core/when-let
    [v1213 (:cluster-type m1212)]
    (. bean1211 setClusterType (clojure.core/str v1213)))
   (clojure.core/when-let
    [v1213 (:vpc-security-group-ids m1212)]
    (.
     bean1211
     setVpcSecurityGroupIds
     (clojure.core/map
      (clojure.core/fn [arg1215] (clojure.core/str arg1215))
      v1213)))
   (clojure.core/when-let
    [v1213 (:master-user-password m1212)]
    (. bean1211 setMasterUserPassword (clojure.core/str v1213)))
   (clojure.core/when-let
    [v1213 (:cluster-parameter-group-name m1212)]
    (. bean1211 setClusterParameterGroupName (clojure.core/str v1213)))
   bean1211))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest authorize-snapshot-access-request
  [m1217]
  (clojure.core/let
   [bean1216
    (new
     com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest)]
   (clojure.core/when-let
    [v1218 (:snapshot-identifier m1217)]
    (. bean1216 setSnapshotIdentifier (clojure.core/str v1218)))
   (clojure.core/when-let
    [v1218 (:snapshot-cluster-identifier m1217)]
    (. bean1216 setSnapshotClusterIdentifier (clojure.core/str v1218)))
   (clojure.core/when-let
    [v1218 (:account-with-restore-access m1217)]
    (. bean1216 setAccountWithRestoreAccess (clojure.core/str v1218)))
   bean1216))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest describe-cluster-subnet-groups-request
  [m1220]
  (clojure.core/let
   [bean1219
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest)]
   (clojure.core/when-let
    [v1221 (:marker m1220)]
    (. bean1219 setMarker (clojure.core/str v1221)))
   (clojure.core/when-let
    [v1221 (:max-records m1220)]
    (. bean1219 setMaxRecords (clojure.core/int v1221)))
   (clojure.core/when-let
    [v1221 (:cluster-subnet-group-name m1220)]
    (. bean1219 setClusterSubnetGroupName (clojure.core/str v1221)))
   bean1219))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeClustersRequest describe-clusters-request
  [m1223]
  (clojure.core/let
   [bean1222
    (new
     com.amazonaws.services.redshift.model.DescribeClustersRequest)]
   (clojure.core/when-let
    [v1224 (:marker m1223)]
    (. bean1222 setMarker (clojure.core/str v1224)))
   (clojure.core/when-let
    [v1224 (:cluster-identifier m1223)]
    (. bean1222 setClusterIdentifier (clojure.core/str v1224)))
   (clojure.core/when-let
    [v1224 (:max-records m1223)]
    (. bean1222 setMaxRecords (clojure.core/int v1224)))
   bean1222))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest restore-from-cluster-snapshot-request
  [m1226]
  (clojure.core/let
   [bean1225
    (new
     com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest)]
   (clojure.core/when-let
    [v1227 (:port m1226)]
    (. bean1225 setPort (clojure.core/int v1227)))
   (clojure.core/when-let
    [v1227 (:snapshot-identifier m1226)]
    (. bean1225 setSnapshotIdentifier (clojure.core/str v1227)))
   (clojure.core/when-let
    [v1227 (:snapshot-cluster-identifier m1226)]
    (. bean1225 setSnapshotClusterIdentifier (clojure.core/str v1227)))
   (clojure.core/when-let
    [v1227 (:cluster-identifier m1226)]
    (. bean1225 setClusterIdentifier (clojure.core/str v1227)))
   (clojure.core/when-let
    [v1227 (:availability-zone m1226)]
    (. bean1225 setAvailabilityZone (clojure.core/str v1227)))
   (clojure.core/when-let
    [v1227 (:owner-account m1226)]
    (. bean1225 setOwnerAccount (clojure.core/str v1227)))
   (clojure.core/when-let
    [v1227 (:cluster-subnet-group-name m1226)]
    (. bean1225 setClusterSubnetGroupName (clojure.core/str v1227)))
   (clojure.core/when-let
    [v1227 (:allow-version-upgrade m1226)]
    (. bean1225 setAllowVersionUpgrade (clojure.core/boolean v1227)))
   (clojure.core/when-let
    [v1227 (:publicly-accessible m1226)]
    (. bean1225 setPubliclyAccessible (clojure.core/boolean v1227)))
   bean1225))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest revoke-snapshot-access-request
  [m1229]
  (clojure.core/let
   [bean1228
    (new
     com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest)]
   (clojure.core/when-let
    [v1230 (:snapshot-identifier m1229)]
    (. bean1228 setSnapshotIdentifier (clojure.core/str v1230)))
   (clojure.core/when-let
    [v1230 (:snapshot-cluster-identifier m1229)]
    (. bean1228 setSnapshotClusterIdentifier (clojure.core/str v1230)))
   (clojure.core/when-let
    [v1230 (:account-with-restore-access m1229)]
    (. bean1228 setAccountWithRestoreAccess (clojure.core/str v1230)))
   bean1228))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest delete-cluster-security-group-request
  [m1232]
  (clojure.core/let
   [bean1231
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest)]
   (clojure.core/when-let
    [v1233 (:cluster-security-group-name m1232)]
    (. bean1231 setClusterSecurityGroupName (clojure.core/str v1233)))
   bean1231))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeClusterParametersRequest describe-cluster-parameters-request
  [m1235]
  (clojure.core/let
   [bean1234
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParametersRequest)]
   (clojure.core/when-let
    [v1236 (:source m1235)]
    (. bean1234 setSource (clojure.core/str v1236)))
   (clojure.core/when-let
    [v1236 (:marker m1235)]
    (. bean1234 setMarker (clojure.core/str v1236)))
   (clojure.core/when-let
    [v1236 (:parameter-group-name m1235)]
    (. bean1234 setParameterGroupName (clojure.core/str v1236)))
   (clojure.core/when-let
    [v1236 (:max-records m1235)]
    (. bean1234 setMaxRecords (clojure.core/int v1236)))
   bean1234))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest reset-cluster-parameter-group-request
  [m1238]
  (clojure.core/let
   [bean1237
    (new
     com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v1239 (:parameters m1238)]
    (.
     bean1237
     setParameters
     (clojure.core/map
      (clojure.core/fn [arg1240] (parameter arg1240))
      v1239)))
   (clojure.core/when-let
    [v1239 (:parameter-group-name m1238)]
    (. bean1237 setParameterGroupName (clojure.core/str v1239)))
   (clojure.core/when-let
    [v1239 (:reset-all-parameters m1238)]
    (. bean1237 setResetAllParameters (clojure.core/boolean v1239)))
   bean1237))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest create-cluster-parameter-group-request
  [m1242]
  (clojure.core/let
   [bean1241
    (new
     com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v1243 (:parameter-group-name m1242)]
    (. bean1241 setParameterGroupName (clojure.core/str v1243)))
   (clojure.core/when-let
    [v1243 (:description m1242)]
    (. bean1241 setDescription (clojure.core/str v1243)))
   (clojure.core/when-let
    [v1243 (:parameter-group-family m1242)]
    (. bean1241 setParameterGroupFamily (clojure.core/str v1243)))
   bean1241))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeReservedNodesRequest describe-reserved-nodes-request
  [m1245]
  (clojure.core/let
   [bean1244
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodesRequest)]
   (clojure.core/when-let
    [v1246 (:marker m1245)]
    (. bean1244 setMarker (clojure.core/str v1246)))
   (clojure.core/when-let
    [v1246 (:max-records m1245)]
    (. bean1244 setMaxRecords (clojure.core/int v1246)))
   (clojure.core/when-let
    [v1246 (:reserved-node-id m1245)]
    (. bean1244 setReservedNodeId (clojure.core/str v1246)))
   bean1244))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest copy-cluster-snapshot-request
  [m1248]
  (clojure.core/let
   [bean1247
    (new
     com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest)]
   (clojure.core/when-let
    [v1249 (:source-snapshot-identifier m1248)]
    (. bean1247 setSourceSnapshotIdentifier (clojure.core/str v1249)))
   (clojure.core/when-let
    [v1249 (:source-snapshot-cluster-identifier m1248)]
    (.
     bean1247
     setSourceSnapshotClusterIdentifier
     (clojure.core/str v1249)))
   (clojure.core/when-let
    [v1249 (:target-snapshot-identifier m1248)]
    (. bean1247 setTargetSnapshotIdentifier (clojure.core/str v1249)))
   bean1247))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest modify-cluster-subnet-group-request
  [m1251]
  (clojure.core/let
   [bean1250
    (new
     com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest)]
   (clojure.core/when-let
    [v1252 (:cluster-subnet-group-name m1251)]
    (. bean1250 setClusterSubnetGroupName (clojure.core/str v1252)))
   (clojure.core/when-let
    [v1252 (:description m1251)]
    (. bean1250 setDescription (clojure.core/str v1252)))
   (clojure.core/when-let
    [v1252 (:subnet-ids m1251)]
    (.
     bean1250
     setSubnetIds
     (clojure.core/map
      (clojure.core/fn [arg1253] (clojure.core/str arg1253))
      v1252)))
   bean1250))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeEventsRequest describe-events-request
  [m1255]
  (clojure.core/let
   [bean1254
    (new com.amazonaws.services.redshift.model.DescribeEventsRequest)]
   (clojure.core/when-let
    [v1256 (:marker m1255)]
    (. bean1254 setMarker (clojure.core/str v1256)))
   (clojure.core/when-let
    [v1256 (:max-records m1255)]
    (. bean1254 setMaxRecords (clojure.core/int v1256)))
   (clojure.core/when-let
    [v1256 (:start-time m1255)]
    (.
     bean1254
     setStartTime
     (com.palletops.awaze.common/to-date v1256)))
   (clojure.core/when-let
    [v1256 (:duration m1255)]
    (. bean1254 setDuration (clojure.core/int v1256)))
   (clojure.core/when-let
    [v1256 (:source-identifier m1255)]
    (. bean1254 setSourceIdentifier (clojure.core/str v1256)))
   (clojure.core/when-let
    [v1256 (:source-type m1255)]
    (. bean1254 setSourceType (clojure.core/str v1256)))
   (clojure.core/when-let
    [v1256 (:source-type m1255)]
    (. bean1254 setSourceType (source-type v1256)))
   (clojure.core/when-let
    [v1256 (:end-time m1255)]
    (. bean1254 setEndTime (com.palletops.awaze.common/to-date v1256)))
   bean1254))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest delete-cluster-parameter-group-request
  [m1258]
  (clojure.core/let
   [bean1257
    (new
     com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v1259 (:parameter-group-name m1258)]
    (. bean1257 setParameterGroupName (clojure.core/str v1259)))
   bean1257))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest authorize-cluster-security-group-ingress-request
  [m1261]
  (clojure.core/let
   [bean1260
    (new
     com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v1262 (:cluster-security-group-name m1261)]
    (. bean1260 setClusterSecurityGroupName (clojure.core/str v1262)))
   (clojure.core/when-let
    [v1262 (:cidrip m1261)]
    (. bean1260 setCIDRIP (clojure.core/str v1262)))
   (clojure.core/when-let
    [v1262 (:ec2security-group-name m1261)]
    (. bean1260 setEC2SecurityGroupName (clojure.core/str v1262)))
   (clojure.core/when-let
    [v1262 (:ec2security-group-owner-id m1261)]
    (. bean1260 setEC2SecurityGroupOwnerId (clojure.core/str v1262)))
   bean1260))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.ModifyClusterRequest modify-cluster-request
  [m1264]
  (clojure.core/let
   [bean1263
    (new com.amazonaws.services.redshift.model.ModifyClusterRequest)]
   (clojure.core/when-let
    [v1265 (:cluster-identifier m1264)]
    (. bean1263 setClusterIdentifier (clojure.core/str v1265)))
   (clojure.core/when-let
    [v1265 (:cluster-version m1264)]
    (. bean1263 setClusterVersion (clojure.core/str v1265)))
   (clojure.core/when-let
    [v1265 (:node-type m1264)]
    (. bean1263 setNodeType (clojure.core/str v1265)))
   (clojure.core/when-let
    [v1265 (:number-of-nodes m1264)]
    (. bean1263 setNumberOfNodes (clojure.core/int v1265)))
   (clojure.core/when-let
    [v1265 (:cluster-security-groups m1264)]
    (.
     bean1263
     setClusterSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg1266] (clojure.core/str arg1266))
      v1265)))
   (clojure.core/when-let
    [v1265 (:automated-snapshot-retention-period m1264)]
    (.
     bean1263
     setAutomatedSnapshotRetentionPeriod
     (clojure.core/int v1265)))
   (clojure.core/when-let
    [v1265 (:preferred-maintenance-window m1264)]
    (.
     bean1263
     setPreferredMaintenanceWindow
     (clojure.core/str v1265)))
   (clojure.core/when-let
    [v1265 (:allow-version-upgrade m1264)]
    (. bean1263 setAllowVersionUpgrade (clojure.core/boolean v1265)))
   (clojure.core/when-let
    [v1265 (:cluster-type m1264)]
    (. bean1263 setClusterType (clojure.core/str v1265)))
   (clojure.core/when-let
    [v1265 (:vpc-security-group-ids m1264)]
    (.
     bean1263
     setVpcSecurityGroupIds
     (clojure.core/map
      (clojure.core/fn [arg1267] (clojure.core/str arg1267))
      v1265)))
   (clojure.core/when-let
    [v1265 (:master-user-password m1264)]
    (. bean1263 setMasterUserPassword (clojure.core/str v1265)))
   (clojure.core/when-let
    [v1265 (:cluster-parameter-group-name m1264)]
    (. bean1263 setClusterParameterGroupName (clojure.core/str v1265)))
   bean1263))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest delete-cluster-subnet-group-request
  [m1269]
  (clojure.core/let
   [bean1268
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest)]
   (clojure.core/when-let
    [v1270 (:cluster-subnet-group-name m1269)]
    (. bean1268 setClusterSubnetGroupName (clojure.core/str v1270)))
   bean1268))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest create-cluster-subnet-group-request
  [m1272]
  (clojure.core/let
   [bean1271
    (new
     com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest)]
   (clojure.core/when-let
    [v1273 (:cluster-subnet-group-name m1272)]
    (. bean1271 setClusterSubnetGroupName (clojure.core/str v1273)))
   (clojure.core/when-let
    [v1273 (:description m1272)]
    (. bean1271 setDescription (clojure.core/str v1273)))
   (clojure.core/when-let
    [v1273 (:subnet-ids m1272)]
    (.
     bean1271
     setSubnetIds
     (clojure.core/map
      (clojure.core/fn [arg1274] (clojure.core/str arg1274))
      v1273)))
   bean1271))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest purchase-reserved-node-offering-request
  [m1276]
  (clojure.core/let
   [bean1275
    (new
     com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest)]
   (clojure.core/when-let
    [v1277 (:reserved-node-offering-id m1276)]
    (. bean1275 setReservedNodeOfferingId (clojure.core/str v1277)))
   (clojure.core/when-let
    [v1277 (:node-count m1276)]
    (. bean1275 setNodeCount (clojure.core/int v1277)))
   bean1275))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest describe-reserved-node-offerings-request
  [m1279]
  (clojure.core/let
   [bean1278
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest)]
   (clojure.core/when-let
    [v1280 (:marker m1279)]
    (. bean1278 setMarker (clojure.core/str v1280)))
   (clojure.core/when-let
    [v1280 (:max-records m1279)]
    (. bean1278 setMaxRecords (clojure.core/int v1280)))
   (clojure.core/when-let
    [v1280 (:reserved-node-offering-id m1279)]
    (. bean1278 setReservedNodeOfferingId (clojure.core/str v1280)))
   bean1278))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DeleteClusterRequest delete-cluster-request
  [m1282]
  (clojure.core/let
   [bean1281
    (new com.amazonaws.services.redshift.model.DeleteClusterRequest)]
   (clojure.core/when-let
    [v1283 (:cluster-identifier m1282)]
    (. bean1281 setClusterIdentifier (clojure.core/str v1283)))
   (clojure.core/when-let
    [v1283 (:skip-final-cluster-snapshot m1282)]
    (.
     bean1281
     setSkipFinalClusterSnapshot
     (clojure.core/boolean v1283)))
   (clojure.core/when-let
    [v1283 (:final-cluster-snapshot-identifier m1282)]
    (.
     bean1281
     setFinalClusterSnapshotIdentifier
     (clojure.core/str v1283)))
   bean1281))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest create-cluster-security-group-request
  [m1285]
  (clojure.core/let
   [bean1284
    (new
     com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest)]
   (clojure.core/when-let
    [v1286 (:cluster-security-group-name m1285)]
    (. bean1284 setClusterSecurityGroupName (clojure.core/str v1286)))
   (clojure.core/when-let
    [v1286 (:description m1285)]
    (. bean1284 setDescription (clojure.core/str v1286)))
   bean1284))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest describe-default-cluster-parameters-request
  [m1288]
  (clojure.core/let
   [bean1287
    (new
     com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest)]
   (clojure.core/when-let
    [v1289 (:marker m1288)]
    (. bean1287 setMarker (clojure.core/str v1289)))
   (clojure.core/when-let
    [v1289 (:max-records m1288)]
    (. bean1287 setMaxRecords (clojure.core/int v1289)))
   (clojure.core/when-let
    [v1289 (:parameter-group-family m1288)]
    (. bean1287 setParameterGroupFamily (clojure.core/str v1289)))
   bean1287))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest create-cluster-snapshot-request
  [m1291]
  (clojure.core/let
   [bean1290
    (new
     com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest)]
   (clojure.core/when-let
    [v1292 (:snapshot-identifier m1291)]
    (. bean1290 setSnapshotIdentifier (clojure.core/str v1292)))
   (clojure.core/when-let
    [v1292 (:cluster-identifier m1291)]
    (. bean1290 setClusterIdentifier (clojure.core/str v1292)))
   bean1290))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest describe-cluster-versions-request
  [m1294]
  (clojure.core/let
   [bean1293
    (new
     com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest)]
   (clojure.core/when-let
    [v1295 (:marker m1294)]
    (. bean1293 setMarker (clojure.core/str v1295)))
   (clojure.core/when-let
    [v1295 (:cluster-version m1294)]
    (. bean1293 setClusterVersion (clojure.core/str v1295)))
   (clojure.core/when-let
    [v1295 (:max-records m1294)]
    (. bean1293 setMaxRecords (clojure.core/int v1295)))
   (clojure.core/when-let
    [v1295 (:cluster-parameter-group-family m1294)]
    (.
     bean1293
     setClusterParameterGroupFamily
     (clojure.core/str v1295)))
   bean1293))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.RebootClusterRequest reboot-cluster-request
  [m1297]
  (clojure.core/let
   [bean1296
    (new com.amazonaws.services.redshift.model.RebootClusterRequest)]
   (clojure.core/when-let
    [v1298 (:cluster-identifier m1297)]
    (. bean1296 setClusterIdentifier (clojure.core/str v1298)))
   bean1296))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeResizeRequest describe-resize-request
  [m1300]
  (clojure.core/let
   [bean1299
    (new com.amazonaws.services.redshift.model.DescribeResizeRequest)]
   (clojure.core/when-let
    [v1301 (:cluster-identifier m1300)]
    (. bean1299 setClusterIdentifier (clojure.core/str v1301)))
   bean1299))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest revoke-cluster-security-group-ingress-request
  [m1303]
  (clojure.core/let
   [bean1302
    (new
     com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v1304 (:cluster-security-group-name m1303)]
    (. bean1302 setClusterSecurityGroupName (clojure.core/str v1304)))
   (clojure.core/when-let
    [v1304 (:cidrip m1303)]
    (. bean1302 setCIDRIP (clojure.core/str v1304)))
   (clojure.core/when-let
    [v1304 (:ec2security-group-name m1303)]
    (. bean1302 setEC2SecurityGroupName (clojure.core/str v1304)))
   (clojure.core/when-let
    [v1304 (:ec2security-group-owner-id m1303)]
    (. bean1302 setEC2SecurityGroupOwnerId (clojure.core/str v1304)))
   bean1302))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest modify-cluster-parameter-group-request
  [m1306]
  (clojure.core/let
   [bean1305
    (new
     com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v1307 (:parameters m1306)]
    (.
     bean1305
     setParameters
     (clojure.core/map
      (clojure.core/fn [arg1308] (parameter arg1308))
      v1307)))
   (clojure.core/when-let
    [v1307 (:parameter-group-name m1306)]
    (. bean1305 setParameterGroupName (clojure.core/str v1307)))
   bean1305))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest describe-cluster-snapshots-request
  [m1310]
  (clojure.core/let
   [bean1309
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest)]
   (clojure.core/when-let
    [v1311 (:marker m1310)]
    (. bean1309 setMarker (clojure.core/str v1311)))
   (clojure.core/when-let
    [v1311 (:snapshot-identifier m1310)]
    (. bean1309 setSnapshotIdentifier (clojure.core/str v1311)))
   (clojure.core/when-let
    [v1311 (:cluster-identifier m1310)]
    (. bean1309 setClusterIdentifier (clojure.core/str v1311)))
   (clojure.core/when-let
    [v1311 (:snapshot-type m1310)]
    (. bean1309 setSnapshotType (clojure.core/str v1311)))
   (clojure.core/when-let
    [v1311 (:owner-account m1310)]
    (. bean1309 setOwnerAccount (clojure.core/str v1311)))
   (clojure.core/when-let
    [v1311 (:max-records m1310)]
    (. bean1309 setMaxRecords (clojure.core/int v1311)))
   (clojure.core/when-let
    [v1311 (:start-time m1310)]
    (.
     bean1309
     setStartTime
     (com.palletops.awaze.common/to-date v1311)))
   (clojure.core/when-let
    [v1311 (:end-time m1310)]
    (. bean1309 setEndTime (com.palletops.awaze.common/to-date v1311)))
   bean1309))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest delete-cluster-snapshot-request
  [m1313]
  (clojure.core/let
   [bean1312
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest)]
   (clojure.core/when-let
    [v1314 (:snapshot-identifier m1313)]
    (. bean1312 setSnapshotIdentifier (clojure.core/str v1314)))
   (clojure.core/when-let
    [v1314 (:snapshot-cluster-identifier m1313)]
    (. bean1312 setSnapshotClusterIdentifier (clojure.core/str v1314)))
   bean1312))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest describe-orderable-cluster-options-request
  [m1316]
  (clojure.core/let
   [bean1315
    (new
     com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest)]
   (clojure.core/when-let
    [v1317 (:marker m1316)]
    (. bean1315 setMarker (clojure.core/str v1317)))
   (clojure.core/when-let
    [v1317 (:cluster-version m1316)]
    (. bean1315 setClusterVersion (clojure.core/str v1317)))
   (clojure.core/when-let
    [v1317 (:node-type m1316)]
    (. bean1315 setNodeType (clojure.core/str v1317)))
   (clojure.core/when-let
    [v1317 (:max-records m1316)]
    (. bean1315 setMaxRecords (clojure.core/int v1317)))
   bean1315))
 (clojure.core/defmulti
  redshift
  (clojure.core/fn redshift [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-security-groups
   [m1318]
   (clojure.core/let
    [credentials1319 (:credentials m1318) args1320 (:args m1318)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1321
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1319)]
     (clojure.core/case
      (clojure.core/count args1320)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1321
        describeClusterSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1321
        describeClusterSecurityGroups
        (describe-cluster-security-groups-request
         (clojure.core/nth args1320 0))))))))
  (clojure.core/defn
   describe-cluster-security-groups-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cluster-security-group-name]}]],
    :doc
    "Generate map for describeClusterSecurityGroups, describeClusterSecurityGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-security-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-security-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-cluster-security-groups
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cluster-security-group-name]}]],
    :doc
    "Call describeClusterSecurityGroups, describeClusterSecurityGroups"}
   [credentials1323 & args1324]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1325
     (com.palletops.awaze.common/aws-client :redshift credentials1323)]
    (clojure.core/case
     (clojure.core/count args1324)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1325
       describeClusterSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1325
       describeClusterSecurityGroups
       (describe-cluster-security-groups-request
        (clojure.core/nth args1324 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameter-groups
   [m1326]
   (clojure.core/let
    [credentials1327 (:credentials m1326) args1328 (:args m1326)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1329
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1327)]
     (clojure.core/case
      (clojure.core/count args1328)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1329
        describeClusterParameterGroups
        (describe-cluster-parameter-groups-request
         (clojure.core/nth args1328 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1329
        describeClusterParameterGroups))))))
  (clojure.core/defn
   describe-cluster-parameter-groups-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         parameter-group-name
         max-records
         marker]}]
      [credentials]],
    :doc
    "Generate map for describeClusterParameterGroups, describeClusterParameterGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-cluster-parameter-groups
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         parameter-group-name
         max-records
         marker]}]
      [credentials]],
    :doc
    "Call describeClusterParameterGroups, describeClusterParameterGroups"}
   [credentials1331 & args1332]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1333
     (com.palletops.awaze.common/aws-client :redshift credentials1331)]
    (clojure.core/case
     (clojure.core/count args1332)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1333
       describeClusterParameterGroups
       (describe-cluster-parameter-groups-request
        (clojure.core/nth args1332 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1333
       describeClusterParameterGroups))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster
   [m1334]
   (clojure.core/let
    [credentials1335 (:credentials m1334) args1336 (:args m1334)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1337
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1335)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1337
       createCluster
       (create-cluster-request (clojure.core/nth args1336 0)))))))
  (clojure.core/defn
   create-cluster-map
   {:arglists
    '[[credentials
       {:keys
        [node-type
         cluster-type
         publicly-accessible
         request-metric-collector
         cluster-security-groups
         automated-snapshot-retention-period
         cluster-identifier
         encrypted
         availability-zone
         preferred-maintenance-window
         master-username
         dbname
         cluster-parameter-group-name
         master-user-password
         number-of-nodes
         vpc-security-group-ids
         port
         cluster-version
         cluster-subnet-group-name
         allow-version-upgrade]}]],
    :doc "Generate map for createCluster"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-cluster
   {:arglists
    '[[credentials
       {:keys
        [node-type
         cluster-type
         publicly-accessible
         request-metric-collector
         cluster-security-groups
         automated-snapshot-retention-period
         cluster-identifier
         encrypted
         availability-zone
         preferred-maintenance-window
         master-username
         dbname
         cluster-parameter-group-name
         master-user-password
         number-of-nodes
         vpc-security-group-ids
         port
         cluster-version
         cluster-subnet-group-name
         allow-version-upgrade]}]],
    :doc "Call createCluster"}
   [credentials1339 & args1340]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1341
     (com.palletops.awaze.common/aws-client :redshift credentials1339)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1341
      createCluster
      (create-cluster-request (clojure.core/nth args1340 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-snapshot-access
   [m1342]
   (clojure.core/let
    [credentials1343 (:credentials m1342) args1344 (:args m1342)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1345
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1343)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1345
       authorizeSnapshotAccess
       (authorize-snapshot-access-request
        (clojure.core/nth args1344 0)))))))
  (clojure.core/defn
   authorize-snapshot-access-map
   {:arglists
    '[[credentials
       {:keys
        [snapshot-identifier
         snapshot-cluster-identifier
         request-metric-collector
         account-with-restore-access]}]],
    :doc "Generate map for authorizeSnapshotAccess"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :authorize-snapshot-access,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   authorize-snapshot-access
   {:arglists
    '[[credentials
       {:keys
        [snapshot-identifier
         snapshot-cluster-identifier
         request-metric-collector
         account-with-restore-access]}]],
    :doc "Call authorizeSnapshotAccess"}
   [credentials1347 & args1348]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1349
     (com.palletops.awaze.common/aws-client :redshift credentials1347)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1349
      authorizeSnapshotAccess
      (authorize-snapshot-access-request
       (clojure.core/nth args1348 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-subnet-groups
   [m1350]
   (clojure.core/let
    [credentials1351 (:credentials m1350) args1352 (:args m1350)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1353
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1351)]
     (clojure.core/case
      (clojure.core/count args1352)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1353
        describeClusterSubnetGroups
        (describe-cluster-subnet-groups-request
         (clojure.core/nth args1352 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1353
        describeClusterSubnetGroups))))))
  (clojure.core/defn
   describe-cluster-subnet-groups-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cluster-subnet-group-name]}]
      [credentials]],
    :doc
    "Generate map for describeClusterSubnetGroups, describeClusterSubnetGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-cluster-subnet-groups
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cluster-subnet-group-name]}]
      [credentials]],
    :doc
    "Call describeClusterSubnetGroups, describeClusterSubnetGroups"}
   [credentials1355 & args1356]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1357
     (com.palletops.awaze.common/aws-client :redshift credentials1355)]
    (clojure.core/case
     (clojure.core/count args1356)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1357
       describeClusterSubnetGroups
       (describe-cluster-subnet-groups-request
        (clojure.core/nth args1356 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1357
       describeClusterSubnetGroups))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-clusters
   [m1358]
   (clojure.core/let
    [credentials1359 (:credentials m1358) args1360 (:args m1358)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1361
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1359)]
     (clojure.core/case
      (clojure.core/count args1360)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1361
        describeClusters
        (describe-clusters-request (clojure.core/nth args1360 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1361
        describeClusters))))))
  (clojure.core/defn
   describe-clusters-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cluster-identifier]}]
      [credentials]],
    :doc "Generate map for describeClusters, describeClusters"}
   ([credentials__577__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-clusters,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-clusters,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-clusters
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cluster-identifier]}]
      [credentials]],
    :doc "Call describeClusters, describeClusters"}
   [credentials1363 & args1364]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1365
     (com.palletops.awaze.common/aws-client :redshift credentials1363)]
    (clojure.core/case
     (clojure.core/count args1364)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1365
       describeClusters
       (describe-clusters-request (clojure.core/nth args1364 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1365
       describeClusters))))))
 (do
  (clojure.core/defmethod
   redshift
   :restore-from-cluster-snapshot
   [m1366]
   (clojure.core/let
    [credentials1367 (:credentials m1366) args1368 (:args m1366)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1369
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1367)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1369
       restoreFromClusterSnapshot
       (restore-from-cluster-snapshot-request
        (clojure.core/nth args1368 0)))))))
  (clojure.core/defn
   restore-from-cluster-snapshot-map
   {:arglists
    '[[credentials
       {:keys
        [publicly-accessible
         request-metric-collector
         cluster-identifier
         owner-account
         availability-zone
         port
         snapshot-identifier
         snapshot-cluster-identifier
         cluster-subnet-group-name
         allow-version-upgrade]}]],
    :doc "Generate map for restoreFromClusterSnapshot"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :restore-from-cluster-snapshot,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   restore-from-cluster-snapshot
   {:arglists
    '[[credentials
       {:keys
        [publicly-accessible
         request-metric-collector
         cluster-identifier
         owner-account
         availability-zone
         port
         snapshot-identifier
         snapshot-cluster-identifier
         cluster-subnet-group-name
         allow-version-upgrade]}]],
    :doc "Call restoreFromClusterSnapshot"}
   [credentials1371 & args1372]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1373
     (com.palletops.awaze.common/aws-client :redshift credentials1371)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1373
      restoreFromClusterSnapshot
      (restore-from-cluster-snapshot-request
       (clojure.core/nth args1372 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-snapshot-access
   [m1374]
   (clojure.core/let
    [credentials1375 (:credentials m1374) args1376 (:args m1374)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1377
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1375)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1377
       revokeSnapshotAccess
       (revoke-snapshot-access-request
        (clojure.core/nth args1376 0)))))))
  (clojure.core/defn
   revoke-snapshot-access-map
   {:arglists
    '[[credentials
       {:keys
        [snapshot-identifier
         snapshot-cluster-identifier
         request-metric-collector
         account-with-restore-access]}]],
    :doc "Generate map for revokeSnapshotAccess"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :revoke-snapshot-access,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   revoke-snapshot-access
   {:arglists
    '[[credentials
       {:keys
        [snapshot-identifier
         snapshot-cluster-identifier
         request-metric-collector
         account-with-restore-access]}]],
    :doc "Call revokeSnapshotAccess"}
   [credentials1379 & args1380]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1381
     (com.palletops.awaze.common/aws-client :redshift credentials1379)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1381
      revokeSnapshotAccess
      (revoke-snapshot-access-request
       (clojure.core/nth args1380 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-security-group
   [m1382]
   (clojure.core/let
    [credentials1383 (:credentials m1382) args1384 (:args m1382)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1385
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1383)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1385
       deleteClusterSecurityGroup
       (delete-cluster-security-group-request
        (clojure.core/nth args1384 0)))))))
  (clojure.core/defn
   delete-cluster-security-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector cluster-security-group-name]}]],
    :doc "Generate map for deleteClusterSecurityGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-security-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-cluster-security-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector cluster-security-group-name]}]],
    :doc "Call deleteClusterSecurityGroup"}
   [credentials1387 & args1388]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1389
     (com.palletops.awaze.common/aws-client :redshift credentials1387)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1389
      deleteClusterSecurityGroup
      (delete-cluster-security-group-request
       (clojure.core/nth args1388 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameters
   [m1390]
   (clojure.core/let
    [credentials1391 (:credentials m1390) args1392 (:args m1390)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1393
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1391)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1393
       describeClusterParameters
       (describe-cluster-parameters-request
        (clojure.core/nth args1392 0)))))))
  (clojure.core/defn
   describe-cluster-parameters-map
   {:arglists
    '[[credentials
       {:keys
        [source
         request-metric-collector
         parameter-group-name
         max-records
         marker]}]],
    :doc "Generate map for describeClusterParameters"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-parameters,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-cluster-parameters
   {:arglists
    '[[credentials
       {:keys
        [source
         request-metric-collector
         parameter-group-name
         max-records
         marker]}]],
    :doc "Call describeClusterParameters"}
   [credentials1395 & args1396]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1397
     (com.palletops.awaze.common/aws-client :redshift credentials1395)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1397
      describeClusterParameters
      (describe-cluster-parameters-request
       (clojure.core/nth args1396 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :reset-cluster-parameter-group
   [m1398]
   (clojure.core/let
    [credentials1399 (:credentials m1398) args1400 (:args m1398)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1401
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1399)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1401
       resetClusterParameterGroup
       (reset-cluster-parameter-group-request
        (clojure.core/nth args1400 0)))))))
  (clojure.core/defn
   reset-cluster-parameter-group-map
   {:arglists
    '[[credentials
       {:keys
        [reset-all-parameters
         request-metric-collector
         parameters
         parameter-group-name]}]],
    :doc "Generate map for resetClusterParameterGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :reset-cluster-parameter-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   reset-cluster-parameter-group
   {:arglists
    '[[credentials
       {:keys
        [reset-all-parameters
         request-metric-collector
         parameters
         parameter-group-name]}]],
    :doc "Call resetClusterParameterGroup"}
   [credentials1403 & args1404]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1405
     (com.palletops.awaze.common/aws-client :redshift credentials1403)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1405
      resetClusterParameterGroup
      (reset-cluster-parameter-group-request
       (clojure.core/nth args1404 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-parameter-group
   [m1406]
   (clojure.core/let
    [credentials1407 (:credentials m1406) args1408 (:args m1406)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1409
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1407)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1409
       createClusterParameterGroup
       (create-cluster-parameter-group-request
        (clojure.core/nth args1408 0)))))))
  (clojure.core/defn
   create-cluster-parameter-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         parameter-group-name
         parameter-group-family
         description]}]],
    :doc "Generate map for createClusterParameterGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-parameter-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-cluster-parameter-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         parameter-group-name
         parameter-group-family
         description]}]],
    :doc "Call createClusterParameterGroup"}
   [credentials1411 & args1412]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1413
     (com.palletops.awaze.common/aws-client :redshift credentials1411)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1413
      createClusterParameterGroup
      (create-cluster-parameter-group-request
       (clojure.core/nth args1412 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-nodes
   [m1414]
   (clojure.core/let
    [credentials1415 (:credentials m1414) args1416 (:args m1414)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1417
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1415)]
     (clojure.core/case
      (clojure.core/count args1416)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1417
        describeReservedNodes
        (describe-reserved-nodes-request
         (clojure.core/nth args1416 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1417
        describeReservedNodes))))))
  (clojure.core/defn
   describe-reserved-nodes-map
   {:arglists
    '[[credentials
       {:keys
        [reserved-node-id
         request-metric-collector
         max-records
         marker]}]
      [credentials]],
    :doc
    "Generate map for describeReservedNodes, describeReservedNodes"}
   ([credentials__577__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-reserved-nodes,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-reserved-nodes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-reserved-nodes
   {:arglists
    '[[credentials
       {:keys
        [reserved-node-id
         request-metric-collector
         max-records
         marker]}]
      [credentials]],
    :doc "Call describeReservedNodes, describeReservedNodes"}
   [credentials1419 & args1420]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1421
     (com.palletops.awaze.common/aws-client :redshift credentials1419)]
    (clojure.core/case
     (clojure.core/count args1420)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1421
       describeReservedNodes
       (describe-reserved-nodes-request
        (clojure.core/nth args1420 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1421
       describeReservedNodes))))))
 (do
  (clojure.core/defmethod
   redshift
   :copy-cluster-snapshot
   [m1422]
   (clojure.core/let
    [credentials1423 (:credentials m1422) args1424 (:args m1422)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1425
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1423)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1425
       copyClusterSnapshot
       (copy-cluster-snapshot-request
        (clojure.core/nth args1424 0)))))))
  (clojure.core/defn
   copy-cluster-snapshot-map
   {:arglists
    '[[credentials
       {:keys
        [target-snapshot-identifier
         source-snapshot-identifier
         source-snapshot-cluster-identifier
         request-metric-collector]}]],
    :doc "Generate map for copyClusterSnapshot"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :copy-cluster-snapshot,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   copy-cluster-snapshot
   {:arglists
    '[[credentials
       {:keys
        [target-snapshot-identifier
         source-snapshot-identifier
         source-snapshot-cluster-identifier
         request-metric-collector]}]],
    :doc "Call copyClusterSnapshot"}
   [credentials1427 & args1428]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1429
     (com.palletops.awaze.common/aws-client :redshift credentials1427)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1429
      copyClusterSnapshot
      (copy-cluster-snapshot-request
       (clojure.core/nth args1428 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-subnet-group
   [m1430]
   (clojure.core/let
    [credentials1431 (:credentials m1430) args1432 (:args m1430)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1433
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1431)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1433
       modifyClusterSubnetGroup
       (modify-cluster-subnet-group-request
        (clojure.core/nth args1432 0)))))))
  (clojure.core/defn
   modify-cluster-subnet-group-map
   {:arglists
    '[[credentials
       {:keys
        [subnet-ids
         request-metric-collector
         description
         cluster-subnet-group-name]}]],
    :doc "Generate map for modifyClusterSubnetGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-cluster-subnet-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-cluster-subnet-group
   {:arglists
    '[[credentials
       {:keys
        [subnet-ids
         request-metric-collector
         description
         cluster-subnet-group-name]}]],
    :doc "Call modifyClusterSubnetGroup"}
   [credentials1435 & args1436]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1437
     (com.palletops.awaze.common/aws-client :redshift credentials1435)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1437
      modifyClusterSubnetGroup
      (modify-cluster-subnet-group-request
       (clojure.core/nth args1436 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-events
   [m1438]
   (clojure.core/let
    [credentials1439 (:credentials m1438) args1440 (:args m1438)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1441
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1439)]
     (clojure.core/case
      (clojure.core/count args1440)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1441
        describeEvents
        (describe-events-request (clojure.core/nth args1440 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1441
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists
    '[[credentials
       {:keys
        [end-time
         source-type
         duration
         request-metric-collector
         max-records
         start-time
         marker
         source-identifier]}]
      [credentials]],
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__577__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-events,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-events,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists
    '[[credentials
       {:keys
        [end-time
         source-type
         duration
         request-metric-collector
         max-records
         start-time
         marker
         source-identifier]}]
      [credentials]],
    :doc "Call describeEvents, describeEvents"}
   [credentials1443 & args1444]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1445
     (com.palletops.awaze.common/aws-client :redshift credentials1443)]
    (clojure.core/case
     (clojure.core/count args1444)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1445
       describeEvents
       (describe-events-request (clojure.core/nth args1444 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1445
       describeEvents))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-parameter-group
   [m1446]
   (clojure.core/let
    [credentials1447 (:credentials m1446) args1448 (:args m1446)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1449
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1447)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1449
       deleteClusterParameterGroup
       (delete-cluster-parameter-group-request
        (clojure.core/nth args1448 0)))))))
  (clojure.core/defn
   delete-cluster-parameter-group-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector parameter-group-name]}]],
    :doc "Generate map for deleteClusterParameterGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-parameter-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-cluster-parameter-group
   {:arglists
    '[[credentials
       {:keys [request-metric-collector parameter-group-name]}]],
    :doc "Call deleteClusterParameterGroup"}
   [credentials1451 & args1452]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1453
     (com.palletops.awaze.common/aws-client :redshift credentials1451)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1453
      deleteClusterParameterGroup
      (delete-cluster-parameter-group-request
       (clojure.core/nth args1452 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-cluster-security-group-ingress
   [m1454]
   (clojure.core/let
    [credentials1455 (:credentials m1454) args1456 (:args m1454)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1457
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1455)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1457
       authorizeClusterSecurityGroupIngress
       (authorize-cluster-security-group-ingress-request
        (clojure.core/nth args1456 0)))))))
  (clojure.core/defn
   authorize-cluster-security-group-ingress-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         cluster-security-group-name
         ec2security-group-owner-id
         ec2security-group-name
         cidrip]}]],
    :doc "Generate map for authorizeClusterSecurityGroupIngress"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :authorize-cluster-security-group-ingress,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   authorize-cluster-security-group-ingress
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         cluster-security-group-name
         ec2security-group-owner-id
         ec2security-group-name
         cidrip]}]],
    :doc "Call authorizeClusterSecurityGroupIngress"}
   [credentials1459 & args1460]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1461
     (com.palletops.awaze.common/aws-client :redshift credentials1459)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1461
      authorizeClusterSecurityGroupIngress
      (authorize-cluster-security-group-ingress-request
       (clojure.core/nth args1460 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster
   [m1462]
   (clojure.core/let
    [credentials1463 (:credentials m1462) args1464 (:args m1462)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1465
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1463)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1465
       modifyCluster
       (modify-cluster-request (clojure.core/nth args1464 0)))))))
  (clojure.core/defn
   modify-cluster-map
   {:arglists
    '[[credentials
       {:keys
        [node-type
         cluster-type
         request-metric-collector
         cluster-security-groups
         automated-snapshot-retention-period
         cluster-identifier
         preferred-maintenance-window
         cluster-parameter-group-name
         master-user-password
         number-of-nodes
         vpc-security-group-ids
         cluster-version
         allow-version-upgrade]}]],
    :doc "Generate map for modifyCluster"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-cluster,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-cluster
   {:arglists
    '[[credentials
       {:keys
        [node-type
         cluster-type
         request-metric-collector
         cluster-security-groups
         automated-snapshot-retention-period
         cluster-identifier
         preferred-maintenance-window
         cluster-parameter-group-name
         master-user-password
         number-of-nodes
         vpc-security-group-ids
         cluster-version
         allow-version-upgrade]}]],
    :doc "Call modifyCluster"}
   [credentials1467 & args1468]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1469
     (com.palletops.awaze.common/aws-client :redshift credentials1467)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1469
      modifyCluster
      (modify-cluster-request (clojure.core/nth args1468 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-subnet-group
   [m1470]
   (clojure.core/let
    [credentials1471 (:credentials m1470) args1472 (:args m1470)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1473
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1471)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1473
       deleteClusterSubnetGroup
       (delete-cluster-subnet-group-request
        (clojure.core/nth args1472 0)))))))
  (clojure.core/defn
   delete-cluster-subnet-group-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector cluster-subnet-group-name]}]],
    :doc "Generate map for deleteClusterSubnetGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-subnet-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-cluster-subnet-group
   {:arglists
    '[[credentials
       {:keys [request-metric-collector cluster-subnet-group-name]}]],
    :doc "Call deleteClusterSubnetGroup"}
   [credentials1475 & args1476]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1477
     (com.palletops.awaze.common/aws-client :redshift credentials1475)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1477
      deleteClusterSubnetGroup
      (delete-cluster-subnet-group-request
       (clojure.core/nth args1476 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-subnet-group
   [m1478]
   (clojure.core/let
    [credentials1479 (:credentials m1478) args1480 (:args m1478)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1481
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1479)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1481
       createClusterSubnetGroup
       (create-cluster-subnet-group-request
        (clojure.core/nth args1480 0)))))))
  (clojure.core/defn
   create-cluster-subnet-group-map
   {:arglists
    '[[credentials
       {:keys
        [subnet-ids
         request-metric-collector
         description
         cluster-subnet-group-name]}]],
    :doc "Generate map for createClusterSubnetGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-subnet-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-cluster-subnet-group
   {:arglists
    '[[credentials
       {:keys
        [subnet-ids
         request-metric-collector
         description
         cluster-subnet-group-name]}]],
    :doc "Call createClusterSubnetGroup"}
   [credentials1483 & args1484]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1485
     (com.palletops.awaze.common/aws-client :redshift credentials1483)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1485
      createClusterSubnetGroup
      (create-cluster-subnet-group-request
       (clojure.core/nth args1484 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :purchase-reserved-node-offering
   [m1486]
   (clojure.core/let
    [credentials1487 (:credentials m1486) args1488 (:args m1486)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1489
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1487)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1489
       purchaseReservedNodeOffering
       (purchase-reserved-node-offering-request
        (clojure.core/nth args1488 0)))))))
  (clojure.core/defn
   purchase-reserved-node-offering-map
   {:arglists
    '[[credentials
       {:keys
        [reserved-node-offering-id
         request-metric-collector
         node-count]}]],
    :doc "Generate map for purchaseReservedNodeOffering"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :purchase-reserved-node-offering,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   purchase-reserved-node-offering
   {:arglists
    '[[credentials
       {:keys
        [reserved-node-offering-id
         request-metric-collector
         node-count]}]],
    :doc "Call purchaseReservedNodeOffering"}
   [credentials1491 & args1492]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1493
     (com.palletops.awaze.common/aws-client :redshift credentials1491)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1493
      purchaseReservedNodeOffering
      (purchase-reserved-node-offering-request
       (clojure.core/nth args1492 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-node-offerings
   [m1494]
   (clojure.core/let
    [credentials1495 (:credentials m1494) args1496 (:args m1494)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1497
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1495)]
     (clojure.core/case
      (clojure.core/count args1496)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1497
        describeReservedNodeOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1497
        describeReservedNodeOfferings
        (describe-reserved-node-offerings-request
         (clojure.core/nth args1496 0))))))))
  (clojure.core/defn
   describe-reserved-node-offerings-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [reserved-node-offering-id
         request-metric-collector
         max-records
         marker]}]],
    :doc
    "Generate map for describeReservedNodeOfferings, describeReservedNodeOfferings"}
   ([credentials__577__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-reserved-node-offerings,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-reserved-node-offerings,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-reserved-node-offerings
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [reserved-node-offering-id
         request-metric-collector
         max-records
         marker]}]],
    :doc
    "Call describeReservedNodeOfferings, describeReservedNodeOfferings"}
   [credentials1499 & args1500]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1501
     (com.palletops.awaze.common/aws-client :redshift credentials1499)]
    (clojure.core/case
     (clojure.core/count args1500)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1501
       describeReservedNodeOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1501
       describeReservedNodeOfferings
       (describe-reserved-node-offerings-request
        (clojure.core/nth args1500 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster
   [m1502]
   (clojure.core/let
    [credentials1503 (:credentials m1502) args1504 (:args m1502)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1505
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1503)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1505
       deleteCluster
       (delete-cluster-request (clojure.core/nth args1504 0)))))))
  (clojure.core/defn
   delete-cluster-map
   {:arglists
    '[[credentials
       {:keys
        [skip-final-cluster-snapshot
         request-metric-collector
         final-cluster-snapshot-identifier
         cluster-identifier]}]],
    :doc "Generate map for deleteCluster"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-cluster
   {:arglists
    '[[credentials
       {:keys
        [skip-final-cluster-snapshot
         request-metric-collector
         final-cluster-snapshot-identifier
         cluster-identifier]}]],
    :doc "Call deleteCluster"}
   [credentials1507 & args1508]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1509
     (com.palletops.awaze.common/aws-client :redshift credentials1507)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1509
      deleteCluster
      (delete-cluster-request (clojure.core/nth args1508 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-security-group
   [m1510]
   (clojure.core/let
    [credentials1511 (:credentials m1510) args1512 (:args m1510)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1513
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1511)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1513
       createClusterSecurityGroup
       (create-cluster-security-group-request
        (clojure.core/nth args1512 0)))))))
  (clojure.core/defn
   create-cluster-security-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         description
         cluster-security-group-name]}]],
    :doc "Generate map for createClusterSecurityGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-security-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-cluster-security-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         description
         cluster-security-group-name]}]],
    :doc "Call createClusterSecurityGroup"}
   [credentials1515 & args1516]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1517
     (com.palletops.awaze.common/aws-client :redshift credentials1515)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1517
      createClusterSecurityGroup
      (create-cluster-security-group-request
       (clojure.core/nth args1516 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-default-cluster-parameters
   [m1518]
   (clojure.core/let
    [credentials1519 (:credentials m1518) args1520 (:args m1518)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1521
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1519)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1521
       describeDefaultClusterParameters
       (describe-default-cluster-parameters-request
        (clojure.core/nth args1520 0)))))))
  (clojure.core/defn
   describe-default-cluster-parameters-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         parameter-group-family
         max-records
         marker]}]],
    :doc "Generate map for describeDefaultClusterParameters"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-default-cluster-parameters,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-default-cluster-parameters
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         parameter-group-family
         max-records
         marker]}]],
    :doc "Call describeDefaultClusterParameters"}
   [credentials1523 & args1524]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1525
     (com.palletops.awaze.common/aws-client :redshift credentials1523)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1525
      describeDefaultClusterParameters
      (describe-default-cluster-parameters-request
       (clojure.core/nth args1524 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-snapshot
   [m1526]
   (clojure.core/let
    [credentials1527 (:credentials m1526) args1528 (:args m1526)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1529
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1527)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1529
       createClusterSnapshot
       (create-cluster-snapshot-request
        (clojure.core/nth args1528 0)))))))
  (clojure.core/defn
   create-cluster-snapshot-map
   {:arglists
    '[[credentials
       {:keys
        [snapshot-identifier
         request-metric-collector
         cluster-identifier]}]],
    :doc "Generate map for createClusterSnapshot"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-snapshot,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-cluster-snapshot
   {:arglists
    '[[credentials
       {:keys
        [snapshot-identifier
         request-metric-collector
         cluster-identifier]}]],
    :doc "Call createClusterSnapshot"}
   [credentials1531 & args1532]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1533
     (com.palletops.awaze.common/aws-client :redshift credentials1531)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1533
      createClusterSnapshot
      (create-cluster-snapshot-request
       (clojure.core/nth args1532 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-versions
   [m1534]
   (clojure.core/let
    [credentials1535 (:credentials m1534) args1536 (:args m1534)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1537
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1535)]
     (clojure.core/case
      (clojure.core/count args1536)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1537
        describeClusterVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1537
        describeClusterVersions
        (describe-cluster-versions-request
         (clojure.core/nth args1536 0))))))))
  (clojure.core/defn
   describe-cluster-versions-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cluster-version
         cluster-parameter-group-family]}]],
    :doc
    "Generate map for describeClusterVersions, describeClusterVersions"}
   ([credentials__577__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-versions,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-versions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-cluster-versions
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cluster-version
         cluster-parameter-group-family]}]],
    :doc "Call describeClusterVersions, describeClusterVersions"}
   [credentials1539 & args1540]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1541
     (com.palletops.awaze.common/aws-client :redshift credentials1539)]
    (clojure.core/case
     (clojure.core/count args1540)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1541
       describeClusterVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1541
       describeClusterVersions
       (describe-cluster-versions-request
        (clojure.core/nth args1540 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :reboot-cluster
   [m1542]
   (clojure.core/let
    [credentials1543 (:credentials m1542) args1544 (:args m1542)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1545
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1543)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1545
       rebootCluster
       (reboot-cluster-request (clojure.core/nth args1544 0)))))))
  (clojure.core/defn
   reboot-cluster-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector cluster-identifier]}]],
    :doc "Generate map for rebootCluster"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :reboot-cluster,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   reboot-cluster
   {:arglists
    '[[credentials
       {:keys [request-metric-collector cluster-identifier]}]],
    :doc "Call rebootCluster"}
   [credentials1547 & args1548]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1549
     (com.palletops.awaze.common/aws-client :redshift credentials1547)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1549
      rebootCluster
      (reboot-cluster-request (clojure.core/nth args1548 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-resize
   [m1550]
   (clojure.core/let
    [credentials1551 (:credentials m1550) args1552 (:args m1550)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1553
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1551)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1553
       describeResize
       (describe-resize-request (clojure.core/nth args1552 0)))))))
  (clojure.core/defn
   describe-resize-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector cluster-identifier]}]],
    :doc "Generate map for describeResize"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-resize,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-resize
   {:arglists
    '[[credentials
       {:keys [request-metric-collector cluster-identifier]}]],
    :doc "Call describeResize"}
   [credentials1555 & args1556]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1557
     (com.palletops.awaze.common/aws-client :redshift credentials1555)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1557
      describeResize
      (describe-resize-request (clojure.core/nth args1556 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-cluster-security-group-ingress
   [m1558]
   (clojure.core/let
    [credentials1559 (:credentials m1558) args1560 (:args m1558)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1561
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1559)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1561
       revokeClusterSecurityGroupIngress
       (revoke-cluster-security-group-ingress-request
        (clojure.core/nth args1560 0)))))))
  (clojure.core/defn
   revoke-cluster-security-group-ingress-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         cluster-security-group-name
         ec2security-group-owner-id
         ec2security-group-name
         cidrip]}]],
    :doc "Generate map for revokeClusterSecurityGroupIngress"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :revoke-cluster-security-group-ingress,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   revoke-cluster-security-group-ingress
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         cluster-security-group-name
         ec2security-group-owner-id
         ec2security-group-name
         cidrip]}]],
    :doc "Call revokeClusterSecurityGroupIngress"}
   [credentials1563 & args1564]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1565
     (com.palletops.awaze.common/aws-client :redshift credentials1563)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1565
      revokeClusterSecurityGroupIngress
      (revoke-cluster-security-group-ingress-request
       (clojure.core/nth args1564 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-parameter-group
   [m1566]
   (clojure.core/let
    [credentials1567 (:credentials m1566) args1568 (:args m1566)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1569
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1567)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1569
       modifyClusterParameterGroup
       (modify-cluster-parameter-group-request
        (clojure.core/nth args1568 0)))))))
  (clojure.core/defn
   modify-cluster-parameter-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector parameters parameter-group-name]}]],
    :doc "Generate map for modifyClusterParameterGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-cluster-parameter-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-cluster-parameter-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector parameters parameter-group-name]}]],
    :doc "Call modifyClusterParameterGroup"}
   [credentials1571 & args1572]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1573
     (com.palletops.awaze.common/aws-client :redshift credentials1571)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1573
      modifyClusterParameterGroup
      (modify-cluster-parameter-group-request
       (clojure.core/nth args1572 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-snapshots
   [m1574]
   (clojure.core/let
    [credentials1575 (:credentials m1574) args1576 (:args m1574)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1577
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1575)]
     (clojure.core/case
      (clojure.core/count args1576)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1577
        describeClusterSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1577
        describeClusterSnapshots
        (describe-cluster-snapshots-request
         (clojure.core/nth args1576 0))))))))
  (clojure.core/defn
   describe-cluster-snapshots-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [end-time
         request-metric-collector
         cluster-identifier
         owner-account
         max-records
         start-time
         marker
         snapshot-identifier
         snapshot-type]}]],
    :doc
    "Generate map for describeClusterSnapshots, describeClusterSnapshots"}
   ([credentials__577__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-snapshots,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-snapshots,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-cluster-snapshots
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [end-time
         request-metric-collector
         cluster-identifier
         owner-account
         max-records
         start-time
         marker
         snapshot-identifier
         snapshot-type]}]],
    :doc "Call describeClusterSnapshots, describeClusterSnapshots"}
   [credentials1579 & args1580]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1581
     (com.palletops.awaze.common/aws-client :redshift credentials1579)]
    (clojure.core/case
     (clojure.core/count args1580)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1581
       describeClusterSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1581
       describeClusterSnapshots
       (describe-cluster-snapshots-request
        (clojure.core/nth args1580 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-snapshot
   [m1582]
   (clojure.core/let
    [credentials1583 (:credentials m1582) args1584 (:args m1582)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1585
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1583)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1585
       deleteClusterSnapshot
       (delete-cluster-snapshot-request
        (clojure.core/nth args1584 0)))))))
  (clojure.core/defn
   delete-cluster-snapshot-map
   {:arglists
    '[[credentials
       {:keys
        [snapshot-identifier
         snapshot-cluster-identifier
         request-metric-collector]}]],
    :doc "Generate map for deleteClusterSnapshot"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-snapshot,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-cluster-snapshot
   {:arglists
    '[[credentials
       {:keys
        [snapshot-identifier
         snapshot-cluster-identifier
         request-metric-collector]}]],
    :doc "Call deleteClusterSnapshot"}
   [credentials1587 & args1588]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1589
     (com.palletops.awaze.common/aws-client :redshift credentials1587)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client1589
      deleteClusterSnapshot
      (delete-cluster-snapshot-request
       (clojure.core/nth args1588 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-orderable-cluster-options
   [m1590]
   (clojure.core/let
    [credentials1591 (:credentials m1590) args1592 (:args m1590)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client1593
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials1591)]
     (clojure.core/case
      (clojure.core/count args1592)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1593
        describeOrderableClusterOptions
        (describe-orderable-cluster-options-request
         (clojure.core/nth args1592 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client1593
        describeOrderableClusterOptions))))))
  (clojure.core/defn
   describe-orderable-cluster-options-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         node-type
         max-records
         marker
         cluster-version]}]
      [credentials]],
    :doc
    "Generate map for describeOrderableClusterOptions, describeOrderableClusterOptions"}
   ([credentials__577__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-orderable-cluster-options,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-orderable-cluster-options,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-orderable-cluster-options
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         node-type
         max-records
         marker
         cluster-version]}]
      [credentials]],
    :doc
    "Call describeOrderableClusterOptions, describeOrderableClusterOptions"}
   [credentials1595 & args1596]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client1597
     (com.palletops.awaze.common/aws-client :redshift credentials1595)]
    (clojure.core/case
     (clojure.core/count args1596)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1597
       describeOrderableClusterOptions
       (describe-orderable-cluster-options-request
        (clojure.core/nth args1596 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client1597
       describeOrderableClusterOptions)))))))
