(ns com.palletops.awaze.rds (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :rds
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.rds.AmazonRDSClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.OptionSetting option-setting
  [m3216]
  (clojure.core/let
   [bean3215 (new com.amazonaws.services.rds.model.OptionSetting)]
   (clojure.core/when-let
    [v3217 (:name m3216)]
    (. bean3215 setName (clojure.core/str v3217)))
   (clojure.core/when-let
    [v3217 (:value m3216)]
    (. bean3215 setValue (clojure.core/str v3217)))
   (clojure.core/when-let
    [v3217 (:apply-type m3216)]
    (. bean3215 setApplyType (clojure.core/str v3217)))
   (clojure.core/when-let
    [v3217 (:default-value m3216)]
    (. bean3215 setDefaultValue (clojure.core/str v3217)))
   (clojure.core/when-let
    [v3217 (:is-collection m3216)]
    (. bean3215 setIsCollection (clojure.core/boolean v3217)))
   (clojure.core/when-let
    [v3217 (:description m3216)]
    (. bean3215 setDescription (clojure.core/str v3217)))
   (clojure.core/when-let
    [v3217 (:data-type m3216)]
    (. bean3215 setDataType (clojure.core/str v3217)))
   (clojure.core/when-let
    [v3217 (:allowed-values m3216)]
    (. bean3215 setAllowedValues (clojure.core/str v3217)))
   (clojure.core/when-let
    [v3217 (:is-modifiable m3216)]
    (. bean3215 setIsModifiable (clojure.core/boolean v3217)))
   bean3215))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.ApplyMethod apply-method
  [m3219]
  (java.lang.Enum/valueOf
   com.amazonaws.services.rds.model.ApplyMethod
   (clojure.core/name m3219)))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.Tag tag
  [m3222]
  (clojure.core/let
   [bean3221 (new com.amazonaws.services.rds.model.Tag)]
   (clojure.core/when-let
    [v3223 (:value m3222)]
    (. bean3221 setValue (clojure.core/str v3223)))
   (clojure.core/when-let
    [v3223 (:key m3222)]
    (. bean3221 setKey (clojure.core/str v3223)))
   bean3221))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.SourceType source-type
  [m3225]
  (java.lang.Enum/valueOf
   com.amazonaws.services.rds.model.SourceType
   (clojure.core/name m3225)))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.OptionConfiguration option-configuration
  [m3228]
  (clojure.core/let
   [bean3227
    (new com.amazonaws.services.rds.model.OptionConfiguration)]
   (clojure.core/when-let
    [v3229 (:option-name m3228)]
    (. bean3227 setOptionName (clojure.core/str v3229)))
   (clojure.core/when-let
    [v3229 (:dbsecurity-group-memberships m3228)]
    (.
     bean3227
     setDBSecurityGroupMemberships
     (clojure.core/map
      (clojure.core/fn [arg3230] (clojure.core/str arg3230))
      v3229)))
   (clojure.core/when-let
    [v3229 (:vpc-security-group-memberships m3228)]
    (.
     bean3227
     setVpcSecurityGroupMemberships
     (clojure.core/map
      (clojure.core/fn [arg3231] (clojure.core/str arg3231))
      v3229)))
   (clojure.core/when-let
    [v3229 (:option-settings m3228)]
    (.
     bean3227
     setOptionSettings
     (clojure.core/map
      (clojure.core/fn [arg3232] (option-setting arg3232))
      v3229)))
   (clojure.core/when-let
    [v3229 (:port m3228)]
    (. bean3227 setPort (clojure.core/int v3229)))
   bean3227))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.Parameter parameter
  [m3234]
  (clojure.core/let
   [bean3233 (new com.amazonaws.services.rds.model.Parameter)]
   (clojure.core/when-let
    [v3235 (:source m3234)]
    (. bean3233 setSource (clojure.core/str v3235)))
   (clojure.core/when-let
    [v3235 (:apply-type m3234)]
    (. bean3233 setApplyType (clojure.core/str v3235)))
   (clojure.core/when-let
    [v3235 (:apply-method m3234)]
    (. bean3233 setApplyMethod (clojure.core/str v3235)))
   (clojure.core/when-let
    [v3235 (:apply-method m3234)]
    (. bean3233 setApplyMethod (apply-method v3235)))
   (clojure.core/when-let
    [v3235 (:description m3234)]
    (. bean3233 setDescription (clojure.core/str v3235)))
   (clojure.core/when-let
    [v3235 (:parameter-name m3234)]
    (. bean3233 setParameterName (clojure.core/str v3235)))
   (clojure.core/when-let
    [v3235 (:parameter-value m3234)]
    (. bean3233 setParameterValue (clojure.core/str v3235)))
   (clojure.core/when-let
    [v3235 (:data-type m3234)]
    (. bean3233 setDataType (clojure.core/str v3235)))
   (clojure.core/when-let
    [v3235 (:allowed-values m3234)]
    (. bean3233 setAllowedValues (clojure.core/str v3235)))
   (clojure.core/when-let
    [v3235 (:is-modifiable m3234)]
    (. bean3233 setIsModifiable (clojure.core/boolean v3235)))
   (clojure.core/when-let
    [v3235 (:minimum-engine-version m3234)]
    (. bean3233 setMinimumEngineVersion (clojure.core/str v3235)))
   bean3233))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest revoke-dbsecurity-group-ingress-request
  [m3237]
  (clojure.core/let
   [bean3236
    (new
     com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v3238 (:dbsecurity-group-name m3237)]
    (. bean3236 setDBSecurityGroupName (clojure.core/str v3238)))
   (clojure.core/when-let
    [v3238 (:ec2security-group-id m3237)]
    (. bean3236 setEC2SecurityGroupId (clojure.core/str v3238)))
   (clojure.core/when-let
    [v3238 (:cidrip m3237)]
    (. bean3236 setCIDRIP (clojure.core/str v3238)))
   (clojure.core/when-let
    [v3238 (:ec2security-group-name m3237)]
    (. bean3236 setEC2SecurityGroupName (clojure.core/str v3238)))
   (clojure.core/when-let
    [v3238 (:ec2security-group-owner-id m3237)]
    (. bean3236 setEC2SecurityGroupOwnerId (clojure.core/str v3238)))
   bean3236))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.AddTagsToResourceRequest add-tags-to-resource-request
  [m3240]
  (clojure.core/let
   [bean3239
    (new com.amazonaws.services.rds.model.AddTagsToResourceRequest)]
   (clojure.core/when-let
    [v3241 (:tags m3240)]
    (.
     bean3239
     setTags
     (clojure.core/map
      (clojure.core/fn [arg3242] (tag arg3242))
      v3241)))
   (clojure.core/when-let
    [v3241 (:resource-name m3240)]
    (. bean3239 setResourceName (clojure.core/str v3241)))
   bean3239))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest describe-dbsecurity-groups-request
  [m3244]
  (clojure.core/let
   [bean3243
    (new
     com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest)]
   (clojure.core/when-let
    [v3245 (:dbsecurity-group-name m3244)]
    (. bean3243 setDBSecurityGroupName (clojure.core/str v3245)))
   (clojure.core/when-let
    [v3245 (:marker m3244)]
    (. bean3243 setMarker (clojure.core/str v3245)))
   (clojure.core/when-let
    [v3245 (:max-records m3244)]
    (. bean3243 setMaxRecords (clojure.core/int v3245)))
   bean3243))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest purchase-reserved-dbinstances-offering-request
  [m3247]
  (clojure.core/let
   [bean3246
    (new
     com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest)]
   (clojure.core/when-let
    [v3248 (:reserved-dbinstance-id m3247)]
    (. bean3246 setReservedDBInstanceId (clojure.core/str v3248)))
   (clojure.core/when-let
    [v3248 (:reserved-dbinstances-offering-id m3247)]
    (.
     bean3246
     setReservedDBInstancesOfferingId
     (clojure.core/str v3248)))
   (clojure.core/when-let
    [v3248 (:dbinstance-count m3247)]
    (. bean3246 setDBInstanceCount (clojure.core/int v3248)))
   bean3246))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeDBParametersRequest describe-dbparameters-request
  [m3250]
  (clojure.core/let
   [bean3249
    (new com.amazonaws.services.rds.model.DescribeDBParametersRequest)]
   (clojure.core/when-let
    [v3251 (:source m3250)]
    (. bean3249 setSource (clojure.core/str v3251)))
   (clojure.core/when-let
    [v3251 (:dbparameter-group-name m3250)]
    (. bean3249 setDBParameterGroupName (clojure.core/str v3251)))
   (clojure.core/when-let
    [v3251 (:marker m3250)]
    (. bean3249 setMarker (clojure.core/str v3251)))
   (clojure.core/when-let
    [v3251 (:max-records m3250)]
    (. bean3249 setMaxRecords (clojure.core/int v3251)))
   bean3249))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeOptionGroupsRequest describe-option-groups-request
  [m3253]
  (clojure.core/let
   [bean3252
    (new com.amazonaws.services.rds.model.DescribeOptionGroupsRequest)]
   (clojure.core/when-let
    [v3254 (:option-group-name m3253)]
    (. bean3252 setOptionGroupName (clojure.core/str v3254)))
   (clojure.core/when-let
    [v3254 (:engine-name m3253)]
    (. bean3252 setEngineName (clojure.core/str v3254)))
   (clojure.core/when-let
    [v3254 (:major-engine-version m3253)]
    (. bean3252 setMajorEngineVersion (clojure.core/str v3254)))
   (clojure.core/when-let
    [v3254 (:marker m3253)]
    (. bean3252 setMarker (clojure.core/str v3254)))
   (clojure.core/when-let
    [v3254 (:max-records m3253)]
    (. bean3252 setMaxRecords (clojure.core/int v3254)))
   bean3252))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest create-dbinstance-read-replica-request
  [m3256]
  (clojure.core/let
   [bean3255
    (new
     com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest)]
   (clojure.core/when-let
    [v3257 (:dbinstance-class m3256)]
    (. bean3255 setDBInstanceClass (clojure.core/str v3257)))
   (clojure.core/when-let
    [v3257 (:dbinstance-identifier m3256)]
    (. bean3255 setDBInstanceIdentifier (clojure.core/str v3257)))
   (clojure.core/when-let
    [v3257 (:iops m3256)]
    (. bean3255 setIops (clojure.core/int v3257)))
   (clojure.core/when-let
    [v3257 (:option-group-name m3256)]
    (. bean3255 setOptionGroupName (clojure.core/str v3257)))
   (clojure.core/when-let
    [v3257 (:auto-minor-version-upgrade m3256)]
    (.
     bean3255
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v3257)))
   (clojure.core/when-let
    [v3257 (:source-dbinstance-identifier m3256)]
    (.
     bean3255
     setSourceDBInstanceIdentifier
     (clojure.core/str v3257)))
   (clojure.core/when-let
    [v3257 (:port m3256)]
    (. bean3255 setPort (clojure.core/int v3257)))
   (clojure.core/when-let
    [v3257 (:availability-zone m3256)]
    (. bean3255 setAvailabilityZone (clojure.core/str v3257)))
   (clojure.core/when-let
    [v3257 (:publicly-accessible m3256)]
    (. bean3255 setPubliclyAccessible (clojure.core/boolean v3257)))
   bean3255))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest restore-dbinstance-from-dbsnapshot-request
  [m3259]
  (clojure.core/let
   [bean3258
    (new
     com.amazonaws.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest)]
   (clojure.core/when-let
    [v3260 (:dbinstance-class m3259)]
    (. bean3258 setDBInstanceClass (clojure.core/str v3260)))
   (clojure.core/when-let
    [v3260 (:multi-az m3259)]
    (. bean3258 setMultiAZ (clojure.core/boolean v3260)))
   (clojure.core/when-let
    [v3260 (:dbsnapshot-identifier m3259)]
    (. bean3258 setDBSnapshotIdentifier (clojure.core/str v3260)))
   (clojure.core/when-let
    [v3260 (:dbsubnet-group-name m3259)]
    (. bean3258 setDBSubnetGroupName (clojure.core/str v3260)))
   (clojure.core/when-let
    [v3260 (:dbinstance-identifier m3259)]
    (. bean3258 setDBInstanceIdentifier (clojure.core/str v3260)))
   (clojure.core/when-let
    [v3260 (:engine m3259)]
    (. bean3258 setEngine (clojure.core/str v3260)))
   (clojure.core/when-let
    [v3260 (:license-model m3259)]
    (. bean3258 setLicenseModel (clojure.core/str v3260)))
   (clojure.core/when-let
    [v3260 (:iops m3259)]
    (. bean3258 setIops (clojure.core/int v3260)))
   (clojure.core/when-let
    [v3260 (:option-group-name m3259)]
    (. bean3258 setOptionGroupName (clojure.core/str v3260)))
   (clojure.core/when-let
    [v3260 (:auto-minor-version-upgrade m3259)]
    (.
     bean3258
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v3260)))
   (clojure.core/when-let
    [v3260 (:port m3259)]
    (. bean3258 setPort (clojure.core/int v3260)))
   (clojure.core/when-let
    [v3260 (:availability-zone m3259)]
    (. bean3258 setAvailabilityZone (clojure.core/str v3260)))
   (clojure.core/when-let
    [v3260 (:dbname m3259)]
    (. bean3258 setDBName (clojure.core/str v3260)))
   (clojure.core/when-let
    [v3260 (:publicly-accessible m3259)]
    (. bean3258 setPubliclyAccessible (clojure.core/boolean v3260)))
   bean3258))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DeleteDBParameterGroupRequest delete-dbparameter-group-request
  [m3262]
  (clojure.core/let
   [bean3261
    (new
     com.amazonaws.services.rds.model.DeleteDBParameterGroupRequest)]
   (clojure.core/when-let
    [v3263 (:dbparameter-group-name m3262)]
    (. bean3261 setDBParameterGroupName (clojure.core/str v3263)))
   bean3261))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest describe-reserved-dbinstances-request
  [m3265]
  (clojure.core/let
   [bean3264
    (new
     com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest)]
   (clojure.core/when-let
    [v3266 (:reserved-dbinstance-id m3265)]
    (. bean3264 setReservedDBInstanceId (clojure.core/str v3266)))
   (clojure.core/when-let
    [v3266 (:reserved-dbinstances-offering-id m3265)]
    (.
     bean3264
     setReservedDBInstancesOfferingId
     (clojure.core/str v3266)))
   (clojure.core/when-let
    [v3266 (:dbinstance-class m3265)]
    (. bean3264 setDBInstanceClass (clojure.core/str v3266)))
   (clojure.core/when-let
    [v3266 (:product-description m3265)]
    (. bean3264 setProductDescription (clojure.core/str v3266)))
   (clojure.core/when-let
    [v3266 (:multi-az m3265)]
    (. bean3264 setMultiAZ (clojure.core/boolean v3266)))
   (clojure.core/when-let
    [v3266 (:marker m3265)]
    (. bean3264 setMarker (clojure.core/str v3266)))
   (clojure.core/when-let
    [v3266 (:max-records m3265)]
    (. bean3264 setMaxRecords (clojure.core/int v3266)))
   (clojure.core/when-let
    [v3266 (:duration m3265)]
    (. bean3264 setDuration (clojure.core/str v3266)))
   (clojure.core/when-let
    [v3266 (:offering-type m3265)]
    (. bean3264 setOfferingType (clojure.core/str v3266)))
   bean3264))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DeleteDBSecurityGroupRequest delete-dbsecurity-group-request
  [m3268]
  (clojure.core/let
   [bean3267
    (new
     com.amazonaws.services.rds.model.DeleteDBSecurityGroupRequest)]
   (clojure.core/when-let
    [v3269 (:dbsecurity-group-name m3268)]
    (. bean3267 setDBSecurityGroupName (clojure.core/str v3269)))
   bean3267))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest describe-engine-default-parameters-request
  [m3271]
  (clojure.core/let
   [bean3270
    (new
     com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest)]
   (clojure.core/when-let
    [v3272 (:dbparameter-group-family m3271)]
    (. bean3270 setDBParameterGroupFamily (clojure.core/str v3272)))
   (clojure.core/when-let
    [v3272 (:marker m3271)]
    (. bean3270 setMarker (clojure.core/str v3272)))
   (clojure.core/when-let
    [v3272 (:max-records m3271)]
    (. bean3270 setMaxRecords (clojure.core/int v3272)))
   bean3270))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.CreateDBParameterGroupRequest create-dbparameter-group-request
  [m3274]
  (clojure.core/let
   [bean3273
    (new
     com.amazonaws.services.rds.model.CreateDBParameterGroupRequest)]
   (clojure.core/when-let
    [v3275 (:dbparameter-group-name m3274)]
    (. bean3273 setDBParameterGroupName (clojure.core/str v3275)))
   (clojure.core/when-let
    [v3275 (:dbparameter-group-family m3274)]
    (. bean3273 setDBParameterGroupFamily (clojure.core/str v3275)))
   (clojure.core/when-let
    [v3275 (:description m3274)]
    (. bean3273 setDescription (clojure.core/str v3275)))
   bean3273))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.CreateEventSubscriptionRequest create-event-subscription-request
  [m3277]
  (clojure.core/let
   [bean3276
    (new
     com.amazonaws.services.rds.model.CreateEventSubscriptionRequest)]
   (clojure.core/when-let
    [v3278 (:enabled m3277)]
    (. bean3276 setEnabled (clojure.core/boolean v3278)))
   (clojure.core/when-let
    [v3278 (:subscription-name m3277)]
    (. bean3276 setSubscriptionName (clojure.core/str v3278)))
   (clojure.core/when-let
    [v3278 (:sns-topic-arn m3277)]
    (. bean3276 setSnsTopicArn (clojure.core/str v3278)))
   (clojure.core/when-let
    [v3278 (:event-categories m3277)]
    (.
     bean3276
     setEventCategories
     (clojure.core/map
      (clojure.core/fn [arg3279] (clojure.core/str arg3279))
      v3278)))
   (clojure.core/when-let
    [v3278 (:source-ids m3277)]
    (.
     bean3276
     setSourceIds
     (clojure.core/map
      (clojure.core/fn [arg3280] (clojure.core/str arg3280))
      v3278)))
   (clojure.core/when-let
    [v3278 (:source-type m3277)]
    (. bean3276 setSourceType (clojure.core/str v3278)))
   bean3276))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest create-dbsecurity-group-request
  [m3282]
  (clojure.core/let
   [bean3281
    (new
     com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest)]
   (clojure.core/when-let
    [v3283 (:dbsecurity-group-name m3282)]
    (. bean3281 setDBSecurityGroupName (clojure.core/str v3283)))
   (clojure.core/when-let
    [v3283 (:dbsecurity-group-description m3282)]
    (.
     bean3281
     setDBSecurityGroupDescription
     (clojure.core/str v3283)))
   bean3281))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.ModifyEventSubscriptionRequest modify-event-subscription-request
  [m3285]
  (clojure.core/let
   [bean3284
    (new
     com.amazonaws.services.rds.model.ModifyEventSubscriptionRequest)]
   (clojure.core/when-let
    [v3286 (:enabled m3285)]
    (. bean3284 setEnabled (clojure.core/boolean v3286)))
   (clojure.core/when-let
    [v3286 (:subscription-name m3285)]
    (. bean3284 setSubscriptionName (clojure.core/str v3286)))
   (clojure.core/when-let
    [v3286 (:sns-topic-arn m3285)]
    (. bean3284 setSnsTopicArn (clojure.core/str v3286)))
   (clojure.core/when-let
    [v3286 (:event-categories m3285)]
    (.
     bean3284
     setEventCategories
     (clojure.core/map
      (clojure.core/fn [arg3287] (clojure.core/str arg3287))
      v3286)))
   (clojure.core/when-let
    [v3286 (:source-type m3285)]
    (. bean3284 setSourceType (clojure.core/str v3286)))
   bean3284))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DeleteOptionGroupRequest delete-option-group-request
  [m3289]
  (clojure.core/let
   [bean3288
    (new com.amazonaws.services.rds.model.DeleteOptionGroupRequest)]
   (clojure.core/when-let
    [v3290 (:option-group-name m3289)]
    (. bean3288 setOptionGroupName (clojure.core/str v3290)))
   bean3288))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DownloadDBLogFilePortionRequest download-dblog-file-portion-request
  [m3292]
  (clojure.core/let
   [bean3291
    (new
     com.amazonaws.services.rds.model.DownloadDBLogFilePortionRequest)]
   (clojure.core/when-let
    [v3293 (:dbinstance-identifier m3292)]
    (. bean3291 setDBInstanceIdentifier (clojure.core/str v3293)))
   (clojure.core/when-let
    [v3293 (:log-file-name m3292)]
    (. bean3291 setLogFileName (clojure.core/str v3293)))
   (clojure.core/when-let
    [v3293 (:number-of-lines m3292)]
    (. bean3291 setNumberOfLines (clojure.core/int v3293)))
   (clojure.core/when-let
    [v3293 (:marker m3292)]
    (. bean3291 setMarker (clojure.core/str v3293)))
   bean3291))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeEventsRequest describe-events-request
  [m3295]
  (clojure.core/let
   [bean3294
    (new com.amazonaws.services.rds.model.DescribeEventsRequest)]
   (clojure.core/when-let
    [v3296 (:event-categories m3295)]
    (.
     bean3294
     setEventCategories
     (clojure.core/map
      (clojure.core/fn [arg3297] (clojure.core/str arg3297))
      v3296)))
   (clojure.core/when-let
    [v3296 (:marker m3295)]
    (. bean3294 setMarker (clojure.core/str v3296)))
   (clojure.core/when-let
    [v3296 (:max-records m3295)]
    (. bean3294 setMaxRecords (clojure.core/int v3296)))
   (clojure.core/when-let
    [v3296 (:start-time m3295)]
    (.
     bean3294
     setStartTime
     (com.palletops.awaze.common/to-date v3296)))
   (clojure.core/when-let
    [v3296 (:duration m3295)]
    (. bean3294 setDuration (clojure.core/int v3296)))
   (clojure.core/when-let
    [v3296 (:source-identifier m3295)]
    (. bean3294 setSourceIdentifier (clojure.core/str v3296)))
   (clojure.core/when-let
    [v3296 (:source-type m3295)]
    (. bean3294 setSourceType (source-type v3296)))
   (clojure.core/when-let
    [v3296 (:source-type m3295)]
    (. bean3294 setSourceType (clojure.core/str v3296)))
   (clojure.core/when-let
    [v3296 (:end-time m3295)]
    (. bean3294 setEndTime (com.palletops.awaze.common/to-date v3296)))
   bean3294))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest describe-reserved-dbinstances-offerings-request
  [m3299]
  (clojure.core/let
   [bean3298
    (new
     com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest)]
   (clojure.core/when-let
    [v3300 (:reserved-dbinstances-offering-id m3299)]
    (.
     bean3298
     setReservedDBInstancesOfferingId
     (clojure.core/str v3300)))
   (clojure.core/when-let
    [v3300 (:dbinstance-class m3299)]
    (. bean3298 setDBInstanceClass (clojure.core/str v3300)))
   (clojure.core/when-let
    [v3300 (:product-description m3299)]
    (. bean3298 setProductDescription (clojure.core/str v3300)))
   (clojure.core/when-let
    [v3300 (:multi-az m3299)]
    (. bean3298 setMultiAZ (clojure.core/boolean v3300)))
   (clojure.core/when-let
    [v3300 (:marker m3299)]
    (. bean3298 setMarker (clojure.core/str v3300)))
   (clojure.core/when-let
    [v3300 (:max-records m3299)]
    (. bean3298 setMaxRecords (clojure.core/int v3300)))
   (clojure.core/when-let
    [v3300 (:duration m3299)]
    (. bean3298 setDuration (clojure.core/str v3300)))
   (clojure.core/when-let
    [v3300 (:offering-type m3299)]
    (. bean3298 setOfferingType (clojure.core/str v3300)))
   bean3298))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.ModifyOptionGroupRequest modify-option-group-request
  [m3302]
  (clojure.core/let
   [bean3301
    (new com.amazonaws.services.rds.model.ModifyOptionGroupRequest)]
   (clojure.core/when-let
    [v3303 (:option-group-name m3302)]
    (. bean3301 setOptionGroupName (clojure.core/str v3303)))
   (clojure.core/when-let
    [v3303 (:options-to-include m3302)]
    (.
     bean3301
     setOptionsToInclude
     (clojure.core/map
      (clojure.core/fn [arg3304] (option-configuration arg3304))
      v3303)))
   (clojure.core/when-let
    [v3303 (:options-to-remove m3302)]
    (.
     bean3301
     setOptionsToRemove
     (clojure.core/map
      (clojure.core/fn [arg3305] (clojure.core/str arg3305))
      v3303)))
   (clojure.core/when-let
    [v3303 (:apply-immediately m3302)]
    (. bean3301 setApplyImmediately (clojure.core/boolean v3303)))
   bean3301))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeDBInstancesRequest describe-dbinstances-request
  [m3307]
  (clojure.core/let
   [bean3306
    (new com.amazonaws.services.rds.model.DescribeDBInstancesRequest)]
   (clojure.core/when-let
    [v3308 (:dbinstance-identifier m3307)]
    (. bean3306 setDBInstanceIdentifier (clojure.core/str v3308)))
   (clojure.core/when-let
    [v3308 (:marker m3307)]
    (. bean3306 setMarker (clojure.core/str v3308)))
   (clojure.core/when-let
    [v3308 (:max-records m3307)]
    (. bean3306 setMaxRecords (clojure.core/int v3308)))
   bean3306))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.CreateDBSnapshotRequest create-dbsnapshot-request
  [m3310]
  (clojure.core/let
   [bean3309
    (new com.amazonaws.services.rds.model.CreateDBSnapshotRequest)]
   (clojure.core/when-let
    [v3311 (:dbsnapshot-identifier m3310)]
    (. bean3309 setDBSnapshotIdentifier (clojure.core/str v3311)))
   (clojure.core/when-let
    [v3311 (:dbinstance-identifier m3310)]
    (. bean3309 setDBInstanceIdentifier (clojure.core/str v3311)))
   bean3309))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest remove-source-identifier-from-subscription-request
  [m3313]
  (clojure.core/let
   [bean3312
    (new
     com.amazonaws.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest)]
   (clojure.core/when-let
    [v3314 (:subscription-name m3313)]
    (. bean3312 setSubscriptionName (clojure.core/str v3314)))
   (clojure.core/when-let
    [v3314 (:source-identifier m3313)]
    (. bean3312 setSourceIdentifier (clojure.core/str v3314)))
   bean3312))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.CreateOptionGroupRequest create-option-group-request
  [m3316]
  (clojure.core/let
   [bean3315
    (new com.amazonaws.services.rds.model.CreateOptionGroupRequest)]
   (clojure.core/when-let
    [v3317 (:option-group-name m3316)]
    (. bean3315 setOptionGroupName (clojure.core/str v3317)))
   (clojure.core/when-let
    [v3317 (:option-group-description m3316)]
    (. bean3315 setOptionGroupDescription (clojure.core/str v3317)))
   (clojure.core/when-let
    [v3317 (:engine-name m3316)]
    (. bean3315 setEngineName (clojure.core/str v3317)))
   (clojure.core/when-let
    [v3317 (:major-engine-version m3316)]
    (. bean3315 setMajorEngineVersion (clojure.core/str v3317)))
   bean3315))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeEventSubscriptionsRequest describe-event-subscriptions-request
  [m3319]
  (clojure.core/let
   [bean3318
    (new
     com.amazonaws.services.rds.model.DescribeEventSubscriptionsRequest)]
   (clojure.core/when-let
    [v3320 (:subscription-name m3319)]
    (. bean3318 setSubscriptionName (clojure.core/str v3320)))
   (clojure.core/when-let
    [v3320 (:marker m3319)]
    (. bean3318 setMarker (clojure.core/str v3320)))
   (clojure.core/when-let
    [v3320 (:max-records m3319)]
    (. bean3318 setMaxRecords (clojure.core/int v3320)))
   bean3318))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest describe-orderable-dbinstance-options-request
  [m3322]
  (clojure.core/let
   [bean3321
    (new
     com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest)]
   (clojure.core/when-let
    [v3323 (:dbinstance-class m3322)]
    (. bean3321 setDBInstanceClass (clojure.core/str v3323)))
   (clojure.core/when-let
    [v3323 (:engine m3322)]
    (. bean3321 setEngine (clojure.core/str v3323)))
   (clojure.core/when-let
    [v3323 (:engine-version m3322)]
    (. bean3321 setEngineVersion (clojure.core/str v3323)))
   (clojure.core/when-let
    [v3323 (:license-model m3322)]
    (. bean3321 setLicenseModel (clojure.core/str v3323)))
   (clojure.core/when-let
    [v3323 (:vpc m3322)]
    (. bean3321 setVpc (clojure.core/boolean v3323)))
   (clojure.core/when-let
    [v3323 (:marker m3322)]
    (. bean3321 setMarker (clojure.core/str v3323)))
   (clojure.core/when-let
    [v3323 (:max-records m3322)]
    (. bean3321 setMaxRecords (clojure.core/int v3323)))
   bean3321))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.ListTagsForResourceRequest list-tags-for-resource-request
  [m3325]
  (clojure.core/let
   [bean3324
    (new com.amazonaws.services.rds.model.ListTagsForResourceRequest)]
   (clojure.core/when-let
    [v3326 (:resource-name m3325)]
    (. bean3324 setResourceName (clojure.core/str v3326)))
   bean3324))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.ModifyDBSubnetGroupRequest modify-dbsubnet-group-request
  [m3328]
  (clojure.core/let
   [bean3327
    (new com.amazonaws.services.rds.model.ModifyDBSubnetGroupRequest)]
   (clojure.core/when-let
    [v3329 (:dbsubnet-group-name m3328)]
    (. bean3327 setDBSubnetGroupName (clojure.core/str v3329)))
   (clojure.core/when-let
    [v3329 (:dbsubnet-group-description m3328)]
    (. bean3327 setDBSubnetGroupDescription (clojure.core/str v3329)))
   (clojure.core/when-let
    [v3329 (:subnet-ids m3328)]
    (.
     bean3327
     setSubnetIds
     (clojure.core/map
      (clojure.core/fn [arg3330] (clojure.core/str arg3330))
      v3329)))
   bean3327))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeDBLogFilesRequest describe-dblog-files-request
  [m3332]
  (clojure.core/let
   [bean3331
    (new com.amazonaws.services.rds.model.DescribeDBLogFilesRequest)]
   (clojure.core/when-let
    [v3333 (:dbinstance-identifier m3332)]
    (. bean3331 setDBInstanceIdentifier (clojure.core/str v3333)))
   (clojure.core/when-let
    [v3333 (:filename-contains m3332)]
    (. bean3331 setFilenameContains (clojure.core/str v3333)))
   (clojure.core/when-let
    [v3333 (:file-last-written m3332)]
    (. bean3331 setFileLastWritten (clojure.core/long v3333)))
   (clojure.core/when-let
    [v3333 (:file-size m3332)]
    (. bean3331 setFileSize (clojure.core/long v3333)))
   (clojure.core/when-let
    [v3333 (:marker m3332)]
    (. bean3331 setMarker (clojure.core/str v3333)))
   (clojure.core/when-let
    [v3333 (:max-records m3332)]
    (. bean3331 setMaxRecords (clojure.core/int v3333)))
   bean3331))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.PromoteReadReplicaRequest promote-read-replica-request
  [m3335]
  (clojure.core/let
   [bean3334
    (new com.amazonaws.services.rds.model.PromoteReadReplicaRequest)]
   (clojure.core/when-let
    [v3336 (:dbinstance-identifier m3335)]
    (. bean3334 setDBInstanceIdentifier (clojure.core/str v3336)))
   (clojure.core/when-let
    [v3336 (:preferred-backup-window m3335)]
    (. bean3334 setPreferredBackupWindow (clojure.core/str v3336)))
   (clojure.core/when-let
    [v3336 (:backup-retention-period m3335)]
    (. bean3334 setBackupRetentionPeriod (clojure.core/int v3336)))
   bean3334))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DeleteDBSubnetGroupRequest delete-dbsubnet-group-request
  [m3338]
  (clojure.core/let
   [bean3337
    (new com.amazonaws.services.rds.model.DeleteDBSubnetGroupRequest)]
   (clojure.core/when-let
    [v3339 (:dbsubnet-group-name m3338)]
    (. bean3337 setDBSubnetGroupName (clojure.core/str v3339)))
   bean3337))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest describe-dbsnapshots-request
  [m3341]
  (clojure.core/let
   [bean3340
    (new com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest)]
   (clojure.core/when-let
    [v3342 (:dbsnapshot-identifier m3341)]
    (. bean3340 setDBSnapshotIdentifier (clojure.core/str v3342)))
   (clojure.core/when-let
    [v3342 (:dbinstance-identifier m3341)]
    (. bean3340 setDBInstanceIdentifier (clojure.core/str v3342)))
   (clojure.core/when-let
    [v3342 (:marker m3341)]
    (. bean3340 setMarker (clojure.core/str v3342)))
   (clojure.core/when-let
    [v3342 (:snapshot-type m3341)]
    (. bean3340 setSnapshotType (clojure.core/str v3342)))
   (clojure.core/when-let
    [v3342 (:max-records m3341)]
    (. bean3340 setMaxRecords (clojure.core/int v3342)))
   bean3340))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.AddSourceIdentifierToSubscriptionRequest add-source-identifier-to-subscription-request
  [m3344]
  (clojure.core/let
   [bean3343
    (new
     com.amazonaws.services.rds.model.AddSourceIdentifierToSubscriptionRequest)]
   (clojure.core/when-let
    [v3345 (:subscription-name m3344)]
    (. bean3343 setSubscriptionName (clojure.core/str v3345)))
   (clojure.core/when-let
    [v3345 (:source-identifier m3344)]
    (. bean3343 setSourceIdentifier (clojure.core/str v3345)))
   bean3343))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.RemoveTagsFromResourceRequest remove-tags-from-resource-request
  [m3347]
  (clojure.core/let
   [bean3346
    (new
     com.amazonaws.services.rds.model.RemoveTagsFromResourceRequest)]
   (clojure.core/when-let
    [v3348 (:resource-name m3347)]
    (. bean3346 setResourceName (clojure.core/str v3348)))
   (clojure.core/when-let
    [v3348 (:tag-keys m3347)]
    (.
     bean3346
     setTagKeys
     (clojure.core/map
      (clojure.core/fn [arg3349] (clojure.core/str arg3349))
      v3348)))
   bean3346))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.ModifyDBInstanceRequest modify-dbinstance-request
  [m3351]
  (clojure.core/let
   [bean3350
    (new com.amazonaws.services.rds.model.ModifyDBInstanceRequest)]
   (clojure.core/when-let
    [v3352 (:dbinstance-class m3351)]
    (. bean3350 setDBInstanceClass (clojure.core/str v3352)))
   (clojure.core/when-let
    [v3352 (:multi-az m3351)]
    (. bean3350 setMultiAZ (clojure.core/boolean v3352)))
   (clojure.core/when-let
    [v3352 (:dbinstance-identifier m3351)]
    (. bean3350 setDBInstanceIdentifier (clojure.core/str v3352)))
   (clojure.core/when-let
    [v3352 (:allocated-storage m3351)]
    (. bean3350 setAllocatedStorage (clojure.core/int v3352)))
   (clojure.core/when-let
    [v3352 (:engine-version m3351)]
    (. bean3350 setEngineVersion (clojure.core/str v3352)))
   (clojure.core/when-let
    [v3352 (:iops m3351)]
    (. bean3350 setIops (clojure.core/int v3352)))
   (clojure.core/when-let
    [v3352 (:option-group-name m3351)]
    (. bean3350 setOptionGroupName (clojure.core/str v3352)))
   (clojure.core/when-let
    [v3352 (:auto-minor-version-upgrade m3351)]
    (.
     bean3350
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v3352)))
   (clojure.core/when-let
    [v3352 (:preferred-backup-window m3351)]
    (. bean3350 setPreferredBackupWindow (clojure.core/str v3352)))
   (clojure.core/when-let
    [v3352 (:backup-retention-period m3351)]
    (. bean3350 setBackupRetentionPeriod (clojure.core/int v3352)))
   (clojure.core/when-let
    [v3352 (:dbsecurity-groups m3351)]
    (.
     bean3350
     setDBSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg3353] (clojure.core/str arg3353))
      v3352)))
   (clojure.core/when-let
    [v3352 (:apply-immediately m3351)]
    (. bean3350 setApplyImmediately (clojure.core/boolean v3352)))
   (clojure.core/when-let
    [v3352 (:dbparameter-group-name m3351)]
    (. bean3350 setDBParameterGroupName (clojure.core/str v3352)))
   (clojure.core/when-let
    [v3352 (:allow-major-version-upgrade m3351)]
    (.
     bean3350
     setAllowMajorVersionUpgrade
     (clojure.core/boolean v3352)))
   (clojure.core/when-let
    [v3352 (:new-dbinstance-identifier m3351)]
    (. bean3350 setNewDBInstanceIdentifier (clojure.core/str v3352)))
   (clojure.core/when-let
    [v3352 (:preferred-maintenance-window m3351)]
    (.
     bean3350
     setPreferredMaintenanceWindow
     (clojure.core/str v3352)))
   (clojure.core/when-let
    [v3352 (:vpc-security-group-ids m3351)]
    (.
     bean3350
     setVpcSecurityGroupIds
     (clojure.core/map
      (clojure.core/fn [arg3354] (clojure.core/str arg3354))
      v3352)))
   (clojure.core/when-let
    [v3352 (:master-user-password m3351)]
    (. bean3350 setMasterUserPassword (clojure.core/str v3352)))
   bean3350))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeDBEngineVersionsRequest describe-dbengine-versions-request
  [m3356]
  (clojure.core/let
   [bean3355
    (new
     com.amazonaws.services.rds.model.DescribeDBEngineVersionsRequest)]
   (clojure.core/when-let
    [v3357 (:engine m3356)]
    (. bean3355 setEngine (clojure.core/str v3357)))
   (clojure.core/when-let
    [v3357 (:engine-version m3356)]
    (. bean3355 setEngineVersion (clojure.core/str v3357)))
   (clojure.core/when-let
    [v3357 (:dbparameter-group-family m3356)]
    (. bean3355 setDBParameterGroupFamily (clojure.core/str v3357)))
   (clojure.core/when-let
    [v3357 (:default-only m3356)]
    (. bean3355 setDefaultOnly (clojure.core/boolean v3357)))
   (clojure.core/when-let
    [v3357 (:list-supported-character-sets m3356)]
    (.
     bean3355
     setListSupportedCharacterSets
     (clojure.core/boolean v3357)))
   (clojure.core/when-let
    [v3357 (:marker m3356)]
    (. bean3355 setMarker (clojure.core/str v3357)))
   (clojure.core/when-let
    [v3357 (:max-records m3356)]
    (. bean3355 setMaxRecords (clojure.core/int v3357)))
   bean3355))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.RebootDBInstanceRequest reboot-dbinstance-request
  [m3359]
  (clojure.core/let
   [bean3358
    (new com.amazonaws.services.rds.model.RebootDBInstanceRequest)]
   (clojure.core/when-let
    [v3360 (:dbinstance-identifier m3359)]
    (. bean3358 setDBInstanceIdentifier (clojure.core/str v3360)))
   (clojure.core/when-let
    [v3360 (:force-failover m3359)]
    (. bean3358 setForceFailover (clojure.core/boolean v3360)))
   bean3358))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeOptionGroupOptionsRequest describe-option-group-options-request
  [m3362]
  (clojure.core/let
   [bean3361
    (new
     com.amazonaws.services.rds.model.DescribeOptionGroupOptionsRequest)]
   (clojure.core/when-let
    [v3363 (:engine-name m3362)]
    (. bean3361 setEngineName (clojure.core/str v3363)))
   (clojure.core/when-let
    [v3363 (:major-engine-version m3362)]
    (. bean3361 setMajorEngineVersion (clojure.core/str v3363)))
   (clojure.core/when-let
    [v3363 (:marker m3362)]
    (. bean3361 setMarker (clojure.core/str v3363)))
   (clojure.core/when-let
    [v3363 (:max-records m3362)]
    (. bean3361 setMaxRecords (clojure.core/int v3363)))
   bean3361))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.CreateDBInstanceRequest create-dbinstance-request
  [m3365]
  (clojure.core/let
   [bean3364
    (new com.amazonaws.services.rds.model.CreateDBInstanceRequest)]
   (clojure.core/when-let
    [v3366 (:dbinstance-class m3365)]
    (. bean3364 setDBInstanceClass (clojure.core/str v3366)))
   (clojure.core/when-let
    [v3366 (:multi-az m3365)]
    (. bean3364 setMultiAZ (clojure.core/boolean v3366)))
   (clojure.core/when-let
    [v3366 (:dbsubnet-group-name m3365)]
    (. bean3364 setDBSubnetGroupName (clojure.core/str v3366)))
   (clojure.core/when-let
    [v3366 (:dbinstance-identifier m3365)]
    (. bean3364 setDBInstanceIdentifier (clojure.core/str v3366)))
   (clojure.core/when-let
    [v3366 (:engine m3365)]
    (. bean3364 setEngine (clojure.core/str v3366)))
   (clojure.core/when-let
    [v3366 (:allocated-storage m3365)]
    (. bean3364 setAllocatedStorage (clojure.core/int v3366)))
   (clojure.core/when-let
    [v3366 (:engine-version m3365)]
    (. bean3364 setEngineVersion (clojure.core/str v3366)))
   (clojure.core/when-let
    [v3366 (:license-model m3365)]
    (. bean3364 setLicenseModel (clojure.core/str v3366)))
   (clojure.core/when-let
    [v3366 (:iops m3365)]
    (. bean3364 setIops (clojure.core/int v3366)))
   (clojure.core/when-let
    [v3366 (:option-group-name m3365)]
    (. bean3364 setOptionGroupName (clojure.core/str v3366)))
   (clojure.core/when-let
    [v3366 (:auto-minor-version-upgrade m3365)]
    (.
     bean3364
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v3366)))
   (clojure.core/when-let
    [v3366 (:preferred-backup-window m3365)]
    (. bean3364 setPreferredBackupWindow (clojure.core/str v3366)))
   (clojure.core/when-let
    [v3366 (:backup-retention-period m3365)]
    (. bean3364 setBackupRetentionPeriod (clojure.core/int v3366)))
   (clojure.core/when-let
    [v3366 (:dbsecurity-groups m3365)]
    (.
     bean3364
     setDBSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg3367] (clojure.core/str arg3367))
      v3366)))
   (clojure.core/when-let
    [v3366 (:character-set-name m3365)]
    (. bean3364 setCharacterSetName (clojure.core/str v3366)))
   (clojure.core/when-let
    [v3366 (:dbparameter-group-name m3365)]
    (. bean3364 setDBParameterGroupName (clojure.core/str v3366)))
   (clojure.core/when-let
    [v3366 (:port m3365)]
    (. bean3364 setPort (clojure.core/int v3366)))
   (clojure.core/when-let
    [v3366 (:availability-zone m3365)]
    (. bean3364 setAvailabilityZone (clojure.core/str v3366)))
   (clojure.core/when-let
    [v3366 (:master-username m3365)]
    (. bean3364 setMasterUsername (clojure.core/str v3366)))
   (clojure.core/when-let
    [v3366 (:dbname m3365)]
    (. bean3364 setDBName (clojure.core/str v3366)))
   (clojure.core/when-let
    [v3366 (:preferred-maintenance-window m3365)]
    (.
     bean3364
     setPreferredMaintenanceWindow
     (clojure.core/str v3366)))
   (clojure.core/when-let
    [v3366 (:publicly-accessible m3365)]
    (. bean3364 setPubliclyAccessible (clojure.core/boolean v3366)))
   (clojure.core/when-let
    [v3366 (:vpc-security-group-ids m3365)]
    (.
     bean3364
     setVpcSecurityGroupIds
     (clojure.core/map
      (clojure.core/fn [arg3368] (clojure.core/str arg3368))
      v3366)))
   (clojure.core/when-let
    [v3366 (:master-user-password m3365)]
    (. bean3364 setMasterUserPassword (clojure.core/str v3366)))
   bean3364))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeDBSubnetGroupsRequest describe-dbsubnet-groups-request
  [m3370]
  (clojure.core/let
   [bean3369
    (new
     com.amazonaws.services.rds.model.DescribeDBSubnetGroupsRequest)]
   (clojure.core/when-let
    [v3371 (:dbsubnet-group-name m3370)]
    (. bean3369 setDBSubnetGroupName (clojure.core/str v3371)))
   (clojure.core/when-let
    [v3371 (:marker m3370)]
    (. bean3369 setMarker (clojure.core/str v3371)))
   (clojure.core/when-let
    [v3371 (:max-records m3370)]
    (. bean3369 setMaxRecords (clojure.core/int v3371)))
   bean3369))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DeleteEventSubscriptionRequest delete-event-subscription-request
  [m3373]
  (clojure.core/let
   [bean3372
    (new
     com.amazonaws.services.rds.model.DeleteEventSubscriptionRequest)]
   (clojure.core/when-let
    [v3374 (:subscription-name m3373)]
    (. bean3372 setSubscriptionName (clojure.core/str v3374)))
   bean3372))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeDBParameterGroupsRequest describe-dbparameter-groups-request
  [m3376]
  (clojure.core/let
   [bean3375
    (new
     com.amazonaws.services.rds.model.DescribeDBParameterGroupsRequest)]
   (clojure.core/when-let
    [v3377 (:dbparameter-group-name m3376)]
    (. bean3375 setDBParameterGroupName (clojure.core/str v3377)))
   (clojure.core/when-let
    [v3377 (:marker m3376)]
    (. bean3375 setMarker (clojure.core/str v3377)))
   (clojure.core/when-let
    [v3377 (:max-records m3376)]
    (. bean3375 setMaxRecords (clojure.core/int v3377)))
   bean3375))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.ResetDBParameterGroupRequest reset-dbparameter-group-request
  [m3379]
  (clojure.core/let
   [bean3378
    (new
     com.amazonaws.services.rds.model.ResetDBParameterGroupRequest)]
   (clojure.core/when-let
    [v3380 (:parameters m3379)]
    (.
     bean3378
     setParameters
     (clojure.core/map
      (clojure.core/fn [arg3381] (parameter arg3381))
      v3380)))
   (clojure.core/when-let
    [v3380 (:dbparameter-group-name m3379)]
    (. bean3378 setDBParameterGroupName (clojure.core/str v3380)))
   (clojure.core/when-let
    [v3380 (:reset-all-parameters m3379)]
    (. bean3378 setResetAllParameters (clojure.core/boolean v3380)))
   bean3378))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest restore-dbinstance-to-point-in-time-request
  [m3383]
  (clojure.core/let
   [bean3382
    (new
     com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest)]
   (clojure.core/when-let
    [v3384 (:dbinstance-class m3383)]
    (. bean3382 setDBInstanceClass (clojure.core/str v3384)))
   (clojure.core/when-let
    [v3384 (:multi-az m3383)]
    (. bean3382 setMultiAZ (clojure.core/boolean v3384)))
   (clojure.core/when-let
    [v3384 (:dbsubnet-group-name m3383)]
    (. bean3382 setDBSubnetGroupName (clojure.core/str v3384)))
   (clojure.core/when-let
    [v3384 (:engine m3383)]
    (. bean3382 setEngine (clojure.core/str v3384)))
   (clojure.core/when-let
    [v3384 (:license-model m3383)]
    (. bean3382 setLicenseModel (clojure.core/str v3384)))
   (clojure.core/when-let
    [v3384 (:iops m3383)]
    (. bean3382 setIops (clojure.core/int v3384)))
   (clojure.core/when-let
    [v3384 (:option-group-name m3383)]
    (. bean3382 setOptionGroupName (clojure.core/str v3384)))
   (clojure.core/when-let
    [v3384 (:auto-minor-version-upgrade m3383)]
    (.
     bean3382
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v3384)))
   (clojure.core/when-let
    [v3384 (:source-dbinstance-identifier m3383)]
    (.
     bean3382
     setSourceDBInstanceIdentifier
     (clojure.core/str v3384)))
   (clojure.core/when-let
    [v3384 (:target-dbinstance-identifier m3383)]
    (.
     bean3382
     setTargetDBInstanceIdentifier
     (clojure.core/str v3384)))
   (clojure.core/when-let
    [v3384 (:restore-time m3383)]
    (.
     bean3382
     setRestoreTime
     (com.palletops.awaze.common/to-date v3384)))
   (clojure.core/when-let
    [v3384 (:use-latest-restorable-time m3383)]
    (.
     bean3382
     setUseLatestRestorableTime
     (clojure.core/boolean v3384)))
   (clojure.core/when-let
    [v3384 (:port m3383)]
    (. bean3382 setPort (clojure.core/int v3384)))
   (clojure.core/when-let
    [v3384 (:availability-zone m3383)]
    (. bean3382 setAvailabilityZone (clojure.core/str v3384)))
   (clojure.core/when-let
    [v3384 (:dbname m3383)]
    (. bean3382 setDBName (clojure.core/str v3384)))
   (clojure.core/when-let
    [v3384 (:publicly-accessible m3383)]
    (. bean3382 setPubliclyAccessible (clojure.core/boolean v3384)))
   bean3382))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest modify-dbparameter-group-request
  [m3386]
  (clojure.core/let
   [bean3385
    (new
     com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest)]
   (clojure.core/when-let
    [v3387 (:parameters m3386)]
    (.
     bean3385
     setParameters
     (clojure.core/map
      (clojure.core/fn [arg3388] (parameter arg3388))
      v3387)))
   (clojure.core/when-let
    [v3387 (:dbparameter-group-name m3386)]
    (. bean3385 setDBParameterGroupName (clojure.core/str v3387)))
   bean3385))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DeleteDBInstanceRequest delete-dbinstance-request
  [m3390]
  (clojure.core/let
   [bean3389
    (new com.amazonaws.services.rds.model.DeleteDBInstanceRequest)]
   (clojure.core/when-let
    [v3391 (:dbinstance-identifier m3390)]
    (. bean3389 setDBInstanceIdentifier (clojure.core/str v3391)))
   (clojure.core/when-let
    [v3391 (:skip-final-snapshot m3390)]
    (. bean3389 setSkipFinalSnapshot (clojure.core/boolean v3391)))
   (clojure.core/when-let
    [v3391 (:final-dbsnapshot-identifier m3390)]
    (. bean3389 setFinalDBSnapshotIdentifier (clojure.core/str v3391)))
   bean3389))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DescribeEventCategoriesRequest describe-event-categories-request
  [m3393]
  (clojure.core/let
   [bean3392
    (new
     com.amazonaws.services.rds.model.DescribeEventCategoriesRequest)]
   (clojure.core/when-let
    [v3394 (:source-type m3393)]
    (. bean3392 setSourceType (clojure.core/str v3394)))
   bean3392))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest authorize-dbsecurity-group-ingress-request
  [m3396]
  (clojure.core/let
   [bean3395
    (new
     com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v3397 (:dbsecurity-group-name m3396)]
    (. bean3395 setDBSecurityGroupName (clojure.core/str v3397)))
   (clojure.core/when-let
    [v3397 (:ec2security-group-id m3396)]
    (. bean3395 setEC2SecurityGroupId (clojure.core/str v3397)))
   (clojure.core/when-let
    [v3397 (:cidrip m3396)]
    (. bean3395 setCIDRIP (clojure.core/str v3397)))
   (clojure.core/when-let
    [v3397 (:ec2security-group-name m3396)]
    (. bean3395 setEC2SecurityGroupName (clojure.core/str v3397)))
   (clojure.core/when-let
    [v3397 (:ec2security-group-owner-id m3396)]
    (. bean3395 setEC2SecurityGroupOwnerId (clojure.core/str v3397)))
   bean3395))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.CopyDBSnapshotRequest copy-dbsnapshot-request
  [m3399]
  (clojure.core/let
   [bean3398
    (new com.amazonaws.services.rds.model.CopyDBSnapshotRequest)]
   (clojure.core/when-let
    [v3400 (:source-dbsnapshot-identifier m3399)]
    (.
     bean3398
     setSourceDBSnapshotIdentifier
     (clojure.core/str v3400)))
   (clojure.core/when-let
    [v3400 (:target-dbsnapshot-identifier m3399)]
    (.
     bean3398
     setTargetDBSnapshotIdentifier
     (clojure.core/str v3400)))
   bean3398))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.DeleteDBSnapshotRequest delete-dbsnapshot-request
  [m3402]
  (clojure.core/let
   [bean3401
    (new com.amazonaws.services.rds.model.DeleteDBSnapshotRequest)]
   (clojure.core/when-let
    [v3403 (:dbsnapshot-identifier m3402)]
    (. bean3401 setDBSnapshotIdentifier (clojure.core/str v3403)))
   bean3401))
 (clojure.core/defn
  ^com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest create-dbsubnet-group-request
  [m3405]
  (clojure.core/let
   [bean3404
    (new com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest)]
   (clojure.core/when-let
    [v3406 (:dbsubnet-group-name m3405)]
    (. bean3404 setDBSubnetGroupName (clojure.core/str v3406)))
   (clojure.core/when-let
    [v3406 (:dbsubnet-group-description m3405)]
    (. bean3404 setDBSubnetGroupDescription (clojure.core/str v3406)))
   (clojure.core/when-let
    [v3406 (:subnet-ids m3405)]
    (.
     bean3404
     setSubnetIds
     (clojure.core/map
      (clojure.core/fn [arg3407] (clojure.core/str arg3407))
      v3406)))
   bean3404))
 (clojure.core/defmulti
  rds
  (clojure.core/fn rds [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   rds
   :revoke-dbsecurity-group-ingress
   [m3408]
   (clojure.core/let
    [credentials3409 (:credentials m3408) args3410 (:args m3408)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3411
      (com.palletops.awaze.common/aws-client :rds credentials3409)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3411
       revokeDBSecurityGroupIngress
       (revoke-dbsecurity-group-ingress-request
        (clojure.core/nth args3410 0)))))))
  (clojure.core/defn
   revoke-dbsecurity-group-ingress-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         ec2security-group-owner-id
         ec2security-group-name
         ec2security-group-id
         dbsecurity-group-name
         cidrip]}]],
    :doc "Generate map for revokeDBSecurityGroupIngress"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :revoke-dbsecurity-group-ingress,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   revoke-dbsecurity-group-ingress
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         ec2security-group-owner-id
         ec2security-group-name
         ec2security-group-id
         dbsecurity-group-name
         cidrip]}]],
    :doc "Call revokeDBSecurityGroupIngress"}
   [credentials3413 & args3414]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3415
     (com.palletops.awaze.common/aws-client :rds credentials3413)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3415
      revokeDBSecurityGroupIngress
      (revoke-dbsecurity-group-ingress-request
       (clojure.core/nth args3414 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :add-tags-to-resource
   [m3416]
   (clojure.core/let
    [credentials3417 (:credentials m3416) args3418 (:args m3416)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3419
      (com.palletops.awaze.common/aws-client :rds credentials3417)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3419
       addTagsToResource
       (add-tags-to-resource-request
        (clojure.core/nth args3418 0)))))))
  (clojure.core/defn
   add-tags-to-resource-map
   {:arglists
    '[[credentials
       {:keys [tags resource-name request-metric-collector]}]],
    :doc "Generate map for addTagsToResource"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :add-tags-to-resource,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   add-tags-to-resource
   {:arglists
    '[[credentials
       {:keys [tags resource-name request-metric-collector]}]],
    :doc "Call addTagsToResource"}
   [credentials3421 & args3422]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3423
     (com.palletops.awaze.common/aws-client :rds credentials3421)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3423
      addTagsToResource
      (add-tags-to-resource-request (clojure.core/nth args3422 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsecurity-groups
   [m3424]
   (clojure.core/let
    [credentials3425 (:credentials m3424) args3426 (:args m3424)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3427
      (com.palletops.awaze.common/aws-client :rds credentials3425)]
     (clojure.core/case
      (clojure.core/count args3426)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3427
        describeDBSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3427
        describeDBSecurityGroups
        (describe-dbsecurity-groups-request
         (clojure.core/nth args3426 0))))))))
  (clojure.core/defn
   describe-dbsecurity-groups-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         dbsecurity-group-name]}]],
    :doc
    "Generate map for describeDBSecurityGroups, describeDBSecurityGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbsecurity-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbsecurity-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-dbsecurity-groups
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         dbsecurity-group-name]}]],
    :doc "Call describeDBSecurityGroups, describeDBSecurityGroups"}
   [credentials3429 & args3430]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3431
     (com.palletops.awaze.common/aws-client :rds credentials3429)]
    (clojure.core/case
     (clojure.core/count args3430)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3431
       describeDBSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3431
       describeDBSecurityGroups
       (describe-dbsecurity-groups-request
        (clojure.core/nth args3430 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :purchase-reserved-dbinstances-offering
   [m3432]
   (clojure.core/let
    [credentials3433 (:credentials m3432) args3434 (:args m3432)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3435
      (com.palletops.awaze.common/aws-client :rds credentials3433)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3435
       purchaseReservedDBInstancesOffering
       (purchase-reserved-dbinstances-offering-request
        (clojure.core/nth args3434 0)))))))
  (clojure.core/defn
   purchase-reserved-dbinstances-offering-map
   {:arglists
    '[[credentials
       {:keys
        [reserved-dbinstances-offering-id
         reserved-dbinstance-id
         request-metric-collector
         dbinstance-count]}]],
    :doc "Generate map for purchaseReservedDBInstancesOffering"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :purchase-reserved-dbinstances-offering,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   purchase-reserved-dbinstances-offering
   {:arglists
    '[[credentials
       {:keys
        [reserved-dbinstances-offering-id
         reserved-dbinstance-id
         request-metric-collector
         dbinstance-count]}]],
    :doc "Call purchaseReservedDBInstancesOffering"}
   [credentials3437 & args3438]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3439
     (com.palletops.awaze.common/aws-client :rds credentials3437)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3439
      purchaseReservedDBInstancesOffering
      (purchase-reserved-dbinstances-offering-request
       (clojure.core/nth args3438 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbparameters
   [m3440]
   (clojure.core/let
    [credentials3441 (:credentials m3440) args3442 (:args m3440)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3443
      (com.palletops.awaze.common/aws-client :rds credentials3441)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3443
       describeDBParameters
       (describe-dbparameters-request
        (clojure.core/nth args3442 0)))))))
  (clojure.core/defn
   describe-dbparameters-map
   {:arglists
    '[[credentials
       {:keys
        [source
         request-metric-collector
         max-records
         marker
         dbparameter-group-name]}]],
    :doc "Generate map for describeDBParameters"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbparameters,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-dbparameters
   {:arglists
    '[[credentials
       {:keys
        [source
         request-metric-collector
         max-records
         marker
         dbparameter-group-name]}]],
    :doc "Call describeDBParameters"}
   [credentials3445 & args3446]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3447
     (com.palletops.awaze.common/aws-client :rds credentials3445)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3447
      describeDBParameters
      (describe-dbparameters-request
       (clojure.core/nth args3446 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-option-groups
   [m3448]
   (clojure.core/let
    [credentials3449 (:credentials m3448) args3450 (:args m3448)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3451
      (com.palletops.awaze.common/aws-client :rds credentials3449)]
     (clojure.core/case
      (clojure.core/count args3450)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3451
        describeOptionGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3451
        describeOptionGroups
        (describe-option-groups-request
         (clojure.core/nth args3450 0))))))))
  (clojure.core/defn
   describe-option-groups-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         option-group-name
         max-records
         marker
         major-engine-version
         engine-name]}]],
    :doc "Generate map for describeOptionGroups, describeOptionGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :rds,
     :fn :describe-option-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-option-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-option-groups
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         option-group-name
         max-records
         marker
         major-engine-version
         engine-name]}]],
    :doc "Call describeOptionGroups, describeOptionGroups"}
   [credentials3453 & args3454]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3455
     (com.palletops.awaze.common/aws-client :rds credentials3453)]
    (clojure.core/case
     (clojure.core/count args3454)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3455
       describeOptionGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3455
       describeOptionGroups
       (describe-option-groups-request
        (clojure.core/nth args3454 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbinstance-read-replica
   [m3456]
   (clojure.core/let
    [credentials3457 (:credentials m3456) args3458 (:args m3456)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3459
      (com.palletops.awaze.common/aws-client :rds credentials3457)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3459
       createDBInstanceReadReplica
       (create-dbinstance-read-replica-request
        (clojure.core/nth args3458 0)))))))
  (clojure.core/defn
   create-dbinstance-read-replica-map
   {:arglists
    '[[credentials
       {:keys
        [publicly-accessible
         iops
         request-metric-collector
         availability-zone
         dbinstance-class
         port
         dbinstance-identifier
         source-dbinstance-identifier
         auto-minor-version-upgrade
         option-group-name]}]],
    :doc "Generate map for createDBInstanceReadReplica"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbinstance-read-replica,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-dbinstance-read-replica
   {:arglists
    '[[credentials
       {:keys
        [publicly-accessible
         iops
         request-metric-collector
         availability-zone
         dbinstance-class
         port
         dbinstance-identifier
         source-dbinstance-identifier
         auto-minor-version-upgrade
         option-group-name]}]],
    :doc "Call createDBInstanceReadReplica"}
   [credentials3461 & args3462]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3463
     (com.palletops.awaze.common/aws-client :rds credentials3461)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3463
      createDBInstanceReadReplica
      (create-dbinstance-read-replica-request
       (clojure.core/nth args3462 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :restore-dbinstance-from-dbsnapshot
   [m3464]
   (clojure.core/let
    [credentials3465 (:credentials m3464) args3466 (:args m3464)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3467
      (com.palletops.awaze.common/aws-client :rds credentials3465)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3467
       restoreDBInstanceFromDBSnapshot
       (restore-dbinstance-from-dbsnapshot-request
        (clojure.core/nth args3466 0)))))))
  (clojure.core/defn
   restore-dbinstance-from-dbsnapshot-map
   {:arglists
    '[[credentials
       {:keys
        [publicly-accessible
         dbsnapshot-identifier
         iops
         request-metric-collector
         engine
         availability-zone
         dbname
         dbinstance-class
         port
         license-model
         dbsubnet-group-name
         multi-az
         dbinstance-identifier
         auto-minor-version-upgrade
         option-group-name]}]],
    :doc "Generate map for restoreDBInstanceFromDBSnapshot"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :restore-dbinstance-from-dbsnapshot,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   restore-dbinstance-from-dbsnapshot
   {:arglists
    '[[credentials
       {:keys
        [publicly-accessible
         dbsnapshot-identifier
         iops
         request-metric-collector
         engine
         availability-zone
         dbname
         dbinstance-class
         port
         license-model
         dbsubnet-group-name
         multi-az
         dbinstance-identifier
         auto-minor-version-upgrade
         option-group-name]}]],
    :doc "Call restoreDBInstanceFromDBSnapshot"}
   [credentials3469 & args3470]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3471
     (com.palletops.awaze.common/aws-client :rds credentials3469)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3471
      restoreDBInstanceFromDBSnapshot
      (restore-dbinstance-from-dbsnapshot-request
       (clojure.core/nth args3470 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbparameter-group
   [m3472]
   (clojure.core/let
    [credentials3473 (:credentials m3472) args3474 (:args m3472)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3475
      (com.palletops.awaze.common/aws-client :rds credentials3473)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3475
       deleteDBParameterGroup
       (delete-dbparameter-group-request
        (clojure.core/nth args3474 0)))))))
  (clojure.core/defn
   delete-dbparameter-group-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector dbparameter-group-name]}]],
    :doc "Generate map for deleteDBParameterGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbparameter-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-dbparameter-group
   {:arglists
    '[[credentials
       {:keys [request-metric-collector dbparameter-group-name]}]],
    :doc "Call deleteDBParameterGroup"}
   [credentials3477 & args3478]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3479
     (com.palletops.awaze.common/aws-client :rds credentials3477)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3479
      deleteDBParameterGroup
      (delete-dbparameter-group-request
       (clojure.core/nth args3478 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-reserved-dbinstances
   [m3480]
   (clojure.core/let
    [credentials3481 (:credentials m3480) args3482 (:args m3480)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3483
      (com.palletops.awaze.common/aws-client :rds credentials3481)]
     (clojure.core/case
      (clojure.core/count args3482)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3483
        describeReservedDBInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3483
        describeReservedDBInstances
        (describe-reserved-dbinstances-request
         (clojure.core/nth args3482 0))))))))
  (clojure.core/defn
   describe-reserved-dbinstances-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [duration
         request-metric-collector
         reserved-dbinstances-offering-id
         reserved-dbinstance-id
         max-records
         dbinstance-class
         marker
         product-description
         offering-type
         multi-az]}]],
    :doc
    "Generate map for describeReservedDBInstances, describeReservedDBInstances"}
   ([credentials__577__auto__]
    {:args [],
     :client :rds,
     :fn :describe-reserved-dbinstances,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-reserved-dbinstances,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-reserved-dbinstances
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [duration
         request-metric-collector
         reserved-dbinstances-offering-id
         reserved-dbinstance-id
         max-records
         dbinstance-class
         marker
         product-description
         offering-type
         multi-az]}]],
    :doc
    "Call describeReservedDBInstances, describeReservedDBInstances"}
   [credentials3485 & args3486]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3487
     (com.palletops.awaze.common/aws-client :rds credentials3485)]
    (clojure.core/case
     (clojure.core/count args3486)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3487
       describeReservedDBInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3487
       describeReservedDBInstances
       (describe-reserved-dbinstances-request
        (clojure.core/nth args3486 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbsecurity-group
   [m3488]
   (clojure.core/let
    [credentials3489 (:credentials m3488) args3490 (:args m3488)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3491
      (com.palletops.awaze.common/aws-client :rds credentials3489)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3491
       deleteDBSecurityGroup
       (delete-dbsecurity-group-request
        (clojure.core/nth args3490 0)))))))
  (clojure.core/defn
   delete-dbsecurity-group-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector dbsecurity-group-name]}]],
    :doc "Generate map for deleteDBSecurityGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbsecurity-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-dbsecurity-group
   {:arglists
    '[[credentials
       {:keys [request-metric-collector dbsecurity-group-name]}]],
    :doc "Call deleteDBSecurityGroup"}
   [credentials3493 & args3494]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3495
     (com.palletops.awaze.common/aws-client :rds credentials3493)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3495
      deleteDBSecurityGroup
      (delete-dbsecurity-group-request
       (clojure.core/nth args3494 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-engine-default-parameters
   [m3496]
   (clojure.core/let
    [credentials3497 (:credentials m3496) args3498 (:args m3496)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3499
      (com.palletops.awaze.common/aws-client :rds credentials3497)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3499
       describeEngineDefaultParameters
       (describe-engine-default-parameters-request
        (clojure.core/nth args3498 0)))))))
  (clojure.core/defn
   describe-engine-default-parameters-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         dbparameter-group-family]}]],
    :doc "Generate map for describeEngineDefaultParameters"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-engine-default-parameters,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-engine-default-parameters
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         dbparameter-group-family]}]],
    :doc "Call describeEngineDefaultParameters"}
   [credentials3501 & args3502]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3503
     (com.palletops.awaze.common/aws-client :rds credentials3501)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3503
      describeEngineDefaultParameters
      (describe-engine-default-parameters-request
       (clojure.core/nth args3502 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbparameter-group
   [m3504]
   (clojure.core/let
    [credentials3505 (:credentials m3504) args3506 (:args m3504)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3507
      (com.palletops.awaze.common/aws-client :rds credentials3505)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3507
       createDBParameterGroup
       (create-dbparameter-group-request
        (clojure.core/nth args3506 0)))))))
  (clojure.core/defn
   create-dbparameter-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         description
         dbparameter-group-name
         dbparameter-group-family]}]],
    :doc "Generate map for createDBParameterGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbparameter-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-dbparameter-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         description
         dbparameter-group-name
         dbparameter-group-family]}]],
    :doc "Call createDBParameterGroup"}
   [credentials3509 & args3510]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3511
     (com.palletops.awaze.common/aws-client :rds credentials3509)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3511
      createDBParameterGroup
      (create-dbparameter-group-request
       (clojure.core/nth args3510 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-event-subscription
   [m3512]
   (clojure.core/let
    [credentials3513 (:credentials m3512) args3514 (:args m3512)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3515
      (com.palletops.awaze.common/aws-client :rds credentials3513)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3515
       createEventSubscription
       (create-event-subscription-request
        (clojure.core/nth args3514 0)))))))
  (clojure.core/defn
   create-event-subscription-map
   {:arglists
    '[[credentials
       {:keys
        [source-type
         subscription-name
         source-ids
         event-categories
         sns-topic-arn
         request-metric-collector
         enabled]}]],
    :doc "Generate map for createEventSubscription"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-event-subscription,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-event-subscription
   {:arglists
    '[[credentials
       {:keys
        [source-type
         subscription-name
         source-ids
         event-categories
         sns-topic-arn
         request-metric-collector
         enabled]}]],
    :doc "Call createEventSubscription"}
   [credentials3517 & args3518]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3519
     (com.palletops.awaze.common/aws-client :rds credentials3517)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3519
      createEventSubscription
      (create-event-subscription-request
       (clojure.core/nth args3518 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbsecurity-group
   [m3520]
   (clojure.core/let
    [credentials3521 (:credentials m3520) args3522 (:args m3520)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3523
      (com.palletops.awaze.common/aws-client :rds credentials3521)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3523
       createDBSecurityGroup
       (create-dbsecurity-group-request
        (clojure.core/nth args3522 0)))))))
  (clojure.core/defn
   create-dbsecurity-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         dbsecurity-group-name
         dbsecurity-group-description]}]],
    :doc "Generate map for createDBSecurityGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbsecurity-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-dbsecurity-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         dbsecurity-group-name
         dbsecurity-group-description]}]],
    :doc "Call createDBSecurityGroup"}
   [credentials3525 & args3526]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3527
     (com.palletops.awaze.common/aws-client :rds credentials3525)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3527
      createDBSecurityGroup
      (create-dbsecurity-group-request
       (clojure.core/nth args3526 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-event-subscription
   [m3528]
   (clojure.core/let
    [credentials3529 (:credentials m3528) args3530 (:args m3528)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3531
      (com.palletops.awaze.common/aws-client :rds credentials3529)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3531
       modifyEventSubscription
       (modify-event-subscription-request
        (clojure.core/nth args3530 0)))))))
  (clojure.core/defn
   modify-event-subscription-map
   {:arglists
    '[[credentials
       {:keys
        [subscription-name
         source-type
         sns-topic-arn
         request-metric-collector
         event-categories
         enabled]}]],
    :doc "Generate map for modifyEventSubscription"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-event-subscription,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-event-subscription
   {:arglists
    '[[credentials
       {:keys
        [subscription-name
         source-type
         sns-topic-arn
         request-metric-collector
         event-categories
         enabled]}]],
    :doc "Call modifyEventSubscription"}
   [credentials3533 & args3534]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3535
     (com.palletops.awaze.common/aws-client :rds credentials3533)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3535
      modifyEventSubscription
      (modify-event-subscription-request
       (clojure.core/nth args3534 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-option-group
   [m3536]
   (clojure.core/let
    [credentials3537 (:credentials m3536) args3538 (:args m3536)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3539
      (com.palletops.awaze.common/aws-client :rds credentials3537)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3539
       deleteOptionGroup
       (delete-option-group-request (clojure.core/nth args3538 0)))))))
  (clojure.core/defn
   delete-option-group-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector option-group-name]}]],
    :doc "Generate map for deleteOptionGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-option-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-option-group
   {:arglists
    '[[credentials
       {:keys [request-metric-collector option-group-name]}]],
    :doc "Call deleteOptionGroup"}
   [credentials3541 & args3542]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3543
     (com.palletops.awaze.common/aws-client :rds credentials3541)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3543
      deleteOptionGroup
      (delete-option-group-request (clojure.core/nth args3542 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :download-dblog-file-portion
   [m3544]
   (clojure.core/let
    [credentials3545 (:credentials m3544) args3546 (:args m3544)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3547
      (com.palletops.awaze.common/aws-client :rds credentials3545)]
     (clojure.core/case
      (clojure.core/count args3546)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3547
        downloadDBLogFilePortion))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3547
        downloadDBLogFilePortion
        (download-dblog-file-portion-request
         (clojure.core/nth args3546 0))))))))
  (clojure.core/defn
   download-dblog-file-portion-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         number-of-lines
         marker
         log-file-name
         dbinstance-identifier]}]],
    :doc
    "Generate map for downloadDBLogFilePortion, downloadDBLogFilePortion"}
   ([credentials__577__auto__]
    {:args [],
     :client :rds,
     :fn :download-dblog-file-portion,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :download-dblog-file-portion,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   download-dblog-file-portion
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         number-of-lines
         marker
         log-file-name
         dbinstance-identifier]}]],
    :doc "Call downloadDBLogFilePortion, downloadDBLogFilePortion"}
   [credentials3549 & args3550]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3551
     (com.palletops.awaze.common/aws-client :rds credentials3549)]
    (clojure.core/case
     (clojure.core/count args3550)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3551
       downloadDBLogFilePortion))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3551
       downloadDBLogFilePortion
       (download-dblog-file-portion-request
        (clojure.core/nth args3550 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-events
   [m3552]
   (clojure.core/let
    [credentials3553 (:credentials m3552) args3554 (:args m3552)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3555
      (com.palletops.awaze.common/aws-client :rds credentials3553)]
     (clojure.core/case
      (clojure.core/count args3554)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3555
        describeEvents))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3555
        describeEvents
        (describe-events-request (clojure.core/nth args3554 0))))))))
  (clojure.core/defn
   describe-events-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [end-time
         source-type
         duration
         request-metric-collector
         event-categories
         max-records
         start-time
         marker
         source-identifier]}]],
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__577__auto__]
    {:args [],
     :client :rds,
     :fn :describe-events,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-events,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [end-time
         source-type
         duration
         request-metric-collector
         event-categories
         max-records
         start-time
         marker
         source-identifier]}]],
    :doc "Call describeEvents, describeEvents"}
   [credentials3557 & args3558]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3559
     (com.palletops.awaze.common/aws-client :rds credentials3557)]
    (clojure.core/case
     (clojure.core/count args3558)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3559
       describeEvents))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3559
       describeEvents
       (describe-events-request (clojure.core/nth args3558 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-reserved-dbinstances-offerings
   [m3560]
   (clojure.core/let
    [credentials3561 (:credentials m3560) args3562 (:args m3560)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3563
      (com.palletops.awaze.common/aws-client :rds credentials3561)]
     (clojure.core/case
      (clojure.core/count args3562)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3563
        describeReservedDBInstancesOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3563
        describeReservedDBInstancesOfferings
        (describe-reserved-dbinstances-offerings-request
         (clojure.core/nth args3562 0))))))))
  (clojure.core/defn
   describe-reserved-dbinstances-offerings-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [duration
         request-metric-collector
         reserved-dbinstances-offering-id
         max-records
         dbinstance-class
         marker
         product-description
         offering-type
         multi-az]}]],
    :doc
    "Generate map for describeReservedDBInstancesOfferings, describeReservedDBInstancesOfferings"}
   ([credentials__577__auto__]
    {:args [],
     :client :rds,
     :fn :describe-reserved-dbinstances-offerings,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-reserved-dbinstances-offerings,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-reserved-dbinstances-offerings
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [duration
         request-metric-collector
         reserved-dbinstances-offering-id
         max-records
         dbinstance-class
         marker
         product-description
         offering-type
         multi-az]}]],
    :doc
    "Call describeReservedDBInstancesOfferings, describeReservedDBInstancesOfferings"}
   [credentials3565 & args3566]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3567
     (com.palletops.awaze.common/aws-client :rds credentials3565)]
    (clojure.core/case
     (clojure.core/count args3566)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3567
       describeReservedDBInstancesOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3567
       describeReservedDBInstancesOfferings
       (describe-reserved-dbinstances-offerings-request
        (clojure.core/nth args3566 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-option-group
   [m3568]
   (clojure.core/let
    [credentials3569 (:credentials m3568) args3570 (:args m3568)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3571
      (com.palletops.awaze.common/aws-client :rds credentials3569)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3571
       modifyOptionGroup
       (modify-option-group-request (clojure.core/nth args3570 0)))))))
  (clojure.core/defn
   modify-option-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         options-to-remove
         options-to-include
         option-group-name
         apply-immediately]}]],
    :doc "Generate map for modifyOptionGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-option-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-option-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         options-to-remove
         options-to-include
         option-group-name
         apply-immediately]}]],
    :doc "Call modifyOptionGroup"}
   [credentials3573 & args3574]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3575
     (com.palletops.awaze.common/aws-client :rds credentials3573)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3575
      modifyOptionGroup
      (modify-option-group-request (clojure.core/nth args3574 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbinstances
   [m3576]
   (clojure.core/let
    [credentials3577 (:credentials m3576) args3578 (:args m3576)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3579
      (com.palletops.awaze.common/aws-client :rds credentials3577)]
     (clojure.core/case
      (clojure.core/count args3578)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3579
        describeDBInstances
        (describe-dbinstances-request (clojure.core/nth args3578 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3579
        describeDBInstances))))))
  (clojure.core/defn
   describe-dbinstances-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         dbinstance-identifier]}]
      [credentials]],
    :doc "Generate map for describeDBInstances, describeDBInstances"}
   ([credentials__577__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbinstances,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbinstances,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-dbinstances
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         dbinstance-identifier]}]
      [credentials]],
    :doc "Call describeDBInstances, describeDBInstances"}
   [credentials3581 & args3582]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3583
     (com.palletops.awaze.common/aws-client :rds credentials3581)]
    (clojure.core/case
     (clojure.core/count args3582)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3583
       describeDBInstances
       (describe-dbinstances-request (clojure.core/nth args3582 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3583
       describeDBInstances))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbsnapshot
   [m3584]
   (clojure.core/let
    [credentials3585 (:credentials m3584) args3586 (:args m3584)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3587
      (com.palletops.awaze.common/aws-client :rds credentials3585)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3587
       createDBSnapshot
       (create-dbsnapshot-request (clojure.core/nth args3586 0)))))))
  (clojure.core/defn
   create-dbsnapshot-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         dbsnapshot-identifier
         dbinstance-identifier]}]],
    :doc "Generate map for createDBSnapshot"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbsnapshot,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-dbsnapshot
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         dbsnapshot-identifier
         dbinstance-identifier]}]],
    :doc "Call createDBSnapshot"}
   [credentials3589 & args3590]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3591
     (com.palletops.awaze.common/aws-client :rds credentials3589)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3591
      createDBSnapshot
      (create-dbsnapshot-request (clojure.core/nth args3590 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :remove-source-identifier-from-subscription
   [m3592]
   (clojure.core/let
    [credentials3593 (:credentials m3592) args3594 (:args m3592)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3595
      (com.palletops.awaze.common/aws-client :rds credentials3593)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3595
       removeSourceIdentifierFromSubscription
       (remove-source-identifier-from-subscription-request
        (clojure.core/nth args3594 0)))))))
  (clojure.core/defn
   remove-source-identifier-from-subscription-map
   {:arglists
    '[[credentials
       {:keys
        [subscription-name
         source-identifier
         request-metric-collector]}]],
    :doc "Generate map for removeSourceIdentifierFromSubscription"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :remove-source-identifier-from-subscription,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   remove-source-identifier-from-subscription
   {:arglists
    '[[credentials
       {:keys
        [subscription-name
         source-identifier
         request-metric-collector]}]],
    :doc "Call removeSourceIdentifierFromSubscription"}
   [credentials3597 & args3598]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3599
     (com.palletops.awaze.common/aws-client :rds credentials3597)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3599
      removeSourceIdentifierFromSubscription
      (remove-source-identifier-from-subscription-request
       (clojure.core/nth args3598 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-option-group
   [m3600]
   (clojure.core/let
    [credentials3601 (:credentials m3600) args3602 (:args m3600)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3603
      (com.palletops.awaze.common/aws-client :rds credentials3601)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3603
       createOptionGroup
       (create-option-group-request (clojure.core/nth args3602 0)))))))
  (clojure.core/defn
   create-option-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         option-group-name
         option-group-description
         major-engine-version
         engine-name]}]],
    :doc "Generate map for createOptionGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-option-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-option-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         option-group-name
         option-group-description
         major-engine-version
         engine-name]}]],
    :doc "Call createOptionGroup"}
   [credentials3605 & args3606]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3607
     (com.palletops.awaze.common/aws-client :rds credentials3605)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3607
      createOptionGroup
      (create-option-group-request (clojure.core/nth args3606 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-event-subscriptions
   [m3608]
   (clojure.core/let
    [credentials3609 (:credentials m3608) args3610 (:args m3608)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3611
      (com.palletops.awaze.common/aws-client :rds credentials3609)]
     (clojure.core/case
      (clojure.core/count args3610)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3611
        describeEventSubscriptions
        (describe-event-subscriptions-request
         (clojure.core/nth args3610 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3611
        describeEventSubscriptions))))))
  (clojure.core/defn
   describe-event-subscriptions-map
   {:arglists
    '[[credentials
       {:keys
        [subscription-name
         request-metric-collector
         max-records
         marker]}]
      [credentials]],
    :doc
    "Generate map for describeEventSubscriptions, describeEventSubscriptions"}
   ([credentials__577__auto__]
    {:args [],
     :client :rds,
     :fn :describe-event-subscriptions,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-event-subscriptions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-event-subscriptions
   {:arglists
    '[[credentials
       {:keys
        [subscription-name
         request-metric-collector
         max-records
         marker]}]
      [credentials]],
    :doc "Call describeEventSubscriptions, describeEventSubscriptions"}
   [credentials3613 & args3614]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3615
     (com.palletops.awaze.common/aws-client :rds credentials3613)]
    (clojure.core/case
     (clojure.core/count args3614)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3615
       describeEventSubscriptions
       (describe-event-subscriptions-request
        (clojure.core/nth args3614 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3615
       describeEventSubscriptions))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-orderable-dbinstance-options
   [m3616]
   (clojure.core/let
    [credentials3617 (:credentials m3616) args3618 (:args m3616)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3619
      (com.palletops.awaze.common/aws-client :rds credentials3617)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3619
       describeOrderableDBInstanceOptions
       (describe-orderable-dbinstance-options-request
        (clojure.core/nth args3618 0)))))))
  (clojure.core/defn
   describe-orderable-dbinstance-options-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         engine
         max-records
         dbinstance-class
         vpc
         marker
         license-model
         engine-version]}]],
    :doc "Generate map for describeOrderableDBInstanceOptions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-orderable-dbinstance-options,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-orderable-dbinstance-options
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         engine
         max-records
         dbinstance-class
         vpc
         marker
         license-model
         engine-version]}]],
    :doc "Call describeOrderableDBInstanceOptions"}
   [credentials3621 & args3622]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3623
     (com.palletops.awaze.common/aws-client :rds credentials3621)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3623
      describeOrderableDBInstanceOptions
      (describe-orderable-dbinstance-options-request
       (clojure.core/nth args3622 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :list-tags-for-resource
   [m3624]
   (clojure.core/let
    [credentials3625 (:credentials m3624) args3626 (:args m3624)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3627
      (com.palletops.awaze.common/aws-client :rds credentials3625)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3627
       listTagsForResource
       (list-tags-for-resource-request
        (clojure.core/nth args3626 0)))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists
    '[[credentials {:keys [resource-name request-metric-collector]}]],
    :doc "Generate map for listTagsForResource"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :list-tags-for-resource,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists
    '[[credentials {:keys [resource-name request-metric-collector]}]],
    :doc "Call listTagsForResource"}
   [credentials3629 & args3630]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3631
     (com.palletops.awaze.common/aws-client :rds credentials3629)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3631
      listTagsForResource
      (list-tags-for-resource-request
       (clojure.core/nth args3630 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbsubnet-group
   [m3632]
   (clojure.core/let
    [credentials3633 (:credentials m3632) args3634 (:args m3632)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3635
      (com.palletops.awaze.common/aws-client :rds credentials3633)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3635
       modifyDBSubnetGroup
       (modify-dbsubnet-group-request
        (clojure.core/nth args3634 0)))))))
  (clojure.core/defn
   modify-dbsubnet-group-map
   {:arglists
    '[[credentials
       {:keys
        [subnet-ids
         request-metric-collector
         dbsubnet-group-name
         dbsubnet-group-description]}]],
    :doc "Generate map for modifyDBSubnetGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-dbsubnet-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-dbsubnet-group
   {:arglists
    '[[credentials
       {:keys
        [subnet-ids
         request-metric-collector
         dbsubnet-group-name
         dbsubnet-group-description]}]],
    :doc "Call modifyDBSubnetGroup"}
   [credentials3637 & args3638]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3639
     (com.palletops.awaze.common/aws-client :rds credentials3637)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3639
      modifyDBSubnetGroup
      (modify-dbsubnet-group-request
       (clojure.core/nth args3638 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dblog-files
   [m3640]
   (clojure.core/let
    [credentials3641 (:credentials m3640) args3642 (:args m3640)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3643
      (com.palletops.awaze.common/aws-client :rds credentials3641)]
     (clojure.core/case
      (clojure.core/count args3642)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3643
        describeDBLogFiles))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3643
        describeDBLogFiles
        (describe-dblog-files-request
         (clojure.core/nth args3642 0))))))))
  (clojure.core/defn
   describe-dblog-files-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [file-last-written
         marker
         file-size
         max-records
         dbinstance-identifier
         filename-contains
         request-metric-collector]}]],
    :doc "Generate map for describeDBLogFiles, describeDBLogFiles"}
   ([credentials__577__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dblog-files,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dblog-files,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-dblog-files
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [file-last-written
         marker
         file-size
         max-records
         dbinstance-identifier
         filename-contains
         request-metric-collector]}]],
    :doc "Call describeDBLogFiles, describeDBLogFiles"}
   [credentials3645 & args3646]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3647
     (com.palletops.awaze.common/aws-client :rds credentials3645)]
    (clojure.core/case
     (clojure.core/count args3646)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3647
       describeDBLogFiles))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3647
       describeDBLogFiles
       (describe-dblog-files-request
        (clojure.core/nth args3646 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :promote-read-replica
   [m3648]
   (clojure.core/let
    [credentials3649 (:credentials m3648) args3650 (:args m3648)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3651
      (com.palletops.awaze.common/aws-client :rds credentials3649)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3651
       promoteReadReplica
       (promote-read-replica-request
        (clojure.core/nth args3650 0)))))))
  (clojure.core/defn
   promote-read-replica-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         preferred-backup-window
         backup-retention-period
         dbinstance-identifier]}]],
    :doc "Generate map for promoteReadReplica"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :promote-read-replica,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   promote-read-replica
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         preferred-backup-window
         backup-retention-period
         dbinstance-identifier]}]],
    :doc "Call promoteReadReplica"}
   [credentials3653 & args3654]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3655
     (com.palletops.awaze.common/aws-client :rds credentials3653)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3655
      promoteReadReplica
      (promote-read-replica-request (clojure.core/nth args3654 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbsubnet-group
   [m3656]
   (clojure.core/let
    [credentials3657 (:credentials m3656) args3658 (:args m3656)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3659
      (com.palletops.awaze.common/aws-client :rds credentials3657)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3659
       deleteDBSubnetGroup
       (delete-dbsubnet-group-request
        (clojure.core/nth args3658 0)))))))
  (clojure.core/defn
   delete-dbsubnet-group-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector dbsubnet-group-name]}]],
    :doc "Generate map for deleteDBSubnetGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbsubnet-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-dbsubnet-group
   {:arglists
    '[[credentials
       {:keys [request-metric-collector dbsubnet-group-name]}]],
    :doc "Call deleteDBSubnetGroup"}
   [credentials3661 & args3662]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3663
     (com.palletops.awaze.common/aws-client :rds credentials3661)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3663
      deleteDBSubnetGroup
      (delete-dbsubnet-group-request
       (clojure.core/nth args3662 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsnapshots
   [m3664]
   (clojure.core/let
    [credentials3665 (:credentials m3664) args3666 (:args m3664)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3667
      (com.palletops.awaze.common/aws-client :rds credentials3665)]
     (clojure.core/case
      (clojure.core/count args3666)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3667
        describeDBSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3667
        describeDBSnapshots
        (describe-dbsnapshots-request
         (clojure.core/nth args3666 0))))))))
  (clojure.core/defn
   describe-dbsnapshots-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [snapshot-type
         request-metric-collector
         max-records
         marker
         dbsnapshot-identifier
         dbinstance-identifier]}]],
    :doc "Generate map for describeDBSnapshots, describeDBSnapshots"}
   ([credentials__577__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbsnapshots,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbsnapshots,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-dbsnapshots
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [snapshot-type
         request-metric-collector
         max-records
         marker
         dbsnapshot-identifier
         dbinstance-identifier]}]],
    :doc "Call describeDBSnapshots, describeDBSnapshots"}
   [credentials3669 & args3670]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3671
     (com.palletops.awaze.common/aws-client :rds credentials3669)]
    (clojure.core/case
     (clojure.core/count args3670)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3671
       describeDBSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3671
       describeDBSnapshots
       (describe-dbsnapshots-request
        (clojure.core/nth args3670 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :add-source-identifier-to-subscription
   [m3672]
   (clojure.core/let
    [credentials3673 (:credentials m3672) args3674 (:args m3672)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3675
      (com.palletops.awaze.common/aws-client :rds credentials3673)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3675
       addSourceIdentifierToSubscription
       (add-source-identifier-to-subscription-request
        (clojure.core/nth args3674 0)))))))
  (clojure.core/defn
   add-source-identifier-to-subscription-map
   {:arglists
    '[[credentials
       {:keys
        [subscription-name
         source-identifier
         request-metric-collector]}]],
    :doc "Generate map for addSourceIdentifierToSubscription"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :add-source-identifier-to-subscription,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   add-source-identifier-to-subscription
   {:arglists
    '[[credentials
       {:keys
        [subscription-name
         source-identifier
         request-metric-collector]}]],
    :doc "Call addSourceIdentifierToSubscription"}
   [credentials3677 & args3678]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3679
     (com.palletops.awaze.common/aws-client :rds credentials3677)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3679
      addSourceIdentifierToSubscription
      (add-source-identifier-to-subscription-request
       (clojure.core/nth args3678 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :remove-tags-from-resource
   [m3680]
   (clojure.core/let
    [credentials3681 (:credentials m3680) args3682 (:args m3680)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3683
      (com.palletops.awaze.common/aws-client :rds credentials3681)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3683
       removeTagsFromResource
       (remove-tags-from-resource-request
        (clojure.core/nth args3682 0)))))))
  (clojure.core/defn
   remove-tags-from-resource-map
   {:arglists
    '[[credentials
       {:keys [tag-keys resource-name request-metric-collector]}]],
    :doc "Generate map for removeTagsFromResource"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :remove-tags-from-resource,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   remove-tags-from-resource
   {:arglists
    '[[credentials
       {:keys [tag-keys resource-name request-metric-collector]}]],
    :doc "Call removeTagsFromResource"}
   [credentials3685 & args3686]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3687
     (com.palletops.awaze.common/aws-client :rds credentials3685)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3687
      removeTagsFromResource
      (remove-tags-from-resource-request
       (clojure.core/nth args3686 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbinstance
   [m3688]
   (clojure.core/let
    [credentials3689 (:credentials m3688) args3690 (:args m3688)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3691
      (com.palletops.awaze.common/aws-client :rds credentials3689)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3691
       modifyDBInstance
       (modify-dbinstance-request (clojure.core/nth args3690 0)))))))
  (clojure.core/defn
   modify-dbinstance-map
   {:arglists
    '[[credentials
       {:keys
        [iops
         request-metric-collector
         dbsecurity-groups
         backup-retention-period
         preferred-maintenance-window
         new-dbinstance-identifier
         allow-major-version-upgrade
         preferred-backup-window
         dbinstance-class
         master-user-password
         vpc-security-group-ids
         dbparameter-group-name
         apply-immediately
         engine-version
         multi-az
         dbinstance-identifier
         allocated-storage
         auto-minor-version-upgrade
         option-group-name]}]],
    :doc "Generate map for modifyDBInstance"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-dbinstance,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-dbinstance
   {:arglists
    '[[credentials
       {:keys
        [iops
         request-metric-collector
         dbsecurity-groups
         backup-retention-period
         preferred-maintenance-window
         new-dbinstance-identifier
         allow-major-version-upgrade
         preferred-backup-window
         dbinstance-class
         master-user-password
         vpc-security-group-ids
         dbparameter-group-name
         apply-immediately
         engine-version
         multi-az
         dbinstance-identifier
         allocated-storage
         auto-minor-version-upgrade
         option-group-name]}]],
    :doc "Call modifyDBInstance"}
   [credentials3693 & args3694]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3695
     (com.palletops.awaze.common/aws-client :rds credentials3693)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3695
      modifyDBInstance
      (modify-dbinstance-request (clojure.core/nth args3694 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbengine-versions
   [m3696]
   (clojure.core/let
    [credentials3697 (:credentials m3696) args3698 (:args m3696)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3699
      (com.palletops.awaze.common/aws-client :rds credentials3697)]
     (clojure.core/case
      (clojure.core/count args3698)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3699
        describeDBEngineVersions
        (describe-dbengine-versions-request
         (clojure.core/nth args3698 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3699
        describeDBEngineVersions))))))
  (clojure.core/defn
   describe-dbengine-versions-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         dbparameter-group-family
         list-supported-character-sets
         engine
         max-records
         marker
         default-only
         engine-version]}]
      [credentials]],
    :doc
    "Generate map for describeDBEngineVersions, describeDBEngineVersions"}
   ([credentials__577__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbengine-versions,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbengine-versions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-dbengine-versions
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         dbparameter-group-family
         list-supported-character-sets
         engine
         max-records
         marker
         default-only
         engine-version]}]
      [credentials]],
    :doc "Call describeDBEngineVersions, describeDBEngineVersions"}
   [credentials3701 & args3702]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3703
     (com.palletops.awaze.common/aws-client :rds credentials3701)]
    (clojure.core/case
     (clojure.core/count args3702)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3703
       describeDBEngineVersions
       (describe-dbengine-versions-request
        (clojure.core/nth args3702 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3703
       describeDBEngineVersions))))))
 (do
  (clojure.core/defmethod
   rds
   :reboot-dbinstance
   [m3704]
   (clojure.core/let
    [credentials3705 (:credentials m3704) args3706 (:args m3704)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3707
      (com.palletops.awaze.common/aws-client :rds credentials3705)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3707
       rebootDBInstance
       (reboot-dbinstance-request (clojure.core/nth args3706 0)))))))
  (clojure.core/defn
   reboot-dbinstance-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         force-failover
         dbinstance-identifier]}]],
    :doc "Generate map for rebootDBInstance"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :reboot-dbinstance,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   reboot-dbinstance
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         force-failover
         dbinstance-identifier]}]],
    :doc "Call rebootDBInstance"}
   [credentials3709 & args3710]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3711
     (com.palletops.awaze.common/aws-client :rds credentials3709)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3711
      rebootDBInstance
      (reboot-dbinstance-request (clojure.core/nth args3710 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-option-group-options
   [m3712]
   (clojure.core/let
    [credentials3713 (:credentials m3712) args3714 (:args m3712)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3715
      (com.palletops.awaze.common/aws-client :rds credentials3713)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3715
       describeOptionGroupOptions
       (describe-option-group-options-request
        (clojure.core/nth args3714 0)))))))
  (clojure.core/defn
   describe-option-group-options-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         major-engine-version
         engine-name]}]],
    :doc "Generate map for describeOptionGroupOptions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-option-group-options,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-option-group-options
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         major-engine-version
         engine-name]}]],
    :doc "Call describeOptionGroupOptions"}
   [credentials3717 & args3718]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3719
     (com.palletops.awaze.common/aws-client :rds credentials3717)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3719
      describeOptionGroupOptions
      (describe-option-group-options-request
       (clojure.core/nth args3718 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbinstance
   [m3720]
   (clojure.core/let
    [credentials3721 (:credentials m3720) args3722 (:args m3720)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3723
      (com.palletops.awaze.common/aws-client :rds credentials3721)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3723
       createDBInstance
       (create-dbinstance-request (clojure.core/nth args3722 0)))))))
  (clojure.core/defn
   create-dbinstance-map
   {:arglists
    '[[credentials
       {:keys
        [publicly-accessible
         iops
         request-metric-collector
         dbsecurity-groups
         engine
         backup-retention-period
         availability-zone
         preferred-maintenance-window
         master-username
         dbname
         preferred-backup-window
         dbinstance-class
         master-user-password
         vpc-security-group-ids
         port
         dbparameter-group-name
         character-set-name
         license-model
         dbsubnet-group-name
         engine-version
         multi-az
         dbinstance-identifier
         allocated-storage
         auto-minor-version-upgrade
         option-group-name]}]],
    :doc "Generate map for createDBInstance"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbinstance,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-dbinstance
   {:arglists
    '[[credentials
       {:keys
        [publicly-accessible
         iops
         request-metric-collector
         dbsecurity-groups
         engine
         backup-retention-period
         availability-zone
         preferred-maintenance-window
         master-username
         dbname
         preferred-backup-window
         dbinstance-class
         master-user-password
         vpc-security-group-ids
         port
         dbparameter-group-name
         character-set-name
         license-model
         dbsubnet-group-name
         engine-version
         multi-az
         dbinstance-identifier
         allocated-storage
         auto-minor-version-upgrade
         option-group-name]}]],
    :doc "Call createDBInstance"}
   [credentials3725 & args3726]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3727
     (com.palletops.awaze.common/aws-client :rds credentials3725)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3727
      createDBInstance
      (create-dbinstance-request (clojure.core/nth args3726 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsubnet-groups
   [m3728]
   (clojure.core/let
    [credentials3729 (:credentials m3728) args3730 (:args m3728)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3731
      (com.palletops.awaze.common/aws-client :rds credentials3729)]
     (clojure.core/case
      (clojure.core/count args3730)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3731
        describeDBSubnetGroups
        (describe-dbsubnet-groups-request
         (clojure.core/nth args3730 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3731
        describeDBSubnetGroups))))))
  (clojure.core/defn
   describe-dbsubnet-groups-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         dbsubnet-group-name]}]
      [credentials]],
    :doc
    "Generate map for describeDBSubnetGroups, describeDBSubnetGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbsubnet-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbsubnet-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-dbsubnet-groups
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         dbsubnet-group-name]}]
      [credentials]],
    :doc "Call describeDBSubnetGroups, describeDBSubnetGroups"}
   [credentials3733 & args3734]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3735
     (com.palletops.awaze.common/aws-client :rds credentials3733)]
    (clojure.core/case
     (clojure.core/count args3734)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3735
       describeDBSubnetGroups
       (describe-dbsubnet-groups-request
        (clojure.core/nth args3734 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3735
       describeDBSubnetGroups))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-event-subscription
   [m3736]
   (clojure.core/let
    [credentials3737 (:credentials m3736) args3738 (:args m3736)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3739
      (com.palletops.awaze.common/aws-client :rds credentials3737)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3739
       deleteEventSubscription
       (delete-event-subscription-request
        (clojure.core/nth args3738 0)))))))
  (clojure.core/defn
   delete-event-subscription-map
   {:arglists
    '[[credentials
       {:keys [subscription-name request-metric-collector]}]],
    :doc "Generate map for deleteEventSubscription"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-event-subscription,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-event-subscription
   {:arglists
    '[[credentials
       {:keys [subscription-name request-metric-collector]}]],
    :doc "Call deleteEventSubscription"}
   [credentials3741 & args3742]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3743
     (com.palletops.awaze.common/aws-client :rds credentials3741)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3743
      deleteEventSubscription
      (delete-event-subscription-request
       (clojure.core/nth args3742 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbparameter-groups
   [m3744]
   (clojure.core/let
    [credentials3745 (:credentials m3744) args3746 (:args m3744)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3747
      (com.palletops.awaze.common/aws-client :rds credentials3745)]
     (clojure.core/case
      (clojure.core/count args3746)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3747
        describeDBParameterGroups
        (describe-dbparameter-groups-request
         (clojure.core/nth args3746 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3747
        describeDBParameterGroups))))))
  (clojure.core/defn
   describe-dbparameter-groups-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         dbparameter-group-name]}]
      [credentials]],
    :doc
    "Generate map for describeDBParameterGroups, describeDBParameterGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :rds,
     :fn :describe-dbparameter-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-dbparameter-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-dbparameter-groups
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         dbparameter-group-name]}]
      [credentials]],
    :doc "Call describeDBParameterGroups, describeDBParameterGroups"}
   [credentials3749 & args3750]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3751
     (com.palletops.awaze.common/aws-client :rds credentials3749)]
    (clojure.core/case
     (clojure.core/count args3750)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3751
       describeDBParameterGroups
       (describe-dbparameter-groups-request
        (clojure.core/nth args3750 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3751
       describeDBParameterGroups))))))
 (do
  (clojure.core/defmethod
   rds
   :reset-dbparameter-group
   [m3752]
   (clojure.core/let
    [credentials3753 (:credentials m3752) args3754 (:args m3752)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3755
      (com.palletops.awaze.common/aws-client :rds credentials3753)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3755
       resetDBParameterGroup
       (reset-dbparameter-group-request
        (clojure.core/nth args3754 0)))))))
  (clojure.core/defn
   reset-dbparameter-group-map
   {:arglists
    '[[credentials
       {:keys
        [reset-all-parameters
         request-metric-collector
         parameters
         dbparameter-group-name]}]],
    :doc "Generate map for resetDBParameterGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :reset-dbparameter-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   reset-dbparameter-group
   {:arglists
    '[[credentials
       {:keys
        [reset-all-parameters
         request-metric-collector
         parameters
         dbparameter-group-name]}]],
    :doc "Call resetDBParameterGroup"}
   [credentials3757 & args3758]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3759
     (com.palletops.awaze.common/aws-client :rds credentials3757)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3759
      resetDBParameterGroup
      (reset-dbparameter-group-request
       (clojure.core/nth args3758 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :restore-dbinstance-to-point-in-time
   [m3760]
   (clojure.core/let
    [credentials3761 (:credentials m3760) args3762 (:args m3760)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3763
      (com.palletops.awaze.common/aws-client :rds credentials3761)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3763
       restoreDBInstanceToPointInTime
       (restore-dbinstance-to-point-in-time-request
        (clojure.core/nth args3762 0)))))))
  (clojure.core/defn
   restore-dbinstance-to-point-in-time-map
   {:arglists
    '[[credentials
       {:keys
        [restore-time
         publicly-accessible
         iops
         request-metric-collector
         engine
         availability-zone
         dbname
         target-dbinstance-identifier
         dbinstance-class
         port
         license-model
         dbsubnet-group-name
         multi-az
         use-latest-restorable-time
         source-dbinstance-identifier
         auto-minor-version-upgrade
         option-group-name]}]],
    :doc "Generate map for restoreDBInstanceToPointInTime"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :restore-dbinstance-to-point-in-time,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   restore-dbinstance-to-point-in-time
   {:arglists
    '[[credentials
       {:keys
        [restore-time
         publicly-accessible
         iops
         request-metric-collector
         engine
         availability-zone
         dbname
         target-dbinstance-identifier
         dbinstance-class
         port
         license-model
         dbsubnet-group-name
         multi-az
         use-latest-restorable-time
         source-dbinstance-identifier
         auto-minor-version-upgrade
         option-group-name]}]],
    :doc "Call restoreDBInstanceToPointInTime"}
   [credentials3765 & args3766]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3767
     (com.palletops.awaze.common/aws-client :rds credentials3765)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3767
      restoreDBInstanceToPointInTime
      (restore-dbinstance-to-point-in-time-request
       (clojure.core/nth args3766 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbparameter-group
   [m3768]
   (clojure.core/let
    [credentials3769 (:credentials m3768) args3770 (:args m3768)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3771
      (com.palletops.awaze.common/aws-client :rds credentials3769)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3771
       modifyDBParameterGroup
       (modify-dbparameter-group-request
        (clojure.core/nth args3770 0)))))))
  (clojure.core/defn
   modify-dbparameter-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         parameters
         dbparameter-group-name]}]],
    :doc "Generate map for modifyDBParameterGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :modify-dbparameter-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-dbparameter-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         parameters
         dbparameter-group-name]}]],
    :doc "Call modifyDBParameterGroup"}
   [credentials3773 & args3774]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3775
     (com.palletops.awaze.common/aws-client :rds credentials3773)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3775
      modifyDBParameterGroup
      (modify-dbparameter-group-request
       (clojure.core/nth args3774 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbinstance
   [m3776]
   (clojure.core/let
    [credentials3777 (:credentials m3776) args3778 (:args m3776)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3779
      (com.palletops.awaze.common/aws-client :rds credentials3777)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3779
       deleteDBInstance
       (delete-dbinstance-request (clojure.core/nth args3778 0)))))))
  (clojure.core/defn
   delete-dbinstance-map
   {:arglists
    '[[credentials
       {:keys
        [skip-final-snapshot
         request-metric-collector
         final-dbsnapshot-identifier
         dbinstance-identifier]}]],
    :doc "Generate map for deleteDBInstance"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbinstance,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-dbinstance
   {:arglists
    '[[credentials
       {:keys
        [skip-final-snapshot
         request-metric-collector
         final-dbsnapshot-identifier
         dbinstance-identifier]}]],
    :doc "Call deleteDBInstance"}
   [credentials3781 & args3782]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3783
     (com.palletops.awaze.common/aws-client :rds credentials3781)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3783
      deleteDBInstance
      (delete-dbinstance-request (clojure.core/nth args3782 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-event-categories
   [m3784]
   (clojure.core/let
    [credentials3785 (:credentials m3784) args3786 (:args m3784)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3787
      (com.palletops.awaze.common/aws-client :rds credentials3785)]
     (clojure.core/case
      (clojure.core/count args3786)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3787
        describeEventCategories
        (describe-event-categories-request
         (clojure.core/nth args3786 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.rds.AmazonRDSClient client3787
        describeEventCategories))))))
  (clojure.core/defn
   describe-event-categories-map
   {:arglists
    '[[credentials {:keys [source-type request-metric-collector]}]
      [credentials]],
    :doc
    "Generate map for describeEventCategories, describeEventCategories"}
   ([credentials__577__auto__]
    {:args [],
     :client :rds,
     :fn :describe-event-categories,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :describe-event-categories,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-event-categories
   {:arglists
    '[[credentials {:keys [source-type request-metric-collector]}]
      [credentials]],
    :doc "Call describeEventCategories, describeEventCategories"}
   [credentials3789 & args3790]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3791
     (com.palletops.awaze.common/aws-client :rds credentials3789)]
    (clojure.core/case
     (clojure.core/count args3790)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3791
       describeEventCategories
       (describe-event-categories-request
        (clojure.core/nth args3790 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3791
       describeEventCategories))))))
 (do
  (clojure.core/defmethod
   rds
   :authorize-dbsecurity-group-ingress
   [m3792]
   (clojure.core/let
    [credentials3793 (:credentials m3792) args3794 (:args m3792)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3795
      (com.palletops.awaze.common/aws-client :rds credentials3793)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3795
       authorizeDBSecurityGroupIngress
       (authorize-dbsecurity-group-ingress-request
        (clojure.core/nth args3794 0)))))))
  (clojure.core/defn
   authorize-dbsecurity-group-ingress-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         ec2security-group-owner-id
         ec2security-group-name
         ec2security-group-id
         dbsecurity-group-name
         cidrip]}]],
    :doc "Generate map for authorizeDBSecurityGroupIngress"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :authorize-dbsecurity-group-ingress,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   authorize-dbsecurity-group-ingress
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         ec2security-group-owner-id
         ec2security-group-name
         ec2security-group-id
         dbsecurity-group-name
         cidrip]}]],
    :doc "Call authorizeDBSecurityGroupIngress"}
   [credentials3797 & args3798]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3799
     (com.palletops.awaze.common/aws-client :rds credentials3797)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3799
      authorizeDBSecurityGroupIngress
      (authorize-dbsecurity-group-ingress-request
       (clojure.core/nth args3798 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :copy-dbsnapshot
   [m3800]
   (clojure.core/let
    [credentials3801 (:credentials m3800) args3802 (:args m3800)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3803
      (com.palletops.awaze.common/aws-client :rds credentials3801)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3803
       copyDBSnapshot
       (copy-dbsnapshot-request (clojure.core/nth args3802 0)))))))
  (clojure.core/defn
   copy-dbsnapshot-map
   {:arglists
    '[[credentials
       {:keys
        [target-dbsnapshot-identifier
         source-dbsnapshot-identifier
         request-metric-collector]}]],
    :doc "Generate map for copyDBSnapshot"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :copy-dbsnapshot,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   copy-dbsnapshot
   {:arglists
    '[[credentials
       {:keys
        [target-dbsnapshot-identifier
         source-dbsnapshot-identifier
         request-metric-collector]}]],
    :doc "Call copyDBSnapshot"}
   [credentials3805 & args3806]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3807
     (com.palletops.awaze.common/aws-client :rds credentials3805)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3807
      copyDBSnapshot
      (copy-dbsnapshot-request (clojure.core/nth args3806 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbsnapshot
   [m3808]
   (clojure.core/let
    [credentials3809 (:credentials m3808) args3810 (:args m3808)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3811
      (com.palletops.awaze.common/aws-client :rds credentials3809)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3811
       deleteDBSnapshot
       (delete-dbsnapshot-request (clojure.core/nth args3810 0)))))))
  (clojure.core/defn
   delete-dbsnapshot-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector dbsnapshot-identifier]}]],
    :doc "Generate map for deleteDBSnapshot"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :delete-dbsnapshot,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-dbsnapshot
   {:arglists
    '[[credentials
       {:keys [request-metric-collector dbsnapshot-identifier]}]],
    :doc "Call deleteDBSnapshot"}
   [credentials3813 & args3814]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3815
     (com.palletops.awaze.common/aws-client :rds credentials3813)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3815
      deleteDBSnapshot
      (delete-dbsnapshot-request (clojure.core/nth args3814 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbsubnet-group
   [m3816]
   (clojure.core/let
    [credentials3817 (:credentials m3816) args3818 (:args m3816)]
    (clojure.core/let
     [^com.amazonaws.services.rds.AmazonRDSClient client3819
      (com.palletops.awaze.common/aws-client :rds credentials3817)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.rds.AmazonRDSClient client3819
       createDBSubnetGroup
       (create-dbsubnet-group-request
        (clojure.core/nth args3818 0)))))))
  (clojure.core/defn
   create-dbsubnet-group-map
   {:arglists
    '[[credentials
       {:keys
        [subnet-ids
         request-metric-collector
         dbsubnet-group-name
         dbsubnet-group-description]}]],
    :doc "Generate map for createDBSubnetGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :rds,
     :fn :create-dbsubnet-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-dbsubnet-group
   {:arglists
    '[[credentials
       {:keys
        [subnet-ids
         request-metric-collector
         dbsubnet-group-name
         dbsubnet-group-description]}]],
    :doc "Call createDBSubnetGroup"}
   [credentials3821 & args3822]
   (clojure.core/let
    [^com.amazonaws.services.rds.AmazonRDSClient client3823
     (com.palletops.awaze.common/aws-client :rds credentials3821)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.rds.AmazonRDSClient client3823
      createDBSubnetGroup
      (create-dbsubnet-group-request
       (clojure.core/nth args3822 0))))))))
