(ns com.palletops.awaze.iam (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :iam
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.StatusType status-type
  [m6191]
  (java.lang.Enum/valueOf
   com.amazonaws.services.identitymanagement.model.StatusType
   (clojure.core/name m6191)))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.AssignmentStatusType assignment-status-type
  [m6194]
  (java.lang.Enum/valueOf
   com.amazonaws.services.identitymanagement.model.AssignmentStatusType
   (clojure.core/name m6194)))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetRolePolicyRequest get-role-policy-request
  [m6197]
  (clojure.core/let
   [bean6196
    (new
     com.amazonaws.services.identitymanagement.model.GetRolePolicyRequest)]
   (clojure.core/when-let
    [v6198 (:policy-name m6197)]
    (. bean6196 setPolicyName (clojure.core/str v6198)))
   (clojure.core/when-let
    [v6198 (:role-name m6197)]
    (. bean6196 setRoleName (clojure.core/str v6198)))
   bean6196))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ChangePasswordRequest change-password-request
  [m6200]
  (clojure.core/let
   [bean6199
    (new
     com.amazonaws.services.identitymanagement.model.ChangePasswordRequest)]
   (clojure.core/when-let
    [v6201 (:old-password m6200)]
    (. bean6199 setOldPassword (clojure.core/str v6201)))
   (clojure.core/when-let
    [v6201 (:new-password m6200)]
    (. bean6199 setNewPassword (clojure.core/str v6201)))
   bean6199))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeactivateMFADeviceRequest deactivate-mfadevice-request
  [m6203]
  (clojure.core/let
   [bean6202
    (new
     com.amazonaws.services.identitymanagement.model.DeactivateMFADeviceRequest)]
   (clojure.core/when-let
    [v6204 (:serial-number m6203)]
    (. bean6202 setSerialNumber (clojure.core/str v6204)))
   (clojure.core/when-let
    [v6204 (:user-name m6203)]
    (. bean6202 setUserName (clojure.core/str v6204)))
   bean6202))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ResyncMFADeviceRequest resync-mfadevice-request
  [m6206]
  (clojure.core/let
   [bean6205
    (new
     com.amazonaws.services.identitymanagement.model.ResyncMFADeviceRequest)]
   (clojure.core/when-let
    [v6207 (:serial-number m6206)]
    (. bean6205 setSerialNumber (clojure.core/str v6207)))
   (clojure.core/when-let
    [v6207 (:user-name m6206)]
    (. bean6205 setUserName (clojure.core/str v6207)))
   (clojure.core/when-let
    [v6207 (:authentication-code1 m6206)]
    (. bean6205 setAuthenticationCode1 (clojure.core/str v6207)))
   (clojure.core/when-let
    [v6207 (:authentication-code2 m6206)]
    (. bean6205 setAuthenticationCode2 (clojure.core/str v6207)))
   bean6205))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateLoginProfileRequest update-login-profile-request
  [m6209]
  (clojure.core/let
   [bean6208
    (new
     com.amazonaws.services.identitymanagement.model.UpdateLoginProfileRequest)]
   (clojure.core/when-let
    [v6210 (:user-name m6209)]
    (. bean6208 setUserName (clojure.core/str v6210)))
   (clojure.core/when-let
    [v6210 (:password m6209)]
    (. bean6208 setPassword (clojure.core/str v6210)))
   bean6208))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.PutRolePolicyRequest put-role-policy-request
  [m6212]
  (clojure.core/let
   [bean6211
    (new
     com.amazonaws.services.identitymanagement.model.PutRolePolicyRequest)]
   (clojure.core/when-let
    [v6213 (:policy-name m6212)]
    (. bean6211 setPolicyName (clojure.core/str v6213)))
   (clojure.core/when-let
    [v6213 (:policy-document m6212)]
    (. bean6211 setPolicyDocument (clojure.core/str v6213)))
   (clojure.core/when-let
    [v6213 (:role-name m6212)]
    (. bean6211 setRoleName (clojure.core/str v6213)))
   bean6211))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteSigningCertificateRequest delete-signing-certificate-request
  [m6215]
  (clojure.core/let
   [bean6214
    (new
     com.amazonaws.services.identitymanagement.model.DeleteSigningCertificateRequest)]
   (clojure.core/when-let
    [v6216 (:user-name m6215)]
    (. bean6214 setUserName (clojure.core/str v6216)))
   (clojure.core/when-let
    [v6216 (:certificate-id m6215)]
    (. bean6214 setCertificateId (clojure.core/str v6216)))
   bean6214))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteUserRequest delete-user-request
  [m6218]
  (clojure.core/let
   [bean6217
    (new
     com.amazonaws.services.identitymanagement.model.DeleteUserRequest)]
   (clojure.core/when-let
    [v6219 (:user-name m6218)]
    (. bean6217 setUserName (clojure.core/str v6219)))
   bean6217))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.AddUserToGroupRequest add-user-to-group-request
  [m6221]
  (clojure.core/let
   [bean6220
    (new
     com.amazonaws.services.identitymanagement.model.AddUserToGroupRequest)]
   (clojure.core/when-let
    [v6222 (:group-name m6221)]
    (. bean6220 setGroupName (clojure.core/str v6222)))
   (clojure.core/when-let
    [v6222 (:user-name m6221)]
    (. bean6220 setUserName (clojure.core/str v6222)))
   bean6220))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListAccountAliasesRequest list-account-aliases-request
  [m6224]
  (clojure.core/let
   [bean6223
    (new
     com.amazonaws.services.identitymanagement.model.ListAccountAliasesRequest)]
   (clojure.core/when-let
    [v6225 (:max-items m6224)]
    (. bean6223 setMaxItems (clojure.core/int v6225)))
   (clojure.core/when-let
    [v6225 (:marker m6224)]
    (. bean6223 setMarker (clojure.core/str v6225)))
   bean6223))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupRequest remove-user-from-group-request
  [m6227]
  (clojure.core/let
   [bean6226
    (new
     com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupRequest)]
   (clojure.core/when-let
    [v6228 (:group-name m6227)]
    (. bean6226 setGroupName (clojure.core/str v6228)))
   (clojure.core/when-let
    [v6228 (:user-name m6227)]
    (. bean6226 setUserName (clojure.core/str v6228)))
   bean6226))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateGroupRequest update-group-request
  [m6230]
  (clojure.core/let
   [bean6229
    (new
     com.amazonaws.services.identitymanagement.model.UpdateGroupRequest)]
   (clojure.core/when-let
    [v6231 (:group-name m6230)]
    (. bean6229 setGroupName (clojure.core/str v6231)))
   (clojure.core/when-let
    [v6231 (:new-path m6230)]
    (. bean6229 setNewPath (clojure.core/str v6231)))
   (clojure.core/when-let
    [v6231 (:new-group-name m6230)]
    (. bean6229 setNewGroupName (clojure.core/str v6231)))
   bean6229))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateServerCertificateRequest update-server-certificate-request
  [m6233]
  (clojure.core/let
   [bean6232
    (new
     com.amazonaws.services.identitymanagement.model.UpdateServerCertificateRequest)]
   (clojure.core/when-let
    [v6234 (:server-certificate-name m6233)]
    (. bean6232 setServerCertificateName (clojure.core/str v6234)))
   (clojure.core/when-let
    [v6234 (:new-path m6233)]
    (. bean6232 setNewPath (clojure.core/str v6234)))
   (clojure.core/when-let
    [v6234 (:new-server-certificate-name m6233)]
    (. bean6232 setNewServerCertificateName (clojure.core/str v6234)))
   bean6232))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteRolePolicyRequest delete-role-policy-request
  [m6236]
  (clojure.core/let
   [bean6235
    (new
     com.amazonaws.services.identitymanagement.model.DeleteRolePolicyRequest)]
   (clojure.core/when-let
    [v6237 (:policy-name m6236)]
    (. bean6235 setPolicyName (clojure.core/str v6237)))
   (clojure.core/when-let
    [v6237 (:role-name m6236)]
    (. bean6235 setRoleName (clojure.core/str v6237)))
   bean6235))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateAccessKeyRequest update-access-key-request
  [m6239]
  (clojure.core/let
   [bean6238
    (new
     com.amazonaws.services.identitymanagement.model.UpdateAccessKeyRequest)]
   (clojure.core/when-let
    [v6240 (:user-name m6239)]
    (. bean6238 setUserName (clojure.core/str v6240)))
   (clojure.core/when-let
    [v6240 (:access-key-id m6239)]
    (. bean6238 setAccessKeyId (clojure.core/str v6240)))
   (clojure.core/when-let
    [v6240 (:status m6239)]
    (. bean6238 setStatus (clojure.core/str v6240)))
   (clojure.core/when-let
    [v6240 (:status m6239)]
    (. bean6238 setStatus (status-type v6240)))
   bean6238))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteGroupRequest delete-group-request
  [m6242]
  (clojure.core/let
   [bean6241
    (new
     com.amazonaws.services.identitymanagement.model.DeleteGroupRequest)]
   (clojure.core/when-let
    [v6243 (:group-name m6242)]
    (. bean6241 setGroupName (clojure.core/str v6243)))
   bean6241))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListGroupsForUserRequest list-groups-for-user-request
  [m6245]
  (clojure.core/let
   [bean6244
    (new
     com.amazonaws.services.identitymanagement.model.ListGroupsForUserRequest)]
   (clojure.core/when-let
    [v6246 (:max-items m6245)]
    (. bean6244 setMaxItems (clojure.core/int v6246)))
   (clojure.core/when-let
    [v6246 (:user-name m6245)]
    (. bean6244 setUserName (clojure.core/str v6246)))
   (clojure.core/when-let
    [v6246 (:marker m6245)]
    (. bean6244 setMarker (clojure.core/str v6246)))
   bean6244))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest put-user-policy-request
  [m6248]
  (clojure.core/let
   [bean6247
    (new
     com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest)]
   (clojure.core/when-let
    [v6249 (:policy-name m6248)]
    (. bean6247 setPolicyName (clojure.core/str v6249)))
   (clojure.core/when-let
    [v6249 (:user-name m6248)]
    (. bean6247 setUserName (clojure.core/str v6249)))
   (clojure.core/when-let
    [v6249 (:policy-document m6248)]
    (. bean6247 setPolicyDocument (clojure.core/str v6249)))
   bean6247))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetRoleRequest get-role-request
  [m6251]
  (clojure.core/let
   [bean6250
    (new
     com.amazonaws.services.identitymanagement.model.GetRoleRequest)]
   (clojure.core/when-let
    [v6252 (:role-name m6251)]
    (. bean6250 setRoleName (clojure.core/str v6252)))
   bean6250))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetAccountPasswordPolicyRequest get-account-password-policy-request
  [m6254]
  (clojure.core/let
   [bean6253
    (new
     com.amazonaws.services.identitymanagement.model.GetAccountPasswordPolicyRequest)]
   bean6253))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest list-access-keys-request
  [m6257]
  (clojure.core/let
   [bean6256
    (new
     com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest)]
   (clojure.core/when-let
    [v6258 (:max-items m6257)]
    (. bean6256 setMaxItems (clojure.core/int v6258)))
   (clojure.core/when-let
    [v6258 (:user-name m6257)]
    (. bean6256 setUserName (clojure.core/str v6258)))
   (clojure.core/when-let
    [v6258 (:marker m6257)]
    (. bean6256 setMarker (clojure.core/str v6258)))
   bean6256))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteAccountAliasRequest delete-account-alias-request
  [m6260]
  (clojure.core/let
   [bean6259
    (new
     com.amazonaws.services.identitymanagement.model.DeleteAccountAliasRequest)]
   (clojure.core/when-let
    [v6261 (:account-alias m6260)]
    (. bean6259 setAccountAlias (clojure.core/str v6261)))
   bean6259))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetLoginProfileRequest get-login-profile-request
  [m6263]
  (clojure.core/let
   [bean6262
    (new
     com.amazonaws.services.identitymanagement.model.GetLoginProfileRequest)]
   (clojure.core/when-let
    [v6264 (:user-name m6263)]
    (. bean6262 setUserName (clojure.core/str v6264)))
   bean6262))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateLoginProfileRequest create-login-profile-request
  [m6266]
  (clojure.core/let
   [bean6265
    (new
     com.amazonaws.services.identitymanagement.model.CreateLoginProfileRequest)]
   (clojure.core/when-let
    [v6267 (:user-name m6266)]
    (. bean6265 setUserName (clojure.core/str v6267)))
   (clojure.core/when-let
    [v6267 (:password m6266)]
    (. bean6265 setPassword (clojure.core/str v6267)))
   bean6265))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListGroupsRequest list-groups-request
  [m6269]
  (clojure.core/let
   [bean6268
    (new
     com.amazonaws.services.identitymanagement.model.ListGroupsRequest)]
   (clojure.core/when-let
    [v6270 (:max-items m6269)]
    (. bean6268 setMaxItems (clojure.core/int v6270)))
   (clojure.core/when-let
    [v6270 (:path-prefix m6269)]
    (. bean6268 setPathPrefix (clojure.core/str v6270)))
   (clojure.core/when-let
    [v6270 (:marker m6269)]
    (. bean6268 setMarker (clojure.core/str v6270)))
   bean6268))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetAccountSummaryRequest get-account-summary-request
  [m6272]
  (clojure.core/let
   [bean6271
    (new
     com.amazonaws.services.identitymanagement.model.GetAccountSummaryRequest)]
   bean6271))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteAccountPasswordPolicyRequest delete-account-password-policy-request
  [m6275]
  (clojure.core/let
   [bean6274
    (new
     com.amazonaws.services.identitymanagement.model.DeleteAccountPasswordPolicyRequest)]
   bean6274))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest get-instance-profile-request
  [m6278]
  (clojure.core/let
   [bean6277
    (new
     com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest)]
   (clojure.core/when-let
    [v6279 (:instance-profile-name m6278)]
    (. bean6277 setInstanceProfileName (clojure.core/str v6279)))
   bean6277))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetUserRequest get-user-request
  [m6281]
  (clojure.core/let
   [bean6280
    (new
     com.amazonaws.services.identitymanagement.model.GetUserRequest)]
   (clojure.core/when-let
    [v6282 (:user-name m6281)]
    (. bean6280 setUserName (clojure.core/str v6282)))
   bean6280))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteVirtualMFADeviceRequest delete-virtual-mfadevice-request
  [m6284]
  (clojure.core/let
   [bean6283
    (new
     com.amazonaws.services.identitymanagement.model.DeleteVirtualMFADeviceRequest)]
   (clojure.core/when-let
    [v6285 (:serial-number m6284)]
    (. bean6283 setSerialNumber (clojure.core/str v6285)))
   bean6283))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest create-access-key-request
  [m6287]
  (clojure.core/let
   [bean6286
    (new
     com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest)]
   (clojure.core/when-let
    [v6288 (:user-name m6287)]
    (. bean6286 setUserName (clojure.core/str v6288)))
   bean6286))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListInstanceProfilesRequest list-instance-profiles-request
  [m6290]
  (clojure.core/let
   [bean6289
    (new
     com.amazonaws.services.identitymanagement.model.ListInstanceProfilesRequest)]
   (clojure.core/when-let
    [v6291 (:max-items m6290)]
    (. bean6289 setMaxItems (clojure.core/int v6291)))
   (clojure.core/when-let
    [v6291 (:path-prefix m6290)]
    (. bean6289 setPathPrefix (clojure.core/str v6291)))
   (clojure.core/when-let
    [v6291 (:marker m6290)]
    (. bean6289 setMarker (clojure.core/str v6291)))
   bean6289))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.PutGroupPolicyRequest put-group-policy-request
  [m6293]
  (clojure.core/let
   [bean6292
    (new
     com.amazonaws.services.identitymanagement.model.PutGroupPolicyRequest)]
   (clojure.core/when-let
    [v6294 (:group-name m6293)]
    (. bean6292 setGroupName (clojure.core/str v6294)))
   (clojure.core/when-let
    [v6294 (:policy-name m6293)]
    (. bean6292 setPolicyName (clojure.core/str v6294)))
   (clojure.core/when-let
    [v6294 (:policy-document m6293)]
    (. bean6292 setPolicyDocument (clojure.core/str v6294)))
   bean6292))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetServerCertificateRequest get-server-certificate-request
  [m6296]
  (clojure.core/let
   [bean6295
    (new
     com.amazonaws.services.identitymanagement.model.GetServerCertificateRequest)]
   (clojure.core/when-let
    [v6297 (:server-certificate-name m6296)]
    (. bean6295 setServerCertificateName (clojure.core/str v6297)))
   bean6295))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UploadServerCertificateRequest upload-server-certificate-request
  [m6299]
  (clojure.core/let
   [bean6298
    (new
     com.amazonaws.services.identitymanagement.model.UploadServerCertificateRequest)]
   (clojure.core/when-let
    [v6300 (:server-certificate-name m6299)]
    (. bean6298 setServerCertificateName (clojure.core/str v6300)))
   (clojure.core/when-let
    [v6300 (:certificate-body m6299)]
    (. bean6298 setCertificateBody (clojure.core/str v6300)))
   (clojure.core/when-let
    [v6300 (:private-key m6299)]
    (. bean6298 setPrivateKey (clojure.core/str v6300)))
   (clojure.core/when-let
    [v6300 (:certificate-chain m6299)]
    (. bean6298 setCertificateChain (clojure.core/str v6300)))
   (clojure.core/when-let
    [v6300 (:path m6299)]
    (. bean6298 setPath (clojure.core/str v6300)))
   bean6298))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListRolePoliciesRequest list-role-policies-request
  [m6302]
  (clojure.core/let
   [bean6301
    (new
     com.amazonaws.services.identitymanagement.model.ListRolePoliciesRequest)]
   (clojure.core/when-let
    [v6303 (:max-items m6302)]
    (. bean6301 setMaxItems (clojure.core/int v6303)))
   (clojure.core/when-let
    [v6303 (:role-name m6302)]
    (. bean6301 setRoleName (clojure.core/str v6303)))
   (clojure.core/when-let
    [v6303 (:marker m6302)]
    (. bean6301 setMarker (clojure.core/str v6303)))
   bean6301))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest add-role-to-instance-profile-request
  [m6305]
  (clojure.core/let
   [bean6304
    (new
     com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest)]
   (clojure.core/when-let
    [v6306 (:role-name m6305)]
    (. bean6304 setRoleName (clojure.core/str v6306)))
   (clojure.core/when-let
    [v6306 (:instance-profile-name m6305)]
    (. bean6304 setInstanceProfileName (clojure.core/str v6306)))
   bean6304))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest delete-access-key-request
  [m6308]
  (clojure.core/let
   [bean6307
    (new
     com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest)]
   (clojure.core/when-let
    [v6309 (:user-name m6308)]
    (. bean6307 setUserName (clojure.core/str v6309)))
   (clojure.core/when-let
    [v6309 (:access-key-id m6308)]
    (. bean6307 setAccessKeyId (clojure.core/str v6309)))
   bean6307))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteRoleRequest delete-role-request
  [m6311]
  (clojure.core/let
   [bean6310
    (new
     com.amazonaws.services.identitymanagement.model.DeleteRoleRequest)]
   (clojure.core/when-let
    [v6312 (:role-name m6311)]
    (. bean6310 setRoleName (clojure.core/str v6312)))
   bean6310))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceRequest create-virtual-mfadevice-request
  [m6314]
  (clojure.core/let
   [bean6313
    (new
     com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceRequest)]
   (clojure.core/when-let
    [v6315 (:virtual-mfadevice-name m6314)]
    (. bean6313 setVirtualMFADeviceName (clojure.core/str v6315)))
   (clojure.core/when-let
    [v6315 (:path m6314)]
    (. bean6313 setPath (clojure.core/str v6315)))
   bean6313))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListGroupPoliciesRequest list-group-policies-request
  [m6317]
  (clojure.core/let
   [bean6316
    (new
     com.amazonaws.services.identitymanagement.model.ListGroupPoliciesRequest)]
   (clojure.core/when-let
    [v6318 (:group-name m6317)]
    (. bean6316 setGroupName (clojure.core/str v6318)))
   (clojure.core/when-let
    [v6318 (:max-items m6317)]
    (. bean6316 setMaxItems (clojure.core/int v6318)))
   (clojure.core/when-let
    [v6318 (:marker m6317)]
    (. bean6316 setMarker (clojure.core/str v6318)))
   bean6316))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetGroupPolicyRequest get-group-policy-request
  [m6320]
  (clojure.core/let
   [bean6319
    (new
     com.amazonaws.services.identitymanagement.model.GetGroupPolicyRequest)]
   (clojure.core/when-let
    [v6321 (:group-name m6320)]
    (. bean6319 setGroupName (clojure.core/str v6321)))
   (clojure.core/when-let
    [v6321 (:policy-name m6320)]
    (. bean6319 setPolicyName (clojure.core/str v6321)))
   bean6319))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListServerCertificatesRequest list-server-certificates-request
  [m6323]
  (clojure.core/let
   [bean6322
    (new
     com.amazonaws.services.identitymanagement.model.ListServerCertificatesRequest)]
   (clojure.core/when-let
    [v6324 (:max-items m6323)]
    (. bean6322 setMaxItems (clojure.core/int v6324)))
   (clojure.core/when-let
    [v6324 (:path-prefix m6323)]
    (. bean6322 setPathPrefix (clojure.core/str v6324)))
   (clojure.core/when-let
    [v6324 (:marker m6323)]
    (. bean6322 setMarker (clojure.core/str v6324)))
   bean6322))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateAccountPasswordPolicyRequest update-account-password-policy-request
  [m6326]
  (clojure.core/let
   [bean6325
    (new
     com.amazonaws.services.identitymanagement.model.UpdateAccountPasswordPolicyRequest)]
   (clojure.core/when-let
    [v6327 (:minimum-password-length m6326)]
    (. bean6325 setMinimumPasswordLength (clojure.core/int v6327)))
   (clojure.core/when-let
    [v6327 (:require-symbols m6326)]
    (. bean6325 setRequireSymbols (clojure.core/boolean v6327)))
   (clojure.core/when-let
    [v6327 (:require-numbers m6326)]
    (. bean6325 setRequireNumbers (clojure.core/boolean v6327)))
   (clojure.core/when-let
    [v6327 (:require-uppercase-characters m6326)]
    (.
     bean6325
     setRequireUppercaseCharacters
     (clojure.core/boolean v6327)))
   (clojure.core/when-let
    [v6327 (:require-lowercase-characters m6326)]
    (.
     bean6325
     setRequireLowercaseCharacters
     (clojure.core/boolean v6327)))
   (clojure.core/when-let
    [v6327 (:allow-users-to-change-password m6326)]
    (.
     bean6325
     setAllowUsersToChangePassword
     (clojure.core/boolean v6327)))
   bean6325))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateGroupRequest create-group-request
  [m6329]
  (clojure.core/let
   [bean6328
    (new
     com.amazonaws.services.identitymanagement.model.CreateGroupRequest)]
   (clojure.core/when-let
    [v6330 (:group-name m6329)]
    (. bean6328 setGroupName (clojure.core/str v6330)))
   (clojure.core/when-let
    [v6330 (:path m6329)]
    (. bean6328 setPath (clojure.core/str v6330)))
   bean6328))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleRequest list-instance-profiles-for-role-request
  [m6332]
  (clojure.core/let
   [bean6331
    (new
     com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleRequest)]
   (clojure.core/when-let
    [v6333 (:max-items m6332)]
    (. bean6331 setMaxItems (clojure.core/int v6333)))
   (clojure.core/when-let
    [v6333 (:role-name m6332)]
    (. bean6331 setRoleName (clojure.core/str v6333)))
   (clojure.core/when-let
    [v6333 (:marker m6332)]
    (. bean6331 setMarker (clojure.core/str v6333)))
   bean6331))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UploadSigningCertificateRequest upload-signing-certificate-request
  [m6335]
  (clojure.core/let
   [bean6334
    (new
     com.amazonaws.services.identitymanagement.model.UploadSigningCertificateRequest)]
   (clojure.core/when-let
    [v6336 (:user-name m6335)]
    (. bean6334 setUserName (clojure.core/str v6336)))
   (clojure.core/when-let
    [v6336 (:certificate-body m6335)]
    (. bean6334 setCertificateBody (clojure.core/str v6336)))
   bean6334))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteServerCertificateRequest delete-server-certificate-request
  [m6338]
  (clojure.core/let
   [bean6337
    (new
     com.amazonaws.services.identitymanagement.model.DeleteServerCertificateRequest)]
   (clojure.core/when-let
    [v6339 (:server-certificate-name m6338)]
    (. bean6337 setServerCertificateName (clojure.core/str v6339)))
   bean6337))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListVirtualMFADevicesRequest list-virtual-mfadevices-request
  [m6341]
  (clojure.core/let
   [bean6340
    (new
     com.amazonaws.services.identitymanagement.model.ListVirtualMFADevicesRequest)]
   (clojure.core/when-let
    [v6342 (:max-items m6341)]
    (. bean6340 setMaxItems (clojure.core/int v6342)))
   (clojure.core/when-let
    [v6342 (:assignment-status m6341)]
    (. bean6340 setAssignmentStatus (assignment-status-type v6342)))
   (clojure.core/when-let
    [v6342 (:assignment-status m6341)]
    (. bean6340 setAssignmentStatus (clojure.core/str v6342)))
   (clojure.core/when-let
    [v6342 (:marker m6341)]
    (. bean6340 setMarker (clojure.core/str v6342)))
   bean6340))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest remove-role-from-instance-profile-request
  [m6344]
  (clojure.core/let
   [bean6343
    (new
     com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest)]
   (clojure.core/when-let
    [v6345 (:role-name m6344)]
    (. bean6343 setRoleName (clojure.core/str v6345)))
   (clojure.core/when-let
    [v6345 (:instance-profile-name m6344)]
    (. bean6343 setInstanceProfileName (clojure.core/str v6345)))
   bean6343))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListSigningCertificatesRequest list-signing-certificates-request
  [m6347]
  (clojure.core/let
   [bean6346
    (new
     com.amazonaws.services.identitymanagement.model.ListSigningCertificatesRequest)]
   (clojure.core/when-let
    [v6348 (:max-items m6347)]
    (. bean6346 setMaxItems (clojure.core/int v6348)))
   (clojure.core/when-let
    [v6348 (:user-name m6347)]
    (. bean6346 setUserName (clojure.core/str v6348)))
   (clojure.core/when-let
    [v6348 (:marker m6347)]
    (. bean6346 setMarker (clojure.core/str v6348)))
   bean6346))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileRequest delete-instance-profile-request
  [m6350]
  (clojure.core/let
   [bean6349
    (new
     com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileRequest)]
   (clojure.core/when-let
    [v6351 (:instance-profile-name m6350)]
    (. bean6349 setInstanceProfileName (clojure.core/str v6351)))
   bean6349))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListMFADevicesRequest list-mfadevices-request
  [m6353]
  (clojure.core/let
   [bean6352
    (new
     com.amazonaws.services.identitymanagement.model.ListMFADevicesRequest)]
   (clojure.core/when-let
    [v6354 (:max-items m6353)]
    (. bean6352 setMaxItems (clojure.core/int v6354)))
   (clojure.core/when-let
    [v6354 (:user-name m6353)]
    (. bean6352 setUserName (clojure.core/str v6354)))
   (clojure.core/when-let
    [v6354 (:marker m6353)]
    (. bean6352 setMarker (clojure.core/str v6354)))
   bean6352))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest delete-user-policy-request
  [m6356]
  (clojure.core/let
   [bean6355
    (new
     com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest)]
   (clojure.core/when-let
    [v6357 (:policy-name m6356)]
    (. bean6355 setPolicyName (clojure.core/str v6357)))
   (clojure.core/when-let
    [v6357 (:user-name m6356)]
    (. bean6355 setUserName (clojure.core/str v6357)))
   bean6355))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateAccountAliasRequest create-account-alias-request
  [m6359]
  (clojure.core/let
   [bean6358
    (new
     com.amazonaws.services.identitymanagement.model.CreateAccountAliasRequest)]
   (clojure.core/when-let
    [v6360 (:account-alias m6359)]
    (. bean6358 setAccountAlias (clojure.core/str v6360)))
   bean6358))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateSigningCertificateRequest update-signing-certificate-request
  [m6362]
  (clojure.core/let
   [bean6361
    (new
     com.amazonaws.services.identitymanagement.model.UpdateSigningCertificateRequest)]
   (clojure.core/when-let
    [v6363 (:user-name m6362)]
    (. bean6361 setUserName (clojure.core/str v6363)))
   (clojure.core/when-let
    [v6363 (:certificate-id m6362)]
    (. bean6361 setCertificateId (clojure.core/str v6363)))
   (clojure.core/when-let
    [v6363 (:status m6362)]
    (. bean6361 setStatus (clojure.core/str v6363)))
   (clojure.core/when-let
    [v6363 (:status m6362)]
    (. bean6361 setStatus (status-type v6363)))
   bean6361))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateAssumeRolePolicyRequest update-assume-role-policy-request
  [m6365]
  (clojure.core/let
   [bean6364
    (new
     com.amazonaws.services.identitymanagement.model.UpdateAssumeRolePolicyRequest)]
   (clojure.core/when-let
    [v6366 (:policy-document m6365)]
    (. bean6364 setPolicyDocument (clojure.core/str v6366)))
   (clojure.core/when-let
    [v6366 (:role-name m6365)]
    (. bean6364 setRoleName (clojure.core/str v6366)))
   bean6364))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListRolesRequest list-roles-request
  [m6368]
  (clojure.core/let
   [bean6367
    (new
     com.amazonaws.services.identitymanagement.model.ListRolesRequest)]
   (clojure.core/when-let
    [v6369 (:max-items m6368)]
    (. bean6367 setMaxItems (clojure.core/int v6369)))
   (clojure.core/when-let
    [v6369 (:path-prefix m6368)]
    (. bean6367 setPathPrefix (clojure.core/str v6369)))
   (clojure.core/when-let
    [v6369 (:marker m6368)]
    (. bean6367 setMarker (clojure.core/str v6369)))
   bean6367))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest list-user-policies-request
  [m6371]
  (clojure.core/let
   [bean6370
    (new
     com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest)]
   (clojure.core/when-let
    [v6372 (:max-items m6371)]
    (. bean6370 setMaxItems (clojure.core/int v6372)))
   (clojure.core/when-let
    [v6372 (:user-name m6371)]
    (. bean6370 setUserName (clojure.core/str v6372)))
   (clojure.core/when-let
    [v6372 (:marker m6371)]
    (. bean6370 setMarker (clojure.core/str v6372)))
   bean6370))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteLoginProfileRequest delete-login-profile-request
  [m6374]
  (clojure.core/let
   [bean6373
    (new
     com.amazonaws.services.identitymanagement.model.DeleteLoginProfileRequest)]
   (clojure.core/when-let
    [v6375 (:user-name m6374)]
    (. bean6373 setUserName (clojure.core/str v6375)))
   bean6373))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.EnableMFADeviceRequest enable-mfadevice-request
  [m6377]
  (clojure.core/let
   [bean6376
    (new
     com.amazonaws.services.identitymanagement.model.EnableMFADeviceRequest)]
   (clojure.core/when-let
    [v6378 (:serial-number m6377)]
    (. bean6376 setSerialNumber (clojure.core/str v6378)))
   (clojure.core/when-let
    [v6378 (:user-name m6377)]
    (. bean6376 setUserName (clojure.core/str v6378)))
   (clojure.core/when-let
    [v6378 (:authentication-code1 m6377)]
    (. bean6376 setAuthenticationCode1 (clojure.core/str v6378)))
   (clojure.core/when-let
    [v6378 (:authentication-code2 m6377)]
    (. bean6376 setAuthenticationCode2 (clojure.core/str v6378)))
   bean6376))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetGroupRequest get-group-request
  [m6380]
  (clojure.core/let
   [bean6379
    (new
     com.amazonaws.services.identitymanagement.model.GetGroupRequest)]
   (clojure.core/when-let
    [v6381 (:group-name m6380)]
    (. bean6379 setGroupName (clojure.core/str v6381)))
   (clojure.core/when-let
    [v6381 (:max-items m6380)]
    (. bean6379 setMaxItems (clojure.core/int v6381)))
   (clojure.core/when-let
    [v6381 (:marker m6380)]
    (. bean6379 setMarker (clojure.core/str v6381)))
   bean6379))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteGroupPolicyRequest delete-group-policy-request
  [m6383]
  (clojure.core/let
   [bean6382
    (new
     com.amazonaws.services.identitymanagement.model.DeleteGroupPolicyRequest)]
   (clojure.core/when-let
    [v6384 (:group-name m6383)]
    (. bean6382 setGroupName (clojure.core/str v6384)))
   (clojure.core/when-let
    [v6384 (:policy-name m6383)]
    (. bean6382 setPolicyName (clojure.core/str v6384)))
   bean6382))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest create-instance-profile-request
  [m6386]
  (clojure.core/let
   [bean6385
    (new
     com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest)]
   (clojure.core/when-let
    [v6387 (:instance-profile-name m6386)]
    (. bean6385 setInstanceProfileName (clojure.core/str v6387)))
   (clojure.core/when-let
    [v6387 (:path m6386)]
    (. bean6385 setPath (clojure.core/str v6387)))
   bean6385))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateUserRequest update-user-request
  [m6389]
  (clojure.core/let
   [bean6388
    (new
     com.amazonaws.services.identitymanagement.model.UpdateUserRequest)]
   (clojure.core/when-let
    [v6390 (:user-name m6389)]
    (. bean6388 setUserName (clojure.core/str v6390)))
   (clojure.core/when-let
    [v6390 (:new-user-name m6389)]
    (. bean6388 setNewUserName (clojure.core/str v6390)))
   (clojure.core/when-let
    [v6390 (:new-path m6389)]
    (. bean6388 setNewPath (clojure.core/str v6390)))
   bean6388))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateUserRequest create-user-request
  [m6392]
  (clojure.core/let
   [bean6391
    (new
     com.amazonaws.services.identitymanagement.model.CreateUserRequest)]
   (clojure.core/when-let
    [v6393 (:user-name m6392)]
    (. bean6391 setUserName (clojure.core/str v6393)))
   (clojure.core/when-let
    [v6393 (:path m6392)]
    (. bean6391 setPath (clojure.core/str v6393)))
   bean6391))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateRoleRequest create-role-request
  [m6395]
  (clojure.core/let
   [bean6394
    (new
     com.amazonaws.services.identitymanagement.model.CreateRoleRequest)]
   (clojure.core/when-let
    [v6396 (:role-name m6395)]
    (. bean6394 setRoleName (clojure.core/str v6396)))
   (clojure.core/when-let
    [v6396 (:assume-role-policy-document m6395)]
    (. bean6394 setAssumeRolePolicyDocument (clojure.core/str v6396)))
   (clojure.core/when-let
    [v6396 (:path m6395)]
    (. bean6394 setPath (clojure.core/str v6396)))
   bean6394))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetUserPolicyRequest get-user-policy-request
  [m6398]
  (clojure.core/let
   [bean6397
    (new
     com.amazonaws.services.identitymanagement.model.GetUserPolicyRequest)]
   (clojure.core/when-let
    [v6399 (:policy-name m6398)]
    (. bean6397 setPolicyName (clojure.core/str v6399)))
   (clojure.core/when-let
    [v6399 (:user-name m6398)]
    (. bean6397 setUserName (clojure.core/str v6399)))
   bean6397))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListUsersRequest list-users-request
  [m6401]
  (clojure.core/let
   [bean6400
    (new
     com.amazonaws.services.identitymanagement.model.ListUsersRequest)]
   (clojure.core/when-let
    [v6402 (:max-items m6401)]
    (. bean6400 setMaxItems (clojure.core/int v6402)))
   (clojure.core/when-let
    [v6402 (:path-prefix m6401)]
    (. bean6400 setPathPrefix (clojure.core/str v6402)))
   (clojure.core/when-let
    [v6402 (:marker m6401)]
    (. bean6400 setMarker (clojure.core/str v6402)))
   bean6400))
 (clojure.core/defmulti
  iam
  (clojure.core/fn iam [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   iam
   :get-role-policy
   [m6403]
   (clojure.core/let
    [credentials6404 (:credentials m6403) args6405 (:args m6403)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6406
      (com.palletops.awaze.common/aws-client :iam credentials6404)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6406
       getRolePolicy
       (get-role-policy-request (clojure.core/nth args6405 0)))))))
  (clojure.core/defn
   get-role-policy-map
   {:arglists
    '[[credentials
       {:keys [role-name request-metric-collector policy-name]}]],
    :doc "Generate map for getRolePolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-role-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-role-policy
   {:arglists
    '[[credentials
       {:keys [role-name request-metric-collector policy-name]}]],
    :doc "Call getRolePolicy"}
   [credentials6408 & args6409]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6410
     (com.palletops.awaze.common/aws-client :iam credentials6408)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6410
      getRolePolicy
      (get-role-policy-request (clojure.core/nth args6409 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :change-password
   [m6411]
   (clojure.core/let
    [credentials6412 (:credentials m6411) args6413 (:args m6411)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6414
      (com.palletops.awaze.common/aws-client :iam credentials6412)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6414
       changePassword
       (change-password-request (clojure.core/nth args6413 0)))))))
  (clojure.core/defn
   change-password-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector old-password new-password]}]],
    :doc "Generate map for changePassword"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :change-password,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   change-password
   {:arglists
    '[[credentials
       {:keys [request-metric-collector old-password new-password]}]],
    :doc "Call changePassword"}
   [credentials6416 & args6417]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6418
     (com.palletops.awaze.common/aws-client :iam credentials6416)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6418
      changePassword
      (change-password-request (clojure.core/nth args6417 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :deactivate-mfadevice
   [m6419]
   (clojure.core/let
    [credentials6420 (:credentials m6419) args6421 (:args m6419)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6422
      (com.palletops.awaze.common/aws-client :iam credentials6420)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6422
       deactivateMFADevice
       (deactivate-mfadevice-request
        (clojure.core/nth args6421 0)))))))
  (clojure.core/defn
   deactivate-mfadevice-map
   {:arglists
    '[[credentials
       {:keys [user-name serial-number request-metric-collector]}]],
    :doc "Generate map for deactivateMFADevice"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :deactivate-mfadevice,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   deactivate-mfadevice
   {:arglists
    '[[credentials
       {:keys [user-name serial-number request-metric-collector]}]],
    :doc "Call deactivateMFADevice"}
   [credentials6424 & args6425]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6426
     (com.palletops.awaze.common/aws-client :iam credentials6424)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6426
      deactivateMFADevice
      (deactivate-mfadevice-request (clojure.core/nth args6425 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :resync-mfadevice
   [m6427]
   (clojure.core/let
    [credentials6428 (:credentials m6427) args6429 (:args m6427)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6430
      (com.palletops.awaze.common/aws-client :iam credentials6428)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6430
       resyncMFADevice
       (resync-mfadevice-request (clojure.core/nth args6429 0)))))))
  (clojure.core/defn
   resync-mfadevice-map
   {:arglists
    '[[credentials
       {:keys
        [user-name
         serial-number
         request-metric-collector
         authentication-code2
         authentication-code1]}]],
    :doc "Generate map for resyncMFADevice"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :resync-mfadevice,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   resync-mfadevice
   {:arglists
    '[[credentials
       {:keys
        [user-name
         serial-number
         request-metric-collector
         authentication-code2
         authentication-code1]}]],
    :doc "Call resyncMFADevice"}
   [credentials6432 & args6433]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6434
     (com.palletops.awaze.common/aws-client :iam credentials6432)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6434
      resyncMFADevice
      (resync-mfadevice-request (clojure.core/nth args6433 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-login-profile
   [m6435]
   (clojure.core/let
    [credentials6436 (:credentials m6435) args6437 (:args m6435)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6438
      (com.palletops.awaze.common/aws-client :iam credentials6436)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6438
       updateLoginProfile
       (update-login-profile-request
        (clojure.core/nth args6437 0)))))))
  (clojure.core/defn
   update-login-profile-map
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector password]}]],
    :doc "Generate map for updateLoginProfile"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-login-profile,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-login-profile
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector password]}]],
    :doc "Call updateLoginProfile"}
   [credentials6440 & args6441]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6442
     (com.palletops.awaze.common/aws-client :iam credentials6440)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6442
      updateLoginProfile
      (update-login-profile-request (clojure.core/nth args6441 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-role-policy
   [m6443]
   (clojure.core/let
    [credentials6444 (:credentials m6443) args6445 (:args m6443)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6446
      (com.palletops.awaze.common/aws-client :iam credentials6444)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6446
       putRolePolicy
       (put-role-policy-request (clojure.core/nth args6445 0)))))))
  (clojure.core/defn
   put-role-policy-map
   {:arglists
    '[[credentials
       {:keys
        [role-name
         request-metric-collector
         policy-name
         policy-document]}]],
    :doc "Generate map for putRolePolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :put-role-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   put-role-policy
   {:arglists
    '[[credentials
       {:keys
        [role-name
         request-metric-collector
         policy-name
         policy-document]}]],
    :doc "Call putRolePolicy"}
   [credentials6448 & args6449]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6450
     (com.palletops.awaze.common/aws-client :iam credentials6448)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6450
      putRolePolicy
      (put-role-policy-request (clojure.core/nth args6449 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-signing-certificate
   [m6451]
   (clojure.core/let
    [credentials6452 (:credentials m6451) args6453 (:args m6451)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6454
      (com.palletops.awaze.common/aws-client :iam credentials6452)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6454
       deleteSigningCertificate
       (delete-signing-certificate-request
        (clojure.core/nth args6453 0)))))))
  (clojure.core/defn
   delete-signing-certificate-map
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector certificate-id]}]],
    :doc "Generate map for deleteSigningCertificate"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-signing-certificate,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-signing-certificate
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector certificate-id]}]],
    :doc "Call deleteSigningCertificate"}
   [credentials6456 & args6457]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6458
     (com.palletops.awaze.common/aws-client :iam credentials6456)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6458
      deleteSigningCertificate
      (delete-signing-certificate-request
       (clojure.core/nth args6457 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user
   [m6459]
   (clojure.core/let
    [credentials6460 (:credentials m6459) args6461 (:args m6459)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6462
      (com.palletops.awaze.common/aws-client :iam credentials6460)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6462
       deleteUser
       (delete-user-request (clojure.core/nth args6461 0)))))))
  (clojure.core/defn
   delete-user-map
   {:arglists
    '[[credentials {:keys [user-name request-metric-collector]}]],
    :doc "Generate map for deleteUser"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-user,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-user
   {:arglists
    '[[credentials {:keys [user-name request-metric-collector]}]],
    :doc "Call deleteUser"}
   [credentials6464 & args6465]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6466
     (com.palletops.awaze.common/aws-client :iam credentials6464)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6466
      deleteUser
      (delete-user-request (clojure.core/nth args6465 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :add-user-to-group
   [m6467]
   (clojure.core/let
    [credentials6468 (:credentials m6467) args6469 (:args m6467)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6470
      (com.palletops.awaze.common/aws-client :iam credentials6468)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6470
       addUserToGroup
       (add-user-to-group-request (clojure.core/nth args6469 0)))))))
  (clojure.core/defn
   add-user-to-group-map
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector group-name]}]],
    :doc "Generate map for addUserToGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :add-user-to-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   add-user-to-group
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector group-name]}]],
    :doc "Call addUserToGroup"}
   [credentials6472 & args6473]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6474
     (com.palletops.awaze.common/aws-client :iam credentials6472)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6474
      addUserToGroup
      (add-user-to-group-request (clojure.core/nth args6473 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-account-aliases
   [m6475]
   (clojure.core/let
    [credentials6476 (:credentials m6475) args6477 (:args m6475)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6478
      (com.palletops.awaze.common/aws-client :iam credentials6476)]
     (clojure.core/case
      (clojure.core/count args6477)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6478
        listAccountAliases
        (list-account-aliases-request (clojure.core/nth args6477 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6478
        listAccountAliases))))))
  (clojure.core/defn
   list-account-aliases-map
   {:arglists
    '[[credentials {:keys [request-metric-collector max-items marker]}]
      [credentials]],
    :doc "Generate map for listAccountAliases, listAccountAliases"}
   ([credentials__577__auto__]
    {:args [],
     :client :iam,
     :fn :list-account-aliases,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-account-aliases,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-account-aliases
   {:arglists
    '[[credentials {:keys [request-metric-collector max-items marker]}]
      [credentials]],
    :doc "Call listAccountAliases, listAccountAliases"}
   [credentials6480 & args6481]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6482
     (com.palletops.awaze.common/aws-client :iam credentials6480)]
    (clojure.core/case
     (clojure.core/count args6481)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6482
       listAccountAliases
       (list-account-aliases-request (clojure.core/nth args6481 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6482
       listAccountAliases))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-user-from-group
   [m6483]
   (clojure.core/let
    [credentials6484 (:credentials m6483) args6485 (:args m6483)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6486
      (com.palletops.awaze.common/aws-client :iam credentials6484)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6486
       removeUserFromGroup
       (remove-user-from-group-request
        (clojure.core/nth args6485 0)))))))
  (clojure.core/defn
   remove-user-from-group-map
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector group-name]}]],
    :doc "Generate map for removeUserFromGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :remove-user-from-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   remove-user-from-group
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector group-name]}]],
    :doc "Call removeUserFromGroup"}
   [credentials6488 & args6489]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6490
     (com.palletops.awaze.common/aws-client :iam credentials6488)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6490
      removeUserFromGroup
      (remove-user-from-group-request
       (clojure.core/nth args6489 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-group
   [m6491]
   (clojure.core/let
    [credentials6492 (:credentials m6491) args6493 (:args m6491)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6494
      (com.palletops.awaze.common/aws-client :iam credentials6492)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6494
       updateGroup
       (update-group-request (clojure.core/nth args6493 0)))))))
  (clojure.core/defn
   update-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         new-path
         new-group-name
         group-name]}]],
    :doc "Generate map for updateGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         new-path
         new-group-name
         group-name]}]],
    :doc "Call updateGroup"}
   [credentials6496 & args6497]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6498
     (com.palletops.awaze.common/aws-client :iam credentials6496)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6498
      updateGroup
      (update-group-request (clojure.core/nth args6497 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-server-certificate
   [m6499]
   (clojure.core/let
    [credentials6500 (:credentials m6499) args6501 (:args m6499)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6502
      (com.palletops.awaze.common/aws-client :iam credentials6500)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6502
       updateServerCertificate
       (update-server-certificate-request
        (clojure.core/nth args6501 0)))))))
  (clojure.core/defn
   update-server-certificate-map
   {:arglists
    '[[credentials
       {:keys
        [server-certificate-name
         request-metric-collector
         new-server-certificate-name
         new-path]}]],
    :doc "Generate map for updateServerCertificate"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-server-certificate,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-server-certificate
   {:arglists
    '[[credentials
       {:keys
        [server-certificate-name
         request-metric-collector
         new-server-certificate-name
         new-path]}]],
    :doc "Call updateServerCertificate"}
   [credentials6504 & args6505]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6506
     (com.palletops.awaze.common/aws-client :iam credentials6504)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6506
      updateServerCertificate
      (update-server-certificate-request
       (clojure.core/nth args6505 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role-policy
   [m6507]
   (clojure.core/let
    [credentials6508 (:credentials m6507) args6509 (:args m6507)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6510
      (com.palletops.awaze.common/aws-client :iam credentials6508)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6510
       deleteRolePolicy
       (delete-role-policy-request (clojure.core/nth args6509 0)))))))
  (clojure.core/defn
   delete-role-policy-map
   {:arglists
    '[[credentials
       {:keys [role-name request-metric-collector policy-name]}]],
    :doc "Generate map for deleteRolePolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-role-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-role-policy
   {:arglists
    '[[credentials
       {:keys [role-name request-metric-collector policy-name]}]],
    :doc "Call deleteRolePolicy"}
   [credentials6512 & args6513]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6514
     (com.palletops.awaze.common/aws-client :iam credentials6512)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6514
      deleteRolePolicy
      (delete-role-policy-request (clojure.core/nth args6513 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-access-key
   [m6515]
   (clojure.core/let
    [credentials6516 (:credentials m6515) args6517 (:args m6515)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6518
      (com.palletops.awaze.common/aws-client :iam credentials6516)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6518
       updateAccessKey
       (update-access-key-request (clojure.core/nth args6517 0)))))))
  (clojure.core/defn
   update-access-key-map
   {:arglists
    '[[credentials
       {:keys
        [user-name status request-metric-collector access-key-id]}]],
    :doc "Generate map for updateAccessKey"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-access-key,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-access-key
   {:arglists
    '[[credentials
       {:keys
        [user-name status request-metric-collector access-key-id]}]],
    :doc "Call updateAccessKey"}
   [credentials6520 & args6521]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6522
     (com.palletops.awaze.common/aws-client :iam credentials6520)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6522
      updateAccessKey
      (update-access-key-request (clojure.core/nth args6521 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group
   [m6523]
   (clojure.core/let
    [credentials6524 (:credentials m6523) args6525 (:args m6523)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6526
      (com.palletops.awaze.common/aws-client :iam credentials6524)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6526
       deleteGroup
       (delete-group-request (clojure.core/nth args6525 0)))))))
  (clojure.core/defn
   delete-group-map
   {:arglists
    '[[credentials {:keys [request-metric-collector group-name]}]],
    :doc "Generate map for deleteGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-group
   {:arglists
    '[[credentials {:keys [request-metric-collector group-name]}]],
    :doc "Call deleteGroup"}
   [credentials6528 & args6529]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6530
     (com.palletops.awaze.common/aws-client :iam credentials6528)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6530
      deleteGroup
      (delete-group-request (clojure.core/nth args6529 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-groups-for-user
   [m6531]
   (clojure.core/let
    [credentials6532 (:credentials m6531) args6533 (:args m6531)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6534
      (com.palletops.awaze.common/aws-client :iam credentials6532)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6534
       listGroupsForUser
       (list-groups-for-user-request
        (clojure.core/nth args6533 0)))))))
  (clojure.core/defn
   list-groups-for-user-map
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector max-items marker]}]],
    :doc "Generate map for listGroupsForUser"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-groups-for-user,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-groups-for-user
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector max-items marker]}]],
    :doc "Call listGroupsForUser"}
   [credentials6536 & args6537]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6538
     (com.palletops.awaze.common/aws-client :iam credentials6536)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6538
      listGroupsForUser
      (list-groups-for-user-request (clojure.core/nth args6537 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-user-policy
   [m6539]
   (clojure.core/let
    [credentials6540 (:credentials m6539) args6541 (:args m6539)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6542
      (com.palletops.awaze.common/aws-client :iam credentials6540)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6542
       putUserPolicy
       (put-user-policy-request (clojure.core/nth args6541 0)))))))
  (clojure.core/defn
   put-user-policy-map
   {:arglists
    '[[credentials
       {:keys
        [user-name
         request-metric-collector
         policy-name
         policy-document]}]],
    :doc "Generate map for putUserPolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :put-user-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   put-user-policy
   {:arglists
    '[[credentials
       {:keys
        [user-name
         request-metric-collector
         policy-name
         policy-document]}]],
    :doc "Call putUserPolicy"}
   [credentials6544 & args6545]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6546
     (com.palletops.awaze.common/aws-client :iam credentials6544)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6546
      putUserPolicy
      (put-user-policy-request (clojure.core/nth args6545 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-role
   [m6547]
   (clojure.core/let
    [credentials6548 (:credentials m6547) args6549 (:args m6547)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6550
      (com.palletops.awaze.common/aws-client :iam credentials6548)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6550
       getRole
       (get-role-request (clojure.core/nth args6549 0)))))))
  (clojure.core/defn
   get-role-map
   {:arglists
    '[[credentials {:keys [role-name request-metric-collector]}]],
    :doc "Generate map for getRole"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-role,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-role
   {:arglists
    '[[credentials {:keys [role-name request-metric-collector]}]],
    :doc "Call getRole"}
   [credentials6552 & args6553]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6554
     (com.palletops.awaze.common/aws-client :iam credentials6552)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6554
      getRole
      (get-role-request (clojure.core/nth args6553 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-password-policy
   [m6555]
   (clojure.core/let
    [credentials6556 (:credentials m6555) args6557 (:args m6555)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6558
      (com.palletops.awaze.common/aws-client :iam credentials6556)]
     (clojure.core/case
      (clojure.core/count args6557)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6558
        getAccountPasswordPolicy
        (get-account-password-policy-request
         (clojure.core/nth args6557 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6558
        getAccountPasswordPolicy))))))
  (clojure.core/defn
   get-account-password-policy-map
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc
    "Generate map for getAccountPasswordPolicy, getAccountPasswordPolicy"}
   ([credentials__577__auto__]
    {:args [],
     :client :iam,
     :fn :get-account-password-policy,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-account-password-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-account-password-policy
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc "Call getAccountPasswordPolicy, getAccountPasswordPolicy"}
   [credentials6560 & args6561]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6562
     (com.palletops.awaze.common/aws-client :iam credentials6560)]
    (clojure.core/case
     (clojure.core/count args6561)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6562
       getAccountPasswordPolicy
       (get-account-password-policy-request
        (clojure.core/nth args6561 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6562
       getAccountPasswordPolicy))))))
 (do
  (clojure.core/defmethod
   iam
   :list-access-keys
   [m6563]
   (clojure.core/let
    [credentials6564 (:credentials m6563) args6565 (:args m6563)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6566
      (com.palletops.awaze.common/aws-client :iam credentials6564)]
     (clojure.core/case
      (clojure.core/count args6565)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6566
        listAccessKeys
        (list-access-keys-request (clojure.core/nth args6565 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6566
        listAccessKeys))))))
  (clojure.core/defn
   list-access-keys-map
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector max-items marker]}]
      [credentials]],
    :doc "Generate map for listAccessKeys, listAccessKeys"}
   ([credentials__577__auto__]
    {:args [],
     :client :iam,
     :fn :list-access-keys,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-access-keys,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-access-keys
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector max-items marker]}]
      [credentials]],
    :doc "Call listAccessKeys, listAccessKeys"}
   [credentials6568 & args6569]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6570
     (com.palletops.awaze.common/aws-client :iam credentials6568)]
    (clojure.core/case
     (clojure.core/count args6569)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6570
       listAccessKeys
       (list-access-keys-request (clojure.core/nth args6569 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6570
       listAccessKeys))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-alias
   [m6571]
   (clojure.core/let
    [credentials6572 (:credentials m6571) args6573 (:args m6571)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6574
      (com.palletops.awaze.common/aws-client :iam credentials6572)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6574
       deleteAccountAlias
       (delete-account-alias-request
        (clojure.core/nth args6573 0)))))))
  (clojure.core/defn
   delete-account-alias-map
   {:arglists
    '[[credentials {:keys [request-metric-collector account-alias]}]],
    :doc "Generate map for deleteAccountAlias"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-account-alias,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-account-alias
   {:arglists
    '[[credentials {:keys [request-metric-collector account-alias]}]],
    :doc "Call deleteAccountAlias"}
   [credentials6576 & args6577]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6578
     (com.palletops.awaze.common/aws-client :iam credentials6576)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6578
      deleteAccountAlias
      (delete-account-alias-request (clojure.core/nth args6577 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-login-profile
   [m6579]
   (clojure.core/let
    [credentials6580 (:credentials m6579) args6581 (:args m6579)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6582
      (com.palletops.awaze.common/aws-client :iam credentials6580)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6582
       getLoginProfile
       (get-login-profile-request (clojure.core/nth args6581 0)))))))
  (clojure.core/defn
   get-login-profile-map
   {:arglists
    '[[credentials {:keys [user-name request-metric-collector]}]],
    :doc "Generate map for getLoginProfile"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-login-profile,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-login-profile
   {:arglists
    '[[credentials {:keys [user-name request-metric-collector]}]],
    :doc "Call getLoginProfile"}
   [credentials6584 & args6585]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6586
     (com.palletops.awaze.common/aws-client :iam credentials6584)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6586
      getLoginProfile
      (get-login-profile-request (clojure.core/nth args6585 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-login-profile
   [m6587]
   (clojure.core/let
    [credentials6588 (:credentials m6587) args6589 (:args m6587)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6590
      (com.palletops.awaze.common/aws-client :iam credentials6588)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6590
       createLoginProfile
       (create-login-profile-request
        (clojure.core/nth args6589 0)))))))
  (clojure.core/defn
   create-login-profile-map
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector password]}]],
    :doc "Generate map for createLoginProfile"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-login-profile,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-login-profile
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector password]}]],
    :doc "Call createLoginProfile"}
   [credentials6592 & args6593]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6594
     (com.palletops.awaze.common/aws-client :iam credentials6592)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6594
      createLoginProfile
      (create-login-profile-request (clojure.core/nth args6593 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-groups
   [m6595]
   (clojure.core/let
    [credentials6596 (:credentials m6595) args6597 (:args m6595)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6598
      (com.palletops.awaze.common/aws-client :iam credentials6596)]
     (clojure.core/case
      (clojure.core/count args6597)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6598
        listGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6598
        listGroups
        (list-groups-request (clojure.core/nth args6597 0))))))))
  (clojure.core/defn
   list-groups-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector path-prefix max-items marker]}]],
    :doc "Generate map for listGroups, listGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :iam,
     :fn :list-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-groups
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector path-prefix max-items marker]}]],
    :doc "Call listGroups, listGroups"}
   [credentials6600 & args6601]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6602
     (com.palletops.awaze.common/aws-client :iam credentials6600)]
    (clojure.core/case
     (clojure.core/count args6601)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6602
       listGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6602
       listGroups
       (list-groups-request (clojure.core/nth args6601 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-summary
   [m6603]
   (clojure.core/let
    [credentials6604 (:credentials m6603) args6605 (:args m6603)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6606
      (com.palletops.awaze.common/aws-client :iam credentials6604)]
     (clojure.core/case
      (clojure.core/count args6605)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6606
        getAccountSummary))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6606
        getAccountSummary
        (get-account-summary-request
         (clojure.core/nth args6605 0))))))))
  (clojure.core/defn
   get-account-summary-map
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc "Generate map for getAccountSummary, getAccountSummary"}
   ([credentials__577__auto__]
    {:args [],
     :client :iam,
     :fn :get-account-summary,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-account-summary,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-account-summary
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc "Call getAccountSummary, getAccountSummary"}
   [credentials6608 & args6609]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6610
     (com.palletops.awaze.common/aws-client :iam credentials6608)]
    (clojure.core/case
     (clojure.core/count args6609)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6610
       getAccountSummary))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6610
       getAccountSummary
       (get-account-summary-request
        (clojure.core/nth args6609 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-password-policy
   [m6611]
   (clojure.core/let
    [credentials6612 (:credentials m6611) args6613 (:args m6611)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6614
      (com.palletops.awaze.common/aws-client :iam credentials6612)]
     (clojure.core/case
      (clojure.core/count args6613)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6614
        deleteAccountPasswordPolicy))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6614
        deleteAccountPasswordPolicy
        (delete-account-password-policy-request
         (clojure.core/nth args6613 0))))))))
  (clojure.core/defn
   delete-account-password-policy-map
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc
    "Generate map for deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   ([credentials__577__auto__]
    {:args [],
     :client :iam,
     :fn :delete-account-password-policy,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-account-password-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-account-password-policy
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc
    "Call deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   [credentials6616 & args6617]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6618
     (com.palletops.awaze.common/aws-client :iam credentials6616)]
    (clojure.core/case
     (clojure.core/count args6617)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6618
       deleteAccountPasswordPolicy))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6618
       deleteAccountPasswordPolicy
       (delete-account-password-policy-request
        (clojure.core/nth args6617 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-instance-profile
   [m6619]
   (clojure.core/let
    [credentials6620 (:credentials m6619) args6621 (:args m6619)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6622
      (com.palletops.awaze.common/aws-client :iam credentials6620)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6622
       getInstanceProfile
       (get-instance-profile-request
        (clojure.core/nth args6621 0)))))))
  (clojure.core/defn
   get-instance-profile-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector instance-profile-name]}]],
    :doc "Generate map for getInstanceProfile"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-instance-profile,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-instance-profile
   {:arglists
    '[[credentials
       {:keys [request-metric-collector instance-profile-name]}]],
    :doc "Call getInstanceProfile"}
   [credentials6624 & args6625]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6626
     (com.palletops.awaze.common/aws-client :iam credentials6624)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6626
      getInstanceProfile
      (get-instance-profile-request (clojure.core/nth args6625 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user
   [m6627]
   (clojure.core/let
    [credentials6628 (:credentials m6627) args6629 (:args m6627)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6630
      (com.palletops.awaze.common/aws-client :iam credentials6628)]
     (clojure.core/case
      (clojure.core/count args6629)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6630
        getUser))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6630
        getUser
        (get-user-request (clojure.core/nth args6629 0))))))))
  (clojure.core/defn
   get-user-map
   {:arglists
    '[[credentials]
      [credentials {:keys [user-name request-metric-collector]}]],
    :doc "Generate map for getUser, getUser"}
   ([credentials__577__auto__]
    {:args [],
     :client :iam,
     :fn :get-user,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-user,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-user
   {:arglists
    '[[credentials]
      [credentials {:keys [user-name request-metric-collector]}]],
    :doc "Call getUser, getUser"}
   [credentials6632 & args6633]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6634
     (com.palletops.awaze.common/aws-client :iam credentials6632)]
    (clojure.core/case
     (clojure.core/count args6633)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6634
       getUser))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6634
       getUser
       (get-user-request (clojure.core/nth args6633 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-virtual-mfadevice
   [m6635]
   (clojure.core/let
    [credentials6636 (:credentials m6635) args6637 (:args m6635)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6638
      (com.palletops.awaze.common/aws-client :iam credentials6636)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6638
       deleteVirtualMFADevice
       (delete-virtual-mfadevice-request
        (clojure.core/nth args6637 0)))))))
  (clojure.core/defn
   delete-virtual-mfadevice-map
   {:arglists
    '[[credentials {:keys [serial-number request-metric-collector]}]],
    :doc "Generate map for deleteVirtualMFADevice"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-virtual-mfadevice,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-virtual-mfadevice
   {:arglists
    '[[credentials {:keys [serial-number request-metric-collector]}]],
    :doc "Call deleteVirtualMFADevice"}
   [credentials6640 & args6641]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6642
     (com.palletops.awaze.common/aws-client :iam credentials6640)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6642
      deleteVirtualMFADevice
      (delete-virtual-mfadevice-request
       (clojure.core/nth args6641 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-access-key
   [m6643]
   (clojure.core/let
    [credentials6644 (:credentials m6643) args6645 (:args m6643)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6646
      (com.palletops.awaze.common/aws-client :iam credentials6644)]
     (clojure.core/case
      (clojure.core/count args6645)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6646
        createAccessKey))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6646
        createAccessKey
        (create-access-key-request (clojure.core/nth args6645 0))))))))
  (clojure.core/defn
   create-access-key-map
   {:arglists
    '[[credentials]
      [credentials {:keys [user-name request-metric-collector]}]],
    :doc "Generate map for createAccessKey, createAccessKey"}
   ([credentials__577__auto__]
    {:args [],
     :client :iam,
     :fn :create-access-key,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-access-key,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-access-key
   {:arglists
    '[[credentials]
      [credentials {:keys [user-name request-metric-collector]}]],
    :doc "Call createAccessKey, createAccessKey"}
   [credentials6648 & args6649]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6650
     (com.palletops.awaze.common/aws-client :iam credentials6648)]
    (clojure.core/case
     (clojure.core/count args6649)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6650
       createAccessKey))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6650
       createAccessKey
       (create-access-key-request (clojure.core/nth args6649 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles
   [m6651]
   (clojure.core/let
    [credentials6652 (:credentials m6651) args6653 (:args m6651)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6654
      (com.palletops.awaze.common/aws-client :iam credentials6652)]
     (clojure.core/case
      (clojure.core/count args6653)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6654
        listInstanceProfiles
        (list-instance-profiles-request
         (clojure.core/nth args6653 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6654
        listInstanceProfiles))))))
  (clojure.core/defn
   list-instance-profiles-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector path-prefix max-items marker]}]
      [credentials]],
    :doc "Generate map for listInstanceProfiles, listInstanceProfiles"}
   ([credentials__577__auto__]
    {:args [],
     :client :iam,
     :fn :list-instance-profiles,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-instance-profiles,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-instance-profiles
   {:arglists
    '[[credentials
       {:keys [request-metric-collector path-prefix max-items marker]}]
      [credentials]],
    :doc "Call listInstanceProfiles, listInstanceProfiles"}
   [credentials6656 & args6657]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6658
     (com.palletops.awaze.common/aws-client :iam credentials6656)]
    (clojure.core/case
     (clojure.core/count args6657)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6658
       listInstanceProfiles
       (list-instance-profiles-request (clojure.core/nth args6657 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6658
       listInstanceProfiles))))))
 (do
  (clojure.core/defmethod
   iam
   :put-group-policy
   [m6659]
   (clojure.core/let
    [credentials6660 (:credentials m6659) args6661 (:args m6659)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6662
      (com.palletops.awaze.common/aws-client :iam credentials6660)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6662
       putGroupPolicy
       (put-group-policy-request (clojure.core/nth args6661 0)))))))
  (clojure.core/defn
   put-group-policy-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-name
         policy-document
         group-name]}]],
    :doc "Generate map for putGroupPolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :put-group-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   put-group-policy
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-name
         policy-document
         group-name]}]],
    :doc "Call putGroupPolicy"}
   [credentials6664 & args6665]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6666
     (com.palletops.awaze.common/aws-client :iam credentials6664)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6666
      putGroupPolicy
      (put-group-policy-request (clojure.core/nth args6665 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-server-certificate
   [m6667]
   (clojure.core/let
    [credentials6668 (:credentials m6667) args6669 (:args m6667)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6670
      (com.palletops.awaze.common/aws-client :iam credentials6668)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6670
       getServerCertificate
       (get-server-certificate-request
        (clojure.core/nth args6669 0)))))))
  (clojure.core/defn
   get-server-certificate-map
   {:arglists
    '[[credentials
       {:keys [server-certificate-name request-metric-collector]}]],
    :doc "Generate map for getServerCertificate"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-server-certificate,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-server-certificate
   {:arglists
    '[[credentials
       {:keys [server-certificate-name request-metric-collector]}]],
    :doc "Call getServerCertificate"}
   [credentials6672 & args6673]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6674
     (com.palletops.awaze.common/aws-client :iam credentials6672)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6674
      getServerCertificate
      (get-server-certificate-request
       (clojure.core/nth args6673 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-server-certificate
   [m6675]
   (clojure.core/let
    [credentials6676 (:credentials m6675) args6677 (:args m6675)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6678
      (com.palletops.awaze.common/aws-client :iam credentials6676)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6678
       uploadServerCertificate
       (upload-server-certificate-request
        (clojure.core/nth args6677 0)))))))
  (clojure.core/defn
   upload-server-certificate-map
   {:arglists
    '[[credentials
       {:keys
        [server-certificate-name
         request-metric-collector
         private-key
         path
         certificate-chain
         certificate-body]}]],
    :doc "Generate map for uploadServerCertificate"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :upload-server-certificate,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   upload-server-certificate
   {:arglists
    '[[credentials
       {:keys
        [server-certificate-name
         request-metric-collector
         private-key
         path
         certificate-chain
         certificate-body]}]],
    :doc "Call uploadServerCertificate"}
   [credentials6680 & args6681]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6682
     (com.palletops.awaze.common/aws-client :iam credentials6680)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6682
      uploadServerCertificate
      (upload-server-certificate-request
       (clojure.core/nth args6681 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-role-policies
   [m6683]
   (clojure.core/let
    [credentials6684 (:credentials m6683) args6685 (:args m6683)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6686
      (com.palletops.awaze.common/aws-client :iam credentials6684)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6686
       listRolePolicies
       (list-role-policies-request (clojure.core/nth args6685 0)))))))
  (clojure.core/defn
   list-role-policies-map
   {:arglists
    '[[credentials
       {:keys [role-name request-metric-collector max-items marker]}]],
    :doc "Generate map for listRolePolicies"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-role-policies,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-role-policies
   {:arglists
    '[[credentials
       {:keys [role-name request-metric-collector max-items marker]}]],
    :doc "Call listRolePolicies"}
   [credentials6688 & args6689]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6690
     (com.palletops.awaze.common/aws-client :iam credentials6688)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6690
      listRolePolicies
      (list-role-policies-request (clojure.core/nth args6689 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :add-role-to-instance-profile
   [m6691]
   (clojure.core/let
    [credentials6692 (:credentials m6691) args6693 (:args m6691)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6694
      (com.palletops.awaze.common/aws-client :iam credentials6692)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6694
       addRoleToInstanceProfile
       (add-role-to-instance-profile-request
        (clojure.core/nth args6693 0)))))))
  (clojure.core/defn
   add-role-to-instance-profile-map
   {:arglists
    '[[credentials
       {:keys
        [role-name request-metric-collector instance-profile-name]}]],
    :doc "Generate map for addRoleToInstanceProfile"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :add-role-to-instance-profile,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   add-role-to-instance-profile
   {:arglists
    '[[credentials
       {:keys
        [role-name request-metric-collector instance-profile-name]}]],
    :doc "Call addRoleToInstanceProfile"}
   [credentials6696 & args6697]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6698
     (com.palletops.awaze.common/aws-client :iam credentials6696)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6698
      addRoleToInstanceProfile
      (add-role-to-instance-profile-request
       (clojure.core/nth args6697 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-access-key
   [m6699]
   (clojure.core/let
    [credentials6700 (:credentials m6699) args6701 (:args m6699)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6702
      (com.palletops.awaze.common/aws-client :iam credentials6700)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6702
       deleteAccessKey
       (delete-access-key-request (clojure.core/nth args6701 0)))))))
  (clojure.core/defn
   delete-access-key-map
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector access-key-id]}]],
    :doc "Generate map for deleteAccessKey"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-access-key,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-access-key
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector access-key-id]}]],
    :doc "Call deleteAccessKey"}
   [credentials6704 & args6705]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6706
     (com.palletops.awaze.common/aws-client :iam credentials6704)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6706
      deleteAccessKey
      (delete-access-key-request (clojure.core/nth args6705 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role
   [m6707]
   (clojure.core/let
    [credentials6708 (:credentials m6707) args6709 (:args m6707)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6710
      (com.palletops.awaze.common/aws-client :iam credentials6708)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6710
       deleteRole
       (delete-role-request (clojure.core/nth args6709 0)))))))
  (clojure.core/defn
   delete-role-map
   {:arglists
    '[[credentials {:keys [role-name request-metric-collector]}]],
    :doc "Generate map for deleteRole"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-role,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-role
   {:arglists
    '[[credentials {:keys [role-name request-metric-collector]}]],
    :doc "Call deleteRole"}
   [credentials6712 & args6713]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6714
     (com.palletops.awaze.common/aws-client :iam credentials6712)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6714
      deleteRole
      (delete-role-request (clojure.core/nth args6713 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-virtual-mfadevice
   [m6715]
   (clojure.core/let
    [credentials6716 (:credentials m6715) args6717 (:args m6715)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6718
      (com.palletops.awaze.common/aws-client :iam credentials6716)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6718
       createVirtualMFADevice
       (create-virtual-mfadevice-request
        (clojure.core/nth args6717 0)))))))
  (clojure.core/defn
   create-virtual-mfadevice-map
   {:arglists
    '[[credentials
       {:keys
        [virtual-mfadevice-name request-metric-collector path]}]],
    :doc "Generate map for createVirtualMFADevice"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-virtual-mfadevice,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-virtual-mfadevice
   {:arglists
    '[[credentials
       {:keys
        [virtual-mfadevice-name request-metric-collector path]}]],
    :doc "Call createVirtualMFADevice"}
   [credentials6720 & args6721]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6722
     (com.palletops.awaze.common/aws-client :iam credentials6720)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6722
      createVirtualMFADevice
      (create-virtual-mfadevice-request
       (clojure.core/nth args6721 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-group-policies
   [m6723]
   (clojure.core/let
    [credentials6724 (:credentials m6723) args6725 (:args m6723)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6726
      (com.palletops.awaze.common/aws-client :iam credentials6724)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6726
       listGroupPolicies
       (list-group-policies-request (clojure.core/nth args6725 0)))))))
  (clojure.core/defn
   list-group-policies-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector max-items marker group-name]}]],
    :doc "Generate map for listGroupPolicies"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-group-policies,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-group-policies
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector max-items marker group-name]}]],
    :doc "Call listGroupPolicies"}
   [credentials6728 & args6729]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6730
     (com.palletops.awaze.common/aws-client :iam credentials6728)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6730
      listGroupPolicies
      (list-group-policies-request (clojure.core/nth args6729 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group-policy
   [m6731]
   (clojure.core/let
    [credentials6732 (:credentials m6731) args6733 (:args m6731)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6734
      (com.palletops.awaze.common/aws-client :iam credentials6732)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6734
       getGroupPolicy
       (get-group-policy-request (clojure.core/nth args6733 0)))))))
  (clojure.core/defn
   get-group-policy-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector policy-name group-name]}]],
    :doc "Generate map for getGroupPolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-group-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-group-policy
   {:arglists
    '[[credentials
       {:keys [request-metric-collector policy-name group-name]}]],
    :doc "Call getGroupPolicy"}
   [credentials6736 & args6737]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6738
     (com.palletops.awaze.common/aws-client :iam credentials6736)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6738
      getGroupPolicy
      (get-group-policy-request (clojure.core/nth args6737 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-server-certificates
   [m6739]
   (clojure.core/let
    [credentials6740 (:credentials m6739) args6741 (:args m6739)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6742
      (com.palletops.awaze.common/aws-client :iam credentials6740)]
     (clojure.core/case
      (clojure.core/count args6741)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6742
        listServerCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6742
        listServerCertificates
        (list-server-certificates-request
         (clojure.core/nth args6741 0))))))))
  (clojure.core/defn
   list-server-certificates-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector path-prefix max-items marker]}]],
    :doc
    "Generate map for listServerCertificates, listServerCertificates"}
   ([credentials__577__auto__]
    {:args [],
     :client :iam,
     :fn :list-server-certificates,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-server-certificates,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-server-certificates
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector path-prefix max-items marker]}]],
    :doc "Call listServerCertificates, listServerCertificates"}
   [credentials6744 & args6745]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6746
     (com.palletops.awaze.common/aws-client :iam credentials6744)]
    (clojure.core/case
     (clojure.core/count args6745)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6746
       listServerCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6746
       listServerCertificates
       (list-server-certificates-request
        (clojure.core/nth args6745 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :update-account-password-policy
   [m6747]
   (clojure.core/let
    [credentials6748 (:credentials m6747) args6749 (:args m6747)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6750
      (com.palletops.awaze.common/aws-client :iam credentials6748)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6750
       updateAccountPasswordPolicy
       (update-account-password-policy-request
        (clojure.core/nth args6749 0)))))))
  (clojure.core/defn
   update-account-password-policy-map
   {:arglists
    '[[credentials
       {:keys
        [require-lowercase-characters
         minimum-password-length
         require-uppercase-characters
         require-symbols
         request-metric-collector
         require-numbers
         allow-users-to-change-password]}]],
    :doc "Generate map for updateAccountPasswordPolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-account-password-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-account-password-policy
   {:arglists
    '[[credentials
       {:keys
        [require-lowercase-characters
         minimum-password-length
         require-uppercase-characters
         require-symbols
         request-metric-collector
         require-numbers
         allow-users-to-change-password]}]],
    :doc "Call updateAccountPasswordPolicy"}
   [credentials6752 & args6753]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6754
     (com.palletops.awaze.common/aws-client :iam credentials6752)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6754
      updateAccountPasswordPolicy
      (update-account-password-policy-request
       (clojure.core/nth args6753 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-group
   [m6755]
   (clojure.core/let
    [credentials6756 (:credentials m6755) args6757 (:args m6755)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6758
      (com.palletops.awaze.common/aws-client :iam credentials6756)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6758
       createGroup
       (create-group-request (clojure.core/nth args6757 0)))))))
  (clojure.core/defn
   create-group-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector path group-name]}]],
    :doc "Generate map for createGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-group
   {:arglists
    '[[credentials
       {:keys [request-metric-collector path group-name]}]],
    :doc "Call createGroup"}
   [credentials6760 & args6761]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6762
     (com.palletops.awaze.common/aws-client :iam credentials6760)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6762
      createGroup
      (create-group-request (clojure.core/nth args6761 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles-for-role
   [m6763]
   (clojure.core/let
    [credentials6764 (:credentials m6763) args6765 (:args m6763)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6766
      (com.palletops.awaze.common/aws-client :iam credentials6764)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6766
       listInstanceProfilesForRole
       (list-instance-profiles-for-role-request
        (clojure.core/nth args6765 0)))))))
  (clojure.core/defn
   list-instance-profiles-for-role-map
   {:arglists
    '[[credentials
       {:keys [role-name request-metric-collector max-items marker]}]],
    :doc "Generate map for listInstanceProfilesForRole"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-instance-profiles-for-role,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-instance-profiles-for-role
   {:arglists
    '[[credentials
       {:keys [role-name request-metric-collector max-items marker]}]],
    :doc "Call listInstanceProfilesForRole"}
   [credentials6768 & args6769]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6770
     (com.palletops.awaze.common/aws-client :iam credentials6768)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6770
      listInstanceProfilesForRole
      (list-instance-profiles-for-role-request
       (clojure.core/nth args6769 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-signing-certificate
   [m6771]
   (clojure.core/let
    [credentials6772 (:credentials m6771) args6773 (:args m6771)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6774
      (com.palletops.awaze.common/aws-client :iam credentials6772)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6774
       uploadSigningCertificate
       (upload-signing-certificate-request
        (clojure.core/nth args6773 0)))))))
  (clojure.core/defn
   upload-signing-certificate-map
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector certificate-body]}]],
    :doc "Generate map for uploadSigningCertificate"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :upload-signing-certificate,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   upload-signing-certificate
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector certificate-body]}]],
    :doc "Call uploadSigningCertificate"}
   [credentials6776 & args6777]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6778
     (com.palletops.awaze.common/aws-client :iam credentials6776)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6778
      uploadSigningCertificate
      (upload-signing-certificate-request
       (clojure.core/nth args6777 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-server-certificate
   [m6779]
   (clojure.core/let
    [credentials6780 (:credentials m6779) args6781 (:args m6779)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6782
      (com.palletops.awaze.common/aws-client :iam credentials6780)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6782
       deleteServerCertificate
       (delete-server-certificate-request
        (clojure.core/nth args6781 0)))))))
  (clojure.core/defn
   delete-server-certificate-map
   {:arglists
    '[[credentials
       {:keys [server-certificate-name request-metric-collector]}]],
    :doc "Generate map for deleteServerCertificate"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-server-certificate,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-server-certificate
   {:arglists
    '[[credentials
       {:keys [server-certificate-name request-metric-collector]}]],
    :doc "Call deleteServerCertificate"}
   [credentials6784 & args6785]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6786
     (com.palletops.awaze.common/aws-client :iam credentials6784)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6786
      deleteServerCertificate
      (delete-server-certificate-request
       (clojure.core/nth args6785 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-virtual-mfadevices
   [m6787]
   (clojure.core/let
    [credentials6788 (:credentials m6787) args6789 (:args m6787)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6790
      (com.palletops.awaze.common/aws-client :iam credentials6788)]
     (clojure.core/case
      (clojure.core/count args6789)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6790
        listVirtualMFADevices))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6790
        listVirtualMFADevices
        (list-virtual-mfadevices-request
         (clojure.core/nth args6789 0))))))))
  (clojure.core/defn
   list-virtual-mfadevices-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         max-items
         marker
         assignment-status]}]],
    :doc
    "Generate map for listVirtualMFADevices, listVirtualMFADevices"}
   ([credentials__577__auto__]
    {:args [],
     :client :iam,
     :fn :list-virtual-mfadevices,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-virtual-mfadevices,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-virtual-mfadevices
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         max-items
         marker
         assignment-status]}]],
    :doc "Call listVirtualMFADevices, listVirtualMFADevices"}
   [credentials6792 & args6793]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6794
     (com.palletops.awaze.common/aws-client :iam credentials6792)]
    (clojure.core/case
     (clojure.core/count args6793)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6794
       listVirtualMFADevices))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6794
       listVirtualMFADevices
       (list-virtual-mfadevices-request
        (clojure.core/nth args6793 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-role-from-instance-profile
   [m6795]
   (clojure.core/let
    [credentials6796 (:credentials m6795) args6797 (:args m6795)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6798
      (com.palletops.awaze.common/aws-client :iam credentials6796)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6798
       removeRoleFromInstanceProfile
       (remove-role-from-instance-profile-request
        (clojure.core/nth args6797 0)))))))
  (clojure.core/defn
   remove-role-from-instance-profile-map
   {:arglists
    '[[credentials
       {:keys
        [role-name request-metric-collector instance-profile-name]}]],
    :doc "Generate map for removeRoleFromInstanceProfile"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :remove-role-from-instance-profile,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   remove-role-from-instance-profile
   {:arglists
    '[[credentials
       {:keys
        [role-name request-metric-collector instance-profile-name]}]],
    :doc "Call removeRoleFromInstanceProfile"}
   [credentials6800 & args6801]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6802
     (com.palletops.awaze.common/aws-client :iam credentials6800)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6802
      removeRoleFromInstanceProfile
      (remove-role-from-instance-profile-request
       (clojure.core/nth args6801 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-signing-certificates
   [m6803]
   (clojure.core/let
    [credentials6804 (:credentials m6803) args6805 (:args m6803)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6806
      (com.palletops.awaze.common/aws-client :iam credentials6804)]
     (clojure.core/case
      (clojure.core/count args6805)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6806
        listSigningCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6806
        listSigningCertificates
        (list-signing-certificates-request
         (clojure.core/nth args6805 0))))))))
  (clojure.core/defn
   list-signing-certificates-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys [user-name request-metric-collector max-items marker]}]],
    :doc
    "Generate map for listSigningCertificates, listSigningCertificates"}
   ([credentials__577__auto__]
    {:args [],
     :client :iam,
     :fn :list-signing-certificates,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-signing-certificates,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-signing-certificates
   {:arglists
    '[[credentials]
      [credentials
       {:keys [user-name request-metric-collector max-items marker]}]],
    :doc "Call listSigningCertificates, listSigningCertificates"}
   [credentials6808 & args6809]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6810
     (com.palletops.awaze.common/aws-client :iam credentials6808)]
    (clojure.core/case
     (clojure.core/count args6809)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6810
       listSigningCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6810
       listSigningCertificates
       (list-signing-certificates-request
        (clojure.core/nth args6809 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-instance-profile
   [m6811]
   (clojure.core/let
    [credentials6812 (:credentials m6811) args6813 (:args m6811)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6814
      (com.palletops.awaze.common/aws-client :iam credentials6812)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6814
       deleteInstanceProfile
       (delete-instance-profile-request
        (clojure.core/nth args6813 0)))))))
  (clojure.core/defn
   delete-instance-profile-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector instance-profile-name]}]],
    :doc "Generate map for deleteInstanceProfile"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-instance-profile,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-instance-profile
   {:arglists
    '[[credentials
       {:keys [request-metric-collector instance-profile-name]}]],
    :doc "Call deleteInstanceProfile"}
   [credentials6816 & args6817]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6818
     (com.palletops.awaze.common/aws-client :iam credentials6816)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6818
      deleteInstanceProfile
      (delete-instance-profile-request
       (clojure.core/nth args6817 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-mfadevices
   [m6819]
   (clojure.core/let
    [credentials6820 (:credentials m6819) args6821 (:args m6819)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6822
      (com.palletops.awaze.common/aws-client :iam credentials6820)]
     (clojure.core/case
      (clojure.core/count args6821)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6822
        listMFADevices
        (list-mfadevices-request (clojure.core/nth args6821 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6822
        listMFADevices))))))
  (clojure.core/defn
   list-mfadevices-map
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector max-items marker]}]
      [credentials]],
    :doc "Generate map for listMFADevices, listMFADevices"}
   ([credentials__577__auto__]
    {:args [],
     :client :iam,
     :fn :list-mfadevices,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-mfadevices,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-mfadevices
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector max-items marker]}]
      [credentials]],
    :doc "Call listMFADevices, listMFADevices"}
   [credentials6824 & args6825]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6826
     (com.palletops.awaze.common/aws-client :iam credentials6824)]
    (clojure.core/case
     (clojure.core/count args6825)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6826
       listMFADevices
       (list-mfadevices-request (clojure.core/nth args6825 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6826
       listMFADevices))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user-policy
   [m6827]
   (clojure.core/let
    [credentials6828 (:credentials m6827) args6829 (:args m6827)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6830
      (com.palletops.awaze.common/aws-client :iam credentials6828)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6830
       deleteUserPolicy
       (delete-user-policy-request (clojure.core/nth args6829 0)))))))
  (clojure.core/defn
   delete-user-policy-map
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector policy-name]}]],
    :doc "Generate map for deleteUserPolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-user-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-user-policy
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector policy-name]}]],
    :doc "Call deleteUserPolicy"}
   [credentials6832 & args6833]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6834
     (com.palletops.awaze.common/aws-client :iam credentials6832)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6834
      deleteUserPolicy
      (delete-user-policy-request (clojure.core/nth args6833 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-account-alias
   [m6835]
   (clojure.core/let
    [credentials6836 (:credentials m6835) args6837 (:args m6835)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6838
      (com.palletops.awaze.common/aws-client :iam credentials6836)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6838
       createAccountAlias
       (create-account-alias-request
        (clojure.core/nth args6837 0)))))))
  (clojure.core/defn
   create-account-alias-map
   {:arglists
    '[[credentials {:keys [request-metric-collector account-alias]}]],
    :doc "Generate map for createAccountAlias"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-account-alias,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-account-alias
   {:arglists
    '[[credentials {:keys [request-metric-collector account-alias]}]],
    :doc "Call createAccountAlias"}
   [credentials6840 & args6841]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6842
     (com.palletops.awaze.common/aws-client :iam credentials6840)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6842
      createAccountAlias
      (create-account-alias-request (clojure.core/nth args6841 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-signing-certificate
   [m6843]
   (clojure.core/let
    [credentials6844 (:credentials m6843) args6845 (:args m6843)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6846
      (com.palletops.awaze.common/aws-client :iam credentials6844)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6846
       updateSigningCertificate
       (update-signing-certificate-request
        (clojure.core/nth args6845 0)))))))
  (clojure.core/defn
   update-signing-certificate-map
   {:arglists
    '[[credentials
       {:keys
        [user-name status request-metric-collector certificate-id]}]],
    :doc "Generate map for updateSigningCertificate"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-signing-certificate,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-signing-certificate
   {:arglists
    '[[credentials
       {:keys
        [user-name status request-metric-collector certificate-id]}]],
    :doc "Call updateSigningCertificate"}
   [credentials6848 & args6849]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6850
     (com.palletops.awaze.common/aws-client :iam credentials6848)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6850
      updateSigningCertificate
      (update-signing-certificate-request
       (clojure.core/nth args6849 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-assume-role-policy
   [m6851]
   (clojure.core/let
    [credentials6852 (:credentials m6851) args6853 (:args m6851)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6854
      (com.palletops.awaze.common/aws-client :iam credentials6852)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6854
       updateAssumeRolePolicy
       (update-assume-role-policy-request
        (clojure.core/nth args6853 0)))))))
  (clojure.core/defn
   update-assume-role-policy-map
   {:arglists
    '[[credentials
       {:keys [role-name request-metric-collector policy-document]}]],
    :doc "Generate map for updateAssumeRolePolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-assume-role-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-assume-role-policy
   {:arglists
    '[[credentials
       {:keys [role-name request-metric-collector policy-document]}]],
    :doc "Call updateAssumeRolePolicy"}
   [credentials6856 & args6857]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6858
     (com.palletops.awaze.common/aws-client :iam credentials6856)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6858
      updateAssumeRolePolicy
      (update-assume-role-policy-request
       (clojure.core/nth args6857 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-roles
   [m6859]
   (clojure.core/let
    [credentials6860 (:credentials m6859) args6861 (:args m6859)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6862
      (com.palletops.awaze.common/aws-client :iam credentials6860)]
     (clojure.core/case
      (clojure.core/count args6861)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6862
        listRoles))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6862
        listRoles
        (list-roles-request (clojure.core/nth args6861 0))))))))
  (clojure.core/defn
   list-roles-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector path-prefix max-items marker]}]],
    :doc "Generate map for listRoles, listRoles"}
   ([credentials__577__auto__]
    {:args [],
     :client :iam,
     :fn :list-roles,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-roles,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-roles
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector path-prefix max-items marker]}]],
    :doc "Call listRoles, listRoles"}
   [credentials6864 & args6865]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6866
     (com.palletops.awaze.common/aws-client :iam credentials6864)]
    (clojure.core/case
     (clojure.core/count args6865)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6866
       listRoles))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6866
       listRoles
       (list-roles-request (clojure.core/nth args6865 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-user-policies
   [m6867]
   (clojure.core/let
    [credentials6868 (:credentials m6867) args6869 (:args m6867)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6870
      (com.palletops.awaze.common/aws-client :iam credentials6868)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6870
       listUserPolicies
       (list-user-policies-request (clojure.core/nth args6869 0)))))))
  (clojure.core/defn
   list-user-policies-map
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector max-items marker]}]],
    :doc "Generate map for listUserPolicies"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-user-policies,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-user-policies
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector max-items marker]}]],
    :doc "Call listUserPolicies"}
   [credentials6872 & args6873]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6874
     (com.palletops.awaze.common/aws-client :iam credentials6872)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6874
      listUserPolicies
      (list-user-policies-request (clojure.core/nth args6873 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-login-profile
   [m6875]
   (clojure.core/let
    [credentials6876 (:credentials m6875) args6877 (:args m6875)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6878
      (com.palletops.awaze.common/aws-client :iam credentials6876)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6878
       deleteLoginProfile
       (delete-login-profile-request
        (clojure.core/nth args6877 0)))))))
  (clojure.core/defn
   delete-login-profile-map
   {:arglists
    '[[credentials {:keys [user-name request-metric-collector]}]],
    :doc "Generate map for deleteLoginProfile"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-login-profile,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-login-profile
   {:arglists
    '[[credentials {:keys [user-name request-metric-collector]}]],
    :doc "Call deleteLoginProfile"}
   [credentials6880 & args6881]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6882
     (com.palletops.awaze.common/aws-client :iam credentials6880)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6882
      deleteLoginProfile
      (delete-login-profile-request (clojure.core/nth args6881 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :enable-mfadevice
   [m6883]
   (clojure.core/let
    [credentials6884 (:credentials m6883) args6885 (:args m6883)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6886
      (com.palletops.awaze.common/aws-client :iam credentials6884)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6886
       enableMFADevice
       (enable-mfadevice-request (clojure.core/nth args6885 0)))))))
  (clojure.core/defn
   enable-mfadevice-map
   {:arglists
    '[[credentials
       {:keys
        [user-name
         serial-number
         request-metric-collector
         authentication-code2
         authentication-code1]}]],
    :doc "Generate map for enableMFADevice"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :enable-mfadevice,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   enable-mfadevice
   {:arglists
    '[[credentials
       {:keys
        [user-name
         serial-number
         request-metric-collector
         authentication-code2
         authentication-code1]}]],
    :doc "Call enableMFADevice"}
   [credentials6888 & args6889]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6890
     (com.palletops.awaze.common/aws-client :iam credentials6888)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6890
      enableMFADevice
      (enable-mfadevice-request (clojure.core/nth args6889 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group
   [m6891]
   (clojure.core/let
    [credentials6892 (:credentials m6891) args6893 (:args m6891)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6894
      (com.palletops.awaze.common/aws-client :iam credentials6892)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6894
       getGroup
       (get-group-request (clojure.core/nth args6893 0)))))))
  (clojure.core/defn
   get-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector max-items marker group-name]}]],
    :doc "Generate map for getGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector max-items marker group-name]}]],
    :doc "Call getGroup"}
   [credentials6896 & args6897]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6898
     (com.palletops.awaze.common/aws-client :iam credentials6896)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6898
      getGroup
      (get-group-request (clojure.core/nth args6897 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group-policy
   [m6899]
   (clojure.core/let
    [credentials6900 (:credentials m6899) args6901 (:args m6899)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6902
      (com.palletops.awaze.common/aws-client :iam credentials6900)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6902
       deleteGroupPolicy
       (delete-group-policy-request (clojure.core/nth args6901 0)))))))
  (clojure.core/defn
   delete-group-policy-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector policy-name group-name]}]],
    :doc "Generate map for deleteGroupPolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-group-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-group-policy
   {:arglists
    '[[credentials
       {:keys [request-metric-collector policy-name group-name]}]],
    :doc "Call deleteGroupPolicy"}
   [credentials6904 & args6905]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6906
     (com.palletops.awaze.common/aws-client :iam credentials6904)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6906
      deleteGroupPolicy
      (delete-group-policy-request (clojure.core/nth args6905 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-instance-profile
   [m6907]
   (clojure.core/let
    [credentials6908 (:credentials m6907) args6909 (:args m6907)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6910
      (com.palletops.awaze.common/aws-client :iam credentials6908)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6910
       createInstanceProfile
       (create-instance-profile-request
        (clojure.core/nth args6909 0)))))))
  (clojure.core/defn
   create-instance-profile-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector path instance-profile-name]}]],
    :doc "Generate map for createInstanceProfile"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-instance-profile,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-instance-profile
   {:arglists
    '[[credentials
       {:keys [request-metric-collector path instance-profile-name]}]],
    :doc "Call createInstanceProfile"}
   [credentials6912 & args6913]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6914
     (com.palletops.awaze.common/aws-client :iam credentials6912)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6914
      createInstanceProfile
      (create-instance-profile-request
       (clojure.core/nth args6913 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-user
   [m6915]
   (clojure.core/let
    [credentials6916 (:credentials m6915) args6917 (:args m6915)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6918
      (com.palletops.awaze.common/aws-client :iam credentials6916)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6918
       updateUser
       (update-user-request (clojure.core/nth args6917 0)))))))
  (clojure.core/defn
   update-user-map
   {:arglists
    '[[credentials
       {:keys
        [user-name request-metric-collector new-user-name new-path]}]],
    :doc "Generate map for updateUser"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-user,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-user
   {:arglists
    '[[credentials
       {:keys
        [user-name request-metric-collector new-user-name new-path]}]],
    :doc "Call updateUser"}
   [credentials6920 & args6921]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6922
     (com.palletops.awaze.common/aws-client :iam credentials6920)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6922
      updateUser
      (update-user-request (clojure.core/nth args6921 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-user
   [m6923]
   (clojure.core/let
    [credentials6924 (:credentials m6923) args6925 (:args m6923)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6926
      (com.palletops.awaze.common/aws-client :iam credentials6924)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6926
       createUser
       (create-user-request (clojure.core/nth args6925 0)))))))
  (clojure.core/defn
   create-user-map
   {:arglists
    '[[credentials {:keys [user-name request-metric-collector path]}]],
    :doc "Generate map for createUser"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-user,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-user
   {:arglists
    '[[credentials {:keys [user-name request-metric-collector path]}]],
    :doc "Call createUser"}
   [credentials6928 & args6929]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6930
     (com.palletops.awaze.common/aws-client :iam credentials6928)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6930
      createUser
      (create-user-request (clojure.core/nth args6929 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-role
   [m6931]
   (clojure.core/let
    [credentials6932 (:credentials m6931) args6933 (:args m6931)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6934
      (com.palletops.awaze.common/aws-client :iam credentials6932)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6934
       createRole
       (create-role-request (clojure.core/nth args6933 0)))))))
  (clojure.core/defn
   create-role-map
   {:arglists
    '[[credentials
       {:keys
        [role-name
         request-metric-collector
         path
         assume-role-policy-document]}]],
    :doc "Generate map for createRole"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-role,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-role
   {:arglists
    '[[credentials
       {:keys
        [role-name
         request-metric-collector
         path
         assume-role-policy-document]}]],
    :doc "Call createRole"}
   [credentials6936 & args6937]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6938
     (com.palletops.awaze.common/aws-client :iam credentials6936)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6938
      createRole
      (create-role-request (clojure.core/nth args6937 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user-policy
   [m6939]
   (clojure.core/let
    [credentials6940 (:credentials m6939) args6941 (:args m6939)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6942
      (com.palletops.awaze.common/aws-client :iam credentials6940)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6942
       getUserPolicy
       (get-user-policy-request (clojure.core/nth args6941 0)))))))
  (clojure.core/defn
   get-user-policy-map
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector policy-name]}]],
    :doc "Generate map for getUserPolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-user-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-user-policy
   {:arglists
    '[[credentials
       {:keys [user-name request-metric-collector policy-name]}]],
    :doc "Call getUserPolicy"}
   [credentials6944 & args6945]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6946
     (com.palletops.awaze.common/aws-client :iam credentials6944)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6946
      getUserPolicy
      (get-user-policy-request (clojure.core/nth args6945 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-users
   [m6947]
   (clojure.core/let
    [credentials6948 (:credentials m6947) args6949 (:args m6947)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6950
      (com.palletops.awaze.common/aws-client :iam credentials6948)]
     (clojure.core/case
      (clojure.core/count args6949)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6950
        listUsers))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6950
        listUsers
        (list-users-request (clojure.core/nth args6949 0))))))))
  (clojure.core/defn
   list-users-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector path-prefix max-items marker]}]],
    :doc "Generate map for listUsers, listUsers"}
   ([credentials__577__auto__]
    {:args [],
     :client :iam,
     :fn :list-users,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-users,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-users
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector path-prefix max-items marker]}]],
    :doc "Call listUsers, listUsers"}
   [credentials6952 & args6953]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6954
     (com.palletops.awaze.common/aws-client :iam credentials6952)]
    (clojure.core/case
     (clojure.core/count args6953)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6954
       listUsers))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client6954
       listUsers
       (list-users-request (clojure.core/nth args6953 0)))))))))
