(ns com.palletops.awaze.elasticmapreduce (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticmapreduce
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.MarketType market-type
  [m2519]
  (java.lang.Enum/valueOf
   com.amazonaws.services.elasticmapreduce.model.MarketType
   (clojure.core/name m2519)))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.InstanceRoleType instance-role-type
  [m2522]
  (java.lang.Enum/valueOf
   com.amazonaws.services.elasticmapreduce.model.InstanceRoleType
   (clojure.core/name m2522)))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.KeyValue key-value
  [m2525]
  (clojure.core/let
   [bean2524
    (new com.amazonaws.services.elasticmapreduce.model.KeyValue)]
   (clojure.core/when-let
    [v2526 (:value m2525)]
    (. bean2524 setValue (clojure.core/str v2526)))
   (clojure.core/when-let
    [v2526 (:key m2525)]
    (. bean2524 setKey (clojure.core/str v2526)))
   bean2524))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig instance-group-config
  [m2528]
  (clojure.core/let
   [bean2527
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig)]
   (clojure.core/when-let
    [v2529 (:name m2528)]
    (. bean2527 setName (clojure.core/str v2529)))
   (clojure.core/when-let
    [v2529 (:instance-type m2528)]
    (. bean2527 setInstanceType (clojure.core/str v2529)))
   (clojure.core/when-let
    [v2529 (:instance-count m2528)]
    (. bean2527 setInstanceCount (clojure.core/int v2529)))
   (clojure.core/when-let
    [v2529 (:market m2528)]
    (. bean2527 setMarket (market-type v2529)))
   (clojure.core/when-let
    [v2529 (:market m2528)]
    (. bean2527 setMarket (clojure.core/str v2529)))
   (clojure.core/when-let
    [v2529 (:instance-role m2528)]
    (. bean2527 setInstanceRole (instance-role-type v2529)))
   (clojure.core/when-let
    [v2529 (:instance-role m2528)]
    (. bean2527 setInstanceRole (clojure.core/str v2529)))
   (clojure.core/when-let
    [v2529 (:bid-price m2528)]
    (. bean2527 setBidPrice (clojure.core/str v2529)))
   bean2527))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.PlacementType placement-type
  [m2531]
  (clojure.core/let
   [bean2530
    (new com.amazonaws.services.elasticmapreduce.model.PlacementType)]
   (clojure.core/when-let
    [v2532 (:availability-zone m2531)]
    (. bean2530 setAvailabilityZone (clojure.core/str v2532)))
   bean2530))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ActionOnFailure action-on-failure
  [m2534]
  (java.lang.Enum/valueOf
   com.amazonaws.services.elasticmapreduce.model.ActionOnFailure
   (clojure.core/name m2534)))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig hadoop-jar-step-config
  [m2537]
  (clojure.core/let
   [bean2536
    (new
     com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig)]
   (clojure.core/when-let
    [v2538 (:properties m2537)]
    (.
     bean2536
     setProperties
     (clojure.core/map
      (clojure.core/fn [arg2539] (key-value arg2539))
      v2538)))
   (clojure.core/when-let
    [v2538 (:args m2537)]
    (.
     bean2536
     setArgs
     (clojure.core/map
      (clojure.core/fn [arg2540] (clojure.core/str arg2540))
      v2538)))
   (clojure.core/when-let
    [v2538 (:jar m2537)]
    (. bean2536 setJar (clojure.core/str v2538)))
   (clojure.core/when-let
    [v2538 (:main-class m2537)]
    (. bean2536 setMainClass (clojure.core/str v2538)))
   bean2536))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig script-bootstrap-action-config
  [m2542]
  (clojure.core/let
   [bean2541
    (new
     com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig)]
   (clojure.core/when-let
    [v2543 (:args m2542)]
    (.
     bean2541
     setArgs
     (clojure.core/map
      (clojure.core/fn [arg2544] (clojure.core/str arg2544))
      v2543)))
   (clojure.core/when-let
    [v2543 (:path m2542)]
    (. bean2541 setPath (clojure.core/str v2543)))
   bean2541))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig job-flow-instances-config
  [m2546]
  (clojure.core/let
   [bean2545
    (new
     com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig)]
   (clojure.core/when-let
    [v2547 (:termination-protected m2546)]
    (. bean2545 setTerminationProtected (clojure.core/boolean v2547)))
   (clojure.core/when-let
    [v2547 (:instance-groups m2546)]
    (.
     bean2545
     setInstanceGroups
     (clojure.core/map
      (clojure.core/fn [arg2548] (instance-group-config arg2548))
      v2547)))
   (clojure.core/when-let
    [v2547 (:master-instance-type m2546)]
    (. bean2545 setMasterInstanceType (clojure.core/str v2547)))
   (clojure.core/when-let
    [v2547 (:slave-instance-type m2546)]
    (. bean2545 setSlaveInstanceType (clojure.core/str v2547)))
   (clojure.core/when-let
    [v2547 (:instance-count m2546)]
    (. bean2545 setInstanceCount (clojure.core/int v2547)))
   (clojure.core/when-let
    [v2547 (:ec2key-name m2546)]
    (. bean2545 setEc2KeyName (clojure.core/str v2547)))
   (clojure.core/when-let
    [v2547 (:placement m2546)]
    (. bean2545 setPlacement (placement-type v2547)))
   (clojure.core/when-let
    [v2547 (:keep-job-flow-alive-when-no-steps m2546)]
    (.
     bean2545
     setKeepJobFlowAliveWhenNoSteps
     (clojure.core/boolean v2547)))
   (clojure.core/when-let
    [v2547 (:hadoop-version m2546)]
    (. bean2545 setHadoopVersion (clojure.core/str v2547)))
   (clojure.core/when-let
    [v2547 (:ec2subnet-id m2546)]
    (. bean2545 setEc2SubnetId (clojure.core/str v2547)))
   bean2545))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.StepConfig step-config
  [m2550]
  (clojure.core/let
   [bean2549
    (new com.amazonaws.services.elasticmapreduce.model.StepConfig)]
   (clojure.core/when-let
    [v2551 (:name m2550)]
    (. bean2549 setName (clojure.core/str v2551)))
   (clojure.core/when-let
    [v2551 (:action-on-failure m2550)]
    (. bean2549 setActionOnFailure (action-on-failure v2551)))
   (clojure.core/when-let
    [v2551 (:action-on-failure m2550)]
    (. bean2549 setActionOnFailure (clojure.core/str v2551)))
   (clojure.core/when-let
    [v2551 (:hadoop-jar-step m2550)]
    (. bean2549 setHadoopJarStep (hadoop-jar-step-config v2551)))
   bean2549))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig bootstrap-action-config
  [m2553]
  (clojure.core/let
   [bean2552
    (new
     com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig)]
   (clojure.core/when-let
    [v2554 (:name m2553)]
    (. bean2552 setName (clojure.core/str v2554)))
   (clojure.core/when-let
    [v2554 (:script-bootstrap-action m2553)]
    (.
     bean2552
     setScriptBootstrapAction
     (script-bootstrap-action-config v2554)))
   bean2552))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig supported-product-config
  [m2556]
  (clojure.core/let
   [bean2555
    (new
     com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig)]
   (clojure.core/when-let
    [v2557 (:name m2556)]
    (. bean2555 setName (clojure.core/str v2557)))
   (clojure.core/when-let
    [v2557 (:args m2556)]
    (.
     bean2555
     setArgs
     (clojure.core/map
      (clojure.core/fn [arg2558] (clojure.core/str arg2558))
      v2557)))
   bean2555))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig instance-group-modify-config
  [m2560]
  (clojure.core/let
   [bean2559
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig)]
   (clojure.core/when-let
    [v2561 (:instance-group-id m2560)]
    (. bean2559 setInstanceGroupId (clojure.core/str v2561)))
   (clojure.core/when-let
    [v2561 (:instance-count m2560)]
    (. bean2559 setInstanceCount (clojure.core/int v2561)))
   (clojure.core/when-let
    [v2561 (:ec2instance-ids-to-terminate m2560)]
    (.
     bean2559
     setEC2InstanceIdsToTerminate
     (clojure.core/map
      (clojure.core/fn [arg2562] (clojure.core/str arg2562))
      v2561)))
   bean2559))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest run-job-flow-request
  [m2564]
  (clojure.core/let
   [bean2563
    (new
     com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest)]
   (clojure.core/when-let
    [v2565 (:name m2564)]
    (. bean2563 setName (clojure.core/str v2565)))
   (clojure.core/when-let
    [v2565 (:visible-to-all-users m2564)]
    (. bean2563 setVisibleToAllUsers (clojure.core/boolean v2565)))
   (clojure.core/when-let
    [v2565 (:log-uri m2564)]
    (. bean2563 setLogUri (clojure.core/str v2565)))
   (clojure.core/when-let
    [v2565 (:additional-info m2564)]
    (. bean2563 setAdditionalInfo (clojure.core/str v2565)))
   (clojure.core/when-let
    [v2565 (:ami-version m2564)]
    (. bean2563 setAmiVersion (clojure.core/str v2565)))
   (clojure.core/when-let
    [v2565 (:instances m2564)]
    (. bean2563 setInstances (job-flow-instances-config v2565)))
   (clojure.core/when-let
    [v2565 (:steps m2564)]
    (.
     bean2563
     setSteps
     (clojure.core/map
      (clojure.core/fn [arg2566] (step-config arg2566))
      v2565)))
   (clojure.core/when-let
    [v2565 (:bootstrap-actions m2564)]
    (.
     bean2563
     setBootstrapActions
     (clojure.core/map
      (clojure.core/fn [arg2567] (bootstrap-action-config arg2567))
      v2565)))
   (clojure.core/when-let
    [v2565 (:supported-products m2564)]
    (.
     bean2563
     setSupportedProducts
     (clojure.core/map
      (clojure.core/fn [arg2568] (clojure.core/str arg2568))
      v2565)))
   (clojure.core/when-let
    [v2565 (:new-supported-products m2564)]
    (.
     bean2563
     setNewSupportedProducts
     (clojure.core/map
      (clojure.core/fn [arg2569] (supported-product-config arg2569))
      v2565)))
   (clojure.core/when-let
    [v2565 (:job-flow-role m2564)]
    (. bean2563 setJobFlowRole (clojure.core/str v2565)))
   bean2563))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest list-bootstrap-actions-request
  [m2571]
  (clojure.core/let
   [bean2570
    (new
     com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest)]
   (clojure.core/when-let
    [v2572 (:marker m2571)]
    (. bean2570 setMarker (clojure.core/str v2572)))
   (clojure.core/when-let
    [v2572 (:cluster-id m2571)]
    (. bean2570 setClusterId (clojure.core/str v2572)))
   bean2570))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest list-instance-groups-request
  [m2574]
  (clojure.core/let
   [bean2573
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest)]
   (clojure.core/when-let
    [v2575 (:marker m2574)]
    (. bean2573 setMarker (clojure.core/str v2575)))
   (clojure.core/when-let
    [v2575 (:cluster-id m2574)]
    (. bean2573 setClusterId (clojure.core/str v2575)))
   bean2573))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest set-visible-to-all-users-request
  [m2577]
  (clojure.core/let
   [bean2576
    (new
     com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest)]
   (clojure.core/when-let
    [v2578 (:visible-to-all-users m2577)]
    (. bean2576 setVisibleToAllUsers (clojure.core/boolean v2578)))
   (clojure.core/when-let
    [v2578 (:job-flow-ids m2577)]
    (.
     bean2576
     setJobFlowIds
     (clojure.core/map
      (clojure.core/fn [arg2579] (clojure.core/str arg2579))
      v2578)))
   bean2576))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest modify-instance-groups-request
  [m2581]
  (clojure.core/let
   [bean2580
    (new
     com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest)]
   (clojure.core/when-let
    [v2582 (:instance-groups m2581)]
    (.
     bean2580
     setInstanceGroups
     (clojure.core/map
      (clojure.core/fn
       [arg2583]
       (instance-group-modify-config arg2583))
      v2582)))
   bean2580))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest describe-cluster-request
  [m2585]
  (clojure.core/let
   [bean2584
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest)]
   (clojure.core/when-let
    [v2586 (:cluster-id m2585)]
    (. bean2584 setClusterId (clojure.core/str v2586)))
   bean2584))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest set-termination-protection-request
  [m2588]
  (clojure.core/let
   [bean2587
    (new
     com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest)]
   (clojure.core/when-let
    [v2589 (:job-flow-ids m2588)]
    (.
     bean2587
     setJobFlowIds
     (clojure.core/map
      (clojure.core/fn [arg2590] (clojure.core/str arg2590))
      v2589)))
   (clojure.core/when-let
    [v2589 (:termination-protected m2588)]
    (. bean2587 setTerminationProtected (clojure.core/boolean v2589)))
   bean2587))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest add-instance-groups-request
  [m2592]
  (clojure.core/let
   [bean2591
    (new
     com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest)]
   (clojure.core/when-let
    [v2593 (:instance-groups m2592)]
    (.
     bean2591
     setInstanceGroups
     (clojure.core/map
      (clojure.core/fn [arg2594] (instance-group-config arg2594))
      v2593)))
   (clojure.core/when-let
    [v2593 (:job-flow-id m2592)]
    (. bean2591 setJobFlowId (clojure.core/str v2593)))
   bean2591))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest describe-step-request
  [m2596]
  (clojure.core/let
   [bean2595
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest)]
   (clojure.core/when-let
    [v2597 (:cluster-id m2596)]
    (. bean2595 setClusterId (clojure.core/str v2597)))
   (clojure.core/when-let
    [v2597 (:step-id m2596)]
    (. bean2595 setStepId (clojure.core/str v2597)))
   bean2595))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest terminate-job-flows-request
  [m2599]
  (clojure.core/let
   [bean2598
    (new
     com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest)]
   (clojure.core/when-let
    [v2600 (:job-flow-ids m2599)]
    (.
     bean2598
     setJobFlowIds
     (clojure.core/map
      (clojure.core/fn [arg2601] (clojure.core/str arg2601))
      v2600)))
   bean2598))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest list-instances-request
  [m2603]
  (clojure.core/let
   [bean2602
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest)]
   (clojure.core/when-let
    [v2604 (:marker m2603)]
    (. bean2602 setMarker (clojure.core/str v2604)))
   (clojure.core/when-let
    [v2604 (:cluster-id m2603)]
    (. bean2602 setClusterId (clojure.core/str v2604)))
   (clojure.core/when-let
    [v2604 (:instance-group-id m2603)]
    (. bean2602 setInstanceGroupId (clojure.core/str v2604)))
   (clojure.core/when-let
    [v2604 (:instance-group-types m2603)]
    (.
     bean2602
     setInstanceGroupTypes
     (clojure.core/map
      (clojure.core/fn [arg2605] (clojure.core/str arg2605))
      v2604)))
   bean2602))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ListClustersRequest list-clusters-request
  [m2607]
  (clojure.core/let
   [bean2606
    (new
     com.amazonaws.services.elasticmapreduce.model.ListClustersRequest)]
   (clojure.core/when-let
    [v2608 (:marker m2607)]
    (. bean2606 setMarker (clojure.core/str v2608)))
   (clojure.core/when-let
    [v2608 (:created-after m2607)]
    (.
     bean2606
     setCreatedAfter
     (com.palletops.awaze.common/to-date v2608)))
   (clojure.core/when-let
    [v2608 (:created-before m2607)]
    (.
     bean2606
     setCreatedBefore
     (com.palletops.awaze.common/to-date v2608)))
   (clojure.core/when-let
    [v2608 (:cluster-states m2607)]
    (.
     bean2606
     setClusterStates
     (clojure.core/map
      (clojure.core/fn [arg2609] (clojure.core/str arg2609))
      v2608)))
   bean2606))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest add-job-flow-steps-request
  [m2611]
  (clojure.core/let
   [bean2610
    (new
     com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest)]
   (clojure.core/when-let
    [v2612 (:steps m2611)]
    (.
     bean2610
     setSteps
     (clojure.core/map
      (clojure.core/fn [arg2613] (step-config arg2613))
      v2612)))
   (clojure.core/when-let
    [v2612 (:job-flow-id m2611)]
    (. bean2610 setJobFlowId (clojure.core/str v2612)))
   bean2610))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ListStepsRequest list-steps-request
  [m2615]
  (clojure.core/let
   [bean2614
    (new
     com.amazonaws.services.elasticmapreduce.model.ListStepsRequest)]
   (clojure.core/when-let
    [v2616 (:marker m2615)]
    (. bean2614 setMarker (clojure.core/str v2616)))
   (clojure.core/when-let
    [v2616 (:cluster-id m2615)]
    (. bean2614 setClusterId (clojure.core/str v2616)))
   (clojure.core/when-let
    [v2616 (:step-states m2615)]
    (.
     bean2614
     setStepStates
     (clojure.core/map
      (clojure.core/fn [arg2617] (clojure.core/str arg2617))
      v2616)))
   bean2614))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest describe-job-flows-request
  [m2619]
  (clojure.core/let
   [bean2618
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest)]
   (clojure.core/when-let
    [v2620 (:job-flow-ids m2619)]
    (.
     bean2618
     setJobFlowIds
     (clojure.core/map
      (clojure.core/fn [arg2621] (clojure.core/str arg2621))
      v2620)))
   (clojure.core/when-let
    [v2620 (:created-after m2619)]
    (.
     bean2618
     setCreatedAfter
     (com.palletops.awaze.common/to-date v2620)))
   (clojure.core/when-let
    [v2620 (:created-before m2619)]
    (.
     bean2618
     setCreatedBefore
     (com.palletops.awaze.common/to-date v2620)))
   (clojure.core/when-let
    [v2620 (:job-flow-states m2619)]
    (.
     bean2618
     setJobFlowStates
     (clojure.core/map
      (clojure.core/fn [arg2622] (clojure.core/str arg2622))
      v2620)))
   bean2618))
 (clojure.core/defmulti
  elasticmapreduce
  (clojure.core/fn
   elasticmapreduce
   [m__609__auto__]
   (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :run-job-flow
   [m2623]
   (clojure.core/let
    [credentials2624 (:credentials m2623) args2625 (:args m2623)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2626
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials2624)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2626
       runJobFlow
       (run-job-flow-request (clojure.core/nth args2625 0)))))))
  (clojure.core/defn
   run-job-flow-map
   {:arglists
    '[[credentials
       {:keys
        [job-flow-role
         request-metric-collector
         additional-info
         name
         log-uri
         bootstrap-actions
         visible-to-all-users
         supported-products
         ami-version
         steps
         new-supported-products
         instances]}]],
    :doc "Generate map for runJobFlow"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :run-job-flow,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   run-job-flow
   {:arglists
    '[[credentials
       {:keys
        [job-flow-role
         request-metric-collector
         additional-info
         name
         log-uri
         bootstrap-actions
         visible-to-all-users
         supported-products
         ami-version
         steps
         new-supported-products
         instances]}]],
    :doc "Call runJobFlow"}
   [credentials2628 & args2629]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2630
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials2628)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2630
      runJobFlow
      (run-job-flow-request (clojure.core/nth args2629 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-bootstrap-actions
   [m2631]
   (clojure.core/let
    [credentials2632 (:credentials m2631) args2633 (:args m2631)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2634
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials2632)]
     (clojure.core/case
      (clojure.core/count args2633)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2634
        listBootstrapActions
        (list-bootstrap-actions-request
         (clojure.core/nth args2633 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2634
        listBootstrapActions))))))
  (clojure.core/defn
   list-bootstrap-actions-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector marker cluster-id]}]
      [credentials]],
    :doc "Generate map for listBootstrapActions, listBootstrapActions"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :list-bootstrap-actions,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-bootstrap-actions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-bootstrap-actions
   {:arglists
    '[[credentials
       {:keys [request-metric-collector marker cluster-id]}]
      [credentials]],
    :doc "Call listBootstrapActions, listBootstrapActions"}
   [credentials2636 & args2637]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2638
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials2636)]
    (clojure.core/case
     (clojure.core/count args2637)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2638
       listBootstrapActions
       (list-bootstrap-actions-request (clojure.core/nth args2637 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2638
       listBootstrapActions))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instance-groups
   [m2639]
   (clojure.core/let
    [credentials2640 (:credentials m2639) args2641 (:args m2639)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2642
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials2640)]
     (clojure.core/case
      (clojure.core/count args2641)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2642
        listInstanceGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2642
        listInstanceGroups
        (list-instance-groups-request
         (clojure.core/nth args2641 0))))))))
  (clojure.core/defn
   list-instance-groups-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys [request-metric-collector marker cluster-id]}]],
    :doc "Generate map for listInstanceGroups, listInstanceGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :list-instance-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-instance-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-instance-groups
   {:arglists
    '[[credentials]
      [credentials
       {:keys [request-metric-collector marker cluster-id]}]],
    :doc "Call listInstanceGroups, listInstanceGroups"}
   [credentials2644 & args2645]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2646
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials2644)]
    (clojure.core/case
     (clojure.core/count args2645)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2646
       listInstanceGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2646
       listInstanceGroups
       (list-instance-groups-request
        (clojure.core/nth args2645 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-visible-to-all-users
   [m2647]
   (clojure.core/let
    [credentials2648 (:credentials m2647) args2649 (:args m2647)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2650
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials2648)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2650
       setVisibleToAllUsers
       (set-visible-to-all-users-request
        (clojure.core/nth args2649 0)))))))
  (clojure.core/defn
   set-visible-to-all-users-map
   {:arglists
    '[[credentials
       {:keys
        [visible-to-all-users
         request-metric-collector
         job-flow-ids]}]],
    :doc "Generate map for setVisibleToAllUsers"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :set-visible-to-all-users,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-visible-to-all-users
   {:arglists
    '[[credentials
       {:keys
        [visible-to-all-users
         request-metric-collector
         job-flow-ids]}]],
    :doc "Call setVisibleToAllUsers"}
   [credentials2652 & args2653]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2654
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials2652)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2654
      setVisibleToAllUsers
      (set-visible-to-all-users-request
       (clojure.core/nth args2653 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :modify-instance-groups
   [m2655]
   (clojure.core/let
    [credentials2656 (:credentials m2655) args2657 (:args m2655)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2658
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials2656)]
     (clojure.core/case
      (clojure.core/count args2657)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2658
        modifyInstanceGroups
        (modify-instance-groups-request
         (clojure.core/nth args2657 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2658
        modifyInstanceGroups))))))
  (clojure.core/defn
   modify-instance-groups-map
   {:arglists
    '[[credentials {:keys [request-metric-collector instance-groups]}]
      [credentials]],
    :doc "Generate map for modifyInstanceGroups, modifyInstanceGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :modify-instance-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :modify-instance-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-instance-groups
   {:arglists
    '[[credentials {:keys [request-metric-collector instance-groups]}]
      [credentials]],
    :doc "Call modifyInstanceGroups, modifyInstanceGroups"}
   [credentials2660 & args2661]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2662
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials2660)]
    (clojure.core/case
     (clojure.core/count args2661)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2662
       modifyInstanceGroups
       (modify-instance-groups-request (clojure.core/nth args2661 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2662
       modifyInstanceGroups))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-cluster
   [m2663]
   (clojure.core/let
    [credentials2664 (:credentials m2663) args2665 (:args m2663)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2666
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials2664)]
     (clojure.core/case
      (clojure.core/count args2665)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2666
        describeCluster
        (describe-cluster-request (clojure.core/nth args2665 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2666
        describeCluster))))))
  (clojure.core/defn
   describe-cluster-map
   {:arglists
    '[[credentials {:keys [request-metric-collector cluster-id]}]
      [credentials]],
    :doc "Generate map for describeCluster, describeCluster"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :describe-cluster,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :describe-cluster,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-cluster
   {:arglists
    '[[credentials {:keys [request-metric-collector cluster-id]}]
      [credentials]],
    :doc "Call describeCluster, describeCluster"}
   [credentials2668 & args2669]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2670
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials2668)]
    (clojure.core/case
     (clojure.core/count args2669)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2670
       describeCluster
       (describe-cluster-request (clojure.core/nth args2669 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2670
       describeCluster))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-termination-protection
   [m2671]
   (clojure.core/let
    [credentials2672 (:credentials m2671) args2673 (:args m2671)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2674
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials2672)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2674
       setTerminationProtection
       (set-termination-protection-request
        (clojure.core/nth args2673 0)))))))
  (clojure.core/defn
   set-termination-protection-map
   {:arglists
    '[[credentials
       {:keys
        [termination-protected
         request-metric-collector
         job-flow-ids]}]],
    :doc "Generate map for setTerminationProtection"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :set-termination-protection,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-termination-protection
   {:arglists
    '[[credentials
       {:keys
        [termination-protected
         request-metric-collector
         job-flow-ids]}]],
    :doc "Call setTerminationProtection"}
   [credentials2676 & args2677]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2678
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials2676)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2678
      setTerminationProtection
      (set-termination-protection-request
       (clojure.core/nth args2677 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-instance-groups
   [m2679]
   (clojure.core/let
    [credentials2680 (:credentials m2679) args2681 (:args m2679)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2682
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials2680)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2682
       addInstanceGroups
       (add-instance-groups-request (clojure.core/nth args2681 0)))))))
  (clojure.core/defn
   add-instance-groups-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector job-flow-id instance-groups]}]],
    :doc "Generate map for addInstanceGroups"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :add-instance-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   add-instance-groups
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector job-flow-id instance-groups]}]],
    :doc "Call addInstanceGroups"}
   [credentials2684 & args2685]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2686
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials2684)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2686
      addInstanceGroups
      (add-instance-groups-request (clojure.core/nth args2685 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-step
   [m2687]
   (clojure.core/let
    [credentials2688 (:credentials m2687) args2689 (:args m2687)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2690
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials2688)]
     (clojure.core/case
      (clojure.core/count args2689)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2690
        describeStep
        (describe-step-request (clojure.core/nth args2689 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2690
        describeStep))))))
  (clojure.core/defn
   describe-step-map
   {:arglists
    '[[credentials
       {:keys [step-id request-metric-collector cluster-id]}]
      [credentials]],
    :doc "Generate map for describeStep, describeStep"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :describe-step,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :describe-step,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-step
   {:arglists
    '[[credentials
       {:keys [step-id request-metric-collector cluster-id]}]
      [credentials]],
    :doc "Call describeStep, describeStep"}
   [credentials2692 & args2693]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2694
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials2692)]
    (clojure.core/case
     (clojure.core/count args2693)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2694
       describeStep
       (describe-step-request (clojure.core/nth args2693 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2694
       describeStep))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :terminate-job-flows
   [m2695]
   (clojure.core/let
    [credentials2696 (:credentials m2695) args2697 (:args m2695)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2698
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials2696)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2698
       terminateJobFlows
       (terminate-job-flows-request (clojure.core/nth args2697 0)))))))
  (clojure.core/defn
   terminate-job-flows-map
   {:arglists
    '[[credentials {:keys [request-metric-collector job-flow-ids]}]],
    :doc "Generate map for terminateJobFlows"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :terminate-job-flows,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   terminate-job-flows
   {:arglists
    '[[credentials {:keys [request-metric-collector job-flow-ids]}]],
    :doc "Call terminateJobFlows"}
   [credentials2700 & args2701]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2702
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials2700)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2702
      terminateJobFlows
      (terminate-job-flows-request (clojure.core/nth args2701 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instances
   [m2703]
   (clojure.core/let
    [credentials2704 (:credentials m2703) args2705 (:args m2703)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2706
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials2704)]
     (clojure.core/case
      (clojure.core/count args2705)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2706
        listInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2706
        listInstances
        (list-instances-request (clojure.core/nth args2705 0))))))))
  (clojure.core/defn
   list-instances-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         marker
         instance-group-types
         instance-group-id
         cluster-id]}]],
    :doc "Generate map for listInstances, listInstances"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :list-instances,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-instances,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-instances
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         marker
         instance-group-types
         instance-group-id
         cluster-id]}]],
    :doc "Call listInstances, listInstances"}
   [credentials2708 & args2709]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2710
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials2708)]
    (clojure.core/case
     (clojure.core/count args2709)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2710
       listInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2710
       listInstances
       (list-instances-request (clojure.core/nth args2709 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-clusters
   [m2711]
   (clojure.core/let
    [credentials2712 (:credentials m2711) args2713 (:args m2711)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2714
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials2712)]
     (clojure.core/case
      (clojure.core/count args2713)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2714
        listClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2714
        listClusters
        (list-clusters-request (clojure.core/nth args2713 0))))))))
  (clojure.core/defn
   list-clusters-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         marker
         created-before
         created-after
         cluster-states]}]],
    :doc "Generate map for listClusters, listClusters"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :list-clusters,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-clusters,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-clusters
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         marker
         created-before
         created-after
         cluster-states]}]],
    :doc "Call listClusters, listClusters"}
   [credentials2716 & args2717]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2718
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials2716)]
    (clojure.core/case
     (clojure.core/count args2717)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2718
       listClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2718
       listClusters
       (list-clusters-request (clojure.core/nth args2717 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-job-flow-steps
   [m2719]
   (clojure.core/let
    [credentials2720 (:credentials m2719) args2721 (:args m2719)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2722
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials2720)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2722
       addJobFlowSteps
       (add-job-flow-steps-request (clojure.core/nth args2721 0)))))))
  (clojure.core/defn
   add-job-flow-steps-map
   {:arglists
    '[[credentials
       {:keys [steps request-metric-collector job-flow-id]}]],
    :doc "Generate map for addJobFlowSteps"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :add-job-flow-steps,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   add-job-flow-steps
   {:arglists
    '[[credentials
       {:keys [steps request-metric-collector job-flow-id]}]],
    :doc "Call addJobFlowSteps"}
   [credentials2724 & args2725]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2726
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials2724)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2726
      addJobFlowSteps
      (add-job-flow-steps-request (clojure.core/nth args2725 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-steps
   [m2727]
   (clojure.core/let
    [credentials2728 (:credentials m2727) args2729 (:args m2727)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2730
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials2728)]
     (clojure.core/case
      (clojure.core/count args2729)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2730
        listSteps))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2730
        listSteps
        (list-steps-request (clojure.core/nth args2729 0))))))))
  (clojure.core/defn
   list-steps-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [step-states request-metric-collector marker cluster-id]}]],
    :doc "Generate map for listSteps, listSteps"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :list-steps,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-steps,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-steps
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [step-states request-metric-collector marker cluster-id]}]],
    :doc "Call listSteps, listSteps"}
   [credentials2732 & args2733]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2734
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials2732)]
    (clojure.core/case
     (clojure.core/count args2733)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2734
       listSteps))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2734
       listSteps
       (list-steps-request (clojure.core/nth args2733 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-job-flows
   [m2735]
   (clojure.core/let
    [credentials2736 (:credentials m2735) args2737 (:args m2735)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2738
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials2736)]
     (clojure.core/case
      (clojure.core/count args2737)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2738
        describeJobFlows
        (describe-job-flows-request (clojure.core/nth args2737 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2738
        describeJobFlows))))))
  (clojure.core/defn
   describe-job-flows-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         job-flow-states
         job-flow-ids
         created-before
         created-after]}]
      [credentials]],
    :doc "Generate map for describeJobFlows, describeJobFlows"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :describe-job-flows,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :describe-job-flows,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-job-flows
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         job-flow-states
         job-flow-ids
         created-before
         created-after]}]
      [credentials]],
    :doc "Call describeJobFlows, describeJobFlows"}
   [credentials2740 & args2741]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2742
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials2740)]
    (clojure.core/case
     (clojure.core/count args2741)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2742
       describeJobFlows
       (describe-job-flows-request (clojure.core/nth args2741 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client2742
       describeJobFlows)))))))
