(ns com.palletops.awaze.elasticloadbalancing (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticloadbalancing
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.Instance instance
  [m2876]
  (clojure.core/let
   [bean2875
    (new com.amazonaws.services.elasticloadbalancing.model.Instance)]
   (clojure.core/when-let
    [v2877 (:instance-id m2876)]
    (. bean2875 setInstanceId (clojure.core/str v2877)))
   bean2875))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute policy-attribute
  [m2879]
  (clojure.core/let
   [bean2878
    (new
     com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute)]
   (clojure.core/when-let
    [v2880 (:attribute-name m2879)]
    (. bean2878 setAttributeName (clojure.core/str v2880)))
   (clojure.core/when-let
    [v2880 (:attribute-value m2879)]
    (. bean2878 setAttributeValue (clojure.core/str v2880)))
   bean2878))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.HealthCheck health-check
  [m2882]
  (clojure.core/let
   [bean2881
    (new
     com.amazonaws.services.elasticloadbalancing.model.HealthCheck)]
   (clojure.core/when-let
    [v2883 (:target m2882)]
    (. bean2881 setTarget (clojure.core/str v2883)))
   (clojure.core/when-let
    [v2883 (:interval m2882)]
    (. bean2881 setInterval (clojure.core/int v2883)))
   (clojure.core/when-let
    [v2883 (:timeout m2882)]
    (. bean2881 setTimeout (clojure.core/int v2883)))
   (clojure.core/when-let
    [v2883 (:unhealthy-threshold m2882)]
    (. bean2881 setUnhealthyThreshold (clojure.core/int v2883)))
   (clojure.core/when-let
    [v2883 (:healthy-threshold m2882)]
    (. bean2881 setHealthyThreshold (clojure.core/int v2883)))
   bean2881))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.Listener listener
  [m2885]
  (clojure.core/let
   [bean2884
    (new com.amazonaws.services.elasticloadbalancing.model.Listener)]
   (clojure.core/when-let
    [v2886 (:protocol m2885)]
    (. bean2884 setProtocol (clojure.core/str v2886)))
   (clojure.core/when-let
    [v2886 (:load-balancer-port m2885)]
    (. bean2884 setLoadBalancerPort (clojure.core/int v2886)))
   (clojure.core/when-let
    [v2886 (:instance-port m2885)]
    (. bean2884 setInstancePort (clojure.core/int v2886)))
   (clojure.core/when-let
    [v2886 (:sslcertificate-id m2885)]
    (. bean2884 setSSLCertificateId (clojure.core/str v2886)))
   (clojure.core/when-let
    [v2886 (:instance-protocol m2885)]
    (. bean2884 setInstanceProtocol (clojure.core/str v2886)))
   bean2884))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest deregister-instances-from-load-balancer-request
  [m2888]
  (clojure.core/let
   [bean2887
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest)]
   (clojure.core/when-let
    [v2889 (:instances m2888)]
    (.
     bean2887
     setInstances
     (clojure.core/map
      (clojure.core/fn [arg2890] (instance arg2890))
      v2889)))
   (clojure.core/when-let
    [v2889 (:load-balancer-name m2888)]
    (. bean2887 setLoadBalancerName (clojure.core/str v2889)))
   bean2887))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest enable-availability-zones-for-load-balancer-request
  [m2892]
  (clojure.core/let
   [bean2891
    (new
     com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/when-let
    [v2893 (:availability-zones m2892)]
    (.
     bean2891
     setAvailabilityZones
     (clojure.core/map
      (clojure.core/fn [arg2894] (clojure.core/str arg2894))
      v2893)))
   (clojure.core/when-let
    [v2893 (:load-balancer-name m2892)]
    (. bean2891 setLoadBalancerName (clojure.core/str v2893)))
   bean2891))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest apply-security-groups-to-load-balancer-request
  [m2896]
  (clojure.core/let
   [bean2895
    (new
     com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest)]
   (clojure.core/when-let
    [v2897 (:security-groups m2896)]
    (.
     bean2895
     setSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg2898] (clojure.core/str arg2898))
      v2897)))
   (clojure.core/when-let
    [v2897 (:load-balancer-name m2896)]
    (. bean2895 setLoadBalancerName (clojure.core/str v2897)))
   bean2895))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest create-lbcookie-stickiness-policy-request
  [m2900]
  (clojure.core/let
   [bean2899
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest)]
   (clojure.core/when-let
    [v2901 (:policy-name m2900)]
    (. bean2899 setPolicyName (clojure.core/str v2901)))
   (clojure.core/when-let
    [v2901 (:load-balancer-name m2900)]
    (. bean2899 setLoadBalancerName (clojure.core/str v2901)))
   (clojure.core/when-let
    [v2901 (:cookie-expiration-period m2900)]
    (. bean2899 setCookieExpirationPeriod (clojure.core/long v2901)))
   bean2899))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest describe-load-balancer-policies-request
  [m2903]
  (clojure.core/let
   [bean2902
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest)]
   (clojure.core/when-let
    [v2904 (:policy-names m2903)]
    (.
     bean2902
     setPolicyNames
     (clojure.core/map
      (clojure.core/fn [arg2905] (clojure.core/str arg2905))
      v2904)))
   (clojure.core/when-let
    [v2904 (:load-balancer-name m2903)]
    (. bean2902 setLoadBalancerName (clojure.core/str v2904)))
   bean2902))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest delete-load-balancer-request
  [m2907]
  (clojure.core/let
   [bean2906
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest)]
   (clojure.core/when-let
    [v2908 (:load-balancer-name m2907)]
    (. bean2906 setLoadBalancerName (clojure.core/str v2908)))
   bean2906))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest describe-load-balancer-policy-types-request
  [m2910]
  (clojure.core/let
   [bean2909
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest)]
   (clojure.core/when-let
    [v2911 (:policy-type-names m2910)]
    (.
     bean2909
     setPolicyTypeNames
     (clojure.core/map
      (clojure.core/fn [arg2912] (clojure.core/str arg2912))
      v2911)))
   bean2909))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest delete-load-balancer-policy-request
  [m2914]
  (clojure.core/let
   [bean2913
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest)]
   (clojure.core/when-let
    [v2915 (:policy-name m2914)]
    (. bean2913 setPolicyName (clojure.core/str v2915)))
   (clojure.core/when-let
    [v2915 (:load-balancer-name m2914)]
    (. bean2913 setLoadBalancerName (clojure.core/str v2915)))
   bean2913))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest create-load-balancer-policy-request
  [m2917]
  (clojure.core/let
   [bean2916
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest)]
   (clojure.core/when-let
    [v2918 (:policy-name m2917)]
    (. bean2916 setPolicyName (clojure.core/str v2918)))
   (clojure.core/when-let
    [v2918 (:load-balancer-name m2917)]
    (. bean2916 setLoadBalancerName (clojure.core/str v2918)))
   (clojure.core/when-let
    [v2918 (:policy-type-name m2917)]
    (. bean2916 setPolicyTypeName (clojure.core/str v2918)))
   (clojure.core/when-let
    [v2918 (:policy-attributes m2917)]
    (.
     bean2916
     setPolicyAttributes
     (clojure.core/map
      (clojure.core/fn [arg2919] (policy-attribute arg2919))
      v2918)))
   bean2916))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest configure-health-check-request
  [m2921]
  (clojure.core/let
   [bean2920
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest)]
   (clojure.core/when-let
    [v2922 (:load-balancer-name m2921)]
    (. bean2920 setLoadBalancerName (clojure.core/str v2922)))
   (clojure.core/when-let
    [v2922 (:health-check m2921)]
    (. bean2920 setHealthCheck (health-check v2922)))
   bean2920))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest describe-instance-health-request
  [m2924]
  (clojure.core/let
   [bean2923
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest)]
   (clojure.core/when-let
    [v2925 (:instances m2924)]
    (.
     bean2923
     setInstances
     (clojure.core/map
      (clojure.core/fn [arg2926] (instance arg2926))
      v2925)))
   (clojure.core/when-let
    [v2925 (:load-balancer-name m2924)]
    (. bean2923 setLoadBalancerName (clojure.core/str v2925)))
   bean2923))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest create-load-balancer-request
  [m2928]
  (clojure.core/let
   [bean2927
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest)]
   (clojure.core/when-let
    [v2929 (:availability-zones m2928)]
    (.
     bean2927
     setAvailabilityZones
     (clojure.core/map
      (clojure.core/fn [arg2930] (clojure.core/str arg2930))
      v2929)))
   (clojure.core/when-let
    [v2929 (:security-groups m2928)]
    (.
     bean2927
     setSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg2931] (clojure.core/str arg2931))
      v2929)))
   (clojure.core/when-let
    [v2929 (:load-balancer-name m2928)]
    (. bean2927 setLoadBalancerName (clojure.core/str v2929)))
   (clojure.core/when-let
    [v2929 (:listeners m2928)]
    (.
     bean2927
     setListeners
     (clojure.core/map
      (clojure.core/fn [arg2932] (listener arg2932))
      v2929)))
   (clojure.core/when-let
    [v2929 (:scheme m2928)]
    (. bean2927 setScheme (clojure.core/str v2929)))
   (clojure.core/when-let
    [v2929 (:subnets m2928)]
    (.
     bean2927
     setSubnets
     (clojure.core/map
      (clojure.core/fn [arg2933] (clojure.core/str arg2933))
      v2929)))
   bean2927))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest set-load-balancer-policies-for-backend-server-request
  [m2935]
  (clojure.core/let
   [bean2934
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest)]
   (clojure.core/when-let
    [v2936 (:policy-names m2935)]
    (.
     bean2934
     setPolicyNames
     (clojure.core/map
      (clojure.core/fn [arg2937] (clojure.core/str arg2937))
      v2936)))
   (clojure.core/when-let
    [v2936 (:load-balancer-name m2935)]
    (. bean2934 setLoadBalancerName (clojure.core/str v2936)))
   (clojure.core/when-let
    [v2936 (:instance-port m2935)]
    (. bean2934 setInstancePort (clojure.core/int v2936)))
   bean2934))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest disable-availability-zones-for-load-balancer-request
  [m2939]
  (clojure.core/let
   [bean2938
    (new
     com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/when-let
    [v2940 (:availability-zones m2939)]
    (.
     bean2938
     setAvailabilityZones
     (clojure.core/map
      (clojure.core/fn [arg2941] (clojure.core/str arg2941))
      v2940)))
   (clojure.core/when-let
    [v2940 (:load-balancer-name m2939)]
    (. bean2938 setLoadBalancerName (clojure.core/str v2940)))
   bean2938))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest detach-load-balancer-from-subnets-request
  [m2943]
  (clojure.core/let
   [bean2942
    (new
     com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest)]
   (clojure.core/when-let
    [v2944 (:load-balancer-name m2943)]
    (. bean2942 setLoadBalancerName (clojure.core/str v2944)))
   (clojure.core/when-let
    [v2944 (:subnets m2943)]
    (.
     bean2942
     setSubnets
     (clojure.core/map
      (clojure.core/fn [arg2945] (clojure.core/str arg2945))
      v2944)))
   bean2942))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest create-load-balancer-listeners-request
  [m2947]
  (clojure.core/let
   [bean2946
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest)]
   (clojure.core/when-let
    [v2948 (:load-balancer-name m2947)]
    (. bean2946 setLoadBalancerName (clojure.core/str v2948)))
   (clojure.core/when-let
    [v2948 (:listeners m2947)]
    (.
     bean2946
     setListeners
     (clojure.core/map
      (clojure.core/fn [arg2949] (listener arg2949))
      v2948)))
   bean2946))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest delete-load-balancer-listeners-request
  [m2951]
  (clojure.core/let
   [bean2950
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest)]
   (clojure.core/when-let
    [v2952 (:load-balancer-name m2951)]
    (. bean2950 setLoadBalancerName (clojure.core/str v2952)))
   (clojure.core/when-let
    [v2952 (:load-balancer-ports m2951)]
    (.
     bean2950
     setLoadBalancerPorts
     (clojure.core/map
      (clojure.core/fn [arg2953] (clojure.core/int arg2953))
      v2952)))
   bean2950))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest set-load-balancer-listener-sslcertificate-request
  [m2955]
  (clojure.core/let
   [bean2954
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest)]
   (clojure.core/when-let
    [v2956 (:load-balancer-name m2955)]
    (. bean2954 setLoadBalancerName (clojure.core/str v2956)))
   (clojure.core/when-let
    [v2956 (:load-balancer-port m2955)]
    (. bean2954 setLoadBalancerPort (clojure.core/int v2956)))
   (clojure.core/when-let
    [v2956 (:sslcertificate-id m2955)]
    (. bean2954 setSSLCertificateId (clojure.core/str v2956)))
   bean2954))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest register-instances-with-load-balancer-request
  [m2958]
  (clojure.core/let
   [bean2957
    (new
     com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest)]
   (clojure.core/when-let
    [v2959 (:instances m2958)]
    (.
     bean2957
     setInstances
     (clojure.core/map
      (clojure.core/fn [arg2960] (instance arg2960))
      v2959)))
   (clojure.core/when-let
    [v2959 (:load-balancer-name m2958)]
    (. bean2957 setLoadBalancerName (clojure.core/str v2959)))
   bean2957))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest set-load-balancer-policies-of-listener-request
  [m2962]
  (clojure.core/let
   [bean2961
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest)]
   (clojure.core/when-let
    [v2963 (:policy-names m2962)]
    (.
     bean2961
     setPolicyNames
     (clojure.core/map
      (clojure.core/fn [arg2964] (clojure.core/str arg2964))
      v2963)))
   (clojure.core/when-let
    [v2963 (:load-balancer-name m2962)]
    (. bean2961 setLoadBalancerName (clojure.core/str v2963)))
   (clojure.core/when-let
    [v2963 (:load-balancer-port m2962)]
    (. bean2961 setLoadBalancerPort (clojure.core/int v2963)))
   bean2961))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest attach-load-balancer-to-subnets-request
  [m2966]
  (clojure.core/let
   [bean2965
    (new
     com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest)]
   (clojure.core/when-let
    [v2967 (:load-balancer-name m2966)]
    (. bean2965 setLoadBalancerName (clojure.core/str v2967)))
   (clojure.core/when-let
    [v2967 (:subnets m2966)]
    (.
     bean2965
     setSubnets
     (clojure.core/map
      (clojure.core/fn [arg2968] (clojure.core/str arg2968))
      v2967)))
   bean2965))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest describe-load-balancers-request
  [m2970]
  (clojure.core/let
   [bean2969
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest)]
   (clojure.core/when-let
    [v2971 (:load-balancer-names m2970)]
    (.
     bean2969
     setLoadBalancerNames
     (clojure.core/map
      (clojure.core/fn [arg2972] (clojure.core/str arg2972))
      v2971)))
   (clojure.core/when-let
    [v2971 (:marker m2970)]
    (. bean2969 setMarker (clojure.core/str v2971)))
   bean2969))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest create-app-cookie-stickiness-policy-request
  [m2974]
  (clojure.core/let
   [bean2973
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest)]
   (clojure.core/when-let
    [v2975 (:policy-name m2974)]
    (. bean2973 setPolicyName (clojure.core/str v2975)))
   (clojure.core/when-let
    [v2975 (:load-balancer-name m2974)]
    (. bean2973 setLoadBalancerName (clojure.core/str v2975)))
   (clojure.core/when-let
    [v2975 (:cookie-name m2974)]
    (. bean2973 setCookieName (clojure.core/str v2975)))
   bean2973))
 (clojure.core/defmulti
  elasticloadbalancing
  (clojure.core/fn
   elasticloadbalancing
   [m__609__auto__]
   (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :deregister-instances-from-load-balancer
   [m2976]
   (clojure.core/let
    [credentials2977 (:credentials m2976) args2978 (:args m2976)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client2979
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials2977)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client2979
       deregisterInstancesFromLoadBalancer
       (deregister-instances-from-load-balancer-request
        (clojure.core/nth args2978 0)))))))
  (clojure.core/defn
   deregister-instances-from-load-balancer-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector load-balancer-name instances]}]],
    :doc "Generate map for deregisterInstancesFromLoadBalancer"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :deregister-instances-from-load-balancer,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   deregister-instances-from-load-balancer
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector load-balancer-name instances]}]],
    :doc "Call deregisterInstancesFromLoadBalancer"}
   [credentials2981 & args2982]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client2983
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials2981)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client2983
      deregisterInstancesFromLoadBalancer
      (deregister-instances-from-load-balancer-request
       (clojure.core/nth args2982 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :enable-availability-zones-for-load-balancer
   [m2984]
   (clojure.core/let
    [credentials2985 (:credentials m2984) args2986 (:args m2984)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client2987
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials2985)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client2987
       enableAvailabilityZonesForLoadBalancer
       (enable-availability-zones-for-load-balancer-request
        (clojure.core/nth args2986 0)))))))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         load-balancer-name
         availability-zones]}]],
    :doc "Generate map for enableAvailabilityZonesForLoadBalancer"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :enable-availability-zones-for-load-balancer,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         load-balancer-name
         availability-zones]}]],
    :doc "Call enableAvailabilityZonesForLoadBalancer"}
   [credentials2989 & args2990]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client2991
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials2989)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client2991
      enableAvailabilityZonesForLoadBalancer
      (enable-availability-zones-for-load-balancer-request
       (clojure.core/nth args2990 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :apply-security-groups-to-load-balancer
   [m2992]
   (clojure.core/let
    [credentials2993 (:credentials m2992) args2994 (:args m2992)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client2995
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials2993)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client2995
       applySecurityGroupsToLoadBalancer
       (apply-security-groups-to-load-balancer-request
        (clojure.core/nth args2994 0)))))))
  (clojure.core/defn
   apply-security-groups-to-load-balancer-map
   {:arglists
    '[[credentials
       {:keys
        [security-groups
         request-metric-collector
         load-balancer-name]}]],
    :doc "Generate map for applySecurityGroupsToLoadBalancer"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :apply-security-groups-to-load-balancer,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   apply-security-groups-to-load-balancer
   {:arglists
    '[[credentials
       {:keys
        [security-groups
         request-metric-collector
         load-balancer-name]}]],
    :doc "Call applySecurityGroupsToLoadBalancer"}
   [credentials2997 & args2998]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client2999
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials2997)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client2999
      applySecurityGroupsToLoadBalancer
      (apply-security-groups-to-load-balancer-request
       (clojure.core/nth args2998 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-lbcookie-stickiness-policy
   [m3000]
   (clojure.core/let
    [credentials3001 (:credentials m3000) args3002 (:args m3000)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3003
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3001)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3003
       createLBCookieStickinessPolicy
       (create-lbcookie-stickiness-policy-request
        (clojure.core/nth args3002 0)))))))
  (clojure.core/defn
   create-lbcookie-stickiness-policy-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-name
         load-balancer-name
         cookie-expiration-period]}]],
    :doc "Generate map for createLBCookieStickinessPolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-lbcookie-stickiness-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-lbcookie-stickiness-policy
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-name
         load-balancer-name
         cookie-expiration-period]}]],
    :doc "Call createLBCookieStickinessPolicy"}
   [credentials3005 & args3006]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3007
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3005)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3007
      createLBCookieStickinessPolicy
      (create-lbcookie-stickiness-policy-request
       (clojure.core/nth args3006 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policies
   [m3008]
   (clojure.core/let
    [credentials3009 (:credentials m3008) args3010 (:args m3008)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3011
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3009)]
     (clojure.core/case
      (clojure.core/count args3010)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3011
        describeLoadBalancerPolicies
        (describe-load-balancer-policies-request
         (clojure.core/nth args3010 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3011
        describeLoadBalancerPolicies))))))
  (clojure.core/defn
   describe-load-balancer-policies-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector policy-names load-balancer-name]}]
      [credentials]],
    :doc
    "Generate map for describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policies,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policies,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-load-balancer-policies
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector policy-names load-balancer-name]}]
      [credentials]],
    :doc
    "Call describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   [credentials3013 & args3014]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3015
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3013)]
    (clojure.core/case
     (clojure.core/count args3014)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3015
       describeLoadBalancerPolicies
       (describe-load-balancer-policies-request
        (clojure.core/nth args3014 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3015
       describeLoadBalancerPolicies))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer
   [m3016]
   (clojure.core/let
    [credentials3017 (:credentials m3016) args3018 (:args m3016)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3019
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3017)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3019
       deleteLoadBalancer
       (delete-load-balancer-request
        (clojure.core/nth args3018 0)))))))
  (clojure.core/defn
   delete-load-balancer-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector load-balancer-name]}]],
    :doc "Generate map for deleteLoadBalancer"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :delete-load-balancer,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-load-balancer
   {:arglists
    '[[credentials
       {:keys [request-metric-collector load-balancer-name]}]],
    :doc "Call deleteLoadBalancer"}
   [credentials3021 & args3022]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3023
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3021)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3023
      deleteLoadBalancer
      (delete-load-balancer-request (clojure.core/nth args3022 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policy-types
   [m3024]
   (clojure.core/let
    [credentials3025 (:credentials m3024) args3026 (:args m3024)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3027
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3025)]
     (clojure.core/case
      (clojure.core/count args3026)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3027
        describeLoadBalancerPolicyTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3027
        describeLoadBalancerPolicyTypes
        (describe-load-balancer-policy-types-request
         (clojure.core/nth args3026 0))))))))
  (clojure.core/defn
   describe-load-balancer-policy-types-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys [request-metric-collector policy-type-names]}]],
    :doc
    "Generate map for describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-load-balancer-policy-types
   {:arglists
    '[[credentials]
      [credentials
       {:keys [request-metric-collector policy-type-names]}]],
    :doc
    "Call describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   [credentials3029 & args3030]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3031
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3029)]
    (clojure.core/case
     (clojure.core/count args3030)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3031
       describeLoadBalancerPolicyTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3031
       describeLoadBalancerPolicyTypes
       (describe-load-balancer-policy-types-request
        (clojure.core/nth args3030 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-policy
   [m3032]
   (clojure.core/let
    [credentials3033 (:credentials m3032) args3034 (:args m3032)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3035
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3033)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3035
       deleteLoadBalancerPolicy
       (delete-load-balancer-policy-request
        (clojure.core/nth args3034 0)))))))
  (clojure.core/defn
   delete-load-balancer-policy-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector policy-name load-balancer-name]}]],
    :doc "Generate map for deleteLoadBalancerPolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :delete-load-balancer-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-load-balancer-policy
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector policy-name load-balancer-name]}]],
    :doc "Call deleteLoadBalancerPolicy"}
   [credentials3037 & args3038]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3039
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3037)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3039
      deleteLoadBalancerPolicy
      (delete-load-balancer-policy-request
       (clojure.core/nth args3038 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-policy
   [m3040]
   (clojure.core/let
    [credentials3041 (:credentials m3040) args3042 (:args m3040)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3043
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3041)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3043
       createLoadBalancerPolicy
       (create-load-balancer-policy-request
        (clojure.core/nth args3042 0)))))))
  (clojure.core/defn
   create-load-balancer-policy-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-type-name
         policy-name
         policy-attributes
         load-balancer-name]}]],
    :doc "Generate map for createLoadBalancerPolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-load-balancer-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-load-balancer-policy
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-type-name
         policy-name
         policy-attributes
         load-balancer-name]}]],
    :doc "Call createLoadBalancerPolicy"}
   [credentials3045 & args3046]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3047
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3045)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3047
      createLoadBalancerPolicy
      (create-load-balancer-policy-request
       (clojure.core/nth args3046 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :configure-health-check
   [m3048]
   (clojure.core/let
    [credentials3049 (:credentials m3048) args3050 (:args m3048)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3051
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3049)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3051
       configureHealthCheck
       (configure-health-check-request
        (clojure.core/nth args3050 0)))))))
  (clojure.core/defn
   configure-health-check-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector load-balancer-name health-check]}]],
    :doc "Generate map for configureHealthCheck"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :configure-health-check,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   configure-health-check
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector load-balancer-name health-check]}]],
    :doc "Call configureHealthCheck"}
   [credentials3053 & args3054]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3055
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3053)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3055
      configureHealthCheck
      (configure-health-check-request
       (clojure.core/nth args3054 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-instance-health
   [m3056]
   (clojure.core/let
    [credentials3057 (:credentials m3056) args3058 (:args m3056)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3059
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3057)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3059
       describeInstanceHealth
       (describe-instance-health-request
        (clojure.core/nth args3058 0)))))))
  (clojure.core/defn
   describe-instance-health-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector load-balancer-name instances]}]],
    :doc "Generate map for describeInstanceHealth"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-instance-health,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-instance-health
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector load-balancer-name instances]}]],
    :doc "Call describeInstanceHealth"}
   [credentials3061 & args3062]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3063
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3061)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3063
      describeInstanceHealth
      (describe-instance-health-request
       (clojure.core/nth args3062 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer
   [m3064]
   (clojure.core/let
    [credentials3065 (:credentials m3064) args3066 (:args m3064)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3067
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3065)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3067
       createLoadBalancer
       (create-load-balancer-request
        (clojure.core/nth args3066 0)))))))
  (clojure.core/defn
   create-load-balancer-map
   {:arglists
    '[[credentials
       {:keys
        [listeners
         security-groups
         subnets
         load-balancer-name
         request-metric-collector
         availability-zones
         scheme]}]],
    :doc "Generate map for createLoadBalancer"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-load-balancer,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-load-balancer
   {:arglists
    '[[credentials
       {:keys
        [listeners
         security-groups
         subnets
         load-balancer-name
         request-metric-collector
         availability-zones
         scheme]}]],
    :doc "Call createLoadBalancer"}
   [credentials3069 & args3070]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3071
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3069)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3071
      createLoadBalancer
      (create-load-balancer-request (clojure.core/nth args3070 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-for-backend-server
   [m3072]
   (clojure.core/let
    [credentials3073 (:credentials m3072) args3074 (:args m3072)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3075
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3073)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3075
       setLoadBalancerPoliciesForBackendServer
       (set-load-balancer-policies-for-backend-server-request
        (clojure.core/nth args3074 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-names
         load-balancer-name
         instance-port]}]],
    :doc "Generate map for setLoadBalancerPoliciesForBackendServer"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :set-load-balancer-policies-for-backend-server,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-names
         load-balancer-name
         instance-port]}]],
    :doc "Call setLoadBalancerPoliciesForBackendServer"}
   [credentials3077 & args3078]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3079
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3077)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3079
      setLoadBalancerPoliciesForBackendServer
      (set-load-balancer-policies-for-backend-server-request
       (clojure.core/nth args3078 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :disable-availability-zones-for-load-balancer
   [m3080]
   (clojure.core/let
    [credentials3081 (:credentials m3080) args3082 (:args m3080)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3083
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3081)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3083
       disableAvailabilityZonesForLoadBalancer
       (disable-availability-zones-for-load-balancer-request
        (clojure.core/nth args3082 0)))))))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         load-balancer-name
         availability-zones]}]],
    :doc "Generate map for disableAvailabilityZonesForLoadBalancer"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :disable-availability-zones-for-load-balancer,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         load-balancer-name
         availability-zones]}]],
    :doc "Call disableAvailabilityZonesForLoadBalancer"}
   [credentials3085 & args3086]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3087
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3085)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3087
      disableAvailabilityZonesForLoadBalancer
      (disable-availability-zones-for-load-balancer-request
       (clojure.core/nth args3086 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :detach-load-balancer-from-subnets
   [m3088]
   (clojure.core/let
    [credentials3089 (:credentials m3088) args3090 (:args m3088)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3091
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3089)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3091
       detachLoadBalancerFromSubnets
       (detach-load-balancer-from-subnets-request
        (clojure.core/nth args3090 0)))))))
  (clojure.core/defn
   detach-load-balancer-from-subnets-map
   {:arglists
    '[[credentials
       {:keys [subnets request-metric-collector load-balancer-name]}]],
    :doc "Generate map for detachLoadBalancerFromSubnets"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :detach-load-balancer-from-subnets,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   detach-load-balancer-from-subnets
   {:arglists
    '[[credentials
       {:keys [subnets request-metric-collector load-balancer-name]}]],
    :doc "Call detachLoadBalancerFromSubnets"}
   [credentials3093 & args3094]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3095
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3093)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3095
      detachLoadBalancerFromSubnets
      (detach-load-balancer-from-subnets-request
       (clojure.core/nth args3094 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-listeners
   [m3096]
   (clojure.core/let
    [credentials3097 (:credentials m3096) args3098 (:args m3096)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3099
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3097)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3099
       createLoadBalancerListeners
       (create-load-balancer-listeners-request
        (clojure.core/nth args3098 0)))))))
  (clojure.core/defn
   create-load-balancer-listeners-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector load-balancer-name listeners]}]],
    :doc "Generate map for createLoadBalancerListeners"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-load-balancer-listeners,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-load-balancer-listeners
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector load-balancer-name listeners]}]],
    :doc "Call createLoadBalancerListeners"}
   [credentials3101 & args3102]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3103
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3101)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3103
      createLoadBalancerListeners
      (create-load-balancer-listeners-request
       (clojure.core/nth args3102 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-listeners
   [m3104]
   (clojure.core/let
    [credentials3105 (:credentials m3104) args3106 (:args m3104)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3107
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3105)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3107
       deleteLoadBalancerListeners
       (delete-load-balancer-listeners-request
        (clojure.core/nth args3106 0)))))))
  (clojure.core/defn
   delete-load-balancer-listeners-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         load-balancer-ports
         load-balancer-name]}]],
    :doc "Generate map for deleteLoadBalancerListeners"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :delete-load-balancer-listeners,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-load-balancer-listeners
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         load-balancer-ports
         load-balancer-name]}]],
    :doc "Call deleteLoadBalancerListeners"}
   [credentials3109 & args3110]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3111
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3109)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3111
      deleteLoadBalancerListeners
      (delete-load-balancer-listeners-request
       (clojure.core/nth args3110 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-listener-sslcertificate
   [m3112]
   (clojure.core/let
    [credentials3113 (:credentials m3112) args3114 (:args m3112)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3115
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3113)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3115
       setLoadBalancerListenerSSLCertificate
       (set-load-balancer-listener-sslcertificate-request
        (clojure.core/nth args3114 0)))))))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         load-balancer-port
         load-balancer-name
         sslcertificate-id]}]],
    :doc "Generate map for setLoadBalancerListenerSSLCertificate"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :set-load-balancer-listener-sslcertificate,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         load-balancer-port
         load-balancer-name
         sslcertificate-id]}]],
    :doc "Call setLoadBalancerListenerSSLCertificate"}
   [credentials3117 & args3118]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3119
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3117)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3119
      setLoadBalancerListenerSSLCertificate
      (set-load-balancer-listener-sslcertificate-request
       (clojure.core/nth args3118 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :register-instances-with-load-balancer
   [m3120]
   (clojure.core/let
    [credentials3121 (:credentials m3120) args3122 (:args m3120)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3123
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3121)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3123
       registerInstancesWithLoadBalancer
       (register-instances-with-load-balancer-request
        (clojure.core/nth args3122 0)))))))
  (clojure.core/defn
   register-instances-with-load-balancer-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector load-balancer-name instances]}]],
    :doc "Generate map for registerInstancesWithLoadBalancer"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :register-instances-with-load-balancer,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   register-instances-with-load-balancer
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector load-balancer-name instances]}]],
    :doc "Call registerInstancesWithLoadBalancer"}
   [credentials3125 & args3126]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3127
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3125)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3127
      registerInstancesWithLoadBalancer
      (register-instances-with-load-balancer-request
       (clojure.core/nth args3126 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-of-listener
   [m3128]
   (clojure.core/let
    [credentials3129 (:credentials m3128) args3130 (:args m3128)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3131
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3129)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3131
       setLoadBalancerPoliciesOfListener
       (set-load-balancer-policies-of-listener-request
        (clojure.core/nth args3130 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-of-listener-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-names
         load-balancer-port
         load-balancer-name]}]],
    :doc "Generate map for setLoadBalancerPoliciesOfListener"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :set-load-balancer-policies-of-listener,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-load-balancer-policies-of-listener
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-names
         load-balancer-port
         load-balancer-name]}]],
    :doc "Call setLoadBalancerPoliciesOfListener"}
   [credentials3133 & args3134]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3135
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3133)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3135
      setLoadBalancerPoliciesOfListener
      (set-load-balancer-policies-of-listener-request
       (clojure.core/nth args3134 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :attach-load-balancer-to-subnets
   [m3136]
   (clojure.core/let
    [credentials3137 (:credentials m3136) args3138 (:args m3136)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3139
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3137)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3139
       attachLoadBalancerToSubnets
       (attach-load-balancer-to-subnets-request
        (clojure.core/nth args3138 0)))))))
  (clojure.core/defn
   attach-load-balancer-to-subnets-map
   {:arglists
    '[[credentials
       {:keys [subnets request-metric-collector load-balancer-name]}]],
    :doc "Generate map for attachLoadBalancerToSubnets"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :attach-load-balancer-to-subnets,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   attach-load-balancer-to-subnets
   {:arglists
    '[[credentials
       {:keys [subnets request-metric-collector load-balancer-name]}]],
    :doc "Call attachLoadBalancerToSubnets"}
   [credentials3141 & args3142]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3143
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3141)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3143
      attachLoadBalancerToSubnets
      (attach-load-balancer-to-subnets-request
       (clojure.core/nth args3142 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancers
   [m3144]
   (clojure.core/let
    [credentials3145 (:credentials m3144) args3146 (:args m3144)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3147
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3145)]
     (clojure.core/case
      (clojure.core/count args3146)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3147
        describeLoadBalancers
        (describe-load-balancers-request
         (clojure.core/nth args3146 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3147
        describeLoadBalancers))))))
  (clojure.core/defn
   describe-load-balancers-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector marker load-balancer-names]}]
      [credentials]],
    :doc
    "Generate map for describeLoadBalancers, describeLoadBalancers"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticloadbalancing,
     :fn :describe-load-balancers,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancers,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-load-balancers
   {:arglists
    '[[credentials
       {:keys [request-metric-collector marker load-balancer-names]}]
      [credentials]],
    :doc "Call describeLoadBalancers, describeLoadBalancers"}
   [credentials3149 & args3150]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3151
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3149)]
    (clojure.core/case
     (clojure.core/count args3150)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3151
       describeLoadBalancers
       (describe-load-balancers-request
        (clojure.core/nth args3150 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3151
       describeLoadBalancers))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-app-cookie-stickiness-policy
   [m3152]
   (clojure.core/let
    [credentials3153 (:credentials m3152) args3154 (:args m3152)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3155
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials3153)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3155
       createAppCookieStickinessPolicy
       (create-app-cookie-stickiness-policy-request
        (clojure.core/nth args3154 0)))))))
  (clojure.core/defn
   create-app-cookie-stickiness-policy-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-name
         load-balancer-name
         cookie-name]}]],
    :doc "Generate map for createAppCookieStickinessPolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-app-cookie-stickiness-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-app-cookie-stickiness-policy
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-name
         load-balancer-name
         cookie-name]}]],
    :doc "Call createAppCookieStickinessPolicy"}
   [credentials3157 & args3158]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3159
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials3157)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client3159
      createAppCookieStickinessPolicy
      (create-app-cookie-stickiness-policy-request
       (clojure.core/nth args3158 0))))))))
