(ns com.palletops.awaze.elasticbeanstalk (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticbeanstalk
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.OptionSpecification option-specification
  [m7536]
  (clojure.core/let
   [bean7535
    (new
     com.amazonaws.services.elasticbeanstalk.model.OptionSpecification)]
   (clojure.core/when-let
    [v7537 (:option-name m7536)]
    (. bean7535 setOptionName (clojure.core/str v7537)))
   (clojure.core/when-let
    [v7537 (:namespace m7536)]
    (. bean7535 setNamespace (clojure.core/str v7537)))
   bean7535))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting configuration-option-setting
  [m7539]
  (clojure.core/let
   [bean7538
    (new
     com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting)]
   (clojure.core/when-let
    [v7540 (:value m7539)]
    (. bean7538 setValue (clojure.core/str v7540)))
   (clojure.core/when-let
    [v7540 (:option-name m7539)]
    (. bean7538 setOptionName (clojure.core/str v7540)))
   (clojure.core/when-let
    [v7540 (:namespace m7539)]
    (. bean7538 setNamespace (clojure.core/str v7540)))
   bean7538))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.S3Location s3location
  [m7542]
  (clojure.core/let
   [bean7541
    (new com.amazonaws.services.elasticbeanstalk.model.S3Location)]
   (clojure.core/when-let
    [v7543 (:s3bucket m7542)]
    (. bean7541 setS3Bucket (clojure.core/str v7543)))
   (clojure.core/when-let
    [v7543 (:s3key m7542)]
    (. bean7541 setS3Key (clojure.core/str v7543)))
   bean7541))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration source-configuration
  [m7545]
  (clojure.core/let
   [bean7544
    (new
     com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration)]
   (clojure.core/when-let
    [v7546 (:application-name m7545)]
    (. bean7544 setApplicationName (clojure.core/str v7546)))
   (clojure.core/when-let
    [v7546 (:template-name m7545)]
    (. bean7544 setTemplateName (clojure.core/str v7546)))
   bean7544))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.EventSeverity event-severity
  [m7548]
  (java.lang.Enum/valueOf
   com.amazonaws.services.elasticbeanstalk.model.EventSeverity
   (clojure.core/name m7548)))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.EnvironmentInfoType environment-info-type
  [m7551]
  (java.lang.Enum/valueOf
   com.amazonaws.services.elasticbeanstalk.model.EnvironmentInfoType
   (clojure.core/name m7551)))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest create-application-request
  [m7554]
  (clojure.core/let
   [bean7553
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest)]
   (clojure.core/when-let
    [v7555 (:description m7554)]
    (. bean7553 setDescription (clojure.core/str v7555)))
   (clojure.core/when-let
    [v7555 (:application-name m7554)]
    (. bean7553 setApplicationName (clojure.core/str v7555)))
   bean7553))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest delete-application-request
  [m7557]
  (clojure.core/let
   [bean7556
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest)]
   (clojure.core/when-let
    [v7558 (:application-name m7557)]
    (. bean7556 setApplicationName (clojure.core/str v7558)))
   bean7556))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest create-environment-request
  [m7560]
  (clojure.core/let
   [bean7559
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest)]
   (clojure.core/when-let
    [v7561 (:options-to-remove m7560)]
    (.
     bean7559
     setOptionsToRemove
     (clojure.core/map
      (clojure.core/fn [arg7562] (option-specification arg7562))
      v7561)))
   (clojure.core/when-let
    [v7561 (:option-settings m7560)]
    (.
     bean7559
     setOptionSettings
     (clojure.core/map
      (clojure.core/fn
       [arg7563]
       (configuration-option-setting arg7563))
      v7561)))
   (clojure.core/when-let
    [v7561 (:description m7560)]
    (. bean7559 setDescription (clojure.core/str v7561)))
   (clojure.core/when-let
    [v7561 (:application-name m7560)]
    (. bean7559 setApplicationName (clojure.core/str v7561)))
   (clojure.core/when-let
    [v7561 (:version-label m7560)]
    (. bean7559 setVersionLabel (clojure.core/str v7561)))
   (clojure.core/when-let
    [v7561 (:template-name m7560)]
    (. bean7559 setTemplateName (clojure.core/str v7561)))
   (clojure.core/when-let
    [v7561 (:environment-name m7560)]
    (. bean7559 setEnvironmentName (clojure.core/str v7561)))
   (clojure.core/when-let
    [v7561 (:cnameprefix m7560)]
    (. bean7559 setCNAMEPrefix (clojure.core/str v7561)))
   (clojure.core/when-let
    [v7561 (:solution-stack-name m7560)]
    (. bean7559 setSolutionStackName (clojure.core/str v7561)))
   bean7559))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest describe-configuration-settings-request
  [m7565]
  (clojure.core/let
   [bean7564
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest)]
   (clojure.core/when-let
    [v7566 (:application-name m7565)]
    (. bean7564 setApplicationName (clojure.core/str v7566)))
   (clojure.core/when-let
    [v7566 (:template-name m7565)]
    (. bean7564 setTemplateName (clojure.core/str v7566)))
   (clojure.core/when-let
    [v7566 (:environment-name m7565)]
    (. bean7564 setEnvironmentName (clojure.core/str v7566)))
   bean7564))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest create-storage-location-request
  [m7568]
  (clojure.core/let
   [bean7567
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest)]
   bean7567))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest describe-configuration-options-request
  [m7571]
  (clojure.core/let
   [bean7570
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest)]
   (clojure.core/when-let
    [v7572 (:options m7571)]
    (.
     bean7570
     setOptions
     (clojure.core/map
      (clojure.core/fn [arg7573] (option-specification arg7573))
      v7572)))
   (clojure.core/when-let
    [v7572 (:application-name m7571)]
    (. bean7570 setApplicationName (clojure.core/str v7572)))
   (clojure.core/when-let
    [v7572 (:template-name m7571)]
    (. bean7570 setTemplateName (clojure.core/str v7572)))
   (clojure.core/when-let
    [v7572 (:environment-name m7571)]
    (. bean7570 setEnvironmentName (clojure.core/str v7572)))
   (clojure.core/when-let
    [v7572 (:solution-stack-name m7571)]
    (. bean7570 setSolutionStackName (clojure.core/str v7572)))
   bean7570))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest rebuild-environment-request
  [m7575]
  (clojure.core/let
   [bean7574
    (new
     com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest)]
   (clojure.core/when-let
    [v7576 (:environment-id m7575)]
    (. bean7574 setEnvironmentId (clojure.core/str v7576)))
   (clojure.core/when-let
    [v7576 (:environment-name m7575)]
    (. bean7574 setEnvironmentName (clojure.core/str v7576)))
   bean7574))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest create-application-version-request
  [m7578]
  (clojure.core/let
   [bean7577
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest)]
   (clojure.core/when-let
    [v7579 (:description m7578)]
    (. bean7577 setDescription (clojure.core/str v7579)))
   (clojure.core/when-let
    [v7579 (:application-name m7578)]
    (. bean7577 setApplicationName (clojure.core/str v7579)))
   (clojure.core/when-let
    [v7579 (:version-label m7578)]
    (. bean7577 setVersionLabel (clojure.core/str v7579)))
   (clojure.core/when-let
    [v7579 (:source-bundle m7578)]
    (. bean7577 setSourceBundle (s3location v7579)))
   (clojure.core/when-let
    [v7579 (:auto-create-application m7578)]
    (. bean7577 setAutoCreateApplication (clojure.core/boolean v7579)))
   bean7577))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest update-environment-request
  [m7581]
  (clojure.core/let
   [bean7580
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest)]
   (clojure.core/when-let
    [v7582 (:options-to-remove m7581)]
    (.
     bean7580
     setOptionsToRemove
     (clojure.core/map
      (clojure.core/fn [arg7583] (option-specification arg7583))
      v7582)))
   (clojure.core/when-let
    [v7582 (:option-settings m7581)]
    (.
     bean7580
     setOptionSettings
     (clojure.core/map
      (clojure.core/fn
       [arg7584]
       (configuration-option-setting arg7584))
      v7582)))
   (clojure.core/when-let
    [v7582 (:description m7581)]
    (. bean7580 setDescription (clojure.core/str v7582)))
   (clojure.core/when-let
    [v7582 (:version-label m7581)]
    (. bean7580 setVersionLabel (clojure.core/str v7582)))
   (clojure.core/when-let
    [v7582 (:template-name m7581)]
    (. bean7580 setTemplateName (clojure.core/str v7582)))
   (clojure.core/when-let
    [v7582 (:environment-id m7581)]
    (. bean7580 setEnvironmentId (clojure.core/str v7582)))
   (clojure.core/when-let
    [v7582 (:environment-name m7581)]
    (. bean7580 setEnvironmentName (clojure.core/str v7582)))
   bean7580))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest create-configuration-template-request
  [m7586]
  (clojure.core/let
   [bean7585
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest)]
   (clojure.core/when-let
    [v7587 (:option-settings m7586)]
    (.
     bean7585
     setOptionSettings
     (clojure.core/map
      (clojure.core/fn
       [arg7588]
       (configuration-option-setting arg7588))
      v7587)))
   (clojure.core/when-let
    [v7587 (:description m7586)]
    (. bean7585 setDescription (clojure.core/str v7587)))
   (clojure.core/when-let
    [v7587 (:application-name m7586)]
    (. bean7585 setApplicationName (clojure.core/str v7587)))
   (clojure.core/when-let
    [v7587 (:template-name m7586)]
    (. bean7585 setTemplateName (clojure.core/str v7587)))
   (clojure.core/when-let
    [v7587 (:environment-id m7586)]
    (. bean7585 setEnvironmentId (clojure.core/str v7587)))
   (clojure.core/when-let
    [v7587 (:solution-stack-name m7586)]
    (. bean7585 setSolutionStackName (clojure.core/str v7587)))
   (clojure.core/when-let
    [v7587 (:source-configuration m7586)]
    (. bean7585 setSourceConfiguration (source-configuration v7587)))
   bean7585))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest validate-configuration-settings-request
  [m7590]
  (clojure.core/let
   [bean7589
    (new
     com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest)]
   (clojure.core/when-let
    [v7591 (:option-settings m7590)]
    (.
     bean7589
     setOptionSettings
     (clojure.core/map
      (clojure.core/fn
       [arg7592]
       (configuration-option-setting arg7592))
      v7591)))
   (clojure.core/when-let
    [v7591 (:application-name m7590)]
    (. bean7589 setApplicationName (clojure.core/str v7591)))
   (clojure.core/when-let
    [v7591 (:template-name m7590)]
    (. bean7589 setTemplateName (clojure.core/str v7591)))
   (clojure.core/when-let
    [v7591 (:environment-name m7590)]
    (. bean7589 setEnvironmentName (clojure.core/str v7591)))
   bean7589))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest describe-events-request
  [m7594]
  (clojure.core/let
   [bean7593
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest)]
   (clojure.core/when-let
    [v7595 (:request-id m7594)]
    (. bean7593 setRequestId (clojure.core/str v7595)))
   (clojure.core/when-let
    [v7595 (:next-token m7594)]
    (. bean7593 setNextToken (clojure.core/str v7595)))
   (clojure.core/when-let
    [v7595 (:max-records m7594)]
    (. bean7593 setMaxRecords (clojure.core/int v7595)))
   (clojure.core/when-let
    [v7595 (:start-time m7594)]
    (.
     bean7593
     setStartTime
     (com.palletops.awaze.common/to-date v7595)))
   (clojure.core/when-let
    [v7595 (:end-time m7594)]
    (. bean7593 setEndTime (com.palletops.awaze.common/to-date v7595)))
   (clojure.core/when-let
    [v7595 (:application-name m7594)]
    (. bean7593 setApplicationName (clojure.core/str v7595)))
   (clojure.core/when-let
    [v7595 (:version-label m7594)]
    (. bean7593 setVersionLabel (clojure.core/str v7595)))
   (clojure.core/when-let
    [v7595 (:template-name m7594)]
    (. bean7593 setTemplateName (clojure.core/str v7595)))
   (clojure.core/when-let
    [v7595 (:environment-id m7594)]
    (. bean7593 setEnvironmentId (clojure.core/str v7595)))
   (clojure.core/when-let
    [v7595 (:environment-name m7594)]
    (. bean7593 setEnvironmentName (clojure.core/str v7595)))
   (clojure.core/when-let
    [v7595 (:severity m7594)]
    (. bean7593 setSeverity (clojure.core/str v7595)))
   (clojure.core/when-let
    [v7595 (:severity m7594)]
    (. bean7593 setSeverity (event-severity v7595)))
   bean7593))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest describe-applications-request
  [m7597]
  (clojure.core/let
   [bean7596
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest)]
   (clojure.core/when-let
    [v7598 (:application-names m7597)]
    (.
     bean7596
     setApplicationNames
     (clojure.core/map
      (clojure.core/fn [arg7599] (clojure.core/str arg7599))
      v7598)))
   bean7596))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest check-dnsavailability-request
  [m7601]
  (clojure.core/let
   [bean7600
    (new
     com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest)]
   (clojure.core/when-let
    [v7602 (:cnameprefix m7601)]
    (. bean7600 setCNAMEPrefix (clojure.core/str v7602)))
   bean7600))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest restart-app-server-request
  [m7604]
  (clojure.core/let
   [bean7603
    (new
     com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest)]
   (clojure.core/when-let
    [v7605 (:environment-id m7604)]
    (. bean7603 setEnvironmentId (clojure.core/str v7605)))
   (clojure.core/when-let
    [v7605 (:environment-name m7604)]
    (. bean7603 setEnvironmentName (clojure.core/str v7605)))
   bean7603))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest update-application-version-request
  [m7607]
  (clojure.core/let
   [bean7606
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest)]
   (clojure.core/when-let
    [v7608 (:description m7607)]
    (. bean7606 setDescription (clojure.core/str v7608)))
   (clojure.core/when-let
    [v7608 (:application-name m7607)]
    (. bean7606 setApplicationName (clojure.core/str v7608)))
   (clojure.core/when-let
    [v7608 (:version-label m7607)]
    (. bean7606 setVersionLabel (clojure.core/str v7608)))
   bean7606))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest describe-environment-resources-request
  [m7610]
  (clojure.core/let
   [bean7609
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest)]
   (clojure.core/when-let
    [v7611 (:environment-id m7610)]
    (. bean7609 setEnvironmentId (clojure.core/str v7611)))
   (clojure.core/when-let
    [v7611 (:environment-name m7610)]
    (. bean7609 setEnvironmentName (clojure.core/str v7611)))
   bean7609))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest describe-environments-request
  [m7613]
  (clojure.core/let
   [bean7612
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest)]
   (clojure.core/when-let
    [v7614 (:application-name m7613)]
    (. bean7612 setApplicationName (clojure.core/str v7614)))
   (clojure.core/when-let
    [v7614 (:version-label m7613)]
    (. bean7612 setVersionLabel (clojure.core/str v7614)))
   (clojure.core/when-let
    [v7614 (:environment-ids m7613)]
    (.
     bean7612
     setEnvironmentIds
     (clojure.core/map
      (clojure.core/fn [arg7615] (clojure.core/str arg7615))
      v7614)))
   (clojure.core/when-let
    [v7614 (:environment-names m7613)]
    (.
     bean7612
     setEnvironmentNames
     (clojure.core/map
      (clojure.core/fn [arg7616] (clojure.core/str arg7616))
      v7614)))
   (clojure.core/when-let
    [v7614 (:include-deleted m7613)]
    (. bean7612 setIncludeDeleted (clojure.core/boolean v7614)))
   (clojure.core/when-let
    [v7614 (:included-deleted-back-to m7613)]
    (.
     bean7612
     setIncludedDeletedBackTo
     (com.palletops.awaze.common/to-date v7614)))
   bean7612))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest describe-application-versions-request
  [m7618]
  (clojure.core/let
   [bean7617
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest)]
   (clojure.core/when-let
    [v7619 (:application-name m7618)]
    (. bean7617 setApplicationName (clojure.core/str v7619)))
   (clojure.core/when-let
    [v7619 (:version-labels m7618)]
    (.
     bean7617
     setVersionLabels
     (clojure.core/map
      (clojure.core/fn [arg7620] (clojure.core/str arg7620))
      v7619)))
   bean7617))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest delete-application-version-request
  [m7622]
  (clojure.core/let
   [bean7621
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest)]
   (clojure.core/when-let
    [v7623 (:application-name m7622)]
    (. bean7621 setApplicationName (clojure.core/str v7623)))
   (clojure.core/when-let
    [v7623 (:version-label m7622)]
    (. bean7621 setVersionLabel (clojure.core/str v7623)))
   (clojure.core/when-let
    [v7623 (:delete-source-bundle m7622)]
    (. bean7621 setDeleteSourceBundle (clojure.core/boolean v7623)))
   bean7621))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest swap-environment-cnames-request
  [m7625]
  (clojure.core/let
   [bean7624
    (new
     com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest)]
   (clojure.core/when-let
    [v7626 (:source-environment-id m7625)]
    (. bean7624 setSourceEnvironmentId (clojure.core/str v7626)))
   (clojure.core/when-let
    [v7626 (:source-environment-name m7625)]
    (. bean7624 setSourceEnvironmentName (clojure.core/str v7626)))
   (clojure.core/when-let
    [v7626 (:destination-environment-id m7625)]
    (. bean7624 setDestinationEnvironmentId (clojure.core/str v7626)))
   (clojure.core/when-let
    [v7626 (:destination-environment-name m7625)]
    (.
     bean7624
     setDestinationEnvironmentName
     (clojure.core/str v7626)))
   bean7624))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest delete-configuration-template-request
  [m7628]
  (clojure.core/let
   [bean7627
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest)]
   (clojure.core/when-let
    [v7629 (:application-name m7628)]
    (. bean7627 setApplicationName (clojure.core/str v7629)))
   (clojure.core/when-let
    [v7629 (:template-name m7628)]
    (. bean7627 setTemplateName (clojure.core/str v7629)))
   bean7627))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest update-application-request
  [m7631]
  (clojure.core/let
   [bean7630
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest)]
   (clojure.core/when-let
    [v7632 (:description m7631)]
    (. bean7630 setDescription (clojure.core/str v7632)))
   (clojure.core/when-let
    [v7632 (:application-name m7631)]
    (. bean7630 setApplicationName (clojure.core/str v7632)))
   bean7630))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest list-available-solution-stacks-request
  [m7634]
  (clojure.core/let
   [bean7633
    (new
     com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest)]
   bean7633))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest update-configuration-template-request
  [m7637]
  (clojure.core/let
   [bean7636
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest)]
   (clojure.core/when-let
    [v7638 (:options-to-remove m7637)]
    (.
     bean7636
     setOptionsToRemove
     (clojure.core/map
      (clojure.core/fn [arg7639] (option-specification arg7639))
      v7638)))
   (clojure.core/when-let
    [v7638 (:option-settings m7637)]
    (.
     bean7636
     setOptionSettings
     (clojure.core/map
      (clojure.core/fn
       [arg7640]
       (configuration-option-setting arg7640))
      v7638)))
   (clojure.core/when-let
    [v7638 (:description m7637)]
    (. bean7636 setDescription (clojure.core/str v7638)))
   (clojure.core/when-let
    [v7638 (:application-name m7637)]
    (. bean7636 setApplicationName (clojure.core/str v7638)))
   (clojure.core/when-let
    [v7638 (:template-name m7637)]
    (. bean7636 setTemplateName (clojure.core/str v7638)))
   bean7636))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest request-environment-info-request
  [m7642]
  (clojure.core/let
   [bean7641
    (new
     com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest)]
   (clojure.core/when-let
    [v7643 (:environment-id m7642)]
    (. bean7641 setEnvironmentId (clojure.core/str v7643)))
   (clojure.core/when-let
    [v7643 (:environment-name m7642)]
    (. bean7641 setEnvironmentName (clojure.core/str v7643)))
   (clojure.core/when-let
    [v7643 (:info-type m7642)]
    (. bean7641 setInfoType (clojure.core/str v7643)))
   (clojure.core/when-let
    [v7643 (:info-type m7642)]
    (. bean7641 setInfoType (environment-info-type v7643)))
   bean7641))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest delete-environment-configuration-request
  [m7645]
  (clojure.core/let
   [bean7644
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest)]
   (clojure.core/when-let
    [v7646 (:application-name m7645)]
    (. bean7644 setApplicationName (clojure.core/str v7646)))
   (clojure.core/when-let
    [v7646 (:environment-name m7645)]
    (. bean7644 setEnvironmentName (clojure.core/str v7646)))
   bean7644))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest terminate-environment-request
  [m7648]
  (clojure.core/let
   [bean7647
    (new
     com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest)]
   (clojure.core/when-let
    [v7649 (:environment-id m7648)]
    (. bean7647 setEnvironmentId (clojure.core/str v7649)))
   (clojure.core/when-let
    [v7649 (:environment-name m7648)]
    (. bean7647 setEnvironmentName (clojure.core/str v7649)))
   (clojure.core/when-let
    [v7649 (:terminate-resources m7648)]
    (. bean7647 setTerminateResources (clojure.core/boolean v7649)))
   bean7647))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest retrieve-environment-info-request
  [m7651]
  (clojure.core/let
   [bean7650
    (new
     com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest)]
   (clojure.core/when-let
    [v7652 (:environment-id m7651)]
    (. bean7650 setEnvironmentId (clojure.core/str v7652)))
   (clojure.core/when-let
    [v7652 (:environment-name m7651)]
    (. bean7650 setEnvironmentName (clojure.core/str v7652)))
   (clojure.core/when-let
    [v7652 (:info-type m7651)]
    (. bean7650 setInfoType (clojure.core/str v7652)))
   (clojure.core/when-let
    [v7652 (:info-type m7651)]
    (. bean7650 setInfoType (environment-info-type v7652)))
   bean7650))
 (clojure.core/defmulti
  elasticbeanstalk
  (clojure.core/fn
   elasticbeanstalk
   [m__609__auto__]
   (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application
   [m7653]
   (clojure.core/let
    [credentials7654 (:credentials m7653) args7655 (:args m7653)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7656
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7654)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7656
       createApplication
       (create-application-request (clojure.core/nth args7655 0)))))))
  (clojure.core/defn
   create-application-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector description application-name]}]],
    :doc "Generate map for createApplication"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-application,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-application
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector description application-name]}]],
    :doc "Call createApplication"}
   [credentials7658 & args7659]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7660
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7658)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7660
      createApplication
      (create-application-request (clojure.core/nth args7659 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application
   [m7661]
   (clojure.core/let
    [credentials7662 (:credentials m7661) args7663 (:args m7661)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7664
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7662)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7664
       deleteApplication
       (delete-application-request (clojure.core/nth args7663 0)))))))
  (clojure.core/defn
   delete-application-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector application-name]}]],
    :doc "Generate map for deleteApplication"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-application,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-application
   {:arglists
    '[[credentials
       {:keys [request-metric-collector application-name]}]],
    :doc "Call deleteApplication"}
   [credentials7666 & args7667]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7668
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7666)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7668
      deleteApplication
      (delete-application-request (clojure.core/nth args7667 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-environment
   [m7669]
   (clojure.core/let
    [credentials7670 (:credentials m7669) args7671 (:args m7669)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7672
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7670)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7672
       createEnvironment
       (create-environment-request (clojure.core/nth args7671 0)))))))
  (clojure.core/defn
   create-environment-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         option-settings
         version-label
         cnameprefix
         application-name
         solution-stack-name
         environment-name
         description
         options-to-remove
         template-name]}]],
    :doc "Generate map for createEnvironment"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-environment,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-environment
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         option-settings
         version-label
         cnameprefix
         application-name
         solution-stack-name
         environment-name
         description
         options-to-remove
         template-name]}]],
    :doc "Call createEnvironment"}
   [credentials7674 & args7675]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7676
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7674)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7676
      createEnvironment
      (create-environment-request (clojure.core/nth args7675 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-settings
   [m7677]
   (clojure.core/let
    [credentials7678 (:credentials m7677) args7679 (:args m7677)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7680
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7678)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7680
       describeConfigurationSettings
       (describe-configuration-settings-request
        (clojure.core/nth args7679 0)))))))
  (clojure.core/defn
   describe-configuration-settings-map
   {:arglists
    '[[credentials
       {:keys
        [template-name
         request-metric-collector
         environment-name
         application-name]}]],
    :doc "Generate map for describeConfigurationSettings"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-configuration-settings,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-configuration-settings
   {:arglists
    '[[credentials
       {:keys
        [template-name
         request-metric-collector
         environment-name
         application-name]}]],
    :doc "Call describeConfigurationSettings"}
   [credentials7682 & args7683]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7684
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7682)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7684
      describeConfigurationSettings
      (describe-configuration-settings-request
       (clojure.core/nth args7683 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-storage-location
   [m7685]
   (clojure.core/let
    [credentials7686 (:credentials m7685) args7687 (:args m7685)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7688
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7686)]
     (clojure.core/case
      (clojure.core/count args7687)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7688
        createStorageLocation
        (create-storage-location-request
         (clojure.core/nth args7687 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7688
        createStorageLocation))))))
  (clojure.core/defn
   create-storage-location-map
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc
    "Generate map for createStorageLocation, createStorageLocation"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :create-storage-location,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-storage-location,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-storage-location
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc "Call createStorageLocation, createStorageLocation"}
   [credentials7690 & args7691]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7692
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7690)]
    (clojure.core/case
     (clojure.core/count args7691)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7692
       createStorageLocation
       (create-storage-location-request
        (clojure.core/nth args7691 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7692
       createStorageLocation))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-options
   [m7693]
   (clojure.core/let
    [credentials7694 (:credentials m7693) args7695 (:args m7693)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7696
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7694)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7696
       describeConfigurationOptions
       (describe-configuration-options-request
        (clojure.core/nth args7695 0)))))))
  (clojure.core/defn
   describe-configuration-options-map
   {:arglists
    '[[credentials
       {:keys
        [template-name
         solution-stack-name
         request-metric-collector
         options
         environment-name
         application-name]}]],
    :doc "Generate map for describeConfigurationOptions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-configuration-options,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-configuration-options
   {:arglists
    '[[credentials
       {:keys
        [template-name
         solution-stack-name
         request-metric-collector
         options
         environment-name
         application-name]}]],
    :doc "Call describeConfigurationOptions"}
   [credentials7698 & args7699]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7700
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7698)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7700
      describeConfigurationOptions
      (describe-configuration-options-request
       (clojure.core/nth args7699 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :rebuild-environment
   [m7701]
   (clojure.core/let
    [credentials7702 (:credentials m7701) args7703 (:args m7701)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7704
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7702)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7704
       rebuildEnvironment
       (rebuild-environment-request (clojure.core/nth args7703 0)))))))
  (clojure.core/defn
   rebuild-environment-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector environment-name environment-id]}]],
    :doc "Generate map for rebuildEnvironment"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :rebuild-environment,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   rebuild-environment
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector environment-name environment-id]}]],
    :doc "Call rebuildEnvironment"}
   [credentials7706 & args7707]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7708
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7706)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7708
      rebuildEnvironment
      (rebuild-environment-request (clojure.core/nth args7707 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application-version
   [m7709]
   (clojure.core/let
    [credentials7710 (:credentials m7709) args7711 (:args m7709)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7712
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7710)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7712
       createApplicationVersion
       (create-application-version-request
        (clojure.core/nth args7711 0)))))))
  (clojure.core/defn
   create-application-version-map
   {:arglists
    '[[credentials
       {:keys
        [version-label
         source-bundle
         request-metric-collector
         description
         auto-create-application
         application-name]}]],
    :doc "Generate map for createApplicationVersion"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-application-version,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-application-version
   {:arglists
    '[[credentials
       {:keys
        [version-label
         source-bundle
         request-metric-collector
         description
         auto-create-application
         application-name]}]],
    :doc "Call createApplicationVersion"}
   [credentials7714 & args7715]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7716
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7714)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7716
      createApplicationVersion
      (create-application-version-request
       (clojure.core/nth args7715 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-environment
   [m7717]
   (clojure.core/let
    [credentials7718 (:credentials m7717) args7719 (:args m7717)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7720
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7718)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7720
       updateEnvironment
       (update-environment-request (clojure.core/nth args7719 0)))))))
  (clojure.core/defn
   update-environment-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         environment-id
         option-settings
         version-label
         environment-name
         description
         options-to-remove
         template-name]}]],
    :doc "Generate map for updateEnvironment"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-environment,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-environment
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         environment-id
         option-settings
         version-label
         environment-name
         description
         options-to-remove
         template-name]}]],
    :doc "Call updateEnvironment"}
   [credentials7722 & args7723]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7724
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7722)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7724
      updateEnvironment
      (update-environment-request (clojure.core/nth args7723 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-configuration-template
   [m7725]
   (clojure.core/let
    [credentials7726 (:credentials m7725) args7727 (:args m7725)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7728
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7726)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7728
       createConfigurationTemplate
       (create-configuration-template-request
        (clojure.core/nth args7727 0)))))))
  (clojure.core/defn
   create-configuration-template-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         environment-id
         option-settings
         source-configuration
         application-name
         solution-stack-name
         description
         template-name]}]],
    :doc "Generate map for createConfigurationTemplate"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-configuration-template,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-configuration-template
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         environment-id
         option-settings
         source-configuration
         application-name
         solution-stack-name
         description
         template-name]}]],
    :doc "Call createConfigurationTemplate"}
   [credentials7730 & args7731]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7732
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7730)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7732
      createConfigurationTemplate
      (create-configuration-template-request
       (clojure.core/nth args7731 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :validate-configuration-settings
   [m7733]
   (clojure.core/let
    [credentials7734 (:credentials m7733) args7735 (:args m7733)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7736
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7734)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7736
       validateConfigurationSettings
       (validate-configuration-settings-request
        (clojure.core/nth args7735 0)))))))
  (clojure.core/defn
   validate-configuration-settings-map
   {:arglists
    '[[credentials
       {:keys
        [template-name
         request-metric-collector
         option-settings
         environment-name
         application-name]}]],
    :doc "Generate map for validateConfigurationSettings"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :validate-configuration-settings,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   validate-configuration-settings
   {:arglists
    '[[credentials
       {:keys
        [template-name
         request-metric-collector
         option-settings
         environment-name
         application-name]}]],
    :doc "Call validateConfigurationSettings"}
   [credentials7738 & args7739]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7740
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7738)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7740
      validateConfigurationSettings
      (validate-configuration-settings-request
       (clojure.core/nth args7739 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-events
   [m7741]
   (clojure.core/let
    [credentials7742 (:credentials m7741) args7743 (:args m7741)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7744
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7742)]
     (clojure.core/case
      (clojure.core/count args7743)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7744
        describeEvents
        (describe-events-request (clojure.core/nth args7743 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7744
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists
    '[[credentials
       {:keys
        [end-time
         request-metric-collector
         environment-id
         max-records
         start-time
         version-label
         application-name
         environment-name
         next-token
         severity
         template-name
         request-id]}]
      [credentials]],
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-events,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-events,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists
    '[[credentials
       {:keys
        [end-time
         request-metric-collector
         environment-id
         max-records
         start-time
         version-label
         application-name
         environment-name
         next-token
         severity
         template-name
         request-id]}]
      [credentials]],
    :doc "Call describeEvents, describeEvents"}
   [credentials7746 & args7747]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7748
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7746)]
    (clojure.core/case
     (clojure.core/count args7747)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7748
       describeEvents
       (describe-events-request (clojure.core/nth args7747 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7748
       describeEvents))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-applications
   [m7749]
   (clojure.core/let
    [credentials7750 (:credentials m7749) args7751 (:args m7749)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7752
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7750)]
     (clojure.core/case
      (clojure.core/count args7751)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7752
        describeApplications
        (describe-applications-request (clojure.core/nth args7751 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7752
        describeApplications))))))
  (clojure.core/defn
   describe-applications-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector application-names]}]
      [credentials]],
    :doc "Generate map for describeApplications, describeApplications"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-applications,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-applications,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-applications
   {:arglists
    '[[credentials
       {:keys [request-metric-collector application-names]}]
      [credentials]],
    :doc "Call describeApplications, describeApplications"}
   [credentials7754 & args7755]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7756
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7754)]
    (clojure.core/case
     (clojure.core/count args7755)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7756
       describeApplications
       (describe-applications-request (clojure.core/nth args7755 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7756
       describeApplications))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :check-dnsavailability
   [m7757]
   (clojure.core/let
    [credentials7758 (:credentials m7757) args7759 (:args m7757)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7760
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7758)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7760
       checkDNSAvailability
       (check-dnsavailability-request
        (clojure.core/nth args7759 0)))))))
  (clojure.core/defn
   check-dnsavailability-map
   {:arglists
    '[[credentials {:keys [request-metric-collector cnameprefix]}]],
    :doc "Generate map for checkDNSAvailability"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :check-dnsavailability,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   check-dnsavailability
   {:arglists
    '[[credentials {:keys [request-metric-collector cnameprefix]}]],
    :doc "Call checkDNSAvailability"}
   [credentials7762 & args7763]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7764
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7762)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7764
      checkDNSAvailability
      (check-dnsavailability-request
       (clojure.core/nth args7763 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :restart-app-server
   [m7765]
   (clojure.core/let
    [credentials7766 (:credentials m7765) args7767 (:args m7765)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7768
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7766)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7768
       restartAppServer
       (restart-app-server-request (clojure.core/nth args7767 0)))))))
  (clojure.core/defn
   restart-app-server-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector environment-name environment-id]}]],
    :doc "Generate map for restartAppServer"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :restart-app-server,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   restart-app-server
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector environment-name environment-id]}]],
    :doc "Call restartAppServer"}
   [credentials7770 & args7771]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7772
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7770)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7772
      restartAppServer
      (restart-app-server-request (clojure.core/nth args7771 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application-version
   [m7773]
   (clojure.core/let
    [credentials7774 (:credentials m7773) args7775 (:args m7773)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7776
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7774)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7776
       updateApplicationVersion
       (update-application-version-request
        (clojure.core/nth args7775 0)))))))
  (clojure.core/defn
   update-application-version-map
   {:arglists
    '[[credentials
       {:keys
        [version-label
         request-metric-collector
         description
         application-name]}]],
    :doc "Generate map for updateApplicationVersion"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-application-version,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-application-version
   {:arglists
    '[[credentials
       {:keys
        [version-label
         request-metric-collector
         description
         application-name]}]],
    :doc "Call updateApplicationVersion"}
   [credentials7778 & args7779]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7780
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7778)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7780
      updateApplicationVersion
      (update-application-version-request
       (clojure.core/nth args7779 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environment-resources
   [m7781]
   (clojure.core/let
    [credentials7782 (:credentials m7781) args7783 (:args m7781)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7784
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7782)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7784
       describeEnvironmentResources
       (describe-environment-resources-request
        (clojure.core/nth args7783 0)))))))
  (clojure.core/defn
   describe-environment-resources-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector environment-name environment-id]}]],
    :doc "Generate map for describeEnvironmentResources"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-environment-resources,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-environment-resources
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector environment-name environment-id]}]],
    :doc "Call describeEnvironmentResources"}
   [credentials7786 & args7787]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7788
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7786)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7788
      describeEnvironmentResources
      (describe-environment-resources-request
       (clojure.core/nth args7787 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environments
   [m7789]
   (clojure.core/let
    [credentials7790 (:credentials m7789) args7791 (:args m7789)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7792
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7790)]
     (clojure.core/case
      (clojure.core/count args7791)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7792
        describeEnvironments))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7792
        describeEnvironments
        (describe-environments-request
         (clojure.core/nth args7791 0))))))))
  (clojure.core/defn
   describe-environments-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [version-label
         environment-names
         include-deleted
         included-deleted-back-to
         application-name
         request-metric-collector
         environment-ids]}]],
    :doc "Generate map for describeEnvironments, describeEnvironments"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-environments,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-environments,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-environments
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [version-label
         environment-names
         include-deleted
         included-deleted-back-to
         application-name
         request-metric-collector
         environment-ids]}]],
    :doc "Call describeEnvironments, describeEnvironments"}
   [credentials7794 & args7795]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7796
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7794)]
    (clojure.core/case
     (clojure.core/count args7795)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7796
       describeEnvironments))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7796
       describeEnvironments
       (describe-environments-request
        (clojure.core/nth args7795 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-application-versions
   [m7797]
   (clojure.core/let
    [credentials7798 (:credentials m7797) args7799 (:args m7797)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7800
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7798)]
     (clojure.core/case
      (clojure.core/count args7799)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7800
        describeApplicationVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7800
        describeApplicationVersions
        (describe-application-versions-request
         (clojure.core/nth args7799 0))))))))
  (clojure.core/defn
   describe-application-versions-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [version-labels request-metric-collector application-name]}]],
    :doc
    "Generate map for describeApplicationVersions, describeApplicationVersions"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-application-versions,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-application-versions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-application-versions
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [version-labels request-metric-collector application-name]}]],
    :doc
    "Call describeApplicationVersions, describeApplicationVersions"}
   [credentials7802 & args7803]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7804
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7802)]
    (clojure.core/case
     (clojure.core/count args7803)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7804
       describeApplicationVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7804
       describeApplicationVersions
       (describe-application-versions-request
        (clojure.core/nth args7803 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application-version
   [m7805]
   (clojure.core/let
    [credentials7806 (:credentials m7805) args7807 (:args m7805)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7808
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7806)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7808
       deleteApplicationVersion
       (delete-application-version-request
        (clojure.core/nth args7807 0)))))))
  (clojure.core/defn
   delete-application-version-map
   {:arglists
    '[[credentials
       {:keys
        [version-label
         request-metric-collector
         delete-source-bundle
         application-name]}]],
    :doc "Generate map for deleteApplicationVersion"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-application-version,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-application-version
   {:arglists
    '[[credentials
       {:keys
        [version-label
         request-metric-collector
         delete-source-bundle
         application-name]}]],
    :doc "Call deleteApplicationVersion"}
   [credentials7810 & args7811]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7812
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7810)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7812
      deleteApplicationVersion
      (delete-application-version-request
       (clojure.core/nth args7811 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :swap-environment-cnames
   [m7813]
   (clojure.core/let
    [credentials7814 (:credentials m7813) args7815 (:args m7813)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7816
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7814)]
     (clojure.core/case
      (clojure.core/count args7815)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7816
        swapEnvironmentCNAMEs
        (swap-environment-cnames-request
         (clojure.core/nth args7815 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7816
        swapEnvironmentCNAMEs))))))
  (clojure.core/defn
   swap-environment-cnames-map
   {:arglists
    '[[credentials
       {:keys
        [source-environment-name
         source-environment-id
         request-metric-collector
         destination-environment-name
         destination-environment-id]}]
      [credentials]],
    :doc
    "Generate map for swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :swap-environment-cnames,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :swap-environment-cnames,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   swap-environment-cnames
   {:arglists
    '[[credentials
       {:keys
        [source-environment-name
         source-environment-id
         request-metric-collector
         destination-environment-name
         destination-environment-id]}]
      [credentials]],
    :doc "Call swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   [credentials7818 & args7819]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7820
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7818)]
    (clojure.core/case
     (clojure.core/count args7819)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7820
       swapEnvironmentCNAMEs
       (swap-environment-cnames-request
        (clojure.core/nth args7819 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7820
       swapEnvironmentCNAMEs))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-configuration-template
   [m7821]
   (clojure.core/let
    [credentials7822 (:credentials m7821) args7823 (:args m7821)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7824
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7822)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7824
       deleteConfigurationTemplate
       (delete-configuration-template-request
        (clojure.core/nth args7823 0)))))))
  (clojure.core/defn
   delete-configuration-template-map
   {:arglists
    '[[credentials
       {:keys
        [template-name request-metric-collector application-name]}]],
    :doc "Generate map for deleteConfigurationTemplate"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-configuration-template,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-configuration-template
   {:arglists
    '[[credentials
       {:keys
        [template-name request-metric-collector application-name]}]],
    :doc "Call deleteConfigurationTemplate"}
   [credentials7826 & args7827]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7828
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7826)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7828
      deleteConfigurationTemplate
      (delete-configuration-template-request
       (clojure.core/nth args7827 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application
   [m7829]
   (clojure.core/let
    [credentials7830 (:credentials m7829) args7831 (:args m7829)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7832
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7830)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7832
       updateApplication
       (update-application-request (clojure.core/nth args7831 0)))))))
  (clojure.core/defn
   update-application-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector description application-name]}]],
    :doc "Generate map for updateApplication"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-application,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-application
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector description application-name]}]],
    :doc "Call updateApplication"}
   [credentials7834 & args7835]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7836
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7834)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7836
      updateApplication
      (update-application-request (clojure.core/nth args7835 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :list-available-solution-stacks
   [m7837]
   (clojure.core/let
    [credentials7838 (:credentials m7837) args7839 (:args m7837)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7840
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7838)]
     (clojure.core/case
      (clojure.core/count args7839)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7840
        listAvailableSolutionStacks
        (list-available-solution-stacks-request
         (clojure.core/nth args7839 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7840
        listAvailableSolutionStacks))))))
  (clojure.core/defn
   list-available-solution-stacks-map
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc
    "Generate map for listAvailableSolutionStacks, listAvailableSolutionStacks"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :list-available-solution-stacks,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :list-available-solution-stacks,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-available-solution-stacks
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc
    "Call listAvailableSolutionStacks, listAvailableSolutionStacks"}
   [credentials7842 & args7843]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7844
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7842)]
    (clojure.core/case
     (clojure.core/count args7843)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7844
       listAvailableSolutionStacks
       (list-available-solution-stacks-request
        (clojure.core/nth args7843 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7844
       listAvailableSolutionStacks))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-configuration-template
   [m7845]
   (clojure.core/let
    [credentials7846 (:credentials m7845) args7847 (:args m7845)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7848
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7846)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7848
       updateConfigurationTemplate
       (update-configuration-template-request
        (clojure.core/nth args7847 0)))))))
  (clojure.core/defn
   update-configuration-template-map
   {:arglists
    '[[credentials
       {:keys
        [template-name
         request-metric-collector
         options-to-remove
         option-settings
         description
         application-name]}]],
    :doc "Generate map for updateConfigurationTemplate"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-configuration-template,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-configuration-template
   {:arglists
    '[[credentials
       {:keys
        [template-name
         request-metric-collector
         options-to-remove
         option-settings
         description
         application-name]}]],
    :doc "Call updateConfigurationTemplate"}
   [credentials7850 & args7851]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7852
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7850)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7852
      updateConfigurationTemplate
      (update-configuration-template-request
       (clojure.core/nth args7851 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :request-environment-info
   [m7853]
   (clojure.core/let
    [credentials7854 (:credentials m7853) args7855 (:args m7853)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7856
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7854)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7856
       requestEnvironmentInfo
       (request-environment-info-request
        (clojure.core/nth args7855 0)))))))
  (clojure.core/defn
   request-environment-info-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         info-type
         environment-name
         environment-id]}]],
    :doc "Generate map for requestEnvironmentInfo"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :request-environment-info,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   request-environment-info
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         info-type
         environment-name
         environment-id]}]],
    :doc "Call requestEnvironmentInfo"}
   [credentials7858 & args7859]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7860
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7858)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7860
      requestEnvironmentInfo
      (request-environment-info-request
       (clojure.core/nth args7859 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-environment-configuration
   [m7861]
   (clojure.core/let
    [credentials7862 (:credentials m7861) args7863 (:args m7861)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7864
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7862)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7864
       deleteEnvironmentConfiguration
       (delete-environment-configuration-request
        (clojure.core/nth args7863 0)))))))
  (clojure.core/defn
   delete-environment-configuration-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         environment-name
         application-name]}]],
    :doc "Generate map for deleteEnvironmentConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-environment-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-environment-configuration
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         environment-name
         application-name]}]],
    :doc "Call deleteEnvironmentConfiguration"}
   [credentials7866 & args7867]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7868
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7866)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7868
      deleteEnvironmentConfiguration
      (delete-environment-configuration-request
       (clojure.core/nth args7867 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :terminate-environment
   [m7869]
   (clojure.core/let
    [credentials7870 (:credentials m7869) args7871 (:args m7869)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7872
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7870)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7872
       terminateEnvironment
       (terminate-environment-request
        (clojure.core/nth args7871 0)))))))
  (clojure.core/defn
   terminate-environment-map
   {:arglists
    '[[credentials
       {:keys
        [terminate-resources
         request-metric-collector
         environment-name
         environment-id]}]],
    :doc "Generate map for terminateEnvironment"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :terminate-environment,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   terminate-environment
   {:arglists
    '[[credentials
       {:keys
        [terminate-resources
         request-metric-collector
         environment-name
         environment-id]}]],
    :doc "Call terminateEnvironment"}
   [credentials7874 & args7875]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7876
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7874)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7876
      terminateEnvironment
      (terminate-environment-request
       (clojure.core/nth args7875 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :retrieve-environment-info
   [m7877]
   (clojure.core/let
    [credentials7878 (:credentials m7877) args7879 (:args m7877)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7880
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials7878)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7880
       retrieveEnvironmentInfo
       (retrieve-environment-info-request
        (clojure.core/nth args7879 0)))))))
  (clojure.core/defn
   retrieve-environment-info-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         info-type
         environment-name
         environment-id]}]],
    :doc "Generate map for retrieveEnvironmentInfo"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :retrieve-environment-info,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   retrieve-environment-info
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         info-type
         environment-name
         environment-id]}]],
    :doc "Call retrieveEnvironmentInfo"}
   [credentials7882 & args7883]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7884
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials7882)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client7884
      retrieveEnvironmentInfo
      (retrieve-environment-info-request
       (clojure.core/nth args7883 0))))))))
