(ns com.palletops.awaze.elasticache (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticache
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.elasticache.AmazonElastiCacheClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.ParameterNameValue parameter-name-value
  [m9003]
  (clojure.core/let
   [bean9002
    (new com.amazonaws.services.elasticache.model.ParameterNameValue)]
   (clojure.core/when-let
    [v9004 (:parameter-name m9003)]
    (. bean9002 setParameterName (clojure.core/str v9004)))
   (clojure.core/when-let
    [v9004 (:parameter-value m9003)]
    (. bean9002 setParameterValue (clojure.core/str v9004)))
   bean9002))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.SourceType source-type
  [m9006]
  (java.lang.Enum/valueOf
   com.amazonaws.services.elasticache.model.SourceType
   (clojure.core/name m9006)))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest describe-cache-parameter-groups-request
  [m9009]
  (clojure.core/let
   [bean9008
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest)]
   (clojure.core/when-let
    [v9010 (:marker m9009)]
    (. bean9008 setMarker (clojure.core/str v9010)))
   (clojure.core/when-let
    [v9010 (:max-records m9009)]
    (. bean9008 setMaxRecords (clojure.core/int v9010)))
   (clojure.core/when-let
    [v9010 (:cache-parameter-group-name m9009)]
    (. bean9008 setCacheParameterGroupName (clojure.core/str v9010)))
   bean9008))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest create-cache-parameter-group-request
  [m9012]
  (clojure.core/let
   [bean9011
    (new
     com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v9013 (:description m9012)]
    (. bean9011 setDescription (clojure.core/str v9013)))
   (clojure.core/when-let
    [v9013 (:cache-parameter-group-family m9012)]
    (. bean9011 setCacheParameterGroupFamily (clojure.core/str v9013)))
   (clojure.core/when-let
    [v9013 (:cache-parameter-group-name m9012)]
    (. bean9011 setCacheParameterGroupName (clojure.core/str v9013)))
   bean9011))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest revoke-cache-security-group-ingress-request
  [m9015]
  (clojure.core/let
   [bean9014
    (new
     com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v9016 (:ec2security-group-name m9015)]
    (. bean9014 setEC2SecurityGroupName (clojure.core/str v9016)))
   (clojure.core/when-let
    [v9016 (:ec2security-group-owner-id m9015)]
    (. bean9014 setEC2SecurityGroupOwnerId (clojure.core/str v9016)))
   (clojure.core/when-let
    [v9016 (:cache-security-group-name m9015)]
    (. bean9014 setCacheSecurityGroupName (clojure.core/str v9016)))
   bean9014))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest create-replication-group-request
  [m9018]
  (clojure.core/let
   [bean9017
    (new
     com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest)]
   (clojure.core/when-let
    [v9019 (:replication-group-id m9018)]
    (. bean9017 setReplicationGroupId (clojure.core/str v9019)))
   (clojure.core/when-let
    [v9019 (:primary-cluster-id m9018)]
    (. bean9017 setPrimaryClusterId (clojure.core/str v9019)))
   (clojure.core/when-let
    [v9019 (:replication-group-description m9018)]
    (.
     bean9017
     setReplicationGroupDescription
     (clojure.core/str v9019)))
   bean9017))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest authorize-cache-security-group-ingress-request
  [m9021]
  (clojure.core/let
   [bean9020
    (new
     com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v9022 (:ec2security-group-name m9021)]
    (. bean9020 setEC2SecurityGroupName (clojure.core/str v9022)))
   (clojure.core/when-let
    [v9022 (:ec2security-group-owner-id m9021)]
    (. bean9020 setEC2SecurityGroupOwnerId (clojure.core/str v9022)))
   (clojure.core/when-let
    [v9022 (:cache-security-group-name m9021)]
    (. bean9020 setCacheSecurityGroupName (clojure.core/str v9022)))
   bean9020))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest describe-reserved-cache-nodes-request
  [m9024]
  (clojure.core/let
   [bean9023
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest)]
   (clojure.core/when-let
    [v9025 (:product-description m9024)]
    (. bean9023 setProductDescription (clojure.core/str v9025)))
   (clojure.core/when-let
    [v9025 (:marker m9024)]
    (. bean9023 setMarker (clojure.core/str v9025)))
   (clojure.core/when-let
    [v9025 (:max-records m9024)]
    (. bean9023 setMaxRecords (clojure.core/int v9025)))
   (clojure.core/when-let
    [v9025 (:duration m9024)]
    (. bean9023 setDuration (clojure.core/str v9025)))
   (clojure.core/when-let
    [v9025 (:offering-type m9024)]
    (. bean9023 setOfferingType (clojure.core/str v9025)))
   (clojure.core/when-let
    [v9025 (:cache-node-type m9024)]
    (. bean9023 setCacheNodeType (clojure.core/str v9025)))
   (clojure.core/when-let
    [v9025 (:reserved-cache-nodes-offering-id m9024)]
    (.
     bean9023
     setReservedCacheNodesOfferingId
     (clojure.core/str v9025)))
   (clojure.core/when-let
    [v9025 (:reserved-cache-node-id m9024)]
    (. bean9023 setReservedCacheNodeId (clojure.core/str v9025)))
   bean9023))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest modify-cache-cluster-request
  [m9027]
  (clojure.core/let
   [bean9026
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest)]
   (clojure.core/when-let
    [v9028 (:security-group-ids m9027)]
    (.
     bean9026
     setSecurityGroupIds
     (clojure.core/map
      (clojure.core/fn [arg9029] (clojure.core/str arg9029))
      v9028)))
   (clojure.core/when-let
    [v9028 (:engine-version m9027)]
    (. bean9026 setEngineVersion (clojure.core/str v9028)))
   (clojure.core/when-let
    [v9028 (:auto-minor-version-upgrade m9027)]
    (.
     bean9026
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v9028)))
   (clojure.core/when-let
    [v9028 (:apply-immediately m9027)]
    (. bean9026 setApplyImmediately (clojure.core/boolean v9028)))
   (clojure.core/when-let
    [v9028 (:preferred-maintenance-window m9027)]
    (.
     bean9026
     setPreferredMaintenanceWindow
     (clojure.core/str v9028)))
   (clojure.core/when-let
    [v9028 (:cache-cluster-id m9027)]
    (. bean9026 setCacheClusterId (clojure.core/str v9028)))
   (clojure.core/when-let
    [v9028 (:num-cache-nodes m9027)]
    (. bean9026 setNumCacheNodes (clojure.core/int v9028)))
   (clojure.core/when-let
    [v9028 (:cache-node-ids-to-remove m9027)]
    (.
     bean9026
     setCacheNodeIdsToRemove
     (clojure.core/map
      (clojure.core/fn [arg9030] (clojure.core/str arg9030))
      v9028)))
   (clojure.core/when-let
    [v9028 (:cache-security-group-names m9027)]
    (.
     bean9026
     setCacheSecurityGroupNames
     (clojure.core/map
      (clojure.core/fn [arg9031] (clojure.core/str arg9031))
      v9028)))
   (clojure.core/when-let
    [v9028 (:notification-topic-arn m9027)]
    (. bean9026 setNotificationTopicArn (clojure.core/str v9028)))
   (clojure.core/when-let
    [v9028 (:cache-parameter-group-name m9027)]
    (. bean9026 setCacheParameterGroupName (clojure.core/str v9028)))
   (clojure.core/when-let
    [v9028 (:notification-topic-status m9027)]
    (. bean9026 setNotificationTopicStatus (clojure.core/str v9028)))
   bean9026))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest delete-cache-subnet-group-request
  [m9033]
  (clojure.core/let
   [bean9032
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest)]
   (clojure.core/when-let
    [v9034 (:cache-subnet-group-name m9033)]
    (. bean9032 setCacheSubnetGroupName (clojure.core/str v9034)))
   bean9032))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest describe-cache-engine-versions-request
  [m9036]
  (clojure.core/let
   [bean9035
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest)]
   (clojure.core/when-let
    [v9037 (:engine m9036)]
    (. bean9035 setEngine (clojure.core/str v9037)))
   (clojure.core/when-let
    [v9037 (:engine-version m9036)]
    (. bean9035 setEngineVersion (clojure.core/str v9037)))
   (clojure.core/when-let
    [v9037 (:default-only m9036)]
    (. bean9035 setDefaultOnly (clojure.core/boolean v9037)))
   (clojure.core/when-let
    [v9037 (:marker m9036)]
    (. bean9035 setMarker (clojure.core/str v9037)))
   (clojure.core/when-let
    [v9037 (:max-records m9036)]
    (. bean9035 setMaxRecords (clojure.core/int v9037)))
   (clojure.core/when-let
    [v9037 (:cache-parameter-group-family m9036)]
    (. bean9035 setCacheParameterGroupFamily (clojure.core/str v9037)))
   bean9035))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest reset-cache-parameter-group-request
  [m9039]
  (clojure.core/let
   [bean9038
    (new
     com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v9040 (:reset-all-parameters m9039)]
    (. bean9038 setResetAllParameters (clojure.core/boolean v9040)))
   (clojure.core/when-let
    [v9040 (:cache-parameter-group-name m9039)]
    (. bean9038 setCacheParameterGroupName (clojure.core/str v9040)))
   (clojure.core/when-let
    [v9040 (:parameter-name-values m9039)]
    (.
     bean9038
     setParameterNameValues
     (clojure.core/map
      (clojure.core/fn [arg9041] (parameter-name-value arg9041))
      v9040)))
   bean9038))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest describe-engine-default-parameters-request
  [m9043]
  (clojure.core/let
   [bean9042
    (new
     com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest)]
   (clojure.core/when-let
    [v9044 (:marker m9043)]
    (. bean9042 setMarker (clojure.core/str v9044)))
   (clojure.core/when-let
    [v9044 (:max-records m9043)]
    (. bean9042 setMaxRecords (clojure.core/int v9044)))
   (clojure.core/when-let
    [v9044 (:cache-parameter-group-family m9043)]
    (. bean9042 setCacheParameterGroupFamily (clojure.core/str v9044)))
   bean9042))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest delete-cache-cluster-request
  [m9046]
  (clojure.core/let
   [bean9045
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest)]
   (clojure.core/when-let
    [v9047 (:cache-cluster-id m9046)]
    (. bean9045 setCacheClusterId (clojure.core/str v9047)))
   bean9045))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest describe-cache-subnet-groups-request
  [m9049]
  (clojure.core/let
   [bean9048
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest)]
   (clojure.core/when-let
    [v9050 (:marker m9049)]
    (. bean9048 setMarker (clojure.core/str v9050)))
   (clojure.core/when-let
    [v9050 (:max-records m9049)]
    (. bean9048 setMaxRecords (clojure.core/int v9050)))
   (clojure.core/when-let
    [v9050 (:cache-subnet-group-name m9049)]
    (. bean9048 setCacheSubnetGroupName (clojure.core/str v9050)))
   bean9048))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest describe-replication-groups-request
  [m9052]
  (clojure.core/let
   [bean9051
    (new
     com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest)]
   (clojure.core/when-let
    [v9053 (:marker m9052)]
    (. bean9051 setMarker (clojure.core/str v9053)))
   (clojure.core/when-let
    [v9053 (:max-records m9052)]
    (. bean9051 setMaxRecords (clojure.core/int v9053)))
   (clojure.core/when-let
    [v9053 (:replication-group-id m9052)]
    (. bean9051 setReplicationGroupId (clojure.core/str v9053)))
   bean9051))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest describe-cache-security-groups-request
  [m9055]
  (clojure.core/let
   [bean9054
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest)]
   (clojure.core/when-let
    [v9056 (:marker m9055)]
    (. bean9054 setMarker (clojure.core/str v9056)))
   (clojure.core/when-let
    [v9056 (:max-records m9055)]
    (. bean9054 setMaxRecords (clojure.core/int v9056)))
   (clojure.core/when-let
    [v9056 (:cache-security-group-name m9055)]
    (. bean9054 setCacheSecurityGroupName (clojure.core/str v9056)))
   bean9054))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest create-cache-security-group-request
  [m9058]
  (clojure.core/let
   [bean9057
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest)]
   (clojure.core/when-let
    [v9059 (:description m9058)]
    (. bean9057 setDescription (clojure.core/str v9059)))
   (clojure.core/when-let
    [v9059 (:cache-security-group-name m9058)]
    (. bean9057 setCacheSecurityGroupName (clojure.core/str v9059)))
   bean9057))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest describe-cache-clusters-request
  [m9061]
  (clojure.core/let
   [bean9060
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest)]
   (clojure.core/when-let
    [v9062 (:marker m9061)]
    (. bean9060 setMarker (clojure.core/str v9062)))
   (clojure.core/when-let
    [v9062 (:max-records m9061)]
    (. bean9060 setMaxRecords (clojure.core/int v9062)))
   (clojure.core/when-let
    [v9062 (:cache-cluster-id m9061)]
    (. bean9060 setCacheClusterId (clojure.core/str v9062)))
   (clojure.core/when-let
    [v9062 (:show-cache-node-info m9061)]
    (. bean9060 setShowCacheNodeInfo (clojure.core/boolean v9062)))
   bean9060))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeEventsRequest describe-events-request
  [m9064]
  (clojure.core/let
   [bean9063
    (new
     com.amazonaws.services.elasticache.model.DescribeEventsRequest)]
   (clojure.core/when-let
    [v9065 (:marker m9064)]
    (. bean9063 setMarker (clojure.core/str v9065)))
   (clojure.core/when-let
    [v9065 (:max-records m9064)]
    (. bean9063 setMaxRecords (clojure.core/int v9065)))
   (clojure.core/when-let
    [v9065 (:start-time m9064)]
    (.
     bean9063
     setStartTime
     (com.palletops.awaze.common/to-date v9065)))
   (clojure.core/when-let
    [v9065 (:duration m9064)]
    (. bean9063 setDuration (clojure.core/int v9065)))
   (clojure.core/when-let
    [v9065 (:source-identifier m9064)]
    (. bean9063 setSourceIdentifier (clojure.core/str v9065)))
   (clojure.core/when-let
    [v9065 (:source-type m9064)]
    (. bean9063 setSourceType (clojure.core/str v9065)))
   (clojure.core/when-let
    [v9065 (:source-type m9064)]
    (. bean9063 setSourceType (source-type v9065)))
   (clojure.core/when-let
    [v9065 (:end-time m9064)]
    (. bean9063 setEndTime (com.palletops.awaze.common/to-date v9065)))
   bean9063))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest modify-cache-parameter-group-request
  [m9067]
  (clojure.core/let
   [bean9066
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v9068 (:cache-parameter-group-name m9067)]
    (. bean9066 setCacheParameterGroupName (clojure.core/str v9068)))
   (clojure.core/when-let
    [v9068 (:parameter-name-values m9067)]
    (.
     bean9066
     setParameterNameValues
     (clojure.core/map
      (clojure.core/fn [arg9069] (parameter-name-value arg9069))
      v9068)))
   bean9066))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest delete-cache-security-group-request
  [m9071]
  (clojure.core/let
   [bean9070
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest)]
   (clojure.core/when-let
    [v9072 (:cache-security-group-name m9071)]
    (. bean9070 setCacheSecurityGroupName (clojure.core/str v9072)))
   bean9070))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest create-cache-subnet-group-request
  [m9074]
  (clojure.core/let
   [bean9073
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest)]
   (clojure.core/when-let
    [v9075 (:subnet-ids m9074)]
    (.
     bean9073
     setSubnetIds
     (clojure.core/map
      (clojure.core/fn [arg9076] (clojure.core/str arg9076))
      v9075)))
   (clojure.core/when-let
    [v9075 (:cache-subnet-group-name m9074)]
    (. bean9073 setCacheSubnetGroupName (clojure.core/str v9075)))
   (clojure.core/when-let
    [v9075 (:cache-subnet-group-description m9074)]
    (.
     bean9073
     setCacheSubnetGroupDescription
     (clojure.core/str v9075)))
   bean9073))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest modify-replication-group-request
  [m9078]
  (clojure.core/let
   [bean9077
    (new
     com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest)]
   (clojure.core/when-let
    [v9079 (:security-group-ids m9078)]
    (.
     bean9077
     setSecurityGroupIds
     (clojure.core/map
      (clojure.core/fn [arg9080] (clojure.core/str arg9080))
      v9079)))
   (clojure.core/when-let
    [v9079 (:engine-version m9078)]
    (. bean9077 setEngineVersion (clojure.core/str v9079)))
   (clojure.core/when-let
    [v9079 (:auto-minor-version-upgrade m9078)]
    (.
     bean9077
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v9079)))
   (clojure.core/when-let
    [v9079 (:apply-immediately m9078)]
    (. bean9077 setApplyImmediately (clojure.core/boolean v9079)))
   (clojure.core/when-let
    [v9079 (:preferred-maintenance-window m9078)]
    (.
     bean9077
     setPreferredMaintenanceWindow
     (clojure.core/str v9079)))
   (clojure.core/when-let
    [v9079 (:cache-security-group-names m9078)]
    (.
     bean9077
     setCacheSecurityGroupNames
     (clojure.core/map
      (clojure.core/fn [arg9081] (clojure.core/str arg9081))
      v9079)))
   (clojure.core/when-let
    [v9079 (:notification-topic-arn m9078)]
    (. bean9077 setNotificationTopicArn (clojure.core/str v9079)))
   (clojure.core/when-let
    [v9079 (:cache-parameter-group-name m9078)]
    (. bean9077 setCacheParameterGroupName (clojure.core/str v9079)))
   (clojure.core/when-let
    [v9079 (:notification-topic-status m9078)]
    (. bean9077 setNotificationTopicStatus (clojure.core/str v9079)))
   (clojure.core/when-let
    [v9079 (:replication-group-id m9078)]
    (. bean9077 setReplicationGroupId (clojure.core/str v9079)))
   (clojure.core/when-let
    [v9079 (:primary-cluster-id m9078)]
    (. bean9077 setPrimaryClusterId (clojure.core/str v9079)))
   (clojure.core/when-let
    [v9079 (:replication-group-description m9078)]
    (.
     bean9077
     setReplicationGroupDescription
     (clojure.core/str v9079)))
   bean9077))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest modify-cache-subnet-group-request
  [m9083]
  (clojure.core/let
   [bean9082
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest)]
   (clojure.core/when-let
    [v9084 (:subnet-ids m9083)]
    (.
     bean9082
     setSubnetIds
     (clojure.core/map
      (clojure.core/fn [arg9085] (clojure.core/str arg9085))
      v9084)))
   (clojure.core/when-let
    [v9084 (:cache-subnet-group-name m9083)]
    (. bean9082 setCacheSubnetGroupName (clojure.core/str v9084)))
   (clojure.core/when-let
    [v9084 (:cache-subnet-group-description m9083)]
    (.
     bean9082
     setCacheSubnetGroupDescription
     (clojure.core/str v9084)))
   bean9082))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest describe-cache-parameters-request
  [m9087]
  (clojure.core/let
   [bean9086
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest)]
   (clojure.core/when-let
    [v9088 (:source m9087)]
    (. bean9086 setSource (clojure.core/str v9088)))
   (clojure.core/when-let
    [v9088 (:marker m9087)]
    (. bean9086 setMarker (clojure.core/str v9088)))
   (clojure.core/when-let
    [v9088 (:max-records m9087)]
    (. bean9086 setMaxRecords (clojure.core/int v9088)))
   (clojure.core/when-let
    [v9088 (:cache-parameter-group-name m9087)]
    (. bean9086 setCacheParameterGroupName (clojure.core/str v9088)))
   bean9086))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest delete-cache-parameter-group-request
  [m9090]
  (clojure.core/let
   [bean9089
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v9091 (:cache-parameter-group-name m9090)]
    (. bean9089 setCacheParameterGroupName (clojure.core/str v9091)))
   bean9089))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest delete-replication-group-request
  [m9093]
  (clojure.core/let
   [bean9092
    (new
     com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest)]
   (clojure.core/when-let
    [v9094 (:replication-group-id m9093)]
    (. bean9092 setReplicationGroupId (clojure.core/str v9094)))
   bean9092))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest purchase-reserved-cache-nodes-offering-request
  [m9096]
  (clojure.core/let
   [bean9095
    (new
     com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest)]
   (clojure.core/when-let
    [v9097 (:reserved-cache-nodes-offering-id m9096)]
    (.
     bean9095
     setReservedCacheNodesOfferingId
     (clojure.core/str v9097)))
   (clojure.core/when-let
    [v9097 (:reserved-cache-node-id m9096)]
    (. bean9095 setReservedCacheNodeId (clojure.core/str v9097)))
   (clojure.core/when-let
    [v9097 (:cache-node-count m9096)]
    (. bean9095 setCacheNodeCount (clojure.core/int v9097)))
   bean9095))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.RebootCacheClusterRequest reboot-cache-cluster-request
  [m9099]
  (clojure.core/let
   [bean9098
    (new
     com.amazonaws.services.elasticache.model.RebootCacheClusterRequest)]
   (clojure.core/when-let
    [v9100 (:cache-cluster-id m9099)]
    (. bean9098 setCacheClusterId (clojure.core/str v9100)))
   (clojure.core/when-let
    [v9100 (:cache-node-ids-to-reboot m9099)]
    (.
     bean9098
     setCacheNodeIdsToReboot
     (clojure.core/map
      (clojure.core/fn [arg9101] (clojure.core/str arg9101))
      v9100)))
   bean9098))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.CreateCacheClusterRequest create-cache-cluster-request
  [m9103]
  (clojure.core/let
   [bean9102
    (new
     com.amazonaws.services.elasticache.model.CreateCacheClusterRequest)]
   (clojure.core/when-let
    [v9104 (:security-group-ids m9103)]
    (.
     bean9102
     setSecurityGroupIds
     (clojure.core/map
      (clojure.core/fn [arg9105] (clojure.core/str arg9105))
      v9104)))
   (clojure.core/when-let
    [v9104 (:engine m9103)]
    (. bean9102 setEngine (clojure.core/str v9104)))
   (clojure.core/when-let
    [v9104 (:engine-version m9103)]
    (. bean9102 setEngineVersion (clojure.core/str v9104)))
   (clojure.core/when-let
    [v9104 (:auto-minor-version-upgrade m9103)]
    (.
     bean9102
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v9104)))
   (clojure.core/when-let
    [v9104 (:port m9103)]
    (. bean9102 setPort (clojure.core/int v9104)))
   (clojure.core/when-let
    [v9104 (:preferred-maintenance-window m9103)]
    (.
     bean9102
     setPreferredMaintenanceWindow
     (clojure.core/str v9104)))
   (clojure.core/when-let
    [v9104 (:cache-cluster-id m9103)]
    (. bean9102 setCacheClusterId (clojure.core/str v9104)))
   (clojure.core/when-let
    [v9104 (:num-cache-nodes m9103)]
    (. bean9102 setNumCacheNodes (clojure.core/int v9104)))
   (clojure.core/when-let
    [v9104 (:cache-security-group-names m9103)]
    (.
     bean9102
     setCacheSecurityGroupNames
     (clojure.core/map
      (clojure.core/fn [arg9106] (clojure.core/str arg9106))
      v9104)))
   (clojure.core/when-let
    [v9104 (:notification-topic-arn m9103)]
    (. bean9102 setNotificationTopicArn (clojure.core/str v9104)))
   (clojure.core/when-let
    [v9104 (:cache-parameter-group-name m9103)]
    (. bean9102 setCacheParameterGroupName (clojure.core/str v9104)))
   (clojure.core/when-let
    [v9104 (:cache-node-type m9103)]
    (. bean9102 setCacheNodeType (clojure.core/str v9104)))
   (clojure.core/when-let
    [v9104 (:preferred-availability-zone m9103)]
    (. bean9102 setPreferredAvailabilityZone (clojure.core/str v9104)))
   (clojure.core/when-let
    [v9104 (:cache-subnet-group-name m9103)]
    (. bean9102 setCacheSubnetGroupName (clojure.core/str v9104)))
   (clojure.core/when-let
    [v9104 (:replication-group-id m9103)]
    (. bean9102 setReplicationGroupId (clojure.core/str v9104)))
   (clojure.core/when-let
    [v9104 (:snapshot-arns m9103)]
    (.
     bean9102
     setSnapshotArns
     (clojure.core/map
      (clojure.core/fn [arg9107] (clojure.core/str arg9107))
      v9104)))
   bean9102))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest describe-reserved-cache-nodes-offerings-request
  [m9109]
  (clojure.core/let
   [bean9108
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)]
   (clojure.core/when-let
    [v9110 (:product-description m9109)]
    (. bean9108 setProductDescription (clojure.core/str v9110)))
   (clojure.core/when-let
    [v9110 (:marker m9109)]
    (. bean9108 setMarker (clojure.core/str v9110)))
   (clojure.core/when-let
    [v9110 (:max-records m9109)]
    (. bean9108 setMaxRecords (clojure.core/int v9110)))
   (clojure.core/when-let
    [v9110 (:duration m9109)]
    (. bean9108 setDuration (clojure.core/str v9110)))
   (clojure.core/when-let
    [v9110 (:offering-type m9109)]
    (. bean9108 setOfferingType (clojure.core/str v9110)))
   (clojure.core/when-let
    [v9110 (:cache-node-type m9109)]
    (. bean9108 setCacheNodeType (clojure.core/str v9110)))
   (clojure.core/when-let
    [v9110 (:reserved-cache-nodes-offering-id m9109)]
    (.
     bean9108
     setReservedCacheNodesOfferingId
     (clojure.core/str v9110)))
   bean9108))
 (clojure.core/defmulti
  elasticache
  (clojure.core/fn elasticache [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameter-groups
   [m9111]
   (clojure.core/let
    [credentials9112 (:credentials m9111) args9113 (:args m9111)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9114
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9112)]
     (clojure.core/case
      (clojure.core/count args9113)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9114
        describeCacheParameterGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9114
        describeCacheParameterGroups
        (describe-cache-parameter-groups-request
         (clojure.core/nth args9113 0))))))))
  (clojure.core/defn
   describe-cache-parameter-groups-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cache-parameter-group-name]}]],
    :doc
    "Generate map for describeCacheParameterGroups, describeCacheParameterGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-parameter-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-parameter-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-cache-parameter-groups
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cache-parameter-group-name]}]],
    :doc
    "Call describeCacheParameterGroups, describeCacheParameterGroups"}
   [credentials9116 & args9117]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9118
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9116)]
    (clojure.core/case
     (clojure.core/count args9117)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9118
       describeCacheParameterGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9118
       describeCacheParameterGroups
       (describe-cache-parameter-groups-request
        (clojure.core/nth args9117 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-parameter-group
   [m9119]
   (clojure.core/let
    [credentials9120 (:credentials m9119) args9121 (:args m9119)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9122
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9120)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9122
       createCacheParameterGroup
       (create-cache-parameter-group-request
        (clojure.core/nth args9121 0)))))))
  (clojure.core/defn
   create-cache-parameter-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         description
         cache-parameter-group-name
         cache-parameter-group-family]}]],
    :doc "Generate map for createCacheParameterGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-parameter-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-cache-parameter-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         description
         cache-parameter-group-name
         cache-parameter-group-family]}]],
    :doc "Call createCacheParameterGroup"}
   [credentials9124 & args9125]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9126
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9124)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9126
      createCacheParameterGroup
      (create-cache-parameter-group-request
       (clojure.core/nth args9125 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :revoke-cache-security-group-ingress
   [m9127]
   (clojure.core/let
    [credentials9128 (:credentials m9127) args9129 (:args m9127)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9130
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9128)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9130
       revokeCacheSecurityGroupIngress
       (revoke-cache-security-group-ingress-request
        (clojure.core/nth args9129 0)))))))
  (clojure.core/defn
   revoke-cache-security-group-ingress-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         cache-security-group-name
         ec2security-group-owner-id
         ec2security-group-name]}]],
    :doc "Generate map for revokeCacheSecurityGroupIngress"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :revoke-cache-security-group-ingress,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   revoke-cache-security-group-ingress
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         cache-security-group-name
         ec2security-group-owner-id
         ec2security-group-name]}]],
    :doc "Call revokeCacheSecurityGroupIngress"}
   [credentials9132 & args9133]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9134
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9132)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9134
      revokeCacheSecurityGroupIngress
      (revoke-cache-security-group-ingress-request
       (clojure.core/nth args9133 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-replication-group
   [m9135]
   (clojure.core/let
    [credentials9136 (:credentials m9135) args9137 (:args m9135)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9138
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9136)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9138
       createReplicationGroup
       (create-replication-group-request
        (clojure.core/nth args9137 0)))))))
  (clojure.core/defn
   create-replication-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         replication-group-id
         replication-group-description
         primary-cluster-id]}]],
    :doc "Generate map for createReplicationGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-replication-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-replication-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         replication-group-id
         replication-group-description
         primary-cluster-id]}]],
    :doc "Call createReplicationGroup"}
   [credentials9140 & args9141]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9142
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9140)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9142
      createReplicationGroup
      (create-replication-group-request
       (clojure.core/nth args9141 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :authorize-cache-security-group-ingress
   [m9143]
   (clojure.core/let
    [credentials9144 (:credentials m9143) args9145 (:args m9143)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9146
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9144)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9146
       authorizeCacheSecurityGroupIngress
       (authorize-cache-security-group-ingress-request
        (clojure.core/nth args9145 0)))))))
  (clojure.core/defn
   authorize-cache-security-group-ingress-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         cache-security-group-name
         ec2security-group-owner-id
         ec2security-group-name]}]],
    :doc "Generate map for authorizeCacheSecurityGroupIngress"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :authorize-cache-security-group-ingress,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   authorize-cache-security-group-ingress
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         cache-security-group-name
         ec2security-group-owner-id
         ec2security-group-name]}]],
    :doc "Call authorizeCacheSecurityGroupIngress"}
   [credentials9148 & args9149]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9150
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9148)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9150
      authorizeCacheSecurityGroupIngress
      (authorize-cache-security-group-ingress-request
       (clojure.core/nth args9149 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes
   [m9151]
   (clojure.core/let
    [credentials9152 (:credentials m9151) args9153 (:args m9151)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9154
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9152)]
     (clojure.core/case
      (clojure.core/count args9153)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9154
        describeReservedCacheNodes))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9154
        describeReservedCacheNodes
        (describe-reserved-cache-nodes-request
         (clojure.core/nth args9153 0))))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [reserved-cache-node-id
         duration
         request-metric-collector
         max-records
         marker
         product-description
         offering-type
         reserved-cache-nodes-offering-id
         cache-node-type]}]],
    :doc
    "Generate map for describeReservedCacheNodes, describeReservedCacheNodes"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-reserved-cache-nodes
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [reserved-cache-node-id
         duration
         request-metric-collector
         max-records
         marker
         product-description
         offering-type
         reserved-cache-nodes-offering-id
         cache-node-type]}]],
    :doc "Call describeReservedCacheNodes, describeReservedCacheNodes"}
   [credentials9156 & args9157]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9158
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9156)]
    (clojure.core/case
     (clojure.core/count args9157)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9158
       describeReservedCacheNodes))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9158
       describeReservedCacheNodes
       (describe-reserved-cache-nodes-request
        (clojure.core/nth args9157 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-cluster
   [m9159]
   (clojure.core/let
    [credentials9160 (:credentials m9159) args9161 (:args m9159)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9162
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9160)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9162
       modifyCacheCluster
       (modify-cache-cluster-request
        (clojure.core/nth args9161 0)))))))
  (clojure.core/defn
   modify-cache-cluster-map
   {:arglists
    '[[credentials
       {:keys
        [notification-topic-status
         request-metric-collector
         cache-parameter-group-name
         notification-topic-arn
         cache-cluster-id
         num-cache-nodes
         preferred-maintenance-window
         cache-node-ids-to-remove
         cache-security-group-names
         security-group-ids
         apply-immediately
         engine-version
         auto-minor-version-upgrade]}]],
    :doc "Generate map for modifyCacheCluster"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-cache-cluster,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-cache-cluster
   {:arglists
    '[[credentials
       {:keys
        [notification-topic-status
         request-metric-collector
         cache-parameter-group-name
         notification-topic-arn
         cache-cluster-id
         num-cache-nodes
         preferred-maintenance-window
         cache-node-ids-to-remove
         cache-security-group-names
         security-group-ids
         apply-immediately
         engine-version
         auto-minor-version-upgrade]}]],
    :doc "Call modifyCacheCluster"}
   [credentials9164 & args9165]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9166
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9164)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9166
      modifyCacheCluster
      (modify-cache-cluster-request (clojure.core/nth args9165 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-subnet-group
   [m9167]
   (clojure.core/let
    [credentials9168 (:credentials m9167) args9169 (:args m9167)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9170
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9168)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9170
       deleteCacheSubnetGroup
       (delete-cache-subnet-group-request
        (clojure.core/nth args9169 0)))))))
  (clojure.core/defn
   delete-cache-subnet-group-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector cache-subnet-group-name]}]],
    :doc "Generate map for deleteCacheSubnetGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-subnet-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-cache-subnet-group
   {:arglists
    '[[credentials
       {:keys [request-metric-collector cache-subnet-group-name]}]],
    :doc "Call deleteCacheSubnetGroup"}
   [credentials9172 & args9173]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9174
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9172)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9174
      deleteCacheSubnetGroup
      (delete-cache-subnet-group-request
       (clojure.core/nth args9173 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-engine-versions
   [m9175]
   (clojure.core/let
    [credentials9176 (:credentials m9175) args9177 (:args m9175)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9178
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9176)]
     (clojure.core/case
      (clojure.core/count args9177)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9178
        describeCacheEngineVersions
        (describe-cache-engine-versions-request
         (clojure.core/nth args9177 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9178
        describeCacheEngineVersions))))))
  (clojure.core/defn
   describe-cache-engine-versions-map
   {:arglists
    '[[credentials
       {:keys
        [cache-parameter-group-family
         marker
         max-records
         default-only
         engine-version
         engine
         request-metric-collector]}]
      [credentials]],
    :doc
    "Generate map for describeCacheEngineVersions, describeCacheEngineVersions"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-engine-versions,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-engine-versions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-cache-engine-versions
   {:arglists
    '[[credentials
       {:keys
        [cache-parameter-group-family
         marker
         max-records
         default-only
         engine-version
         engine
         request-metric-collector]}]
      [credentials]],
    :doc
    "Call describeCacheEngineVersions, describeCacheEngineVersions"}
   [credentials9180 & args9181]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9182
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9180)]
    (clojure.core/case
     (clojure.core/count args9181)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9182
       describeCacheEngineVersions
       (describe-cache-engine-versions-request
        (clojure.core/nth args9181 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9182
       describeCacheEngineVersions))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reset-cache-parameter-group
   [m9183]
   (clojure.core/let
    [credentials9184 (:credentials m9183) args9185 (:args m9183)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9186
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9184)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9186
       resetCacheParameterGroup
       (reset-cache-parameter-group-request
        (clojure.core/nth args9185 0)))))))
  (clojure.core/defn
   reset-cache-parameter-group-map
   {:arglists
    '[[credentials
       {:keys
        [reset-all-parameters
         request-metric-collector
         parameter-name-values
         cache-parameter-group-name]}]],
    :doc "Generate map for resetCacheParameterGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :reset-cache-parameter-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   reset-cache-parameter-group
   {:arglists
    '[[credentials
       {:keys
        [reset-all-parameters
         request-metric-collector
         parameter-name-values
         cache-parameter-group-name]}]],
    :doc "Call resetCacheParameterGroup"}
   [credentials9188 & args9189]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9190
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9188)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9190
      resetCacheParameterGroup
      (reset-cache-parameter-group-request
       (clojure.core/nth args9189 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-engine-default-parameters
   [m9191]
   (clojure.core/let
    [credentials9192 (:credentials m9191) args9193 (:args m9191)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9194
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9192)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9194
       describeEngineDefaultParameters
       (describe-engine-default-parameters-request
        (clojure.core/nth args9193 0)))))))
  (clojure.core/defn
   describe-engine-default-parameters-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cache-parameter-group-family]}]],
    :doc "Generate map for describeEngineDefaultParameters"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-engine-default-parameters,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-engine-default-parameters
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cache-parameter-group-family]}]],
    :doc "Call describeEngineDefaultParameters"}
   [credentials9196 & args9197]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9198
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9196)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9198
      describeEngineDefaultParameters
      (describe-engine-default-parameters-request
       (clojure.core/nth args9197 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-cluster
   [m9199]
   (clojure.core/let
    [credentials9200 (:credentials m9199) args9201 (:args m9199)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9202
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9200)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9202
       deleteCacheCluster
       (delete-cache-cluster-request
        (clojure.core/nth args9201 0)))))))
  (clojure.core/defn
   delete-cache-cluster-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector cache-cluster-id]}]],
    :doc "Generate map for deleteCacheCluster"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-cluster,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-cache-cluster
   {:arglists
    '[[credentials
       {:keys [request-metric-collector cache-cluster-id]}]],
    :doc "Call deleteCacheCluster"}
   [credentials9204 & args9205]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9206
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9204)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9206
      deleteCacheCluster
      (delete-cache-cluster-request (clojure.core/nth args9205 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-subnet-groups
   [m9207]
   (clojure.core/let
    [credentials9208 (:credentials m9207) args9209 (:args m9207)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9210
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9208)]
     (clojure.core/case
      (clojure.core/count args9209)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9210
        describeCacheSubnetGroups
        (describe-cache-subnet-groups-request
         (clojure.core/nth args9209 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9210
        describeCacheSubnetGroups))))))
  (clojure.core/defn
   describe-cache-subnet-groups-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cache-subnet-group-name]}]
      [credentials]],
    :doc
    "Generate map for describeCacheSubnetGroups, describeCacheSubnetGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-subnet-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-subnet-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-cache-subnet-groups
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cache-subnet-group-name]}]
      [credentials]],
    :doc "Call describeCacheSubnetGroups, describeCacheSubnetGroups"}
   [credentials9212 & args9213]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9214
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9212)]
    (clojure.core/case
     (clojure.core/count args9213)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9214
       describeCacheSubnetGroups
       (describe-cache-subnet-groups-request
        (clojure.core/nth args9213 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9214
       describeCacheSubnetGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-replication-groups
   [m9215]
   (clojure.core/let
    [credentials9216 (:credentials m9215) args9217 (:args m9215)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9218
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9216)]
     (clojure.core/case
      (clojure.core/count args9217)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9218
        describeReplicationGroups
        (describe-replication-groups-request
         (clojure.core/nth args9217 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9218
        describeReplicationGroups))))))
  (clojure.core/defn
   describe-replication-groups-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         replication-group-id
         max-records
         marker]}]
      [credentials]],
    :doc
    "Generate map for describeReplicationGroups, describeReplicationGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-replication-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-replication-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-replication-groups
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         replication-group-id
         max-records
         marker]}]
      [credentials]],
    :doc "Call describeReplicationGroups, describeReplicationGroups"}
   [credentials9220 & args9221]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9222
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9220)]
    (clojure.core/case
     (clojure.core/count args9221)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9222
       describeReplicationGroups
       (describe-replication-groups-request
        (clojure.core/nth args9221 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9222
       describeReplicationGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-security-groups
   [m9223]
   (clojure.core/let
    [credentials9224 (:credentials m9223) args9225 (:args m9223)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9226
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9224)]
     (clojure.core/case
      (clojure.core/count args9225)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9226
        describeCacheSecurityGroups
        (describe-cache-security-groups-request
         (clojure.core/nth args9225 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9226
        describeCacheSecurityGroups))))))
  (clojure.core/defn
   describe-cache-security-groups-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cache-security-group-name]}]
      [credentials]],
    :doc
    "Generate map for describeCacheSecurityGroups, describeCacheSecurityGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-security-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-security-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-cache-security-groups
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         max-records
         marker
         cache-security-group-name]}]
      [credentials]],
    :doc
    "Call describeCacheSecurityGroups, describeCacheSecurityGroups"}
   [credentials9228 & args9229]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9230
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9228)]
    (clojure.core/case
     (clojure.core/count args9229)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9230
       describeCacheSecurityGroups
       (describe-cache-security-groups-request
        (clojure.core/nth args9229 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9230
       describeCacheSecurityGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-security-group
   [m9231]
   (clojure.core/let
    [credentials9232 (:credentials m9231) args9233 (:args m9231)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9234
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9232)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9234
       createCacheSecurityGroup
       (create-cache-security-group-request
        (clojure.core/nth args9233 0)))))))
  (clojure.core/defn
   create-cache-security-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         description
         cache-security-group-name]}]],
    :doc "Generate map for createCacheSecurityGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-security-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-cache-security-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         description
         cache-security-group-name]}]],
    :doc "Call createCacheSecurityGroup"}
   [credentials9236 & args9237]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9238
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9236)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9238
      createCacheSecurityGroup
      (create-cache-security-group-request
       (clojure.core/nth args9237 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-clusters
   [m9239]
   (clojure.core/let
    [credentials9240 (:credentials m9239) args9241 (:args m9239)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9242
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9240)]
     (clojure.core/case
      (clojure.core/count args9241)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9242
        describeCacheClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9242
        describeCacheClusters
        (describe-cache-clusters-request
         (clojure.core/nth args9241 0))))))))
  (clojure.core/defn
   describe-cache-clusters-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [show-cache-node-info
         request-metric-collector
         max-records
         marker
         cache-cluster-id]}]],
    :doc
    "Generate map for describeCacheClusters, describeCacheClusters"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-clusters,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-clusters,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-cache-clusters
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [show-cache-node-info
         request-metric-collector
         max-records
         marker
         cache-cluster-id]}]],
    :doc "Call describeCacheClusters, describeCacheClusters"}
   [credentials9244 & args9245]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9246
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9244)]
    (clojure.core/case
     (clojure.core/count args9245)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9246
       describeCacheClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9246
       describeCacheClusters
       (describe-cache-clusters-request
        (clojure.core/nth args9245 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-events
   [m9247]
   (clojure.core/let
    [credentials9248 (:credentials m9247) args9249 (:args m9247)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9250
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9248)]
     (clojure.core/case
      (clojure.core/count args9249)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9250
        describeEvents
        (describe-events-request (clojure.core/nth args9249 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9250
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists
    '[[credentials
       {:keys
        [end-time
         source-type
         duration
         request-metric-collector
         max-records
         start-time
         marker
         source-identifier]}]
      [credentials]],
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-events,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-events,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists
    '[[credentials
       {:keys
        [end-time
         source-type
         duration
         request-metric-collector
         max-records
         start-time
         marker
         source-identifier]}]
      [credentials]],
    :doc "Call describeEvents, describeEvents"}
   [credentials9252 & args9253]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9254
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9252)]
    (clojure.core/case
     (clojure.core/count args9253)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9254
       describeEvents
       (describe-events-request (clojure.core/nth args9253 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9254
       describeEvents))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-parameter-group
   [m9255]
   (clojure.core/let
    [credentials9256 (:credentials m9255) args9257 (:args m9255)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9258
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9256)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9258
       modifyCacheParameterGroup
       (modify-cache-parameter-group-request
        (clojure.core/nth args9257 0)))))))
  (clojure.core/defn
   modify-cache-parameter-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         parameter-name-values
         cache-parameter-group-name]}]],
    :doc "Generate map for modifyCacheParameterGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-cache-parameter-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-cache-parameter-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         parameter-name-values
         cache-parameter-group-name]}]],
    :doc "Call modifyCacheParameterGroup"}
   [credentials9260 & args9261]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9262
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9260)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9262
      modifyCacheParameterGroup
      (modify-cache-parameter-group-request
       (clojure.core/nth args9261 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-security-group
   [m9263]
   (clojure.core/let
    [credentials9264 (:credentials m9263) args9265 (:args m9263)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9266
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9264)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9266
       deleteCacheSecurityGroup
       (delete-cache-security-group-request
        (clojure.core/nth args9265 0)))))))
  (clojure.core/defn
   delete-cache-security-group-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector cache-security-group-name]}]],
    :doc "Generate map for deleteCacheSecurityGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-security-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-cache-security-group
   {:arglists
    '[[credentials
       {:keys [request-metric-collector cache-security-group-name]}]],
    :doc "Call deleteCacheSecurityGroup"}
   [credentials9268 & args9269]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9270
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9268)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9270
      deleteCacheSecurityGroup
      (delete-cache-security-group-request
       (clojure.core/nth args9269 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-subnet-group
   [m9271]
   (clojure.core/let
    [credentials9272 (:credentials m9271) args9273 (:args m9271)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9274
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9272)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9274
       createCacheSubnetGroup
       (create-cache-subnet-group-request
        (clojure.core/nth args9273 0)))))))
  (clojure.core/defn
   create-cache-subnet-group-map
   {:arglists
    '[[credentials
       {:keys
        [subnet-ids
         request-metric-collector
         cache-subnet-group-name
         cache-subnet-group-description]}]],
    :doc "Generate map for createCacheSubnetGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-subnet-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-cache-subnet-group
   {:arglists
    '[[credentials
       {:keys
        [subnet-ids
         request-metric-collector
         cache-subnet-group-name
         cache-subnet-group-description]}]],
    :doc "Call createCacheSubnetGroup"}
   [credentials9276 & args9277]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9278
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9276)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9278
      createCacheSubnetGroup
      (create-cache-subnet-group-request
       (clojure.core/nth args9277 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-replication-group
   [m9279]
   (clojure.core/let
    [credentials9280 (:credentials m9279) args9281 (:args m9279)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9282
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9280)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9282
       modifyReplicationGroup
       (modify-replication-group-request
        (clojure.core/nth args9281 0)))))))
  (clojure.core/defn
   modify-replication-group-map
   {:arglists
    '[[credentials
       {:keys
        [notification-topic-status
         request-metric-collector
         cache-parameter-group-name
         notification-topic-arn
         primary-cluster-id
         preferred-maintenance-window
         replication-group-id
         cache-security-group-names
         replication-group-description
         security-group-ids
         apply-immediately
         engine-version
         auto-minor-version-upgrade]}]],
    :doc "Generate map for modifyReplicationGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-replication-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-replication-group
   {:arglists
    '[[credentials
       {:keys
        [notification-topic-status
         request-metric-collector
         cache-parameter-group-name
         notification-topic-arn
         primary-cluster-id
         preferred-maintenance-window
         replication-group-id
         cache-security-group-names
         replication-group-description
         security-group-ids
         apply-immediately
         engine-version
         auto-minor-version-upgrade]}]],
    :doc "Call modifyReplicationGroup"}
   [credentials9284 & args9285]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9286
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9284)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9286
      modifyReplicationGroup
      (modify-replication-group-request
       (clojure.core/nth args9285 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-subnet-group
   [m9287]
   (clojure.core/let
    [credentials9288 (:credentials m9287) args9289 (:args m9287)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9290
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9288)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9290
       modifyCacheSubnetGroup
       (modify-cache-subnet-group-request
        (clojure.core/nth args9289 0)))))))
  (clojure.core/defn
   modify-cache-subnet-group-map
   {:arglists
    '[[credentials
       {:keys
        [subnet-ids
         request-metric-collector
         cache-subnet-group-name
         cache-subnet-group-description]}]],
    :doc "Generate map for modifyCacheSubnetGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-cache-subnet-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-cache-subnet-group
   {:arglists
    '[[credentials
       {:keys
        [subnet-ids
         request-metric-collector
         cache-subnet-group-name
         cache-subnet-group-description]}]],
    :doc "Call modifyCacheSubnetGroup"}
   [credentials9292 & args9293]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9294
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9292)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9294
      modifyCacheSubnetGroup
      (modify-cache-subnet-group-request
       (clojure.core/nth args9293 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameters
   [m9295]
   (clojure.core/let
    [credentials9296 (:credentials m9295) args9297 (:args m9295)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9298
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9296)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9298
       describeCacheParameters
       (describe-cache-parameters-request
        (clojure.core/nth args9297 0)))))))
  (clojure.core/defn
   describe-cache-parameters-map
   {:arglists
    '[[credentials
       {:keys
        [source
         request-metric-collector
         max-records
         marker
         cache-parameter-group-name]}]],
    :doc "Generate map for describeCacheParameters"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-parameters,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-cache-parameters
   {:arglists
    '[[credentials
       {:keys
        [source
         request-metric-collector
         max-records
         marker
         cache-parameter-group-name]}]],
    :doc "Call describeCacheParameters"}
   [credentials9300 & args9301]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9302
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9300)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9302
      describeCacheParameters
      (describe-cache-parameters-request
       (clojure.core/nth args9301 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-parameter-group
   [m9303]
   (clojure.core/let
    [credentials9304 (:credentials m9303) args9305 (:args m9303)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9306
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9304)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9306
       deleteCacheParameterGroup
       (delete-cache-parameter-group-request
        (clojure.core/nth args9305 0)))))))
  (clojure.core/defn
   delete-cache-parameter-group-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector cache-parameter-group-name]}]],
    :doc "Generate map for deleteCacheParameterGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-parameter-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-cache-parameter-group
   {:arglists
    '[[credentials
       {:keys [request-metric-collector cache-parameter-group-name]}]],
    :doc "Call deleteCacheParameterGroup"}
   [credentials9308 & args9309]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9310
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9308)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9310
      deleteCacheParameterGroup
      (delete-cache-parameter-group-request
       (clojure.core/nth args9309 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-replication-group
   [m9311]
   (clojure.core/let
    [credentials9312 (:credentials m9311) args9313 (:args m9311)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9314
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9312)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9314
       deleteReplicationGroup
       (delete-replication-group-request
        (clojure.core/nth args9313 0)))))))
  (clojure.core/defn
   delete-replication-group-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector replication-group-id]}]],
    :doc "Generate map for deleteReplicationGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-replication-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-replication-group
   {:arglists
    '[[credentials
       {:keys [request-metric-collector replication-group-id]}]],
    :doc "Call deleteReplicationGroup"}
   [credentials9316 & args9317]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9318
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9316)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9318
      deleteReplicationGroup
      (delete-replication-group-request
       (clojure.core/nth args9317 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :purchase-reserved-cache-nodes-offering
   [m9319]
   (clojure.core/let
    [credentials9320 (:credentials m9319) args9321 (:args m9319)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9322
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9320)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9322
       purchaseReservedCacheNodesOffering
       (purchase-reserved-cache-nodes-offering-request
        (clojure.core/nth args9321 0)))))))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering-map
   {:arglists
    '[[credentials
       {:keys
        [reserved-cache-nodes-offering-id
         reserved-cache-node-id
         request-metric-collector
         cache-node-count]}]],
    :doc "Generate map for purchaseReservedCacheNodesOffering"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :purchase-reserved-cache-nodes-offering,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering
   {:arglists
    '[[credentials
       {:keys
        [reserved-cache-nodes-offering-id
         reserved-cache-node-id
         request-metric-collector
         cache-node-count]}]],
    :doc "Call purchaseReservedCacheNodesOffering"}
   [credentials9324 & args9325]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9326
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9324)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9326
      purchaseReservedCacheNodesOffering
      (purchase-reserved-cache-nodes-offering-request
       (clojure.core/nth args9325 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reboot-cache-cluster
   [m9327]
   (clojure.core/let
    [credentials9328 (:credentials m9327) args9329 (:args m9327)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9330
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9328)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9330
       rebootCacheCluster
       (reboot-cache-cluster-request
        (clojure.core/nth args9329 0)))))))
  (clojure.core/defn
   reboot-cache-cluster-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         cache-node-ids-to-reboot
         cache-cluster-id]}]],
    :doc "Generate map for rebootCacheCluster"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :reboot-cache-cluster,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   reboot-cache-cluster
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         cache-node-ids-to-reboot
         cache-cluster-id]}]],
    :doc "Call rebootCacheCluster"}
   [credentials9332 & args9333]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9334
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9332)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9334
      rebootCacheCluster
      (reboot-cache-cluster-request (clojure.core/nth args9333 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-cluster
   [m9335]
   (clojure.core/let
    [credentials9336 (:credentials m9335) args9337 (:args m9335)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9338
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9336)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9338
       createCacheCluster
       (create-cache-cluster-request
        (clojure.core/nth args9337 0)))))))
  (clojure.core/defn
   create-cache-cluster-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         engine
         cache-parameter-group-name
         notification-topic-arn
         cache-cluster-id
         preferred-availability-zone
         num-cache-nodes
         preferred-maintenance-window
         replication-group-id
         cache-security-group-names
         port
         security-group-ids
         snapshot-arns
         engine-version
         auto-minor-version-upgrade
         cache-node-type
         cache-subnet-group-name]}]],
    :doc "Generate map for createCacheCluster"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-cluster,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-cache-cluster
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         engine
         cache-parameter-group-name
         notification-topic-arn
         cache-cluster-id
         preferred-availability-zone
         num-cache-nodes
         preferred-maintenance-window
         replication-group-id
         cache-security-group-names
         port
         security-group-ids
         snapshot-arns
         engine-version
         auto-minor-version-upgrade
         cache-node-type
         cache-subnet-group-name]}]],
    :doc "Call createCacheCluster"}
   [credentials9340 & args9341]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9342
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9340)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9342
      createCacheCluster
      (create-cache-cluster-request (clojure.core/nth args9341 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes-offerings
   [m9343]
   (clojure.core/let
    [credentials9344 (:credentials m9343) args9345 (:args m9343)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9346
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials9344)]
     (clojure.core/case
      (clojure.core/count args9345)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9346
        describeReservedCacheNodesOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9346
        describeReservedCacheNodesOfferings
        (describe-reserved-cache-nodes-offerings-request
         (clojure.core/nth args9345 0))))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [duration
         request-metric-collector
         max-records
         marker
         product-description
         offering-type
         reserved-cache-nodes-offering-id
         cache-node-type]}]],
    :doc
    "Generate map for describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   ([credentials__577__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [duration
         request-metric-collector
         max-records
         marker
         product-description
         offering-type
         reserved-cache-nodes-offering-id
         cache-node-type]}]],
    :doc
    "Call describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   [credentials9348 & args9349]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9350
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials9348)]
    (clojure.core/case
     (clojure.core/count args9349)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9350
       describeReservedCacheNodesOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client9350
       describeReservedCacheNodesOfferings
       (describe-reserved-cache-nodes-offerings-request
        (clojure.core/nth args9349 0)))))))))
