(ns com.palletops.awaze.ec2 (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :ec2
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.ec2.AmazonEC2Client
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.VolumeType volume-type
  [m4224]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.VolumeType
   (clojure.core/name m4224)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.PermissionGroup permission-group
  [m4227]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.PermissionGroup
   (clojure.core/name m4227)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.Tenancy tenancy
  [m4230]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.Tenancy
   (clojure.core/name m4230)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DiskImageFormat disk-image-format
  [m4233]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.DiskImageFormat
   (clojure.core/name m4233)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.PrivateIpAddressSpecification private-ip-address-specification
  [m4236]
  (clojure.core/let
   [bean4235
    (new
     com.amazonaws.services.ec2.model.PrivateIpAddressSpecification)]
   (clojure.core/when-let
    [v4237 (:private-ip-address m4236)]
    (. bean4235 setPrivateIpAddress (clojure.core/str v4237)))
   (clojure.core/when-let
    [v4237 (:primary m4236)]
    (. bean4235 setPrimary (clojure.core/boolean v4237)))
   bean4235))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.EbsBlockDevice ebs-block-device
  [m4239]
  (clojure.core/let
   [bean4238 (new com.amazonaws.services.ec2.model.EbsBlockDevice)]
   (clojure.core/when-let
    [v4240 (:volume-type m4239)]
    (. bean4238 setVolumeType (volume-type v4240)))
   (clojure.core/when-let
    [v4240 (:volume-type m4239)]
    (. bean4238 setVolumeType (clojure.core/str v4240)))
   (clojure.core/when-let
    [v4240 (:delete-on-termination m4239)]
    (. bean4238 setDeleteOnTermination (clojure.core/boolean v4240)))
   (clojure.core/when-let
    [v4240 (:snapshot-id m4239)]
    (. bean4238 setSnapshotId (clojure.core/str v4240)))
   (clojure.core/when-let
    [v4240 (:volume-size m4239)]
    (. bean4238 setVolumeSize (clojure.core/int v4240)))
   (clojure.core/when-let
    [v4240 (:iops m4239)]
    (. bean4238 setIops (clojure.core/int v4240)))
   bean4238))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.UserIdGroupPair user-id-group-pair
  [m4242]
  (clojure.core/let
   [bean4241 (new com.amazonaws.services.ec2.model.UserIdGroupPair)]
   (clojure.core/when-let
    [v4243 (:group-name m4242)]
    (. bean4241 setGroupName (clojure.core/str v4243)))
   (clojure.core/when-let
    [v4243 (:group-id m4242)]
    (. bean4241 setGroupId (clojure.core/str v4243)))
   (clojure.core/when-let
    [v4243 (:user-id m4242)]
    (. bean4241 setUserId (clojure.core/str v4243)))
   bean4241))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CurrencyCodeValues currency-code-values
  [m4245]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.CurrencyCodeValues
   (clojure.core/name m4245)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.LaunchPermission launch-permission
  [m4248]
  (clojure.core/let
   [bean4247 (new com.amazonaws.services.ec2.model.LaunchPermission)]
   (clojure.core/when-let
    [v4249 (:user-id m4248)]
    (. bean4247 setUserId (clojure.core/str v4249)))
   (clojure.core/when-let
    [v4249 (:group m4248)]
    (. bean4247 setGroup (clojure.core/str v4249)))
   (clojure.core/when-let
    [v4249 (:group m4248)]
    (. bean4247 setGroup (permission-group v4249)))
   bean4247))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateVolumePermission create-volume-permission
  [m4251]
  (clojure.core/let
   [bean4250
    (new com.amazonaws.services.ec2.model.CreateVolumePermission)]
   (clojure.core/when-let
    [v4252 (:user-id m4251)]
    (. bean4250 setUserId (clojure.core/str v4252)))
   (clojure.core/when-let
    [v4252 (:group m4251)]
    (. bean4250 setGroup (clojure.core/str v4252)))
   (clojure.core/when-let
    [v4252 (:group m4251)]
    (. bean4250 setGroup (permission-group v4252)))
   bean4250))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.InstanceType instance-type
  [m4254]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.InstanceType
   (clojure.core/name m4254)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ShutdownBehavior shutdown-behavior
  [m4257]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.ShutdownBehavior
   (clojure.core/name m4257)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ArchitectureValues architecture-values
  [m4260]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.ArchitectureValues
   (clojure.core/name m4260)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.Placement placement
  [m4263]
  (clojure.core/let
   [bean4262 (new com.amazonaws.services.ec2.model.Placement)]
   (clojure.core/when-let
    [v4264 (:group-name m4263)]
    (. bean4262 setGroupName (clojure.core/str v4264)))
   (clojure.core/when-let
    [v4264 (:tenancy m4263)]
    (. bean4262 setTenancy (tenancy v4264)))
   (clojure.core/when-let
    [v4264 (:tenancy m4263)]
    (. bean4262 setTenancy (clojure.core/str v4264)))
   (clojure.core/when-let
    [v4264 (:availability-zone m4263)]
    (. bean4262 setAvailabilityZone (clojure.core/str v4264)))
   bean4262))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DiskImageDetail disk-image-detail
  [m4266]
  (clojure.core/let
   [bean4265 (new com.amazonaws.services.ec2.model.DiskImageDetail)]
   (clojure.core/when-let
    [v4267 (:bytes m4266)]
    (. bean4265 setBytes (clojure.core/long v4267)))
   (clojure.core/when-let
    [v4267 (:import-manifest-url m4266)]
    (. bean4265 setImportManifestUrl (clojure.core/str v4267)))
   (clojure.core/when-let
    [v4267 (:format m4266)]
    (. bean4265 setFormat (disk-image-format v4267)))
   (clojure.core/when-let
    [v4267 (:format m4266)]
    (. bean4265 setFormat (clojure.core/str v4267)))
   bean4265))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.VolumeDetail volume-detail
  [m4269]
  (clojure.core/let
   [bean4268 (new com.amazonaws.services.ec2.model.VolumeDetail)]
   (clojure.core/when-let
    [v4270 (:size m4269)]
    (. bean4268 setSize (clojure.core/long v4270)))
   bean4268))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification ebs-instance-block-device-specification
  [m4272]
  (clojure.core/let
   [bean4271
    (new
     com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification)]
   (clojure.core/when-let
    [v4273 (:volume-id m4272)]
    (. bean4271 setVolumeId (clojure.core/str v4273)))
   (clojure.core/when-let
    [v4273 (:delete-on-termination m4272)]
    (. bean4271 setDeleteOnTermination (clojure.core/boolean v4273)))
   bean4271))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.S3Storage s3storage
  [m4275]
  (clojure.core/let
   [bean4274 (new com.amazonaws.services.ec2.model.S3Storage)]
   (clojure.core/when-let
    [v4276 (:bucket m4275)]
    (. bean4274 setBucket (clojure.core/str v4276)))
   (clojure.core/when-let
    [v4276 (:prefix m4275)]
    (. bean4274 setPrefix (clojure.core/str v4276)))
   (clojure.core/when-let
    [v4276 (:awsaccess-key-id m4275)]
    (. bean4274 setAWSAccessKeyId (clojure.core/str v4276)))
   (clojure.core/when-let
    [v4276 (:upload-policy m4275)]
    (. bean4274 setUploadPolicy (clojure.core/str v4276)))
   (clojure.core/when-let
    [v4276 (:upload-policy-signature m4275)]
    (. bean4274 setUploadPolicySignature (clojure.core/str v4276)))
   bean4274))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ContainerFormat container-format
  [m4278]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.ContainerFormat
   (clojure.core/name m4278)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification instance-network-interface-specification
  [m4281]
  (clojure.core/let
   [bean4280
    (new
     com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification)]
   (clojure.core/when-let
    [v4282 (:subnet-id m4281)]
    (. bean4280 setSubnetId (clojure.core/str v4282)))
   (clojure.core/when-let
    [v4282 (:private-ip-address m4281)]
    (. bean4280 setPrivateIpAddress (clojure.core/str v4282)))
   (clojure.core/when-let
    [v4282 (:groups m4281)]
    (.
     bean4280
     setGroups
     (clojure.core/map
      (clojure.core/fn [arg4283] (clojure.core/str arg4283))
      v4282)))
   (clojure.core/when-let
    [v4282 (:private-ip-addresses m4281)]
    (.
     bean4280
     setPrivateIpAddresses
     (clojure.core/map
      (clojure.core/fn
       [arg4284]
       (private-ip-address-specification arg4284))
      v4282)))
   (clojure.core/when-let
    [v4282 (:secondary-private-ip-address-count m4281)]
    (.
     bean4280
     setSecondaryPrivateIpAddressCount
     (clojure.core/int v4282)))
   (clojure.core/when-let
    [v4282 (:device-index m4281)]
    (. bean4280 setDeviceIndex (clojure.core/int v4282)))
   (clojure.core/when-let
    [v4282 (:delete-on-termination m4281)]
    (. bean4280 setDeleteOnTermination (clojure.core/boolean v4282)))
   (clojure.core/when-let
    [v4282 (:associate-public-ip-address m4281)]
    (.
     bean4280
     setAssociatePublicIpAddress
     (clojure.core/boolean v4282)))
   (clojure.core/when-let
    [v4282 (:network-interface-id m4281)]
    (. bean4280 setNetworkInterfaceId (clojure.core/str v4282)))
   (clojure.core/when-let
    [v4282 (:description m4281)]
    (. bean4280 setDescription (clojure.core/str v4282)))
   bean4280))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.GroupIdentifier group-identifier
  [m4286]
  (clojure.core/let
   [bean4285 (new com.amazonaws.services.ec2.model.GroupIdentifier)]
   (clojure.core/when-let
    [v4287 (:group-name m4286)]
    (. bean4285 setGroupName (clojure.core/str v4287)))
   (clojure.core/when-let
    [v4287 (:group-id m4286)]
    (. bean4285 setGroupId (clojure.core/str v4287)))
   bean4285))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.BlockDeviceMapping block-device-mapping
  [m4289]
  (clojure.core/let
   [bean4288 (new com.amazonaws.services.ec2.model.BlockDeviceMapping)]
   (clojure.core/when-let
    [v4290 (:no-device m4289)]
    (. bean4288 setNoDevice (clojure.core/str v4290)))
   (clojure.core/when-let
    [v4290 (:virtual-name m4289)]
    (. bean4288 setVirtualName (clojure.core/str v4290)))
   (clojure.core/when-let
    [v4290 (:device-name m4289)]
    (. bean4288 setDeviceName (clojure.core/str v4290)))
   (clojure.core/when-let
    [v4290 (:ebs m4289)]
    (. bean4288 setEbs (ebs-block-device v4290)))
   bean4288))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.IamInstanceProfileSpecification iam-instance-profile-specification
  [m4292]
  (clojure.core/let
   [bean4291
    (new
     com.amazonaws.services.ec2.model.IamInstanceProfileSpecification)]
   (clojure.core/when-let
    [v4293 (:name m4292)]
    (. bean4291 setName (clojure.core/str v4293)))
   (clojure.core/when-let
    [v4293 (:arn m4292)]
    (. bean4291 setArn (clojure.core/str v4293)))
   bean4291))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.SpotPlacement spot-placement
  [m4295]
  (clojure.core/let
   [bean4294 (new com.amazonaws.services.ec2.model.SpotPlacement)]
   (clojure.core/when-let
    [v4296 (:group-name m4295)]
    (. bean4294 setGroupName (clojure.core/str v4296)))
   (clojure.core/when-let
    [v4296 (:availability-zone m4295)]
    (. bean4294 setAvailabilityZone (clojure.core/str v4296)))
   bean4294))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.Filter filter
  [m4298]
  (clojure.core/let
   [bean4297 (new com.amazonaws.services.ec2.model.Filter)]
   (clojure.core/when-let
    [v4299 (:name m4298)]
    (. bean4297 setName (clojure.core/str v4299)))
   (clojure.core/when-let
    [v4299 (:values m4298)]
    (.
     bean4297
     setValues
     (clojure.core/map
      (clojure.core/fn [arg4300] (clojure.core/str arg4300))
      v4299)))
   bean4297))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RuleAction rule-action
  [m4302]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.RuleAction
   (clojure.core/name m4302)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.IcmpTypeCode icmp-type-code
  [m4305]
  (clojure.core/let
   [bean4304 (new com.amazonaws.services.ec2.model.IcmpTypeCode)]
   (clojure.core/when-let
    [v4306 (:code m4305)]
    (. bean4304 setCode (clojure.core/int v4306)))
   (clojure.core/when-let
    [v4306 (:type m4305)]
    (. bean4304 setType (clojure.core/int v4306)))
   bean4304))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.PortRange port-range
  [m4308]
  (clojure.core/let
   [bean4307 (new com.amazonaws.services.ec2.model.PortRange)]
   (clojure.core/when-let
    [v4309 (:to m4308)]
    (. bean4307 setTo (clojure.core/int v4309)))
   (clojure.core/when-let
    [v4309 (:from m4308)]
    (. bean4307 setFrom (clojure.core/int v4309)))
   bean4307))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.IpPermission ip-permission
  [m4311]
  (clojure.core/let
   [bean4310 (new com.amazonaws.services.ec2.model.IpPermission)]
   (clojure.core/when-let
    [v4312 (:ip-protocol m4311)]
    (. bean4310 setIpProtocol (clojure.core/str v4312)))
   (clojure.core/when-let
    [v4312 (:from-port m4311)]
    (. bean4310 setFromPort (clojure.core/int v4312)))
   (clojure.core/when-let
    [v4312 (:to-port m4311)]
    (. bean4310 setToPort (clojure.core/int v4312)))
   (clojure.core/when-let
    [v4312 (:user-id-group-pairs m4311)]
    (.
     bean4310
     setUserIdGroupPairs
     (clojure.core/map
      (clojure.core/fn [arg4313] (user-id-group-pair arg4313))
      v4312)))
   (clojure.core/when-let
    [v4312 (:ip-ranges m4311)]
    (.
     bean4310
     setIpRanges
     (clojure.core/map
      (clojure.core/fn [arg4314] (clojure.core/str arg4314))
      v4312)))
   bean4310))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.PriceScheduleSpecification price-schedule-specification
  [m4316]
  (clojure.core/let
   [bean4315
    (new com.amazonaws.services.ec2.model.PriceScheduleSpecification)]
   (clojure.core/when-let
    [v4317 (:term m4316)]
    (. bean4315 setTerm (clojure.core/long v4317)))
   (clojure.core/when-let
    [v4317 (:price m4316)]
    (. bean4315 setPrice (clojure.core/double v4317)))
   (clojure.core/when-let
    [v4317 (:currency-code m4316)]
    (. bean4315 setCurrencyCode (currency-code-values v4317)))
   (clojure.core/when-let
    [v4317 (:currency-code m4316)]
    (. bean4315 setCurrencyCode (clojure.core/str v4317)))
   bean4315))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ResetImageAttributeName reset-image-attribute-name
  [m4319]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.ResetImageAttributeName
   (clojure.core/name m4319)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.LaunchPermissionModifications launch-permission-modifications
  [m4322]
  (clojure.core/let
   [bean4321
    (new
     com.amazonaws.services.ec2.model.LaunchPermissionModifications)]
   (clojure.core/when-let
    [v4323 (:add m4322)]
    (.
     bean4321
     setAdd
     (clojure.core/map
      (clojure.core/fn [arg4324] (launch-permission arg4324))
      v4323)))
   (clojure.core/when-let
    [v4323 (:remove m4322)]
    (.
     bean4321
     setRemove
     (clojure.core/map
      (clojure.core/fn [arg4325] (launch-permission arg4325))
      v4323)))
   bean4321))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.SnapshotAttributeName snapshot-attribute-name
  [m4327]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.SnapshotAttributeName
   (clojure.core/name m4327)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ImageAttributeName image-attribute-name
  [m4330]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.ImageAttributeName
   (clojure.core/name m4330)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReportStatusType report-status-type
  [m4333]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.ReportStatusType
   (clojure.core/name m4333)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.Tag tag
  [m4336]
  (clojure.core/let
   [bean4335 (new com.amazonaws.services.ec2.model.Tag)]
   (clojure.core/when-let
    [v4337 (:value m4336)]
    (. bean4335 setValue (clojure.core/str v4337)))
   (clojure.core/when-let
    [v4337 (:key m4336)]
    (. bean4335 setKey (clojure.core/str v4337)))
   bean4335))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateVolumePermissionModifications create-volume-permission-modifications
  [m4339]
  (clojure.core/let
   [bean4338
    (new
     com.amazonaws.services.ec2.model.CreateVolumePermissionModifications)]
   (clojure.core/when-let
    [v4340 (:add m4339)]
    (.
     bean4338
     setAdd
     (clojure.core/map
      (clojure.core/fn [arg4341] (create-volume-permission arg4341))
      v4340)))
   (clojure.core/when-let
    [v4340 (:remove m4339)]
    (.
     bean4338
     setRemove
     (clojure.core/map
      (clojure.core/fn [arg4342] (create-volume-permission arg4342))
      v4340)))
   bean4338))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.PlacementStrategy placement-strategy
  [m4344]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.PlacementStrategy
   (clojure.core/name m4344)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReservedInstancesConfiguration reserved-instances-configuration
  [m4347]
  (clojure.core/let
   [bean4346
    (new
     com.amazonaws.services.ec2.model.ReservedInstancesConfiguration)]
   (clojure.core/when-let
    [v4348 (:platform m4347)]
    (. bean4346 setPlatform (clojure.core/str v4348)))
   (clojure.core/when-let
    [v4348 (:instance-type m4347)]
    (. bean4346 setInstanceType (clojure.core/str v4348)))
   (clojure.core/when-let
    [v4348 (:instance-type m4347)]
    (. bean4346 setInstanceType (instance-type v4348)))
   (clojure.core/when-let
    [v4348 (:instance-count m4347)]
    (. bean4346 setInstanceCount (clojure.core/int v4348)))
   (clojure.core/when-let
    [v4348 (:availability-zone m4347)]
    (. bean4346 setAvailabilityZone (clojure.core/str v4348)))
   bean4346))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.VpcAttributeName vpc-attribute-name
  [m4350]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.VpcAttributeName
   (clojure.core/name m4350)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.InstanceLicenseSpecification instance-license-specification
  [m4353]
  (clojure.core/let
   [bean4352
    (new
     com.amazonaws.services.ec2.model.InstanceLicenseSpecification)]
   (clojure.core/when-let
    [v4354 (:pool m4353)]
    (. bean4352 setPool (clojure.core/str v4354)))
   bean4352))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.OfferingTypeValues offering-type-values
  [m4356]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.OfferingTypeValues
   (clojure.core/name m4356)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.PlatformValues platform-values
  [m4359]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.PlatformValues
   (clojure.core/name m4359)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification import-instance-launch-specification
  [m4362]
  (clojure.core/let
   [bean4361
    (new
     com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification)]
   (clojure.core/when-let
    [v4363 (:group-names m4362)]
    (.
     bean4361
     setGroupNames
     (clojure.core/map
      (clojure.core/fn [arg4364] (clojure.core/str arg4364))
      v4363)))
   (clojure.core/when-let
    [v4363 (:subnet-id m4362)]
    (. bean4361 setSubnetId (clojure.core/str v4363)))
   (clojure.core/when-let
    [v4363 (:private-ip-address m4362)]
    (. bean4361 setPrivateIpAddress (clojure.core/str v4363)))
   (clojure.core/when-let
    [v4363 (:monitoring m4362)]
    (. bean4361 setMonitoring (clojure.core/boolean v4363)))
   (clojure.core/when-let
    [v4363 (:instance-initiated-shutdown-behavior m4362)]
    (.
     bean4361
     setInstanceInitiatedShutdownBehavior
     (clojure.core/str v4363)))
   (clojure.core/when-let
    [v4363 (:instance-initiated-shutdown-behavior m4362)]
    (.
     bean4361
     setInstanceInitiatedShutdownBehavior
     (shutdown-behavior v4363)))
   (clojure.core/when-let
    [v4363 (:architecture m4362)]
    (. bean4361 setArchitecture (architecture-values v4363)))
   (clojure.core/when-let
    [v4363 (:architecture m4362)]
    (. bean4361 setArchitecture (clojure.core/str v4363)))
   (clojure.core/when-let
    [v4363 (:user-data m4362)]
    (. bean4361 setUserData (clojure.core/str v4363)))
   (clojure.core/when-let
    [v4363 (:instance-type m4362)]
    (. bean4361 setInstanceType (clojure.core/str v4363)))
   (clojure.core/when-let
    [v4363 (:instance-type m4362)]
    (. bean4361 setInstanceType (instance-type v4363)))
   (clojure.core/when-let
    [v4363 (:additional-info m4362)]
    (. bean4361 setAdditionalInfo (clojure.core/str v4363)))
   (clojure.core/when-let
    [v4363 (:placement m4362)]
    (. bean4361 setPlacement (placement v4363)))
   bean4361))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DiskImage disk-image
  [m4366]
  (clojure.core/let
   [bean4365 (new com.amazonaws.services.ec2.model.DiskImage)]
   (clojure.core/when-let
    [v4367 (:image m4366)]
    (. bean4365 setImage (disk-image-detail v4367)))
   (clojure.core/when-let
    [v4367 (:volume m4366)]
    (. bean4365 setVolume (volume-detail v4367)))
   (clojure.core/when-let
    [v4367 (:description m4366)]
    (. bean4365 setDescription (clojure.core/str v4367)))
   bean4365))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DomainType domain-type
  [m4369]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.DomainType
   (clojure.core/name m4369)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges network-interface-attachment-changes
  [m4372]
  (clojure.core/let
   [bean4371
    (new
     com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges)]
   (clojure.core/when-let
    [v4373 (:attachment-id m4372)]
    (. bean4371 setAttachmentId (clojure.core/str v4373)))
   (clojure.core/when-let
    [v4373 (:delete-on-termination m4372)]
    (. bean4371 setDeleteOnTermination (clojure.core/boolean v4373)))
   bean4371))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.VolumeAttributeName volume-attribute-name
  [m4375]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.VolumeAttributeName
   (clojure.core/name m4375)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification instance-block-device-mapping-specification
  [m4378]
  (clojure.core/let
   [bean4377
    (new
     com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification)]
   (clojure.core/when-let
    [v4379 (:no-device m4378)]
    (. bean4377 setNoDevice (clojure.core/str v4379)))
   (clojure.core/when-let
    [v4379 (:virtual-name m4378)]
    (. bean4377 setVirtualName (clojure.core/str v4379)))
   (clojure.core/when-let
    [v4379 (:device-name m4378)]
    (. bean4377 setDeviceName (clojure.core/str v4379)))
   (clojure.core/when-let
    [v4379 (:ebs m4378)]
    (.
     bean4377
     setEbs
     (ebs-instance-block-device-specification v4379)))
   bean4377))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.InstanceAttributeName instance-attribute-name
  [m4381]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.InstanceAttributeName
   (clojure.core/name m4381)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.Storage storage
  [m4384]
  (clojure.core/let
   [bean4383 (new com.amazonaws.services.ec2.model.Storage)]
   (clojure.core/when-let
    [v4385 (:s3 m4384)]
    (. bean4383 setS3 (s3storage v4385)))
   bean4383))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice reserved-instance-limit-price
  [m4387]
  (clojure.core/let
   [bean4386
    (new com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice)]
   (clojure.core/when-let
    [v4388 (:amount m4387)]
    (. bean4386 setAmount (clojure.core/double v4388)))
   (clojure.core/when-let
    [v4388 (:currency-code m4387)]
    (. bean4386 setCurrencyCode (currency-code-values v4388)))
   (clojure.core/when-let
    [v4388 (:currency-code m4387)]
    (. bean4386 setCurrencyCode (clojure.core/str v4388)))
   bean4386))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.GatewayType gateway-type
  [m4390]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.GatewayType
   (clojure.core/name m4390)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RIProductDescription riproduct-description
  [m4393]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.RIProductDescription
   (clojure.core/name m4393)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ExportEnvironment export-environment
  [m4396]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.ExportEnvironment
   (clojure.core/name m4396)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ExportToS3TaskSpecification export-to-s3task-specification
  [m4399]
  (clojure.core/let
   [bean4398
    (new com.amazonaws.services.ec2.model.ExportToS3TaskSpecification)]
   (clojure.core/when-let
    [v4400 (:disk-image-format m4399)]
    (. bean4398 setDiskImageFormat (clojure.core/str v4400)))
   (clojure.core/when-let
    [v4400 (:disk-image-format m4399)]
    (. bean4398 setDiskImageFormat (disk-image-format v4400)))
   (clojure.core/when-let
    [v4400 (:container-format m4399)]
    (. bean4398 setContainerFormat (clojure.core/str v4400)))
   (clojure.core/when-let
    [v4400 (:container-format m4399)]
    (. bean4398 setContainerFormat (container-format v4400)))
   (clojure.core/when-let
    [v4400 (:s3bucket m4399)]
    (. bean4398 setS3Bucket (clojure.core/str v4400)))
   (clojure.core/when-let
    [v4400 (:s3prefix m4399)]
    (. bean4398 setS3Prefix (clojure.core/str v4400)))
   bean4398))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification vpn-connection-options-specification
  [m4402]
  (clojure.core/let
   [bean4401
    (new
     com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification)]
   (clojure.core/when-let
    [v4403 (:static-routes-only m4402)]
    (. bean4401 setStaticRoutesOnly (clojure.core/boolean v4403)))
   bean4401))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.LaunchSpecification launch-specification
  [m4405]
  (clojure.core/let
   [bean4404
    (new com.amazonaws.services.ec2.model.LaunchSpecification)]
   (clojure.core/when-let
    [v4406 (:network-interfaces m4405)]
    (.
     bean4404
     setNetworkInterfaces
     (clojure.core/map
      (clojure.core/fn
       [arg4407]
       (instance-network-interface-specification arg4407))
      v4406)))
   (clojure.core/when-let
    [v4406 (:subnet-id m4405)]
    (. bean4404 setSubnetId (clojure.core/str v4406)))
   (clojure.core/when-let
    [v4406 (:all-security-groups m4405)]
    (.
     bean4404
     setAllSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg4408] (group-identifier arg4408))
      v4406)))
   (clojure.core/when-let
    [v4406 (:addressing-type m4405)]
    (. bean4404 setAddressingType (clojure.core/str v4406)))
   (clojure.core/when-let
    [v4406 (:monitoring-enabled m4405)]
    (. bean4404 setMonitoringEnabled (clojure.core/boolean v4406)))
   (clojure.core/when-let
    [v4406 (:image-id m4405)]
    (. bean4404 setImageId (clojure.core/str v4406)))
   (clojure.core/when-let
    [v4406 (:key-name m4405)]
    (. bean4404 setKeyName (clojure.core/str v4406)))
   (clojure.core/when-let
    [v4406 (:security-groups m4405)]
    (.
     bean4404
     setSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg4409] (clojure.core/str arg4409))
      v4406)))
   (clojure.core/when-let
    [v4406 (:user-data m4405)]
    (. bean4404 setUserData (clojure.core/str v4406)))
   (clojure.core/when-let
    [v4406 (:instance-type m4405)]
    (. bean4404 setInstanceType (clojure.core/str v4406)))
   (clojure.core/when-let
    [v4406 (:instance-type m4405)]
    (. bean4404 setInstanceType (instance-type v4406)))
   (clojure.core/when-let
    [v4406 (:kernel-id m4405)]
    (. bean4404 setKernelId (clojure.core/str v4406)))
   (clojure.core/when-let
    [v4406 (:ramdisk-id m4405)]
    (. bean4404 setRamdiskId (clojure.core/str v4406)))
   (clojure.core/when-let
    [v4406 (:block-device-mappings m4405)]
    (.
     bean4404
     setBlockDeviceMappings
     (clojure.core/map
      (clojure.core/fn [arg4410] (block-device-mapping arg4410))
      v4406)))
   (clojure.core/when-let
    [v4406 (:iam-instance-profile m4405)]
    (.
     bean4404
     setIamInstanceProfile
     (iam-instance-profile-specification v4406)))
   (clojure.core/when-let
    [v4406 (:ebs-optimized m4405)]
    (. bean4404 setEbsOptimized (clojure.core/boolean v4406)))
   (clojure.core/when-let
    [v4406 (:placement m4405)]
    (. bean4404 setPlacement (spot-placement v4406)))
   bean4404))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.SpotInstanceType spot-instance-type
  [m4412]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.SpotInstanceType
   (clojure.core/name m4412)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DhcpConfiguration dhcp-configuration
  [m4415]
  (clojure.core/let
   [bean4414 (new com.amazonaws.services.ec2.model.DhcpConfiguration)]
   (clojure.core/when-let
    [v4416 (:values m4415)]
    (.
     bean4414
     setValues
     (clojure.core/map
      (clojure.core/fn [arg4417] (clojure.core/str arg4417))
      v4416)))
   (clojure.core/when-let
    [v4416 (:key m4415)]
    (. bean4414 setKey (clojure.core/str v4416)))
   bean4414))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest describe-security-groups-request
  [m4419]
  (clojure.core/let
   [bean4418
    (new
     com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest)]
   (clojure.core/when-let
    [v4420 (:group-names m4419)]
    (.
     bean4418
     setGroupNames
     (clojure.core/map
      (clojure.core/fn [arg4421] (clojure.core/str arg4421))
      v4420)))
   (clojure.core/when-let
    [v4420 (:group-ids m4419)]
    (.
     bean4418
     setGroupIds
     (clojure.core/map
      (clojure.core/fn [arg4422] (clojure.core/str arg4422))
      v4420)))
   (clojure.core/when-let
    [v4420 (:filters m4419)]
    (.
     bean4418
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4423] (filter arg4423))
      v4420)))
   bean4418))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateVpcRequest create-vpc-request
  [m4425]
  (clojure.core/let
   [bean4424 (new com.amazonaws.services.ec2.model.CreateVpcRequest)]
   (clojure.core/when-let
    [v4426 (:cidr-block m4425)]
    (. bean4424 setCidrBlock (clojure.core/str v4426)))
   (clojure.core/when-let
    [v4426 (:instance-tenancy m4425)]
    (. bean4424 setInstanceTenancy (clojure.core/str v4426)))
   (clojure.core/when-let
    [v4426 (:instance-tenancy m4425)]
    (. bean4424 setInstanceTenancy (tenancy v4426)))
   bean4424))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeregisterImageRequest deregister-image-request
  [m4428]
  (clojure.core/let
   [bean4427
    (new com.amazonaws.services.ec2.model.DeregisterImageRequest)]
   (clojure.core/when-let
    [v4429 (:image-id m4428)]
    (. bean4427 setImageId (clojure.core/str v4429)))
   bean4427))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest create-network-acl-entry-request
  [m4431]
  (clojure.core/let
   [bean4430
    (new
     com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest)]
   (clojure.core/when-let
    [v4432 (:network-acl-id m4431)]
    (. bean4430 setNetworkAclId (clojure.core/str v4432)))
   (clojure.core/when-let
    [v4432 (:rule-number m4431)]
    (. bean4430 setRuleNumber (clojure.core/int v4432)))
   (clojure.core/when-let
    [v4432 (:rule-action m4431)]
    (. bean4430 setRuleAction (rule-action v4432)))
   (clojure.core/when-let
    [v4432 (:rule-action m4431)]
    (. bean4430 setRuleAction (clojure.core/str v4432)))
   (clojure.core/when-let
    [v4432 (:egress m4431)]
    (. bean4430 setEgress (clojure.core/boolean v4432)))
   (clojure.core/when-let
    [v4432 (:cidr-block m4431)]
    (. bean4430 setCidrBlock (clojure.core/str v4432)))
   (clojure.core/when-let
    [v4432 (:icmp-type-code m4431)]
    (. bean4430 setIcmpTypeCode (icmp-type-code v4432)))
   (clojure.core/when-let
    [v4432 (:port-range m4431)]
    (. bean4430 setPortRange (port-range v4432)))
   (clojure.core/when-let
    [v4432 (:protocol m4431)]
    (. bean4430 setProtocol (clojure.core/str v4432)))
   bean4430))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CancelExportTaskRequest cancel-export-task-request
  [m4434]
  (clojure.core/let
   [bean4433
    (new com.amazonaws.services.ec2.model.CancelExportTaskRequest)]
   (clojure.core/when-let
    [v4435 (:export-task-id m4434)]
    (. bean4433 setExportTaskId (clojure.core/str v4435)))
   bean4433))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest revoke-security-group-ingress-request
  [m4437]
  (clojure.core/let
   [bean4436
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v4438 (:group-name m4437)]
    (. bean4436 setGroupName (clojure.core/str v4438)))
   (clojure.core/when-let
    [v4438 (:group-id m4437)]
    (. bean4436 setGroupId (clojure.core/str v4438)))
   (clojure.core/when-let
    [v4438 (:source-security-group-name m4437)]
    (. bean4436 setSourceSecurityGroupName (clojure.core/str v4438)))
   (clojure.core/when-let
    [v4438 (:source-security-group-owner-id m4437)]
    (.
     bean4436
     setSourceSecurityGroupOwnerId
     (clojure.core/str v4438)))
   (clojure.core/when-let
    [v4438 (:ip-protocol m4437)]
    (. bean4436 setIpProtocol (clojure.core/str v4438)))
   (clojure.core/when-let
    [v4438 (:from-port m4437)]
    (. bean4436 setFromPort (clojure.core/int v4438)))
   (clojure.core/when-let
    [v4438 (:to-port m4437)]
    (. bean4436 setToPort (clojure.core/int v4438)))
   (clojure.core/when-let
    [v4438 (:cidr-ip m4437)]
    (. bean4436 setCidrIp (clojure.core/str v4438)))
   (clojure.core/when-let
    [v4438 (:ip-permissions m4437)]
    (.
     bean4436
     setIpPermissions
     (clojure.core/map
      (clojure.core/fn [arg4439] (ip-permission arg4439))
      v4438)))
   bean4436))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeRouteTablesRequest describe-route-tables-request
  [m4441]
  (clojure.core/let
   [bean4440
    (new com.amazonaws.services.ec2.model.DescribeRouteTablesRequest)]
   (clojure.core/when-let
    [v4442 (:route-table-ids m4441)]
    (.
     bean4440
     setRouteTableIds
     (clojure.core/map
      (clojure.core/fn [arg4443] (clojure.core/str arg4443))
      v4442)))
   (clojure.core/when-let
    [v4442 (:filters m4441)]
    (.
     bean4440
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4444] (filter arg4444))
      v4442)))
   bean4440))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest create-reserved-instances-listing-request
  [m4446]
  (clojure.core/let
   [bean4445
    (new
     com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest)]
   (clojure.core/when-let
    [v4447 (:reserved-instances-id m4446)]
    (. bean4445 setReservedInstancesId (clojure.core/str v4447)))
   (clojure.core/when-let
    [v4447 (:price-schedules m4446)]
    (.
     bean4445
     setPriceSchedules
     (clojure.core/map
      (clojure.core/fn
       [arg4448]
       (price-schedule-specification arg4448))
      v4447)))
   (clojure.core/when-let
    [v4447 (:instance-count m4446)]
    (. bean4445 setInstanceCount (clojure.core/int v4447)))
   (clojure.core/when-let
    [v4447 (:client-token m4446)]
    (. bean4445 setClientToken (clojure.core/str v4447)))
   bean4445))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ResetImageAttributeRequest reset-image-attribute-request
  [m4450]
  (clojure.core/let
   [bean4449
    (new com.amazonaws.services.ec2.model.ResetImageAttributeRequest)]
   (clojure.core/when-let
    [v4451 (:image-id m4450)]
    (. bean4449 setImageId (clojure.core/str v4451)))
   (clojure.core/when-let
    [v4451 (:attribute m4450)]
    (. bean4449 setAttribute (clojure.core/str v4451)))
   (clojure.core/when-let
    [v4451 (:attribute m4450)]
    (. bean4449 setAttribute (reset-image-attribute-name v4451)))
   bean4449))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest describe-availability-zones-request
  [m4453]
  (clojure.core/let
   [bean4452
    (new
     com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest)]
   (clojure.core/when-let
    [v4454 (:zone-names m4453)]
    (.
     bean4452
     setZoneNames
     (clojure.core/map
      (clojure.core/fn [arg4455] (clojure.core/str arg4455))
      v4454)))
   (clojure.core/when-let
    [v4454 (:filters m4453)]
    (.
     bean4452
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4456] (filter arg4456))
      v4454)))
   bean4452))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest describe-network-acls-request
  [m4458]
  (clojure.core/let
   [bean4457
    (new com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest)]
   (clojure.core/when-let
    [v4459 (:network-acl-ids m4458)]
    (.
     bean4457
     setNetworkAclIds
     (clojure.core/map
      (clojure.core/fn [arg4460] (clojure.core/str arg4460))
      v4459)))
   (clojure.core/when-let
    [v4459 (:filters m4458)]
    (.
     bean4457
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4461] (filter arg4461))
      v4459)))
   bean4457))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest describe-vpn-gateways-request
  [m4463]
  (clojure.core/let
   [bean4462
    (new com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest)]
   (clojure.core/when-let
    [v4464 (:vpn-gateway-ids m4463)]
    (.
     bean4462
     setVpnGatewayIds
     (clojure.core/map
      (clojure.core/fn [arg4465] (clojure.core/str arg4465))
      v4464)))
   (clojure.core/when-let
    [v4464 (:filters m4463)]
    (.
     bean4462
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4466] (filter arg4466))
      v4464)))
   bean4462))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeSnapshotsRequest describe-snapshots-request
  [m4468]
  (clojure.core/let
   [bean4467
    (new com.amazonaws.services.ec2.model.DescribeSnapshotsRequest)]
   (clojure.core/when-let
    [v4469 (:snapshot-ids m4468)]
    (.
     bean4467
     setSnapshotIds
     (clojure.core/map
      (clojure.core/fn [arg4470] (clojure.core/str arg4470))
      v4469)))
   (clojure.core/when-let
    [v4469 (:owner-ids m4468)]
    (.
     bean4467
     setOwnerIds
     (clojure.core/map
      (clojure.core/fn [arg4471] (clojure.core/str arg4471))
      v4469)))
   (clojure.core/when-let
    [v4469 (:restorable-by-user-ids m4468)]
    (.
     bean4467
     setRestorableByUserIds
     (clojure.core/map
      (clojure.core/fn [arg4472] (clojure.core/str arg4472))
      v4469)))
   (clojure.core/when-let
    [v4469 (:filters m4468)]
    (.
     bean4467
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4473] (filter arg4473))
      v4469)))
   bean4467))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ModifyImageAttributeRequest modify-image-attribute-request
  [m4475]
  (clojure.core/let
   [bean4474
    (new com.amazonaws.services.ec2.model.ModifyImageAttributeRequest)]
   (clojure.core/when-let
    [v4476 (:value m4475)]
    (. bean4474 setValue (clojure.core/str v4476)))
   (clojure.core/when-let
    [v4476 (:operation-type m4475)]
    (. bean4474 setOperationType (clojure.core/str v4476)))
   (clojure.core/when-let
    [v4476 (:user-ids m4475)]
    (.
     bean4474
     setUserIds
     (clojure.core/map
      (clojure.core/fn [arg4477] (clojure.core/str arg4477))
      v4476)))
   (clojure.core/when-let
    [v4476 (:user-groups m4475)]
    (.
     bean4474
     setUserGroups
     (clojure.core/map
      (clojure.core/fn [arg4478] (clojure.core/str arg4478))
      v4476)))
   (clojure.core/when-let
    [v4476 (:product-codes m4475)]
    (.
     bean4474
     setProductCodes
     (clojure.core/map
      (clojure.core/fn [arg4479] (clojure.core/str arg4479))
      v4476)))
   (clojure.core/when-let
    [v4476 (:launch-permission m4475)]
    (.
     bean4474
     setLaunchPermission
     (launch-permission-modifications v4476)))
   (clojure.core/when-let
    [v4476 (:image-id m4475)]
    (. bean4474 setImageId (clojure.core/str v4476)))
   (clojure.core/when-let
    [v4476 (:attribute m4475)]
    (. bean4474 setAttribute (clojure.core/str v4476)))
   (clojure.core/when-let
    [v4476 (:description m4475)]
    (. bean4474 setDescription (clojure.core/str v4476)))
   bean4474))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeVolumesRequest describe-volumes-request
  [m4481]
  (clojure.core/let
   [bean4480
    (new com.amazonaws.services.ec2.model.DescribeVolumesRequest)]
   (clojure.core/when-let
    [v4482 (:volume-ids m4481)]
    (.
     bean4480
     setVolumeIds
     (clojure.core/map
      (clojure.core/fn [arg4483] (clojure.core/str arg4483))
      v4482)))
   (clojure.core/when-let
    [v4482 (:filters m4481)]
    (.
     bean4480
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4484] (filter arg4484))
      v4482)))
   bean4480))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AttachInternetGatewayRequest attach-internet-gateway-request
  [m4486]
  (clojure.core/let
   [bean4485
    (new
     com.amazonaws.services.ec2.model.AttachInternetGatewayRequest)]
   (clojure.core/when-let
    [v4487 (:internet-gateway-id m4486)]
    (. bean4485 setInternetGatewayId (clojure.core/str v4487)))
   (clojure.core/when-let
    [v4487 (:vpc-id m4486)]
    (. bean4485 setVpcId (clojure.core/str v4487)))
   bean4485))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeLicensesRequest describe-licenses-request
  [m4489]
  (clojure.core/let
   [bean4488
    (new com.amazonaws.services.ec2.model.DescribeLicensesRequest)]
   (clojure.core/when-let
    [v4490 (:license-ids m4489)]
    (.
     bean4488
     setLicenseIds
     (clojure.core/map
      (clojure.core/fn [arg4491] (clojure.core/str arg4491))
      v4490)))
   (clojure.core/when-let
    [v4490 (:filters m4489)]
    (.
     bean4488
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4492] (filter arg4492))
      v4490)))
   bean4488))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest delete-security-group-request
  [m4494]
  (clojure.core/let
   [bean4493
    (new com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest)]
   (clojure.core/when-let
    [v4495 (:group-name m4494)]
    (. bean4493 setGroupName (clojure.core/str v4495)))
   (clojure.core/when-let
    [v4495 (:group-id m4494)]
    (. bean4493 setGroupId (clojure.core/str v4495)))
   bean4493))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DetachVolumeRequest detach-volume-request
  [m4497]
  (clojure.core/let
   [bean4496
    (new com.amazonaws.services.ec2.model.DetachVolumeRequest)]
   (clojure.core/when-let
    [v4498 (:volume-id m4497)]
    (. bean4496 setVolumeId (clojure.core/str v4498)))
   (clojure.core/when-let
    [v4498 (:device m4497)]
    (. bean4496 setDevice (clojure.core/str v4498)))
   (clojure.core/when-let
    [v4498 (:force m4497)]
    (. bean4496 setForce (clojure.core/boolean v4498)))
   (clojure.core/when-let
    [v4498 (:instance-id m4497)]
    (. bean4496 setInstanceId (clojure.core/str v4498)))
   bean4496))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReleaseAddressRequest release-address-request
  [m4500]
  (clojure.core/let
   [bean4499
    (new com.amazonaws.services.ec2.model.ReleaseAddressRequest)]
   (clojure.core/when-let
    [v4501 (:public-ip m4500)]
    (. bean4499 setPublicIp (clojure.core/str v4501)))
   (clojure.core/when-let
    [v4501 (:allocation-id m4500)]
    (. bean4499 setAllocationId (clojure.core/str v4501)))
   bean4499))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ImportVolumeRequest import-volume-request
  [m4503]
  (clojure.core/let
   [bean4502
    (new com.amazonaws.services.ec2.model.ImportVolumeRequest)]
   (clojure.core/when-let
    [v4504 (:image m4503)]
    (. bean4502 setImage (disk-image-detail v4504)))
   (clojure.core/when-let
    [v4504 (:volume m4503)]
    (. bean4502 setVolume (volume-detail v4504)))
   (clojure.core/when-let
    [v4504 (:availability-zone m4503)]
    (. bean4502 setAvailabilityZone (clojure.core/str v4504)))
   (clojure.core/when-let
    [v4504 (:description m4503)]
    (. bean4502 setDescription (clojure.core/str v4504)))
   bean4502))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteRouteTableRequest delete-route-table-request
  [m4506]
  (clojure.core/let
   [bean4505
    (new com.amazonaws.services.ec2.model.DeleteRouteTableRequest)]
   (clojure.core/when-let
    [v4507 (:route-table-id m4506)]
    (. bean4505 setRouteTableId (clojure.core/str v4507)))
   bean4505))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest describe-snapshot-attribute-request
  [m4509]
  (clojure.core/let
   [bean4508
    (new
     com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest)]
   (clojure.core/when-let
    [v4510 (:snapshot-id m4509)]
    (. bean4508 setSnapshotId (clojure.core/str v4510)))
   (clojure.core/when-let
    [v4510 (:attribute m4509)]
    (. bean4508 setAttribute (clojure.core/str v4510)))
   (clojure.core/when-let
    [v4510 (:attribute m4509)]
    (. bean4508 setAttribute (snapshot-attribute-name v4510)))
   bean4508))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest describe-instance-status-request
  [m4512]
  (clojure.core/let
   [bean4511
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest)]
   (clojure.core/when-let
    [v4513 (:max-results m4512)]
    (. bean4511 setMaxResults (clojure.core/int v4513)))
   (clojure.core/when-let
    [v4513 (:include-all-instances m4512)]
    (. bean4511 setIncludeAllInstances (clojure.core/boolean v4513)))
   (clojure.core/when-let
    [v4513 (:next-token m4512)]
    (. bean4511 setNextToken (clojure.core/str v4513)))
   (clojure.core/when-let
    [v4513 (:filters m4512)]
    (.
     bean4511
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4514] (filter arg4514))
      v4513)))
   (clojure.core/when-let
    [v4513 (:instance-ids m4512)]
    (.
     bean4511
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg4515] (clojure.core/str arg4515))
      v4513)))
   bean4511))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeImageAttributeRequest describe-image-attribute-request
  [m4517]
  (clojure.core/let
   [bean4516
    (new
     com.amazonaws.services.ec2.model.DescribeImageAttributeRequest)]
   (clojure.core/when-let
    [v4518 (:image-id m4517)]
    (. bean4516 setImageId (clojure.core/str v4518)))
   (clojure.core/when-let
    [v4518 (:attribute m4517)]
    (. bean4516 setAttribute (clojure.core/str v4518)))
   (clojure.core/when-let
    [v4518 (:attribute m4517)]
    (. bean4516 setAttribute (image-attribute-name v4518)))
   bean4516))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReportInstanceStatusRequest report-instance-status-request
  [m4520]
  (clojure.core/let
   [bean4519
    (new com.amazonaws.services.ec2.model.ReportInstanceStatusRequest)]
   (clojure.core/when-let
    [v4521 (:reason-codes m4520)]
    (.
     bean4519
     setReasonCodes
     (clojure.core/map
      (clojure.core/fn [arg4522] (clojure.core/str arg4522))
      v4521)))
   (clojure.core/when-let
    [v4521 (:instances m4520)]
    (.
     bean4519
     setInstances
     (clojure.core/map
      (clojure.core/fn [arg4523] (clojure.core/str arg4523))
      v4521)))
   (clojure.core/when-let
    [v4521 (:status m4520)]
    (. bean4519 setStatus (clojure.core/str v4521)))
   (clojure.core/when-let
    [v4521 (:status m4520)]
    (. bean4519 setStatus (report-status-type v4521)))
   (clojure.core/when-let
    [v4521 (:description m4520)]
    (. bean4519 setDescription (clojure.core/str v4521)))
   (clojure.core/when-let
    [v4521 (:start-time m4520)]
    (.
     bean4519
     setStartTime
     (com.palletops.awaze.common/to-date v4521)))
   (clojure.core/when-let
    [v4521 (:end-time m4520)]
    (. bean4519 setEndTime (com.palletops.awaze.common/to-date v4521)))
   bean4519))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteTagsRequest delete-tags-request
  [m4525]
  (clojure.core/let
   [bean4524 (new com.amazonaws.services.ec2.model.DeleteTagsRequest)]
   (clojure.core/when-let
    [v4526 (:resources m4525)]
    (.
     bean4524
     setResources
     (clojure.core/map
      (clojure.core/fn [arg4527] (clojure.core/str arg4527))
      v4526)))
   (clojure.core/when-let
    [v4526 (:tags m4525)]
    (.
     bean4524
     setTags
     (clojure.core/map
      (clojure.core/fn [arg4528] (tag arg4528))
      v4526)))
   bean4524))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest reset-snapshot-attribute-request
  [m4530]
  (clojure.core/let
   [bean4529
    (new
     com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest)]
   (clojure.core/when-let
    [v4531 (:snapshot-id m4530)]
    (. bean4529 setSnapshotId (clojure.core/str v4531)))
   (clojure.core/when-let
    [v4531 (:attribute m4530)]
    (. bean4529 setAttribute (clojure.core/str v4531)))
   (clojure.core/when-let
    [v4531 (:attribute m4530)]
    (. bean4529 setAttribute (snapshot-attribute-name v4531)))
   bean4529))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest associate-dhcp-options-request
  [m4533]
  (clojure.core/let
   [bean4532
    (new com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest)]
   (clojure.core/when-let
    [v4534 (:dhcp-options-id m4533)]
    (. bean4532 setDhcpOptionsId (clojure.core/str v4534)))
   (clojure.core/when-let
    [v4534 (:vpc-id m4533)]
    (. bean4532 setVpcId (clojure.core/str v4534)))
   bean4532))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest modify-snapshot-attribute-request
  [m4536]
  (clojure.core/let
   [bean4535
    (new
     com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest)]
   (clojure.core/when-let
    [v4537 (:group-names m4536)]
    (.
     bean4535
     setGroupNames
     (clojure.core/map
      (clojure.core/fn [arg4538] (clojure.core/str arg4538))
      v4537)))
   (clojure.core/when-let
    [v4537 (:operation-type m4536)]
    (. bean4535 setOperationType (clojure.core/str v4537)))
   (clojure.core/when-let
    [v4537 (:user-ids m4536)]
    (.
     bean4535
     setUserIds
     (clojure.core/map
      (clojure.core/fn [arg4539] (clojure.core/str arg4539))
      v4537)))
   (clojure.core/when-let
    [v4537 (:create-volume-permission m4536)]
    (.
     bean4535
     setCreateVolumePermission
     (create-volume-permission-modifications v4537)))
   (clojure.core/when-let
    [v4537 (:snapshot-id m4536)]
    (. bean4535 setSnapshotId (clojure.core/str v4537)))
   (clojure.core/when-let
    [v4537 (:attribute m4536)]
    (. bean4535 setAttribute (snapshot-attribute-name v4537)))
   (clojure.core/when-let
    [v4537 (:attribute m4536)]
    (. bean4535 setAttribute (clojure.core/str v4537)))
   bean4535))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest modify-volume-attribute-request
  [m4541]
  (clojure.core/let
   [bean4540
    (new
     com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest)]
   (clojure.core/when-let
    [v4542 (:volume-id m4541)]
    (. bean4540 setVolumeId (clojure.core/str v4542)))
   (clojure.core/when-let
    [v4542 (:auto-enable-io m4541)]
    (. bean4540 setAutoEnableIO (clojure.core/boolean v4542)))
   bean4540))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreatePlacementGroupRequest create-placement-group-request
  [m4544]
  (clojure.core/let
   [bean4543
    (new com.amazonaws.services.ec2.model.CreatePlacementGroupRequest)]
   (clojure.core/when-let
    [v4545 (:group-name m4544)]
    (. bean4543 setGroupName (clojure.core/str v4545)))
   (clojure.core/when-let
    [v4545 (:strategy m4544)]
    (. bean4543 setStrategy (clojure.core/str v4545)))
   (clojure.core/when-let
    [v4545 (:strategy m4544)]
    (. bean4543 setStrategy (placement-strategy v4545)))
   bean4543))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest describe-vpn-connections-request
  [m4547]
  (clojure.core/let
   [bean4546
    (new
     com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest)]
   (clojure.core/when-let
    [v4548 (:vpn-connection-ids m4547)]
    (.
     bean4546
     setVpnConnectionIds
     (clojure.core/map
      (clojure.core/fn [arg4549] (clojure.core/str arg4549))
      v4548)))
   (clojure.core/when-let
    [v4548 (:filters m4547)]
    (.
     bean4546
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4550] (filter arg4550))
      v4548)))
   bean4546))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest describe-spot-price-history-request
  [m4552]
  (clojure.core/let
   [bean4551
    (new
     com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest)]
   (clojure.core/when-let
    [v4553 (:instance-types m4552)]
    (.
     bean4551
     setInstanceTypes
     (clojure.core/map
      (clojure.core/fn [arg4554] (clojure.core/str arg4554))
      v4553)))
   (clojure.core/when-let
    [v4553 (:product-descriptions m4552)]
    (.
     bean4551
     setProductDescriptions
     (clojure.core/map
      (clojure.core/fn [arg4555] (clojure.core/str arg4555))
      v4553)))
   (clojure.core/when-let
    [v4553 (:max-results m4552)]
    (. bean4551 setMaxResults (clojure.core/int v4553)))
   (clojure.core/when-let
    [v4553 (:next-token m4552)]
    (. bean4551 setNextToken (clojure.core/str v4553)))
   (clojure.core/when-let
    [v4553 (:filters m4552)]
    (.
     bean4551
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4556] (filter arg4556))
      v4553)))
   (clojure.core/when-let
    [v4553 (:availability-zone m4552)]
    (. bean4551 setAvailabilityZone (clojure.core/str v4553)))
   (clojure.core/when-let
    [v4553 (:start-time m4552)]
    (.
     bean4551
     setStartTime
     (com.palletops.awaze.common/to-date v4553)))
   (clojure.core/when-let
    [v4553 (:end-time m4552)]
    (. bean4551 setEndTime (com.palletops.awaze.common/to-date v4553)))
   bean4551))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteVpcRequest delete-vpc-request
  [m4558]
  (clojure.core/let
   [bean4557 (new com.amazonaws.services.ec2.model.DeleteVpcRequest)]
   (clojure.core/when-let
    [v4559 (:vpc-id m4558)]
    (. bean4557 setVpcId (clojure.core/str v4559)))
   bean4557))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateRouteTableRequest create-route-table-request
  [m4561]
  (clojure.core/let
   [bean4560
    (new com.amazonaws.services.ec2.model.CreateRouteTableRequest)]
   (clojure.core/when-let
    [v4562 (:vpc-id m4561)]
    (. bean4560 setVpcId (clojure.core/str v4562)))
   bean4560))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.TerminateInstancesRequest terminate-instances-request
  [m4564]
  (clojure.core/let
   [bean4563
    (new com.amazonaws.services.ec2.model.TerminateInstancesRequest)]
   (clojure.core/when-let
    [v4565 (:instance-ids m4564)]
    (.
     bean4563
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg4566] (clojure.core/str arg4566))
      v4565)))
   bean4563))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeBundleTasksRequest describe-bundle-tasks-request
  [m4568]
  (clojure.core/let
   [bean4567
    (new com.amazonaws.services.ec2.model.DescribeBundleTasksRequest)]
   (clojure.core/when-let
    [v4569 (:bundle-ids m4568)]
    (.
     bean4567
     setBundleIds
     (clojure.core/map
      (clojure.core/fn [arg4570] (clojure.core/str arg4570))
      v4569)))
   (clojure.core/when-let
    [v4569 (:filters m4568)]
    (.
     bean4567
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4571] (filter arg4571))
      v4569)))
   bean4567))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AssociateAddressRequest associate-address-request
  [m4573]
  (clojure.core/let
   [bean4572
    (new com.amazonaws.services.ec2.model.AssociateAddressRequest)]
   (clojure.core/when-let
    [v4574 (:private-ip-address m4573)]
    (. bean4572 setPrivateIpAddress (clojure.core/str v4574)))
   (clojure.core/when-let
    [v4574 (:public-ip m4573)]
    (. bean4572 setPublicIp (clojure.core/str v4574)))
   (clojure.core/when-let
    [v4574 (:allocation-id m4573)]
    (. bean4572 setAllocationId (clojure.core/str v4574)))
   (clojure.core/when-let
    [v4574 (:allow-reassociation m4573)]
    (. bean4572 setAllowReassociation (clojure.core/boolean v4574)))
   (clojure.core/when-let
    [v4574 (:instance-id m4573)]
    (. bean4572 setInstanceId (clojure.core/str v4574)))
   (clojure.core/when-let
    [v4574 (:network-interface-id m4573)]
    (. bean4572 setNetworkInterfaceId (clojure.core/str v4574)))
   bean4572))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateVolumeRequest create-volume-request
  [m4576]
  (clojure.core/let
   [bean4575
    (new com.amazonaws.services.ec2.model.CreateVolumeRequest)]
   (clojure.core/when-let
    [v4577 (:size m4576)]
    (. bean4575 setSize (clojure.core/int v4577)))
   (clojure.core/when-let
    [v4577 (:volume-type m4576)]
    (. bean4575 setVolumeType (volume-type v4577)))
   (clojure.core/when-let
    [v4577 (:volume-type m4576)]
    (. bean4575 setVolumeType (clojure.core/str v4577)))
   (clojure.core/when-let
    [v4577 (:snapshot-id m4576)]
    (. bean4575 setSnapshotId (clojure.core/str v4577)))
   (clojure.core/when-let
    [v4577 (:iops m4576)]
    (. bean4575 setIops (clojure.core/int v4577)))
   (clojure.core/when-let
    [v4577 (:availability-zone m4576)]
    (. bean4575 setAvailabilityZone (clojure.core/str v4577)))
   bean4575))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest modify-reserved-instances-request
  [m4579]
  (clojure.core/let
   [bean4578
    (new
     com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest)]
   (clojure.core/when-let
    [v4580 (:reserved-instances-ids m4579)]
    (.
     bean4578
     setReservedInstancesIds
     (clojure.core/map
      (clojure.core/fn [arg4581] (clojure.core/str arg4581))
      v4580)))
   (clojure.core/when-let
    [v4580 (:target-configurations m4579)]
    (.
     bean4578
     setTargetConfigurations
     (clojure.core/map
      (clojure.core/fn
       [arg4582]
       (reserved-instances-configuration arg4582))
      v4580)))
   (clojure.core/when-let
    [v4580 (:client-token m4579)]
    (. bean4578 setClientToken (clojure.core/str v4580)))
   bean4578))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest describe-vpc-attribute-request
  [m4584]
  (clojure.core/let
   [bean4583
    (new com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest)]
   (clojure.core/when-let
    [v4585 (:attribute m4584)]
    (. bean4583 setAttribute (clojure.core/str v4585)))
   (clojure.core/when-let
    [v4585 (:attribute m4584)]
    (. bean4583 setAttribute (vpc-attribute-name v4585)))
   (clojure.core/when-let
    [v4585 (:vpc-id m4584)]
    (. bean4583 setVpcId (clojure.core/str v4585)))
   bean4583))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest authorize-security-group-egress-request
  [m4587]
  (clojure.core/let
   [bean4586
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest)]
   (clojure.core/when-let
    [v4588 (:group-id m4587)]
    (. bean4586 setGroupId (clojure.core/str v4588)))
   (clojure.core/when-let
    [v4588 (:source-security-group-name m4587)]
    (. bean4586 setSourceSecurityGroupName (clojure.core/str v4588)))
   (clojure.core/when-let
    [v4588 (:source-security-group-owner-id m4587)]
    (.
     bean4586
     setSourceSecurityGroupOwnerId
     (clojure.core/str v4588)))
   (clojure.core/when-let
    [v4588 (:ip-protocol m4587)]
    (. bean4586 setIpProtocol (clojure.core/str v4588)))
   (clojure.core/when-let
    [v4588 (:from-port m4587)]
    (. bean4586 setFromPort (clojure.core/int v4588)))
   (clojure.core/when-let
    [v4588 (:to-port m4587)]
    (. bean4586 setToPort (clojure.core/int v4588)))
   (clojure.core/when-let
    [v4588 (:cidr-ip m4587)]
    (. bean4586 setCidrIp (clojure.core/str v4588)))
   (clojure.core/when-let
    [v4588 (:ip-permissions m4587)]
    (.
     bean4586
     setIpPermissions
     (clojure.core/map
      (clojure.core/fn [arg4589] (ip-permission arg4589))
      v4588)))
   bean4586))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest delete-customer-gateway-request
  [m4591]
  (clojure.core/let
   [bean4590
    (new
     com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest)]
   (clojure.core/when-let
    [v4592 (:customer-gateway-id m4591)]
    (. bean4590 setCustomerGatewayId (clojure.core/str v4592)))
   bean4590))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest replace-network-acl-entry-request
  [m4594]
  (clojure.core/let
   [bean4593
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest)]
   (clojure.core/when-let
    [v4595 (:network-acl-id m4594)]
    (. bean4593 setNetworkAclId (clojure.core/str v4595)))
   (clojure.core/when-let
    [v4595 (:rule-number m4594)]
    (. bean4593 setRuleNumber (clojure.core/int v4595)))
   (clojure.core/when-let
    [v4595 (:rule-action m4594)]
    (. bean4593 setRuleAction (rule-action v4595)))
   (clojure.core/when-let
    [v4595 (:rule-action m4594)]
    (. bean4593 setRuleAction (clojure.core/str v4595)))
   (clojure.core/when-let
    [v4595 (:egress m4594)]
    (. bean4593 setEgress (clojure.core/boolean v4595)))
   (clojure.core/when-let
    [v4595 (:cidr-block m4594)]
    (. bean4593 setCidrBlock (clojure.core/str v4595)))
   (clojure.core/when-let
    [v4595 (:icmp-type-code m4594)]
    (. bean4593 setIcmpTypeCode (icmp-type-code v4595)))
   (clojure.core/when-let
    [v4595 (:port-range m4594)]
    (. bean4593 setPortRange (port-range v4595)))
   (clojure.core/when-let
    [v4595 (:protocol m4594)]
    (. bean4593 setProtocol (clojure.core/str v4595)))
   bean4593))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeSubnetsRequest describe-subnets-request
  [m4597]
  (clojure.core/let
   [bean4596
    (new com.amazonaws.services.ec2.model.DescribeSubnetsRequest)]
   (clojure.core/when-let
    [v4598 (:filters m4597)]
    (.
     bean4596
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4599] (filter arg4599))
      v4598)))
   (clojure.core/when-let
    [v4598 (:subnet-ids m4597)]
    (.
     bean4596
     setSubnetIds
     (clojure.core/map
      (clojure.core/fn [arg4600] (clojure.core/str arg4600))
      v4598)))
   bean4596))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.GetConsoleOutputRequest get-console-output-request
  [m4602]
  (clojure.core/let
   [bean4601
    (new com.amazonaws.services.ec2.model.GetConsoleOutputRequest)]
   (clojure.core/when-let
    [v4603 (:instance-id m4602)]
    (. bean4601 setInstanceId (clojure.core/str v4603)))
   bean4601))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CancelConversionTaskRequest cancel-conversion-task-request
  [m4605]
  (clojure.core/let
   [bean4604
    (new com.amazonaws.services.ec2.model.CancelConversionTaskRequest)]
   (clojure.core/when-let
    [v4606 (:conversion-task-id m4605)]
    (. bean4604 setConversionTaskId (clojure.core/str v4606)))
   (clojure.core/when-let
    [v4606 (:reason-message m4605)]
    (. bean4604 setReasonMessage (clojure.core/str v4606)))
   bean4604))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AttachVpnGatewayRequest attach-vpn-gateway-request
  [m4608]
  (clojure.core/let
   [bean4607
    (new com.amazonaws.services.ec2.model.AttachVpnGatewayRequest)]
   (clojure.core/when-let
    [v4609 (:vpn-gateway-id m4608)]
    (. bean4607 setVpnGatewayId (clojure.core/str v4609)))
   (clojure.core/when-let
    [v4609 (:vpc-id m4608)]
    (. bean4607 setVpcId (clojure.core/str v4609)))
   bean4607))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest delete-vpn-connection-route-request
  [m4611]
  (clojure.core/let
   [bean4610
    (new
     com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest)]
   (clojure.core/when-let
    [v4612 (:destination-cidr-block m4611)]
    (. bean4610 setDestinationCidrBlock (clojure.core/str v4612)))
   (clojure.core/when-let
    [v4612 (:vpn-connection-id m4611)]
    (. bean4610 setVpnConnectionId (clojure.core/str v4612)))
   bean4610))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RunInstancesRequest run-instances-request
  [m4614]
  (clojure.core/let
   [bean4613
    (new com.amazonaws.services.ec2.model.RunInstancesRequest)]
   (clojure.core/when-let
    [v4615 (:network-interfaces m4614)]
    (.
     bean4613
     setNetworkInterfaces
     (clojure.core/map
      (clojure.core/fn
       [arg4616]
       (instance-network-interface-specification arg4616))
      v4615)))
   (clojure.core/when-let
    [v4615 (:subnet-id m4614)]
    (. bean4613 setSubnetId (clojure.core/str v4615)))
   (clojure.core/when-let
    [v4615 (:private-ip-address m4614)]
    (. bean4613 setPrivateIpAddress (clojure.core/str v4615)))
   (clojure.core/when-let
    [v4615 (:min-count m4614)]
    (. bean4613 setMinCount (clojure.core/int v4615)))
   (clojure.core/when-let
    [v4615 (:max-count m4614)]
    (. bean4613 setMaxCount (clojure.core/int v4615)))
   (clojure.core/when-let
    [v4615 (:security-group-ids m4614)]
    (.
     bean4613
     setSecurityGroupIds
     (clojure.core/map
      (clojure.core/fn [arg4617] (clojure.core/str arg4617))
      v4615)))
   (clojure.core/when-let
    [v4615 (:monitoring m4614)]
    (. bean4613 setMonitoring (clojure.core/boolean v4615)))
   (clojure.core/when-let
    [v4615 (:disable-api-termination m4614)]
    (. bean4613 setDisableApiTermination (clojure.core/boolean v4615)))
   (clojure.core/when-let
    [v4615 (:instance-initiated-shutdown-behavior m4614)]
    (.
     bean4613
     setInstanceInitiatedShutdownBehavior
     (shutdown-behavior v4615)))
   (clojure.core/when-let
    [v4615 (:instance-initiated-shutdown-behavior m4614)]
    (.
     bean4613
     setInstanceInitiatedShutdownBehavior
     (clojure.core/str v4615)))
   (clojure.core/when-let
    [v4615 (:license m4614)]
    (. bean4613 setLicense (instance-license-specification v4615)))
   (clojure.core/when-let
    [v4615 (:image-id m4614)]
    (. bean4613 setImageId (clojure.core/str v4615)))
   (clojure.core/when-let
    [v4615 (:key-name m4614)]
    (. bean4613 setKeyName (clojure.core/str v4615)))
   (clojure.core/when-let
    [v4615 (:security-groups m4614)]
    (.
     bean4613
     setSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg4618] (clojure.core/str arg4618))
      v4615)))
   (clojure.core/when-let
    [v4615 (:user-data m4614)]
    (. bean4613 setUserData (clojure.core/str v4615)))
   (clojure.core/when-let
    [v4615 (:instance-type m4614)]
    (. bean4613 setInstanceType (instance-type v4615)))
   (clojure.core/when-let
    [v4615 (:instance-type m4614)]
    (. bean4613 setInstanceType (clojure.core/str v4615)))
   (clojure.core/when-let
    [v4615 (:kernel-id m4614)]
    (. bean4613 setKernelId (clojure.core/str v4615)))
   (clojure.core/when-let
    [v4615 (:ramdisk-id m4614)]
    (. bean4613 setRamdiskId (clojure.core/str v4615)))
   (clojure.core/when-let
    [v4615 (:block-device-mappings m4614)]
    (.
     bean4613
     setBlockDeviceMappings
     (clojure.core/map
      (clojure.core/fn [arg4619] (block-device-mapping arg4619))
      v4615)))
   (clojure.core/when-let
    [v4615 (:iam-instance-profile m4614)]
    (.
     bean4613
     setIamInstanceProfile
     (iam-instance-profile-specification v4615)))
   (clojure.core/when-let
    [v4615 (:ebs-optimized m4614)]
    (. bean4613 setEbsOptimized (clojure.core/boolean v4615)))
   (clojure.core/when-let
    [v4615 (:additional-info m4614)]
    (. bean4613 setAdditionalInfo (clojure.core/str v4615)))
   (clojure.core/when-let
    [v4615 (:placement m4614)]
    (. bean4613 setPlacement (placement v4615)))
   (clojure.core/when-let
    [v4615 (:client-token m4614)]
    (. bean4613 setClientToken (clojure.core/str v4615)))
   bean4613))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RegisterImageRequest register-image-request
  [m4621]
  (clojure.core/let
   [bean4620
    (new com.amazonaws.services.ec2.model.RegisterImageRequest)]
   (clojure.core/when-let
    [v4622 (:name m4621)]
    (. bean4620 setName (clojure.core/str v4622)))
   (clojure.core/when-let
    [v4622 (:image-location m4621)]
    (. bean4620 setImageLocation (clojure.core/str v4622)))
   (clojure.core/when-let
    [v4622 (:architecture m4621)]
    (. bean4620 setArchitecture (architecture-values v4622)))
   (clojure.core/when-let
    [v4622 (:architecture m4621)]
    (. bean4620 setArchitecture (clojure.core/str v4622)))
   (clojure.core/when-let
    [v4622 (:root-device-name m4621)]
    (. bean4620 setRootDeviceName (clojure.core/str v4622)))
   (clojure.core/when-let
    [v4622 (:kernel-id m4621)]
    (. bean4620 setKernelId (clojure.core/str v4622)))
   (clojure.core/when-let
    [v4622 (:ramdisk-id m4621)]
    (. bean4620 setRamdiskId (clojure.core/str v4622)))
   (clojure.core/when-let
    [v4622 (:block-device-mappings m4621)]
    (.
     bean4620
     setBlockDeviceMappings
     (clojure.core/map
      (clojure.core/fn [arg4623] (block-device-mapping arg4623))
      v4622)))
   (clojure.core/when-let
    [v4622 (:description m4621)]
    (. bean4620 setDescription (clojure.core/str v4622)))
   bean4620))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeTagsRequest describe-tags-request
  [m4625]
  (clojure.core/let
   [bean4624
    (new com.amazonaws.services.ec2.model.DescribeTagsRequest)]
   (clojure.core/when-let
    [v4626 (:filters m4625)]
    (.
     bean4624
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4627] (filter arg4627))
      v4626)))
   bean4624))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest describe-reserved-instances-request
  [m4629]
  (clojure.core/let
   [bean4628
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest)]
   (clojure.core/when-let
    [v4630 (:reserved-instances-ids m4629)]
    (.
     bean4628
     setReservedInstancesIds
     (clojure.core/map
      (clojure.core/fn [arg4631] (clojure.core/str arg4631))
      v4630)))
   (clojure.core/when-let
    [v4630 (:filters m4629)]
    (.
     bean4628
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4632] (filter arg4632))
      v4630)))
   (clojure.core/when-let
    [v4630 (:offering-type m4629)]
    (. bean4628 setOfferingType (clojure.core/str v4630)))
   (clojure.core/when-let
    [v4630 (:offering-type m4629)]
    (. bean4628 setOfferingType (offering-type-values v4630)))
   bean4628))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DetachVpnGatewayRequest detach-vpn-gateway-request
  [m4634]
  (clojure.core/let
   [bean4633
    (new com.amazonaws.services.ec2.model.DetachVpnGatewayRequest)]
   (clojure.core/when-let
    [v4635 (:vpn-gateway-id m4634)]
    (. bean4633 setVpnGatewayId (clojure.core/str v4635)))
   (clojure.core/when-let
    [v4635 (:vpc-id m4634)]
    (. bean4633 setVpcId (clojure.core/str v4635)))
   bean4633))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest describe-customer-gateways-request
  [m4637]
  (clojure.core/let
   [bean4636
    (new
     com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest)]
   (clojure.core/when-let
    [v4638 (:customer-gateway-ids m4637)]
    (.
     bean4636
     setCustomerGatewayIds
     (clojure.core/map
      (clojure.core/fn [arg4639] (clojure.core/str arg4639))
      v4638)))
   (clojure.core/when-let
    [v4638 (:filters m4637)]
    (.
     bean4636
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4640] (filter arg4640))
      v4638)))
   bean4636))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest describe-network-interface-attribute-request
  [m4642]
  (clojure.core/let
   [bean4641
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest)]
   (clojure.core/when-let
    [v4643 (:attachment m4642)]
    (. bean4641 setAttachment (clojure.core/str v4643)))
   (clojure.core/when-let
    [v4643 (:groups m4642)]
    (. bean4641 setGroups (clojure.core/str v4643)))
   (clojure.core/when-let
    [v4643 (:source-dest-check m4642)]
    (. bean4641 setSourceDestCheck (clojure.core/str v4643)))
   (clojure.core/when-let
    [v4643 (:network-interface-id m4642)]
    (. bean4641 setNetworkInterfaceId (clojure.core/str v4643)))
   (clojure.core/when-let
    [v4643 (:description m4642)]
    (. bean4641 setDescription (clojure.core/str v4643)))
   bean4641))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ActivateLicenseRequest activate-license-request
  [m4645]
  (clojure.core/let
   [bean4644
    (new com.amazonaws.services.ec2.model.ActivateLicenseRequest)]
   (clojure.core/when-let
    [v4646 (:license-id m4645)]
    (. bean4644 setLicenseId (clojure.core/str v4646)))
   (clojure.core/when-let
    [v4646 (:capacity m4645)]
    (. bean4644 setCapacity (clojure.core/int v4646)))
   bean4644))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ImportKeyPairRequest import-key-pair-request
  [m4648]
  (clojure.core/let
   [bean4647
    (new com.amazonaws.services.ec2.model.ImportKeyPairRequest)]
   (clojure.core/when-let
    [v4649 (:public-key-material m4648)]
    (. bean4647 setPublicKeyMaterial (clojure.core/str v4649)))
   (clojure.core/when-let
    [v4649 (:key-name m4648)]
    (. bean4647 setKeyName (clojure.core/str v4649)))
   bean4647))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ImportInstanceRequest import-instance-request
  [m4651]
  (clojure.core/let
   [bean4650
    (new com.amazonaws.services.ec2.model.ImportInstanceRequest)]
   (clojure.core/when-let
    [v4652 (:platform m4651)]
    (. bean4650 setPlatform (clojure.core/str v4652)))
   (clojure.core/when-let
    [v4652 (:platform m4651)]
    (. bean4650 setPlatform (platform-values v4652)))
   (clojure.core/when-let
    [v4652 (:launch-specification m4651)]
    (.
     bean4650
     setLaunchSpecification
     (import-instance-launch-specification v4652)))
   (clojure.core/when-let
    [v4652 (:disk-images m4651)]
    (.
     bean4650
     setDiskImages
     (clojure.core/map
      (clojure.core/fn [arg4653] (disk-image arg4653))
      v4652)))
   (clojure.core/when-let
    [v4652 (:description m4651)]
    (. bean4650 setDescription (clojure.core/str v4652)))
   bean4650))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AllocateAddressRequest allocate-address-request
  [m4655]
  (clojure.core/let
   [bean4654
    (new com.amazonaws.services.ec2.model.AllocateAddressRequest)]
   (clojure.core/when-let
    [v4656 (:domain m4655)]
    (. bean4654 setDomain (clojure.core/str v4656)))
   (clojure.core/when-let
    [v4656 (:domain m4655)]
    (. bean4654 setDomain (domain-type v4656)))
   bean4654))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest describe-spot-instance-requests-request
  [m4658]
  (clojure.core/let
   [bean4657
    (new
     com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest)]
   (clojure.core/when-let
    [v4659 (:spot-instance-request-ids m4658)]
    (.
     bean4657
     setSpotInstanceRequestIds
     (clojure.core/map
      (clojure.core/fn [arg4660] (clojure.core/str arg4660))
      v4659)))
   (clojure.core/when-let
    [v4659 (:filters m4658)]
    (.
     bean4657
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4661] (filter arg4661))
      v4659)))
   bean4657))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest delete-spot-datafeed-subscription-request
  [m4663]
  (clojure.core/let
   [bean4662
    (new
     com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest)]
   bean4662))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeConversionTasksRequest describe-conversion-tasks-request
  [m4666]
  (clojure.core/let
   [bean4665
    (new
     com.amazonaws.services.ec2.model.DescribeConversionTasksRequest)]
   (clojure.core/when-let
    [v4667 (:conversion-task-ids m4666)]
    (.
     bean4665
     setConversionTaskIds
     (clojure.core/map
      (clojure.core/fn [arg4668] (clojure.core/str arg4668))
      v4667)))
   (clojure.core/when-let
    [v4667 (:filters m4666)]
    (.
     bean4665
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4669] (filter arg4669))
      v4667)))
   bean4665))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest replace-route-table-association-request
  [m4671]
  (clojure.core/let
   [bean4670
    (new
     com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest)]
   (clojure.core/when-let
    [v4672 (:route-table-id m4671)]
    (. bean4670 setRouteTableId (clojure.core/str v4672)))
   (clojure.core/when-let
    [v4672 (:association-id m4671)]
    (. bean4670 setAssociationId (clojure.core/str v4672)))
   bean4670))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteSubnetRequest delete-subnet-request
  [m4674]
  (clojure.core/let
   [bean4673
    (new com.amazonaws.services.ec2.model.DeleteSubnetRequest)]
   (clojure.core/when-let
    [v4675 (:subnet-id m4674)]
    (. bean4673 setSubnetId (clojure.core/str v4675)))
   bean4673))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest modify-vpc-attribute-request
  [m4677]
  (clojure.core/let
   [bean4676
    (new com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest)]
   (clojure.core/when-let
    [v4678 (:enable-dns-support m4677)]
    (. bean4676 setEnableDnsSupport (clojure.core/boolean v4678)))
   (clojure.core/when-let
    [v4678 (:enable-dns-hostnames m4677)]
    (. bean4676 setEnableDnsHostnames (clojure.core/boolean v4678)))
   (clojure.core/when-let
    [v4678 (:vpc-id m4677)]
    (. bean4676 setVpcId (clojure.core/str v4678)))
   bean4676))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DetachInternetGatewayRequest detach-internet-gateway-request
  [m4680]
  (clojure.core/let
   [bean4679
    (new
     com.amazonaws.services.ec2.model.DetachInternetGatewayRequest)]
   (clojure.core/when-let
    [v4681 (:internet-gateway-id m4680)]
    (. bean4679 setInternetGatewayId (clojure.core/str v4681)))
   (clojure.core/when-let
    [v4681 (:vpc-id m4680)]
    (. bean4679 setVpcId (clojure.core/str v4681)))
   bean4679))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest describe-reserved-instances-modifications-request
  [m4683]
  (clojure.core/let
   [bean4682
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest)]
   (clojure.core/when-let
    [v4684 (:reserved-instances-modification-ids m4683)]
    (.
     bean4682
     setReservedInstancesModificationIds
     (clojure.core/map
      (clojure.core/fn [arg4685] (clojure.core/str arg4685))
      v4684)))
   (clojure.core/when-let
    [v4684 (:next-token m4683)]
    (. bean4682 setNextToken (clojure.core/str v4684)))
   (clojure.core/when-let
    [v4684 (:filters m4683)]
    (.
     bean4682
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4686] (filter arg4686))
      v4684)))
   bean4682))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.GetPasswordDataRequest get-password-data-request
  [m4688]
  (clojure.core/let
   [bean4687
    (new com.amazonaws.services.ec2.model.GetPasswordDataRequest)]
   (clojure.core/when-let
    [v4689 (:instance-id m4688)]
    (. bean4687 setInstanceId (clojure.core/str v4689)))
   bean4687))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest unassign-private-ip-addresses-request
  [m4691]
  (clojure.core/let
   [bean4690
    (new
     com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest)]
   (clojure.core/when-let
    [v4692 (:private-ip-addresses m4691)]
    (.
     bean4690
     setPrivateIpAddresses
     (clojure.core/map
      (clojure.core/fn [arg4693] (clojure.core/str arg4693))
      v4692)))
   (clojure.core/when-let
    [v4692 (:network-interface-id m4691)]
    (. bean4690 setNetworkInterfaceId (clojure.core/str v4692)))
   bean4690))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest modify-network-interface-attribute-request
  [m4695]
  (clojure.core/let
   [bean4694
    (new
     com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest)]
   (clojure.core/when-let
    [v4696 (:attachment m4695)]
    (.
     bean4694
     setAttachment
     (network-interface-attachment-changes v4696)))
   (clojure.core/when-let
    [v4696 (:groups m4695)]
    (.
     bean4694
     setGroups
     (clojure.core/map
      (clojure.core/fn [arg4697] (clojure.core/str arg4697))
      v4696)))
   (clojure.core/when-let
    [v4696 (:source-dest-check m4695)]
    (. bean4694 setSourceDestCheck (clojure.core/boolean v4696)))
   (clojure.core/when-let
    [v4696 (:network-interface-id m4695)]
    (. bean4694 setNetworkInterfaceId (clojure.core/str v4696)))
   (clojure.core/when-let
    [v4696 (:description m4695)]
    (. bean4694 setDescription (clojure.core/str v4696)))
   bean4694))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest reset-network-interface-attribute-request
  [m4699]
  (clojure.core/let
   [bean4698
    (new
     com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest)]
   (clojure.core/when-let
    [v4700 (:source-dest-check m4699)]
    (. bean4698 setSourceDestCheck (clojure.core/str v4700)))
   (clojure.core/when-let
    [v4700 (:network-interface-id m4699)]
    (. bean4698 setNetworkInterfaceId (clojure.core/str v4700)))
   bean4698))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeVpcsRequest describe-vpcs-request
  [m4702]
  (clojure.core/let
   [bean4701
    (new com.amazonaws.services.ec2.model.DescribeVpcsRequest)]
   (clojure.core/when-let
    [v4703 (:vpc-ids m4702)]
    (.
     bean4701
     setVpcIds
     (clojure.core/map
      (clojure.core/fn [arg4704] (clojure.core/str arg4704))
      v4703)))
   (clojure.core/when-let
    [v4703 (:filters m4702)]
    (.
     bean4701
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4705] (filter arg4705))
      v4703)))
   bean4701))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RebootInstancesRequest reboot-instances-request
  [m4707]
  (clojure.core/let
   [bean4706
    (new com.amazonaws.services.ec2.model.RebootInstancesRequest)]
   (clojure.core/when-let
    [v4708 (:instance-ids m4707)]
    (.
     bean4706
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg4709] (clojure.core/str arg4709))
      v4708)))
   bean4706))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest describe-volume-attribute-request
  [m4711]
  (clojure.core/let
   [bean4710
    (new
     com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest)]
   (clojure.core/when-let
    [v4712 (:volume-id m4711)]
    (. bean4710 setVolumeId (clojure.core/str v4712)))
   (clojure.core/when-let
    [v4712 (:attribute m4711)]
    (. bean4710 setAttribute (clojure.core/str v4712)))
   (clojure.core/when-let
    [v4712 (:attribute m4711)]
    (. bean4710 setAttribute (volume-attribute-name v4712)))
   bean4710))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest modify-instance-attribute-request
  [m4714]
  (clojure.core/let
   [bean4713
    (new
     com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest)]
   (clojure.core/when-let
    [v4715 (:value m4714)]
    (. bean4713 setValue (clojure.core/str v4715)))
   (clojure.core/when-let
    [v4715 (:groups m4714)]
    (.
     bean4713
     setGroups
     (clojure.core/map
      (clojure.core/fn [arg4716] (clojure.core/str arg4716))
      v4715)))
   (clojure.core/when-let
    [v4715 (:disable-api-termination m4714)]
    (. bean4713 setDisableApiTermination (clojure.core/boolean v4715)))
   (clojure.core/when-let
    [v4715 (:instance-initiated-shutdown-behavior m4714)]
    (.
     bean4713
     setInstanceInitiatedShutdownBehavior
     (clojure.core/str v4715)))
   (clojure.core/when-let
    [v4715 (:source-dest-check m4714)]
    (. bean4713 setSourceDestCheck (clojure.core/boolean v4715)))
   (clojure.core/when-let
    [v4715 (:kernel m4714)]
    (. bean4713 setKernel (clojure.core/str v4715)))
   (clojure.core/when-let
    [v4715 (:ramdisk m4714)]
    (. bean4713 setRamdisk (clojure.core/str v4715)))
   (clojure.core/when-let
    [v4715 (:instance-id m4714)]
    (. bean4713 setInstanceId (clojure.core/str v4715)))
   (clojure.core/when-let
    [v4715 (:user-data m4714)]
    (. bean4713 setUserData (clojure.core/str v4715)))
   (clojure.core/when-let
    [v4715 (:instance-type m4714)]
    (. bean4713 setInstanceType (clojure.core/str v4715)))
   (clojure.core/when-let
    [v4715 (:block-device-mappings m4714)]
    (.
     bean4713
     setBlockDeviceMappings
     (clojure.core/map
      (clojure.core/fn
       [arg4717]
       (instance-block-device-mapping-specification arg4717))
      v4715)))
   (clojure.core/when-let
    [v4715 (:ebs-optimized m4714)]
    (. bean4713 setEbsOptimized (clojure.core/boolean v4715)))
   (clojure.core/when-let
    [v4715 (:attribute m4714)]
    (. bean4713 setAttribute (instance-attribute-name v4715)))
   (clojure.core/when-let
    [v4715 (:attribute m4714)]
    (. bean4713 setAttribute (clojure.core/str v4715)))
   bean4713))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteKeyPairRequest delete-key-pair-request
  [m4719]
  (clojure.core/let
   [bean4718
    (new com.amazonaws.services.ec2.model.DeleteKeyPairRequest)]
   (clojure.core/when-let
    [v4720 (:key-name m4719)]
    (. bean4718 setKeyName (clojure.core/str v4720)))
   bean4718))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest enable-vgw-route-propagation-request
  [m4722]
  (clojure.core/let
   [bean4721
    (new
     com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest)]
   (clojure.core/when-let
    [v4723 (:route-table-id m4722)]
    (. bean4721 setRouteTableId (clojure.core/str v4723)))
   (clojure.core/when-let
    [v4723 (:gateway-id m4722)]
    (. bean4721 setGatewayId (clojure.core/str v4723)))
   bean4721))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.BundleInstanceRequest bundle-instance-request
  [m4725]
  (clojure.core/let
   [bean4724
    (new com.amazonaws.services.ec2.model.BundleInstanceRequest)]
   (clojure.core/when-let
    [v4726 (:storage m4725)]
    (. bean4724 setStorage (storage v4726)))
   (clojure.core/when-let
    [v4726 (:instance-id m4725)]
    (. bean4724 setInstanceId (clojure.core/str v4726)))
   bean4724))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateInternetGatewayRequest create-internet-gateway-request
  [m4728]
  (clojure.core/let
   [bean4727
    (new
     com.amazonaws.services.ec2.model.CreateInternetGatewayRequest)]
   bean4727))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest describe-volume-status-request
  [m4731]
  (clojure.core/let
   [bean4730
    (new com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest)]
   (clojure.core/when-let
    [v4732 (:max-results m4731)]
    (. bean4730 setMaxResults (clojure.core/int v4732)))
   (clojure.core/when-let
    [v4732 (:volume-ids m4731)]
    (.
     bean4730
     setVolumeIds
     (clojure.core/map
      (clojure.core/fn [arg4733] (clojure.core/str arg4733))
      v4732)))
   (clojure.core/when-let
    [v4732 (:next-token m4731)]
    (. bean4730 setNextToken (clojure.core/str v4732)))
   (clojure.core/when-let
    [v4732 (:filters m4731)]
    (.
     bean4730
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4734] (filter arg4734))
      v4732)))
   bean4730))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CopyImageRequest copy-image-request
  [m4736]
  (clojure.core/let
   [bean4735 (new com.amazonaws.services.ec2.model.CopyImageRequest)]
   (clojure.core/when-let
    [v4737 (:name m4736)]
    (. bean4735 setName (clojure.core/str v4737)))
   (clojure.core/when-let
    [v4737 (:source-region m4736)]
    (. bean4735 setSourceRegion (clojure.core/str v4737)))
   (clojure.core/when-let
    [v4737 (:source-image-id m4736)]
    (. bean4735 setSourceImageId (clojure.core/str v4737)))
   (clojure.core/when-let
    [v4737 (:client-token m4736)]
    (. bean4735 setClientToken (clojure.core/str v4737)))
   (clojure.core/when-let
    [v4737 (:description m4736)]
    (. bean4735 setDescription (clojure.core/str v4737)))
   bean4735))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeKeyPairsRequest describe-key-pairs-request
  [m4739]
  (clojure.core/let
   [bean4738
    (new com.amazonaws.services.ec2.model.DescribeKeyPairsRequest)]
   (clojure.core/when-let
    [v4740 (:key-names m4739)]
    (.
     bean4738
     setKeyNames
     (clojure.core/map
      (clojure.core/fn [arg4741] (clojure.core/str arg4741))
      v4740)))
   (clojure.core/when-let
    [v4740 (:filters m4739)]
    (.
     bean4738
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4742] (filter arg4742))
      v4740)))
   bean4738))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest delete-network-acl-entry-request
  [m4744]
  (clojure.core/let
   [bean4743
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest)]
   (clojure.core/when-let
    [v4745 (:network-acl-id m4744)]
    (. bean4743 setNetworkAclId (clojure.core/str v4745)))
   (clojure.core/when-let
    [v4745 (:rule-number m4744)]
    (. bean4743 setRuleNumber (clojure.core/int v4745)))
   (clojure.core/when-let
    [v4745 (:egress m4744)]
    (. bean4743 setEgress (clojure.core/boolean v4745)))
   bean4743))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest purchase-reserved-instances-offering-request
  [m4747]
  (clojure.core/let
   [bean4746
    (new
     com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest)]
   (clojure.core/when-let
    [v4748 (:limit-price m4747)]
    (. bean4746 setLimitPrice (reserved-instance-limit-price v4748)))
   (clojure.core/when-let
    [v4748 (:reserved-instances-offering-id m4747)]
    (.
     bean4746
     setReservedInstancesOfferingId
     (clojure.core/str v4748)))
   (clojure.core/when-let
    [v4748 (:instance-count m4747)]
    (. bean4746 setInstanceCount (clojure.core/int v4748)))
   bean4746))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest cancel-reserved-instances-listing-request
  [m4750]
  (clojure.core/let
   [bean4749
    (new
     com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest)]
   (clojure.core/when-let
    [v4751 (:reserved-instances-listing-id m4750)]
    (.
     bean4749
     setReservedInstancesListingId
     (clojure.core/str v4751)))
   bean4749))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest revoke-security-group-egress-request
  [m4753]
  (clojure.core/let
   [bean4752
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest)]
   (clojure.core/when-let
    [v4754 (:group-id m4753)]
    (. bean4752 setGroupId (clojure.core/str v4754)))
   (clojure.core/when-let
    [v4754 (:source-security-group-name m4753)]
    (. bean4752 setSourceSecurityGroupName (clojure.core/str v4754)))
   (clojure.core/when-let
    [v4754 (:source-security-group-owner-id m4753)]
    (.
     bean4752
     setSourceSecurityGroupOwnerId
     (clojure.core/str v4754)))
   (clojure.core/when-let
    [v4754 (:ip-protocol m4753)]
    (. bean4752 setIpProtocol (clojure.core/str v4754)))
   (clojure.core/when-let
    [v4754 (:from-port m4753)]
    (. bean4752 setFromPort (clojure.core/int v4754)))
   (clojure.core/when-let
    [v4754 (:to-port m4753)]
    (. bean4752 setToPort (clojure.core/int v4754)))
   (clojure.core/when-let
    [v4754 (:cidr-ip m4753)]
    (. bean4752 setCidrIp (clojure.core/str v4754)))
   (clojure.core/when-let
    [v4754 (:ip-permissions m4753)]
    (.
     bean4752
     setIpPermissions
     (clojure.core/map
      (clojure.core/fn [arg4755] (ip-permission arg4755))
      v4754)))
   bean4752))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeactivateLicenseRequest deactivate-license-request
  [m4757]
  (clojure.core/let
   [bean4756
    (new com.amazonaws.services.ec2.model.DeactivateLicenseRequest)]
   (clojure.core/when-let
    [v4758 (:license-id m4757)]
    (. bean4756 setLicenseId (clojure.core/str v4758)))
   (clojure.core/when-let
    [v4758 (:capacity m4757)]
    (. bean4756 setCapacity (clojure.core/int v4758)))
   bean4756))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest create-spot-datafeed-subscription-request
  [m4760]
  (clojure.core/let
   [bean4759
    (new
     com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest)]
   (clojure.core/when-let
    [v4761 (:bucket m4760)]
    (. bean4759 setBucket (clojure.core/str v4761)))
   (clojure.core/when-let
    [v4761 (:prefix m4760)]
    (. bean4759 setPrefix (clojure.core/str v4761)))
   bean4759))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.EnableVolumeIORequest enable-volume-iorequest
  [m4763]
  (clojure.core/let
   [bean4762
    (new com.amazonaws.services.ec2.model.EnableVolumeIORequest)]
   (clojure.core/when-let
    [v4764 (:volume-id m4763)]
    (. bean4762 setVolumeId (clojure.core/str v4764)))
   bean4762))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest replace-network-acl-association-request
  [m4766]
  (clojure.core/let
   [bean4765
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest)]
   (clojure.core/when-let
    [v4767 (:association-id m4766)]
    (. bean4765 setAssociationId (clojure.core/str v4767)))
   (clojure.core/when-let
    [v4767 (:network-acl-id m4766)]
    (. bean4765 setNetworkAclId (clojure.core/str v4767)))
   bean4765))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CopySnapshotRequest copy-snapshot-request
  [m4769]
  (clojure.core/let
   [bean4768
    (new com.amazonaws.services.ec2.model.CopySnapshotRequest)]
   (clojure.core/when-let
    [v4770 (:source-region m4769)]
    (. bean4768 setSourceRegion (clojure.core/str v4770)))
   (clojure.core/when-let
    [v4770 (:source-snapshot-id m4769)]
    (. bean4768 setSourceSnapshotId (clojure.core/str v4770)))
   (clojure.core/when-let
    [v4770 (:description m4769)]
    (. bean4768 setDescription (clojure.core/str v4770)))
   bean4768))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest create-customer-gateway-request
  [m4772]
  (clojure.core/let
   [bean4771
    (new
     com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest)]
   (clojure.core/when-let
    [v4773 (:public-ip m4772)]
    (. bean4771 setPublicIp (clojure.core/str v4773)))
   (clojure.core/when-let
    [v4773 (:bgp-asn m4772)]
    (. bean4771 setBgpAsn (clojure.core/int v4773)))
   (clojure.core/when-let
    [v4773 (:type m4772)]
    (. bean4771 setType (gateway-type v4773)))
   (clojure.core/when-let
    [v4773 (:type m4772)]
    (. bean4771 setType (clojure.core/str v4773)))
   bean4771))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest describe-reserved-instances-offerings-request
  [m4775]
  (clojure.core/let
   [bean4774
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest)]
   (clojure.core/when-let
    [v4776 (:max-results m4775)]
    (. bean4774 setMaxResults (clojure.core/int v4776)))
   (clojure.core/when-let
    [v4776 (:instance-tenancy m4775)]
    (. bean4774 setInstanceTenancy (clojure.core/str v4776)))
   (clojure.core/when-let
    [v4776 (:instance-tenancy m4775)]
    (. bean4774 setInstanceTenancy (tenancy v4776)))
   (clojure.core/when-let
    [v4776 (:reserved-instances-offering-ids m4775)]
    (.
     bean4774
     setReservedInstancesOfferingIds
     (clojure.core/map
      (clojure.core/fn [arg4777] (clojure.core/str arg4777))
      v4776)))
   (clojure.core/when-let
    [v4776 (:include-marketplace m4775)]
    (. bean4774 setIncludeMarketplace (clojure.core/boolean v4776)))
   (clojure.core/when-let
    [v4776 (:min-duration m4775)]
    (. bean4774 setMinDuration (clojure.core/long v4776)))
   (clojure.core/when-let
    [v4776 (:max-duration m4775)]
    (. bean4774 setMaxDuration (clojure.core/long v4776)))
   (clojure.core/when-let
    [v4776 (:max-instance-count m4775)]
    (. bean4774 setMaxInstanceCount (clojure.core/int v4776)))
   (clojure.core/when-let
    [v4776 (:next-token m4775)]
    (. bean4774 setNextToken (clojure.core/str v4776)))
   (clojure.core/when-let
    [v4776 (:filters m4775)]
    (.
     bean4774
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4778] (filter arg4778))
      v4776)))
   (clojure.core/when-let
    [v4776 (:instance-type m4775)]
    (. bean4774 setInstanceType (clojure.core/str v4776)))
   (clojure.core/when-let
    [v4776 (:instance-type m4775)]
    (. bean4774 setInstanceType (instance-type v4776)))
   (clojure.core/when-let
    [v4776 (:product-description m4775)]
    (. bean4774 setProductDescription (riproduct-description v4776)))
   (clojure.core/when-let
    [v4776 (:product-description m4775)]
    (. bean4774 setProductDescription (clojure.core/str v4776)))
   (clojure.core/when-let
    [v4776 (:availability-zone m4775)]
    (. bean4774 setAvailabilityZone (clojure.core/str v4776)))
   (clojure.core/when-let
    [v4776 (:offering-type m4775)]
    (. bean4774 setOfferingType (clojure.core/str v4776)))
   (clojure.core/when-let
    [v4776 (:offering-type m4775)]
    (. bean4774 setOfferingType (offering-type-values v4776)))
   bean4774))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CancelBundleTaskRequest cancel-bundle-task-request
  [m4780]
  (clojure.core/let
   [bean4779
    (new com.amazonaws.services.ec2.model.CancelBundleTaskRequest)]
   (clojure.core/when-let
    [v4781 (:bundle-id m4780)]
    (. bean4779 setBundleId (clojure.core/str v4781)))
   bean4779))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeImagesRequest describe-images-request
  [m4783]
  (clojure.core/let
   [bean4782
    (new com.amazonaws.services.ec2.model.DescribeImagesRequest)]
   (clojure.core/when-let
    [v4784 (:image-ids m4783)]
    (.
     bean4782
     setImageIds
     (clojure.core/map
      (clojure.core/fn [arg4785] (clojure.core/str arg4785))
      v4784)))
   (clojure.core/when-let
    [v4784 (:owners m4783)]
    (.
     bean4782
     setOwners
     (clojure.core/map
      (clojure.core/fn [arg4786] (clojure.core/str arg4786))
      v4784)))
   (clojure.core/when-let
    [v4784 (:executable-users m4783)]
    (.
     bean4782
     setExecutableUsers
     (clojure.core/map
      (clojure.core/fn [arg4787] (clojure.core/str arg4787))
      v4784)))
   (clojure.core/when-let
    [v4784 (:filters m4783)]
    (.
     bean4782
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4788] (filter arg4788))
      v4784)))
   bean4782))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest describe-dhcp-options-request
  [m4790]
  (clojure.core/let
   [bean4789
    (new com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest)]
   (clojure.core/when-let
    [v4791 (:dhcp-options-ids m4790)]
    (.
     bean4789
     setDhcpOptionsIds
     (clojure.core/map
      (clojure.core/fn [arg4792] (clojure.core/str arg4792))
      v4791)))
   (clojure.core/when-let
    [v4791 (:filters m4790)]
    (.
     bean4789
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4793] (filter arg4793))
      v4791)))
   bean4789))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest delete-vpn-connection-request
  [m4795]
  (clojure.core/let
   [bean4794
    (new com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest)]
   (clojure.core/when-let
    [v4796 (:vpn-connection-id m4795)]
    (. bean4794 setVpnConnectionId (clojure.core/str v4796)))
   bean4794))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest create-vpn-connection-route-request
  [m4798]
  (clojure.core/let
   [bean4797
    (new
     com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest)]
   (clojure.core/when-let
    [v4799 (:destination-cidr-block m4798)]
    (. bean4797 setDestinationCidrBlock (clojure.core/str v4799)))
   (clojure.core/when-let
    [v4799 (:vpn-connection-id m4798)]
    (. bean4797 setVpnConnectionId (clojure.core/str v4799)))
   bean4797))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateKeyPairRequest create-key-pair-request
  [m4801]
  (clojure.core/let
   [bean4800
    (new com.amazonaws.services.ec2.model.CreateKeyPairRequest)]
   (clojure.core/when-let
    [v4802 (:key-name m4801)]
    (. bean4800 setKeyName (clojure.core/str v4802)))
   bean4800))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest describe-account-attributes-request
  [m4804]
  (clojure.core/let
   [bean4803
    (new
     com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest)]
   (clojure.core/when-let
    [v4805 (:attribute-names m4804)]
    (.
     bean4803
     setAttributeNames
     (clojure.core/map
      (clojure.core/fn [arg4806] (clojure.core/str arg4806))
      v4805)))
   bean4803))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest describe-spot-datafeed-subscription-request
  [m4808]
  (clojure.core/let
   [bean4807
    (new
     com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest)]
   bean4807))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest describe-internet-gateways-request
  [m4811]
  (clojure.core/let
   [bean4810
    (new
     com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest)]
   (clojure.core/when-let
    [v4812 (:internet-gateway-ids m4811)]
    (.
     bean4810
     setInternetGatewayIds
     (clojure.core/map
      (clojure.core/fn [arg4813] (clojure.core/str arg4813))
      v4812)))
   (clojure.core/when-let
    [v4812 (:filters m4811)]
    (.
     bean4810
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4814] (filter arg4814))
      v4812)))
   bean4810))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.StartInstancesRequest start-instances-request
  [m4816]
  (clojure.core/let
   [bean4815
    (new com.amazonaws.services.ec2.model.StartInstancesRequest)]
   (clojure.core/when-let
    [v4817 (:instance-ids m4816)]
    (.
     bean4815
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg4818] (clojure.core/str arg4818))
      v4817)))
   (clojure.core/when-let
    [v4817 (:additional-info m4816)]
    (. bean4815 setAdditionalInfo (clojure.core/str v4817)))
   bean4815))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest attach-network-interface-request
  [m4820]
  (clojure.core/let
   [bean4819
    (new
     com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v4821 (:device-index m4820)]
    (. bean4819 setDeviceIndex (clojure.core/int v4821)))
   (clojure.core/when-let
    [v4821 (:instance-id m4820)]
    (. bean4819 setInstanceId (clojure.core/str v4821)))
   (clojure.core/when-let
    [v4821 (:network-interface-id m4820)]
    (. bean4819 setNetworkInterfaceId (clojure.core/str v4821)))
   bean4819))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateRouteRequest create-route-request
  [m4823]
  (clojure.core/let
   [bean4822 (new com.amazonaws.services.ec2.model.CreateRouteRequest)]
   (clojure.core/when-let
    [v4824 (:route-table-id m4823)]
    (. bean4822 setRouteTableId (clojure.core/str v4824)))
   (clojure.core/when-let
    [v4824 (:destination-cidr-block m4823)]
    (. bean4822 setDestinationCidrBlock (clojure.core/str v4824)))
   (clojure.core/when-let
    [v4824 (:instance-id m4823)]
    (. bean4822 setInstanceId (clojure.core/str v4824)))
   (clojure.core/when-let
    [v4824 (:network-interface-id m4823)]
    (. bean4822 setNetworkInterfaceId (clojure.core/str v4824)))
   (clojure.core/when-let
    [v4824 (:gateway-id m4823)]
    (. bean4822 setGatewayId (clojure.core/str v4824)))
   bean4822))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.UnmonitorInstancesRequest unmonitor-instances-request
  [m4826]
  (clojure.core/let
   [bean4825
    (new com.amazonaws.services.ec2.model.UnmonitorInstancesRequest)]
   (clojure.core/when-let
    [v4827 (:instance-ids m4826)]
    (.
     bean4825
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg4828] (clojure.core/str arg4828))
      v4827)))
   bean4825))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest delete-network-interface-request
  [m4830]
  (clojure.core/let
   [bean4829
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v4831 (:network-interface-id m4830)]
    (. bean4829 setNetworkInterfaceId (clojure.core/str v4831)))
   bean4829))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.MonitorInstancesRequest monitor-instances-request
  [m4833]
  (clojure.core/let
   [bean4832
    (new com.amazonaws.services.ec2.model.MonitorInstancesRequest)]
   (clojure.core/when-let
    [v4834 (:instance-ids m4833)]
    (.
     bean4832
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg4835] (clojure.core/str arg4835))
      v4834)))
   bean4832))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest describe-reserved-instances-listings-request
  [m4837]
  (clojure.core/let
   [bean4836
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest)]
   (clojure.core/when-let
    [v4838 (:reserved-instances-id m4837)]
    (. bean4836 setReservedInstancesId (clojure.core/str v4838)))
   (clojure.core/when-let
    [v4838 (:reserved-instances-listing-id m4837)]
    (.
     bean4836
     setReservedInstancesListingId
     (clojure.core/str v4838)))
   (clojure.core/when-let
    [v4838 (:filters m4837)]
    (.
     bean4836
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4839] (filter arg4839))
      v4838)))
   bean4836))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateTagsRequest create-tags-request
  [m4841]
  (clojure.core/let
   [bean4840 (new com.amazonaws.services.ec2.model.CreateTagsRequest)]
   (clojure.core/when-let
    [v4842 (:resources m4841)]
    (.
     bean4840
     setResources
     (clojure.core/map
      (clojure.core/fn [arg4843] (clojure.core/str arg4843))
      v4842)))
   (clojure.core/when-let
    [v4842 (:tags m4841)]
    (.
     bean4840
     setTags
     (clojure.core/map
      (clojure.core/fn [arg4844] (tag arg4844))
      v4842)))
   bean4840))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest confirm-product-instance-request
  [m4846]
  (clojure.core/let
   [bean4845
    (new
     com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest)]
   (clojure.core/when-let
    [v4847 (:product-code m4846)]
    (. bean4845 setProductCode (clojure.core/str v4847)))
   (clojure.core/when-let
    [v4847 (:instance-id m4846)]
    (. bean4845 setInstanceId (clojure.core/str v4847)))
   bean4845))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DisassociateRouteTableRequest disassociate-route-table-request
  [m4849]
  (clojure.core/let
   [bean4848
    (new
     com.amazonaws.services.ec2.model.DisassociateRouteTableRequest)]
   (clojure.core/when-let
    [v4850 (:association-id m4849)]
    (. bean4848 setAssociationId (clojure.core/str v4850)))
   bean4848))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DisassociateAddressRequest disassociate-address-request
  [m4852]
  (clojure.core/let
   [bean4851
    (new com.amazonaws.services.ec2.model.DisassociateAddressRequest)]
   (clojure.core/when-let
    [v4853 (:public-ip m4852)]
    (. bean4851 setPublicIp (clojure.core/str v4853)))
   (clojure.core/when-let
    [v4853 (:association-id m4852)]
    (. bean4851 setAssociationId (clojure.core/str v4853)))
   bean4851))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest detach-network-interface-request
  [m4855]
  (clojure.core/let
   [bean4854
    (new
     com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v4856 (:force m4855)]
    (. bean4854 setForce (clojure.core/boolean v4856)))
   (clojure.core/when-let
    [v4856 (:attachment-id m4855)]
    (. bean4854 setAttachmentId (clojure.core/str v4856)))
   bean4854))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeExportTasksRequest describe-export-tasks-request
  [m4858]
  (clojure.core/let
   [bean4857
    (new com.amazonaws.services.ec2.model.DescribeExportTasksRequest)]
   (clojure.core/when-let
    [v4859 (:export-task-ids m4858)]
    (.
     bean4857
     setExportTaskIds
     (clojure.core/map
      (clojure.core/fn [arg4860] (clojure.core/str arg4860))
      v4859)))
   bean4857))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeAddressesRequest describe-addresses-request
  [m4862]
  (clojure.core/let
   [bean4861
    (new com.amazonaws.services.ec2.model.DescribeAddressesRequest)]
   (clojure.core/when-let
    [v4863 (:public-ips m4862)]
    (.
     bean4861
     setPublicIps
     (clojure.core/map
      (clojure.core/fn [arg4864] (clojure.core/str arg4864))
      v4863)))
   (clojure.core/when-let
    [v4863 (:allocation-ids m4862)]
    (.
     bean4861
     setAllocationIds
     (clojure.core/map
      (clojure.core/fn [arg4865] (clojure.core/str arg4865))
      v4863)))
   (clojure.core/when-let
    [v4863 (:filters m4862)]
    (.
     bean4861
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4866] (filter arg4866))
      v4863)))
   bean4861))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest create-instance-export-task-request
  [m4868]
  (clojure.core/let
   [bean4867
    (new
     com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest)]
   (clojure.core/when-let
    [v4869 (:target-environment m4868)]
    (. bean4867 setTargetEnvironment (clojure.core/str v4869)))
   (clojure.core/when-let
    [v4869 (:target-environment m4868)]
    (. bean4867 setTargetEnvironment (export-environment v4869)))
   (clojure.core/when-let
    [v4869 (:export-to-s3task m4868)]
    (.
     bean4867
     setExportToS3Task
     (export-to-s3task-specification v4869)))
   (clojure.core/when-let
    [v4869 (:instance-id m4868)]
    (. bean4867 setInstanceId (clojure.core/str v4869)))
   (clojure.core/when-let
    [v4869 (:description m4868)]
    (. bean4867 setDescription (clojure.core/str v4869)))
   bean4867))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateImageRequest create-image-request
  [m4871]
  (clojure.core/let
   [bean4870 (new com.amazonaws.services.ec2.model.CreateImageRequest)]
   (clojure.core/when-let
    [v4872 (:name m4871)]
    (. bean4870 setName (clojure.core/str v4872)))
   (clojure.core/when-let
    [v4872 (:no-reboot m4871)]
    (. bean4870 setNoReboot (clojure.core/boolean v4872)))
   (clojure.core/when-let
    [v4872 (:instance-id m4871)]
    (. bean4870 setInstanceId (clojure.core/str v4872)))
   (clojure.core/when-let
    [v4872 (:block-device-mappings m4871)]
    (.
     bean4870
     setBlockDeviceMappings
     (clojure.core/map
      (clojure.core/fn [arg4873] (block-device-mapping arg4873))
      v4872)))
   (clojure.core/when-let
    [v4872 (:description m4871)]
    (. bean4870 setDescription (clojure.core/str v4872)))
   bean4870))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateSecurityGroupRequest create-security-group-request
  [m4875]
  (clojure.core/let
   [bean4874
    (new com.amazonaws.services.ec2.model.CreateSecurityGroupRequest)]
   (clojure.core/when-let
    [v4876 (:group-name m4875)]
    (. bean4874 setGroupName (clojure.core/str v4876)))
   (clojure.core/when-let
    [v4876 (:vpc-id m4875)]
    (. bean4874 setVpcId (clojure.core/str v4876)))
   (clojure.core/when-let
    [v4876 (:description m4875)]
    (. bean4874 setDescription (clojure.core/str v4876)))
   bean4874))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateSubnetRequest create-subnet-request
  [m4878]
  (clojure.core/let
   [bean4877
    (new com.amazonaws.services.ec2.model.CreateSubnetRequest)]
   (clojure.core/when-let
    [v4879 (:cidr-block m4878)]
    (. bean4877 setCidrBlock (clojure.core/str v4879)))
   (clojure.core/when-let
    [v4879 (:availability-zone m4878)]
    (. bean4877 setAvailabilityZone (clojure.core/str v4879)))
   (clojure.core/when-let
    [v4879 (:vpc-id m4878)]
    (. bean4877 setVpcId (clojure.core/str v4879)))
   bean4877))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteNetworkAclRequest delete-network-acl-request
  [m4881]
  (clojure.core/let
   [bean4880
    (new com.amazonaws.services.ec2.model.DeleteNetworkAclRequest)]
   (clojure.core/when-let
    [v4882 (:network-acl-id m4881)]
    (. bean4880 setNetworkAclId (clojure.core/str v4882)))
   bean4880))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest create-network-interface-request
  [m4884]
  (clojure.core/let
   [bean4883
    (new
     com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v4885 (:subnet-id m4884)]
    (. bean4883 setSubnetId (clojure.core/str v4885)))
   (clojure.core/when-let
    [v4885 (:private-ip-address m4884)]
    (. bean4883 setPrivateIpAddress (clojure.core/str v4885)))
   (clojure.core/when-let
    [v4885 (:groups m4884)]
    (.
     bean4883
     setGroups
     (clojure.core/map
      (clojure.core/fn [arg4886] (clojure.core/str arg4886))
      v4885)))
   (clojure.core/when-let
    [v4885 (:private-ip-addresses m4884)]
    (.
     bean4883
     setPrivateIpAddresses
     (clojure.core/map
      (clojure.core/fn
       [arg4887]
       (private-ip-address-specification arg4887))
      v4885)))
   (clojure.core/when-let
    [v4885 (:secondary-private-ip-address-count m4884)]
    (.
     bean4883
     setSecondaryPrivateIpAddressCount
     (clojure.core/int v4885)))
   (clojure.core/when-let
    [v4885 (:description m4884)]
    (. bean4883 setDescription (clojure.core/str v4885)))
   bean4883))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest delete-vpn-gateway-request
  [m4889]
  (clojure.core/let
   [bean4888
    (new com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest)]
   (clojure.core/when-let
    [v4890 (:vpn-gateway-id m4889)]
    (. bean4888 setVpnGatewayId (clojure.core/str v4890)))
   bean4888))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AttachVolumeRequest attach-volume-request
  [m4892]
  (clojure.core/let
   [bean4891
    (new com.amazonaws.services.ec2.model.AttachVolumeRequest)]
   (clojure.core/when-let
    [v4893 (:volume-id m4892)]
    (. bean4891 setVolumeId (clojure.core/str v4893)))
   (clojure.core/when-let
    [v4893 (:device m4892)]
    (. bean4891 setDevice (clojure.core/str v4893)))
   (clojure.core/when-let
    [v4893 (:instance-id m4892)]
    (. bean4891 setInstanceId (clojure.core/str v4893)))
   bean4891))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateVpnConnectionRequest create-vpn-connection-request
  [m4895]
  (clojure.core/let
   [bean4894
    (new com.amazonaws.services.ec2.model.CreateVpnConnectionRequest)]
   (clojure.core/when-let
    [v4896 (:options m4895)]
    (.
     bean4894
     setOptions
     (vpn-connection-options-specification v4896)))
   (clojure.core/when-let
    [v4896 (:vpn-gateway-id m4895)]
    (. bean4894 setVpnGatewayId (clojure.core/str v4896)))
   (clojure.core/when-let
    [v4896 (:customer-gateway-id m4895)]
    (. bean4894 setCustomerGatewayId (clojure.core/str v4896)))
   (clojure.core/when-let
    [v4896 (:type m4895)]
    (. bean4894 setType (clojure.core/str v4896)))
   bean4894))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeletePlacementGroupRequest delete-placement-group-request
  [m4898]
  (clojure.core/let
   [bean4897
    (new com.amazonaws.services.ec2.model.DeletePlacementGroupRequest)]
   (clojure.core/when-let
    [v4899 (:group-name m4898)]
    (. bean4897 setGroupName (clojure.core/str v4899)))
   bean4897))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest reset-instance-attribute-request
  [m4901]
  (clojure.core/let
   [bean4900
    (new
     com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest)]
   (clojure.core/when-let
    [v4902 (:instance-id m4901)]
    (. bean4900 setInstanceId (clojure.core/str v4902)))
   (clojure.core/when-let
    [v4902 (:attribute m4901)]
    (. bean4900 setAttribute (clojure.core/str v4902)))
   (clojure.core/when-let
    [v4902 (:attribute m4901)]
    (. bean4900 setAttribute (instance-attribute-name v4902)))
   bean4900))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateSnapshotRequest create-snapshot-request
  [m4904]
  (clojure.core/let
   [bean4903
    (new com.amazonaws.services.ec2.model.CreateSnapshotRequest)]
   (clojure.core/when-let
    [v4905 (:volume-id m4904)]
    (. bean4903 setVolumeId (clojure.core/str v4905)))
   (clojure.core/when-let
    [v4905 (:description m4904)]
    (. bean4903 setDescription (clojure.core/str v4905)))
   bean4903))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RequestSpotInstancesRequest request-spot-instances-request
  [m4907]
  (clojure.core/let
   [bean4906
    (new com.amazonaws.services.ec2.model.RequestSpotInstancesRequest)]
   (clojure.core/when-let
    [v4908 (:launch-specification m4907)]
    (. bean4906 setLaunchSpecification (launch-specification v4908)))
   (clojure.core/when-let
    [v4908 (:valid-from m4907)]
    (.
     bean4906
     setValidFrom
     (com.palletops.awaze.common/to-date v4908)))
   (clojure.core/when-let
    [v4908 (:valid-until m4907)]
    (.
     bean4906
     setValidUntil
     (com.palletops.awaze.common/to-date v4908)))
   (clojure.core/when-let
    [v4908 (:launch-group m4907)]
    (. bean4906 setLaunchGroup (clojure.core/str v4908)))
   (clojure.core/when-let
    [v4908 (:availability-zone-group m4907)]
    (. bean4906 setAvailabilityZoneGroup (clojure.core/str v4908)))
   (clojure.core/when-let
    [v4908 (:spot-price m4907)]
    (. bean4906 setSpotPrice (clojure.core/str v4908)))
   (clojure.core/when-let
    [v4908 (:instance-count m4907)]
    (. bean4906 setInstanceCount (clojure.core/int v4908)))
   (clojure.core/when-let
    [v4908 (:type m4907)]
    (. bean4906 setType (clojure.core/str v4908)))
   (clojure.core/when-let
    [v4908 (:type m4907)]
    (. bean4906 setType (spot-instance-type v4908)))
   bean4906))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest describe-network-interfaces-request
  [m4910]
  (clojure.core/let
   [bean4909
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest)]
   (clojure.core/when-let
    [v4911 (:network-interface-ids m4910)]
    (.
     bean4909
     setNetworkInterfaceIds
     (clojure.core/map
      (clojure.core/fn [arg4912] (clojure.core/str arg4912))
      v4911)))
   (clojure.core/when-let
    [v4911 (:filters m4910)]
    (.
     bean4909
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4913] (filter arg4913))
      v4911)))
   bean4909))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteVolumeRequest delete-volume-request
  [m4915]
  (clojure.core/let
   [bean4914
    (new com.amazonaws.services.ec2.model.DeleteVolumeRequest)]
   (clojure.core/when-let
    [v4916 (:volume-id m4915)]
    (. bean4914 setVolumeId (clojure.core/str v4916)))
   bean4914))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteSnapshotRequest delete-snapshot-request
  [m4918]
  (clojure.core/let
   [bean4917
    (new com.amazonaws.services.ec2.model.DeleteSnapshotRequest)]
   (clojure.core/when-let
    [v4919 (:snapshot-id m4918)]
    (. bean4917 setSnapshotId (clojure.core/str v4919)))
   bean4917))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeInstancesRequest describe-instances-request
  [m4921]
  (clojure.core/let
   [bean4920
    (new com.amazonaws.services.ec2.model.DescribeInstancesRequest)]
   (clojure.core/when-let
    [v4922 (:filters m4921)]
    (.
     bean4920
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4923] (filter arg4923))
      v4922)))
   (clojure.core/when-let
    [v4922 (:instance-ids m4921)]
    (.
     bean4920
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg4924] (clojure.core/str arg4924))
      v4922)))
   bean4920))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AssociateRouteTableRequest associate-route-table-request
  [m4926]
  (clojure.core/let
   [bean4925
    (new com.amazonaws.services.ec2.model.AssociateRouteTableRequest)]
   (clojure.core/when-let
    [v4927 (:route-table-id m4926)]
    (. bean4925 setRouteTableId (clojure.core/str v4927)))
   (clojure.core/when-let
    [v4927 (:subnet-id m4926)]
    (. bean4925 setSubnetId (clojure.core/str v4927)))
   bean4925))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest disable-vgw-route-propagation-request
  [m4929]
  (clojure.core/let
   [bean4928
    (new
     com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest)]
   (clojure.core/when-let
    [v4930 (:route-table-id m4929)]
    (. bean4928 setRouteTableId (clojure.core/str v4930)))
   (clojure.core/when-let
    [v4930 (:gateway-id m4929)]
    (. bean4928 setGatewayId (clojure.core/str v4930)))
   bean4928))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest describe-instance-attribute-request
  [m4932]
  (clojure.core/let
   [bean4931
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest)]
   (clojure.core/when-let
    [v4933 (:instance-id m4932)]
    (. bean4931 setInstanceId (clojure.core/str v4933)))
   (clojure.core/when-let
    [v4933 (:attribute m4932)]
    (. bean4931 setAttribute (clojure.core/str v4933)))
   (clojure.core/when-let
    [v4933 (:attribute m4932)]
    (. bean4931 setAttribute (instance-attribute-name v4933)))
   bean4931))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateVpnGatewayRequest create-vpn-gateway-request
  [m4935]
  (clojure.core/let
   [bean4934
    (new com.amazonaws.services.ec2.model.CreateVpnGatewayRequest)]
   (clojure.core/when-let
    [v4936 (:availability-zone m4935)]
    (. bean4934 setAvailabilityZone (clojure.core/str v4936)))
   (clojure.core/when-let
    [v4936 (:type m4935)]
    (. bean4934 setType (clojure.core/str v4936)))
   (clojure.core/when-let
    [v4936 (:type m4935)]
    (. bean4934 setType (gateway-type v4936)))
   bean4934))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateNetworkAclRequest create-network-acl-request
  [m4938]
  (clojure.core/let
   [bean4937
    (new com.amazonaws.services.ec2.model.CreateNetworkAclRequest)]
   (clojure.core/when-let
    [v4939 (:vpc-id m4938)]
    (. bean4937 setVpcId (clojure.core/str v4939)))
   bean4937))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReplaceRouteRequest replace-route-request
  [m4941]
  (clojure.core/let
   [bean4940
    (new com.amazonaws.services.ec2.model.ReplaceRouteRequest)]
   (clojure.core/when-let
    [v4942 (:route-table-id m4941)]
    (. bean4940 setRouteTableId (clojure.core/str v4942)))
   (clojure.core/when-let
    [v4942 (:destination-cidr-block m4941)]
    (. bean4940 setDestinationCidrBlock (clojure.core/str v4942)))
   (clojure.core/when-let
    [v4942 (:instance-id m4941)]
    (. bean4940 setInstanceId (clojure.core/str v4942)))
   (clojure.core/when-let
    [v4942 (:network-interface-id m4941)]
    (. bean4940 setNetworkInterfaceId (clojure.core/str v4942)))
   (clojure.core/when-let
    [v4942 (:gateway-id m4941)]
    (. bean4940 setGatewayId (clojure.core/str v4942)))
   bean4940))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeRegionsRequest describe-regions-request
  [m4944]
  (clojure.core/let
   [bean4943
    (new com.amazonaws.services.ec2.model.DescribeRegionsRequest)]
   (clojure.core/when-let
    [v4945 (:region-names m4944)]
    (.
     bean4943
     setRegionNames
     (clojure.core/map
      (clojure.core/fn [arg4946] (clojure.core/str arg4946))
      v4945)))
   (clojure.core/when-let
    [v4945 (:filters m4944)]
    (.
     bean4943
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4947] (filter arg4947))
      v4945)))
   bean4943))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest delete-internet-gateway-request
  [m4949]
  (clojure.core/let
   [bean4948
    (new
     com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest)]
   (clojure.core/when-let
    [v4950 (:internet-gateway-id m4949)]
    (. bean4948 setInternetGatewayId (clojure.core/str v4950)))
   bean4948))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteRouteRequest delete-route-request
  [m4952]
  (clojure.core/let
   [bean4951 (new com.amazonaws.services.ec2.model.DeleteRouteRequest)]
   (clojure.core/when-let
    [v4953 (:route-table-id m4952)]
    (. bean4951 setRouteTableId (clojure.core/str v4953)))
   (clojure.core/when-let
    [v4953 (:destination-cidr-block m4952)]
    (. bean4951 setDestinationCidrBlock (clojure.core/str v4953)))
   bean4951))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest assign-private-ip-addresses-request
  [m4955]
  (clojure.core/let
   [bean4954
    (new
     com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest)]
   (clojure.core/when-let
    [v4956 (:private-ip-addresses m4955)]
    (.
     bean4954
     setPrivateIpAddresses
     (clojure.core/map
      (clojure.core/fn [arg4957] (clojure.core/str arg4957))
      v4956)))
   (clojure.core/when-let
    [v4956 (:secondary-private-ip-address-count m4955)]
    (.
     bean4954
     setSecondaryPrivateIpAddressCount
     (clojure.core/int v4956)))
   (clojure.core/when-let
    [v4956 (:allow-reassignment m4955)]
    (. bean4954 setAllowReassignment (clojure.core/boolean v4956)))
   (clojure.core/when-let
    [v4956 (:network-interface-id m4955)]
    (. bean4954 setNetworkInterfaceId (clojure.core/str v4956)))
   bean4954))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest delete-dhcp-options-request
  [m4959]
  (clojure.core/let
   [bean4958
    (new com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest)]
   (clojure.core/when-let
    [v4960 (:dhcp-options-id m4959)]
    (. bean4958 setDhcpOptionsId (clojure.core/str v4960)))
   bean4958))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest cancel-spot-instance-requests-request
  [m4962]
  (clojure.core/let
   [bean4961
    (new
     com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest)]
   (clojure.core/when-let
    [v4963 (:spot-instance-request-ids m4962)]
    (.
     bean4961
     setSpotInstanceRequestIds
     (clojure.core/map
      (clojure.core/fn [arg4964] (clojure.core/str arg4964))
      v4963)))
   bean4961))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest create-dhcp-options-request
  [m4966]
  (clojure.core/let
   [bean4965
    (new com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest)]
   (clojure.core/when-let
    [v4967 (:dhcp-configurations m4966)]
    (.
     bean4965
     setDhcpConfigurations
     (clojure.core/map
      (clojure.core/fn [arg4968] (dhcp-configuration arg4968))
      v4967)))
   bean4965))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.StopInstancesRequest stop-instances-request
  [m4970]
  (clojure.core/let
   [bean4969
    (new com.amazonaws.services.ec2.model.StopInstancesRequest)]
   (clojure.core/when-let
    [v4971 (:force m4970)]
    (. bean4969 setForce (clojure.core/boolean v4971)))
   (clojure.core/when-let
    [v4971 (:instance-ids m4970)]
    (.
     bean4969
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg4972] (clojure.core/str arg4972))
      v4971)))
   bean4969))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest authorize-security-group-ingress-request
  [m4974]
  (clojure.core/let
   [bean4973
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v4975 (:group-name m4974)]
    (. bean4973 setGroupName (clojure.core/str v4975)))
   (clojure.core/when-let
    [v4975 (:group-id m4974)]
    (. bean4973 setGroupId (clojure.core/str v4975)))
   (clojure.core/when-let
    [v4975 (:source-security-group-name m4974)]
    (. bean4973 setSourceSecurityGroupName (clojure.core/str v4975)))
   (clojure.core/when-let
    [v4975 (:source-security-group-owner-id m4974)]
    (.
     bean4973
     setSourceSecurityGroupOwnerId
     (clojure.core/str v4975)))
   (clojure.core/when-let
    [v4975 (:ip-protocol m4974)]
    (. bean4973 setIpProtocol (clojure.core/str v4975)))
   (clojure.core/when-let
    [v4975 (:from-port m4974)]
    (. bean4973 setFromPort (clojure.core/int v4975)))
   (clojure.core/when-let
    [v4975 (:to-port m4974)]
    (. bean4973 setToPort (clojure.core/int v4975)))
   (clojure.core/when-let
    [v4975 (:cidr-ip m4974)]
    (. bean4973 setCidrIp (clojure.core/str v4975)))
   (clojure.core/when-let
    [v4975 (:ip-permissions m4974)]
    (.
     bean4973
     setIpPermissions
     (clojure.core/map
      (clojure.core/fn [arg4976] (ip-permission arg4976))
      v4975)))
   bean4973))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest describe-placement-groups-request
  [m4978]
  (clojure.core/let
   [bean4977
    (new
     com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest)]
   (clojure.core/when-let
    [v4979 (:group-names m4978)]
    (.
     bean4977
     setGroupNames
     (clojure.core/map
      (clojure.core/fn [arg4980] (clojure.core/str arg4980))
      v4979)))
   (clojure.core/when-let
    [v4979 (:filters m4978)]
    (.
     bean4977
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg4981] (filter arg4981))
      v4979)))
   bean4977))
 (clojure.core/defmulti
  ec2
  (clojure.core/fn ec2 [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   ec2
   :describe-security-groups
   [m4982]
   (clojure.core/let
    [credentials4983 (:credentials m4982) args4984 (:args m4982)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client4985
      (com.palletops.awaze.common/aws-client :ec2 credentials4983)]
     (clojure.core/case
      (clojure.core/count args4984)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client4985
        describeSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client4985
        describeSecurityGroups
        (describe-security-groups-request
         (clojure.core/nth args4984 0))))))))
  (clojure.core/defn
   describe-security-groups-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         group-names
         group-ids
         filters
         dry-run-request]}]],
    :doc
    "Generate map for describeSecurityGroups, describeSecurityGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-security-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-security-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-security-groups
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         group-names
         group-ids
         filters
         dry-run-request]}]],
    :doc "Call describeSecurityGroups, describeSecurityGroups"}
   [credentials4987 & args4988]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client4989
     (com.palletops.awaze.common/aws-client :ec2 credentials4987)]
    (clojure.core/case
     (clojure.core/count args4988)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client4989
       describeSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client4989
       describeSecurityGroups
       (describe-security-groups-request
        (clojure.core/nth args4988 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc
   [m4990]
   (clojure.core/let
    [credentials4991 (:credentials m4990) args4992 (:args m4990)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client4993
      (com.palletops.awaze.common/aws-client :ec2 credentials4991)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client4993
       createVpc
       (create-vpc-request (clojure.core/nth args4992 0)))))))
  (clojure.core/defn
   create-vpc-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         instance-tenancy
         dry-run-request
         cidr-block]}]],
    :doc "Generate map for createVpc"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpc,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-vpc
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         instance-tenancy
         dry-run-request
         cidr-block]}]],
    :doc "Call createVpc"}
   [credentials4995 & args4996]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client4997
     (com.palletops.awaze.common/aws-client :ec2 credentials4995)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client4997
      createVpc
      (create-vpc-request (clojure.core/nth args4996 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :deregister-image
   [m4998]
   (clojure.core/let
    [credentials4999 (:credentials m4998) args5000 (:args m4998)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5001
      (com.palletops.awaze.common/aws-client :ec2 credentials4999)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5001
       deregisterImage
       (deregister-image-request (clojure.core/nth args5000 0)))))))
  (clojure.core/defn
   deregister-image-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector image-id dry-run-request]}]],
    :doc "Generate map for deregisterImage"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :deregister-image,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   deregister-image
   {:arglists
    '[[credentials
       {:keys [request-metric-collector image-id dry-run-request]}]],
    :doc "Call deregisterImage"}
   [credentials5003 & args5004]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5005
     (com.palletops.awaze.common/aws-client :ec2 credentials5003)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5005
      deregisterImage
      (deregister-image-request (clojure.core/nth args5004 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl-entry
   [m5006]
   (clojure.core/let
    [credentials5007 (:credentials m5006) args5008 (:args m5006)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5009
      (com.palletops.awaze.common/aws-client :ec2 credentials5007)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5009
       createNetworkAclEntry
       (create-network-acl-entry-request
        (clojure.core/nth args5008 0)))))))
  (clojure.core/defn
   create-network-acl-entry-map
   {:arglists
    '[[credentials
       {:keys
        [protocol
         dry-run-request
         request-metric-collector
         icmp-type-code
         network-acl-id
         rule-number
         cidr-block
         egress
         port-range
         rule-action]}]],
    :doc "Generate map for createNetworkAclEntry"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-network-acl-entry,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-network-acl-entry
   {:arglists
    '[[credentials
       {:keys
        [protocol
         dry-run-request
         request-metric-collector
         icmp-type-code
         network-acl-id
         rule-number
         cidr-block
         egress
         port-range
         rule-action]}]],
    :doc "Call createNetworkAclEntry"}
   [credentials5011 & args5012]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5013
     (com.palletops.awaze.common/aws-client :ec2 credentials5011)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5013
      createNetworkAclEntry
      (create-network-acl-entry-request
       (clojure.core/nth args5012 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-export-task
   [m5014]
   (clojure.core/let
    [credentials5015 (:credentials m5014) args5016 (:args m5014)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5017
      (com.palletops.awaze.common/aws-client :ec2 credentials5015)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5017
       cancelExportTask
       (cancel-export-task-request (clojure.core/nth args5016 0)))))))
  (clojure.core/defn
   cancel-export-task-map
   {:arglists
    '[[credentials {:keys [request-metric-collector export-task-id]}]],
    :doc "Generate map for cancelExportTask"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-export-task,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   cancel-export-task
   {:arglists
    '[[credentials {:keys [request-metric-collector export-task-id]}]],
    :doc "Call cancelExportTask"}
   [credentials5019 & args5020]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5021
     (com.palletops.awaze.common/aws-client :ec2 credentials5019)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5021
      cancelExportTask
      (cancel-export-task-request (clojure.core/nth args5020 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-ingress
   [m5022]
   (clojure.core/let
    [credentials5023 (:credentials m5022) args5024 (:args m5022)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5025
      (com.palletops.awaze.common/aws-client :ec2 credentials5023)]
     (clojure.core/case
      (clojure.core/count args5024)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5025
        revokeSecurityGroupIngress
        (revoke-security-group-ingress-request
         (clojure.core/nth args5024 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5025
        revokeSecurityGroupIngress))))))
  (clojure.core/defn
   revoke-security-group-ingress-map
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         source-security-group-name
         request-metric-collector
         group-id
         from-port
         ip-permissions
         to-port
         cidr-ip
         ip-protocol
         source-security-group-owner-id
         group-name]}]
      [credentials]],
    :doc
    "Generate map for revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :revoke-security-group-ingress,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :revoke-security-group-ingress,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   revoke-security-group-ingress
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         source-security-group-name
         request-metric-collector
         group-id
         from-port
         ip-permissions
         to-port
         cidr-ip
         ip-protocol
         source-security-group-owner-id
         group-name]}]
      [credentials]],
    :doc "Call revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   [credentials5027 & args5028]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5029
     (com.palletops.awaze.common/aws-client :ec2 credentials5027)]
    (clojure.core/case
     (clojure.core/count args5028)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5029
       revokeSecurityGroupIngress
       (revoke-security-group-ingress-request
        (clojure.core/nth args5028 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5029
       revokeSecurityGroupIngress))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-route-tables
   [m5030]
   (clojure.core/let
    [credentials5031 (:credentials m5030) args5032 (:args m5030)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5033
      (com.palletops.awaze.common/aws-client :ec2 credentials5031)]
     (clojure.core/case
      (clojure.core/count args5032)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5033
        describeRouteTables))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5033
        describeRouteTables
        (describe-route-tables-request
         (clojure.core/nth args5032 0))))))))
  (clojure.core/defn
   describe-route-tables-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [route-table-ids
         request-metric-collector
         filters
         dry-run-request]}]],
    :doc "Generate map for describeRouteTables, describeRouteTables"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-route-tables,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-route-tables,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-route-tables
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [route-table-ids
         request-metric-collector
         filters
         dry-run-request]}]],
    :doc "Call describeRouteTables, describeRouteTables"}
   [credentials5035 & args5036]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5037
     (com.palletops.awaze.common/aws-client :ec2 credentials5035)]
    (clojure.core/case
     (clojure.core/count args5036)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5037
       describeRouteTables))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5037
       describeRouteTables
       (describe-route-tables-request
        (clojure.core/nth args5036 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-reserved-instances-listing
   [m5038]
   (clojure.core/let
    [credentials5039 (:credentials m5038) args5040 (:args m5038)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5041
      (com.palletops.awaze.common/aws-client :ec2 credentials5039)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5041
       createReservedInstancesListing
       (create-reserved-instances-listing-request
        (clojure.core/nth args5040 0)))))))
  (clojure.core/defn
   create-reserved-instances-listing-map
   {:arglists
    '[[credentials
       {:keys
        [reserved-instances-id
         request-metric-collector
         price-schedules
         instance-count
         client-token]}]],
    :doc "Generate map for createReservedInstancesListing"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-reserved-instances-listing,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-reserved-instances-listing
   {:arglists
    '[[credentials
       {:keys
        [reserved-instances-id
         request-metric-collector
         price-schedules
         instance-count
         client-token]}]],
    :doc "Call createReservedInstancesListing"}
   [credentials5043 & args5044]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5045
     (com.palletops.awaze.common/aws-client :ec2 credentials5043)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5045
      createReservedInstancesListing
      (create-reserved-instances-listing-request
       (clojure.core/nth args5044 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-image-attribute
   [m5046]
   (clojure.core/let
    [credentials5047 (:credentials m5046) args5048 (:args m5046)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5049
      (com.palletops.awaze.common/aws-client :ec2 credentials5047)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5049
       resetImageAttribute
       (reset-image-attribute-request
        (clojure.core/nth args5048 0)))))))
  (clojure.core/defn
   reset-image-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         image-id
         dry-run-request
         attribute]}]],
    :doc "Generate map for resetImageAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-image-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   reset-image-attribute
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         image-id
         dry-run-request
         attribute]}]],
    :doc "Call resetImageAttribute"}
   [credentials5051 & args5052]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5053
     (com.palletops.awaze.common/aws-client :ec2 credentials5051)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5053
      resetImageAttribute
      (reset-image-attribute-request
       (clojure.core/nth args5052 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-availability-zones
   [m5054]
   (clojure.core/let
    [credentials5055 (:credentials m5054) args5056 (:args m5054)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5057
      (com.palletops.awaze.common/aws-client :ec2 credentials5055)]
     (clojure.core/case
      (clojure.core/count args5056)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5057
        describeAvailabilityZones))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5057
        describeAvailabilityZones
        (describe-availability-zones-request
         (clojure.core/nth args5056 0))))))))
  (clojure.core/defn
   describe-availability-zones-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [zone-names
         request-metric-collector
         filters
         dry-run-request]}]],
    :doc
    "Generate map for describeAvailabilityZones, describeAvailabilityZones"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-availability-zones,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-availability-zones,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-availability-zones
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [zone-names
         request-metric-collector
         filters
         dry-run-request]}]],
    :doc "Call describeAvailabilityZones, describeAvailabilityZones"}
   [credentials5059 & args5060]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5061
     (com.palletops.awaze.common/aws-client :ec2 credentials5059)]
    (clojure.core/case
     (clojure.core/count args5060)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5061
       describeAvailabilityZones))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5061
       describeAvailabilityZones
       (describe-availability-zones-request
        (clojure.core/nth args5060 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-acls
   [m5062]
   (clojure.core/let
    [credentials5063 (:credentials m5062) args5064 (:args m5062)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5065
      (com.palletops.awaze.common/aws-client :ec2 credentials5063)]
     (clojure.core/case
      (clojure.core/count args5064)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5065
        describeNetworkAcls))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5065
        describeNetworkAcls
        (describe-network-acls-request
         (clojure.core/nth args5064 0))))))))
  (clojure.core/defn
   describe-network-acls-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         network-acl-ids
         filters
         dry-run-request]}]],
    :doc "Generate map for describeNetworkAcls, describeNetworkAcls"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-network-acls,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-network-acls,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-network-acls
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         network-acl-ids
         filters
         dry-run-request]}]],
    :doc "Call describeNetworkAcls, describeNetworkAcls"}
   [credentials5067 & args5068]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5069
     (com.palletops.awaze.common/aws-client :ec2 credentials5067)]
    (clojure.core/case
     (clojure.core/count args5068)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5069
       describeNetworkAcls))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5069
       describeNetworkAcls
       (describe-network-acls-request
        (clojure.core/nth args5068 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-gateways
   [m5070]
   (clojure.core/let
    [credentials5071 (:credentials m5070) args5072 (:args m5070)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5073
      (com.palletops.awaze.common/aws-client :ec2 credentials5071)]
     (clojure.core/case
      (clojure.core/count args5072)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5073
        describeVpnGateways
        (describe-vpn-gateways-request (clojure.core/nth args5072 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5073
        describeVpnGateways))))))
  (clojure.core/defn
   describe-vpn-gateways-map
   {:arglists
    '[[credentials
       {:keys
        [vpn-gateway-ids
         request-metric-collector
         filters
         dry-run-request]}]
      [credentials]],
    :doc "Generate map for describeVpnGateways, describeVpnGateways"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpn-gateways,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpn-gateways,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-vpn-gateways
   {:arglists
    '[[credentials
       {:keys
        [vpn-gateway-ids
         request-metric-collector
         filters
         dry-run-request]}]
      [credentials]],
    :doc "Call describeVpnGateways, describeVpnGateways"}
   [credentials5075 & args5076]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5077
     (com.palletops.awaze.common/aws-client :ec2 credentials5075)]
    (clojure.core/case
     (clojure.core/count args5076)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5077
       describeVpnGateways
       (describe-vpn-gateways-request (clojure.core/nth args5076 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5077
       describeVpnGateways))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshots
   [m5078]
   (clojure.core/let
    [credentials5079 (:credentials m5078) args5080 (:args m5078)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5081
      (com.palletops.awaze.common/aws-client :ec2 credentials5079)]
     (clojure.core/case
      (clojure.core/count args5080)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5081
        describeSnapshots
        (describe-snapshots-request (clojure.core/nth args5080 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5081
        describeSnapshots))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists
    '[[credentials
       {:keys
        [snapshot-ids
         restorable-by-user-ids
         request-metric-collector
         owner-ids
         filters
         dry-run-request]}]
      [credentials]],
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-snapshots,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-snapshots,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-snapshots
   {:arglists
    '[[credentials
       {:keys
        [snapshot-ids
         restorable-by-user-ids
         request-metric-collector
         owner-ids
         filters
         dry-run-request]}]
      [credentials]],
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials5083 & args5084]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5085
     (com.palletops.awaze.common/aws-client :ec2 credentials5083)]
    (clojure.core/case
     (clojure.core/count args5084)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5085
       describeSnapshots
       (describe-snapshots-request (clojure.core/nth args5084 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5085
       describeSnapshots))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-image-attribute
   [m5086]
   (clojure.core/let
    [credentials5087 (:credentials m5086) args5088 (:args m5086)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5089
      (com.palletops.awaze.common/aws-client :ec2 credentials5087)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5089
       modifyImageAttribute
       (modify-image-attribute-request
        (clojure.core/nth args5088 0)))))))
  (clojure.core/defn
   modify-image-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [user-groups
         dry-run-request
         launch-permission
         request-metric-collector
         user-ids
         operation-type
         attribute
         image-id
         product-codes
         value
         description]}]],
    :doc "Generate map for modifyImageAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-image-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-image-attribute
   {:arglists
    '[[credentials
       {:keys
        [user-groups
         dry-run-request
         launch-permission
         request-metric-collector
         user-ids
         operation-type
         attribute
         image-id
         product-codes
         value
         description]}]],
    :doc "Call modifyImageAttribute"}
   [credentials5091 & args5092]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5093
     (com.palletops.awaze.common/aws-client :ec2 credentials5091)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5093
      modifyImageAttribute
      (modify-image-attribute-request
       (clojure.core/nth args5092 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volumes
   [m5094]
   (clojure.core/let
    [credentials5095 (:credentials m5094) args5096 (:args m5094)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5097
      (com.palletops.awaze.common/aws-client :ec2 credentials5095)]
     (clojure.core/case
      (clojure.core/count args5096)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5097
        describeVolumes))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5097
        describeVolumes
        (describe-volumes-request (clojure.core/nth args5096 0))))))))
  (clojure.core/defn
   describe-volumes-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [volume-ids
         request-metric-collector
         filters
         dry-run-request]}]],
    :doc "Generate map for describeVolumes, describeVolumes"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-volumes,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-volumes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-volumes
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [volume-ids
         request-metric-collector
         filters
         dry-run-request]}]],
    :doc "Call describeVolumes, describeVolumes"}
   [credentials5099 & args5100]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5101
     (com.palletops.awaze.common/aws-client :ec2 credentials5099)]
    (clojure.core/case
     (clojure.core/count args5100)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5101
       describeVolumes))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5101
       describeVolumes
       (describe-volumes-request (clojure.core/nth args5100 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-internet-gateway
   [m5102]
   (clojure.core/let
    [credentials5103 (:credentials m5102) args5104 (:args m5102)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5105
      (com.palletops.awaze.common/aws-client :ec2 credentials5103)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5105
       attachInternetGateway
       (attach-internet-gateway-request
        (clojure.core/nth args5104 0)))))))
  (clojure.core/defn
   attach-internet-gateway-map
   {:arglists
    '[[credentials
       {:keys
        [vpc-id
         request-metric-collector
         internet-gateway-id
         dry-run-request]}]],
    :doc "Generate map for attachInternetGateway"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-internet-gateway,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   attach-internet-gateway
   {:arglists
    '[[credentials
       {:keys
        [vpc-id
         request-metric-collector
         internet-gateway-id
         dry-run-request]}]],
    :doc "Call attachInternetGateway"}
   [credentials5107 & args5108]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5109
     (com.palletops.awaze.common/aws-client :ec2 credentials5107)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5109
      attachInternetGateway
      (attach-internet-gateway-request
       (clojure.core/nth args5108 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-licenses
   [m5110]
   (clojure.core/let
    [credentials5111 (:credentials m5110) args5112 (:args m5110)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5113
      (com.palletops.awaze.common/aws-client :ec2 credentials5111)]
     (clojure.core/case
      (clojure.core/count args5112)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5113
        describeLicenses))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5113
        describeLicenses
        (describe-licenses-request (clojure.core/nth args5112 0))))))))
  (clojure.core/defn
   describe-licenses-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         license-ids
         filters
         dry-run-request]}]],
    :doc "Generate map for describeLicenses, describeLicenses"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-licenses,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-licenses,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-licenses
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         license-ids
         filters
         dry-run-request]}]],
    :doc "Call describeLicenses, describeLicenses"}
   [credentials5115 & args5116]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5117
     (com.palletops.awaze.common/aws-client :ec2 credentials5115)]
    (clojure.core/case
     (clojure.core/count args5116)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5117
       describeLicenses))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5117
       describeLicenses
       (describe-licenses-request (clojure.core/nth args5116 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-security-group
   [m5118]
   (clojure.core/let
    [credentials5119 (:credentials m5118) args5120 (:args m5118)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5121
      (com.palletops.awaze.common/aws-client :ec2 credentials5119)]
     (clojure.core/case
      (clojure.core/count args5120)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5121
        deleteSecurityGroup))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5121
        deleteSecurityGroup
        (delete-security-group-request
         (clojure.core/nth args5120 0))))))))
  (clojure.core/defn
   delete-security-group-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         group-name
         group-id
         dry-run-request]}]],
    :doc "Generate map for deleteSecurityGroup, deleteSecurityGroup"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :delete-security-group,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-security-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-security-group
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         group-name
         group-id
         dry-run-request]}]],
    :doc "Call deleteSecurityGroup, deleteSecurityGroup"}
   [credentials5123 & args5124]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5125
     (com.palletops.awaze.common/aws-client :ec2 credentials5123)]
    (clojure.core/case
     (clojure.core/count args5124)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5125
       deleteSecurityGroup))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5125
       deleteSecurityGroup
       (delete-security-group-request
        (clojure.core/nth args5124 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-volume
   [m5126]
   (clojure.core/let
    [credentials5127 (:credentials m5126) args5128 (:args m5126)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5129
      (com.palletops.awaze.common/aws-client :ec2 credentials5127)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5129
       detachVolume
       (detach-volume-request (clojure.core/nth args5128 0)))))))
  (clojure.core/defn
   detach-volume-map
   {:arglists
    '[[credentials
       {:keys
        [volume-id
         request-metric-collector
         instance-id
         force
         dry-run-request
         device]}]],
    :doc "Generate map for detachVolume"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-volume,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   detach-volume
   {:arglists
    '[[credentials
       {:keys
        [volume-id
         request-metric-collector
         instance-id
         force
         dry-run-request
         device]}]],
    :doc "Call detachVolume"}
   [credentials5131 & args5132]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5133
     (com.palletops.awaze.common/aws-client :ec2 credentials5131)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5133
      detachVolume
      (detach-volume-request (clojure.core/nth args5132 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :release-address
   [m5134]
   (clojure.core/let
    [credentials5135 (:credentials m5134) args5136 (:args m5134)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5137
      (com.palletops.awaze.common/aws-client :ec2 credentials5135)]
     (clojure.core/case
      (clojure.core/count args5136)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5137
        releaseAddress
        (release-address-request (clojure.core/nth args5136 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5137
        releaseAddress))))))
  (clojure.core/defn
   release-address-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         public-ip
         dry-run-request
         allocation-id]}]
      [credentials]],
    :doc "Generate map for releaseAddress, releaseAddress"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :release-address,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :release-address,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   release-address
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         public-ip
         dry-run-request
         allocation-id]}]
      [credentials]],
    :doc "Call releaseAddress, releaseAddress"}
   [credentials5139 & args5140]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5141
     (com.palletops.awaze.common/aws-client :ec2 credentials5139)]
    (clojure.core/case
     (clojure.core/count args5140)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5141
       releaseAddress
       (release-address-request (clojure.core/nth args5140 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5141
       releaseAddress))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-volume
   [m5142]
   (clojure.core/let
    [credentials5143 (:credentials m5142) args5144 (:args m5142)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5145
      (com.palletops.awaze.common/aws-client :ec2 credentials5143)]
     (clojure.core/case
      (clojure.core/count args5144)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5145
        importVolume))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5145
        importVolume
        (import-volume-request (clojure.core/nth args5144 0))))))))
  (clojure.core/defn
   import-volume-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [volume
         request-metric-collector
         image
         dry-run-request
         description
         availability-zone]}]],
    :doc "Generate map for importVolume, importVolume"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :import-volume,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :import-volume,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   import-volume
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [volume
         request-metric-collector
         image
         dry-run-request
         description
         availability-zone]}]],
    :doc "Call importVolume, importVolume"}
   [credentials5147 & args5148]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5149
     (com.palletops.awaze.common/aws-client :ec2 credentials5147)]
    (clojure.core/case
     (clojure.core/count args5148)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5149
       importVolume))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5149
       importVolume
       (import-volume-request (clojure.core/nth args5148 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route-table
   [m5150]
   (clojure.core/let
    [credentials5151 (:credentials m5150) args5152 (:args m5150)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5153
      (com.palletops.awaze.common/aws-client :ec2 credentials5151)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5153
       deleteRouteTable
       (delete-route-table-request (clojure.core/nth args5152 0)))))))
  (clojure.core/defn
   delete-route-table-map
   {:arglists
    '[[credentials
       {:keys
        [route-table-id request-metric-collector dry-run-request]}]],
    :doc "Generate map for deleteRouteTable"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-route-table,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-route-table
   {:arglists
    '[[credentials
       {:keys
        [route-table-id request-metric-collector dry-run-request]}]],
    :doc "Call deleteRouteTable"}
   [credentials5155 & args5156]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5157
     (com.palletops.awaze.common/aws-client :ec2 credentials5155)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5157
      deleteRouteTable
      (delete-route-table-request (clojure.core/nth args5156 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshot-attribute
   [m5158]
   (clojure.core/let
    [credentials5159 (:credentials m5158) args5160 (:args m5158)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5161
      (com.palletops.awaze.common/aws-client :ec2 credentials5159)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5161
       describeSnapshotAttribute
       (describe-snapshot-attribute-request
        (clojure.core/nth args5160 0)))))))
  (clojure.core/defn
   describe-snapshot-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [snapshot-id
         request-metric-collector
         dry-run-request
         attribute]}]],
    :doc "Generate map for describeSnapshotAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-snapshot-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-snapshot-attribute
   {:arglists
    '[[credentials
       {:keys
        [snapshot-id
         request-metric-collector
         dry-run-request
         attribute]}]],
    :doc "Call describeSnapshotAttribute"}
   [credentials5163 & args5164]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5165
     (com.palletops.awaze.common/aws-client :ec2 credentials5163)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5165
      describeSnapshotAttribute
      (describe-snapshot-attribute-request
       (clojure.core/nth args5164 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-status
   [m5166]
   (clojure.core/let
    [credentials5167 (:credentials m5166) args5168 (:args m5166)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5169
      (com.palletops.awaze.common/aws-client :ec2 credentials5167)]
     (clojure.core/case
      (clojure.core/count args5168)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5169
        describeInstanceStatus
        (describe-instance-status-request
         (clojure.core/nth args5168 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5169
        describeInstanceStatus))))))
  (clojure.core/defn
   describe-instance-status-map
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         instance-ids
         next-token
         filters
         request-metric-collector
         include-all-instances
         max-results]}]
      [credentials]],
    :doc
    "Generate map for describeInstanceStatus, describeInstanceStatus"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-instance-status,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-instance-status,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-instance-status
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         instance-ids
         next-token
         filters
         request-metric-collector
         include-all-instances
         max-results]}]
      [credentials]],
    :doc "Call describeInstanceStatus, describeInstanceStatus"}
   [credentials5171 & args5172]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5173
     (com.palletops.awaze.common/aws-client :ec2 credentials5171)]
    (clojure.core/case
     (clojure.core/count args5172)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5173
       describeInstanceStatus
       (describe-instance-status-request
        (clojure.core/nth args5172 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5173
       describeInstanceStatus))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-image-attribute
   [m5174]
   (clojure.core/let
    [credentials5175 (:credentials m5174) args5176 (:args m5174)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5177
      (com.palletops.awaze.common/aws-client :ec2 credentials5175)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5177
       describeImageAttribute
       (describe-image-attribute-request
        (clojure.core/nth args5176 0)))))))
  (clojure.core/defn
   describe-image-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         image-id
         dry-run-request
         attribute]}]],
    :doc "Generate map for describeImageAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-image-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-image-attribute
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         image-id
         dry-run-request
         attribute]}]],
    :doc "Call describeImageAttribute"}
   [credentials5179 & args5180]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5181
     (com.palletops.awaze.common/aws-client :ec2 credentials5179)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5181
      describeImageAttribute
      (describe-image-attribute-request
       (clojure.core/nth args5180 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :report-instance-status
   [m5182]
   (clojure.core/let
    [credentials5183 (:credentials m5182) args5184 (:args m5182)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5185
      (com.palletops.awaze.common/aws-client :ec2 credentials5183)]
     (clojure.core/case
      (clojure.core/count args5184)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5185
        reportInstanceStatus
        (report-instance-status-request
         (clojure.core/nth args5184 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5185
        reportInstanceStatus))))))
  (clojure.core/defn
   report-instance-status-map
   {:arglists
    '[[credentials
       {:keys
        [end-time
         status
         dry-run-request
         request-metric-collector
         reason-codes
         start-time
         description
         instances]}]
      [credentials]],
    :doc "Generate map for reportInstanceStatus, reportInstanceStatus"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :report-instance-status,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :report-instance-status,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   report-instance-status
   {:arglists
    '[[credentials
       {:keys
        [end-time
         status
         dry-run-request
         request-metric-collector
         reason-codes
         start-time
         description
         instances]}]
      [credentials]],
    :doc "Call reportInstanceStatus, reportInstanceStatus"}
   [credentials5187 & args5188]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5189
     (com.palletops.awaze.common/aws-client :ec2 credentials5187)]
    (clojure.core/case
     (clojure.core/count args5188)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5189
       reportInstanceStatus
       (report-instance-status-request (clojure.core/nth args5188 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5189
       reportInstanceStatus))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-tags
   [m5190]
   (clojure.core/let
    [credentials5191 (:credentials m5190) args5192 (:args m5190)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5193
      (com.palletops.awaze.common/aws-client :ec2 credentials5191)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5193
       deleteTags
       (delete-tags-request (clojure.core/nth args5192 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists
    '[[credentials
       {:keys
        [tags resources request-metric-collector dry-run-request]}]],
    :doc "Generate map for deleteTags"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-tags,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-tags
   {:arglists
    '[[credentials
       {:keys
        [tags resources request-metric-collector dry-run-request]}]],
    :doc "Call deleteTags"}
   [credentials5195 & args5196]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5197
     (com.palletops.awaze.common/aws-client :ec2 credentials5195)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5197
      deleteTags
      (delete-tags-request (clojure.core/nth args5196 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-snapshot-attribute
   [m5198]
   (clojure.core/let
    [credentials5199 (:credentials m5198) args5200 (:args m5198)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5201
      (com.palletops.awaze.common/aws-client :ec2 credentials5199)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5201
       resetSnapshotAttribute
       (reset-snapshot-attribute-request
        (clojure.core/nth args5200 0)))))))
  (clojure.core/defn
   reset-snapshot-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [snapshot-id
         request-metric-collector
         dry-run-request
         attribute]}]],
    :doc "Generate map for resetSnapshotAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-snapshot-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   reset-snapshot-attribute
   {:arglists
    '[[credentials
       {:keys
        [snapshot-id
         request-metric-collector
         dry-run-request
         attribute]}]],
    :doc "Call resetSnapshotAttribute"}
   [credentials5203 & args5204]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5205
     (com.palletops.awaze.common/aws-client :ec2 credentials5203)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5205
      resetSnapshotAttribute
      (reset-snapshot-attribute-request
       (clojure.core/nth args5204 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-dhcp-options
   [m5206]
   (clojure.core/let
    [credentials5207 (:credentials m5206) args5208 (:args m5206)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5209
      (com.palletops.awaze.common/aws-client :ec2 credentials5207)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5209
       associateDhcpOptions
       (associate-dhcp-options-request
        (clojure.core/nth args5208 0)))))))
  (clojure.core/defn
   associate-dhcp-options-map
   {:arglists
    '[[credentials
       {:keys
        [vpc-id
         request-metric-collector
         dry-run-request
         dhcp-options-id]}]],
    :doc "Generate map for associateDhcpOptions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :associate-dhcp-options,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   associate-dhcp-options
   {:arglists
    '[[credentials
       {:keys
        [vpc-id
         request-metric-collector
         dry-run-request
         dhcp-options-id]}]],
    :doc "Call associateDhcpOptions"}
   [credentials5211 & args5212]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5213
     (com.palletops.awaze.common/aws-client :ec2 credentials5211)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5213
      associateDhcpOptions
      (associate-dhcp-options-request
       (clojure.core/nth args5212 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-snapshot-attribute
   [m5214]
   (clojure.core/let
    [credentials5215 (:credentials m5214) args5216 (:args m5214)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5217
      (com.palletops.awaze.common/aws-client :ec2 credentials5215)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5217
       modifySnapshotAttribute
       (modify-snapshot-attribute-request
        (clojure.core/nth args5216 0)))))))
  (clojure.core/defn
   modify-snapshot-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         request-metric-collector
         group-names
         snapshot-id
         user-ids
         operation-type
         attribute
         create-volume-permission]}]],
    :doc "Generate map for modifySnapshotAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-snapshot-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-snapshot-attribute
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         request-metric-collector
         group-names
         snapshot-id
         user-ids
         operation-type
         attribute
         create-volume-permission]}]],
    :doc "Call modifySnapshotAttribute"}
   [credentials5219 & args5220]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5221
     (com.palletops.awaze.common/aws-client :ec2 credentials5219)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5221
      modifySnapshotAttribute
      (modify-snapshot-attribute-request
       (clojure.core/nth args5220 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-volume-attribute
   [m5222]
   (clojure.core/let
    [credentials5223 (:credentials m5222) args5224 (:args m5222)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5225
      (com.palletops.awaze.common/aws-client :ec2 credentials5223)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5225
       modifyVolumeAttribute
       (modify-volume-attribute-request
        (clojure.core/nth args5224 0)))))))
  (clojure.core/defn
   modify-volume-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [volume-id
         request-metric-collector
         dry-run-request
         auto-enable-io]}]],
    :doc "Generate map for modifyVolumeAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-volume-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-volume-attribute
   {:arglists
    '[[credentials
       {:keys
        [volume-id
         request-metric-collector
         dry-run-request
         auto-enable-io]}]],
    :doc "Call modifyVolumeAttribute"}
   [credentials5227 & args5228]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5229
     (com.palletops.awaze.common/aws-client :ec2 credentials5227)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5229
      modifyVolumeAttribute
      (modify-volume-attribute-request
       (clojure.core/nth args5228 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-placement-group
   [m5230]
   (clojure.core/let
    [credentials5231 (:credentials m5230) args5232 (:args m5230)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5233
      (com.palletops.awaze.common/aws-client :ec2 credentials5231)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5233
       createPlacementGroup
       (create-placement-group-request
        (clojure.core/nth args5232 0)))))))
  (clojure.core/defn
   create-placement-group-map
   {:arglists
    '[[credentials
       {:keys
        [strategy
         request-metric-collector
         group-name
         dry-run-request]}]],
    :doc "Generate map for createPlacementGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-placement-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-placement-group
   {:arglists
    '[[credentials
       {:keys
        [strategy
         request-metric-collector
         group-name
         dry-run-request]}]],
    :doc "Call createPlacementGroup"}
   [credentials5235 & args5236]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5237
     (com.palletops.awaze.common/aws-client :ec2 credentials5235)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5237
      createPlacementGroup
      (create-placement-group-request
       (clojure.core/nth args5236 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-connections
   [m5238]
   (clojure.core/let
    [credentials5239 (:credentials m5238) args5240 (:args m5238)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5241
      (com.palletops.awaze.common/aws-client :ec2 credentials5239)]
     (clojure.core/case
      (clojure.core/count args5240)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5241
        describeVpnConnections
        (describe-vpn-connections-request
         (clojure.core/nth args5240 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5241
        describeVpnConnections))))))
  (clojure.core/defn
   describe-vpn-connections-map
   {:arglists
    '[[credentials
       {:keys
        [vpn-connection-ids
         request-metric-collector
         filters
         dry-run-request]}]
      [credentials]],
    :doc
    "Generate map for describeVpnConnections, describeVpnConnections"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpn-connections,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpn-connections,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-vpn-connections
   {:arglists
    '[[credentials
       {:keys
        [vpn-connection-ids
         request-metric-collector
         filters
         dry-run-request]}]
      [credentials]],
    :doc "Call describeVpnConnections, describeVpnConnections"}
   [credentials5243 & args5244]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5245
     (com.palletops.awaze.common/aws-client :ec2 credentials5243)]
    (clojure.core/case
     (clojure.core/count args5244)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5245
       describeVpnConnections
       (describe-vpn-connections-request
        (clojure.core/nth args5244 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5245
       describeVpnConnections))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-price-history
   [m5246]
   (clojure.core/let
    [credentials5247 (:credentials m5246) args5248 (:args m5246)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5249
      (com.palletops.awaze.common/aws-client :ec2 credentials5247)]
     (clojure.core/case
      (clojure.core/count args5248)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5249
        describeSpotPriceHistory))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5249
        describeSpotPriceHistory
        (describe-spot-price-history-request
         (clojure.core/nth args5248 0))))))))
  (clojure.core/defn
   describe-spot-price-history-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [end-time
         instance-types
         dry-run-request
         request-metric-collector
         product-descriptions
         filters
         availability-zone
         max-results
         start-time
         next-token]}]],
    :doc
    "Generate map for describeSpotPriceHistory, describeSpotPriceHistory"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-spot-price-history,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-spot-price-history,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-spot-price-history
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [end-time
         instance-types
         dry-run-request
         request-metric-collector
         product-descriptions
         filters
         availability-zone
         max-results
         start-time
         next-token]}]],
    :doc "Call describeSpotPriceHistory, describeSpotPriceHistory"}
   [credentials5251 & args5252]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5253
     (com.palletops.awaze.common/aws-client :ec2 credentials5251)]
    (clojure.core/case
     (clojure.core/count args5252)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5253
       describeSpotPriceHistory))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5253
       describeSpotPriceHistory
       (describe-spot-price-history-request
        (clojure.core/nth args5252 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc
   [m5254]
   (clojure.core/let
    [credentials5255 (:credentials m5254) args5256 (:args m5254)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5257
      (com.palletops.awaze.common/aws-client :ec2 credentials5255)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5257
       deleteVpc
       (delete-vpc-request (clojure.core/nth args5256 0)))))))
  (clojure.core/defn
   delete-vpc-map
   {:arglists
    '[[credentials
       {:keys [vpc-id request-metric-collector dry-run-request]}]],
    :doc "Generate map for deleteVpc"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpc,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-vpc
   {:arglists
    '[[credentials
       {:keys [vpc-id request-metric-collector dry-run-request]}]],
    :doc "Call deleteVpc"}
   [credentials5259 & args5260]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5261
     (com.palletops.awaze.common/aws-client :ec2 credentials5259)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5261
      deleteVpc
      (delete-vpc-request (clojure.core/nth args5260 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route-table
   [m5262]
   (clojure.core/let
    [credentials5263 (:credentials m5262) args5264 (:args m5262)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5265
      (com.palletops.awaze.common/aws-client :ec2 credentials5263)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5265
       createRouteTable
       (create-route-table-request (clojure.core/nth args5264 0)))))))
  (clojure.core/defn
   create-route-table-map
   {:arglists
    '[[credentials
       {:keys [vpc-id request-metric-collector dry-run-request]}]],
    :doc "Generate map for createRouteTable"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-route-table,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-route-table
   {:arglists
    '[[credentials
       {:keys [vpc-id request-metric-collector dry-run-request]}]],
    :doc "Call createRouteTable"}
   [credentials5267 & args5268]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5269
     (com.palletops.awaze.common/aws-client :ec2 credentials5267)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5269
      createRouteTable
      (create-route-table-request (clojure.core/nth args5268 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :terminate-instances
   [m5270]
   (clojure.core/let
    [credentials5271 (:credentials m5270) args5272 (:args m5270)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5273
      (com.palletops.awaze.common/aws-client :ec2 credentials5271)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5273
       terminateInstances
       (terminate-instances-request (clojure.core/nth args5272 0)))))))
  (clojure.core/defn
   terminate-instances-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector instance-ids dry-run-request]}]],
    :doc "Generate map for terminateInstances"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :terminate-instances,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   terminate-instances
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector instance-ids dry-run-request]}]],
    :doc "Call terminateInstances"}
   [credentials5275 & args5276]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5277
     (com.palletops.awaze.common/aws-client :ec2 credentials5275)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5277
      terminateInstances
      (terminate-instances-request (clojure.core/nth args5276 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-bundle-tasks
   [m5278]
   (clojure.core/let
    [credentials5279 (:credentials m5278) args5280 (:args m5278)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5281
      (com.palletops.awaze.common/aws-client :ec2 credentials5279)]
     (clojure.core/case
      (clojure.core/count args5280)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5281
        describeBundleTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5281
        describeBundleTasks
        (describe-bundle-tasks-request
         (clojure.core/nth args5280 0))))))))
  (clojure.core/defn
   describe-bundle-tasks-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         filters
         dry-run-request
         bundle-ids]}]],
    :doc "Generate map for describeBundleTasks, describeBundleTasks"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-bundle-tasks,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-bundle-tasks,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-bundle-tasks
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         filters
         dry-run-request
         bundle-ids]}]],
    :doc "Call describeBundleTasks, describeBundleTasks"}
   [credentials5283 & args5284]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5285
     (com.palletops.awaze.common/aws-client :ec2 credentials5283)]
    (clojure.core/case
     (clojure.core/count args5284)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5285
       describeBundleTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5285
       describeBundleTasks
       (describe-bundle-tasks-request
        (clojure.core/nth args5284 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-address
   [m5286]
   (clojure.core/let
    [credentials5287 (:credentials m5286) args5288 (:args m5286)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5289
      (com.palletops.awaze.common/aws-client :ec2 credentials5287)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5289
       associateAddress
       (associate-address-request (clojure.core/nth args5288 0)))))))
  (clojure.core/defn
   associate-address-map
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         request-metric-collector
         allocation-id
         public-ip
         private-ip-address
         allow-reassociation
         network-interface-id
         instance-id]}]],
    :doc "Generate map for associateAddress"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :associate-address,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   associate-address
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         request-metric-collector
         allocation-id
         public-ip
         private-ip-address
         allow-reassociation
         network-interface-id
         instance-id]}]],
    :doc "Call associateAddress"}
   [credentials5291 & args5292]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5293
     (com.palletops.awaze.common/aws-client :ec2 credentials5291)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5293
      associateAddress
      (associate-address-request (clojure.core/nth args5292 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-volume
   [m5294]
   (clojure.core/let
    [credentials5295 (:credentials m5294) args5296 (:args m5294)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5297
      (com.palletops.awaze.common/aws-client :ec2 credentials5295)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5297
       createVolume
       (create-volume-request (clojure.core/nth args5296 0)))))))
  (clojure.core/defn
   create-volume-map
   {:arglists
    '[[credentials
       {:keys
        [availability-zone
         volume-type
         size
         dry-run-request
         request-metric-collector
         iops
         snapshot-id]}]],
    :doc "Generate map for createVolume"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-volume,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-volume
   {:arglists
    '[[credentials
       {:keys
        [availability-zone
         volume-type
         size
         dry-run-request
         request-metric-collector
         iops
         snapshot-id]}]],
    :doc "Call createVolume"}
   [credentials5299 & args5300]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5301
     (com.palletops.awaze.common/aws-client :ec2 credentials5299)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5301
      createVolume
      (create-volume-request (clojure.core/nth args5300 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-reserved-instances
   [m5302]
   (clojure.core/let
    [credentials5303 (:credentials m5302) args5304 (:args m5302)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5305
      (com.palletops.awaze.common/aws-client :ec2 credentials5303)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5305
       modifyReservedInstances
       (modify-reserved-instances-request
        (clojure.core/nth args5304 0)))))))
  (clojure.core/defn
   modify-reserved-instances-map
   {:arglists
    '[[credentials
       {:keys
        [target-configurations
         reserved-instances-ids
         request-metric-collector
         client-token]}]],
    :doc "Generate map for modifyReservedInstances"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-reserved-instances,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-reserved-instances
   {:arglists
    '[[credentials
       {:keys
        [target-configurations
         reserved-instances-ids
         request-metric-collector
         client-token]}]],
    :doc "Call modifyReservedInstances"}
   [credentials5307 & args5308]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5309
     (com.palletops.awaze.common/aws-client :ec2 credentials5307)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5309
      modifyReservedInstances
      (modify-reserved-instances-request
       (clojure.core/nth args5308 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-attribute
   [m5310]
   (clojure.core/let
    [credentials5311 (:credentials m5310) args5312 (:args m5310)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5313
      (com.palletops.awaze.common/aws-client :ec2 credentials5311)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5313
       describeVpcAttribute
       (describe-vpc-attribute-request
        (clojure.core/nth args5312 0)))))))
  (clojure.core/defn
   describe-vpc-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [vpc-id request-metric-collector dry-run-request attribute]}]],
    :doc "Generate map for describeVpcAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpc-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-vpc-attribute
   {:arglists
    '[[credentials
       {:keys
        [vpc-id request-metric-collector dry-run-request attribute]}]],
    :doc "Call describeVpcAttribute"}
   [credentials5315 & args5316]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5317
     (com.palletops.awaze.common/aws-client :ec2 credentials5315)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5317
      describeVpcAttribute
      (describe-vpc-attribute-request
       (clojure.core/nth args5316 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-egress
   [m5318]
   (clojure.core/let
    [credentials5319 (:credentials m5318) args5320 (:args m5318)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5321
      (com.palletops.awaze.common/aws-client :ec2 credentials5319)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5321
       authorizeSecurityGroupEgress
       (authorize-security-group-egress-request
        (clojure.core/nth args5320 0)))))))
  (clojure.core/defn
   authorize-security-group-egress-map
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         source-security-group-name
         request-metric-collector
         group-id
         from-port
         ip-permissions
         to-port
         cidr-ip
         ip-protocol
         source-security-group-owner-id]}]],
    :doc "Generate map for authorizeSecurityGroupEgress"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :authorize-security-group-egress,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   authorize-security-group-egress
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         source-security-group-name
         request-metric-collector
         group-id
         from-port
         ip-permissions
         to-port
         cidr-ip
         ip-protocol
         source-security-group-owner-id]}]],
    :doc "Call authorizeSecurityGroupEgress"}
   [credentials5323 & args5324]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5325
     (com.palletops.awaze.common/aws-client :ec2 credentials5323)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5325
      authorizeSecurityGroupEgress
      (authorize-security-group-egress-request
       (clojure.core/nth args5324 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-customer-gateway
   [m5326]
   (clojure.core/let
    [credentials5327 (:credentials m5326) args5328 (:args m5326)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5329
      (com.palletops.awaze.common/aws-client :ec2 credentials5327)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5329
       deleteCustomerGateway
       (delete-customer-gateway-request
        (clojure.core/nth args5328 0)))))))
  (clojure.core/defn
   delete-customer-gateway-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         dry-run-request
         customer-gateway-id]}]],
    :doc "Generate map for deleteCustomerGateway"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-customer-gateway,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-customer-gateway
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         dry-run-request
         customer-gateway-id]}]],
    :doc "Call deleteCustomerGateway"}
   [credentials5331 & args5332]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5333
     (com.palletops.awaze.common/aws-client :ec2 credentials5331)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5333
      deleteCustomerGateway
      (delete-customer-gateway-request
       (clojure.core/nth args5332 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-entry
   [m5334]
   (clojure.core/let
    [credentials5335 (:credentials m5334) args5336 (:args m5334)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5337
      (com.palletops.awaze.common/aws-client :ec2 credentials5335)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5337
       replaceNetworkAclEntry
       (replace-network-acl-entry-request
        (clojure.core/nth args5336 0)))))))
  (clojure.core/defn
   replace-network-acl-entry-map
   {:arglists
    '[[credentials
       {:keys
        [protocol
         dry-run-request
         request-metric-collector
         icmp-type-code
         network-acl-id
         rule-number
         cidr-block
         egress
         port-range
         rule-action]}]],
    :doc "Generate map for replaceNetworkAclEntry"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-network-acl-entry,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   replace-network-acl-entry
   {:arglists
    '[[credentials
       {:keys
        [protocol
         dry-run-request
         request-metric-collector
         icmp-type-code
         network-acl-id
         rule-number
         cidr-block
         egress
         port-range
         rule-action]}]],
    :doc "Call replaceNetworkAclEntry"}
   [credentials5339 & args5340]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5341
     (com.palletops.awaze.common/aws-client :ec2 credentials5339)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5341
      replaceNetworkAclEntry
      (replace-network-acl-entry-request
       (clojure.core/nth args5340 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-subnets
   [m5342]
   (clojure.core/let
    [credentials5343 (:credentials m5342) args5344 (:args m5342)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5345
      (com.palletops.awaze.common/aws-client :ec2 credentials5343)]
     (clojure.core/case
      (clojure.core/count args5344)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5345
        describeSubnets))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5345
        describeSubnets
        (describe-subnets-request (clojure.core/nth args5344 0))))))))
  (clojure.core/defn
   describe-subnets-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [subnet-ids
         request-metric-collector
         filters
         dry-run-request]}]],
    :doc "Generate map for describeSubnets, describeSubnets"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-subnets,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-subnets,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-subnets
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [subnet-ids
         request-metric-collector
         filters
         dry-run-request]}]],
    :doc "Call describeSubnets, describeSubnets"}
   [credentials5347 & args5348]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5349
     (com.palletops.awaze.common/aws-client :ec2 credentials5347)]
    (clojure.core/case
     (clojure.core/count args5348)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5349
       describeSubnets))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5349
       describeSubnets
       (describe-subnets-request (clojure.core/nth args5348 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-console-output
   [m5350]
   (clojure.core/let
    [credentials5351 (:credentials m5350) args5352 (:args m5350)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5353
      (com.palletops.awaze.common/aws-client :ec2 credentials5351)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5353
       getConsoleOutput
       (get-console-output-request (clojure.core/nth args5352 0)))))))
  (clojure.core/defn
   get-console-output-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector instance-id dry-run-request]}]],
    :doc "Generate map for getConsoleOutput"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :get-console-output,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-console-output
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector instance-id dry-run-request]}]],
    :doc "Call getConsoleOutput"}
   [credentials5355 & args5356]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5357
     (com.palletops.awaze.common/aws-client :ec2 credentials5355)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5357
      getConsoleOutput
      (get-console-output-request (clojure.core/nth args5356 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-conversion-task
   [m5358]
   (clojure.core/let
    [credentials5359 (:credentials m5358) args5360 (:args m5358)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5361
      (com.palletops.awaze.common/aws-client :ec2 credentials5359)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5361
       cancelConversionTask
       (cancel-conversion-task-request
        (clojure.core/nth args5360 0)))))))
  (clojure.core/defn
   cancel-conversion-task-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         reason-message
         dry-run-request
         conversion-task-id]}]],
    :doc "Generate map for cancelConversionTask"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-conversion-task,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   cancel-conversion-task
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         reason-message
         dry-run-request
         conversion-task-id]}]],
    :doc "Call cancelConversionTask"}
   [credentials5363 & args5364]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5365
     (com.palletops.awaze.common/aws-client :ec2 credentials5363)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5365
      cancelConversionTask
      (cancel-conversion-task-request
       (clojure.core/nth args5364 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-vpn-gateway
   [m5366]
   (clojure.core/let
    [credentials5367 (:credentials m5366) args5368 (:args m5366)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5369
      (com.palletops.awaze.common/aws-client :ec2 credentials5367)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5369
       attachVpnGateway
       (attach-vpn-gateway-request (clojure.core/nth args5368 0)))))))
  (clojure.core/defn
   attach-vpn-gateway-map
   {:arglists
    '[[credentials
       {:keys
        [vpn-gateway-id
         vpc-id
         request-metric-collector
         dry-run-request]}]],
    :doc "Generate map for attachVpnGateway"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-vpn-gateway,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   attach-vpn-gateway
   {:arglists
    '[[credentials
       {:keys
        [vpn-gateway-id
         vpc-id
         request-metric-collector
         dry-run-request]}]],
    :doc "Call attachVpnGateway"}
   [credentials5371 & args5372]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5373
     (com.palletops.awaze.common/aws-client :ec2 credentials5371)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5373
      attachVpnGateway
      (attach-vpn-gateway-request (clojure.core/nth args5372 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection-route
   [m5374]
   (clojure.core/let
    [credentials5375 (:credentials m5374) args5376 (:args m5374)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5377
      (com.palletops.awaze.common/aws-client :ec2 credentials5375)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5377
       deleteVpnConnectionRoute
       (delete-vpn-connection-route-request
        (clojure.core/nth args5376 0)))))))
  (clojure.core/defn
   delete-vpn-connection-route-map
   {:arglists
    '[[credentials
       {:keys
        [vpn-connection-id
         request-metric-collector
         destination-cidr-block]}]],
    :doc "Generate map for deleteVpnConnectionRoute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpn-connection-route,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-vpn-connection-route
   {:arglists
    '[[credentials
       {:keys
        [vpn-connection-id
         request-metric-collector
         destination-cidr-block]}]],
    :doc "Call deleteVpnConnectionRoute"}
   [credentials5379 & args5380]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5381
     (com.palletops.awaze.common/aws-client :ec2 credentials5379)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5381
      deleteVpnConnectionRoute
      (delete-vpn-connection-route-request
       (clojure.core/nth args5380 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :run-instances
   [m5382]
   (clojure.core/let
    [credentials5383 (:credentials m5382) args5384 (:args m5382)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5385
      (com.palletops.awaze.common/aws-client :ec2 credentials5383)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5385
       runInstances
       (run-instances-request (clojure.core/nth args5384 0)))))))
  (clojure.core/defn
   run-instances-map
   {:arglists
    '[[credentials
       {:keys
        [instance-type
         license
         kernel-id
         dry-run-request
         request-metric-collector
         additional-info
         ebs-optimized
         subnet-id
         max-count
         block-device-mappings
         network-interfaces
         placement
         private-ip-address
         disable-api-termination
         user-data
         security-groups
         ramdisk-id
         iam-instance-profile
         min-count
         security-group-ids
         key-name
         client-token
         image-id
         monitoring
         instance-initiated-shutdown-behavior]}]],
    :doc "Generate map for runInstances"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :run-instances,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   run-instances
   {:arglists
    '[[credentials
       {:keys
        [instance-type
         license
         kernel-id
         dry-run-request
         request-metric-collector
         additional-info
         ebs-optimized
         subnet-id
         max-count
         block-device-mappings
         network-interfaces
         placement
         private-ip-address
         disable-api-termination
         user-data
         security-groups
         ramdisk-id
         iam-instance-profile
         min-count
         security-group-ids
         key-name
         client-token
         image-id
         monitoring
         instance-initiated-shutdown-behavior]}]],
    :doc "Call runInstances"}
   [credentials5387 & args5388]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5389
     (com.palletops.awaze.common/aws-client :ec2 credentials5387)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5389
      runInstances
      (run-instances-request (clojure.core/nth args5388 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :register-image
   [m5390]
   (clojure.core/let
    [credentials5391 (:credentials m5390) args5392 (:args m5390)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5393
      (com.palletops.awaze.common/aws-client :ec2 credentials5391)]
     (clojure.core/case
      (clojure.core/count args5392)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5393
        registerImage))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5393
        registerImage
        (register-image-request (clojure.core/nth args5392 0))))))))
  (clojure.core/defn
   register-image-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [kernel-id
         dry-run-request
         request-metric-collector
         name
         root-device-name
         block-device-mappings
         image-location
         ramdisk-id
         architecture
         description]}]],
    :doc "Generate map for registerImage, registerImage"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :register-image,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :register-image,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   register-image
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [kernel-id
         dry-run-request
         request-metric-collector
         name
         root-device-name
         block-device-mappings
         image-location
         ramdisk-id
         architecture
         description]}]],
    :doc "Call registerImage, registerImage"}
   [credentials5395 & args5396]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5397
     (com.palletops.awaze.common/aws-client :ec2 credentials5395)]
    (clojure.core/case
     (clojure.core/count args5396)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5397
       registerImage))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5397
       registerImage
       (register-image-request (clojure.core/nth args5396 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-tags
   [m5398]
   (clojure.core/let
    [credentials5399 (:credentials m5398) args5400 (:args m5398)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5401
      (com.palletops.awaze.common/aws-client :ec2 credentials5399)]
     (clojure.core/case
      (clojure.core/count args5400)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5401
        describeTags))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5401
        describeTags
        (describe-tags-request (clojure.core/nth args5400 0))))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys [request-metric-collector filters dry-run-request]}]],
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-tags,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-tags,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-tags
   {:arglists
    '[[credentials]
      [credentials
       {:keys [request-metric-collector filters dry-run-request]}]],
    :doc "Call describeTags, describeTags"}
   [credentials5403 & args5404]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5405
     (com.palletops.awaze.common/aws-client :ec2 credentials5403)]
    (clojure.core/case
     (clojure.core/count args5404)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5405
       describeTags))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5405
       describeTags
       (describe-tags-request (clojure.core/nth args5404 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances
   [m5406]
   (clojure.core/let
    [credentials5407 (:credentials m5406) args5408 (:args m5406)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5409
      (com.palletops.awaze.common/aws-client :ec2 credentials5407)]
     (clojure.core/case
      (clojure.core/count args5408)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5409
        describeReservedInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5409
        describeReservedInstances
        (describe-reserved-instances-request
         (clojure.core/nth args5408 0))))))))
  (clojure.core/defn
   describe-reserved-instances-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [reserved-instances-ids
         request-metric-collector
         offering-type
         filters
         dry-run-request]}]],
    :doc
    "Generate map for describeReservedInstances, describeReservedInstances"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-reserved-instances
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [reserved-instances-ids
         request-metric-collector
         offering-type
         filters
         dry-run-request]}]],
    :doc "Call describeReservedInstances, describeReservedInstances"}
   [credentials5411 & args5412]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5413
     (com.palletops.awaze.common/aws-client :ec2 credentials5411)]
    (clojure.core/case
     (clojure.core/count args5412)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5413
       describeReservedInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5413
       describeReservedInstances
       (describe-reserved-instances-request
        (clojure.core/nth args5412 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-vpn-gateway
   [m5414]
   (clojure.core/let
    [credentials5415 (:credentials m5414) args5416 (:args m5414)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5417
      (com.palletops.awaze.common/aws-client :ec2 credentials5415)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5417
       detachVpnGateway
       (detach-vpn-gateway-request (clojure.core/nth args5416 0)))))))
  (clojure.core/defn
   detach-vpn-gateway-map
   {:arglists
    '[[credentials
       {:keys
        [vpn-gateway-id
         vpc-id
         request-metric-collector
         dry-run-request]}]],
    :doc "Generate map for detachVpnGateway"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-vpn-gateway,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   detach-vpn-gateway
   {:arglists
    '[[credentials
       {:keys
        [vpn-gateway-id
         vpc-id
         request-metric-collector
         dry-run-request]}]],
    :doc "Call detachVpnGateway"}
   [credentials5419 & args5420]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5421
     (com.palletops.awaze.common/aws-client :ec2 credentials5419)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5421
      detachVpnGateway
      (detach-vpn-gateway-request (clojure.core/nth args5420 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-customer-gateways
   [m5422]
   (clojure.core/let
    [credentials5423 (:credentials m5422) args5424 (:args m5422)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5425
      (com.palletops.awaze.common/aws-client :ec2 credentials5423)]
     (clojure.core/case
      (clojure.core/count args5424)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5425
        describeCustomerGateways
        (describe-customer-gateways-request
         (clojure.core/nth args5424 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5425
        describeCustomerGateways))))))
  (clojure.core/defn
   describe-customer-gateways-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         filters
         dry-run-request
         customer-gateway-ids]}]
      [credentials]],
    :doc
    "Generate map for describeCustomerGateways, describeCustomerGateways"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-customer-gateways,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-customer-gateways,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-customer-gateways
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         filters
         dry-run-request
         customer-gateway-ids]}]
      [credentials]],
    :doc "Call describeCustomerGateways, describeCustomerGateways"}
   [credentials5427 & args5428]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5429
     (com.palletops.awaze.common/aws-client :ec2 credentials5427)]
    (clojure.core/case
     (clojure.core/count args5428)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5429
       describeCustomerGateways
       (describe-customer-gateways-request
        (clojure.core/nth args5428 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5429
       describeCustomerGateways))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interface-attribute
   [m5430]
   (clojure.core/let
    [credentials5431 (:credentials m5430) args5432 (:args m5430)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5433
      (com.palletops.awaze.common/aws-client :ec2 credentials5431)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5433
       describeNetworkInterfaceAttribute
       (describe-network-interface-attribute-request
        (clojure.core/nth args5432 0)))))))
  (clojure.core/defn
   describe-network-interface-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [description
         network-interface-id
         attachment
         groups
         dry-run-request
         request-metric-collector
         source-dest-check]}]],
    :doc "Generate map for describeNetworkInterfaceAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-network-interface-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-network-interface-attribute
   {:arglists
    '[[credentials
       {:keys
        [description
         network-interface-id
         attachment
         groups
         dry-run-request
         request-metric-collector
         source-dest-check]}]],
    :doc "Call describeNetworkInterfaceAttribute"}
   [credentials5435 & args5436]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5437
     (com.palletops.awaze.common/aws-client :ec2 credentials5435)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5437
      describeNetworkInterfaceAttribute
      (describe-network-interface-attribute-request
       (clojure.core/nth args5436 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :activate-license
   [m5438]
   (clojure.core/let
    [credentials5439 (:credentials m5438) args5440 (:args m5438)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5441
      (com.palletops.awaze.common/aws-client :ec2 credentials5439)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5441
       activateLicense
       (activate-license-request (clojure.core/nth args5440 0)))))))
  (clojure.core/defn
   activate-license-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         license-id
         dry-run-request
         capacity]}]],
    :doc "Generate map for activateLicense"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :activate-license,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   activate-license
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         license-id
         dry-run-request
         capacity]}]],
    :doc "Call activateLicense"}
   [credentials5443 & args5444]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5445
     (com.palletops.awaze.common/aws-client :ec2 credentials5443)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5445
      activateLicense
      (activate-license-request (clojure.core/nth args5444 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-key-pair
   [m5446]
   (clojure.core/let
    [credentials5447 (:credentials m5446) args5448 (:args m5446)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5449
      (com.palletops.awaze.common/aws-client :ec2 credentials5447)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5449
       importKeyPair
       (import-key-pair-request (clojure.core/nth args5448 0)))))))
  (clojure.core/defn
   import-key-pair-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         public-key-material
         key-name
         dry-run-request]}]],
    :doc "Generate map for importKeyPair"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :import-key-pair,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   import-key-pair
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         public-key-material
         key-name
         dry-run-request]}]],
    :doc "Call importKeyPair"}
   [credentials5451 & args5452]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5453
     (com.palletops.awaze.common/aws-client :ec2 credentials5451)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5453
      importKeyPair
      (import-key-pair-request (clojure.core/nth args5452 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-instance
   [m5454]
   (clojure.core/let
    [credentials5455 (:credentials m5454) args5456 (:args m5454)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5457
      (com.palletops.awaze.common/aws-client :ec2 credentials5455)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5457
       importInstance
       (import-instance-request (clojure.core/nth args5456 0)))))))
  (clojure.core/defn
   import-instance-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         platform
         launch-specification
         dry-run-request
         disk-images
         description]}]],
    :doc "Generate map for importInstance"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :import-instance,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   import-instance
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         platform
         launch-specification
         dry-run-request
         disk-images
         description]}]],
    :doc "Call importInstance"}
   [credentials5459 & args5460]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5461
     (com.palletops.awaze.common/aws-client :ec2 credentials5459)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5461
      importInstance
      (import-instance-request (clojure.core/nth args5460 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :allocate-address
   [m5462]
   (clojure.core/let
    [credentials5463 (:credentials m5462) args5464 (:args m5462)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5465
      (com.palletops.awaze.common/aws-client :ec2 credentials5463)]
     (clojure.core/case
      (clojure.core/count args5464)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5465
        allocateAddress
        (allocate-address-request (clojure.core/nth args5464 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5465
        allocateAddress))))))
  (clojure.core/defn
   allocate-address-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector dry-run-request domain]}]
      [credentials]],
    :doc "Generate map for allocateAddress, allocateAddress"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :allocate-address,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :allocate-address,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   allocate-address
   {:arglists
    '[[credentials
       {:keys [request-metric-collector dry-run-request domain]}]
      [credentials]],
    :doc "Call allocateAddress, allocateAddress"}
   [credentials5467 & args5468]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5469
     (com.palletops.awaze.common/aws-client :ec2 credentials5467)]
    (clojure.core/case
     (clojure.core/count args5468)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5469
       allocateAddress
       (allocate-address-request (clojure.core/nth args5468 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5469
       allocateAddress))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-instance-requests
   [m5470]
   (clojure.core/let
    [credentials5471 (:credentials m5470) args5472 (:args m5470)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5473
      (com.palletops.awaze.common/aws-client :ec2 credentials5471)]
     (clojure.core/case
      (clojure.core/count args5472)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5473
        describeSpotInstanceRequests))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5473
        describeSpotInstanceRequests
        (describe-spot-instance-requests-request
         (clojure.core/nth args5472 0))))))))
  (clojure.core/defn
   describe-spot-instance-requests-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [spot-instance-request-ids
         request-metric-collector
         filters
         dry-run-request]}]],
    :doc
    "Generate map for describeSpotInstanceRequests, describeSpotInstanceRequests"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-spot-instance-requests,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-spot-instance-requests,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-spot-instance-requests
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [spot-instance-request-ids
         request-metric-collector
         filters
         dry-run-request]}]],
    :doc
    "Call describeSpotInstanceRequests, describeSpotInstanceRequests"}
   [credentials5475 & args5476]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5477
     (com.palletops.awaze.common/aws-client :ec2 credentials5475)]
    (clojure.core/case
     (clojure.core/count args5476)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5477
       describeSpotInstanceRequests))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5477
       describeSpotInstanceRequests
       (describe-spot-instance-requests-request
        (clojure.core/nth args5476 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-spot-datafeed-subscription
   [m5478]
   (clojure.core/let
    [credentials5479 (:credentials m5478) args5480 (:args m5478)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5481
      (com.palletops.awaze.common/aws-client :ec2 credentials5479)]
     (clojure.core/case
      (clojure.core/count args5480)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5481
        deleteSpotDatafeedSubscription
        (delete-spot-datafeed-subscription-request
         (clojure.core/nth args5480 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5481
        deleteSpotDatafeedSubscription))))))
  (clojure.core/defn
   delete-spot-datafeed-subscription-map
   {:arglists
    '[[credentials {:keys [request-metric-collector dry-run-request]}]
      [credentials]],
    :doc
    "Generate map for deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-spot-datafeed-subscription
   {:arglists
    '[[credentials {:keys [request-metric-collector dry-run-request]}]
      [credentials]],
    :doc
    "Call deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   [credentials5483 & args5484]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5485
     (com.palletops.awaze.common/aws-client :ec2 credentials5483)]
    (clojure.core/case
     (clojure.core/count args5484)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5485
       deleteSpotDatafeedSubscription
       (delete-spot-datafeed-subscription-request
        (clojure.core/nth args5484 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5485
       deleteSpotDatafeedSubscription))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-conversion-tasks
   [m5486]
   (clojure.core/let
    [credentials5487 (:credentials m5486) args5488 (:args m5486)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5489
      (com.palletops.awaze.common/aws-client :ec2 credentials5487)]
     (clojure.core/case
      (clojure.core/count args5488)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5489
        describeConversionTasks
        (describe-conversion-tasks-request
         (clojure.core/nth args5488 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5489
        describeConversionTasks))))))
  (clojure.core/defn
   describe-conversion-tasks-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         filters
         dry-run-request
         conversion-task-ids]}]
      [credentials]],
    :doc
    "Generate map for describeConversionTasks, describeConversionTasks"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-conversion-tasks,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-conversion-tasks,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-conversion-tasks
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         filters
         dry-run-request
         conversion-task-ids]}]
      [credentials]],
    :doc "Call describeConversionTasks, describeConversionTasks"}
   [credentials5491 & args5492]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5493
     (com.palletops.awaze.common/aws-client :ec2 credentials5491)]
    (clojure.core/case
     (clojure.core/count args5492)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5493
       describeConversionTasks
       (describe-conversion-tasks-request
        (clojure.core/nth args5492 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5493
       describeConversionTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route-table-association
   [m5494]
   (clojure.core/let
    [credentials5495 (:credentials m5494) args5496 (:args m5494)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5497
      (com.palletops.awaze.common/aws-client :ec2 credentials5495)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5497
       replaceRouteTableAssociation
       (replace-route-table-association-request
        (clojure.core/nth args5496 0)))))))
  (clojure.core/defn
   replace-route-table-association-map
   {:arglists
    '[[credentials
       {:keys
        [route-table-id
         request-metric-collector
         dry-run-request
         association-id]}]],
    :doc "Generate map for replaceRouteTableAssociation"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-route-table-association,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   replace-route-table-association
   {:arglists
    '[[credentials
       {:keys
        [route-table-id
         request-metric-collector
         dry-run-request
         association-id]}]],
    :doc "Call replaceRouteTableAssociation"}
   [credentials5499 & args5500]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5501
     (com.palletops.awaze.common/aws-client :ec2 credentials5499)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5501
      replaceRouteTableAssociation
      (replace-route-table-association-request
       (clojure.core/nth args5500 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-subnet
   [m5502]
   (clojure.core/let
    [credentials5503 (:credentials m5502) args5504 (:args m5502)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5505
      (com.palletops.awaze.common/aws-client :ec2 credentials5503)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5505
       deleteSubnet
       (delete-subnet-request (clojure.core/nth args5504 0)))))))
  (clojure.core/defn
   delete-subnet-map
   {:arglists
    '[[credentials
       {:keys [subnet-id request-metric-collector dry-run-request]}]],
    :doc "Generate map for deleteSubnet"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-subnet,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-subnet
   {:arglists
    '[[credentials
       {:keys [subnet-id request-metric-collector dry-run-request]}]],
    :doc "Call deleteSubnet"}
   [credentials5507 & args5508]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5509
     (com.palletops.awaze.common/aws-client :ec2 credentials5507)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5509
      deleteSubnet
      (delete-subnet-request (clojure.core/nth args5508 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-vpc-attribute
   [m5510]
   (clojure.core/let
    [credentials5511 (:credentials m5510) args5512 (:args m5510)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5513
      (com.palletops.awaze.common/aws-client :ec2 credentials5511)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5513
       modifyVpcAttribute
       (modify-vpc-attribute-request
        (clojure.core/nth args5512 0)))))))
  (clojure.core/defn
   modify-vpc-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [vpc-id
         request-metric-collector
         enable-dns-support
         enable-dns-hostnames]}]],
    :doc "Generate map for modifyVpcAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-vpc-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-vpc-attribute
   {:arglists
    '[[credentials
       {:keys
        [vpc-id
         request-metric-collector
         enable-dns-support
         enable-dns-hostnames]}]],
    :doc "Call modifyVpcAttribute"}
   [credentials5515 & args5516]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5517
     (com.palletops.awaze.common/aws-client :ec2 credentials5515)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5517
      modifyVpcAttribute
      (modify-vpc-attribute-request (clojure.core/nth args5516 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-internet-gateway
   [m5518]
   (clojure.core/let
    [credentials5519 (:credentials m5518) args5520 (:args m5518)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5521
      (com.palletops.awaze.common/aws-client :ec2 credentials5519)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5521
       detachInternetGateway
       (detach-internet-gateway-request
        (clojure.core/nth args5520 0)))))))
  (clojure.core/defn
   detach-internet-gateway-map
   {:arglists
    '[[credentials
       {:keys
        [vpc-id
         request-metric-collector
         internet-gateway-id
         dry-run-request]}]],
    :doc "Generate map for detachInternetGateway"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-internet-gateway,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   detach-internet-gateway
   {:arglists
    '[[credentials
       {:keys
        [vpc-id
         request-metric-collector
         internet-gateway-id
         dry-run-request]}]],
    :doc "Call detachInternetGateway"}
   [credentials5523 & args5524]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5525
     (com.palletops.awaze.common/aws-client :ec2 credentials5523)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5525
      detachInternetGateway
      (detach-internet-gateway-request
       (clojure.core/nth args5524 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-modifications
   [m5526]
   (clojure.core/let
    [credentials5527 (:credentials m5526) args5528 (:args m5526)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5529
      (com.palletops.awaze.common/aws-client :ec2 credentials5527)]
     (clojure.core/case
      (clojure.core/count args5528)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5529
        describeReservedInstancesModifications
        (describe-reserved-instances-modifications-request
         (clojure.core/nth args5528 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5529
        describeReservedInstancesModifications))))))
  (clojure.core/defn
   describe-reserved-instances-modifications-map
   {:arglists
    '[[credentials
       {:keys
        [reserved-instances-modification-ids
         request-metric-collector
         next-token
         filters]}]
      [credentials]],
    :doc
    "Generate map for describeReservedInstancesModifications, describeReservedInstancesModifications"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-reserved-instances-modifications
   {:arglists
    '[[credentials
       {:keys
        [reserved-instances-modification-ids
         request-metric-collector
         next-token
         filters]}]
      [credentials]],
    :doc
    "Call describeReservedInstancesModifications, describeReservedInstancesModifications"}
   [credentials5531 & args5532]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5533
     (com.palletops.awaze.common/aws-client :ec2 credentials5531)]
    (clojure.core/case
     (clojure.core/count args5532)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5533
       describeReservedInstancesModifications
       (describe-reserved-instances-modifications-request
        (clojure.core/nth args5532 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5533
       describeReservedInstancesModifications))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-password-data
   [m5534]
   (clojure.core/let
    [credentials5535 (:credentials m5534) args5536 (:args m5534)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5537
      (com.palletops.awaze.common/aws-client :ec2 credentials5535)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5537
       getPasswordData
       (get-password-data-request (clojure.core/nth args5536 0)))))))
  (clojure.core/defn
   get-password-data-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector instance-id dry-run-request]}]],
    :doc "Generate map for getPasswordData"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :get-password-data,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-password-data
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector instance-id dry-run-request]}]],
    :doc "Call getPasswordData"}
   [credentials5539 & args5540]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5541
     (com.palletops.awaze.common/aws-client :ec2 credentials5539)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5541
      getPasswordData
      (get-password-data-request (clojure.core/nth args5540 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :unassign-private-ip-addresses
   [m5542]
   (clojure.core/let
    [credentials5543 (:credentials m5542) args5544 (:args m5542)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5545
      (com.palletops.awaze.common/aws-client :ec2 credentials5543)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5545
       unassignPrivateIpAddresses
       (unassign-private-ip-addresses-request
        (clojure.core/nth args5544 0)))))))
  (clojure.core/defn
   unassign-private-ip-addresses-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         private-ip-addresses
         network-interface-id]}]],
    :doc "Generate map for unassignPrivateIpAddresses"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :unassign-private-ip-addresses,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   unassign-private-ip-addresses
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         private-ip-addresses
         network-interface-id]}]],
    :doc "Call unassignPrivateIpAddresses"}
   [credentials5547 & args5548]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5549
     (com.palletops.awaze.common/aws-client :ec2 credentials5547)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5549
      unassignPrivateIpAddresses
      (unassign-private-ip-addresses-request
       (clojure.core/nth args5548 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-network-interface-attribute
   [m5550]
   (clojure.core/let
    [credentials5551 (:credentials m5550) args5552 (:args m5550)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5553
      (com.palletops.awaze.common/aws-client :ec2 credentials5551)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5553
       modifyNetworkInterfaceAttribute
       (modify-network-interface-attribute-request
        (clojure.core/nth args5552 0)))))))
  (clojure.core/defn
   modify-network-interface-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [description
         network-interface-id
         attachment
         groups
         dry-run-request
         request-metric-collector
         source-dest-check]}]],
    :doc "Generate map for modifyNetworkInterfaceAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-network-interface-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-network-interface-attribute
   {:arglists
    '[[credentials
       {:keys
        [description
         network-interface-id
         attachment
         groups
         dry-run-request
         request-metric-collector
         source-dest-check]}]],
    :doc "Call modifyNetworkInterfaceAttribute"}
   [credentials5555 & args5556]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5557
     (com.palletops.awaze.common/aws-client :ec2 credentials5555)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5557
      modifyNetworkInterfaceAttribute
      (modify-network-interface-attribute-request
       (clojure.core/nth args5556 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-network-interface-attribute
   [m5558]
   (clojure.core/let
    [credentials5559 (:credentials m5558) args5560 (:args m5558)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5561
      (com.palletops.awaze.common/aws-client :ec2 credentials5559)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5561
       resetNetworkInterfaceAttribute
       (reset-network-interface-attribute-request
        (clojure.core/nth args5560 0)))))))
  (clojure.core/defn
   reset-network-interface-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [source-dest-check
         request-metric-collector
         network-interface-id
         dry-run-request]}]],
    :doc "Generate map for resetNetworkInterfaceAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-network-interface-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   reset-network-interface-attribute
   {:arglists
    '[[credentials
       {:keys
        [source-dest-check
         request-metric-collector
         network-interface-id
         dry-run-request]}]],
    :doc "Call resetNetworkInterfaceAttribute"}
   [credentials5563 & args5564]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5565
     (com.palletops.awaze.common/aws-client :ec2 credentials5563)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5565
      resetNetworkInterfaceAttribute
      (reset-network-interface-attribute-request
       (clojure.core/nth args5564 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpcs
   [m5566]
   (clojure.core/let
    [credentials5567 (:credentials m5566) args5568 (:args m5566)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5569
      (com.palletops.awaze.common/aws-client :ec2 credentials5567)]
     (clojure.core/case
      (clojure.core/count args5568)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5569
        describeVpcs
        (describe-vpcs-request (clojure.core/nth args5568 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5569
        describeVpcs))))))
  (clojure.core/defn
   describe-vpcs-map
   {:arglists
    '[[credentials
       {:keys
        [vpc-ids request-metric-collector filters dry-run-request]}]
      [credentials]],
    :doc "Generate map for describeVpcs, describeVpcs"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpcs,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpcs,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-vpcs
   {:arglists
    '[[credentials
       {:keys
        [vpc-ids request-metric-collector filters dry-run-request]}]
      [credentials]],
    :doc "Call describeVpcs, describeVpcs"}
   [credentials5571 & args5572]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5573
     (com.palletops.awaze.common/aws-client :ec2 credentials5571)]
    (clojure.core/case
     (clojure.core/count args5572)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5573
       describeVpcs
       (describe-vpcs-request (clojure.core/nth args5572 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5573
       describeVpcs))))))
 (do
  (clojure.core/defmethod
   ec2
   :reboot-instances
   [m5574]
   (clojure.core/let
    [credentials5575 (:credentials m5574) args5576 (:args m5574)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5577
      (com.palletops.awaze.common/aws-client :ec2 credentials5575)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5577
       rebootInstances
       (reboot-instances-request (clojure.core/nth args5576 0)))))))
  (clojure.core/defn
   reboot-instances-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector instance-ids dry-run-request]}]],
    :doc "Generate map for rebootInstances"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reboot-instances,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   reboot-instances
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector instance-ids dry-run-request]}]],
    :doc "Call rebootInstances"}
   [credentials5579 & args5580]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5581
     (com.palletops.awaze.common/aws-client :ec2 credentials5579)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5581
      rebootInstances
      (reboot-instances-request (clojure.core/nth args5580 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-attribute
   [m5582]
   (clojure.core/let
    [credentials5583 (:credentials m5582) args5584 (:args m5582)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5585
      (com.palletops.awaze.common/aws-client :ec2 credentials5583)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5585
       describeVolumeAttribute
       (describe-volume-attribute-request
        (clojure.core/nth args5584 0)))))))
  (clojure.core/defn
   describe-volume-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [volume-id
         request-metric-collector
         dry-run-request
         attribute]}]],
    :doc "Generate map for describeVolumeAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-volume-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-volume-attribute
   {:arglists
    '[[credentials
       {:keys
        [volume-id
         request-metric-collector
         dry-run-request
         attribute]}]],
    :doc "Call describeVolumeAttribute"}
   [credentials5587 & args5588]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5589
     (com.palletops.awaze.common/aws-client :ec2 credentials5587)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5589
      describeVolumeAttribute
      (describe-volume-attribute-request
       (clojure.core/nth args5588 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-instance-attribute
   [m5590]
   (clojure.core/let
    [credentials5591 (:credentials m5590) args5592 (:args m5590)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5593
      (com.palletops.awaze.common/aws-client :ec2 credentials5591)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5593
       modifyInstanceAttribute
       (modify-instance-attribute-request
        (clojure.core/nth args5592 0)))))))
  (clojure.core/defn
   modify-instance-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [instance-type
         dry-run-request
         request-metric-collector
         ebs-optimized
         source-dest-check
         block-device-mappings
         kernel
         disable-api-termination
         user-data
         groups
         ramdisk
         attribute
         instance-id
         instance-initiated-shutdown-behavior
         value]}]],
    :doc "Generate map for modifyInstanceAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-instance-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   modify-instance-attribute
   {:arglists
    '[[credentials
       {:keys
        [instance-type
         dry-run-request
         request-metric-collector
         ebs-optimized
         source-dest-check
         block-device-mappings
         kernel
         disable-api-termination
         user-data
         groups
         ramdisk
         attribute
         instance-id
         instance-initiated-shutdown-behavior
         value]}]],
    :doc "Call modifyInstanceAttribute"}
   [credentials5595 & args5596]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5597
     (com.palletops.awaze.common/aws-client :ec2 credentials5595)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5597
      modifyInstanceAttribute
      (modify-instance-attribute-request
       (clojure.core/nth args5596 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-key-pair
   [m5598]
   (clojure.core/let
    [credentials5599 (:credentials m5598) args5600 (:args m5598)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5601
      (com.palletops.awaze.common/aws-client :ec2 credentials5599)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5601
       deleteKeyPair
       (delete-key-pair-request (clojure.core/nth args5600 0)))))))
  (clojure.core/defn
   delete-key-pair-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector key-name dry-run-request]}]],
    :doc "Generate map for deleteKeyPair"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-key-pair,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-key-pair
   {:arglists
    '[[credentials
       {:keys [request-metric-collector key-name dry-run-request]}]],
    :doc "Call deleteKeyPair"}
   [credentials5603 & args5604]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5605
     (com.palletops.awaze.common/aws-client :ec2 credentials5603)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5605
      deleteKeyPair
      (delete-key-pair-request (clojure.core/nth args5604 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vgw-route-propagation
   [m5606]
   (clojure.core/let
    [credentials5607 (:credentials m5606) args5608 (:args m5606)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5609
      (com.palletops.awaze.common/aws-client :ec2 credentials5607)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5609
       enableVgwRoutePropagation
       (enable-vgw-route-propagation-request
        (clojure.core/nth args5608 0)))))))
  (clojure.core/defn
   enable-vgw-route-propagation-map
   {:arglists
    '[[credentials
       {:keys [route-table-id request-metric-collector gateway-id]}]],
    :doc "Generate map for enableVgwRoutePropagation"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :enable-vgw-route-propagation,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   enable-vgw-route-propagation
   {:arglists
    '[[credentials
       {:keys [route-table-id request-metric-collector gateway-id]}]],
    :doc "Call enableVgwRoutePropagation"}
   [credentials5611 & args5612]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5613
     (com.palletops.awaze.common/aws-client :ec2 credentials5611)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5613
      enableVgwRoutePropagation
      (enable-vgw-route-propagation-request
       (clojure.core/nth args5612 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :bundle-instance
   [m5614]
   (clojure.core/let
    [credentials5615 (:credentials m5614) args5616 (:args m5614)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5617
      (com.palletops.awaze.common/aws-client :ec2 credentials5615)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5617
       bundleInstance
       (bundle-instance-request (clojure.core/nth args5616 0)))))))
  (clojure.core/defn
   bundle-instance-map
   {:arglists
    '[[credentials
       {:keys
        [storage
         request-metric-collector
         instance-id
         dry-run-request]}]],
    :doc "Generate map for bundleInstance"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :bundle-instance,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   bundle-instance
   {:arglists
    '[[credentials
       {:keys
        [storage
         request-metric-collector
         instance-id
         dry-run-request]}]],
    :doc "Call bundleInstance"}
   [credentials5619 & args5620]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5621
     (com.palletops.awaze.common/aws-client :ec2 credentials5619)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5621
      bundleInstance
      (bundle-instance-request (clojure.core/nth args5620 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-internet-gateway
   [m5622]
   (clojure.core/let
    [credentials5623 (:credentials m5622) args5624 (:args m5622)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5625
      (com.palletops.awaze.common/aws-client :ec2 credentials5623)]
     (clojure.core/case
      (clojure.core/count args5624)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5625
        createInternetGateway))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5625
        createInternetGateway
        (create-internet-gateway-request
         (clojure.core/nth args5624 0))))))))
  (clojure.core/defn
   create-internet-gateway-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys [request-metric-collector dry-run-request]}]],
    :doc
    "Generate map for createInternetGateway, createInternetGateway"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :create-internet-gateway,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-internet-gateway,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-internet-gateway
   {:arglists
    '[[credentials]
      [credentials
       {:keys [request-metric-collector dry-run-request]}]],
    :doc "Call createInternetGateway, createInternetGateway"}
   [credentials5627 & args5628]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5629
     (com.palletops.awaze.common/aws-client :ec2 credentials5627)]
    (clojure.core/case
     (clojure.core/count args5628)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5629
       createInternetGateway))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5629
       createInternetGateway
       (create-internet-gateway-request
        (clojure.core/nth args5628 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-status
   [m5630]
   (clojure.core/let
    [credentials5631 (:credentials m5630) args5632 (:args m5630)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5633
      (com.palletops.awaze.common/aws-client :ec2 credentials5631)]
     (clojure.core/case
      (clojure.core/count args5632)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5633
        describeVolumeStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5633
        describeVolumeStatus
        (describe-volume-status-request
         (clojure.core/nth args5632 0))))))))
  (clojure.core/defn
   describe-volume-status-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [volume-ids
         request-metric-collector
         next-token
         max-results
         filters
         dry-run-request]}]],
    :doc "Generate map for describeVolumeStatus, describeVolumeStatus"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-volume-status,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-volume-status,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-volume-status
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [volume-ids
         request-metric-collector
         next-token
         max-results
         filters
         dry-run-request]}]],
    :doc "Call describeVolumeStatus, describeVolumeStatus"}
   [credentials5635 & args5636]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5637
     (com.palletops.awaze.common/aws-client :ec2 credentials5635)]
    (clojure.core/case
     (clojure.core/count args5636)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5637
       describeVolumeStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5637
       describeVolumeStatus
       (describe-volume-status-request
        (clojure.core/nth args5636 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-image
   [m5638]
   (clojure.core/let
    [credentials5639 (:credentials m5638) args5640 (:args m5638)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5641
      (com.palletops.awaze.common/aws-client :ec2 credentials5639)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5641
       copyImage
       (copy-image-request (clojure.core/nth args5640 0)))))))
  (clojure.core/defn
   copy-image-map
   {:arglists
    '[[credentials
       {:keys
        [description
         source-image-id
         source-region
         client-token
         dry-run-request
         name
         request-metric-collector]}]],
    :doc "Generate map for copyImage"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :copy-image,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   copy-image
   {:arglists
    '[[credentials
       {:keys
        [description
         source-image-id
         source-region
         client-token
         dry-run-request
         name
         request-metric-collector]}]],
    :doc "Call copyImage"}
   [credentials5643 & args5644]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5645
     (com.palletops.awaze.common/aws-client :ec2 credentials5643)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5645
      copyImage
      (copy-image-request (clojure.core/nth args5644 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-key-pairs
   [m5646]
   (clojure.core/let
    [credentials5647 (:credentials m5646) args5648 (:args m5646)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5649
      (com.palletops.awaze.common/aws-client :ec2 credentials5647)]
     (clojure.core/case
      (clojure.core/count args5648)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5649
        describeKeyPairs))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5649
        describeKeyPairs
        (describe-key-pairs-request
         (clojure.core/nth args5648 0))))))))
  (clojure.core/defn
   describe-key-pairs-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         key-names
         filters
         dry-run-request]}]],
    :doc "Generate map for describeKeyPairs, describeKeyPairs"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-key-pairs,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-key-pairs,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-key-pairs
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         key-names
         filters
         dry-run-request]}]],
    :doc "Call describeKeyPairs, describeKeyPairs"}
   [credentials5651 & args5652]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5653
     (com.palletops.awaze.common/aws-client :ec2 credentials5651)]
    (clojure.core/case
     (clojure.core/count args5652)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5653
       describeKeyPairs))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5653
       describeKeyPairs
       (describe-key-pairs-request (clojure.core/nth args5652 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl-entry
   [m5654]
   (clojure.core/let
    [credentials5655 (:credentials m5654) args5656 (:args m5654)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5657
      (com.palletops.awaze.common/aws-client :ec2 credentials5655)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5657
       deleteNetworkAclEntry
       (delete-network-acl-entry-request
        (clojure.core/nth args5656 0)))))))
  (clojure.core/defn
   delete-network-acl-entry-map
   {:arglists
    '[[credentials
       {:keys
        [rule-number
         request-metric-collector
         network-acl-id
         egress
         dry-run-request]}]],
    :doc "Generate map for deleteNetworkAclEntry"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-network-acl-entry,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-network-acl-entry
   {:arglists
    '[[credentials
       {:keys
        [rule-number
         request-metric-collector
         network-acl-id
         egress
         dry-run-request]}]],
    :doc "Call deleteNetworkAclEntry"}
   [credentials5659 & args5660]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5661
     (com.palletops.awaze.common/aws-client :ec2 credentials5659)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5661
      deleteNetworkAclEntry
      (delete-network-acl-entry-request
       (clojure.core/nth args5660 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :purchase-reserved-instances-offering
   [m5662]
   (clojure.core/let
    [credentials5663 (:credentials m5662) args5664 (:args m5662)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5665
      (com.palletops.awaze.common/aws-client :ec2 credentials5663)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5665
       purchaseReservedInstancesOffering
       (purchase-reserved-instances-offering-request
        (clojure.core/nth args5664 0)))))))
  (clojure.core/defn
   purchase-reserved-instances-offering-map
   {:arglists
    '[[credentials
       {:keys
        [reserved-instances-offering-id
         request-metric-collector
         limit-price
         instance-count
         dry-run-request]}]],
    :doc "Generate map for purchaseReservedInstancesOffering"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :purchase-reserved-instances-offering,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   purchase-reserved-instances-offering
   {:arglists
    '[[credentials
       {:keys
        [reserved-instances-offering-id
         request-metric-collector
         limit-price
         instance-count
         dry-run-request]}]],
    :doc "Call purchaseReservedInstancesOffering"}
   [credentials5667 & args5668]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5669
     (com.palletops.awaze.common/aws-client :ec2 credentials5667)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5669
      purchaseReservedInstancesOffering
      (purchase-reserved-instances-offering-request
       (clojure.core/nth args5668 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-reserved-instances-listing
   [m5670]
   (clojure.core/let
    [credentials5671 (:credentials m5670) args5672 (:args m5670)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5673
      (com.palletops.awaze.common/aws-client :ec2 credentials5671)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5673
       cancelReservedInstancesListing
       (cancel-reserved-instances-listing-request
        (clojure.core/nth args5672 0)))))))
  (clojure.core/defn
   cancel-reserved-instances-listing-map
   {:arglists
    '[[credentials
       {:keys
        [reserved-instances-listing-id request-metric-collector]}]],
    :doc "Generate map for cancelReservedInstancesListing"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-reserved-instances-listing,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   cancel-reserved-instances-listing
   {:arglists
    '[[credentials
       {:keys
        [reserved-instances-listing-id request-metric-collector]}]],
    :doc "Call cancelReservedInstancesListing"}
   [credentials5675 & args5676]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5677
     (com.palletops.awaze.common/aws-client :ec2 credentials5675)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5677
      cancelReservedInstancesListing
      (cancel-reserved-instances-listing-request
       (clojure.core/nth args5676 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-egress
   [m5678]
   (clojure.core/let
    [credentials5679 (:credentials m5678) args5680 (:args m5678)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5681
      (com.palletops.awaze.common/aws-client :ec2 credentials5679)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5681
       revokeSecurityGroupEgress
       (revoke-security-group-egress-request
        (clojure.core/nth args5680 0)))))))
  (clojure.core/defn
   revoke-security-group-egress-map
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         source-security-group-name
         request-metric-collector
         group-id
         from-port
         ip-permissions
         to-port
         cidr-ip
         ip-protocol
         source-security-group-owner-id]}]],
    :doc "Generate map for revokeSecurityGroupEgress"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :revoke-security-group-egress,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   revoke-security-group-egress
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         source-security-group-name
         request-metric-collector
         group-id
         from-port
         ip-permissions
         to-port
         cidr-ip
         ip-protocol
         source-security-group-owner-id]}]],
    :doc "Call revokeSecurityGroupEgress"}
   [credentials5683 & args5684]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5685
     (com.palletops.awaze.common/aws-client :ec2 credentials5683)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5685
      revokeSecurityGroupEgress
      (revoke-security-group-egress-request
       (clojure.core/nth args5684 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :deactivate-license
   [m5686]
   (clojure.core/let
    [credentials5687 (:credentials m5686) args5688 (:args m5686)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5689
      (com.palletops.awaze.common/aws-client :ec2 credentials5687)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5689
       deactivateLicense
       (deactivate-license-request (clojure.core/nth args5688 0)))))))
  (clojure.core/defn
   deactivate-license-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         license-id
         dry-run-request
         capacity]}]],
    :doc "Generate map for deactivateLicense"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :deactivate-license,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   deactivate-license
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         license-id
         dry-run-request
         capacity]}]],
    :doc "Call deactivateLicense"}
   [credentials5691 & args5692]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5693
     (com.palletops.awaze.common/aws-client :ec2 credentials5691)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5693
      deactivateLicense
      (deactivate-license-request (clojure.core/nth args5692 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-spot-datafeed-subscription
   [m5694]
   (clojure.core/let
    [credentials5695 (:credentials m5694) args5696 (:args m5694)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5697
      (com.palletops.awaze.common/aws-client :ec2 credentials5695)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5697
       createSpotDatafeedSubscription
       (create-spot-datafeed-subscription-request
        (clojure.core/nth args5696 0)))))))
  (clojure.core/defn
   create-spot-datafeed-subscription-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector prefix dry-run-request bucket]}]],
    :doc "Generate map for createSpotDatafeedSubscription"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-spot-datafeed-subscription,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-spot-datafeed-subscription
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector prefix dry-run-request bucket]}]],
    :doc "Call createSpotDatafeedSubscription"}
   [credentials5699 & args5700]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5701
     (com.palletops.awaze.common/aws-client :ec2 credentials5699)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5701
      createSpotDatafeedSubscription
      (create-spot-datafeed-subscription-request
       (clojure.core/nth args5700 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-volume-io
   [m5702]
   (clojure.core/let
    [credentials5703 (:credentials m5702) args5704 (:args m5702)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5705
      (com.palletops.awaze.common/aws-client :ec2 credentials5703)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5705
       enableVolumeIO
       (enable-volume-iorequest (clojure.core/nth args5704 0)))))))
  (clojure.core/defn
   enable-volume-io-map
   {:arglists
    '[[credentials
       {:keys [volume-id request-metric-collector dry-run-request]}]],
    :doc "Generate map for enableVolumeIO"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :enable-volume-io,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   enable-volume-io
   {:arglists
    '[[credentials
       {:keys [volume-id request-metric-collector dry-run-request]}]],
    :doc "Call enableVolumeIO"}
   [credentials5707 & args5708]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5709
     (com.palletops.awaze.common/aws-client :ec2 credentials5707)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5709
      enableVolumeIO
      (enable-volume-iorequest (clojure.core/nth args5708 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-association
   [m5710]
   (clojure.core/let
    [credentials5711 (:credentials m5710) args5712 (:args m5710)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5713
      (com.palletops.awaze.common/aws-client :ec2 credentials5711)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5713
       replaceNetworkAclAssociation
       (replace-network-acl-association-request
        (clojure.core/nth args5712 0)))))))
  (clojure.core/defn
   replace-network-acl-association-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         network-acl-id
         dry-run-request
         association-id]}]],
    :doc "Generate map for replaceNetworkAclAssociation"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-network-acl-association,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   replace-network-acl-association
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         network-acl-id
         dry-run-request
         association-id]}]],
    :doc "Call replaceNetworkAclAssociation"}
   [credentials5715 & args5716]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5717
     (com.palletops.awaze.common/aws-client :ec2 credentials5715)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5717
      replaceNetworkAclAssociation
      (replace-network-acl-association-request
       (clojure.core/nth args5716 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-snapshot
   [m5718]
   (clojure.core/let
    [credentials5719 (:credentials m5718) args5720 (:args m5718)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5721
      (com.palletops.awaze.common/aws-client :ec2 credentials5719)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5721
       copySnapshot
       (copy-snapshot-request (clojure.core/nth args5720 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists
    '[[credentials
       {:keys
        [source-snapshot-id
         source-region
         request-metric-collector
         dry-run-request
         description]}]],
    :doc "Generate map for copySnapshot"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :copy-snapshot,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   copy-snapshot
   {:arglists
    '[[credentials
       {:keys
        [source-snapshot-id
         source-region
         request-metric-collector
         dry-run-request
         description]}]],
    :doc "Call copySnapshot"}
   [credentials5723 & args5724]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5725
     (com.palletops.awaze.common/aws-client :ec2 credentials5723)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5725
      copySnapshot
      (copy-snapshot-request (clojure.core/nth args5724 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-customer-gateway
   [m5726]
   (clojure.core/let
    [credentials5727 (:credentials m5726) args5728 (:args m5726)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5729
      (com.palletops.awaze.common/aws-client :ec2 credentials5727)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5729
       createCustomerGateway
       (create-customer-gateway-request
        (clojure.core/nth args5728 0)))))))
  (clojure.core/defn
   create-customer-gateway-map
   {:arglists
    '[[credentials
       {:keys
        [type
         request-metric-collector
         public-ip
         dry-run-request
         bgp-asn]}]],
    :doc "Generate map for createCustomerGateway"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-customer-gateway,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-customer-gateway
   {:arglists
    '[[credentials
       {:keys
        [type
         request-metric-collector
         public-ip
         dry-run-request
         bgp-asn]}]],
    :doc "Call createCustomerGateway"}
   [credentials5731 & args5732]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5733
     (com.palletops.awaze.common/aws-client :ec2 credentials5731)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5733
      createCustomerGateway
      (create-customer-gateway-request
       (clojure.core/nth args5732 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-offerings
   [m5734]
   (clojure.core/let
    [credentials5735 (:credentials m5734) args5736 (:args m5734)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5737
      (com.palletops.awaze.common/aws-client :ec2 credentials5735)]
     (clojure.core/case
      (clojure.core/count args5736)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5737
        describeReservedInstancesOfferings
        (describe-reserved-instances-offerings-request
         (clojure.core/nth args5736 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5737
        describeReservedInstancesOfferings))))))
  (clojure.core/defn
   describe-reserved-instances-offerings-map
   {:arglists
    '[[credentials
       {:keys
        [instance-type
         reserved-instances-offering-ids
         dry-run-request
         request-metric-collector
         min-duration
         filters
         max-duration
         availability-zone
         max-instance-count
         max-results
         product-description
         next-token
         offering-type
         instance-tenancy
         include-marketplace]}]
      [credentials]],
    :doc
    "Generate map for describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-reserved-instances-offerings
   {:arglists
    '[[credentials
       {:keys
        [instance-type
         reserved-instances-offering-ids
         dry-run-request
         request-metric-collector
         min-duration
         filters
         max-duration
         availability-zone
         max-instance-count
         max-results
         product-description
         next-token
         offering-type
         instance-tenancy
         include-marketplace]}]
      [credentials]],
    :doc
    "Call describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   [credentials5739 & args5740]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5741
     (com.palletops.awaze.common/aws-client :ec2 credentials5739)]
    (clojure.core/case
     (clojure.core/count args5740)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5741
       describeReservedInstancesOfferings
       (describe-reserved-instances-offerings-request
        (clojure.core/nth args5740 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5741
       describeReservedInstancesOfferings))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-bundle-task
   [m5742]
   (clojure.core/let
    [credentials5743 (:credentials m5742) args5744 (:args m5742)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5745
      (com.palletops.awaze.common/aws-client :ec2 credentials5743)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5745
       cancelBundleTask
       (cancel-bundle-task-request (clojure.core/nth args5744 0)))))))
  (clojure.core/defn
   cancel-bundle-task-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector dry-run-request bundle-id]}]],
    :doc "Generate map for cancelBundleTask"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-bundle-task,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   cancel-bundle-task
   {:arglists
    '[[credentials
       {:keys [request-metric-collector dry-run-request bundle-id]}]],
    :doc "Call cancelBundleTask"}
   [credentials5747 & args5748]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5749
     (com.palletops.awaze.common/aws-client :ec2 credentials5747)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5749
      cancelBundleTask
      (cancel-bundle-task-request (clojure.core/nth args5748 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-images
   [m5750]
   (clojure.core/let
    [credentials5751 (:credentials m5750) args5752 (:args m5750)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5753
      (com.palletops.awaze.common/aws-client :ec2 credentials5751)]
     (clojure.core/case
      (clojure.core/count args5752)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5753
        describeImages
        (describe-images-request (clojure.core/nth args5752 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5753
        describeImages))))))
  (clojure.core/defn
   describe-images-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         owners
         image-ids
         filters
         executable-users
         dry-run-request]}]
      [credentials]],
    :doc "Generate map for describeImages, describeImages"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-images,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-images,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-images
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         owners
         image-ids
         filters
         executable-users
         dry-run-request]}]
      [credentials]],
    :doc "Call describeImages, describeImages"}
   [credentials5755 & args5756]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5757
     (com.palletops.awaze.common/aws-client :ec2 credentials5755)]
    (clojure.core/case
     (clojure.core/count args5756)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5757
       describeImages
       (describe-images-request (clojure.core/nth args5756 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5757
       describeImages))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-dhcp-options
   [m5758]
   (clojure.core/let
    [credentials5759 (:credentials m5758) args5760 (:args m5758)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5761
      (com.palletops.awaze.common/aws-client :ec2 credentials5759)]
     (clojure.core/case
      (clojure.core/count args5760)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5761
        describeDhcpOptions))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5761
        describeDhcpOptions
        (describe-dhcp-options-request
         (clojure.core/nth args5760 0))))))))
  (clojure.core/defn
   describe-dhcp-options-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         filters
         dry-run-request
         dhcp-options-ids]}]],
    :doc "Generate map for describeDhcpOptions, describeDhcpOptions"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-dhcp-options,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-dhcp-options,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-dhcp-options
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         filters
         dry-run-request
         dhcp-options-ids]}]],
    :doc "Call describeDhcpOptions, describeDhcpOptions"}
   [credentials5763 & args5764]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5765
     (com.palletops.awaze.common/aws-client :ec2 credentials5763)]
    (clojure.core/case
     (clojure.core/count args5764)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5765
       describeDhcpOptions))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5765
       describeDhcpOptions
       (describe-dhcp-options-request
        (clojure.core/nth args5764 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection
   [m5766]
   (clojure.core/let
    [credentials5767 (:credentials m5766) args5768 (:args m5766)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5769
      (com.palletops.awaze.common/aws-client :ec2 credentials5767)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5769
       deleteVpnConnection
       (delete-vpn-connection-request
        (clojure.core/nth args5768 0)))))))
  (clojure.core/defn
   delete-vpn-connection-map
   {:arglists
    '[[credentials
       {:keys
        [vpn-connection-id
         request-metric-collector
         dry-run-request]}]],
    :doc "Generate map for deleteVpnConnection"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpn-connection,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-vpn-connection
   {:arglists
    '[[credentials
       {:keys
        [vpn-connection-id
         request-metric-collector
         dry-run-request]}]],
    :doc "Call deleteVpnConnection"}
   [credentials5771 & args5772]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5773
     (com.palletops.awaze.common/aws-client :ec2 credentials5771)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5773
      deleteVpnConnection
      (delete-vpn-connection-request
       (clojure.core/nth args5772 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection-route
   [m5774]
   (clojure.core/let
    [credentials5775 (:credentials m5774) args5776 (:args m5774)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5777
      (com.palletops.awaze.common/aws-client :ec2 credentials5775)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5777
       createVpnConnectionRoute
       (create-vpn-connection-route-request
        (clojure.core/nth args5776 0)))))))
  (clojure.core/defn
   create-vpn-connection-route-map
   {:arglists
    '[[credentials
       {:keys
        [vpn-connection-id
         request-metric-collector
         destination-cidr-block]}]],
    :doc "Generate map for createVpnConnectionRoute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpn-connection-route,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-vpn-connection-route
   {:arglists
    '[[credentials
       {:keys
        [vpn-connection-id
         request-metric-collector
         destination-cidr-block]}]],
    :doc "Call createVpnConnectionRoute"}
   [credentials5779 & args5780]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5781
     (com.palletops.awaze.common/aws-client :ec2 credentials5779)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5781
      createVpnConnectionRoute
      (create-vpn-connection-route-request
       (clojure.core/nth args5780 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-key-pair
   [m5782]
   (clojure.core/let
    [credentials5783 (:credentials m5782) args5784 (:args m5782)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5785
      (com.palletops.awaze.common/aws-client :ec2 credentials5783)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5785
       createKeyPair
       (create-key-pair-request (clojure.core/nth args5784 0)))))))
  (clojure.core/defn
   create-key-pair-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector key-name dry-run-request]}]],
    :doc "Generate map for createKeyPair"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-key-pair,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-key-pair
   {:arglists
    '[[credentials
       {:keys [request-metric-collector key-name dry-run-request]}]],
    :doc "Call createKeyPair"}
   [credentials5787 & args5788]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5789
     (com.palletops.awaze.common/aws-client :ec2 credentials5787)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5789
      createKeyPair
      (create-key-pair-request (clojure.core/nth args5788 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-account-attributes
   [m5790]
   (clojure.core/let
    [credentials5791 (:credentials m5790) args5792 (:args m5790)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5793
      (com.palletops.awaze.common/aws-client :ec2 credentials5791)]
     (clojure.core/case
      (clojure.core/count args5792)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5793
        describeAccountAttributes
        (describe-account-attributes-request
         (clojure.core/nth args5792 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5793
        describeAccountAttributes))))))
  (clojure.core/defn
   describe-account-attributes-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector dry-run-request attribute-names]}]
      [credentials]],
    :doc
    "Generate map for describeAccountAttributes, describeAccountAttributes"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-account-attributes,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-account-attributes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-account-attributes
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector dry-run-request attribute-names]}]
      [credentials]],
    :doc "Call describeAccountAttributes, describeAccountAttributes"}
   [credentials5795 & args5796]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5797
     (com.palletops.awaze.common/aws-client :ec2 credentials5795)]
    (clojure.core/case
     (clojure.core/count args5796)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5797
       describeAccountAttributes
       (describe-account-attributes-request
        (clojure.core/nth args5796 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5797
       describeAccountAttributes))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-datafeed-subscription
   [m5798]
   (clojure.core/let
    [credentials5799 (:credentials m5798) args5800 (:args m5798)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5801
      (com.palletops.awaze.common/aws-client :ec2 credentials5799)]
     (clojure.core/case
      (clojure.core/count args5800)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5801
        describeSpotDatafeedSubscription))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5801
        describeSpotDatafeedSubscription
        (describe-spot-datafeed-subscription-request
         (clojure.core/nth args5800 0))))))))
  (clojure.core/defn
   describe-spot-datafeed-subscription-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys [request-metric-collector dry-run-request]}]],
    :doc
    "Generate map for describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-spot-datafeed-subscription
   {:arglists
    '[[credentials]
      [credentials
       {:keys [request-metric-collector dry-run-request]}]],
    :doc
    "Call describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   [credentials5803 & args5804]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5805
     (com.palletops.awaze.common/aws-client :ec2 credentials5803)]
    (clojure.core/case
     (clojure.core/count args5804)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5805
       describeSpotDatafeedSubscription))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5805
       describeSpotDatafeedSubscription
       (describe-spot-datafeed-subscription-request
        (clojure.core/nth args5804 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-internet-gateways
   [m5806]
   (clojure.core/let
    [credentials5807 (:credentials m5806) args5808 (:args m5806)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5809
      (com.palletops.awaze.common/aws-client :ec2 credentials5807)]
     (clojure.core/case
      (clojure.core/count args5808)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5809
        describeInternetGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5809
        describeInternetGateways
        (describe-internet-gateways-request
         (clojure.core/nth args5808 0))))))))
  (clojure.core/defn
   describe-internet-gateways-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         internet-gateway-ids
         filters
         dry-run-request]}]],
    :doc
    "Generate map for describeInternetGateways, describeInternetGateways"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-internet-gateways,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-internet-gateways,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-internet-gateways
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         internet-gateway-ids
         filters
         dry-run-request]}]],
    :doc "Call describeInternetGateways, describeInternetGateways"}
   [credentials5811 & args5812]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5813
     (com.palletops.awaze.common/aws-client :ec2 credentials5811)]
    (clojure.core/case
     (clojure.core/count args5812)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5813
       describeInternetGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5813
       describeInternetGateways
       (describe-internet-gateways-request
        (clojure.core/nth args5812 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :start-instances
   [m5814]
   (clojure.core/let
    [credentials5815 (:credentials m5814) args5816 (:args m5814)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5817
      (com.palletops.awaze.common/aws-client :ec2 credentials5815)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5817
       startInstances
       (start-instances-request (clojure.core/nth args5816 0)))))))
  (clojure.core/defn
   start-instances-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         instance-ids
         dry-run-request
         additional-info]}]],
    :doc "Generate map for startInstances"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :start-instances,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   start-instances
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         instance-ids
         dry-run-request
         additional-info]}]],
    :doc "Call startInstances"}
   [credentials5819 & args5820]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5821
     (com.palletops.awaze.common/aws-client :ec2 credentials5819)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5821
      startInstances
      (start-instances-request (clojure.core/nth args5820 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-network-interface
   [m5822]
   (clojure.core/let
    [credentials5823 (:credentials m5822) args5824 (:args m5822)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5825
      (com.palletops.awaze.common/aws-client :ec2 credentials5823)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5825
       attachNetworkInterface
       (attach-network-interface-request
        (clojure.core/nth args5824 0)))))))
  (clojure.core/defn
   attach-network-interface-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         network-interface-id
         instance-id
         dry-run-request
         device-index]}]],
    :doc "Generate map for attachNetworkInterface"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-network-interface,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   attach-network-interface
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         network-interface-id
         instance-id
         dry-run-request
         device-index]}]],
    :doc "Call attachNetworkInterface"}
   [credentials5827 & args5828]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5829
     (com.palletops.awaze.common/aws-client :ec2 credentials5827)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5829
      attachNetworkInterface
      (attach-network-interface-request
       (clojure.core/nth args5828 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route
   [m5830]
   (clojure.core/let
    [credentials5831 (:credentials m5830) args5832 (:args m5830)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5833
      (com.palletops.awaze.common/aws-client :ec2 credentials5831)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5833
       createRoute
       (create-route-request (clojure.core/nth args5832 0)))))))
  (clojure.core/defn
   create-route-map
   {:arglists
    '[[credentials
       {:keys
        [network-interface-id
         route-table-id
         dry-run-request
         destination-cidr-block
         instance-id
         request-metric-collector
         gateway-id]}]],
    :doc "Generate map for createRoute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-route,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-route
   {:arglists
    '[[credentials
       {:keys
        [network-interface-id
         route-table-id
         dry-run-request
         destination-cidr-block
         instance-id
         request-metric-collector
         gateway-id]}]],
    :doc "Call createRoute"}
   [credentials5835 & args5836]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5837
     (com.palletops.awaze.common/aws-client :ec2 credentials5835)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5837
      createRoute
      (create-route-request (clojure.core/nth args5836 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :unmonitor-instances
   [m5838]
   (clojure.core/let
    [credentials5839 (:credentials m5838) args5840 (:args m5838)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5841
      (com.palletops.awaze.common/aws-client :ec2 credentials5839)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5841
       unmonitorInstances
       (unmonitor-instances-request (clojure.core/nth args5840 0)))))))
  (clojure.core/defn
   unmonitor-instances-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector instance-ids dry-run-request]}]],
    :doc "Generate map for unmonitorInstances"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :unmonitor-instances,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   unmonitor-instances
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector instance-ids dry-run-request]}]],
    :doc "Call unmonitorInstances"}
   [credentials5843 & args5844]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5845
     (com.palletops.awaze.common/aws-client :ec2 credentials5843)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5845
      unmonitorInstances
      (unmonitor-instances-request (clojure.core/nth args5844 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-interface
   [m5846]
   (clojure.core/let
    [credentials5847 (:credentials m5846) args5848 (:args m5846)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5849
      (com.palletops.awaze.common/aws-client :ec2 credentials5847)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5849
       deleteNetworkInterface
       (delete-network-interface-request
        (clojure.core/nth args5848 0)))))))
  (clojure.core/defn
   delete-network-interface-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         network-interface-id
         dry-run-request]}]],
    :doc "Generate map for deleteNetworkInterface"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-network-interface,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-network-interface
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         network-interface-id
         dry-run-request]}]],
    :doc "Call deleteNetworkInterface"}
   [credentials5851 & args5852]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5853
     (com.palletops.awaze.common/aws-client :ec2 credentials5851)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5853
      deleteNetworkInterface
      (delete-network-interface-request
       (clojure.core/nth args5852 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :monitor-instances
   [m5854]
   (clojure.core/let
    [credentials5855 (:credentials m5854) args5856 (:args m5854)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5857
      (com.palletops.awaze.common/aws-client :ec2 credentials5855)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5857
       monitorInstances
       (monitor-instances-request (clojure.core/nth args5856 0)))))))
  (clojure.core/defn
   monitor-instances-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector instance-ids dry-run-request]}]],
    :doc "Generate map for monitorInstances"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :monitor-instances,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   monitor-instances
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector instance-ids dry-run-request]}]],
    :doc "Call monitorInstances"}
   [credentials5859 & args5860]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5861
     (com.palletops.awaze.common/aws-client :ec2 credentials5859)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5861
      monitorInstances
      (monitor-instances-request (clojure.core/nth args5860 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-listings
   [m5862]
   (clojure.core/let
    [credentials5863 (:credentials m5862) args5864 (:args m5862)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5865
      (com.palletops.awaze.common/aws-client :ec2 credentials5863)]
     (clojure.core/case
      (clojure.core/count args5864)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5865
        describeReservedInstancesListings))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5865
        describeReservedInstancesListings
        (describe-reserved-instances-listings-request
         (clojure.core/nth args5864 0))))))))
  (clojure.core/defn
   describe-reserved-instances-listings-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [reserved-instances-listing-id
         reserved-instances-id
         request-metric-collector
         filters]}]],
    :doc
    "Generate map for describeReservedInstancesListings, describeReservedInstancesListings"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances-listings,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances-listings,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-reserved-instances-listings
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [reserved-instances-listing-id
         reserved-instances-id
         request-metric-collector
         filters]}]],
    :doc
    "Call describeReservedInstancesListings, describeReservedInstancesListings"}
   [credentials5867 & args5868]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5869
     (com.palletops.awaze.common/aws-client :ec2 credentials5867)]
    (clojure.core/case
     (clojure.core/count args5868)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5869
       describeReservedInstancesListings))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5869
       describeReservedInstancesListings
       (describe-reserved-instances-listings-request
        (clojure.core/nth args5868 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-tags
   [m5870]
   (clojure.core/let
    [credentials5871 (:credentials m5870) args5872 (:args m5870)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5873
      (com.palletops.awaze.common/aws-client :ec2 credentials5871)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5873
       createTags
       (create-tags-request (clojure.core/nth args5872 0)))))))
  (clojure.core/defn
   create-tags-map
   {:arglists
    '[[credentials
       {:keys
        [tags resources request-metric-collector dry-run-request]}]],
    :doc "Generate map for createTags"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-tags,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-tags
   {:arglists
    '[[credentials
       {:keys
        [tags resources request-metric-collector dry-run-request]}]],
    :doc "Call createTags"}
   [credentials5875 & args5876]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5877
     (com.palletops.awaze.common/aws-client :ec2 credentials5875)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5877
      createTags
      (create-tags-request (clojure.core/nth args5876 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :confirm-product-instance
   [m5878]
   (clojure.core/let
    [credentials5879 (:credentials m5878) args5880 (:args m5878)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5881
      (com.palletops.awaze.common/aws-client :ec2 credentials5879)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5881
       confirmProductInstance
       (confirm-product-instance-request
        (clojure.core/nth args5880 0)))))))
  (clojure.core/defn
   confirm-product-instance-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         product-code
         instance-id
         dry-run-request]}]],
    :doc "Generate map for confirmProductInstance"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :confirm-product-instance,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   confirm-product-instance
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         product-code
         instance-id
         dry-run-request]}]],
    :doc "Call confirmProductInstance"}
   [credentials5883 & args5884]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5885
     (com.palletops.awaze.common/aws-client :ec2 credentials5883)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5885
      confirmProductInstance
      (confirm-product-instance-request
       (clojure.core/nth args5884 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-route-table
   [m5886]
   (clojure.core/let
    [credentials5887 (:credentials m5886) args5888 (:args m5886)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5889
      (com.palletops.awaze.common/aws-client :ec2 credentials5887)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5889
       disassociateRouteTable
       (disassociate-route-table-request
        (clojure.core/nth args5888 0)))))))
  (clojure.core/defn
   disassociate-route-table-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector dry-run-request association-id]}]],
    :doc "Generate map for disassociateRouteTable"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :disassociate-route-table,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   disassociate-route-table
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector dry-run-request association-id]}]],
    :doc "Call disassociateRouteTable"}
   [credentials5891 & args5892]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5893
     (com.palletops.awaze.common/aws-client :ec2 credentials5891)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5893
      disassociateRouteTable
      (disassociate-route-table-request
       (clojure.core/nth args5892 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-address
   [m5894]
   (clojure.core/let
    [credentials5895 (:credentials m5894) args5896 (:args m5894)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5897
      (com.palletops.awaze.common/aws-client :ec2 credentials5895)]
     (clojure.core/case
      (clojure.core/count args5896)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5897
        disassociateAddress
        (disassociate-address-request (clojure.core/nth args5896 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5897
        disassociateAddress))))))
  (clojure.core/defn
   disassociate-address-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         public-ip
         dry-run-request
         association-id]}]
      [credentials]],
    :doc "Generate map for disassociateAddress, disassociateAddress"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :disassociate-address,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :disassociate-address,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   disassociate-address
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         public-ip
         dry-run-request
         association-id]}]
      [credentials]],
    :doc "Call disassociateAddress, disassociateAddress"}
   [credentials5899 & args5900]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5901
     (com.palletops.awaze.common/aws-client :ec2 credentials5899)]
    (clojure.core/case
     (clojure.core/count args5900)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5901
       disassociateAddress
       (disassociate-address-request (clojure.core/nth args5900 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5901
       disassociateAddress))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-network-interface
   [m5902]
   (clojure.core/let
    [credentials5903 (:credentials m5902) args5904 (:args m5902)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5905
      (com.palletops.awaze.common/aws-client :ec2 credentials5903)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5905
       detachNetworkInterface
       (detach-network-interface-request
        (clojure.core/nth args5904 0)))))))
  (clojure.core/defn
   detach-network-interface-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         force
         dry-run-request
         attachment-id]}]],
    :doc "Generate map for detachNetworkInterface"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-network-interface,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   detach-network-interface
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         force
         dry-run-request
         attachment-id]}]],
    :doc "Call detachNetworkInterface"}
   [credentials5907 & args5908]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5909
     (com.palletops.awaze.common/aws-client :ec2 credentials5907)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5909
      detachNetworkInterface
      (detach-network-interface-request
       (clojure.core/nth args5908 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-export-tasks
   [m5910]
   (clojure.core/let
    [credentials5911 (:credentials m5910) args5912 (:args m5910)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5913
      (com.palletops.awaze.common/aws-client :ec2 credentials5911)]
     (clojure.core/case
      (clojure.core/count args5912)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5913
        describeExportTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5913
        describeExportTasks
        (describe-export-tasks-request
         (clojure.core/nth args5912 0))))))))
  (clojure.core/defn
   describe-export-tasks-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys [request-metric-collector export-task-ids]}]],
    :doc "Generate map for describeExportTasks, describeExportTasks"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-export-tasks,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-export-tasks,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-export-tasks
   {:arglists
    '[[credentials]
      [credentials
       {:keys [request-metric-collector export-task-ids]}]],
    :doc "Call describeExportTasks, describeExportTasks"}
   [credentials5915 & args5916]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5917
     (com.palletops.awaze.common/aws-client :ec2 credentials5915)]
    (clojure.core/case
     (clojure.core/count args5916)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5917
       describeExportTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5917
       describeExportTasks
       (describe-export-tasks-request
        (clojure.core/nth args5916 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-addresses
   [m5918]
   (clojure.core/let
    [credentials5919 (:credentials m5918) args5920 (:args m5918)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5921
      (com.palletops.awaze.common/aws-client :ec2 credentials5919)]
     (clojure.core/case
      (clojure.core/count args5920)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5921
        describeAddresses
        (describe-addresses-request (clojure.core/nth args5920 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client5921
        describeAddresses))))))
  (clojure.core/defn
   describe-addresses-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         public-ips
         filters
         dry-run-request
         allocation-ids]}]
      [credentials]],
    :doc "Generate map for describeAddresses, describeAddresses"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-addresses,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-addresses,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-addresses
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         public-ips
         filters
         dry-run-request
         allocation-ids]}]
      [credentials]],
    :doc "Call describeAddresses, describeAddresses"}
   [credentials5923 & args5924]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5925
     (com.palletops.awaze.common/aws-client :ec2 credentials5923)]
    (clojure.core/case
     (clojure.core/count args5924)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5925
       describeAddresses
       (describe-addresses-request (clojure.core/nth args5924 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5925
       describeAddresses))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-instance-export-task
   [m5926]
   (clojure.core/let
    [credentials5927 (:credentials m5926) args5928 (:args m5926)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5929
      (com.palletops.awaze.common/aws-client :ec2 credentials5927)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5929
       createInstanceExportTask
       (create-instance-export-task-request
        (clojure.core/nth args5928 0)))))))
  (clojure.core/defn
   create-instance-export-task-map
   {:arglists
    '[[credentials
       {:keys
        [target-environment
         request-metric-collector
         instance-id
         export-to-s3task
         description]}]],
    :doc "Generate map for createInstanceExportTask"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-instance-export-task,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-instance-export-task
   {:arglists
    '[[credentials
       {:keys
        [target-environment
         request-metric-collector
         instance-id
         export-to-s3task
         description]}]],
    :doc "Call createInstanceExportTask"}
   [credentials5931 & args5932]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5933
     (com.palletops.awaze.common/aws-client :ec2 credentials5931)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5933
      createInstanceExportTask
      (create-instance-export-task-request
       (clojure.core/nth args5932 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-image
   [m5934]
   (clojure.core/let
    [credentials5935 (:credentials m5934) args5936 (:args m5934)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5937
      (com.palletops.awaze.common/aws-client :ec2 credentials5935)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5937
       createImage
       (create-image-request (clojure.core/nth args5936 0)))))))
  (clojure.core/defn
   create-image-map
   {:arglists
    '[[credentials
       {:keys
        [description
         block-device-mappings
         dry-run-request
         name
         instance-id
         no-reboot
         request-metric-collector]}]],
    :doc "Generate map for createImage"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-image,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-image
   {:arglists
    '[[credentials
       {:keys
        [description
         block-device-mappings
         dry-run-request
         name
         instance-id
         no-reboot
         request-metric-collector]}]],
    :doc "Call createImage"}
   [credentials5939 & args5940]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5941
     (com.palletops.awaze.common/aws-client :ec2 credentials5939)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5941
      createImage
      (create-image-request (clojure.core/nth args5940 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-security-group
   [m5942]
   (clojure.core/let
    [credentials5943 (:credentials m5942) args5944 (:args m5942)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5945
      (com.palletops.awaze.common/aws-client :ec2 credentials5943)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5945
       createSecurityGroup
       (create-security-group-request
        (clojure.core/nth args5944 0)))))))
  (clojure.core/defn
   create-security-group-map
   {:arglists
    '[[credentials
       {:keys
        [vpc-id
         request-metric-collector
         group-name
         dry-run-request
         description]}]],
    :doc "Generate map for createSecurityGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-security-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-security-group
   {:arglists
    '[[credentials
       {:keys
        [vpc-id
         request-metric-collector
         group-name
         dry-run-request
         description]}]],
    :doc "Call createSecurityGroup"}
   [credentials5947 & args5948]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5949
     (com.palletops.awaze.common/aws-client :ec2 credentials5947)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5949
      createSecurityGroup
      (create-security-group-request
       (clojure.core/nth args5948 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-subnet
   [m5950]
   (clojure.core/let
    [credentials5951 (:credentials m5950) args5952 (:args m5950)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5953
      (com.palletops.awaze.common/aws-client :ec2 credentials5951)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5953
       createSubnet
       (create-subnet-request (clojure.core/nth args5952 0)))))))
  (clojure.core/defn
   create-subnet-map
   {:arglists
    '[[credentials
       {:keys
        [vpc-id
         request-metric-collector
         dry-run-request
         cidr-block
         availability-zone]}]],
    :doc "Generate map for createSubnet"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-subnet,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-subnet
   {:arglists
    '[[credentials
       {:keys
        [vpc-id
         request-metric-collector
         dry-run-request
         cidr-block
         availability-zone]}]],
    :doc "Call createSubnet"}
   [credentials5955 & args5956]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5957
     (com.palletops.awaze.common/aws-client :ec2 credentials5955)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5957
      createSubnet
      (create-subnet-request (clojure.core/nth args5956 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl
   [m5958]
   (clojure.core/let
    [credentials5959 (:credentials m5958) args5960 (:args m5958)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5961
      (com.palletops.awaze.common/aws-client :ec2 credentials5959)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5961
       deleteNetworkAcl
       (delete-network-acl-request (clojure.core/nth args5960 0)))))))
  (clojure.core/defn
   delete-network-acl-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector network-acl-id dry-run-request]}]],
    :doc "Generate map for deleteNetworkAcl"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-network-acl,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-network-acl
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector network-acl-id dry-run-request]}]],
    :doc "Call deleteNetworkAcl"}
   [credentials5963 & args5964]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5965
     (com.palletops.awaze.common/aws-client :ec2 credentials5963)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5965
      deleteNetworkAcl
      (delete-network-acl-request (clojure.core/nth args5964 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-interface
   [m5966]
   (clojure.core/let
    [credentials5967 (:credentials m5966) args5968 (:args m5966)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5969
      (com.palletops.awaze.common/aws-client :ec2 credentials5967)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5969
       createNetworkInterface
       (create-network-interface-request
        (clojure.core/nth args5968 0)))))))
  (clojure.core/defn
   create-network-interface-map
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         request-metric-collector
         secondary-private-ip-address-count
         subnet-id
         private-ip-address
         groups
         private-ip-addresses
         description]}]],
    :doc "Generate map for createNetworkInterface"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-network-interface,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-network-interface
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         request-metric-collector
         secondary-private-ip-address-count
         subnet-id
         private-ip-address
         groups
         private-ip-addresses
         description]}]],
    :doc "Call createNetworkInterface"}
   [credentials5971 & args5972]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5973
     (com.palletops.awaze.common/aws-client :ec2 credentials5971)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5973
      createNetworkInterface
      (create-network-interface-request
       (clojure.core/nth args5972 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-gateway
   [m5974]
   (clojure.core/let
    [credentials5975 (:credentials m5974) args5976 (:args m5974)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5977
      (com.palletops.awaze.common/aws-client :ec2 credentials5975)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5977
       deleteVpnGateway
       (delete-vpn-gateway-request (clojure.core/nth args5976 0)))))))
  (clojure.core/defn
   delete-vpn-gateway-map
   {:arglists
    '[[credentials
       {:keys
        [vpn-gateway-id request-metric-collector dry-run-request]}]],
    :doc "Generate map for deleteVpnGateway"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpn-gateway,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-vpn-gateway
   {:arglists
    '[[credentials
       {:keys
        [vpn-gateway-id request-metric-collector dry-run-request]}]],
    :doc "Call deleteVpnGateway"}
   [credentials5979 & args5980]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5981
     (com.palletops.awaze.common/aws-client :ec2 credentials5979)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5981
      deleteVpnGateway
      (delete-vpn-gateway-request (clojure.core/nth args5980 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-volume
   [m5982]
   (clojure.core/let
    [credentials5983 (:credentials m5982) args5984 (:args m5982)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5985
      (com.palletops.awaze.common/aws-client :ec2 credentials5983)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5985
       attachVolume
       (attach-volume-request (clojure.core/nth args5984 0)))))))
  (clojure.core/defn
   attach-volume-map
   {:arglists
    '[[credentials
       {:keys
        [volume-id
         request-metric-collector
         instance-id
         dry-run-request
         device]}]],
    :doc "Generate map for attachVolume"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-volume,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   attach-volume
   {:arglists
    '[[credentials
       {:keys
        [volume-id
         request-metric-collector
         instance-id
         dry-run-request
         device]}]],
    :doc "Call attachVolume"}
   [credentials5987 & args5988]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5989
     (com.palletops.awaze.common/aws-client :ec2 credentials5987)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5989
      attachVolume
      (attach-volume-request (clojure.core/nth args5988 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection
   [m5990]
   (clojure.core/let
    [credentials5991 (:credentials m5990) args5992 (:args m5990)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client5993
      (com.palletops.awaze.common/aws-client :ec2 credentials5991)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client5993
       createVpnConnection
       (create-vpn-connection-request
        (clojure.core/nth args5992 0)))))))
  (clojure.core/defn
   create-vpn-connection-map
   {:arglists
    '[[credentials
       {:keys
        [vpn-gateway-id
         type
         request-metric-collector
         options
         dry-run-request
         customer-gateway-id]}]],
    :doc "Generate map for createVpnConnection"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpn-connection,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-vpn-connection
   {:arglists
    '[[credentials
       {:keys
        [vpn-gateway-id
         type
         request-metric-collector
         options
         dry-run-request
         customer-gateway-id]}]],
    :doc "Call createVpnConnection"}
   [credentials5995 & args5996]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client5997
     (com.palletops.awaze.common/aws-client :ec2 credentials5995)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client5997
      createVpnConnection
      (create-vpn-connection-request
       (clojure.core/nth args5996 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-placement-group
   [m5998]
   (clojure.core/let
    [credentials5999 (:credentials m5998) args6000 (:args m5998)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6001
      (com.palletops.awaze.common/aws-client :ec2 credentials5999)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6001
       deletePlacementGroup
       (delete-placement-group-request
        (clojure.core/nth args6000 0)))))))
  (clojure.core/defn
   delete-placement-group-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector group-name dry-run-request]}]],
    :doc "Generate map for deletePlacementGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-placement-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-placement-group
   {:arglists
    '[[credentials
       {:keys [request-metric-collector group-name dry-run-request]}]],
    :doc "Call deletePlacementGroup"}
   [credentials6003 & args6004]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6005
     (com.palletops.awaze.common/aws-client :ec2 credentials6003)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6005
      deletePlacementGroup
      (delete-placement-group-request
       (clojure.core/nth args6004 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-instance-attribute
   [m6006]
   (clojure.core/let
    [credentials6007 (:credentials m6006) args6008 (:args m6006)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6009
      (com.palletops.awaze.common/aws-client :ec2 credentials6007)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6009
       resetInstanceAttribute
       (reset-instance-attribute-request
        (clojure.core/nth args6008 0)))))))
  (clojure.core/defn
   reset-instance-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         instance-id
         dry-run-request
         attribute]}]],
    :doc "Generate map for resetInstanceAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-instance-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   reset-instance-attribute
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         instance-id
         dry-run-request
         attribute]}]],
    :doc "Call resetInstanceAttribute"}
   [credentials6011 & args6012]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6013
     (com.palletops.awaze.common/aws-client :ec2 credentials6011)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6013
      resetInstanceAttribute
      (reset-instance-attribute-request
       (clojure.core/nth args6012 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-snapshot
   [m6014]
   (clojure.core/let
    [credentials6015 (:credentials m6014) args6016 (:args m6014)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6017
      (com.palletops.awaze.common/aws-client :ec2 credentials6015)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6017
       createSnapshot
       (create-snapshot-request (clojure.core/nth args6016 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists
    '[[credentials
       {:keys
        [volume-id
         request-metric-collector
         dry-run-request
         description]}]],
    :doc "Generate map for createSnapshot"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-snapshot,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-snapshot
   {:arglists
    '[[credentials
       {:keys
        [volume-id
         request-metric-collector
         dry-run-request
         description]}]],
    :doc "Call createSnapshot"}
   [credentials6019 & args6020]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6021
     (com.palletops.awaze.common/aws-client :ec2 credentials6019)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6021
      createSnapshot
      (create-snapshot-request (clojure.core/nth args6020 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :request-spot-instances
   [m6022]
   (clojure.core/let
    [credentials6023 (:credentials m6022) args6024 (:args m6022)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6025
      (com.palletops.awaze.common/aws-client :ec2 credentials6023)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6025
       requestSpotInstances
       (request-spot-instances-request
        (clojure.core/nth args6024 0)))))))
  (clojure.core/defn
   request-spot-instances-map
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         request-metric-collector
         valid-from
         spot-price
         launch-group
         instance-count
         launch-specification
         type
         availability-zone-group
         valid-until]}]],
    :doc "Generate map for requestSpotInstances"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :request-spot-instances,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   request-spot-instances
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         request-metric-collector
         valid-from
         spot-price
         launch-group
         instance-count
         launch-specification
         type
         availability-zone-group
         valid-until]}]],
    :doc "Call requestSpotInstances"}
   [credentials6027 & args6028]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6029
     (com.palletops.awaze.common/aws-client :ec2 credentials6027)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6029
      requestSpotInstances
      (request-spot-instances-request
       (clojure.core/nth args6028 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interfaces
   [m6030]
   (clojure.core/let
    [credentials6031 (:credentials m6030) args6032 (:args m6030)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6033
      (com.palletops.awaze.common/aws-client :ec2 credentials6031)]
     (clojure.core/case
      (clojure.core/count args6032)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6033
        describeNetworkInterfaces))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6033
        describeNetworkInterfaces
        (describe-network-interfaces-request
         (clojure.core/nth args6032 0))))))))
  (clojure.core/defn
   describe-network-interfaces-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         network-interface-ids
         filters
         dry-run-request]}]],
    :doc
    "Generate map for describeNetworkInterfaces, describeNetworkInterfaces"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-network-interfaces,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-network-interfaces,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-network-interfaces
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         network-interface-ids
         filters
         dry-run-request]}]],
    :doc "Call describeNetworkInterfaces, describeNetworkInterfaces"}
   [credentials6035 & args6036]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6037
     (com.palletops.awaze.common/aws-client :ec2 credentials6035)]
    (clojure.core/case
     (clojure.core/count args6036)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6037
       describeNetworkInterfaces))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6037
       describeNetworkInterfaces
       (describe-network-interfaces-request
        (clojure.core/nth args6036 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-volume
   [m6038]
   (clojure.core/let
    [credentials6039 (:credentials m6038) args6040 (:args m6038)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6041
      (com.palletops.awaze.common/aws-client :ec2 credentials6039)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6041
       deleteVolume
       (delete-volume-request (clojure.core/nth args6040 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists
    '[[credentials
       {:keys [volume-id request-metric-collector dry-run-request]}]],
    :doc "Generate map for deleteVolume"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-volume,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-volume
   {:arglists
    '[[credentials
       {:keys [volume-id request-metric-collector dry-run-request]}]],
    :doc "Call deleteVolume"}
   [credentials6043 & args6044]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6045
     (com.palletops.awaze.common/aws-client :ec2 credentials6043)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6045
      deleteVolume
      (delete-volume-request (clojure.core/nth args6044 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-snapshot
   [m6046]
   (clojure.core/let
    [credentials6047 (:credentials m6046) args6048 (:args m6046)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6049
      (com.palletops.awaze.common/aws-client :ec2 credentials6047)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6049
       deleteSnapshot
       (delete-snapshot-request (clojure.core/nth args6048 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists
    '[[credentials
       {:keys
        [snapshot-id request-metric-collector dry-run-request]}]],
    :doc "Generate map for deleteSnapshot"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-snapshot,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-snapshot
   {:arglists
    '[[credentials
       {:keys
        [snapshot-id request-metric-collector dry-run-request]}]],
    :doc "Call deleteSnapshot"}
   [credentials6051 & args6052]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6053
     (com.palletops.awaze.common/aws-client :ec2 credentials6051)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6053
      deleteSnapshot
      (delete-snapshot-request (clojure.core/nth args6052 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instances
   [m6054]
   (clojure.core/let
    [credentials6055 (:credentials m6054) args6056 (:args m6054)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6057
      (com.palletops.awaze.common/aws-client :ec2 credentials6055)]
     (clojure.core/case
      (clojure.core/count args6056)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6057
        describeInstances
        (describe-instances-request (clojure.core/nth args6056 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6057
        describeInstances))))))
  (clojure.core/defn
   describe-instances-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         instance-ids
         filters
         dry-run-request]}]
      [credentials]],
    :doc "Generate map for describeInstances, describeInstances"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-instances,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-instances,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-instances
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         instance-ids
         filters
         dry-run-request]}]
      [credentials]],
    :doc "Call describeInstances, describeInstances"}
   [credentials6059 & args6060]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6061
     (com.palletops.awaze.common/aws-client :ec2 credentials6059)]
    (clojure.core/case
     (clojure.core/count args6060)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6061
       describeInstances
       (describe-instances-request (clojure.core/nth args6060 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6061
       describeInstances))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-route-table
   [m6062]
   (clojure.core/let
    [credentials6063 (:credentials m6062) args6064 (:args m6062)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6065
      (com.palletops.awaze.common/aws-client :ec2 credentials6063)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6065
       associateRouteTable
       (associate-route-table-request
        (clojure.core/nth args6064 0)))))))
  (clojure.core/defn
   associate-route-table-map
   {:arglists
    '[[credentials
       {:keys
        [subnet-id
         route-table-id
         request-metric-collector
         dry-run-request]}]],
    :doc "Generate map for associateRouteTable"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :associate-route-table,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   associate-route-table
   {:arglists
    '[[credentials
       {:keys
        [subnet-id
         route-table-id
         request-metric-collector
         dry-run-request]}]],
    :doc "Call associateRouteTable"}
   [credentials6067 & args6068]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6069
     (com.palletops.awaze.common/aws-client :ec2 credentials6067)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6069
      associateRouteTable
      (associate-route-table-request
       (clojure.core/nth args6068 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vgw-route-propagation
   [m6070]
   (clojure.core/let
    [credentials6071 (:credentials m6070) args6072 (:args m6070)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6073
      (com.palletops.awaze.common/aws-client :ec2 credentials6071)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6073
       disableVgwRoutePropagation
       (disable-vgw-route-propagation-request
        (clojure.core/nth args6072 0)))))))
  (clojure.core/defn
   disable-vgw-route-propagation-map
   {:arglists
    '[[credentials
       {:keys [route-table-id request-metric-collector gateway-id]}]],
    :doc "Generate map for disableVgwRoutePropagation"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :disable-vgw-route-propagation,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   disable-vgw-route-propagation
   {:arglists
    '[[credentials
       {:keys [route-table-id request-metric-collector gateway-id]}]],
    :doc "Call disableVgwRoutePropagation"}
   [credentials6075 & args6076]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6077
     (com.palletops.awaze.common/aws-client :ec2 credentials6075)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6077
      disableVgwRoutePropagation
      (disable-vgw-route-propagation-request
       (clojure.core/nth args6076 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-attribute
   [m6078]
   (clojure.core/let
    [credentials6079 (:credentials m6078) args6080 (:args m6078)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6081
      (com.palletops.awaze.common/aws-client :ec2 credentials6079)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6081
       describeInstanceAttribute
       (describe-instance-attribute-request
        (clojure.core/nth args6080 0)))))))
  (clojure.core/defn
   describe-instance-attribute-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         instance-id
         dry-run-request
         attribute]}]],
    :doc "Generate map for describeInstanceAttribute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-instance-attribute,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-instance-attribute
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         instance-id
         dry-run-request
         attribute]}]],
    :doc "Call describeInstanceAttribute"}
   [credentials6083 & args6084]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6085
     (com.palletops.awaze.common/aws-client :ec2 credentials6083)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6085
      describeInstanceAttribute
      (describe-instance-attribute-request
       (clojure.core/nth args6084 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-gateway
   [m6086]
   (clojure.core/let
    [credentials6087 (:credentials m6086) args6088 (:args m6086)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6089
      (com.palletops.awaze.common/aws-client :ec2 credentials6087)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6089
       createVpnGateway
       (create-vpn-gateway-request (clojure.core/nth args6088 0)))))))
  (clojure.core/defn
   create-vpn-gateway-map
   {:arglists
    '[[credentials
       {:keys
        [type
         request-metric-collector
         dry-run-request
         availability-zone]}]],
    :doc "Generate map for createVpnGateway"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpn-gateway,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-vpn-gateway
   {:arglists
    '[[credentials
       {:keys
        [type
         request-metric-collector
         dry-run-request
         availability-zone]}]],
    :doc "Call createVpnGateway"}
   [credentials6091 & args6092]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6093
     (com.palletops.awaze.common/aws-client :ec2 credentials6091)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6093
      createVpnGateway
      (create-vpn-gateway-request (clojure.core/nth args6092 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl
   [m6094]
   (clojure.core/let
    [credentials6095 (:credentials m6094) args6096 (:args m6094)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6097
      (com.palletops.awaze.common/aws-client :ec2 credentials6095)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6097
       createNetworkAcl
       (create-network-acl-request (clojure.core/nth args6096 0)))))))
  (clojure.core/defn
   create-network-acl-map
   {:arglists
    '[[credentials
       {:keys [vpc-id request-metric-collector dry-run-request]}]],
    :doc "Generate map for createNetworkAcl"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-network-acl,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-network-acl
   {:arglists
    '[[credentials
       {:keys [vpc-id request-metric-collector dry-run-request]}]],
    :doc "Call createNetworkAcl"}
   [credentials6099 & args6100]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6101
     (com.palletops.awaze.common/aws-client :ec2 credentials6099)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6101
      createNetworkAcl
      (create-network-acl-request (clojure.core/nth args6100 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route
   [m6102]
   (clojure.core/let
    [credentials6103 (:credentials m6102) args6104 (:args m6102)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6105
      (com.palletops.awaze.common/aws-client :ec2 credentials6103)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6105
       replaceRoute
       (replace-route-request (clojure.core/nth args6104 0)))))))
  (clojure.core/defn
   replace-route-map
   {:arglists
    '[[credentials
       {:keys
        [network-interface-id
         route-table-id
         dry-run-request
         destination-cidr-block
         instance-id
         request-metric-collector
         gateway-id]}]],
    :doc "Generate map for replaceRoute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-route,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   replace-route
   {:arglists
    '[[credentials
       {:keys
        [network-interface-id
         route-table-id
         dry-run-request
         destination-cidr-block
         instance-id
         request-metric-collector
         gateway-id]}]],
    :doc "Call replaceRoute"}
   [credentials6107 & args6108]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6109
     (com.palletops.awaze.common/aws-client :ec2 credentials6107)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6109
      replaceRoute
      (replace-route-request (clojure.core/nth args6108 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-regions
   [m6110]
   (clojure.core/let
    [credentials6111 (:credentials m6110) args6112 (:args m6110)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6113
      (com.palletops.awaze.common/aws-client :ec2 credentials6111)]
     (clojure.core/case
      (clojure.core/count args6112)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6113
        describeRegions
        (describe-regions-request (clojure.core/nth args6112 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6113
        describeRegions))))))
  (clojure.core/defn
   describe-regions-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         region-names
         filters
         dry-run-request]}]
      [credentials]],
    :doc "Generate map for describeRegions, describeRegions"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-regions,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-regions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-regions
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         region-names
         filters
         dry-run-request]}]
      [credentials]],
    :doc "Call describeRegions, describeRegions"}
   [credentials6115 & args6116]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6117
     (com.palletops.awaze.common/aws-client :ec2 credentials6115)]
    (clojure.core/case
     (clojure.core/count args6116)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6117
       describeRegions
       (describe-regions-request (clojure.core/nth args6116 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6117
       describeRegions))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-internet-gateway
   [m6118]
   (clojure.core/let
    [credentials6119 (:credentials m6118) args6120 (:args m6118)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6121
      (com.palletops.awaze.common/aws-client :ec2 credentials6119)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6121
       deleteInternetGateway
       (delete-internet-gateway-request
        (clojure.core/nth args6120 0)))))))
  (clojure.core/defn
   delete-internet-gateway-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         internet-gateway-id
         dry-run-request]}]],
    :doc "Generate map for deleteInternetGateway"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-internet-gateway,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-internet-gateway
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         internet-gateway-id
         dry-run-request]}]],
    :doc "Call deleteInternetGateway"}
   [credentials6123 & args6124]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6125
     (com.palletops.awaze.common/aws-client :ec2 credentials6123)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6125
      deleteInternetGateway
      (delete-internet-gateway-request
       (clojure.core/nth args6124 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route
   [m6126]
   (clojure.core/let
    [credentials6127 (:credentials m6126) args6128 (:args m6126)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6129
      (com.palletops.awaze.common/aws-client :ec2 credentials6127)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6129
       deleteRoute
       (delete-route-request (clojure.core/nth args6128 0)))))))
  (clojure.core/defn
   delete-route-map
   {:arglists
    '[[credentials
       {:keys
        [route-table-id
         request-metric-collector
         dry-run-request
         destination-cidr-block]}]],
    :doc "Generate map for deleteRoute"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-route,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-route
   {:arglists
    '[[credentials
       {:keys
        [route-table-id
         request-metric-collector
         dry-run-request
         destination-cidr-block]}]],
    :doc "Call deleteRoute"}
   [credentials6131 & args6132]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6133
     (com.palletops.awaze.common/aws-client :ec2 credentials6131)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6133
      deleteRoute
      (delete-route-request (clojure.core/nth args6132 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :assign-private-ip-addresses
   [m6134]
   (clojure.core/let
    [credentials6135 (:credentials m6134) args6136 (:args m6134)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6137
      (com.palletops.awaze.common/aws-client :ec2 credentials6135)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6137
       assignPrivateIpAddresses
       (assign-private-ip-addresses-request
        (clojure.core/nth args6136 0)))))))
  (clojure.core/defn
   assign-private-ip-addresses-map
   {:arglists
    '[[credentials
       {:keys
        [secondary-private-ip-address-count
         request-metric-collector
         private-ip-addresses
         network-interface-id
         allow-reassignment]}]],
    :doc "Generate map for assignPrivateIpAddresses"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :assign-private-ip-addresses,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   assign-private-ip-addresses
   {:arglists
    '[[credentials
       {:keys
        [secondary-private-ip-address-count
         request-metric-collector
         private-ip-addresses
         network-interface-id
         allow-reassignment]}]],
    :doc "Call assignPrivateIpAddresses"}
   [credentials6139 & args6140]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6141
     (com.palletops.awaze.common/aws-client :ec2 credentials6139)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6141
      assignPrivateIpAddresses
      (assign-private-ip-addresses-request
       (clojure.core/nth args6140 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-dhcp-options
   [m6142]
   (clojure.core/let
    [credentials6143 (:credentials m6142) args6144 (:args m6142)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6145
      (com.palletops.awaze.common/aws-client :ec2 credentials6143)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6145
       deleteDhcpOptions
       (delete-dhcp-options-request (clojure.core/nth args6144 0)))))))
  (clojure.core/defn
   delete-dhcp-options-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector dry-run-request dhcp-options-id]}]],
    :doc "Generate map for deleteDhcpOptions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-dhcp-options,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-dhcp-options
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector dry-run-request dhcp-options-id]}]],
    :doc "Call deleteDhcpOptions"}
   [credentials6147 & args6148]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6149
     (com.palletops.awaze.common/aws-client :ec2 credentials6147)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6149
      deleteDhcpOptions
      (delete-dhcp-options-request (clojure.core/nth args6148 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-spot-instance-requests
   [m6150]
   (clojure.core/let
    [credentials6151 (:credentials m6150) args6152 (:args m6150)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6153
      (com.palletops.awaze.common/aws-client :ec2 credentials6151)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6153
       cancelSpotInstanceRequests
       (cancel-spot-instance-requests-request
        (clojure.core/nth args6152 0)))))))
  (clojure.core/defn
   cancel-spot-instance-requests-map
   {:arglists
    '[[credentials
       {:keys
        [spot-instance-request-ids
         request-metric-collector
         dry-run-request]}]],
    :doc "Generate map for cancelSpotInstanceRequests"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-spot-instance-requests,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   cancel-spot-instance-requests
   {:arglists
    '[[credentials
       {:keys
        [spot-instance-request-ids
         request-metric-collector
         dry-run-request]}]],
    :doc "Call cancelSpotInstanceRequests"}
   [credentials6155 & args6156]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6157
     (com.palletops.awaze.common/aws-client :ec2 credentials6155)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6157
      cancelSpotInstanceRequests
      (cancel-spot-instance-requests-request
       (clojure.core/nth args6156 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-dhcp-options
   [m6158]
   (clojure.core/let
    [credentials6159 (:credentials m6158) args6160 (:args m6158)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6161
      (com.palletops.awaze.common/aws-client :ec2 credentials6159)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6161
       createDhcpOptions
       (create-dhcp-options-request (clojure.core/nth args6160 0)))))))
  (clojure.core/defn
   create-dhcp-options-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         dry-run-request
         dhcp-configurations]}]],
    :doc "Generate map for createDhcpOptions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-dhcp-options,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-dhcp-options
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         dry-run-request
         dhcp-configurations]}]],
    :doc "Call createDhcpOptions"}
   [credentials6163 & args6164]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6165
     (com.palletops.awaze.common/aws-client :ec2 credentials6163)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6165
      createDhcpOptions
      (create-dhcp-options-request (clojure.core/nth args6164 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :stop-instances
   [m6166]
   (clojure.core/let
    [credentials6167 (:credentials m6166) args6168 (:args m6166)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6169
      (com.palletops.awaze.common/aws-client :ec2 credentials6167)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6169
       stopInstances
       (stop-instances-request (clojure.core/nth args6168 0)))))))
  (clojure.core/defn
   stop-instances-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         instance-ids
         force
         dry-run-request]}]],
    :doc "Generate map for stopInstances"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :stop-instances,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   stop-instances
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         instance-ids
         force
         dry-run-request]}]],
    :doc "Call stopInstances"}
   [credentials6171 & args6172]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6173
     (com.palletops.awaze.common/aws-client :ec2 credentials6171)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6173
      stopInstances
      (stop-instances-request (clojure.core/nth args6172 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-ingress
   [m6174]
   (clojure.core/let
    [credentials6175 (:credentials m6174) args6176 (:args m6174)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6177
      (com.palletops.awaze.common/aws-client :ec2 credentials6175)]
     (clojure.core/case
      (clojure.core/count args6176)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6177
        authorizeSecurityGroupIngress
        (authorize-security-group-ingress-request
         (clojure.core/nth args6176 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6177
        authorizeSecurityGroupIngress))))))
  (clojure.core/defn
   authorize-security-group-ingress-map
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         source-security-group-name
         request-metric-collector
         group-id
         from-port
         ip-permissions
         to-port
         cidr-ip
         ip-protocol
         source-security-group-owner-id
         group-name]}]
      [credentials]],
    :doc
    "Generate map for authorizeSecurityGroupIngress, authorizeSecurityGroupIngress"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :authorize-security-group-ingress,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :authorize-security-group-ingress,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   authorize-security-group-ingress
   {:arglists
    '[[credentials
       {:keys
        [dry-run-request
         source-security-group-name
         request-metric-collector
         group-id
         from-port
         ip-permissions
         to-port
         cidr-ip
         ip-protocol
         source-security-group-owner-id
         group-name]}]
      [credentials]],
    :doc
    "Call authorizeSecurityGroupIngress, authorizeSecurityGroupIngress"}
   [credentials6179 & args6180]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6181
     (com.palletops.awaze.common/aws-client :ec2 credentials6179)]
    (clojure.core/case
     (clojure.core/count args6180)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6181
       authorizeSecurityGroupIngress
       (authorize-security-group-ingress-request
        (clojure.core/nth args6180 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6181
       authorizeSecurityGroupIngress))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-placement-groups
   [m6182]
   (clojure.core/let
    [credentials6183 (:credentials m6182) args6184 (:args m6182)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6185
      (com.palletops.awaze.common/aws-client :ec2 credentials6183)]
     (clojure.core/case
      (clojure.core/count args6184)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6185
        describePlacementGroups
        (describe-placement-groups-request
         (clojure.core/nth args6184 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6185
        describePlacementGroups))))))
  (clojure.core/defn
   describe-placement-groups-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         group-names
         filters
         dry-run-request]}]
      [credentials]],
    :doc
    "Generate map for describePlacementGroups, describePlacementGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-placement-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-placement-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-placement-groups
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         group-names
         filters
         dry-run-request]}]
      [credentials]],
    :doc "Call describePlacementGroups, describePlacementGroups"}
   [credentials6187 & args6188]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6189
     (com.palletops.awaze.common/aws-client :ec2 credentials6187)]
    (clojure.core/case
     (clojure.core/count args6188)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6189
       describePlacementGroups
       (describe-placement-groups-request
        (clojure.core/nth args6188 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6189
       describePlacementGroups)))))))
