(ns com.palletops.awaze.directconnect (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :directconnect
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.directconnect.AmazonDirectConnectClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.RouteFilterPrefix route-filter-prefix
  [m2293]
  (clojure.core/let
   [bean2292
    (new com.amazonaws.services.directconnect.model.RouteFilterPrefix)]
   (clojure.core/when-let
    [v2294 (:cidr m2293)]
    (. bean2292 setCidr (clojure.core/str v2294)))
   bean2292))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.NewPublicVirtualInterface new-public-virtual-interface
  [m2296]
  (clojure.core/let
   [bean2295
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterface)]
   (clojure.core/when-let
    [v2297 (:asn m2296)]
    (. bean2295 setAsn (clojure.core/int v2297)))
   (clojure.core/when-let
    [v2297 (:auth-key m2296)]
    (. bean2295 setAuthKey (clojure.core/str v2297)))
   (clojure.core/when-let
    [v2297 (:vlan m2296)]
    (. bean2295 setVlan (clojure.core/int v2297)))
   (clojure.core/when-let
    [v2297 (:amazon-address m2296)]
    (. bean2295 setAmazonAddress (clojure.core/str v2297)))
   (clojure.core/when-let
    [v2297 (:customer-address m2296)]
    (. bean2295 setCustomerAddress (clojure.core/str v2297)))
   (clojure.core/when-let
    [v2297 (:virtual-interface-name m2296)]
    (. bean2295 setVirtualInterfaceName (clojure.core/str v2297)))
   (clojure.core/when-let
    [v2297 (:route-filter-prefixes m2296)]
    (.
     bean2295
     setRouteFilterPrefixes
     (clojure.core/map
      (clojure.core/fn [arg2298] (route-filter-prefix arg2298))
      v2297)))
   bean2295))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface new-private-virtual-interface
  [m2300]
  (clojure.core/let
   [bean2299
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface)]
   (clojure.core/when-let
    [v2301 (:asn m2300)]
    (. bean2299 setAsn (clojure.core/int v2301)))
   (clojure.core/when-let
    [v2301 (:auth-key m2300)]
    (. bean2299 setAuthKey (clojure.core/str v2301)))
   (clojure.core/when-let
    [v2301 (:vlan m2300)]
    (. bean2299 setVlan (clojure.core/int v2301)))
   (clojure.core/when-let
    [v2301 (:amazon-address m2300)]
    (. bean2299 setAmazonAddress (clojure.core/str v2301)))
   (clojure.core/when-let
    [v2301 (:customer-address m2300)]
    (. bean2299 setCustomerAddress (clojure.core/str v2301)))
   (clojure.core/when-let
    [v2301 (:virtual-gateway-id m2300)]
    (. bean2299 setVirtualGatewayId (clojure.core/str v2301)))
   (clojure.core/when-let
    [v2301 (:virtual-interface-name m2300)]
    (. bean2299 setVirtualInterfaceName (clojure.core/str v2301)))
   bean2299))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation new-private-virtual-interface-allocation
  [m2303]
  (clojure.core/let
   [bean2302
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation)]
   (clojure.core/when-let
    [v2304 (:asn m2303)]
    (. bean2302 setAsn (clojure.core/int v2304)))
   (clojure.core/when-let
    [v2304 (:auth-key m2303)]
    (. bean2302 setAuthKey (clojure.core/str v2304)))
   (clojure.core/when-let
    [v2304 (:vlan m2303)]
    (. bean2302 setVlan (clojure.core/int v2304)))
   (clojure.core/when-let
    [v2304 (:amazon-address m2303)]
    (. bean2302 setAmazonAddress (clojure.core/str v2304)))
   (clojure.core/when-let
    [v2304 (:customer-address m2303)]
    (. bean2302 setCustomerAddress (clojure.core/str v2304)))
   (clojure.core/when-let
    [v2304 (:virtual-interface-name m2303)]
    (. bean2302 setVirtualInterfaceName (clojure.core/str v2304)))
   bean2302))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation new-public-virtual-interface-allocation
  [m2306]
  (clojure.core/let
   [bean2305
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation)]
   (clojure.core/when-let
    [v2307 (:asn m2306)]
    (. bean2305 setAsn (clojure.core/int v2307)))
   (clojure.core/when-let
    [v2307 (:auth-key m2306)]
    (. bean2305 setAuthKey (clojure.core/str v2307)))
   (clojure.core/when-let
    [v2307 (:vlan m2306)]
    (. bean2305 setVlan (clojure.core/int v2307)))
   (clojure.core/when-let
    [v2307 (:amazon-address m2306)]
    (. bean2305 setAmazonAddress (clojure.core/str v2307)))
   (clojure.core/when-let
    [v2307 (:customer-address m2306)]
    (. bean2305 setCustomerAddress (clojure.core/str v2307)))
   (clojure.core/when-let
    [v2307 (:virtual-interface-name m2306)]
    (. bean2305 setVirtualInterfaceName (clojure.core/str v2307)))
   (clojure.core/when-let
    [v2307 (:route-filter-prefixes m2306)]
    (.
     bean2305
     setRouteFilterPrefixes
     (clojure.core/map
      (clojure.core/fn [arg2308] (route-filter-prefix arg2308))
      v2307)))
   bean2305))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DeleteConnectionRequest delete-connection-request
  [m2310]
  (clojure.core/let
   [bean2309
    (new
     com.amazonaws.services.directconnect.model.DeleteConnectionRequest)]
   (clojure.core/when-let
    [v2311 (:connection-id m2310)]
    (. bean2309 setConnectionId (clojure.core/str v2311)))
   bean2309))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest describe-connections-on-interconnect-request
  [m2313]
  (clojure.core/let
   [bean2312
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest)]
   (clojure.core/when-let
    [v2314 (:interconnect-id m2313)]
    (. bean2312 setInterconnectId (clojure.core/str v2314)))
   bean2312))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DescribeLocationsRequest describe-locations-request
  [m2316]
  (clojure.core/let
   [bean2315
    (new
     com.amazonaws.services.directconnect.model.DescribeLocationsRequest)]
   bean2315))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest allocate-connection-on-interconnect-request
  [m2319]
  (clojure.core/let
   [bean2318
    (new
     com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest)]
   (clojure.core/when-let
    [v2320 (:interconnect-id m2319)]
    (. bean2318 setInterconnectId (clojure.core/str v2320)))
   (clojure.core/when-let
    [v2320 (:bandwidth m2319)]
    (. bean2318 setBandwidth (clojure.core/str v2320)))
   (clojure.core/when-let
    [v2320 (:connection-name m2319)]
    (. bean2318 setConnectionName (clojure.core/str v2320)))
   (clojure.core/when-let
    [v2320 (:vlan m2319)]
    (. bean2318 setVlan (clojure.core/int v2320)))
   (clojure.core/when-let
    [v2320 (:owner-account m2319)]
    (. bean2318 setOwnerAccount (clojure.core/str v2320)))
   bean2318))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest create-public-virtual-interface-request
  [m2322]
  (clojure.core/let
   [bean2321
    (new
     com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v2323 (:connection-id m2322)]
    (. bean2321 setConnectionId (clojure.core/str v2323)))
   (clojure.core/when-let
    [v2323 (:new-public-virtual-interface m2322)]
    (.
     bean2321
     setNewPublicVirtualInterface
     (new-public-virtual-interface v2323)))
   bean2321))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.ConfirmConnectionRequest confirm-connection-request
  [m2325]
  (clojure.core/let
   [bean2324
    (new
     com.amazonaws.services.directconnect.model.ConfirmConnectionRequest)]
   (clojure.core/when-let
    [v2326 (:connection-id m2325)]
    (. bean2324 setConnectionId (clojure.core/str v2326)))
   bean2324))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest confirm-private-virtual-interface-request
  [m2328]
  (clojure.core/let
   [bean2327
    (new
     com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v2329 (:virtual-interface-id m2328)]
    (. bean2327 setVirtualInterfaceId (clojure.core/str v2329)))
   (clojure.core/when-let
    [v2329 (:virtual-gateway-id m2328)]
    (. bean2327 setVirtualGatewayId (clojure.core/str v2329)))
   bean2327))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.CreateInterconnectRequest create-interconnect-request
  [m2331]
  (clojure.core/let
   [bean2330
    (new
     com.amazonaws.services.directconnect.model.CreateInterconnectRequest)]
   (clojure.core/when-let
    [v2332 (:bandwidth m2331)]
    (. bean2330 setBandwidth (clojure.core/str v2332)))
   (clojure.core/when-let
    [v2332 (:interconnect-name m2331)]
    (. bean2330 setInterconnectName (clojure.core/str v2332)))
   (clojure.core/when-let
    [v2332 (:location m2331)]
    (. bean2330 setLocation (clojure.core/str v2332)))
   bean2330))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest confirm-public-virtual-interface-request
  [m2334]
  (clojure.core/let
   [bean2333
    (new
     com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v2335 (:virtual-interface-id m2334)]
    (. bean2333 setVirtualInterfaceId (clojure.core/str v2335)))
   bean2333))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest delete-virtual-interface-request
  [m2337]
  (clojure.core/let
   [bean2336
    (new
     com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v2338 (:virtual-interface-id m2337)]
    (. bean2336 setVirtualInterfaceId (clojure.core/str v2338)))
   bean2336))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest create-private-virtual-interface-request
  [m2340]
  (clojure.core/let
   [bean2339
    (new
     com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v2341 (:connection-id m2340)]
    (. bean2339 setConnectionId (clojure.core/str v2341)))
   (clojure.core/when-let
    [v2341 (:new-private-virtual-interface m2340)]
    (.
     bean2339
     setNewPrivateVirtualInterface
     (new-private-virtual-interface v2341)))
   bean2339))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest allocate-private-virtual-interface-request
  [m2343]
  (clojure.core/let
   [bean2342
    (new
     com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v2344 (:connection-id m2343)]
    (. bean2342 setConnectionId (clojure.core/str v2344)))
   (clojure.core/when-let
    [v2344 (:new-private-virtual-interface-allocation m2343)]
    (.
     bean2342
     setNewPrivateVirtualInterfaceAllocation
     (new-private-virtual-interface-allocation v2344)))
   (clojure.core/when-let
    [v2344 (:owner-account m2343)]
    (. bean2342 setOwnerAccount (clojure.core/str v2344)))
   bean2342))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest describe-virtual-interfaces-request
  [m2346]
  (clojure.core/let
   [bean2345
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest)]
   (clojure.core/when-let
    [v2347 (:connection-id m2346)]
    (. bean2345 setConnectionId (clojure.core/str v2347)))
   (clojure.core/when-let
    [v2347 (:virtual-interface-id m2346)]
    (. bean2345 setVirtualInterfaceId (clojure.core/str v2347)))
   bean2345))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DescribeConnectionsRequest describe-connections-request
  [m2349]
  (clojure.core/let
   [bean2348
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsRequest)]
   (clojure.core/when-let
    [v2350 (:connection-id m2349)]
    (. bean2348 setConnectionId (clojure.core/str v2350)))
   bean2348))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest allocate-public-virtual-interface-request
  [m2352]
  (clojure.core/let
   [bean2351
    (new
     com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v2353 (:connection-id m2352)]
    (. bean2351 setConnectionId (clojure.core/str v2353)))
   (clojure.core/when-let
    [v2353 (:new-public-virtual-interface-allocation m2352)]
    (.
     bean2351
     setNewPublicVirtualInterfaceAllocation
     (new-public-virtual-interface-allocation v2353)))
   (clojure.core/when-let
    [v2353 (:owner-account m2352)]
    (. bean2351 setOwnerAccount (clojure.core/str v2353)))
   bean2351))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest describe-interconnects-request
  [m2355]
  (clojure.core/let
   [bean2354
    (new
     com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest)]
   (clojure.core/when-let
    [v2356 (:interconnect-id m2355)]
    (. bean2354 setInterconnectId (clojure.core/str v2356)))
   bean2354))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.CreateConnectionRequest create-connection-request
  [m2358]
  (clojure.core/let
   [bean2357
    (new
     com.amazonaws.services.directconnect.model.CreateConnectionRequest)]
   (clojure.core/when-let
    [v2359 (:bandwidth m2358)]
    (. bean2357 setBandwidth (clojure.core/str v2359)))
   (clojure.core/when-let
    [v2359 (:connection-name m2358)]
    (. bean2357 setConnectionName (clojure.core/str v2359)))
   (clojure.core/when-let
    [v2359 (:location m2358)]
    (. bean2357 setLocation (clojure.core/str v2359)))
   bean2357))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DeleteInterconnectRequest delete-interconnect-request
  [m2361]
  (clojure.core/let
   [bean2360
    (new
     com.amazonaws.services.directconnect.model.DeleteInterconnectRequest)]
   (clojure.core/when-let
    [v2362 (:interconnect-id m2361)]
    (. bean2360 setInterconnectId (clojure.core/str v2362)))
   bean2360))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest describe-virtual-gateways-request
  [m2364]
  (clojure.core/let
   [bean2363
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest)]
   bean2363))
 (clojure.core/defmulti
  directconnect
  (clojure.core/fn
   directconnect
   [m__609__auto__]
   (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-connection
   [m2366]
   (clojure.core/let
    [credentials2367 (:credentials m2366) args2368 (:args m2366)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2369
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2367)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2369
       deleteConnection
       (delete-connection-request (clojure.core/nth args2368 0)))))))
  (clojure.core/defn
   delete-connection-map
   {:arglists
    '[[credentials {:keys [request-metric-collector connection-id]}]],
    :doc "Generate map for deleteConnection"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :delete-connection,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-connection
   {:arglists
    '[[credentials {:keys [request-metric-collector connection-id]}]],
    :doc "Call deleteConnection"}
   [credentials2371 & args2372]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2373
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2371)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2373
      deleteConnection
      (delete-connection-request (clojure.core/nth args2372 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections-on-interconnect
   [m2374]
   (clojure.core/let
    [credentials2375 (:credentials m2374) args2376 (:args m2374)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2377
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2375)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2377
       describeConnectionsOnInterconnect
       (describe-connections-on-interconnect-request
        (clojure.core/nth args2376 0)))))))
  (clojure.core/defn
   describe-connections-on-interconnect-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector interconnect-id]}]],
    :doc "Generate map for describeConnectionsOnInterconnect"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-connections-on-interconnect,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-connections-on-interconnect
   {:arglists
    '[[credentials
       {:keys [request-metric-collector interconnect-id]}]],
    :doc "Call describeConnectionsOnInterconnect"}
   [credentials2379 & args2380]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2381
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2379)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2381
      describeConnectionsOnInterconnect
      (describe-connections-on-interconnect-request
       (clojure.core/nth args2380 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-locations
   [m2382]
   (clojure.core/let
    [credentials2383 (:credentials m2382) args2384 (:args m2382)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2385
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2383)]
     (clojure.core/case
      (clojure.core/count args2384)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2385
        describeLocations
        (describe-locations-request (clojure.core/nth args2384 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2385
        describeLocations))))))
  (clojure.core/defn
   describe-locations-map
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc "Generate map for describeLocations, describeLocations"}
   ([credentials__577__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-locations,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-locations,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-locations
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc "Call describeLocations, describeLocations"}
   [credentials2387 & args2388]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2389
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2387)]
    (clojure.core/case
     (clojure.core/count args2388)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2389
       describeLocations
       (describe-locations-request (clojure.core/nth args2388 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2389
       describeLocations))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-connection-on-interconnect
   [m2390]
   (clojure.core/let
    [credentials2391 (:credentials m2390) args2392 (:args m2390)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2393
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2391)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2393
       allocateConnectionOnInterconnect
       (allocate-connection-on-interconnect-request
        (clojure.core/nth args2392 0)))))))
  (clojure.core/defn
   allocate-connection-on-interconnect-map
   {:arglists
    '[[credentials
       {:keys
        [vlan
         request-metric-collector
         owner-account
         interconnect-id
         connection-name
         bandwidth]}]],
    :doc "Generate map for allocateConnectionOnInterconnect"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :allocate-connection-on-interconnect,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   allocate-connection-on-interconnect
   {:arglists
    '[[credentials
       {:keys
        [vlan
         request-metric-collector
         owner-account
         interconnect-id
         connection-name
         bandwidth]}]],
    :doc "Call allocateConnectionOnInterconnect"}
   [credentials2395 & args2396]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2397
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2395)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2397
      allocateConnectionOnInterconnect
      (allocate-connection-on-interconnect-request
       (clojure.core/nth args2396 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-public-virtual-interface
   [m2398]
   (clojure.core/let
    [credentials2399 (:credentials m2398) args2400 (:args m2398)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2401
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2399)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2401
       createPublicVirtualInterface
       (create-public-virtual-interface-request
        (clojure.core/nth args2400 0)))))))
  (clojure.core/defn
   create-public-virtual-interface-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         new-public-virtual-interface
         connection-id]}]],
    :doc "Generate map for createPublicVirtualInterface"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-public-virtual-interface,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-public-virtual-interface
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         new-public-virtual-interface
         connection-id]}]],
    :doc "Call createPublicVirtualInterface"}
   [credentials2403 & args2404]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2405
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2403)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2405
      createPublicVirtualInterface
      (create-public-virtual-interface-request
       (clojure.core/nth args2404 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-connection
   [m2406]
   (clojure.core/let
    [credentials2407 (:credentials m2406) args2408 (:args m2406)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2409
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2407)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2409
       confirmConnection
       (confirm-connection-request (clojure.core/nth args2408 0)))))))
  (clojure.core/defn
   confirm-connection-map
   {:arglists
    '[[credentials {:keys [request-metric-collector connection-id]}]],
    :doc "Generate map for confirmConnection"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :confirm-connection,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   confirm-connection
   {:arglists
    '[[credentials {:keys [request-metric-collector connection-id]}]],
    :doc "Call confirmConnection"}
   [credentials2411 & args2412]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2413
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2411)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2413
      confirmConnection
      (confirm-connection-request (clojure.core/nth args2412 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-private-virtual-interface
   [m2414]
   (clojure.core/let
    [credentials2415 (:credentials m2414) args2416 (:args m2414)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2417
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2415)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2417
       confirmPrivateVirtualInterface
       (confirm-private-virtual-interface-request
        (clojure.core/nth args2416 0)))))))
  (clojure.core/defn
   confirm-private-virtual-interface-map
   {:arglists
    '[[credentials
       {:keys
        [virtual-interface-id
         virtual-gateway-id
         request-metric-collector]}]],
    :doc "Generate map for confirmPrivateVirtualInterface"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :confirm-private-virtual-interface,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   confirm-private-virtual-interface
   {:arglists
    '[[credentials
       {:keys
        [virtual-interface-id
         virtual-gateway-id
         request-metric-collector]}]],
    :doc "Call confirmPrivateVirtualInterface"}
   [credentials2419 & args2420]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2421
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2419)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2421
      confirmPrivateVirtualInterface
      (confirm-private-virtual-interface-request
       (clojure.core/nth args2420 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-interconnect
   [m2422]
   (clojure.core/let
    [credentials2423 (:credentials m2422) args2424 (:args m2422)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2425
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2423)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2425
       createInterconnect
       (create-interconnect-request (clojure.core/nth args2424 0)))))))
  (clojure.core/defn
   create-interconnect-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         location
         interconnect-name
         bandwidth]}]],
    :doc "Generate map for createInterconnect"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-interconnect,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-interconnect
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         location
         interconnect-name
         bandwidth]}]],
    :doc "Call createInterconnect"}
   [credentials2427 & args2428]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2429
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2427)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2429
      createInterconnect
      (create-interconnect-request (clojure.core/nth args2428 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-public-virtual-interface
   [m2430]
   (clojure.core/let
    [credentials2431 (:credentials m2430) args2432 (:args m2430)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2433
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2431)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2433
       confirmPublicVirtualInterface
       (confirm-public-virtual-interface-request
        (clojure.core/nth args2432 0)))))))
  (clojure.core/defn
   confirm-public-virtual-interface-map
   {:arglists
    '[[credentials
       {:keys [virtual-interface-id request-metric-collector]}]],
    :doc "Generate map for confirmPublicVirtualInterface"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :confirm-public-virtual-interface,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   confirm-public-virtual-interface
   {:arglists
    '[[credentials
       {:keys [virtual-interface-id request-metric-collector]}]],
    :doc "Call confirmPublicVirtualInterface"}
   [credentials2435 & args2436]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2437
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2435)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2437
      confirmPublicVirtualInterface
      (confirm-public-virtual-interface-request
       (clojure.core/nth args2436 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-virtual-interface
   [m2438]
   (clojure.core/let
    [credentials2439 (:credentials m2438) args2440 (:args m2438)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2441
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2439)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2441
       deleteVirtualInterface
       (delete-virtual-interface-request
        (clojure.core/nth args2440 0)))))))
  (clojure.core/defn
   delete-virtual-interface-map
   {:arglists
    '[[credentials
       {:keys [virtual-interface-id request-metric-collector]}]],
    :doc "Generate map for deleteVirtualInterface"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :delete-virtual-interface,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-virtual-interface
   {:arglists
    '[[credentials
       {:keys [virtual-interface-id request-metric-collector]}]],
    :doc "Call deleteVirtualInterface"}
   [credentials2443 & args2444]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2445
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2443)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2445
      deleteVirtualInterface
      (delete-virtual-interface-request
       (clojure.core/nth args2444 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-private-virtual-interface
   [m2446]
   (clojure.core/let
    [credentials2447 (:credentials m2446) args2448 (:args m2446)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2449
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2447)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2449
       createPrivateVirtualInterface
       (create-private-virtual-interface-request
        (clojure.core/nth args2448 0)))))))
  (clojure.core/defn
   create-private-virtual-interface-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         new-private-virtual-interface
         connection-id]}]],
    :doc "Generate map for createPrivateVirtualInterface"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-private-virtual-interface,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-private-virtual-interface
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         new-private-virtual-interface
         connection-id]}]],
    :doc "Call createPrivateVirtualInterface"}
   [credentials2451 & args2452]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2453
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2451)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2453
      createPrivateVirtualInterface
      (create-private-virtual-interface-request
       (clojure.core/nth args2452 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-private-virtual-interface
   [m2454]
   (clojure.core/let
    [credentials2455 (:credentials m2454) args2456 (:args m2454)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2457
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2455)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2457
       allocatePrivateVirtualInterface
       (allocate-private-virtual-interface-request
        (clojure.core/nth args2456 0)))))))
  (clojure.core/defn
   allocate-private-virtual-interface-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         owner-account
         new-private-virtual-interface-allocation
         connection-id]}]],
    :doc "Generate map for allocatePrivateVirtualInterface"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :allocate-private-virtual-interface,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   allocate-private-virtual-interface
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         owner-account
         new-private-virtual-interface-allocation
         connection-id]}]],
    :doc "Call allocatePrivateVirtualInterface"}
   [credentials2459 & args2460]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2461
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2459)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2461
      allocatePrivateVirtualInterface
      (allocate-private-virtual-interface-request
       (clojure.core/nth args2460 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-interfaces
   [m2462]
   (clojure.core/let
    [credentials2463 (:credentials m2462) args2464 (:args m2462)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2465
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2463)]
     (clojure.core/case
      (clojure.core/count args2464)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2465
        describeVirtualInterfaces
        (describe-virtual-interfaces-request
         (clojure.core/nth args2464 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2465
        describeVirtualInterfaces))))))
  (clojure.core/defn
   describe-virtual-interfaces-map
   {:arglists
    '[[credentials
       {:keys
        [virtual-interface-id request-metric-collector connection-id]}]
      [credentials]],
    :doc
    "Generate map for describeVirtualInterfaces, describeVirtualInterfaces"}
   ([credentials__577__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-virtual-interfaces,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-virtual-interfaces,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-virtual-interfaces
   {:arglists
    '[[credentials
       {:keys
        [virtual-interface-id request-metric-collector connection-id]}]
      [credentials]],
    :doc "Call describeVirtualInterfaces, describeVirtualInterfaces"}
   [credentials2467 & args2468]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2469
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2467)]
    (clojure.core/case
     (clojure.core/count args2468)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2469
       describeVirtualInterfaces
       (describe-virtual-interfaces-request
        (clojure.core/nth args2468 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2469
       describeVirtualInterfaces))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections
   [m2470]
   (clojure.core/let
    [credentials2471 (:credentials m2470) args2472 (:args m2470)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2473
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2471)]
     (clojure.core/case
      (clojure.core/count args2472)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2473
        describeConnections))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2473
        describeConnections
        (describe-connections-request
         (clojure.core/nth args2472 0))))))))
  (clojure.core/defn
   describe-connections-map
   {:arglists
    '[[credentials]
      [credentials {:keys [request-metric-collector connection-id]}]],
    :doc "Generate map for describeConnections, describeConnections"}
   ([credentials__577__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-connections,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-connections,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-connections
   {:arglists
    '[[credentials]
      [credentials {:keys [request-metric-collector connection-id]}]],
    :doc "Call describeConnections, describeConnections"}
   [credentials2475 & args2476]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2477
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2475)]
    (clojure.core/case
     (clojure.core/count args2476)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2477
       describeConnections))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2477
       describeConnections
       (describe-connections-request
        (clojure.core/nth args2476 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-public-virtual-interface
   [m2478]
   (clojure.core/let
    [credentials2479 (:credentials m2478) args2480 (:args m2478)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2481
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2479)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2481
       allocatePublicVirtualInterface
       (allocate-public-virtual-interface-request
        (clojure.core/nth args2480 0)))))))
  (clojure.core/defn
   allocate-public-virtual-interface-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         owner-account
         new-public-virtual-interface-allocation
         connection-id]}]],
    :doc "Generate map for allocatePublicVirtualInterface"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :allocate-public-virtual-interface,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   allocate-public-virtual-interface
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         owner-account
         new-public-virtual-interface-allocation
         connection-id]}]],
    :doc "Call allocatePublicVirtualInterface"}
   [credentials2483 & args2484]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2485
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2483)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2485
      allocatePublicVirtualInterface
      (allocate-public-virtual-interface-request
       (clojure.core/nth args2484 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-interconnects
   [m2486]
   (clojure.core/let
    [credentials2487 (:credentials m2486) args2488 (:args m2486)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2489
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2487)]
     (clojure.core/case
      (clojure.core/count args2488)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2489
        describeInterconnects))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2489
        describeInterconnects
        (describe-interconnects-request
         (clojure.core/nth args2488 0))))))))
  (clojure.core/defn
   describe-interconnects-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys [request-metric-collector interconnect-id]}]],
    :doc
    "Generate map for describeInterconnects, describeInterconnects"}
   ([credentials__577__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-interconnects,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-interconnects,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-interconnects
   {:arglists
    '[[credentials]
      [credentials
       {:keys [request-metric-collector interconnect-id]}]],
    :doc "Call describeInterconnects, describeInterconnects"}
   [credentials2491 & args2492]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2493
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2491)]
    (clojure.core/case
     (clojure.core/count args2492)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2493
       describeInterconnects))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2493
       describeInterconnects
       (describe-interconnects-request
        (clojure.core/nth args2492 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-connection
   [m2494]
   (clojure.core/let
    [credentials2495 (:credentials m2494) args2496 (:args m2494)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2497
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2495)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2497
       createConnection
       (create-connection-request (clojure.core/nth args2496 0)))))))
  (clojure.core/defn
   create-connection-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         location
         connection-name
         bandwidth]}]],
    :doc "Generate map for createConnection"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-connection,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-connection
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         location
         connection-name
         bandwidth]}]],
    :doc "Call createConnection"}
   [credentials2499 & args2500]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2501
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2499)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2501
      createConnection
      (create-connection-request (clojure.core/nth args2500 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-interconnect
   [m2502]
   (clojure.core/let
    [credentials2503 (:credentials m2502) args2504 (:args m2502)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2505
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2503)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2505
       deleteInterconnect
       (delete-interconnect-request (clojure.core/nth args2504 0)))))))
  (clojure.core/defn
   delete-interconnect-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector interconnect-id]}]],
    :doc "Generate map for deleteInterconnect"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :delete-interconnect,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-interconnect
   {:arglists
    '[[credentials
       {:keys [request-metric-collector interconnect-id]}]],
    :doc "Call deleteInterconnect"}
   [credentials2507 & args2508]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2509
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2507)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2509
      deleteInterconnect
      (delete-interconnect-request (clojure.core/nth args2508 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-gateways
   [m2510]
   (clojure.core/let
    [credentials2511 (:credentials m2510) args2512 (:args m2510)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2513
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials2511)]
     (clojure.core/case
      (clojure.core/count args2512)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2513
        describeVirtualGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2513
        describeVirtualGateways
        (describe-virtual-gateways-request
         (clojure.core/nth args2512 0))))))))
  (clojure.core/defn
   describe-virtual-gateways-map
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc
    "Generate map for describeVirtualGateways, describeVirtualGateways"}
   ([credentials__577__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-virtual-gateways,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-virtual-gateways,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-virtual-gateways
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc "Call describeVirtualGateways, describeVirtualGateways"}
   [credentials2515 & args2516]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2517
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials2515)]
    (clojure.core/case
     (clojure.core/count args2516)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2517
       describeVirtualGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client2517
       describeVirtualGateways
       (describe-virtual-gateways-request
        (clojure.core/nth args2516 0)))))))))
