(ns com.palletops.awaze.datapipeline (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :datapipeline
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.datapipeline.DataPipelineClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.OperatorType operator-type
  [m7941]
  (java.lang.Enum/valueOf
   com.amazonaws.services.datapipeline.model.OperatorType
   (clojure.core/name m7941)))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.Operator operator
  [m7944]
  (clojure.core/let
   [bean7943 (new com.amazonaws.services.datapipeline.model.Operator)]
   (clojure.core/when-let
    [v7945 (:values m7944)]
    (.
     bean7943
     setValues
     (clojure.core/map
      (clojure.core/fn [arg7946] (clojure.core/str arg7946))
      v7945)))
   (clojure.core/when-let
    [v7945 (:type m7944)]
    (. bean7943 setType (operator-type v7945)))
   (clojure.core/when-let
    [v7945 (:type m7944)]
    (. bean7943 setType (clojure.core/str v7945)))
   bean7943))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.Selector selector
  [m7948]
  (clojure.core/let
   [bean7947 (new com.amazonaws.services.datapipeline.model.Selector)]
   (clojure.core/when-let
    [v7949 (:field-name m7948)]
    (. bean7947 setFieldName (clojure.core/str v7949)))
   (clojure.core/when-let
    [v7949 (:operator m7948)]
    (. bean7947 setOperator (operator v7949)))
   bean7947))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.Field field
  [m7951]
  (clojure.core/let
   [bean7950 (new com.amazonaws.services.datapipeline.model.Field)]
   (clojure.core/when-let
    [v7952 (:key m7951)]
    (. bean7950 setKey (clojure.core/str v7952)))
   (clojure.core/when-let
    [v7952 (:string-value m7951)]
    (. bean7950 setStringValue (clojure.core/str v7952)))
   (clojure.core/when-let
    [v7952 (:ref-value m7951)]
    (. bean7950 setRefValue (clojure.core/str v7952)))
   bean7950))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.Query query
  [m7954]
  (clojure.core/let
   [bean7953 (new com.amazonaws.services.datapipeline.model.Query)]
   (clojure.core/when-let
    [v7955 (:selectors m7954)]
    (.
     bean7953
     setSelectors
     (clojure.core/map
      (clojure.core/fn [arg7956] (selector arg7956))
      v7955)))
   bean7953))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.InstanceIdentity instance-identity
  [m7958]
  (clojure.core/let
   [bean7957
    (new com.amazonaws.services.datapipeline.model.InstanceIdentity)]
   (clojure.core/when-let
    [v7959 (:document m7958)]
    (. bean7957 setDocument (clojure.core/str v7959)))
   (clojure.core/when-let
    [v7959 (:signature m7958)]
    (. bean7957 setSignature (clojure.core/str v7959)))
   bean7957))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.PipelineObject pipeline-object
  [m7961]
  (clojure.core/let
   [bean7960
    (new com.amazonaws.services.datapipeline.model.PipelineObject)]
   (clojure.core/when-let
    [v7962 (:name m7961)]
    (. bean7960 setName (clojure.core/str v7962)))
   (clojure.core/when-let
    [v7962 (:id m7961)]
    (. bean7960 setId (clojure.core/str v7962)))
   (clojure.core/when-let
    [v7962 (:fields m7961)]
    (.
     bean7960
     setFields
     (clojure.core/map
      (clojure.core/fn [arg7963] (field arg7963))
      v7962)))
   bean7960))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.TaskStatus task-status
  [m7965]
  (java.lang.Enum/valueOf
   com.amazonaws.services.datapipeline.model.TaskStatus
   (clojure.core/name m7965)))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.DescribeObjectsRequest describe-objects-request
  [m7968]
  (clojure.core/let
   [bean7967
    (new
     com.amazonaws.services.datapipeline.model.DescribeObjectsRequest)]
   (clojure.core/when-let
    [v7969 (:marker m7968)]
    (. bean7967 setMarker (clojure.core/str v7969)))
   (clojure.core/when-let
    [v7969 (:pipeline-id m7968)]
    (. bean7967 setPipelineId (clojure.core/str v7969)))
   (clojure.core/when-let
    [v7969 (:object-ids m7968)]
    (.
     bean7967
     setObjectIds
     (clojure.core/map
      (clojure.core/fn [arg7970] (clojure.core/str arg7970))
      v7969)))
   (clojure.core/when-let
    [v7969 (:evaluate-expressions m7968)]
    (. bean7967 setEvaluateExpressions (clojure.core/boolean v7969)))
   bean7967))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest report-task-runner-heartbeat-request
  [m7972]
  (clojure.core/let
   [bean7971
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest)]
   (clojure.core/when-let
    [v7973 (:taskrunner-id m7972)]
    (. bean7971 setTaskrunnerId (clojure.core/str v7973)))
   (clojure.core/when-let
    [v7973 (:worker-group m7972)]
    (. bean7971 setWorkerGroup (clojure.core/str v7973)))
   (clojure.core/when-let
    [v7973 (:hostname m7972)]
    (. bean7971 setHostname (clojure.core/str v7973)))
   bean7971))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.QueryObjectsRequest query-objects-request
  [m7975]
  (clojure.core/let
   [bean7974
    (new
     com.amazonaws.services.datapipeline.model.QueryObjectsRequest)]
   (clojure.core/when-let
    [v7976 (:marker m7975)]
    (. bean7974 setMarker (clojure.core/str v7976)))
   (clojure.core/when-let
    [v7976 (:pipeline-id m7975)]
    (. bean7974 setPipelineId (clojure.core/str v7976)))
   (clojure.core/when-let
    [v7976 (:query m7975)]
    (. bean7974 setQuery (query v7976)))
   (clojure.core/when-let
    [v7976 (:sphere m7975)]
    (. bean7974 setSphere (clojure.core/str v7976)))
   (clojure.core/when-let
    [v7976 (:limit m7975)]
    (. bean7974 setLimit (clojure.core/int v7976)))
   bean7974))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.DescribePipelinesRequest describe-pipelines-request
  [m7978]
  (clojure.core/let
   [bean7977
    (new
     com.amazonaws.services.datapipeline.model.DescribePipelinesRequest)]
   (clojure.core/when-let
    [v7979 (:pipeline-ids m7978)]
    (.
     bean7977
     setPipelineIds
     (clojure.core/map
      (clojure.core/fn [arg7980] (clojure.core/str arg7980))
      v7979)))
   bean7977))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.ActivatePipelineRequest activate-pipeline-request
  [m7982]
  (clojure.core/let
   [bean7981
    (new
     com.amazonaws.services.datapipeline.model.ActivatePipelineRequest)]
   (clojure.core/when-let
    [v7983 (:pipeline-id m7982)]
    (. bean7981 setPipelineId (clojure.core/str v7983)))
   bean7981))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.SetStatusRequest set-status-request
  [m7985]
  (clojure.core/let
   [bean7984
    (new com.amazonaws.services.datapipeline.model.SetStatusRequest)]
   (clojure.core/when-let
    [v7986 (:pipeline-id m7985)]
    (. bean7984 setPipelineId (clojure.core/str v7986)))
   (clojure.core/when-let
    [v7986 (:object-ids m7985)]
    (.
     bean7984
     setObjectIds
     (clojure.core/map
      (clojure.core/fn [arg7987] (clojure.core/str arg7987))
      v7986)))
   (clojure.core/when-let
    [v7986 (:status m7985)]
    (. bean7984 setStatus (clojure.core/str v7986)))
   bean7984))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest get-pipeline-definition-request
  [m7989]
  (clojure.core/let
   [bean7988
    (new
     com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest)]
   (clojure.core/when-let
    [v7990 (:pipeline-id m7989)]
    (. bean7988 setPipelineId (clojure.core/str v7990)))
   (clojure.core/when-let
    [v7990 (:version m7989)]
    (. bean7988 setVersion (clojure.core/str v7990)))
   bean7988))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.PollForTaskRequest poll-for-task-request
  [m7992]
  (clojure.core/let
   [bean7991
    (new com.amazonaws.services.datapipeline.model.PollForTaskRequest)]
   (clojure.core/when-let
    [v7993 (:worker-group m7992)]
    (. bean7991 setWorkerGroup (clojure.core/str v7993)))
   (clojure.core/when-let
    [v7993 (:hostname m7992)]
    (. bean7991 setHostname (clojure.core/str v7993)))
   (clojure.core/when-let
    [v7993 (:instance-identity m7992)]
    (. bean7991 setInstanceIdentity (instance-identity v7993)))
   bean7991))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest report-task-progress-request
  [m7995]
  (clojure.core/let
   [bean7994
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest)]
   (clojure.core/when-let
    [v7996 (:task-id m7995)]
    (. bean7994 setTaskId (clojure.core/str v7996)))
   bean7994))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.DeletePipelineRequest delete-pipeline-request
  [m7998]
  (clojure.core/let
   [bean7997
    (new
     com.amazonaws.services.datapipeline.model.DeletePipelineRequest)]
   (clojure.core/when-let
    [v7999 (:pipeline-id m7998)]
    (. bean7997 setPipelineId (clojure.core/str v7999)))
   bean7997))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.CreatePipelineRequest create-pipeline-request
  [m8001]
  (clojure.core/let
   [bean8000
    (new
     com.amazonaws.services.datapipeline.model.CreatePipelineRequest)]
   (clojure.core/when-let
    [v8002 (:name m8001)]
    (. bean8000 setName (clojure.core/str v8002)))
   (clojure.core/when-let
    [v8002 (:unique-id m8001)]
    (. bean8000 setUniqueId (clojure.core/str v8002)))
   (clojure.core/when-let
    [v8002 (:description m8001)]
    (. bean8000 setDescription (clojure.core/str v8002)))
   bean8000))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest evaluate-expression-request
  [m8004]
  (clojure.core/let
   [bean8003
    (new
     com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest)]
   (clojure.core/when-let
    [v8005 (:pipeline-id m8004)]
    (. bean8003 setPipelineId (clojure.core/str v8005)))
   (clojure.core/when-let
    [v8005 (:object-id m8004)]
    (. bean8003 setObjectId (clojure.core/str v8005)))
   (clojure.core/when-let
    [v8005 (:expression m8004)]
    (. bean8003 setExpression (clojure.core/str v8005)))
   bean8003))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest put-pipeline-definition-request
  [m8007]
  (clojure.core/let
   [bean8006
    (new
     com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest)]
   (clojure.core/when-let
    [v8008 (:pipeline-id m8007)]
    (. bean8006 setPipelineId (clojure.core/str v8008)))
   (clojure.core/when-let
    [v8008 (:pipeline-objects m8007)]
    (.
     bean8006
     setPipelineObjects
     (clojure.core/map
      (clojure.core/fn [arg8009] (pipeline-object arg8009))
      v8008)))
   bean8006))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.ListPipelinesRequest list-pipelines-request
  [m8011]
  (clojure.core/let
   [bean8010
    (new
     com.amazonaws.services.datapipeline.model.ListPipelinesRequest)]
   (clojure.core/when-let
    [v8012 (:marker m8011)]
    (. bean8010 setMarker (clojure.core/str v8012)))
   bean8010))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.SetTaskStatusRequest set-task-status-request
  [m8014]
  (clojure.core/let
   [bean8013
    (new
     com.amazonaws.services.datapipeline.model.SetTaskStatusRequest)]
   (clojure.core/when-let
    [v8015 (:task-status m8014)]
    (. bean8013 setTaskStatus (clojure.core/str v8015)))
   (clojure.core/when-let
    [v8015 (:task-status m8014)]
    (. bean8013 setTaskStatus (task-status v8015)))
   (clojure.core/when-let
    [v8015 (:task-id m8014)]
    (. bean8013 setTaskId (clojure.core/str v8015)))
   (clojure.core/when-let
    [v8015 (:error-id m8014)]
    (. bean8013 setErrorId (clojure.core/str v8015)))
   (clojure.core/when-let
    [v8015 (:error-message m8014)]
    (. bean8013 setErrorMessage (clojure.core/str v8015)))
   (clojure.core/when-let
    [v8015 (:error-stack-trace m8014)]
    (. bean8013 setErrorStackTrace (clojure.core/str v8015)))
   bean8013))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest validate-pipeline-definition-request
  [m8017]
  (clojure.core/let
   [bean8016
    (new
     com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest)]
   (clojure.core/when-let
    [v8018 (:pipeline-id m8017)]
    (. bean8016 setPipelineId (clojure.core/str v8018)))
   (clojure.core/when-let
    [v8018 (:pipeline-objects m8017)]
    (.
     bean8016
     setPipelineObjects
     (clojure.core/map
      (clojure.core/fn [arg8019] (pipeline-object arg8019))
      v8018)))
   bean8016))
 (clojure.core/defmulti
  datapipeline
  (clojure.core/fn datapipeline [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-objects
   [m8020]
   (clojure.core/let
    [credentials8021 (:credentials m8020) args8022 (:args m8020)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8023
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8021)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8023
       describeObjects
       (describe-objects-request (clojure.core/nth args8022 0)))))))
  (clojure.core/defn
   describe-objects-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         pipeline-id
         object-ids
         marker
         evaluate-expressions]}]],
    :doc "Generate map for describeObjects"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :describe-objects,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-objects
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         pipeline-id
         object-ids
         marker
         evaluate-expressions]}]],
    :doc "Call describeObjects"}
   [credentials8025 & args8026]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8027
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8025)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client8027
      describeObjects
      (describe-objects-request (clojure.core/nth args8026 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-runner-heartbeat
   [m8028]
   (clojure.core/let
    [credentials8029 (:credentials m8028) args8030 (:args m8028)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8031
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8029)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8031
       reportTaskRunnerHeartbeat
       (report-task-runner-heartbeat-request
        (clojure.core/nth args8030 0)))))))
  (clojure.core/defn
   report-task-runner-heartbeat-map
   {:arglists
    '[[credentials
       {:keys
        [worker-group
         taskrunner-id
         request-metric-collector
         hostname]}]],
    :doc "Generate map for reportTaskRunnerHeartbeat"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :report-task-runner-heartbeat,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   report-task-runner-heartbeat
   {:arglists
    '[[credentials
       {:keys
        [worker-group
         taskrunner-id
         request-metric-collector
         hostname]}]],
    :doc "Call reportTaskRunnerHeartbeat"}
   [credentials8033 & args8034]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8035
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8033)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client8035
      reportTaskRunnerHeartbeat
      (report-task-runner-heartbeat-request
       (clojure.core/nth args8034 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :query-objects
   [m8036]
   (clojure.core/let
    [credentials8037 (:credentials m8036) args8038 (:args m8036)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8039
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8037)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8039
       queryObjects
       (query-objects-request (clojure.core/nth args8038 0)))))))
  (clojure.core/defn
   query-objects-map
   {:arglists
    '[[credentials
       {:keys
        [sphere
         request-metric-collector
         query
         pipeline-id
         marker
         limit]}]],
    :doc "Generate map for queryObjects"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :query-objects,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   query-objects
   {:arglists
    '[[credentials
       {:keys
        [sphere
         request-metric-collector
         query
         pipeline-id
         marker
         limit]}]],
    :doc "Call queryObjects"}
   [credentials8041 & args8042]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8043
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8041)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client8043
      queryObjects
      (query-objects-request (clojure.core/nth args8042 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-pipelines
   [m8044]
   (clojure.core/let
    [credentials8045 (:credentials m8044) args8046 (:args m8044)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8047
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8045)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8047
       describePipelines
       (describe-pipelines-request (clojure.core/nth args8046 0)))))))
  (clojure.core/defn
   describe-pipelines-map
   {:arglists
    '[[credentials {:keys [request-metric-collector pipeline-ids]}]],
    :doc "Generate map for describePipelines"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :describe-pipelines,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-pipelines
   {:arglists
    '[[credentials {:keys [request-metric-collector pipeline-ids]}]],
    :doc "Call describePipelines"}
   [credentials8049 & args8050]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8051
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8049)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client8051
      describePipelines
      (describe-pipelines-request (clojure.core/nth args8050 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :activate-pipeline
   [m8052]
   (clojure.core/let
    [credentials8053 (:credentials m8052) args8054 (:args m8052)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8055
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8053)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8055
       activatePipeline
       (activate-pipeline-request (clojure.core/nth args8054 0)))))))
  (clojure.core/defn
   activate-pipeline-map
   {:arglists
    '[[credentials {:keys [request-metric-collector pipeline-id]}]],
    :doc "Generate map for activatePipeline"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :activate-pipeline,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   activate-pipeline
   {:arglists
    '[[credentials {:keys [request-metric-collector pipeline-id]}]],
    :doc "Call activatePipeline"}
   [credentials8057 & args8058]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8059
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8057)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client8059
      activatePipeline
      (activate-pipeline-request (clojure.core/nth args8058 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-status
   [m8060]
   (clojure.core/let
    [credentials8061 (:credentials m8060) args8062 (:args m8060)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8063
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8061)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8063
       setStatus
       (set-status-request (clojure.core/nth args8062 0)))))))
  (clojure.core/defn
   set-status-map
   {:arglists
    '[[credentials
       {:keys
        [status request-metric-collector pipeline-id object-ids]}]],
    :doc "Generate map for setStatus"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :set-status,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-status
   {:arglists
    '[[credentials
       {:keys
        [status request-metric-collector pipeline-id object-ids]}]],
    :doc "Call setStatus"}
   [credentials8065 & args8066]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8067
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8065)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client8067
      setStatus
      (set-status-request (clojure.core/nth args8066 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :get-pipeline-definition
   [m8068]
   (clojure.core/let
    [credentials8069 (:credentials m8068) args8070 (:args m8068)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8071
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8069)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8071
       getPipelineDefinition
       (get-pipeline-definition-request
        (clojure.core/nth args8070 0)))))))
  (clojure.core/defn
   get-pipeline-definition-map
   {:arglists
    '[[credentials
       {:keys [version request-metric-collector pipeline-id]}]],
    :doc "Generate map for getPipelineDefinition"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :get-pipeline-definition,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-pipeline-definition
   {:arglists
    '[[credentials
       {:keys [version request-metric-collector pipeline-id]}]],
    :doc "Call getPipelineDefinition"}
   [credentials8073 & args8074]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8075
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8073)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client8075
      getPipelineDefinition
      (get-pipeline-definition-request
       (clojure.core/nth args8074 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :poll-for-task
   [m8076]
   (clojure.core/let
    [credentials8077 (:credentials m8076) args8078 (:args m8076)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8079
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8077)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8079
       pollForTask
       (poll-for-task-request (clojure.core/nth args8078 0)))))))
  (clojure.core/defn
   poll-for-task-map
   {:arglists
    '[[credentials
       {:keys
        [worker-group
         request-metric-collector
         instance-identity
         hostname]}]],
    :doc "Generate map for pollForTask"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :poll-for-task,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   poll-for-task
   {:arglists
    '[[credentials
       {:keys
        [worker-group
         request-metric-collector
         instance-identity
         hostname]}]],
    :doc "Call pollForTask"}
   [credentials8081 & args8082]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8083
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8081)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client8083
      pollForTask
      (poll-for-task-request (clojure.core/nth args8082 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-progress
   [m8084]
   (clojure.core/let
    [credentials8085 (:credentials m8084) args8086 (:args m8084)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8087
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8085)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8087
       reportTaskProgress
       (report-task-progress-request
        (clojure.core/nth args8086 0)))))))
  (clojure.core/defn
   report-task-progress-map
   {:arglists
    '[[credentials {:keys [task-id request-metric-collector]}]],
    :doc "Generate map for reportTaskProgress"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :report-task-progress,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   report-task-progress
   {:arglists
    '[[credentials {:keys [task-id request-metric-collector]}]],
    :doc "Call reportTaskProgress"}
   [credentials8089 & args8090]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8091
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8089)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client8091
      reportTaskProgress
      (report-task-progress-request (clojure.core/nth args8090 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :delete-pipeline
   [m8092]
   (clojure.core/let
    [credentials8093 (:credentials m8092) args8094 (:args m8092)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8095
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8093)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8095
       deletePipeline
       (delete-pipeline-request (clojure.core/nth args8094 0)))))))
  (clojure.core/defn
   delete-pipeline-map
   {:arglists
    '[[credentials {:keys [request-metric-collector pipeline-id]}]],
    :doc "Generate map for deletePipeline"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :delete-pipeline,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-pipeline
   {:arglists
    '[[credentials {:keys [request-metric-collector pipeline-id]}]],
    :doc "Call deletePipeline"}
   [credentials8097 & args8098]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8099
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8097)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client8099
      deletePipeline
      (delete-pipeline-request (clojure.core/nth args8098 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :create-pipeline
   [m8100]
   (clojure.core/let
    [credentials8101 (:credentials m8100) args8102 (:args m8100)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8103
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8101)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8103
       createPipeline
       (create-pipeline-request (clojure.core/nth args8102 0)))))))
  (clojure.core/defn
   create-pipeline-map
   {:arglists
    '[[credentials
       {:keys [unique-id request-metric-collector name description]}]],
    :doc "Generate map for createPipeline"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :create-pipeline,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-pipeline
   {:arglists
    '[[credentials
       {:keys [unique-id request-metric-collector name description]}]],
    :doc "Call createPipeline"}
   [credentials8105 & args8106]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8107
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8105)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client8107
      createPipeline
      (create-pipeline-request (clojure.core/nth args8106 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :evaluate-expression
   [m8108]
   (clojure.core/let
    [credentials8109 (:credentials m8108) args8110 (:args m8108)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8111
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8109)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8111
       evaluateExpression
       (evaluate-expression-request (clojure.core/nth args8110 0)))))))
  (clojure.core/defn
   evaluate-expression-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector pipeline-id object-id expression]}]],
    :doc "Generate map for evaluateExpression"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :evaluate-expression,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   evaluate-expression
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector pipeline-id object-id expression]}]],
    :doc "Call evaluateExpression"}
   [credentials8113 & args8114]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8115
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8113)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client8115
      evaluateExpression
      (evaluate-expression-request (clojure.core/nth args8114 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :put-pipeline-definition
   [m8116]
   (clojure.core/let
    [credentials8117 (:credentials m8116) args8118 (:args m8116)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8119
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8117)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8119
       putPipelineDefinition
       (put-pipeline-definition-request
        (clojure.core/nth args8118 0)))))))
  (clojure.core/defn
   put-pipeline-definition-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector pipeline-objects pipeline-id]}]],
    :doc "Generate map for putPipelineDefinition"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :put-pipeline-definition,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   put-pipeline-definition
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector pipeline-objects pipeline-id]}]],
    :doc "Call putPipelineDefinition"}
   [credentials8121 & args8122]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8123
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8121)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client8123
      putPipelineDefinition
      (put-pipeline-definition-request
       (clojure.core/nth args8122 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :list-pipelines
   [m8124]
   (clojure.core/let
    [credentials8125 (:credentials m8124) args8126 (:args m8124)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8127
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8125)]
     (clojure.core/case
      (clojure.core/count args8126)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.datapipeline.DataPipelineClient client8127
        listPipelines))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.datapipeline.DataPipelineClient client8127
        listPipelines
        (list-pipelines-request (clojure.core/nth args8126 0))))))))
  (clojure.core/defn
   list-pipelines-map
   {:arglists
    '[[credentials]
      [credentials {:keys [request-metric-collector marker]}]],
    :doc "Generate map for listPipelines, listPipelines"}
   ([credentials__577__auto__]
    {:args [],
     :client :datapipeline,
     :fn :list-pipelines,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :list-pipelines,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-pipelines
   {:arglists
    '[[credentials]
      [credentials {:keys [request-metric-collector marker]}]],
    :doc "Call listPipelines, listPipelines"}
   [credentials8129 & args8130]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8131
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8129)]
    (clojure.core/case
     (clojure.core/count args8130)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8131
       listPipelines))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8131
       listPipelines
       (list-pipelines-request (clojure.core/nth args8130 0))))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-task-status
   [m8132]
   (clojure.core/let
    [credentials8133 (:credentials m8132) args8134 (:args m8132)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8135
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8133)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8135
       setTaskStatus
       (set-task-status-request (clojure.core/nth args8134 0)))))))
  (clojure.core/defn
   set-task-status-map
   {:arglists
    '[[credentials
       {:keys
        [task-status
         task-id
         request-metric-collector
         error-stack-trace
         error-message
         error-id]}]],
    :doc "Generate map for setTaskStatus"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :set-task-status,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-task-status
   {:arglists
    '[[credentials
       {:keys
        [task-status
         task-id
         request-metric-collector
         error-stack-trace
         error-message
         error-id]}]],
    :doc "Call setTaskStatus"}
   [credentials8137 & args8138]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8139
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8137)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client8139
      setTaskStatus
      (set-task-status-request (clojure.core/nth args8138 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :validate-pipeline-definition
   [m8140]
   (clojure.core/let
    [credentials8141 (:credentials m8140) args8142 (:args m8140)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client8143
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials8141)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client8143
       validatePipelineDefinition
       (validate-pipeline-definition-request
        (clojure.core/nth args8142 0)))))))
  (clojure.core/defn
   validate-pipeline-definition-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector pipeline-objects pipeline-id]}]],
    :doc "Generate map for validatePipelineDefinition"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :validate-pipeline-definition,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   validate-pipeline-definition
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector pipeline-objects pipeline-id]}]],
    :doc "Call validatePipelineDefinition"}
   [credentials8145 & args8146]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client8147
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials8145)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client8147
      validatePipelineDefinition
      (validate-pipeline-definition-request
       (clojure.core/nth args8146 0))))))))
