(ns com.palletops.awaze.cloudwatch (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudwatch
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.cloudwatch.AmazonCloudWatchClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.Dimension dimension
  [m7374]
  (clojure.core/let
   [bean7373 (new com.amazonaws.services.cloudwatch.model.Dimension)]
   (clojure.core/when-let
    [v7375 (:name m7374)]
    (. bean7373 setName (clojure.core/str v7375)))
   (clojure.core/when-let
    [v7375 (:value m7374)]
    (. bean7373 setValue (clojure.core/str v7375)))
   bean7373))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.StandardUnit standard-unit
  [m7377]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudwatch.model.StandardUnit
   (clojure.core/name m7377)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.StatisticSet statistic-set
  [m7380]
  (clojure.core/let
   [bean7379
    (new com.amazonaws.services.cloudwatch.model.StatisticSet)]
   (clojure.core/when-let
    [v7381 (:sample-count m7380)]
    (. bean7379 setSampleCount (clojure.core/double v7381)))
   (clojure.core/when-let
    [v7381 (:sum m7380)]
    (. bean7379 setSum (clojure.core/double v7381)))
   (clojure.core/when-let
    [v7381 (:minimum m7380)]
    (. bean7379 setMinimum (clojure.core/double v7381)))
   (clojure.core/when-let
    [v7381 (:maximum m7380)]
    (. bean7379 setMaximum (clojure.core/double v7381)))
   bean7379))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.Statistic statistic
  [m7383]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudwatch.model.Statistic
   (clojure.core/name m7383)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.ComparisonOperator comparison-operator
  [m7386]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudwatch.model.ComparisonOperator
   (clojure.core/name m7386)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.HistoryItemType history-item-type
  [m7389]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudwatch.model.HistoryItemType
   (clojure.core/name m7389)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.StateValue state-value
  [m7392]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudwatch.model.StateValue
   (clojure.core/name m7392)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.DimensionFilter dimension-filter
  [m7395]
  (clojure.core/let
   [bean7394
    (new com.amazonaws.services.cloudwatch.model.DimensionFilter)]
   (clojure.core/when-let
    [v7396 (:name m7395)]
    (. bean7394 setName (clojure.core/str v7396)))
   (clojure.core/when-let
    [v7396 (:value m7395)]
    (. bean7394 setValue (clojure.core/str v7396)))
   bean7394))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.MetricDatum metric-datum
  [m7398]
  (clojure.core/let
   [bean7397 (new com.amazonaws.services.cloudwatch.model.MetricDatum)]
   (clojure.core/when-let
    [v7399 (:value m7398)]
    (. bean7397 setValue (clojure.core/double v7399)))
   (clojure.core/when-let
    [v7399 (:timestamp m7398)]
    (.
     bean7397
     setTimestamp
     (com.palletops.awaze.common/to-date v7399)))
   (clojure.core/when-let
    [v7399 (:metric-name m7398)]
    (. bean7397 setMetricName (clojure.core/str v7399)))
   (clojure.core/when-let
    [v7399 (:dimensions m7398)]
    (.
     bean7397
     setDimensions
     (clojure.core/map
      (clojure.core/fn [arg7400] (dimension arg7400))
      v7399)))
   (clojure.core/when-let
    [v7399 (:unit m7398)]
    (. bean7397 setUnit (clojure.core/str v7399)))
   (clojure.core/when-let
    [v7399 (:unit m7398)]
    (. bean7397 setUnit (standard-unit v7399)))
   (clojure.core/when-let
    [v7399 (:statistic-values m7398)]
    (. bean7397 setStatisticValues (statistic-set v7399)))
   bean7397))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest put-metric-alarm-request
  [m7402]
  (clojure.core/let
   [bean7401
    (new
     com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest)]
   (clojure.core/when-let
    [v7403 (:threshold m7402)]
    (. bean7401 setThreshold (clojure.core/double v7403)))
   (clojure.core/when-let
    [v7403 (:alarm-name m7402)]
    (. bean7401 setAlarmName (clojure.core/str v7403)))
   (clojure.core/when-let
    [v7403 (:alarm-description m7402)]
    (. bean7401 setAlarmDescription (clojure.core/str v7403)))
   (clojure.core/when-let
    [v7403 (:actions-enabled m7402)]
    (. bean7401 setActionsEnabled (clojure.core/boolean v7403)))
   (clojure.core/when-let
    [v7403 (:okactions m7402)]
    (.
     bean7401
     setOKActions
     (clojure.core/map
      (clojure.core/fn [arg7404] (clojure.core/str arg7404))
      v7403)))
   (clojure.core/when-let
    [v7403 (:alarm-actions m7402)]
    (.
     bean7401
     setAlarmActions
     (clojure.core/map
      (clojure.core/fn [arg7405] (clojure.core/str arg7405))
      v7403)))
   (clojure.core/when-let
    [v7403 (:insufficient-data-actions m7402)]
    (.
     bean7401
     setInsufficientDataActions
     (clojure.core/map
      (clojure.core/fn [arg7406] (clojure.core/str arg7406))
      v7403)))
   (clojure.core/when-let
    [v7403 (:metric-name m7402)]
    (. bean7401 setMetricName (clojure.core/str v7403)))
   (clojure.core/when-let
    [v7403 (:statistic m7402)]
    (. bean7401 setStatistic (clojure.core/str v7403)))
   (clojure.core/when-let
    [v7403 (:statistic m7402)]
    (. bean7401 setStatistic (statistic v7403)))
   (clojure.core/when-let
    [v7403 (:dimensions m7402)]
    (.
     bean7401
     setDimensions
     (clojure.core/map
      (clojure.core/fn [arg7407] (dimension arg7407))
      v7403)))
   (clojure.core/when-let
    [v7403 (:period m7402)]
    (. bean7401 setPeriod (clojure.core/int v7403)))
   (clojure.core/when-let
    [v7403 (:unit m7402)]
    (. bean7401 setUnit (standard-unit v7403)))
   (clojure.core/when-let
    [v7403 (:unit m7402)]
    (. bean7401 setUnit (clojure.core/str v7403)))
   (clojure.core/when-let
    [v7403 (:evaluation-periods m7402)]
    (. bean7401 setEvaluationPeriods (clojure.core/int v7403)))
   (clojure.core/when-let
    [v7403 (:comparison-operator m7402)]
    (. bean7401 setComparisonOperator (clojure.core/str v7403)))
   (clojure.core/when-let
    [v7403 (:comparison-operator m7402)]
    (. bean7401 setComparisonOperator (comparison-operator v7403)))
   (clojure.core/when-let
    [v7403 (:namespace m7402)]
    (. bean7401 setNamespace (clojure.core/str v7403)))
   bean7401))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest describe-alarm-history-request
  [m7409]
  (clojure.core/let
   [bean7408
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest)]
   (clojure.core/when-let
    [v7410 (:alarm-name m7409)]
    (. bean7408 setAlarmName (clojure.core/str v7410)))
   (clojure.core/when-let
    [v7410 (:history-item-type m7409)]
    (. bean7408 setHistoryItemType (clojure.core/str v7410)))
   (clojure.core/when-let
    [v7410 (:history-item-type m7409)]
    (. bean7408 setHistoryItemType (history-item-type v7410)))
   (clojure.core/when-let
    [v7410 (:start-date m7409)]
    (.
     bean7408
     setStartDate
     (com.palletops.awaze.common/to-date v7410)))
   (clojure.core/when-let
    [v7410 (:end-date m7409)]
    (. bean7408 setEndDate (com.palletops.awaze.common/to-date v7410)))
   (clojure.core/when-let
    [v7410 (:next-token m7409)]
    (. bean7408 setNextToken (clojure.core/str v7410)))
   (clojure.core/when-let
    [v7410 (:max-records m7409)]
    (. bean7408 setMaxRecords (clojure.core/int v7410)))
   bean7408))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest set-alarm-state-request
  [m7412]
  (clojure.core/let
   [bean7411
    (new com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest)]
   (clojure.core/when-let
    [v7413 (:alarm-name m7412)]
    (. bean7411 setAlarmName (clojure.core/str v7413)))
   (clojure.core/when-let
    [v7413 (:state-value m7412)]
    (. bean7411 setStateValue (state-value v7413)))
   (clojure.core/when-let
    [v7413 (:state-value m7412)]
    (. bean7411 setStateValue (clojure.core/str v7413)))
   (clojure.core/when-let
    [v7413 (:state-reason m7412)]
    (. bean7411 setStateReason (clojure.core/str v7413)))
   (clojure.core/when-let
    [v7413 (:state-reason-data m7412)]
    (. bean7411 setStateReasonData (clojure.core/str v7413)))
   bean7411))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.ListMetricsRequest list-metrics-request
  [m7415]
  (clojure.core/let
   [bean7414
    (new com.amazonaws.services.cloudwatch.model.ListMetricsRequest)]
   (clojure.core/when-let
    [v7416 (:metric-name m7415)]
    (. bean7414 setMetricName (clojure.core/str v7416)))
   (clojure.core/when-let
    [v7416 (:dimensions m7415)]
    (.
     bean7414
     setDimensions
     (clojure.core/map
      (clojure.core/fn [arg7417] (dimension-filter arg7417))
      v7416)))
   (clojure.core/when-let
    [v7416 (:next-token m7415)]
    (. bean7414 setNextToken (clojure.core/str v7416)))
   (clojure.core/when-let
    [v7416 (:namespace m7415)]
    (. bean7414 setNamespace (clojure.core/str v7416)))
   bean7414))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest get-metric-statistics-request
  [m7419]
  (clojure.core/let
   [bean7418
    (new
     com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest)]
   (clojure.core/when-let
    [v7420 (:metric-name m7419)]
    (. bean7418 setMetricName (clojure.core/str v7420)))
   (clojure.core/when-let
    [v7420 (:dimensions m7419)]
    (.
     bean7418
     setDimensions
     (clojure.core/map
      (clojure.core/fn [arg7421] (dimension arg7421))
      v7420)))
   (clojure.core/when-let
    [v7420 (:period m7419)]
    (. bean7418 setPeriod (clojure.core/int v7420)))
   (clojure.core/when-let
    [v7420 (:unit m7419)]
    (. bean7418 setUnit (clojure.core/str v7420)))
   (clojure.core/when-let
    [v7420 (:unit m7419)]
    (. bean7418 setUnit (standard-unit v7420)))
   (clojure.core/when-let
    [v7420 (:statistics m7419)]
    (.
     bean7418
     setStatistics
     (clojure.core/map
      (clojure.core/fn [arg7422] (clojure.core/str arg7422))
      v7420)))
   (clojure.core/when-let
    [v7420 (:namespace m7419)]
    (. bean7418 setNamespace (clojure.core/str v7420)))
   (clojure.core/when-let
    [v7420 (:start-time m7419)]
    (.
     bean7418
     setStartTime
     (com.palletops.awaze.common/to-date v7420)))
   (clojure.core/when-let
    [v7420 (:end-time m7419)]
    (. bean7418 setEndTime (com.palletops.awaze.common/to-date v7420)))
   bean7418))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest disable-alarm-actions-request
  [m7424]
  (clojure.core/let
   [bean7423
    (new
     com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest)]
   (clojure.core/when-let
    [v7425 (:alarm-names m7424)]
    (.
     bean7423
     setAlarmNames
     (clojure.core/map
      (clojure.core/fn [arg7426] (clojure.core/str arg7426))
      v7425)))
   bean7423))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest enable-alarm-actions-request
  [m7428]
  (clojure.core/let
   [bean7427
    (new
     com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest)]
   (clojure.core/when-let
    [v7429 (:alarm-names m7428)]
    (.
     bean7427
     setAlarmNames
     (clojure.core/map
      (clojure.core/fn [arg7430] (clojure.core/str arg7430))
      v7429)))
   bean7427))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.PutMetricDataRequest put-metric-data-request
  [m7432]
  (clojure.core/let
   [bean7431
    (new com.amazonaws.services.cloudwatch.model.PutMetricDataRequest)]
   (clojure.core/when-let
    [v7433 (:metric-data m7432)]
    (.
     bean7431
     setMetricData
     (clojure.core/map
      (clojure.core/fn [arg7434] (metric-datum arg7434))
      v7433)))
   (clojure.core/when-let
    [v7433 (:namespace m7432)]
    (. bean7431 setNamespace (clojure.core/str v7433)))
   bean7431))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest describe-alarms-for-metric-request
  [m7436]
  (clojure.core/let
   [bean7435
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest)]
   (clojure.core/when-let
    [v7437 (:metric-name m7436)]
    (. bean7435 setMetricName (clojure.core/str v7437)))
   (clojure.core/when-let
    [v7437 (:statistic m7436)]
    (. bean7435 setStatistic (statistic v7437)))
   (clojure.core/when-let
    [v7437 (:statistic m7436)]
    (. bean7435 setStatistic (clojure.core/str v7437)))
   (clojure.core/when-let
    [v7437 (:dimensions m7436)]
    (.
     bean7435
     setDimensions
     (clojure.core/map
      (clojure.core/fn [arg7438] (dimension arg7438))
      v7437)))
   (clojure.core/when-let
    [v7437 (:period m7436)]
    (. bean7435 setPeriod (clojure.core/int v7437)))
   (clojure.core/when-let
    [v7437 (:unit m7436)]
    (. bean7435 setUnit (standard-unit v7437)))
   (clojure.core/when-let
    [v7437 (:unit m7436)]
    (. bean7435 setUnit (clojure.core/str v7437)))
   (clojure.core/when-let
    [v7437 (:namespace m7436)]
    (. bean7435 setNamespace (clojure.core/str v7437)))
   bean7435))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest describe-alarms-request
  [m7440]
  (clojure.core/let
   [bean7439
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest)]
   (clojure.core/when-let
    [v7441 (:alarm-names m7440)]
    (.
     bean7439
     setAlarmNames
     (clojure.core/map
      (clojure.core/fn [arg7442] (clojure.core/str arg7442))
      v7441)))
   (clojure.core/when-let
    [v7441 (:alarm-name-prefix m7440)]
    (. bean7439 setAlarmNamePrefix (clojure.core/str v7441)))
   (clojure.core/when-let
    [v7441 (:state-value m7440)]
    (. bean7439 setStateValue (clojure.core/str v7441)))
   (clojure.core/when-let
    [v7441 (:state-value m7440)]
    (. bean7439 setStateValue (state-value v7441)))
   (clojure.core/when-let
    [v7441 (:action-prefix m7440)]
    (. bean7439 setActionPrefix (clojure.core/str v7441)))
   (clojure.core/when-let
    [v7441 (:next-token m7440)]
    (. bean7439 setNextToken (clojure.core/str v7441)))
   (clojure.core/when-let
    [v7441 (:max-records m7440)]
    (. bean7439 setMaxRecords (clojure.core/int v7441)))
   bean7439))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest delete-alarms-request
  [m7444]
  (clojure.core/let
   [bean7443
    (new com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest)]
   (clojure.core/when-let
    [v7445 (:alarm-names m7444)]
    (.
     bean7443
     setAlarmNames
     (clojure.core/map
      (clojure.core/fn [arg7446] (clojure.core/str arg7446))
      v7445)))
   bean7443))
 (clojure.core/defmulti
  cloudwatch
  (clojure.core/fn cloudwatch [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-alarm
   [m7447]
   (clojure.core/let
    [credentials7448 (:credentials m7447) args7449 (:args m7447)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7450
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials7448)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7450
       putMetricAlarm
       (put-metric-alarm-request (clojure.core/nth args7449 0)))))))
  (clojure.core/defn
   put-metric-alarm-map
   {:arglists
    '[[credentials
       {:keys
        [period
         evaluation-periods
         request-metric-collector
         metric-name
         namespace
         insufficient-data-actions
         alarm-actions
         threshold
         alarm-description
         comparison-operator
         statistic
         alarm-name
         unit
         okactions
         dimensions
         actions-enabled]}]],
    :doc "Generate map for putMetricAlarm"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :put-metric-alarm,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   put-metric-alarm
   {:arglists
    '[[credentials
       {:keys
        [period
         evaluation-periods
         request-metric-collector
         metric-name
         namespace
         insufficient-data-actions
         alarm-actions
         threshold
         alarm-description
         comparison-operator
         statistic
         alarm-name
         unit
         okactions
         dimensions
         actions-enabled]}]],
    :doc "Call putMetricAlarm"}
   [credentials7452 & args7453]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7454
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials7452)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7454
      putMetricAlarm
      (put-metric-alarm-request (clojure.core/nth args7453 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarm-history
   [m7455]
   (clojure.core/let
    [credentials7456 (:credentials m7455) args7457 (:args m7455)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7458
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials7456)]
     (clojure.core/case
      (clojure.core/count args7457)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7458
        describeAlarmHistory
        (describe-alarm-history-request
         (clojure.core/nth args7457 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7458
        describeAlarmHistory))))))
  (clojure.core/defn
   describe-alarm-history-map
   {:arglists
    '[[credentials
       {:keys
        [alarm-name
         history-item-type
         max-records
         start-date
         next-token
         request-metric-collector
         end-date]}]
      [credentials]],
    :doc "Generate map for describeAlarmHistory, describeAlarmHistory"}
   ([credentials__577__auto__]
    {:args [],
     :client :cloudwatch,
     :fn :describe-alarm-history,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :describe-alarm-history,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-alarm-history
   {:arglists
    '[[credentials
       {:keys
        [alarm-name
         history-item-type
         max-records
         start-date
         next-token
         request-metric-collector
         end-date]}]
      [credentials]],
    :doc "Call describeAlarmHistory, describeAlarmHistory"}
   [credentials7460 & args7461]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7462
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials7460)]
    (clojure.core/case
     (clojure.core/count args7461)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7462
       describeAlarmHistory
       (describe-alarm-history-request (clojure.core/nth args7461 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7462
       describeAlarmHistory))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :set-alarm-state
   [m7463]
   (clojure.core/let
    [credentials7464 (:credentials m7463) args7465 (:args m7463)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7466
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials7464)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7466
       setAlarmState
       (set-alarm-state-request (clojure.core/nth args7465 0)))))))
  (clojure.core/defn
   set-alarm-state-map
   {:arglists
    '[[credentials
       {:keys
        [state-value
         state-reason-data
         state-reason
         request-metric-collector
         alarm-name]}]],
    :doc "Generate map for setAlarmState"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :set-alarm-state,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-alarm-state
   {:arglists
    '[[credentials
       {:keys
        [state-value
         state-reason-data
         state-reason
         request-metric-collector
         alarm-name]}]],
    :doc "Call setAlarmState"}
   [credentials7468 & args7469]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7470
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials7468)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7470
      setAlarmState
      (set-alarm-state-request (clojure.core/nth args7469 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :list-metrics
   [m7471]
   (clojure.core/let
    [credentials7472 (:credentials m7471) args7473 (:args m7471)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7474
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials7472)]
     (clojure.core/case
      (clojure.core/count args7473)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7474
        listMetrics))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7474
        listMetrics
        (list-metrics-request (clojure.core/nth args7473 0))))))))
  (clojure.core/defn
   list-metrics-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         next-token
         namespace
         metric-name
         dimensions]}]],
    :doc "Generate map for listMetrics, listMetrics"}
   ([credentials__577__auto__]
    {:args [],
     :client :cloudwatch,
     :fn :list-metrics,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :list-metrics,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-metrics
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         next-token
         namespace
         metric-name
         dimensions]}]],
    :doc "Call listMetrics, listMetrics"}
   [credentials7476 & args7477]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7478
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials7476)]
    (clojure.core/case
     (clojure.core/count args7477)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7478
       listMetrics))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7478
       listMetrics
       (list-metrics-request (clojure.core/nth args7477 0))))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :get-metric-statistics
   [m7479]
   (clojure.core/let
    [credentials7480 (:credentials m7479) args7481 (:args m7479)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7482
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials7480)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7482
       getMetricStatistics
       (get-metric-statistics-request
        (clojure.core/nth args7481 0)))))))
  (clojure.core/defn
   get-metric-statistics-map
   {:arglists
    '[[credentials
       {:keys
        [end-time
         period
         request-metric-collector
         metric-name
         namespace
         start-time
         unit
         dimensions
         statistics]}]],
    :doc "Generate map for getMetricStatistics"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :get-metric-statistics,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-metric-statistics
   {:arglists
    '[[credentials
       {:keys
        [end-time
         period
         request-metric-collector
         metric-name
         namespace
         start-time
         unit
         dimensions
         statistics]}]],
    :doc "Call getMetricStatistics"}
   [credentials7484 & args7485]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7486
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials7484)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7486
      getMetricStatistics
      (get-metric-statistics-request
       (clojure.core/nth args7485 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :disable-alarm-actions
   [m7487]
   (clojure.core/let
    [credentials7488 (:credentials m7487) args7489 (:args m7487)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7490
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials7488)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7490
       disableAlarmActions
       (disable-alarm-actions-request
        (clojure.core/nth args7489 0)))))))
  (clojure.core/defn
   disable-alarm-actions-map
   {:arglists
    '[[credentials {:keys [request-metric-collector alarm-names]}]],
    :doc "Generate map for disableAlarmActions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :disable-alarm-actions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   disable-alarm-actions
   {:arglists
    '[[credentials {:keys [request-metric-collector alarm-names]}]],
    :doc "Call disableAlarmActions"}
   [credentials7492 & args7493]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7494
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials7492)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7494
      disableAlarmActions
      (disable-alarm-actions-request
       (clojure.core/nth args7493 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :enable-alarm-actions
   [m7495]
   (clojure.core/let
    [credentials7496 (:credentials m7495) args7497 (:args m7495)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7498
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials7496)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7498
       enableAlarmActions
       (enable-alarm-actions-request
        (clojure.core/nth args7497 0)))))))
  (clojure.core/defn
   enable-alarm-actions-map
   {:arglists
    '[[credentials {:keys [request-metric-collector alarm-names]}]],
    :doc "Generate map for enableAlarmActions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :enable-alarm-actions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   enable-alarm-actions
   {:arglists
    '[[credentials {:keys [request-metric-collector alarm-names]}]],
    :doc "Call enableAlarmActions"}
   [credentials7500 & args7501]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7502
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials7500)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7502
      enableAlarmActions
      (enable-alarm-actions-request (clojure.core/nth args7501 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-data
   [m7503]
   (clojure.core/let
    [credentials7504 (:credentials m7503) args7505 (:args m7503)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7506
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials7504)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7506
       putMetricData
       (put-metric-data-request (clojure.core/nth args7505 0)))))))
  (clojure.core/defn
   put-metric-data-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector namespace metric-data]}]],
    :doc "Generate map for putMetricData"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :put-metric-data,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   put-metric-data
   {:arglists
    '[[credentials
       {:keys [request-metric-collector namespace metric-data]}]],
    :doc "Call putMetricData"}
   [credentials7508 & args7509]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7510
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials7508)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7510
      putMetricData
      (put-metric-data-request (clojure.core/nth args7509 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms-for-metric
   [m7511]
   (clojure.core/let
    [credentials7512 (:credentials m7511) args7513 (:args m7511)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7514
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials7512)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7514
       describeAlarmsForMetric
       (describe-alarms-for-metric-request
        (clojure.core/nth args7513 0)))))))
  (clojure.core/defn
   describe-alarms-for-metric-map
   {:arglists
    '[[credentials
       {:keys
        [dimensions
         unit
         statistic
         namespace
         metric-name
         request-metric-collector
         period]}]],
    :doc "Generate map for describeAlarmsForMetric"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :describe-alarms-for-metric,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-alarms-for-metric
   {:arglists
    '[[credentials
       {:keys
        [dimensions
         unit
         statistic
         namespace
         metric-name
         request-metric-collector
         period]}]],
    :doc "Call describeAlarmsForMetric"}
   [credentials7516 & args7517]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7518
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials7516)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7518
      describeAlarmsForMetric
      (describe-alarms-for-metric-request
       (clojure.core/nth args7517 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms
   [m7519]
   (clojure.core/let
    [credentials7520 (:credentials m7519) args7521 (:args m7519)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7522
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials7520)]
     (clojure.core/case
      (clojure.core/count args7521)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7522
        describeAlarms))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7522
        describeAlarms
        (describe-alarms-request (clojure.core/nth args7521 0))))))))
  (clojure.core/defn
   describe-alarms-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [alarm-names
         action-prefix
         max-records
         state-value
         next-token
         alarm-name-prefix
         request-metric-collector]}]],
    :doc "Generate map for describeAlarms, describeAlarms"}
   ([credentials__577__auto__]
    {:args [],
     :client :cloudwatch,
     :fn :describe-alarms,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :describe-alarms,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-alarms
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [alarm-names
         action-prefix
         max-records
         state-value
         next-token
         alarm-name-prefix
         request-metric-collector]}]],
    :doc "Call describeAlarms, describeAlarms"}
   [credentials7524 & args7525]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7526
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials7524)]
    (clojure.core/case
     (clojure.core/count args7525)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7526
       describeAlarms))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7526
       describeAlarms
       (describe-alarms-request (clojure.core/nth args7525 0))))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :delete-alarms
   [m7527]
   (clojure.core/let
    [credentials7528 (:credentials m7527) args7529 (:args m7527)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7530
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials7528)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7530
       deleteAlarms
       (delete-alarms-request (clojure.core/nth args7529 0)))))))
  (clojure.core/defn
   delete-alarms-map
   {:arglists
    '[[credentials {:keys [request-metric-collector alarm-names]}]],
    :doc "Generate map for deleteAlarms"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :delete-alarms,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-alarms
   {:arglists
    '[[credentials {:keys [request-metric-collector alarm-names]}]],
    :doc "Call deleteAlarms"}
   [credentials7532 & args7533]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7534
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials7532)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client7534
      deleteAlarms
      (delete-alarms-request (clojure.core/nth args7533 0))))))))
