(ns com.palletops.awaze.cloudsearch (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudsearch
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.cloudsearch.AmazonCloudSearchClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.SourceDataFunction source-data-function
  [m7116]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudsearch.model.SourceDataFunction
   (clojure.core/name m7116)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.SourceData source-data
  [m7119]
  (clojure.core/let
   [bean7118 (new com.amazonaws.services.cloudsearch.model.SourceData)]
   (clojure.core/when-let
    [v7120 (:source-name m7119)]
    (. bean7118 setSourceName (clojure.core/str v7120)))
   (clojure.core/when-let
    [v7120 (:default-value m7119)]
    (. bean7118 setDefaultValue (clojure.core/str v7120)))
   bean7118))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle source-data-trim-title
  [m7122]
  (clojure.core/let
   [bean7121
    (new com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle)]
   (clojure.core/when-let
    [v7123 (:source-name m7122)]
    (. bean7121 setSourceName (clojure.core/str v7123)))
   (clojure.core/when-let
    [v7123 (:separator m7122)]
    (. bean7121 setSeparator (clojure.core/str v7123)))
   (clojure.core/when-let
    [v7123 (:language m7122)]
    (. bean7121 setLanguage (clojure.core/str v7123)))
   (clojure.core/when-let
    [v7123 (:default-value m7122)]
    (. bean7121 setDefaultValue (clojure.core/str v7123)))
   bean7121))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.SourceDataMap source-data-map
  [m7125]
  (clojure.core/let
   [bean7124
    (new com.amazonaws.services.cloudsearch.model.SourceDataMap)]
   (clojure.core/when-let
    [v7126 (:source-name m7125)]
    (. bean7124 setSourceName (clojure.core/str v7126)))
   (clojure.core/when-let
    [v7126 (:cases m7125)]
    (.
     bean7124
     setCases
     (clojure.core/zipmap
      (clojure.core/map
       (clojure.core/fn [arg7127] (clojure.core/str arg7127))
       (clojure.core/keys v7126))
      (clojure.core/map
       (clojure.core/fn [arg7127] (clojure.core/str arg7127))
       (clojure.core/vals v7126)))))
   (clojure.core/when-let
    [v7126 (:default-value m7125)]
    (. bean7124 setDefaultValue (clojure.core/str v7126)))
   bean7124))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.IndexFieldType index-field-type
  [m7129]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudsearch.model.IndexFieldType
   (clojure.core/name m7129)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.UIntOptions uint-options
  [m7132]
  (clojure.core/let
   [bean7131
    (new com.amazonaws.services.cloudsearch.model.UIntOptions)]
   (clojure.core/when-let
    [v7133 (:default-value m7132)]
    (. bean7131 setDefaultValue (clojure.core/int v7133)))
   bean7131))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.LiteralOptions literal-options
  [m7135]
  (clojure.core/let
   [bean7134
    (new com.amazonaws.services.cloudsearch.model.LiteralOptions)]
   (clojure.core/when-let
    [v7136 (:search-enabled m7135)]
    (. bean7134 setSearchEnabled (clojure.core/boolean v7136)))
   (clojure.core/when-let
    [v7136 (:facet-enabled m7135)]
    (. bean7134 setFacetEnabled (clojure.core/boolean v7136)))
   (clojure.core/when-let
    [v7136 (:result-enabled m7135)]
    (. bean7134 setResultEnabled (clojure.core/boolean v7136)))
   (clojure.core/when-let
    [v7136 (:default-value m7135)]
    (. bean7134 setDefaultValue (clojure.core/str v7136)))
   bean7134))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.TextOptions text-options
  [m7138]
  (clojure.core/let
   [bean7137
    (new com.amazonaws.services.cloudsearch.model.TextOptions)]
   (clojure.core/when-let
    [v7139 (:facet-enabled m7138)]
    (. bean7137 setFacetEnabled (clojure.core/boolean v7139)))
   (clojure.core/when-let
    [v7139 (:result-enabled m7138)]
    (. bean7137 setResultEnabled (clojure.core/boolean v7139)))
   (clojure.core/when-let
    [v7139 (:text-processor m7138)]
    (. bean7137 setTextProcessor (clojure.core/str v7139)))
   (clojure.core/when-let
    [v7139 (:default-value m7138)]
    (. bean7137 setDefaultValue (clojure.core/str v7139)))
   bean7137))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.SourceAttribute source-attribute
  [m7141]
  (clojure.core/let
   [bean7140
    (new com.amazonaws.services.cloudsearch.model.SourceAttribute)]
   (clojure.core/when-let
    [v7142 (:source-data-function m7141)]
    (. bean7140 setSourceDataFunction (clojure.core/str v7142)))
   (clojure.core/when-let
    [v7142 (:source-data-function m7141)]
    (. bean7140 setSourceDataFunction (source-data-function v7142)))
   (clojure.core/when-let
    [v7142 (:source-data-copy m7141)]
    (. bean7140 setSourceDataCopy (source-data v7142)))
   (clojure.core/when-let
    [v7142 (:source-data-trim-title m7141)]
    (. bean7140 setSourceDataTrimTitle (source-data-trim-title v7142)))
   (clojure.core/when-let
    [v7142 (:source-data-map m7141)]
    (. bean7140 setSourceDataMap (source-data-map v7142)))
   bean7140))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.IndexField index-field
  [m7144]
  (clojure.core/let
   [bean7143 (new com.amazonaws.services.cloudsearch.model.IndexField)]
   (clojure.core/when-let
    [v7145 (:index-field-name m7144)]
    (. bean7143 setIndexFieldName (clojure.core/str v7145)))
   (clojure.core/when-let
    [v7145 (:index-field-type m7144)]
    (. bean7143 setIndexFieldType (clojure.core/str v7145)))
   (clojure.core/when-let
    [v7145 (:index-field-type m7144)]
    (. bean7143 setIndexFieldType (index-field-type v7145)))
   (clojure.core/when-let
    [v7145 (:uint-options m7144)]
    (. bean7143 setUIntOptions (uint-options v7145)))
   (clojure.core/when-let
    [v7145 (:literal-options m7144)]
    (. bean7143 setLiteralOptions (literal-options v7145)))
   (clojure.core/when-let
    [v7145 (:text-options m7144)]
    (. bean7143 setTextOptions (text-options v7145)))
   (clojure.core/when-let
    [v7145 (:source-attributes m7144)]
    (.
     bean7143
     setSourceAttributes
     (clojure.core/map
      (clojure.core/fn [arg7146] (source-attribute arg7146))
      v7145)))
   bean7143))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.NamedRankExpression named-rank-expression
  [m7148]
  (clojure.core/let
   [bean7147
    (new com.amazonaws.services.cloudsearch.model.NamedRankExpression)]
   (clojure.core/when-let
    [v7149 (:rank-name m7148)]
    (. bean7147 setRankName (clojure.core/str v7149)))
   (clojure.core/when-let
    [v7149 (:rank-expression m7148)]
    (. bean7147 setRankExpression (clojure.core/str v7149)))
   bean7147))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest update-default-search-field-request
  [m7151]
  (clojure.core/let
   [bean7150
    (new
     com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest)]
   (clojure.core/when-let
    [v7152 (:domain-name m7151)]
    (. bean7150 setDomainName (clojure.core/str v7152)))
   (clojure.core/when-let
    [v7152 (:default-search-field m7151)]
    (. bean7150 setDefaultSearchField (clojure.core/str v7152)))
   bean7150))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest describe-service-access-policies-request
  [m7154]
  (clojure.core/let
   [bean7153
    (new
     com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest)]
   (clojure.core/when-let
    [v7155 (:domain-name m7154)]
    (. bean7153 setDomainName (clojure.core/str v7155)))
   bean7153))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest describe-domains-request
  [m7157]
  (clojure.core/let
   [bean7156
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest)]
   (clojure.core/when-let
    [v7158 (:domain-names m7157)]
    (.
     bean7156
     setDomainNames
     (clojure.core/map
      (clojure.core/fn [arg7159] (clojure.core/str arg7159))
      v7158)))
   bean7156))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest define-index-field-request
  [m7161]
  (clojure.core/let
   [bean7160
    (new
     com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest)]
   (clojure.core/when-let
    [v7162 (:domain-name m7161)]
    (. bean7160 setDomainName (clojure.core/str v7162)))
   (clojure.core/when-let
    [v7162 (:index-field m7161)]
    (. bean7160 setIndexField (index-field v7162)))
   bean7160))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest define-rank-expression-request
  [m7164]
  (clojure.core/let
   [bean7163
    (new
     com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest)]
   (clojure.core/when-let
    [v7165 (:domain-name m7164)]
    (. bean7163 setDomainName (clojure.core/str v7165)))
   (clojure.core/when-let
    [v7165 (:rank-expression m7164)]
    (. bean7163 setRankExpression (named-rank-expression v7165)))
   bean7163))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest update-stopword-options-request
  [m7167]
  (clojure.core/let
   [bean7166
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest)]
   (clojure.core/when-let
    [v7168 (:domain-name m7167)]
    (. bean7166 setDomainName (clojure.core/str v7168)))
   (clojure.core/when-let
    [v7168 (:stopwords m7167)]
    (. bean7166 setStopwords (clojure.core/str v7168)))
   bean7166))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest delete-rank-expression-request
  [m7170]
  (clojure.core/let
   [bean7169
    (new
     com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest)]
   (clojure.core/when-let
    [v7171 (:domain-name m7170)]
    (. bean7169 setDomainName (clojure.core/str v7171)))
   (clojure.core/when-let
    [v7171 (:rank-name m7170)]
    (. bean7169 setRankName (clojure.core/str v7171)))
   bean7169))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest describe-default-search-field-request
  [m7173]
  (clojure.core/let
   [bean7172
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest)]
   (clojure.core/when-let
    [v7174 (:domain-name m7173)]
    (. bean7172 setDomainName (clojure.core/str v7174)))
   bean7172))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.CreateDomainRequest create-domain-request
  [m7176]
  (clojure.core/let
   [bean7175
    (new com.amazonaws.services.cloudsearch.model.CreateDomainRequest)]
   (clojure.core/when-let
    [v7177 (:domain-name m7176)]
    (. bean7175 setDomainName (clojure.core/str v7177)))
   bean7175))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest describe-stemming-options-request
  [m7179]
  (clojure.core/let
   [bean7178
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest)]
   (clojure.core/when-let
    [v7180 (:domain-name m7179)]
    (. bean7178 setDomainName (clojure.core/str v7180)))
   bean7178))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest describe-index-fields-request
  [m7182]
  (clojure.core/let
   [bean7181
    (new
     com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest)]
   (clojure.core/when-let
    [v7183 (:domain-name m7182)]
    (. bean7181 setDomainName (clojure.core/str v7183)))
   (clojure.core/when-let
    [v7183 (:field-names m7182)]
    (.
     bean7181
     setFieldNames
     (clojure.core/map
      (clojure.core/fn [arg7184] (clojure.core/str arg7184))
      v7183)))
   bean7181))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest delete-index-field-request
  [m7186]
  (clojure.core/let
   [bean7185
    (new
     com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest)]
   (clojure.core/when-let
    [v7187 (:domain-name m7186)]
    (. bean7185 setDomainName (clojure.core/str v7187)))
   (clojure.core/when-let
    [v7187 (:index-field-name m7186)]
    (. bean7185 setIndexFieldName (clojure.core/str v7187)))
   bean7185))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest describe-stopword-options-request
  [m7189]
  (clojure.core/let
   [bean7188
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest)]
   (clojure.core/when-let
    [v7190 (:domain-name m7189)]
    (. bean7188 setDomainName (clojure.core/str v7190)))
   bean7188))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest describe-synonym-options-request
  [m7192]
  (clojure.core/let
   [bean7191
    (new
     com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest)]
   (clojure.core/when-let
    [v7193 (:domain-name m7192)]
    (. bean7191 setDomainName (clojure.core/str v7193)))
   bean7191))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest update-synonym-options-request
  [m7195]
  (clojure.core/let
   [bean7194
    (new
     com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest)]
   (clojure.core/when-let
    [v7196 (:domain-name m7195)]
    (. bean7194 setDomainName (clojure.core/str v7196)))
   (clojure.core/when-let
    [v7196 (:synonyms m7195)]
    (. bean7194 setSynonyms (clojure.core/str v7196)))
   bean7194))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DeleteDomainRequest delete-domain-request
  [m7198]
  (clojure.core/let
   [bean7197
    (new com.amazonaws.services.cloudsearch.model.DeleteDomainRequest)]
   (clojure.core/when-let
    [v7199 (:domain-name m7198)]
    (. bean7197 setDomainName (clojure.core/str v7199)))
   bean7197))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest describe-rank-expressions-request
  [m7201]
  (clojure.core/let
   [bean7200
    (new
     com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest)]
   (clojure.core/when-let
    [v7202 (:domain-name m7201)]
    (. bean7200 setDomainName (clojure.core/str v7202)))
   (clojure.core/when-let
    [v7202 (:rank-names m7201)]
    (.
     bean7200
     setRankNames
     (clojure.core/map
      (clojure.core/fn [arg7203] (clojure.core/str arg7203))
      v7202)))
   bean7200))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest index-documents-request
  [m7205]
  (clojure.core/let
   [bean7204
    (new
     com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest)]
   (clojure.core/when-let
    [v7206 (:domain-name m7205)]
    (. bean7204 setDomainName (clojure.core/str v7206)))
   bean7204))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest update-service-access-policies-request
  [m7208]
  (clojure.core/let
   [bean7207
    (new
     com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest)]
   (clojure.core/when-let
    [v7209 (:domain-name m7208)]
    (. bean7207 setDomainName (clojure.core/str v7209)))
   (clojure.core/when-let
    [v7209 (:access-policies m7208)]
    (. bean7207 setAccessPolicies (clojure.core/str v7209)))
   bean7207))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest update-stemming-options-request
  [m7211]
  (clojure.core/let
   [bean7210
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest)]
   (clojure.core/when-let
    [v7212 (:domain-name m7211)]
    (. bean7210 setDomainName (clojure.core/str v7212)))
   (clojure.core/when-let
    [v7212 (:stems m7211)]
    (. bean7210 setStems (clojure.core/str v7212)))
   bean7210))
 (clojure.core/defmulti
  cloudsearch
  (clojure.core/fn cloudsearch [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-default-search-field
   [m7213]
   (clojure.core/let
    [credentials7214 (:credentials m7213) args7215 (:args m7213)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7216
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7214)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7216
       updateDefaultSearchField
       (update-default-search-field-request
        (clojure.core/nth args7215 0)))))))
  (clojure.core/defn
   update-default-search-field-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector domain-name default-search-field]}]],
    :doc "Generate map for updateDefaultSearchField"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-default-search-field,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-default-search-field
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector domain-name default-search-field]}]],
    :doc "Call updateDefaultSearchField"}
   [credentials7218 & args7219]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7220
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7218)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7220
      updateDefaultSearchField
      (update-default-search-field-request
       (clojure.core/nth args7219 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-service-access-policies
   [m7221]
   (clojure.core/let
    [credentials7222 (:credentials m7221) args7223 (:args m7221)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7224
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7222)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7224
       describeServiceAccessPolicies
       (describe-service-access-policies-request
        (clojure.core/nth args7223 0)))))))
  (clojure.core/defn
   describe-service-access-policies-map
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Generate map for describeServiceAccessPolicies"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-service-access-policies,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-service-access-policies
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Call describeServiceAccessPolicies"}
   [credentials7226 & args7227]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7228
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7226)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7228
      describeServiceAccessPolicies
      (describe-service-access-policies-request
       (clojure.core/nth args7227 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-domains
   [m7229]
   (clojure.core/let
    [credentials7230 (:credentials m7229) args7231 (:args m7229)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7232
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7230)]
     (clojure.core/case
      (clojure.core/count args7231)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7232
        describeDomains))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7232
        describeDomains
        (describe-domains-request (clojure.core/nth args7231 0))))))))
  (clojure.core/defn
   describe-domains-map
   {:arglists
    '[[credentials]
      [credentials {:keys [request-metric-collector domain-names]}]],
    :doc "Generate map for describeDomains, describeDomains"}
   ([credentials__577__auto__]
    {:args [],
     :client :cloudsearch,
     :fn :describe-domains,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-domains,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-domains
   {:arglists
    '[[credentials]
      [credentials {:keys [request-metric-collector domain-names]}]],
    :doc "Call describeDomains, describeDomains"}
   [credentials7234 & args7235]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7236
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7234)]
    (clojure.core/case
     (clojure.core/count args7235)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7236
       describeDomains))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7236
       describeDomains
       (describe-domains-request (clojure.core/nth args7235 0))))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-index-field
   [m7237]
   (clojure.core/let
    [credentials7238 (:credentials m7237) args7239 (:args m7237)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7240
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7238)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7240
       defineIndexField
       (define-index-field-request (clojure.core/nth args7239 0)))))))
  (clojure.core/defn
   define-index-field-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector index-field domain-name]}]],
    :doc "Generate map for defineIndexField"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :define-index-field,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   define-index-field
   {:arglists
    '[[credentials
       {:keys [request-metric-collector index-field domain-name]}]],
    :doc "Call defineIndexField"}
   [credentials7242 & args7243]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7244
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7242)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7244
      defineIndexField
      (define-index-field-request (clojure.core/nth args7243 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-rank-expression
   [m7245]
   (clojure.core/let
    [credentials7246 (:credentials m7245) args7247 (:args m7245)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7248
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7246)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7248
       defineRankExpression
       (define-rank-expression-request
        (clojure.core/nth args7247 0)))))))
  (clojure.core/defn
   define-rank-expression-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector rank-expression domain-name]}]],
    :doc "Generate map for defineRankExpression"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :define-rank-expression,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   define-rank-expression
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector rank-expression domain-name]}]],
    :doc "Call defineRankExpression"}
   [credentials7250 & args7251]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7252
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7250)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7252
      defineRankExpression
      (define-rank-expression-request
       (clojure.core/nth args7251 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stopword-options
   [m7253]
   (clojure.core/let
    [credentials7254 (:credentials m7253) args7255 (:args m7253)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7256
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7254)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7256
       updateStopwordOptions
       (update-stopword-options-request
        (clojure.core/nth args7255 0)))))))
  (clojure.core/defn
   update-stopword-options-map
   {:arglists
    '[[credentials
       {:keys [stopwords request-metric-collector domain-name]}]],
    :doc "Generate map for updateStopwordOptions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-stopword-options,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-stopword-options
   {:arglists
    '[[credentials
       {:keys [stopwords request-metric-collector domain-name]}]],
    :doc "Call updateStopwordOptions"}
   [credentials7258 & args7259]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7260
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7258)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7260
      updateStopwordOptions
      (update-stopword-options-request
       (clojure.core/nth args7259 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-rank-expression
   [m7261]
   (clojure.core/let
    [credentials7262 (:credentials m7261) args7263 (:args m7261)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7264
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7262)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7264
       deleteRankExpression
       (delete-rank-expression-request
        (clojure.core/nth args7263 0)))))))
  (clojure.core/defn
   delete-rank-expression-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector rank-name domain-name]}]],
    :doc "Generate map for deleteRankExpression"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :delete-rank-expression,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-rank-expression
   {:arglists
    '[[credentials
       {:keys [request-metric-collector rank-name domain-name]}]],
    :doc "Call deleteRankExpression"}
   [credentials7266 & args7267]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7268
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7266)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7268
      deleteRankExpression
      (delete-rank-expression-request
       (clojure.core/nth args7267 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-default-search-field
   [m7269]
   (clojure.core/let
    [credentials7270 (:credentials m7269) args7271 (:args m7269)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7272
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7270)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7272
       describeDefaultSearchField
       (describe-default-search-field-request
        (clojure.core/nth args7271 0)))))))
  (clojure.core/defn
   describe-default-search-field-map
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Generate map for describeDefaultSearchField"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-default-search-field,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-default-search-field
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Call describeDefaultSearchField"}
   [credentials7274 & args7275]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7276
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7274)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7276
      describeDefaultSearchField
      (describe-default-search-field-request
       (clojure.core/nth args7275 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :create-domain
   [m7277]
   (clojure.core/let
    [credentials7278 (:credentials m7277) args7279 (:args m7277)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7280
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7278)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7280
       createDomain
       (create-domain-request (clojure.core/nth args7279 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Generate map for createDomain"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :create-domain,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-domain
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Call createDomain"}
   [credentials7282 & args7283]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7284
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7282)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7284
      createDomain
      (create-domain-request (clojure.core/nth args7283 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stemming-options
   [m7285]
   (clojure.core/let
    [credentials7286 (:credentials m7285) args7287 (:args m7285)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7288
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7286)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7288
       describeStemmingOptions
       (describe-stemming-options-request
        (clojure.core/nth args7287 0)))))))
  (clojure.core/defn
   describe-stemming-options-map
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Generate map for describeStemmingOptions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-stemming-options,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-stemming-options
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Call describeStemmingOptions"}
   [credentials7290 & args7291]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7292
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7290)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7292
      describeStemmingOptions
      (describe-stemming-options-request
       (clojure.core/nth args7291 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-index-fields
   [m7293]
   (clojure.core/let
    [credentials7294 (:credentials m7293) args7295 (:args m7293)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7296
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7294)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7296
       describeIndexFields
       (describe-index-fields-request
        (clojure.core/nth args7295 0)))))))
  (clojure.core/defn
   describe-index-fields-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector field-names domain-name]}]],
    :doc "Generate map for describeIndexFields"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-index-fields,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-index-fields
   {:arglists
    '[[credentials
       {:keys [request-metric-collector field-names domain-name]}]],
    :doc "Call describeIndexFields"}
   [credentials7298 & args7299]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7300
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7298)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7300
      describeIndexFields
      (describe-index-fields-request
       (clojure.core/nth args7299 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-index-field
   [m7301]
   (clojure.core/let
    [credentials7302 (:credentials m7301) args7303 (:args m7301)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7304
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7302)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7304
       deleteIndexField
       (delete-index-field-request (clojure.core/nth args7303 0)))))))
  (clojure.core/defn
   delete-index-field-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector index-field-name domain-name]}]],
    :doc "Generate map for deleteIndexField"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :delete-index-field,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-index-field
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector index-field-name domain-name]}]],
    :doc "Call deleteIndexField"}
   [credentials7306 & args7307]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7308
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7306)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7308
      deleteIndexField
      (delete-index-field-request (clojure.core/nth args7307 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stopword-options
   [m7309]
   (clojure.core/let
    [credentials7310 (:credentials m7309) args7311 (:args m7309)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7312
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7310)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7312
       describeStopwordOptions
       (describe-stopword-options-request
        (clojure.core/nth args7311 0)))))))
  (clojure.core/defn
   describe-stopword-options-map
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Generate map for describeStopwordOptions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-stopword-options,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-stopword-options
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Call describeStopwordOptions"}
   [credentials7314 & args7315]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7316
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7314)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7316
      describeStopwordOptions
      (describe-stopword-options-request
       (clojure.core/nth args7315 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-synonym-options
   [m7317]
   (clojure.core/let
    [credentials7318 (:credentials m7317) args7319 (:args m7317)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7320
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7318)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7320
       describeSynonymOptions
       (describe-synonym-options-request
        (clojure.core/nth args7319 0)))))))
  (clojure.core/defn
   describe-synonym-options-map
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Generate map for describeSynonymOptions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-synonym-options,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-synonym-options
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Call describeSynonymOptions"}
   [credentials7322 & args7323]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7324
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7322)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7324
      describeSynonymOptions
      (describe-synonym-options-request
       (clojure.core/nth args7323 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-synonym-options
   [m7325]
   (clojure.core/let
    [credentials7326 (:credentials m7325) args7327 (:args m7325)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7328
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7326)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7328
       updateSynonymOptions
       (update-synonym-options-request
        (clojure.core/nth args7327 0)))))))
  (clojure.core/defn
   update-synonym-options-map
   {:arglists
    '[[credentials
       {:keys [synonyms request-metric-collector domain-name]}]],
    :doc "Generate map for updateSynonymOptions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-synonym-options,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-synonym-options
   {:arglists
    '[[credentials
       {:keys [synonyms request-metric-collector domain-name]}]],
    :doc "Call updateSynonymOptions"}
   [credentials7330 & args7331]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7332
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7330)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7332
      updateSynonymOptions
      (update-synonym-options-request
       (clojure.core/nth args7331 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-domain
   [m7333]
   (clojure.core/let
    [credentials7334 (:credentials m7333) args7335 (:args m7333)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7336
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7334)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7336
       deleteDomain
       (delete-domain-request (clojure.core/nth args7335 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Generate map for deleteDomain"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :delete-domain,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-domain
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Call deleteDomain"}
   [credentials7338 & args7339]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7340
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7338)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7340
      deleteDomain
      (delete-domain-request (clojure.core/nth args7339 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-rank-expressions
   [m7341]
   (clojure.core/let
    [credentials7342 (:credentials m7341) args7343 (:args m7341)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7344
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7342)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7344
       describeRankExpressions
       (describe-rank-expressions-request
        (clojure.core/nth args7343 0)))))))
  (clojure.core/defn
   describe-rank-expressions-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector rank-names domain-name]}]],
    :doc "Generate map for describeRankExpressions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-rank-expressions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-rank-expressions
   {:arglists
    '[[credentials
       {:keys [request-metric-collector rank-names domain-name]}]],
    :doc "Call describeRankExpressions"}
   [credentials7346 & args7347]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7348
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7346)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7348
      describeRankExpressions
      (describe-rank-expressions-request
       (clojure.core/nth args7347 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :index-documents
   [m7349]
   (clojure.core/let
    [credentials7350 (:credentials m7349) args7351 (:args m7349)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7352
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7350)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7352
       indexDocuments
       (index-documents-request (clojure.core/nth args7351 0)))))))
  (clojure.core/defn
   index-documents-map
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Generate map for indexDocuments"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :index-documents,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   index-documents
   {:arglists
    '[[credentials {:keys [request-metric-collector domain-name]}]],
    :doc "Call indexDocuments"}
   [credentials7354 & args7355]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7356
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7354)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7356
      indexDocuments
      (index-documents-request (clojure.core/nth args7355 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-service-access-policies
   [m7357]
   (clojure.core/let
    [credentials7358 (:credentials m7357) args7359 (:args m7357)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7360
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7358)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7360
       updateServiceAccessPolicies
       (update-service-access-policies-request
        (clojure.core/nth args7359 0)))))))
  (clojure.core/defn
   update-service-access-policies-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector domain-name access-policies]}]],
    :doc "Generate map for updateServiceAccessPolicies"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-service-access-policies,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-service-access-policies
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector domain-name access-policies]}]],
    :doc "Call updateServiceAccessPolicies"}
   [credentials7362 & args7363]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7364
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7362)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7364
      updateServiceAccessPolicies
      (update-service-access-policies-request
       (clojure.core/nth args7363 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stemming-options
   [m7365]
   (clojure.core/let
    [credentials7366 (:credentials m7365) args7367 (:args m7365)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7368
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7366)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7368
       updateStemmingOptions
       (update-stemming-options-request
        (clojure.core/nth args7367 0)))))))
  (clojure.core/defn
   update-stemming-options-map
   {:arglists
    '[[credentials
       {:keys [stems request-metric-collector domain-name]}]],
    :doc "Generate map for updateStemmingOptions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-stemming-options,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-stemming-options
   {:arglists
    '[[credentials
       {:keys [stems request-metric-collector domain-name]}]],
    :doc "Call updateStemmingOptions"}
   [credentials7370 & args7371]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7372
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7370)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client7372
      updateStemmingOptions
      (update-stemming-options-request
       (clojure.core/nth args7371 0))))))))
