(ns com.palletops.awaze.cloudfront (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudfront
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.cloudfront.AmazonCloudFrontClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CookieNames cookie-names
  [m877]
  (clojure.core/let
   [bean876 (new com.amazonaws.services.cloudfront.model.CookieNames)]
   (clojure.core/when-let
    [v878 (:quantity m877)]
    (. bean876 setQuantity (clojure.core/int v878)))
   (clojure.core/when-let
    [v878 (:items m877)]
    (.
     bean876
     setItems
     (clojure.core/map
      (clojure.core/fn [arg879] (clojure.core/str arg879))
      v878)))
   bean876))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ItemSelection item-selection
  [m881]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudfront.model.ItemSelection
   (clojure.core/name m881)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.OriginProtocolPolicy origin-protocol-policy
  [m884]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudfront.model.OriginProtocolPolicy
   (clojure.core/name m884)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CookiePreference cookie-preference
  [m887]
  (clojure.core/let
   [bean886
    (new com.amazonaws.services.cloudfront.model.CookiePreference)]
   (clojure.core/when-let
    [v888 (:whitelisted-names m887)]
    (. bean886 setWhitelistedNames (cookie-names v888)))
   (clojure.core/when-let
    [v888 (:forward m887)]
    (. bean886 setForward (clojure.core/str v888)))
   (clojure.core/when-let
    [v888 (:forward m887)]
    (. bean886 setForward (item-selection v888)))
   bean886))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.S3OriginConfig s3origin-config
  [m890]
  (clojure.core/let
   [bean889
    (new com.amazonaws.services.cloudfront.model.S3OriginConfig)]
   (clojure.core/when-let
    [v891 (:origin-access-identity m890)]
    (. bean889 setOriginAccessIdentity (clojure.core/str v891)))
   bean889))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CustomOriginConfig custom-origin-config
  [m893]
  (clojure.core/let
   [bean892
    (new com.amazonaws.services.cloudfront.model.CustomOriginConfig)]
   (clojure.core/when-let
    [v894 (:httpport m893)]
    (. bean892 setHTTPPort (clojure.core/int v894)))
   (clojure.core/when-let
    [v894 (:httpsport m893)]
    (. bean892 setHTTPSPort (clojure.core/int v894)))
   (clojure.core/when-let
    [v894 (:origin-protocol-policy m893)]
    (. bean892 setOriginProtocolPolicy (clojure.core/str v894)))
   (clojure.core/when-let
    [v894 (:origin-protocol-policy m893)]
    (. bean892 setOriginProtocolPolicy (origin-protocol-policy v894)))
   bean892))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ForwardedValues forwarded-values
  [m896]
  (clojure.core/let
   [bean895
    (new com.amazonaws.services.cloudfront.model.ForwardedValues)]
   (clojure.core/when-let
    [v897 (:query-string m896)]
    (. bean895 setQueryString (clojure.core/boolean v897)))
   (clojure.core/when-let
    [v897 (:cookies m896)]
    (. bean895 setCookies (cookie-preference v897)))
   bean895))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy viewer-protocol-policy
  [m899]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy
   (clojure.core/name m899)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.AllowedMethods allowed-methods
  [m902]
  (clojure.core/let
   [bean901
    (new com.amazonaws.services.cloudfront.model.AllowedMethods)]
   (clojure.core/when-let
    [v903 (:quantity m902)]
    (. bean901 setQuantity (clojure.core/int v903)))
   (clojure.core/when-let
    [v903 (:items m902)]
    (.
     bean901
     setItems
     (clojure.core/map
      (clojure.core/fn [arg904] (clojure.core/str arg904))
      v903)))
   bean901))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.TrustedSigners trusted-signers
  [m906]
  (clojure.core/let
   [bean905
    (new com.amazonaws.services.cloudfront.model.TrustedSigners)]
   (clojure.core/when-let
    [v907 (:quantity m906)]
    (. bean905 setQuantity (clojure.core/int v907)))
   (clojure.core/when-let
    [v907 (:items m906)]
    (.
     bean905
     setItems
     (clojure.core/map
      (clojure.core/fn [arg908] (clojure.core/str arg908))
      v907)))
   (clojure.core/when-let
    [v907 (:enabled m906)]
    (. bean905 setEnabled (clojure.core/boolean v907)))
   bean905))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.Origin origin
  [m910]
  (clojure.core/let
   [bean909 (new com.amazonaws.services.cloudfront.model.Origin)]
   (clojure.core/when-let
    [v911 (:domain-name m910)]
    (. bean909 setDomainName (clojure.core/str v911)))
   (clojure.core/when-let
    [v911 (:s3origin-config m910)]
    (. bean909 setS3OriginConfig (s3origin-config v911)))
   (clojure.core/when-let
    [v911 (:custom-origin-config m910)]
    (. bean909 setCustomOriginConfig (custom-origin-config v911)))
   (clojure.core/when-let
    [v911 (:id m910)]
    (. bean909 setId (clojure.core/str v911)))
   bean909))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CacheBehavior cache-behavior
  [m913]
  (clojure.core/let
   [bean912
    (new com.amazonaws.services.cloudfront.model.CacheBehavior)]
   (clojure.core/when-let
    [v914 (:target-origin-id m913)]
    (. bean912 setTargetOriginId (clojure.core/str v914)))
   (clojure.core/when-let
    [v914 (:forwarded-values m913)]
    (. bean912 setForwardedValues (forwarded-values v914)))
   (clojure.core/when-let
    [v914 (:viewer-protocol-policy m913)]
    (. bean912 setViewerProtocolPolicy (viewer-protocol-policy v914)))
   (clojure.core/when-let
    [v914 (:viewer-protocol-policy m913)]
    (. bean912 setViewerProtocolPolicy (clojure.core/str v914)))
   (clojure.core/when-let
    [v914 (:min-ttl m913)]
    (. bean912 setMinTTL (clojure.core/long v914)))
   (clojure.core/when-let
    [v914 (:allowed-methods m913)]
    (. bean912 setAllowedMethods (allowed-methods v914)))
   (clojure.core/when-let
    [v914 (:path-pattern m913)]
    (. bean912 setPathPattern (clojure.core/str v914)))
   (clojure.core/when-let
    [v914 (:trusted-signers m913)]
    (. bean912 setTrustedSigners (trusted-signers v914)))
   bean912))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CustomErrorResponse custom-error-response
  [m916]
  (clojure.core/let
   [bean915
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponse)]
   (clojure.core/when-let
    [v917 (:response-page-path m916)]
    (. bean915 setResponsePagePath (clojure.core/str v917)))
   (clojure.core/when-let
    [v917 (:response-code m916)]
    (. bean915 setResponseCode (clojure.core/str v917)))
   (clojure.core/when-let
    [v917 (:error-caching-min-ttl m916)]
    (. bean915 setErrorCachingMinTTL (clojure.core/long v917)))
   (clojure.core/when-let
    [v917 (:error-code m916)]
    (. bean915 setErrorCode (clojure.core/int v917)))
   bean915))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.S3Origin s3origin
  [m919]
  (clojure.core/let
   [bean918 (new com.amazonaws.services.cloudfront.model.S3Origin)]
   (clojure.core/when-let
    [v920 (:domain-name m919)]
    (. bean918 setDomainName (clojure.core/str v920)))
   (clojure.core/when-let
    [v920 (:origin-access-identity m919)]
    (. bean918 setOriginAccessIdentity (clojure.core/str v920)))
   bean918))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.Aliases aliases
  [m922]
  (clojure.core/let
   [bean921 (new com.amazonaws.services.cloudfront.model.Aliases)]
   (clojure.core/when-let
    [v923 (:quantity m922)]
    (. bean921 setQuantity (clojure.core/int v923)))
   (clojure.core/when-let
    [v923 (:items m922)]
    (.
     bean921
     setItems
     (clojure.core/map
      (clojure.core/fn [arg924] (clojure.core/str arg924))
      v923)))
   bean921))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.StreamingLoggingConfig streaming-logging-config
  [m926]
  (clojure.core/let
   [bean925
    (new
     com.amazonaws.services.cloudfront.model.StreamingLoggingConfig)]
   (clojure.core/when-let
    [v927 (:bucket m926)]
    (. bean925 setBucket (clojure.core/str v927)))
   (clojure.core/when-let
    [v927 (:prefix m926)]
    (. bean925 setPrefix (clojure.core/str v927)))
   (clojure.core/when-let
    [v927 (:enabled m926)]
    (. bean925 setEnabled (clojure.core/boolean v927)))
   bean925))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.PriceClass price-class
  [m929]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudfront.model.PriceClass
   (clojure.core/name m929)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.LoggingConfig logging-config
  [m932]
  (clojure.core/let
   [bean931
    (new com.amazonaws.services.cloudfront.model.LoggingConfig)]
   (clojure.core/when-let
    [v933 (:bucket m932)]
    (. bean931 setBucket (clojure.core/str v933)))
   (clojure.core/when-let
    [v933 (:prefix m932)]
    (. bean931 setPrefix (clojure.core/str v933)))
   (clojure.core/when-let
    [v933 (:include-cookies m932)]
    (. bean931 setIncludeCookies (clojure.core/boolean v933)))
   (clojure.core/when-let
    [v933 (:enabled m932)]
    (. bean931 setEnabled (clojure.core/boolean v933)))
   bean931))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.Origins origins
  [m935]
  (clojure.core/let
   [bean934 (new com.amazonaws.services.cloudfront.model.Origins)]
   (clojure.core/when-let
    [v936 (:quantity m935)]
    (. bean934 setQuantity (clojure.core/int v936)))
   (clojure.core/when-let
    [v936 (:items m935)]
    (.
     bean934
     setItems
     (clojure.core/map
      (clojure.core/fn [arg937] (origin arg937))
      v936)))
   bean934))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.DefaultCacheBehavior default-cache-behavior
  [m939]
  (clojure.core/let
   [bean938
    (new com.amazonaws.services.cloudfront.model.DefaultCacheBehavior)]
   (clojure.core/when-let
    [v940 (:target-origin-id m939)]
    (. bean938 setTargetOriginId (clojure.core/str v940)))
   (clojure.core/when-let
    [v940 (:forwarded-values m939)]
    (. bean938 setForwardedValues (forwarded-values v940)))
   (clojure.core/when-let
    [v940 (:viewer-protocol-policy m939)]
    (. bean938 setViewerProtocolPolicy (viewer-protocol-policy v940)))
   (clojure.core/when-let
    [v940 (:viewer-protocol-policy m939)]
    (. bean938 setViewerProtocolPolicy (clojure.core/str v940)))
   (clojure.core/when-let
    [v940 (:min-ttl m939)]
    (. bean938 setMinTTL (clojure.core/long v940)))
   (clojure.core/when-let
    [v940 (:allowed-methods m939)]
    (. bean938 setAllowedMethods (allowed-methods v940)))
   (clojure.core/when-let
    [v940 (:trusted-signers m939)]
    (. bean938 setTrustedSigners (trusted-signers v940)))
   bean938))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CacheBehaviors cache-behaviors
  [m942]
  (clojure.core/let
   [bean941
    (new com.amazonaws.services.cloudfront.model.CacheBehaviors)]
   (clojure.core/when-let
    [v943 (:quantity m942)]
    (. bean941 setQuantity (clojure.core/int v943)))
   (clojure.core/when-let
    [v943 (:items m942)]
    (.
     bean941
     setItems
     (clojure.core/map
      (clojure.core/fn [arg944] (cache-behavior arg944))
      v943)))
   bean941))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CustomErrorResponses custom-error-responses
  [m946]
  (clojure.core/let
   [bean945
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponses)]
   (clojure.core/when-let
    [v947 (:quantity m946)]
    (. bean945 setQuantity (clojure.core/int v947)))
   (clojure.core/when-let
    [v947 (:items m946)]
    (.
     bean945
     setItems
     (clojure.core/map
      (clojure.core/fn [arg948] (custom-error-response arg948))
      v947)))
   bean945))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ViewerCertificate viewer-certificate
  [m950]
  (clojure.core/let
   [bean949
    (new com.amazonaws.services.cloudfront.model.ViewerCertificate)]
   (clojure.core/when-let
    [v951 (:iamcertificate-id m950)]
    (. bean949 setIAMCertificateId (clojure.core/str v951)))
   (clojure.core/when-let
    [v951 (:cloud-front-default-certificate m950)]
    (.
     bean949
     setCloudFrontDefaultCertificate
     (clojure.core/boolean v951)))
   bean949))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.Paths paths
  [m953]
  (clojure.core/let
   [bean952 (new com.amazonaws.services.cloudfront.model.Paths)]
   (clojure.core/when-let
    [v954 (:quantity m953)]
    (. bean952 setQuantity (clojure.core/int v954)))
   (clojure.core/when-let
    [v954 (:items m953)]
    (.
     bean952
     setItems
     (clojure.core/map
      (clojure.core/fn [arg955] (clojure.core/str arg955))
      v954)))
   bean952))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.StreamingDistributionConfig streaming-distribution-config
  [m957]
  (clojure.core/let
   [bean956
    (new
     com.amazonaws.services.cloudfront.model.StreamingDistributionConfig)]
   (clojure.core/when-let
    [v958 (:comment m957)]
    (. bean956 setComment (clojure.core/str v958)))
   (clojure.core/when-let
    [v958 (:caller-reference m957)]
    (. bean956 setCallerReference (clojure.core/str v958)))
   (clojure.core/when-let
    [v958 (:s3origin m957)]
    (. bean956 setS3Origin (s3origin v958)))
   (clojure.core/when-let
    [v958 (:aliases m957)]
    (. bean956 setAliases (aliases v958)))
   (clojure.core/when-let
    [v958 (:logging m957)]
    (. bean956 setLogging (streaming-logging-config v958)))
   (clojure.core/when-let
    [v958 (:trusted-signers m957)]
    (. bean956 setTrustedSigners (trusted-signers v958)))
   (clojure.core/when-let
    [v958 (:price-class m957)]
    (. bean956 setPriceClass (clojure.core/str v958)))
   (clojure.core/when-let
    [v958 (:price-class m957)]
    (. bean956 setPriceClass (price-class v958)))
   (clojure.core/when-let
    [v958 (:enabled m957)]
    (. bean956 setEnabled (clojure.core/boolean v958)))
   bean956))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig cloud-front-origin-access-identity-config
  [m960]
  (clojure.core/let
   [bean959
    (new
     com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig)]
   (clojure.core/when-let
    [v961 (:comment m960)]
    (. bean959 setComment (clojure.core/str v961)))
   (clojure.core/when-let
    [v961 (:caller-reference m960)]
    (. bean959 setCallerReference (clojure.core/str v961)))
   bean959))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.DistributionConfig distribution-config
  [m963]
  (clojure.core/let
   [bean962
    (new com.amazonaws.services.cloudfront.model.DistributionConfig)]
   (clojure.core/when-let
    [v964 (:comment m963)]
    (. bean962 setComment (clojure.core/str v964)))
   (clojure.core/when-let
    [v964 (:caller-reference m963)]
    (. bean962 setCallerReference (clojure.core/str v964)))
   (clojure.core/when-let
    [v964 (:aliases m963)]
    (. bean962 setAliases (aliases v964)))
   (clojure.core/when-let
    [v964 (:logging m963)]
    (. bean962 setLogging (logging-config v964)))
   (clojure.core/when-let
    [v964 (:price-class m963)]
    (. bean962 setPriceClass (clojure.core/str v964)))
   (clojure.core/when-let
    [v964 (:price-class m963)]
    (. bean962 setPriceClass (price-class v964)))
   (clojure.core/when-let
    [v964 (:enabled m963)]
    (. bean962 setEnabled (clojure.core/boolean v964)))
   (clojure.core/when-let
    [v964 (:default-root-object m963)]
    (. bean962 setDefaultRootObject (clojure.core/str v964)))
   (clojure.core/when-let
    [v964 (:origins m963)]
    (. bean962 setOrigins (origins v964)))
   (clojure.core/when-let
    [v964 (:default-cache-behavior m963)]
    (. bean962 setDefaultCacheBehavior (default-cache-behavior v964)))
   (clojure.core/when-let
    [v964 (:cache-behaviors m963)]
    (. bean962 setCacheBehaviors (cache-behaviors v964)))
   (clojure.core/when-let
    [v964 (:custom-error-responses m963)]
    (. bean962 setCustomErrorResponses (custom-error-responses v964)))
   (clojure.core/when-let
    [v964 (:viewer-certificate m963)]
    (. bean962 setViewerCertificate (viewer-certificate v964)))
   bean962))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.InvalidationBatch invalidation-batch
  [m966]
  (clojure.core/let
   [bean965
    (new com.amazonaws.services.cloudfront.model.InvalidationBatch)]
   (clojure.core/when-let
    [v967 (:caller-reference m966)]
    (. bean965 setCallerReference (clojure.core/str v967)))
   (clojure.core/when-let
    [v967 (:paths m966)]
    (. bean965 setPaths (paths v967)))
   bean965))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest list-streaming-distributions-request
  [m969]
  (clojure.core/let
   [bean968
    (new
     com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest)]
   (clojure.core/when-let
    [v970 (:max-items m969)]
    (. bean968 setMaxItems (clojure.core/str v970)))
   (clojure.core/when-let
    [v970 (:marker m969)]
    (. bean968 setMarker (clojure.core/str v970)))
   bean968))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest get-cloud-front-origin-access-identity-config-request
  [m972]
  (clojure.core/let
   [bean971
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest)]
   (clojure.core/when-let
    [v973 (:id m972)]
    (. bean971 setId (clojure.core/str v973)))
   bean971))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest update-streaming-distribution-request
  [m975]
  (clojure.core/let
   [bean974
    (new
     com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest)]
   (clojure.core/when-let
    [v976 (:id m975)]
    (. bean974 setId (clojure.core/str v976)))
   (clojure.core/when-let
    [v976 (:if-match m975)]
    (. bean974 setIfMatch (clojure.core/str v976)))
   (clojure.core/when-let
    [v976 (:streaming-distribution-config m975)]
    (.
     bean974
     setStreamingDistributionConfig
     (streaming-distribution-config v976)))
   bean974))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest create-cloud-front-origin-access-identity-request
  [m978]
  (clojure.core/let
   [bean977
    (new
     com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/when-let
    [v979 (:cloud-front-origin-access-identity-config m978)]
    (.
     bean977
     setCloudFrontOriginAccessIdentityConfig
     (cloud-front-origin-access-identity-config v979)))
   bean977))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest list-cloud-front-origin-access-identities-request
  [m981]
  (clojure.core/let
   [bean980
    (new
     com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest)]
   (clojure.core/when-let
    [v982 (:max-items m981)]
    (. bean980 setMaxItems (clojure.core/str v982)))
   (clojure.core/when-let
    [v982 (:marker m981)]
    (. bean980 setMarker (clojure.core/str v982)))
   bean980))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest get-distribution-config-request
  [m984]
  (clojure.core/let
   [bean983
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest)]
   (clojure.core/when-let
    [v985 (:id m984)]
    (. bean983 setId (clojure.core/str v985)))
   bean983))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest get-streaming-distribution-config-request
  [m987]
  (clojure.core/let
   [bean986
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest)]
   (clojure.core/when-let
    [v988 (:id m987)]
    (. bean986 setId (clojure.core/str v988)))
   bean986))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CreateDistributionRequest create-distribution-request
  [m990]
  (clojure.core/let
   [bean989
    (new
     com.amazonaws.services.cloudfront.model.CreateDistributionRequest)]
   (clojure.core/when-let
    [v991 (:distribution-config m990)]
    (. bean989 setDistributionConfig (distribution-config v991)))
   bean989))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CreateInvalidationRequest create-invalidation-request
  [m993]
  (clojure.core/let
   [bean992
    (new
     com.amazonaws.services.cloudfront.model.CreateInvalidationRequest)]
   (clojure.core/when-let
    [v994 (:distribution-id m993)]
    (. bean992 setDistributionId (clojure.core/str v994)))
   (clojure.core/when-let
    [v994 (:invalidation-batch m993)]
    (. bean992 setInvalidationBatch (invalidation-batch v994)))
   bean992))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.UpdateDistributionRequest update-distribution-request
  [m996]
  (clojure.core/let
   [bean995
    (new
     com.amazonaws.services.cloudfront.model.UpdateDistributionRequest)]
   (clojure.core/when-let
    [v997 (:id m996)]
    (. bean995 setId (clojure.core/str v997)))
   (clojure.core/when-let
    [v997 (:if-match m996)]
    (. bean995 setIfMatch (clojure.core/str v997)))
   (clojure.core/when-let
    [v997 (:distribution-config m996)]
    (. bean995 setDistributionConfig (distribution-config v997)))
   bean995))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest get-streaming-distribution-request
  [m999]
  (clojure.core/let
   [bean998
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest)]
   (clojure.core/when-let
    [v1000 (:id m999)]
    (. bean998 setId (clojure.core/str v1000)))
   bean998))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ListInvalidationsRequest list-invalidations-request
  [m1002]
  (clojure.core/let
   [bean1001
    (new
     com.amazonaws.services.cloudfront.model.ListInvalidationsRequest)]
   (clojure.core/when-let
    [v1003 (:max-items m1002)]
    (. bean1001 setMaxItems (clojure.core/str v1003)))
   (clojure.core/when-let
    [v1003 (:distribution-id m1002)]
    (. bean1001 setDistributionId (clojure.core/str v1003)))
   (clojure.core/when-let
    [v1003 (:marker m1002)]
    (. bean1001 setMarker (clojure.core/str v1003)))
   bean1001))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.DeleteDistributionRequest delete-distribution-request
  [m1005]
  (clojure.core/let
   [bean1004
    (new
     com.amazonaws.services.cloudfront.model.DeleteDistributionRequest)]
   (clojure.core/when-let
    [v1006 (:id m1005)]
    (. bean1004 setId (clojure.core/str v1006)))
   (clojure.core/when-let
    [v1006 (:if-match m1005)]
    (. bean1004 setIfMatch (clojure.core/str v1006)))
   bean1004))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest create-streaming-distribution-request
  [m1008]
  (clojure.core/let
   [bean1007
    (new
     com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest)]
   (clojure.core/when-let
    [v1009 (:streaming-distribution-config m1008)]
    (.
     bean1007
     setStreamingDistributionConfig
     (streaming-distribution-config v1009)))
   bean1007))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ListDistributionsRequest list-distributions-request
  [m1011]
  (clojure.core/let
   [bean1010
    (new
     com.amazonaws.services.cloudfront.model.ListDistributionsRequest)]
   (clojure.core/when-let
    [v1012 (:max-items m1011)]
    (. bean1010 setMaxItems (clojure.core/str v1012)))
   (clojure.core/when-let
    [v1012 (:marker m1011)]
    (. bean1010 setMarker (clojure.core/str v1012)))
   bean1010))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest update-cloud-front-origin-access-identity-request
  [m1014]
  (clojure.core/let
   [bean1013
    (new
     com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/when-let
    [v1015 (:id m1014)]
    (. bean1013 setId (clojure.core/str v1015)))
   (clojure.core/when-let
    [v1015 (:cloud-front-origin-access-identity-config m1014)]
    (.
     bean1013
     setCloudFrontOriginAccessIdentityConfig
     (cloud-front-origin-access-identity-config v1015)))
   (clojure.core/when-let
    [v1015 (:if-match m1014)]
    (. bean1013 setIfMatch (clojure.core/str v1015)))
   bean1013))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.GetInvalidationRequest get-invalidation-request
  [m1017]
  (clojure.core/let
   [bean1016
    (new
     com.amazonaws.services.cloudfront.model.GetInvalidationRequest)]
   (clojure.core/when-let
    [v1018 (:distribution-id m1017)]
    (. bean1016 setDistributionId (clojure.core/str v1018)))
   (clojure.core/when-let
    [v1018 (:id m1017)]
    (. bean1016 setId (clojure.core/str v1018)))
   bean1016))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest delete-streaming-distribution-request
  [m1020]
  (clojure.core/let
   [bean1019
    (new
     com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest)]
   (clojure.core/when-let
    [v1021 (:id m1020)]
    (. bean1019 setId (clojure.core/str v1021)))
   (clojure.core/when-let
    [v1021 (:if-match m1020)]
    (. bean1019 setIfMatch (clojure.core/str v1021)))
   bean1019))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.GetDistributionRequest get-distribution-request
  [m1023]
  (clojure.core/let
   [bean1022
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionRequest)]
   (clojure.core/when-let
    [v1024 (:id m1023)]
    (. bean1022 setId (clojure.core/str v1024)))
   bean1022))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest delete-cloud-front-origin-access-identity-request
  [m1026]
  (clojure.core/let
   [bean1025
    (new
     com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/when-let
    [v1027 (:id m1026)]
    (. bean1025 setId (clojure.core/str v1027)))
   (clojure.core/when-let
    [v1027 (:if-match m1026)]
    (. bean1025 setIfMatch (clojure.core/str v1027)))
   bean1025))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest get-cloud-front-origin-access-identity-request
  [m1029]
  (clojure.core/let
   [bean1028
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/when-let
    [v1030 (:id m1029)]
    (. bean1028 setId (clojure.core/str v1030)))
   bean1028))
 (clojure.core/defmulti
  cloudfront
  (clojure.core/fn cloudfront [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-streaming-distributions
   [m1031]
   (clojure.core/let
    [credentials1032 (:credentials m1031) args1033 (:args m1031)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1034
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1032)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1034
       listStreamingDistributions
       (list-streaming-distributions-request
        (clojure.core/nth args1033 0)))))))
  (clojure.core/defn
   list-streaming-distributions-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector max-items marker]}]],
    :doc "Generate map for listStreamingDistributions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-streaming-distributions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-streaming-distributions
   {:arglists
    '[[credentials
       {:keys [request-metric-collector max-items marker]}]],
    :doc "Call listStreamingDistributions"}
   [credentials1036 & args1037]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1038
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1036)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1038
      listStreamingDistributions
      (list-streaming-distributions-request
       (clojure.core/nth args1037 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity-config
   [m1039]
   (clojure.core/let
    [credentials1040 (:credentials m1039) args1041 (:args m1039)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1042
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1040)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1042
       getCloudFrontOriginAccessIdentityConfig
       (get-cloud-front-origin-access-identity-config-request
        (clojure.core/nth args1041 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config-map
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Generate map for getCloudFrontOriginAccessIdentityConfig"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-cloud-front-origin-access-identity-config,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Call getCloudFrontOriginAccessIdentityConfig"}
   [credentials1044 & args1045]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1046
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1044)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1046
      getCloudFrontOriginAccessIdentityConfig
      (get-cloud-front-origin-access-identity-config-request
       (clojure.core/nth args1045 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-streaming-distribution
   [m1047]
   (clojure.core/let
    [credentials1048 (:credentials m1047) args1049 (:args m1047)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1050
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1048)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1050
       updateStreamingDistribution
       (update-streaming-distribution-request
        (clojure.core/nth args1049 0)))))))
  (clojure.core/defn
   update-streaming-distribution-map
   {:arglists
    '[[credentials
       {:keys
        [streaming-distribution-config
         request-metric-collector
         if-match
         id]}]],
    :doc "Generate map for updateStreamingDistribution"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :update-streaming-distribution,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-streaming-distribution
   {:arglists
    '[[credentials
       {:keys
        [streaming-distribution-config
         request-metric-collector
         if-match
         id]}]],
    :doc "Call updateStreamingDistribution"}
   [credentials1052 & args1053]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1054
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1052)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1054
      updateStreamingDistribution
      (update-streaming-distribution-request
       (clojure.core/nth args1053 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-cloud-front-origin-access-identity
   [m1055]
   (clojure.core/let
    [credentials1056 (:credentials m1055) args1057 (:args m1055)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1058
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1056)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1058
       createCloudFrontOriginAccessIdentity
       (create-cloud-front-origin-access-identity-request
        (clojure.core/nth args1057 0)))))))
  (clojure.core/defn
   create-cloud-front-origin-access-identity-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         cloud-front-origin-access-identity-config]}]],
    :doc "Generate map for createCloudFrontOriginAccessIdentity"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-cloud-front-origin-access-identity,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-cloud-front-origin-access-identity
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         cloud-front-origin-access-identity-config]}]],
    :doc "Call createCloudFrontOriginAccessIdentity"}
   [credentials1060 & args1061]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1062
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1060)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1062
      createCloudFrontOriginAccessIdentity
      (create-cloud-front-origin-access-identity-request
       (clojure.core/nth args1061 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-cloud-front-origin-access-identities
   [m1063]
   (clojure.core/let
    [credentials1064 (:credentials m1063) args1065 (:args m1063)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1066
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1064)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1066
       listCloudFrontOriginAccessIdentities
       (list-cloud-front-origin-access-identities-request
        (clojure.core/nth args1065 0)))))))
  (clojure.core/defn
   list-cloud-front-origin-access-identities-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector max-items marker]}]],
    :doc "Generate map for listCloudFrontOriginAccessIdentities"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-cloud-front-origin-access-identities,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-cloud-front-origin-access-identities
   {:arglists
    '[[credentials
       {:keys [request-metric-collector max-items marker]}]],
    :doc "Call listCloudFrontOriginAccessIdentities"}
   [credentials1068 & args1069]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1070
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1068)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1070
      listCloudFrontOriginAccessIdentities
      (list-cloud-front-origin-access-identities-request
       (clojure.core/nth args1069 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution-config
   [m1071]
   (clojure.core/let
    [credentials1072 (:credentials m1071) args1073 (:args m1071)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1074
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1072)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1074
       getDistributionConfig
       (get-distribution-config-request
        (clojure.core/nth args1073 0)))))))
  (clojure.core/defn
   get-distribution-config-map
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Generate map for getDistributionConfig"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-distribution-config,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-distribution-config
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Call getDistributionConfig"}
   [credentials1076 & args1077]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1078
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1076)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1078
      getDistributionConfig
      (get-distribution-config-request
       (clojure.core/nth args1077 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution-config
   [m1079]
   (clojure.core/let
    [credentials1080 (:credentials m1079) args1081 (:args m1079)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1082
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1080)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1082
       getStreamingDistributionConfig
       (get-streaming-distribution-config-request
        (clojure.core/nth args1081 0)))))))
  (clojure.core/defn
   get-streaming-distribution-config-map
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Generate map for getStreamingDistributionConfig"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-streaming-distribution-config,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-streaming-distribution-config
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Call getStreamingDistributionConfig"}
   [credentials1084 & args1085]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1086
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1084)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1086
      getStreamingDistributionConfig
      (get-streaming-distribution-config-request
       (clojure.core/nth args1085 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-distribution
   [m1087]
   (clojure.core/let
    [credentials1088 (:credentials m1087) args1089 (:args m1087)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1090
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1088)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1090
       createDistribution
       (create-distribution-request (clojure.core/nth args1089 0)))))))
  (clojure.core/defn
   create-distribution-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector distribution-config]}]],
    :doc "Generate map for createDistribution"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-distribution,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-distribution
   {:arglists
    '[[credentials
       {:keys [request-metric-collector distribution-config]}]],
    :doc "Call createDistribution"}
   [credentials1092 & args1093]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1094
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1092)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1094
      createDistribution
      (create-distribution-request (clojure.core/nth args1093 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-invalidation
   [m1095]
   (clojure.core/let
    [credentials1096 (:credentials m1095) args1097 (:args m1095)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1098
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1096)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1098
       createInvalidation
       (create-invalidation-request (clojure.core/nth args1097 0)))))))
  (clojure.core/defn
   create-invalidation-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         invalidation-batch
         distribution-id]}]],
    :doc "Generate map for createInvalidation"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-invalidation,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-invalidation
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         invalidation-batch
         distribution-id]}]],
    :doc "Call createInvalidation"}
   [credentials1100 & args1101]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1102
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1100)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1102
      createInvalidation
      (create-invalidation-request (clojure.core/nth args1101 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-distribution
   [m1103]
   (clojure.core/let
    [credentials1104 (:credentials m1103) args1105 (:args m1103)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1106
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1104)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1106
       updateDistribution
       (update-distribution-request (clojure.core/nth args1105 0)))))))
  (clojure.core/defn
   update-distribution-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector if-match id distribution-config]}]],
    :doc "Generate map for updateDistribution"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :update-distribution,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-distribution
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector if-match id distribution-config]}]],
    :doc "Call updateDistribution"}
   [credentials1108 & args1109]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1110
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1108)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1110
      updateDistribution
      (update-distribution-request (clojure.core/nth args1109 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution
   [m1111]
   (clojure.core/let
    [credentials1112 (:credentials m1111) args1113 (:args m1111)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1114
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1112)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1114
       getStreamingDistribution
       (get-streaming-distribution-request
        (clojure.core/nth args1113 0)))))))
  (clojure.core/defn
   get-streaming-distribution-map
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Generate map for getStreamingDistribution"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-streaming-distribution,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-streaming-distribution
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Call getStreamingDistribution"}
   [credentials1116 & args1117]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1118
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1116)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1118
      getStreamingDistribution
      (get-streaming-distribution-request
       (clojure.core/nth args1117 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-invalidations
   [m1119]
   (clojure.core/let
    [credentials1120 (:credentials m1119) args1121 (:args m1119)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1122
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1120)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1122
       listInvalidations
       (list-invalidations-request (clojure.core/nth args1121 0)))))))
  (clojure.core/defn
   list-invalidations-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector max-items marker distribution-id]}]],
    :doc "Generate map for listInvalidations"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-invalidations,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-invalidations
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector max-items marker distribution-id]}]],
    :doc "Call listInvalidations"}
   [credentials1124 & args1125]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1126
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1124)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1126
      listInvalidations
      (list-invalidations-request (clojure.core/nth args1125 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-distribution
   [m1127]
   (clojure.core/let
    [credentials1128 (:credentials m1127) args1129 (:args m1127)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1130
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1128)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1130
       deleteDistribution
       (delete-distribution-request (clojure.core/nth args1129 0)))))))
  (clojure.core/defn
   delete-distribution-map
   {:arglists
    '[[credentials {:keys [request-metric-collector if-match id]}]],
    :doc "Generate map for deleteDistribution"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :delete-distribution,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-distribution
   {:arglists
    '[[credentials {:keys [request-metric-collector if-match id]}]],
    :doc "Call deleteDistribution"}
   [credentials1132 & args1133]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1134
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1132)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1134
      deleteDistribution
      (delete-distribution-request (clojure.core/nth args1133 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-streaming-distribution
   [m1135]
   (clojure.core/let
    [credentials1136 (:credentials m1135) args1137 (:args m1135)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1138
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1136)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1138
       createStreamingDistribution
       (create-streaming-distribution-request
        (clojure.core/nth args1137 0)))))))
  (clojure.core/defn
   create-streaming-distribution-map
   {:arglists
    '[[credentials
       {:keys
        [streaming-distribution-config request-metric-collector]}]],
    :doc "Generate map for createStreamingDistribution"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-streaming-distribution,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-streaming-distribution
   {:arglists
    '[[credentials
       {:keys
        [streaming-distribution-config request-metric-collector]}]],
    :doc "Call createStreamingDistribution"}
   [credentials1140 & args1141]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1142
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1140)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1142
      createStreamingDistribution
      (create-streaming-distribution-request
       (clojure.core/nth args1141 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-distributions
   [m1143]
   (clojure.core/let
    [credentials1144 (:credentials m1143) args1145 (:args m1143)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1146
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1144)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1146
       listDistributions
       (list-distributions-request (clojure.core/nth args1145 0)))))))
  (clojure.core/defn
   list-distributions-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector max-items marker]}]],
    :doc "Generate map for listDistributions"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-distributions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-distributions
   {:arglists
    '[[credentials
       {:keys [request-metric-collector max-items marker]}]],
    :doc "Call listDistributions"}
   [credentials1148 & args1149]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1150
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1148)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1150
      listDistributions
      (list-distributions-request (clojure.core/nth args1149 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-cloud-front-origin-access-identity
   [m1151]
   (clojure.core/let
    [credentials1152 (:credentials m1151) args1153 (:args m1151)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1154
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1152)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1154
       updateCloudFrontOriginAccessIdentity
       (update-cloud-front-origin-access-identity-request
        (clojure.core/nth args1153 0)))))))
  (clojure.core/defn
   update-cloud-front-origin-access-identity-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         if-match
         id
         cloud-front-origin-access-identity-config]}]],
    :doc "Generate map for updateCloudFrontOriginAccessIdentity"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :update-cloud-front-origin-access-identity,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-cloud-front-origin-access-identity
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         if-match
         id
         cloud-front-origin-access-identity-config]}]],
    :doc "Call updateCloudFrontOriginAccessIdentity"}
   [credentials1156 & args1157]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1158
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1156)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1158
      updateCloudFrontOriginAccessIdentity
      (update-cloud-front-origin-access-identity-request
       (clojure.core/nth args1157 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-invalidation
   [m1159]
   (clojure.core/let
    [credentials1160 (:credentials m1159) args1161 (:args m1159)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1162
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1160)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1162
       getInvalidation
       (get-invalidation-request (clojure.core/nth args1161 0)))))))
  (clojure.core/defn
   get-invalidation-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector id distribution-id]}]],
    :doc "Generate map for getInvalidation"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-invalidation,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-invalidation
   {:arglists
    '[[credentials
       {:keys [request-metric-collector id distribution-id]}]],
    :doc "Call getInvalidation"}
   [credentials1164 & args1165]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1166
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1164)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1166
      getInvalidation
      (get-invalidation-request (clojure.core/nth args1165 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-streaming-distribution
   [m1167]
   (clojure.core/let
    [credentials1168 (:credentials m1167) args1169 (:args m1167)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1170
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1168)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1170
       deleteStreamingDistribution
       (delete-streaming-distribution-request
        (clojure.core/nth args1169 0)))))))
  (clojure.core/defn
   delete-streaming-distribution-map
   {:arglists
    '[[credentials {:keys [request-metric-collector if-match id]}]],
    :doc "Generate map for deleteStreamingDistribution"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :delete-streaming-distribution,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-streaming-distribution
   {:arglists
    '[[credentials {:keys [request-metric-collector if-match id]}]],
    :doc "Call deleteStreamingDistribution"}
   [credentials1172 & args1173]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1174
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1172)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1174
      deleteStreamingDistribution
      (delete-streaming-distribution-request
       (clojure.core/nth args1173 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution
   [m1175]
   (clojure.core/let
    [credentials1176 (:credentials m1175) args1177 (:args m1175)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1178
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1176)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1178
       getDistribution
       (get-distribution-request (clojure.core/nth args1177 0)))))))
  (clojure.core/defn
   get-distribution-map
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Generate map for getDistribution"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-distribution,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-distribution
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Call getDistribution"}
   [credentials1180 & args1181]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1182
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1180)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1182
      getDistribution
      (get-distribution-request (clojure.core/nth args1181 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-cloud-front-origin-access-identity
   [m1183]
   (clojure.core/let
    [credentials1184 (:credentials m1183) args1185 (:args m1183)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1186
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1184)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1186
       deleteCloudFrontOriginAccessIdentity
       (delete-cloud-front-origin-access-identity-request
        (clojure.core/nth args1185 0)))))))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity-map
   {:arglists
    '[[credentials {:keys [request-metric-collector if-match id]}]],
    :doc "Generate map for deleteCloudFrontOriginAccessIdentity"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :delete-cloud-front-origin-access-identity,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity
   {:arglists
    '[[credentials {:keys [request-metric-collector if-match id]}]],
    :doc "Call deleteCloudFrontOriginAccessIdentity"}
   [credentials1188 & args1189]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1190
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1188)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1190
      deleteCloudFrontOriginAccessIdentity
      (delete-cloud-front-origin-access-identity-request
       (clojure.core/nth args1189 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity
   [m1191]
   (clojure.core/let
    [credentials1192 (:credentials m1191) args1193 (:args m1191)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1194
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials1192)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1194
       getCloudFrontOriginAccessIdentity
       (get-cloud-front-origin-access-identity-request
        (clojure.core/nth args1193 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-map
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Generate map for getCloudFrontOriginAccessIdentity"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-cloud-front-origin-access-identity,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity
   {:arglists '[[credentials {:keys [request-metric-collector id]}]],
    :doc "Call getCloudFrontOriginAccessIdentity"}
   [credentials1196 & args1197]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1198
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials1196)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client1198
      getCloudFrontOriginAccessIdentity
      (get-cloud-front-origin-access-identity-request
       (clojure.core/nth args1197 0))))))))
