(ns com.palletops.awaze.cloudformation (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudformation
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.cloudformation.AmazonCloudFormationClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.Parameter parameter
  [m6956]
  (clojure.core/let
   [bean6955
    (new com.amazonaws.services.cloudformation.model.Parameter)]
   (clojure.core/when-let
    [v6957 (:parameter-key m6956)]
    (. bean6955 setParameterKey (clojure.core/str v6957)))
   (clojure.core/when-let
    [v6957 (:parameter-value m6956)]
    (. bean6955 setParameterValue (clojure.core/str v6957)))
   bean6955))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.Tag tag
  [m6959]
  (clojure.core/let
   [bean6958 (new com.amazonaws.services.cloudformation.model.Tag)]
   (clojure.core/when-let
    [v6960 (:value m6959)]
    (. bean6958 setValue (clojure.core/str v6960)))
   (clojure.core/when-let
    [v6960 (:key m6959)]
    (. bean6958 setKey (clojure.core/str v6960)))
   bean6958))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.OnFailure on-failure
  [m6962]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudformation.model.OnFailure
   (clojure.core/name m6962)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest describe-stack-events-request
  [m6965]
  (clojure.core/let
   [bean6964
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest)]
   (clojure.core/when-let
    [v6966 (:next-token m6965)]
    (. bean6964 setNextToken (clojure.core/str v6966)))
   (clojure.core/when-let
    [v6966 (:stack-name m6965)]
    (. bean6964 setStackName (clojure.core/str v6966)))
   bean6964))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.DescribeStacksRequest describe-stacks-request
  [m6968]
  (clojure.core/let
   [bean6967
    (new
     com.amazonaws.services.cloudformation.model.DescribeStacksRequest)]
   (clojure.core/when-let
    [v6969 (:next-token m6968)]
    (. bean6967 setNextToken (clojure.core/str v6969)))
   (clojure.core/when-let
    [v6969 (:stack-name m6968)]
    (. bean6967 setStackName (clojure.core/str v6969)))
   bean6967))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.GetTemplateRequest get-template-request
  [m6971]
  (clojure.core/let
   [bean6970
    (new
     com.amazonaws.services.cloudformation.model.GetTemplateRequest)]
   (clojure.core/when-let
    [v6972 (:stack-name m6971)]
    (. bean6970 setStackName (clojure.core/str v6972)))
   bean6970))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.ListStacksRequest list-stacks-request
  [m6974]
  (clojure.core/let
   [bean6973
    (new
     com.amazonaws.services.cloudformation.model.ListStacksRequest)]
   (clojure.core/when-let
    [v6975 (:next-token m6974)]
    (. bean6973 setNextToken (clojure.core/str v6975)))
   (clojure.core/when-let
    [v6975 (:stack-status-filters m6974)]
    (.
     bean6973
     setStackStatusFilters
     (clojure.core/map
      (clojure.core/fn [arg6976] (clojure.core/str arg6976))
      v6975)))
   bean6973))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.DeleteStackRequest delete-stack-request
  [m6978]
  (clojure.core/let
   [bean6977
    (new
     com.amazonaws.services.cloudformation.model.DeleteStackRequest)]
   (clojure.core/when-let
    [v6979 (:stack-name m6978)]
    (. bean6977 setStackName (clojure.core/str v6979)))
   bean6977))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest estimate-template-cost-request
  [m6981]
  (clojure.core/let
   [bean6980
    (new
     com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest)]
   (clojure.core/when-let
    [v6982 (:parameters m6981)]
    (.
     bean6980
     setParameters
     (clojure.core/map
      (clojure.core/fn [arg6983] (parameter arg6983))
      v6982)))
   (clojure.core/when-let
    [v6982 (:template-body m6981)]
    (. bean6980 setTemplateBody (clojure.core/str v6982)))
   (clojure.core/when-let
    [v6982 (:template-url m6981)]
    (. bean6980 setTemplateURL (clojure.core/str v6982)))
   bean6980))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.ValidateTemplateRequest validate-template-request
  [m6985]
  (clojure.core/let
   [bean6984
    (new
     com.amazonaws.services.cloudformation.model.ValidateTemplateRequest)]
   (clojure.core/when-let
    [v6986 (:template-body m6985)]
    (. bean6984 setTemplateBody (clojure.core/str v6986)))
   (clojure.core/when-let
    [v6986 (:template-url m6985)]
    (. bean6984 setTemplateURL (clojure.core/str v6986)))
   bean6984))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.UpdateStackRequest update-stack-request
  [m6988]
  (clojure.core/let
   [bean6987
    (new
     com.amazonaws.services.cloudformation.model.UpdateStackRequest)]
   (clojure.core/when-let
    [v6989 (:parameters m6988)]
    (.
     bean6987
     setParameters
     (clojure.core/map
      (clojure.core/fn [arg6990] (parameter arg6990))
      v6989)))
   (clojure.core/when-let
    [v6989 (:template-body m6988)]
    (. bean6987 setTemplateBody (clojure.core/str v6989)))
   (clojure.core/when-let
    [v6989 (:template-url m6988)]
    (. bean6987 setTemplateURL (clojure.core/str v6989)))
   (clojure.core/when-let
    [v6989 (:capabilities m6988)]
    (.
     bean6987
     setCapabilities
     (clojure.core/map
      (clojure.core/fn [arg6991] (clojure.core/str arg6991))
      v6989)))
   (clojure.core/when-let
    [v6989 (:stack-name m6988)]
    (. bean6987 setStackName (clojure.core/str v6989)))
   bean6987))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest describe-stack-resources-request
  [m6993]
  (clojure.core/let
   [bean6992
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest)]
   (clojure.core/when-let
    [v6994 (:stack-name m6993)]
    (. bean6992 setStackName (clojure.core/str v6994)))
   (clojure.core/when-let
    [v6994 (:logical-resource-id m6993)]
    (. bean6992 setLogicalResourceId (clojure.core/str v6994)))
   (clojure.core/when-let
    [v6994 (:physical-resource-id m6993)]
    (. bean6992 setPhysicalResourceId (clojure.core/str v6994)))
   bean6992))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest cancel-update-stack-request
  [m6996]
  (clojure.core/let
   [bean6995
    (new
     com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest)]
   (clojure.core/when-let
    [v6997 (:stack-name m6996)]
    (. bean6995 setStackName (clojure.core/str v6997)))
   bean6995))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.CreateStackRequest create-stack-request
  [m6999]
  (clojure.core/let
   [bean6998
    (new
     com.amazonaws.services.cloudformation.model.CreateStackRequest)]
   (clojure.core/when-let
    [v7000 (:parameters m6999)]
    (.
     bean6998
     setParameters
     (clojure.core/map
      (clojure.core/fn [arg7001] (parameter arg7001))
      v7000)))
   (clojure.core/when-let
    [v7000 (:tags m6999)]
    (.
     bean6998
     setTags
     (clojure.core/map
      (clojure.core/fn [arg7002] (tag arg7002))
      v7000)))
   (clojure.core/when-let
    [v7000 (:template-body m6999)]
    (. bean6998 setTemplateBody (clojure.core/str v7000)))
   (clojure.core/when-let
    [v7000 (:template-url m6999)]
    (. bean6998 setTemplateURL (clojure.core/str v7000)))
   (clojure.core/when-let
    [v7000 (:capabilities m6999)]
    (.
     bean6998
     setCapabilities
     (clojure.core/map
      (clojure.core/fn [arg7003] (clojure.core/str arg7003))
      v7000)))
   (clojure.core/when-let
    [v7000 (:stack-name m6999)]
    (. bean6998 setStackName (clojure.core/str v7000)))
   (clojure.core/when-let
    [v7000 (:disable-rollback m6999)]
    (. bean6998 setDisableRollback (clojure.core/boolean v7000)))
   (clojure.core/when-let
    [v7000 (:timeout-in-minutes m6999)]
    (. bean6998 setTimeoutInMinutes (clojure.core/int v7000)))
   (clojure.core/when-let
    [v7000 (:notification-arns m6999)]
    (.
     bean6998
     setNotificationARNs
     (clojure.core/map
      (clojure.core/fn [arg7004] (clojure.core/str arg7004))
      v7000)))
   (clojure.core/when-let
    [v7000 (:on-failure m6999)]
    (. bean6998 setOnFailure (clojure.core/str v7000)))
   (clojure.core/when-let
    [v7000 (:on-failure m6999)]
    (. bean6998 setOnFailure (on-failure v7000)))
   bean6998))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest describe-stack-resource-request
  [m7006]
  (clojure.core/let
   [bean7005
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest)]
   (clojure.core/when-let
    [v7007 (:stack-name m7006)]
    (. bean7005 setStackName (clojure.core/str v7007)))
   (clojure.core/when-let
    [v7007 (:logical-resource-id m7006)]
    (. bean7005 setLogicalResourceId (clojure.core/str v7007)))
   bean7005))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.ListStackResourcesRequest list-stack-resources-request
  [m7009]
  (clojure.core/let
   [bean7008
    (new
     com.amazonaws.services.cloudformation.model.ListStackResourcesRequest)]
   (clojure.core/when-let
    [v7010 (:next-token m7009)]
    (. bean7008 setNextToken (clojure.core/str v7010)))
   (clojure.core/when-let
    [v7010 (:stack-name m7009)]
    (. bean7008 setStackName (clojure.core/str v7010)))
   bean7008))
 (clojure.core/defmulti
  cloudformation
  (clojure.core/fn
   cloudformation
   [m__609__auto__]
   (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-events
   [m7011]
   (clojure.core/let
    [credentials7012 (:credentials m7011) args7013 (:args m7011)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7014
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials7012)]
     (clojure.core/case
      (clojure.core/count args7013)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7014
        describeStackEvents))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7014
        describeStackEvents
        (describe-stack-events-request
         (clojure.core/nth args7013 0))))))))
  (clojure.core/defn
   describe-stack-events-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys [stack-name request-metric-collector next-token]}]],
    :doc "Generate map for describeStackEvents, describeStackEvents"}
   ([credentials__577__auto__]
    {:args [],
     :client :cloudformation,
     :fn :describe-stack-events,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stack-events,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-stack-events
   {:arglists
    '[[credentials]
      [credentials
       {:keys [stack-name request-metric-collector next-token]}]],
    :doc "Call describeStackEvents, describeStackEvents"}
   [credentials7016 & args7017]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7018
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials7016)]
    (clojure.core/case
     (clojure.core/count args7017)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7018
       describeStackEvents))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7018
       describeStackEvents
       (describe-stack-events-request
        (clojure.core/nth args7017 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stacks
   [m7019]
   (clojure.core/let
    [credentials7020 (:credentials m7019) args7021 (:args m7019)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7022
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials7020)]
     (clojure.core/case
      (clojure.core/count args7021)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7022
        describeStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7022
        describeStacks
        (describe-stacks-request (clojure.core/nth args7021 0))))))))
  (clojure.core/defn
   describe-stacks-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys [stack-name request-metric-collector next-token]}]],
    :doc "Generate map for describeStacks, describeStacks"}
   ([credentials__577__auto__]
    {:args [],
     :client :cloudformation,
     :fn :describe-stacks,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stacks,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-stacks
   {:arglists
    '[[credentials]
      [credentials
       {:keys [stack-name request-metric-collector next-token]}]],
    :doc "Call describeStacks, describeStacks"}
   [credentials7024 & args7025]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7026
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials7024)]
    (clojure.core/case
     (clojure.core/count args7025)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7026
       describeStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7026
       describeStacks
       (describe-stacks-request (clojure.core/nth args7025 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-template
   [m7027]
   (clojure.core/let
    [credentials7028 (:credentials m7027) args7029 (:args m7027)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7030
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials7028)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7030
       getTemplate
       (get-template-request (clojure.core/nth args7029 0)))))))
  (clojure.core/defn
   get-template-map
   {:arglists
    '[[credentials {:keys [stack-name request-metric-collector]}]],
    :doc "Generate map for getTemplate"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :get-template,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   get-template
   {:arglists
    '[[credentials {:keys [stack-name request-metric-collector]}]],
    :doc "Call getTemplate"}
   [credentials7032 & args7033]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7034
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials7032)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7034
      getTemplate
      (get-template-request (clojure.core/nth args7033 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stacks
   [m7035]
   (clojure.core/let
    [credentials7036 (:credentials m7035) args7037 (:args m7035)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7038
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials7036)]
     (clojure.core/case
      (clojure.core/count args7037)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7038
        listStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7038
        listStacks
        (list-stacks-request (clojure.core/nth args7037 0))))))))
  (clojure.core/defn
   list-stacks-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [stack-status-filters request-metric-collector next-token]}]],
    :doc "Generate map for listStacks, listStacks"}
   ([credentials__577__auto__]
    {:args [],
     :client :cloudformation,
     :fn :list-stacks,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :list-stacks,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-stacks
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [stack-status-filters request-metric-collector next-token]}]],
    :doc "Call listStacks, listStacks"}
   [credentials7040 & args7041]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7042
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials7040)]
    (clojure.core/case
     (clojure.core/count args7041)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7042
       listStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7042
       listStacks
       (list-stacks-request (clojure.core/nth args7041 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :delete-stack
   [m7043]
   (clojure.core/let
    [credentials7044 (:credentials m7043) args7045 (:args m7043)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7046
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials7044)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7046
       deleteStack
       (delete-stack-request (clojure.core/nth args7045 0)))))))
  (clojure.core/defn
   delete-stack-map
   {:arglists
    '[[credentials {:keys [stack-name request-metric-collector]}]],
    :doc "Generate map for deleteStack"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :delete-stack,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-stack
   {:arglists
    '[[credentials {:keys [stack-name request-metric-collector]}]],
    :doc "Call deleteStack"}
   [credentials7048 & args7049]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7050
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials7048)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7050
      deleteStack
      (delete-stack-request (clojure.core/nth args7049 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :estimate-template-cost
   [m7051]
   (clojure.core/let
    [credentials7052 (:credentials m7051) args7053 (:args m7051)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7054
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials7052)]
     (clojure.core/case
      (clojure.core/count args7053)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7054
        estimateTemplateCost
        (estimate-template-cost-request
         (clojure.core/nth args7053 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7054
        estimateTemplateCost))))))
  (clojure.core/defn
   estimate-template-cost-map
   {:arglists
    '[[credentials
       {:keys
        [template-url
         template-body
         request-metric-collector
         parameters]}]
      [credentials]],
    :doc "Generate map for estimateTemplateCost, estimateTemplateCost"}
   ([credentials__577__auto__]
    {:args [],
     :client :cloudformation,
     :fn :estimate-template-cost,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :estimate-template-cost,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   estimate-template-cost
   {:arglists
    '[[credentials
       {:keys
        [template-url
         template-body
         request-metric-collector
         parameters]}]
      [credentials]],
    :doc "Call estimateTemplateCost, estimateTemplateCost"}
   [credentials7056 & args7057]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7058
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials7056)]
    (clojure.core/case
     (clojure.core/count args7057)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7058
       estimateTemplateCost
       (estimate-template-cost-request (clojure.core/nth args7057 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7058
       estimateTemplateCost))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :validate-template
   [m7059]
   (clojure.core/let
    [credentials7060 (:credentials m7059) args7061 (:args m7059)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7062
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials7060)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7062
       validateTemplate
       (validate-template-request (clojure.core/nth args7061 0)))))))
  (clojure.core/defn
   validate-template-map
   {:arglists
    '[[credentials
       {:keys [template-url template-body request-metric-collector]}]],
    :doc "Generate map for validateTemplate"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :validate-template,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   validate-template
   {:arglists
    '[[credentials
       {:keys [template-url template-body request-metric-collector]}]],
    :doc "Call validateTemplate"}
   [credentials7064 & args7065]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7066
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials7064)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7066
      validateTemplate
      (validate-template-request (clojure.core/nth args7065 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :update-stack
   [m7067]
   (clojure.core/let
    [credentials7068 (:credentials m7067) args7069 (:args m7067)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7070
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials7068)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7070
       updateStack
       (update-stack-request (clojure.core/nth args7069 0)))))))
  (clojure.core/defn
   update-stack-map
   {:arglists
    '[[credentials
       {:keys
        [template-url
         template-body
         stack-name
         request-metric-collector
         parameters
         capabilities]}]],
    :doc "Generate map for updateStack"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :update-stack,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-stack
   {:arglists
    '[[credentials
       {:keys
        [template-url
         template-body
         stack-name
         request-metric-collector
         parameters
         capabilities]}]],
    :doc "Call updateStack"}
   [credentials7072 & args7073]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7074
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials7072)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7074
      updateStack
      (update-stack-request (clojure.core/nth args7073 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resources
   [m7075]
   (clojure.core/let
    [credentials7076 (:credentials m7075) args7077 (:args m7075)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7078
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials7076)]
     (clojure.core/case
      (clojure.core/count args7077)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7078
        describeStackResources))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7078
        describeStackResources
        (describe-stack-resources-request
         (clojure.core/nth args7077 0))))))))
  (clojure.core/defn
   describe-stack-resources-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [stack-name
         request-metric-collector
         physical-resource-id
         logical-resource-id]}]],
    :doc
    "Generate map for describeStackResources, describeStackResources"}
   ([credentials__577__auto__]
    {:args [],
     :client :cloudformation,
     :fn :describe-stack-resources,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stack-resources,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-stack-resources
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [stack-name
         request-metric-collector
         physical-resource-id
         logical-resource-id]}]],
    :doc "Call describeStackResources, describeStackResources"}
   [credentials7080 & args7081]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7082
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials7080)]
    (clojure.core/case
     (clojure.core/count args7081)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7082
       describeStackResources))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7082
       describeStackResources
       (describe-stack-resources-request
        (clojure.core/nth args7081 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :cancel-update-stack
   [m7083]
   (clojure.core/let
    [credentials7084 (:credentials m7083) args7085 (:args m7083)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7086
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials7084)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7086
       cancelUpdateStack
       (cancel-update-stack-request (clojure.core/nth args7085 0)))))))
  (clojure.core/defn
   cancel-update-stack-map
   {:arglists
    '[[credentials {:keys [stack-name request-metric-collector]}]],
    :doc "Generate map for cancelUpdateStack"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :cancel-update-stack,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   cancel-update-stack
   {:arglists
    '[[credentials {:keys [stack-name request-metric-collector]}]],
    :doc "Call cancelUpdateStack"}
   [credentials7088 & args7089]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7090
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials7088)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7090
      cancelUpdateStack
      (cancel-update-stack-request (clojure.core/nth args7089 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :create-stack
   [m7091]
   (clojure.core/let
    [credentials7092 (:credentials m7091) args7093 (:args m7091)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7094
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials7092)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7094
       createStack
       (create-stack-request (clojure.core/nth args7093 0)))))))
  (clojure.core/defn
   create-stack-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         disable-rollback
         template-body
         capabilities
         stack-name
         notification-arns
         parameters
         template-url
         on-failure
         timeout-in-minutes
         tags]}]],
    :doc "Generate map for createStack"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :create-stack,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-stack
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         disable-rollback
         template-body
         capabilities
         stack-name
         notification-arns
         parameters
         template-url
         on-failure
         timeout-in-minutes
         tags]}]],
    :doc "Call createStack"}
   [credentials7096 & args7097]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7098
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials7096)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7098
      createStack
      (create-stack-request (clojure.core/nth args7097 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resource
   [m7099]
   (clojure.core/let
    [credentials7100 (:credentials m7099) args7101 (:args m7099)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7102
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials7100)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7102
       describeStackResource
       (describe-stack-resource-request
        (clojure.core/nth args7101 0)))))))
  (clojure.core/defn
   describe-stack-resource-map
   {:arglists
    '[[credentials
       {:keys
        [stack-name request-metric-collector logical-resource-id]}]],
    :doc "Generate map for describeStackResource"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stack-resource,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-stack-resource
   {:arglists
    '[[credentials
       {:keys
        [stack-name request-metric-collector logical-resource-id]}]],
    :doc "Call describeStackResource"}
   [credentials7104 & args7105]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7106
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials7104)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7106
      describeStackResource
      (describe-stack-resource-request
       (clojure.core/nth args7105 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stack-resources
   [m7107]
   (clojure.core/let
    [credentials7108 (:credentials m7107) args7109 (:args m7107)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7110
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials7108)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7110
       listStackResources
       (list-stack-resources-request
        (clojure.core/nth args7109 0)))))))
  (clojure.core/defn
   list-stack-resources-map
   {:arglists
    '[[credentials
       {:keys [stack-name request-metric-collector next-token]}]],
    :doc "Generate map for listStackResources"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :list-stack-resources,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   list-stack-resources
   {:arglists
    '[[credentials
       {:keys [stack-name request-metric-collector next-token]}]],
    :doc "Call listStackResources"}
   [credentials7112 & args7113]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7114
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials7112)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client7114
      listStackResources
      (list-stack-resources-request (clojure.core/nth args7113 0))))))))
