(ns com.palletops.awaze.autoscaling (:require [com.palletops.awaze.common]))

(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :autoscaling
  [___529__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__530__auto__]
  (new
   com.amazonaws.services.autoscaling.AmazonAutoScalingClient
   credentials__530__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.Ebs ebs
  [m1880]
  (clojure.core/let
   [bean1879 (new com.amazonaws.services.autoscaling.model.Ebs)]
   (clojure.core/when-let
    [v1881 (:snapshot-id m1880)]
    (. bean1879 setSnapshotId (clojure.core/str v1881)))
   (clojure.core/when-let
    [v1881 (:volume-size m1880)]
    (. bean1879 setVolumeSize (clojure.core/int v1881)))
   bean1879))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.Tag tag
  [m1883]
  (clojure.core/let
   [bean1882 (new com.amazonaws.services.autoscaling.model.Tag)]
   (clojure.core/when-let
    [v1884 (:value m1883)]
    (. bean1882 setValue (clojure.core/str v1884)))
   (clojure.core/when-let
    [v1884 (:resource-id m1883)]
    (. bean1882 setResourceId (clojure.core/str v1884)))
   (clojure.core/when-let
    [v1884 (:resource-type m1883)]
    (. bean1882 setResourceType (clojure.core/str v1884)))
   (clojure.core/when-let
    [v1884 (:key m1883)]
    (. bean1882 setKey (clojure.core/str v1884)))
   (clojure.core/when-let
    [v1884 (:propagate-at-launch m1883)]
    (. bean1882 setPropagateAtLaunch (clojure.core/boolean v1884)))
   bean1882))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.BlockDeviceMapping block-device-mapping
  [m1886]
  (clojure.core/let
   [bean1885
    (new com.amazonaws.services.autoscaling.model.BlockDeviceMapping)]
   (clojure.core/when-let
    [v1887 (:virtual-name m1886)]
    (. bean1885 setVirtualName (clojure.core/str v1887)))
   (clojure.core/when-let
    [v1887 (:device-name m1886)]
    (. bean1885 setDeviceName (clojure.core/str v1887)))
   (clojure.core/when-let
    [v1887 (:ebs m1886)]
    (. bean1885 setEbs (ebs v1887)))
   bean1885))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.InstanceMonitoring instance-monitoring
  [m1889]
  (clojure.core/let
   [bean1888
    (new com.amazonaws.services.autoscaling.model.InstanceMonitoring)]
   (clojure.core/when-let
    [v1890 (:enabled m1889)]
    (. bean1888 setEnabled (clojure.core/boolean v1890)))
   bean1888))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.Filter filter
  [m1892]
  (clojure.core/let
   [bean1891 (new com.amazonaws.services.autoscaling.model.Filter)]
   (clojure.core/when-let
    [v1893 (:name m1892)]
    (. bean1891 setName (clojure.core/str v1893)))
   (clojure.core/when-let
    [v1893 (:values m1892)]
    (.
     bean1891
     setValues
     (clojure.core/map
      (clojure.core/fn [arg1894] (clojure.core/str arg1894))
      v1893)))
   bean1891))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest set-desired-capacity-request
  [m1896]
  (clojure.core/let
   [bean1895
    (new
     com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest)]
   (clojure.core/when-let
    [v1897 (:desired-capacity m1896)]
    (. bean1895 setDesiredCapacity (clojure.core/int v1897)))
   (clojure.core/when-let
    [v1897 (:auto-scaling-group-name m1896)]
    (. bean1895 setAutoScalingGroupName (clojure.core/str v1897)))
   (clojure.core/when-let
    [v1897 (:honor-cooldown m1896)]
    (. bean1895 setHonorCooldown (clojure.core/boolean v1897)))
   bean1895))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest enable-metrics-collection-request
  [m1899]
  (clojure.core/let
   [bean1898
    (new
     com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest)]
   (clojure.core/when-let
    [v1900 (:auto-scaling-group-name m1899)]
    (. bean1898 setAutoScalingGroupName (clojure.core/str v1900)))
   (clojure.core/when-let
    [v1900 (:metrics m1899)]
    (.
     bean1898
     setMetrics
     (clojure.core/map
      (clojure.core/fn [arg1901] (clojure.core/str arg1901))
      v1900)))
   (clojure.core/when-let
    [v1900 (:granularity m1899)]
    (. bean1898 setGranularity (clojure.core/str v1900)))
   bean1898))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DeletePolicyRequest delete-policy-request
  [m1903]
  (clojure.core/let
   [bean1902
    (new com.amazonaws.services.autoscaling.model.DeletePolicyRequest)]
   (clojure.core/when-let
    [v1904 (:auto-scaling-group-name m1903)]
    (. bean1902 setAutoScalingGroupName (clojure.core/str v1904)))
   (clojure.core/when-let
    [v1904 (:policy-name m1903)]
    (. bean1902 setPolicyName (clojure.core/str v1904)))
   bean1902))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest set-instance-health-request
  [m1906]
  (clojure.core/let
   [bean1905
    (new
     com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest)]
   (clojure.core/when-let
    [v1907 (:instance-id m1906)]
    (. bean1905 setInstanceId (clojure.core/str v1907)))
   (clojure.core/when-let
    [v1907 (:health-status m1906)]
    (. bean1905 setHealthStatus (clojure.core/str v1907)))
   (clojure.core/when-let
    [v1907 (:should-respect-grace-period m1906)]
    (.
     bean1905
     setShouldRespectGracePeriod
     (clojure.core/boolean v1907)))
   bean1905))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest describe-launch-configurations-request
  [m1909]
  (clojure.core/let
   [bean1908
    (new
     com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest)]
   (clojure.core/when-let
    [v1910 (:next-token m1909)]
    (. bean1908 setNextToken (clojure.core/str v1910)))
   (clojure.core/when-let
    [v1910 (:launch-configuration-names m1909)]
    (.
     bean1908
     setLaunchConfigurationNames
     (clojure.core/map
      (clojure.core/fn [arg1911] (clojure.core/str arg1911))
      v1910)))
   (clojure.core/when-let
    [v1910 (:max-records m1909)]
    (. bean1908 setMaxRecords (clojure.core/int v1910)))
   bean1908))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DeleteTagsRequest delete-tags-request
  [m1913]
  (clojure.core/let
   [bean1912
    (new com.amazonaws.services.autoscaling.model.DeleteTagsRequest)]
   (clojure.core/when-let
    [v1914 (:tags m1913)]
    (.
     bean1912
     setTags
     (clojure.core/map
      (clojure.core/fn [arg1915] (tag arg1915))
      v1914)))
   bean1912))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest describe-auto-scaling-instances-request
  [m1917]
  (clojure.core/let
   [bean1916
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest)]
   (clojure.core/when-let
    [v1918 (:next-token m1917)]
    (. bean1916 setNextToken (clojure.core/str v1918)))
   (clojure.core/when-let
    [v1918 (:instance-ids m1917)]
    (.
     bean1916
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg1919] (clojure.core/str arg1919))
      v1918)))
   (clojure.core/when-let
    [v1918 (:max-records m1917)]
    (. bean1916 setMaxRecords (clojure.core/int v1918)))
   bean1916))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest describe-notification-configurations-request
  [m1921]
  (clojure.core/let
   [bean1920
    (new
     com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest)]
   (clojure.core/when-let
    [v1922 (:next-token m1921)]
    (. bean1920 setNextToken (clojure.core/str v1922)))
   (clojure.core/when-let
    [v1922 (:auto-scaling-group-names m1921)]
    (.
     bean1920
     setAutoScalingGroupNames
     (clojure.core/map
      (clojure.core/fn [arg1923] (clojure.core/str arg1923))
      v1922)))
   (clojure.core/when-let
    [v1922 (:max-records m1921)]
    (. bean1920 setMaxRecords (clojure.core/int v1922)))
   bean1920))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest describe-auto-scaling-notification-types-request
  [m1925]
  (clojure.core/let
   [bean1924
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest)]
   bean1924))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest put-notification-configuration-request
  [m1928]
  (clojure.core/let
   [bean1927
    (new
     com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest)]
   (clojure.core/when-let
    [v1929 (:auto-scaling-group-name m1928)]
    (. bean1927 setAutoScalingGroupName (clojure.core/str v1929)))
   (clojure.core/when-let
    [v1929 (:topic-arn m1928)]
    (. bean1927 setTopicARN (clojure.core/str v1929)))
   (clojure.core/when-let
    [v1929 (:notification-types m1928)]
    (.
     bean1927
     setNotificationTypes
     (clojure.core/map
      (clojure.core/fn [arg1930] (clojure.core/str arg1930))
      v1929)))
   bean1927))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribePoliciesRequest describe-policies-request
  [m1932]
  (clojure.core/let
   [bean1931
    (new
     com.amazonaws.services.autoscaling.model.DescribePoliciesRequest)]
   (clojure.core/when-let
    [v1933 (:next-token m1932)]
    (. bean1931 setNextToken (clojure.core/str v1933)))
   (clojure.core/when-let
    [v1933 (:auto-scaling-group-name m1932)]
    (. bean1931 setAutoScalingGroupName (clojure.core/str v1933)))
   (clojure.core/when-let
    [v1933 (:policy-names m1932)]
    (.
     bean1931
     setPolicyNames
     (clojure.core/map
      (clojure.core/fn [arg1934] (clojure.core/str arg1934))
      v1933)))
   (clojure.core/when-let
    [v1933 (:max-records m1932)]
    (. bean1931 setMaxRecords (clojure.core/int v1933)))
   bean1931))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.SuspendProcessesRequest suspend-processes-request
  [m1936]
  (clojure.core/let
   [bean1935
    (new
     com.amazonaws.services.autoscaling.model.SuspendProcessesRequest)]
   (clojure.core/when-let
    [v1937 (:auto-scaling-group-name m1936)]
    (. bean1935 setAutoScalingGroupName (clojure.core/str v1937)))
   (clojure.core/when-let
    [v1937 (:scaling-processes m1936)]
    (.
     bean1935
     setScalingProcesses
     (clojure.core/map
      (clojure.core/fn [arg1938] (clojure.core/str arg1938))
      v1937)))
   bean1935))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest create-auto-scaling-group-request
  [m1940]
  (clojure.core/let
   [bean1939
    (new
     com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v1941 (:desired-capacity m1940)]
    (. bean1939 setDesiredCapacity (clojure.core/int v1941)))
   (clojure.core/when-let
    [v1941 (:auto-scaling-group-name m1940)]
    (. bean1939 setAutoScalingGroupName (clojure.core/str v1941)))
   (clojure.core/when-let
    [v1941 (:launch-configuration-name m1940)]
    (. bean1939 setLaunchConfigurationName (clojure.core/str v1941)))
   (clojure.core/when-let
    [v1941 (:min-size m1940)]
    (. bean1939 setMinSize (clojure.core/int v1941)))
   (clojure.core/when-let
    [v1941 (:max-size m1940)]
    (. bean1939 setMaxSize (clojure.core/int v1941)))
   (clojure.core/when-let
    [v1941 (:default-cooldown m1940)]
    (. bean1939 setDefaultCooldown (clojure.core/int v1941)))
   (clojure.core/when-let
    [v1941 (:availability-zones m1940)]
    (.
     bean1939
     setAvailabilityZones
     (clojure.core/map
      (clojure.core/fn [arg1942] (clojure.core/str arg1942))
      v1941)))
   (clojure.core/when-let
    [v1941 (:load-balancer-names m1940)]
    (.
     bean1939
     setLoadBalancerNames
     (clojure.core/map
      (clojure.core/fn [arg1943] (clojure.core/str arg1943))
      v1941)))
   (clojure.core/when-let
    [v1941 (:health-check-type m1940)]
    (. bean1939 setHealthCheckType (clojure.core/str v1941)))
   (clojure.core/when-let
    [v1941 (:health-check-grace-period m1940)]
    (. bean1939 setHealthCheckGracePeriod (clojure.core/int v1941)))
   (clojure.core/when-let
    [v1941 (:placement-group m1940)]
    (. bean1939 setPlacementGroup (clojure.core/str v1941)))
   (clojure.core/when-let
    [v1941 (:vpczone-identifier m1940)]
    (. bean1939 setVPCZoneIdentifier (clojure.core/str v1941)))
   (clojure.core/when-let
    [v1941 (:termination-policies m1940)]
    (.
     bean1939
     setTerminationPolicies
     (clojure.core/map
      (clojure.core/fn [arg1944] (clojure.core/str arg1944))
      v1941)))
   (clojure.core/when-let
    [v1941 (:tags m1940)]
    (.
     bean1939
     setTags
     (clojure.core/map
      (clojure.core/fn [arg1945] (tag arg1945))
      v1941)))
   bean1939))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest describe-auto-scaling-groups-request
  [m1947]
  (clojure.core/let
   [bean1946
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest)]
   (clojure.core/when-let
    [v1948 (:next-token m1947)]
    (. bean1946 setNextToken (clojure.core/str v1948)))
   (clojure.core/when-let
    [v1948 (:auto-scaling-group-names m1947)]
    (.
     bean1946
     setAutoScalingGroupNames
     (clojure.core/map
      (clojure.core/fn [arg1949] (clojure.core/str arg1949))
      v1948)))
   (clojure.core/when-let
    [v1948 (:max-records m1947)]
    (. bean1946 setMaxRecords (clojure.core/int v1948)))
   bean1946))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest put-scaling-policy-request
  [m1951]
  (clojure.core/let
   [bean1950
    (new
     com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest)]
   (clojure.core/when-let
    [v1952 (:auto-scaling-group-name m1951)]
    (. bean1950 setAutoScalingGroupName (clojure.core/str v1952)))
   (clojure.core/when-let
    [v1952 (:policy-name m1951)]
    (. bean1950 setPolicyName (clojure.core/str v1952)))
   (clojure.core/when-let
    [v1952 (:scaling-adjustment m1951)]
    (. bean1950 setScalingAdjustment (clojure.core/int v1952)))
   (clojure.core/when-let
    [v1952 (:adjustment-type m1951)]
    (. bean1950 setAdjustmentType (clojure.core/str v1952)))
   (clojure.core/when-let
    [v1952 (:cooldown m1951)]
    (. bean1950 setCooldown (clojure.core/int v1952)))
   (clojure.core/when-let
    [v1952 (:min-adjustment-step m1951)]
    (. bean1950 setMinAdjustmentStep (clojure.core/int v1952)))
   bean1950))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.ExecutePolicyRequest execute-policy-request
  [m1954]
  (clojure.core/let
   [bean1953
    (new
     com.amazonaws.services.autoscaling.model.ExecutePolicyRequest)]
   (clojure.core/when-let
    [v1955 (:auto-scaling-group-name m1954)]
    (. bean1953 setAutoScalingGroupName (clojure.core/str v1955)))
   (clojure.core/when-let
    [v1955 (:policy-name m1954)]
    (. bean1953 setPolicyName (clojure.core/str v1955)))
   (clojure.core/when-let
    [v1955 (:honor-cooldown m1954)]
    (. bean1953 setHonorCooldown (clojure.core/boolean v1955)))
   bean1953))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest create-launch-configuration-request
  [m1957]
  (clojure.core/let
   [bean1956
    (new
     com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest)]
   (clojure.core/when-let
    [v1958 (:launch-configuration-name m1957)]
    (. bean1956 setLaunchConfigurationName (clojure.core/str v1958)))
   (clojure.core/when-let
    [v1958 (:image-id m1957)]
    (. bean1956 setImageId (clojure.core/str v1958)))
   (clojure.core/when-let
    [v1958 (:key-name m1957)]
    (. bean1956 setKeyName (clojure.core/str v1958)))
   (clojure.core/when-let
    [v1958 (:security-groups m1957)]
    (.
     bean1956
     setSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg1959] (clojure.core/str arg1959))
      v1958)))
   (clojure.core/when-let
    [v1958 (:user-data m1957)]
    (. bean1956 setUserData (clojure.core/str v1958)))
   (clojure.core/when-let
    [v1958 (:instance-type m1957)]
    (. bean1956 setInstanceType (clojure.core/str v1958)))
   (clojure.core/when-let
    [v1958 (:kernel-id m1957)]
    (. bean1956 setKernelId (clojure.core/str v1958)))
   (clojure.core/when-let
    [v1958 (:ramdisk-id m1957)]
    (. bean1956 setRamdiskId (clojure.core/str v1958)))
   (clojure.core/when-let
    [v1958 (:block-device-mappings m1957)]
    (.
     bean1956
     setBlockDeviceMappings
     (clojure.core/map
      (clojure.core/fn [arg1960] (block-device-mapping arg1960))
      v1958)))
   (clojure.core/when-let
    [v1958 (:instance-monitoring m1957)]
    (. bean1956 setInstanceMonitoring (instance-monitoring v1958)))
   (clojure.core/when-let
    [v1958 (:spot-price m1957)]
    (. bean1956 setSpotPrice (clojure.core/str v1958)))
   (clojure.core/when-let
    [v1958 (:iam-instance-profile m1957)]
    (. bean1956 setIamInstanceProfile (clojure.core/str v1958)))
   (clojure.core/when-let
    [v1958 (:ebs-optimized m1957)]
    (. bean1956 setEbsOptimized (clojure.core/boolean v1958)))
   (clojure.core/when-let
    [v1958 (:associate-public-ip-address m1957)]
    (.
     bean1956
     setAssociatePublicIpAddress
     (clojure.core/boolean v1958)))
   bean1956))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest describe-termination-policy-types-request
  [m1962]
  (clojure.core/let
   [bean1961
    (new
     com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest)]
   bean1961))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest describe-scaling-activities-request
  [m1965]
  (clojure.core/let
   [bean1964
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest)]
   (clojure.core/when-let
    [v1966 (:next-token m1965)]
    (. bean1964 setNextToken (clojure.core/str v1966)))
   (clojure.core/when-let
    [v1966 (:auto-scaling-group-name m1965)]
    (. bean1964 setAutoScalingGroupName (clojure.core/str v1966)))
   (clojure.core/when-let
    [v1966 (:activity-ids m1965)]
    (.
     bean1964
     setActivityIds
     (clojure.core/map
      (clojure.core/fn [arg1967] (clojure.core/str arg1967))
      v1966)))
   (clojure.core/when-let
    [v1966 (:max-records m1965)]
    (. bean1964 setMaxRecords (clojure.core/int v1966)))
   bean1964))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest describe-scheduled-actions-request
  [m1969]
  (clojure.core/let
   [bean1968
    (new
     com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest)]
   (clojure.core/when-let
    [v1970 (:next-token m1969)]
    (. bean1968 setNextToken (clojure.core/str v1970)))
   (clojure.core/when-let
    [v1970 (:auto-scaling-group-name m1969)]
    (. bean1968 setAutoScalingGroupName (clojure.core/str v1970)))
   (clojure.core/when-let
    [v1970 (:scheduled-action-names m1969)]
    (.
     bean1968
     setScheduledActionNames
     (clojure.core/map
      (clojure.core/fn [arg1971] (clojure.core/str arg1971))
      v1970)))
   (clojure.core/when-let
    [v1970 (:max-records m1969)]
    (. bean1968 setMaxRecords (clojure.core/int v1970)))
   (clojure.core/when-let
    [v1970 (:start-time m1969)]
    (.
     bean1968
     setStartTime
     (com.palletops.awaze.common/to-date v1970)))
   (clojure.core/when-let
    [v1970 (:end-time m1969)]
    (. bean1968 setEndTime (com.palletops.awaze.common/to-date v1970)))
   bean1968))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest describe-adjustment-types-request
  [m1973]
  (clojure.core/let
   [bean1972
    (new
     com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest)]
   bean1972))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeTagsRequest describe-tags-request
  [m1976]
  (clojure.core/let
   [bean1975
    (new com.amazonaws.services.autoscaling.model.DescribeTagsRequest)]
   (clojure.core/when-let
    [v1977 (:next-token m1976)]
    (. bean1975 setNextToken (clojure.core/str v1977)))
   (clojure.core/when-let
    [v1977 (:filters m1976)]
    (.
     bean1975
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg1978] (filter arg1978))
      v1977)))
   (clojure.core/when-let
    [v1977 (:max-records m1976)]
    (. bean1975 setMaxRecords (clojure.core/int v1977)))
   bean1975))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.ResumeProcessesRequest resume-processes-request
  [m1980]
  (clojure.core/let
   [bean1979
    (new
     com.amazonaws.services.autoscaling.model.ResumeProcessesRequest)]
   (clojure.core/when-let
    [v1981 (:auto-scaling-group-name m1980)]
    (. bean1979 setAutoScalingGroupName (clojure.core/str v1981)))
   (clojure.core/when-let
    [v1981 (:scaling-processes m1980)]
    (.
     bean1979
     setScalingProcesses
     (clojure.core/map
      (clojure.core/fn [arg1982] (clojure.core/str arg1982))
      v1981)))
   bean1979))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest delete-launch-configuration-request
  [m1984]
  (clojure.core/let
   [bean1983
    (new
     com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest)]
   (clojure.core/when-let
    [v1985 (:launch-configuration-name m1984)]
    (. bean1983 setLaunchConfigurationName (clojure.core/str v1985)))
   bean1983))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest disable-metrics-collection-request
  [m1987]
  (clojure.core/let
   [bean1986
    (new
     com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest)]
   (clojure.core/when-let
    [v1988 (:auto-scaling-group-name m1987)]
    (. bean1986 setAutoScalingGroupName (clojure.core/str v1988)))
   (clojure.core/when-let
    [v1988 (:metrics m1987)]
    (.
     bean1986
     setMetrics
     (clojure.core/map
      (clojure.core/fn [arg1989] (clojure.core/str arg1989))
      v1988)))
   bean1986))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest put-scheduled-update-group-action-request
  [m1991]
  (clojure.core/let
   [bean1990
    (new
     com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest)]
   (clojure.core/when-let
    [v1992 (:time m1991)]
    (. bean1990 setTime (com.palletops.awaze.common/to-date v1992)))
   (clojure.core/when-let
    [v1992 (:desired-capacity m1991)]
    (. bean1990 setDesiredCapacity (clojure.core/int v1992)))
   (clojure.core/when-let
    [v1992 (:auto-scaling-group-name m1991)]
    (. bean1990 setAutoScalingGroupName (clojure.core/str v1992)))
   (clojure.core/when-let
    [v1992 (:min-size m1991)]
    (. bean1990 setMinSize (clojure.core/int v1992)))
   (clojure.core/when-let
    [v1992 (:max-size m1991)]
    (. bean1990 setMaxSize (clojure.core/int v1992)))
   (clojure.core/when-let
    [v1992 (:scheduled-action-name m1991)]
    (. bean1990 setScheduledActionName (clojure.core/str v1992)))
   (clojure.core/when-let
    [v1992 (:recurrence m1991)]
    (. bean1990 setRecurrence (clojure.core/str v1992)))
   (clojure.core/when-let
    [v1992 (:start-time m1991)]
    (.
     bean1990
     setStartTime
     (com.palletops.awaze.common/to-date v1992)))
   (clojure.core/when-let
    [v1992 (:end-time m1991)]
    (. bean1990 setEndTime (com.palletops.awaze.common/to-date v1992)))
   bean1990))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest describe-scaling-process-types-request
  [m1994]
  (clojure.core/let
   [bean1993
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest)]
   bean1993))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest describe-metric-collection-types-request
  [m1997]
  (clojure.core/let
   [bean1996
    (new
     com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest)]
   bean1996))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest delete-scheduled-action-request
  [m2000]
  (clojure.core/let
   [bean1999
    (new
     com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest)]
   (clojure.core/when-let
    [v2001 (:auto-scaling-group-name m2000)]
    (. bean1999 setAutoScalingGroupName (clojure.core/str v2001)))
   (clojure.core/when-let
    [v2001 (:scheduled-action-name m2000)]
    (. bean1999 setScheduledActionName (clojure.core/str v2001)))
   bean1999))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest update-auto-scaling-group-request
  [m2003]
  (clojure.core/let
   [bean2002
    (new
     com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v2004 (:desired-capacity m2003)]
    (. bean2002 setDesiredCapacity (clojure.core/int v2004)))
   (clojure.core/when-let
    [v2004 (:auto-scaling-group-name m2003)]
    (. bean2002 setAutoScalingGroupName (clojure.core/str v2004)))
   (clojure.core/when-let
    [v2004 (:launch-configuration-name m2003)]
    (. bean2002 setLaunchConfigurationName (clojure.core/str v2004)))
   (clojure.core/when-let
    [v2004 (:min-size m2003)]
    (. bean2002 setMinSize (clojure.core/int v2004)))
   (clojure.core/when-let
    [v2004 (:max-size m2003)]
    (. bean2002 setMaxSize (clojure.core/int v2004)))
   (clojure.core/when-let
    [v2004 (:default-cooldown m2003)]
    (. bean2002 setDefaultCooldown (clojure.core/int v2004)))
   (clojure.core/when-let
    [v2004 (:availability-zones m2003)]
    (.
     bean2002
     setAvailabilityZones
     (clojure.core/map
      (clojure.core/fn [arg2005] (clojure.core/str arg2005))
      v2004)))
   (clojure.core/when-let
    [v2004 (:health-check-type m2003)]
    (. bean2002 setHealthCheckType (clojure.core/str v2004)))
   (clojure.core/when-let
    [v2004 (:health-check-grace-period m2003)]
    (. bean2002 setHealthCheckGracePeriod (clojure.core/int v2004)))
   (clojure.core/when-let
    [v2004 (:placement-group m2003)]
    (. bean2002 setPlacementGroup (clojure.core/str v2004)))
   (clojure.core/when-let
    [v2004 (:vpczone-identifier m2003)]
    (. bean2002 setVPCZoneIdentifier (clojure.core/str v2004)))
   (clojure.core/when-let
    [v2004 (:termination-policies m2003)]
    (.
     bean2002
     setTerminationPolicies
     (clojure.core/map
      (clojure.core/fn [arg2006] (clojure.core/str arg2006))
      v2004)))
   bean2002))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest delete-notification-configuration-request
  [m2008]
  (clojure.core/let
   [bean2007
    (new
     com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest)]
   (clojure.core/when-let
    [v2009 (:auto-scaling-group-name m2008)]
    (. bean2007 setAutoScalingGroupName (clojure.core/str v2009)))
   (clojure.core/when-let
    [v2009 (:topic-arn m2008)]
    (. bean2007 setTopicARN (clojure.core/str v2009)))
   bean2007))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest terminate-instance-in-auto-scaling-group-request
  [m2011]
  (clojure.core/let
   [bean2010
    (new
     com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v2012 (:instance-id m2011)]
    (. bean2010 setInstanceId (clojure.core/str v2012)))
   (clojure.core/when-let
    [v2012 (:should-decrement-desired-capacity m2011)]
    (.
     bean2010
     setShouldDecrementDesiredCapacity
     (clojure.core/boolean v2012)))
   bean2010))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest delete-auto-scaling-group-request
  [m2014]
  (clojure.core/let
   [bean2013
    (new
     com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v2015 (:auto-scaling-group-name m2014)]
    (. bean2013 setAutoScalingGroupName (clojure.core/str v2015)))
   (clojure.core/when-let
    [v2015 (:force-delete m2014)]
    (. bean2013 setForceDelete (clojure.core/boolean v2015)))
   bean2013))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest create-or-update-tags-request
  [m2017]
  (clojure.core/let
   [bean2016
    (new
     com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest)]
   (clojure.core/when-let
    [v2018 (:tags m2017)]
    (.
     bean2016
     setTags
     (clojure.core/map
      (clojure.core/fn [arg2019] (tag arg2019))
      v2018)))
   bean2016))
 (clojure.core/defmulti
  autoscaling
  (clojure.core/fn autoscaling [m__609__auto__] (:fn m__609__auto__)))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-desired-capacity
   [m2020]
   (clojure.core/let
    [credentials2021 (:credentials m2020) args2022 (:args m2020)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2023
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2021)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2023
       setDesiredCapacity
       (set-desired-capacity-request
        (clojure.core/nth args2022 0)))))))
  (clojure.core/defn
   set-desired-capacity-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         honor-cooldown
         desired-capacity
         auto-scaling-group-name]}]],
    :doc "Generate map for setDesiredCapacity"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :set-desired-capacity,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-desired-capacity
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         honor-cooldown
         desired-capacity
         auto-scaling-group-name]}]],
    :doc "Call setDesiredCapacity"}
   [credentials2025 & args2026]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2027
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2025)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2027
      setDesiredCapacity
      (set-desired-capacity-request (clojure.core/nth args2026 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :enable-metrics-collection
   [m2028]
   (clojure.core/let
    [credentials2029 (:credentials m2028) args2030 (:args m2028)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2031
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2029)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2031
       enableMetricsCollection
       (enable-metrics-collection-request
        (clojure.core/nth args2030 0)))))))
  (clojure.core/defn
   enable-metrics-collection-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         metrics
         granularity
         auto-scaling-group-name]}]],
    :doc "Generate map for enableMetricsCollection"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :enable-metrics-collection,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   enable-metrics-collection
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         metrics
         granularity
         auto-scaling-group-name]}]],
    :doc "Call enableMetricsCollection"}
   [credentials2033 & args2034]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2035
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2033)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2035
      enableMetricsCollection
      (enable-metrics-collection-request
       (clojure.core/nth args2034 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-policy
   [m2036]
   (clojure.core/let
    [credentials2037 (:credentials m2036) args2038 (:args m2036)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2039
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2037)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2039
       deletePolicy
       (delete-policy-request (clojure.core/nth args2038 0)))))))
  (clojure.core/defn
   delete-policy-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-name
         auto-scaling-group-name]}]],
    :doc "Generate map for deletePolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-policy
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-name
         auto-scaling-group-name]}]],
    :doc "Call deletePolicy"}
   [credentials2041 & args2042]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2043
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2041)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2043
      deletePolicy
      (delete-policy-request (clojure.core/nth args2042 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-instance-health
   [m2044]
   (clojure.core/let
    [credentials2045 (:credentials m2044) args2046 (:args m2044)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2047
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2045)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2047
       setInstanceHealth
       (set-instance-health-request (clojure.core/nth args2046 0)))))))
  (clojure.core/defn
   set-instance-health-map
   {:arglists
    '[[credentials
       {:keys
        [should-respect-grace-period
         request-metric-collector
         instance-id
         health-status]}]],
    :doc "Generate map for setInstanceHealth"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :set-instance-health,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   set-instance-health
   {:arglists
    '[[credentials
       {:keys
        [should-respect-grace-period
         request-metric-collector
         instance-id
         health-status]}]],
    :doc "Call setInstanceHealth"}
   [credentials2049 & args2050]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2051
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2049)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2051
      setInstanceHealth
      (set-instance-health-request (clojure.core/nth args2050 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-launch-configurations
   [m2052]
   (clojure.core/let
    [credentials2053 (:credentials m2052) args2054 (:args m2052)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2055
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2053)]
     (clojure.core/case
      (clojure.core/count args2054)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2055
        describeLaunchConfigurations
        (describe-launch-configurations-request
         (clojure.core/nth args2054 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2055
        describeLaunchConfigurations))))))
  (clojure.core/defn
   describe-launch-configurations-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         next-token
         max-records
         launch-configuration-names]}]
      [credentials]],
    :doc
    "Generate map for describeLaunchConfigurations, describeLaunchConfigurations"}
   ([credentials__577__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-launch-configurations,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-launch-configurations,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-launch-configurations
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         next-token
         max-records
         launch-configuration-names]}]
      [credentials]],
    :doc
    "Call describeLaunchConfigurations, describeLaunchConfigurations"}
   [credentials2057 & args2058]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2059
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2057)]
    (clojure.core/case
     (clojure.core/count args2058)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2059
       describeLaunchConfigurations
       (describe-launch-configurations-request
        (clojure.core/nth args2058 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2059
       describeLaunchConfigurations))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-tags
   [m2060]
   (clojure.core/let
    [credentials2061 (:credentials m2060) args2062 (:args m2060)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2063
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2061)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2063
       deleteTags
       (delete-tags-request (clojure.core/nth args2062 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists '[[credentials {:keys [tags request-metric-collector]}]],
    :doc "Generate map for deleteTags"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-tags,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-tags
   {:arglists '[[credentials {:keys [tags request-metric-collector]}]],
    :doc "Call deleteTags"}
   [credentials2065 & args2066]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2067
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2065)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2067
      deleteTags
      (delete-tags-request (clojure.core/nth args2066 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-instances
   [m2068]
   (clojure.core/let
    [credentials2069 (:credentials m2068) args2070 (:args m2068)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2071
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2069)]
     (clojure.core/case
      (clojure.core/count args2070)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2071
        describeAutoScalingInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2071
        describeAutoScalingInstances
        (describe-auto-scaling-instances-request
         (clojure.core/nth args2070 0))))))))
  (clojure.core/defn
   describe-auto-scaling-instances-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         next-token
         max-records
         instance-ids]}]],
    :doc
    "Generate map for describeAutoScalingInstances, describeAutoScalingInstances"}
   ([credentials__577__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-auto-scaling-instances,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-auto-scaling-instances,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-auto-scaling-instances
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         next-token
         max-records
         instance-ids]}]],
    :doc
    "Call describeAutoScalingInstances, describeAutoScalingInstances"}
   [credentials2073 & args2074]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2075
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2073)]
    (clojure.core/case
     (clojure.core/count args2074)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2075
       describeAutoScalingInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2075
       describeAutoScalingInstances
       (describe-auto-scaling-instances-request
        (clojure.core/nth args2074 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-notification-configurations
   [m2076]
   (clojure.core/let
    [credentials2077 (:credentials m2076) args2078 (:args m2076)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2079
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2077)]
     (clojure.core/case
      (clojure.core/count args2078)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2079
        describeNotificationConfigurations
        (describe-notification-configurations-request
         (clojure.core/nth args2078 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2079
        describeNotificationConfigurations))))))
  (clojure.core/defn
   describe-notification-configurations-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         next-token
         max-records
         auto-scaling-group-names]}]
      [credentials]],
    :doc
    "Generate map for describeNotificationConfigurations, describeNotificationConfigurations"}
   ([credentials__577__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-notification-configurations,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-notification-configurations,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-notification-configurations
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         next-token
         max-records
         auto-scaling-group-names]}]
      [credentials]],
    :doc
    "Call describeNotificationConfigurations, describeNotificationConfigurations"}
   [credentials2081 & args2082]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2083
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2081)]
    (clojure.core/case
     (clojure.core/count args2082)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2083
       describeNotificationConfigurations
       (describe-notification-configurations-request
        (clojure.core/nth args2082 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2083
       describeNotificationConfigurations))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-notification-types
   [m2084]
   (clojure.core/let
    [credentials2085 (:credentials m2084) args2086 (:args m2084)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2087
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2085)]
     (clojure.core/case
      (clojure.core/count args2086)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2087
        describeAutoScalingNotificationTypes
        (describe-auto-scaling-notification-types-request
         (clojure.core/nth args2086 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2087
        describeAutoScalingNotificationTypes))))))
  (clojure.core/defn
   describe-auto-scaling-notification-types-map
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc
    "Generate map for describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   ([credentials__577__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-auto-scaling-notification-types
   {:arglists
    '[[credentials {:keys [request-metric-collector]}] [credentials]],
    :doc
    "Call describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   [credentials2089 & args2090]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2091
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2089)]
    (clojure.core/case
     (clojure.core/count args2090)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2091
       describeAutoScalingNotificationTypes
       (describe-auto-scaling-notification-types-request
        (clojure.core/nth args2090 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2091
       describeAutoScalingNotificationTypes))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-notification-configuration
   [m2092]
   (clojure.core/let
    [credentials2093 (:credentials m2092) args2094 (:args m2092)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2095
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2093)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2095
       putNotificationConfiguration
       (put-notification-configuration-request
        (clojure.core/nth args2094 0)))))))
  (clojure.core/defn
   put-notification-configuration-map
   {:arglists
    '[[credentials
       {:keys
        [topic-arn
         request-metric-collector
         notification-types
         auto-scaling-group-name]}]],
    :doc "Generate map for putNotificationConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :put-notification-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   put-notification-configuration
   {:arglists
    '[[credentials
       {:keys
        [topic-arn
         request-metric-collector
         notification-types
         auto-scaling-group-name]}]],
    :doc "Call putNotificationConfiguration"}
   [credentials2097 & args2098]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2099
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2097)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2099
      putNotificationConfiguration
      (put-notification-configuration-request
       (clojure.core/nth args2098 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-policies
   [m2100]
   (clojure.core/let
    [credentials2101 (:credentials m2100) args2102 (:args m2100)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2103
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2101)]
     (clojure.core/case
      (clojure.core/count args2102)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2103
        describePolicies))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2103
        describePolicies
        (describe-policies-request (clojure.core/nth args2102 0))))))))
  (clojure.core/defn
   describe-policies-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         policy-names
         next-token
         max-records
         auto-scaling-group-name]}]],
    :doc "Generate map for describePolicies, describePolicies"}
   ([credentials__577__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-policies,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-policies,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-policies
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         policy-names
         next-token
         max-records
         auto-scaling-group-name]}]],
    :doc "Call describePolicies, describePolicies"}
   [credentials2105 & args2106]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2107
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2105)]
    (clojure.core/case
     (clojure.core/count args2106)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2107
       describePolicies))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2107
       describePolicies
       (describe-policies-request (clojure.core/nth args2106 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :suspend-processes
   [m2108]
   (clojure.core/let
    [credentials2109 (:credentials m2108) args2110 (:args m2108)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2111
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2109)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2111
       suspendProcesses
       (suspend-processes-request (clojure.core/nth args2110 0)))))))
  (clojure.core/defn
   suspend-processes-map
   {:arglists
    '[[credentials
       {:keys
        [scaling-processes
         request-metric-collector
         auto-scaling-group-name]}]],
    :doc "Generate map for suspendProcesses"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :suspend-processes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   suspend-processes
   {:arglists
    '[[credentials
       {:keys
        [scaling-processes
         request-metric-collector
         auto-scaling-group-name]}]],
    :doc "Call suspendProcesses"}
   [credentials2113 & args2114]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2115
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2113)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2115
      suspendProcesses
      (suspend-processes-request (clojure.core/nth args2114 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-auto-scaling-group
   [m2116]
   (clojure.core/let
    [credentials2117 (:credentials m2116) args2118 (:args m2116)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2119
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2117)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2119
       createAutoScalingGroup
       (create-auto-scaling-group-request
        (clojure.core/nth args2118 0)))))))
  (clojure.core/defn
   create-auto-scaling-group-map
   {:arglists
    '[[credentials
       {:keys
        [load-balancer-names
         health-check-grace-period
         placement-group
         request-metric-collector
         launch-configuration-name
         termination-policies
         vpczone-identifier
         desired-capacity
         availability-zones
         min-size
         default-cooldown
         max-size
         health-check-type
         auto-scaling-group-name
         tags]}]],
    :doc "Generate map for createAutoScalingGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :create-auto-scaling-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-auto-scaling-group
   {:arglists
    '[[credentials
       {:keys
        [load-balancer-names
         health-check-grace-period
         placement-group
         request-metric-collector
         launch-configuration-name
         termination-policies
         vpczone-identifier
         desired-capacity
         availability-zones
         min-size
         default-cooldown
         max-size
         health-check-type
         auto-scaling-group-name
         tags]}]],
    :doc "Call createAutoScalingGroup"}
   [credentials2121 & args2122]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2123
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2121)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2123
      createAutoScalingGroup
      (create-auto-scaling-group-request
       (clojure.core/nth args2122 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-groups
   [m2124]
   (clojure.core/let
    [credentials2125 (:credentials m2124) args2126 (:args m2124)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2127
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2125)]
     (clojure.core/case
      (clojure.core/count args2126)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2127
        describeAutoScalingGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2127
        describeAutoScalingGroups
        (describe-auto-scaling-groups-request
         (clojure.core/nth args2126 0))))))))
  (clojure.core/defn
   describe-auto-scaling-groups-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         next-token
         max-records
         auto-scaling-group-names]}]],
    :doc
    "Generate map for describeAutoScalingGroups, describeAutoScalingGroups"}
   ([credentials__577__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-auto-scaling-groups,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-auto-scaling-groups,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-auto-scaling-groups
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         next-token
         max-records
         auto-scaling-group-names]}]],
    :doc "Call describeAutoScalingGroups, describeAutoScalingGroups"}
   [credentials2129 & args2130]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2131
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2129)]
    (clojure.core/case
     (clojure.core/count args2130)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2131
       describeAutoScalingGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2131
       describeAutoScalingGroups
       (describe-auto-scaling-groups-request
        (clojure.core/nth args2130 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scaling-policy
   [m2132]
   (clojure.core/let
    [credentials2133 (:credentials m2132) args2134 (:args m2132)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2135
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2133)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2135
       putScalingPolicy
       (put-scaling-policy-request (clojure.core/nth args2134 0)))))))
  (clojure.core/defn
   put-scaling-policy-map
   {:arglists
    '[[credentials
       {:keys
        [min-adjustment-step
         scaling-adjustment
         cooldown
         auto-scaling-group-name
         policy-name
         adjustment-type
         request-metric-collector]}]],
    :doc "Generate map for putScalingPolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :put-scaling-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   put-scaling-policy
   {:arglists
    '[[credentials
       {:keys
        [min-adjustment-step
         scaling-adjustment
         cooldown
         auto-scaling-group-name
         policy-name
         adjustment-type
         request-metric-collector]}]],
    :doc "Call putScalingPolicy"}
   [credentials2137 & args2138]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2139
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2137)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2139
      putScalingPolicy
      (put-scaling-policy-request (clojure.core/nth args2138 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :execute-policy
   [m2140]
   (clojure.core/let
    [credentials2141 (:credentials m2140) args2142 (:args m2140)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2143
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2141)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2143
       executePolicy
       (execute-policy-request (clojure.core/nth args2142 0)))))))
  (clojure.core/defn
   execute-policy-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-name
         honor-cooldown
         auto-scaling-group-name]}]],
    :doc "Generate map for executePolicy"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :execute-policy,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   execute-policy
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         policy-name
         honor-cooldown
         auto-scaling-group-name]}]],
    :doc "Call executePolicy"}
   [credentials2145 & args2146]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2147
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2145)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2147
      executePolicy
      (execute-policy-request (clojure.core/nth args2146 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-launch-configuration
   [m2148]
   (clojure.core/let
    [credentials2149 (:credentials m2148) args2150 (:args m2148)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2151
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2149)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2151
       createLaunchConfiguration
       (create-launch-configuration-request
        (clojure.core/nth args2150 0)))))))
  (clojure.core/defn
   create-launch-configuration-map
   {:arglists
    '[[credentials
       {:keys
        [instance-type
         kernel-id
         associate-public-ip-address
         request-metric-collector
         launch-configuration-name
         ebs-optimized
         block-device-mappings
         spot-price
         user-data
         security-groups
         ramdisk-id
         instance-monitoring
         iam-instance-profile
         key-name
         image-id]}]],
    :doc "Generate map for createLaunchConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :create-launch-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-launch-configuration
   {:arglists
    '[[credentials
       {:keys
        [instance-type
         kernel-id
         associate-public-ip-address
         request-metric-collector
         launch-configuration-name
         ebs-optimized
         block-device-mappings
         spot-price
         user-data
         security-groups
         ramdisk-id
         instance-monitoring
         iam-instance-profile
         key-name
         image-id]}]],
    :doc "Call createLaunchConfiguration"}
   [credentials2153 & args2154]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2155
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2153)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2155
      createLaunchConfiguration
      (create-launch-configuration-request
       (clojure.core/nth args2154 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-termination-policy-types
   [m2156]
   (clojure.core/let
    [credentials2157 (:credentials m2156) args2158 (:args m2156)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2159
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2157)]
     (clojure.core/case
      (clojure.core/count args2158)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2159
        describeTerminationPolicyTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2159
        describeTerminationPolicyTypes
        (describe-termination-policy-types-request
         (clojure.core/nth args2158 0))))))))
  (clojure.core/defn
   describe-termination-policy-types-map
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc
    "Generate map for describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   ([credentials__577__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-termination-policy-types,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-termination-policy-types,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-termination-policy-types
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc
    "Call describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   [credentials2161 & args2162]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2163
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2161)]
    (clojure.core/case
     (clojure.core/count args2162)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2163
       describeTerminationPolicyTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2163
       describeTerminationPolicyTypes
       (describe-termination-policy-types-request
        (clojure.core/nth args2162 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-activities
   [m2164]
   (clojure.core/let
    [credentials2165 (:credentials m2164) args2166 (:args m2164)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2167
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2165)]
     (clojure.core/case
      (clojure.core/count args2166)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2167
        describeScalingActivities))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2167
        describeScalingActivities
        (describe-scaling-activities-request
         (clojure.core/nth args2166 0))))))))
  (clojure.core/defn
   describe-scaling-activities-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         next-token
         max-records
         auto-scaling-group-name
         activity-ids]}]],
    :doc
    "Generate map for describeScalingActivities, describeScalingActivities"}
   ([credentials__577__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-scaling-activities,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-scaling-activities,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-scaling-activities
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector
         next-token
         max-records
         auto-scaling-group-name
         activity-ids]}]],
    :doc "Call describeScalingActivities, describeScalingActivities"}
   [credentials2169 & args2170]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2171
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2169)]
    (clojure.core/case
     (clojure.core/count args2170)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2171
       describeScalingActivities))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2171
       describeScalingActivities
       (describe-scaling-activities-request
        (clojure.core/nth args2170 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scheduled-actions
   [m2172]
   (clojure.core/let
    [credentials2173 (:credentials m2172) args2174 (:args m2172)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2175
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2173)]
     (clojure.core/case
      (clojure.core/count args2174)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2175
        describeScheduledActions
        (describe-scheduled-actions-request
         (clojure.core/nth args2174 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2175
        describeScheduledActions))))))
  (clojure.core/defn
   describe-scheduled-actions-map
   {:arglists
    '[[credentials
       {:keys
        [start-time
         end-time
         auto-scaling-group-name
         max-records
         scheduled-action-names
         next-token
         request-metric-collector]}]
      [credentials]],
    :doc
    "Generate map for describeScheduledActions, describeScheduledActions"}
   ([credentials__577__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-scheduled-actions,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-scheduled-actions,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-scheduled-actions
   {:arglists
    '[[credentials
       {:keys
        [start-time
         end-time
         auto-scaling-group-name
         max-records
         scheduled-action-names
         next-token
         request-metric-collector]}]
      [credentials]],
    :doc "Call describeScheduledActions, describeScheduledActions"}
   [credentials2177 & args2178]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2179
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2177)]
    (clojure.core/case
     (clojure.core/count args2178)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2179
       describeScheduledActions
       (describe-scheduled-actions-request
        (clojure.core/nth args2178 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2179
       describeScheduledActions))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-adjustment-types
   [m2180]
   (clojure.core/let
    [credentials2181 (:credentials m2180) args2182 (:args m2180)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2183
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2181)]
     (clojure.core/case
      (clojure.core/count args2182)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2183
        describeAdjustmentTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2183
        describeAdjustmentTypes
        (describe-adjustment-types-request
         (clojure.core/nth args2182 0))))))))
  (clojure.core/defn
   describe-adjustment-types-map
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc
    "Generate map for describeAdjustmentTypes, describeAdjustmentTypes"}
   ([credentials__577__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-adjustment-types,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-adjustment-types,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-adjustment-types
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc "Call describeAdjustmentTypes, describeAdjustmentTypes"}
   [credentials2185 & args2186]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2187
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2185)]
    (clojure.core/case
     (clojure.core/count args2186)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2187
       describeAdjustmentTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2187
       describeAdjustmentTypes
       (describe-adjustment-types-request
        (clojure.core/nth args2186 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-tags
   [m2188]
   (clojure.core/let
    [credentials2189 (:credentials m2188) args2190 (:args m2188)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2191
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2189)]
     (clojure.core/case
      (clojure.core/count args2190)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2191
        describeTags))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2191
        describeTags
        (describe-tags-request (clojure.core/nth args2190 0))))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector next-token max-records filters]}]],
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__577__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-tags,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-tags,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-tags
   {:arglists
    '[[credentials]
      [credentials
       {:keys
        [request-metric-collector next-token max-records filters]}]],
    :doc "Call describeTags, describeTags"}
   [credentials2193 & args2194]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2195
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2193)]
    (clojure.core/case
     (clojure.core/count args2194)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2195
       describeTags))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2195
       describeTags
       (describe-tags-request (clojure.core/nth args2194 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :resume-processes
   [m2196]
   (clojure.core/let
    [credentials2197 (:credentials m2196) args2198 (:args m2196)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2199
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2197)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2199
       resumeProcesses
       (resume-processes-request (clojure.core/nth args2198 0)))))))
  (clojure.core/defn
   resume-processes-map
   {:arglists
    '[[credentials
       {:keys
        [scaling-processes
         request-metric-collector
         auto-scaling-group-name]}]],
    :doc "Generate map for resumeProcesses"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :resume-processes,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   resume-processes
   {:arglists
    '[[credentials
       {:keys
        [scaling-processes
         request-metric-collector
         auto-scaling-group-name]}]],
    :doc "Call resumeProcesses"}
   [credentials2201 & args2202]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2203
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2201)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2203
      resumeProcesses
      (resume-processes-request (clojure.core/nth args2202 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-launch-configuration
   [m2204]
   (clojure.core/let
    [credentials2205 (:credentials m2204) args2206 (:args m2204)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2207
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2205)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2207
       deleteLaunchConfiguration
       (delete-launch-configuration-request
        (clojure.core/nth args2206 0)))))))
  (clojure.core/defn
   delete-launch-configuration-map
   {:arglists
    '[[credentials
       {:keys [request-metric-collector launch-configuration-name]}]],
    :doc "Generate map for deleteLaunchConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-launch-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-launch-configuration
   {:arglists
    '[[credentials
       {:keys [request-metric-collector launch-configuration-name]}]],
    :doc "Call deleteLaunchConfiguration"}
   [credentials2209 & args2210]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2211
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2209)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2211
      deleteLaunchConfiguration
      (delete-launch-configuration-request
       (clojure.core/nth args2210 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :disable-metrics-collection
   [m2212]
   (clojure.core/let
    [credentials2213 (:credentials m2212) args2214 (:args m2212)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2215
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2213)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2215
       disableMetricsCollection
       (disable-metrics-collection-request
        (clojure.core/nth args2214 0)))))))
  (clojure.core/defn
   disable-metrics-collection-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector metrics auto-scaling-group-name]}]],
    :doc "Generate map for disableMetricsCollection"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :disable-metrics-collection,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   disable-metrics-collection
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector metrics auto-scaling-group-name]}]],
    :doc "Call disableMetricsCollection"}
   [credentials2217 & args2218]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2219
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2217)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2219
      disableMetricsCollection
      (disable-metrics-collection-request
       (clojure.core/nth args2218 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scheduled-update-group-action
   [m2220]
   (clojure.core/let
    [credentials2221 (:credentials m2220) args2222 (:args m2220)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2223
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2221)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2223
       putScheduledUpdateGroupAction
       (put-scheduled-update-group-action-request
        (clojure.core/nth args2222 0)))))))
  (clojure.core/defn
   put-scheduled-update-group-action-map
   {:arglists
    '[[credentials
       {:keys
        [end-time
         request-metric-collector
         desired-capacity
         recurrence
         start-time
         min-size
         time
         max-size
         scheduled-action-name
         auto-scaling-group-name]}]],
    :doc "Generate map for putScheduledUpdateGroupAction"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :put-scheduled-update-group-action,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   put-scheduled-update-group-action
   {:arglists
    '[[credentials
       {:keys
        [end-time
         request-metric-collector
         desired-capacity
         recurrence
         start-time
         min-size
         time
         max-size
         scheduled-action-name
         auto-scaling-group-name]}]],
    :doc "Call putScheduledUpdateGroupAction"}
   [credentials2225 & args2226]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2227
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2225)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2227
      putScheduledUpdateGroupAction
      (put-scheduled-update-group-action-request
       (clojure.core/nth args2226 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-process-types
   [m2228]
   (clojure.core/let
    [credentials2229 (:credentials m2228) args2230 (:args m2228)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2231
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2229)]
     (clojure.core/case
      (clojure.core/count args2230)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2231
        describeScalingProcessTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2231
        describeScalingProcessTypes
        (describe-scaling-process-types-request
         (clojure.core/nth args2230 0))))))))
  (clojure.core/defn
   describe-scaling-process-types-map
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc
    "Generate map for describeScalingProcessTypes, describeScalingProcessTypes"}
   ([credentials__577__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-scaling-process-types,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-scaling-process-types,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-scaling-process-types
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc
    "Call describeScalingProcessTypes, describeScalingProcessTypes"}
   [credentials2233 & args2234]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2235
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2233)]
    (clojure.core/case
     (clojure.core/count args2234)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2235
       describeScalingProcessTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2235
       describeScalingProcessTypes
       (describe-scaling-process-types-request
        (clojure.core/nth args2234 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-metric-collection-types
   [m2236]
   (clojure.core/let
    [credentials2237 (:credentials m2236) args2238 (:args m2236)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2239
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2237)]
     (clojure.core/case
      (clojure.core/count args2238)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2239
        describeMetricCollectionTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2239
        describeMetricCollectionTypes
        (describe-metric-collection-types-request
         (clojure.core/nth args2238 0))))))))
  (clojure.core/defn
   describe-metric-collection-types-map
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc
    "Generate map for describeMetricCollectionTypes, describeMetricCollectionTypes"}
   ([credentials__577__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-metric-collection-types,
     :credentials credentials__577__auto__})
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-metric-collection-types,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   describe-metric-collection-types
   {:arglists
    '[[credentials] [credentials {:keys [request-metric-collector]}]],
    :doc
    "Call describeMetricCollectionTypes, describeMetricCollectionTypes"}
   [credentials2241 & args2242]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2243
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2241)]
    (clojure.core/case
     (clojure.core/count args2242)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2243
       describeMetricCollectionTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2243
       describeMetricCollectionTypes
       (describe-metric-collection-types-request
        (clojure.core/nth args2242 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-scheduled-action
   [m2244]
   (clojure.core/let
    [credentials2245 (:credentials m2244) args2246 (:args m2244)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2247
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2245)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2247
       deleteScheduledAction
       (delete-scheduled-action-request
        (clojure.core/nth args2246 0)))))))
  (clojure.core/defn
   delete-scheduled-action-map
   {:arglists
    '[[credentials
       {:keys
        [scheduled-action-name
         request-metric-collector
         auto-scaling-group-name]}]],
    :doc "Generate map for deleteScheduledAction"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-scheduled-action,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-scheduled-action
   {:arglists
    '[[credentials
       {:keys
        [scheduled-action-name
         request-metric-collector
         auto-scaling-group-name]}]],
    :doc "Call deleteScheduledAction"}
   [credentials2249 & args2250]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2251
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2249)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2251
      deleteScheduledAction
      (delete-scheduled-action-request
       (clojure.core/nth args2250 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :update-auto-scaling-group
   [m2252]
   (clojure.core/let
    [credentials2253 (:credentials m2252) args2254 (:args m2252)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2255
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2253)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2255
       updateAutoScalingGroup
       (update-auto-scaling-group-request
        (clojure.core/nth args2254 0)))))))
  (clojure.core/defn
   update-auto-scaling-group-map
   {:arglists
    '[[credentials
       {:keys
        [health-check-grace-period
         placement-group
         request-metric-collector
         launch-configuration-name
         termination-policies
         vpczone-identifier
         desired-capacity
         availability-zones
         min-size
         default-cooldown
         max-size
         health-check-type
         auto-scaling-group-name]}]],
    :doc "Generate map for updateAutoScalingGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :update-auto-scaling-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   update-auto-scaling-group
   {:arglists
    '[[credentials
       {:keys
        [health-check-grace-period
         placement-group
         request-metric-collector
         launch-configuration-name
         termination-policies
         vpczone-identifier
         desired-capacity
         availability-zones
         min-size
         default-cooldown
         max-size
         health-check-type
         auto-scaling-group-name]}]],
    :doc "Call updateAutoScalingGroup"}
   [credentials2257 & args2258]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2259
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2257)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2259
      updateAutoScalingGroup
      (update-auto-scaling-group-request
       (clojure.core/nth args2258 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-notification-configuration
   [m2260]
   (clojure.core/let
    [credentials2261 (:credentials m2260) args2262 (:args m2260)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2263
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2261)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2263
       deleteNotificationConfiguration
       (delete-notification-configuration-request
        (clojure.core/nth args2262 0)))))))
  (clojure.core/defn
   delete-notification-configuration-map
   {:arglists
    '[[credentials
       {:keys
        [topic-arn
         request-metric-collector
         auto-scaling-group-name]}]],
    :doc "Generate map for deleteNotificationConfiguration"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-notification-configuration,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-notification-configuration
   {:arglists
    '[[credentials
       {:keys
        [topic-arn
         request-metric-collector
         auto-scaling-group-name]}]],
    :doc "Call deleteNotificationConfiguration"}
   [credentials2265 & args2266]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2267
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2265)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2267
      deleteNotificationConfiguration
      (delete-notification-configuration-request
       (clojure.core/nth args2266 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :terminate-instance-in-auto-scaling-group
   [m2268]
   (clojure.core/let
    [credentials2269 (:credentials m2268) args2270 (:args m2268)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2271
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2269)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2271
       terminateInstanceInAutoScalingGroup
       (terminate-instance-in-auto-scaling-group-request
        (clojure.core/nth args2270 0)))))))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group-map
   {:arglists
    '[[credentials
       {:keys
        [should-decrement-desired-capacity
         request-metric-collector
         instance-id]}]],
    :doc "Generate map for terminateInstanceInAutoScalingGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :terminate-instance-in-auto-scaling-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group
   {:arglists
    '[[credentials
       {:keys
        [should-decrement-desired-capacity
         request-metric-collector
         instance-id]}]],
    :doc "Call terminateInstanceInAutoScalingGroup"}
   [credentials2273 & args2274]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2275
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2273)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2275
      terminateInstanceInAutoScalingGroup
      (terminate-instance-in-auto-scaling-group-request
       (clojure.core/nth args2274 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-auto-scaling-group
   [m2276]
   (clojure.core/let
    [credentials2277 (:credentials m2276) args2278 (:args m2276)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2279
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2277)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2279
       deleteAutoScalingGroup
       (delete-auto-scaling-group-request
        (clojure.core/nth args2278 0)))))))
  (clojure.core/defn
   delete-auto-scaling-group-map
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         force-delete
         auto-scaling-group-name]}]],
    :doc "Generate map for deleteAutoScalingGroup"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-auto-scaling-group,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   delete-auto-scaling-group
   {:arglists
    '[[credentials
       {:keys
        [request-metric-collector
         force-delete
         auto-scaling-group-name]}]],
    :doc "Call deleteAutoScalingGroup"}
   [credentials2281 & args2282]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2283
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2281)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2283
      deleteAutoScalingGroup
      (delete-auto-scaling-group-request
       (clojure.core/nth args2282 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-or-update-tags
   [m2284]
   (clojure.core/let
    [credentials2285 (:credentials m2284) args2286 (:args m2284)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2287
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials2285)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2287
       createOrUpdateTags
       (create-or-update-tags-request
        (clojure.core/nth args2286 0)))))))
  (clojure.core/defn
   create-or-update-tags-map
   {:arglists '[[credentials {:keys [tags request-metric-collector]}]],
    :doc "Generate map for createOrUpdateTags"}
   ([credentials__577__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :create-or-update-tags,
     :credentials credentials__577__auto__}))
  (clojure.core/defn
   create-or-update-tags
   {:arglists '[[credentials {:keys [tags request-metric-collector]}]],
    :doc "Call createOrUpdateTags"}
   [credentials2289 & args2290]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2291
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials2289)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client2291
      createOrUpdateTags
      (create-or-update-tags-request
       (clojure.core/nth args2290 0))))))))
